<!doctype html>
<html class="no-js">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fixOrDefault(\Edwin404\Config\Facades\ConfigFacade::get('siteFavIco'),'default_favicon.ico')}}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="keywords" content="@yield('pageKeywords',\Edwin404\Config\Facades\ConfigFacade::get('siteKeywords'))">
    <meta name="description" content="@yield('pageDescription',\Edwin404\Config\Facades\ConfigFacade::get('siteDescription'))">
    <meta name="viewport" content="width=320, minimum-scale=0.5, maximum-scale=5, user-scalable=no">
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="no-siteapp"/>
    <script src="@assets('assets/init.js')"></script>
    <title>@section('pageTitle'){{\Edwin404\Config\Facades\ConfigFacade::get('siteName')}}@show</title>
    @section('headScript')
        <link rel="stylesheet" href="@assets('assets/uikit/css/ui.css')"/>
        <link rel="stylesheet" href="@assets('theme/default/m/css/style.css')"/>
    @show
    @section('headAppend')@show
    {!! \Edwin404\Config\Facades\ConfigFacade::get('systemCounter') !!}
</head>
<body>
@section('body')

    @if(!\Edwin404\Common\Helpers\AgentHelper::isWechat())
    <header>
        <div class="uk-grid">
            <div class="uk-width-1-5">
                <div class="left">
                    <a href="javascript:window.history.go(-1);;">
                        <i class="uk-icon-angle-left"></i>
                    </a>
                </div>
            </div>
            <div class="uk-width-3-5">
                <span class="title uk-text-truncate">
                    @yield('pageTitleMain',\Edwin404\Config\Facades\ConfigFacade::get('siteName'))
                </span>
            </div>
            <div class="uk-width-1-5">
                <div class="right">
                    @section('headerNavRight')
                    @show
                </div>
            </div>
        </div>
    </header>
    <div style="height:40px;"></div>
    @endif

    <footer>
        <div class="uk-grid">
            <div class="uk-width-1-3">
                <a href="/" @if($request_path=='/') class="cur" @endif >
                    <span class="icon uk-icon-home"></span>
                    <span>首页</span>
                </a>
            </div>
            <div class="uk-width-1-3">
                <a href="/category" @if(\Illuminate\Support\Str::startsWith($request_path,'/category') || \Illuminate\Support\Str::startsWith($request_path,'/event'))) class="cur" @endif>
                    <span class="icon uk-icon-th-large small"></span>
                    <span>课程</span>
                </a>
            </div>
            <div class="uk-width-1-3">
                <a href="/member" @if(\Illuminate\Support\Str::startsWith($request_path,'/member')) class="cur" @endif>
                    <span class="icon uk-icon-user"></span>
                    <span>我的</span>
                </a>
            </div>
        </div>
    </footer>

    @section('bodyContent')@show

    <div style="height:40px;"></div>

@show
@section('bodyScript')
    <script src="@assets('assets/m/js/basic.js')"></script>
@show
@section('bodyAppend')@show
</body>
</html>