@extends('theme.default.m.frame')

@section('pageTitle',\Edwin404\Config\Facades\ConfigFacade::get('siteName'))

@section('bodyScript')
    @parent
    <script>
        var swiper = new Swiper('.page-block-banner .swiper-container', {
            pagination: '.swiper-pagination',
            paginationClickable: '.swiper-pagination',
            nextButton: '.swiper-button-next',
            prevButton: '.swiper-button-prev',
            loop: true,
            autoplay: 2500,
            autoplayDisableOnInteraction: false
        });
    </script>
@endsection

@section('bodyContent')

    <div class="page-block page-block-banner">
        <div class="swiper-container">
            <div class="swiper-wrapper">
                @if(empty($banners))
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x360');"></a>
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x360');"></a>
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x360');"></a>
                @else
                    @foreach($banners as $banner)
                        <a class="swiper-slide"
                           style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($banner['image'])}});"
                           @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                    @endforeach
                @endif
            </div>
            <div class="swiper-pagination swiper-pagination-white"></div>
        </div>
    </div>

    @foreach($eventCategories as $eventCategory)
        <div class="home-event-category">
            <h2>{{$eventCategory['title']}}</h2>
            <div class="desc">
                {{$eventCategory['summary']}}
            </div>
            <div class="list">
                <div class="uk-grid">
                    @foreach($eventCategory['_events'] as $event)
                        <div class="uk-width-1-1">
                            <a href="/event/{{$event['id']}}" class="item">
                                <div class="cover" data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($event['cover'])}}"></div>
                                <div class="title uk-text-truncate">
                                    @if($event['status']==\App\Types\EventStatus::APPLYING)
                                        [正在报名]
                                    @else
                                        [{{\Edwin404\Base\Support\TypeHelper::name(\App\Types\EventStatus::class,$event['status'])}}]
                                    @endif
                                    {{$event['title']}}
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endforeach

@endsection






































