@extends('theme.default.m.frame')

@section('pageTitle','用户登录')
@section('pageTitleMain')用户登录@endsection

@section('bodyContent')

    <div class="page-block">
        <div class="body">
            <form action="?" method="post" class="uk-form" data-ajax-form>
                <div class="line">
                    <div class="label">用户：</div>
                    <div class="field">
                        <input type="text" name="username" class="uk-width-1-1" />
                    </div>
                </div>
                <div class="line">
                    <div class="label">密码：</div>
                    <div class="field">
                        <input type="password" name="password" class="uk-width-1-1" />
                    </div>
                </div>
                <div class="line">
                    <div class="field">
                        <button type="submit" class="uk-button uk-button-primary uk-width-1-1">提交</button>
                    </div>
                </div>
                <input type="hidden" name="redirect" value="{{$redirect}}" />
            </form>
        </div>
    </div>

    @if(\Edwin404\Tecmz\Helpers\OauthHelper::hasOauth())
        <div class="page-block page-block-oauth">
            <div class="body">
                <div>
                    您可以使用以下方式登录
                </div>
                <div class="oauth">
                    @if(\Edwin404\Tecmz\Helpers\OauthHelper::isWechatMobileEnable())
                        <a class="item" href="/oauth_login_{{\Edwin404\Oauth\Types\OauthType::WECHAT_MOBILE}}?redirect={{urlencode($redirect)}}"><i class="uk-icon-wechat"></i> 微信登录</a>
                    @endif
                    @if(\Edwin404\Tecmz\Helpers\OauthHelper::isQQEnable())
                        <a class="item" href="/oauth_login_{{\Edwin404\Oauth\Types\OauthType::QQ}}?redirect={{urlencode($redirect)}}"><i class="uk-icon-qq"></i> QQ登录</a>
                    @endif
                    @if(\Edwin404\Tecmz\Helpers\OauthHelper::isWeiboEnable())
                        <a class="item" href="/oauth_login_{{\Edwin404\Oauth\Types\OauthType::WEIBO}}?redirect={{urlencode($redirect)}}"><i class="uk-icon-weibo"></i> 微博登录</a>
                    @endif
                </div>
            </div>
        </div>
    @endif

    <div class="page-block">
        <div class="body">
            <div>
                没有账号？<a href="/register?redirect={{urlencode($redirect)}}">马上注册</a>
            </div>
            <div>
                忘记密码？<a href="/retrieve?redirect={{urlencode($redirect)}}">找回密码</a>
            </div>
        </div>
    </div>

@endsection