@extends('theme.default.m.member.profile.frame')

@section('pageTitle','我的消息')
@section('headerTitle','我的消息')

@section('bodyScript')
    @parent
    <script>
        $(function () {
            $('[data-mark-read]').on('click',function () {
                var ids = [];
                $('[data-id]:checked').each(function (i,o) {
                    ids.push($(o).attr('data-id'));
                });
                if(ids.length==0){
                    window.api.dialog.tipError('请先选择消息');
                    return;
                }
                window.api.dialog.loadingOn();
                $.post('/member/message_mark_read',{ids:ids},function (res) {
                    window.api.dialog.loadingOff();
                    window.api.base.defaultFormCallback(res,{
                        success:function () {
                            $('[data-id]:checked').each(function (i,o) {
                                $(this).closest('tr').remove();
                            });
                            $('[data-member-unread-message-count]').html($('[data-id]').length);
                            if(!$('[data-id]').length){
                                $('[data-member-unread-message-count]').remove();
                                $('[data-message-empty]').show();
                            }
                        }
                    });
                });
            });
            $('[data-mark-read-all]').on('click',function () {
                window.api.dialog.confirm('确定全部标记为已读?',function () {
                    window.api.dialog.loadingOn();
                    $.post('/member/message_mark_read_all',{},function (res) {
                        window.api.dialog.loadingOff();
                        window.api.base.defaultFormCallback(res,{
                            success:function () {
                                $('[data-id]').each(function (i,o) {
                                    $(this).closest('tr').remove();
                                });
                                $('[data-member-unread-message-count]').remove();
                                $('[data-message-empty]').show();
                            }
                        });
                    });
                });
            });
        });
    </script>
@endsection

@section('bodyContentMember')

    <div class="page-block">
        <div class="body">
            <div class="member-message-list">
                <div class="action">
                    <a href="javascript:;" class="uk-button" data-mark-read>标为已读</a>
                    <a href="javascript:;" class="uk-button" data-mark-read-all>全部标为已读</a>
                </div>
                <table class="uk-table">
                    <thead>
                    <tr>
                        <th width="5">&nbsp;</th>
                        <th>内容</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr data-message-empty @if(!empty($messages)) style="display:none;" @endif>
                        <td colspan="2">
                            <div class="empty">
                                没有任何未读消息~
                            </div>
                        </td>
                    </tr>
                    @foreach($messages as $message)
                        <tr class="unread">
                            <td><input type="checkbox" data-id="{{$message['id']}}" /></td>
                            <td>
                                <div class="time">{{$message['created_at']}}</div>
                                <div class="message">
                                    {!! $message['content'] !!}
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>



@endsection