@extends('theme.default.m.member.profile.frame')

@section('pageTitleMember','订单详情')

@section('bodyContentMember')

    <div class="page-block">
        <div class="body">
            <div class="member-event-list">
                <div class="list-box">
                    <table class="uk-table table-bordered">
                        <thead>
                        <tr>
                            <th>
                                <div class="status">
                                    @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                        <span class="uk-text-danger">等待付款</span>
                                    @elseif($order['status']==\App\Types\EventOrderStatus::WAIT_SIGN_IN)
                                        <span class="uk-text-success">已完成</span>
                                    @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                                        <span class="uk-text-muted">已过期</span>
                                    @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                                        <span class="uk-text-success">已完成</span>
                                    @elseif($order['status']==\App\Types\EventOrderStatus::ABSENT)
                                        <span class="uk-text-success">已完成</span>
                                    @endif
                                </div>
                                时间：{{$order['created_at']}}
                                <br>
                                订单号：{{$order['sn']}}
                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>
                                <div class="event">
                                    <a class="cover cover-1-1" href="/event/{{$order['eventId']}}" target="_blank"  style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($order['_event']['cover'])}})">
                                    </a>
                                    <a class="title" href="/event/{{$order['eventId']}}" target="_blank">
                                        {{$order['_event']['title']}}
                                    </a>
                                    <div class="buyInfo">
                                        @foreach($order['applyInfo'] as $item)
                                            {{$item['name']}}:{{$item['value']}}
                                            <br>
                                        @endforeach
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="action">
                                    @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                        <a class="main" href="/member/order_pay/{{$order['id']}}">立即付款</a>
                                    @endif
                                </div>
                                <div class="fee">
                                    ￥{{$order['payFee']}}元
                                </div>
                            </td>
                        </tr>
                        </tbody>
                        @if(!empty($order['_event']['applySuccessText']) && in_array($order['status'],[
                            \App\Types\EventOrderStatus::WAIT_SIGN_IN,
                            \App\Types\EventOrderStatus::COMPLETED,
                            \App\Types\EventOrderStatus::ABSENT
                            ]))
                            <thead>
                            <tr>
                                <th colspan="4">说明</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <td colspan="4">
                                    <div class="richhtml-container">
                                        {!! $order['_event']['applySuccessText'] !!}
                                    </div>
                                </td>
                            </tr>
                            </tbody>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>

@endsection