@extends('theme.default.m.frame')

@section('pageTitleMain','在线支付')

@section('headerNav')@endsection

@section('bodyScript')
    @parent
    @if(\Edwin404\Tecmz\Helpers\PayHelper::isWechatMobileEnable())
        <script src="http://res.wx.qq.com/open/js/jweixin-1.1.0.js"></script>
        <script>
            wx.config(<?php echo \Edwin404\Pay\Services\PayOrderService::getWechatMobileApp()->js->config(array('chooseWXPay'), false) ?>);
        </script>
    @endif
    <script>
        new window.api.payPage({
            payTypeSelector: '.pay-list > a',
            paySubmitSelector: '[data-pay-submit]',
            payTypeActiveClass: 'cur',
            dialog: window.api.dialog,
            device: 'mobile'
        });
    </script>
@endsection

@section('bodyContent')

    <div class="page-block">
        <div class="body">
            <div class="member-order-pay">
                <div class="container">

                    <div>

                        <div class="pay-summary">
                            共支付
                            <span>￥{{$order['payFee']}}</span>
                            元，请选择支付：
                        </div>

                        @if( \Edwin404\Tecmz\Helpers\PayHelper::hasPay() )
                            <div class="pay-list">

                                @if(\Edwin404\Tecmz\Helpers\PayHelper::isAlipayEnable())
                                    <a href="javascript:;" data-type="{{\Edwin404\Pay\Types\PayType::ALIPAY}}">
                                        <img src="@assets('theme/default/pc/img/alipay.jpg')"/>
                                        支付宝
                                    </a>
                                @endif

                                @if(\Edwin404\Tecmz\Helpers\PayHelper::isWechatMobileEnable())
                                    <a href="javascript:;" data-type="{{\Edwin404\Pay\Types\PayType::WECHAT_MOBILE}}">
                                        <img src="@assets('theme/default/pc/img/wechat.jpg')"/>
                                        微信支付
                                    </a>
                                @endif

                            </div>

                            <div class="pay-submit">
                                <a href="javascript:;" data-pay-submit>确定支付</a>
                            </div>

                        @else

                            <div class="pay-list">
                                <div class="uk-alert uk-alert-danger">
                                    没有开启任何支付方式 T_T
                                </div>
                            </div>

                        @endif

                    </div>

                </div>
            </div>
        </div>
    </div>

@endsection