@extends('theme.default.m.member.profile.frame')

@section('pageTitle','绑定邮箱')
@section('headerTitle','绑定邮箱')

@section('bodyScript')
    @parent
    <script>
        $(function () {
            new window.api.commonVerify({
                generateServer: '/member/profile_email_verify',
                selectorTarget: 'input[name=email]',
                selectorGenerate: '[data-verify-generate]',
                selectorCountdown: '[data-verify-countdown]',
                selectorRegenerate: '[data-verify-regenerate]',
                selectorCaptcha: 'input[name=captcha]',
                selectorCaptchaImg:'img[data-captcha]',
                interval: 60,
            },window.api.dialog);
        });
    </script>
@endsection

@section('bodyContentMember')

    <div class="page-block">
        <div class="body">
            <form action="?" class="uk-form" method="post" data-ajax-form>

                @if(!\Edwin404\Config\Facades\ConfigFacade::get('systemEmailEnable'))
                    <div class="line">
                        <div class="uk-alert uk-alert-danger">
                            <i class="uk-icon-warning"></i>
                            系统没有开启邮件发送服务，邮件可能无法发送。
                        </div>
                    </div>
                @endif

                @if($_memberUser['email'] && $_memberUser['emailVerified'])
                    <div class="line">
                        <div class="label">邮箱:</div>
                        <div class="field">
                            {{$_memberUser['email']}} <span class="uk-text-success">已验证</span>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">&nbsp;</div>
                        <div class="field">
                            <a href="javascript:;" onclick="$('[data-modify-box]').show();" class="uk-button uk-width-1-1">修改</a>
                        </div>
                    </div>
                    <div data-modify-box style="display:none;">
                        <div class="line">
                            <div class="label">新邮箱:</div>
                            <div class="field">
                                <input type="text" name="email" class="uk-width-1-1" value="" />
                            </div>
                        </div>
                        <div class="line">
                            <div class="label">图形验证码：</div>
                            <div class="field">
                                <div class="uk-grid">
                                    <div class="uk-width-1-3">
                                        <img data-captcha src="/member/profile_captcha" style="height:30px;border:1px solid #CCC;border-radius:3px;cursor:pointer;" alt="刷新验证码" onclick="this.src='/member/profile_captcha?'+Math.random();"/>
                                    </div>
                                    <div class="uk-width-1-3">
                                        <input type="text" name="captcha" class="uk-width-1-1" />
                                    </div>
                                    <div class="uk-width-1-3">
                                        <button class="uk-button uk-button-default uk-width-1-1" type="button" data-verify-generate>获取验证码</button>
                                        <button class="uk-button uk-button-default uk-disabled uk-width-1-1" type="button" data-verify-countdown style="display:none;"></button>
                                        <button class="uk-button uk-button-default uk-width-1-1" type="button" data-verify-regenerate style="display:none;">重新获取</button>
                                    </div>
                                </div>
                                <div class="help">
                                </div>
                            </div>
                        </div>
                        <div class="line">
                            <div class="label">邮箱验证码：</div>
                            <div class="field">
                                <input type="text" name="verify" class="uk-width-1-1" />
                                <div class="help">
                                </div>
                            </div>
                        </div>
                        <div class="line">
                            <div class="label">&nbsp;</div>
                            <div class="field">
                                <button type="submit" class="uk-button uk-button-primary uk-width-1-1">提交</button>
                            </div>
                        </div>
                    </div>
                @else
                    @if($_memberUser['email'])
                        <div class="line">
                            <div class="uk-alert uk-alert-danger">
                                邮箱还没有进行验证
                            </div>
                        </div>
                    @endif
                    <div class="line">
                        <div class="label">邮箱:</div>
                        <div class="field">
                            <input type="text" name="email" class="uk-width-1-1" value="{{$_memberUser['email'] or ''}}" />
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">图形验证码：</div>
                        <div class="field">
                            <div class="uk-grid">
                                <div class="uk-width-1-3">
                                    <img data-captcha src="/member/profile_captcha" style="height:30px;border:1px solid #CCC;border-radius:3px;cursor:pointer;" alt="刷新验证码" onclick="this.src='/member/profile_captcha?'+Math.random();"/>
                                </div>
                                <div class="uk-width-1-3">
                                    <input type="text" name="captcha" class="uk-width-1-1" />
                                </div>
                                <div class="uk-width-1-3">
                                    <button class="uk-button uk-button-default uk-width-1-1" type="button" data-verify-generate>获取验证码</button>
                                    <button class="uk-button uk-button-default uk-disabled uk-width-1-1" type="button" data-verify-countdown style="display:none;"></button>
                                    <button class="uk-button uk-button-default uk-width-1-1" type="button" data-verify-regenerate style="display:none;">重新获取</button>
                                </div>
                            </div>
                            <div class="help">
                            </div>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">邮箱验证码：</div>
                        <div class="field">
                            <input type="text" name="verify" />
                            <div class="help">
                            </div>
                        </div>
                    </div>
                    <div class="line">
                        <div class="field">
                            <button type="submit" class="uk-button uk-button-primary uk-width-1-1">提交</button>
                        </div>
                    </div>
                @endif
            </form>
        </div>
    </div>

@endsection