@extends('theme.default.m.frame')

@section('pageTitle','找回密码')
@section('pageTitleMain')找回密码@endsection

@section('bodyContent')

    <div class="page-block">
        <div class="body uk-text-center" style="padding:50px 0;">
            <?php $found = false; ?>
            @if(\Edwin404\Config\Facades\ConfigFacade::get('retrieveEmailEnable',false))
                <a class="uk-button" href="/retrieve/email"><i class="uk-icon-envelope"></i> 通过邮箱找回</a>
                <?php $found = true; ?>
            @endif
            @if(\Edwin404\Config\Facades\ConfigFacade::get('retrievePhoneEnable',false))
                <a class="uk-button" href="/retrieve/phone"><i class="uk-icon-tablet"></i> 通过手机找回</a>
                <?php $found = true; ?>
            @endif
            @if(!$found)
                <div class="uk-alert uk-alert-danger">没有开启任何找回密码方式</div>
            @endif
        </div>
    </div>

    <div class="page-block">
        <div class="body">
            <div>
                还没有账号？<a href="/register?redirect={{urlencode($redirect)}}">马上注册</a>
            </div>
            <div>
                已想起来密码？<a href="/login?redirect={{urlencode($redirect)}}">马上登录</a>
            </div>
        </div>
    </div>

@endsection