@extends('theme.default.m.frame')

@section('pageTitle','通过手机找回密码')
@section('pageTitleMain')通过手机找回密码@endsection

@section('bodyScript')
    @parent
    <script>
        $(function () {
            new window.api.commonVerify({
                generateServer: '/retrieve/phone_verify',
                selectorTarget: 'input[name=phone]',
                selectorGenerate: '[data-phone-verify-generate]',
                selectorCountdown: '[data-phone-verify-countdown]',
                selectorRegenerate: '[data-phone-verify-regenerate]',
                selectorCaptcha: 'input[name=captcha]',
                selectorCaptchaImg:'img[data-captcha]',
                interval: 60,
            },window.api.dialog);
        });
    </script>
@endsection

@section('bodyContent')

    <div class="page-block">
        <div class="body">
            <form action="?" method="post" class="uk-form" data-ajax-form>
                <div class="line">
                    <div class="label">手机：</div>
                    <div class="field">
                        <input type="text" name="phone" class="uk-width-1-1" />
                        <div class="help">
                        </div>
                    </div>
                </div>
                <div class="line">
                    <div class="label">图形验证码：</div>
                    <div class="field">
                        <div class="uk-grid">
                            <div class="uk-width-1-3">
                                <img data-captcha src="/retrieve/captcha" style="height:30px;border:1px solid #CCC;border-radius:3px;cursor:pointer;" alt="刷新验证码" onclick="this.src='/retrieve/captcha?'+Math.random();"/>
                            </div>
                            <div class="uk-width-1-3">
                                <input type="text" name="captcha" class="uk-width-1-1" />
                            </div>
                            <div class="uk-width-1-3">
                                <button class="uk-button uk-button-default uk-width-1-1" type="button" data-phone-verify-generate>获取验证码</button>
                                <button class="uk-button uk-button-default uk-disabled uk-width-1-1" type="button" data-phone-verify-countdown style="display:none;"></button>
                                <button class="uk-button uk-button-default uk-width-1-1" type="button" data-phone-verify-regenerate style="display:none;">重新获取</button>
                            </div>
                        </div>
                        <div class="help">
                        </div>
                    </div>
                </div>
                <div class="line">
                    <div class="label">手机验证码：</div>
                    <div class="field">
                        <input type="text" name="verify" class="uk-width-1-1" />
                        <div class="help">
                        </div>
                    </div>
                </div>
                <div class="line">
                    <div class="field">
                        <button type="submit" class="uk-button uk-button-primary uk-width-1-1">提交</button>
                    </div>
                </div>
                <input type="hidden" name="redirect" value="{{$redirect}}" />
            </form>
        </div>
    </div>

    <div class="page-block">
        <div class="body">
            <div>
                还没有账号？<a href="/register?redirect={{urlencode($redirect)}}">马上注册</a>
            </div>
            <div>
                已想起来密码？<a href="/login?redirect={{urlencode($redirect)}}">马上登录</a>
            </div>
        </div>
    </div>

@endsection