@extends('theme.default.m.frame')

@section('pageTitle','设置新密码')
@section('pageTitleMain')设置新密码@endsection

@section('bodyContent')

    <div class="page-block">
        <div class="body">
            <form action="?" method="post" class="uk-form" data-ajax-form>
                <div class="line">
                    <div class="label">
                        账户
                    </div>
                    <div class="field">
                        @if(!empty($memberUser['username']))
                            {{\Edwin404\Base\Support\StrHelper::mask($memberUser['username'])}}
                        @elseif(!empty($memberUser['email']))
                            {{\Edwin404\Base\Support\StrHelper::mask($memberUser['email'])}}
                        @elseif(!empty($memberUser['phone']))
                            {{\Edwin404\Base\Support\StrHelper::mask($memberUser['phone'])}}
                        @endif
                    </div>
                </div>
                <div class="line">
                    <div class="label">新密码：</div>
                    <div class="field">
                        <input type="password" name="password" class="uk-width-1-1" />
                        <div class="help">
                        </div>
                    </div>
                </div>
                <div class="line">
                    <div class="label">重复密码：</div>
                    <div class="field">
                        <input type="password" name="passwordRepeat" class="uk-width-1-1" />
                        <div class="help">
                        </div>
                    </div>
                </div>
                <div class="line">
                    <div class="field">
                        <button type="submit" class="uk-button uk-button-primary uk-width-1-1">提交</button>
                    </div>
                </div>
                <input type="hidden" name="redirect" value="{{$redirect}}" />
            </form>
        </div>
    </div>

    <div class="page-block">
        <div class="body">
            <div>
                还没有账号？<a href="/register?redirect={{urlencode($redirect)}}">马上注册</a>
            </div>
            <div>
                已想起来密码？<a href="/login?redirect={{urlencode($redirect)}}">马上登录</a>
            </div>
        </div>
    </div>

@endsection