@extends('theme.default.pc.frame')

@if($currentCategory)
    @section('pageTitleMain',$currentCategory['title'])
@else
    @section('pageTitleMain','课程')
@endif

@section('bodyContent')

    <div style="background:#FFF;">
        <div class="main-container">
            <div class="category-list">
                <div class="filter">
                    <div class="label">分类：</div>
                    <div class="value">
                        <a href="/category" @if($request_path=='/category') class="active" @endif>全部</a>
                        @foreach($eventCategories as $eventCategory)
                            <a href="/category/{{$eventCategory['id']}}" @if($request_path=='/category/'.$eventCategory['id']) class="active" @endif>{{$eventCategory['title']}}</a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="main-container">
        <div class="category-event-list">
            <div class="list">
                @if(empty($events))
                    <div class="empty">
                        暂无记录~
                    </div>
                @else
                    <div class="uk-grid">
                        @foreach($events as $event)
                        <div class="uk-width-1-4">
                            <a href="/event/{{$event['id']}}" class="item">
                                <div class="cover" data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($event['cover'])}}"></div>
                                <div class="title uk-text-truncate">
                                    {{$event['title']}}
                                </div>
                                <div class="attr">
                                    <div class="right">
                                        <i class="uk-icon-clock-o"></i> {{\Carbon\Carbon::parse($event['time'])->toDateString()}}
                                    </div>
                                    @if($event['status']==\App\Types\EventStatus::APPLYING)
                                        <span class="uk-text-success">正在报名</span>
                                    @else
                                        {{\Edwin404\Base\Support\TypeHelper::name(\App\Types\EventStatus::class,$event['status'])}}
                                    @endif
                                </div>
                            </a>
                        </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        <div class="page-container">
            {!! $pageHtml !!}
        </div>

    </div>


@endsection