@extends('theme.default.pc.frame')

@section('pageTitleMain',$event['title'])
@section('pageKeywords',$event['title'])
@section('pageDescription',$event['summary'])

@section('bodyScript')
    @parent
    <script>
        var swiper = new Swiper('.page-block-event-basic .swiper-container', {
            pagination: '.swiper-pagination',
            paginationClickable: '.swiper-pagination',
            nextButton: '.swiper-button-next',
            prevButton: '.swiper-button-prev',
            loop: true,
            autoplay: 2500,
            autoplayDisableOnInteraction: false
        });
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">
        <div class="page-block page-block-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/category/{{$event['_category']['id']}}">{{$event['_category']['title']}}</a></li>
                <li class="uk-active"><span>{{$event['title']}}</span></li>
            </ul>
        </div>
    </div>

    <div class="main-container">
        <div class="uk-grid">
            <div class="uk-width-1-1">
                <div class="page-block page-block-event-basic">
                    <div class="uk-grid">
                        <div class="uk-width-1-2">
                            <div class="images">
                                <div class="swiper-container">
                                    <div class="swiper-wrapper">
                                        <a href="javascript:;" class="swiper-slide" style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($event['cover'])}});"></a>
                                        @foreach($event['photos'] as $photo)
                                            <a  href="javascript:;" class="swiper-slide" style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($photo)}});"></a>
                                        @endforeach
                                    </div>
                                    <div class="swiper-pagination swiper-pagination-white"></div>
                                    <div class="swiper-button-next swiper-button-white"></div>
                                    <div class="swiper-button-prev swiper-button-white"></div>
                                </div>
                            </div>
                        </div>
                        <div class="uk-width-1-2">
                            <div class="basic">
                                <h1>{{$event['title']}}</h1>
                                <div class="info">
                                    <div class="attr">
                                        <div class="name">
                                            时间：
                                        </div>
                                        <div class="value">
                                            {{\Carbon\Carbon::parse($event['time'])->format('Y-m-d H:i')}}
                                        </div>
                                    </div>
                                    @if($event['applyTimeLimit'])
                                        <div class="attr">
                                            <div class="name">
                                                报名开始：
                                            </div>
                                            <div class="value">
                                                {{\Carbon\Carbon::parse($event['applyStartTime'])->format('Y-m-d H:i')}}
                                            </div>
                                        </div>
                                        <div class="attr">
                                            <div class="name">
                                                报名截止：
                                            </div>
                                            <div class="value">
                                                {{\Carbon\Carbon::parse($event['applyEndTime'])->format('Y-m-d H:i')}}
                                            </div>
                                        </div>
                                    @endif
                                    @if($event['applyNumberLimit'])
                                        <div class="attr">
                                            <div class="name">
                                                报名限制：
                                            </div>
                                            <div class="value">
                                                {{$event['applyNumberMax']}}人
                                            </div>
                                        </div>
                                    @endif
                                    @foreach($event['param'] as $item)
                                        <div class="attr">
                                            <div class="name">
                                                {{$item['name']}}：
                                            </div>
                                            <div class="value">
                                                {{$item['value']}}
                                            </div>
                                        </div>
                                    @endforeach
                                    @if($event['price']>0)
                                        <div class="attr">
                                            <div class="name">
                                                费用：
                                            </div>
                                            <div class="value">
                                                <div class="price">￥{{$event['price']}}元</div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="action">
                                    @if($event['applyTimeLimit'] && (time()<strtotime($event['applyStartTime']) || time()>strtotime($event['applyEndTime'])))
                                        <div class="disabled">报名未开始或已截止</div>
                                    @else
                                        @if($event['status']==\App\Types\EventStatus::NOT_START)
                                            <div class="disabled">报名未开始</div>
                                        @elseif($event['status']==\App\Types\EventStatus::APPLYING)
                                            @if($_memberUserId)
                                                <a class="submit" href="javascript:;" onclick="UIkit.modal('#submitDialog').show();">立即报名</a>
                                            @else
                                                <a class="submit" href="/login?redirect={{urlencode('/event/'.$event['id'])}}">立即报名</a>
                                            @endif
                                        @elseif($event['status']==\App\Types\EventStatus::APPLY_EXPIRED)
                                            <div class="disabled">已过期</div>
                                        @elseif($event['status']==\App\Types\EventStatus::FINISHED)
                                            <div class="disabled">已结束</div>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-width-7-10">
                <div class="page-block page-block-event-detail">
                    <div class="title">
                        详细描述
                    </div>
                    <div class="content">
                        {!! \Edwin404\Base\Support\HtmlHelper::replaceImageSrcToLazyLoad($event['content'],'data-src',true) !!}
                    </div>
                </div>
            </div>
            <div class="uk-width-3-10">
                <div class="page-block page-block-event-info">
                    <div class="title">
                        <h2>{{$event['title']}}</h2>
                    </div>
                    @foreach($event['param'] as $item)
                    <div class="attr">
                        <div class="name">
                            {{$item['name']}}：
                        </div>
                        <div class="value">
                            {{$item['value']}}
                        </div>
                    </div>
                    @endforeach
                    <div class="summary">
                        {{$event['summary']}}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="submitDialog" class="uk-modal">
        <form action="/event/{{$event['id']}}/submit" class="uk-form" method="post" data-ajax-form>
            <div class="uk-modal-dialog event-submit-dialog" style="width:800px;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    <h2>{{$event['title']}}报名确认</h2>
                </div>
                <div>

                    @if($event['applyText'])
                        <div class="apply-text">
                            {!! $event['applyText'] !!}
                        </div>
                    @endif

                    @if(!empty($event['applyInfo']))
                        <div class="apply-field">
                            {!! \Edwin404\Admin\Cms\Field\FieldFields::parseHtml($event['applyInfo'],'applyInfo[]') !!}
                        </div>
                    @endif

                </div>
                <div class="uk-modal-footer">
                    <button type="submit" class="uk-button uk-button-primary uk-button-large uk-width-1-1">确认报名</button>
                </div>
            </div>
        </form>
    </div>

@endsection