@extends('theme.default.pc.frame')

@section('pageTitleMain','课程详情')

@section('bodyContent')

    <div class="main-container">

        <div class="page-block page-block-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li class="uk-active"><span>我的课程</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-1-6">
                @include('theme.default.pc.member.profile.menu')
            </div>
            <div class="uk-width-5-6">
                <div class="page-block">
                    <div class="head">我的课程</div>
                    <div class="content">

                        <div class="member-event-list">
                            <div class="list-box">
                                @if(empty($orders))
                                    <div class="empty">
                                        暂无记录
                                    </div>
                                @endif
                                @foreach($orders as $order)
                                    <table class="uk-table table-bordered">
                                        <thead>
                                        <tr>
                                            <th colspan="3">
                                                时间：{{$order['created_at']}}
                                                &nbsp;&nbsp;
                                                订单号：{{$order['sn']}}
                                            </th>
                                            <th class="uk-text-right">
                                                {{--<a class="remove" href="javascript:;" data-ajax-request="/member/order_delete/1" data-ajax-request-loading data-confirm="确认删除?">--}}
                                                    {{--<i class="uk-icon-trash-o"></i>--}}
                                                {{--</a>--}}
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <div class="event">
                                                        <a class="cover cover-1-1" href="/event/{{$order['eventId']}}" target="_blank" style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($order['_event']['cover'])}})">
                                                        </a>
                                                        <a class="title" href="/event/{{$order['eventId']}}" target="_blank">
                                                            {{$order['_event']['title']}}
                                                        </a>
                                                        <div class="buyInfo">
                                                            @foreach($order['applyInfo'] as $item)
                                                                {{$item['name']}}:{{$item['value']}}
                                                                <br>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </td>
                                                <td style="width:100px;" class="uk-text-center">
                                                    ￥{{$order['payFee']}}元
                                                </td>
                                                <td style="width:100px;" class="uk-text-center">
                                                    <div class="status">
                                                        @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                                            <span class="uk-text-danger">等待付款</span>
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::WAIT_SIGN_IN)
                                                            <span class="uk-text-success">已完成</span>
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                                                            <span class="uk-text-muted">已过期</span>
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                                                            <span class="uk-text-success">已完成</span>
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::ABSENT)
                                                            <span class="uk-text-success">已完成</span>
                                                        @endif
                                                    </div>
                                                </td>
                                                <td style="width:100px;">
                                                    <div class="action">
                                                        @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                                            <a class="main" href="/member/order_pay/{{$order['id']}}">立即付款</a>
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::WAIT_SIGN_IN)
                                                            <a class="main" href="/member/order_detail/{{$order['id']}}">查看详情</a>
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                                                            <a class="main" href="/member/order_detail/{{$order['id']}}">查看详情</a>
                                                        @elseif($order['status']==\App\Types\EventOrderStatus::ABSENT)
                                                            <a class="main" href="/member/order_detail/{{$order['id']}}">查看详情</a>
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                @endforeach
                            </div>
                        </div>

                        <div class="page-container">
                            {!! $pageHtml !!}
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection