<?php

namespace Edwin404\Admin\Http\Controllers;

use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Data\Support\DataUploadHandle;
use Edwin404\Data\Support\ImageSelectDialogHandle;
use Edwin404\Data\Support\UEditorHandle;

class DataController extends AdminCheckController
{
    public function imageSelectDialog(ImageSelectDialogHandle $imageSelectDialogHandle)
    {
        return $imageSelectDialogHandle->execute();
    }

    public function tempDataUpload(DataUploadHandle $dataUploadHandle, $category = '')
    {
        return $dataUploadHandle->temp($category);
    }

    public function ueditorHandle(UEditorHandle $UEditorHandle)
    {
        return $UEditorHandle->executeForAdmin();
    }
}
