<?php

namespace Edwin404\SmartAssets\Helper;

use Illuminate\Support\Facades\Request;
use Illuminate\Support\Str;

class AssetsHelper
{
    public static function cdn()
    {
        return app('smartAssetsPath')->getCDN('');
    }

    public static function fix($path)
    {
        if (Str::startsWith($path, 'http://') || Str::startsWith($path, 'https://') || Str::startsWith($path, '//')) {
            return $path;
        }
        if (Str::startsWith($path, '/')) {
            $path = substr($path, 1);
        }
        return app('smartAssetsPath')->getCDN($path) . app('smartAssetsPath')->getPathWithHash($path);
    }

    public static function fixOrDefault($path, $default)
    {
        if (empty($path)) {
            return self::fix($default);
        }
        return self::fix($path);
    }

    public static function url($file)
    {
        return app('smartAssetsPath')->getCDN($file) . app('smartAssetsPath')->getPathWithHash($file);
    }

    public static function fixFull($path)
    {
        $path = self::fix($path);
        if (Str::startsWith($path, 'http://') || Str::startsWith($path, 'https://')) {
            return $path;
        }
        if (Request::secure()) {
            $schema = 'https';
        } else {
            $schema = 'http';
        }
        if (Str::startsWith($path, '//')) {
            return $schema . ':' . $path;
        }
        return $schema . '://' . Request::server('HTTP_HOST') . $path;
    }

    public static function fixFullOrDefault($path, $default = null)
    {
        if (empty($path)) {
            return self::fixFull($default);
        }
        return self::fixFull($path);
    }
}