<?php

namespace Edwin404\Tecmz\Helpers;


use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\TypeHelper;
use Edwin404\SmartAssets\Helper\AssetsHelper;

class AdminCmsHelper
{
    public static function thumbViewItem($image)
    {
        $url = AssetsHelper::fixOrDefault($image, 'assets/lib/img/none.png');
        return '<a href="' . $url . '" style="border:1px solid #CCC;display:inline-block;height:42px;width:42px;box-sizing:border-box;border-radius:2px;" data-image-preview><img src="' . $url . '" style="height:40px;width:40px;display:inline-block;" /></a>';
    }

    public static function memberUserId($memberUserId)
    {
        $memberUser = ModelHelper::loadWithCache('member_user', ['id' => $memberUserId]);
        return self::memberUser($memberUser);
    }

    public static function memberUser($memberUser)
    {
        if (!empty($memberUser)) {
            return '<a href="javascript:;" data-dialog-request="' . action('\App\Http\Controllers\Admin\MemberController@dataView', ['id' => $memberUser['id']]) . '" class="list-member-user"><img src="'
            . AssetsHelper::fixOrDefault($memberUser['avatar'], 'assets/lib/img/avatar.png') . '" /><span>' . htmlspecialchars($memberUser['username']) . '</span></a>';
        }
        return '';
    }

    public static function colorText($typeValue, $typeClass, $colorMap = [])
    {
        $text = htmlspecialchars(TypeHelper::name($typeClass, $typeValue));
        if (empty($colorMap[$typeValue])) {
            return $text;
        }
        return
            '<span class="uk-text-' . (empty($colorMap[$typeValue]) ? 'default' : $colorMap[$typeValue]) . '">'
            . $text . '</span>';
    }

    public static function colorBadge($typeValue, $typeClass, $colorMap = [])
    {
        $text = htmlspecialchars(TypeHelper::name($typeClass, $typeValue));
        if (empty($colorMap[$typeValue])) {
            return $text;
        }
        return
            '<span class="uk-badge uk-badge-' . (empty($colorMap[$typeValue]) ? 'default' : $colorMap[$typeValue]) . '">'
            . $text . '</span>';
    }

}