<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_mail', language 'zh_cn', branch 'MOODLE_32_STABLE'
 *
 * @package   local_mail
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addbcc'] = '添加 密送';
$string['addcc'] = '添加 抄送';
$string['addrecipients'] = '添加 收件人';
$string['addto'] = '添加收件人';
$string['advsearch'] = '高级搜索';
$string['all'] = '所有';
$string['applychanges'] = '应用';
$string['assigntonewlabel'] = '添加到新标签……';
$string['attachments'] = '附件';
$string['attachnumber'] = '{$a} 个附件';
$string['bcc'] = '密送';
$string['bulkmessage'] = '给选择的用户发送一封邮件……';
$string['cancel'] = '取消';
$string['cannotcompose'] = '你没有选择任何课程，不能创建邮件';
$string['cc'] = '抄送';
$string['compose'] = '创建';
$string['continue'] = '继续';
$string['courses'] = '课程';
$string['delete'] = '删除';
$string['discard'] = '放弃';
$string['downloadall'] = '全部下载';
$string['draft'] = '草稿';
$string['drafts'] = '草稿箱';
$string['editlabel'] = '编辑标签';
$string['emptyrecipients'] = '没有收件人';
$string['erroremptycourse'] = '请指定一个课程';
$string['erroremptylabelname'] = '请指定一个标签名称';
$string['erroremptyrecipients'] = '至少需要指定一个收件人';
$string['erroremptysubject'] = '请指定一个主题';
$string['errorinvalidcolor'] = '无效颜色';
$string['errorrepeatedlabelname'] = '标签名已存在';
$string['filterbydate'] = '日期（截止今日）：';
$string['forward'] = '转发';
$string['from'] = '从';
$string['hasattachments'] = '（邮件附件）';
$string['inbox'] = '收件箱';
$string['invalidlabel'] = '无效标签';
$string['invalidmessage'] = '无效邮件';
$string['labelcolor'] = '颜色';
$string['labeldeleteconfirm'] = '你确定要彻底删除标签 \'{$a}\'吗?';
$string['labelname'] = '名称';
$string['labels'] = '标签';
$string['mail:addinstance'] = '添加一封新邮件';
$string['mail:mailsamerole'] = '发送邮件给具有相同角色的用户';
$string['mailupdater'] = '邮件更新';
$string['mail:usemail'] = '使用邮件';
$string['markasread'] = '标为已读';
$string['markasread_help'] = '启用，所有新邮件都将标记为已读';
$string['markasstarred'] = '标为重要';
$string['markasunread'] = '标为未读';
$string['markasunstarred'] = '标为非重要';
$string['maxattachments'] = '最大附件数';
$string['maxattachmentsize'] = '最大附件大小';
$string['message'] = '消息';
$string['messageprovider:mail'] = '接收邮件通知';
$string['moreactions'] = '更多';
$string['mymail'] = '我的邮箱';
$string['newlabel'] = '新标签';
$string['nocolor'] = '无颜色';
$string['nolabels'] = '没有可用标签';
$string['nomessages'] = '没有消息';
$string['nomessageserror'] = '该操作要求至少选择一封邮件';
$string['nomessagestoview'] = '没有可查看的邮件';
$string['none'] = '空';
$string['norecipient'] = '(缺少收件人)';
$string['noselectedmessages'] = '没有选择邮件';
$string['nosubject'] = '(没有主题)';
$string['notificationbody'] = '- 从: {$a->user}

- 主题: {$a->subject}

{$a->content}';
$string['notificationbodyhtml'] = '<p>从: {$a->user}</p><p>主题: <a href="{$a->url}">{$a->subject}</a></p><p>{$a->content}</p>';
$string['notificationpref'] = '发送通知';
$string['notificationsubject'] = '新邮件在 {$a}';
$string['notingroup'] = '你不是任何组的成员';
$string['pagingmultiple'] = '{$a->first}-{$a->last} 的 {$a->total}';
$string['pagingsingle'] = '{$a->index} 的 {$a->total}';
$string['perpage'] = '显示 {$a} 邮件';
$string['pluginname'] = '我的邮件';
$string['read'] = '读';
$string['references'] = '参考';
$string['removelabel'] = '移除标签';
$string['reply'] = '回复';
$string['replyall'] = '回复所有';
$string['restore'] = '恢复';
$string['save'] = '保存';
$string['search'] = '搜索';
$string['searchbyattach'] = '有附件';
$string['searchbyunread'] = '只显示未读';
$string['send'] = '发送';
$string['sendmessage'] = '发送一封邮件';
$string['sentmail'] = '已发邮件';
$string['setlabels'] = '标签';
$string['shortaddbcc'] = '密送';
$string['shortaddcc'] = '抄送';
$string['shortaddto'] = '收件人';
$string['showlabelmessages'] = '显示标签为 "{$a}" 的邮件';
$string['showrecentmessages'] = '显示最近的邮件';
$string['smallmessage'] = '{$a->user} 已经发了一封邮件给你';
$string['starred'] = '重要';
$string['starredmail'] = '重要邮件';
$string['subject'] = '主题';
$string['to'] = '到';
$string['toomanyrecipients'] = '搜索到太多的邮件';
$string['trash'] = '垃圾箱';
$string['undo'] = '撤销';
$string['undodelete'] = '{$a} 邮件已经移动到垃圾箱';
$string['undorestore'] = '{$a} 邮件已经恢复';
$string['unread'] = '未读';
$string['unstarred'] = '未标识重要邮件';
