<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dyslexic', language 'zh_tw', branch 'MOODLE_31_STABLE'
 *
 * @package   block_dyslexic
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['defaut_font'] = '預設字型';
$string['info'] = '什麼是閱讀障礙？';
$string['link'] = '更多閱讀障礙字型';
$string['moving_title'] = '為何所有的都在移動？';
$string['opendyslexic_font'] = '閱讀障礙專用字型';
$string['pluginname'] = '閱讀障礙模式';
$string['readmore'] = '閱讀更多...';
$string['script_info'] = '頁面動畫的腳本來自：';
$string['script_off'] = '停止動畫 !';
$string['script_on'] = '重新上載動畫';
$string['wikipedia_description'] = '失讀症（英語：dyslexia、reading disorder、或 alexia、或是讀寫障礙，或稱為難語症、誦讀障礙、閱讀障礙、），是一種學習困難的表現，對於閱讀和書寫文字具有困難，但具有常人的智商。

症狀的嚴重程度因人而異。其他的症狀包括難以唸出字詞，難以拼出單字，無法專注閱讀，難以連續書寫以及無法在閱讀時清楚唸出字詞，或是無法理解閱讀的內容。這些症狀最先往往在學校時發現。這些讀寫上的困難，並不是患者自己可以控制的，讀寫障礙患者對於學習的渴望，通常與普通人並無二致。

一般認為，先天基因因素與後天環境因素，都同時是造成讀寫困難的原因。有些則看似與家族史相關。罹患注意力失調症的患者，通常也較容易發生讀寫障礙，且往往算術障礙。如果成人開始出現相關症狀，也許是腦部創傷、中風或失智症所導致。相關的病理機制與大腦處理語言的過程有關。診斷過程包括了檢測患者的記憶、拼字能力、視力和閱讀技巧等。診斷的過程中需先排除因為未受閱讀教育或閱讀教育品質不良所導致的閱讀困難，或是患者可能具有的視聽障礙。

治療通常包括了依據患者的需求，調整教學的方法。即便這無法治療造成疾病的原因，但讀寫困難的情況會有所改善。對於視力的治療並不奏效。讀寫障礙是最常見的學習障礙，在一般族群中，影響3%~7%的人。常見確診為男性患者，但部分研究認為讀寫障礙並無性別差異。在一般的族群中，也有將近20%的人有程度不一的症狀。讀寫障礙也並無地緣差異。';
$string['wikipedia_title'] = '來自維基百科的文章';
$string['wikipedia_url'] = 'https://zh.wikipedia.org/wiki/%E5%A4%B1%E8%AE%80%E7%97%87';
