<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_progress', language 'zh_tw', branch 'MOODLE_31_STABLE'
 *
 * @package   block_progress
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity_completion'] = '活動完成';
$string['addallcurrentitems'] = '添加活動/資源';
$string['answered'] = '已經回答';
$string['aspirelist'] = 'Aspire資源列表';
$string['assessed'] = '已評核';
$string['assign'] = '作業';
$string['assignment'] = '作業';
$string['attempted'] = '作答次';
$string['attempted_colour'] = '#73A839';
$string['attempted_colour_descr'] = '已嘗試元素的HTML顏色編碼';
$string['attempted_colour_title'] = '已嘗試顏色';
$string['awarded'] = '已經授予';
$string['bigbluebuttonbn'] = '大藍色接鍵';
$string['book'] = '書籍';
$string['cachedef_cachedlogs'] = '緩存進度桿的查詢紀錄';
$string['certificate'] = '證書';
$string['chat'] = '聊天室';
$string['choice'] = '投票';
$string['completed'] = '已完成';
$string['config_default_title'] = '進度桿';
$string['config_group'] = '只顯示給群組';
$string['config_header_action'] = '動作';
$string['config_header_expected'] = '預期由';
$string['config_header_icon'] = '圖標';
$string['config_header_locked'] = '鎖定至到期日';
$string['config_header_monitored'] = '被監控的';
$string['config_header_showsubmitted'] = '行動前先顯示提交';
$string['config_icons'] = '在進度趕上使用圖標';
$string['config_longbars'] = '如何顯示進度桿';
$string['config_now'] = '使用';
$string['config_orderby'] = '項目順序依照';
$string['config_orderby_course_order'] = '課程內的順序';
$string['config_orderby_due_time'] = '以日期時間預期';
$string['config_percentage'] = '對學生顯示百分比';
$string['config_scroll'] = '滑動';
$string['config_squeeze'] = '壓縮';
$string['config_title'] = '另類標題';
$string['config_warning_loglifetime'] = '警告：紀錄將於 {$a} 日後清除。依靠瀏覽數目的動作將會因此受到影響。';
$string['config_warning_logstores'] = '警告：紀錄功能已被停用，因此將不會檢查依靠瀏覽數目的動作';
$string['config_wrap'] = '包裹';
$string['coursenametoshow'] = '在Dashboard上顯示的課皇名稱';
$string['data'] = '資料庫';
$string['defaultlongbars'] = '進度列的預設設置';
$string['dmelearn'] = '網上電子媒體教學';
$string['equella'] = 'Equella';
$string['feedback'] = '回饋';
$string['finished'] = '已完成的';
$string['flashcardtrainer'] = '閃示卡訓練員';
$string['folder'] = '資料夾';
$string['forum'] = '討論區';
$string['fullname'] = '完整課程名稱';
$string['futureNotAttempted_colour'] = '#025187';
$string['futurenotattempted_colour_descr'] = '尚未嘗試的未來元素的HTML顏色編碼';
$string['futurenotattempted_colour_title'] = '以後不會嘗上的顏色';
$string['geogebra'] = 'Geogebra';
$string['glossary'] = '詞彙表';
$string['graded'] = '已經計分的';
$string['hotpot'] = 'Hot Potatoes教學軟件';
$string['how_group_works'] = '可顯示群組是如何操作';
$string['how_group_works_help'] = '選擇群組會限制此區塊僅群組可見';
$string['how_longbars_works'] = '如何顯示長桿';
$string['how_longbars_works_help'] = '<p>當桿超過已定的長度，將會以以下方式顯示</p>
<ul>
    <li>壓縮成一條橫桿</li>
    <li>向側滑動顯示溢出的桿部份</li>
    <li>多行方式顯示所有桿部份</li>
</ul>
<p>注意：當桿已被壓縮，將不會題示「現在」的指示</p>';
$string['how_ordering_works'] = '順序是如何操作的';
$string['how_ordering_works_help'] = '<p>進度桿中的項目可以兩種方式排列</p>
<ul>
    <li><em>預期的日期時間</em> (default)<br />
    到期日或活動／資源的手動設置日期皆會用作排列進度桿中的項目
    </li>
    <li><em>課程中的順序</em><br />
活動／資源將會以課程主頁的順序顯示。當此選擇此選項，有關時間的功能將會停用
    </li>
</ul>';
$string['hsuforum'] = '高級討論區';
$string['imscp'] = 'IMS內容包';
$string['jclic'] = 'JClic';
$string['journal'] = '日記';
$string['lastonline'] = '最後上線';
$string['lesson'] = '編序學習';
$string['lti'] = '外部工具';
$string['marked'] = '已標記';
$string['mouse_over_prompt'] = '放置滑鼠或點擊桿以獲尿資訊';
$string['no_blocks'] = '尚未在您的課程中設置進度桿區塊';
$string['no_courses'] = '您尚未選讀任何課程，只會顯示您就讀課程的進度桿';
$string['no_events_config_message'] = '沒有活動／資源可被監視。建立活動／資源以設置此區塊。';
$string['no_events_message'] = '沒有正在監視的活動／資源。使用設置以設定監視功能。';
$string['notAttempted_colour'] = '#C71C22';
$string['notattempted_colour_descr'] = '尚未嘗試的現有元素的HTML顏色編碼';
$string['notattempted_colour_title'] = '不嘗試的顏色';
$string['no_visible_events_message'] = '沒有可視的監察活動';
$string['now_indicator'] = '現在';
$string['ouwiki'] = 'OU 維基';
$string['overview'] = '學生綜覽';
$string['page'] = '頁面';
$string['panopto'] = 'Panopto影片';
$string['passed'] = '已經合格';
$string['passedby'] = '過去的到期日';
$string['passedscorm'] = '過去';
$string['pluginname'] = '進度桿';
$string['posted_to'] = '張貼到';
$string['progress'] = '進度';
$string['progress:addinstance'] = '新增進度桿區塊';
$string['progressbar'] = '進度桿';
$string['progress:myaddinstance'] = '新增進度桿區塊到我的主頁';
$string['progress:overview'] = '查看所有學生的課程概覽的進度';
$string['progress:showbar'] = '在進度桿區塊上顯示桿';
$string['questionnaire'] = '問卷';
$string['quiz'] = '測驗卷';
$string['recordingsbn'] = 'BBB錄音';
$string['resource'] = '檔案';
$string['responded_to'] = '回應至';
$string['scorm'] = 'SCORM';
$string['selectitemstobeadded'] = '選擇活動/資源';
$string['shortname'] = '短的課程名稱';
$string['showallinfo'] = '顯示所有資料';
$string['showinactive'] = '在概覽中顯示不活躍學生';
$string['subcourse'] = '子課程';
$string['submitted'] = '已經提交的';
$string['submittednotcomplete_colour'] = '#FFCC00';
$string['submittednotcomplete_colour_descr'] = '已提交HTML顏色編碼，但未完成';
$string['submittednotcomplete_colour_title'] = '己提交但未完成的顏色';
$string['survey'] = '調查';
$string['time_expected'] = '預期的';
$string['turnitintool'] = 'Turnitin工具';
$string['turnitintooltwo'] = 'Turnitin工具2';
$string['url'] = '網址';
$string['video'] = '視頻';
$string['viewed'] = '已經檢視';
$string['vpl'] = '虛擬編程實驗室';
$string['what_actions_can_be_monitored'] = '可監視那一個動作？';
$string['what_actions_can_be_monitored_help'] = '<p>每個活動將可能有不同的動作</p>

<p>例如，作業模組的可能動作是：

<ul>
        <li>已提交,</li>
        <li>已標記,</li>
        <li>已通過 (請看下列的通過注釋),</li>
        <li>已通過截止日(請看下列的通過注釋) 及</li>
<li>完成活動 </li>
    </ul>
</p>
<h3>通過</h3>

<p>至於作業, 課堂及測驗模組, 通過的概念是根據在成績簿中設定的成績項目<a href="http://docs.moodle.org/en/Grade_items#Activity-based_grade_items" target="_blank">更多...</a></p>';
$string['what_does_monitored_mean'] = '監控是什麼意思？';
$string['what_does_monitored_mean_help'] = '<p>此區塊的作用是鼓勵學生有效地管理時間。每個學生都可以監視他們自已在活動或資源中的進度。</p>

<p>在配置的頁面中，您可以看見您已建立用作監視進度區塊的模組清單。如果您在監視此模組的選項中選擇是，將可以監察模組並在進度桿中顯示為小的正方格。';
$string['what_expected_by_means'] = '預期是什麼意思？';
$string['what_expected_by_means_help'] = '<p> <em>預期</em> 日子－時間 是相關活動／資源預期完成的日期 （查看、提交及發佈等）</p>

<p>如果活動已經連結截止日期，如作業的截止日期，只要已勾選了"鎖定至截止日期"的選格，此截止日期可以用作設定為活動預期的完成時間。</p>

<p>當您初次前往進度桿的配置頁面，或您創立了新的活動／資源後返回配置頁面，將會有一個估算預期完成活動／資源的日期及時間。
<ul>
    <li>已設定截止日期的活動，將會使用此截止日期</li>
    <li>當活動是沒有截止日期，但課程是使用星期格式，將會預設為每個星期的結束（在星期天的凌晨前）為截止日期。 </li>
    <li>如果課程不是使用星期格式，將會預設為每個星期的結束（在下一個星期天的凌晨前）為截止日期。</li>
</ul>
</p>一旦設定了預期的日子及時間， 其他截止日期或資訊將會視為無關。</p>';
$string['what_locked_means'] = '鎖定至截止日是指？';
$string['what_locked_means_help'] = '<p> 您可以選擇使用活動的截止日期，或為在進度桿中的活動設定另一個時間。</p>

<p>要鎖定進度桿至活動的截止日期，必須先啟用及設定截止日期。如果已鎖定截止日期，在活動設定中更改截止日期會自動更改在進度桿中的相關時間。</p>

<p>當沒有鎖定截止日期，在進度桿中更改時間及日期將不會影響活動的截止日期。</p>';
$string['what_show_submitted_means'] = '在行動前顯示提交的意思是';
$string['what_show_submitted_means_help'] = '有些活動允許學生提交。當學生已提交，但最後的行動（例如評分）尚未完成，進度桿將會改變顏色以顯示已經提交。';
$string['why_display_now'] = '為什麼您想要隱藏／顯示NOW指示？';
$string['why_display_now_help'] = '<p>不是所有的課程都是集中在指定時間中完成工作。有些課程是開放註冊，允許學生在可以時註冊及完成。</p>
<p>要在課程中使用進度桿，建立"預期"的日子及設置"現在使用"的設定為否。</p>';
$string['why_set_the_title'] = '為什麼您想要設定區塊示例標題？';
$string['why_set_the_title_help'] = '<p>在進度桿中會有多個例子。您可以使用不同的進度桿來監視不同的活動及資源。例如，您可以一個區塊中追踪作業的進度，並在另一個區塊中追踪測驗的進度。因此，您可以取代預設標題及為每個實例設定更合適的區塊標題。';
$string['why_show_precentage'] = '為什麼要顯示學生進度的百分比？';
$string['why_show_precentage_help'] = '< p>可以顯示向學生百分比的進度</ P >

< p>這是在桿的總項數除以項目完成的數量以計算。 </ P>
<P>直到學生將鼠標懸停在桿的一個項目，進度百分比將會出現。 </ P>';
$string['why_use_icons'] = '為什麼你可能需要使用圖標？';
$string['why_use_icons_help'] = '<p>您可以在進度桿增加剔和交叉圖標，使該塊為患有色盲學生更容易可見。 </ P>

<P>這也可能使區塊的含義更清晰，如果你認為顏色是不直觀，無論是文化還是個人原因。 </ P>';
$string['wiki'] = 'Wiki';
$string['workshop'] = '工作室';
$string['wrapafter'] = '當縮進時，限制列到';
