<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   competency
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = '所有下層項目都已完成';
$string['competencies'] = '能力';
$string['competenciesarenotenabled'] = '核心能力未啟用';
$string['competenciessettings'] = '核心能力的各項設定';
$string['completeplanstask'] = '完成已經過期的學習計畫';
$string['coursecompetencyoutcome_complete'] = '完成這核心能力';
$string['coursecompetencyoutcome_evidence'] = '附帶證據';
$string['coursecompetencyoutcome_none'] = '不做任何事';
$string['coursecompetencyoutcome_recommend'] = '送去審查';
$string['coursemodulecompetencyoutcome_complete'] = '完成這核心能力';
$string['coursemodulecompetencyoutcome_evidence'] = '附帶證據';
$string['coursemodulecompetencyoutcome_none'] = '不做任何事';
$string['coursemodulecompetencyoutcome_recommend'] = '送去審查';
$string['deletecompetencyratings'] = '刪除核心能力的評等';
$string['duplicateditemname'] = '{$a} (複製)';
$string['enablecompetencies'] = '啟用核心能力';
$string['enablecompetencies_desc'] = '核心能力活動允許用戶依照學習計畫被評估';
$string['errorcannotchangeapastduedate'] = '這截止日期已經過去了，不能更改。';
$string['errorcannotsetduedateinthepast'] = '這截止日期不能設在過去';
$string['errorcannotsetduedatetoosoon'] = '這截止日太靠近了';
$string['errorcompetencyrule'] = '課程核心能力規則\'{$a}\'有錯誤';
$string['errorcoursecompetencyrule'] = '課程核心能力規則\'{$a}\'有錯誤';
$string['errorinvalidcourse'] = '無效的課程';
$string['errornocompetency'] = '找不到 {$a} 核心能力';
$string['errorplanstatus'] = '學習計畫 \'{$a}\' 狀況有錯誤';
$string['errorscalealreadyused'] = '不能更改這一量尺，因為它已經在使用中';
$string['errorscaleconfiguration'] = '這一量尺需要藉由選出預設的和精熟的項目來被配置';
$string['errorusercomptencystatus'] = '用戶的核心能力狀態 \'{$a}\' 有錯誤';
$string['eventcompetencycreated'] = '已建立核心能力';
$string['eventcompetencydeleted'] = '已刪除核心能力';
$string['eventcompetencyframeworkcreated'] = '已經建立核心能力架構';
$string['eventcompetencyframeworkdeleted'] = '已經刪除核心能力架構';
$string['eventcompetencyframeworkupdated'] = '已經更新核心能力架構';
$string['eventcompetencyframeworkviewed'] = '已經審查核心能力架構';
$string['eventcompetencyupdated'] = '已經更新核心能力';
$string['eventcompetencyviewed'] = '已經審查核心能力';
$string['eventevidencecreated'] = '已經建立證據';
$string['eventplanapproved'] = '已經認可學習計畫';
$string['eventplancompleted'] = '已經完成學習計畫';
$string['eventplancreated'] = '已經建立學習計畫';
$string['eventplandeleted'] = '已經刪除學習計畫';
$string['eventplanreopened'] = '學習計畫已重新開啟';
$string['eventplanreviewrequestcancelled'] = '已經取消學習計畫審查的要求';
$string['eventplanreviewrequested'] = '已經提出學習計畫審查的要求';
$string['eventplanreviewstarted'] = '學習計畫審查已經開始';
$string['eventplanreviewstopped'] = '學習計畫審查已經停止';
$string['eventplanunapproved'] = '學習計畫不被認可';
$string['eventplanunlinked'] = '學習計畫已經取消連結';
$string['eventplanupdated'] = '學習計畫已經更新';
$string['eventplanviewed'] = '學習計畫已經審查';
$string['eventtemplatecreated'] = '已經建立學習計畫樣版';
$string['eventtemplatedeleted'] = '已經刪除學習計畫樣版';
$string['eventtemplateupdated'] = '已經更新學習計畫樣版';
$string['eventtemplateviewed'] = '已經審查學習計畫樣版';
$string['eventusercompetencyplanviewed'] = '已經審查用戶核心能力學習計畫';
$string['eventusercompetencyrated'] = '已經評定用戶核心能力';
$string['eventusercompetencyratedincourse'] = '在課程中被評定的用戶核心能力';
$string['eventusercompetencyratedinplan'] = '在學習計畫中被評定的用戶核心能力';
$string['eventusercompetencyreviewrequestcancelled'] = '已經取消用戶核心能力審查的要求';
$string['eventusercompetencyreviewrequested'] = '已經提出用戶核心能力審查的要求';
$string['eventusercompetencyreviewstarted'] = '已經開始用戶核心能力的審查';
$string['eventusercompetencyreviewstopped'] = '已經停止用戶核心能力的審查';
$string['eventusercompetencyviewed'] = '已經審查用戶的核心能力';
$string['eventusercompetencyviewedincourse'] = '在課程中審查用戶核心能力';
$string['eventusercompetencyviewedinplan'] = '在學習計畫中審查用戶核心能力';
$string['eventuserevidencecreated'] = '已經建立先備學習的證據';
$string['eventuserevidencedeleted'] = '已經刪除先備學習的證據';
$string['eventuserevidenceupdated'] = '已經更新先備學習的證據';
$string['evidence_competencyrule'] = '已經符合這核心能力的規則';
$string['evidence_coursecompleted'] = '已經完成課程 \'{$a}\'';
$string['evidence_coursemodulecompleted'] = '已經完成活動 \'{$a}\'';
$string['evidence_courserestored'] = '這一評等已經伴隨著課程\'{$a}\'被回存';
$string['evidence_evidenceofpriorlearninglinked'] = '先備學習的證據 \'{$a}\' 已經建立連結';
$string['evidence_evidenceofpriorlearningunlinked'] = '先備學習的證據 \'{$a}\' 已經取消連結';
$string['evidence_manualoverride'] = '已經手動設定核心能力的評等';
$string['evidence_manualoverrideincourse'] = '這核心能力的評等已經在課程 \'{$a}\'上以手動方式設定';
$string['evidence_manualoverrideinplan'] = '這核心能力的評等已經在學習計畫 \'{$a}\'上以手動方式設定';
$string['invalidevidencedesc'] = '無效的證據說明';
$string['invalidgrade'] = '無效的評等';
$string['invalidpersistent'] = '無效的硬性規定';
$string['invalidpersistenterror'] = '錯誤：{$a}';
$string['invalidplan'] = '無效的學習計畫';
$string['invalidtaxonomy'] = '無效的分類架構：{$a}';
$string['invalidurl'] = '這網址無效。請確定它是以 \'http://\' 或 \'https://\' 開頭';
$string['planstatusactive'] = '啟用中';
$string['planstatuscomplete'] = '完成';
$string['planstatusdraft'] = '草稿';
$string['planstatusinreview'] = '審查中';
$string['planstatuswaitingforreview'] = '等待審查';
$string['pointsrequiredaremet'] = '已經達到要求的分數';
$string['pushcourseratingstouserplans'] = '把課程評等放入個別學習計畫中';
$string['pushcourseratingstouserplans_desc'] = '當課程核心能力被評等時，在課程設定上是否要更新個別學習計畫';
$string['syncplanscohorts'] = '讓學習計畫和同期的學習計畫樣版同步';
$string['taxonomy_behaviour'] = '行為';
$string['taxonomy_competency'] = '能力';
$string['taxonomy_concept'] = '概念';
$string['taxonomy_domain'] = '領域';
$string['taxonomy_indicator'] = '指標';
$string['taxonomy_level'] = '層次';
$string['taxonomy_outcome'] = '成果';
$string['taxonomy_practice'] = '練習';
$string['taxonomy_proficiency'] = '精熟';
$string['taxonomy_skill'] = '技巧';
$string['taxonomy_value'] = '價值';
$string['usercommentedonacompetency'] = '{$a->fullname}對於這核心能力 "{$a->competency}"所做的評論：

{$a->comment}

See: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} 對這核心能力"{$a->competency}"所做的評論:</p>
<div>{$a->comment}</div>
<p>See: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} 對這核心能力"{$a->competency}"做了評論';
$string['usercommentedonacompetencysubject'] = '在一核心能力上有{$a}篇評論';
$string['usercommentedonaplan'] = '{$a->fullname}對於學習計畫 "{$a->plan}"所做的評論：

{$a->comment}

See: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} 對於學習計畫 "{$a->plan}"所做的評論：</p>
<div>{$a->comment}</div>
<p>See: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} 對於學習計畫 "{$a->plan}"做了評論';
$string['usercommentedonaplansubject'] = '在一學習計畫上有{$a}篇評論';
$string['usercompetencystatus_idle'] = '閒置';
$string['usercompetencystatus_inreview'] = '正在審查';
$string['usercompetencystatus_waitingforreview'] = '等待審查中';
$string['userplans'] = '學習計畫';
