<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   data
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '操作';
$string['add'] = '新增';
$string['addcomment'] = '新增評論';
$string['addentries'] = '新增條目';
$string['addtemplate'] = '新增資料';
$string['advancedsearch'] = '進階搜尋';
$string['allowcomments'] = '允許評論';
$string['alttext'] = '替代文字';
$string['approvalstatus'] = '審核結果';
$string['approve'] = '審核';
$string['approved'] = '已核准';
$string['areacontent'] = '欄位';
$string['ascending'] = '升冪';
$string['asearchtemplate'] = '進階搜尋';
$string['atmaxentry'] = '您輸入的資料量已經超過允許的上限！';
$string['authorfirstname'] = '作者的名字';
$string['authorlastname'] = '作者的姓氏';
$string['autogenallforms'] = '產生所有預設樣板';
$string['autolinkurl'] = '自動連結網址';
$string['availablefromdate'] = '活動開始時間';
$string['availabletags'] = '可用的標籤';
$string['availabletags_help'] = '標籤是樣版裡的預置符號，它將會被資料和其他項目所取代，例如編輯圖示，當資料被編輯和檢視時。

欄位的格式是[[fieldname]]，而其他標籤的格式是##sometag##。

目前的樣版只可以使用出現在"可用的標籤"清單上的標籤，其餘無效。';
$string['availabletodate'] = '活動結束時間';
$string['availabletodatevalidation'] = '關閉的日期不能早於開放的日期';
$string['blank'] = '空白';
$string['buttons'] = '操作';
$string['bynameondate'] = '由 {$a->name} 於 {$a->date}';
$string['calendarend'] = '資料庫 {$a} 關閉';
$string['calendarstart'] = '資料庫 {$a} 開啟';
$string['cancel'] = '取消';
$string['cannotaccesspresentsother'] = '您不能從其他用戶取用範本';
$string['cannotadd'] = '無法加入資料！';
$string['cannotdeletepreset'] = '刪除範本時發生錯誤!';
$string['cannotoverwritepreset'] = '取代範本時發生錯誤!';
$string['cannotunziptopreset'] = '無法解壓縮到這範本目錄';
$string['checkbox'] = '核選方塊';
$string['chooseexportfields'] = '選擇您想要匯出的欄位：';
$string['chooseexportformat'] = '選擇您想要匯出的格式：';
$string['chooseorupload'] = '選擇檔案';
$string['columns'] = '欄位';
$string['comment'] = '評論';
$string['commentdeleted'] = '評論刪除了';
$string['commentempty'] = '評論是空白的';
$string['comments'] = '評論';
$string['commentsaved'] = '評論儲存了';
$string['commentsn'] = '{$a}個評論';
$string['commentsoff'] = '評論功能沒有被取用';
$string['configenablerssfeeds'] = '這個開關可以啟用所有資料庫的RSS彙集，但您仍需要在每一個資料庫中以手動方式啟用它。';
$string['confirmdeletefield'] = '您確定要刪除這個欄位？';
$string['confirmdeleterecord'] = '您確定要刪除這筆資料嗎？';
$string['confirmdeleterecords'] = '您確定要刪除這些資料嗎？';
$string['csstemplate'] = 'CSS';
$string['csvfailed'] = '無法從這CSV檔讀取原始資料';
$string['csvfile'] = 'CSV 檔案';
$string['csvimport'] = '匯入 CSV 檔案';
$string['csvimport_help'] = '資料庫資料可以用純文字格式的檔案匯入。

檔案的第一行是一系列的欄位名稱，以逗點隔開。第二行以後就是實際的資料，每一行一筆資料(紀錄)。';
$string['csvwithselecteddelimiter'] = '<acronym title="Comma Separated Values">CSV</acronym> 文字，分隔符號為：';
$string['data:addinstance'] = '新增一個資料庫';
$string['data:approve'] = '審核或駁回資料紀錄';
$string['data:comment'] = '撰寫評論';
$string['data:exportallentries'] = '匯出所有資料庫資料';
$string['data:exportentry'] = '匯出一筆資料庫資料';
$string['data:exportownentry'] = '匯出自己的資料庫資料';
$string['data:exportuserinfo'] = '匯出用戶資訊';
$string['data:managecomments'] = '管理評論';
$string['data:manageentries'] = '管理資料';
$string['data:managetemplates'] = '管理樣板';
$string['data:manageuserpresets'] = '管理所有資料庫範本';
$string['data:rate'] = '評比資料';
$string['data:readentry'] = '閱讀資料';
$string['data:view'] = '檢視資料庫活動';
$string['data:viewallratings'] = '檢視所有個人做的原始評比';
$string['data:viewalluserpresets'] = '檢視所有用戶的範本';
$string['data:viewanyrating'] = '檢視任何人收到的全部評比';
$string['data:viewentry'] = '檢視資料';
$string['data:viewrating'] = '檢視你得到的全部評比';
$string['data:writeentry'] = '填寫資料';
$string['date'] = '日期';
$string['dateentered'] = '輸入的日期';
$string['defaultfielddelimiter'] = '(預設是逗點字元)';
$string['defaultfieldenclosure'] = '(預設為無)';
$string['defaultsortfield'] = '預設排序欄位';
$string['delcheck'] = '批次刪除核選方塊';
$string['delete'] = '刪除';
$string['deleteallentries'] = '刪除所有資料';
$string['deletecomment'] = '您確定要刪除這個評論';
$string['deleted'] = '已刪除';
$string['deletefield'] = '刪除現有欄位';
$string['deletenotenrolled'] = '刪除未修課者提供的資料';
$string['deletewarning'] = '您確定要刪除這個範本嗎？';
$string['descending'] = '降冪';
$string['directorynotapreset'] = '{$a->directory} 不是範本：缺少檔案： {$a->missing_files}';
$string['disapprove'] = '取消核准';
$string['download'] = '下載';
$string['edit'] = '編輯';
$string['editcomment'] = '編輯評論';
$string['editentry'] = '編輯資料';
$string['editordisable'] = '停用編輯器';
$string['editorenable'] = '啟用編輯器';
$string['emptyadd'] = '新增樣板為空白，從預設格式產生...';
$string['emptyaddform'] = '您沒有填入任何欄位！';
$string['enabletemplateeditorcheck'] = '你確定要啟用這編輯器？這可能導致當這樣版被儲存時，它的內容被改變。';
$string['entries'] = '資料';
$string['entrieslefttoadd'] = '在您要瀏覽其他同學提供的資料前，您必須要再新增{$a->entriesleft} 筆資料。';
$string['entrieslefttoaddtoview'] = '您必須新增{$a->entriesleft}筆以上資料，才能夠看到其他同學提供的資料。';
$string['entry'] = '資料';
$string['entrysaved'] = '您的資料已經儲存了';
$string['errormustbeteacher'] = '只有教師身份可以使用這個頁面！';
$string['errormustsupplyvalue'] = '這裡你必須提供一個數值。';
$string['errorpresetexists'] = '已經有一範本使用您選用的名稱';
$string['eventfieldcreated'] = '已建立欄位';
$string['eventfielddeleted'] = '已刪除欄位';
$string['eventfieldupdated'] = '已更新欄位';
$string['eventrecordcreated'] = '已建立紀錄';
$string['eventrecorddeleted'] = '已刪除紀錄';
$string['eventrecordupdated'] = '已更新紀錄';
$string['eventtemplateupdated'] = '已更新樣板';
$string['eventtemplateviewed'] = '已檢視樣板';
$string['example'] = '資料庫模組範例';
$string['excel'] = 'Excel';
$string['expired'] = '抱歉，這活動已經在 {$a}關閉，已經無法使用。';
$string['export'] = '匯出';
$string['exportaszip'] = '匯出為壓縮檔';
$string['exportaszip_help'] = '匯出成壓縮檔的功能，允許您儲存樣版和欄位成一個範本壓縮檔，以便下載。然後這壓縮檔可匯入到另一課程中使用。';
$string['exportedtozip'] = '匯出成暫時的zip壓縮檔案...';
$string['exportentries'] = '匯出資料';
$string['exportownentries'] = '只匯出您自己的資料？ ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = '刪除範本時發生錯誤！';
$string['fieldadded'] = '欄位新增了';
$string['fieldallowautolink'] = '允許自動連結';
$string['fielddeleted'] = '欄位刪除了';
$string['fielddelimiter'] = '欄位分隔字元';
$string['fielddescription'] = '欄位說明';
$string['fieldenclosure'] = '欄位附件';
$string['fieldheight'] = '高度';
$string['fieldheightlistview'] = '列表高度';
$string['fieldheightsingleview'] = '單筆檢視的高度';
$string['fieldids'] = '欄位編號';
$string['fieldmappings'] = '欄位對應';
$string['fieldmappings_help'] = '這一選單讓你從現有的資料庫中保留資料。要保留在一欄位裡的資料，你必須將它對應到這一資料將會出現新欄位上。任何欄位也都可以留空白，這樣將沒有資料拷貝過去。任何舊欄位沒有對應到新欄位上，這欄位將會失去，且資料也會被移除。

你只可以將相同類型的欄位相對應，因此每一下拉選單會有不同的欄位在裡面。還有，必須小心，不可以將一個舊欄位對應到多個新欄位上。';
$string['fieldname'] = '欄位名稱';
$string['fieldnotmatched'] = '這資料庫不認識在你的檔案裡的下列欄位： {$a}';
$string['fieldoptions'] = '選項(每行一個)';
$string['fields'] = '欄位';
$string['fieldupdated'] = '欄位更新了';
$string['fieldwidth'] = '寬度';
$string['fieldwidthlistview'] = '列表寬度';
$string['fieldwidthsingleview'] = '單筆檢視的寬度';
$string['file'] = '檔案';
$string['fileencoding'] = '編碼';
$string['filesnotgenerated'] = '並非所有檔案都是產生的： {$a}';
$string['filtername'] = '資料庫自動連結';
$string['footer'] = '頁尾';
$string['forcelinkname'] = '強制為連結取名';
$string['foundnorecords'] = '沒有找到記錄 (<a href="<b>{$a->reseturl}</b>">重設篩選器</a>)';
$string['foundrecords'] = '找到記錄資料： <b>{$a->num}</b>/<b>{$a->max}</b> (<a href="<b>{$a->reseturl}</b>">重設篩選器</a>)';
$string['fromfile'] = '從壓縮檔案匯入';
$string['fromfile_help'] = '從壓縮檔匯入的功能，讓你能瀏覽並上傳一個樣版和欄位的範本壓縮檔。';
$string['generateerror'] = '不是所有的檔案被產生!';
$string['header'] = '頁首';
$string['headeraddtemplate'] = '新增資料樣版：訂定新增編輯資料的畫面編排';
$string['headerasearchtemplate'] = '進階搜尋樣版：訂定進階搜尋的畫面編排';
$string['headercsstemplate'] = 'CSS 樣版：訂定其他樣版使用的本地CSS樣式';
$string['headerjstemplate'] = 'Javascript樣版：為其他樣版自訂 Javascript';
$string['headerlisttemplate'] = '條列資料樣版：訂定多筆資料瀏覽的畫面編排';
$string['headerrsstemplate'] = 'RSS樣版：定義RSS彙集資料的顯示方式';
$string['headersingletemplate'] = '單筆檢視樣版：訂定單筆資料顯示的畫面編排';
$string['importentries'] = '匯入資料';
$string['importsuccess'] = '範本已套用成功。';
$string['includeapproval'] = '包含審核狀態';
$string['includetime'] = '包含加入或修改時間';
$string['includeuserdetails'] = '包含用戶資料';
$string['insufficiententries'] = '需要提供更多的資料才能檢視這個資料庫';
$string['intro'] = '描述';
$string['invalidaccess'] = '這一頁面沒有被正確地存取';
$string['invalidfieldid'] = '欄位編號不正確';
$string['invalidfieldname'] = '請選擇另一個欄位名稱';
$string['invalidfieldtype'] = '欄位類型不正確';
$string['invalidid'] = '不正確的資料編號';
$string['invalidpreset'] = '{$a}不是一個範本';
$string['invalidrecord'] = '不正確的紀錄';
$string['invalidurl'] = '輸入的網址無效';
$string['jstemplate'] = 'Javascript';
$string['latitude'] = '緯度';
$string['latlong'] = '緯度/經度';
$string['latlongboth'] = '緯度和經度兩者都要填寫';
$string['latlongdownloadallhint'] = '把所有的資料連結下載為KML文件';
$string['latlongkmllabelling'] = '怎樣在KML文件中標出內容(Google Earth)';
$string['latlonglinkservicesdisplayed'] = '連結外部服務來顯示';
$string['latlongotherfields'] = '其他欄位';
$string['list'] = '條列';
$string['listtemplate'] = '條列資料';
$string['longitude'] = '經度';
$string['manageapproved'] = '允許編輯已經核准的條目';
$string['manageapproved_help'] = '若關閉，用戶不能再編輯或刪除他自己的，但已通過審核的條目。這一設定只有在資料被設定為需要審核時才會發生作用。預設為允許編輯。';
$string['mapexistingfield'] = '對應到{$a}';
$string['mapnewfield'] = '建立一新欄位';
$string['mappingwarning'] = '所有沒對應新欄位的舊欄位將會遺失，其中的資料也會移除。';
$string['maxentries'] = '資料筆數上限';
$string['maxentries_help'] = '資料數上限是指學生在這一活動所允許繳交的最大數量。';
$string['maxsize'] = '檔案上限';
$string['menu'] = '選單';
$string['menuchoose'] = '選擇...';
$string['missingdata'] = '資料編號或物件必須提供欄位群';
$string['missingfield'] = '錯誤：當你定義欄位群時，你必須指明欄位和/或資料。';
$string['modulename'] = '資料庫';
$string['modulename_help'] = '資料庫活動模組能讓學生建立、維護和搜尋一大堆的資料(紀錄)。這些條目由教師訂定一些欄位組成。欄位類型包括：核選方塊、選項按鈕、下拉選單、多行文字、網址、圖片、經緯度、上傳檔案等欄位。

當學生在列表、檢視、或編輯資料庫資料時，資料的視覺編排設計是可以由資料庫樣版來控制。資料庫活動可以透過範本讓不同的課程彼此共用，而且教師可以匯入和匯出資料庫資料(紀錄)。

如果資料庫自動鏈結過濾器被啟用，在資料庫的任何筆資料將會自動鏈結，如果這些字或片語出現在課程的任何地方。

教師可以對資料評論。每筆資料也可以由老師評分或由學生評比(同儕互評)。評比結果可以彙整形成最後分數，並記錄到成績簿上。

資料庫活動有許多應用方式，例如：

* 全班合作性的以共同格式蒐集網站鏈結、書籍、參考文獻、CD等。
* 用來展示學生的攝影作品、海報、網站或詩詞，讓同儕彼此評論、和觀摩。';
$string['modulenameplural'] = '資料庫';
$string['more'] = '更多';
$string['moreurl'] = '更多網址';
$string['movezipfailed'] = '無法搬移壓縮檔案';
$string['multientry'] = '重複的資料';
$string['multimenu'] = '選單(多選)';
$string['multipletags'] = '找到多個標籤！樣板未儲存';
$string['namecheckbox'] = '勾選格欄位';
$string['namedate'] = '日期欄位';
$string['namefile'] = '檔案欄位';
$string['namelatlong'] = '經度/緯度欄位';
$string['namemenu'] = '選單欄位';
$string['namemultimenu'] = '多選';
$string['namenumber'] = '數字欄位';
$string['namepicture'] = '圖片欄位';
$string['nameradiobutton'] = '圓形按鈕欄位';
$string['nametext'] = '文字欄位';
$string['nametextarea'] = '文字區域欄位';
$string['nameurl'] = '網址欄為';
$string['newentry'] = '新資料';
$string['newfield'] = '建立新欄位';
$string['newfield_help'] = '欄位是資料庫中用來輸入與存放資料的位置。在資料課活動中的每一個條目可以有多種類型的多個欄位，比如，日期欄位，它讓用戶可以從一下拉選單中選擇年、月、日的數字。而圖片欄位，它允許用戶上傳一圖像檔。核選方塊，允許用戶勾選一或二個選項。

每一欄位必須有獨一無二的名稱，但欄位說明描述是選填的。';
$string['noaccess'] = '您沒有存取這個頁面的權限';
$string['nodefinedfields'] = '新範本沒有定義欄位！';
$string['nofieldcontent'] = '找不到欄位內容';
$string['nofieldindatabase'] = '目前這個資料庫沒有定義任何欄位。';
$string['nolisttemplate'] = '條列資料的樣版尚未訂定';
$string['nomatch'] = '找不到符合的資料！';
$string['nomaximum'] = '沒有上限';
$string['norecords'] = '資料庫中沒有資料';
$string['nosingletemplate'] = '尚未定義單一樣版';
$string['notapproved'] = '資料尚未審核。';
$string['notinjectivemap'] = '不是一個可插入的地圖';
$string['notopenyet'] = '抱歉，這一活動要等到{$a}才開始';
$string['number'] = '數量';
$string['numberrssarticles'] = '在RSS彙集中的文章篇數';
$string['numnotapproved'] = '等待中';
$string['numrecords'] = '{$a} 筆資料';
$string['ods'] = '<acronym title="OpenDocument Spreadsheet">ODS</acronym> (OpenOffice)';
$string['optionaldescription'] = '簡述(選)';
$string['optionalfilename'] = '檔名(選)';
$string['other'] = '其他';
$string['overrwritedesc'] = '如果已經存在將取代舊範本';
$string['overwrite'] = '取代';
$string['overwritesettings'] = '取代目前的設定';
$string['page-mod-data-x'] = '任何資料庫活動模組頁面';
$string['pagesize'] = '每頁資料筆數';
$string['participants'] = '參與者';
$string['picture'] = '圖片';
$string['pleaseaddsome'] = '請在下面新增一些欄位或是由<a href="{$a}">選擇一個範本</a>開始。';
$string['pluginadministration'] = '資料庫活動管理';
$string['pluginname'] = '資料庫';
$string['portfolionotfile'] = '匯出到學習歷程檔案，而不是一個檔案(只限 CSV 和 leap2a)';
$string['presetinfo'] = '儲存為範本將會發佈這個範本。這樣其他用戶就可以在他們的資料庫中使用它。';
$string['presets'] = '範本';
$string['radiobutton'] = '選項按鈕';
$string['recordapproved'] = '資料已審核';
$string['recorddeleted'] = '資料已刪除';
$string['recorddisapproved'] = '不可進入';
$string['recordsnotsaved'] = '沒有資料儲存，請檢查上傳檔案的格式。';
$string['recordssaved'] = '資料儲存了';
$string['requireapproval'] = '需要老師審核';
$string['requireapproval_help'] = '如果啟用，資料需要由教師審核之後，才能讓每個人看到。';
$string['required'] = '必要的';
$string['requiredentries'] = '完成活動需要的資料筆數';
$string['requiredentries_help'] = '每一學生需要提供的資料筆數，達到之後活動才算完成。';
$string['requiredentriestoview'] = '可瀏覽前需要的資料筆數';
$string['requiredentriestoview_help'] = '每一學生需要繳交該數量的資料之後，才可以看到其他學生提供的資料。
注意：若要先填寫提供資料後才可查看他人的，那資料庫的自動鏈結應該關閉。這是因為資料庫自動連結過濾器無法確認用戶是否有繳交足夠筆數的資料。';
$string['requiredfield'] = '必要的欄位';
$string['resetsettings'] = '重設欄位';
$string['resettemplate'] = '重設樣板';
$string['resizingimages'] = '調整縮圖大小...';
$string['rows'] = '列';
$string['rssglobaldisabled'] = '停用，檢視網站設定變數。';
$string['rsstemplate'] = 'RSS';
$string['rsstitletemplate'] = 'RSS標題樣板';
$string['save'] = '儲存';
$string['saveandadd'] = '儲存後新增';
$string['saveandview'] = '儲存後檢視';
$string['saveaspreset'] = '儲存為範本';
$string['saveaspreset_help'] = '儲存為範本的功能，可以將樣版和欄位發佈為一個範本，讓網站上的其他人可以使用。(你可以隨時從範本的清單上刪除它)';
$string['savesettings'] = '儲存設定';
$string['savesuccess'] = '儲存成功，您的範本現在整個網站都可以使用了。';
$string['savetemplate'] = '儲存樣板';
$string['search'] = '搜尋';
$string['search:activity'] = '資料庫 --活動訊息';
$string['search:entry'] = '資料庫 --條目';
$string['selectedrequired'] = '所有必要的選擇';
$string['showall'] = '顯示所有資料';
$string['single'] = '單筆';
$string['singletemplate'] = '單筆檢視';
$string['subplugintype_datafield'] = '資料庫欄位類型';
$string['subplugintype_datafield_plural'] = '資料庫欄位類型';
$string['subplugintype_datapreset'] = '範本';
$string['subplugintype_datapreset_plural'] = '範本';
$string['teachersandstudents'] = '{$a->teachers} 與 {$a->students}';
$string['templates'] = '樣板';
$string['templatesaved'] = '樣板儲存了';
$string['text'] = '文字';
$string['textarea'] = '多行文字';
$string['timeadded'] = '新增的時間';
$string['timemodified'] = '修改的時間';
$string['todatabase'] = '到此資料庫。';
$string['type'] = '欄位類型';
$string['undefinedprocessactionmethod'] = '在 Data_Preset 沒有定義動作方法來處理動作 "{$a}"。';
$string['unsupportedexport'] = '(<b>{$a->fieldtype}</b>) 無法匯出。';
$string['updatefield'] = '更新現有欄位';
$string['uploadfile'] = '上傳檔案';
$string['uploadrecords'] = '從檔案上傳資料';
$string['uploadrecords_help'] = '資料可以經由文字檔上傳。檔案格式必須如下：

* 第一筆紀錄包含一系列的欄位名稱，定義了其後的資料格式。
* 在第一行之後，每一行代表一筆資料(紀錄)
* 每一筆紀錄包含一系列資料，以逗點(或其他分隔符號)隔開，每樣資料都對應第一行的欄位名稱。';
$string['url'] = '網址';
$string['usedate'] = '包含在搜尋中';
$string['usestandard'] = '採用一個範本';
$string['usestandard_help'] = '要使用一個可用於整個網站的範本，請從這清單選擇它。(若你曾使用"儲存為範本"的功能來新增範本到清單上，那麼你有刪除它的選項可以使用)。';
$string['viewfromdate'] = '開始只能閱讀';
$string['viewtodate'] = '結束只能閱讀';
$string['viewtodatevalidation'] = '唯讀的結束日期不能早於開始日期';
$string['wrongdataid'] = '提供的資料編號有誤';
