<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'dataform', language 'zh_tw', branch 'MOODLE_30_STABLE'
 *
 * @package   dataform
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acccesstypesnotfound'] = '抱歉，存取形式並未安裝或啟用。請聮絡您的管理員了解細節。';
$string['access'] = '存取';
$string['accessadd'] = '新增存取內容';
$string['accessedit'] = '編輯\'{$a}\\';
$string['accessenabled'] = '啟用';
$string['accessnew'] = '新{$a}';
$string['actions'] = '輸入活動';
$string['activityadministration'] = '活動管理';
$string['activityicon'] = '活動圖示';
$string['activityicon_help'] = '您可上傳影像檔來取代資料格式預設的活動圖示，它會顯示在課程頁面，在活動連結旁。';
$string['alignment'] = '排列';
$string['and'] = '且';
$string['andor'] = '且/或';
$string['anonymousentries'] = '允許匿名輸入';
$string['anonymousentries_help'] = '如果啟用訪客及未登錄之選項，使用者即能活動中輸入東西。
此處訪客如需"連絡我們"，即可傳送要求。此選項必須由管理員於模組中設定。';
$string['ascending'] = '順序';
$string['author'] = '作者';
$string['authorinfo'] = '作者資料';
$string['availablefrom'] = '可從';
$string['availableplugins'] = '可用外掛程式';
$string['availableto'] = '可以';
$string['between'] = '介於';
$string['browse'] = '瀏覽';
$string['cancel'] = '取消';
$string['cancelbutton'] = '取消';
$string['cancelbutton_help'] = '取消繳交並返回檢視';
$string['cancelbutton_label'] = '取消鍵';
$string['characterpatterns'] = '角色樣式';
$string['characterpatterns_help'] = '字母模式';
$string['columns'] = '欄位';
$string['comment'] = '意見';
$string['commentadd'] = '新增意見';
$string['commentbynameondate'] = '由 {$a->name} - {$a->date}';
$string['commentdelete'] = '您確定要刪除此意見?';
$string['commentdeleted'] = '意見已刪除';
$string['commentedit'] = '編修意見';
$string['commentempty'] = '意見空白';
$string['commentinputtype'] = '意見輸入形式';
$string['comments'] = '意見';
$string['commentsallow'] = '允許意見?';
$string['commentsaved'] = '竟見已存';
$string['commentsn'] = '{$a} 評語';
$string['commentsnone'] = '沒意見';
$string['completionentries'] = '參加者需新輸入：';
$string['completionentriesgroup'] = '要求輸入';
$string['completionentrieshelp'] = '要求完成輸入';
$string['completionspecificgrade'] = '參加者必須接受評分';
$string['completionspecificgradegroup'] = '要求特殊評分';
$string['completionspecificgradehelp'] = '要求特定年級完成。';
$string['configanonymousentries'] = '這個開關打開可允許訪客或匿名使用者輸入各式資料。設定時您仍需手動開啟，允許匿名使用者輸入各種格式資料。';
$string['configenablerssfeeds'] = '這個開關打開可允許RSS回饋各式資料。設定時您仍須於資料格式處新增RSS檢視以便產生回饋。';
$string['configmaxentries'] = '此項數值決定您可以加到資料格式最多活動可以有幾個條目。';
$string['configmaxfields'] = '此項數值決定您可以加到資料格式活動最多可以有幾個區域。';
$string['configmaxfilters'] = '此項數值決定您可以加到資料格式活動最多可以有過濾器幾個。';
$string['configmaxviews'] = '此項數值決定您可以加到資料格式活動裡最多可以有幾個檢視。';
$string['configmultigradeitems'] = '在資料表活動設定為 ‘是’ 來允許多個評級項目。';
$string['configplugins'] = '請啟用全部所需的外掛，且予以適當的排列。';
$string['contains'] = '包含';
$string['contentview'] = '視窗內容';
$string['conversation'] = '對話。';
$string['correct'] = '正確。';
$string['csscode'] = 'CSS代碼';
$string['cssinclude'] = 'CSS';
$string['cssincludes'] = '包括外置 CSS';
$string['csssaved'] = 'CSS已儲存';
$string['cssupload'] = '上傳css檔案。';
$string['csvdelimiter'] = '分隔符';
$string['csvenclosure'] = '結束。';
$string['csvfailed'] = '無法由csv格式的檔案讀到原始資料。';
$string['csvoutput'] = '以csv格式匯出';
$string['csvsettings'] = 'CSV 設定';
$string['csvwithselecteddelimiter'] = '<acronym title=\\"Comma Separated Values\\">CSV</acronym> 已選取的分隔符文字:';
$string['dataform:addinstance'] = '新增資料格式';
$string['dataform:approve'] = '** 被反對 **';
$string['dataform:comment'] = '** 被反對 **';
$string['dataformearly'] = '此活動計劃開始 {$a}';
$string['dataform:entryanonymousadd'] = '匿名輸入 - 新增';
$string['dataform:entryanonymousdelete'] = '匿名輸入 - 移除';
$string['dataform:entryanonymousexport'] = '匿名輸入 - 輸出';
$string['dataform:entryanonymousupdate'] = '匿名輸入 - 更新';
$string['dataform:entryanonymousview'] = '匿名輸入 - 檢視';
$string['dataform:entryanyadd'] = '任何輸入 - 新增';
$string['dataform:entryanydelete'] = '任何輸入 - 移除';
$string['dataform:entryanyexport'] = '任何輸入 - 輸出';
$string['dataform:entryanyupdate'] = '任何輸入 - 更新';
$string['dataform:entryanyview'] = '任何輸入 - 檢視';
$string['dataform:entryearlyadd'] = '早期輸入 - 新增';
$string['dataform:entryearlydelete'] = '早期輸入 - 移除';
$string['dataform:entryearlyupdate'] = '早期輸入 - 更新';
$string['dataform:entryearlyview'] = '早期輸入 - 檢視';
$string['dataform:entrygroupadd'] = '群組輸入 - 新增';
$string['dataform:entrygroupdelete'] = '群組輸入 - 移除';
$string['dataform:entrygroupexport'] = '群組輸入 - 輸出';
$string['dataform:entrygroupupdate'] = '群組輸入 - 更新';
$string['dataform:entrygroupview'] = '群組輸入 - 檢視';
$string['dataform:entrylateadd'] = '晚期輸入 - 新增';
$string['dataform:entrylatedelete'] = '晚期輸入 - 移除';
$string['dataform:entrylateupdate'] = '晚期輸入 - 更新';
$string['dataform:entrylateview'] = '晚期輸入 - 檢視';
$string['dataform:entryownadd'] = '自己輸入 - 新增';
$string['dataform:entryowndelete'] = '自己輸入 - 移除';
$string['dataform:entryownexport'] = '自己輸入 - 輸出';
$string['dataform:entryownupdate'] = '自己輸入 - 更新';
$string['dataform:entryownview'] = '自己輸入 - 檢視';
$string['dataform:exportallentries'] = '** 被反對 **';
$string['dataform:exportentry'] = '** 被反對 **';
$string['dataform:exportownentry'] = '** 被反對 **';
$string['dataform:indexview'] = '檢視索引';
$string['dataform:manageaccess'] = '管理進入規限';
$string['dataform:managecomments'] = '** 被反對 **';
$string['dataform:managecss'] = '管理 css';
$string['dataform:manageentries'] = '管理資料輸入';
$string['dataform:managefields'] = '管理字段';
$string['dataform:managefilters'] = '管理篩選器';
$string['dataform:managejs'] = '管理 js';
$string['dataform:managenotifications'] = '管理通知設定';
$string['dataform:managepresets'] = '管理預設';
$string['dataform:manageratings'] = '** 被反對 **';
$string['dataform:managetemplates'] = '管理模板';
$string['dataform:managetools'] = '管理工具';
$string['dataform:manageviews'] = '管理瀏覽';
$string['dataform:messagingview'] = '觀看訊息';
$string['dataformnew'] = '新資料格式';
$string['dataformnone'] = '無資料格式';
$string['dataformnotready'] = '此項活動尚未能檢視';
$string['dataformpastdue'] = '此項活動已經過期 {$a}';
$string['dataform:presetsviewall'] = '檢視所有用戶的預設';
$string['dataform:rate'] = '** 被反對 **';
$string['dataform:ratingsview'] = '** 被反對 **';
$string['dataform:ratingsviewall'] = '** 被反對 **';
$string['dataform:ratingsviewany'] = '** 被反對 **';
$string['dataform:viewaccess'] = '檢視 - 進入';
$string['dataform:viewaccessdisabled'] = '檢視 - 禁止進入';
$string['dataform:viewaccessearly'] = '檢視 - 預先進入';
$string['dataform:viewaccesshidden'] = '檢視';
$string['dataform:viewaccesslate'] = '檢視 - 延遲進入';
$string['dataform:viewanonymousentry'] = '** 被反對 **';
$string['dataform:viewentry'] = '** 被反對 **';
$string['dataform:viewfilteroverride'] = '檢視 - 篩選器無效';
$string['dataform:writeentry'] = '** 被反對 **';
$string['deleteactivity'] = '移除活動';
$string['deletenotenrolled'] = '移除未註冊用戶的輸入';
$string['descending'] = '倒序';
$string['dfupdatefailed'] = '無法更新資料格式';
$string['documenttype'] = '文件類型';
$string['dots'] = '。。。';
$string['download'] = '下載';
$string['editing'] = '編輯';
$string['editordisable'] = '禁止編輯';
$string['editorenable'] = '允許編輯';
$string['email'] = '電子郵件';
$string['embed'] = '嵌入';
$string['embedded'] = '嵌入';
$string['embedded_help'] = '所選的內聯視窗可透過 iframe 嵌入到課程頁面中, 以允許與視窗互動而留在課程頁面。';
$string['empty'] = '空白';
$string['enabled'] = '啟用';
$string['entries'] = '輸入';
$string['entriesadded'] = '{$a} 新增輸入';
$string['entriesconfirmadd'] = '你即將複製 {$a} 資料，確認複製？';
$string['entriesconfirmdelete'] = '你即將移除 {$a} 資料，確認移除？';
$string['entriesconfirmduplicate'] = '你即將複製 {$a} 資料，確認複製？';
$string['entriesconfirmupdate'] = '你即將更新 {$a} 資料，確認更新？';
$string['entriescount'] = '{$a} 條目';
$string['entriesdeleteall'] = '移除所有條目';
$string['entriesdeleted'] = '{$a} 資料已移除';
$string['entriesduplicated'] = '{$a} 資料已複製';
$string['entriesfound'] = '{$a} 資料已找到';
$string['entriesimport'] = '輸入資料';
$string['entrieslefttoadd'] = '你必須輸入 {$a} 更多資料來完成這項活動。';
$string['entrieslefttoaddtoview'] = '你必須輸入 {$a} 更多資料來瀏覽其他參與者輸入的資料。';
$string['entriesmanager'] = '資料管理員';
$string['entriesmax'] = '最大輸入量';
$string['entriesmax_help'] = '沒有資料管理權的用戶可以新增到活動中的最大輸入量。
<ul>
<li><b>-1:</b> 容許的輸入量沒有限制。
<li><b> 0:</b> 不准輸入。
<li><b> N:</b> 允許 N 項輸入 (其中N是任何正數，例如10).
</ul>如果活動有間隔，則該數字適用於每個間隔，而整項活動的最大條目數是該數乘以間隔數。';
$string['entriesnotsaved'] = '沒有儲存輸入。請檢查上載文件的類型。';
$string['entriespending'] = '待定';
$string['entriesrequired'] = '必須輸入';
$string['entriesrequired_help'] = '沒有資料管理權的用戶需要輸入的條目數以完成該活動（在考慮其他條件如評級）。如果活動有間隔，則該數字適用於每個間隔，而整項活動需要輸入的條目數是該數乘以間隔數。';
$string['entriessaved'] = '{$a} 輸入已儲存';
$string['entriesupdated'] = '{$a} 輸入已更新';
$string['entry'] = '輸入';
$string['entryaddmultinew'] = '新增輸入';
$string['entryaddnew'] = '新增輸入';
$string['entryinfo'] = '輸入資料';
$string['entrynew'] = '新條目';
$string['entrynoneforaction'] = '就你的請求，沒有找到任何條目。';
$string['entrynoneindataform'] = '資料格式中無文字';
$string['entryrating'] = '條目評級';
$string['entrysaved'] = '你的輸入已經儲存';
$string['entrysettings'] = '輸入設定';
$string['entrysettingsupdated'] = '輸入設定已更新';
$string['entrytemplate'] = '輸入模板';
$string['entrytemplate_help'] = '此輸入模板容許你確定用於瀏覽和編輯的條目的內容、功能和一般佈局。此模板通常包含用於顯示和更新條目內容的字段元素。 當創建新視圖時，包含基本字段樣式，編輯和移除功能的預設佈局會自動顯示於模板。你可以根據需要添加或移除樣式。WYSIWYG編輯器還允許您裝飾模板，並利用顏色，字體和圖像建立自己的形象。';
$string['entrytimelimit'] = '正在編輯時間限制（分鐘）';
$string['entrytimelimit_help'] = '沒有資料管理權的用戶可更新或移除新條目的時間限制（分鐘）。
<ul>
<li><b>-1:</b> 沒有限制。
<li><b>&nbsp;0:</b> 遞交後，輸入的資料不能更新或移除。
<li><b>&nbsp;N:</b> 於N分鐘內輸入的資料可以更新或移除（當中N是任可正數例如30）。
</ul>';
$string['equal'] = '等於';
$string['err_lowername'] = '名稱不能包含大寫字母。';
$string['error:cannotbenegative'] = '數值不能是負數。';
$string['errorinvalidtimeto'] = '結束時間至必須晚於開始時間';
$string['errornoitemsselected'] = '至少需選擇一個項目';
$string['event'] = '事件';
$string['event_entry_created'] = '新增的條目';
$string['event_entry_deleted'] = '已移除的條目';
$string['event_entry_updated'] = '已更新的條目';
$string['event_field_content_updated'] = '字段內容已更新';
$string['event_field_created'] = '已新增的條目';
$string['event_field_deleted'] = '已移除的條目';
$string['event_field_updated'] = '已更新的條目';
$string['event_filter_created'] = '已新增的篩選';
$string['event_filter_deleted'] = '已移除的篩選';
$string['event_filter_updated'] = '已更新的篩選';
$string['events'] = '事件';
$string['event_view_created'] = '已新增的視圖';
$string['event_view_deleted'] = '已移除的視圖';
$string['event_view_updated'] = '已更新的視圖';
$string['event_view_viewed'] = '已進入的視圖';
$string['export'] = '輸出';
$string['exportcontent'] = '輸出內容';
$string['field'] = '字段';
$string['fieldadd'] = '添加字段';
$string['fieldallowautolink'] = '允許自動連接';
$string['fieldapplydefault'] = '編輯時應用預設值';
$string['fieldattributes'] = 'Field attributes';
$string['fieldcreate'] = '添加新欄位';
$string['fielddefaultany'] = '任何條目';
$string['fielddefaultcontent'] = '預設內容';
$string['fielddefaultnew'] = '只允許新條目';
$string['fielddefaultvalue'] = '預設值';
$string['fielddescription'] = '欄位描述';
$string['fieldedit'] = '編輯 \'{$a}\\';
$string['fieldeditable'] = '可編輯';
$string['fieldids'] = '欄位編號';
$string['fieldmappings'] = '欄位追蹤';
$string['fieldname'] = '欄位名稱';
$string['fieldnew'] = '新 {$a} 欄位';
$string['fieldnoneforaction'] = '沒有找到任何欄位符合你的要求';
$string['fieldnoneindataform'] = '在這數據形式中並沒有被定義的欄位';
$string['fieldnonematching'] = '沒有找到適合的欄位';
$string['fieldnotmatched'] = '您的檔案中的以下字段並沒有紀錄在此數據表: {$a}';
$string['fieldpatterns'] = '條目模式';
$string['fieldpatterns_help'] = '其內容對輸入有反應的模式';
$string['fieldplugins'] = '字段外掛程式';
$string['fieldrequired'] = '你必須提供一個數目';
$string['fieldrules'] = '字段編輯規則';
$string['fields'] = '字段';
$string['fieldsadded'] = '新增的字段';
$string['fieldsconfirmdelete'] = '你即將移除 {$a} 字段，確認移除？';
$string['fieldsconfirmduplicate'] = '你即將複製 {$a} 字段，確認複製？';
$string['fieldsdeleted'] = '字段已移除，你或需要更新預設排序設置。';
$string['fieldsinternal'] = '內部字段';
$string['fieldsmax'] = '最多字段';
$string['fieldsnonedefined'] = '未定義字段';
$string['fieldsupdated'] = '字段已更新';
$string['fieldtemplate'] = '模板';
$string['fieldtemplate_help'] = '欄位模板允許通過[[fieldname @]]欄位模式將指定的欄位標籤添加到視圖。此欄位模式會監察欄位顯示，如果該欄位設置為隱藏，該欄位模式也將被隱藏。此欄位模板也可以用作欄位顯示模板，當列入在標籤中，模板會對該欄位的模式進行分析。例如，使用一個名為「Number」的數字欄位，並將欄位標籤定義為「您已賺取[[Number]]學分。」；輸入數值為47的條目，該[[Number@]]將會顯示為「您已賺取47學分。」\\';
$string['fieldvisibility'] = '可以見到';
$string['fieldvisibleall'] = '每個人';
$string['fieldvisiblenone'] = '只限管理員';
$string['fieldvisibleowner'] = '所有者和管理員';
$string['fieldwidth'] = '寬度';
$string['filemaxsize'] = '上傳檔案的總大小';
$string['filesettings'] = '檔案設定';
$string['filesmax'] = '上傳檔案的最大數量';
$string['filetypeany'] = '任何檔案類型';
$string['filetypeaudio'] = '音頻檔案';
$string['filetypegif'] = 'gif 檔案';
$string['filetypehtml'] = 'Html 檔案';
$string['filetypeimage'] = '圖像檔案';
$string['filetypejpg'] = 'jpg 檔案';
$string['filetypepng'] = 'png 檔案';
$string['filetypes'] = '可接受的檔案類型';
$string['filter'] = '篩選器';
$string['filteradd'] = '添加篩選';
$string['filteradvanced'] = '進階篩選';
$string['filterbypage'] = '按頁面';
$string['filtercancel'] = '取消篩選';
$string['filtercreate'] = '創建新篩選';
$string['filtercurrent'] = '現時篩選';
$string['filtercustomsearch'] = '搜尋選項';
$string['filtercustomsort'] = '排序選項';
$string['filterdescription'] = '篩選描述';
$string['filteredit'] = '編輯中 \'{$a}\\';
$string['filtergroupby'] = '通過...分類';
$string['filterincomplete'] = '搜尋條件必須完成。';
$string['filtername'] = '數據表自動連接';
$string['filternew'] = '新篩選';
$string['filternoneforaction'] = '沒有找到符合你要求的篩選';
$string['filterperpage'] = '每頁';
$string['filterquick'] = '快速篩選';
$string['filterquickreset'] = '* 重新設定快速篩選';
$string['filters'] = '篩選';
$string['filtersadded'] = '已添加 {$ a} 個篩選';
$string['filtersave'] = '儲存篩選';
$string['filtersaved'] = '我的已儲存篩選';
$string['filtersavedreset'] = '* 重新設定已儲存篩選';
$string['filtersconfirmdelete'] = '你即將移除 {$a} 篩選，確定繼續嗎？';
$string['filtersconfirmduplicate'] = '你即將複製 {$a} 篩選，確定繼續嗎？';
$string['filtersdeleted'] = '{$a} 篩選已移除';
$string['filtersduplicated'] = '{$a} 篩選已複製';
$string['filtersearchfieldlabel'] = '搜尋篩選';
$string['filterselection'] = '選擇';
$string['filtersimplesearch'] = '簡單搜尋';
$string['filtersmax'] = '最多篩選';
$string['filtersnonedefined'] = '沒有被定義的篩選';
$string['filtersnoneindataform'] = '此資料格式並未定義過濾器';
$string['filtersortfieldlabel'] = '排序欄位';
$string['filtersupdated'] = '{$a} 篩選已更新';
$string['filterupdate'] = '更新一個現實篩選';
$string['filterurlquery'] = '網址查詢';
$string['first'] = '第一';
$string['firstdayofweek'] = '星期一';
$string['formemptyadd'] = '你沒有填任何欄位';
$string['fromfile'] = '從zip檔案輸入';
$string['generalactions'] = '一般行動';
$string['getstarted'] = '此資料格式似乎是新增的或者未設定完全';
$string['getstartedfields'] = '在 {$ a} 部分添加欄位';
$string['getstartedpresets'] = '在 {$ a} 部分應用預設';
$string['getstartedviews'] = '在{$ a}部分添加視圖';
$string['gradecalc'] = '等級計算';
$string['gradecalc_help'] = '等級計算是一條確定活動等級的公式。這條公式可以使用常用的數學運算器，如最大值、最小值和總和，它還可以基於用戶內容使用某些欄位模式來確定活動等級。';
$string['gradeguide'] = '評分指南/量表';
$string['gradeguide_help'] = '選擇評分指南或量表用作確定此活動／評分項目的評級。';
$string['gradeitems'] = '評分項目';
$string['gradeitems_help'] = '此頁面允許你在此活動添加／編輯評分項目。';
$string['gradeitemsin'] = '在 {$a} 中的評分項目';
$string['greaterorequal'] = '大於或等於';
$string['greaterthan'] = '大於';
$string['groupentries'] = '群組項目';
$string['groupentries_help'] = '項目會新增群組資訊，但不包括作者資訊，此設定需要使用群組模式';
$string['headercss'] = '所有視圖的自訂CSS樣式';
$string['headerjs'] = '所有視圖的自訂javascript樣式';
$string['horizontal'] = '水平';
$string['import'] = '輸入';
$string['importadd'] = '添加新的導入視圖';
$string['importnoneindataform'] = '此資料格式並未定義匯入';
$string['in'] = '在';
$string['incorrect'] = '不正確';
$string['index'] = '索引';
$string['inlineview'] = '內嵌視圖';
$string['inlineview_help'] = '您可以選擇其中一個資料表的視圖來顯示在課程頁面而不是活動連結。如這是個新例，你需要儲存它並在選擇內嵌視圖前至少創建一個視圖。';
$string['instances'] = '實例';
$string['insufficiententries'] = '欲檢視此數據格式需輸入更多文字';
$string['internal'] = '內置';
$string['intervalcount'] = '間隔數目';
$string['intervalcount_help'] = '如果活動設定為超過1個間隔，則可用設定和項目設定會分別應用於每個間隔。';
$string['intro'] = '介紹';
$string['invalidname'] = '請為 {$a} 選擇另一個名稱';
$string['invalidrate'] = '資料形式率無效（{$ a}）';
$string['invalidurl'] = '你剛剛輸入的網址無效';
$string['is'] = '信息系統';
$string['jscode'] = 'Javascript 代碼';
$string['jsinclude'] = 'JS';
$string['jsincludes'] = '包含外置 javascript';
$string['jssaved'] = 'Javascript 已儲存';
$string['jsupload'] = '上傳 javascript 檔案';
$string['lessorequal'] = '少於或等於';
$string['lessthan'] = '少於';
$string['lock'] = '鎖';
$string['manage'] = '管理';
$string['modulename'] = '數據格式';
$string['modulenameplural'] = '數據格式';
$string['pluginadministration'] = '數據格式活動管理';
$string['pluginname'] = '數據格式';
$string['presetfromdataform'] = '預先設定此數據格式';
$string['presetinfo'] = '儲存預設即發布於檢視中。其它用戶可於數據格式中用到。';
$string['returntoimport'] = '返回匯入';
$string['scope'] = '範圍';
$string['search'] = '搜尋';
$string['separateentries'] = '每次輸入內容為個別檔案。';
$string['separateparticipants'] = '個別的參與者';
$string['settings'] = '設定';
$string['spreadsheettype'] = '電子表格形式';
$string['subject'] = '主題';
$string['submission'] = '繳交';
$string['submissiondefaultmessage'] = '謝謝您';
$string['submissiondisplay'] = '一邊編輯一邊顯示';
$string['submissionmessage'] = '回應繳交的作業';
$string['submissionredirect'] = '重新導向另一個畫面';
$string['submissionredirect_help'] = '預設情況是使用者在繳交文字後停留在原來的畫面。如果您選了另一個畫面，使用者繳交完文字後就會被導向那裡。';
$string['submissiontimeout'] = '回應時間結束';
$string['submissiontimeout_help'] = '使用者交出文字後，在未被導向目標畫面前的預留時間(以秒計)';
$string['submitfailure'] = '我們無法儲存您交的文字，請再試一次。';
$string['subplugintype_dataformtool'] = '數據格式工具形式';
$string['subplugintype_dataformview'] = '數據格式檢視形式';
$string['timedue'] = '到(期)';
$string['timeinterval'] = '延續時間';
$string['timing'] = '時間與間隔';
$string['toolnoneindataform'] = '並未為此數據格式指定工具';
$string['toolrun'] = '執行';
$string['tools'] = '工具';
$string['type'] = '形式';
$string['unlock'] = '開啟';
$string['userpref'] = '使用者偏好';
$string['view'] = '檢視';
$string['viewadd'] = '新增檢視';
$string['viewcreate'] = '開啟新視窗';
$string['viewcurrent'] = '目前視窗';
$string['viewcustomdays'] = '慣例更新間隔：日';
$string['viewcustomhours'] = '慣例更新間隔：小時';
$string['viewcustomminutes'] = '慣例更新間隔：分';
$string['viewdescription'] = '檢視描述';
$string['viewdescription_help'] = '簡短的描述檢視的目的及特徵，讓管理者可以一眼看出每個檢視的目的。描述只有出現在檢視管理清單裡。';
$string['viewdisabled'] = '不啟用';
$string['viewedit'] = '編輯\'{$a}';
$string['vieweditthis'] = '編輯此檢視';
$string['viewfilter'] = '過濾器';
$string['viewforedit'] = '檢視編輯';
$string['viewformore'] = '檢視更多';
$string['viewfromdate'] = '檢視自';
$string['viewgeneral'] = '檢視一般設定';
$string['viewgeneral_help'] = '檢視一般設定';
$string['viewhidden'] = '隱藏';
$string['viewinterval'] = '更新檢視內容的時間';
$string['viewintervalsettings'] = '間隔設定';
$string['viewname'] = '檢視姓名';
$string['viewnodefault'] = '未設定預設檢視。可選擇{$a}清單中任一檢視作為預設。';
$string['wrongdataid'] = '提供的數據格式ID是錯誤的。';
