<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityisscheduledfordeletion'] = '活動刪除進行中....';
$string['alreadyloggedin'] = '您已經以{$a}身分登入，如果您要用不同身分登入前，需要先登出。';
$string['authnotexisting'] = 'autorization外掛套件不存在';
$string['backupcontainexternal'] = '此備份檔案包含沒有在本地配置的外部Moodle網路主機';
$string['backuptablefail'] = '備份的資料表不能順利安裝！';
$string['blockcannotconfig'] = '此區塊不支持全局配置';
$string['blockcannotinistantiate'] = '區塊無法實例化';
$string['blockcannotread'] = '無法為 blockid = {$} 讀取資料';
$string['blockdoesnotexist'] = '這一區塊不存在';
$string['blockdoesnotexistonpage'] = '這區塊 (id={$a->instanceid})不存在於這一頁 ({$a->url})。';
$string['blocknameconflict'] = '命名衝突：區塊 {$a->name}和現存的區塊 {$a->conflict}有相同的標題!';
$string['callbackrejectcomment'] = '回應回調拒絕了這個回應';
$string['cannotaddcoursemodule'] = '無法新增一課程模組';
$string['cannotaddcoursemoduletosection'] = '無法新增一課程模組到這學習單元';
$string['cannotaddmodule'] = '{$a} 模組不能新增到這模組清單!';
$string['cannotaddnewmodule'] = '無法新增一個 {$a}的新模組';
$string['cannotaddrss'] = '你沒有權限新增 rss feeds';
$string['cannotaddthisblocktype'] = '你不能新增一 {$a} 區塊到這一頁';
$string['cannotassignrole'] = '課程中無法指派角色';
$string['cannotassignrolehere'] = '你不能在這情境 ({$a->context})指派中這一角色 (id = {$a->roleid})';
$string['cannotassignselfasparent'] = '無法指派自己為上層';
$string['cannotcallscript'] = '你無法以此方式呼叫腳本';
$string['cannotcallusgetselecteduser'] = '你不能呼叫 user_selector::get_selected_user，若多重選擇為真';
$string['cannotcreatebackupdir'] = '無法建立備分資料夾。網站管理員需要修復檔案權限';
$string['cannotcreatecategory'] = '無法建立類目';
$string['cannotcreatedboninstall'] = '<p>無法建立資料庫</p>
<p>指定之資料庫並不存在。使用者並未有權限建立資料庫</p>
<p>網站管理員需查明資料庫之組態.</p>';
$string['cannotcreategroup'] = '無法建立群組';
$string['cannotcreatelangbase'] = '無法建立基本語言目錄';
$string['cannotcreatelangdir'] = '無法建立語言資料夾';
$string['cannotcreateorfindstructs'] = '無法建立這一課程的學習單元結構';
$string['cannotcreatepopupwin'] = '無法建立彈出式視窗';
$string['cannotcreatesitedir'] = '無法建立網站資料夾。這網站管理員需要修復這檔案權限。';
$string['cannotcreatetempdir'] = '無法建立暫存資料夾';
$string['cannotcreateuploaddir'] = '不能建立上傳的資料夾。網站的管理員需要修復該檔案的權限。';
$string['cannotcustomisefiltersblockuser'] = '你不能在用戶或區塊的情境下，自行定義過濾器的設定。';
$string['cannotdeletebackupids'] = '無法刪除先前的備份檔';
$string['cannotdeletecategorycourse'] = '課程 \'{$a}\' 無法被刪除';
$string['cannotdeletecategoryquestions'] = '無法從類目 \'{$a}\'刪除試題';
$string['cannotdeletecourse'] = '你沒有權限刪除這一課程';
$string['cannotdeletecustomfield'] = '無法刪除自訂欄位資料';
$string['cannotdeletedir'] = '無法刪除 ({$a})';
$string['cannotdeletefile'] = '無法刪除這一檔案';
$string['cannotdeleterole'] = '它無法被刪除，因為 {$a}';
$string['cannotdeleterolewithid'] = '不能刪除編號{$a}的角色';
$string['cannotdeletethisrole'] = '你不能刪除這一角色，因為它是由系統所使用，或因為它是有管理員權限的最後角色。';
$string['cannotdisableformat'] = '你不能關閉這預設格式';
$string['cannotdownloadcomponents'] = '無法下載元件';
$string['cannotdownloadlanguageupdatelist'] = '無法從download.moodle.org下載語言清單';
$string['cannotdownloadzipfile'] = '無法下載 ZIP 壓縮檔案';
$string['cannoteditcomment'] = '這回應不是你的，不可以刪除!';
$string['cannoteditcommentexpired'] = '你不能編輯這個，時間已經超過。';
$string['cannoteditpostorblog'] = '你不可以張貼或編輯部落格';
$string['cannoteditsiteform'] = '你不可以使用這一表格編輯這網站的課程';
$string['cannotedituserpreferences'] = '無法編輯這一用戶的偏好';
$string['cannotedityourprofile'] = '抱歉，你無法編輯自己的';
$string['cannotexecduringupgrade'] = '更新時無法執行';
$string['cannotfindcategory'] = '無法以編號 - {$a}從資料庫找到類別紀錄';
$string['cannotfindcomponent'] = '找不到元件';
$string['cannotfindcontext'] = '找不到脈絡';
$string['cannotfindcourse'] = '找不到課程';
$string['cannotfinddocs'] = '找不到 "{$a}" 語言的文件檔';
$string['cannotfindgradeitem'] = '無法找到評分項目';
$string['cannotfindgroup'] = '無法找到群組';
$string['cannotfindhelp'] = '找到 "{$a}"語言的幫助說明檔';
$string['cannotfindinfo'] = '找不到 "{$a}"的資訊';
$string['cannotfindlang'] = '找不到 "{$a}"語言包';
$string['cannotfindteacher'] = '找不到教師';
$string['cannotfinduser'] = '找不到名字為 "{$a}"的用戶';
$string['cannotgeoplugin'] = '無法連結到http://www.geoplugin.com 的 geoPlugin 伺服器，請檢查代理伺服器設定或最好安裝 MaxMind GeoLite City 資料庫文件';
$string['cannotgetblock'] = '無法從資料庫中檢索區塊';
$string['cannotgetcats'] = '不能得到分類紀錄';
$string['cannotgetdata'] = '無法取得資料';
$string['cannotgradeuser'] = '無法對這一用戶評分';
$string['cannothaveparentcate'] = '課程類目不能有上層';
$string['cannotimport'] = '無法匯入';
$string['cannotimportformat'] = '很抱歉，此格式導入尚未實現！';
$string['cannotimportgrade'] = '無法匯入成績';
$string['cannotinsertgrade'] = '沒有課程編號，無法插入計分項目';
$string['cannotinsertrate'] = '無法插入新的評比 ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = '不能插入新紀錄編號{$a}';
$string['cannotmailconfirm'] = '無法送出確認要變更密碼的email';
$string['cannotmanualctrack'] = '活動沒有提供手動完成度追蹤';
$string['cannotmapfield'] = '發現對應衝突-兩個欄位對應到相同的成績項目{$a}';
$string['cannotmarktopic'] = '不能標記此課程的主題';
$string['cannotmigratedatacomments'] = '不能轉移回應模組的資料';
$string['cannotmodulename'] = '不能在已建立的導覽列中取得模組名稱';
$string['cannotmoduletype'] = '不能在已建立的導覽列中取得模組類型';
$string['cannotmovecategory'] = '目錄不能移動';
$string['cannotmovecourses'] = '不能將課程由其所在的目錄移至其它目錄';
$string['cannotmoverolewithid'] = '不能移除編號 {$a}的角色';
$string['cannotopencsv'] = '無法開啟 CSV 檔';
$string['cannotopenfile'] = '無法開啟檔案({$a})';
$string['cannotopenforwrit'] = '無法開啟({$a})來寫入';
$string['cannotopentemplate'] = '無法開啟樣版檔案({$a})';
$string['cannotopenzip'] = '無法開啟壓縮檔，可能是64bit作業系統上的zip擴展的臭蟲';
$string['cannotoverridebaserole'] = '無法覆蓋基本角色權限';
$string['cannotoverriderolehere'] = '你不允許覆蓋這角色(id = {$a->roleid}) 在這情境({$a->context})';
$string['cannotreadfile'] = '無法閱讀檔案({$a})';
$string['cannotreadtmpfile'] = '無法閱讀暫存檔案';
$string['cannotreaduploadfile'] = '無法讀取上傳的檔案';
$string['cannotremovefrommeta'] = '無法從這後設課程中移除這選出的課程';
$string['cannotreprocessgrades'] = '無法為這一活動{$a}處理成績';
$string['cannotresetguestpwd'] = '你無法重設訪客密碼';
$string['cannotresetmail'] = '無法重設密碼並寄給你';
$string['cannotresetthisrole'] = '無法重設這一角色';
$string['cannotrestore'] = '發生了錯誤，無法完成回存！';
$string['cannotrestoreadminorcreator'] = '你必須是一個開課者或管理員，才可還原到新課程！';
$string['cannotrestoreadminoredit'] = '您必須是有編輯權的教師或管理員，才可以回存到選出的課程！';
$string['cannotsaveagreement'] = '無法儲存您的協議';
$string['cannotsaveblock'] = '儲存區塊配置時發生錯誤';
$string['cannotsavecomment'] = '無法儲存評論';
$string['cannotsavedata'] = '無法儲存資料';
$string['cannotsavefile'] = '無法儲存檔案“{$a}”！';
$string['cannotsavemd5file'] = '無法儲存 md5 檔案';
$string['cannotsavezipfile'] = '無法儲存 ZIP 檔案';
$string['cannotservefile'] = '不能傳送文件-伺服器設定錯誤。';
$string['cannotsetparentforcatoritem'] = '無法為類別或課程項目設定父類別！';
$string['cannotsetpassword'] = '無法設定用戶密碼！';
$string['cannotsetprefgrade'] = '不能設定此成績類別的參數';
$string['cannotsettheme'] = '無法設定佈景主題！';
$string['cannotsetupblock'] = '建立區塊失敗！';
$string['cannotsetupcapformod'] = '無法為{$a}設定權限';
$string['cannotsetupcapforplugin'] = '無法為{$a}設定權限';
$string['cannotshowhidecoursesincategory'] = '無法在類別{$a}中顯示或隱藏課程。';
$string['cannotsignup'] = '你無法建立一新帳號，因為你已經以{$a}身分登入。';
$string['cannotunassigncap'] = '無法從角色{$a->role}取消已停用的權限{$a->cap}';
$string['cannotunassignrolefrom'] = '無法取消用戶編號為{$a}的角色指派';
$string['cannotunzipfile'] = '無法將檔案解壓縮';
$string['cannotupdatemod'] = '無法更新{$a}';
$string['cannotupdatepasswordonextauth'] = '更新外部認證（{$a}）的密碼失敗。詳見伺服器日誌。';
$string['cannotupdateprofile'] = '更新用戶記錄發生錯誤';
$string['cannotupdaterecord'] = '不能更新紀錄，ID：{$a}';
$string['cannotupdaterss'] = '無法更新RSS';
$string['cannotupdatesubcourse'] = '無法更新子課程';
$string['cannotupdateusermsgpref'] = '無法更新用戶簡訊的偏好設定';
$string['cannotupdateuseronexauth'] = '更新在外部認證:{$a}的用戶資料失敗。詳見伺服器日誌。';
$string['cannotuploadfile'] = '處理上傳檔案發生錯誤';
$string['cannotuseadmin'] = '您必須是管理員才能使用這個頁面';
$string['cannotuseadminadminorteacher'] = '您必須是管理員或是教師才能使用這個頁面';
$string['cannotusepage'] = '只有管理員和教師才能使用這個頁面';
$string['cannotusepage2'] = '對不起，您不可以使用這個頁面';
$string['cannotviewprofile'] = '您不能看這位用戶的個人資料';
$string['cannotviewreport'] = '您不能看這一報告';
$string['cannotwritefile'] = '不能寫入檔案({$a})';
$string['categoryerror'] = '類別錯誤';
$string['categoryidnumbertaken'] = '此ID數字已由另一類別所使用';
$string['categorynamerequired'] = '此處需要輸入類別名稱';
$string['categorytoolong'] = '類別名稱太長';
$string['commentmisconf'] = '評論的編號設定錯誤';
$string['componentisuptodate'] = '元件已經是最新的了';
$string['confirmationnotenabled'] = '這一網站沒有啟用用戶確認';
$string['confirmsesskeybad'] = '抱歉，您的session key 無法確認能進行這個動作,這個安全性功能是為了預防以您的帳號進行意外或惡意執行一些重要功能,請確認您真的要執行這個功能。';
$string['couldnotassignrole'] = '指定角色給您時發生了一個嚴重但是不明的錯誤。';
$string['couldnotupdatenoexistinguser'] = '無法更新用戶-該用戶不存在';
$string['countriesphpempty'] = '錯誤：語言包{$a}中的countries.php 檔案遺失或是內容為空白。';
$string['coursedoesnotbelongtocategory'] = '這門課程部屬於此類別';
$string['courseformatnotfound'] = '課程格式“{$a}”不存在，或不可辨識';
$string['coursegroupunknown'] = '與群組 {$a} 對應的課程沒被指定';
$string['courseidnotfound'] = '課程編號不存在';
$string['courseidnumbertaken'] = 'ID編號已為其它課程使用';
$string['coursemisconf'] = '課程設定錯誤';
$string['courserequestdisabled'] = '抱歉，申請開設課程的功能已經被管理員停用';
$string['csvcolumnduplicates'] = '檢測到重複的欄位';
$string['csvemptyfile'] = '這CSV檔是空的';
$string['csvfewcolumns'] = '欄位數不足，請檢查分隔符號設定';
$string['csvinvalidcols'] = '<b>無效的CSV檔案：</b>第一行必須是"欄位標題"並起該檔案必須符合<br />擴充欄位/逗點分隔"<br />或<br />"帶CAVV結果程式碼的擴充欄位/逗號分隔"的類型';
$string['csvinvalidcolsnum'] = '無效的CSV檔案---每一行必須包含49 70個欄位。';
$string['csvloaderror'] = '當裝載CSV檔案{$a}時發生錯誤!';
$string['csvweirdcolumns'] = '不正確的CSV檔格式：欄位數目不固定！';
$string['dbconnectionfailed'] = '<p>錯誤：資料庫連接失敗</p>
<p>可能是資料庫過載或是沒有正確執行</p>
<p>網站管理員還應該檢查config.php檔案資料庫詳細設定是否正確</p>';
$string['dbdriverproblem'] = '<p>錯誤：檢測出資料庫驅動有問題</p>
<p>網站管理員應該檢查伺服器設定
</p><p>{$a}</p>';
$string['dbsessionbroken'] = '檢查到嚴重的資料庫session錯誤<br /><br />請聯繫伺服器管理員。';
$string['dbsessionhandlerproblem'] = '設定資料庫session失敗。<br/>請通知伺服器管理員。';
$string['dbsessionmysqlpacketsize'] = '偵測到嚴重的資料庫session錯誤。請聯繫伺服器管理員。這個問題最可能是MySQL設定裡的max_allowed_packet值太小引起的。';
$string['dbupdatefailed'] = '更新資料庫失敗';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" 無法被修改。找到相依性於 {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql 執行錯誤';
$string['ddlfieldalreadyexists'] = '欄位"{$a}"已經存在';
$string['ddlfieldnotexist'] = '欄位 "{$a->fieldname}" 不存在於資料表 "{$a->tablename}"之中';
$string['ddltablealreadyexists'] = '資料表"{$a}"已經存在';
$string['ddltablenotexist'] = '資料表"{$a}"不存在';
$string['ddlunknownerror'] = '未知的DLL函示庫錯誤';
$string['ddlxmlfileerror'] = 'XML資料庫檔案有錯誤';
$string['ddsequenceerror'] = '資料表"{$a}"定義不不正確：只能有一個自動列，且必須為它定義key。';
$string['destinationcmnotexit'] = '目標課程模組不存在';
$string['detectedbrokenplugin'] = '抱歉，外掛套件"{$a}"是毀損的或是舊版的，不能繼續處理。';
$string['dmlexceptiononinstall'] = '<p>資料庫有誤 [{$a->錯誤碼}].<br />{$a->排除故障資訊}</p>';
$string['dmlreadexception'] = '從資料庫讀取失敗';
$string['dmltransactionexception'] = '資料庫交易發生錯誤';
$string['dmlwriteexception'] = '寫入資料庫發生錯誤';
$string['downgradedcore'] = '錯誤！！您使用的程式版本和現在資料庫的版本比較起來以經是過舊了！';
$string['downloadedfilecheckfailed'] = '下載的檔案檢查結果有錯誤';
$string['duplicatefieldname'] = '發現重複名稱欄位"{$a}"';
$string['duplicatenosupport'] = '\'{$a->modname}\' 活動不能重複，因為{$a->modtype} 模組不支援備分和還原。';
$string['duplicateparaminsql'] = '錯誤：查詢中出現重複的參數名稱';
$string['duplicaterolename'] = '同樣名稱的角色已經存在！';
$string['duplicateroleshortname'] = '使用這個簡稱的角色名稱已經存在！';
$string['duplicateusername'] = '使用者名稱重複：跳過紀錄';
$string['emailfail'] = '信件發送失敗';
$string['enddatebeforestartdate'] = '課程結束日期必須在開始日期之後';
$string['error'] = '發生錯誤';
$string['errorcleaningdirectory'] = '清除"{$a}"目錄時發生錯誤';
$string['errorcopyingfiles'] = '複製檔案時發生錯誤';
$string['errorcreatingdirectory'] = '建立目錄 "{$a}" 時發生錯誤';
$string['errorcreatingfile'] = '建立檔案 "{$a}" 時發生錯誤';
$string['errorcreatingrole'] = '建立角色發生錯誤';
$string['errorfetchingrssfeed'] = '抓取RSS feed時出現錯誤。';
$string['erroronline'] = '錯誤發生在第 {$a} 行';
$string['erroroutput'] = '錯誤的輸出，因此關閉自動化的重新導向';
$string['errorparsingxml'] = '解析XML出現錯誤：{$a->errorstring}，發生在行 {$a->errorline}，字元 {$a->errorchar}';
$string['errorprocessingarchive'] = '抓取資料庫資料時發生錯誤';
$string['error_question_answers_missing_in_db'] = '無法在這試題_答案資料庫表格中找到"{$a->answer}"的答案。會發生這現象的原因，是將備份檔案中的這試題以編號 {$a->filequestionid} 回存，而它已經和資料庫中編號{$a->dbquestionid}的試題相配對。';
$string['errorreadingfile'] = '讀取檔案 "{$a}" 時發生錯誤';
$string['errorsavingrequest'] = '在儲存您的要求時發生錯誤。';
$string['errorsettinguserpref'] = '設定用戶參數時發生錯誤';
$string['errorunzippingfiles'] = '解壓縮檔案時發生錯誤';
$string['expiredkey'] = '過期的密鑰';
$string['externalauthpassworderror'] = '外部認證時密碼不可為空';
$string['externalfilenolocation'] = '外部檔案沒有設定路徑';
$string['failtoloadblocks'] = '資料庫中註冊了一個或多個區塊，但是載入它們失敗！';
$string['fieldrequired'] = '"{$a}" 是必填的欄位';
$string['fileexists'] = '檔案已經存在';
$string['filemismatch'] = '非核心檔案名稱不匹配。檔案"{$a->current}"應該為{$a->file}';
$string['filenotfound'] = '抱歉,指定的檔案找不到';
$string['filenotreadable'] = '檔案無法讀取';
$string['filterdoesnothavelocalconfig'] = '過濾器{$a}不允許使用本地設定。';
$string['filternotactive'] = '過濾器{$a}目前處於未啟動狀態。';
$string['filternotenabled'] = '過濾器未啟用！';
$string['filternotinstalled'] = '目前尚未安裝過濾器{$a}';
$string['forumblockingtoomanyposts'] = '您已經超過這個討論區所設定的張貼限制';
$string['generalexceptionmessage'] = '異常-{$a}';
$string['gradecantregrade'] = '計算分數時產生錯誤';
$string['gradepubdisable'] = '成績發佈已經停用';
$string['gradesneedregrading'] = '這些課程分數需要重新計算';
$string['groupalready'] = '使用者已隸屬於群組 {$a}';
$string['groupexistforcourse'] = '這課程已經有"{$a}"群組了';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}：此課程已經有編號為 “{$a->idnumber}” 的群組“{$a->name}”';
$string['grouphasidnumber'] = '群組"{$a}"已經有一個編號，且可能被自動建立在一外部系統。您沒有權限刪除這個群組。';
$string['groupinghasidnumber'] = '用戶不是這個群組的成員';
$string['groupingnotaddederror'] = '"{$a}" 分群未加入。';
$string['groupnotaddederror'] = '群組 "{$a}" 新增失敗';
$string['groupnotaddedtogroupingerror'] = '群組 "{$a->groupname}" 沒有加到分群 "{$a->groupingname}"';
$string['groupunknown'] = '群組{$a}與指定的課程不相關';
$string['groupusernotmember'] = '用戶不是這個群組的成員';
$string['guestcantaccessprofiles'] = '訪客無法存取用戶個人資料表。以完整的用戶帳號登入才能繼續。';
$string['guestnocomment'] = '訪客無法發表回應！';
$string['guestnoeditprofile'] = '訪客無法編輯個人資料';
$string['guestnoeditprofileother'] = '不能編輯訪客個人資料';
$string['guestnorate'] = '不允許訪客為項目評分';
$string['guestsarenotallowed'] = '訪客用戶無權做此操作';
$string['hackdetected'] = '偵測到駭客攻擊!';
$string['hashpoolproblem'] = '不正確的匯集檔案內容{$a}。';
$string['headersent'] = '表頭已經送出';
$string['idnumbertaken'] = '此 ID 已經被另一個課程所使用';
$string['idnumbertoolong'] = '編號數字太長';
$string['importformatnotimplement'] = '抱歉，目前不支援匯入這種格式。';
$string['incorrectext'] = '檔案的副檔名錯誤';
$string['inplaceeditableerror'] = '呼叫更新處理器失敗';
$string['installproblem'] = '安裝過程中出現的錯誤通常是無法恢復的，如果您要重新安裝，可能要重新建立一個新的資料庫或者使用不同的資料庫前置詞。';
$string['internalauthpassworderror'] = '內部認證密碼遺失或密碼規則無效';
$string['invalidaccess'] = '頁面連結不正確';
$string['invalidaccessparameter'] = '無效的連接參數';
$string['invalidaction'] = '無效的動作參數';
$string['invalidactivityid'] = '無效的活動編號';
$string['invalidadminsettingname'] = '錯誤的管理設定({$a})';
$string['invalidargorconf'] = '沒有提供有效的參數或伺服器設定錯誤';
$string['invalidarguments'] = '沒有提供有效的參數';
$string['invalidblockinstance'] = '無效的區塊實體：{$a}';
$string['invalidbulkenrolop'] = '無效的批次選課操作請求。';
$string['invalidcategory'] = '錯誤的類別！';
$string['invalidcategoryid'] = '不正確的類別編號！';
$string['invalidcomment'] = '評論錯誤';
$string['invalidcommentarea'] = '無效的評論區域';
$string['invalidcommentid'] = '無效的評論編號';
$string['invalidcommentitemid'] = '無效的試題編號';
$string['invalidcommentparam'] = '無效的評論參數';
$string['invalidcomponent'] = '無效的元件名稱';
$string['invalidconfirmdata'] = '無效的確認資料';
$string['invalidcontext'] = '無效的內容';
$string['invalidcourse'] = '無效的課程';
$string['invalidcourseformat'] = '無效的課程格式';
$string['invalidcourseid'] = '您正試圖使用一個無效的課程編號({$a})';
$string['invalidcourselevel'] = '脈絡層次不正確';
$string['invalidcoursemodule'] = '課程模組編號無效';
$string['invalidcoursenameshort'] = '無效的課程簡稱';
$string['invaliddata'] = '送出的資料是無效的';
$string['invaliddatarootpermissions'] = '在嘗試建立一目錄時偵測無效的權限，管理員必須開啟系統除錯模式即可看到近一步的細節。';
$string['invaliddevicetype'] = '無效的設備類型';
$string['invalidelementid'] = '元素編號錯誤！';
$string['invalidentry'] = '無效的條目';
$string['invalidevent'] = '無效的事件';
$string['invalidfieldname'] = '"{$a}" 不是合法的欄位名稱';
$string['invalidfiletype'] = '"{$a}" 不是合法的檔案型態';
$string['invalidformatpara'] = '選擇參數格式錯誤';
$string['invalidformdata'] = '表單資料不正確';
$string['invalidfunction'] = '不正確的函式';
$string['invalidgradeitemid'] = '無效的成績項目編號';
$string['invalidgroupid'] = '指定的群組編號不正確';
$string['invalidipformat'] = 'IP 格式錯誤';
$string['invaliditemid'] = '項目編號不正確';
$string['invalidkey'] = '密鑰不正確';
$string['invalidlegacy'] = '不正確的舊版角色類型定義：{$a}';
$string['invalidmd5'] = '這檢查變項是錯的，再試一次';
$string['invalidmode'] = '無效的模式({$a})';
$string['invalidmodule'] = '無效的模組';
$string['invalidmoduleid'] = '無效模組編號： {$a}';
$string['invalidmodulename'] = '無效模組名稱： {$a}';
$string['invalidnum'] = '無效的數值';
$string['invalidnumkey'] = '$conditions 陣列不應該包含數字索引，請修改程式！';
$string['invalidoutcome'] = '不正確的核心能力編號';
$string['invalidpagesize'] = '無效的頁面大小';
$string['invalidpasswordpolicy'] = '無效的密碼管理辦法';
$string['invalidpaymentmethod'] = '無效的付款方式: {$a}';
$string['invalidqueryparam'] = '錯誤：查詢參數數目不正確。應該為{$a->expected}個，現在有{$a->actual}個。';
$string['invalidratingarea'] = '無效的評比區域';
$string['invalidrecord'] = '在資料表{$a}中找不到資料記錄。';
$string['invalidrecordunknown'] = '在資料庫中找不到資料記錄。';
$string['invalidrequest'] = '無效的請求';
$string['invalidrole'] = '無效的角色';
$string['invalidroleid'] = '無效的角色編號';
$string['invalidscaleid'] = '無效的量尺編號';
$string['invalidsection'] = '課程模組紀錄包含無效的學習單元';
$string['invalidsesskey'] = '傳送了錯誤的sesskey，表單未被接受。';
$string['invalidshortname'] = '這是無效的課程簡稱';
$string['invalidsourcefield'] = '草稿檔案的來源欄位是無效的';
$string['invalidstatedetected'] = '一定出了差錯{$a}，這通常是不會發生。';
$string['invalidurl'] = '無效的URL網址';
$string['invaliduser'] = '無效的用戶';
$string['invaliduserdata'] = '無效的用戶資料：{$a}';
$string['invaliduserfield'] = '無效的用戶欄位: {$a}';
$string['invaliduserid'] = '無效的用戶編號';
$string['invalidusername'] = '所給的用戶名稱包含無效的字元。';
$string['invalidxmlfile'] = '"{$a}" 不是合法的XML檔案';
$string['iplookupfailed'] = '無法找到這個IP位址的地理資訊';
$string['iplookupprivate'] = '無法顯示私有IP';
$string['ipmismatch'] = '客戶端IP位址不符合';
$string['listcantmovedown'] = '向下移動項目失敗，已經是在最後位置。';
$string['listcantmoveleft'] = '向左移動項目失敗，沒有找到父項目。';
$string['listcantmoveright'] = '向右移動項目失敗，沒有找到子項。您必須向下移動到另一個同類項中後才能向右移。';
$string['listcantmoveup'] = '已經是最上層了，無法再往上移動了!';
$string['listnochildren'] = '找不到子項目';
$string['listnoitem'] = '找不到項目';
$string['listnopeers'] = '找不到項目';
$string['listupdatefail'] = '編輯列表層級時，DB操作失敗。';
$string['logfilenotavailable'] = '日誌無法使用';
$string['loginasnoenrol'] = '當您以"登入為..."方式連線時，您不能選課或退選。';
$string['loginasonecourse'] = '您無法進入這個課程。<br />在進入其他課程前，您必須先終止以其他身分登入的連線。';
$string['maxareabytes'] = '這一檔案大於這一區域剩餘的空間。';
$string['maxbytes'] = '這檔案大於允許的檔案最大限制';
$string['maxbytesfile'] = '這檔案 {$a->file} 太大了。你可以上傳的檔案最大容量是 {$a->size}。';
$string['messagingdisable'] = '在這網站，簡訊功能是關閉的';
$string['mimetexisnotexist'] = '你的系統還沒有設定要執行mimeTeX。您需要從<a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>
為您的PHP_OS平台下載正確的可執行檔，或從<a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>
取得C原始碼，編譯該原始碼並將可執行文件放入您的 moodle/filter/tex/目錄下。';
$string['mimetexnotexecutable'] = '自定義mimetex無法執行！';
$string['missingfield'] = '欄位 "{$a}" 不存在';
$string['missingkeyinsql'] = '錯誤：查詢語法缺少參數"{$a}"';
$string['missing_moodle_backup_xml_file'] = '找不到備份XML檔案：{$a}';
$string['missingparam'] = '缺少必須要的參數({$a})';
$string['missingparameter'] = '缺少參數';
$string['missingrequiredfield'] = '缺少部份必填欄位';
$string['missinguseranditemid'] = '缺少用戶編號和項目編號';
$string['missingvarname'] = '缺少必要的變項名稱!';
$string['mixedtypesqlparam'] = '錯誤：資料庫查詢參數使用混和的類型！！';
$string['mnetdisable'] = 'MNET被停用';
$string['mnetlocal'] = '遠端MNET用戶不能在本地登入';
$string['moduledisable'] = '模組({$a})對於該課程已經失效';
$string['moduledoesnotexist'] = '這模組不存在';
$string['moduleinstancedoesnotexist'] = '這模組的實例不存在';
$string['modulemissingcode'] = '模組 {$a} 缺少了執行這個功能所需要的代碼';
$string['movecatcontentstoroot'] = '不允許移動類別內容到根目錄，您必須移動此內容到一個已經存在的類別中！';
$string['movecategorynotpossible'] = '不可將類別{$a}移至選定之目錄';
$string['movecategoryownparent'] = '不可將類別{$a}又作為其上層目錄';
$string['movecategoryparentconflict'] = '不可將類別{$a}又作為其下層目錄';
$string['mssqlrcsmodemissing'] = '這資料庫不是使用預期的 READ_COMMITTED_SNAPSHOT 模式，它可能導致錯誤的結果。
請啟用它，才能正確運作，你可以在<a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP#Configuration">Moodle 文件</a>.找到更多訊息。';
$string['multiplerecordsfound'] = '找到多筆紀錄，但應該只有一筆。';
$string['multiplerestorenotallow'] = '不允許同時執行多個還原!';
$string['mustbeloggedin'] = '你必須登入才能做這個';
$string['mustbeteacher'] = '只有教師可以檢視這個頁面';
$string['myisamproblem'] = '資料庫資料表正在使用MyISAM資料庫引擎，建議使用符合ACID原則的交易引擎像是，InnoDB。';
$string['needcopy'] = '你需要先複製某些東西!';
$string['needcoursecategroyid'] = '必須指定課程編號或類別';
$string['needphpext'] = '您需要為您的PHP加入對{$a}的支援';
$string['noadmins'] = '沒有管理員!';
$string['noblocks'] = '找不到區塊!';
$string['nocapabilitytousethisservice'] = '這用戶者沒有使用這一服務所需要的權限';
$string['nocategorydelete'] = '課程類別"{$a})不能刪除!';
$string['nocontext'] = '很抱歉，但此課程不是一個有效的脈絡';
$string['nodata'] = '沒有資料';
$string['noexistingcategory'] = '沒有現存的類別';
$string['nofile'] = '沒有指定檔案';
$string['nofiltersenabled'] = '沒有過濾器被啟用';
$string['nofolder'] = '需要的目錄不存在';
$string['noformdesc'] = '找不到此活動的formslib表單敘述文件。';
$string['noguest'] = '現在沒有訪客!';
$string['noinstances'] = '在本課程中沒有{$a}！';
$string['nologinas'] = '您不可以用此用戶的身分登入';
$string['nonmeaningfulcontent'] = '沒有實質內容';
$string['noparticipants'] = '這一課程找不到參與者';
$string['noparticipatorycms'] = '抱歉，但您沒有參與的課程模組可以報告';
$string['nopermissions'] = '抱歉，但是您目前沒有權限執行({$a})';
$string['nopermissiontocomment'] = '你無法新增回應';
$string['nopermissiontodelentry'] = '你沒有權限去刪除他人的條目';
$string['nopermissiontoeditcomment'] = '你沒有權限編輯他人的回應';
$string['nopermissiontohide'] = '你沒有權限隱藏';
$string['nopermissiontoimportact'] = '你沒有需要的權限去匯入活動到到這一課程。';
$string['nopermissiontolock'] = '你沒有權限去封鎖';
$string['nopermissiontomanagegroup'] = '你沒有權限去管理群組';
$string['nopermissiontorate'] = '你沒有權限去做評比';
$string['nopermissiontoshow'] = '你沒有權限去看這個!';
$string['nopermissiontounlock'] = '你沒有權限去解除封鎖！';
$string['nopermissiontoupdatecalendar'] = '你沒有權限去更新行事曆事件';
$string['nopermissiontoviewgrades'] = '你沒有權限檢視成績';
$string['nopermissiontoviewletergrade'] = '你沒有權限檢視分數';
$string['nopermissiontoviewpage'] = '你沒有權限去檢視這一頁';
$string['nosite'] = '無法找到一個上層的課程';
$string['nositeid'] = '沒有網站編號';
$string['nostartdatenoenddate'] = '課程要先設有開始日期才能設定結束日期';
$string['nostatstodisplay'] = '抱歉，目前沒有資料可以顯示。';
$string['notallowedtoupdateprefremotely'] = '你不能從遠端更新這一用戶的偏好';
$string['notavailable'] = '目前無法使用';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = '你不是這課程成群組的成員';
$string['notownerofkey'] = '你不是這一密鑰的擁有者';
$string['nousers'] = '沒有這樣的用戶！';
$string['onlyadmins'] = '只有管理者可以這麼做';
$string['onlyeditingteachers'] = '只有擁有修改權的教師可以這樣做';
$string['onlyeditown'] = '您只能修改您自己的資料';
$string['orderidnotfound'] = '找不到訂單編號{$a}';
$string['pagenotexist'] = '發生一個罕見的錯誤（嘗試存取一個不存在的頁面）';
$string['pathdoesnotstartslash'] = '未提供正確參數，路徑不是以/開始！';
$string['pleasereport'] = '我們知道在錯誤發生的時候您在試圖做什麼 如果您有充裕的時間，請讓我們知道錯誤發生當時您正要執行什麼操作：';
$string['pluginrequirementsnotmet'] = '外掛套件"{$a->pluginname}" ({$a->pluginversion}) 無法安裝，它需要更新版本的 Moodle （目前您正在使用{$a->currentmoodle}，您需要升級為{$a->requiremoodle}）';
$string['prefixcannotbeempty'] = '<p>錯誤：資料庫表前置詞不能為空({$a})</p>
<p>網站管理員必須修復此問題。</p>';
$string['prefixtoolong'] = '<p>錯誤：資料表前置詞過長({$a->dbfamily})</p>
<p>網站管理員必須修復此問題。{$a->dbfamily}中前置詞的最大長度為{$a->maxlenght}個字元。</p>';
$string['privatefilesupload'] = '已經不再支援上傳到用戶私人檔案區。請上傳到草稿區，然後把這檔案移到core_user::add_user_private_files';
$string['processingstops'] = '處理程序停止！剩餘的紀錄資料將被忽略。';
$string['protected_cc_not_supported'] = '不支援受保護的CC格式。';
$string['querystringcannotbeempty'] = '字串查詢不可空白';
$string['redirecterrordetected'] = '偵測到不支援的重新導向。程式碼停止執行。';
$string['refoundto'] = '可以退款給 {$a}';
$string['refoundtoorigi'] = '退款到原始金額：{$a}';
$string['registrationdisabled'] = '這網站已經關閉註冊功能';
$string['remotedownloaderror'] = '<p>下載元件到你的伺服器已經失敗，請檢查代理伺服器的設定、高度建議安裝PHP cURL擴展。</p>
<p>您必須手動下載<a href="{$a->url}">{$a->url}</a>檔案，並且複製到你的伺服器的"{$a->dest}"，並在那兒解壓縮。</p>';
$string['remotedownloadnotallowed'] = '您的伺服器不允許下載元件（停用了 allow_url_fopen ）。<br /><br />您必須手動下載 <a href="{$a->url}">{$a->url}</a> ，然後複製到 "{$a->dest}" 並且解壓縮。';
$string['reportnotavailable'] = '這類型的報告只有網站課程可以使用';
$string['requirecorrectaccess'] = '無效的網址或埠';
$string['requireloginerror'] = '課程或活動無法使用';
$string['restorechecksumfailed'] = '從您的Session還原儲存的資訊時候發生了一些錯誤。請檢查您的PHP記憶體/DB大小限制。還原終止。';
$string['restore_path_element_missingmethod'] = '缺少還原方法 {$a} ，它必須由程式設計這定義。';
$string['restore_path_element_noobject'] = '還原的物件{$a}不是一個物件。';
$string['restrictedcontextexception'] = '抱歉，執行外部函式違反了內容限制。';
$string['restricteduser'] = '抱歉，您的目前帳號 {$a} 無權進行這一操作';
$string['reverseproxyabused'] = '反向代理伺服器啟用，不能直接瀏覽伺服器，抱歉<br />請聯絡伺服器管理員。';
$string['rpcerror'] = '唉！您的MNET通訊失敗！把這個錯誤訊息給管理員：{$a}';
$string['scheduledbackupsdisabled'] = '管理者已關閉排程備份功能';
$string['secretalreadyused'] = '更改密碼的確認連接已經使用，密碼沒有被變更';
$string['sectionnotexist'] = '此學習單元不存在';
$string['sendmessage'] = '寄送訊息';
$string['serverconnection'] = '連結到伺服器時發生錯誤';
$string['servicedonotexist'] = '這服務不存在';
$string['sessioncookiesdisable'] = '錯誤的使用require_key_login()-session cookies一定是被停用了!';
$string['sessiondiskfull'] = '存放Session的磁區已滿了。現在無法登入系統。請通知伺服器管理員。';
$string['sessionerroruser'] = '您的連線時間已經超過，請重新登入。';
$string['sessionerroruser2'] = '影響您的登入連線的伺服器錯誤被查出了。請再登入或重新啟動您的瀏覽器。';
$string['sessionhandlerproblem'] = '會話處理程序之設定錯誤';
$string['sessionipnomatch'] = '抱歉，您的ip似乎與您初次登入時不符，這個安全性功能可預防駭客以您的身份竊取您登入此站的資料，一般使用者可能不會看到這個訊息，請向系統管理者詢問取得協助。';
$string['sessionipnomatch2'] = '抱歉，您這次登入所用的IP編號與上次登入時不同。此一安全功能可以防止他人在這網站上盜用您的身分。如果您是使用無限網路或者在不同的網路中漫遊，您可能會看到此一錯誤訊息。請洽詢網站管理者尋求更多協助。<br /><br />如果您要繼續操作，請按F5刷新這一頁面。';
$string['sessionwaiterr'] = '等待session鎖超時。<br />請在目前要求結束之後再重試。';
$string['shortnametaken'] = '簡稱已經被其他課程所用({$a})';
$string['sitepolicynotagreed'] = '尚未同意網站管理辦法: <a href="{$a}">點選這裡來開啟管理辦法。</a>';
$string['socksnotsupported'] = 'PHP4不支援SOCKS5代理';
$string['spellcheckernotconf'] = '沒有配置拼字檢查的功能';
$string['sslonlyaccess'] = '抱歉，基於安全理由，只允許https連線。';
$string['statscatchupmode'] = '統計資料目前在 catchup 模式， {$a->daysdone} 天內的資料已經處理， {$a->dayspending} 天的資料等候中，請立刻整理！';
$string['statsdisable'] = '尚未啟動統計功能';
$string['statsnodata'] = '對於該課程和時段的組合沒有可用的資料';
$string['storedfilecannotcreatefile'] = '無法建立本地檔案集目錄，請檢查dataroot的權限及可用硬碟空間。';
$string['storedfilecannotcreatefiledirs'] = '無法建立本地檔案集目錄，請檢查dataroot的權限。';
$string['storedfilecannotread'] = '無法讀取檔案，可能是這檔案不存在或是有權限上的問題';
$string['storedfilenotcreated'] = '不能建立檔案"{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = '本地檔案({$a})發生未知的例外狀況';
$string['tagdisabled'] = '標籤功能已經停用！';
$string['tagnotfound'] = '資料庫中找不到指定的標籤';
$string['targetdatabasenotempty'] = '目標資料庫不是空的。為了安全理由，轉移工作已放棄。';
$string['textconditionsnotallowed'] = '不允許對文字列做條件比較。請在您在查詢中使用sql_compare_text()。';
$string['themenotinstall'] = '沒有安裝這個佈景主題';
$string['TODO'] = '待辦事項';
$string['tokengenerationfailed'] = '無法產生新的識別憑證。';
$string['transactionvoid'] = '交易不能被取消，因為它已經被取消了。';
$string['unenrolerror'] = '當試著將此人退選時，發生錯誤';
$string['unicodeupgradeerror'] = '抱歉，您的資料庫並非使用萬國字元，而這個版本的 Moodle 無法轉換您的資料庫，請先升級到 Moodle 1.7.x 並且透過管理頁面執行萬國字元轉換，接著您應該就可以升級為 Moodle {$a}';
$string['unknowaction'] = '不知名的操作！';
$string['unknowcategory'] = '不明的類別！';
$string['unknowcontext'] = '此內文({$a})在get_child_contexts中是未知的內容！';
$string['unknowformat'] = '不明的格式({$a})';
$string['unknownbackupexporterror'] = '準備匯入資訊時發生未知錯誤';
$string['unknownblockregion'] = '此頁無法識別區塊\'{$a}\'。';
$string['unknowncontext'] = '這是未知的內文。';
$string['unknowncourse'] = '不明的課程名稱： {$a}';
$string['unknowncourseidnumber'] = '不明的課程編號 "{$a}"';
$string['unknowncourserequest'] = '不明的開課申請';
$string['unknowncoursesection'] = '在課程 "{$a}"上的不明課程學習單元';
$string['unknownevent'] = '不明事件';
$string['unknownfiletype'] = '不明的過濾器類型';
$string['unknowngroup'] = '不明的群組 "{$a}"';
$string['unknownhelp'] = '不明的幫助主題{$a}';
$string['unknownjsinrequirejs'] = '找不到JS函式庫：{$a}';
$string['unknownmodulename'] = '不明的模組名稱';
$string['unknownrole'] = '不明的角色"{$a}"';
$string['unknownsortcolumn'] = '不明的排序欄位 {$a}';
$string['unknownuseraction'] = '很遺憾，我不明白這位用戶的動作';
$string['unknownuserselector'] = '不明的用戶選擇器';
$string['unknoworder'] = '不明的排序';
$string['unknowparamtype'] = '不明的參數類型： {$a}';
$string['unknowquestiontype'] = '不支援的題型 {$a}';
$string['unknowuploadaction'] = '錯誤：不明的上傳動作({$a})';
$string['unspecifycourseid'] = '必須指明課程編號，簡稱或辨認編號';
$string['unsupportedevent'] = '不支援的事件類型';
$string['unsupportedstate'] = '不支援的完成度統計';
$string['unsupportedwebserver'] = '不支援網頁伺服器軟體 ({$a}) ，抱歉。';
$string['upgraderequires19'] = '錯誤：已經在伺服器上安裝了新版的Moodle，但是不支援從之前的版本升級。<br />請先升級到最新的1.9.x版。您也可以透過重新安裝原始檔案回到之前的版本。';
$string['upgraderunning'] = '網站正在升級中，請稍後再試。';
$string['urlnotdefinerss'] = 'RSS feed 的網址沒有定義';
$string['useradmineditadmin'] = '只有管理員可以修改其他管理員的帳號';
$string['useradminodelete'] = '管理員帳號不能被刪除';
$string['userautherror'] = '不明的認證外掛';
$string['userauthunsupported'] = '不受支援的認證外掛';
$string['useremailduplicate'] = '重複的位址';
$string['usermustbemnet'] = '在MNET存取控制清單上的用戶必須是遠端MNET用戶。';
$string['usernotaddederror'] = '無法新增用戶- 未知的錯誤';
$string['usernotaddedregistered'] = '無法新增用戶- 該帳號已註冊';
$string['usernotavailable'] = '您無法檢視該用戶的詳細資料';
$string['usernotdeletedadmin'] = '用戶沒被刪除---無法刪除管理員帳號';
$string['usernotdeletederror'] = '用戶沒被刪除 --錯誤!';
$string['usernotdeletedmissing'] = '錯誤!尚未刪除使用者...無法找到使用者名稱';
$string['usernotdeletedoff'] = '用戶沒被刪除---不允許刪除';
$string['usernotfullysetup'] = '用戶沒有完全設定好';
$string['usernotincourse'] = '這一用戶沒有在此課程中！';
$string['usernotrenamedadmin'] = '管理員帳號無法重新命名';
$string['usernotrenamedexists'] = '用戶沒被更名---新的用戶名稱已經被使用。';
$string['usernotrenamedmissing'] = '用戶沒被更名 -- 找不到舊的帳號。';
$string['usernotrenamedoff'] = '尚未修改使用名稱...不允許更名';
$string['usernotupdatedadmin'] = '不能更新管理者帳號';
$string['usernotupdatederror'] = '尚未更新---錯誤';
$string['usernotupdatednotexists'] = '尚未更新---不存在';
$string['userquotalimit'] = '您已經達到了您的檔案容量配額上限。';
$string['userselectortoomany'] = '儘管多重選擇設定為false，用戶選擇器仍然選出多於一個選出的用戶。';
$string['wrongcall'] = '該指令碼呼叫錯誤';
$string['wrongcontextid'] = '內文ID錯誤（無法找到該ID）';
$string['wrongdestpath'] = '錯誤的目的路徑';
$string['wrongroleid'] = '不正確的角色編號!';
$string['wrongsourcebase'] = '錯誤的來源網址基礎';
$string['wrongusernamepassword'] = '錯誤的用戶/密碼';
$string['wrongzipfilename'] = '錯誤的 ZIP 檔名';
$string['wscouldnotcreateecoursenopermission'] = 'WS - 無法建立課程--沒有權限';
$string['wwwrootmismatch'] = '偵測到錯誤的存取，該伺服器只能經由"{$a}"網址存取，抱歉。<br />請通知伺服器管理員。';
$string['wwwrootslash'] = '在config.php偵測到不正確的 $CFG->wwwroot ，它不可以包含尾隨的斜線。

請通知伺服器管理員。';
$string['xmldberror'] = 'XMLDB 錯誤!';
$string['youcannotdeletecategory'] = '您不能刪除類別"{$a}"，因為您不能刪除這內容，也不能將它們移到別處。';
