<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_hub', language 'zh_tw', branch 'MOODLE_21_STABLE'
 *
 * @package   local_hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = '活動';
$string['additionaladmindesc'] = '註冊：{$a->timeregistered} - 修改：{$a->timemodified}  - 隱私：{$a->privacy} - 可連絡：{$a->contactable} - 電子郵件：{$a->emailalert}';
$string['additionaldesc'] = '課程：{$a->courses} - 用戶：{$a->users} - 選修：{$a->enrolments} - 資源：{$a->resources} - 張貼： {$a->posts} - 試題： {$a->questions} - 平均參與人數： {$a->participantnumberavg} - 平均課程模組數：{$a->modulenumberavg}';
$string['addscreenshots'] = '加入螢幕快照';
$string['addscreenshots_help'] = '加入新的螢幕快照。';
$string['allowglobalsearch'] = '公佈這課程集散中心，並允許全世界搜尋所有課程。';
$string['allowpublicsearch'] = '公佈這課程集散中心，讓大家可以參加。';
$string['audience'] = '對象';
$string['audienceadmins'] = 'Moodle管理員';
$string['audienceeducators'] = '教育工作者';
$string['audience_help'] = '為這課程選擇目標觀眾';
$string['audiencestudents'] = '學生';
$string['badurlformat'] = '錯誤的網址格式';
$string['blockedsecretdocurl'] = 'Blocked_site_secret';
$string['blocks'] = '區塊';
$string['bulkdelete'] = '刪除';
$string['bulknotvisible'] = '設為隱藏';
$string['bulkoperation'] = '選擇';
$string['bulkoperationperform'] = '展示';
$string['bulkselectoperation'] = '對選取的課程...';
$string['bulkvisible'] = '設為顯示';
$string['cannotregisternotavailablesite'] = '本課程集散中心無法存取您的網站。';
$string['cannotregisterprivatehub'] = '您無法註冊您的課程集散中心。更改隱私設定。';
$string['cannotsetpasswordforpublichub'] = '公開的課程集散中心無法設置密碼。刪除您的密碼，或者設為私人的課程集散中心。';
$string['comments'] = '評論';
$string['community'] = '社群';
$string['confirmbulkdelete'] = '確認批次刪除';
$string['confirmbulknotvisible'] = '確認批次隱藏';
$string['confirmbulkvisible'] = '確認批次顯示';
$string['confirmforceunregistration'] = '課程集散中心目錄中的現有的資訊都不會被修改。您確定要強制取消註冊嗎？';
$string['confirmmessagebulkdelete'] = '您確定要刪除下列課程：';
$string['confirmmessagebulknotvisible'] = '您確定要隱藏下列課程：';
$string['confirmmessagebulkvisible'] = '您確定要顯示下列課程：';
$string['confirmregistration'] = '確認註冊';
$string['confirmunregistration'] = '您確定要從課程集散中心目錄註銷嗎？';
$string['contactemail'] = '聯絡人信箱';
$string['contactemail_help'] = '聯絡人信箱是電子郵件，提供課程集散中心目錄管理員針對任何重要問題聯絡。';
$string['contactname'] = '聯絡人姓名';
$string['contentinfo'] = '主題：{$a->subject} - 對象： {$a->audience} - 教育程度： {$a->educationallevel}';
$string['contributornames'] = '貢獻者姓名';
$string['contributornames_help'] = '其他對此課程有貢獻的人。';
$string['contributors'] = '貢獻者：{$a}';
$string['copied'] = '註冊一個新網站';
$string['country'] = '國家';
$string['country_help'] = '僅顯示選取的國家的網站。';
$string['coursedesc'] = '說明';
$string['coursedesc_help'] = '課程說明';
$string['courselang'] = '語言';
$string['courselang_help'] = '課程語言';
$string['coursemap'] = '課程地圖';
$string['coursename'] = '名稱';
$string['coursename_help'] = '課程名稱';
$string['coursenotvisible'] = '{$a}現在是隱藏的。';
$string['courseprivate'] = '私人的';
$string['coursepublic'] = '公開的';
$string['coursepublished'] = '此課程已經成功發佈在“{$a}”。';
$string['coursesettings'] = '課程設定';
$string['coursesettingsform'] = '“{$a}”設定';
$string['coursesettingsupdated'] = '{$a}已經更新。';
$string['courseshortname'] = '簡稱';
$string['coursesnumber'] = '課程數（{$a}）';
$string['coursetimemodified'] = '修改時間：{$a}';
$string['coursetotal'] = '找到了{$a}個課程。';
$string['coursetype'] = '類型：{$a}';
$string['courseurl'] = '課程網址';
$string['courseurl_help'] = '您課程的網址。此網址會在搜尋結果中顯示為連結。';
$string['coursevisibility'] = '顯示';
$string['coursevisibility_help'] = '當啟用時，課程會顯示在搜尋的結果中。';
$string['coursevisible'] = '{$a}現在是顯示的。';
$string['coverage'] = '標籤：{$a}';
$string['creatorname'] = '建立者姓名';
$string['creatorname_help'] = '建立者是建立此課程的人。';
$string['creatornotes'] = '建立者的備註';
$string['creatornotes_help'] = '建立者的備註是用來告訴教師們如何使用這一課程。';
$string['deleteconfirmation'] = '該網站管理員將收到一封電子郵件，說明他如何能註銷他的網站。';
$string['deletecourseconfirmation'] = '您確定要刪除這{$a}課程嗎？';
$string['deleterelatedcourseslink'] = '相關課程';
$string['deletesite'] = '註銷{$a}';
$string['demourl'] = '示範網站網址';
$string['demourl_help'] = '輸入您課程示範網站的網址。預設上，它就是您的課程網址。這網址會以鏈結形式出現在搜尋結果上。';
$string['description'] = '說明';
$string['description_help'] = '這課程說明將會顯示在課程集散中心的課程清單上。';
$string['donotdeleteormodify'] = '不要刪除或修改此用戶！';
$string['downloadable'] = '可下載的';
$string['downloadablecourses'] = '可下載的課程';
$string['editcourse'] = '編輯';
$string['educationallevel'] = '教育程度';
$string['educationallevel_help'] = '選擇此課程最適合的教育程度。';
$string['edulevelassociation'] = '學會';
$string['edulevelcorporate'] = '公司';
$string['edulevelgovernment'] = '政府';
$string['edulevelother'] = '其他';
$string['edulevelprimary'] = '初等教育';
$string['edulevelsecondary'] = '中等教育';
$string['eduleveltertiary'] = '高等教育';
$string['emailmessage'] = '訊息';
$string['emailmessage_help'] = '訊息的內容。';
$string['emailmessagesiteadded'] = '一個新的網站剛剛註冊到位於{$a->huburl}的課程集散中心
名稱： {$a->name}
網址： {$a->url}
管理員： {$a->contactname} ({$a->contactemail})
語言{$a->language}
若要管理註冊的網站資料，請至：{$a->managesiteurl}';
$string['emailmessagesitedeleted'] = '一位來自 {$a->hubname} ({$a->huburl})的管理員從集散中心課程清單刪除了 {$a->sitename} ({$a->siteurl})。如果您想要再向此課程集散中心註冊，您必須先重設您的伺服器上的註冊資料。請至{$a->unregisterpagelink}。';
$string['emailmessagesiteurlchanged'] = '{$a->name} 網站已經更新。（之前的名稱：{$a->oldname}）它的新網址為{$a->url}已經從{$a->oldurl}更新。
名稱： {$a->name}
網址： {$a->url}
管理員： {$a->contactname} ({$a->contactemail})
語言{$a->language}
若要管理註冊的網站資料，請至：{$a->managesiteurl}';
$string['emailmessageurlalreadyexists'] = '如果不了解請勿點按此連結，這可能是盜竊註冊未遂！
{$a->hubname} 課程集散中心偵測到有一個網站試圖以{$a->existingsite}的網址註冊。這個問題通常會發生在當您嘗試用一個已經登錄過的網址來註冊不同的Moodle網站。若要註冊重新安裝的Moodle網站（或是遷移的網站），您需要先刪除之前的註冊資料：{$a->deletesiteregistration}';
$string['emailtitlesiteadded'] = '{$a}網站已經被加到此課程集散中心';
$string['emailtitlesitedeleted'] = '{$a->sitename}已經從 {$a->hubname}課程集散中心刪除';
$string['emailtitlesiteurlchanged'] = '{$a} 網站已經改變了它的名稱或網址（請檢核）。';
$string['emailtitleurlalreadyexists'] = '另一個網站嘗試用{$a->existingsite} 網址註冊。';
$string['enabled'] = '啟用';
$string['enabled_help'] = '您可以啟用/停用這課程集散中心。';
$string['enablerssfeeds'] = 'RSS訂閱';
$string['enablerssfeeds_help'] = '如果啟用，一個RSS訂閱圖示將顯示在搜尋頁面的底部。如果停用，則無法讀取RSS。';
$string['enroldownload'] = '尋找';
$string['enroldownload_help'] = '有些課程列在刊登宣傳的清單中，使人們可以到原始網站上並參與課程。其他的課程典範提供您下載，以及在自己的Moodle網站上使用。';
$string['enrollable'] = '可選課的';
$string['enrollablecourses'] = '可選修的課程';
$string['errorbadimageheightwidth'] = '錯誤! 圖片最大不可超過{$a->width} X {$a->height}';
$string['errorlangnotrecognized'] = 'Moolde無法識別提供的語言編碼。請聯絡{$a}';
$string['errormaxpublication'] = '抱歉，您的網站今天已經發表超過{$a->maxpublication}個課程。您將在：{$a->time} 才可再發布。';
$string['errornopublication'] = '課程集散中心伺服器阻止所有新的發行。';
$string['errorregistration'] = '註冊時發生錯誤，請稍候再試。({$a})';
$string['errorunregistration'] = '課程集散中心註銷過程中出現錯誤，請稍後再試。 ({$a})';
$string['errorwrongpostdata'] = '一些POST的資料遺失，請使用Moodle的註冊表單。';
$string['errosecretandnameempty'] = '輸入一個秘密的數值或名稱';
$string['failunregistrationofprivate'] = '從集線器無法註銷登記冊頁（{}），再次嘗試。';
$string['featured'] = '精選';
$string['featureddesc'] = '精選為一個典範課程。';
$string['fileinfo'] = '語言： {$a->lang} - 授權：{$a->license} - 更新時間： {$a->timeupdated}';
$string['freshmoodleconfmsg'] = '您確定要用新的註冊資料取代之前的嗎？';
$string['freshmoodleregistrationerror'] = 'You are trying to register a site with a url that was previously used by a registered site. We\'ve sent an email to this previously registered site administrator. This administrator will have the choice to delete the previous registration record from the hub. If he/she decide to do it, then you will be able to register your site. Note: Usually you should be this administrator, but this step is required to avoid hacking. Thank you.

與以前使用的已註冊的站點的URL，要註冊的網站。
我們發送了一封電子郵件給此之前註冊的網站管理員。該管理員將可以選擇刪除先前的註冊記錄的樞紐。
如果他/她決定這樣做，那麼你就可以註冊您的網站。注：通常你應該是這樣的管理員，但這個步驟是必要的，以避免黑客攻擊。謝謝。';
$string['freshmoodleregistrationerror2'] = '您正嘗試登錄一個網站網址，這個網址以前是另一個網站註冊過。一個詢問確認已經送到這個網站的管理員。';
$string['freshtokenerror'] = '很抱歉，token無效或已被使用。';
$string['hideguestbutton'] = 'Moodle的變更“訪客登入按鈕”選項的值為“隱藏”。';
$string['hub'] = '課程集散中心';
$string['hubcoursessearch'] = '課程集散中心課程';
$string['hubdetails'] = '課程集散中心的細節';
$string['hubforceunregister'] = '強制註銷';
$string['hubimage'] = '圖片';
$string['hubimage_help'] = '此圖片被保存在您的課程集散中心磁碟。一旦在課程集散中心註冊，課程集散中心目錄將嘗試通過HTTP訪問這個圖像以緩存。如果課程集散中心目錄無法訪問到該圖像，無圖像將顯示在課程集散中心上的目錄清單。';
$string['hublang'] = '語言';
$string['hublang_help'] = '課程集散中心的主要語言。';
$string['hubpassword'] = '密碼';
$string['hubpassword_help'] = '如果您在這裡輸入密碼，任何網站要註冊時，將被要求輸入此密碼。我們建議您私下告知需要的網站管理員該密碼。只有私人的課程集散中心，可以設置一個密碼。';
$string['hubregister'] = '向Moodle.org註冊您的課程集散中心';
$string['hub:registercourse'] = '註冊/更新課程集散中心上的課程。';
$string['hubregisterupdate'] = '更新在Moodle.org的註冊資料';
$string['hubregistrationcomment'] = '您即將向Moodle.org註冊您的課程集散中心。 Moodle.org將定期聯繫此課程集散中心，以確保它仍然是活躍的，同時也更新此資訊。';
$string['hubunregister'] = '註銷';
$string['hub:unregistercourse'] = '從課程集散中心刪除課程。';
$string['hub:updateinfo'] = '更新已註冊的網站。';
$string['hubversion'] = '課程集散中心版本';
$string['hub:view'] = '檢視課程/網站。';
$string['hub:viewinfo'] = '查看詳細的課程集散中心資訊（聯繫方式，統計）。';
$string['hub:viewsmallinfo'] = '檢視課程集散中心訊息。';
$string['hubwsroledescription'] = '警告：請勿刪除或修改此角色。此角色是內部為註冊的網站、課程集散中心或Moodle.org而建立的。';
$string['hubwsuserdescription'] = '警告：請勿刪除或修改此用戶。此用戶是內部為註冊的網站、課程集散中心或Moodle.org而建立的。';
$string['image'] = '圖片';
$string['information'] = '資訊';
$string['keepcurrentimage'] = '保留目前的圖片';
$string['keepcurrentimage_help'] = '保留當前的圖片儲存在磁碟上。即使您選擇下面圖片，目前的圖片將被保留。如果取消選取，並且不選擇一個新的圖片，目前的圖片就會被刪掉。';
$string['keepscreenshot'] = '保留螢幕快照';
$string['keepscreenshot_help'] = '取消選取刪除這螢幕快照。';
$string['keywords'] = '關鍵字';
$string['keywords_help'] = '您可以在資料庫的名稱、說明和其他欄位，搜尋包含特定文字的課程。';
$string['language'] = '語言';
$string['language_help'] = '您可以課程特定的語言來搜尋';
$string['lastmodified'] = '最後修改';
$string['lastmodified_help'] = '針對某特定時段顯示最後修改的課程。';
$string['licence'] = '授權方式';
$string['licence_help'] = '您要以什麼授權方式散佈您的課程';
$string['logourl'] = 'Logo網址';
$string['managecourses'] = '管理課程';
$string['managesites'] = '管理網站';
$string['markstolen'] = '標記為被盜';
$string['markstolenmsg'] = 'Any sites related to this token are going to be removed from the site listing - A message will be sent to the site administrators asking them to register a new time - All people trying to register with 
此令牌有關的任何網站，從網站列表中刪除 -
一則消息將被發送到網站管理員，要求他們註冊一個新的時間 - 這個中心服務器，所有的人都將被要求重新嘗試註冊這個秘密秘密。';
$string['maxcoursesperday'] = '每天可發佈的課程數上限';
$string['maxcoursesperday_help'] = 'The maximum number of courses that can be published per site per day. This setting is to avoid automatic spam. Once reaching the maximum number, an error will be displayed on the registered site during the next 24 hours. (0 = none, empty = unlimited)最大數量的課程，每個站點每天可以發布。此設置是為了避免自動垃圾郵件。一旦達到最大數量，錯誤將在未來24小時內註冊的網站上顯示。 （0 =無，空=無限）';
$string['maxmessagesent'] = '您今天不能再發送訊息了，明天再試試看。';
$string['maxwscourseresult'] = '返回遠端網站的課程數上限';
$string['maxwscourseresultempty'] = '課程數上限必須是> 0';
$string['maxwscourseresult_help'] = '自訂當遠端Moodle網站請求，課程集散中心將送回課程的最大數量。（0或空白：代表沒有課程送回）';
$string['messagesentsuccess'] = '訊息發送成功';
$string['modulenumberaverage'] = '課程模組的平均數：({$a})';
$string['moodleorg'] = 'Moodle.org';
$string['moreinfo'] = '更多資訊';
$string['moved'] = '更新現有網站登錄的網址';
$string['movedorcopiedmsg'] = 'We detected that you try to register a Moodle 2 site that has already been registered on a different url. If you moved an existing Moodle 2 site to another url, then press \'Update registration url for an existing site\'. Your original Moodle 2 registration will be updated. In any other cases (you duplicated an existing site, you moved a Moodle 1.9 site to this url, you just did a fresh install...) press \'Register a new site\'. You will be redirected to your site to regenerate your site identifier and a clean registration can be processed.
我們檢測到您嘗試註冊一個Moodle網站，已經登記在一個不同的URL。
如果您移動現有的Moodle網站到另一個URL，然後按\'更新註冊為現有網站的網址。
原Moodle的註冊將被更新。在任何其他情況下，（你複製現有的網站，你提出一個Moodle 1.9網站，這個網址，你只是做了一個新的安裝...）按“註冊一個新的網站。
您將被重定向到您的網站重新生成您的站點標識符和一個乾淨的註冊就可以處理。';
$string['msgforcourse'] = '您有“{$a->hubname}”({$a->huburl})課程集散中心的課程新訊息：
--------------------------------------------------------------------------------------
來自：{$a->userfullname}
主題：“{$a->fullname}”，{$a->hubcourseurl}
訊息： {$a->message}
--------------------------------------------------------------------------------------
您可以透過電子郵件直接回覆或是使用課程集散中心({$a->userurl})傳送訊息。';
$string['msgforcoursetitle'] = '關於{$a}的訊息';
$string['msgforcoursetitlewithlink'] = '關於“\'{$a->fullname}”的訊息';
$string['msgtopublisher'] = '發送有關{$a}的訊息';
$string['msgtype'] = '類別';
$string['msgtypeappreciation'] = '欣賞/祝賀';
$string['msgtype_help'] = '選擇一個廣泛的類別，描述您的訊息。';
$string['msgtypeimprovement'] = '改進建議';
$string['msgtypeissue'] = '問題報告';
$string['msgtypequestion'] = '問題';
$string['mustbeemail'] = '必須是電子郵件。';
$string['mustbeinteger'] = '必須是一個整數。';
$string['mustbetext'] = '必須是純文字 -  無HTML。';
$string['mustbeurl'] = '必須是一個URL。';
$string['name'] = '名稱';
$string['name_help'] = '此名稱會顯示在課程列表中。';
$string['never'] = '從來沒有';
$string['newregistration'] = '新註冊';
$string['no'] = '否';
$string['nocomments'] = '沒有評論';
$string['nocourse'] = '沒有課程符合您的搜尋。';
$string['nocoursereturn'] = '課程集散中心已設置Web服務不返回任何課程。';
$string['nocourseselected'] = '沒有選擇課程';
$string['none'] = '無';
$string['noratings'] = '無評分';
$string['nosearch'] = '不發佈課程集散中心或課程';
$string['nosite'] = '還沒有註冊的網站或是符合搜尋條件的。';
$string['notregisteredonhub'] = '在您可以發佈課程之前，您的管理員需要至少向一個課程集散中心註冊。請聯繫您的網站管理員。';
$string['notregisteredonmoodleorg'] = '您的管理員需要在 moodle.org 註冊此網站。';
$string['operation'] = '動作';
$string['or'] = '或';
$string['orderby'] = '排序方式';
$string['orderbyeldest'] = '最舊';
$string['orderby_help'] = '搜尋結果顯示的順序。';
$string['orderbyname'] = '名稱';
$string['orderbynewest'] = '最新';
$string['orderbypublisher'] = '發行人';
$string['orderbyratingaverage'] = '精選';
$string['orenterprivatehub'] = '也可以輸入一個私人的課程集散中心的網址：';
$string['outcomes'] = '能力指標：{$a}';
$string['participantnumberaverage'] = '課程成員數平均值（{$a}）';
$string['password'] = '密碼';
$string['periodforteennight'] = '最近14天';
$string['periodmonth'] = '最近30天';
$string['periodweek'] = '最近7天';
$string['permalink'] = '固定網址';
$string['pluginname'] = '課程集散中心';
$string['postaladdress'] = '郵政地址';
$string['postsnumber'] = '貼文數({$a})';
$string['previousregistration'] = '先前登錄';
$string['prioritise'] = '優先';
$string['prioritise_help'] = '只顯示優先網站。';
$string['prioritiseno'] = '沒有';
$string['prioritiseyes'] = '是';
$string['privacy'] = '隱私';
$string['privacy_help'] = '課程集散中心可能會顯示註冊網站的清單。若它有顯示，那您可以選擇是否要出現在這清單上。';
$string['private'] = '私人的';
$string['privatehuburl'] = '私人的課程集散中心網址';
$string['publicationinfo'] = '課程發佈資訊';
$string['publicationmax'] = '每天可發佈的課程數上限';
$string['publicationmax_help'] = '這個網站每天可以發佈的課程數量上限。此設置是為了避免自動的垃圾發佈。一旦達到最大數量時，此網站在接下來的24小時內，將顯示錯誤。 （0 = 無，空白= 使用課程集散中心設定）';
$string['publichub'] = '公開的課程集散中心';
$string['publishcourseon'] = '發佈在{$a}';
$string['publisheremail'] = '發行人電子郵件';
$string['publisheremail_help'] = '發佈者電子郵件可讓課程集散中心管理員提醒出版者，有關發佈課程的狀態的任何改變。';
$string['publishername'] = '發行人';
$string['publishername_help'] = '發行人是指正式擁有這課程版權的個人或組織。除非您是替其他人發佈，否則通常此人就是您自己。';
$string['publishon'] = '發佈到';
$string['publishonmoodleorg'] = '發佈到MOOCH';
$string['publishonspecifichub'] = '發佈到另一課程集散中心';
$string['questionsnumber'] = '試題數({$a})';
$string['rating'] = '評價';
$string['recaptcha'] = '圖形驗證碼的設置';
$string['recaptchadisable'] = '圖形驗證碼金鑰沒有設置，請更改 {$a}';
$string['registeredcourses'] = '已註冊的課程';
$string['registeredsites'] = '已註冊的網站';
$string['registeron'] = '登錄您的網站';
$string['registeronmoodleorg'] = '登錄在 Moodle.org (MOOCH)網站';
$string['registeronspecifichub'] = '向特定課程集散中心註冊';
$string['registersite'] = '在{$a}註冊';
$string['registration'] = '中心伺服器註冊';
$string['registrationconfirmed'] = '網站註冊已經確認';
$string['registrationinfo'] = '註冊資訊';
$string['registrationupdated'] = '註冊已經被更新。';
$string['registrationupdatedfailed'] = '註冊更新失敗。';
$string['replaceregistrationbutton'] = '更換註冊資料！';
$string['resourcesnumber'] = '資源數({$a})';
$string['roleassignmentsnumber'] = '角色指派數({$a})';
$string['rsssecret'] = 'RSS密鑰';
$string['rsssecret_help'] = 'If the RSS secret is in the RSS URL (add \'?rsssecret=YOUR_RSS_SECRET\'), the rss feed will return not published courses instead of published ones. This is particularly usefull for the hub administrator to be easily alerted of new courses. You will need one RSS feed for enrollable courses and one for downloadable courses.
如果RSS的秘密是在的RSS URL（添加“：？rsssecret YOUR_RSS_SECRET”），RSS訂閱將返回未公佈的課程，而不是發布的信息。中心管理員可以很容易地提醒新課程，這是特別有用的。您將需要一個RSS飼料enrollable課程和一個可下載的課程。';
$string['rsstooltip'] = 'RSS feed of your search - Last published downloadable and enrollable courses are returned if no search were executed.
RSS訂閱您的搜索 - 最新發布的的下載和enrollable課程，如果沒有搜索返回被執行。';
$string['screenshots'] = '螢幕快照';
$string['search'] = '搜尋課程';
$string['searchfornologin'] = '公開的首頁搜尋';
$string['searchfornologin_help'] = 'If enabled, the course search form will be displayed on the front page for not logged in users. Note that if the hub privacy is set to private, this setting is ignored and the search form will be only displayed for logged users.
如果啟用，課程搜尋表單將顯示在首頁提供未登入的使用者。請注意，如果課程集散中心設置為“私人的”，此設定將被忽略，搜尋表單將只顯示給已登入的用戶。';
$string['searchsite'] = '搜尋網站';
$string['secret'] = '密鑰';
$string['secretblocked'] = '密鑰封鎖';
$string['secretisstolen'] = '您嘗試註冊一個標識符，它已被封鎖的網站（{}）。您會被重定向到您的Moodle網站來重新生成標識符。要重新生成的標識符，您的的Moodle網站必須有一個版本號> = 2011020901。';
$string['secretvalue'] = '密鑰 ：{$a}';
$string['seecreatornotes'] = '檢視建立者備註';
$string['selecthub'] = '選擇課程集散中心';
$string['sendfollowinginfo'] = '更多資訊';
$string['sendmessage'] = '發送訊息';
$string['sendto'] = '發送到';
$string['sentto'] = '發送到';
$string['senttohub'] = '{$a}課程集散中心管理員';
$string['senttopublisher'] = '課程發行人：{$a}';
$string['settings'] = '設定';
$string['settingsupdated'] = '設定已更新。';
$string['sharemore'] = '更多...';
$string['sharetofacebook'] = '分享到Facebook';
$string['sharetotwitter'] = '分享至Twitter';
$string['site'] = '網站';
$string['siteadmin'] = '網站管理員';
$string['siteadminemail'] = '管理員的電子郵件';
$string['siteadminemail_help'] = '管理員的電子郵件';
$string['siteadmin_help'] = '可聯絡的管理員姓名';
$string['sitecountry'] = '國家';
$string['sitecountry_help'] = '您的組織所在的國家。';
$string['sitecreated'] = '網站已經建立';
$string['sitedesc'] = '說明';
$string['sitedesc_help'] = '這些說明文字將會出現在網站清單上。請只使用純文字格式。';
$string['site_help'] = '只顯示這網站的課程。';
$string['sitehelpexplanation'] = '中心服務器上註冊的網站列表。要顯示一個網站頂部的
    搜索結果/的名單，proritise它。受信任的站點將被標記為可信的搜索結果/列表，和他們之前，將顯示不受信任的網站。
    優先的網站會自動信任。最後，僅可見的網站上顯示的搜索結果/列表（即使它們的優先級/信任的）。
    個多月無法訪問的網站，將被從數據庫中刪除（除非他們是值得信賴/優先）';
$string['sitekeywords'] = '關鍵字';
$string['sitekeywords_help'] = '您可以在資料庫的名稱、說明和其他欄位，搜尋包含特定文字的網站。';
$string['sitelang'] = '語言';
$string['sitelang_help'] = '您網站的主要語言，將會顯示在網站清單上';
$string['sitelanguage'] = '語言';
$string['sitelanguage_help'] = '網站主要的語言。';
$string['sitelinkpublished'] = '連結已發佈';
$string['sitelist'] = '網站列表';
$string['sitename'] = '網站名稱';
$string['sitename_help'] = '若課程集散中心允許，這名稱將會出現在網站清單上。';
$string['sitenamepublished'] = '發佈名稱';
$string['sitenotpublished'] = '未發佈';
$string['siteoperation'] = '網站操作';
$string['siteprivacy'] = '隱私';
$string['siteregconfcomment'] = '您的網站需要在{$a}做最後確認(為了防止{$a}上的垃圾廣告)';
$string['siteregistration'] = '網站註冊';
$string['siteregistrationupdated'] = '網站註冊已經更新';
$string['sitesearch'] = '搜尋網站';
$string['sitesecretalreadyexist'] = '課程集散中心無法處理這註冊資料，因為其他網站已經用相同識別碼註冊了。';
$string['sitesettings'] = '網站設定';
$string['sitesettingsform'] = '“{$a}”設定';
$string['sitesettingsupdated'] = '{$a}設定已更新。';
$string['siteupdated'] = '{$a}已成功更新。';
$string['siteurl'] = '網站網址';
$string['siteurl_help'] = '這一網站的網址。若隱私設定為允許人們看見網站位址，那這網址將被看見。';
$string['sitevisibility'] = '顯示';
$string['sitevisibility_help'] = '顯示可見的網站、隱藏的網站或兩者同時。';
$string['specifichub'] = '特定的課程集散中心';
$string['specifichubpublicationdetail'] = '您可以發佈到另一個課程集散中心。';
$string['specifichubregistrationdetail'] = '您也可以將其他社群課程集散中心登錄到您的網站。';
$string['statistics'] = '統計的隱私';
$string['stolensecret'] = '被盜的密鑰';
$string['subject'] = '教育主題';
$string['subject_help'] = '選擇這一課程所屬的主要學科領域。';
$string['subjects'] = '主題';
$string['tags'] = '標籤';
$string['tags_help'] = '標籤有助於將課程歸類，並容易被找到。請使用簡單、有意義的字，並以逗點隔開。例如： 數學,代數,幾何';
$string['trusted'] = '受信任的';
$string['trusted_help'] = '只顯示設為受信任的網站。';
$string['trustedno'] = '沒有';
$string['trustedyes'] = '是';
$string['trustme'] = '信任';
$string['typedownloadable'] = '可下載的';
$string['typeenrollable'] = '可選修的';
$string['unlistedurl'] = '未列出的課程集散中心網址';
$string['unprioritise'] = '無優先的';
$string['unregistersite'] = '註銷網站';
$string['unregistersiteandcourses'] = '註銷網站和所有課程';
$string['unregistrationofprivate'] = '該課程集散中心已經從集散中心目錄註銷。';
$string['untrustme'] = '不被信任的';
$string['updatesite'] = '在{$a}更新註冊資料';
$string['url'] = '課程集散中心網址';
$string['urlalreadyexist'] = '您的新網站網址已經存在於{$a}。它可能來自於{$a}壞的資料庫或是先前的註冊資料。提醒課程集散中心管理員。您必須註銷您的網站註冊，然後再次註冊。如果您想保有您已經發佈的課程，您必須告訴課程集散中心管理員，需要請他刪除您先前註冊的資料。';
$string['userinfo'] = '建立者：{$a->creatorname} - 發行人：{$a->publishername}';
$string['usersnumber'] = '用戶數({$a})';
$string['visibility'] = '顯示';
$string['visibilityall'] = '任意';
$string['visibility_help'] = '顯示可見的課程、隱藏的課程或兩者同時。';
$string['visibilityno'] = '隱藏';
$string['visibilityyes'] = '顯示';
$string['visitdemo'] = '看展示';
$string['visitsite'] = '瀏覽網站';
$string['wronghubpassword'] = '課程集散中心的密碼錯誤，請按繼續，然後再試一次。';
$string['wrongurlformat'] = '錯誤的網址格式';
$string['xmlrpcdisabled'] = '未啟用伺服器上的XML-RPC延伸套件。在此套件啟用前，您無法管理您的課程集散中心。';
$string['yeswithmoodle'] = '是的，有Moodle';
$string['yeswithoutmoodle'] = '是的，沒有Moodle';
