<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'zh_tw', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = '請注意: 這個官方的Moodle行動應用程式將只與已設定允許它的Moodle網站上運作.  如果您在連接時遇到任何問題, 請與您的Moodle管理員聯繫.

如果您的Moodle網站已正確設定, 您可以使用此應用程式:

- 瀏覽您的課程內容, 就算是在離線的時候
- 接收訊息和其他事件的即時通知
- 快速找到並聯繫您的課程中的其他人
- 從您的行動裝置上傳圖片, 錄音, 錄影和其他檔案
- 查看您的課程成績
- 和更多！

有關所有最新資訊, 請參閱http://docs.moodle.org/en/Mobile_app

我們真的很感激針對目前為止的功能有任何好的評論,  以及其他您想要這個應用程式做什麼的建議!

該應用程式需要以下權限:
錄製聲音 - 用於錄製聲音上傳到Moodle
讀取和修改SD卡的內容 - 內容下載到SD卡, 以便您可以離線觀看
網路存取 - 能夠與您的Moodle網站連接, 並檢查您是否已連接或切換到離線模式
在啟動時運行 - 因此即使應用程式在後台運行, 您也會收到本端的通知
防止電話進入休眠狀態 - 因此您可以隨時接收到推出的通知';
$string['mma.calendar.calendarevents'] = '行事曆';
$string['mma.calendar.errorloadevent'] = '載入事件時出現錯誤';
$string['mma.calendar.errorloadevents'] = '載入事件時出現錯誤';
$string['mma.calendar.noevents'] = '沒有事件';
$string['mma.calendar.notifications'] = '通知';
$string['mma.competency.errornocompetenciesfound'] = '找不到能使用的功能';
$string['mma.competency.mylearningplans'] = '我的學習計畫';
$string['mma.competency.nocompetencies'] = '沒有功能';
$string['mma.coursecompletion.complete'] = '完成';
$string['mma.coursecompletion.completecourse'] = '完成課程';
$string['mma.coursecompletion.completed'] = '已完成';
$string['mma.coursecompletion.completiondate'] = '完成日期';
$string['mma.coursecompletion.couldnotloadreport'] = '無法載入課程完成報表,請稍後再試.';
$string['mma.coursecompletion.coursecompletion'] = '課程完成度';
$string['mma.coursecompletion.criteria'] = '條件';
$string['mma.coursecompletion.criteriagroup'] = '條件群組';
$string['mma.coursecompletion.criteriarequiredall'] = '以下所有的條件都為必填';
$string['mma.coursecompletion.criteriarequiredany'] = '以下任何條件都為必須';
$string['mma.coursecompletion.inprogress'] = '處理中';
$string['mma.coursecompletion.manualselfcompletion'] = '手動自我完成';
$string['mma.coursecompletion.notyetstarted'] = '還沒有開始';
$string['mma.coursecompletion.pending'] = '暫緩';
$string['mma.coursecompletion.required'] = '必須的';
$string['mma.coursecompletion.requiredcriteria'] = '必須條件';
$string['mma.coursecompletion.requirement'] = '需要';
$string['mma.coursecompletion.status'] = '狀態';
$string['mma.coursecompletion.viewcoursereport'] = '檢視課程報表';
$string['mma.files.admindisableddownload'] = '請注意, 您的Moodle管理員禁止檔案下載, 您可以瀏覽檔案, 但不能下載它們.';
$string['mma.files.audio'] = '錄音';
$string['mma.files.camera'] = '照相機';
$string['mma.files.chooseaccountuploadfile'] = '選擇一個帳號去上傳檔案';
$string['mma.files.clicktoupload'] = '點選這個按鈕,將檔案上傳到你的個人檔案區';
$string['mma.files.confirmuploadfile'] = '您即將上傳{{size}}. 您確定要繼續嗎？';
$string['mma.files.couldnotloadfiles'] = '這些檔案是不能被載入的';
$string['mma.files.downloading'] = '下載中';
$string['mma.files.emptyfilelist'] = '沒有檔案可以顯示';
$string['mma.files.errorcapturingaudio'] = '截取錄音資料錯誤';
$string['mma.files.errorcapturingimage'] = '截取畫面錯誤';
$string['mma.files.errorcapturingvideo'] = '截取錄影資料錯誤';
$string['mma.files.errorgettingimagealbum'] = '從相簿讀取影像檔發生錯誤';
$string['mma.files.errormustbeonlinetoupload'] = '你必須上線才能上傳檔案';
$string['mma.files.errornoapp'] = '您沒有安裝應用程式來執行此動作.';
$string['mma.files.errorreadingfile'] = '讀取檔案發生錯誤';
$string['mma.files.errorreceivefilenosites'] = '沒有儲存的網站. 請在嘗試上傳檔案之前新增一個網站.';
$string['mma.files.erroruploadnotworking'] = '很抱歉, 目前無法將檔案上傳到您的網站.';
$string['mma.files.errorwhiledownloading'] = '當試著去下載檔案時發生錯誤';
$string['mma.files.errorwhilerecordingaudio'] = '當試著去錄音時發生錯誤';
$string['mma.files.errorwhileuploading'] = '上傳檔案時發生錯誤';
$string['mma.files.fileuploaded'] = '檔案上傳成功';
$string['mma.files.myfiles'] = '我的檔案';
$string['mma.files.myprivatefiles'] = '個人專用檔案';
$string['mma.files.myprivatefilesdesc'] = '在此Moodle網站上, 您的私有區域中有可用的文件';
$string['mma.files.photoalbums'] = '相簿';
$string['mma.files.readingfile'] = '讀取檔案';
$string['mma.files.sitefilesdesc'] = '您在此Moodle網站上有可用的其他文件.';
$string['mma.files.success'] = '成功!';
$string['mma.files.uploadfiles'] = '上傳檔案';
$string['mma.files.uploading'] = '上傳中';
$string['mma.files.video'] = '錄影';
$string['mma.frontpage.frontpage'] = '首頁';
$string['mma.grades.itemname'] = '成績項目';
$string['mma.messageoutput_airnotifier.processorsettingsdesc'] = '設定裝置';
$string['mma.messages.contactlistempty'] = '聯絡人清單沒有資料';
$string['mma.messages.contactname'] = '聯絡人名稱';
$string['mma.messages.errordeletemessage'] = '刪除訊息時發生錯誤.';
$string['mma.messages.errorwhileretrievingcontacts'] = '從伺服器存取聯絡人時出錯';
$string['mma.messages.errorwhileretrievingdiscussions'] = '從伺服器存取討論區時出錯';
$string['mma.messages.errorwhileretrievingmessages'] = '從伺服器存取訊息時出錯';
$string['mma.messages.messagenotsent'] = '訊息未發送, 請稍後再試.';
$string['mma.messages.mustbeonlinetosendmessages'] = '您必須上線才能發送訊息';
$string['mma.messages.newmessage'] = '新訊息...';
$string['mma.messages.nomessages'] = '沒有任何訊息.';
$string['mma.messages.nousersfound'] = '沒有使用者';
$string['mma.messages.type_blocked'] = '已停止';
$string['mma.messages.type_offline'] = '離線';
$string['mma.messages.type_online'] = '上線';
$string['mma.messages.type_search'] = '搜尋結果';
$string['mma.messages.type_strangers'] = '其他';
$string['mma.messages.warningmessagenotsent'] = '無法傳送訊息給使用者 {{user}}. {{error}}';
$string['mma.mod_assign.acceptsubmissionstatement'] = '請接受提交聲明.';
$string['mma.mod_assign.cannoteditduetostatementsubmission'] = '您無法在應用程式中新增或編輯提交內容, 因為我們無法從該網站擷取提交內容.';
$string['mma.mod_assign.cannotgradefromapp'] = '應用程式尚未支援部分評分方式, 無法修改.';
$string['mma.mod_assign.cannotsubmitduetostatementsubmission'] = '您無法在應用程式中提交評分,  因為我們無法從網站存取提交聲明';
$string['mma.mod_assign.erroreditpluginsnotsupported'] = '您無法在應用程式中新增或修改提交, 因為某些外掛不支援編輯:';
$string['mma.mod_assign.errorshowinginformation'] = '我們無法顯示提交資訊';
$string['mma.mod_assign.feedbacknotsupported'] = '該應用程式不支援此回饋, 並且可能不包含所有資訊';
$string['mma.mod_assign.notallparticipantsareshown'] = '沒有提交的參與者不會被顯示出來';
$string['mma.mod_assign.submissionnotsupported'] = '該應用程式不支援此提交, 並且可能不包含所有資訊';
$string['mma.mod_assign.userwithid'] = 'ID為{{id}}的使用者';
$string['mma.mod_assign.warningsubmissiongrademodified'] = '在網站上修改了提交成績.';
$string['mma.mod_assign.warningsubmissionmodified'] = '使用者的提交已在網站中修改.';
$string['mma.mod_chat.errorwhileconnecting'] = '連接到聊天時出錯.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = '取得聊天資料時發生錯誤.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = '取得聊天使用者時發生錯誤.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = '從伺服器存取訊息時發生錯誤';
$string['mma.mod_chat.errorwhilesendingmessage'] = '當傳送訊息時發生錯誤';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = '您必須上線才能傳送訊息';
$string['mma.mod_choice.errorgetchoice'] = '取得選項資料時出錯';
$string['mma.mod_choice.numberofuser'] = '參與者人數';
$string['mma.mod_choice.numberofuserinpercentage'] = '參與者百分比';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}}％的使用者選擇了選項: {{text}}.';
$string['mma.mod_choice.resultsnotsynced'] = '結果不包括您的上次回覆. 請同步更新.';
$string['mma.mod_folder.emptyfilelist'] = '沒有檔案可以顯示';
$string['mma.mod_folder.errorwhilegettingfolder'] = '當讀取資料夾資料時發生錯誤';
$string['mma.mod_forum.erroremptysubject'] = '貼文的標題不可以是空的';
$string['mma.mod_forum.errorgetforum'] = '讀取討論區資料發生錯誤';
$string['mma.mod_forum.errorgetgroups'] = '讀取群組設定發生錯誤';
$string['mma.mod_forum.forumnodiscussionsyet'] = '這個討論區還沒有討論主題';
$string['mma.mod_forum.group'] = '群組';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}}篇討論';
$string['mma.mod_forum.numreplies'] = '{{numreplies}}個回覆';
$string['mma.mod_forum.refreshdiscussions'] = '更新討論區';
$string['mma.mod_forum.refreshposts'] = '更新討論區貼文';
$string['mma.mod_forum.sortnewestfirst'] = '優先顯示最新的項目';
$string['mma.mod_forum.sortoldestfirst'] = '優先顯示最早的項目';
$string['mma.mod_glossary.browsemode'] = '瀏覽條目';
$string['mma.mod_glossary.byalphabet'] = '按字母順序排列';
$string['mma.mod_glossary.byauthor'] = '以作者為分群';
$string['mma.mod_glossary.bynewestfirst'] = '最新的優先';
$string['mma.mod_glossary.byrecentlyupdated'] = '最近的更新';
$string['mma.mod_glossary.bysearch'] = '搜尋';
$string['mma.mod_glossary.entrypendingapproval'] = '這個項目已被暫緩核可';
$string['mma.mod_glossary.errorloadingentries'] = '載入項目時發生錯誤';
$string['mma.mod_glossary.errorloadingentry'] = '載入項目時發生錯誤';
$string['mma.mod_glossary.errorloadingglossary'] = '載入詞彙表時發生錯誤.';
$string['mma.mod_glossary.noentriesfound'] = '未找到條目.';
$string['mma.mod_glossary.searchquery'] = '搜索查詢';
$string['mma.mod_imscp.showmoduledescription'] = '顯示說明';
$string['mma.mod_label.label'] = '標籤';
$string['mma.mod_label.taptoview'] = '點擊查看標籤';
$string['mma.mod_lti.errorgetlti'] = '取得模組資料時出錯';
$string['mma.mod_lti.errorinvalidlaunchurl'] = '啟動網址無效';
$string['mma.mod_lti.launchactivity'] = '啟動活動';
$string['mma.mod_page.errorwhileloadingthepage'] = '載入頁面內容時出錯';
$string['mma.mod_quiz.cannotsubmitquizdueto'] = '此測驗嘗試無法提交, 原因如下:';
$string['mma.mod_quiz.confirmcontinueoffline'] = '自{{$ a}}之後, 此嘗試尚未恢復同步.  如果您在此後在其他設備上繼續此嘗試, 您可能會遺失資料.';
$string['mma.mod_quiz.confirmleavequizonerror'] = '存入答案時發生錯誤. 您確定要離開測驗嗎?';
$string['mma.mod_quiz.errorbehaviournotsupported'] = '此測驗不能在應用程式中嘗試進行, 因為應用程式不支援此行為:';
$string['mma.mod_quiz.errordownloading'] = '下載必要資料時出錯';
$string['mma.mod_quiz.errorgetattempt'] = '取得嘗試資料時出錯';
$string['mma.mod_quiz.errorgetquestions'] = '取得問題時出錯';
$string['mma.mod_quiz.errorgetquiz'] = '取得測驗資料時出錯';
$string['mma.mod_quiz.errorparsequestions'] = '閱讀問題時發生錯誤. 請在網路瀏覽器中嘗試進行此測驗.';
$string['mma.mod_quiz.errorquestionsnotsupported'] = '此測驗不能在應用程式中嘗試進行, 因為它可能包含應用程式不支援的問題:';
$string['mma.mod_quiz.errorrulesnotsupported'] = '此測驗不能在應用程式中嘗試，因為它具有應用程序不支持的存取規則：';
$string['mma.mod_quiz.errorsaveattempt'] = '存入嘗試資料時發生錯誤.';
$string['mma.mod_quiz.errorsyncquiz'] = '同步時發生錯誤. 請再試一次.';
$string['mma.mod_quiz.errorsyncquizblocked'] = '由於正在進行的程序, 此測驗無法立即同步.  請稍後再試.  如果問題仍然存在, 請嘗試重新啟動應用程式.';
$string['mma.mod_quiz.finishnotsynced'] = '已完成但未同步';
$string['mma.mod_quiz.hasdatatosync'] = '此測驗有離線資料要做同步';
$string['mma.mod_quiz.opentoc'] = '打開導航彈出視窗.';
$string['mma.mod_quiz.warningattemptfinished'] = '由於在網站上已完成或找不到, 因此捨棄離線嘗試.';
$string['mma.mod_quiz.warningdatadiscarded'] = '一些離線的答案被捨棄, 因為問題在上線時被修改了.';
$string['mma.mod_quiz.warningdatadiscardedfromfinished'] = '嘗試未完成, 因為一些離線答案被捨棄.  請檢查您的答案, 然後重新提交嘗試.';
$string['mma.mod_resource.errorwhileloadingthecontent'] = '載入內容時發生錯誤.';
$string['mma.mod_resource.openthefile'] = '開啟檔案';
$string['mma.mod_scorm.cannotcalculategrade'] = '無法計算成績';
$string['mma.mod_scorm.dataattemptshown'] = '此資料屬於嘗試編號{{number}}.';
$string['mma.mod_scorm.errorcreateofflineattempt'] = '建立新的離線嘗試時發生錯誤. 請再試一次.';
$string['mma.mod_scorm.errordownloadscorm'] = '下載SCORM時出錯: “{{name}}”.';
$string['mma.mod_scorm.errorgetscorm'] = '取得SCORM資料時出錯';
$string['mma.mod_scorm.errorinvalidversion'] = '很抱歉, 本應用程序僅支援SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = '您的Moodle網站禁止SCORM軟體的下載.  請與您的Moodle網站管理員聯繫.';
$string['mma.mod_scorm.errornovalidsco'] = '此SCORM沒有可見的SCO供載入.';
$string['mma.mod_scorm.errorpackagefile'] = '很抱歉, 該應用程式只支援ZIP.';
$string['mma.mod_scorm.errorsyncscorm'] = '同步時發生錯誤. 請再試一次.';
$string['mma.mod_scorm.lastsync'] = '最後的同步';
$string['mma.mod_scorm.offlineattemptnote'] = '此嘗試包含尚未同步的資料.';
$string['mma.mod_scorm.offlineattemptovermax'] = '無法發送此嘗試, 因為您超過了最大嘗試次數.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = '此SCORM未下載. 它會在您打開時自動下載.';
$string['mma.mod_scorm.scormstatusoutdated'] = '此SCORM自上次下載以來已被修改. 它會在您打開時自動下載.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = '嘗試{{number}}的某些離線資料已被刪除, 因為無法建立新的嘗試.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = '某些嘗試無法與網站同步, 因為上次上線嘗試未完成, 請先完成上線嘗試.';
$string['mma.mod_survey.cannotsubmitsurvey'] = '很抱歉, 提交您的問卷調查時發生問題.  請再試一次.';
$string['mma.mod_survey.errorgetsurvey'] = '取得調查資料時出錯';
$string['mma.mod_survey.results'] = '結果';
$string['mma.mod_url.accessurl'] = '存取URL';
$string['mma.mod_url.pointingtourl'] = '此資源所指向的網址';
$string['mma.mod_wiki.errorloadingpage'] = '載入頁面時出錯';
$string['mma.mod_wiki.errornowikiavailable'] = '這個維基詞條沒有內容';
$string['mma.mod_wiki.gowikihome'] = '到維基百科';
$string['mma.mod_wiki.page'] = '分頁';
$string['mma.mod_wiki.subwiki'] = 'Subwiki';
$string['mma.mod_wiki.titleshouldnotbeempty'] = '標題不能為空';
$string['mma.mod_wiki.viewpage'] = '檢視頁面';
$string['mma.mod_wiki.wikipage'] = '維基頁面';
$string['mma.notes.addnewnote'] = '新增註記';
$string['mma.notes.coursenotes'] = '課程註記';
$string['mma.notes.eventnotecreated'] = '註記已被建立';
$string['mma.notes.nonotes'] = '還沒有這種類型的註記';
$string['mma.notes.note'] = '註記';
$string['mma.notes.notes'] = '註記';
$string['mma.notes.personalnotes'] = '個人註記';
$string['mma.notes.publishstate'] = '上下文';
$string['mma.notes.sitenotes'] = '網站註記';
$string['mma.notes.userwithid'] = '使用者編號 {{id}}';
$string['mma.notes.warningnotenotsent'] = '無法新增註冊到課程 {{course}}. {{error}}';
$string['mma.notifications.errorgetnotifications'] = '取得通知資料發生錯誤';
$string['mma.notifications.notificationpreferences'] = '通知偏好設定';
$string['mma.notifications.notifications'] = '通知';
$string['mma.notifications.therearentnotificationsyet'] = '沒有通知訊息';
$string['mma.participants.noparticipants'] = '這個課程沒有參與者';
$string['mma.participants.participants'] = '參與者';
$string['mm.contentlinks.chooseaccount'] = '選擇帳號';
$string['mm.contentlinks.chooseaccounttoopenlink'] = '選擇一個帳號以開啟連結';
$string['mm.contentlinks.confirmurlothersite'] = '這個連結屬於其他的網站. 你確定要開啟嗎?';
$string['mm.contentlinks.errornoactions'] = '找不到要使用此連結執行的操作';
$string['mm.contentlinks.errornosites'] = '找不到任何網站來處理此連結';
$string['mm.core.accounts'] = '帳號';
$string['mm.core.android'] = '安卓';
$string['mm.core.cannotconnect'] = '無法連接：請確認您輸入之網址正確，且您的位置使用的是Moodle2.4版或更新版本。';
$string['mm.core.cannotdownloadfiles'] = '在您的行動服務中禁用檔案下載. 請與您的網站管理員聯繫.';
$string['mm.core.clearsearch'] = '清除搜尋';
$string['mm.core.clicktoseefull'] = '點擊以看到詳細內容';
$string['mm.core.commentsnotworking'] = '無法取得評論資料';
$string['mm.core.completion-alt-auto-fail'] = '已完成: {{$a}} (did not achieve pass grade)';
$string['mm.core.completion-alt-auto-n'] = '未完成: {{$a}}';
$string['mm.core.completion-alt-auto-pass'] = '已完成: {{$a}} (achieved pass grade)';
$string['mm.core.completion-alt-auto-y'] = '已完成: {{$a}}';
$string['mm.core.completion-alt-manual-n'] = '未完成: {{$ a}}.  選擇標記為完成.';
$string['mm.core.completion-alt-manual-y'] = '已完成: {{$ a}}. 選擇標記為未完成.';
$string['mm.core.confirmcanceledit'] = '您確定要離開此頁面嗎? 所有的修改將會遺失.';
$string['mm.core.confirmopeninbrowser'] = '你想要在瀏覽器內開啟嗎?';
$string['mm.core.contenteditingsynced'] = '您正在編輯的內容已同步.';
$string['mm.core.currentdevice'] = '目前的裝置';
$string['mm.core.datastoredoffline'] = '儲存在設備中的資料，因為它之前無法發送.  它稍後將自動發送.';
$string['mm.core.deleting'] = '刪除中';
$string['mm.core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'h[:]mm A';
$string['mm.core.discard'] = '捨棄';
$string['mm.core.dismiss'] = '除去';
$string['mm.core.downloading'] = '下載中';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = '更改完成狀態時發生錯誤. 請再試一次.';
$string['mm.core.errordeletefile'] = '刪除檔案時出錯. 請再試一次.';
$string['mm.core.errordownloading'] = '下載檔案時發生錯誤';
$string['mm.core.errordownloadingsomefiles'] = '下載模組檔案時出錯. 某些檔案可能會遺失';
$string['mm.core.errorfileexistssamename'] = '已有一個具有此名稱的檔案';
$string['mm.core.errorinvalidform'] = '表單包含無效的資料. 請確認填寫所有必填欄位, 並確認資料有效.';
$string['mm.core.errorinvalidresponse'] = '接收的回應無效.  如果錯誤仍然存在, 請與您的Moodle網站管理員聯繫.';
$string['mm.core.erroropenfilenoapp'] = '打開檔案時發生錯誤: 找不到應用程式打開此類檔案.';
$string['mm.core.erroropenfilenoextension'] = '打開檔案時發生錯誤: 檔案沒有副檔名.';
$string['mm.core.erroropenpopup'] = '此活動正在嘗試打開一個彈出視窗. 此應用程式不支援這項功能.';
$string['mm.core.errorrenamefile'] = '重新命名檔案時發生錯誤. 請再試一次.';
$string['mm.core.errorsync'] = '同步時出錯. 請再試一次.';
$string['mm.core.errorsyncblocked'] = '由於程序正在進行, 此{{$ a}}目前無法同步.  請稍後再試. 如果問題仍然存在, 請嘗試重新啟動應用程式.';
$string['mm.core.filenameexist'] = '檔案名已存在: {{$ a}}';
$string['mm.core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['mm.core.hasdatatosync'] = '此{{$ a}}有離線資料要同步.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = '圖片';
$string['mm.core.imageviewer'] = '影像檢視器';
$string['mm.core.info'] = '資料';
$string['mm.core.ios'] = 'iOS';
$string['mm.core.lastsync'] = '最後同步';
$string['mm.core.lostconnection'] = '我們已斷了線，您需重新連線。您的口令目前是無效的。';
$string['mm.core.mod_assign'] = '分配';
$string['mm.core.mod_assignment'] = '分配';
$string['mm.core.mod_book'] = '預定';
$string['mm.core.mod_chat'] = '交談';
$string['mm.core.mod_choice'] = '選擇';
$string['mm.core.mod_data'] = '資料庫';
$string['mm.core.mod_database'] = '資料庫';
$string['mm.core.mod_external-tool'] = '外部工具';
$string['mm.core.mod_feedback'] = '回饋';
$string['mm.core.mod_file'] = '檔案';
$string['mm.core.mod_folder'] = '資料夾';
$string['mm.core.mod_forum'] = '討論區';
$string['mm.core.mod_glossary'] = '詞彙表';
$string['mm.core.mod_ims'] = 'IMS內容套件';
$string['mm.core.mod_imscp'] = 'IMS內容套件';
$string['mm.core.mod_label'] = '標籤';
$string['mm.core.mod_lesson'] = '課程';
$string['mm.core.mod_lti'] = '外部工具';
$string['mm.core.mod_page'] = '分頁';
$string['mm.core.mod_quiz'] = '測驗';
$string['mm.core.mod_resource'] = '資源';
$string['mm.core.mod_scorm'] = 'SCORM套件';
$string['mm.core.mod_survey'] = '調查';
$string['mm.core.mod_url'] = '網址';
$string['mm.core.mod_wiki'] = '維基百科';
$string['mm.core.mod_workshop'] = '工作坊';
$string['mm.core.mygroups'] = '我的群組';
$string['mm.core.networkerrormsg'] = '網路未啟用或未運作。';
$string['mm.core.nopasswordchangeforced'] = '你若沒有更新密碼無法進行此處理';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.notsent'] = '沒有傳送';
$string['mm.core.offline'] = '離線';
$string['mm.core.online'] = '上線';
$string['mm.core.openfullimage'] = '點擊這裡以圖像原尺寸顯示';
$string['mm.core.openinbrowser'] = '以瀏覽器開啟';
$string['mm.core.othergroups'] = '其他群組';
$string['mm.core.percentagenumber'] = '{{$a}}%';
$string['mm.core.pulltorefresh'] = '拖曳更新';
$string['mm.core.redirectingtosite'] = '您將被重定向到網站.';
$string['mm.core.requireduserdatamissing'] = '此使用者缺少一些必需的配置資料. 請在您的Moodle中填寫此數據, 然後重試.<br> {{$ a}}';
$string['mm.core.retry'] = '重試';
$string['mm.core.searching'] = '搜尋中';
$string['mm.core.sending'] = '傳送中';
$string['mm.core.showmore'] = '顯示更多...';
$string['mm.core.sitemaintenance'] = '這個網站在維護中目前無法使用';
$string['mm.core.sizetb'] = 'TB';
$string['mm.core.sorry'] = '抱歉...';
$string['mm.core.success'] = '成功!';
$string['mm.core.tablet'] = '平板';
$string['mm.core.thereisdatatosync'] = '有離線的{{$ a}}要同步';
$string['mm.core.tryagain'] = '再試一次';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.uhoh'] = '噢哦!';
$string['mm.core.unexpectederror'] = '無法預期的錯誤. 請關閉並重新開啟應用程式, 再試一次.';
$string['mm.core.unknown'] = '未知';
$string['mm.core.unzipping'] = '解壓縮中';
$string['mm.core.warningofflinedatadeleted'] = '離線資料 {{component}} \'{{name}}\' 已被刪除. {{error}}';
$string['mm.core.whoops'] = '糟糕!';
$string['mm.core.whyisthishappening'] = '為什麼會發生這種情況呢?';
$string['mm.core.windowsphone'] = 'Windows Phone';
$string['mm.core.wsfunctionnotavailable'] = '行動服務功能無法使用';
$string['mm.course.activitynotyetviewable'] = '此應用程式尚未檢視這項活動.';
$string['mm.course.activitynotyetviewablegothere'] = '此應用程式尚未檢視這項活動或資源, 請按底下的按鈕從網站存取.';
$string['mm.course.activitynotyetviewableinapp'] = '我們正在努力支援{{$ a}}活動.';
$string['mm.course.activitynotyetviewableremoteaddon'] = '您的組織安裝了尚未支援的外掛';
$string['mm.course.activitynotyetviewablesiteupgradeneeded'] = '您的組織的Moodle安裝需要更新.';
$string['mm.course.allsections'] = '全部';
$string['mm.course.askadmintosupport'] = '請與網站管理員聯繫, 告知他們您要使用Moodle Mobile應用程式使用此活動.';
$string['mm.course.confirmdeletemodulefiles'] = '您確定要刪除此模組檔案嗎?';
$string['mm.course.confirmdownload'] = '您即將下載{{size}}. 您確定您要繼續嗎?';
$string['mm.course.confirmdownloadsection'] = '您即將下載{{size}}. 您確定您要繼續嗎?';
$string['mm.course.confirmdownloadunknownsize'] = '我們無法計算下載的容量. 您確定要下載嗎?';
$string['mm.course.confirmpartialdownloadsize'] = '您即將下載<strong>至少</ strong> {{size}}. 您確定您要繼續嗎?';
$string['mm.course.contents'] = '內容';
$string['mm.course.couldnotloadsectioncontent'] = '無法載入區塊內容, 請稍後再試.';
$string['mm.course.couldnotloadsections'] = '無法載入區塊, 請稍後再試.';
$string['mm.course.errordownloadingsection'] = '載入區塊時發生錯誤';
$string['mm.course.errorgetmodule'] = '取得模組資料時出現錯誤';
$string['mm.course.gotothesite'] = '連到網站';
$string['mm.course.nocontentavailable'] = '目前無內容可使用';
$string['mm.courses.confirmselfenrol'] = '您確定要註冊本課程嗎?';
$string['mm.courses.enrolme'] = '註冊報名';
$string['mm.courses.errorloadcourses'] = '載入課程時出錯.';
$string['mm.courses.errorsearching'] = '搜索時出錯.';
$string['mm.courses.errorselfenrol'] = '自行註冊時出現錯誤.';
$string['mm.courses.filtermycourses'] = '過濾我的課程';
$string['mm.courses.frontpage'] = '首頁';
$string['mm.course.showall'] = '顯示全部';
$string['mm.courses.nocourses'] = '沒有課程資料可以顯示';
$string['mm.courses.nosearchresults'] = '您的搜索沒有任何結果.';
$string['mm.courses.notenroled'] = '您沒有註冊此課程';
$string['mm.courses.notenrollable'] = '您無法註冊本課程.';
$string['mm.courses.password'] = '註冊碼';
$string['mm.courses.searchcoursesadvice'] = '您可以使用搜尋課程按鈕以訪客身份登入, 或在允許它的課程中註冊';
$string['mm.courses.selfenrolment'] = '自行註冊';
$string['mm.courses.totalcoursesearchresults'] = '課程總數: {{$a}}';
$string['mm.course.useactivityonbrowser'] = '你可以以瀏覽器一直使用';
$string['mm.course.whoops'] = '糟糕!';
$string['mm.fileuploader.addfiletext'] = '新增檔案';
$string['mm.fileuploader.audio'] = '聲音';
$string['mm.fileuploader.camera'] = '相機';
$string['mm.fileuploader.confirmuploadfile'] = '你已上傳 {{size}}. 你確定想繼續嗎?';
$string['mm.fileuploader.confirmuploadunknownsize'] = '我們無法去計算上傳檔案的容量.你確定想繼續嗎?';
$string['mm.fileuploader.errorcapturingaudio'] = '錄製聲音時發生錯誤';
$string['mm.fileuploader.errorcapturingimage'] = '擷取圖片時發生錯誤.';
$string['mm.fileuploader.errorcapturingvideo'] = '錄製影片時發生錯誤';
$string['mm.fileuploader.errorgettingimagealbum'] = '從相簿裡取得圖片發生錯誤.';
$string['mm.fileuploader.errormustbeonlinetoupload'] = '您必須上線才能上傳檔案.';
$string['mm.fileuploader.errornoapp'] = '您沒有安裝應用程式來執行此動作.';
$string['mm.fileuploader.errorreadingfile'] = '讀取檔案發生錯誤.';
$string['mm.fileuploader.errorwhileuploading'] = '檔案上傳時發生錯誤.';
$string['mm.fileuploader.file'] = '檔案';
$string['mm.fileuploader.fileuploaded'] = '檔案已上傳';
$string['mm.fileuploader.maxbytesfile'] = '這個檔案大小 {{$a.file}} 超過限制. 最大檔案大小只能上傳 {{$a.size}}.';
$string['mm.fileuploader.photoalbums'] = '相簿';
$string['mm.fileuploader.readingfile'] = '讀取檔案中';
$string['mm.fileuploader.selectafile'] = '選擇一個檔案';
$string['mm.fileuploader.uploadafile'] = '上傳一個檔案';
$string['mm.fileuploader.uploading'] = '上傳中';
$string['mm.fileuploader.uploadingperc'] = '上傳中: {{$a}}%';
$string['mm.fileuploader.video'] = '影片';
$string['mm.login.auth_email'] = '基於電子郵件的自助註冊';
$string['mm.login.authenticating'] = '認證中';
$string['mm.login.cannotdownloadfiles'] = '在您的行動服務中已停用檔案下載, 應用程式無法使用此未啟用的設定來運作. 請與您的網站管理員聯繫.';
$string['mm.login.checksiteversion'] = '請檢查您的網站是否使用Moodle 2.4或更高版本.';
$string['mm.login.confirmdeletesite'] = '您確定要刪除網站{{sitename}}嗎?';
$string['mm.login.connect'] = '連線!';
$string['mm.login.connecttomoodle'] = '連上Moodle平台';
$string['mm.login.contactyouradministrator'] = '連絡你的網站管理員以取得更多的協助.';
$string['mm.login.contactyouradministratorissue'] = '請求管理員檢查以下問題: {{$ a}}';
$string['mm.login.credentials'] = '認證';
$string['mm.login.credentialsdescription'] = '請提供您的帳號和密碼以便登入';
$string['mm.login.emailconfirmsent'] = '<p>電子郵件應該已經寄到您的地址<b> {{$ a}} </ b> </ p> <p>它包含簡單的說明, 可以完成註冊. </ p> <p>如果, 您仍然有困難, 請與網站管理員聯繫.</ p>';
$string['mm.login.emailnotmatch'] = '電子郵件內容不符';
$string['mm.login.erroraccesscontrolalloworigin'] = '您嘗試執行的Cross-Origin呼叫已被拒絕. 請檢查https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = '刪除此網站時出錯. 請再試一次.';
$string['mm.login.errorupdatesite'] = '更新網站權杖時出錯.';
$string['mm.login.helpmelogin'] = '<p>要登入前請確認:</p>1. Moodle 入口網站版本要是2.4或更高<br />2. Moodle 入口網站管理員有啟用手機存取.<br /><br /><p>想測試Moodle示範入口網站型態須輸入<i>teacher</i> 或<i>student</i> 於<i>Username</i> 欄位並點選<b>Add button</b>.</p><p><a href="http://docs.moodle.org/en/Mobile_app" target="_blank">Moodle文件網站有更詳細的資料及協助</a></p>';
$string['mm.login.invalidaccount'] = '請檢查您的登人資料或請您的網站管理員檢查網站設定。';
$string['mm.login.invaliddate'] = '無效的日期';
$string['mm.login.invalidmoodleversion'] = '無效的Moodle版本。至少需要的版本為2.4';
$string['mm.login.invalidsite'] = '這網站網址無效.';
$string['mm.login.invalidtime'] = '無效的時間';
$string['mm.login.invalidvaluemax'] = '最大值為 {{$a}}';
$string['mm.login.invalidvaluemin'] = '最小值為 {{$a}}';
$string['mm.login.localmobileunexpectedresponse'] = 'Moodle行動其他功能檢查返回了無預期的回應, 您將使用標準行動服務進行身份驗證.';
$string['mm.login.loginbutton'] = '登入';
$string['mm.login.logininsiterequired'] = '您的Moodle網站強制您以系統瀏覽器開啟. 將開啟新瀏覽器, 並重新導向這Moodle網站.';
$string['mm.login.mobileservicesnotenabled'] = '您的網站並未啟用行動服務. 如果您想使用此功能, 請連絡您的Moodle網站管理員.';
$string['mm.login.newsitedescription'] = '請輸入您的Moodle平台網址. 注意平台需要先設定好才能使用這個應用程式.';
$string['mm.login.notloggedin'] = '你必須先登入';
$string['mm.login.passwordrequired'] = '需要密碼';
$string['mm.login.problemconnectingerror'] = '我們無法連接到';
$string['mm.login.problemconnectingerrorcontinue'] = '請仔細檢查您是否正確輸入了地址, 然後重試.';
$string['mm.login.profileinvaliddata'] = '無效的內容';
$string['mm.login.recaptchachallengeimage'] = 'reCAPTCHA挑戰的圖片';
$string['mm.login.reconnect'] = '重新連線';
$string['mm.login.reconnectdescription'] = '您的授權權杖無效或已過期, 您必須重新連線到這個網站';
$string['mm.login.reconnectssodescription'] = '您的授權權杖無效或已過期, 您必須重新連線到這個網站進行重新登入.';
$string['mm.login.signupplugindisabled'] = '{{$ a}}未啟用.';
$string['mm.login.siteaddress'] = '網站位址';
$string['mm.login.siteinmaintenance'] = '您的網站處於維護模式';
$string['mm.login.siteurl'] = '網址';
$string['mm.login.siteurlrequired'] = '需要網站網址, 例如<i>http://www.yourmoodle.tw</i>';
$string['mm.login.stillcantconnect'] = '一直無法連線嗎?';
$string['mm.login.usernamerequired'] = '需要帳號';
$string['mm.login.visitchangepassword'] = '您需要去拜訪這個網站變更密碼嗎?';
$string['mm.login.webservicesnotenabled'] = '您的網站沒有啟用Web服務。如果您想用行動裝置連線，請聯繫您的Moodle網站管理員。';
$string['mm.question.errorattachmentsnotsupported'] = '本應用程序尚不支援將檔案附加到答案.';
$string['mm.question.errorinlinefilesnotsupported'] = '該應用程序尚不支援線上檔案的編輯.';
$string['mm.question.errorquestionnotsupported'] = '該應用程式不支援此問題類型: {{$ a}}.';
$string['mm.question.howtodraganddrop'] = '點一下選擇, 然後再點一下刪除.';
$string['mm.question.questionmessage'] = '問題 {{$a}}: {{$b}}';
$string['mm.question.unknown'] = '無法偵測到狀態';
$string['mm.settings.about'] = '關於';
$string['mm.settings.appname'] = 'Moodle行動版{{version}}';
$string['mm.settings.appready'] = '應用程式已就緒';
$string['mm.settings.cacheexpirationtime'] = '快取到期時間(毫秒)';
$string['mm.settings.cannotsyncoffline'] = '離線狀態無法進行同步';
$string['mm.settings.cannotsyncwithoutwifi'] = '無法同步, 因為目前的設定只允許在連接到Wi-Fi時同步. 請連接到Wi-Fi網絡.';
$string['mm.settings.configuringnotifications'] = '您正在設定“{{$ a}}”通知.';
$string['mm.settings.cordovadevicemodel'] = 'Cordova裝置型號';
$string['mm.settings.cordovadeviceosversion'] = 'Cordova裝置作業系統版本';
$string['mm.settings.cordovadeviceplatform'] = 'Cordova裝置平臺';
$string['mm.settings.cordovadeviceuuid'] = 'Cordova裝置uuid';
$string['mm.settings.cordovaversion'] = 'Cordova版本';
$string['mm.settings.credits'] = '信譽';
$string['mm.settings.deletesitefiles'] = '您確定想從這個網站位置刪除已下載的檔案?';
$string['mm.settings.deletesitefilestitle'] = '刪除網站檔案';
$string['mm.settings.development'] = '開發';
$string['mm.settings.deviceinfo'] = '裝置資訊';
$string['mm.settings.deviceos'] = '裝置作業系統';
$string['mm.settings.devicewebworkers'] = '裝置網路工作站已支援';
$string['mm.settings.displayformat'] = '顯示格式';
$string['mm.settings.enabledebugging'] = '啟用除錯';
$string['mm.settings.enabledownloadsection'] = '啟用下載區塊';
$string['mm.settings.enabledownloadsectiondescription'] = '禁用此選項可加快課程區塊的載入速度';
$string['mm.settings.enablerichtexteditor'] = '啟用文本編輯器';
$string['mm.settings.enablerichtexteditordescription'] = '如果啟用了, 文本編輯器將會顯示在允許它的地方';
$string['mm.settings.enablesyncwifi'] = '只允許使用Wi-Fi進行同步';
$string['mm.settings.errordeletesitefiles'] = '刪除網站檔案時發生錯誤';
$string['mm.settings.errorsyncsite'] = '同步網站資料時出錯, 請檢查您的網際網路連線, 然後重試.';
$string['mm.settings.estimatedfreespace'] = '估計剩餘空間';
$string['mm.settings.filesystemroot'] = '檔案系統根目錄';
$string['mm.settings.localnotifavailable'] = '提供本端通知';
$string['mm.settings.locationhref'] = 'Webview網址';
$string['mm.settings.navigatorlanguage'] = '導覽語言';
$string['mm.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['mm.settings.networkstatus'] = '網際網路連線狀況';
$string['mm.settings.reportinbackground'] = '報表錯誤自動回報';
$string['mm.settings.spaceusage'] = '使用空間';
$string['mm.settings.storagetype'] = '儲存類型';
$string['mm.settings.success'] = '成功!';
$string['mm.settings.synchronization'] = '同步';
$string['mm.settings.synchronizenow'] = '立即同步';
$string['mm.settings.synchronizing'] = '同步中';
$string['mm.settings.syncsettings'] = '同步設定';
$string['mm.settings.syncsitesuccess'] = '網站資料同步與快取都無效';
$string['mm.settings.versioncode'] = '版本碼';
$string['mm.settings.versionname'] = '版本名稱';
$string['mm.settings.wificonnection'] = 'WiFi連線';
$string['mm.sharedfiles.chooseaccountstorefile'] = '選擇要存入檔案的帳號';
$string['mm.sharedfiles.chooseactionrepeatedfile'] = '已有一個同名稱的檔案.  要替換現有檔案還是將重新命名為“{{$ a}}”?';
$string['mm.sharedfiles.errorreceivefilenosites'] = '沒有已存入的網站. 請在與應用程式共享文件之前新增網站.';
$string['mm.sharedfiles.nosharedfiles'] = '此網站中沒有存入共享檔案.';
$string['mm.sharedfiles.nosharedfilestoupload'] = '您沒有要在此處上傳的檔案. 如果您要從其他應用程式上傳檔案, 請找出該檔案, 然後按一下[開啟]按鈕.';
$string['mm.sharedfiles.rename'] = '重新命名';
$string['mm.sharedfiles.replace'] = '替代';
$string['mm.sharedfiles.sharedfiles'] = '分享檔案';
$string['mm.sharedfiles.successstorefile'] = '檔案已成功儲存.現在您可以選擇檔案進行上傳到您的個人檔案.';
$string['mm.sidemenu.appsettings'] = '應用程式設定';
$string['mm.sidemenu.changesite'] = '更換網站';
$string['mm.sidemenu.help'] = '協助';
$string['mm.sidemenu.logout'] = '更換網站';
$string['mm.sidemenu.mycourses'] = '我的課程';
$string['mm.sidemenu.togglemenu'] = '切換功能選單';
$string['mm.sidemenu.website'] = '網站';
$string['mm.user.contact'] = '連絡人';
$string['mm.user.details'] = '明細';
$string['mm.user.detailsnotavailable'] = '這個使用者的詳細資料無法提供給您';
$string['mm.user.editingteacher'] = '教師';
$string['mm.user.invaliduser'] = '無效的使用者';
$string['mm.user.manager'] = '管理者';
$string['mm.user.phone2'] = '行動';
$string['mm.user.student'] = '學生';
$string['mm.user.teacher'] = '非編輯中的教師';
$string['pluginname'] = 'Moodle 行動版語言字串';
