<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'qformat_gift', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   qformat_gift
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['braceerror'] = '找不到包圍答案的{...}';
$string['giftleftbraceerror'] = '無法找到一個  {';
$string['giftmatchingformat'] = '配合題的答案，沒採用適當的格式';
$string['giftnonumericalanswers'] = '數值題找不到答案';
$string['giftnovalidquestion'] = '沒找到有效的題目';
$string['giftqtypenotset'] = '題型沒有設定';
$string['giftrightbraceerror'] = '無法找到一個  }';
$string['importminerror'] = '這一題有錯誤，就這一題型而言，這裡沒有足夠的選項';
$string['nohandler'] = '沒有題型{$a}的處理程式';
$string['pluginname'] = 'Gift 格式';
$string['pluginname_help'] = '<h1>匯入 GIFT 格式的檔案</h1>
<p>要將文字檔匯入 Moodle 測驗模組時，GIFT 是最具綜合性的匯入格式。 它支援選擇題、是非題、簡答(填充題)、配合題、和數字題、以及填空式的克漏字題型。各種題型可以混雜在一個文字檔中，而且這格式可以支援線上說明、試題簡稱、回饋、和選項加權百分比計分。</p>
<p>您的文字檔的編碼方式必須和您安裝 Moodle 時所用的編碼相同(本系統是 UTF-8 )，才不會變成亂碼。</p>
<p>這兒有一個試題文字檔的範例: <a href="<?php echo $CFG->wwwroot; ?>/question/format/gift/examples.txt">gift/examples.txt</a>.</p>

<h3>基本概念</h3>
<p>在GIFT檔裡的每個個別的試題絕不可包含空白行，因為每一試題之間是以至少一空白行作為分隔。如果你需要放一空白行到你的試題裡面，你可以使用 <b>n</b> 代替。</p>
<p>你可在任何地方加上不會顯示給受測者看到的備註，但是它們必須在該行前端加上兩個向前的斜線 (<b>//</b>)。</p>

<h2>試題類型</h2>
<h3>選擇題</h3>
    就選擇題而言，錯誤答案前面要加波浪符號(~)，而正確答案前面要加上等於符號(=)。</p>
    <pre>     誰被埋在格蘭特的墳墓裡？{~格蘭特 ~傑佛遜 =沒有人}</pre>
    <p>這<b>填空</b>格式會在句子中間自動插入一可供填寫的底線(像這樣 _____)。
    要使用填充格式，只要把答案放在該句子中，您要底線出現的地方。</p>
    <pre>     Grant is {~buried =entombed ~living} in Grant\'s tomb.</pre>
    <p>只要答案是在結束的標點符號前出現，一個填空用的底線就會被插入。所有的題型都可以寫成填空的格式。</p>
    <p>您必須使用一個空白行 (即連按兩次return鍵) 來分隔試題。
    為了閱讀清晰，每個選項可以寫成一欄，甚至上下對齊，例如：</p>
    <pre>
     美國的感恩節是在十一月的第{
         ~二
         ~三
         =四
     } 個星期四。

     日本文字原初是來自於哪一國家？{
         ~印度
         =中國
         ~韓國
         ~埃及}
	 </pre>

<h3>簡答題:</h3>
    簡答題的所有可接受的答案，都要在前面加上等號(=)，並以空格隔開。
	答案裡不可以包含顎化符號(tilde,西班牙文字中 n 字上所附之符號)。</p>
    <pre>
	誰被埋在格蘭特的墳墓裡？{=沒有 =沒有人}

     二加二等於 {=四 =4}.
	 </pre>
    <p>如果只有<b>一個</b>正確答案，它可以不必在前面加上等號，但是不要與是非題混淆。</p>

<h3>是非題:</h3>
 <p>在這種題型裡，答案要指出這敘述是真或假。
    試題的答案應該寫成{TRUE} 或{FALSE}，或簡寫成{T} 或 {F}。</p>
    <pre>
    格蘭特是被葬在格蘭特的墳墓裡。{F}

    太陽從東方升起。{T}
	 </pre>

<h3>配合題:</h3>
 <p>配題題中的每一配對要以等號(=)開頭，並以箭頭"->"(減號和大於)指向答案。每一題至少要有三個配對。</p>
    <pre>
	配合題的作答說明。 {
         =試題1 -> 答案1
         =試題2 -> 答案2
         =試題3 -> 答案3
         }

     請將下列國家與其首都對應起來。{
         =加拿大 -> 渥太華
         =義大利 -> 羅馬
         =日本   -> 東京
         =印度   -> 新德里
         }</pre>
		 <p>配合題不可以使用回饋，和選項百分比加權法。</p>

<h3>數字題:</h3>
<p>    數字題的答案部分必須以一數字符號(#)開始。
    數字答案可以包括誤差範圍，它是寫在正確答案之後，並以冒號隔開。
    舉例來說，如果正確答案是界於 1.5 和 2.5 之間的任何數值，那它可以寫成<b>{#2:0.5}</b>。
    這表示正確答案是 2 而允許的誤差範圍是 0.5 (亦即，範圍從 1.5 到 2.5)。
    如果沒有指定誤差範圍，那就會被當作是 0。</p>
    <pre>     Ulysses S. Grant 是哪一年出生? {#1822}

     圓周率(pi)的值是多少(取到小數第三位)? {#3.1415:0.0005}.</pre>
    <p>除此之外，數字答案也可以用下列格式指定一個範圍
 {#<i>最大值</i>..<i>最小值</i>}.</p>
    <pre>     圓周率(pi)的值是多少(取到小數第三位)? {#3.141..3.142}.</pre>
    <p>撰寫數字題時，Moodle的瀏覽器介面不支援多個數字答案，但 Moodle 的程式碼可以，GIFT 也可以。
    這功能可用於指定多種數字範圍，並與答案百分比加權計分相結合，也讓比較不精確的答案也可得到部分的分數。
    如果使用多個可接受答案，它們必須像簡答題一樣，以等號（=）隔開。</p>
    <pre>     Ulysses S. Grant 是這在哪一年出生？{#
         =1822:0
         =%50%1822:2}</pre>
    <p>注意，因為 Moodle的瀏覽器的圖形使用介面不支援數字題的多重答案，所以透過 Moodle 是沒有辦法看到他們或編輯他們。
    要改變數值答案的唯一方法，就是刪除這試題並重新匯入它 (或使用像是 phpMyAdmin 的程式)。</p>

<h2>其他選擇</h2>
    <p>除了這些基本的試題類型之外，這一程式還提供下列選項:
    補充說明、試題簡稱、回饋、和選項加權百分比等。</p>

<h3>行間備註:</h3>
<p> 您不想要匯入 Moodle 題庫裡的補充說明文字，也可以包含在文字檔裡。<br/>
    這將可以用來提供標題或更複雜的補充說明。 <br/>
    所有各行文字，若以雙斜線開頭(不算跳格鍵或空白鍵) 其後的文字，這程式將會忽視不處理。</p>
    <pre>
	// 副標題: 以下為數字答案題
      2 加 2 是多少？ {#4}
	 </pre>

<h3>試題簡稱:</h3>
<p>  一個試題的簡稱，是在試題前面加上文字，並在其前後各加上雙重冒號(::)。例如：</p>
    <pre>
	 ::漢字起源::日本文字是起源於哪一國家? {=中國}

    ::感恩節日期::美國的感恩節假日是在十一月的第{~二 ~三 =四}個星期四。
	</pre>
    <p>如果沒有指定試題簡稱，預設是把整個試題的前面幾個字當作其簡稱。</p>

<h3>回饋:</h3>
<p>   回饋可以放在每個答案之後，中間加上一數字符號(# 或稱為井字符號)使答案在前，回饋在後。</p>
    <pre>這個選擇題答案是什麼?{
     ~錯誤答案#針對此錯誤答案的回饋
     ~另一個錯誤答案#針對此錯誤答案的回饋
     =正確答案#你答對了}

     Who\'s buried in Grant\'s tomb?{
     =no one#excellent answer!
     =nobody#excellent answer!}

     Grant 被埋在 Grant 的墓裡。{FALSE#沒有人埋在 Grant的墓裡。}</pre>
    <p>就選擇題而言，學生選不同的答案會有不同的回饋。 <br/>
    就簡答題而言，只有在學生輸入對應的正確答案時才顯示回饋。 <br/>
    就是非題而言，只有在學生答錯了時才會有回饋。<br/>
    因此，就上面最後一個是非題，只有學生選了 TRUE 時，才會看到回饋。</p>

<h3>選項加權百分比:</h3>
<p> 選擇題和簡答題兩者都可以使用選項加權百分比。
    若您要給予不同精確性的答案有不同的分數，您可以使用選項百分比加權，您可以在波浪符號(用於選擇題)或
    等於符號(用於簡答題)之後，加上所要給的百分比，並以百分比符號包夾(比如，%50%)。
    這選項可以和回饋的文字合併。</p>
    <pre>     試題說明文字.{~錯誤答案 ~%50%可得一半分數的答案 =可得全部分數的答案}

     ::耶蘇的家鄉::基督耶穌是來自 {
     ~耶路撒冷#它是重要城市，但不是正確答案.
     ~%25%伯利恆#他出生在這裡，但不是在這裡長大.
     ~%50%加利利#你必須更具體.
     =拿撒勒#是的! 答對了!}.

     ::耶蘇的家鄉::基督耶穌是來自 {
     =拿撒勒#是的! 答對了!.
     =%50%加利利#你必須更具體.
     =%25%伯利恆#他出生在這裡，但不是在這裡長大.}</pre>

    <p>注意，上面兩題基本是是同一個問題，只是第一個是選擇題，而第二個是簡答題。</p>

    <p><font size="-1">注意：您在匯入檔上所指定的選項加權百分比，在匯入之後，您用瀏覽器進行試題編輯時
	，會發現並不是所有的百分比都會顯示出來。<br/>
	這些選項的加權量仍然能正確計算(依照匯入時所指派的數值)，並對作測驗的學生正常顯示。
    但是這些加權量在當老師以測驗模組的編輯試題的介面來編輯它們時，卻無法正確顯示。<br/>
	編輯介面上的下拉選單，只允許某些固定的百分比，因此，若試題的選項加權量沒有正好符合這些事先決定的百分比，那它就被調整為最接近的百分比。
    若你以瀏覽器介面來編輯試題，選項加權量將會變成被調整後所顯示的數值。</font></p>

<h3>指定試題所用的文本格式化方式</h3>
 <p> 試題的文字(只限文字)可以使用幾種不同的文字格式化方式進行排版。現在可用的格式有四種：
	<b>moodle</b> (Moodle 自動格式)，<b>html</b>(HTML 格式)，<b>plain</b> (純文字格式)和<b>markdown</b>(Markdown 格式)。<br/>
	格式化方式是在試題文字之前，以中括號指明。
     <a href="help.php?file=textformat.html">參見 Moodle 的文字格式的更多訊息</a></p>

 <pre>[markdown] *美國的感恩節*是在十一月的第幾個星期四舉行？ {
         ~第二
         ~第三
         =第四
     } </pre>

<h3>複選題:</h3>
<p>當選擇題必須選取兩個或以上的選項，才能獲得該題完整的配分，就稱為複選題。<br/> 你只要在各選項上指派不同比例的配分，就會啟動複選的功能，同時沒有單一的選項會得到完整的配分。</p>
    <pre> What two people are entombed in Grant\'s tomb? {
          ~No one
          ~%50%Grant
          ~%50%Grant\'s wife
          ~Grant\'s father }</pre>
    <p>注意，這裡不需要在任何答案上使用等號(=)，而且各答案加權百分比的累加不可以超過 100%，
    否則 Moodle 將會回報錯誤訊息。 <br/>
    要避免學生勾選全部答案就會自動拿到 100%的分數，最好對錯誤的選項設定負的加權百分比，並且使全部累加起來成為 0%。</p>
    <pre>   What two people are entombed in Grant\'s tomb? {
          ~%-50%No one
          ~%50%Grant
          ~%50%Grant\'s wife
          ~%-50%Grant\'s father }</pre>

<h3>在試題中如何使用特殊符號 ~ = # { } :</h3>
 <p>   這些符號<b> ~ = # { } </b> 是用來控制篩選器的運作，所以不能在試題中當作一般文字使用。<br />
    由於這些符號在決定篩選器的運作上有其特殊角色，所以被稱為「控制字元」。<br />
    但是有時候，你可能需要在試題中用到其中某些符號，例如，在試題中顯示數學公式。<br />
    要解決這個難題的方法，就是「跳脫」這個控制字元。 <br />
    也就是說，你只要把放一個後斜線() 在控制字元前面，這樣篩選器就知道，你是要把它當作文字字元，而不是控制字元。<br />
    例如:</p>
    <pre> 下列哪一個答案等於 5？ {
          ~ = 2 + 2
          = = 2 + 3
          ~ = 2 + 4  }

     ::GIFT 格式的控制字元::
     下列哪一個不是 GIFT 匯入格式的控制字元？ {
        ~ ~     # ~ 是控制字元.
        ~ =     # = 是控制字元.
        ~ #     # # 是控制字元.
        ~ {     # { 是控制字元.
        ~ }     # } 是控制字元.
        =      # 答對了!  (後斜線) 不是控制字元。但是它可用來跳脫控制字元.
     }</pre>
    <p>當試題被篩選器處理後，後斜線會被移除，且不會儲存在 Moodle 裡。</p>

<h3>其他選項:</h3>
<p>    簡答題可以把答案設定成區分大小寫（英文），您只要把以下這一行的"0" 改成"1" :<br />
    <tt>$question->usecase = 0;  // 不分大小寫</tt></p>
    <p>至於其他選項，則需要在匯入時透過匯入篩選器 <b>gift/format.php</b>才可進行設定。 </p>
<p></p>';
