<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'zh_tw', branch 'MOODLE_32_STABLE'
 *
 * @package   questionnaire
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = '行動';
$string['activityoverview'] = '您有到期的問卷';
$string['additionalinfo'] = '更強資料';
$string['additionalinfo_help'] = '在首頁置頂上顯示的文字（例如：教師，背景資料等）';
$string['addnewquestion'] = '正增加{$a} 問題';
$string['addquestions'] = '新增問題';
$string['addselqtype'] = '新增指定題型';
$string['alignment'] = '對齊單選按鈕';
$string['alignment_help'] = '對齊選擇按鈕：垂直（預設值）或水平。';
$string['all'] = '全部';
$string['alreadyfilled'] = '您已經填寫了此問卷{$a}。謝謝。';
$string['andaveragevalues'] = '及平均值';
$string['anonymous'] = '匿名';
$string['answerquestions'] = '填答問卷...';
$string['attempted'] = '已提交問卷';
$string['attemptstillinprogress'] = '進行中，儲存在：';
$string['autonumbering'] = '自動編碼';
$string['autonumbering_help'] = '題目及頁數的自動編碼。您可能想以
條件分支來取消問卷的自動編碼';
$string['autonumberno'] = '不要為問題及頁數編碼';
$string['autonumberpages'] = '自動編碼頁數';
$string['autonumberpagesandquestions'] = '自動編碼頁數及問題';
$string['autonumberquestions'] = '自動編碼問題';
$string['average'] = '平均';
$string['averageposition'] = '平均位置';
$string['averagerank'] = '平均等級';
$string['bodytext'] = '本體';
$string['boxesnbexact'] = '剛好{$a} 格子';
$string['boxesnbmax'] = '{$a} 格子的上限';
$string['boxesnbmin'] = '{$a} 格子的下限';
$string['boxesnbreq'] = '此問題您必須勾選';
$string['by'] = '由';
$string['cannotviewpublicresponses'] = '您可以查看公開問卷的回覆';
$string['chart:bipolar'] = '雙極列';
$string['chart:hbar'] = '水平列';
$string['chart:radar'] = '雷達';
$string['chart:rose'] = '玫瑰';
$string['chart:type'] = '表圖類型';
$string['chart:type_help'] = '選擇您想使用的表圖類型';
$string['chart:vprogress'] = '垂直進度桿';
$string['checkallradiobuttons'] = '請勾選<strong>{$a}</strong>單選按鈕';
$string['checkboxes'] = '勾選格';
$string['checkboxes_help'] = '每行輸入一個選項以令用戶可以選多於一個答案';
$string['checkbreaksadded'] = '新頁隔在此插入：';
$string['checkbreaksok'] = '所有要求的頁隔都在！';
$string['checkbreaksremoved'] = '已移除{$a}多餘頁隔';
$string['checknotstarted'] = '選擇未開始';
$string['checkstarted'] = '選擇開始';
$string['clicktoswitch'] = '（點擊以轉換）';
$string['closed'] = '問卷在{$a}開閉。謝謝。';
$string['closedate'] = '使用結束日期';
$string['closedate_help'] = '您可以在此指定一個日期關閉問卷。勾選勾選格，然後選擇您想要的日期及時間。
用戶將不能夠在此日期後填寫問卷。如果沒有勾選，問卷將永遠不關閉。';
$string['closeson'] = '問卷在 {$a}關閉';
$string['completionsubmit'] = '學生必須提交意問卷來完成';
$string['confalts'] = '- 或 - <br />確定頁面';
$string['configmaxsections'] = '最多回饋部份';
$string['configusergraph'] = '顯示"人格測試"回饋的圖表';
$string['configusergraphlong'] = '使用<a href="http://www.rgraph.net/">Rgraph</a>庫來顯示"人格測試"回饋的圖表';
$string['confirmdelallresp'] = '您確定要刪除所有在問卷的回覆？';
$string['confirmdelchildren'] = '如果您刪除此部份，子題目亦會被刪除。';
$string['confirmdelgroupresp'] = '您確定要刪除所有在{$a}的回覆？';
$string['confirmdelquestion'] = '您確定要刪除在{$a}的題目？';
$string['confirmdelquestionresps'] = '這亦會刪除此問題的{$a} 回覆。';
$string['confirmdelresp'] = '您確定要刪除&nbsp;{$a}&nbsp;的回覆？';
$string['confpage'] = '隱藏文字';
$string['confpagedesc'] = '當用戶完成此問卷後，題示&quot;確認&quot;頁面中，隱藏（粗體）及本體。（網址（如有），將會先於確認文字）';
$string['confpage_help'] = '當用戶完成此問卷後，題示"確認"頁面中，隱藏（粗體）及本體。（網址（如有），將會先於確認文字）。如果您留空此框，預設訊息將會在完成問卷後顯示（感謝您完成問卷）。';
$string['contentoptions'] = '內容選項';
$string['couldnotcreatenewsurvey'] = '不能建立新問卷！';
$string['couldnotdelresp'] = '不能刪子回覆';
$string['createcontent'] = '界定新內容';
$string['createcontent_help'] = '選擇其中的單項選擇。「建立新的」是預設';
$string['createnew'] = '建立新的';
$string['crontask'] = '問卷清除工作';
$string['date'] = '日期';
$string['dateformatting'] = '使用日／月／年的格式，例如March 14th, 1945:&nbsp; <strong>14/3/1945</strong>';
$string['date_help'] = '如果您期望回覆會是正確格式的日期，使用此題型。';
$string['deleteallresponses'] = '刪除所有回覆';
$string['deletecurrentquestion'] = '刪除題目{$a}';
$string['deletedallgroupresp'] = '刪除在群組{$a}的所有回覆';
$string['deletedallresp'] = '已刪除問卷回覆';
$string['deletedisabled'] = '不能刪除此項目';
$string['deletedresp'] = '刪除回覆';
$string['deleteresp'] = '刪除此回覆';
$string['deletingresp'] = '正刪除回覆';
$string['dependquestion'] = '主問題';
$string['dependquestion_help'] = '您可以此問題的選擇主問題及選擇選項。子問題只會在顯示主問題及選擇選項後顯示給學生。';
$string['displaymethod'] = '未界定此問題的顯示方式';
$string['download'] = '下載';
$string['downloadtextformat'] = '以文字方式下載';
$string['downloadtextformat_help'] = '此特點允許您方式以文字檔（CSV）儲存問卷的所有回覆。此檔案可以匯入至計算表（例如，MS Excel or Open Office Calc）或處理資料的統計包。';
$string['dropdown'] = '下拉框';
$string['dropdown_help'] = '相比單項選擇，使用下拉框沒有實質好處，除了節省稍長的選項會佔用屏幕空間。';
$string['edit'] = '編輯';
$string['editingquestionnaire'] = '編輯問卷設定';
$string['editquestion'] = '編輯 {$a}問題';
$string['email'] = '電郵';
$string['errnewname'] = '抱歉，此名稱已被使用，請選擇其他名稱。';
$string['erroropening'] = '錯誤打開問卷';
$string['errortable'] = '錯誤系統表損壞';
$string['essaybox'] = '評論框';
$string['essaybox_help'] = '此問題會顯示為x 文字面積欄（面積闊度）及y文字面積列（字行的數目）的純文字框。

如果您留空 x, y至預設的0數值（或您設成0)，Moodle HTML編輯器將會以標準長度及闊度（如在課程／ 用戶內容及用戶簡歷可用）顯示。';
$string['event_all_responses_deleted'] = '已刪除所有回覆';
$string['event_all_responses_saved_as_text'] = '已儲存所有回覆為文字';
$string['event_all_responses_viewed'] = '已查看所有回覆報告';
$string['event_individual_responses_viewed'] = '已查看個人回覆報告';
$string['event_non_respondents_viewed'] = '已查看非回覆者';
$string['event_previewed'] = '已預覽問卷';
$string['event_question_created'] = '已建立問卷';
$string['event_question_deleted'] = '已刪除問卷';
$string['event_response_deleted'] = '已刪除個人回覆';
$string['event_resumed'] = '已嘗試恢復';
$string['event_saved'] = '已儲存回覆';
$string['event_submitted'] = '已提交回覆';
$string['feedback'] = '回饋';
$string['feedbackaddmorefeedbacks'] = '新增{no}更多回饋欄';
$string['feedbackbysection'] = '分割回饋';
$string['feedbackeditingglobal'] = '編輯問卷全球回饋';
$string['feedbackeditingmessages'] = '編輯問卷全球訊息';
$string['feedbackeditingsections'] = '編輯問卷全球部份';
$string['feedbackeditmessages'] = '儲存章節設定及編輯回饋訊息';
$string['feedbackeditsections'] = '儲存設定及修改回饋章節';
$string['feedbackerrorboundaryformat'] = '回饋分數界限必須是百分比或數字。不能識別您在界限輸入的數值{$a}。';
$string['feedbackerrorboundaryoutofrange'] = '回饋分數界限必須是0%理100％。您界限輸入的數值{$a}不在範圍之內。';
$string['feedbackerrorjunkinboundary'] = '您必須填寫回饋分數界限框，不要有任何空隔。';
$string['feedbackerrorjunkinfeedback'] = '您必須填寫回饋框，不要有任何空隔。';
$string['feedbackerrororder'] = '回饋分數界限必須順序，由高至低。您在界限輸入的數值是不依次序。';
$string['feedbackglobal'] = '全球回饋';
$string['feedbackglobalheading'] = '全球回饋標題';
$string['feedbackglobalmessages'] = '全球回饋訊息';
$string['feedbackhdr'] = '回饋';
$string['feedbackheading'] = '回饋標題';
$string['feedbackheading_help'] = '您可以在回饋標題中使用兩個變數：$scorepercent 及 $oppositescorepercent.';
$string['feedback_help'] = '回饋協助';
$string['feedbackmessages'] = '章節 {$a}的回饋訊息';
$string['feedbacknextsection'] = '下一單元 {$a}';
$string['feedbacknone'] = '沒有回饋訊息';
$string['feedbacknotes'] = '回饋筆記';
$string['feedbacknotes_help'] = '在此輸入的文字將會在回饋報告結束時顯示給回答者。';
$string['feedbackoptions'] = '回饋選項';
$string['feedbackoptions_help'] = '如果您的問卷包括了以下的題型及題目設定，則可以使用回饋選項：
單項選項、下拉框或評分。這此問題必須設定為需環，問題名稱框遺不能留空，可能答案選擇必須包含數值。';
$string['feedbackremovequestionfromsection'] = '此問題是回饋章節 [{$a}]的部份';
$string['feedbackremovesection'] = '移除此問題會完全移除回饋章節 。';
$string['feedbackreport'] = '回饋報告';
$string['feedbackscore'] = '回饋分數';
$string['feedbackscoreboundary'] = '回饋分數界限';
$string['feedbackscores'] = '顯示分數';
$string['feedbackscores_help'] = '顯示回饋分數的表格';
$string['feedbacksection'] = '章節';
$string['feedbacksectionheading'] = '{$a}章節的回饋標題';
$string['feedbacksectionheadingmissing'] = '您必須在此回饋章節輸入標題！';
$string['feedbacksectionheadingtext'] = '標題';
$string['feedbacksectionlabel'] = '標籤';
$string['feedbacksectionlabel_help'] = '此標籤會在圖表中時用。請盡可能簡短標籤！';
$string['feedbacksections'] = '{$a}回饋章節';
$string['feedbacksectionsselect'] = '章節';
$string['feedbacksectionsselect_help'] = '在這此章節中放置您的問題';
$string['feedbacksettingssaved'] = '已儲存回饋設定';
$string['feedbacktype'] = '回饋類型';
$string['field'] = '問題{$a}';
$string['fieldlength'] = '輸入框長度';
$string['fieldlength_help'] = '至於**文字框**的題型，輸入回答者回覆的**文字框長度**及** 文字長度上限** 。

在預設數值中，文字框長度為20字元； 文字長度上限為25字元。';
$string['finished'] = '您已回答此問卷的所有問題。';
$string['firstrespondent'] = '第一位回覆者';
$string['formateditor'] = 'HTML編輯器';
$string['formatplain'] = '純文字';
$string['grade'] = '提交分數';
$string['gradesdeleted'] = '已刪除問卷分數';
$string['headingtext'] = '標題文字';
$string['horizontal'] = '水平';
$string['id'] = '編號';
$string['includechoicecodes'] = '包括選項編碼';
$string['includechoicetext'] = '包括選項文字';
$string['incorrectcourseid'] = '課程編號不正確';
$string['incorrectmodule'] = '課程模組編號不正確';
$string['incorrectquestionnaire'] = '問卷不正確';
$string['invalidresponse'] = '指明了無效的回覆';
$string['invalidresponserecord'] = '指明了無效回覆的紀錄';
$string['invalidsurveyid'] = '無效問卷編號';
$string['kindofratescale'] = '評分標準的類型';
$string['kindofratescale_help'] = '在下方更多幫助鏈接上點擊右鍵';
$string['lastrespondent'] = '最後回覆者';
$string['length'] = '長度';
$string['managequestions'] = '管理問題';
$string['managequestions_help'] = '在編輯問題頁面中的管理問題章節，您可以在問卷報告中進行多個操作。';
$string['maxdigitsallowed'] = '最多允許的數字';
$string['maxforcedresponses'] = '強制回答的上限';
$string['maxtextlength'] = '文字長度上限';
$string['messageprovider:message'] = '問卷提示';
$string['minforcedresponses'] = '強制回答的下限';
$string['minforcedresponses_help'] = '使用這些參數來強制回答者點選**最少**格的下限及of **最多** 勾選框的上限.
要強制相同數相的勾選框的數目，設定**最少**及**最多** 至相同數值。如果只需要最少或最多，只需留空一個為預設數值0。如果您設定了**最少**及**最多** 不是預設設定0，當回答者沒有跟從指示時，將會顯示警告訊息。因此，您必須在問卷中的一般說明或相關問題的文字上清晰標明您的指示。';
$string['misconfigured'] = '課程配置錯誤';
$string['missingname'] = '由於問題{$a}沒有名稱，因此不能在此回饋章節中使用。';
$string['missingnameandrequired'] = '由於問題{$a}沒有名稱及不必要，因此不能在此回饋章節中使用。';
$string['missingquestion'] = '請回答必要問題';
$string['missingquestions'] = '請回答必要問題：';
$string['missingrequired'] = '由於問題{$a}不是必要，因此不能在此回饋章節中使用。';
$string['modulename'] = '問卷';
$string['modulename_help'] = '此問卷模組允許您建立不同題型的問卷，以從用戶中收集資料。';
$string['modulenameplural'] = '問卷';
$string['movedisabled'] = '不能移動此項目';
$string['myresponses'] = '您的全部回覆';
$string['myresponsetitle'] = '您的{$a} 回覆';
$string['myresults'] = '您的結果';
$string['name'] = '名稱';
$string['navigate'] = '允許分支題目';
$string['navigate_help'] = '啟用是非題或單項選擇問題以建立他們在問卷的選擇的子問題';
$string['next'] = '下一個';
$string['nextpage'] = '下一頁';
$string['nlines'] = '{$a} 行';
$string['noanswer'] = '沒有問題';
$string['noattempts'] = '尚未在此問卷建立作答';
$string['nodata'] = '沒有發佈的資料';
$string['noduplicates'] = '沒有重複的選擇';
$string['noduplicateschoiceserror'] = '您在「沒有重複的選擇」的選項中必須輸入至少兩個可能答案！';
$string['noneinuse'] = '此問卷沒有任何題目。';
$string['non_respondents'] = '尚未提交此問卷回覆的用戶';
$string['nopublicsurveys'] = '沒有公開問卷';
$string['noresponsedata'] = '沒有此問題的回覆';
$string['noresponses'] = '沒有回覆';
$string['normal'] = '正常';
$string['notanumber'] = '<strong>{$a}</strong> 不是可接受的數字格式';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/A欄';
$string['notavail'] = '此問卷現不適用。請請求您的教師刪除此問卷。';
$string['noteligible'] = '您不能取得此問卷';
$string['notemplatesurveys'] = '沒有範本問卷。';
$string['notenoughscaleitems'] = '您必須輸入';
$string['notopen'] = '此問卷會直至 {$a}才公開。';
$string['notrequired'] = '回覆不是必要的';
$string['not_started'] = '未開始';
$string['nousersselected'] = '沒有選擇用戶';
$string['num'] = '＃';
$string['numattemptsmade'] = '已在此問卷建立{$a}作答';
$string['numberfloat'] = '您已輸入的數字<strong>{$a->number}</strong> 已經重新格式化或轉換至<strong>{$a->precision}</strong> 小數位。';
$string['numberofdecimaldigits'] = 'Nb小數位';
$string['numberscaleitems'] = 'Nb項目規模';
$string['numberscaleitems_help'] = 'Nb項目規模是用作您的評標準中的*項目數目*。您一般會使用3至5的數值。預設值為**5**';
$string['numeric'] = '數字';
$string['numeric_help'] = '使用此題型如果您期望回覆會是正確格式的數字';
$string['of'] = '的';
$string['opendate'] = '使用公開日期';
$string['opendate_help'] = '您可以在此標明開放問卷的日子。勾選此勾選格，並選擇您想要的日期及時間。
用戶將不能在此日期前填寫問卷。如果沒有選擇此選項，將會即時開放問卷。';
$string['option'] = '選項 {$a}';
$string['optionalname'] = '問題名稱';
$string['optionalname_help'] = '問題名稱只會在您匯出回覆至CSV／Excel格式時使用。
如果您從不匯出至CSV格式，則不需要顧慮問題名稱。如果您計劃定期匯出問卷回覆至CSV格式，問題名稱將會有兩個選擇。';
$string['or'] = '－或－';
$string['order_ascending'] = '由小至大的順序（升序）';
$string['order_default'] = '查看預設順序';
$string['order_descending'] = '由大至小的順序（降序）';
$string['orderresponses'] = '排序回覆';
$string['orderresponses_help'] = '當顯示所有回覆時，您可以以回覆數目（平均欄）排列以下四種題型。

* 單一選擇的單選按鈕
* 單一選擇的下拉框
* 多項選擇題（勾選框）
* 評分題（包括李克特量表）

當您前往全部回覆的頁面時，在預設設定中，回覆會按照問卷建立者輸入題目選擇的次序排列。您可以選擇升序或降序。';
$string['osgood'] = 'Osgood';
$string['other'] = '其他：';
$string['otherempty'] = '如果您勾選此選項，您必須在文字框輸入文字！';
$string['overviewnumresplog'] = '回覆';
$string['overviewnumresplog1'] = '回覆';
$string['overviewnumrespvw'] = '回覆';
$string['overviewnumrespvw1'] = '回覆';
$string['owner'] = '擁有者';
$string['page'] = '頁';
$string['pageof'] = '{$a->totpages}頁中的{$a->page}頁';
$string['participant'] = '參加者';
$string['pleasecomplete'] = '請完成此選頂。';
$string['pluginadministration'] = '問卷管理';
$string['pluginname'] = '問卷';
$string['position'] = '位置';
$string['possibleanswers'] = '可能答案';
$string['posteddata'] = '與發佈資料前往頁面：';
$string['previewing'] = '預覽問卷';
$string['preview_label'] = '預覽';
$string['preview_questionnaire'] = '問卷預覽';
$string['previous'] = '前';
$string['previouspage'] = '上一頁';
$string['print'] = '列印此回覆';
$string['printblank'] = '列印空白';
$string['printblanktooltip'] = '與空白問卷開啟打印機友善視窗';
$string['printtooltip'] = '與現有回覆開啟打印機友善視窗';
$string['private'] = '私人';
$string['public'] = '公開';
$string['publiccopy'] = '副本：';
$string['publicoriginal'] = '原本：';
$string['qtype'] = '類型';
$string['qtypedaily'] = '每日回覆';
$string['qtype_help'] = '選擇允許用戶一次、每日、每週、每月或無限回覆。';
$string['qtypemonthly'] = '每月回覆';
$string['qtypeonce'] = '回覆一次';
$string['qtypeunlimited'] = '回覆多次';
$string['qtypeweekly'] = '每週回覆';
$string['questionnaire:addinstance'] = '新增問卷';
$string['questionnaireadministration'] = '問卷管理';
$string['questionnairecloses'] = '問卷關閉';
$string['questionnaire:copysurveys'] = '複製範本及私人問卷';
$string['questionnaire:createpublic'] = '建立公開問卷';
$string['questionnaire:createtemplates'] = '建立範本問卷';
$string['questionnaire:deleteresponses'] = '刪除任何回覆';
$string['questionnaire:downloadresponses'] = '以CSV檔案下載回覆';
$string['questionnaire:editquestions'] = '建立及編輯問卷問題';
$string['questionnaire:manage'] = '建立及編輯問卷';
$string['questionnaire:message'] = '傳送訊息給尚未填問卷者';
$string['questionnaireopens'] = '問卷開啟';
$string['questionnaire:preview'] = '預覽問卷';
$string['questionnaire:printblank'] = '列印空白問卷';
$string['questionnaire:readallresponseanytime'] = '任何時候閱覽全部回覆';
$string['questionnaire:readallresponses'] = '閱覽回覆摘要，根據打開次數';
$string['questionnaire:readownresponses'] = '閱覽自己的回覆';
$string['questionnairereport'] = '問卷報告';
$string['questionnaire:submit'] = '完成及提交問卷';
$string['questionnaire:view'] = '查看問卷';
$string['questionnaire:viewsingleresponse'] = '查看完整的個人回覆';
$string['questionnum'] = '問題＃';
$string['questions'] = '問題';
$string['questionsinsection'] = '在此章節的問題';
$string['questiontypes'] = '問題類型';
$string['questiontypes_help'] = '在下方查看Moodle文檔';
$string['radiobuttons'] = '單選按鈕';
$string['radiobuttons_help'] = '在此題型，回答者必須提供的選項中選擇。';
$string['rank'] = '等級';
$string['ratescale'] = '評分（級別1..5）';
$string['ratescale_help'] = '在下方查看Moodle文檔';
$string['realm'] = '問卷類型';
$string['realm_help'] = '**有三類型的問卷：**
＊私人：只屬於已界定的課程
＊範本：可以複製及修改
＊公開：可以與課程之間共享';
$string['redirecturl'] = '在完成問卷後將重新定向用戶的網址';
$string['remove'] = '刪除';
$string['removeallquestionnaireattempts'] = '刪除所有問卷的回覆';
$string['required'] = '點覆是必要的';
$string['required_help'] = '如果您選擇***是***，此問題的回覆是必需的，例如，直至已回答所有問題前，回答者將不能提交問卷。';
$string['requiredparameter'] = '缺少了必要的參數';
$string['reset'] = '重設';
$string['respeligiblerepl'] = '（按角色覆蓋取代）';
$string['respondent'] = '回答者';
$string['respondenteligibleall'] = '全部';
$string['respondenteligiblestudents'] = '只有學生';
$string['respondenteligibleteachers'] = '只有教師';
$string['respondents'] = '回答者';
$string['respondenttype'] = '回答者類型';
$string['respondenttypeanonymous'] = '匿名';
$string['respondenttypefullname'] = '完整姓名';
$string['respondenttype_help'] = '設定成「完整姓名」，您可以在每個回覆中顯示用戶的完整姓名。
設定成「匿名」，您可以在每個回覆中隱藏用戶的身份。';
$string['response'] = '回覆';
$string['responsefieldlines'] = '輸入框尺寸';
$string['responseformat'] = '回覆格式';
$string['responseoptions'] = '回覆選項';
$string['responses'] = '回覆';
$string['responseview'] = '學生可以查看所有回覆';
$string['responseview_help'] = '您可以指明誰可以查看已提交問卷的回覆（一般統計表格）';
$string['responseviewstudentsalways'] = '總是';
$string['responseviewstudentsnever'] = '永不';
$string['responseviewstudentswhenanswered'] = '在回答問卷之後';
$string['responseviewstudentswhenclosed'] = '在問卷關閉之後';
$string['restrictedtoteacher'] = '這些功能只限於編輯教師';
$string['resume'] = '儲存／恢復答案';
$string['resume_help'] = '設定此選項允許用戶在提交問卷前儲存他們的回答至問卷。用戶可以保留未完成的問卷並日後在儲存的位置恢復回答問卷。';
$string['resumesurvey'] = '恢復問卷';
$string['return'] = '返回';
$string['save'] = '儲存';
$string['saveasnew'] = '儲存成新題目';
$string['savedbutnotsubmitted'] = '此問卷已儲存但未提交';
$string['savedprogress'] = '已儲存您的進度。您可以任何時候返回並完成問卷。';
$string['saveeditedquestion'] = '儲存問題{$a}';
$string['savesettings'] = '儲存設定';
$string['section'] = '描述';
$string['sectionbreak'] = '----- 分頁符 -----';
$string['sectionbreak_help'] = '----- 分頁符 -----';
$string['sectionsnotset'] = '您必須在每個章節中至少選擇一個題目！<br />沒有選擇的章節: {$a}';
$string['sectiontext'] = '標籤';
$string['sectiontext_help'] = '這不是一個問題但是一個用題示作簡介以下題目的短文';
$string['selecttheme'] = '選擇此問卷的主題（css）';
$string['send'] = '傳送';
$string['sendemail'] = '傳送電郵';
$string['sendemail_help'] = '傳送副本到指定的電郵地址。您可以提供多於一個電郵地址，並以逗號作分隔。留空如果沒有電郵備份。';
$string['send_message'] = '傳送訊息到指定用戶';
$string['send_message_to'] = '傳送訊息到：';
$string['settings'] = '設定';
$string['settingssaved'] = '已儲存設定';
$string['show_nonrespondents'] = '尚未填問卷者';
$string['started'] = '已開始';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['subject'] = '主題';
$string['submitoptions'] = '遞交選項';
$string['submitpreview'] = '繳交前預覽';
$string['submitpreviewcorrect'] = '由於正確輸入，將會接受此遞交';
$string['submitsurvey'] = '繳交問卷';
$string['submitted'] = '提交在：';
$string['subtitle'] = '子標題';
$string['subtitle_help'] = '此問卷的子標題。';
$string['summary'] = '摘要';
$string['surveynotexists'] = '問卷不存在';
$string['surveyowner'] = '您必須是問卷的擁有者以進行此操作';
$string['surveyresponse'] = '問卷中的回覆';
$string['template'] = '範本';
$string['templatenotviewable'] = '問卷範本不能查看。';
$string['text'] = '問題文字';
$string['textareacolumns'] = '文本區域欄';
$string['textareacolumns_help'] = '此問題會以純文字框顯示，與**x** *文本區域欄* (或面積 *閣度*) 及 **y** *文本區域行* (文字數目
*行*).';
$string['textarearows'] = '文本區域行';
$string['textbox'] = '文字框';
$string['textbox_help'] = '至於文字框題型，輸入回答者的文字框長度及文字長度上限。
輸入框闊度的預設設定是20字元，文字長度上限的預設設定是25字元。';
$string['textdownloadoptions'] = '文字下載的選項（CSV）';
$string['thank_head'] = '感謝您完成問卷。';
$string['theme'] = '主題';
$string['thismonth'] = '此月份';
$string['thisresponse'] = '此回覆';
$string['thisweek'] = '此週';
$string['title'] = '標題';
$string['title_help'] = '為問卷命名標題，將會在每頁的置頂中顯示。在預設設定中，標題設定為問卷名稱，但您可以修改成您想要的。';
$string['today'] = '今天';
$string['total'] = '總共';
$string['type'] = '題目煩型';
$string['undefinedquestiontype'] = '未定義題型';
$string['unknown'] = '不知明';
$string['unknownaction'] = '指定了不知明問卷行動';
$string['url'] = 'URL確認';
$string['url_help'] = '此URL將會在用戶完成問卷後重新定向';
$string['useprivate'] = '複製現有的';
$string['usepublic'] = '使用公開';
$string['usetemplate'] = '使用範本';
$string['vertical'] = '垂直';
$string['view'] = '查看';
$string['viewallresponses'] = '查看全部回覆';
$string['viewallresponses_help'] = '如果問卷設定成 **群組模式**:
*可見群組*或設定為*分隔群組*及現有用戶擁有*moodle/site:accessallgroups* 的權限（在現有內容），以及群組已在課程中界定的話，用戶將可以查看群組的下拉列表。
此下拉列表允許用戶以群組「過濾」問卷回覆。

如果問卷設定成 **群組模式**:*分隔群組*，沒有*moodle/site:accessallgroups* 的權限的用戶（通常是學生或非編輯教師等）將只能看見他們所屬群組的回覆。';
$string['viewbyresponse'] = '回覆清單';
$string['viewindividualresponse'] = '個人回覆';
$string['viewindividualresponse_help'] = '在下方的清單上點擊回答者的名稱以查看其個人回覆';
$string['viewresponses'] = '全部回覆 ({$a})';
$string['viewyourresponses'] = '您的回覆－ 查看{$a}';
$string['warning'] = '警告：遇到錯誤';
$string['wronganswers'] = '您的答案有一些是錯誤（見下文）';
$string['wrongdateformat'] = '輸入的日期：<strong>{$a}</strong>不符合例子中的格式。';
$string['wrongdaterange'] = '錯誤！年份必須設定在1902至2037期間。';
$string['wrongformat'] = '您的答案有一些是錯誤:&nbsp;';
$string['wrongformats'] = '您的答案有一些是錯誤:&nbsp;';
$string['yesno'] = '是／否';
$string['yesno_help'] = '簡單是非題';
$string['yourresponse'] = '您的回覆';
$string['yourresponses'] = '您的回覆';
