<?php

namespace Elgg;

use Throwable;

/**
 * Thrown when CSRF tokens mismatch
 */
class CsrfException extends HttpException {

	/**
	 * {@inheritdoc}
	 */
	public function __construct(string $message = '', int $code = 0, Throwable $previous = null) {
		if (!$code) {
			$code = ELGG_HTTP_FORBIDDEN;
		}
		parent::__construct($message, $code, $previous);
	}
}
