<?php
ini_set('date.timezone', 'Asia/Shanghai');
//error_reporting(E_ERROR);

require_once "../lib/WxPay.Api.php";
require_once "WxPay.NativePay.php";
require_once 'log.php';


$pay_set = $_COOKIE['reg_id']."_".$_COOKIE['group_id'];


//模式一
/**
 * 流程：
 * 1、组装包含支付信息的url，生成二维码
 * 2、用户扫描二维码，进行支付
 * 3、确定支付之后，微信服务器会回调预先配置的回调地址，在【微信开放平台-微信支付-支付配置】中进行配置
 * 4、在接到回调通知之后，用户进行统一下单支付，并返回支付信息以完成支付（见：native_notify.php）
 * 5、支付完成之后，微信服务器会通知支付成功
 * 6、在支付成功通知中需要查单确认是否真正支付成功（见：notify.php）
 */
$notify = new NativePay();
$url1 = $notify->GetPrePayUrl("123456789");

//模式二
/**
 * 流程：
 * 1、调用统一下单，取得code_url，生成二维码
 * 2、用户扫描二维码，进行支付
 * 3、支付完成之后，微信服务器会通知支付成功
 * 4、在支付成功通知中需要查单确认是否真正支付成功（见：notify.php）
 */

$input = new WxPayUnifiedOrder();
$input->SetBody("waychar"."_".$_COOKIE['reg_id']."_".$_COOKIE['group_id']);
$input->SetAttach($_COOKIE['reg_id']."_".$_COOKIE['group_id']);
$input->SetOut_trade_no(WxPayConfig::MCHID . date("YmdHis"));
$input->SetTotal_fee($_COOKIE['price']*100);
$input->SetTime_start(date("YmdHis"));
$input->SetTime_expire(date("YmdHis", time() + 600));
$input->SetGoods_tag("xiaobeei race");
$input->SetNotify_url("http://www.xxx.cn/pay/wx/example/notify.php");
$input->SetTrade_type("NATIVE");
$input->SetProduct_id("123456789");
$result = $notify->GetPayUrl($input);
$url2 = $result["code_url"];
?>

<html>
<head>
    <meta http-equiv="content-type" content="text/html;charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>waychar pay</title>
</head>
<body>
<center>
<h4 style="font-weight: 100">扫描支付</h4>
<img alt="模式二扫码支付" src="http://www.xxx.cn/pay/wx/example/qrcode.php?data=<?php echo urlencode($url2); ?>"
     style="width:150px;height:150px;"/>
     
     <br/>
	 <p style="font-weight:100">
     请用其他手机扫描二维码支付，或者使用电脑端登陆付款<br/>
     <br/>
     如果您已经完成付款并收到确认短信，可以关闭本页或返回。<br/>
	 </p>
	 <span style="border:1px solid #999999; padding:10px;">
     <a href="../../../index.php?c=race&action=message&re_g_id=<?php echo $_COOKIE['reg_id']?>" > 完成支付 </a>
	 </span>
	 </center>


</body>
</html>