/*
 Navicat Premium Data Transfer

 Source Server         : 本地
 Source Server Type    : MySQL
 Source Server Version : 50727
 Source Host           : localhost:3306
 Source Schema         : bushu

 Target Server Type    : MySQL
 Target Server Version : 50727
 File Encoding         : 65001

 Date: 20/07/2020 16:56:46
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for dd_addons
-- ----------------------------
DROP TABLE IF EXISTS `dd_addons`;
CREATE TABLE `dd_addons`  (
  `mid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '模块id',
  `identifie` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '英文标识',
  `type` enum('base','business','marketing','member','other','system','enterprise','services') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'base' COMMENT '模块类型',
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `version` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '版本',
  `ability` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '简介',
  `description` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '描述',
  `author` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '作者',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '社区地址',
  `settings` tinyint(1) NOT NULL DEFAULT 0 COMMENT '配置',
  `logo` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'logo',
  `versions` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '适应的软件版本',
  `is_install` tinyint(1) NULL DEFAULT NULL,
  PRIMARY KEY (`mid`) USING BTREE,
  INDEX `idx_name`(`identifie`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 108 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '扩展模块表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_addons
-- ----------------------------
INSERT INTO `dd_addons` VALUES (17, 'diandi_shop', 'business', '店滴商城', '1.0.0', '店滴商城', '店滴商城', 'chunchun', '23', 1, '202002/16/b4b9135c-5c04-38bf-ae78-2eb751fb428a.png', NULL, NULL);

-- ----------------------------
-- Table structure for dd_addons_user
-- ----------------------------
DROP TABLE IF EXISTS `dd_addons_user`;
CREATE TABLE `dd_addons_user`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NULL DEFAULT NULL COMMENT '用户类型',
  `module_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属模块',
  `user_id` int(11) NULL DEFAULT NULL COMMENT '用户id',
  `status` smallint(6) NULL DEFAULT NULL COMMENT '审核状态',
  `create_time` int(11) NULL DEFAULT NULL,
  `update_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `module_name`(`module_name`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 45 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '扩展模块用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_addons_user
-- ----------------------------
INSERT INTO `dd_addons_user` VALUES (34, 1, 'diandi_shop', 15, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (35, 1, 'diandi_shop', 17, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (36, 1, 'diandi_store', 19, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (37, 0, 'sys', 20, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (38, 1, 'diandi_shop', 20, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (39, 1, 'diandi_distribution', 20, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (40, 1, 'diandi_lottery', 21, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (41, 1, 'diandi_shop', 11, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (42, 1, 'diandi_lottery', 11, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (43, 1, 'diandi_distribution', 11, 1, NULL, NULL);
INSERT INTO `dd_addons_user` VALUES (44, 1, 'diandi_operator', 11, 1, NULL, NULL);

-- ----------------------------
-- Table structure for dd_ai_applications
-- ----------------------------
DROP TABLE IF EXISTS `dd_ai_applications`;
CREATE TABLE `dd_ai_applications`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '人脸库应用名称',
  `APP_ID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'appid',
  `SECRET_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `API_KEY` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `updatetime` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `APP_ID`(`APP_ID`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'ai应用管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_ai_applications
-- ----------------------------
INSERT INTO `dd_ai_applications` VALUES (1, '店滴AI', '18260702', 'dUhq1DzKOGO2BseeDaqGtQ4EhGto1PSq', 'euSGa9FaVg90vQZsTbIKxPnI', '1580208947', '1580208388');

-- ----------------------------
-- Table structure for dd_ai_faces
-- ----------------------------
DROP TABLE IF EXISTS `dd_ai_faces`;
CREATE TABLE `dd_ai_faces`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ai_user_id` int(11) NULL DEFAULT NULL,
  `ai_group_id` int(11) NULL DEFAULT NULL,
  `ai_face_status` int(11) NULL DEFAULT NULL,
  `face_image` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `face_token` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `createtime` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `updatetime` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 28 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'ai检测用户' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_ai_faces
-- ----------------------------
INSERT INTO `dd_ai_faces` VALUES (23, 10, 1, 0, 'upload/202001/19/e8a7b515-6343-3e87-b206-44653934970c.jpg', '2b0e0b643f1550090e0df5723b500b18', '', '');
INSERT INTO `dd_ai_faces` VALUES (25, 13, 1, 0, 'http://www.cc.com/upload/202001/19/de7bf97b-646f-3c41-883e-217e545abcae.jpg', 'e2c79fad75fe77570b8c0f7b4021a89f', '1579369175', '');
INSERT INTO `dd_ai_faces` VALUES (26, 14, 1, NULL, 'https://ss3.bdstatic.com/70cFv8Sh_Q1YnxGkpoWK1HF6hhy/it/u=485966869,2300262866&fm=26&gp=0.jpg', '10ec6989393375e86227ba52aca8da15', '1579503350', '1579503350');
INSERT INTO `dd_ai_faces` VALUES (27, 15, 1, NULL, 'https://ss3.bdstatic.com/70cFv8Sh_Q1YnxGkpoWK1HF6hhy/it/u=485966869,2300262866&fm=26&gp=0.jpg', '0bec06b07a7a99bfbba58557b271e8dd', '1579503351', '1579503351');

-- ----------------------------
-- Table structure for dd_ai_groups
-- ----------------------------
DROP TABLE IF EXISTS `dd_ai_groups`;
CREATE TABLE `dd_ai_groups`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ai_group_status` int(11) NULL DEFAULT NULL COMMENT '百度ai用户组创建状态',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分组名称',
  `createtime` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `updatetime` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `is_default` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'ai人脸库分组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_ai_groups
-- ----------------------------
INSERT INTO `dd_ai_groups` VALUES (7, 0, '第一组', '1579356698', '1579356249', 0);
INSERT INTO `dd_ai_groups` VALUES (8, 0, '第二组', '1579356254', '1579356254', 0);

-- ----------------------------
-- Table structure for dd_ai_member
-- ----------------------------
DROP TABLE IF EXISTS `dd_ai_member`;
CREATE TABLE `dd_ai_member`  (
  `user_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '人脸招聘',
  `face_group_id` int(11) NOT NULL COMMENT '人脸库组id',
  `nickName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `face_image` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '人脸照片',
  `gender` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  `face_token` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '脸部图片唯一标识',
  `wxapp_id` int(11) UNSIGNED NULL DEFAULT NULL,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `ai_age` int(11) NULL DEFAULT NULL COMMENT 'ai年龄',
  `ai_gender` enum('male','female') CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ai性别',
  `ai_glasses` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ai_race` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ai种族',
  `ai_emotion` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ai情绪',
  `face_shape` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ai脸型',
  `ai_quality_blur` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ai图片质量1',
  `ai_quality_illumination` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ai图片质量1',
  `ai_quality_completeness` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'ai图片质量1',
  PRIMARY KEY (`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '店滴ai会员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_ai_member
-- ----------------------------
INSERT INTO `dd_ai_member` VALUES (10, 1, '', 'http://www.cc.com/upload/202001/19/cf072bdc-e936-3bc6-b7e3-a8684676750d.jpg', '0', '3d809bfd3d06e83c796592cf3c55fcbe', NULL, 1579367498, 1579367498, 30, 'male', 'none', 'yellow', 'neutral', NULL, NULL, NULL, NULL);
INSERT INTO `dd_ai_member` VALUES (11, 1, '', 'http://www.cc.com/upload/202001/19/de7bf97b-646f-3c41-883e-217e545abcae.jpg', '0', 'e2c79fad75fe77570b8c0f7b4021a89f', NULL, 1579368388, 1579368388, 39, 'male', 'none', 'white', 'angry', NULL, NULL, NULL, NULL);
INSERT INTO `dd_ai_member` VALUES (12, 1, '', 'http://www.cc.com/upload/202001/19/de7bf97b-646f-3c41-883e-217e545abcae.jpg', '0', 'e2c79fad75fe77570b8c0f7b4021a89f', NULL, 1579368861, 1579368861, 39, 'male', 'none', 'white', 'angry', NULL, NULL, NULL, NULL);
INSERT INTO `dd_ai_member` VALUES (13, 1, '', 'http://www.cc.com/upload/202001/19/de7bf97b-646f-3c41-883e-217e545abcae.jpg', '0', 'e2c79fad75fe77570b8c0f7b4021a89f', NULL, 1579369110, 1579369110, 39, 'male', 'none', 'white', 'angry', NULL, NULL, NULL, NULL);
INSERT INTO `dd_ai_member` VALUES (14, 1, '', 'https://ss3.bdstatic.com/70cFv8Sh_Q1YnxGkpoWK1HF6hhy/it/u=485966869,2300262866&fm=26&gp=0.jpg', '0', '10ec6989393375e86227ba52aca8da15', NULL, 1579503349, 1579503349, 40, 'male', 'none', 'yellow', 'neutral', NULL, NULL, NULL, NULL);
INSERT INTO `dd_ai_member` VALUES (15, 1, '', 'https://ss3.bdstatic.com/70cFv8Sh_Q1YnxGkpoWK1HF6hhy/it/u=485966869,2300262866&fm=26&gp=0.jpg', '0', '0bec06b07a7a99bfbba58557b271e8dd', NULL, 1579503350, 1579503350, 18, 'female', 'none', 'white', 'happy', NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for dd_ai_sms_log
-- ----------------------------
DROP TABLE IF EXISTS `dd_ai_sms_log`;
CREATE TABLE `dd_ai_sms_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` int(11) UNSIGNED NULL DEFAULT 0 COMMENT '用户id',
  `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '手机号码',
  `code` varchar(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '验证码',
  `content` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '内容',
  `error_code` int(10) NULL DEFAULT 0 COMMENT '报错code',
  `error_msg` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '报错信息',
  `error_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '报错日志',
  `usage` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '用途',
  `used` tinyint(1) NULL DEFAULT 0 COMMENT '是否使用[0:未使用;1:已使用]',
  `use_time` int(10) NULL DEFAULT 0 COMMENT '使用时间',
  `ip` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT 'ip地址',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '状态(-1:已删除,0:禁用,1:正常)',
  `created_at` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '创建时间',
  `updated_at` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `error_code`(`error_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '公用_短信发送日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_ai_sms_log
-- ----------------------------

-- ----------------------------
-- Table structure for dd_api_access_token
-- ----------------------------
DROP TABLE IF EXISTS `dd_api_access_token`;
CREATE TABLE `dd_api_access_token`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refresh_token` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '刷新令牌',
  `access_token` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '授权令牌',
  `member_id` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '用户id',
  `openid` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '授权对象openid',
  `group_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '组别',
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '状态[-1:删除;0:禁用;1启用]',
  `create_time` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '创建时间',
  `updated_time` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `access_token`(`access_token`) USING BTREE,
  UNIQUE INDEX `refresh_token`(`refresh_token`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 459 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'api_授权秘钥表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_api_access_token
-- ----------------------------
INSERT INTO `dd_api_access_token` VALUES (45, 'Bkbt-icls3u0NaMsDIhv1ZkjENmqQfdT_1591177246', '5IcA3tr7VWC4iA-4Ew9U6CJy9IwmNgYY_1591177246', 76, 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '1', 0, 0, 1, 1591177246, 0);
INSERT INTO `dd_api_access_token` VALUES (46, 'lnbofuY-t79Fo5nvwldqz-QSL3H_EAVU_1586982257', 'Zqoj7sjc7WMQ4Uo8uJ8ihJpUCCW1BuIv_1586982257', 81, 'oE5EC0TLr-jpEqRV-x7WqjPax7jA', '1', NULL, NULL, 1, 1586982257, 0);
INSERT INTO `dd_api_access_token` VALUES (47, 'Vhb-QrR9nIfVc_Gir-6noFi3CuQZzZOB_1587700016', 'wXXybp_ZOvepJXZzp891wZsbUkx2uFri_1587700016', 82, 'oE5EC0Uvc4QkT_TgcfhgSfpO4LLQ', '1', NULL, NULL, 1, 1587700016, 0);
INSERT INTO `dd_api_access_token` VALUES (48, 'VUj-Aowcx7fCdtycshtWHbsNPQTe6Aqm_1587299157', 'gS6mTMBTvXIZoPrxgRBToBKQXkAcrxiu_1587299157', 83, 'oE5EC0S5K7EMf1tCf1S3tIBXIbCw', '1', NULL, NULL, 1, 1587299157, 0);
INSERT INTO `dd_api_access_token` VALUES (49, 'rFmZ94DBs0x46pBMQzoiBhF540yYsIFN_1587624234', 's958XXfU6BFiUIIAE5rXwWxmQBeHqhCC_1587624234', 79, '', '1', NULL, NULL, 1, 1587624234, 0);
INSERT INTO `dd_api_access_token` VALUES (50, 'pr4TugYf2HSiWPkPHdQ9JyhiiARSHzsW_1587000233', 'fd9V1cgT-o8mY8fD3KOo87u0eO6GWTfl_1587000233', 84, 'oE5EC0U4u2ZwyzuwckZrXPBolhnQ', '1', NULL, NULL, 1, 1587000233, 0);
INSERT INTO `dd_api_access_token` VALUES (51, '3FBrd1g8rL5OACDz62x_u0aXAun4HK7R_1587009910', 'KJ7hNHOZqKMdwfQYGVbQYbYeMVwDJC9t_1587009910', 85, 'oE5EC0WVJ2F3utO_BOm6LluEuN8c', '1', NULL, NULL, 1, 1587009910, 0);
INSERT INTO `dd_api_access_token` VALUES (52, '8pJ1wl8sntVhpDtTC9IaN-HSbDV4ZNdm_1587012328', '0QdH_wDQulxrSAYRyFchY-xVBct_xtb8_1587012328', 86, 'oE5EC0T_WvEAoNipm3VSSPRzdvkY', '1', NULL, NULL, 1, 1587012328, 0);
INSERT INTO `dd_api_access_token` VALUES (53, '6MBSZkN0lOjfnJNY5_dHxCY5z0MJh-AF_1587027160', '-qgoHpG_4YE7AXPZB-gKvVroMglz0FD1_1587027160', 87, 'oE5EC0b6D5Y4rbunZ898h-xcS6D8', '1', NULL, NULL, 1, 1587027160, 0);
INSERT INTO `dd_api_access_token` VALUES (54, 'GDfIJKyOEnvzgAwWKGut1bM0ZGuhWUTv_1587701480', 'qkdxPmjPikZqDC9yWPiAOmSFAitq94Nl_1587701480', 80, '', '1', NULL, NULL, 1, 1587701480, 0);
INSERT INTO `dd_api_access_token` VALUES (55, 'zJf2Wb4QNjgDdske4iYIaULwU6xhnxDT_1587040257', 'r76m0zajOsTcXiv8rCY3JyOCGivwwnkl_1587040257', 88, 'oE5EC0WsKZhxybJwn8JYdHRg3RQ4', '1', NULL, NULL, 1, 1587040257, 0);
INSERT INTO `dd_api_access_token` VALUES (56, '1I_Yg4VG1cAMm3WxsGvkNU0nldmBQnLl_1587042026', 'rS6H5SIAauUaJin-z6_vI_Z_gJo2e-6o_1587042026', 89, 'oE5EC0RVdf3EtKdWYEpJ2kQbDxwY', '1', NULL, NULL, 1, 1587042026, 0);
INSERT INTO `dd_api_access_token` VALUES (57, 'vxveHD7a7qmMTVaFMc6AgCCmwvLGTNsi_1587085724', 'rBLHFcdEgsq-sO3JTPbPfYbvYu2IO5MV_1587085724', 90, 'oE5EC0W553U-JFQL3uczY04PMAnk', '1', NULL, NULL, 1, 1587085724, 0);
INSERT INTO `dd_api_access_token` VALUES (58, '_JrKwTMrD1Tbg3wFOjOHFGGoMONO3TO1_1587097119', 'aZycKWpyNdvpbvqF5ohtCW1gAV_5tovT_1587097119', 91, 'oE5EC0UUZxACRdtFZdO_Hfl5FkpE', '1', NULL, NULL, 1, 1587097119, 0);
INSERT INTO `dd_api_access_token` VALUES (59, '2tEDcBlROIh61HkRHuZVmMiPgxAjQoBE_1587097248', 'T95Fq-3OCDk-n9OdkBwiWvW5cZQU5DxS_1587097248', 92, 'oE5EC0WCXthR-YCz6nD_YwaMBlbQ', '1', NULL, NULL, 1, 1587097248, 0);
INSERT INTO `dd_api_access_token` VALUES (60, 'ss4HoMPykG4S9X8nQFjGg2wXC8sgIcr4_1587188717', 'MA2o5tfSDtNMz1tZfrzx6ToiPW2Q9-D6_1587188717', 93, 'oE5EC0QznY0pnfvROYus5_4Wcc5I', '1', NULL, NULL, 1, 1587188717, 0);
INSERT INTO `dd_api_access_token` VALUES (61, 'XqGC2FjshB7sIDFNAKp9wNdcbvBAxfgB_1587219784', '_peWoRzDvxs7A24SZ8hGa6Ux611aK7F1_1587219784', 94, 'oE5EC0ZnVtq0pi_hAlyRzcE8oLOM', '1', NULL, NULL, 1, 1587219784, 0);
INSERT INTO `dd_api_access_token` VALUES (62, '-ncV0XkKFw-FpbtV-IEPoDJT7yCpF1B__1587280987', 'f_LPnyyhX0DIfWfzlRR49Mnu6Z_NzubR_1587280987', 95, 'oE5EC0azpuPFyRcyIbxPkE3zRk5w', '1', NULL, NULL, 1, 1587280987, 0);
INSERT INTO `dd_api_access_token` VALUES (63, '2WDNFPyVYqTr2O42XFGXPoDJOAjWIHP1_1587380962', 'Yn63tuRHBoOPz_9ir00MFbA80SDb30yr_1587380962', 96, 'oE5EC0V37yTXf0P_GUKb2KlrWG5s', '1', NULL, NULL, 1, 1587380962, 0);
INSERT INTO `dd_api_access_token` VALUES (64, '0gvuWHsToo9CwGVCNmfj5HeOJFdyoa6c_1587723980', 'fqrGTKBP2NiIOSHSfSwztxhdb_TKD-cu_1587723980', 97, 'oE5EC0YZmEGxxdRNlY6KPT4MMXvw', '1', NULL, NULL, 1, 1587723980, 0);
INSERT INTO `dd_api_access_token` VALUES (65, 'NjhFzCrOcFtdSxA7995-jcEd1WTnmkUP_1587518780', 'G3ZT-NBsFXYHqaTSmd_C286HAnS5QeHF_1587518780', 98, 'oE5EC0cmqtVK_Qs8JLTaFCYQ7rX8', '1', NULL, NULL, 1, 1587518780, 0);
INSERT INTO `dd_api_access_token` VALUES (66, 'WpsbSfa9yvuRBZux66p5GwjqexX2fzwV_1587538658', 'aFqo3bnXMrSP9qVCFO-9AgSOU0wv6jdk_1587538658', 99, 'oE5EC0e33D-2Z6VZVnCw4DjSsDxo', '1', NULL, NULL, 1, 1587538658, 0);
INSERT INTO `dd_api_access_token` VALUES (67, 'HweFirI95Lz9KSkYh-ZpxjF2mdxrh8OP_1587548101', 'H1dFxqkpE6iOIwNvRLshQQnGrVNYERra_1587548101', 100, 'oE5EC0Wqyg790huSMiaMwmKpAyGw', '1', NULL, NULL, 1, 1587548101, 0);
INSERT INTO `dd_api_access_token` VALUES (68, '5DVv5o9os7pTbvQ0FjJ-Epscydxucqko_1587752939', 'MIWsWyJrbPyYhtsD6jIg9oMiPxotJvTT_1587752939', 101, 'oE5EC0VxLFXLk44_vWuL8t2FyuXI', '1', NULL, NULL, 1, 1587752939, 0);
INSERT INTO `dd_api_access_token` VALUES (69, 'Z-mVs5hbIwl_nWxNQPykU-p9UDIb-tD5_1595063828', 'tJ6JbKQf1JqLovqScs4Cn9tAj4CxIJcc_1595063828', 102, 'oWwx95ah9DFDURUj8LRMjRUA955k', '1', 1, 38, 1, 1595063828, 0);
INSERT INTO `dd_api_access_token` VALUES (70, 'lrV0MsnT0r25TdnUNseNxLwpT2fB2WJd_1593836152', 'rFLG535mTggQTTT_kxyrjfxRd3uLtSDl_1593836152', 103, 'oWwx95aYnQqdMbl4qhxJFFeLod-0', '1', 1, 38, 1, 1593836152, 0);
INSERT INTO `dd_api_access_token` VALUES (71, 'Iy6gI7RuTiGa17IfCB5BD1R8JgGb2s1a_1594461914', 'pg87XzIyZD-o0fy2eYh5mAjBiz-EBz6u_1594461914', 104, 'oWwx95UjQy5wOJ84RlUeq0UukVMo', '1', 1, 38, 1, 1594461914, 0);
INSERT INTO `dd_api_access_token` VALUES (72, '1NvOoZtniAYPi_iyVQHShp1lj1QmvLFg_1593680337', 'mtwSBkDG3evEaPGlZDCRN_b9gjKCc3vN_1593680337', 105, 'oWwx95bS5_-Emi0ec9BMQcQbTjfs', '1', 1, 38, 1, 1593680337, 0);
INSERT INTO `dd_api_access_token` VALUES (73, 'bKpoMMctG0fp6o_t9JF4vQy1CpPxWcqP_1595227310', 'HVR_WJcLobf-O-yz4s7K-Y07gw5nZtVi_1595227310', 106, 'oWwx95U6umbfQutwUn-2f1z7Ag1c', '1', 1, 38, 1, 1595227310, 0);
INSERT INTO `dd_api_access_token` VALUES (74, 'oAz5fBjj6j2eE-JdPQH8SefabDfuMpyO_1593848734', 'b7Qoco3NgFfWs-osGRIFKO4yTUkofYKw_1593848734', 107, 'oWwx95el-5IOjlOt9crzJpFD9t3U', '1', 1, 38, 1, 1593848734, 0);
INSERT INTO `dd_api_access_token` VALUES (75, 'tVUPgk6LppVXMnjYoXsitK27v3ZPICVs_1593737459', 'cZWqwi3fI0HeVjbV8JFemtUgvfMo-Jiw_1593737459', 108, 'oWwx95VtjIP0mZhvgFmZvlyd503M', '1', 1, 38, 1, 1593737459, 0);
INSERT INTO `dd_api_access_token` VALUES (76, '70DBXGEnA0tkjvgC4snECakPaIGfY-hI_1595135358', 'z10xYK3ZQmd6ieUuplEyYHuHpgPj5gvo_1595135358', 109, 'oWwx95fScDYPK-58fTvt94z4q7kg', '1', 1, 38, 1, 1595135358, 0);
INSERT INTO `dd_api_access_token` VALUES (77, 'IiVT6u0VJ8PY0dk3ZZT0yBDRkuxFQ9LA_1595135829', 'zTpiSPWDpUe7ooXysc8QWqY5FiouseHb_1595135829', 110, 'oWwx95ZQN3L0ZR5p6emrMQdtM29E', '1', 1, 38, 1, 1595135829, 0);
INSERT INTO `dd_api_access_token` VALUES (78, 'uPpYEt2mVYcna-8twYCXLSw41imppXxK_1595227451', 'ZoZGYP-_CXNyvha8bxwPxiSwqRXQB1ou_1595227451', 111, 'oWwx95byAAaFSFJpD6tedMkKDimE', '1', 1, 38, 1, 1595227451, 0);
INSERT INTO `dd_api_access_token` VALUES (79, 'AfIUCAjLJOvwdEpy9X-11w3sB3uekkHD_1593935463', 'tOyNrtVMnFiVd_rd-ndZFeHJWisnRARg_1593935463', 112, 'oWwx95Uu0dFTSruN9lp3_FscZIVo', '1', 1, 38, 1, 1593935463, 0);
INSERT INTO `dd_api_access_token` VALUES (80, 'i5_MW_ScaRing4HlsDpPfOKVsWzZH-GK_1594568944', 'qCC247whQmdo80koz4pbfGxedncdxkae_1594568944', 113, 'oWwx95Tn0AG1GjOqSYk6kuIZUFpg', '1', 1, 38, 1, 1594568944, 0);
INSERT INTO `dd_api_access_token` VALUES (81, 'MyrgLWyXSEbw8mKCQzSoEMhEjVY9X6C9_1593860005', '86MP0tbMCdW1qKMBzwZ-t0mtWB4Wcq-j_1593860005', 114, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593860005, 0);
INSERT INTO `dd_api_access_token` VALUES (82, '9kGob20E1N_Hti6My_7tu2WVpHTZ763G_1593860013', 'PeDVkK9FkwXpZeVUDhRj5-TUHWKB5PH7_1593860013', 115, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593860013, 0);
INSERT INTO `dd_api_access_token` VALUES (83, 'F-jTZrqK3SlbfeHLOogIqIkWkMaqGs13_1593860022', 'TYH-3tRbljhrpKmeAhWar2fH6slj7vQ4_1593860022', 116, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593860022, 0);
INSERT INTO `dd_api_access_token` VALUES (84, 'xkJAVkt4PBWdoGTalN1Dp_6XhZZYZXJr_1593860032', 'SoZzSg08Ck7BXVeeJ9pDI68zeSlKOP8p_1593860032', 117, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593860032, 0);
INSERT INTO `dd_api_access_token` VALUES (85, '48kQziSoP-S1j0BPE1-bM2HdBDn7zkSF_1593860038', 'ouqkfTYnDd81Aipwmh5flxuYk1bJYBKN_1593860038', 118, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593860038, 0);
INSERT INTO `dd_api_access_token` VALUES (86, 'C9zGrkxN6Tu-4y8ejSdKmyLaQ2JWsjg1_1593860049', 'ACf7YWnIrRzVHiUkFGVE1UgTyENNaflp_1593860049', 119, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593860049, 0);
INSERT INTO `dd_api_access_token` VALUES (87, 'jY1qHebQ2fs1XEJHRp2-AtQNTF6H-7Tc_1593860065', 'JTq8JNcAZqDMW6OvX5_FSzGqSvw3Rx5m_1593860065', 120, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593860065, 0);
INSERT INTO `dd_api_access_token` VALUES (88, 'S3kuO9E9xNXieE1mFhSn0BoTcgM7R70h_1593907376', 'F0Ti1i_RJNa474xqmsrzuNQKcVMlgs-V_1593907376', 121, 'oWwx95QxKmEpXXu9v1Mi40BFc0jY', '1', 1, 38, 1, 1593907376, 0);
INSERT INTO `dd_api_access_token` VALUES (89, 'JV_l38DfDvcr7lzW1jcd8U1tfLc1yGI7_1595227517', 'L1hd04BnHUgtC30en4o4hHIw5xspoNnj_1595227517', 122, 'oWwx95fUmd6ZKXbZvB9fVREpKQcE', '1', 1, 38, 1, 1595227517, 0);
INSERT INTO `dd_api_access_token` VALUES (90, 'IDgqSHo0tGhD8K7DJ03O6nOkbsxVm9Th_1594657894', '_YDGBWPbBWwQXadprJD8qa-9L-rKtorz_1594657894', 123, 'oWwx95b84Uaq7zHo5A5gKgyuzEOA', '1', 1, 38, 1, 1594657894, 0);
INSERT INTO `dd_api_access_token` VALUES (91, '9XHE5wJlzfzSqE4qlFFdCqqxcxZ_5NOh_1593923818', 'HqIyfeDC1PjzvWCh5uD2L0KZmDiCOkxr_1593923818', 124, 'oWwx95b84Uaq7zHo5A5gKgyuzEOA', '1', 1, 38, 1, 1593923818, 0);
INSERT INTO `dd_api_access_token` VALUES (92, 'TSlWVPu99arws_lBrRp_HAabDTCiF9Ur_1593923905', 'ii55jNuVv0pCrJp3qPc7GsXSX1tu6DFI_1593923905', 125, 'oWwx95T2EI8jLOPtR0h_wcaSJfRY', '1', 1, 38, 1, 1593923905, 0);
INSERT INTO `dd_api_access_token` VALUES (93, 'BuIHNm1_uEV9wYsPEB-XJr4bXOkOdqKJ_1593923905', 'emp6f37ll7edxsF-b4c9FmDZw4Brc9uT_1593923905', 126, 'oWwx95T2EI8jLOPtR0h_wcaSJfRY', '1', 1, 38, 1, 1593923905, 0);
INSERT INTO `dd_api_access_token` VALUES (94, 'tWpGNY5x5SKqhZNv4V_uo6IEIAL-UyPW_1595148080', 'PCQu0E01QOWFZD7_1MU2HDYX0JTWJHly_1595148080', 127, 'oWwx95RHEU5GTx8osGiSivcrhhYw', '1', 1, 38, 1, 1595148080, 0);
INSERT INTO `dd_api_access_token` VALUES (95, 'UILZqlYgMUYmMGjQFu7Ku-5MAH6po_-A_1594658719', 'DQa1newomQnuykeL0MuipQp7ka2_Khz6_1594658719', 128, 'oWwx95cJhp1LDYlrz6a16VdaUKB4', '1', 1, 38, 1, 1594658719, 0);
INSERT INTO `dd_api_access_token` VALUES (96, '-09_KwoDrH33Qfg4qix4z6agVDh8gMXr_1593924214', 'qV6dEEEqVlgwFJLm_BXNj1LEJujA2bce_1593924214', 129, 'oWwx95UNtWQtIRO5wzhuyW0DQTJY', '1', 1, 38, 1, 1593924214, 0);
INSERT INTO `dd_api_access_token` VALUES (97, 'PjyD8vg7pLlxbnvBAs5Yzlctn2XWXuCS_1593924612', 'LJYxbxc9LQ0i_pp1Bz_hre0CJl3_ZZEA_1593924612', 130, 'oWwx95QupqBkxFdzIsA08arSSqvg', '1', 1, 38, 1, 1593924612, 0);
INSERT INTO `dd_api_access_token` VALUES (98, '7-99th99vf8qCBcPDS98FC52yMU4Uwby_1593924619', '-rFN1EqUgRw4SNebeUPQY5Dv28iNBx5S_1593924619', 131, 'oWwx95YGCSa0JJkiLTWH87wfjKNU', '1', 1, 38, 1, 1593924619, 0);
INSERT INTO `dd_api_access_token` VALUES (99, 'g8SSk6hY_AANtMiwsZgzOOuV_eiwK1Q5_1594657998', 'FsS9Hq9M-uXA-0TCvD7vnNVfp9HfvvM-_1594657998', 132, 'oWwx95VX0ex0-524YQ7bHAbMikGA', '1', 1, 38, 1, 1594657998, 0);
INSERT INTO `dd_api_access_token` VALUES (100, 'qEW5IQBJLy4t436XC4Fl68ZsqRITEAqI_1593924622', 'hlRQ-nvJgNcHe1bEiBDgBEhLfrEeXhxa_1593924622', 133, 'oWwx95bUPvC9eFHmc5OQn9pNzieA', '1', 1, 38, 1, 1593924622, 0);
INSERT INTO `dd_api_access_token` VALUES (101, 'Js8c4_YoX_gmk6cdbkNkNJRNg69LlbJq_1594657860', 'IiwbR1vfUneP7AT17wcD7AUZR2eALUmA_1594657860', 134, 'oWwx95aiC0o4AcsgKyhcIiw6bMSY', '1', 1, 38, 1, 1594657860, 0);
INSERT INTO `dd_api_access_token` VALUES (102, 'dbKr6qJTmZF3dei7-rzyMkVzRneq8T4p_1593924629', 'X98c05Ma5TNNQ2F80AH5QkboaztujtNc_1593924629', 135, 'oWwx95aiC0o4AcsgKyhcIiw6bMSY', '1', 1, 38, 1, 1593924629, 0);
INSERT INTO `dd_api_access_token` VALUES (103, '79JJgSWL10l1UDi9NyMJbOboNFj66Tgd_1593924642', 'vlONZ5TAyiKQY79Mfb1vqROYICBojafT_1593924642', 136, 'oWwx95angs8CK7RMLUheh4R9jjhQ', '1', 1, 38, 1, 1593924642, 0);
INSERT INTO `dd_api_access_token` VALUES (104, '_vDJL4-WTIgB7ranJOF_1ObxU7_ts-fV_1593924670', 'CUjn0uGu5_l-HijuRF_o1Cn5VjJGxH9V_1593924670', 137, 'oWwx95es4EofB5-M2CoYfSymoAXw', '1', 1, 38, 1, 1593924670, 0);
INSERT INTO `dd_api_access_token` VALUES (105, 'kr2FkX9G-v-m4wFUWBislDPu4tFyBA0__1594657986', 'SS0lAZWD4wUHaTYXtkXWcaV3hSGZNfMH_1594657986', 138, 'oWwx95Y9Z94yJyw-r1pZDP_xaTjo', '1', 1, 38, 1, 1594657986, 0);
INSERT INTO `dd_api_access_token` VALUES (106, 'SYb7LeYUe24NDhlbAmzHaq5Sl8oimgZz_1593924682', 'fF1AJNiSFcLJfVNpCq4IPqmEAX-EaSI7_1593924682', 139, 'oWwx95dTaQ22ZyKdJho5OP7aDs9Y', '1', 1, 38, 1, 1593924682, 0);
INSERT INTO `dd_api_access_token` VALUES (107, 'pWh74JMGtBuQqMgmG2wj9TwHZzjV4DWF_1593924685', 'CUj7dBgvbJ4Nfr5PxNTvsAcF7YzipbKS_1593924685', 140, 'oWwx95TWeSjQUpljC8z4SaCIj2rQ', '1', 1, 38, 1, 1593924685, 0);
INSERT INTO `dd_api_access_token` VALUES (108, 'gGoY-5_wvKu6b_tsQxURaF6kWFBQzVM-_1593924716', '5qNPpdW0kLPfaj03PVMLef34uBUNCydu_1593924716', 141, 'oWwx95Qz2yTiAuNAYxjtmxsfpMGU', '1', 1, 38, 1, 1593924716, 0);
INSERT INTO `dd_api_access_token` VALUES (109, 'ufMob1LkPYMjsvb8B821C1hAlIUNlFHQ_1593924716', 'pGuskyPdmXVmhTFMyrgcSYAJSV_W7NOq_1593924716', 142, 'oWwx95Q5WcHD_segCtQaEy_VwasY', '1', 1, 38, 1, 1593924716, 0);
INSERT INTO `dd_api_access_token` VALUES (110, 'uUfZ94xRQO4OR6YsAyXWWkfIS1HtvxcE_1593924736', 'p6FC_sWpoz5VDJ81dLyHscbJwYPYNUip_1593924736', 143, 'oWwx95edxLvOPPfmi0jIbrL6Vmyg', '1', 1, 38, 1, 1593924736, 0);
INSERT INTO `dd_api_access_token` VALUES (111, 'cvcvVsd1OLhbGsETOGgyoXMc5BSySaXr_1593924752', 'EzGj0xnZEyXJmWqLeLdIzmzxpTVpOkbJ_1593924752', 144, 'oWwx95WVJAXEUdSAcWA0buS7qpms', '1', 1, 38, 1, 1593924752, 0);
INSERT INTO `dd_api_access_token` VALUES (112, 'JrElQPcsyeCKkao8PJlnE3LzS0CN856z_1593924773', 'wBwR-Ulx3cLEsR7d83uzBMTlDrVZETfG_1593924773', 145, 'oWwx95XDdiaLumnaAOQJ82ZukGZs', '1', 1, 38, 1, 1593924773, 0);
INSERT INTO `dd_api_access_token` VALUES (113, 'Y0oNcXd47xqIGez3LHECIX4LKXgDIGuy_1593924778', '3yF0yYIRNhf1FjBXGDgQ-iR64gDiXr9d_1593924778', 146, 'oWwx95XDdiaLumnaAOQJ82ZukGZs', '1', 1, 38, 1, 1593924778, 0);
INSERT INTO `dd_api_access_token` VALUES (114, 'VSTpbnVHuA3tbMXH19fIvn8aPuQVjjkC_1593924797', 'YQlxsxGXm2_5DK26casK_bYuHIkmM545_1593924797', 147, 'oWwx95VxvbMy0xOUO251AjVilZEA', '1', 1, 38, 1, 1593924797, 0);
INSERT INTO `dd_api_access_token` VALUES (115, 's3exwDSOSn0bzQh0V3pKqJrQZTIGpXwo_1593962683', 'PBwwA6UQhFUaUPW_IvWe5ZMDOwSCYGvt_1593962683', 148, 'oWwx95S5AuK19yoRupdRJUuHB9U4', '1', 1, 38, 1, 1593962683, 0);
INSERT INTO `dd_api_access_token` VALUES (116, 'XudOb16vY6Omr4ZV6kY9kIB9tTLCOwm1_1593924837', 'E4J8QQIPryhxxXzCJVXquk9rMdcrVv3H_1593924837', 149, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', '1', 1, 38, 1, 1593924837, 0);
INSERT INTO `dd_api_access_token` VALUES (117, '0ODqG3xvIkqc8JeBG4pJBKMDAufna8ZR_1593924843', 'SYaKi3YlSEJ_KOSBgQMM1EuBC9KtD5ts_1593924843', 150, 'oWwx95SduDaN_RjCtk9ZPKoPG3FQ', '1', 1, 38, 1, 1593924843, 0);
INSERT INTO `dd_api_access_token` VALUES (118, '_jCY5YjtyWlg0HcDqELKZhQh2GiqIgpq_1593924843', 'DxDDqTyN4XwTTqV31qq9W-EdYLF84K_B_1593924843', 151, 'oWwx95V8aF5EpCOmqcGdJPbZWTjE', '1', 1, 38, 1, 1593924843, 0);
INSERT INTO `dd_api_access_token` VALUES (119, '3jzDmTt6z4FTKU9y_KpjCWdEjbbasTib_1593924844', 'E6U4UVBwUTVo9e9wtltmAjB76hV6ModT_1593924844', 152, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', '1', 1, 38, 1, 1593924844, 0);
INSERT INTO `dd_api_access_token` VALUES (120, 'LfZKskGat-wGpzAQqv623uh0FENyFvrX_1593924846', 'WEk88tWqR-u3REDP5EPIHP8BRYJBhgh4_1593924846', 153, 'oWwx95Y9tcFkHR1uJW-IxWfEFT9Q', '1', 1, 38, 1, 1593924846, 0);
INSERT INTO `dd_api_access_token` VALUES (121, '5QOmq1UoZ9ql-77fTyeyuAW_H4ufDAr__1593924854', 'M5oDT55yrELHW017TIJfpFgDaqf0R24J_1593924854', 154, 'oWwx95Ry2FyqlBrMOz-Es_G4W5zQ', '1', 1, 38, 1, 1593924854, 0);
INSERT INTO `dd_api_access_token` VALUES (122, 'iaQ_6l5BQtxnXMERtL7kEX_NMJH_hLlt_1593924857', 'jCteqLeEvkhtW5MayUOZgTJ6On84pNsj_1593924857', 155, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', '1', 1, 38, 1, 1593924857, 0);
INSERT INTO `dd_api_access_token` VALUES (123, 'YwsmlPeGXU7-JStptjaQAjFMqyvVxVL6_1593924863', 'EX_Whz1RoiuyQ2pJfV5NS96iZAcqSt6l_1593924863', 156, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', '1', 1, 38, 1, 1593924863, 0);
INSERT INTO `dd_api_access_token` VALUES (124, '51ZWKGRvEyj3k9TOfb1OTpgVvzPZp8xz_1593924890', 'B-jpK48Gwpvuk3kP54U-ZLlUvJG73AP9_1593924890', 157, 'oWwx95QkO8n-IvBWqKYrp_YitK_4', '1', 1, 38, 1, 1593924890, 0);
INSERT INTO `dd_api_access_token` VALUES (125, 'HQjj1q1UCQuv5BtsLxGQTEurmwRGNFCG_1593924931', '-O3ofn33LyVcYVoRdWayMoFu6eGTDa2E_1593924931', 158, 'oWwx95TGg-GFTEBQ_3GIWLv6GjNA', '1', 1, 38, 1, 1593924931, 0);
INSERT INTO `dd_api_access_token` VALUES (126, '-boJUDe7V-8QubKWOkLqkX21yY3tKIU6_1593924931', 'tHAwS9OCIPNgMKXh7WuK97rUy-j_audU_1593924931', 159, 'oWwx95TGg-GFTEBQ_3GIWLv6GjNA', '1', 1, 38, 1, 1593924931, 0);
INSERT INTO `dd_api_access_token` VALUES (127, 'OO7ggM7Lv4GZKZFYXrdqLMmnq8--UYiw_1593924939', 'RsE0Y6283mQZV2IbIc_B2KQJClwUVvtP_1593924939', 160, 'oWwx95XCDzN44_VhWEDv2x99R_HY', '1', 1, 38, 1, 1593924939, 0);
INSERT INTO `dd_api_access_token` VALUES (128, 'xMMKOpmX11bMpcR9yZYVrYS-GdCH-2yr_1593934311', 'K0BmGnq3hRxVwo4_fvJ9YWP3wpdbbZdQ_1593934311', 161, 'oWwx95djPF6zaDB6MHSosC_fnd_I', '1', 1, 38, 1, 1593934311, 0);
INSERT INTO `dd_api_access_token` VALUES (129, 'QvXtYpGA_ZHBo2q3DTIrbT_UyHJ2L8_k_1593924965', 'vs-GB1b1xAl-3jhJ7k8uuNRVQs53oecM_1593924965', 162, 'oWwx95Zre5iFBePGUNbIjlyjZkOo', '1', 1, 38, 1, 1593924965, 0);
INSERT INTO `dd_api_access_token` VALUES (130, 'PgH-PalVHAPeL9O2b3bcog2OYvNeogdZ_1593924974', 'DW02kF4H1TlMvYu2FHf5ek_PeKZP_ph__1593924974', 163, 'oWwx95ckFuhBxc6xVxwsVubg43Ys', '1', 1, 38, 1, 1593924974, 0);
INSERT INTO `dd_api_access_token` VALUES (131, 'T8_8yq_GScgFIUttCk1dCWYVgkxrLYIR_1593924980', '9KRrUSHspXtJ5nuqXlq71qg1m4rE9ywi_1593924980', 164, 'oWwx95U2iRF1zq_sxoxsUEeai-O0', '1', 1, 38, 1, 1593924980, 0);
INSERT INTO `dd_api_access_token` VALUES (132, 'ka8pCfXh8jqV1wuPBhsg2qCdrA0v5Jqv_1593924985', 'aCx9hDv6nNlUj4orJaaYRVL0ghPIFUA7_1593924985', 165, 'oWwx95QWly3AxrWJz6OO-NILYRxA', '1', 1, 38, 1, 1593924985, 0);
INSERT INTO `dd_api_access_token` VALUES (133, 'pmKYnseIvzsX6cg0jgoVov4r71KpWQMP_1593924996', 'EG0QSMbp3VsA0ydEmsQdCiT2vGCg-Ko6_1593924996', 166, 'oWwx95Y94Ab3QmRWso-kbt4vjjrc', '1', 1, 38, 1, 1593924996, 0);
INSERT INTO `dd_api_access_token` VALUES (134, 'hep5xPPXjuuGj9KsDrlwz1bV6p-uFtYj_1593925078', 'AiIM3u47n5n2stYfL34HRUA2w-V6nsGl_1593925078', 167, 'oWwx95QyTAxbyRwDkxlhpZRjg1vA', '1', 1, 38, 1, 1593925078, 0);
INSERT INTO `dd_api_access_token` VALUES (135, 'MCGNEolCig5xoTjLmapGd-ABQFw99pmA_1593925227', 'k-ufhL6yEqvEepv7QprTgG4Umi3hX7N-_1593925227', 168, 'oWwx95ZuB0BR_h3lZpDrbezXwqYY', '1', 1, 38, 1, 1593925227, 0);
INSERT INTO `dd_api_access_token` VALUES (136, 'wCNDX6oBtgqTNj3c5UHVCAEiiqWABOXa_1593925273', 'NQuAI0Aw8Yvwmb3V9gmOFFAbFaMH2qh__1593925273', 169, 'oWwx95S4nsCm_iYEVmxMlHWtQQZQ', '1', 1, 38, 1, 1593925273, 0);
INSERT INTO `dd_api_access_token` VALUES (137, 'ZOEneYHi4z07xh-LZqltk2hxgYlXmA09_1593925285', 'k6DQHROoGeObH0aj6cmyYy_OqFm-hj1a_1593925285', 170, 'oWwx95UsvEhFHFFqoE4cqnMsM19I', '1', 1, 38, 1, 1593925285, 0);
INSERT INTO `dd_api_access_token` VALUES (138, 'yaC9i9a1EFtHUWAUSmcg7oEKc5PsqvHR_1593925315', 'XtIVTCRZZ1nQJLip4aB88IHmt-qf2YU__1593925315', 171, 'oWwx95Y2s9eg6mtgJrQJcEKHtUEA', '1', 1, 38, 1, 1593925315, 0);
INSERT INTO `dd_api_access_token` VALUES (139, 'eQqvwYb1rJaKXZpuElLPEXBsRBw7o07p_1593925324', 'W_pwjewOJDLTM3AFl3eHl0DRn8v94T-a_1593925324', 172, 'oWwx95QDCP0kt2ZHVYc7vcAlHAtM', '1', 1, 38, 1, 1593925324, 0);
INSERT INTO `dd_api_access_token` VALUES (140, 'b7iSGuQsjDXH4C5aeN89UTFoc4WeJ8vR_1593925327', '13FmmMabfaK96jBIJDnZr_6bJzXe-RgM_1593925327', 173, 'oWwx95aCj6E43hOMr-BseW0J05d0', '1', 1, 38, 1, 1593925327, 0);
INSERT INTO `dd_api_access_token` VALUES (141, 'Oyhb7BuhAnx-kDhbeDJXqkSkC6CVLj0M_1594658806', 'wFcTtBfweQWgkQgX7MCox18SkIo3KkfP_1594658806', 174, 'oWwx95bvTUpC9A2LyW4iTItR5_8s', '1', 1, 38, 1, 1594658806, 0);
INSERT INTO `dd_api_access_token` VALUES (142, 'QiZuTcXip00q8ygXLXqC5V5TamLkaF7K_1593925341', 'vc40kAzUnJiR53AK_qJnCz4tT00djd_c_1593925341', 175, 'oWwx95VMlgvDWg9mh6tJmyoSsmzU', '1', 1, 38, 1, 1593925341, 0);
INSERT INTO `dd_api_access_token` VALUES (143, 'tqa_kAcEYTXhMBGkdfkIK6XHs23FY25W_1593925348', '8KpFxfWiADNKYDtxwe9Sr4tUDRsWLlcR_1593925348', 176, 'oWwx95cQRhxhiLkN8O7hytpfOSp0', '1', 1, 38, 1, 1593925348, 0);
INSERT INTO `dd_api_access_token` VALUES (144, 'FUdq3uAkmHkvu_fIRqIGHJrnR77Q5aP9_1593925389', 'OzZyCY1MLC7yagAo9CH-6-8RJgnFfUJu_1593925389', 177, 'oWwx95f2DepAi8gUw5gVw_GFu3qA', '1', 1, 38, 1, 1593925389, 0);
INSERT INTO `dd_api_access_token` VALUES (145, '7R6I-6QD5u5NzoYHyobz-xycJz9VYAzT_1593925441', 'GnTqQTTMNGtzAxWVFpFELhZAYDbwJkTN_1593925441', 178, 'oWwx95TSUJxzWtDaZ9oy7JfUmukU', '1', 1, 38, 1, 1593925441, 0);
INSERT INTO `dd_api_access_token` VALUES (146, 'veo0_t5bVZgGmemOaYuHPUzslH7FlxXu_1593925447', 'ZeeedWhes1j7aevMQj1D-37LLiQxCoEy_1593925447', 179, 'oWwx95eNZTIrj4Djdw-xXLiFgtvM', '1', 1, 38, 1, 1593925447, 0);
INSERT INTO `dd_api_access_token` VALUES (147, 'wiExarXg3-UOgrRZjL5DuH28wPSuGP4Y_1593925598', 'tbKYd-XQDvYKq2GyzyVH3EHDILZ5T8ey_1593925598', 180, 'oWwx95e0x1PTt5gKX7Js6O8BZTEA', '1', 1, 38, 1, 1593925598, 0);
INSERT INTO `dd_api_access_token` VALUES (148, 'dO917LMrjWNbiUJbmCGDOe3YUeC-jaHc_1593936036', 'TvYUgoSebnLaTidWCtWmueghQrwQFdtn_1593936036', 181, 'oWwx95YzcjIW7jeega7eGcScvig4', '1', 1, 38, 1, 1593936036, 0);
INSERT INTO `dd_api_access_token` VALUES (149, 'E8ONgUryBIQRb988Pg5-z0jaXYQOszV7_1593925683', 'qlZYMspj9MOFi3Ut2Ci3HEIWCFdiyI7h_1593925683', 182, 'oWwx95UijcxDtGSFHX579scd0dcc', '1', 1, 38, 1, 1593925683, 0);
INSERT INTO `dd_api_access_token` VALUES (150, 'CSoJsK1iMKWwGLrsp7zrcP7MtU2aP3ha_1593925684', 'gXv0M6bY0zigYTrjBYjwVePiS6mycqtb_1593925684', 183, 'oWwx95f-dDV38tnYjw94CBJbgklA', '1', 1, 38, 1, 1593925684, 0);
INSERT INTO `dd_api_access_token` VALUES (151, 'XGU9tIM9vNjgPuf5ftIyu88zEOcunSEn_1593925715', 'QNbhKlqjukjJIyD2TcwN2HmlKhdfqlLi_1593925715', 184, 'oWwx95aCj6E43hOMr-BseW0J05d0', '1', 1, 38, 1, 1593925715, 0);
INSERT INTO `dd_api_access_token` VALUES (152, 'NncA8kir7nA91dhCANaXE6aSla32pMlJ_1593925719', 'yxq0srcxiJLRsqQx16BBPeXMyyJ1Pu2e_1593925719', 185, 'oWwx95aCj6E43hOMr-BseW0J05d0', '1', 1, 38, 1, 1593925719, 0);
INSERT INTO `dd_api_access_token` VALUES (153, 'z7Uf0Lr5mhp7ti6xHqEqoL7-QQj8OqPb_1593925727', '26z_WqwigGtDBpL0gTy0ecXsFg4CASKr_1593925727', 186, 'oWwx95aCj6E43hOMr-BseW0J05d0', '1', 1, 38, 1, 1593925727, 0);
INSERT INTO `dd_api_access_token` VALUES (154, 'g5Avw0acZP6aGEnrYZuFAmxfR0YoT6wf_1593925731', 'TE9z0-zK1zlENQnuu5Xp0Sw21l9dTERm_1593925731', 187, 'oWwx95aCj6E43hOMr-BseW0J05d0', '1', 1, 38, 1, 1593925731, 0);
INSERT INTO `dd_api_access_token` VALUES (155, 'EWaKoHlE_au1eEphwg71ft30ZwqQ4iJA_1593925736', 'piB0LLy1um8ui__-MUkLtWwOBnMMjxnB_1593925736', 188, 'oWwx95aCj6E43hOMr-BseW0J05d0', '1', 1, 38, 1, 1593925736, 0);
INSERT INTO `dd_api_access_token` VALUES (156, 'fVr58zCbyWFzDIfPYy7achUtSXdJf6A2_1593925772', 'a2kP4wn6CQbuJ0_eiUmr3JHPhBk_9nGF_1593925772', 189, 'oWwx95TfR-qsGHuIz88vYJ9e5WqY', '1', 1, 38, 1, 1593925772, 0);
INSERT INTO `dd_api_access_token` VALUES (157, 'TKA-yuyo1yGoOltcXulAFamV6xzUFIwQ_1593925793', 'iWze6NqDW8x3GALwH_T64GJuVXuXx3Yw_1593925793', 190, 'oWwx95UY-Cl9ihSEfkPzjDkAjffM', '1', 1, 38, 1, 1593925793, 0);
INSERT INTO `dd_api_access_token` VALUES (158, '-PIfyRDuSVnYS0GdLSplHaV7_zuf34Hb_1594658883', 'Z23AV6kMXzJxgm1M0qJpXQgsrGBeXrzN_1594658883', 191, 'oWwx95Qy1F5qdIOtIsXvsiJGTBuY', '1', 1, 38, 1, 1594658883, 0);
INSERT INTO `dd_api_access_token` VALUES (159, 'ZqWJ-41AQonBhFQsN1GnXoRaGa33oi-7_1593925842', 'WiDTY1Hw__5lSW1cQcMWwHgu8OGb1QBO_1593925842', 192, 'oWwx95VbLCNULgox4bl5T2S34mK8', '1', 1, 38, 1, 1593925842, 0);
INSERT INTO `dd_api_access_token` VALUES (160, 'HziKkXk1PuR8Acn6cncdrvAgsUWdFEIL_1593925846', 'y3Xl8DCVerE-h1JAMqcA950yPa9NmvMl_1593925846', 193, 'oWwx95V_v6Fbbaea1cIkq4-jo8Vk', '1', 1, 38, 1, 1593925846, 0);
INSERT INTO `dd_api_access_token` VALUES (161, 'Dr5T-2DcS3EHyXOb80--KGf3ogr_dOqQ_1593925859', 'vy1Zr89UE304vQHMsLrF0NGBepA2iCzx_1593925859', 194, 'oWwx95VVMaTGDgfNPGz0cU81q2FM', '1', 1, 38, 1, 1593925859, 0);
INSERT INTO `dd_api_access_token` VALUES (162, 'g2nbC0CVO87cKbWRUTrF9oh2tVzr-ZD4_1593925899', 'XRD6TZtaN5csDr5M4IBBZ-s6Y7VAU5i-_1593925899', 195, 'oWwx95Zt1rTcul0x0mrCDru0GEt4', '1', 1, 38, 1, 1593925899, 0);
INSERT INTO `dd_api_access_token` VALUES (163, 'LW1qCSBSMUVjmAghVoWCBdYjDfYGX8hZ_1593925900', 'PBAuXQPnyRG5ucua6fWeYMUOUlbKHr8V_1593925900', 196, 'oWwx95Zt1rTcul0x0mrCDru0GEt4', '1', 1, 38, 1, 1593925900, 0);
INSERT INTO `dd_api_access_token` VALUES (164, '49pnUCyE646ddIH1Jm5xrI4FqM5aZy7v_1593925911', 'C0KdDz6rmCYMHERWXUe_Co-gLk6iZ-Uk_1593925911', 197, 'oWwx95e4yoSFr0dQfIGLJJe-Cmng', '1', 1, 38, 1, 1593925911, 0);
INSERT INTO `dd_api_access_token` VALUES (165, 'SwfxCgj4hYviszeFCy-S7q9-PymItAcE_1593925914', 'nt16nh4msGGo2eJUnlONd4r66TLfG246_1593925914', 198, 'oWwx95W3ahhl4_LqDDg3UyuoAvVM', '1', 1, 38, 1, 1593925914, 0);
INSERT INTO `dd_api_access_token` VALUES (166, 'D13PlODXl40jGm2DLZQfvS5ksXD9w-no_1593925916', 'emCkoxnaV11e3BONVeYezzhRp6VTEwME_1593925916', 199, 'oWwx95TbKBt5rJHzneqGTHygwStg', '1', 1, 38, 1, 1593925916, 0);
INSERT INTO `dd_api_access_token` VALUES (167, 'EpkQBlyEXUpUCY7EapviUuIPRGQsKjgs_1593925931', '5U7ojjl5yYSjDA9m_u7R3U9-pmxuEuBN_1593925931', 200, 'oWwx95byto3vNcaFviGyyPWZ0Pms', '1', 1, 38, 1, 1593925931, 0);
INSERT INTO `dd_api_access_token` VALUES (168, 'P3inSmMgH-psGFW2FAxZK_I1S9Tmhauo_1593925949', 'qfxME_kto6CotVZZZgn1hlBx1Nsln8y4_1593925949', 201, 'oWwx95YTm1laTwozc4rB58ZWxPi0', '1', 1, 38, 1, 1593925949, 0);
INSERT INTO `dd_api_access_token` VALUES (169, '2uRR4nG5qCg8DXMxmN-sjHkSw7QZVj72_1593925985', 'XH26ykV5Saxe1_skGbA2uzCRH9cUPS1K_1593925985', 202, 'oWwx95axLoyVjgyzE85rFq6FbCzI', '1', 1, 38, 1, 1593925985, 0);
INSERT INTO `dd_api_access_token` VALUES (170, 'OmVa1Nk8aHzFCixvM0_oJ3Hn1thpHMLj_1593925996', 'jAqBmOY0hEmVeQCxVx0X5z1y3RSfjnUE_1593925996', 203, 'oWwx95YDBWO594lcy6sMsX4Le4AE', '1', 1, 38, 1, 1593925996, 0);
INSERT INTO `dd_api_access_token` VALUES (171, 'HEnsa6kKGjlkyqsWZ_AsVlD09SD1_zJh_1593926030', '9bq5ttPi5OOZjUtCmdsKBrXzDpUkkrpk_1593926030', 204, 'oWwx95QWrtLjsFQrSV0TYSUnSn5g', '1', 1, 38, 1, 1593926030, 0);
INSERT INTO `dd_api_access_token` VALUES (172, 'YtmGjeYoxRCqP8h_32NRzi2hZfuA8kHj_1593926031', 'zCB1wOtBc7OEm0QlhMbwxLMKndVkMeT0_1593926031', 205, 'oWwx95e5IcPMLd_AZU68gsO1fSAc', '1', 1, 38, 1, 1593926031, 0);
INSERT INTO `dd_api_access_token` VALUES (173, 'P0_J88F8-78ewkAIeBy80iJDtjjfHm8M_1593926082', 'L8yLm5iWAFbBzpeHDzY-W6HiLbLKFwhz_1593926082', 206, 'oWwx95WRPuhSsgnD2AOYjp34LPGw', '1', 1, 38, 1, 1593926082, 0);
INSERT INTO `dd_api_access_token` VALUES (174, '3yxLm2BJ2wOoh5tQZEbVEOJx_8gS3hbH_1593961696', 'VS8GERB9xjvup-6ptGOxxAd3zzKRRo3B_1593961696', 207, 'oWwx95eavsf1OoO3kYyoJ8DImGtI', '1', 1, 38, 1, 1593961696, 0);
INSERT INTO `dd_api_access_token` VALUES (175, '8z_KsgURnR_I8J-KdZU9SH9IrbrpT_X8_1593926082', 'XOGb_sYkErltzUAeozg20XpqpEEfuS-y_1593926082', 208, 'oWwx95WRPuhSsgnD2AOYjp34LPGw', '1', 1, 38, 1, 1593926082, 0);
INSERT INTO `dd_api_access_token` VALUES (176, 'mQJO1O-Py3mLtlFHJ0K5nHNAtg2a-Np1_1594027588', 'c5884K3Q32Kvktqzf4SVvDMGHFJX2fVs_1594027588', 209, 'oWwx95RZVdPoZEpTJmI6Lne3GRro', '1', 1, 38, 1, 1594027588, 0);
INSERT INTO `dd_api_access_token` VALUES (177, '42NKZBraHXRZEImrMDf9UR6xWhuMNPoE_1593926139', 'dlwp53FozIwtI_5IklIdS2B9xAeguIuw_1593926139', 210, 'oWwx95bixQV8uqc8fVgcBm1M-SBs', '1', 1, 38, 1, 1593926139, 0);
INSERT INTO `dd_api_access_token` VALUES (178, 'R2z6uuRYvdNsTN27FwpSxXcMNsGAPlPO_1593926159', 'Wf2TEyCxGZ5564CL-vXS6QV2nPbhHsef_1593926159', 211, 'oWwx95YVXCrF8M-F-_AdkvYLJgWQ', '1', 1, 38, 1, 1593926159, 0);
INSERT INTO `dd_api_access_token` VALUES (179, 'Yw3iU8PDEKSdR3XytqNoXXfdOO4E31O0_1593926213', 'ENMd-IHvyFJOuNn6JzpIiPJqysHfYnyC_1593926213', 212, 'oWwx95ULt2z2QrRGqApirsNpmLTI', '1', 1, 38, 1, 1593926213, 0);
INSERT INTO `dd_api_access_token` VALUES (180, 'ezEQ7FpgPQE47sJRX-aIDB6Tf8lciLIO_1593926221', '5JViNOIMLfBj08tXlME4qZIzysp0xLPp_1593926221', 213, 'oWwx95TtDfgIzTsZDKnvQLAV-g88', '1', 1, 38, 1, 1593926221, 0);
INSERT INTO `dd_api_access_token` VALUES (181, 'iFJIEG9ZFKoHpICx9BnKPe8jjBNvQHNc_1594658010', 'WukbI0l-Ha6r1_DkrWx8uLtPMx7V552b_1594658010', 214, 'oWwx95TmP4ERRjoWIh4V2dodZGSQ', '1', 1, 38, 1, 1594658010, 0);
INSERT INTO `dd_api_access_token` VALUES (182, 'v86hCwZaxoKFpF8DppUzWjT7mAW9L8cQ_1593926330', 'qwyzcEcf-H4dMOwa5iWjq3NmNBMUQnZU_1593926330', 215, 'oWwx95dBxU7TNfoT7HWzpWgzAILk', '1', 1, 38, 1, 1593926330, 0);
INSERT INTO `dd_api_access_token` VALUES (183, 'R6rQpt7codQDwUnPOfrk64IMulboGRWj_1593926383', '9qHvgUSyNAcdsJdp5eS-nJG9RYO7hsg__1593926383', 216, 'oWwx95cHXNj_-joRvyvVTHUD7QX8', '1', 1, 38, 1, 1593926383, 0);
INSERT INTO `dd_api_access_token` VALUES (184, '42K8oJVEaBiRODIJ5cxIZo5VvQw_qCJf_1593926383', 'cmX0AEVMnzDL7ojYTR1Sc0LadCRkc08x_1593926383', 217, 'oWwx95cHXNj_-joRvyvVTHUD7QX8', '1', 1, 38, 1, 1593926383, 0);
INSERT INTO `dd_api_access_token` VALUES (185, '4IL-lPztPRnLRX-I1Itrew0aSAwp3b8A_1593926470', '_EaYcaAqkpTRoC2680A6nkBnXwmmJInr_1593926470', 218, 'oWwx95SZoJ5p3HWagGVcFljWbUSM', '1', 1, 38, 1, 1593926470, 0);
INSERT INTO `dd_api_access_token` VALUES (186, 'AZ8k-zsYe9I9A1jPzAt-i7FcZRvC3iZm_1593926531', 'AvXX6eAKd2bPVmhjpcxXeCq8G-pBruFs_1593926531', 219, 'oWwx95Y4Ymfrb5L_gsNKjd8ayn9c', '1', 1, 38, 1, 1593926531, 0);
INSERT INTO `dd_api_access_token` VALUES (187, 'hqjOkjtDpAvBGS8WdjopIg9cY8UeKmLn_1595227565', 'vwQ5RUmLJhgF-tIZpBtcFdFNOPKf6Koc_1595227565', 220, 'oWwx95VhSyj47r5z8NuotoTs67jE', '1', 1, 38, 1, 1595227565, 0);
INSERT INTO `dd_api_access_token` VALUES (188, 'aJnKgRh8MNWYr37h1Xm8f4-er0OYBvi__1593926592', 'AtC9SrpAB6cSi3Nv3ok-lZAoh5T-n_eo_1593926592', 221, 'oWwx95d-De2nYQgBwIMxuu2NUh2U', '1', 1, 38, 1, 1593926592, 0);
INSERT INTO `dd_api_access_token` VALUES (189, 'GzNv0H-W0EOD4oRp1322QbMjmWMwRJmt_1593926634', 'k-FvgWykvlCPYDlS0_d0_zmQNp3iFg4B_1593926634', 222, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', '1', 1, 38, 1, 1593926634, 0);
INSERT INTO `dd_api_access_token` VALUES (190, '0nurIlVMC13idVrpbDN76FQFClqicw9G_1593926637', 'MGEdK2oBO9Mh2wLKhd0mrAleGW3Ug9j3_1593926637', 223, 'oWwx95WxbirLThUUqtYP2FbOQK5I', '1', 1, 38, 1, 1593926637, 0);
INSERT INTO `dd_api_access_token` VALUES (191, 'gvwCWH97WJwSfL2UANToSKzitLN6yB-m_1593926679', 'ks8xzFpUR-uR0llhee_GNBkbO39-RnvG_1593926679', 224, 'oWwx95e9Jt8ojP9datgBk9HIt-DQ', '1', 1, 38, 1, 1593926679, 0);
INSERT INTO `dd_api_access_token` VALUES (192, '4MtIgWvyBeP-p31aBtD26GhlWrgG81Y7_1593926905', 'yn0wM3WkQqNJi23VDmVYz9Vp_Oq_REFd_1593926905', 225, 'oWwx95Ymodlx89WvLjuynyb-aJzc', '1', 1, 38, 1, 1593926905, 0);
INSERT INTO `dd_api_access_token` VALUES (193, 'rW5kn98gdARvVOiTsWGQBC-qNvzX4Gi7_1593926905', 'rcx3YKmigXWg84nHCUMrPGv5ZXCwEuwG_1593926905', 226, 'oWwx95bKhxQBTIRsID2wGbS1KUVo', '1', 1, 38, 1, 1593926905, 0);
INSERT INTO `dd_api_access_token` VALUES (194, 'iJ3wWfiW7GeUySEjqFdZ3vpIFvdTW1do_1593926941', '9JODCJuvQBxKSnJnARsTvptjpaMjfr_2_1593926941', 227, 'oWwx95TPPv-Cl0qB5wcfxYnE8rto', '1', 1, 38, 1, 1593926941, 0);
INSERT INTO `dd_api_access_token` VALUES (195, 'wd8e6ZWDFr3SYmpx8xzTpME8KmuSKqkf_1594658817', '29-U1KJ8mjUtQBNCizoSbY9G_tvfY0ul_1594658817', 228, 'oWwx95fLgyy6EK74ur-WyItiSS5Q', '1', 1, 38, 1, 1594658817, 0);
INSERT INTO `dd_api_access_token` VALUES (196, 'VWDtN9rfeWpf6KvqEajB_OJ8-Xnb5R4__1593926988', 'sTqC-z6qFZ2uqopnIrELU_wBnhXrOriG_1593926988', 229, 'oWwx95fLgyy6EK74ur-WyItiSS5Q', '1', 1, 38, 1, 1593926988, 0);
INSERT INTO `dd_api_access_token` VALUES (197, 'dlUcVB6oPcvScl4czgoaYXDOmqXlT0JK_1593927010', '0DzOXmmC7jtziA11pJaU9FqJsojGK_G0_1593927010', 230, 'oWwx95ZmgNYwntJFN1KHrWadVwxU', '1', 1, 38, 1, 1593927010, 0);
INSERT INTO `dd_api_access_token` VALUES (198, 'LZyD9Fo_xC8LBRiearbqn_gAqHwfG7Zr_1594454678', 'EcOM5KKEM7u5zcztIIlXJsNb-Ugjq_GI_1594454678', 231, 'oWwx95ey6ucWwxAvo-dnWor0BSiY', '1', 1, 38, 1, 1594454678, 0);
INSERT INTO `dd_api_access_token` VALUES (199, 'aQ5EWHF1ihotfjv5Ipp7DsstLyISvw3S_1593927095', '6UyE2XpEQSrsoYfoHEo1AzppHtmr5cVb_1593927095', 232, 'oWwx95aMY7rZF9HpDvLa6n-_6l0w', '1', 1, 38, 1, 1593927095, 0);
INSERT INTO `dd_api_access_token` VALUES (200, 'U2ksUCqC5K9FruadCXXk7trvdWh9hCYz_1593927142', 'hoHN72ZglxZaiknnooWHGM07TSySnBg7_1593927142', 233, 'oWwx95SnS9zAdYxp0bZeKYyCLEUI', '1', 1, 38, 1, 1593927142, 0);
INSERT INTO `dd_api_access_token` VALUES (201, 'l4_dHfBt_CwdbHQOjiFLE8aKtzHc5cWh_1593927180', 'YMpFX0FLX8RfzGsmpYr-DJuWy8iAadxJ_1593927180', 234, 'oWwx95V5jFdHyKg_LyrWo5XRj2cs', '1', 1, 38, 1, 1593927180, 0);
INSERT INTO `dd_api_access_token` VALUES (202, 'rFhUcpxXdv75TcRfU0muOcFUDjvZTdUH_1593927187', 'udLfX3QpVP9d96sbV-XMWn7da8fg1FtJ_1593927187', 235, 'oWwx95aDYuXrPE7yggYg9dN_rFjc', '1', 1, 38, 1, 1593927187, 0);
INSERT INTO `dd_api_access_token` VALUES (203, '6XrMQJxm43HP6X0Ca1Cs6FokZkrlWF2B_1593927189', 'To8h1DTO4iDE-oa_IE0Lu3oeCYLdNMUB_1593927189', 236, 'oWwx95UjWN_WvAhU1zfwA114nFSA', '1', 1, 38, 1, 1593927189, 0);
INSERT INTO `dd_api_access_token` VALUES (204, 'JRvazrRwDVPCcnO02_C-hnLbcyaI4v9I_1593927247', 'VtmFxuUDRJaRnoKRJONTi2etZp-OX46J_1593927247', 237, 'oWwx95aoO7jiK75EBI2VI3Su2S08', '1', 1, 38, 1, 1593927247, 0);
INSERT INTO `dd_api_access_token` VALUES (205, 'v6bWN5gMyX8s8_24rod1uM5pxHf70dCw_1593927249', 'iAk2KusNMKTwS5hmuUk95QSbD3GzVofF_1593927249', 238, 'oWwx95QjJvCVR8s7QGvukjrWIjPM', '1', 1, 38, 1, 1593927249, 0);
INSERT INTO `dd_api_access_token` VALUES (206, 'QJ1aKR6a0f2k3xRJGzp9NzPnq0rzAJ8G_1593927344', 'Pfx8p3-BZ93-Uud7P1iVDhPevhm48LNi_1593927344', 239, 'oWwx95R2d3oqDnUNg7BumRwaVkeI', '1', 1, 38, 1, 1593927344, 0);
INSERT INTO `dd_api_access_token` VALUES (207, 'R4MEQxelJ6NaB7eSKcYpD_8A0reofz6Y_1593927344', 'cN1miDiFIGYxxUwFcpotm8nAUHHhsR23_1593927344', 240, 'oWwx95for5NPYLBtGJicSDhUMbT8', '1', 1, 38, 1, 1593927344, 0);
INSERT INTO `dd_api_access_token` VALUES (208, 'HJGvL4SbmIYbpdWS5lVN5F4NEDHRUI_P_1593927360', 'oe8i54zj6i00IEcHtChyRjsN9RsG-4ny_1593927360', 241, 'oWwx95VUOs6R6Qz_bQvKVgVy0EWU', '1', 1, 38, 1, 1593927360, 0);
INSERT INTO `dd_api_access_token` VALUES (209, 'l6nAP3Qmni1oLzy7UER3fkkTSdjgx-KM_1593927368', 'RdnZ5Y9BRNWEzi0BLFUXfob8woZ0tB4l_1593927368', 242, 'oWwx95bxrJGORmlUa4VDLsVwh1mk', '1', 1, 38, 1, 1593927368, 0);
INSERT INTO `dd_api_access_token` VALUES (210, 'K0-i9oZQzO3pPUOaY3IzWjYk1-5flHUV_1593927415', 'v7woA9CYEr_-zj2XSOmbs_zOmIMip4KO_1593927415', 243, 'oWwx95ch-K97IPbDS6RxmotlqbPU', '1', 1, 38, 1, 1593927415, 0);
INSERT INTO `dd_api_access_token` VALUES (211, 'XC63F0uJsMkP1j9REyfeNfLvWOyURiXR_1593961530', '4QmEessCHHhdD2mOpmKafv8rTC0WUu2H_1593961530', 244, 'oWwx95UmgMIBXmshRaaN2frIkOvI', '1', 1, 38, 1, 1593961530, 0);
INSERT INTO `dd_api_access_token` VALUES (212, 'ZaTADrkU3RE1yIGANPqdUAZRgqzrSzIa_1594708972', 'AJ0x7Hz-p5FEIPMd_vIScjvM_lWUY1nU_1594708972', 245, 'oWwx95b1DaKyZ6TkkeFZO2ls0GYY', '1', 1, 38, 1, 1594708972, 0);
INSERT INTO `dd_api_access_token` VALUES (213, 'l4sDV_lN9CZ3dEfn2e3GPJksDrGaOUFJ_1593927561', 'r0RpdIk80wla5a8Ul6edpVWFhintoqgv_1593927561', 246, 'oWwx95S7epuP9FZyjL7mKYEk5SMw', '1', 1, 38, 1, 1593927561, 0);
INSERT INTO `dd_api_access_token` VALUES (214, '7EljLdjrWRVn9FGYmPCt029qt5HIuhaP_1593927661', 'My-Nn1_y81z7_MHPjWpJ-7S3zDEN8nF0_1593927661', 247, 'oWwx95Xyn5NSHoM5aNKrMCd60A00', '1', 1, 38, 1, 1593927661, 0);
INSERT INTO `dd_api_access_token` VALUES (215, 'DjUpF_fcV1NGtDgZl72A9eLgw7gy6soa_1593927663', 'Mf_hikgzcF5hJc9U8NVx8x4DyE1SvxvK_1593927663', 248, 'oWwx95WCjKDXyoTMw77MRRmthCZc', '1', 1, 38, 1, 1593927663, 0);
INSERT INTO `dd_api_access_token` VALUES (216, 'mTRfBHZbVGp1c21zmIA5iA8fQLXLCPnk_1593927757', '7ernup-Zfn8YcENWY0Q92RspYVzVlEnm_1593927757', 249, 'oWwx95XRnbiom_x151uU7Ro2v-84', '1', 1, 38, 1, 1593927757, 0);
INSERT INTO `dd_api_access_token` VALUES (217, 'OwLXmxI2EkGjCjmbDqAEtDEpU3yFVRap_1593927766', 'avV0LVOHS_mSSVgp280QS_TGazmCF5wm_1593927766', 250, 'oWwx95U2Xvrpb8qiy8UYITC_zpVE', '1', 1, 38, 1, 1593927766, 0);
INSERT INTO `dd_api_access_token` VALUES (218, 'VboFGTFAy8_yQuEB5JT_03IzNNh8BWGM_1593927828', 'tGBK01Dc0mWgqME5Du2x5zgoscL2cIa9_1593927828', 251, 'oWwx95UQrR6U47VQ9VAYRl51uxUQ', '1', 1, 38, 1, 1593927828, 0);
INSERT INTO `dd_api_access_token` VALUES (219, 'f91gFLa8MrU0OZvLqYgA96rm425tJj5__1593927828', 'sNVC05RRSCCdOJrAKF11sgzYlX58JRop_1593927828', 252, 'oWwx95UQrR6U47VQ9VAYRl51uxUQ', '1', 1, 38, 1, 1593927828, 0);
INSERT INTO `dd_api_access_token` VALUES (220, 'XYt9-B0eoNNRFyu2Np296OWU0td47EQm_1593927932', 'TIentdNdsleCcEOokLiCidygzY8wZJFt_1593927932', 253, 'oWwx95fxfsM7plNBLno82HIXKdy0', '1', 1, 38, 1, 1593927932, 0);
INSERT INTO `dd_api_access_token` VALUES (221, '0oXrpY-fpZ9P0qgA2cBgj0haQsB7dmPS_1594658767', '7j-0hiARMu1ykqxG-DptR9X_XtbgOM3C_1594658767', 254, 'oWwx95bAKEF_GKY0JKwD1iADtgu0', '1', 1, 38, 1, 1594658767, 0);
INSERT INTO `dd_api_access_token` VALUES (222, 'OwuCWoAPtwWDuBKg2Lqu56IVuIIwHNtp_1593928146', 'otOIXKvWxjMn2icYmj2H9mHD-YfZwblM_1593928146', 255, 'oWwx95feH3vHeht0pvbwHPFOjdp4', '1', 1, 38, 1, 1593928146, 0);
INSERT INTO `dd_api_access_token` VALUES (223, '3sezRoFljDzUCZ50_QyEv59TgKbeTN9g_1594049509', 'Ru6hgu8F6UVQ2yBhYBw2s3U5lNYWiqYX_1594049509', 256, 'oWwx95ZipdChJ-PYiVyt7B517rlc', '1', 1, 38, 1, 1594049509, 0);
INSERT INTO `dd_api_access_token` VALUES (224, 'NsW_v5ann3JlDi-wf-2K3HFzL8YxR9k3_1593928283', 'GDe3aOA9pxig4XA_kmt6w_mkmkJzGDFD_1593928283', 257, 'oWwx95TDWkjoZN7P7_bm6aWRK7_0', '1', 1, 38, 1, 1593928283, 0);
INSERT INTO `dd_api_access_token` VALUES (225, 'NPTfb6ap1Z7qorTKClbhCE9GUDpJcEAl_1593928412', 'Ln2k2L4KLoG1e0wAxTWYN0Ajq-pnJrYv_1593928412', 258, 'oWwx95Y_b-lF1yCBLsimrltQIH-U', '1', 1, 38, 1, 1593928412, 0);
INSERT INTO `dd_api_access_token` VALUES (226, '7ENyDJiT3MXvB1KpSDlExIyfMjM_ZXm5_1593992658', 'GmjfAXTe0_GYVwS4cATZQwwqjQZiPj_Q_1593992658', 259, 'oWwx95RA-j0ZWWHPdE8b_24SOLDc', '1', 1, 38, 1, 1593992658, 0);
INSERT INTO `dd_api_access_token` VALUES (227, 'oFIfOr0c42i7YCZ4UTqgt50hsVu-4UYw_1593928560', '-HrqRhiTtAvgDuZ9Cti1ILiEjkwO5lst_1593928560', 260, 'oWwx95VS4932aDxK4zKHmoJhhZY4', '1', 1, 38, 1, 1593928560, 0);
INSERT INTO `dd_api_access_token` VALUES (228, 'zCipoDCWa62bLLsAxOE81p1QzktQ65VB_1593928618', 'AldKB8BwxiBMOV4iaTO78sBj3QwvsLb9_1593928618', 261, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593928618, 0);
INSERT INTO `dd_api_access_token` VALUES (229, 'jDqReh2NFIDDGkscu5yfuTX3PuWKVHmb_1593928626', 'vc8QOCaIl8opo5FFAKdDPxuvUx4NmgXz_1593928626', 262, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593928626, 0);
INSERT INTO `dd_api_access_token` VALUES (230, 'lYj07fHFi00dY9xTMV4zTAXTIFEfkKVq_1593928670', 'We49xxnhoAEZgr4KlAThco0fas2DOC47_1593928670', 263, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593928670, 0);
INSERT INTO `dd_api_access_token` VALUES (231, 'VXUe16o-cd1t2S_re4SyFLhRJ3UzJQt6_1593928710', 'kLVY6HVmNnBPyOVKM_X4uAatKlKt4-cb_1593928710', 264, 'oWwx95ZFm07zSdqR976eaFz3EaIw', '1', 1, 38, 1, 1593928710, 0);
INSERT INTO `dd_api_access_token` VALUES (232, 'nQgZCIZVx1Rdb2gMWt6XempVLMZ0h5ZE_1593928818', 'WbhU94I5l1qHnP52wUJQXX0IBzoL06be_1593928818', 265, 'oWwx95fEsoSKZwkdLNPspWop43Wk', '1', 1, 38, 1, 1593928818, 0);
INSERT INTO `dd_api_access_token` VALUES (233, 'j2-rO7Eo_av9EwR-hNTHIaPSbTBq_hGa_1593958508', 'NSDGbeJQlajKLFahTAkzMmfn54nv1bkK_1593958508', 266, 'oWwx95VhtUaVi0mXSyOBeostTi6c', '1', 1, 38, 1, 1593958508, 0);
INSERT INTO `dd_api_access_token` VALUES (234, 'nMELX9YsZc7wQi4K9MwypUY9Qqq8pjmm_1593929015', 'Jc5FrAELWzJpLGUipN9pPY5E3qNJEzPD_1593929015', 267, 'oWwx95Xw0NLN_QiNTH_rGNyz5u6w', '1', 1, 38, 1, 1593929015, 0);
INSERT INTO `dd_api_access_token` VALUES (235, 'aSPueEHIEtBEocbuuZNExgyLvb_gjrn__1593929018', 'vfY5FzW2Y50tfauzqETLVTDelXRJtM3M_1593929018', 268, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929018, 0);
INSERT INTO `dd_api_access_token` VALUES (236, 'wOjCKu2TP2-yjBujg9ey7hFiOvmAEU3F_1593929046', 'WxuwUSib4j4Dowq8WvNPcsrpyyqgPeKG_1593929046', 269, 'oWwx95QpsogZjILc_JveW32gqfv8', '1', 1, 38, 1, 1593929046, 0);
INSERT INTO `dd_api_access_token` VALUES (237, 'X4Pda4tassEXxR0nVvMfIb7R9Rrfx1dT_1593929052', 'i25zlrJPCpwxPG4S9HRE6VqyhWTpUtNR_1593929052', 270, 'oWwx95cdOFfq2Lf97HpQmHWgjqS8', '1', 1, 38, 1, 1593929052, 0);
INSERT INTO `dd_api_access_token` VALUES (238, 'mkFvMzFVDxU5KEywylG9Ee8hN7pUSHj7_1593929109', 'THQTCyVpz3p4btUaEwBI16u4GjqUyxI7_1593929109', 271, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929109, 0);
INSERT INTO `dd_api_access_token` VALUES (239, 'knsQs4gWXrYADgMuUiTPIJcfGksd4-QL_1593929116', 'bPWMqNwkYrH5fXUmgoljqViFbu7gXmue_1593929116', 272, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929116, 0);
INSERT INTO `dd_api_access_token` VALUES (240, 'YQZvi2qWjspqe73Dc6Buu293gD17bBc0_1593936975', 'zBkIFX-OJYSrMnNhI9xpjZEXjbeIwR2B_1593936975', 273, 'oWwx95V0bubaaklQ4Knw4c4dW-wA', '1', 1, 38, 1, 1593936975, 0);
INSERT INTO `dd_api_access_token` VALUES (241, 'Jvz2vaXTFVMdKNQ12VC6acxjD5wYEgc7_1593929189', 'po7UXTVrceUkaVrIuBkhHkNQWBDlIIAr_1593929189', 274, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929189, 0);
INSERT INTO `dd_api_access_token` VALUES (242, 'BeqaUITz8USXN11QVhE2FW_B1d8CewBH_1593929284', 'ouHag1k_2wntedVPdpLD1_WYdSI6zvo0_1593929284', 275, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929284, 0);
INSERT INTO `dd_api_access_token` VALUES (243, 'PKRxD3p359gralT_s91UR5g3ckZYQEBb_1593929288', 'kl7V_-s-hEb7qQ9UsQzSDAN3_FEpIvjV_1593929288', 276, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929288, 0);
INSERT INTO `dd_api_access_token` VALUES (244, '01-irZ-1D1ldmdFm7Skqj9p6hneIjeqN_1593929293', 'WUA0puVBoxVxyBVSI9dYDG_K4t5-g7Td_1593929293', 277, 'oWwx95etNxh_PsCgpVMXnH-XM8Oo', '1', 1, 38, 1, 1593929293, 0);
INSERT INTO `dd_api_access_token` VALUES (245, '32o1hlvh4otddFBJb9Si3V3sLDwH4L8X_1593929294', 'o695RoIfqjnja7lBneEE6nehw7IDiPGU_1593929294', 278, 'oWwx95R_x1FMqRYMFFw8PWfT7nL0', '1', 1, 38, 1, 1593929294, 0);
INSERT INTO `dd_api_access_token` VALUES (246, 'lfWzBsF3pP7sus3IZTZUdWazlwja-0eJ_1593929301', 'LTb43cNWTugXjNNdta1tjmfeL5n6tLdz_1593929301', 279, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929301, 0);
INSERT INTO `dd_api_access_token` VALUES (247, 'Xxq2BQrCtIYsteG867qgdl-VlYpb8iVS_1593929309', '5UQAEtHL869Ln3OKreAmO5MZGhsmF7BY_1593929309', 280, 'oWwx95bO2rhjj-ijlmKgzRZ3-ySM', '1', 1, 38, 1, 1593929309, 0);
INSERT INTO `dd_api_access_token` VALUES (248, 'QRvmuaackv8BC58NveiQ42tdpDHbKLkj_1593929312', '3_aIWb4mgUhmnh2eNyvdKUkAQjvUt5pR_1593929312', 281, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929312, 0);
INSERT INTO `dd_api_access_token` VALUES (249, 'Py6amv5dG31sjRloGb63q7T35ybNCOPm_1593929321', 'uxlQYiRAwluSG2mYSrbdgufhS9EUkLyN_1593929321', 282, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929321, 0);
INSERT INTO `dd_api_access_token` VALUES (250, '9kv3dv5psLdMNU4CE7LC8CnLykwU06yf_1593929330', 'g8UWI9ZGaFeQA3EgkLLTUXcxVmh_2BO3_1593929330', 283, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929330, 0);
INSERT INTO `dd_api_access_token` VALUES (251, 'gBjWgjsNPDKmoRD9RZG94pDNsBIV5CXT_1593940771', 'kGVg_qh8jkxOFqNiT5a2lE2A9tztvAeb_1593940771', 284, 'oWwx95Z8gRNa3HdSZ0kdUNcHJQgE', '1', 1, 38, 1, 1593940771, 0);
INSERT INTO `dd_api_access_token` VALUES (252, 'Pguc9ibWvNE547H-iu_spdzsoDfF1zO4_1593929375', 'I8ngCccXcIDBkoJ2ha6Fk0kXrliKiHjj_1593929375', 285, 'oWwx95aWqQ3OaO911ab6Kloi4VHY', '1', 1, 38, 1, 1593929375, 0);
INSERT INTO `dd_api_access_token` VALUES (253, '1OcW5Hh-UoE_xtoM9gUGsW3jOw2P8pdk_1593929425', 'rd8fxVN9jAJMvemx3jismHBgJICd-Z_W_1593929425', 286, 'oWwx95ZpOvXKZnNRu8W-oSTFuYQM', '1', 1, 38, 1, 1593929425, 0);
INSERT INTO `dd_api_access_token` VALUES (254, 'atUHYG89lpD-NfZz7zyWItRHJCVTUoi9_1593929469', 'RwQkGZX3SRPa-_abKKilNElR-NhpG9fF_1593929469', 287, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929469, 0);
INSERT INTO `dd_api_access_token` VALUES (255, 'z8_o5W278ap2AfH78hhUd1Y9IEi44A8X_1593929487', 'GSXwcCgE2hBWFJuyGOXM-rrrKcc49M1s_1593929487', 288, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929487, 0);
INSERT INTO `dd_api_access_token` VALUES (256, 'FUf7Z8T-oiCwLfZldENgkZYcbogksF_G_1593929513', '0IJApPQj_SEXdUE63aH0gVkgi9dtksYR_1593929513', 289, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929513, 0);
INSERT INTO `dd_api_access_token` VALUES (257, 'T4DW6WtZcFxgR02JZvhaUJ-VhtnC7_pY_1593929517', '7NsMCrOoGA4e60nqUgQTR8_T-vJRk8c4_1593929517', 290, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929517, 0);
INSERT INTO `dd_api_access_token` VALUES (258, 'Du0SyVBSm922qRTydv_ss9x81t3G4tXC_1593929566', 'Gemynwh14PW6svUTJDWOdAp1M1v6y8fz_1593929566', 291, 'oWwx95R-27dwirXJYgBVMBcghgxE', '1', 1, 38, 1, 1593929566, 0);
INSERT INTO `dd_api_access_token` VALUES (259, 'RObVXHgkSmbTCT0gKDgIBAUN5yAEFOzu_1593929642', 'EnAHUKuTPbQO0rMTerl93KCMz3pV946R_1593929642', 292, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929642, 0);
INSERT INTO `dd_api_access_token` VALUES (260, 'AIlYdvvgEk6QTuVOYS8EplLfZ9qsMBWB_1593929665', 'Fyiey2QDu-BoKQIrBWf6tkx0SvPGX7fR_1593929665', 293, 'oWwx95dHBZDmSxZn1j8ZZ31ti7fI', '1', 1, 38, 1, 1593929665, 0);
INSERT INTO `dd_api_access_token` VALUES (261, 'Le8TEG3CcN3WYtm4dGtALlg99bbiYMbq_1593929680', 'Uw0b5I-UAgzkBm4wEHnoL0sLKCtfGeIX_1593929680', 294, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929680, 0);
INSERT INTO `dd_api_access_token` VALUES (262, '5Lu_qntIJYVjWXYlEDT4eFCcfvTUt00k_1593929683', 'vbJUqgemDmGIYdohlzobHVVABcNxi3Cu_1593929683', 295, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1593929683, 0);
INSERT INTO `dd_api_access_token` VALUES (263, 'YSYut3dQgjc_o1Fd-Qiuoh2H1UTl3k_7_1593929780', 'P3fBRvucQapqQLtKxJps3xWWvO6FyCXY_1593929780', 296, 'oWwx95WWaZyWmPvc9aedY_vhEKLk', '1', 1, 38, 1, 1593929780, 0);
INSERT INTO `dd_api_access_token` VALUES (264, 'AYJdHZUETdsbxmNM77Wb6hKzkrgkm_qo_1593929813', '8wxuanX4p-XOmoQ7ak6Mjzax9eYqm2tr_1593929813', 297, 'oWwx95Tudd79nq5m46RT3AM9Gdy4', '1', 1, 38, 1, 1593929813, 0);
INSERT INTO `dd_api_access_token` VALUES (265, 'Mj7XWhoFJsR1_ohC4przW20gq760D6Km_1593930030', 'Pmkkx1H6KKAIuVLmb3gWANkTb0lXYfrI_1593930030', 298, 'oWwx95YWqExUs_Wqo3kU8tgIlcOI', '1', 1, 38, 1, 1593930030, 0);
INSERT INTO `dd_api_access_token` VALUES (266, '--7O1naCOZA4uVDmYP-Dq-rOHvUkIbws_1594658261', 'SVCq3WHSseFAfJ1j3jc42-TyzjIn9BfR_1594658261', 299, 'oWwx95ep53Q927bs9qhsz2cN2FFU', '1', 1, 38, 1, 1594658261, 0);
INSERT INTO `dd_api_access_token` VALUES (267, 'fwxdMDgeAMlFQHm_pf9nSfqRP3pi72Yf_1594657911', 'fLDUXdZQg3UG0vDoZ0uUup6wVcarJvOn_1594657911', 300, 'oWwx95RPBSAiq0PZh0n_P8V28jSs', '1', 1, 38, 1, 1594657911, 0);
INSERT INTO `dd_api_access_token` VALUES (268, 'C9aYXL6FKXIlrannaRfzE9JXnxGY_7aK_1593930867', '7cH2Uzi9j1xorFthtBz3hhlbXXiS44sc_1593930867', 301, 'oWwx95X8ZFbA0Dd2-7Fo8a4sIUgc', '1', 1, 38, 1, 1593930867, 0);
INSERT INTO `dd_api_access_token` VALUES (269, '887isa8q9gbP5YysQLTJVH3_QPI8Ye5d_1593930915', 'SPoKKraw81yqRAeRtPyQa5_gnUPxeNaj_1593930915', 302, 'oWwx95c-7nsSjv-vro95uP97u7b0', '1', 1, 38, 1, 1593930915, 0);
INSERT INTO `dd_api_access_token` VALUES (270, 'GUet_tB58OPH4Uywt4-mfI7-SxoOlcDd_1594658247', '_GImHdvUdYlXbDr5gGrTPffHzw8LM6xD_1594658247', 303, 'oWwx95VbcQ_SxxsA-xXWfMBiMmFM', '1', 1, 38, 1, 1594658247, 0);
INSERT INTO `dd_api_access_token` VALUES (271, 'CGXVPnv-8CyHSijbJ6AEIlbfH-26nBro_1593947876', 'FqknlQ8Jf0mv42uMVbxEXZsSVwHfA8QC_1593947876', 304, 'oWwx95a76ckXDjIKNrhe-xc2lV1M', '1', 1, 38, 1, 1593947876, 0);
INSERT INTO `dd_api_access_token` VALUES (272, 'cXv68bIf16d2TDVid75bWlVhN0oVbTFM_1593931113', 'EUElNPKQM7X0w5YHGkqAd65naYX2pIC4_1593931113', 305, 'oWwx95a2X7zCE2cduhR7WcSFWP0Y', '1', 1, 38, 1, 1593931113, 0);
INSERT INTO `dd_api_access_token` VALUES (273, 'Te-ghmIoxRYb5lx4sZX4H84Q8gSrx493_1593931198', 'dtuWmoOgAHnn1B-2RXWtY-dpqMOv6SKc_1593931198', 306, 'oWwx95YxlBJRb1SZyQ_qsXqrZigY', '1', 1, 38, 1, 1593931198, 0);
INSERT INTO `dd_api_access_token` VALUES (274, 'NT2TBezAMa4OwXVyV36IeIb5pl47b_51_1594657893', '-Mep-vi6I4mbEHoZgK-1q5vdgR2yXieM_1594657893', 307, 'oWwx95fyfOa6Bh9nrQa9SR2IcXX4', '1', 1, 38, 1, 1594657893, 0);
INSERT INTO `dd_api_access_token` VALUES (275, 'IXhtFUU8i6t6gHn8BKbxVqmGsXuIFgwy_1593931905', '42ltIlxO7hP9M524iMSuNgkrtsYEEZ7-_1593931905', 308, 'oWwx95bI9qiXd0rzYrYqXbcOM3wo', '1', 1, 38, 1, 1593931905, 0);
INSERT INTO `dd_api_access_token` VALUES (276, '6sSYeXF24u7eN5AKi4r_tl8uq-X_vF72_1594121831', 'jph4Vfij-it3LHzeXF2Bg4BiMdU0KLaW_1594121831', 309, 'oWwx95R58IVaBdp9vtbPKD3t51r8', '1', 1, 38, 1, 1594121831, 0);
INSERT INTO `dd_api_access_token` VALUES (277, 'DC5Jl0D9pL6ZfZ9jvl-YN8wDhK8O9BA8_1593932318', 'wMGZDfIPFz61vhtKG6J4QcmXv5rCkdly_1593932318', 310, 'oWwx95ZAW3fX5XfpBjh0sBlMH4PI', '1', 1, 38, 1, 1593932318, 0);
INSERT INTO `dd_api_access_token` VALUES (278, '-c9BtrZUuqDyl6G8_59rA-ptI_Lboyv0_1593932416', 'pw4z3DfAIw3h1FSq4VMqsdtKk3lytpBA_1593932416', 311, 'oWwx95YFJEca4KINGv7eK7SR6qXg', '1', 1, 38, 1, 1593932416, 0);
INSERT INTO `dd_api_access_token` VALUES (279, '3RJe_8sZBTYQrsSAXQGu4VFelIbXF1cJ_1593932612', 'ruosi4HV4rhJU9krZ54WSr7JkOcIJeej_1593932612', 312, 'oWwx95QHgolc0-EswBZrhy7lkXmU', '1', 1, 38, 1, 1593932612, 0);
INSERT INTO `dd_api_access_token` VALUES (280, 'AF1vIT-K7Sj-WifHX-ng22eO4T7ZC7_8_1593933103', 'G11-xo42pq4C5BCycHE2PfMF_DN2_NdP_1593933103', 313, 'oWwx95afkiUc3rHzHBpmv9PRlf_U', '1', 1, 38, 1, 1593933103, 0);
INSERT INTO `dd_api_access_token` VALUES (281, 'tAm0uNyl6pmUIsHuSy0H8ffI2E3lIpyF_1593933116', 'f27VzhEbhqzzWjTNpmRmjqBFW1Es2TXZ_1593933116', 314, 'oWwx95Ymzobx4MINmv_GOSSdCWJM', '1', 1, 38, 1, 1593933116, 0);
INSERT INTO `dd_api_access_token` VALUES (282, 'HxcgqRs0f1vjatUdFdjofwfw3XmcWIy9_1593933131', 'IC6dxHKtgbhxviAxCP-yOLX9Zhu6K-WV_1593933131', 315, 'oWwx95c9zSDg8kynVPj-bkS-PWYo', '1', 1, 38, 1, 1593933131, 0);
INSERT INTO `dd_api_access_token` VALUES (283, 'tZJGTpcD9grY762ytppBVuZWaPdkywdV_1593933178', 'H8aU4M1hc5HFp4b-SYbBxLDGNMpJRrtc_1593933178', 316, 'oWwx95eUVMnHXYhsJG_cfXC2wsP0', '1', 1, 38, 1, 1593933178, 0);
INSERT INTO `dd_api_access_token` VALUES (284, 'U9P_P4j1tdG6-XnrThMjXMpGLYuvZTxA_1593955921', 'z8djva0gqyuXB_2xEGqfWo5H3a9YgT31_1593955921', 317, 'oWwx95cFaoKLQ5MoE9iwSpxJAHgM', '1', 1, 38, 1, 1593955921, 0);
INSERT INTO `dd_api_access_token` VALUES (285, 'pjwiC2Ury-c7jId_hEfkTqMpKHKAMvmG_1593933361', 'os-rlzevXoC7XiFJw7sgzlo1KG7MARz4_1593933361', 318, 'oWwx95alJQUu3IUsgl6HSZWqae4o', '1', 1, 38, 1, 1593933361, 0);
INSERT INTO `dd_api_access_token` VALUES (286, 'eyzraKohDGeGqt1YBZuZGwl8xQRFDrs7_1593933365', 'tHBtaB6fofv-Hd04Gfx6k3jGru577ZAK_1593933365', 319, 'oWwx95dR5pwiJMju3b8Ow7Afzru4', '1', 1, 38, 1, 1593933365, 0);
INSERT INTO `dd_api_access_token` VALUES (287, 'IONiVccgOBc-Tl6RIqdIF9eik-ol4z-7_1593933854', 'eiJn5Wlo5-Al8C3DxqCZ5rifxxx6R0XL_1593933854', 320, 'oWwx95Rzs11GCq6Gg0JlKg9omlsE', '1', 1, 38, 1, 1593933854, 0);
INSERT INTO `dd_api_access_token` VALUES (288, 'DqGJ_3o3sjCIUh0avxVXEwy_mLCAeLCs_1593933860', 'qMmuQYEgyU2Vz_Nxa9LbMHDJFN0s8rzd_1593933860', 321, 'oWwx95esBs7aIdyZCG3y4muc0oXI', '1', 1, 38, 1, 1593933860, 0);
INSERT INTO `dd_api_access_token` VALUES (289, 'PH2nto02TRu8_BJUF94y_dtc5SjO2ca4_1593934043', 'EybRcRqe6s2LJ94MjLn1Wwjp9Pi7Q4Gb_1593934043', 322, 'oWwx95fWWbZssQuma1T1gc4yAZO0', '1', 1, 38, 1, 1593934043, 0);
INSERT INTO `dd_api_access_token` VALUES (290, 'm5EpZeVyu8kQp-yPs9S82R2Fnmd-4OHQ_1593934101', '_K1ZXrASETyIiqd8_7Kc7ilkBsgVFVwM_1593934101', 323, 'oWwx95ZNkhLeSKu4v4-swOhYRtjo', '1', 1, 38, 1, 1593934101, 0);
INSERT INTO `dd_api_access_token` VALUES (291, '9lRpP9f_Q-kFFMMNk1NN1ViNvP-55n6i_1593934338', 'vWYFpkZmQ_JqhQUVmbO3TH-9fGmKTgh-_1593934338', 324, 'oWwx95UHX_6_RfDAalKobz7_G5Nk', '1', 1, 38, 1, 1593934338, 0);
INSERT INTO `dd_api_access_token` VALUES (292, 'AUAhXzSmSf_CBxbOcKW_VxOIOQGOap07_1593935306', 'LZmzw2uW6rxhY6aS7lN3mF3bwM-U4pLv_1593935306', 325, 'oWwx95Z8oN_Dn1led45nzJs0ljOs', '1', 1, 38, 1, 1593935306, 0);
INSERT INTO `dd_api_access_token` VALUES (293, 'rAr4nCcw5tcJ5NX7DwAtD_rq2qeolLCq_1594712209', '32Ch_Xev1GiI9--eEuUR4yoOxwhx5E-2_1594712209', 326, 'oWwx95Xe1AzQKcLX8NduJPU_2Yo0', '1', 1, 38, 1, 1594712209, 0);
INSERT INTO `dd_api_access_token` VALUES (294, 'GA62nA1SaUvYn2-zLRCly-HE0tealdaU_1593935485', 'C3b9Xpz7w6BVkneOJu5qGyhjSDDty4h__1593935485', 327, 'oWwx95TAptMKoMiz1kr_dOJSB58Y', '1', 1, 38, 1, 1593935485, 0);
INSERT INTO `dd_api_access_token` VALUES (295, 'zqIBbV7lsWCPaWh7SGqbxvJ0k6Gj-rWt_1593935979', 'qtab-pRl3g7B5SZb2n2zVlDzLotr9NpP_1593935979', 328, 'oWwx95erviPbq5Cgg08cQ5-1BZso', '1', 1, 38, 1, 1593935979, 0);
INSERT INTO `dd_api_access_token` VALUES (296, 'F_wV6onDozGmBf0WvrXzgn5xbawcLeK__1593935996', 'uZf6cnC8AwQoW7Rw7HcYE3x_QFJcttBF_1593935996', 329, 'oWwx95S8RYn9STEfqIRpMw4-XNlQ', '1', 1, 38, 1, 1593935996, 0);
INSERT INTO `dd_api_access_token` VALUES (297, 'DyFDFk2KVpb_-fbeSNCpKBhuiL35L1PH_1593935996', 'iDyputtvD9S0hF-bJDMRw2lP6W7n7t3m_1593935996', 330, 'oWwx95S8RYn9STEfqIRpMw4-XNlQ', '1', 1, 38, 1, 1593935996, 0);
INSERT INTO `dd_api_access_token` VALUES (298, 'MEQkvYgPDU3D7ydBUMpJKEnfxd_QziT8_1593935996', 'N_oLemq_Q2GzWSq2Y2H4BWwM12GpiZq__1593935996', 331, 'oWwx95S8RYn9STEfqIRpMw4-XNlQ', '1', 1, 38, 1, 1593935996, 0);
INSERT INTO `dd_api_access_token` VALUES (299, 'o1e2aAu1rDXkVbi64bEKH50Zt0fxb7jS_1593936479', 'ZsqL148zm6Dy6Kq7wu4uw3Y_GYbC6Bhy_1593936479', 332, 'oWwx95VgmRwMGPsqSTB_Eres_aLs', '1', 1, 38, 1, 1593936479, 0);
INSERT INTO `dd_api_access_token` VALUES (300, 'tyadabLEKWt9m6NvTTui9uxkqib5HJLp_1593936574', 'fu34_Mib5sIsZ-oInKz5VNgaN2uBlE5T_1593936574', 333, 'oWwx95VnJLU8jR6MfWA87H8a_uVU', '1', 1, 38, 1, 1593936574, 0);
INSERT INTO `dd_api_access_token` VALUES (301, 'LFBtCRr66aqf7fhCxq_VYvZ3XJwOUDiX_1594044337', '0bDl-NIeuT8DkbB9psoZX8c9JqbTsBPC_1594044337', 334, 'oWwx95SDR-TKMyF6EdedG8_2X29o', '1', 1, 38, 1, 1594044337, 0);
INSERT INTO `dd_api_access_token` VALUES (302, 'pejNRMnHZiiv3z_ZvgPlEu-I0dUqEMA__1594658878', 'QVIMBASA6yO_6-6PVTv0cDchoN7lrQ9a_1594658878', 335, 'oWwx95e7DZUKz1OgVHN7VI5Wkavw', '1', 1, 38, 1, 1594658878, 0);
INSERT INTO `dd_api_access_token` VALUES (303, 'uu8BJZQBXmRSOAEiWJ8ezHiFb2N3AGSM_1593937107', 'K6WK7velkQnwJntASqC0GQ4G_qFvgI1E_1593937107', 336, 'oWwx95eL2RIZ42Vp3uon1uavco00', '1', 1, 38, 1, 1593937107, 0);
INSERT INTO `dd_api_access_token` VALUES (304, 'tFrakwvBDnRTls6l06PtLKOUa8jmTreW_1593937154', 'rQoYH_L3QcgJeWVZ4kjxk2ZvH-Bu-oR__1593937154', 337, 'oWwx95UXW_1kXYh2YaYvVR3kp0qA', '1', 1, 38, 1, 1593937154, 0);
INSERT INTO `dd_api_access_token` VALUES (305, 'IwA-fDXiMj4i0rstR9RWCDvzBW5_pofy_1593937173', 'tb3BmaQ51_6hqR_e4IqEehOHuTrDlJm8_1593937173', 338, 'oWwx95RG2iNu5DLznhJWHKhehhrs', '1', 1, 38, 1, 1593937173, 0);
INSERT INTO `dd_api_access_token` VALUES (306, 'oEsOAEre-Oj4mSpHCgi6ZgS4nnHjPJQ7_1593937374', '9cbIzm8Cen2ZOhUc1WsEhXxzlNXL1mem_1593937374', 339, 'oWwx95QMl_LL8vsr8ZvX6Bbqg_DI', '1', 1, 38, 1, 1593937374, 0);
INSERT INTO `dd_api_access_token` VALUES (307, 'fdaagCqMRb0CKgCpJpnrgkjiQ3LC5QOB_1593938119', 'UWTEfeYAvEEYw5YzX8fhofa9vX6wqh_G_1593938119', 340, 'oWwx95aeliP3NPIKtngNx2yUDvDM', '1', 1, 38, 1, 1593938119, 0);
INSERT INTO `dd_api_access_token` VALUES (308, 'ygIv9xfpkEzWb_pMh-h7otZ26vdLlur__1594659808', 'oLj1cu2T8OYaJUnBdXERyu7Uz7eE7J8I_1594659808', 341, 'oWwx95fhSvGt1kVt0RZW7Geu589Q', '1', 1, 38, 1, 1594659808, 0);
INSERT INTO `dd_api_access_token` VALUES (309, 'rWF6p9i5bO6iptIJFFdM1C7lCvg4ZEQQ_1593938666', 'kASmAXVoy683iEheE7LYJTl-G8-Fpk5I_1593938666', 342, 'oWwx95UNAekkTp5PBYEkq0hn8UA0', '1', 1, 38, 1, 1593938666, 0);
INSERT INTO `dd_api_access_token` VALUES (310, 'D-h8hTZn61Adb07gYggYpQfUwUG1AHOn_1593939205', 'YDG7w1-heyZ9iIyvl7o12aaGRw1QHgoI_1593939205', 343, 'oWwx95Vhc4LBj2Dn9P73in01Cd9g', '1', 1, 38, 1, 1593939205, 0);
INSERT INTO `dd_api_access_token` VALUES (311, 'qwuigx3cIBJJrLjxWNuEbqj68KKauYHX_1593939261', 'PutWGAxGdYqmbwjAe4HwY53-rnjZkgif_1593939261', 344, 'oWwx95TSaVDJ6BPLcRwhebSkJpao', '1', 1, 38, 1, 1593939261, 0);
INSERT INTO `dd_api_access_token` VALUES (312, 'w-Zdsw4ihxAGVrosJT35EWkB2CDd2QaY_1593939670', 's-DccI7iRNDYBdNFBTGTc-sL8UFwuIiW_1593939670', 345, 'oWwx95bCwMp5P0jH-PVT_UvGbtCk', '1', 1, 38, 1, 1593939670, 0);
INSERT INTO `dd_api_access_token` VALUES (313, 'LJD0Id7at40BCNk5JtNFT0LKcV_77Jnh_1593940968', 'g56d-0GxLRMXI15_s4Wer78YLC4Bxb6y_1593940968', 346, 'oWwx95QTic1-xMVqhDaTMPlfU9_M', '1', 1, 38, 1, 1593940968, 0);
INSERT INTO `dd_api_access_token` VALUES (314, 'LZ36-0jjk4Dj6-xGMfLVHBw_7820KtBN_1593941281', 'e2Fp7T8ce5AV0G0c9aun4KP5aG237E85_1593941281', 347, 'oWwx95TL1NuzD3tms9tmtczgGaXI', '1', 1, 38, 1, 1593941281, 0);
INSERT INTO `dd_api_access_token` VALUES (315, '3gVek5EpmSjoyHQ4bqjfKixi5mMlsJOD_1593941923', 'c_AEGoJ-q3-989sUCWLBK73weUY0Jr6L_1593941923', 348, 'oWwx95cJlIktjcpewYxVcfYNjA3o', '1', 1, 38, 1, 1593941923, 0);
INSERT INTO `dd_api_access_token` VALUES (316, 'zMr6US5UA0nYSKvWkjbLJQ6Zw7wv6iZ0_1593941923', 'qVoRfz0zxuLqjqm5anfCVz666bDGjA4g_1593941923', 349, 'oWwx95cJlIktjcpewYxVcfYNjA3o', '1', 1, 38, 1, 1593941923, 0);
INSERT INTO `dd_api_access_token` VALUES (317, 'djQ1e_sJb_10xLXYEDPBBCDJZ8a9DA9W_1593942461', 'Sax67neokS-CdlmHf8klDQ5fErY8CPYQ_1593942461', 350, 'oWwx95Ze550ftQnYXt4oaeGbWePw', '1', 1, 38, 1, 1593942461, 0);
INSERT INTO `dd_api_access_token` VALUES (318, 'kqKYmlWw5SZS4_wi6gGwXkfoxV2t-j98_1593942903', 'EQurstFG_dMmipbQTbOeZY3YUZdIQe38_1593942903', 351, 'oWwx95dlDb6eZthHxVy3YLicZfVo', '1', 1, 38, 1, 1593942903, 0);
INSERT INTO `dd_api_access_token` VALUES (319, '01MYRZJa_LJkrPlRssWZ0JaJyHQaj79l_1593944855', '38F8TypUAVbmmTvls4RaHp5nz8rjP1B2_1593944855', 352, 'oWwx95cHvRegIhVYjr1KdZkmzENg', '1', 1, 38, 1, 1593944855, 0);
INSERT INTO `dd_api_access_token` VALUES (320, 'Zl-816Qtps2Iu5sUQ8I5yaVDRB8Sfuq5_1593946183', 'QCwAUgOlmXcN4Fie6ENMn3fATLXzR8Ov_1593946183', 353, 'oWwx95WdzAt-6WFe4N0cQmYu-hEk', '1', 1, 38, 1, 1593946183, 0);
INSERT INTO `dd_api_access_token` VALUES (321, 'Npoiy8EiDnEfT47NdkGwXgf9eBVDkkaY_1594023399', 'pH9E2wy9KU80PqEtWBaSBe0OMUDE_rT2_1594023399', 354, 'oWwx95auUAOxHSWQcSBblu-IgtX8', '1', 1, 38, 1, 1594023399, 0);
INSERT INTO `dd_api_access_token` VALUES (322, 'giiqgixYDEbduVQmeIfCTZwQn_h74rbE_1593947429', 'x1LPztxUp23eWtgo3h1ME-fdBbbgkmFO_1593947429', 355, 'oWwx95YSXsjOPTtz5Za25XoMLB4w', '1', 1, 38, 1, 1593947429, 0);
INSERT INTO `dd_api_access_token` VALUES (323, 'oQnLvIjZgkZ3kh6yXmOkaOYHzB9GOLoX_1593948021', 'MSssLOwZ2iFnzhqnIeaAjgdrSKzaG64e_1593948021', 356, 'oWwx95RDWZQ9s49KNvm2zq7RZVbE', '1', 1, 38, 1, 1593948021, 0);
INSERT INTO `dd_api_access_token` VALUES (324, 'gBhST1XkarEwrtp8_Q-8wJXDS4v3V06m_1593948173', 'jlJLg_m2QJX9zdehSkAWfEa23mJxnBcX_1593948173', 357, 'oWwx95ZLpAlnL9I9dOpm4i2SdEqY', '1', 1, 38, 1, 1593948173, 0);
INSERT INTO `dd_api_access_token` VALUES (325, 'abLMvDCYt4E5q7pKmxve8SxsIc0c6V8-_1594033876', 'c5ycpWCUgYNwuQNt4iLo0A49I9HwlTaL_1594033876', 358, 'oWwx95bObt-npid0s5wn1f8taLHU', '1', 1, 38, 1, 1594033875, 0);
INSERT INTO `dd_api_access_token` VALUES (326, 'y_hr_Jk5wFBFP-7ng_4gbi6e4B-K7ypT_1593949026', 'R3XEN6AdzT5O26d9X50uYufaJ2TRg902_1593949026', 359, 'oWwx95ZFmHEuuFJ06iCpLxgJzabU', '1', 1, 38, 1, 1593949026, 0);
INSERT INTO `dd_api_access_token` VALUES (327, 'mAFscnTbztcbC0Zfl6C_kV39kGvXEtmB_1593950189', '8IsjABE63aXbECdDg2rRK3kJ2Sz7JNYv_1593950189', 360, 'oWwx95WDk5UfFEc-2RIqjqF0VYYs', '1', 1, 38, 1, 1593950189, 0);
INSERT INTO `dd_api_access_token` VALUES (328, 'Dto0Cy2ASijaCXA9fdqY13h7285fAvlC_1593951118', 'x5i-6QD-YR5TGch_BhkLuKMU62BUDCOh_1593951118', 361, 'oWwx95QZU7mSzWW_PUpt8lnEny2Y', '1', 1, 38, 1, 1593951118, 0);
INSERT INTO `dd_api_access_token` VALUES (329, 'LYAtuZcEyS8_IwcyVfWwmb2MPtJpRjXq_1593951348', 'JVggPxNIn7rUKfYzxKki_5Iwb-26ieS9_1593951348', 362, 'oWwx95WCZuME8gu6PsvrMX2txSX0', '1', 1, 38, 1, 1593951348, 0);
INSERT INTO `dd_api_access_token` VALUES (330, 'W3lldfOpnzwVrOnV881ReS0FS4qwhBsu_1593951949', '5FfEKpm-5GdXIICw0GRYQ0ZT1DIxZd9o_1593951949', 363, 'oWwx95U_AKVpkAMxlxuK7nAFY6KM', '1', 1, 38, 1, 1593951949, 0);
INSERT INTO `dd_api_access_token` VALUES (331, 'wMnsrb7ikFZt4hfNq6aP2zNP-Ac5Gkfk_1593953513', '2k2wII1qCiUlCn1eZt01g8n6FX1IP1yt_1593953513', 364, 'oWwx95WUGKUod0p1SzmqGA60t86Y', '1', 1, 38, 1, 1593953513, 0);
INSERT INTO `dd_api_access_token` VALUES (332, '0jx1iROahP_XmPYciZdw5_PoMCyef1iR_1593955230', 'NdJ8fUvT7sw8gg2XcQDVMG0kwE7jimq8_1593955230', 365, 'oWwx95QkFpQamegonOCTAO2syqJY', '1', 1, 38, 1, 1593955230, 0);
INSERT INTO `dd_api_access_token` VALUES (333, 'cagCnxQL1FK1GOZyOkIc47SRN14_FaD7_1593995557', 'FLOuNWG_jvZijEDxg8jzPn2Xher7nkRO_1593995557', 366, 'oWwx95f3LeXys-qlKawzv7dnAOIE', '1', 1, 38, 1, 1593995557, 0);
INSERT INTO `dd_api_access_token` VALUES (334, 'I_McFBedSfcWPZZ4jl4vNOSBs2pEm3Ws_1594011572', 'eHykkpHXqaEuRLR4GOrA8sTs41_t0z7L_1594011572', 367, 'oWwx95W9ZwVUtjrZmFpAfkJVyMbg', '1', 1, 38, 1, 1594011572, 0);
INSERT INTO `dd_api_access_token` VALUES (335, 'O08EU0xaj7RGW6Nd9qzCMm_fP3qN0s-P_1593958310', 'ydfVrxFEvDEyAe6WTeciOQ2mMlZT55Uj_1593958310', 368, 'oWwx95cdG4v1bqwppYKM5SmbBOHg', '1', 1, 38, 1, 1593958310, 0);
INSERT INTO `dd_api_access_token` VALUES (336, 'VZKFXxek9gTL4DqGnJ--w2E2qZlf6xSo_1593959460', 'OBcvQlp76kw5hVdoekdBCeIU0lz0s4mq_1593959460', 369, 'oWwx95RUI27Xs76VKxK55hCIaMbo', '1', 1, 38, 1, 1593959460, 0);
INSERT INTO `dd_api_access_token` VALUES (337, '01ypG9NHRWpt4eQLOG19uWYEpSReOf27_1594128567', 'HG0Q0atKz5BLxQrE3yhJlU5h4ZDbqnQm_1594128567', 370, 'oWwx95Ssm2NwgNbt5c6G4USSCams', '1', 1, 38, 1, 1594128567, 0);
INSERT INTO `dd_api_access_token` VALUES (338, 'wueVvZowuMKCcp_cqEqW-m1JkbwQIH-t_1593963299', 'OHDqrOykODMoqs4sPfDX-PckBt1DB0V__1593963299', 371, 'oWwx95dvgkq8hwLjLS-D-VhRr4Xk', '1', 1, 38, 1, 1593963299, 0);
INSERT INTO `dd_api_access_token` VALUES (339, 'ruhEozpiNiLpNpUwXAyKR5qIwKwsU1vu_1593965015', 'sKGxgyNhDROjJlK7SrH2JlbMlpw83y7t_1593965015', 372, 'oWwx95YsurWIHz21WIVzmEFRJ7mw', '1', 1, 38, 1, 1593965015, 0);
INSERT INTO `dd_api_access_token` VALUES (340, 'DtzL4HbEDoY3h4JjzuKZH1hiPN7K776K_1593965774', 'YvqWtamGph01hLhnvLuIcIYElKd4pcP3_1593965774', 373, 'oWwx95c5JvkpEho9KE7uaxSKd7i8', '1', 1, 38, 1, 1593965774, 0);
INSERT INTO `dd_api_access_token` VALUES (341, '9TftI8QIlvbdTZN11cOMzcdnGf-jhdQh_1593968877', '1i-N4ldScIK4PGN-5oG1Savn-MHk6GFF_1593968877', 374, 'oWwx95WtvwNu3C1PYYqizFf51k7M', '1', 1, 38, 1, 1593968877, 0);
INSERT INTO `dd_api_access_token` VALUES (342, 'sPPlLf393kIdkAu_lWlDo6HInwfc7p_0_1595191279', '8pIXpFiXtLRBrr70ZwusPqLc4PNJRYaE_1595191279', 375, 'oWwx95TA-GqTIoKLZEW3263wzB1g', '1', 1, 38, 1, 1595191279, 0);
INSERT INTO `dd_api_access_token` VALUES (343, 'Lvbb4jK9KOtKxWAQ4nDucv2NCYyAs6Yp_1594470487', 'Ll96IJbXUNQXjOI4y8GJYcAWryW9nV0o_1594470487', 376, 'oWwx95U4xREYBja2MoWMaQJJd7e4', '1', 1, 38, 1, 1594470487, 0);
INSERT INTO `dd_api_access_token` VALUES (344, '960B2MkCIPX2Xt-ihId8jiNo0s7FBrbD_1593995234', 'zpaFUVX0h_T_FRVtxxVlpzA8Js1Szcc__1593995234', 377, 'oWwx95Y9nWkj9N24PsYGv4gnciO4', '1', 1, 38, 1, 1593995234, 0);
INSERT INTO `dd_api_access_token` VALUES (345, 'p33aLpt0ATgvIydIf_c4126MzRQrK4fv_1593998510', 'yGJ9tdo_yaYsqKSyAESnJi-3Ewu24Joe_1593998510', 378, 'oWwx95fic3zWjQFOIitNiVTYbG3c', '1', 1, 38, 1, 1593998510, 0);
INSERT INTO `dd_api_access_token` VALUES (346, 'cy1qT9VV31m67l51HgoLMWu4jZFuszr2_1593999757', 'dEbK1h0jiUaQ8XzVv0oXCMqJofVF92QQ_1593999757', 379, 'oWwx95UUus8qk3qkuwa_tsE78waI', '1', 1, 38, 1, 1593999757, 0);
INSERT INTO `dd_api_access_token` VALUES (347, 'M_u49EE14nmVaSWH7GUdaDHT-feFofy8_1593999758', 'oHBFTGSfdLiv3qjgeSovqQdUs2kWM9rb_1593999758', 380, 'oWwx95UUus8qk3qkuwa_tsE78waI', '1', 1, 38, 1, 1593999758, 0);
INSERT INTO `dd_api_access_token` VALUES (348, 'IscInAl4tDqfvS7JGofX_T-j-W1Hsr-J_1593999758', 'darGkhvDqHt9AEskkBxVIhmv-TinOrsw_1593999758', 381, 'oWwx95UUus8qk3qkuwa_tsE78waI', '1', 1, 38, 1, 1593999758, 0);
INSERT INTO `dd_api_access_token` VALUES (349, 'ODFQJHtkZq4iBevjqCm5k9GY5IWtTX6P_1594001811', '5ommI4r24NJO289V1f3c4JQNKeHSVQlT_1594001811', 382, 'oWwx95cxQYVB0dprWMGBU4mgXRWg', '1', 1, 38, 1, 1594001811, 0);
INSERT INTO `dd_api_access_token` VALUES (350, 'ZPWSw3B2i39Q7keJ144wB5oaOGOEJrfK_1594012216', 'vKBAj8cRNs7cIRowcA8EyWJ36GohdJpQ_1594012216', 383, 'oWwx95Q6KNe5-kftnSmG3c50laj4', '1', 1, 38, 1, 1594012216, 0);
INSERT INTO `dd_api_access_token` VALUES (351, '7_MvTrmM1tErwq3GyZnsRODYaVxTTsx1_1594014039', 'rc-pzRFpwJNFtzrSFx1OfOu_9QjgTEgX_1594014039', 384, 'oWwx95UzYjpI6io899o07X_atN14', '1', 1, 38, 1, 1594014039, 0);
INSERT INTO `dd_api_access_token` VALUES (352, '8U3QXIYbhiI1QS4RqM6mjzAGLa5zjAla_1594014144', 'e8uiu5QuWyzJZmYdOJh_jwA5e5zlmVou_1594014144', 385, 'oWwx95ZipwkKuYFsIE-3rYRkbDkM', '1', 1, 38, 1, 1594014144, 0);
INSERT INTO `dd_api_access_token` VALUES (353, 'Fj9WdHXm4YFvwDClZDuv_trNan74pOXP_1594034037', '0ICHyGow2xx6oZh9fWMK5AB__KahbHqt_1594034037', 386, 'oWwx95fjylE8RPFt4AXmMs5MZOo4', '1', 1, 38, 1, 1594034037, 0);
INSERT INTO `dd_api_access_token` VALUES (354, 'Fw2ft3AISud7JIfDiK4YiIfaz6-5dbgG_1594036072', 'RGOzIO3tqKzH9gAXgYFD171Oz8yTuneY_1594036072', 387, 'oWwx95QSEu23shUFlOFC7iFgm_bE', '1', 1, 38, 1, 1594036072, 0);
INSERT INTO `dd_api_access_token` VALUES (355, 'p-kUhORE1_r0Sb6BAewATP40O_AKV_H0_1594037538', '4PMehgqK0hl2x6koItQAjadn0l4bSwsR_1594037538', 388, 'oWwx95Qjbq6XwMUShKkLGhZAopqc', '1', 1, 38, 1, 1594037538, 0);
INSERT INTO `dd_api_access_token` VALUES (356, 'GNcZAhcXBp8GzWwEVlk7AdtiRIrfkKc__1594037539', '6PHf-YNqPZ-8YuVpXgXN_HwUBfsYPa_m_1594037539', 389, 'oWwx95Qjbq6XwMUShKkLGhZAopqc', '1', 1, 38, 1, 1594037539, 0);
INSERT INTO `dd_api_access_token` VALUES (357, 'aRuLVutLuCu4UVX1aszTIj3igfNbo5QS_1594038811', 'cuaEzVaXDIaYwwC7q69bAKmvv1sBKHmb_1594038811', 390, 'oWwx95WtxbV-uQRmsagCFJ1ouzek', '1', 1, 38, 1, 1594038811, 0);
INSERT INTO `dd_api_access_token` VALUES (358, 'A_74OjB_Daah_YjkShcBo760TyW78Won_1594050462', 'P4WJ20XZvmoGcR5rqZJPRDhHCmXHpmJM_1594050462', 391, 'oWwx95WM8urOg9SF3qcdzuT5_4b0', '1', 1, 38, 1, 1594050462, 0);
INSERT INTO `dd_api_access_token` VALUES (359, '-jxhDl1y60SUz44P2TTgnHUvJHnFGbqF_1594052341', 'b3dygbjtnSm2Inoi6rRfx9uelXHq6yAD_1594052341', 392, 'oWwx95dIs-iLQ4bu48345OaORxvs', '1', 1, 38, 1, 1594052341, 0);
INSERT INTO `dd_api_access_token` VALUES (360, 'B56xD2s0FSByZyFALmhr-8XE6U4YiPNA_1594096394', 'd5gnbCQuq5XZDGuJWDSP7W1SNFk4E_nI_1594096394', 393, 'oWwx95b7o4ZptmEoIDbTLHLGffHk', '1', 1, 38, 1, 1594096394, 0);
INSERT INTO `dd_api_access_token` VALUES (361, 'AIpU_phUojnzO6k7vQ-QbGR4f2K_Ewst_1594090533', 'HcrStpq0QTyG2P5X1yOvdEV7ZZMch-_z_1594090533', 394, 'oWwx95aU4eNDRrGd7kCmpWfuVB04', '1', 1, 38, 1, 1594090533, 0);
INSERT INTO `dd_api_access_token` VALUES (362, 'puLIcjukF4j_kr7iLbLb94BrvE9oNhuG_1594097732', 'i9_tstn_TrBaDpXP19qJryhOEm7qb4MB_1594097732', 395, 'oWwx95Q3-BCBWnqFAb88VPY-9QHc', '1', 1, 38, 1, 1594097732, 0);
INSERT INTO `dd_api_access_token` VALUES (363, 'gk_8kIcibfVtLsa_do1T7gRryZ3RTrpG_1594284674', 'AcIKUGkUXB9IHzoTji66UDbPGjjMhnnO_1594284674', 396, 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '1', 4, 43, 1, 1594284674, 0);
INSERT INTO `dd_api_access_token` VALUES (364, 'VxcuBIujiYZYOQQ_7uGeLY0JqKSzOoav_1594111786', 'pmsYzDOfRgySTKl9n-GGr3sAYWJOmtGv_1594111786', 397, 'oWwx95TjI2Rfp_NItHO6no7UDCzo', '1', 1, 38, 1, 1594111786, 0);
INSERT INTO `dd_api_access_token` VALUES (365, 'iQRrlSMln1GLE9NDeuHKmUCnznpx7urH_1594659206', 'aijnILGCiX6l2c9D6I_4nBlzM8lEXiZi_1594659206', 398, 'oWwx95a_4X8wrhNVSCZg4JU9G1nQ', '1', 1, 38, 1, 1594659206, 0);
INSERT INTO `dd_api_access_token` VALUES (366, 'otF23FykLjrD8k_W238qHGRvVw0EpVUR_1594132699', 'H14i5pUkavMZN8HCdJyKHqordcNhsxze_1594132699', 399, 'oWwx95eYknZ1ekcNTUZsV4tTFobQ', '1', 1, 38, 1, 1594132699, 0);
INSERT INTO `dd_api_access_token` VALUES (367, 'PAtayGqvpYDdR6vBrvzT0CityYwwOVC5_1594658347', 'WHqEcSicPO2UU3GZcSXWntWpO55AW6Qo_1594658347', 400, 'oWwx95d7D4Qwt9YdS7b-68Pn4RjI', '1', 1, 38, 1, 1594658347, 0);
INSERT INTO `dd_api_access_token` VALUES (368, '-DMHcY7wgPonNHj_oOGY_Rj0YvRQbkuS_1594189196', 'svwwyWiUt12JF4Q8Wuj4_hcUAN-jlnoM_1594189196', 401, 'oWwx95dnuI6zmPbTMcr1epZDBxqo', '1', 1, 38, 1, 1594189196, 0);
INSERT INTO `dd_api_access_token` VALUES (369, 'ZsLEIx9fGKT_wjptQdpz9CFa_Jh0dAp3_1594207181', 'U0mVT_p2lB74lZWraDytPx0ucg9b14ON_1594207181', 402, 'oWwx95TaY36SODogDD18xnWEcMLQ', '1', 1, 38, 1, 1594207181, 0);
INSERT INTO `dd_api_access_token` VALUES (370, 'aYjSolf_z_IAR1gGG9j88Kzd9bf1M8Ke_1594658718', '5UdEnynYDTd39y5D6oYfRBxZ7-dTfV1B_1594658718', 403, 'oWwx95RfQzygbFELN2wHaKgg321U', '1', 1, 38, 1, 1594658718, 0);
INSERT INTO `dd_api_access_token` VALUES (371, 'wfdd7blr_y_y1Jc5Btw5DD1T65hIQXCs_1594709847', 'WXG8_N2zBdzQ-RhHYYtv3kZEDC4hvbQy_1594709847', 404, 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '1', 4, 43, 1, 1594709847, 0);
INSERT INTO `dd_api_access_token` VALUES (372, 'YGPA37ig8Gk9Mxio1j32lVvjAe4Fqd2d_1594295254', 'qCT9N7xAYp_a_DVnlZM6ySZbhE7DILNM_1594295254', 405, 'oWwx95eUAUa9n_OYTV97vIwdpjD4', '1', 1, 38, 1, 1594295254, 0);
INSERT INTO `dd_api_access_token` VALUES (373, 'Hz1tyYHSK_bqvrh3muAjzfTCWkXkkCx2_1594316076', 'oHNvlOCGSXb_wdK_Sg7P-sVBjZnDkYOm_1594316076', 406, 'oWwx95ZcxrZPTsRASuphO2Sg1ncM', '1', 1, 38, 1, 1594316076, 0);
INSERT INTO `dd_api_access_token` VALUES (374, 'X3jDAsQFM0g9Xr8bhSHNSJnRhjN3kBe2_1594317592', 'DiUNmL6ObckIkl6-9ohgiFlp1i7dw36Y_1594317592', 407, 'oWwx95YrvOe-U98Juf-AwnCURw6w', '1', 1, 38, 1, 1594317592, 0);
INSERT INTO `dd_api_access_token` VALUES (375, 'y0ndpiBfjnDiF4WQHNYMAdUm32QVKznQ_1594336058', '256xBvIkVtHT9RoFvscgi0xxmoFG0YHe_1594336058', 408, 'oWwx95YwkRM8M90Mi2SXqJg-9Qy8', '1', 1, 38, 1, 1594336058, 0);
INSERT INTO `dd_api_access_token` VALUES (376, 'WnOoFSIjlZC3qOhpRCDAZRf0YFnjTcUL_1594348791', 'nhcPdr34Cu-4_EKK0_vqLCV20bs-WhzL_1594348791', 409, 'oWwx95ShTiiTK2pGmxKmqfgE7gSs', '1', 1, 38, 1, 1594348791, 0);
INSERT INTO `dd_api_access_token` VALUES (377, 'x-SOIZrNKd8t_Q2Q4XLjfJjLAE8Ak46K_1594360974', 'UIaEGSXphWRezwxi57QfSJLXBDyIclxS_1594360974', 410, 'oWwx95aMMCaJQK1tD6pD9LKKOEww', '1', 1, 38, 1, 1594360974, 0);
INSERT INTO `dd_api_access_token` VALUES (378, 'ZM-_qo66MZqxUqz5QfJLIE06Bgv00RWk_1594367609', 'MeMeS80202G-MPbmDx-HLn-vXiGfcHrN_1594367609', 411, 'oWwx95dKs2XO1lyadTdnJdDjZ2GY', '1', 1, 38, 1, 1594367609, 0);
INSERT INTO `dd_api_access_token` VALUES (379, 'xPuyNBGpNg4ptk7M7yDaE3nTFYfZQsU4_1594425841', 'IEv_xxzKDXJdjgYLtdwy1DnPmFCuse2z_1594425841', 412, 'oWwx95UkFtJfShCXlHLH5Ilp4SNQ', '1', 1, 38, 1, 1594425841, 0);
INSERT INTO `dd_api_access_token` VALUES (380, 'fo3Ufco0i65x4vTF2KYQ0yYgP1Mgqt_a_1594529866', 'nQcY6wC0d9TONa8HXDCWZ3mVmLh5iQO5_1594529866', 413, 'oWwx95RYWnfhDKnnATajUAqahEus', '1', 1, 38, 1, 1594529866, 0);
INSERT INTO `dd_api_access_token` VALUES (381, 'JEjn-b-wcCAvM4eq7JEf4hiwu6LWlSCJ_1594531638', 'Gk2XdKWpfQfivRH4AsRFuY_POzqsdTbf_1594531638', 414, 'oWwx95YjNG3q6ZRiwCK1dQqWQwj4', '1', 1, 38, 1, 1594531638, 0);
INSERT INTO `dd_api_access_token` VALUES (382, 'l8Do0j6If3-ZCQ8gDPyriuu5Kl6zS2qh_1594570452', 'I662ycxzfHjx5_uD-fRrKjDESwsjIVEn_1594570452', 415, 'oWwx95dAWUrOdf8wjKUazkIvghlM', '1', 1, 38, 1, 1594570452, 0);
INSERT INTO `dd_api_access_token` VALUES (383, '98BAqMDfETqTlv0frG2ysz9iKtabgLEo_1594535812', 'mZwCakuwPD_D0bZds0zsIcR2mlbCf7_T_1594535812', 416, 'oWwx95fwp9pIX0Bxy9NFMlqstvFE', '1', 1, 38, 1, 1594535812, 0);
INSERT INTO `dd_api_access_token` VALUES (384, 'BFpk_crEgRH5qAP2weVCmqfVrQiyolXZ_1594555080', 'fyvQmvyDlatItbQM9y_wrfKLZw5eqwKY_1594555080', 417, 'oO3nO4nDS9kD25TJCvOoSrRAnu3w', '1', 4, 43, 1, 1594555080, 0);
INSERT INTO `dd_api_access_token` VALUES (385, '_0vv_zdbxp7tAnCnk4kS4mAT4rJRxG-V_1594562369', '2uIj77x9m4emJv90xCFtsKCq4OZViiMv_1594562369', 418, 'oO3nO4tIc_cM6TRVICrxDJ8yRpTE', '1', 4, 43, 1, 1594562369, 0);
INSERT INTO `dd_api_access_token` VALUES (386, 'bTWfMP8lmI-FxdAZMGw_MVgTW_BTyuu-_1594569810', 'Tyd_1QPnNy0lun6KAorCxGnHaQCqTHp9_1594569810', 419, 'oWwx95RCtD9RJbVYjDG3dU3oUKLg', '1', 1, 38, 1, 1594569810, 0);
INSERT INTO `dd_api_access_token` VALUES (387, 'F5_m05ahYmd8JVwjz-uBfPfoylVF-NhA_1594587920', 'G0sOtR1xoGO31SqGKAZDCYcnNFcPEQiD_1594587920', 420, 'oWwx95auD2ce4OKGCmpy_o01HAi8', '1', 1, 38, 1, 1594587920, 0);
INSERT INTO `dd_api_access_token` VALUES (388, 'tjzqyu23HHBsruVgs8cM0l-FoJZZQANV_1594600344', 'UtNBXDDCdns2KEHC0ER2r8OaEuQlCF_C_1594600344', 421, 'oO3nO4gD2sEB7rBkuOQml-g7OuJg', '1', 4, 43, 1, 1594600344, 0);
INSERT INTO `dd_api_access_token` VALUES (389, 'wpG5vV0YNN_pYXzVAUI6f7OxdbSQiMhP_1594600522', 'OQ5xvmMrF0Bf4_Mma6WSB26Q3DNbBEmU_1594600522', 422, 'oO3nO4jxLp0F_uUZuw0K4QTolDTs', '1', 4, 43, 1, 1594600522, 0);
INSERT INTO `dd_api_access_token` VALUES (390, 'PI1Op1ymXdEpEkNJdgLGzz0aa6rzztH8_1595070730', '9_pxH_0_CFGKTLXyW_LKlDU94pUtyvC0_1595070730', 423, 'oO3nO4lv6mLpT3o2pfmZwPtVjdZE', '1', 4, 43, 1, 1595070730, 0);
INSERT INTO `dd_api_access_token` VALUES (391, 'O4l-9uZIjgNEl4ACx0FPCR732awhlgGa_1594603718', 'tolZf4qEAGj3Tg5yhfPaVjcDubhYgYLx_1594603718', 424, 'oO3nO4hltqpP4l1SS84D6t6mkDYI', '1', 4, 43, 1, 1594603718, 0);
INSERT INTO `dd_api_access_token` VALUES (392, 'fwaBPYdoFvwCR84lpFy1xOclaznce-Qt_1594604667', 'BTFSum1U0LLi8tDHSQNVEBv_XLtyT5Kj_1594604667', 425, 'oO3nO4tFIBkmMTqrRwOy7KGGwzGw', '1', 4, 43, 1, 1594604667, 0);
INSERT INTO `dd_api_access_token` VALUES (393, 'gpmy9YEIFLY13FP8zC6UKUTu-VzgkIZn_1594641013', 'wxjR6ifjCeX-7MNYl2RRyDq0JCeLvNOm_1594641013', 426, 'oO3nO4s8AdIm6O_995RjExmEEUXA', '1', 4, 43, 1, 1594641013, 0);
INSERT INTO `dd_api_access_token` VALUES (394, 't-puldpVzadWCKOVp_T7FGvmCMstNMYZ_1594642223', 'e2cUD7qNYv5AVmfNR_Ez0P6U-4dH_13d_1594642223', 427, 'oWwx95UMFlQbQ6BezzNHce47--Cc', '1', 1, 38, 1, 1594642223, 0);
INSERT INTO `dd_api_access_token` VALUES (395, 'MxZ7H9hIZhz8G5cWBHvctNwUUQsuhzFv_1595139134', 'aYRSqf0sxU_rLIlUfBQB6ONa36DPDX13_1595139134', 428, 'oWwx95R8nBnklnJOD40dtbgf3m6A', '1', 1, 38, 1, 1595139134, 0);
INSERT INTO `dd_api_access_token` VALUES (396, 'kgANXVDo7H52U3TkSW8MxLLwJ2mvwEkw_1594657856', 'n-FBGAr7DBzMoG3FpWoSp0WQ1jh7UQWA_1594657856', 429, 'oWwx95c2k7mxyn6kqdEa2WN6pk_k', '1', 1, 38, 1, 1594657856, 0);
INSERT INTO `dd_api_access_token` VALUES (397, 'UciRIpRQ10n-o283Od7NESCNZ4bWgNJL_1594657876', 'X6kGhYRySauCOAhljLHuLsOifVF_kMq9_1594657876', 430, 'oWwx95aYrCkR6ZPvKRMiaIILC3AI', '1', 1, 38, 1, 1594657876, 0);
INSERT INTO `dd_api_access_token` VALUES (398, 'H9h-Azgm1J5q49_ZDyyTyW-NeB1zKhUq_1595134300', 'NQN-ZYe60Xl7dV5eAPdlVN7A8HqqiEZX_1595134300', 431, 'oWwx95cCY3RxC0G69Tc0gffp4Hqw', '1', 1, 38, 1, 1595134300, 0);
INSERT INTO `dd_api_access_token` VALUES (399, 'Tn0pDju_G64Cq5pK5qWof2GMsDYY7AI8_1594658299', 'AONpqRUNwXlFjx_WxFS3hZ6r8oaWKjNq_1594658299', 432, 'oWwx95fd39s4U4c3yXlyEAKoEyVU', '1', 1, 38, 1, 1594658299, 0);
INSERT INTO `dd_api_access_token` VALUES (400, 'vC5mOqm0GLC1t7CbjQWS1XpImbXqQfu7_1594658398', '7wM54mGqglwBRhjZsx9oXGihSed3E1gt_1594658398', 433, 'oWwx95YL3rW9WaxU-Hu6cE-JKALg', '1', 1, 38, 1, 1594658398, 0);
INSERT INTO `dd_api_access_token` VALUES (401, 'sO5dD9Ek5OpBMOI-671BMSB2w8S39hF1_1595136833', 'mb6PsMiPG21yTv4y6mv88cYe_c3lUhNM_1595136833', 434, 'oWwx95VnoUaI2XT1H910fMYj0ksg', '1', 1, 38, 1, 1595136833, 0);
INSERT INTO `dd_api_access_token` VALUES (402, 'r3T653Z1M6xnqJfgSf_mtFjEAjL_0rD7_1594658761', 'ME4vc8hDB-upP0lUXtJ_zgtbiTu98K0a_1594658761', 435, 'oWwx95duRGq0VjV2k3J8dpFa63Zo', '1', 1, 38, 1, 1594658761, 0);
INSERT INTO `dd_api_access_token` VALUES (403, '0N_E-GYsLK5WT45srw_HceEgCb8nuoeK_1594658868', 'pr7JPlmV6gst_EWnFwLKpDhGyLm8nAWX_1594658868', 436, 'oWwx95ZHpeX2OoLs1S5nU8O1fjzo', '1', 1, 38, 1, 1594658868, 0);
INSERT INTO `dd_api_access_token` VALUES (404, 'NwTD0AJIuj6nyw3K9HkOfApLlfuudIxu_1594659038', '5T7VFwIfD5cIibOw7zodgGRnn0_qcP-f_1594659038', 437, 'oWwx95XwZ5-HeDTCX69vFed1x3Rg', '1', 1, 38, 1, 1594659038, 0);
INSERT INTO `dd_api_access_token` VALUES (405, 'eWe62lB2nsoTRtONXrwt0WIm9p4JWdhV_1594660290', '9aDH5WBLtrlUrGoWITIoaihbxVBxdw9h_1594660290', 438, 'oWwx95VOZqlijJz86LHK11EEpfbY', '1', 1, 38, 1, 1594660290, 0);
INSERT INTO `dd_api_access_token` VALUES (406, 'p-PCrhRpleFiudig00KvPzZMRWZ7WpTG_1594661190', 'q17BAuH4gfJD5AOIFQOJcMJkPfeB03UW_1594661190', 439, 'oWwx95SJBu43k_4v0gjiI43UgzwY', '1', 1, 38, 1, 1594661190, 0);
INSERT INTO `dd_api_access_token` VALUES (407, 'dj7MGRREM2FZ9YrKVKvEnoKhfugGozGp_1594662904', 'AqLHQp1CYQ8-CqETizSQ_W3-reDVN2gB_1594662904', 440, 'oWwx95ZE4Nog8oRkc8Pi98bogPdM', '1', 1, 38, 1, 1594662904, 0);
INSERT INTO `dd_api_access_token` VALUES (408, 'z0Eio-pa-TQDaYAJ11KwYI5gAtwBFgpI_1594683282', 'K6Qg6F040OU6ndGgCVJs_1p9XS6yO1OM_1594683282', 441, 'oWwx95YtDFuWfXRKmbA3Ihgs7mFk', '1', 1, 38, 1, 1594683282, 0);
INSERT INTO `dd_api_access_token` VALUES (409, 'J3W9MxNOEvh3b6HGUvbkhhx8q1ZyrIsh_1594713189', 'zFdb3arEKlSHrp94oCemLBC2E1YgsQNX_1594713189', 442, 'oWwx95btuLBzVgeIYyyaFdqfGL_I', '1', 1, 38, 1, 1594713189, 0);
INSERT INTO `dd_api_access_token` VALUES (410, 'g1q1wJXKpqPKqvw0Mqqxr_G2kLz582p__1594728057', '-E5vB_pnp2WQrRdErE7v1fzJUiwwAbQS_1594728057', 443, 'oO3nO4rICl0Cyle_iuJIatpxj0k0', '1', 4, 43, 1, 1594728057, 0);
INSERT INTO `dd_api_access_token` VALUES (411, 'bPA6o2fptYuTBx9tShID13rjzRL1dkpQ_1594887366', 'yJGZMVN0Vw_uRPkBCb_aLiqVw5jfI49M_1594887366', 444, 'oWwx95ZyJc8y040oTLEbe8oL1Si0', '1', 1, 38, 1, 1594887366, 0);
INSERT INTO `dd_api_access_token` VALUES (412, '28RLJqfi546J76fPxcviJ5GrR5yZhTSU_1595227637', 'vASCx8eW-BHhy1Gd91pk48gUZBBQtyKh_1595227637', 445, 'oWwx95SASwtnSLAKfOMLBtyGeqB0', '1', 1, 38, 1, 1595227637, 0);
INSERT INTO `dd_api_access_token` VALUES (413, 'p__vw8kaXyq0qu6NAULt4HtjPH-hdhm6_1595134244', '20gPG-bDtanAJo_UZlleZVKT_ory8BLs_1595134244', 446, 'oWwx95T1kiE6B1qqm8CtDXLWa5xE', '1', 1, 38, 1, 1595134244, 0);
INSERT INTO `dd_api_access_token` VALUES (414, '7qjQeftgskhcNe0XQpdMR3Y4tF_ul_cw_1595134247', 'EKLukp9BEqUm4hZ8MPE-jaboJwXHFSoT_1595134247', 447, 'oWwx95WsSyoVoWGuRTC7JjoFS9Bo', '1', 1, 38, 1, 1595134247, 0);
INSERT INTO `dd_api_access_token` VALUES (415, '7FEX6Du0LbFjnyN87rSw-zg_WCKD1X0-_1595134253', 'PEGy0x9O4ykx6iyyDq5ne6xmAqMaTi9d_1595134253', 448, 'oWwx95YNUf-w7-1VjrZOYU5PlMwU', '1', 1, 38, 1, 1595134253, 0);
INSERT INTO `dd_api_access_token` VALUES (416, '7Hv6QX-ozYeWat5ro8zyPMDNb2HnFFX0_1595134283', 'fjGmhv9r3GJI9kC6OX-HpeE6tJxeGFmJ_1595134283', 449, 'oWwx95bgrQF4G1zgA2iNH-eyePEY', '1', 1, 38, 1, 1595134283, 0);
INSERT INTO `dd_api_access_token` VALUES (417, 'oHEfSPWYuz-mDabmqXTkdn1eI2KbPBkm_1595134292', 'f2SBApaQjUnvrldnw-Cpxn81Ydi2DAWM_1595134292', 450, 'oWwx95WSgqlCu2qCFjCo11vRaQYs', '1', 1, 38, 1, 1595134292, 0);
INSERT INTO `dd_api_access_token` VALUES (418, 'ar1LJiNzRKK-EZEf_Mrt6cH6R0Lxgp3v_1595134328', 'HMkMuV1uiqGSuZeXh0GDrANgId97zu2X_1595134328', 451, 'oWwx95WvQ_Xwd7RwAagXlcSjreyU', '1', 1, 38, 1, 1595134328, 0);
INSERT INTO `dd_api_access_token` VALUES (419, 'ECyNqLPnXHJ0in32vkUJSMWXaPsTITi2_1595134427', 'ExJGWyE1EIIsRqJvdHc-UWBvqFZL1bEl_1595134427', 452, 'oWwx95ZFVysQ4Olo9PuBYqTnN4aQ', '1', 1, 38, 1, 1595134427, 0);
INSERT INTO `dd_api_access_token` VALUES (420, 'NNcCrB2dTKb13TQIa24TGDTJzeZrDB5r_1595134498', 'mMSrNKaiPH4Bq6eHx8YAIDRQ63f-RSRY_1595134498', 453, 'oWwx95bdceyfdnPvRGJDewQQcIqI', '1', 1, 38, 1, 1595134498, 0);
INSERT INTO `dd_api_access_token` VALUES (421, '9mrq5jhyCcrULlJmj4jp9tz0zEQe_-kD_1595134507', 'ennbbplAqv7rDVmh3Txwj0mHmk4qy4w3_1595134507', 454, 'oWwx95YUymlSTdQGTg8NvZw8mHjM', '1', 1, 38, 1, 1595134507, 0);
INSERT INTO `dd_api_access_token` VALUES (422, 'puriRtwHaw1PBnOtdi1mLjYIY9-DdXCw_1595134821', '1E94hxDN8eQAOKqx2Uyu2h0hNBGer9b4_1595134821', 455, 'oWwx95d0Hd0EFVPi5lseRR0pdrgI', '1', 1, 38, 1, 1595134821, 0);
INSERT INTO `dd_api_access_token` VALUES (423, 'yTOmpLXMdXRX8_8PJxQmGhvDYQfdw6Rp_1595135227', 'UWNKyAgOKbHrfXIRiFL08g-Z3ROvnF1S_1595135227', 456, 'oWwx95cEkjzea329yDC0j--fjgME', '1', 1, 38, 1, 1595135227, 0);
INSERT INTO `dd_api_access_token` VALUES (424, 'oN7n7rkO580GPIKSzgvKMv4Dwvnm4AnB_1595158922', 'x04MR7lJJ1hLKfTIdcrOMRRsVShgWZ8U_1595158922', 457, 'oWwx95ejujk33sLwKFmH1V-HamYE', '1', 1, 38, 1, 1595158922, 0);
INSERT INTO `dd_api_access_token` VALUES (425, 'VrrC9n6bu1wyAvZuEKPGt7eP1oTV5pMs_1595135755', 'kXF61GogtaATeQWd7LZMNenJgwrc2Whk_1595135755', 458, 'oWwx95cTD3oHPwWqV6gUogCuG2Wk', '1', 1, 38, 1, 1595135755, 0);
INSERT INTO `dd_api_access_token` VALUES (426, 'R7P5kfDMTyJoCEzW0ICPcu_gEVhtY0ld_1595227475', '0z344TwRINLCxwfKnrfZk_k_h40SK8MR_1595227475', 459, 'oWwx95TawshiF6EH3tkcfOilPhRg', '1', 1, 38, 1, 1595227475, 0);
INSERT INTO `dd_api_access_token` VALUES (427, 'nbWagwWGApNC2GLq9sBztd56UnBPnYeJ_1595136084', 'mX0FB0XEPc7l52MB3m5uaHp2SSZ_Uxes_1595136084', 460, 'oWwx95e0UMr3jcSu72di3KU7qg2U', '1', 1, 38, 1, 1595136084, 0);
INSERT INTO `dd_api_access_token` VALUES (428, '_q1NsmCDv0LZPaPFFfHeAbW2mC_5pyF-_1595136175', 'hqWzpPGvMOYshtDsm0Ii9QxFIrrUnhiE_1595136175', 461, 'oWwx95X6WmKy8FmkOSkcUQ84dhls', '1', 1, 38, 1, 1595136175, 0);
INSERT INTO `dd_api_access_token` VALUES (429, '6x9pPZf6iZLLh7VQuLukMOKc_-bfgLiw_1595136204', '_k0f-2yA2LUqizC_ybtnARHILyiYOGdL_1595136204', 462, 'oWwx95USRyRtTqdM7equa9uYlf3c', '1', 1, 38, 1, 1595136204, 0);
INSERT INTO `dd_api_access_token` VALUES (430, 'SWTJuWKDqYzng56EEHfeDs0RSIt1Zjem_1595136943', 'O4kX6F5x1qhdyeWo9_yekstPbFN1JPJg_1595136943', 463, 'oWwx95TGO5vO2q1lBoDl4PjoVUQQ', '1', 1, 38, 1, 1595136943, 0);
INSERT INTO `dd_api_access_token` VALUES (431, 'Y2ArFJWhDX1VCjmVZ5zC3ZvtU0CSWM7Y_1595136957', 'yqfGiR1TjmWq7RjnARm-_-i-JI6tK0Cz_1595136957', 464, 'oWwx95Sv0t1lm5N3X5Y3kVtzcunE', '1', 1, 38, 1, 1595136957, 0);
INSERT INTO `dd_api_access_token` VALUES (432, 'iEIb1Z3oN-JoHRY0y81Ucb8tW3W5Xnos_1595137149', 'HiN4zjLipjYFpGgoC1r9k_CO_aDHndTi_1595137149', 465, 'oWwx95dyWlq7oMCwTzUwedEMIYus', '1', 1, 38, 1, 1595137149, 0);
INSERT INTO `dd_api_access_token` VALUES (433, 'XPpJ7pxjgTqbnqised0Wac9NWig0uh6M_1595137779', 'Cs2eWlEt9v4g8ikGcrqtTvRLkhRW6lJR_1595137779', 466, 'oWwx95fT9nrd6XzGmov5Q8HaBrl8', '1', 1, 38, 1, 1595137779, 0);
INSERT INTO `dd_api_access_token` VALUES (434, 'GYi5lMXtjBHfkDrKWU_t6agnEOz9Hdsp_1595138133', 'naU6N2U51DvVqwf9-eIKfi6NUHCuPhpD_1595138133', 467, 'oWwx95Tb7CAyFvWaWii7EaBUAGuo', '1', 1, 38, 1, 1595138133, 0);
INSERT INTO `dd_api_access_token` VALUES (435, 'kKpdYcsDJiqTh1AdD1NrHFapDaz9ABsh_1595138402', 'fABoEiaxVF4ufNi6vu6L-8Y-e_V9Hxi6_1595138402', 468, 'oWwx95bJODYAlmpj13m98kT1ZtI4', '1', 1, 38, 1, 1595138402, 0);
INSERT INTO `dd_api_access_token` VALUES (436, 'jcXEUNHiQvByZqmGEV4OiEYdONE8cUkR_1595139376', 'ewJOAOkzC8YtQE4rb0PoNuecv8PmV5xV_1595139376', 469, 'oWwx95TlPPCqP67nW7gmRsvaOHJ0', '1', 1, 38, 1, 1595139376, 0);
INSERT INTO `dd_api_access_token` VALUES (437, 'FFKdkRXAUtDdLnMOACXkayZsryFS2T-n_1595140627', '9Q58JJO7u8a6hO-LPRG5vn06NIMCaEO__1595140627', 470, 'oWwx95dWQRMQmZMd5FRtHv8mPvyo', '1', 1, 38, 1, 1595140627, 0);
INSERT INTO `dd_api_access_token` VALUES (438, 'olWZFRmrzU8ToFS39axe8l3TU5x5aHYL_1595142235', 'ZParRZGvTPqe5vt3YWUS15FNf2yzf8uo_1595142235', 471, 'oWwx95dkVkiBhFZ-JD04QqrWMkh8', '1', 1, 38, 1, 1595142235, 0);
INSERT INTO `dd_api_access_token` VALUES (439, 'iCRoyctgWcovbjPHHp2CDD_VwGurPomH_1595142632', 'nsf283S0VUj8fw-rzwWH-tODhZRUvON3_1595142632', 472, 'oWwx95Y5jSnapV6nup0oKaKADwr0', '1', 1, 38, 1, 1595142632, 0);
INSERT INTO `dd_api_access_token` VALUES (440, 'zl2WmbdaXW1GxL9dTv3r_JtuKo6DuFzq_1595142760', 'iYsPLddYeDeE-Et0aAEkyKmL0wn1B95s_1595142760', 473, 'oWwx95avKYZ62JNILXpcpECVF-xc', '1', 1, 38, 1, 1595142760, 0);
INSERT INTO `dd_api_access_token` VALUES (441, 'NtvIYaUVPgXEE3L2QWtVLFFNLlzX1lpi_1595142827', 'EE4-cHFnC1hoTSnda1UzhjUEf3lM1CYl_1595142827', 474, 'oWwx95a_IghAN1lD2HmRUSiCMU9A', '1', 1, 38, 1, 1595142827, 0);
INSERT INTO `dd_api_access_token` VALUES (442, 'Hsqpssnc3v49Gl8MJ-vJwtcStE_1SILM_1595215155', 'o5KQC7O2JB51Sg4vyh_9FL21Dq1yMj5e_1595215155', 475, 'oWwx95ZA5CGMdjzzMUZvtkiWgpnI', '1', 1, 38, 1, 1595215155, 0);
INSERT INTO `dd_api_access_token` VALUES (443, 'KMuHR1jSSp6BnDNbs4IyD2ge_BTCiOBi_1595144186', 'QUBt-boO7H-0drFEvZa2mvawxMyVvuOx_1595144186', 476, 'oWwx95SMLehtznHgvK659u8JSJRQ', '1', 1, 38, 1, 1595144186, 0);
INSERT INTO `dd_api_access_token` VALUES (444, 'R7rO5ZnrlbcGBdXt02dZ7-cH0Oh8OwKQ_1595145922', 'aK1W5fCayGY8dA_QTEUhkDSOpcgoJ8Hd_1595145922', 477, 'oWwx95aFAndT8grCQnfsVxrSZALA', '1', 1, 38, 1, 1595145922, 0);
INSERT INTO `dd_api_access_token` VALUES (445, '8MxPaO0gVEHqUTfx6mvO989BPgMrU9OX_1595149797', 'SJfSJMWmljW_MlVsTsh3EozkaBiEEnE1_1595149797', 478, 'oWwx95XS_c0KPuNv3kNo5tlNNOrw', '1', 1, 38, 1, 1595149797, 0);
INSERT INTO `dd_api_access_token` VALUES (446, 'IxngXkHHJnOpEusAP8oDEombqd1yMRq7_1595152523', 'UQE-JicoG8wjwjC5J0CsYCpLm6r5xdNZ_1595152523', 479, 'oWwx95UNZh7BJdIqVOGzAZDTDUrY', '1', 1, 38, 1, 1595152523, 0);
INSERT INTO `dd_api_access_token` VALUES (447, 'x5ZAyJS35jF8lnp3Xlekf4NC0LOPimzU_1595152626', '4JNCKGzU2E3xoLwyw5hw-ZCBNxkdP91y_1595152626', 480, 'oWwx95SJMGQ27uNs8ySgK7eHf9us', '1', 1, 38, 1, 1595152626, 0);
INSERT INTO `dd_api_access_token` VALUES (448, 'MkguxxJmg70AeaLg8LY-RJ5HEFYExU_k_1595155049', 'AmUcp4ZVcItp5U4Euk7qKgKbl6sPIDBa_1595155049', 481, 'oWwx95R06cicDIk8fzs1Lm4pFdQ8', '1', 1, 38, 1, 1595155049, 0);
INSERT INTO `dd_api_access_token` VALUES (449, '_NBuO3UyQoArF7lBHlHhtYZ-pRxRQTrQ_1595156576', '5dpql7xp7A74QrWXsUo6psGLEkWCQyJn_1595156576', 482, 'oWwx95SM6OMm1ZzCN0K2_1qAmd90', '1', 1, 38, 1, 1595156576, 0);
INSERT INTO `dd_api_access_token` VALUES (450, 'uFqUF8gGQhSmQLUhEsrEG2-tIUbBfVvh_1595158186', 'sF6Q_30qTeqQqcKl-rnEpKTo_Via11y1_1595158186', 483, 'oWwx95XPV9DMh-SsOwQqXSdhfLl0', '1', 1, 38, 1, 1595158186, 0);
INSERT INTO `dd_api_access_token` VALUES (451, 'jf0CtVa9uYRYXVkDI8p73hy2dpD3Ujgi_1595160846', 'umsAxqj4l3PcFUCKLcVVQ_mkMfro9j5o_1595160846', 484, 'oWwx95Yzm7r_UNh7-tuYRoqa5qtM', '1', 1, 38, 1, 1595160846, 0);
INSERT INTO `dd_api_access_token` VALUES (452, 'AvJusvLcVlzNffV6wFM4H6W0iIfTBzJ2_1595163237', 'mYrPv8bjnRfzosjNBE17UeYehWSYrksD_1595163237', 485, 'oWwx95YoKB2wRBUDQ23rm7TO-c9M', '1', 1, 38, 1, 1595163237, 0);
INSERT INTO `dd_api_access_token` VALUES (453, '54-1zZ4Zykejc0I8jSzMOAAbiS1AdEJE_1595174096', 'OPilrg706e-3x0jGRRKn0dtuxE2EuXX7_1595174096', 486, 'oWwx95TVtDmuiXB_1VaJBjlcjkAg', '1', 1, 38, 1, 1595174096, 0);
INSERT INTO `dd_api_access_token` VALUES (454, 'xhmJU5xgLII_puj0_UdBBJWZhOuH_qPc_1595182726', 'qZDVrjvj3GXuaA8vDbBv32DIqaqrnS29_1595182726', 487, 'oWwx95eEYAUyq_IgnXKP-4b_js0k', '1', 1, 38, 1, 1595182726, 0);
INSERT INTO `dd_api_access_token` VALUES (455, 'EGBgyFF_9kk9cysQ-7Uc_zyWSDmXo7VT_1595203451', 'W-0DVNd9z44cg2xD198hP01aVnZ28CLa_1595203451', 488, 'oWwx95VTtSaAIXJ5CuzW2MgM-TpI', '1', 1, 38, 1, 1595203451, 0);
INSERT INTO `dd_api_access_token` VALUES (456, 'K-OsMc3Eu6fKFUv6p2mxQtUnj6rz0F6b_1595227538', 'TsM4TBWUxLtMxGaVHOiruxFFxRXhxpzU_1595227538', 489, 'oWwx95YOzzDm5lZLV9c4wPUHmdbE', '1', 1, 38, 1, 1595227538, 0);
INSERT INTO `dd_api_access_token` VALUES (457, 'IWyWixxeEfXuy4HvoyLULgsTXPNQIeGL_1595227365', '_mzfc1DhIsu9XUT2vuB4xZuSWiEpt0hf_1595227365', 490, 'oWwx95ZSeykgE0wZiR9IJA8xD5ac', '1', 1, 38, 1, 1595227365, 0);
INSERT INTO `dd_api_access_token` VALUES (458, 'umidiRUyoLvstu---Jo77XhreH1oDBhe_1595227597', 'kaMBfURfhVgo7RNzQVZquoBfr34ZAdXU_1595227597', 491, 'oWwx95TiMhnqqy4g4_EvyUdp9IUg', '1', 1, 38, 1, 1595227597, 0);

-- ----------------------------
-- Table structure for dd_api_log
-- ----------------------------
DROP TABLE IF EXISTS `dd_api_log`;
CREATE TABLE `dd_api_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `method` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '提交类型',
  `url` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '提交url',
  `get_data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'get数据',
  `post_data` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT 'post数据',
  `ip` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'ip地址',
  `append` int(10) NULL DEFAULT 0 COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'api_接口日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_api_log
-- ----------------------------

-- ----------------------------
-- Table structure for dd_article
-- ----------------------------
DROP TABLE IF EXISTS `dd_article`;
CREATE TABLE `dd_article`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ishot` tinyint(1) UNSIGNED NOT NULL,
  `pcate` int(10) UNSIGNED NOT NULL,
  `ccate` int(10) UNSIGNED NOT NULL,
  `template` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `content` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `thumb` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `incontent` tinyint(1) NOT NULL,
  `source` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `author` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `displayorder` int(10) UNSIGNED NOT NULL,
  `linkurl` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `createtime` int(10) UNSIGNED NOT NULL,
  `edittime` int(10) NOT NULL,
  `click` int(10) UNSIGNED NOT NULL,
  `type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `credit` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `icon` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_ishot`(`ishot`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 17 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文章资讯' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_article
-- ----------------------------
INSERT INTO `dd_article` VALUES (1, 0, 10, 13, '8', '智能硬件', '提供专业的智能硬件推荐方案，包括人脸抓拍机、人流热力图机等，实现在前端设备上运行人脸抓拍、人体检测跟踪等AI能力', '<p>提供专业的智能硬件推荐方案，包括人脸抓拍机、人流热力图机等，实现在前端设备上运行人脸抓拍、人体检测跟踪等AI能力</p>', '202002/29/516422b5-c302-3e95-b7e8-9c2038cd8be9.png', 0, 'wu', 'diandi', 1, 'www', 1582972566, 0, 0, '', '', 'fa fa-microchip');
INSERT INTO `dd_article` VALUES (2, 0, 10, 13, 'jieshao', '顾客洞察', '提供人脸识别与人体分析的云端服务，实现顾客个体识别、人体跟踪以及顾客群体画像与重复到店识别等分析功能', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">提供人脸识别与人体分析的云端服务，实现顾客个体识别、人体跟踪以及顾客群体画像与重复到店识别等分析功能</span></p>', 'upload/202001/18/e0b8ea3c-3176-3c86-b515-8961e9b52531.png', 0, 'wu', 'diandi', 1, 'www', 1579318080, 0, 0, '', '', 'fa fa-user-plus ');
INSERT INTO `dd_article` VALUES (3, 0, 10, 13, 'jieshao', '店铺管理模块', '从门店客流、顾客回访率、顾客停留时长及消费转化率、店员考勤监控等角度，实现对店铺的有效管理', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">从门店客流、顾客回访率、顾客停留时长及消费转化率、店员考勤监控等角度，实现对店铺的有效管理</span></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579318696, 0, 0, '', '', 'fa fa-home ');
INSERT INTO `dd_article` VALUES (4, 0, 10, 11, 'jieshao', '人脸检测定位', '检测图片中的人脸并标记出人脸坐标，支持同时识别多张人脸', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">检测图片中的人脸并标记出人脸坐标，支持同时识别多张人脸</span></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579320120, 0, 0, '', '', 'fa fa-user-o');
INSERT INTO `dd_article` VALUES (5, 0, 10, 11, 'jieshao', '人脸属性分析', '准确识别多种人脸属性信息，包括年龄、性别、颜值、表情、情绪、脸型、头部姿态、是否闭眼、是否配戴眼镜、人脸质量信息及类型等', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">准确识别多种人脸属性信息，包括年龄、性别、颜值、表情、情绪、脸型、头部姿态、是否闭眼、是否配戴眼镜、人脸质量信息及类型等</span></p>', 'upload/202001/18/d0745841-7b4e-3726-a323-a6d64d742f5b.jpg', 0, 'wu', 'diandi', 1, 'www', 1579320162, 0, 0, '', '', 'fa fa-microchip');
INSERT INTO `dd_article` VALUES (6, 0, 10, 11, 'jieshao', '150关键点定位', '精准定位包括脸颊、眉、眼、口、鼻等人脸五官及轮廓的150个关键点', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">精准定位包括脸颊、眉、眼、口、鼻等人脸五官及轮廓的150个关键点</span></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579320195, 0, 0, '', '', 'fa fa-microchip');
INSERT INTO `dd_article` VALUES (7, 0, 10, 11, 'jieshao', '情绪识别', '分析检测到的人脸的情绪，并返回置信度分数，目前可识别愤怒、厌恶、恐惧、高兴、伤心、惊讶、嘟嘴、鬼脸、无情绪等9种情绪', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">分析检测到的人脸的情绪，并返回置信度分数，目前可识别愤怒、厌恶、恐惧、高兴、伤心、惊讶、嘟嘴、鬼脸、无情绪等9种情绪</span></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579320229, 0, 0, '', '', 'fa fa-microchip');
INSERT INTO `dd_article` VALUES (8, 0, 10, 11, 'jieshao', '图片质量控制', '分析图片中人脸的遮挡度、模糊度、光照强度、姿态角度、完整度、大小等特征，确保图片符合质量标准，保障后续人脸对比、搜索的准确性', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">分析图片中人脸的遮挡度、模糊度、光照强度、姿态角度、完整度、大小等特征，确保图片符合质量标准，保障后续人脸对比、搜索的准确性</span></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579320258, 0, 0, '', '', 'fa fa-microchip');
INSERT INTO `dd_article` VALUES (9, 0, 10, 11, 'jieshao', '在线图片活体检测', '基于单张图片中人像的破绽（摩尔纹、成像畸形等），判断图片是否为二次翻拍，过滤检测中不符合标准的人脸', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">基于单张图片中人像的破绽（摩尔纹、成像畸形等），判断图片是否为二次翻拍，过滤检测中不符合标准的人脸</span></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579320284, 0, 0, '', '', 'fa fa-microchip');
INSERT INTO `dd_article` VALUES (10, 0, 10, 9, 'jieshao', '商场客流统计', '商场的客流量对于运营情况分析是十分重要的数据，通过抓拍机对商场内的顾客人脸进行实时抓拍识别，能够统计到精准的区中顾客数；通过人流热力图机与云端算法的配合对商场客流热力分布图进行绘制，最直观地让运营者了', '<p>商场的客流量对于运营情况分析是十分重要的数据，通过抓拍机对商场内的顾客人脸进行实时抓拍识别，能够统计到精准的区中顾客数；通过人流热力图机与云端算法的配合对商场客流热力分布图进行绘制，最直观地让运营者了解商场运营状态进而做出更准确的经营决策。</p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579320863, 0, 0, '', '', 'fa fa-home ');
INSERT INTO `dd_article` VALUES (11, 0, 10, 9, 'jieshao', '门店智能管理', '通过人脸检测抓拍、和库中人脸比对的方式获取来人身份信息，尤其应用于新零售场景中，可用于识别门店会员，与系统中的会员购买记录、联系方式等信息匹配，推送给店员，实现精准营销。', '<p><span style=\"font-family: BlinkMacSystemFont, Roboto, &quot;Helvetica Neue&quot;, Helvetica, PingFangSC-Regular, &quot;Hiragino Sans GB&quot;, &quot;Microsoft YaHei&quot;, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);\">通过人脸检测抓拍、和库中人脸比对的方式获取来人身份信息，尤其应用于新零售场景中，可用于识别门店会员，与系统中的会员购买记录、联系方式等信息匹配，推送给店员，实现精准营销。</span></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579320892, 0, 0, '', '', 'fa-user-plus ');
INSERT INTO `dd_article` VALUES (12, 0, 10, 9, 'jieshao', '店内监控', '店内监控', '<p>店内监控</p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579321283, 0, 0, '', '', 'fa-user-plus ');
INSERT INTO `dd_article` VALUES (13, 0, 10, 8, 'jieshao', '人脸识别摄像头', '人脸识别摄像头', '<p>人脸识别摄像头</p>', 'upload/202001/18/707700ac-e089-32c1-854c-57ee6d7ab838.jpg', 0, 'wu', 'diandi', 1, 'www', 1579322166, 0, 0, '', '', 'fa-microchip');
INSERT INTO `dd_article` VALUES (14, 0, 10, 12, 'jieshao', '接口开源', '接口完全开源', '<p>接口文档开源：<a href=\"http://www.open.com/index.php?r=doc\" target=\"_blank\" title=\"查看接口文档\">文档地址</a></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'www', 1579404291, 0, 0, '', '', 'fa fa-user-o');
INSERT INTO `dd_article` VALUES (15, 0, 10, 12, 'jieshao', '代码开源', '代码开源', '<p>代码开源：<a href=\"https://gitee.com/wayfiretech_admin/firetech\" target=\"_blank\">源码GIT地址</a></p>', 'upload/202001/18/9877f497-97ac-3f4b-84cf-6563c059162f.png', 0, 'wu', 'diandi', 1, 'https://gitee.com/wayfiretech_admin/firetech', 1579404417, 0, 0, '', '', 'fa-microchip');
INSERT INTO `dd_article` VALUES (16, 0, 10, 14, 'jieshao', '店滴AI', '基于人脸识别的会员管理系统', '<p>基于人脸识别的会员管理系统</p>', 'upload/202001/19/b7440d3b-f625-34c2-9851-3f3a983baa53.jpg', 0, 'wu', 'diandi', 1, 'www', 1579400356, 0, 0, '', '', '');

-- ----------------------------
-- Table structure for dd_article_category
-- ----------------------------
DROP TABLE IF EXISTS `dd_article_category`;
CREATE TABLE `dd_article_category`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `displayorder` tinyint(3) UNSIGNED NOT NULL,
  `pcate` int(11) NULL DEFAULT 0,
  `type` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type`(`type`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 15 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文章分类' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_article_category
-- ----------------------------
INSERT INTO `dd_article_category` VALUES (14, '关于我们', 1, 10, 'about');
INSERT INTO `dd_article_category` VALUES (8, '智能设备', 1, 10, 'facility');
INSERT INTO `dd_article_category` VALUES (9, '应用场景', 1, 10, 'scene');
INSERT INTO `dd_article_category` VALUES (10, '网站内容', 1, 0, 'website');
INSERT INTO `dd_article_category` VALUES (11, '特色优势', 1, 10, 'superiority');
INSERT INTO `dd_article_category` VALUES (12, '开源内容', 1, 10, 'open');
INSERT INTO `dd_article_category` VALUES (13, '方案介绍', 1, 10, 'website1');

-- ----------------------------
-- Table structure for dd_auth_assignment
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_assignment`;
CREATE TABLE `dd_auth_assignment`  (
  `item_id` int(11) NOT NULL,
  `item_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `user_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`item_name`, `user_id`) USING BTREE,
  INDEX `auth_assignment_user_id_idx`(`user_id`) USING BTREE,
  CONSTRAINT `dd_auth_assignment_ibfk_1` FOREIGN KEY (`item_name`) REFERENCES `dd_auth_item` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户与权限关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_assignment
-- ----------------------------
INSERT INTO `dd_auth_assignment` VALUES (0, '人脸库管理', '11', 1586678304);
INSERT INTO `dd_auth_assignment` VALUES (0, '人脸识别', '11', 1586678304);
INSERT INTO `dd_auth_assignment` VALUES (31, '价格配置', '20', 1593573915);
INSERT INTO `dd_auth_assignment` VALUES (0, '会员管理', '11', 1586678304);
INSERT INTO `dd_auth_assignment` VALUES (32, '分销商品管理', '20', 1593575206);
INSERT INTO `dd_auth_assignment` VALUES (25, '商品分类', '20', 1593569319);
INSERT INTO `dd_auth_assignment` VALUES (35, '商品标签管理', '20', 1593575206);
INSERT INTO `dd_auth_assignment` VALUES (24, '商品管理', '15', 1589108423);
INSERT INTO `dd_auth_assignment` VALUES (24, '商品管理', '20', 1593569319);
INSERT INTO `dd_auth_assignment` VALUES (26, '商家', '20', 1593569319);
INSERT INTO `dd_auth_assignment` VALUES (27, '商家信息维护', '20', 1593569319);
INSERT INTO `dd_auth_assignment` VALUES (0, '基础权限组', '1', 1588809678);
INSERT INTO `dd_auth_assignment` VALUES (0, '基础权限组', '11', 1586678304);
INSERT INTO `dd_auth_assignment` VALUES (4, '基础权限组', '20', 1593569288);
INSERT INTO `dd_auth_assignment` VALUES (0, '开发示例', '11', 1586678304);
INSERT INTO `dd_auth_assignment` VALUES (0, '扩展功能', '11', 1586678304);
INSERT INTO `dd_auth_assignment` VALUES (36, '抽奖权限', '21', 1593679676);
INSERT INTO `dd_auth_assignment` VALUES (0, '权限控制', '11', 1586678304);
INSERT INTO `dd_auth_assignment` VALUES (0, '模块生成', '11', 1586678305);
INSERT INTO `dd_auth_assignment` VALUES (0, '模块统一入口', '1', 1588809691);
INSERT INTO `dd_auth_assignment` VALUES (10, '模块统一入口', '20', 1593569292);
INSERT INTO `dd_auth_assignment` VALUES (0, '站点管理', '11', 1586678305);
INSERT INTO `dd_auth_assignment` VALUES (0, '系统设置', '11', 1586678305);
INSERT INTO `dd_auth_assignment` VALUES (20, '订单操作', '20', 1593569319);
INSERT INTO `dd_auth_assignment` VALUES (17, '订单管理', '15', 1589031171);
INSERT INTO `dd_auth_assignment` VALUES (17, '订单管理', '20', 1593569319);
INSERT INTO `dd_auth_assignment` VALUES (0, '订座', '11', 1586678305);
INSERT INTO `dd_auth_assignment` VALUES (33, '评论管理', '20', 1593575206);
INSERT INTO `dd_auth_assignment` VALUES (0, '资源上传', '11', 1586678305);
INSERT INTO `dd_auth_assignment` VALUES (19, '资源上传', '20', 1593569297);
INSERT INTO `dd_auth_assignment` VALUES (30, '配置权限', '20', 1593573915);
INSERT INTO `dd_auth_assignment` VALUES (34, '配送点管理', '20', 1593575206);
INSERT INTO `dd_auth_assignment` VALUES (28, '默认入口', '15', 1589034117);
INSERT INTO `dd_auth_assignment` VALUES (28, '默认入口', '20', 1593569319);

-- ----------------------------
-- Table structure for dd_auth_assignment_group
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_assignment_group`;
CREATE TABLE `dd_auth_assignment_group`  (
  `group_id` int(11) NOT NULL,
  `item_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `user_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`item_name`, `user_id`) USING BTREE,
  INDEX `auth_assignment_user_id_idx`(`user_id`) USING BTREE,
  CONSTRAINT `dd_auth_assignment_ibfk_2` FOREIGN KEY (`item_name`) REFERENCES `dd_auth_user_group` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户权限组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_assignment_group
-- ----------------------------
INSERT INTO `dd_auth_assignment_group` VALUES (0, '基础权限组', '1', 1588768586);
INSERT INTO `dd_auth_assignment_group` VALUES (551, '基础权限组', '11', 1589288351);
INSERT INTO `dd_auth_assignment_group` VALUES (0, '基础权限组', '14', 1588816083);
INSERT INTO `dd_auth_assignment_group` VALUES (551, '基础权限组', '15', 1592303323);
INSERT INTO `dd_auth_assignment_group` VALUES (551, '基础权限组', '19', 1592302886);
INSERT INTO `dd_auth_assignment_group` VALUES (0, '基础权限组', '2', 1588756893);
INSERT INTO `dd_auth_assignment_group` VALUES (565, '店滴商城-评论', '20', 1593569319);
INSERT INTO `dd_auth_assignment_group` VALUES (559, '店滴商城-运维', '15', 1589030125);
INSERT INTO `dd_auth_assignment_group` VALUES (559, '店滴商城-运维', '20', 1593569319);
INSERT INTO `dd_auth_assignment_group` VALUES (0, '总管理员', '1', 1588768586);
INSERT INTO `dd_auth_assignment_group` VALUES (552, '总管理员', '11', 1589288348);

-- ----------------------------
-- Table structure for dd_auth_item
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_item`;
CREATE TABLE `dd_auth_item`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `type` smallint(6) NOT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `rule_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `parent_id` int(11) NULL DEFAULT NULL,
  `data` blob NULL,
  `module_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `rule_name`(`rule_name`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  INDEX `name`(`name`) USING BTREE,
  CONSTRAINT `dd_auth_item_ibfk_1` FOREIGN KEY (`rule_name`) REFERENCES `dd_auth_rule` (`name`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 37 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_item
-- ----------------------------
INSERT INTO `dd_auth_item` VALUES (1, '人脸库管理', 0, NULL, NULL, 0, NULL, 'sys', 1582139590, 1582141243);
INSERT INTO `dd_auth_item` VALUES (2, '人脸识别', 0, NULL, NULL, 1, NULL, 'sys', 1582139583, 1582141300);
INSERT INTO `dd_auth_item` VALUES (3, '会员管理', 0, NULL, NULL, 0, NULL, 'sys', 1582139598, 1582139598);
INSERT INTO `dd_auth_item` VALUES (4, '基础权限组', 0, NULL, NULL, 0, NULL, 'sys', 1585578773, 1585578773);
INSERT INTO `dd_auth_item` VALUES (6, '开发示例', 0, NULL, NULL, 0, NULL, 'sys', 1585611530, 1585611530);
INSERT INTO `dd_auth_item` VALUES (7, '扩展功能', 0, NULL, NULL, 0, NULL, 'sys', 1582139605, 1582139605);
INSERT INTO `dd_auth_item` VALUES (8, '权限控制', 0, NULL, NULL, 0, NULL, 'sys', 1582139364, 1582139364);
INSERT INTO `dd_auth_item` VALUES (9, '模块生成', 0, NULL, NULL, 0, NULL, 'sys', 1585473562, 1585473562);
INSERT INTO `dd_auth_item` VALUES (10, '模块统一入口', 0, NULL, NULL, 0, NULL, '', 1588808930, 1588808930);
INSERT INTO `dd_auth_item` VALUES (11, '测试', 0, NULL, NULL, 0, NULL, 'sys', 1588851182, 1588851182);
INSERT INTO `dd_auth_item` VALUES (12, '测试实施', 0, NULL, NULL, 0, NULL, 'sys', 1588573267, 1588573267);
INSERT INTO `dd_auth_item` VALUES (13, '站点管理', 0, NULL, NULL, 0, NULL, 'sys', 1582139575, 1582139575);
INSERT INTO `dd_auth_item` VALUES (14, '管理员管理', 0, NULL, NULL, 0, NULL, '', 1588779477, 1588779477);
INSERT INTO `dd_auth_item` VALUES (15, '系统设置', 0, NULL, NULL, 0, NULL, 'sys', 1582139568, 1582139568);
INSERT INTO `dd_auth_item` VALUES (17, '订单管理', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588927400, 1588927400);
INSERT INTO `dd_auth_item` VALUES (18, '订座', 0, NULL, NULL, 0, NULL, 'sys', 1585413762, 1585413762);
INSERT INTO `dd_auth_item` VALUES (19, '资源上传', 0, NULL, NULL, 0, NULL, 'sys', 1585451956, 1585451956);
INSERT INTO `dd_auth_item` VALUES (20, '订单操作', 1, NULL, NULL, 17, NULL, 'diandi_shop', 1588945445, 1588945445);
INSERT INTO `dd_auth_item` VALUES (24, '商品管理', 1, NULL, '模块访问', 0, 0x613A313A7B733A323A226964223B733A323A223233223B7D, 'diandi_shop', 1588952740, 1589126545);
INSERT INTO `dd_auth_item` VALUES (25, '商品分类', 1, NULL, NULL, 24, NULL, 'diandi_shop', 1588953479, 1588953479);
INSERT INTO `dd_auth_item` VALUES (26, '商家', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588953578, 1588953578);
INSERT INTO `dd_auth_item` VALUES (27, '商家信息维护', 1, NULL, NULL, 26, NULL, 'diandi_shop', 1588953596, 1588953596);
INSERT INTO `dd_auth_item` VALUES (28, '默认入口', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1589034059, 1589034059);
INSERT INTO `dd_auth_item` VALUES (29, '数据库', 0, NULL, NULL, 15, NULL, 'sys', 1592915692, 1592915723);
INSERT INTO `dd_auth_item` VALUES (30, '配置权限', 1, NULL, NULL, 0, NULL, 'diandi_distribution', 1593569358, 1593569512);
INSERT INTO `dd_auth_item` VALUES (31, '价格配置', 1, NULL, NULL, 30, NULL, 'diandi_distribution', 1593569540, 1593569540);
INSERT INTO `dd_auth_item` VALUES (32, '分销商品管理', 1, NULL, NULL, 0, NULL, 'diandi_distribution', 1593573986, 1593573986);
INSERT INTO `dd_auth_item` VALUES (33, '评论管理', 1, NULL, NULL, 26, NULL, 'diandi_shop', 1593574124, 1593574124);
INSERT INTO `dd_auth_item` VALUES (34, '配送点管理', 1, NULL, NULL, 24, NULL, 'diandi_shop', 1593575097, 1593575097);
INSERT INTO `dd_auth_item` VALUES (35, '商品标签管理', 1, NULL, NULL, 24, NULL, 'diandi_shop', 1593575124, 1593575124);
INSERT INTO `dd_auth_item` VALUES (36, '抽奖权限', 1, NULL, NULL, 0, NULL, 'diandi_lottery', 1593679648, 1593679648);

-- ----------------------------
-- Table structure for dd_auth_item_child
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_item_child`;
CREATE TABLE `dd_auth_item_child`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NULL DEFAULT NULL,
  `parent` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `child` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `module_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `child_type` smallint(6) NULL DEFAULT NULL,
  `parent_type` smallint(6) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `child`(`child`) USING BTREE,
  INDEX `parent`(`parent`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1658 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_item_child
-- ----------------------------
INSERT INTO `dd_auth_item_child` VALUES (1, 0, '人脸库管理', '/diandiai/dd-ai-applications/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (2, 0, '人脸库管理', '/diandiai/dd-ai-applications/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (3, 0, '人脸库管理', '/diandiai/dd-ai-applications/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (4, 0, '人脸库管理', '/diandiai/dd-ai-applications/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (5, 0, '人脸库管理', '/diandiai/dd-ai-applications/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (6, 0, '人脸库管理', '/diandiai/dd-ai-applications/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (7, 0, '人脸库管理', '/diandiai/dd-ai-applications/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (8, 0, '人脸库管理', '/diandiai/dd-ai-faces/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (9, 0, '人脸库管理', '/diandiai/dd-ai-faces/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (10, 0, '人脸库管理', '/diandiai/dd-ai-faces/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (11, 0, '人脸库管理', '/diandiai/dd-ai-faces/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (12, 0, '人脸库管理', '/diandiai/dd-ai-faces/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (13, 0, '人脸库管理', '/diandiai/dd-ai-faces/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (14, 0, '人脸库管理', '/diandiai/dd-ai-faces/users', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (15, 0, '人脸库管理', '/diandiai/dd-ai-faces/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (16, 0, '人脸库管理', '/diandiai/dd-ai-groups/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (17, 0, '人脸库管理', '/diandiai/dd-ai-groups/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (18, 0, '人脸库管理', '/diandiai/dd-ai-groups/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (19, 0, '人脸库管理', '/diandiai/dd-ai-groups/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (20, 0, '人脸库管理', '/diandiai/dd-ai-groups/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (21, 0, '人脸库管理', '/diandiai/dd-ai-groups/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (22, 0, '人脸库管理', '/diandiai/dd-ai-groups/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (23, 0, '人脸库管理', '/diandiai/dd-ai-member/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (24, 0, '人脸库管理', '/diandiai/dd-ai-member/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (25, 0, '人脸库管理', '/diandiai/dd-ai-member/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (26, 0, '人脸库管理', '/diandiai/dd-ai-member/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (27, 0, '人脸库管理', '/diandiai/dd-ai-member/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (28, 0, '人脸库管理', '/diandiai/dd-ai-member/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (29, 0, '人脸库管理', '/diandiai/dd-ai-member/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (30, 0, '会员管理', '/member/dd-ai-member/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (31, 0, '会员管理', '/member/dd-ai-member/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (32, 0, '会员管理', '/member/dd-ai-member/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (33, 0, '会员管理', '/member/dd-ai-member/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (34, 0, '会员管理', '/member/dd-ai-member/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (35, 0, '会员管理', '/member/dd-ai-member/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (36, 0, '会员管理', '/member/dd-member-group/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (37, 0, '会员管理', '/member/dd-member-group/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (38, 0, '会员管理', '/member/dd-member-group/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (39, 0, '会员管理', '/member/dd-member-group/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (40, 0, '会员管理', '/member/dd-member-group/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (41, 0, '会员管理', '/member/dd-member-group/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (42, 0, '会员管理', '/member/dd-member-group/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (43, 0, '会员管理', '/member/dd-member/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (44, 0, '会员管理', '/member/dd-member/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (45, 0, '会员管理', '/member/dd-member/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (46, 0, '会员管理', '/member/dd-member/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (47, 0, '会员管理', '/member/dd-member/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (48, 0, '会员管理', '/member/dd-member/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (49, 0, '会员管理', '/member/dd-member/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (50, 0, '基础权限', '/system/index/childcate', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (51, 0, '开发示例', '/demo/form/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (52, 0, '开发示例', '/demo/form/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (53, 0, '开发示例', '/demo/form/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (54, 0, '扩展功能', '/diandi_shop/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (55, 0, '扩展功能', '/diandi_shop/default/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (56, 0, '扩展功能', '/diandi_shop/default/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (57, 0, '扩展功能', '/diandi_shop/default/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (58, 0, '扩展功能', '/diandi_shop/goods/dd-category/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (59, 0, '扩展功能', '/diandi_shop/goods/dd-category/childcate', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (60, 0, '扩展功能', '/diandi_shop/goods/dd-category/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (61, 0, '扩展功能', '/diandi_shop/goods/dd-category/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (62, 0, '扩展功能', '/diandi_shop/goods/dd-category/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (63, 0, '扩展功能', '/diandi_shop/goods/dd-category/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (64, 0, '扩展功能', '/diandi_shop/goods/dd-category/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (65, 0, '扩展功能', '/diandi_shop/goods/dd-category/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (66, 0, '扩展功能', '/diandi_shop/goods/dd-goods/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (67, 0, '扩展功能', '/diandi_shop/goods/dd-goods/adds', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (68, 0, '扩展功能', '/diandi_shop/goods/dd-goods/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (69, 0, '扩展功能', '/diandi_shop/goods/dd-goods/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (70, 0, '扩展功能', '/diandi_shop/goods/dd-goods/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (71, 0, '扩展功能', '/diandi_shop/goods/dd-goods/param', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (72, 0, '扩展功能', '/diandi_shop/goods/dd-goods/spec', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (73, 0, '扩展功能', '/diandi_shop/goods/dd-goods/specitem', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (74, 0, '扩展功能', '/diandi_shop/goods/dd-goods/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (75, 0, '扩展功能', '/diandi_shop/goods/dd-goods/upload', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (76, 0, '扩展功能', '/diandi_shop/goods/dd-goods/validate', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (77, 0, '扩展功能', '/diandi_shop/goods/dd-goods/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (78, 0, '扩展功能', '/diandi_shop/goods/dd-member/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (79, 0, '扩展功能', '/diandi_shop/goods/dd-member/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (80, 0, '扩展功能', '/diandi_shop/goods/dd-member/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (81, 0, '扩展功能', '/diandi_shop/goods/dd-member/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (82, 0, '扩展功能', '/diandi_shop/goods/dd-member/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (83, 0, '扩展功能', '/diandi_shop/goods/dd-member/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (84, 0, '扩展功能', '/diandi_shop/goods/dd-order/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (85, 0, '扩展功能', '/diandi_shop/goods/dd-order/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (86, 0, '扩展功能', '/diandi_shop/goods/dd-order/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (87, 0, '扩展功能', '/diandi_shop/goods/dd-order/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (88, 0, '扩展功能', '/diandi_shop/goods/dd-order/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (89, 0, '扩展功能', '/diandi_shop/goods/dd-order/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (90, 0, '扩展功能', '/diandi_shop/goods/dd-order/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (91, 0, '扩展功能', '/diandi_shop/menu/menu/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (92, 0, '扩展功能', '/diandi_shop/menu/menu/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (93, 0, '扩展功能', '/diandi_shop/menu/menu/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (94, 0, '扩展功能', '/diandi_shop/menu/menu/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (95, 0, '扩展功能', '/diandi_shop/menu/menu/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (96, 0, '扩展功能', '/diandi_shop/menu/menu/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (97, 0, '扩展功能', '/diandi_shop/menu/menu/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (98, 0, '扩展功能', '/diandi_shop/order/dd-delivery-rule/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (99, 0, '扩展功能', '/diandi_shop/order/dd-delivery-rule/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (100, 0, '扩展功能', '/diandi_shop/order/dd-delivery-rule/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (101, 0, '扩展功能', '/diandi_shop/order/dd-delivery-rule/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (102, 0, '扩展功能', '/diandi_shop/order/dd-delivery-rule/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (103, 0, '扩展功能', '/diandi_shop/order/dd-delivery-rule/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (104, 0, '扩展功能', '/diandi_shop/order/dd-delivery-rule/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (105, 0, '扩展功能', '/diandi_shop/order/dd-delivery/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (106, 0, '扩展功能', '/diandi_shop/order/dd-delivery/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (107, 0, '扩展功能', '/diandi_shop/order/dd-delivery/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (108, 0, '扩展功能', '/diandi_shop/order/dd-delivery/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (109, 0, '扩展功能', '/diandi_shop/order/dd-delivery/get-region', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (110, 0, '扩展功能', '/diandi_shop/order/dd-delivery/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (111, 0, '扩展功能', '/diandi_shop/order/dd-delivery/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (112, 0, '扩展功能', '/diandi_shop/order/dd-delivery/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (113, 0, '扩展功能', '/diandi_shop/order/dd-order/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (114, 0, '扩展功能', '/diandi_shop/order/dd-order/confirm', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (115, 0, '扩展功能', '/diandi_shop/order/dd-order/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (116, 0, '扩展功能', '/diandi_shop/order/dd-order/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (117, 0, '扩展功能', '/diandi_shop/order/dd-order/deletes', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (118, 0, '扩展功能', '/diandi_shop/order/dd-order/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (119, 0, '扩展功能', '/diandi_shop/order/dd-order/exportdata', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (120, 0, '扩展功能', '/diandi_shop/order/dd-order/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (121, 0, '扩展功能', '/diandi_shop/order/dd-order/upaddress', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (122, 0, '扩展功能', '/diandi_shop/order/dd-order/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (123, 0, '扩展功能', '/diandi_shop/order/dd-order/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (124, 0, '扩展功能', '/diandi_shop/setting/area/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (125, 0, '扩展功能', '/diandi_shop/setting/area/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (126, 0, '扩展功能', '/diandi_shop/setting/area/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (127, 0, '扩展功能', '/diandi_shop/setting/area/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (128, 0, '扩展功能', '/diandi_shop/setting/area/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (129, 0, '扩展功能', '/diandi_shop/setting/area/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (130, 0, '扩展功能', '/diandi_shop/setting/area/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (131, 0, '扩展功能', '/diandi_shop/setting/comment/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (132, 0, '扩展功能', '/diandi_shop/setting/comment/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (133, 0, '扩展功能', '/diandi_shop/setting/comment/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (134, 0, '扩展功能', '/diandi_shop/setting/comment/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (135, 0, '扩展功能', '/diandi_shop/setting/comment/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (136, 0, '扩展功能', '/diandi_shop/setting/comment/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (137, 0, '扩展功能', '/diandi_shop/setting/comment/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (138, 0, '扩展功能', '/diandi_shop/setting/store/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (139, 0, '扩展功能', '/diandi_shop/setting/store/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (140, 0, '扩展功能', '/diandi_shop/setting/store/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (141, 0, '扩展功能', '/diandi_shop/setting/store/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (142, 0, '扩展功能', '/diandi_shop/setting/store/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (143, 0, '扩展功能', '/diandi_shop/setting/store/setting', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (144, 0, '扩展功能', '/diandi_shop/setting/store/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (145, 0, '扩展功能', '/diandi_shop/setting/store/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (146, 0, '扩展功能', '/diandi_shop/system/menu/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (147, 0, '扩展功能', '/diandi_shop/system/menu/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (148, 0, '扩展功能', '/diandi_shop/system/menu/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (149, 0, '扩展功能', '/diandi_shop/system/menu/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (150, 0, '扩展功能', '/diandi_shop/system/menu/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (151, 0, '扩展功能', '/diandi_shop/system/menu/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (152, 0, '扩展功能', '/diandi_shop/system/menu/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (153, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-help/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (154, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-help/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (155, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-help/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (156, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-help/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (157, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-help/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (158, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-help/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (159, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-help/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (160, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-navbar/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (161, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-navbar/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (162, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-navbar/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (163, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-navbar/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (164, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-navbar/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (165, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-navbar/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (166, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-navbar/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (167, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-page/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (168, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-slide/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (169, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-slide/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (170, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-slide/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (171, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-slide/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (172, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-slide/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (173, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-slide/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (174, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp-slide/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (175, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (176, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (177, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (178, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (179, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (180, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (181, 0, '扩展功能', '/diandi_shop/wxapp/dd-wxapp/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (182, 0, '扩展功能', '/system/welcome/plugins', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (183, 0, '扩展功能', '订座', 'sys', 1, 1);
INSERT INTO `dd_auth_item_child` VALUES (184, 0, '普通管理员', '/module/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (185, 0, '普通管理员', '/system/welcome/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (186, 0, '普通管理员', '资源上传', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (187, 0, '权限控制', '/admin/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (188, 0, '权限控制', '/admin/assignment/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (189, 0, '权限控制', '/admin/assignment/assign', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (190, 0, '权限控制', '/admin/assignment/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (191, 0, '权限控制', '/admin/assignment/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (192, 0, '权限控制', '/admin/assignment/revoke', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (193, 0, '权限控制', '/admin/assignment/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (194, 0, '权限控制', '/admin/default/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (195, 0, '权限控制', '/admin/default/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (196, 0, '权限控制', '/admin/default/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (197, 0, '权限控制', '/admin/menu/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (198, 0, '权限控制', '/admin/menu/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (199, 0, '权限控制', '/admin/menu/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (200, 0, '权限控制', '/admin/menu/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (201, 0, '权限控制', '/admin/menu/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (202, 0, '权限控制', '/admin/menu/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (203, 0, '权限控制', '/admin/menu/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (204, 0, '权限控制', '/admin/permission/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (205, 0, '权限控制', '/admin/permission/assign', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (206, 0, '权限控制', '/admin/permission/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (207, 0, '权限控制', '/admin/permission/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (208, 0, '权限控制', '/admin/permission/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (209, 0, '权限控制', '/admin/permission/remove', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (210, 0, '权限控制', '/admin/permission/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (211, 0, '权限控制', '/admin/permission/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (212, 0, '权限控制', '/admin/role/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (213, 0, '权限控制', '/admin/role/assign', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (214, 0, '权限控制', '/admin/role/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (215, 0, '权限控制', '/admin/role/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (216, 0, '权限控制', '/admin/role/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (217, 0, '权限控制', '/admin/role/remove', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (218, 0, '权限控制', '/admin/role/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (219, 0, '权限控制', '/admin/role/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (220, 0, '权限控制', '/admin/route/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (221, 0, '权限控制', '/admin/route/assign', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (222, 0, '权限控制', '/admin/route/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (223, 0, '权限控制', '/admin/route/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (224, 0, '权限控制', '/admin/route/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (225, 0, '权限控制', '/admin/route/refresh', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (226, 0, '权限控制', '/admin/route/remove', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (227, 0, '权限控制', '/admin/rule/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (228, 0, '权限控制', '/admin/rule/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (229, 0, '权限控制', '/admin/rule/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (230, 0, '权限控制', '/admin/rule/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (231, 0, '权限控制', '/admin/rule/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (232, 0, '权限控制', '/admin/rule/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (233, 0, '权限控制', '/admin/rule/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (234, 0, '权限控制', '/admin/user/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (235, 0, '权限控制', '/admin/user/activate', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (236, 0, '权限控制', '/admin/user/change-password', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (237, 0, '权限控制', '/admin/user/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (238, 0, '权限控制', '/admin/user/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (239, 0, '权限控制', '/admin/user/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (240, 0, '权限控制', '/admin/user/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (241, 0, '权限控制', '/admin/user/login', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (242, 0, '权限控制', '/admin/user/logout', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (243, 0, '权限控制', '/admin/user/request-password-reset', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (244, 0, '权限控制', '/admin/user/reset-password', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (245, 0, '权限控制', '/admin/user/signup', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (246, 0, '权限控制', '/admin/user/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (247, 0, '权限控制', '/admin/user/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (248, 0, '模块生成', '/gii/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (249, 0, '模块生成', '/gii/default/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (250, 0, '模块生成', '/gii/default/action', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (251, 0, '模块生成', '/gii/default/diff', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (252, 0, '模块生成', '/gii/default/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (253, 0, '模块生成', '/gii/default/preview', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (254, 0, '模块生成', '/gii/default/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (255, 0, '模块管理员', '基础权限', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (256, 0, '模块管理员', '扩展功能', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (257, 0, '模块管理员', '资源上传', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (258, 0, '站点管理', '/modal/modal/website', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (259, 0, '站点管理', '/system/settings/website', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (260, 0, '站点管理', '/website/dd-website-contact/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (261, 0, '站点管理', '/website/dd-website-contact/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (262, 0, '站点管理', '/website/dd-website-contact/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (263, 0, '站点管理', '/website/dd-website-contact/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (264, 0, '站点管理', '/website/dd-website-contact/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (265, 0, '站点管理', '/website/dd-website-contact/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (266, 0, '站点管理', '/website/dd-website-contact/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (267, 0, '站点管理', '/website/dd-website-slide/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (268, 0, '站点管理', '/website/dd-website-slide/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (269, 0, '站点管理', '/website/dd-website-slide/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (270, 0, '站点管理', '/website/dd-website-slide/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (271, 0, '站点管理', '/website/dd-website-slide/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (272, 0, '站点管理', '/website/dd-website-slide/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (273, 0, '站点管理', '/website/dd-website-slide/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (274, 0, '站点管理', '/website/setting/website', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (275, 0, '系统设置', '/addons/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (276, 0, '系统设置', '/addons/addons/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (277, 0, '系统设置', '/addons/addons/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (278, 0, '系统设置', '/addons/addons/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (279, 0, '系统设置', '/addons/addons/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (280, 0, '系统设置', '/addons/addons/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (281, 0, '系统设置', '/addons/addons/logo', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (282, 0, '系统设置', '/addons/addons/uninstalled', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (283, 0, '系统设置', '/addons/addons/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (284, 0, '系统设置', '/addons/addons/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (285, 0, '系统设置', '/addons/manage/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (286, 0, '系统设置', '/addons/manage/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (287, 0, '系统设置', '/addons/manage/install', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (288, 0, '系统设置', '/addons/manage/uninstall', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (289, 0, '系统设置', '/addons/manage/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (290, 0, '系统设置', '/bloc/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (291, 0, '系统设置', '/bloc/bloc/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (292, 0, '系统设置', '/bloc/bloc/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (293, 0, '系统设置', '/bloc/bloc/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (294, 0, '系统设置', '/bloc/bloc/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (295, 0, '系统设置', '/bloc/bloc/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (296, 0, '系统设置', '/bloc/bloc/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (297, 0, '系统设置', '/bloc/default/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (298, 0, '系统设置', '/bloc/default/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (299, 0, '系统设置', '/system/settings/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (300, 0, '系统设置', '/system/settings/baidu', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (301, 0, '系统设置', '/system/settings/settings', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (302, 0, '系统设置', '/system/settings/sms', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (303, 0, '系统设置', '/system/settings/website', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (304, 0, '系统设置', '/system/settings/weburl', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (305, 0, '系统设置', '/system/settings/wechatpay', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (306, 0, '订座', '/diandi_store/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (307, 0, '订座', '/diandi_store/coupon-groups/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (308, 0, '订座', '/diandi_store/coupon-groups/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (309, 0, '订座', '/diandi_store/coupon-groups/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (310, 0, '订座', '/diandi_store/coupon-groups/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (311, 0, '订座', '/diandi_store/coupon-groups/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (312, 0, '订座', '/diandi_store/coupon-groups/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (313, 0, '订座', '/diandi_store/coupon-record/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (314, 0, '订座', '/diandi_store/coupon-record/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (315, 0, '订座', '/diandi_store/coupon-record/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (316, 0, '订座', '/diandi_store/coupon-record/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (317, 0, '订座', '/diandi_store/coupon-record/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (318, 0, '订座', '/diandi_store/coupon-record/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (319, 0, '订座', '/diandi_store/coupon/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (320, 0, '订座', '/diandi_store/coupon/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (321, 0, '订座', '/diandi_store/coupon/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (322, 0, '订座', '/diandi_store/coupon/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (323, 0, '订座', '/diandi_store/coupon/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (324, 0, '订座', '/diandi_store/coupon/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (325, 0, '订座', '/diandi_store/default/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (326, 0, '订座', '/diandi_store/default/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (327, 0, '订座', '/diandi_store/default/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (328, 0, '订座', '/diandi_store/store-seat/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (329, 0, '订座', '/diandi_store/store-seat/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (330, 0, '订座', '/diandi_store/store-seat/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (331, 0, '订座', '/diandi_store/store-seat/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (332, 0, '订座', '/diandi_store/store-seat/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (333, 0, '订座', '/diandi_store/store-seat/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (334, 0, '订座', '/diandi_store/store-service/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (335, 0, '订座', '/diandi_store/store-service/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (336, 0, '订座', '/diandi_store/store-service/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (337, 0, '订座', '/diandi_store/store-service/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (338, 0, '订座', '/diandi_store/store-service/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (339, 0, '订座', '/diandi_store/store-service/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (340, 0, '订座', '/diandi_store/store-share/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (341, 0, '订座', '/diandi_store/store-share/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (342, 0, '订座', '/diandi_store/store-share/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (343, 0, '订座', '/diandi_store/store-share/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (344, 0, '订座', '/diandi_store/store-share/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (345, 0, '订座', '/diandi_store/store-share/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (346, 0, '订座', '/diandi_store/store-slide/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (347, 0, '订座', '/diandi_store/store-slide/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (348, 0, '订座', '/diandi_store/store-slide/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (349, 0, '订座', '/diandi_store/store-slide/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (350, 0, '订座', '/diandi_store/store-slide/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (351, 0, '订座', '/diandi_store/store-slide/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (352, 0, '订座', '/diandi_store/store/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (353, 0, '订座', '/diandi_store/store/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (354, 0, '订座', '/diandi_store/store/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (355, 0, '订座', '/diandi_store/store/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (356, 0, '订座', '/diandi_store/store/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (357, 0, '订座', '/diandi_store/store/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (358, 0, '订座', '/diandi_store/user/record/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (359, 0, '订座', '/diandi_store/user/record/create', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (360, 0, '订座', '/diandi_store/user/record/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (361, 0, '订座', '/diandi_store/user/record/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (362, 0, '订座', '/diandi_store/user/record/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (363, 0, '订座', '/diandi_store/user/record/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (364, 0, '订座', '/diandi_store/user/record/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (365, 0, '资源上传', '/modal/modal/icons', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (366, 0, '资源上传', '/upload/upload/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (367, 0, '资源上传', '/upload/upload/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (368, 0, '资源上传', '/upload/upload/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (909, 0, '总管理员', '人脸库管理', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (910, 0, '总管理员', '/settings/default/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (912, 0, '总管理员', '/settings/default/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (914, 0, '总管理员', '/settings/default/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (915, 0, '总管理员', '基础权限', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (916, 0, '总管理员', '/settings/default/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (917, 0, '总管理员', '/admin/assignment/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (918, 0, '总管理员', '/settings/default/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (919, 0, '总管理员', '订座', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (920, 0, '总管理员', '会员管理', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (921, 0, '总管理员', '测试实施', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (922, 0, '总管理员', '站点管理', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (923, 0, '总管理员', '系统设置', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (924, 0, '总管理员', '资源上传', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (925, 0, '总管理员', '人脸识别', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (926, 0, '总管理员', '开发示例', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (927, 0, '总管理员', '扩展功能', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (928, 0, '总管理员', '权限控制', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (929, 0, '总管理员', '模块生成', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (930, 0, '总管理员', '/settings/default/edit-setting', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (931, 0, '总管理员', '/settings/default/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (932, 0, '总管理员', '/settings/default/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (933, 0, '总管理员', '/settings/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (934, 0, '总管理员', '/admin/assignment/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (935, 0, '总管理员', '/admin/assignment/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (936, 0, '总管理员', '/admin/assignment/assign', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (937, 0, '总管理员', '/admin/assignment/revoke', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (938, 0, '总管理员', '/admin/assignment/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (939, 0, '总管理员', '/admin/baidu/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (940, 0, '总管理员', '/admin/baidu/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (941, 0, '总管理员', '/admin/baidu/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (942, 0, '总管理员', '/admin/baidu/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (943, 0, '总管理员', '/admin/baidu/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (944, 0, '总管理员', '/admin/baidu/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (945, 0, '总管理员', '/admin/baidu/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (946, 0, '总管理员', '/admin/bloc/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (947, 0, '总管理员', '/admin/bloc/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (948, 0, '总管理员', '/admin/bloc/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (949, 0, '总管理员', '/admin/bloc/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (950, 0, '总管理员', '/admin/bloc/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (951, 0, '总管理员', '/admin/bloc/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (952, 0, '总管理员', '/admin/default/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (953, 0, '总管理员', '/admin/default/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (954, 0, '总管理员', '/admin/default/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (955, 0, '总管理员', '/admin/email/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (956, 0, '总管理员', '/admin/email/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (957, 0, '总管理员', '/admin/email/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (958, 0, '总管理员', '/admin/email/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (959, 0, '总管理员', '/admin/email/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (960, 0, '总管理员', '/admin/email/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (961, 0, '总管理员', '/admin/email/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (962, 0, '总管理员', '/admin/group/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (963, 0, '总管理员', '/admin/group/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (964, 0, '总管理员', '/admin/group/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (965, 0, '总管理员', '/admin/group/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (966, 0, '总管理员', '/admin/group/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (967, 0, '总管理员', '/admin/group/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (968, 0, '总管理员', '/admin/group/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (969, 0, '总管理员', '/admin/menu/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (970, 0, '总管理员', '/admin/menu/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (971, 0, '总管理员', '/admin/menu/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (972, 0, '总管理员', '/admin/menu/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (973, 0, '总管理员', '/admin/menu/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (974, 0, '总管理员', '/admin/menu/update-files', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (975, 0, '总管理员', '/admin/menu/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (976, 0, '总管理员', '/admin/menu/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (977, 0, '总管理员', '/admin/menu-top/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (978, 0, '总管理员', '/admin/menu-top/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (979, 0, '总管理员', '/admin/menu-top/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (980, 0, '总管理员', '/admin/menu-top/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (981, 0, '总管理员', '/admin/menu-top/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (982, 0, '总管理员', '/admin/menu-top/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (983, 0, '总管理员', '/admin/permission/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (984, 0, '总管理员', '/admin/permission/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (985, 0, '总管理员', '/admin/permission/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (986, 0, '总管理员', '/admin/permission/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (987, 0, '总管理员', '/admin/permission/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (988, 0, '总管理员', '/admin/permission/assign', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (989, 0, '总管理员', '/admin/permission/remove', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (990, 0, '总管理员', '/admin/permission/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (991, 0, '总管理员', '/admin/role/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (992, 0, '总管理员', '/admin/role/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (993, 0, '总管理员', '/admin/role/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (994, 0, '总管理员', '/admin/role/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (995, 0, '总管理员', '/admin/role/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (996, 0, '总管理员', '/admin/role/assign', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (997, 0, '总管理员', '/admin/role/remove', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (998, 0, '总管理员', '/admin/role/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (999, 0, '总管理员', '/admin/route/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1000, 0, '总管理员', '/admin/route/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1001, 0, '总管理员', '/admin/route/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1002, 0, '总管理员', '/admin/route/assign', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1003, 0, '总管理员', '/admin/route/remove', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1004, 0, '总管理员', '/admin/route/refresh', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1005, 0, '总管理员', '/admin/route/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1006, 0, '总管理员', '/admin/rule/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1007, 0, '总管理员', '/admin/rule/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1008, 0, '总管理员', '/admin/rule/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1009, 0, '总管理员', '/admin/rule/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1010, 0, '总管理员', '/admin/rule/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1011, 0, '总管理员', '/admin/rule/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1012, 0, '总管理员', '/admin/rule/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1013, 0, '总管理员', '/admin/setting/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1014, 0, '总管理员', '/admin/sms/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1015, 0, '总管理员', '/admin/sms/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1016, 0, '总管理员', '/admin/sms/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1017, 0, '总管理员', '/admin/sms/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1018, 0, '总管理员', '/admin/sms/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1019, 0, '总管理员', '/admin/sms/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1020, 0, '总管理员', '/admin/sms/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1021, 0, '总管理员', '/admin/user-bloc/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1022, 0, '总管理员', '/admin/user/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1023, 0, '总管理员', '/admin/user/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1024, 0, '总管理员', '/admin/user/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1025, 0, '总管理员', '/admin/user/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1026, 0, '总管理员', '/admin/user/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1027, 0, '总管理员', '/admin/user/login', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1028, 0, '总管理员', '/admin/user/logout', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1029, 0, '总管理员', '/admin/user/signup', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1030, 0, '总管理员', '/admin/user/request-password-reset', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1031, 0, '总管理员', '/admin/user/reset-password', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1032, 0, '总管理员', '/admin/user/change-password', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1033, 0, '总管理员', '/admin/user/activate', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1034, 0, '总管理员', '/admin/user/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1035, 0, '总管理员', '/admin/wechatpay/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1036, 0, '总管理员', '/admin/wechatpay/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1037, 0, '总管理员', '/admin/wechatpay/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1038, 0, '总管理员', '/admin/wechatpay/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1039, 0, '总管理员', '/admin/wechatpay/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1040, 0, '总管理员', '/admin/wechatpay/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1041, 0, '总管理员', '/admin/wechatpay/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1042, 0, '总管理员', '/admin/wxapp/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1043, 0, '总管理员', '/admin/wxapp/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1044, 0, '总管理员', '/admin/wxapp/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1045, 0, '总管理员', '/admin/wxapp/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1046, 0, '总管理员', '/admin/wxapp/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1047, 0, '总管理员', '/admin/wxapp/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1048, 0, '总管理员', '/admin/wxapp/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1049, 0, '总管理员', '/admin/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1050, 0, '总管理员', '/modal/modal/website', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1051, 0, '总管理员', '/modal/modal/icons', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1052, 0, '总管理员', '/modal/modal/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1053, 0, '总管理员', '/modal/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1054, 0, '总管理员', '/addons/addons/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1055, 0, '总管理员', '/addons/addons/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1056, 0, '总管理员', '/addons/addons/uninstalled', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1057, 0, '总管理员', '/addons/addons/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1058, 0, '总管理员', '/addons/addons/logo', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1059, 0, '总管理员', '/addons/addons/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1060, 0, '总管理员', '/addons/addons/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1061, 0, '总管理员', '/addons/addons/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1062, 0, '总管理员', '/addons/addons/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1063, 0, '总管理员', '/addons/manage/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1064, 0, '总管理员', '/addons/manage/install', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1065, 0, '总管理员', '/addons/manage/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1066, 0, '总管理员', '/addons/manage/uninstall', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1067, 0, '总管理员', '/addons/manage/auth', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1068, 0, '总管理员', '/addons/manage/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1069, 0, '总管理员', '/addons/menu/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1070, 0, '总管理员', '/addons/menu/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1071, 0, '总管理员', '/addons/menu/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1072, 0, '总管理员', '/addons/menu/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1073, 0, '总管理员', '/addons/menu/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1074, 0, '总管理员', '/addons/menu/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1075, 0, '总管理员', '/addons/menu/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1076, 0, '总管理员', '/addons/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1077, 0, '总管理员', '/gii/default/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1078, 0, '总管理员', '/gii/default/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1079, 0, '总管理员', '/gii/default/preview', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1080, 0, '总管理员', '/gii/default/diff', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1081, 0, '总管理员', '/gii/default/action', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1082, 0, '总管理员', '/gii/default/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1083, 0, '总管理员', '/gii/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1084, 0, '总管理员', '/diandi_shop/default/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1085, 0, '总管理员', '/diandi_shop/default/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1086, 0, '总管理员', '/diandi_shop/default/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1087, 0, '总管理员', '/diandi_shop/goods/dd-category/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1088, 0, '总管理员', '/diandi_shop/goods/dd-category/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1089, 0, '总管理员', '/diandi_shop/goods/dd-category/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1090, 0, '总管理员', '/diandi_shop/goods/dd-category/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1091, 0, '总管理员', '/diandi_shop/goods/dd-category/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1092, 0, '总管理员', '/diandi_shop/goods/dd-category/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1093, 0, '总管理员', '/diandi_shop/goods/dd-category/childcate', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1094, 0, '总管理员', '/diandi_shop/goods/dd-category/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1095, 0, '总管理员', '/diandi_shop/goods/dd-goods/upload', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1096, 0, '总管理员', '/diandi_shop/goods/dd-goods/change-username', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1097, 0, '总管理员', '/diandi_shop/goods/dd-goods/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1098, 0, '总管理员', '/diandi_shop/goods/dd-goods/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1099, 0, '总管理员', '/diandi_shop/goods/dd-goods/validate', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1100, 0, '总管理员', '/diandi_shop/goods/dd-goods/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1101, 0, '总管理员', '/diandi_shop/goods/dd-goods/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1102, 0, '总管理员', '/diandi_shop/goods/dd-goods/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1103, 0, '总管理员', '/diandi_shop/goods/dd-goods/specitem', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1104, 0, '总管理员', '/diandi_shop/goods/dd-goods/param', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1105, 0, '总管理员', '/diandi_shop/goods/dd-goods/spec', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1106, 0, '总管理员', '/diandi_shop/goods/dd-goods/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1107, 0, '总管理员', '/diandi_shop/goods/label/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1108, 0, '总管理员', '/diandi_shop/goods/label/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1109, 0, '总管理员', '/diandi_shop/goods/label/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1110, 0, '总管理员', '/diandi_shop/goods/label/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1111, 0, '总管理员', '/diandi_shop/goods/label/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1112, 0, '总管理员', '/diandi_shop/goods/label/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1113, 0, '总管理员', '/diandi_shop/goods/label/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1114, 0, '总管理员', '/diandi_shop/order/dd-delivery/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1115, 0, '总管理员', '/diandi_shop/order/dd-delivery/get-region', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1116, 0, '总管理员', '/diandi_shop/order/dd-delivery/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1117, 0, '总管理员', '/diandi_shop/order/dd-delivery/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1118, 0, '总管理员', '/diandi_shop/order/dd-delivery/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1119, 0, '总管理员', '/diandi_shop/order/dd-delivery/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1120, 0, '总管理员', '/diandi_shop/order/dd-delivery/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1121, 0, '总管理员', '/diandi_shop/order/dd-delivery/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1122, 0, '总管理员', '/diandi_shop/order/dd-delivery-rule/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1123, 0, '总管理员', '/diandi_shop/order/dd-delivery-rule/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1124, 0, '总管理员', '/diandi_shop/order/dd-delivery-rule/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1125, 0, '总管理员', '/diandi_shop/order/dd-delivery-rule/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1126, 0, '总管理员', '/diandi_shop/order/dd-delivery-rule/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1127, 0, '总管理员', '/diandi_shop/order/dd-delivery-rule/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1128, 0, '总管理员', '/diandi_shop/order/dd-delivery-rule/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1129, 0, '总管理员', '/diandi_shop/order/dd-order/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1130, 0, '总管理员', '/diandi_shop/order/dd-order/get-region', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1131, 0, '总管理员', '/diandi_shop/order/dd-order/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1132, 0, '总管理员', '/diandi_shop/order/dd-order/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1133, 0, '总管理员', '/diandi_shop/order/dd-order/upaddress', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1134, 0, '总管理员', '/diandi_shop/order/dd-order/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1135, 0, '总管理员', '/diandi_shop/order/dd-order/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1136, 0, '总管理员', '/diandi_shop/order/dd-order/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1137, 0, '总管理员', '/diandi_shop/order/dd-order/confirm', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1138, 0, '总管理员', '/diandi_shop/order/dd-order/exportdata', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1139, 0, '总管理员', '/diandi_shop/order/dd-order/prints', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1140, 0, '总管理员', '/diandi_shop/order/dd-order/deletes', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1141, 0, '总管理员', '/diandi_shop/order/dd-order/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1142, 0, '总管理员', '/diandi_shop/setting/area/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1143, 0, '总管理员', '/diandi_shop/setting/area/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1144, 0, '总管理员', '/diandi_shop/setting/area/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1145, 0, '总管理员', '/diandi_shop/setting/area/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1146, 0, '总管理员', '/diandi_shop/setting/area/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1147, 0, '总管理员', '/diandi_shop/setting/area/setdefault', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1148, 0, '总管理员', '/diandi_shop/setting/area/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1149, 0, '总管理员', '/diandi_shop/setting/area/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1150, 0, '总管理员', '/diandi_shop/setting/comment/change-status', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1151, 0, '总管理员', '/diandi_shop/setting/comment/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1152, 0, '总管理员', '/diandi_shop/setting/comment/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1153, 0, '总管理员', '/diandi_shop/setting/comment/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1154, 0, '总管理员', '/diandi_shop/setting/comment/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1155, 0, '总管理员', '/diandi_shop/setting/comment/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1156, 0, '总管理员', '/diandi_shop/setting/comment/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1157, 0, '总管理员', '/diandi_shop/setting/store/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1158, 0, '总管理员', '/diandi_shop/setting/store/setting', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1159, 0, '总管理员', '/diandi_shop/setting/store/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1160, 0, '总管理员', '/diandi_shop/setting/store/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1161, 0, '总管理员', '/diandi_shop/setting/store/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1162, 0, '总管理员', '/diandi_shop/setting/store/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1163, 0, '总管理员', '/diandi_shop/setting/store/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1164, 0, '总管理员', '/diandi_shop/setting/store/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1165, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1166, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1167, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1168, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1169, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1170, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1171, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1172, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-help/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1173, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-help/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1174, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-help/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1175, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-help/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1176, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-help/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1177, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-help/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1178, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-help/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1179, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-navbar/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1180, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-navbar/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1181, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-navbar/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1182, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-navbar/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1183, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-navbar/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1184, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-navbar/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1185, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-navbar/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1186, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-page/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1187, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-slide/error', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1188, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-slide/index', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1189, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-slide/view', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1190, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-slide/create', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1191, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-slide/update', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1192, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-slide/delete', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1193, 0, '总管理员', '/diandi_shop/wxapp/dd-wxapp-slide/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1194, 0, '总管理员', '/diandi_shop/*', 'diandi_shop', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1195, 0, '总管理员', '/diandi_store/coupon/error', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1196, 0, '总管理员', '/diandi_store/coupon/index', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1197, 0, '总管理员', '/diandi_store/coupon/view', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1198, 0, '总管理员', '/diandi_store/coupon/create', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1199, 0, '总管理员', '/diandi_store/coupon/update', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1200, 0, '总管理员', '/diandi_store/coupon/delete', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1201, 0, '总管理员', '/diandi_store/coupon/*', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1202, 0, '总管理员', '/diandi_store/coupon-groups/error', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1203, 0, '总管理员', '/diandi_store/coupon-groups/index', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1204, 0, '总管理员', '/diandi_store/coupon-groups/view', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1205, 0, '总管理员', '/diandi_store/coupon-groups/create', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1206, 0, '总管理员', '/diandi_store/coupon-groups/update', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1207, 0, '总管理员', '/diandi_store/coupon-groups/delete', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1208, 0, '总管理员', '/diandi_store/coupon-groups/*', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1209, 0, '总管理员', '/diandi_store/coupon-record/error', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1210, 0, '总管理员', '/diandi_store/coupon-record/index', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1211, 0, '总管理员', '/diandi_store/coupon-record/view', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1212, 0, '总管理员', '/diandi_store/coupon-record/create', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1213, 0, '总管理员', '/diandi_store/coupon-record/update', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1214, 0, '总管理员', '/diandi_store/coupon-record/delete', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1215, 0, '总管理员', '/diandi_store/coupon-record/*', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1216, 0, '总管理员', '/diandi_store/default/error', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1217, 0, '总管理员', '/diandi_store/default/index', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1218, 0, '总管理员', '/diandi_store/default/*', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1219, 0, '总管理员', '/diandi_store/*', 'diandi_store', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1220, 0, '总管理员', '/base/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1221, 0, '总管理员', '/base/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1222, 0, '总管理员', '/module/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1223, 0, '总管理员', '/module/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1224, 0, '总管理员', '/module/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1225, 0, '总管理员', '/site/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1226, 0, '总管理员', '/site/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1227, 0, '总管理员', '/site/login', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1228, 0, '总管理员', '/site/logout', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1229, 0, '总管理员', '/site/signup', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1230, 0, '总管理员', '/site/request-password-reset', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1231, 0, '总管理员', '/site/reset-password', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1232, 0, '总管理员', '/site/verify-email', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1233, 0, '总管理员', '/site/resend-verification-email', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1234, 0, '总管理员', '/site/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1235, 0, '总管理员', '/article/dd-article-category/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1236, 0, '总管理员', '/article/dd-article-category/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1237, 0, '总管理员', '/article/dd-article-category/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1238, 0, '总管理员', '/article/dd-article-category/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1239, 0, '总管理员', '/article/dd-article-category/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1240, 0, '总管理员', '/article/dd-article-category/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1241, 0, '总管理员', '/article/dd-article-category/childcate', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1242, 0, '总管理员', '/article/dd-article-category/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1243, 0, '总管理员', '/article/dd-article/upload', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1244, 0, '总管理员', '/article/dd-article/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1245, 0, '总管理员', '/article/dd-article/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1246, 0, '总管理员', '/article/dd-article/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1247, 0, '总管理员', '/article/dd-article/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1248, 0, '总管理员', '/article/dd-article/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1249, 0, '总管理员', '/article/dd-article/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1250, 0, '总管理员', '/article/record/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1251, 0, '总管理员', '/article/record/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1252, 0, '总管理员', '/article/record/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1253, 0, '总管理员', '/article/record/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1254, 0, '总管理员', '/article/record/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1255, 0, '总管理员', '/article/record/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1256, 0, '总管理员', '/demo/form/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1257, 0, '总管理员', '/demo/form/get-region', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1258, 0, '总管理员', '/demo/form/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1259, 0, '总管理员', '/demo/form/maile', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1260, 0, '总管理员', '/demo/form/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1261, 0, '总管理员', '/diandiai/dd-ai-applications/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1262, 0, '总管理员', '/diandiai/dd-ai-applications/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1263, 0, '总管理员', '/diandiai/dd-ai-applications/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1264, 0, '总管理员', '/diandiai/dd-ai-applications/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1265, 0, '总管理员', '/diandiai/dd-ai-applications/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1266, 0, '总管理员', '/diandiai/dd-ai-applications/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1267, 0, '总管理员', '/diandiai/dd-ai-applications/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1268, 0, '总管理员', '/diandiai/dd-ai-faces/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1269, 0, '总管理员', '/diandiai/dd-ai-faces/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1270, 0, '总管理员', '/diandiai/dd-ai-faces/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1271, 0, '总管理员', '/diandiai/dd-ai-faces/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1272, 0, '总管理员', '/diandiai/dd-ai-faces/users', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1273, 0, '总管理员', '/diandiai/dd-ai-faces/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1274, 0, '总管理员', '/diandiai/dd-ai-faces/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1275, 0, '总管理员', '/diandiai/dd-ai-faces/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1276, 0, '总管理员', '/diandiai/dd-ai-groups/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1277, 0, '总管理员', '/diandiai/dd-ai-groups/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1278, 0, '总管理员', '/diandiai/dd-ai-groups/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1279, 0, '总管理员', '/diandiai/dd-ai-groups/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1280, 0, '总管理员', '/diandiai/dd-ai-groups/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1281, 0, '总管理员', '/diandiai/dd-ai-groups/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1282, 0, '总管理员', '/diandiai/dd-ai-groups/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1283, 0, '总管理员', '/diandiai/dd-ai-member/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1284, 0, '总管理员', '/diandiai/dd-ai-member/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1285, 0, '总管理员', '/diandiai/dd-ai-member/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1286, 0, '总管理员', '/diandiai/dd-ai-member/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1287, 0, '总管理员', '/diandiai/dd-ai-member/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1288, 0, '总管理员', '/diandiai/dd-ai-member/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1289, 0, '总管理员', '/diandiai/dd-ai-member/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1290, 0, '总管理员', '/member/dd-member/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1291, 0, '总管理员', '/member/dd-member/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1292, 0, '总管理员', '/member/dd-member/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1293, 0, '总管理员', '/member/dd-member/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1294, 0, '总管理员', '/member/dd-member/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1295, 0, '总管理员', '/member/dd-member/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1296, 0, '总管理员', '/member/dd-member/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1297, 0, '总管理员', '/member/dd-member-group/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1298, 0, '总管理员', '/member/dd-member-group/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1299, 0, '总管理员', '/member/dd-member-group/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1300, 0, '总管理员', '/member/dd-member-group/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1301, 0, '总管理员', '/member/dd-member-group/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1302, 0, '总管理员', '/member/dd-member-group/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1303, 0, '总管理员', '/member/dd-member-group/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1304, 0, '总管理员', '/system/index/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1305, 0, '总管理员', '/system/index/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1306, 0, '总管理员', '/system/index/childcate', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1307, 0, '总管理员', '/system/index/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1308, 0, '总管理员', '/system/settings/baidu', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1309, 0, '总管理员', '/system/settings/wxapp', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1310, 0, '总管理员', '/system/settings/wechatpay', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1311, 0, '总管理员', '/system/settings/weburl', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1312, 0, '总管理员', '/system/settings/sms', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1313, 0, '总管理员', '/system/settings/email', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1314, 0, '总管理员', '/system/settings/clear-cache', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1315, 0, '总管理员', '/system/settings/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1316, 0, '总管理员', '/system/welcome/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1317, 0, '总管理员', '/system/welcome/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1318, 0, '总管理员', '/system/welcome/sysai', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1319, 0, '总管理员', '/system/welcome/member', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1320, 0, '总管理员', '/system/welcome/aimember', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1321, 0, '总管理员', '/system/welcome/goods', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1322, 0, '总管理员', '/system/welcome/marketing', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1323, 0, '总管理员', '/system/welcome/order', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1324, 0, '总管理员', '/system/welcome/wxapp', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1325, 0, '总管理员', '/system/welcome/plugins', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1326, 0, '总管理员', '/system/welcome/system', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1327, 0, '总管理员', '/system/welcome/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1328, 0, '总管理员', '/upload/upload/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1329, 0, '总管理员', '/upload/upload/uploadimg', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1330, 0, '总管理员', '/upload/upload/uploadfile', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1331, 0, '总管理员', '/upload/upload/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1332, 0, '总管理员', '/user/dd-user/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1333, 0, '总管理员', '/user/dd-user/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1334, 0, '总管理员', '/user/dd-user/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1335, 0, '总管理员', '/user/dd-user/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1336, 0, '总管理员', '/user/dd-user/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1337, 0, '总管理员', '/user/dd-user/profile', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1338, 0, '总管理员', '/user/dd-user/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1339, 0, '总管理员', '/user/dd-user/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1340, 0, '总管理员', '/website/dd-website-contact/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1341, 0, '总管理员', '/website/dd-website-contact/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1342, 0, '总管理员', '/website/dd-website-contact/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1343, 0, '总管理员', '/website/dd-website-contact/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1344, 0, '总管理员', '/website/dd-website-contact/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1345, 0, '总管理员', '/website/dd-website-contact/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1346, 0, '总管理员', '/website/dd-website-contact/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1347, 0, '总管理员', '/website/dd-website-slide/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1348, 0, '总管理员', '/website/dd-website-slide/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1349, 0, '总管理员', '/website/dd-website-slide/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1350, 0, '总管理员', '/website/dd-website-slide/create', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1351, 0, '总管理员', '/website/dd-website-slide/update', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1352, 0, '总管理员', '/website/dd-website-slide/delete', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1353, 0, '总管理员', '/website/dd-website-slide/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1354, 0, '总管理员', '/website/setting/website', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1355, 0, '总管理员', '/website/setting/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1356, 0, '总管理员', '/*', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1357, 0, '总管理员', '/admin/group/assign', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1358, 0, '总管理员', '/admin/group/remove', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1359, 0, '基础权限组', '资源上传', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (1360, 0, '基础权限组', '基础权限', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (1408, 0, '管理员管理', '/admin/user/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1409, 0, '管理员管理', '/admin/user/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1410, 0, '管理员管理', '/admin/user/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1411, 0, '管理员管理', '/admin/user/view', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1412, 0, '管理员管理', '/admin/user/delete', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1413, 0, '模块统一入口', '/module/error', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1414, 0, '模块统一入口', '/module/index', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1415, 0, '模块统一入口', '/module/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1416, 0, '总管理员', '模块统一入口', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (1417, 0, '总管理员', '管理员管理', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (1418, 0, '总管理员', '基础权限组', 'sys', 2, 2);
INSERT INTO `dd_auth_item_child` VALUES (1420, 0, '基础权限', '资源上传', 'sys', 1, 1);
INSERT INTO `dd_auth_item_child` VALUES (1421, 0, '基础权限', '模块统一入口', 'sys', 1, 1);
INSERT INTO `dd_auth_item_child` VALUES (1447, 0, '人脸库管理', '人脸识别', 'sys', 1, 1);
INSERT INTO `dd_auth_item_child` VALUES (1453, 0, '人脸库管理', '/settings/default/*', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1454, 0, '人脸库管理', '/settings/default/update', 'sys', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1457, 0, '扩展功能', '模块统一入口', 'sys', 1, 1);
INSERT INTO `dd_auth_item_child` VALUES (1458, 0, '基础权限组', '/addons/addons/index', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1460, 0, '基础权限组', '模块统一入口', 'sys', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (1461, 0, '基础权限组', '/addons/addons/error', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1462, 0, '基础权限组', '/addons/addons/view', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1463, 0, '基础权限组', '/addons/addons/logo', 'sys', 0, 2);
INSERT INTO `dd_auth_item_child` VALUES (1464, 0, '订单操作', '测试', 'sys', 1, 1);
INSERT INTO `dd_auth_item_child` VALUES (1465, 0, '订单操作', '/diandi_shop/order/dd-order/error', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1466, 0, '订单操作', '/diandi_shop/order/dd-order/get-region', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1467, 0, '订单操作', '/diandi_shop/order/dd-order/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1468, 0, '订单操作', '/diandi_shop/order/dd-order/view', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1469, 0, '订单操作', '/diandi_shop/order/dd-order/upaddress', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1470, 0, '订单操作', '/diandi_shop/order/dd-order/create', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1471, 0, '订单操作', '/diandi_shop/order/dd-order/update', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1472, 0, '订单操作', '/diandi_shop/order/dd-order/delete', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1473, 0, '订单操作', '/diandi_shop/order/dd-order/confirm', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1474, 0, '订单操作', '/diandi_shop/order/dd-order/exportdata', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1475, 0, '订单操作', '/diandi_shop/order/dd-order/prints', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1476, 0, '订单操作', '/diandi_shop/order/dd-order/deletes', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1477, 0, '订单操作', '/diandi_shop/order/dd-order/*', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1478, 1, '店滴商城-运维', '订单操作', 'diandi_shop', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (1483, 1, '店滴商城-运维', '订单管理', 'diandi_shop', 1, 2);
INSERT INTO `dd_auth_item_child` VALUES (1484, 0, '默认入口', '/diandi_shop/default/error', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1485, 0, '默认入口', '/diandi_shop/default/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1486, 0, '默认入口', '/diandi_shop/default/*', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1487, 0, '商品管理', '/diandi_shop/goods/dd-goods/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1488, 0, '商品管理', '/diandi_shop/goods/dd-goods/view', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1489, 0, '商品管理', '/diandi_shop/goods/dd-goods/update', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1490, 0, '商家', '/diandi_shop/setting/store/error', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1491, 0, '商家', '/diandi_shop/setting/store/setting', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1492, 0, '商家', '/diandi_shop/setting/store/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1493, 0, '商家', '/diandi_shop/setting/store/view', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1494, 0, '商家', '/diandi_shop/setting/store/create', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1495, 0, '商家', '/diandi_shop/setting/store/update', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1496, 0, '商家', '/diandi_shop/setting/store/delete', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1497, 0, '商家', '/diandi_shop/setting/store/*', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1498, 0, '基础权限组', '/system/settings/set-cache', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1499, 0, '测试', '/system/settings/set-cache', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1500, 1, '配置权限', '/diandi_distribution/default/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1501, 1, '配置权限', '/diandi_distribution/default/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1502, 1, '配置权限', '/diandi_distribution/default/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1503, 1, '配置权限', '/diandi_distribution/conf/price-conf/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1504, 1, '配置权限', '/diandi_distribution/conf/price-conf/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1505, 1, '配置权限', '/diandi_distribution/conf/price-conf/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1506, 1, '配置权限', '/diandi_distribution/conf/price-conf/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1507, 1, '配置权限', '/diandi_distribution/conf/price-conf/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1508, 1, '配置权限', '/diandi_distribution/conf/price-conf/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1509, 1, '配置权限', '/diandi_distribution/conf/price-conf/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1510, 1, '配置权限', '/diandi_distribution/level/level/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1511, 1, '配置权限', '/diandi_distribution/level/level/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1512, 1, '配置权限', '/diandi_distribution/level/level/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1513, 1, '配置权限', '/diandi_distribution/level/level/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1514, 1, '配置权限', '/diandi_distribution/level/level/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1515, 1, '配置权限', '/diandi_distribution/level/level/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1516, 1, '配置权限', '/diandi_distribution/level/level/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1517, 1, '配置权限', '/diandi_distribution/level/member-level/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1518, 1, '配置权限', '/diandi_distribution/level/member-level/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1519, 1, '配置权限', '/diandi_distribution/level/member-level/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1520, 1, '配置权限', '/diandi_distribution/level/member-level/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1521, 1, '配置权限', '/diandi_distribution/level/member-level/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1522, 1, '配置权限', '/diandi_distribution/level/member-level/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1523, 1, '配置权限', '/diandi_distribution/level/member-level/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1524, 1, '配置权限', '/diandi_distribution/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1525, 1, '配置权限', '/diandi_distribution/conf/price-conf/change-use', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1526, 1, '配置权限', '/diandi_distribution/level/price-conf/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1527, 1, '配置权限', '/diandi_distribution/level/price-conf/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1528, 1, '配置权限', '/diandi_distribution/level/price-conf/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1529, 1, '配置权限', '/diandi_distribution/level/price-conf/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1530, 1, '配置权限', '/diandi_distribution/level/price-conf/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1531, 1, '配置权限', '/diandi_distribution/level/price-conf/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1532, 1, '配置权限', '/diandi_distribution/level/price-conf/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1533, 1, '配置权限', '/diandi_distribution/conf/slide/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1534, 1, '配置权限', '/diandi_distribution/conf/slide/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1535, 1, '配置权限', '/diandi_distribution/conf/slide/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1536, 1, '配置权限', '/diandi_distribution/conf/slide/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1537, 1, '配置权限', '/diandi_distribution/conf/slide/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1538, 1, '配置权限', '/diandi_distribution/conf/slide/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1539, 1, '配置权限', '/diandi_distribution/conf/slide/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1540, 1, '分销商品管理', '/diandi_distribution/goods/gift/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1541, 1, '分销商品管理', '/diandi_distribution/goods/gift/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1542, 1, '分销商品管理', '/diandi_distribution/goods/gift/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1543, 1, '分销商品管理', '/diandi_distribution/goods/gift/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1544, 1, '分销商品管理', '/diandi_distribution/goods/gift/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1545, 1, '分销商品管理', '/diandi_distribution/goods/gift/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1546, 1, '分销商品管理', '/diandi_distribution/goods/gift/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1547, 1, '分销商品管理', '/diandi_distribution/goods/goods/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1548, 1, '分销商品管理', '/diandi_distribution/goods/goods/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1549, 1, '分销商品管理', '/diandi_distribution/goods/goods/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1550, 1, '分销商品管理', '/diandi_distribution/goods/goods/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1551, 1, '分销商品管理', '/diandi_distribution/goods/goods/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1552, 1, '分销商品管理', '/diandi_distribution/goods/goods/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1553, 1, '分销商品管理', '/diandi_distribution/goods/goods/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1554, 1, '分销商品管理', '/diandi_distribution/goods/location/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1555, 1, '分销商品管理', '/diandi_distribution/goods/location/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1556, 1, '分销商品管理', '/diandi_distribution/goods/location/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1557, 1, '分销商品管理', '/diandi_distribution/goods/location/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1558, 1, '分销商品管理', '/diandi_distribution/goods/location/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1559, 1, '分销商品管理', '/diandi_distribution/goods/location/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1560, 1, '分销商品管理', '/diandi_distribution/goods/location/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1561, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1562, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1563, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1564, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1565, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1566, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1567, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1568, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/goodslocation', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1569, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/goodslist', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1570, 1, '分销商品管理', '/diandi_distribution/goods/location-goods/advlist', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1571, 1, '评论管理', '/diandi_shop/setting/comment/change-status', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1572, 1, '评论管理', '/diandi_shop/setting/comment/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1573, 1, '评论管理', '/diandi_shop/setting/comment/view', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1574, 1, '评论管理', '/diandi_shop/setting/comment/create', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1575, 1, '评论管理', '/diandi_shop/setting/comment/update', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1576, 1, '评论管理', '/diandi_shop/setting/comment/delete', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1577, 1, '评论管理', '/diandi_shop/setting/comment/*', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1578, 1, '配送点管理', '/diandi_shop/setting/area/error', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1579, 1, '配送点管理', '/diandi_shop/setting/area/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1580, 1, '配送点管理', '/diandi_shop/setting/area/view', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1581, 1, '配送点管理', '/diandi_shop/setting/area/create', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1582, 1, '配送点管理', '/diandi_shop/setting/area/update', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1583, 1, '配送点管理', '/diandi_shop/setting/area/setdefault', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1584, 1, '配送点管理', '/diandi_shop/setting/area/delete', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1585, 1, '配送点管理', '/diandi_shop/setting/area/*', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1586, 1, '商品标签管理', '/diandi_shop/goods/label/error', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1587, 1, '商品标签管理', '/diandi_shop/goods/label/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1588, 1, '商品标签管理', '/diandi_shop/goods/label/view', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1589, 1, '商品标签管理', '/diandi_shop/goods/label/create', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1590, 1, '商品标签管理', '/diandi_shop/goods/label/update', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1591, 1, '商品标签管理', '/diandi_shop/goods/label/delete', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1592, 1, '商品标签管理', '/diandi_shop/goods/label/getlist', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1593, 1, '商品标签管理', '/diandi_shop/goods/label/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1594, 1, '商品管理', '/diandi_shop/goods/dd-goods/upload', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1595, 1, '商品管理', '/diandi_shop/goods/dd-goods/change-username', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1596, 1, '商品管理', '/diandi_shop/goods/dd-goods/validate', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1597, 1, '商品管理', '/diandi_shop/goods/dd-goods/create', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1598, 1, '商品管理', '/diandi_shop/goods/dd-goods/delete', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1599, 1, '商品管理', '/diandi_shop/goods/dd-goods/specitem', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1600, 1, '商品管理', '/diandi_shop/goods/dd-goods/param', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1601, 1, '商品管理', '/diandi_shop/goods/dd-goods/spec', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1602, 1, '商品管理', '/diandi_shop/goods/dd-goods/*', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1603, 1, '商品分类', '/diandi_shop/goods/dd-category/error', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1604, 1, '商品分类', '/diandi_shop/goods/dd-category/index', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1605, 1, '商品分类', '/diandi_shop/goods/dd-category/view', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1606, 1, '商品分类', '/diandi_shop/goods/dd-category/create', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1607, 1, '商品分类', '/diandi_shop/goods/dd-category/update', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1608, 1, '商品分类', '/diandi_shop/goods/dd-category/delete', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1609, 1, '商品分类', '/diandi_shop/goods/dd-category/childcate', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1610, 1, '商品分类', '/diandi_shop/goods/dd-category/*', 'diandi_shop', 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1611, 1, '抽奖权限', '/diandi_lottery/active/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1612, 1, '抽奖权限', '/diandi_lottery/active/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1613, 1, '抽奖权限', '/diandi_lottery/active/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1614, 1, '抽奖权限', '/diandi_lottery/active/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1615, 1, '抽奖权限', '/diandi_lottery/active/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1616, 1, '抽奖权限', '/diandi_lottery/active/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1617, 1, '抽奖权限', '/diandi_lottery/active/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1618, 1, '抽奖权限', '/diandi_lottery/contact/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1619, 1, '抽奖权限', '/diandi_lottery/contact/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1620, 1, '抽奖权限', '/diandi_lottery/contact/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1621, 1, '抽奖权限', '/diandi_lottery/contact/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1622, 1, '抽奖权限', '/diandi_lottery/contact/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1623, 1, '抽奖权限', '/diandi_lottery/contact/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1624, 1, '抽奖权限', '/diandi_lottery/contact/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1625, 1, '抽奖权限', '/diandi_lottery/default/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1626, 1, '抽奖权限', '/diandi_lottery/default/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1627, 1, '抽奖权限', '/diandi_lottery/default/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1628, 1, '抽奖权限', '/diandi_lottery/prize/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1629, 1, '抽奖权限', '/diandi_lottery/prize/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1630, 1, '抽奖权限', '/diandi_lottery/prize/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1631, 1, '抽奖权限', '/diandi_lottery/prize/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1632, 1, '抽奖权限', '/diandi_lottery/prize/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1633, 1, '抽奖权限', '/diandi_lottery/prize/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1634, 1, '抽奖权限', '/diandi_lottery/prize/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1635, 1, '抽奖权限', '/diandi_lottery/slide/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1636, 1, '抽奖权限', '/diandi_lottery/slide/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1637, 1, '抽奖权限', '/diandi_lottery/slide/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1638, 1, '抽奖权限', '/diandi_lottery/slide/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1639, 1, '抽奖权限', '/diandi_lottery/slide/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1640, 1, '抽奖权限', '/diandi_lottery/slide/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1641, 1, '抽奖权限', '/diandi_lottery/slide/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1642, 1, '抽奖权限', '/diandi_lottery/template/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1643, 1, '抽奖权限', '/diandi_lottery/template/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1644, 1, '抽奖权限', '/diandi_lottery/template/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1645, 1, '抽奖权限', '/diandi_lottery/template/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1646, 1, '抽奖权限', '/diandi_lottery/template/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1647, 1, '抽奖权限', '/diandi_lottery/template/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1648, 1, '抽奖权限', '/diandi_lottery/template/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1649, 1, '抽奖权限', '/diandi_lottery/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1650, 1, '抽奖权限', '/diandi_lottery/prizewin/error', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1651, 1, '抽奖权限', '/diandi_lottery/prizewin/index', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1652, 1, '抽奖权限', '/diandi_lottery/prizewin/view', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1653, 1, '抽奖权限', '/diandi_lottery/prizewin/create', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1654, 1, '抽奖权限', '/diandi_lottery/prizewin/update', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1655, 1, '抽奖权限', '/diandi_lottery/prizewin/delete', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1656, 1, '抽奖权限', '/diandi_lottery/prizewin/*', NULL, 0, 1);
INSERT INTO `dd_auth_item_child` VALUES (1657, 0, '基础权限组', '/system/settings/clear-cache', 'sys', 0, 1);

-- ----------------------------
-- Table structure for dd_auth_item_copy1
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_item_copy1`;
CREATE TABLE `dd_auth_item_copy1`  (
  `id` int(11) NOT NULL,
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `type` smallint(6) NOT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `rule_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `parent_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `data` blob NULL,
  `module_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`name`, `id`) USING BTREE,
  INDEX `rule_name`(`rule_name`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  CONSTRAINT `dd_auth_item_copy1_ibfk_1` FOREIGN KEY (`rule_name`) REFERENCES `dd_auth_rule` (`name`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_item_copy1
-- ----------------------------
INSERT INTO `dd_auth_item_copy1` VALUES (0, '人脸库管理', 0, NULL, NULL, '0', NULL, 'sys', 1582139590, 1582141243);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '人脸识别', 0, NULL, NULL, '0', NULL, 'sys', 1582139583, 1582141300);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '会员管理', 0, NULL, NULL, '0', NULL, 'sys', 1582139598, 1582139598);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '基础权限', 0, NULL, NULL, '0', NULL, 'sys', 1585578773, 1585578773);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '店滴会员卡', 1, NULL, NULL, '0', NULL, 'diandi_shop', 1588923080, 1588923080);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '开发示例', 0, NULL, NULL, '0', NULL, 'sys', 1585611530, 1585611530);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '扩展功能', 0, NULL, NULL, '0', NULL, 'sys', 1582139605, 1582139605);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '权限控制', 0, NULL, NULL, '0', NULL, 'sys', 1582139364, 1582139364);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '模块生成', 0, NULL, NULL, '0', NULL, 'sys', 1585473562, 1585473562);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '模块统一入口', 0, NULL, NULL, '0', NULL, '', 1588808930, 1588808930);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '测试', 0, NULL, NULL, '人脸识别', NULL, 'sys', 1588851182, 1588851182);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '测试实施', 0, NULL, NULL, '人脸库管理', NULL, 'sys', 1588573267, 1588573267);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '站点管理', 0, NULL, NULL, '0', NULL, 'sys', 1582139575, 1582139575);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '管理员管理', 0, NULL, NULL, '0', NULL, '', 1588779477, 1588779477);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '系统设置', 0, NULL, NULL, '0', NULL, 'sys', 1582139568, 1582139568);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '订单操作', 1, NULL, NULL, '订单管理', NULL, 'diandi_shop', 1588927818, 1588927818);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '订单管理', 1, NULL, NULL, '店滴会员卡', NULL, 'diandi_shop', 1588927400, 1588927400);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '订座', 0, NULL, NULL, '0', NULL, 'sys', 1585413762, 1585413762);
INSERT INTO `dd_auth_item_copy1` VALUES (0, '资源上传', 0, NULL, NULL, '0', NULL, 'sys', 1585451956, 1585451956);

-- ----------------------------
-- Table structure for dd_auth_menu
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_menu`;
CREATE TABLE `dd_auth_menu`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `parent` int(11) NULL DEFAULT NULL,
  `route` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `order` int(11) NULL DEFAULT 0,
  `data` blob NULL,
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `icon` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `is_sys` enum('system','addons') CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'system',
  `module_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `parent`(`parent`) USING BTREE,
  CONSTRAINT `dd_auth_menu_ibfk_1` FOREIGN KEY (`parent`) REFERENCES `dd_menu` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 246 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_menu
-- ----------------------------
INSERT INTO `dd_auth_menu` VALUES (1, '权限管理', NULL, '/admin/default/index', 3, NULL, 'sysai', 'fa fa-fw fa-sitemap', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (2, '权限维护', 1, '/admin/permission/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (3, '菜单路由', 1, '/admin/route/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (4, '用户组', 27, '/admin/role/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (5, '权限分配', 1, '/admin/assignment/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (6, '系统菜单', 1, '/admin/menu/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (9, '权限规则', 1, '/admin/rule/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (11, '系统设置', 75, '/system/settings/weburl', 1, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (12, '扩展功能', NULL, NULL, 7, NULL, 'plugins', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (25, '会员管理', NULL, '/member/dd-member/index', NULL, NULL, 'member', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (26, 'AI会员管理', 33, '/diandiai/dd-ai-member/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (27, '管理员管理', NULL, NULL, 2, NULL, 'sysai', 'glyphicon glyphicon-th-large', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (28, '管理员', 27, '/admin/user/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (33, '人脸识别', NULL, '/diandiai/dd-ai-member/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (35, '人脸库管理', NULL, '/diandiai/dd-ai-faces/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (36, '应用管理', 35, '/diandiai/dd-ai-applications/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (37, '人脸库分组', 35, '/diandiai/dd-ai-groups/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (38, '人脸管理', 35, '/diandiai/dd-ai-faces/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (39, '站点管理', NULL, '/website/dd-website-slide/index', 1, NULL, 'sysai', 'fa fa-fw fa-cubes', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (40, '幻灯片', 39, '/website/dd-website-slide/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (41, '文章管理', 39, '/article/dd-article/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (42, '文章分类', 41, '/article/dd-article-category/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (43, '文章列表', 41, '/article/dd-article/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (44, '联系我们', 39, '/website/dd-website-contact/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (45, '顶部导航', 1, '/admin/menu-top/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (46, '会员管理', 25, '/member/dd-member/index', NULL, NULL, 'member', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (49, '会员等级', 25, '/member/dd-member-group/index', NULL, NULL, 'member', '', 'system', NULL);
INSERT INTO `dd_auth_menu` VALUES (58, '店滴商城', NULL, '/diandi_shop/default/index', NULL, NULL, 'plugins', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (60, '商品管理', 63, '/diandi_shop/goods/dd-goods/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (61, '商品分类', 63, '/diandi_shop/goods/dd-category/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (62, '订单管理', NULL, NULL, 4, NULL, 'plugins', 'fa fa-fw fa-list', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (63, '商品管理', NULL, NULL, 3, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (64, '订单管理', 62, '/diandi_shop/order/dd-order/index', NULL, NULL, 'plugins', 'fa fa-fw fa-clone', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (69, '商家设置', NULL, '/diandi_shop/setting/store/index', 2, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (70, '商家设置', 69, '/diandi_shop/setting/store/setting', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (71, '评论管理', 69, '/diandi_shop/setting/comment/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (74, '配送点管理', 69, '/diandi_shop/setting/area/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (75, '系统管理', NULL, NULL, 4, NULL, 'sysai', 'fa fa-fw fa-cogs', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (76, '扩展模块', 75, '/addons/addons/index', 2, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (197, '站点设置', 39, '/website/setting/website', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (221, '商品标签', 63, '/diandi_shop/goods/label/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_auth_menu` VALUES (222, '公司管理', 75, '/bloc/bloc/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (223, '开发示例', NULL, NULL, 5, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (224, '表单示例', 223, '/demo/form/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (225, '商家管理', NULL, '/diandi_store/default/index', NULL, NULL, 'plugins', '', 'system', '');
INSERT INTO `dd_auth_menu` VALUES (227, '基础设置', NULL, '/diandi_store/slide/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (228, '幻灯片', NULL, '/diandi_store/store-slide/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (229, '商家管理', NULL, '/diandi_store/store/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (230, '商家座位', NULL, '/diandi_store/store-seat/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (232, '服务管理', NULL, '/diandi_store/store-service/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (242, '营销管理', NULL, '/diandi_store/coupon/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (243, '优惠券分类', NULL, '/diandi_store/coupon-groups/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (244, '优惠券', NULL, '/diandi_store/coupon/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');
INSERT INTO `dd_auth_menu` VALUES (245, '领取记录', NULL, '/diandi_store/coupon-record/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_store');

-- ----------------------------
-- Table structure for dd_auth_route
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_route`;
CREATE TABLE `dd_auth_route`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `type` smallint(6) NOT NULL,
  `description` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `title` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `pid` int(11) NULL DEFAULT 0,
  `data` blob NULL,
  `module_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `name`) USING BTREE,
  UNIQUE INDEX `name`(`name`) USING BTREE,
  INDEX `rule_name`(`title`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  CONSTRAINT `dd_auth_route_ibfk_1` FOREIGN KEY (`title`) REFERENCES `dd_auth_rule` (`name`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE = InnoDB AUTO_INCREMENT = 704 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_route
-- ----------------------------
INSERT INTO `dd_auth_route` VALUES (3, '/settings/default/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634163, 1588634163);
INSERT INTO `dd_auth_route` VALUES (5, '/settings/default/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (6, '/settings/default/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (7, '/settings/default/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (8, '/settings/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (9, '/admin/assignment/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (10, '/admin/assignment/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (11, '/admin/assignment/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (12, '/admin/assignment/assign', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (13, '/admin/assignment/revoke', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (14, '/admin/assignment/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (15, '/admin/baidu/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (16, '/admin/baidu/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634166, 1588634166);
INSERT INTO `dd_auth_route` VALUES (17, '/admin/baidu/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (18, '/admin/baidu/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (19, '/admin/baidu/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (20, '/admin/baidu/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (21, '/admin/baidu/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (22, '/admin/bloc/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (23, '/admin/bloc/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (24, '/admin/bloc/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (25, '/admin/bloc/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (26, '/admin/bloc/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (27, '/admin/bloc/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (28, '/admin/default/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (29, '/admin/default/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (30, '/admin/default/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (31, '/admin/email/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (32, '/admin/email/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (33, '/admin/email/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (34, '/admin/email/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (35, '/admin/email/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (36, '/admin/email/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (37, '/admin/email/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (38, '/admin/group/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (39, '/admin/group/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (40, '/admin/group/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (41, '/admin/group/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (42, '/admin/group/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634167, 1588634167);
INSERT INTO `dd_auth_route` VALUES (43, '/admin/group/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (44, '/admin/group/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (45, '/admin/menu/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (46, '/admin/menu/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (47, '/admin/menu/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (48, '/admin/menu/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (49, '/admin/menu/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (50, '/admin/menu/update-files', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (51, '/admin/menu/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (52, '/admin/menu/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (53, '/admin/menu-top/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (54, '/admin/menu-top/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (55, '/admin/menu-top/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (56, '/admin/menu-top/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (57, '/admin/menu-top/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (58, '/admin/menu-top/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (59, '/admin/permission/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (60, '/admin/permission/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (61, '/admin/permission/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (62, '/admin/permission/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (63, '/admin/permission/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (64, '/admin/permission/assign', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (65, '/admin/permission/remove', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (66, '/admin/permission/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (67, '/admin/role/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (68, '/admin/role/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (69, '/admin/role/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (70, '/admin/role/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634168, 1588634168);
INSERT INTO `dd_auth_route` VALUES (71, '/admin/role/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (72, '/admin/role/assign', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (73, '/admin/role/remove', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (74, '/admin/role/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (75, '/admin/route/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (76, '/admin/route/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (77, '/admin/route/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (78, '/admin/route/assign', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (79, '/admin/route/remove', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (80, '/admin/route/refresh', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (81, '/admin/route/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (82, '/admin/rule/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (83, '/admin/rule/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (84, '/admin/rule/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (85, '/admin/rule/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (86, '/admin/rule/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (87, '/admin/rule/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (88, '/admin/rule/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (89, '/admin/setting/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (90, '/admin/sms/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (91, '/admin/sms/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (92, '/admin/sms/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (93, '/admin/sms/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (94, '/admin/sms/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (95, '/admin/sms/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (96, '/admin/sms/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (97, '/admin/user-bloc/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634169, 1588634169);
INSERT INTO `dd_auth_route` VALUES (98, '/admin/user/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (99, '/admin/user/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (100, '/admin/user/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (101, '/admin/user/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (102, '/admin/user/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (103, '/admin/user/login', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (104, '/admin/user/logout', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (105, '/admin/user/signup', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (106, '/admin/user/request-password-reset', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (107, '/admin/user/reset-password', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (108, '/admin/user/change-password', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (109, '/admin/user/activate', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (110, '/admin/user/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (111, '/admin/wechatpay/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (112, '/admin/wechatpay/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (113, '/admin/wechatpay/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (114, '/admin/wechatpay/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (115, '/admin/wechatpay/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (116, '/admin/wechatpay/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (117, '/admin/wechatpay/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (118, '/admin/wxapp/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (119, '/admin/wxapp/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (120, '/admin/wxapp/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (121, '/admin/wxapp/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (122, '/admin/wxapp/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (123, '/admin/wxapp/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (124, '/admin/wxapp/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (125, '/admin/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (126, '/modal/modal/website', 0, NULL, NULL, 0, NULL, 'sys', 1588634170, 1588634170);
INSERT INTO `dd_auth_route` VALUES (127, '/modal/modal/icons', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (128, '/modal/modal/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (129, '/modal/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (130, '/addons/addons/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (131, '/addons/addons/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (132, '/addons/addons/uninstalled', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (133, '/addons/addons/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (134, '/addons/addons/logo', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (135, '/addons/addons/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (136, '/addons/addons/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (137, '/addons/addons/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (138, '/addons/addons/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (139, '/addons/manage/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (140, '/addons/manage/install', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (141, '/addons/manage/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (142, '/addons/manage/uninstall', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (143, '/addons/manage/auth', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (144, '/addons/manage/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (145, '/addons/menu/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (146, '/addons/menu/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (147, '/addons/menu/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (148, '/addons/menu/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (149, '/addons/menu/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (150, '/addons/menu/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (151, '/addons/menu/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (152, '/addons/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634171, 1588634171);
INSERT INTO `dd_auth_route` VALUES (153, '/gii/default/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (154, '/gii/default/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (155, '/gii/default/preview', 0, NULL, NULL, 0, NULL, 'sys', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (156, '/gii/default/diff', 0, NULL, NULL, 0, NULL, 'sys', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (157, '/gii/default/action', 0, NULL, NULL, 0, NULL, 'sys', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (158, '/gii/default/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (159, '/gii/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (160, '/diandi_shop/default/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (161, '/diandi_shop/default/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (162, '/diandi_shop/default/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (163, '/diandi_shop/goods/dd-category/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (164, '/diandi_shop/goods/dd-category/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (165, '/diandi_shop/goods/dd-category/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (166, '/diandi_shop/goods/dd-category/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (167, '/diandi_shop/goods/dd-category/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (168, '/diandi_shop/goods/dd-category/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (169, '/diandi_shop/goods/dd-category/childcate', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (170, '/diandi_shop/goods/dd-category/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (171, '/diandi_shop/goods/dd-goods/upload', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (172, '/diandi_shop/goods/dd-goods/change-username', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (173, '/diandi_shop/goods/dd-goods/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (174, '/diandi_shop/goods/dd-goods/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (175, '/diandi_shop/goods/dd-goods/validate', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (176, '/diandi_shop/goods/dd-goods/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (177, '/diandi_shop/goods/dd-goods/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (178, '/diandi_shop/goods/dd-goods/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (179, '/diandi_shop/goods/dd-goods/specitem', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (180, '/diandi_shop/goods/dd-goods/param', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (181, '/diandi_shop/goods/dd-goods/spec', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634172, 1588634172);
INSERT INTO `dd_auth_route` VALUES (182, '/diandi_shop/goods/dd-goods/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (183, '/diandi_shop/goods/label/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (184, '/diandi_shop/goods/label/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (185, '/diandi_shop/goods/label/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (186, '/diandi_shop/goods/label/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (187, '/diandi_shop/goods/label/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (188, '/diandi_shop/goods/label/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (190, '/diandi_shop/order/dd-delivery/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (191, '/diandi_shop/order/dd-delivery/get-region', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (192, '/diandi_shop/order/dd-delivery/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (193, '/diandi_shop/order/dd-delivery/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (194, '/diandi_shop/order/dd-delivery/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (195, '/diandi_shop/order/dd-delivery/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (196, '/diandi_shop/order/dd-delivery/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (197, '/diandi_shop/order/dd-delivery/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (198, '/diandi_shop/order/dd-delivery-rule/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (199, '/diandi_shop/order/dd-delivery-rule/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (200, '/diandi_shop/order/dd-delivery-rule/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (201, '/diandi_shop/order/dd-delivery-rule/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (202, '/diandi_shop/order/dd-delivery-rule/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (203, '/diandi_shop/order/dd-delivery-rule/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (204, '/diandi_shop/order/dd-delivery-rule/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (205, '/diandi_shop/order/dd-order/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (206, '/diandi_shop/order/dd-order/get-region', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (207, '/diandi_shop/order/dd-order/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (208, '/diandi_shop/order/dd-order/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (209, '/diandi_shop/order/dd-order/upaddress', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634173, 1588634173);
INSERT INTO `dd_auth_route` VALUES (210, '/diandi_shop/order/dd-order/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (211, '/diandi_shop/order/dd-order/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (212, '/diandi_shop/order/dd-order/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (213, '/diandi_shop/order/dd-order/confirm', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (214, '/diandi_shop/order/dd-order/exportdata', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (215, '/diandi_shop/order/dd-order/prints', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (216, '/diandi_shop/order/dd-order/deletes', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (217, '/diandi_shop/order/dd-order/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (218, '/diandi_shop/setting/area/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (219, '/diandi_shop/setting/area/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (220, '/diandi_shop/setting/area/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (221, '/diandi_shop/setting/area/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (222, '/diandi_shop/setting/area/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (223, '/diandi_shop/setting/area/setdefault', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (224, '/diandi_shop/setting/area/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (225, '/diandi_shop/setting/area/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (226, '/diandi_shop/setting/comment/change-status', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (227, '/diandi_shop/setting/comment/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (228, '/diandi_shop/setting/comment/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (229, '/diandi_shop/setting/comment/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (230, '/diandi_shop/setting/comment/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (231, '/diandi_shop/setting/comment/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (232, '/diandi_shop/setting/comment/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (233, '/diandi_shop/setting/store/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (234, '/diandi_shop/setting/store/setting', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (235, '/diandi_shop/setting/store/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (236, '/diandi_shop/setting/store/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (237, '/diandi_shop/setting/store/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634174, 1588634174);
INSERT INTO `dd_auth_route` VALUES (238, '/diandi_shop/setting/store/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (239, '/diandi_shop/setting/store/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (240, '/diandi_shop/setting/store/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (241, '/diandi_shop/wxapp/dd-wxapp/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (242, '/diandi_shop/wxapp/dd-wxapp/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (243, '/diandi_shop/wxapp/dd-wxapp/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (244, '/diandi_shop/wxapp/dd-wxapp/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (245, '/diandi_shop/wxapp/dd-wxapp/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (246, '/diandi_shop/wxapp/dd-wxapp/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (247, '/diandi_shop/wxapp/dd-wxapp/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (248, '/diandi_shop/wxapp/dd-wxapp-help/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (249, '/diandi_shop/wxapp/dd-wxapp-help/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (250, '/diandi_shop/wxapp/dd-wxapp-help/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (251, '/diandi_shop/wxapp/dd-wxapp-help/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (252, '/diandi_shop/wxapp/dd-wxapp-help/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (253, '/diandi_shop/wxapp/dd-wxapp-help/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (254, '/diandi_shop/wxapp/dd-wxapp-help/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (255, '/diandi_shop/wxapp/dd-wxapp-navbar/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (256, '/diandi_shop/wxapp/dd-wxapp-navbar/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (257, '/diandi_shop/wxapp/dd-wxapp-navbar/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (258, '/diandi_shop/wxapp/dd-wxapp-navbar/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (259, '/diandi_shop/wxapp/dd-wxapp-navbar/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634175, 1588634175);
INSERT INTO `dd_auth_route` VALUES (260, '/diandi_shop/wxapp/dd-wxapp-navbar/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (261, '/diandi_shop/wxapp/dd-wxapp-navbar/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (262, '/diandi_shop/wxapp/dd-wxapp-page/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (263, '/diandi_shop/wxapp/dd-wxapp-slide/error', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (264, '/diandi_shop/wxapp/dd-wxapp-slide/index', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (265, '/diandi_shop/wxapp/dd-wxapp-slide/view', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (266, '/diandi_shop/wxapp/dd-wxapp-slide/create', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (267, '/diandi_shop/wxapp/dd-wxapp-slide/update', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (268, '/diandi_shop/wxapp/dd-wxapp-slide/delete', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (269, '/diandi_shop/wxapp/dd-wxapp-slide/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (270, '/diandi_shop/*', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (271, '/diandi_store/coupon/error', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (272, '/diandi_store/coupon/index', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (273, '/diandi_store/coupon/view', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (274, '/diandi_store/coupon/create', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (275, '/diandi_store/coupon/update', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (276, '/diandi_store/coupon/delete', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (277, '/diandi_store/coupon/*', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (278, '/diandi_store/coupon-groups/error', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (279, '/diandi_store/coupon-groups/index', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (280, '/diandi_store/coupon-groups/view', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (281, '/diandi_store/coupon-groups/create', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (282, '/diandi_store/coupon-groups/update', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (283, '/diandi_store/coupon-groups/delete', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (284, '/diandi_store/coupon-groups/*', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (285, '/diandi_store/coupon-record/error', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (286, '/diandi_store/coupon-record/index', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (287, '/diandi_store/coupon-record/view', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634176, 1588634176);
INSERT INTO `dd_auth_route` VALUES (288, '/diandi_store/coupon-record/create', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (289, '/diandi_store/coupon-record/update', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (290, '/diandi_store/coupon-record/delete', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (291, '/diandi_store/coupon-record/*', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (292, '/diandi_store/default/error', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (293, '/diandi_store/default/index', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (294, '/diandi_store/default/*', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (295, '/diandi_store/*', 0, NULL, NULL, 0, NULL, 'diandi_store', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (296, '/base/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (297, '/base/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (298, '/module/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (299, '/module/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (300, '/module/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (301, '/site/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (302, '/site/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (303, '/site/login', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (304, '/site/logout', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (305, '/site/signup', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (306, '/site/request-password-reset', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (307, '/site/reset-password', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (308, '/site/verify-email', 0, NULL, NULL, 0, NULL, 'sys', 1588634177, 1588634177);
INSERT INTO `dd_auth_route` VALUES (309, '/site/resend-verification-email', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (310, '/site/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (311, '/article/dd-article-category/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (312, '/article/dd-article-category/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (313, '/article/dd-article-category/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (314, '/article/dd-article-category/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (315, '/article/dd-article-category/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (316, '/article/dd-article-category/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (317, '/article/dd-article-category/childcate', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (318, '/article/dd-article-category/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (319, '/article/dd-article/upload', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (320, '/article/dd-article/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (321, '/article/dd-article/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (322, '/article/dd-article/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (323, '/article/dd-article/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (324, '/article/dd-article/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (325, '/article/dd-article/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (326, '/article/record/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (327, '/article/record/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (328, '/article/record/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (329, '/article/record/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (330, '/article/record/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (331, '/article/record/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (332, '/demo/form/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (333, '/demo/form/get-region', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (334, '/demo/form/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (335, '/demo/form/maile', 0, NULL, NULL, 0, NULL, 'sys', 1588634178, 1588634178);
INSERT INTO `dd_auth_route` VALUES (336, '/demo/form/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (337, '/diandiai/dd-ai-applications/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (338, '/diandiai/dd-ai-applications/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (339, '/diandiai/dd-ai-applications/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (340, '/diandiai/dd-ai-applications/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (341, '/diandiai/dd-ai-applications/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (342, '/diandiai/dd-ai-applications/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (343, '/diandiai/dd-ai-applications/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (344, '/diandiai/dd-ai-faces/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (345, '/diandiai/dd-ai-faces/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (346, '/diandiai/dd-ai-faces/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (347, '/diandiai/dd-ai-faces/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (348, '/diandiai/dd-ai-faces/users', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (349, '/diandiai/dd-ai-faces/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (350, '/diandiai/dd-ai-faces/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (351, '/diandiai/dd-ai-faces/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (352, '/diandiai/dd-ai-groups/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (353, '/diandiai/dd-ai-groups/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (354, '/diandiai/dd-ai-groups/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (355, '/diandiai/dd-ai-groups/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (356, '/diandiai/dd-ai-groups/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (357, '/diandiai/dd-ai-groups/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (358, '/diandiai/dd-ai-groups/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (359, '/diandiai/dd-ai-member/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (360, '/diandiai/dd-ai-member/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (361, '/diandiai/dd-ai-member/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (362, '/diandiai/dd-ai-member/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634179, 1588634179);
INSERT INTO `dd_auth_route` VALUES (363, '/diandiai/dd-ai-member/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (364, '/diandiai/dd-ai-member/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (365, '/diandiai/dd-ai-member/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (366, '/member/dd-member/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (367, '/member/dd-member/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (368, '/member/dd-member/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (369, '/member/dd-member/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (370, '/member/dd-member/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (371, '/member/dd-member/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (372, '/member/dd-member/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (373, '/member/dd-member-group/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (374, '/member/dd-member-group/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (375, '/member/dd-member-group/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (376, '/member/dd-member-group/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (377, '/member/dd-member-group/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (378, '/member/dd-member-group/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (379, '/member/dd-member-group/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (380, '/system/index/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (381, '/system/index/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (382, '/system/index/childcate', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (383, '/system/index/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (384, '/system/settings/baidu', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (385, '/system/settings/wxapp', 0, NULL, NULL, 0, NULL, 'sys', 1588634180, 1588634180);
INSERT INTO `dd_auth_route` VALUES (386, '/system/settings/wechatpay', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (387, '/system/settings/weburl', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (388, '/system/settings/sms', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (389, '/system/settings/email', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (390, '/system/settings/clear-cache', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (391, '/system/settings/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (392, '/system/welcome/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (393, '/system/welcome/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (394, '/system/welcome/sysai', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (395, '/system/welcome/member', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (396, '/system/welcome/aimember', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (397, '/system/welcome/goods', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (398, '/system/welcome/marketing', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (399, '/system/welcome/order', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (400, '/system/welcome/wxapp', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (401, '/system/welcome/plugins', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (402, '/system/welcome/system', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (403, '/system/welcome/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (404, '/upload/upload/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (405, '/upload/upload/uploadimg', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (406, '/upload/upload/uploadfile', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (407, '/upload/upload/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (408, '/user/dd-user/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (409, '/user/dd-user/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (410, '/user/dd-user/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (411, '/user/dd-user/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (412, '/user/dd-user/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (413, '/user/dd-user/profile', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (414, '/user/dd-user/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634181, 1588634181);
INSERT INTO `dd_auth_route` VALUES (415, '/user/dd-user/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (416, '/website/dd-website-contact/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (417, '/website/dd-website-contact/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (418, '/website/dd-website-contact/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (419, '/website/dd-website-contact/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (420, '/website/dd-website-contact/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (421, '/website/dd-website-contact/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (422, '/website/dd-website-contact/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (423, '/website/dd-website-slide/error', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (424, '/website/dd-website-slide/index', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (425, '/website/dd-website-slide/view', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (426, '/website/dd-website-slide/create', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (427, '/website/dd-website-slide/update', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (428, '/website/dd-website-slide/delete', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (429, '/website/dd-website-slide/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (430, '/website/setting/website', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (431, '/website/setting/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (432, '/*', 0, NULL, NULL, 0, NULL, 'sys', 1588634182, 1588634182);
INSERT INTO `dd_auth_route` VALUES (433, '/admin/group/assign', 0, NULL, NULL, 0, NULL, 'sys', 1588749311, 1588749311);
INSERT INTO `dd_auth_route` VALUES (434, '/admin/group/remove', 0, NULL, NULL, 0, NULL, 'sys', 1588749311, 1588749311);
INSERT INTO `dd_auth_route` VALUES (435, '/admin/store/error', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (436, '/admin/store/get-region', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (437, '/admin/store/index', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (438, '/admin/store/view', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (439, '/admin/store/create', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (440, '/admin/store/update', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (441, '/admin/store/delete', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (442, '/admin/store/*', 0, NULL, NULL, 0, NULL, NULL, 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (443, '/diandi_shop/setting/store/get-region', 1, NULL, NULL, 0, NULL, 'diandi_shop', 1590020675, 1590020675);
INSERT INTO `dd_auth_route` VALUES (447, '/diandi_gathergoods/ceshi/py_with_something', 1, NULL, NULL, 0, NULL, 'diandi_gathergoods', 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (448, '/diandi_gathergoods/ceshi/py_arr', 1, NULL, NULL, 0, NULL, 'diandi_gathergoods', 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (449, '/diandi_gathergoods/ceshi/py_num', 1, NULL, NULL, 0, NULL, 'diandi_gathergoods', 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (451, '/diandi_gathergoods/default/error', 1, NULL, NULL, 0, NULL, 'diandi_gathergoods', 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (452, '/diandi_gathergoods/default/index', 1, NULL, NULL, 0, NULL, 'diandi_gathergoods', 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (453, '/diandi_gathergoods/default/*', 1, NULL, NULL, 0, NULL, 'diandi_gathergoods', 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (454, '/diandi_gathergoods/*', 1, NULL, NULL, 0, NULL, 'diandi_gathergoods', 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (455, '/system/settings/map', 0, NULL, NULL, 0, NULL, NULL, 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (456, '/system/settings/set-cache', 0, NULL, NULL, 0, NULL, NULL, 1590020676, 1590020676);
INSERT INTO `dd_auth_route` VALUES (461, '/settings/default/*', 1, NULL, NULL, 0, NULL, NULL, 1590024401, 1590024401);
INSERT INTO `dd_auth_route` VALUES (466, '/diandi_gathergoods/ceshi/index', 1, NULL, NULL, 0, NULL, NULL, 1590899440, 1590899440);
INSERT INTO `dd_auth_route` VALUES (467, '/diandi_gathergoods/ceshi/py', 1, NULL, NULL, 0, NULL, NULL, 1590899440, 1590899440);
INSERT INTO `dd_auth_route` VALUES (468, '/diandi_gathergoods/ceshi/*', 1, NULL, NULL, 0, NULL, NULL, 1590899440, 1590899440);
INSERT INTO `dd_auth_route` VALUES (469, '/diandi_gathergoods/jingd/*', 1, NULL, NULL, 0, NULL, NULL, 1590899440, 1590899440);
INSERT INTO `dd_auth_route` VALUES (475, '/diandi_gathergoods/ceshi/error', 1, NULL, NULL, 0, NULL, NULL, 1590915002, 1590915002);
INSERT INTO `dd_auth_route` VALUES (476, '/diandi_gathergoods/tao/*', 1, NULL, NULL, 0, NULL, NULL, 1590915004, 1590915004);
INSERT INTO `dd_auth_route` VALUES (477, '/gii/addons', 1, NULL, NULL, 0, NULL, NULL, 1590915881, 1590915881);
INSERT INTO `dd_auth_route` VALUES (478, '/diandi_aggregate/default/error', 1, NULL, NULL, 0, NULL, NULL, 1590928510, 1590928510);
INSERT INTO `dd_auth_route` VALUES (479, '/diandi_aggregate/default/index', 1, NULL, NULL, 0, NULL, NULL, 1590928510, 1590928510);
INSERT INTO `dd_auth_route` VALUES (480, '/diandi_aggregate/default/*', 1, NULL, NULL, 0, NULL, NULL, 1590928510, 1590928510);
INSERT INTO `dd_auth_route` VALUES (481, '/diandi_aggregate/*', 1, NULL, NULL, 0, NULL, NULL, 1590928510, 1590928510);
INSERT INTO `dd_auth_route` VALUES (482, '/diandi_aggregate/set/config/index', 1, NULL, NULL, 0, NULL, NULL, 1590928862, 1590928862);
INSERT INTO `dd_auth_route` VALUES (483, '/diandi_aggregate/set/config/view', 1, NULL, NULL, 0, NULL, NULL, 1590928862, 1590928862);
INSERT INTO `dd_auth_route` VALUES (484, '/diandi_aggregate/set/config/create', 1, NULL, NULL, 0, NULL, NULL, 1590928862, 1590928862);
INSERT INTO `dd_auth_route` VALUES (485, '/diandi_aggregate/set/config/update', 1, NULL, NULL, 0, NULL, NULL, 1590928862, 1590928862);
INSERT INTO `dd_auth_route` VALUES (486, '/diandi_aggregate/set/config/delete', 1, NULL, NULL, 0, NULL, NULL, 1590928862, 1590928862);
INSERT INTO `dd_auth_route` VALUES (487, '/diandi_aggregate/set/config/*', 1, NULL, NULL, 0, NULL, NULL, 1590928862, 1590928862);
INSERT INTO `dd_auth_route` VALUES (502, '/diandi_aggregate/set/config/error', 1, NULL, NULL, 0, NULL, NULL, 1590983271, 1590983271);
INSERT INTO `dd_auth_route` VALUES (503, '/diandi_distribution/default/error', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (504, '/diandi_distribution/default/index', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (505, '/diandi_distribution/default/*', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (506, '/diandi_distribution/conf/price-conf/error', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (507, '/diandi_distribution/conf/price-conf/index', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (508, '/diandi_distribution/conf/price-conf/view', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (509, '/diandi_distribution/conf/price-conf/create', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (510, '/diandi_distribution/conf/price-conf/update', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (511, '/diandi_distribution/conf/price-conf/delete', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (512, '/diandi_distribution/conf/price-conf/*', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (513, '/diandi_distribution/goods/gift/error', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (514, '/diandi_distribution/goods/gift/index', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (515, '/diandi_distribution/goods/gift/view', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (516, '/diandi_distribution/goods/gift/create', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (517, '/diandi_distribution/goods/gift/update', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (518, '/diandi_distribution/goods/gift/delete', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (519, '/diandi_distribution/goods/gift/*', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (520, '/diandi_distribution/goods/goods/error', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (521, '/diandi_distribution/goods/goods/index', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (522, '/diandi_distribution/goods/goods/view', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (523, '/diandi_distribution/goods/goods/create', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (524, '/diandi_distribution/goods/goods/update', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (525, '/diandi_distribution/goods/goods/delete', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (526, '/diandi_distribution/goods/goods/*', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (527, '/diandi_distribution/level/level/error', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (528, '/diandi_distribution/level/level/index', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (529, '/diandi_distribution/level/level/view', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (530, '/diandi_distribution/level/level/create', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (531, '/diandi_distribution/level/level/update', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (532, '/diandi_distribution/level/level/delete', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (533, '/diandi_distribution/level/level/*', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (534, '/diandi_distribution/level/member-level/error', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (535, '/diandi_distribution/level/member-level/index', 1, NULL, NULL, 0, NULL, NULL, 1590983525, 1590983525);
INSERT INTO `dd_auth_route` VALUES (536, '/diandi_distribution/level/member-level/view', 1, NULL, NULL, 0, NULL, NULL, 1590983526, 1590983526);
INSERT INTO `dd_auth_route` VALUES (537, '/diandi_distribution/level/member-level/create', 1, NULL, NULL, 0, NULL, NULL, 1590983526, 1590983526);
INSERT INTO `dd_auth_route` VALUES (538, '/diandi_distribution/level/member-level/update', 1, NULL, NULL, 0, NULL, NULL, 1590983526, 1590983526);
INSERT INTO `dd_auth_route` VALUES (539, '/diandi_distribution/level/member-level/delete', 1, NULL, NULL, 0, NULL, NULL, 1590983526, 1590983526);
INSERT INTO `dd_auth_route` VALUES (540, '/diandi_distribution/level/member-level/*', 1, NULL, NULL, 0, NULL, NULL, 1590983526, 1590983526);
INSERT INTO `dd_auth_route` VALUES (541, '/diandi_distribution/*', 1, NULL, NULL, 0, NULL, NULL, 1590983526, 1590983526);
INSERT INTO `dd_auth_route` VALUES (542, '/diandi_distribution/conf/price-conf/change-use', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (543, '/diandi_distribution/level/price-conf/error', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (544, '/diandi_distribution/level/price-conf/index', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (545, '/diandi_distribution/level/price-conf/view', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (546, '/diandi_distribution/level/price-conf/create', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (547, '/diandi_distribution/level/price-conf/update', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (548, '/diandi_distribution/level/price-conf/delete', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (549, '/diandi_distribution/level/price-conf/*', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (550, '/diandi_pro/default/error', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (551, '/diandi_pro/default/index', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (552, '/diandi_pro/default/*', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (553, '/diandi_pro/goods/category/error', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (554, '/diandi_pro/goods/category/index', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (555, '/diandi_pro/goods/category/view', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (556, '/diandi_pro/goods/category/create', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (557, '/diandi_pro/goods/category/update', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (558, '/diandi_pro/goods/category/delete', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (559, '/diandi_pro/goods/category/*', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (560, '/diandi_pro/goods/goods/error', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (561, '/diandi_pro/goods/goods/index', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (562, '/diandi_pro/goods/goods/view', 1, NULL, NULL, 0, NULL, NULL, 1591531134, 1591531134);
INSERT INTO `dd_auth_route` VALUES (563, '/diandi_pro/goods/goods/create', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (564, '/diandi_pro/goods/goods/update', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (565, '/diandi_pro/goods/goods/delete', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (566, '/diandi_pro/goods/goods/*', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (567, '/diandi_pro/goods/param/error', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (568, '/diandi_pro/goods/param/index', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (569, '/diandi_pro/goods/param/view', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (570, '/diandi_pro/goods/param/create', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (571, '/diandi_pro/goods/param/update', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (572, '/diandi_pro/goods/param/delete', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (573, '/diandi_pro/goods/param/*', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (574, '/diandi_pro/goods/specrel/error', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (575, '/diandi_pro/goods/specrel/index', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (576, '/diandi_pro/goods/specrel/view', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (577, '/diandi_pro/goods/specrel/create', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (578, '/diandi_pro/goods/specrel/update', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (579, '/diandi_pro/goods/specrel/delete', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (580, '/diandi_pro/goods/specrel/*', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (581, '/diandi_pro/template/param/error', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (582, '/diandi_pro/template/param/index', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (583, '/diandi_pro/template/param/view', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (584, '/diandi_pro/template/param/create', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (585, '/diandi_pro/template/param/update', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (586, '/diandi_pro/template/param/delete', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (587, '/diandi_pro/template/param/*', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (588, '/diandi_pro/template/pro-template/error', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (589, '/diandi_pro/template/pro-template/index', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (590, '/diandi_pro/template/pro-template/view', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (591, '/diandi_pro/template/pro-template/create', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (592, '/diandi_pro/template/pro-template/update', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (593, '/diandi_pro/template/pro-template/delete', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (594, '/diandi_pro/template/pro-template/*', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (595, '/diandi_pro/*', 1, NULL, NULL, 0, NULL, NULL, 1591531135, 1591531135);
INSERT INTO `dd_auth_route` VALUES (596, '/diandi_pro/goods/category/getlist', 1, NULL, NULL, 0, NULL, NULL, 1591541402, 1591541402);
INSERT INTO `dd_auth_route` VALUES (597, '/diandi_pro/template/specrel/error', 1, NULL, NULL, 0, NULL, NULL, 1591541402, 1591541402);
INSERT INTO `dd_auth_route` VALUES (598, '/diandi_pro/template/specrel/index', 1, NULL, NULL, 0, NULL, NULL, 1591541402, 1591541402);
INSERT INTO `dd_auth_route` VALUES (599, '/diandi_pro/template/specrel/view', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (600, '/diandi_pro/template/specrel/create', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (601, '/diandi_pro/template/specrel/update', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (602, '/diandi_pro/template/specrel/delete', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (603, '/diandi_pro/template/specrel/*', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (604, '/diandi_pro/template/template/error', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (605, '/diandi_pro/template/template/index', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (606, '/diandi_pro/template/template/view', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (607, '/diandi_pro/template/template/create', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (608, '/diandi_pro/template/template/update', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (609, '/diandi_pro/template/template/delete', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (610, '/diandi_pro/template/template/*', 1, NULL, NULL, 0, NULL, NULL, 1591541403, 1591541403);
INSERT INTO `dd_auth_route` VALUES (611, '/diandi_shop/goods/label/getlist', 1, NULL, NULL, 0, NULL, NULL, 1592915329, 1592915329);
INSERT INTO `dd_auth_route` VALUES (612, '/diandi_shop/order/dd-order/printsip', 1, NULL, NULL, 0, NULL, NULL, 1592915329, 1592915329);
INSERT INTO `dd_auth_route` VALUES (613, '/diandi_pro/goods/goods/getlist', 1, NULL, NULL, 0, NULL, NULL, 1592915329, 1592915329);
INSERT INTO `dd_auth_route` VALUES (616, '/system/database/*', 1, NULL, NULL, 0, NULL, NULL, 1592915329, 1592915329);
INSERT INTO `dd_auth_route` VALUES (617, '/system/database/error', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (618, '/system/database/backups', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (619, '/system/database/export', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (620, '/system/database/export-start', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (621, '/system/database/optimize', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (622, '/system/database/repair', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (623, '/system/database/restore', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (624, '/system/database/restore-init', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (625, '/system/database/restore-start', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (626, '/system/database/delete', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (627, '/system/database/data-dictionary', 1, NULL, NULL, 0, NULL, NULL, 1592917793, 1592917793);
INSERT INTO `dd_auth_route` VALUES (628, '/admin/bloc/error', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (629, '/diandi_lottery/active/error', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (630, '/diandi_lottery/active/index', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (631, '/diandi_lottery/active/view', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (632, '/diandi_lottery/active/create', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (633, '/diandi_lottery/active/update', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (634, '/diandi_lottery/active/delete', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (635, '/diandi_lottery/active/*', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (636, '/diandi_lottery/contact/error', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (637, '/diandi_lottery/contact/index', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (638, '/diandi_lottery/contact/view', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (639, '/diandi_lottery/contact/create', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (640, '/diandi_lottery/contact/update', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (641, '/diandi_lottery/contact/delete', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (642, '/diandi_lottery/contact/*', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (643, '/diandi_lottery/default/error', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (644, '/diandi_lottery/default/index', 1, NULL, NULL, 0, NULL, NULL, 1593007220, 1593007220);
INSERT INTO `dd_auth_route` VALUES (645, '/diandi_lottery/default/*', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (646, '/diandi_lottery/prize/error', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (647, '/diandi_lottery/prize/index', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (648, '/diandi_lottery/prize/view', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (649, '/diandi_lottery/prize/create', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (650, '/diandi_lottery/prize/update', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (651, '/diandi_lottery/prize/delete', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (652, '/diandi_lottery/prize/*', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (653, '/diandi_lottery/slide/error', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (654, '/diandi_lottery/slide/index', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (655, '/diandi_lottery/slide/view', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (656, '/diandi_lottery/slide/create', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (657, '/diandi_lottery/slide/update', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (658, '/diandi_lottery/slide/delete', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (659, '/diandi_lottery/slide/*', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (660, '/diandi_lottery/template/error', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (661, '/diandi_lottery/template/index', 1, NULL, NULL, 0, NULL, NULL, 1593007221, 1593007221);
INSERT INTO `dd_auth_route` VALUES (662, '/diandi_lottery/template/view', 1, NULL, NULL, 0, NULL, NULL, 1593007222, 1593007222);
INSERT INTO `dd_auth_route` VALUES (663, '/diandi_lottery/template/create', 1, NULL, NULL, 0, NULL, NULL, 1593007222, 1593007222);
INSERT INTO `dd_auth_route` VALUES (664, '/diandi_lottery/template/update', 1, NULL, NULL, 0, NULL, NULL, 1593007222, 1593007222);
INSERT INTO `dd_auth_route` VALUES (665, '/diandi_lottery/template/delete', 1, NULL, NULL, 0, NULL, NULL, 1593007222, 1593007222);
INSERT INTO `dd_auth_route` VALUES (666, '/diandi_lottery/template/*', 1, NULL, NULL, 0, NULL, NULL, 1593007222, 1593007222);
INSERT INTO `dd_auth_route` VALUES (667, '/diandi_lottery/*', 1, NULL, NULL, 0, NULL, NULL, 1593007222, 1593007222);
INSERT INTO `dd_auth_route` VALUES (668, '/system/database/backlist', 1, NULL, NULL, 0, NULL, NULL, 1593007222, 1593007222);
INSERT INTO `dd_auth_route` VALUES (669, '/diandi_lottery/prizewin/error', 1, NULL, NULL, 0, NULL, NULL, 1593008125, 1593008125);
INSERT INTO `dd_auth_route` VALUES (670, '/diandi_lottery/prizewin/index', 1, NULL, NULL, 0, NULL, NULL, 1593008125, 1593008125);
INSERT INTO `dd_auth_route` VALUES (671, '/diandi_lottery/prizewin/view', 1, NULL, NULL, 0, NULL, NULL, 1593008125, 1593008125);
INSERT INTO `dd_auth_route` VALUES (672, '/diandi_lottery/prizewin/create', 1, NULL, NULL, 0, NULL, NULL, 1593008125, 1593008125);
INSERT INTO `dd_auth_route` VALUES (673, '/diandi_lottery/prizewin/update', 1, NULL, NULL, 0, NULL, NULL, 1593008125, 1593008125);
INSERT INTO `dd_auth_route` VALUES (674, '/diandi_lottery/prizewin/delete', 1, NULL, NULL, 0, NULL, NULL, 1593008125, 1593008125);
INSERT INTO `dd_auth_route` VALUES (675, '/diandi_lottery/prizewin/*', 1, NULL, NULL, 0, NULL, NULL, 1593008125, 1593008125);
INSERT INTO `dd_auth_route` VALUES (676, '/diandi_shop/goods/label/*', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (677, '/diandi_distribution/goods/location/error', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (678, '/diandi_distribution/goods/location/index', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (679, '/diandi_distribution/goods/location/view', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (680, '/diandi_distribution/goods/location/create', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (681, '/diandi_distribution/goods/location/update', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (682, '/diandi_distribution/goods/location/delete', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (683, '/diandi_distribution/goods/location/*', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (684, '/diandi_distribution/goods/location-goods/error', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (685, '/diandi_distribution/goods/location-goods/index', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (686, '/diandi_distribution/goods/location-goods/view', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (687, '/diandi_distribution/goods/location-goods/create', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (688, '/diandi_distribution/goods/location-goods/update', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (689, '/diandi_distribution/goods/location-goods/delete', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (690, '/diandi_distribution/goods/location-goods/*', 1, NULL, NULL, 0, NULL, NULL, 1593447323, 1593447323);
INSERT INTO `dd_auth_route` VALUES (691, '/diandi_distribution/conf/slide/error', 1, NULL, NULL, 0, NULL, NULL, 1593448401, 1593448401);
INSERT INTO `dd_auth_route` VALUES (692, '/diandi_distribution/conf/slide/index', 1, NULL, NULL, 0, NULL, NULL, 1593448401, 1593448401);
INSERT INTO `dd_auth_route` VALUES (693, '/diandi_distribution/conf/slide/view', 1, NULL, NULL, 0, NULL, NULL, 1593448401, 1593448401);
INSERT INTO `dd_auth_route` VALUES (694, '/diandi_distribution/conf/slide/create', 1, NULL, NULL, 0, NULL, NULL, 1593448401, 1593448401);
INSERT INTO `dd_auth_route` VALUES (695, '/diandi_distribution/conf/slide/update', 1, NULL, NULL, 0, NULL, NULL, 1593448401, 1593448401);
INSERT INTO `dd_auth_route` VALUES (696, '/diandi_distribution/conf/slide/delete', 1, NULL, NULL, 0, NULL, NULL, 1593448401, 1593448401);
INSERT INTO `dd_auth_route` VALUES (697, '/diandi_distribution/conf/slide/*', 1, NULL, NULL, 0, NULL, NULL, 1593448401, 1593448401);
INSERT INTO `dd_auth_route` VALUES (698, '/diandi_distribution/goods/location-goods/goodslocation', 1, NULL, NULL, 0, NULL, NULL, 1593569456, 1593569456);
INSERT INTO `dd_auth_route` VALUES (699, '/diandi_distribution/goods/location-goods/goodslist', 1, NULL, NULL, 0, NULL, NULL, 1593569456, 1593569456);
INSERT INTO `dd_auth_route` VALUES (700, '/diandi_distribution/goods/location-goods/advlist', 1, NULL, NULL, 0, NULL, NULL, 1593569456, 1593569456);
INSERT INTO `dd_auth_route` VALUES (701, '/ds', 1, NULL, NULL, 0, NULL, NULL, 1593682380, 1593682380);
INSERT INTO `dd_auth_route` VALUES (702, '/debug/default/view', 1, NULL, NULL, 0, NULL, NULL, 1594610576, 1594610576);
INSERT INTO `dd_auth_route` VALUES (703, '/debug/*', 1, NULL, NULL, 0, NULL, NULL, 1594610578, 1594610578);

-- ----------------------------
-- Table structure for dd_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_rule`;
CREATE TABLE `dd_auth_rule`  (
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `data` blob NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_rule
-- ----------------------------
INSERT INTO `dd_auth_rule` VALUES ('模块访问', 0x4F3A32323A22636F6D6D6F6E5C726261635C4164646F6E7352756C65223A333A7B733A343A226E616D65223B733A31323A22E6A8A1E59D97E8AEBFE997AE223B733A393A22637265617465644174223B693A313538383436323034393B733A393A22757064617465644174223B693A313538383436323137303B7D, 1588462049, 1588462170);

-- ----------------------------
-- Table structure for dd_auth_user_group
-- ----------------------------
DROP TABLE IF EXISTS `dd_auth_user_group`;
CREATE TABLE `dd_auth_user_group`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户组名称',
  `type` smallint(6) NOT NULL COMMENT '用户组类型',
  `description` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '用户组名称',
  `module_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`, `name`) USING BTREE,
  INDEX `type`(`type`) USING BTREE,
  INDEX `name`(`name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 566 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '后台用户组' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_auth_user_group
-- ----------------------------
INSERT INTO `dd_auth_user_group` VALUES (551, '基础权限组', 0, '', 'sys', 1588976797, 1588837647);
INSERT INTO `dd_auth_user_group` VALUES (552, '总管理员', 0, '', 'sys', 1588976797, NULL);
INSERT INTO `dd_auth_user_group` VALUES (559, '店滴商城-运维', 1, '', 'diandi_shop', 1588983602, 1588989817);
INSERT INTO `dd_auth_user_group` VALUES (565, '店滴商城-评论', 1, '', 'diandi_shop', 1588989802, 1588989802);

-- ----------------------------
-- Table structure for dd_bloc_conf_map
-- ----------------------------
DROP TABLE IF EXISTS `dd_bloc_conf_map`;
CREATE TABLE `dd_bloc_conf_map`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `baiduApk` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `amapApk` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tencentApk` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_bloc_conf_map
-- ----------------------------
INSERT INTO `dd_bloc_conf_map` VALUES (1, 3, '1', '2', '3');

-- ----------------------------
-- Table structure for dd_core_paylog
-- ----------------------------
DROP TABLE IF EXISTS `dd_core_paylog`;
CREATE TABLE `dd_core_paylog`  (
  `plid` bigint(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '支付类型',
  `openid` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'openid',
  `uniontid` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '跨应用标识',
  `tid` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `fee` decimal(10, 2) NOT NULL COMMENT '支付金额',
  `status` tinyint(4) NOT NULL COMMENT '支付状态',
  `module` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模块',
  `tag` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `is_usecard` tinyint(3) UNSIGNED NULL DEFAULT NULL COMMENT '是否使用会员卡',
  `card_type` tinyint(3) UNSIGNED NULL DEFAULT NULL COMMENT '会员卡类型',
  `card_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '会员卡id',
  `card_fee` decimal(10, 2) UNSIGNED NULL DEFAULT NULL COMMENT '会员卡余额',
  `encrypt_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '加密字符串',
  `is_wish` tinyint(11) NULL DEFAULT NULL,
  `create_time` int(11) NULL DEFAULT NULL,
  `update_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`plid`) USING BTREE,
  INDEX `idx_openid`(`openid`) USING BTREE,
  INDEX `idx_tid`(`tid`) USING BTREE,
  INDEX `uniontid`(`uniontid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 153 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_core_paylog
-- ----------------------------
INSERT INTO `dd_core_paylog` VALUES (9, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', NULL, NULL, 40.00, 1, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (10, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', NULL, NULL, 40.00, 1, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (11, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031449995152', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (12, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031454975355', NULL, 80.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (13, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031455515510', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (14, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031451100102', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (15, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031498485155', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (16, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031410256571', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (17, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031455524949', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (18, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031453981005', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (19, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031452101971', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (20, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031448514951', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (21, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031499521004', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (22, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031451549754', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (23, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031499525351', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (24, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031449531001', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (25, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031453974950', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (26, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031454511019', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (27, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031410010198', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (28, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031410055494', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (29, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031455535548', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (30, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031448515797', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (31, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031497555655', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (32, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031454574950', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (33, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031448529799', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (34, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031453539910', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (35, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031455515410', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (36, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031498501005', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (37, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031410048541', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (38, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031456495097', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (39, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031498551005', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (40, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031448101571', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (41, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031450571015', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (42, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031457975110', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (43, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031451101100', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (44, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031448565453', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (45, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031497545051', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (46, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031410156531', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (47, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031498525010', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (48, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031410151995', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (49, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031451521005', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (50, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031453579797', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (51, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031499565256', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (52, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031410298985', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (53, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031455525410', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (54, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031498495352', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (55, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031452545797', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (56, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031454971015', NULL, 240.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (57, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031449531009', NULL, 0.10, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (58, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031599501025', NULL, 0.10, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (59, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031555571021', NULL, 0.05, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (60, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031654535557', '', 0.10, 1, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (61, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020031657981005', '', 0.15, 1, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (62, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032151975653', NULL, 0.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (63, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032110197100', NULL, 0.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (64, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032199995652', NULL, 280.20, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (65, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032157549749', NULL, 280.20, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (66, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032110156975', NULL, 280.20, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (67, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032149524850', NULL, 280.20, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (68, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032154985397', NULL, 280.20, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (69, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032156100555', '', 280.20, 1, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (70, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032553100102', NULL, 50.05, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (71, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032510053565', NULL, 80.10, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (72, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032599975597', NULL, 80.20, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (73, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032598545751', NULL, 40.05, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (74, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032557974851', NULL, 40.05, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (75, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032551565198', NULL, 40.05, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (76, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032549499757', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (77, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032749485450', NULL, 80.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (78, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020032753565110', NULL, 40.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (79, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020033010010199', NULL, 40.05, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (80, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020033054544897', NULL, 40.15, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (81, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020040151971015', NULL, 130.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (82, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020041149521001', NULL, 18.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (83, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020041598535649', NULL, 3280.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (84, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020041654481014', NULL, 1000.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (85, NULL, NULL, 'wechat', 'oE5EC0Uvc4QkT_TgcfhgSfpO4LLQ', '2020041651579957', NULL, 200.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (86, NULL, NULL, 'wechat', 'oE5EC0aRDVDME1L39dYWzt9bUGlI', '2020041650565248', NULL, 601.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (87, NULL, NULL, 'wechat', 'oE5EC0S5K7EMf1tCf1S3tIBXIbCw', '2020041697569856', NULL, 200.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (88, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020041753535752', NULL, 1697.50, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (89, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020042948544910', NULL, 600.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (90, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020042955101565', NULL, 402.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (91, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020042997524957', NULL, 402.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (92, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020042910053495', NULL, 357.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (93, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020042952541025', NULL, 357.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (94, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020051152971025', NULL, 600.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (95, NULL, NULL, 'wechat', 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', '2020051152559999', NULL, 600.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `dd_core_paylog` VALUES (96, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070849544899', NULL, 12.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594180145, 1594180145);
INSERT INTO `dd_core_paylog` VALUES (97, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070950495156', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594288515, 1594288515);
INSERT INTO `dd_core_paylog` VALUES (98, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070910249101', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594288960, 1594288960);
INSERT INTO `dd_core_paylog` VALUES (99, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070949569856', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594289474, 1594289474);
INSERT INTO `dd_core_paylog` VALUES (100, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070910052504', NULL, 45.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594289581, 1594289581);
INSERT INTO `dd_core_paylog` VALUES (101, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070953985699', NULL, 45.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594289653, 1594289653);
INSERT INTO `dd_core_paylog` VALUES (102, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070956101484', NULL, 10.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594289752, 1594289752);
INSERT INTO `dd_core_paylog` VALUES (103, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070910010251', NULL, 45.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594289838, 1594289838);
INSERT INTO `dd_core_paylog` VALUES (104, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070998565250', NULL, 45.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594289851, 1594289851);
INSERT INTO `dd_core_paylog` VALUES (105, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070955101985', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594291975, 1594291975);
INSERT INTO `dd_core_paylog` VALUES (106, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070998539850', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594297291, 1594297291);
INSERT INTO `dd_core_paylog` VALUES (107, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070998975599', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594300363, 1594300363);
INSERT INTO `dd_core_paylog` VALUES (108, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070950499710', NULL, 10.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594300434, 1594300434);
INSERT INTO `dd_core_paylog` VALUES (109, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070948101571', NULL, 10.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594301040, 1594301040);
INSERT INTO `dd_core_paylog` VALUES (110, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070951100995', NULL, 10.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594301139, 1594301139);
INSERT INTO `dd_core_paylog` VALUES (111, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070957989955', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594301993, 1594301993);
INSERT INTO `dd_core_paylog` VALUES (112, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070952102524', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594302213, 1594302213);
INSERT INTO `dd_core_paylog` VALUES (113, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070956994954', NULL, 459.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594302408, 1594302408);
INSERT INTO `dd_core_paylog` VALUES (114, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070910252509', NULL, 30.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594302911, 1594302911);
INSERT INTO `dd_core_paylog` VALUES (115, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070998971005', NULL, 355.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594303227, 1594303227);
INSERT INTO `dd_core_paylog` VALUES (116, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020070910110152', NULL, 10.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594303646, 1594303646);
INSERT INTO `dd_core_paylog` VALUES (117, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071210151571', NULL, 100.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594528782, 1594528782);
INSERT INTO `dd_core_paylog` VALUES (118, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071298991005', NULL, 100.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594528875, 1594528875);
INSERT INTO `dd_core_paylog` VALUES (119, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071249575055', '4200000580202007127237233976', 0.01, 1, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594528913, 1594528913);
INSERT INTO `dd_core_paylog` VALUES (120, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071257494998', NULL, 0.01, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594530041, 1594530041);
INSERT INTO `dd_core_paylog` VALUES (121, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071252979752', NULL, 0.01, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594533636, 1594533636);
INSERT INTO `dd_core_paylog` VALUES (122, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071297100100', NULL, 499.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594533898, 1594533898);
INSERT INTO `dd_core_paylog` VALUES (123, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071252495399', NULL, 499.00, 0, 'diandi_shop', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594533956, 1594533956);
INSERT INTO `dd_core_paylog` VALUES (133, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071253505650', NULL, 499.00, 0, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594534645, 1594534645);
INSERT INTO `dd_core_paylog` VALUES (134, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071253554853', NULL, 0.01, 0, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594534821, 1594534821);
INSERT INTO `dd_core_paylog` VALUES (135, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071251985455', '4200000581202007129274281040', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594535667, 1594535667);
INSERT INTO `dd_core_paylog` VALUES (136, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071250501019', '4200000593202007120278308858', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594535826, 1594535826);
INSERT INTO `dd_core_paylog` VALUES (137, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071210210050', NULL, 12.00, 0, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594539807, 1594539807);
INSERT INTO `dd_core_paylog` VALUES (138, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071257565153', '4200000575202007129308838624', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594545721, 1594545721);
INSERT INTO `dd_core_paylog` VALUES (139, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071297531011', NULL, 0.01, 0, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594546234, 1594546234);
INSERT INTO `dd_core_paylog` VALUES (140, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071251100579', NULL, 0.01, 0, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594546323, 1594546323);
INSERT INTO `dd_core_paylog` VALUES (141, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071298555650', NULL, 0.01, 0, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594546347, 1594546347);
INSERT INTO `dd_core_paylog` VALUES (142, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071210252535', '4200000590202007122887871986', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594546399, 1594546399);
INSERT INTO `dd_core_paylog` VALUES (143, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071250995697', '4200000574202007126193755940', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594546914, 1594546914);
INSERT INTO `dd_core_paylog` VALUES (144, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071210099575', '4200000584202007120431648036', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594547021, 1594547021);
INSERT INTO `dd_core_paylog` VALUES (145, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071210210052', '4200000586202007127223074139', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594547151, 1594547151);
INSERT INTO `dd_core_paylog` VALUES (146, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071253481015', '4200000575202007128141662610', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594547301, 1594547301);
INSERT INTO `dd_core_paylog` VALUES (147, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071254979956', '4200000585202007123881968080', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594547414, 1594547414);
INSERT INTO `dd_core_paylog` VALUES (148, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071257991024', '4200000574202007123799750608', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594548761, 1594548761);
INSERT INTO `dd_core_paylog` VALUES (149, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071257975657', '4200000577202007125612303582', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594549065, 1594549065);
INSERT INTO `dd_core_paylog` VALUES (150, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071210255561', '4200000593202007126127218035', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594549215, 1594549215);
INSERT INTO `dd_core_paylog` VALUES (151, 4, 43, 'wechat', 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', '2020071310297539', NULL, 12.00, 0, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594600703, 1594600703);
INSERT INTO `dd_core_paylog` VALUES (152, 4, 43, 'wechat', 'oO3nO4lv6mLpT3o2pfmZwPtVjdZE', '2020071448985053', '4200000597202007144553310857', 0.01, 1, 'diandi_distribution', '小程序下单', NULL, NULL, NULL, NULL, NULL, NULL, 1594710784, 1594710784);

-- ----------------------------
-- Table structure for dd_diandi_aggregate_config
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_aggregate_config`;
CREATE TABLE `dd_diandi_aggregate_config`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '公司ID',
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商户ID',
  `inst_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '机构号',
  `key` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '令牌',
  `merchant_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商户号',
  `terminal_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '终端号',
  `token` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT 'Token',
  `url` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '接口地址',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '扫呗支付配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_aggregate_config
-- ----------------------------
INSERT INTO `dd_diandi_aggregate_config` VALUES (8, 1, 38, '52100021', '2d7c2a70e2cd4e33902f6215cd368400', '824200203000002', '30759267', '416bcc325af048bdb0d0dedaa2210b3b', 'http://test.lcsw.cn:8045/lcsw/');

-- ----------------------------
-- Table structure for dd_diandi_coupon
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_coupon`;
CREATE TABLE `dd_diandi_coupon`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `card_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `type` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '卡券类型',
  `logo_url` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '优惠券logo',
  `code_type` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT 'code类型（二维码/条形码/code码）',
  `brand_name` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '商家名称',
  `title` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '优惠券标题',
  `sub_title` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '优惠券短标题',
  `color` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '优惠券颜色',
  `notice` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '使用说明',
  `description` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '优惠券描述',
  `date_info` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '使用期限',
  `quantity` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '总库存',
  `use_custom_code` tinyint(3) NOT NULL DEFAULT 0,
  `bind_openid` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `can_share` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否可分享',
  `can_give_friend` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否可转赠给朋友',
  `get_limit` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '每人领取限制',
  `service_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '服务电话',
  `extra` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '扩展数据',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '1:审核中,2:未通过,3:已通过,4:卡券被商户删除,5:未知',
  `is_display` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否上架',
  `is_selfconsume` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否开启自助核销',
  `promotion_url_name` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `promotion_url` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `promotion_url_sub_title` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `source` tinyint(3) UNSIGNED NOT NULL DEFAULT 2 COMMENT '来源，1是系统，2是微信',
  `dosage` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '已领取数量',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `card_id`(`card_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_coupon
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_coupon_groups
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_coupon_groups`;
CREATE TABLE `dd_diandi_coupon_groups`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `couponid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '优惠券id',
  `groupid` int(10) NOT NULL COMMENT '分组id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_coupon_groups
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_coupon_location
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_coupon_location`;
CREATE TABLE `dd_diandi_coupon_location`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) UNSIGNED NOT NULL,
  `acid` int(10) UNSIGNED NOT NULL,
  `sid` int(10) UNSIGNED NOT NULL,
  `location_id` int(10) UNSIGNED NOT NULL,
  `business_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `branch_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `category` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `province` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `city` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `district` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `address` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `longitude` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `latitude` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `telephone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `photo_list` varchar(10000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `avg_price` int(10) UNSIGNED NOT NULL,
  `open_time` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `recommend` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `special` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `introduction` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `offset_type` tinyint(3) UNSIGNED NOT NULL,
  `status` tinyint(3) UNSIGNED NOT NULL,
  `message` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `uniacid`(`uniacid`, `acid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_coupon_location
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_coupon_modules
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_coupon_modules`;
CREATE TABLE `dd_diandi_coupon_modules`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `couponid` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '优惠券id',
  `module` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模块标识',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `cid`(`couponid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_coupon_modules
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_coupon_record
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_coupon_record`;
CREATE TABLE `dd_diandi_coupon_record`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `card_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '会员卡id',
  `openid` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'openid',
  `friend_openid` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '朋友的openid',
  `givebyfriend` tinyint(3) UNSIGNED NOT NULL COMMENT '朋友的奖励金',
  `code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `hash` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `addtime` int(10) UNSIGNED NOT NULL COMMENT '领取时间',
  `usetime` int(10) UNSIGNED NOT NULL COMMENT '使用时间',
  `status` tinyint(3) NOT NULL COMMENT '状态',
  `clerk_name` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `clerk_id` int(10) UNSIGNED NOT NULL,
  `store_id` int(10) UNSIGNED NOT NULL COMMENT '商家id',
  `clerk_type` tinyint(3) UNSIGNED NOT NULL,
  `couponid` int(10) UNSIGNED NOT NULL COMMENT '优惠券id',
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户id',
  `grantmodule` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '发放模块',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `card_id`(`card_id`) USING BTREE,
  INDEX `hash`(`hash`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_coupon_record
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_coupon_store
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_coupon_store`;
CREATE TABLE `dd_diandi_coupon_store`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL,
  `couponid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `storeid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `couponid`(`couponid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_coupon_store
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_shop_areas
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_areas`;
CREATE TABLE `dd_diandi_shop_areas`  (
  `area_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '区域id',
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `area_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '区域名称',
  `create_time` int(11) NOT NULL COMMENT '创建时间',
  `address` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '具体地址',
  `logo` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '配送点标志',
  `status` int(11) NULL DEFAULT 0 COMMENT '配送点状态',
  `freight` decimal(10, 0) NULL DEFAULT NULL COMMENT '运费',
  `province_id` int(11) NULL DEFAULT NULL COMMENT '省份',
  `is_default` int(11) NOT NULL DEFAULT 0,
  `city_id` int(11) NULL DEFAULT NULL COMMENT '城市',
  `region_id` int(11) NULL DEFAULT NULL COMMENT '区县',
  `update_time` int(11) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`area_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 43 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_areas
-- ----------------------------
INSERT INTO `dd_diandi_shop_areas` VALUES (20, NULL, NULL, '幸福里社区', 1578810017, '陕西省空港新城幸福里', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 1, 3016, 3019, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (21, NULL, NULL, '博尚新都社区', 1578810267, '陕西省咸阳市朝阳二路 博尚新都小区', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 2931, 2934, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (22, NULL, NULL, '秦王府社区', 1578810409, '陕西省咸阳市长陵路南 秦王府小区', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 2931, 2934, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (23, NULL, NULL, '长庆石化社区', 1578810580, '陕西省咸阳市朝阳二路 长庆石化小区', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 2931, 2934, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (24, NULL, NULL, '成国右岸社区', 1578810873, '陕西省咸阳市迎宾大道、成国右岸小区', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 3016, 3019, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (25, NULL, NULL, '厚德苑社区', 1578810930, '陕西省咸阳市迎宾大道、厚德苑小区', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, NULL, 0, NULL, NULL, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (27, NULL, NULL, '咸阳机场社区', 1579146545, '咸阳机场办公区', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 3016, 3017, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (28, NULL, NULL, '空港花园社区', 1579221558, '周公大道', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 3016, 3017, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (34, NULL, NULL, '西安咸阳国际机场', 1581762529, '请下单前阅读首页购买须知（客服热线：18729404118）', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 3016, 3017, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (38, NULL, NULL, '西安市区', 1582100923, '提前24h预定，50份起订（客服热线：18729404118）', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 2899, 2900, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (39, NULL, NULL, '西咸新区', 1582100974, '提前24h预定，50份起订（客服热线：18729404118）', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg10390', 0, 0, 2898, 0, 3016, 3017, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (40, NULL, NULL, '咸阳市区', 1582101013, '提前24h预定，50份起订（客服热线：18729404118）', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 0, 2898, 0, 2931, 2932, NULL);
INSERT INTO `dd_diandi_shop_areas` VALUES (41, NULL, NULL, '机场厂区', 1583922267, '具体地址', '202003/11/2add4834-a36f-3968-90c5-34ee0d77519b.jpg', 0, 20, 2572, 0, 2631, 2636, 1583922087);
INSERT INTO `dd_diandi_shop_areas` VALUES (42, 29, 3, '商户2配送点', 1589612284, '复合物', '202005/16/00d0fdb4-e5df-3a34-978d-00de867e9259.jpg', 0, 12, 37, 0, 197, 205, 1589612284);

-- ----------------------------
-- Table structure for dd_diandi_shop_cart
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_cart`;
CREATE TABLE `dd_diandi_shop_cart`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL COMMENT '用户id',
  `goods_id` int(11) NULL DEFAULT NULL COMMENT '商品id',
  `spec_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT '0' COMMENT '规格组合id',
  `spec_val` varchar(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '规格组合名称',
  `number` int(11) NOT NULL DEFAULT 0 COMMENT '数量',
  `goods_price` decimal(10, 2) NULL DEFAULT 0.00,
  `total_price` decimal(10, 2) NULL DEFAULT NULL COMMENT '总价格',
  `line_price` decimal(10, 2) NULL DEFAULT 0.00,
  `create_time` int(11) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 131 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci COMMENT = '购物车' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_cart
-- ----------------------------
INSERT INTO `dd_diandi_shop_cart` VALUES (89, NULL, NULL, 92, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1587097256);
INSERT INTO `dd_diandi_shop_cart` VALUES (67, NULL, NULL, 77, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1586935840);
INSERT INTO `dd_diandi_shop_cart` VALUES (68, NULL, NULL, 77, 23, '29_30_32', '熟_生_小的', 1, 150.00, 150.00, 344.00, 1586935845);
INSERT INTO `dd_diandi_shop_cart` VALUES (82, NULL, NULL, 85, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1587009917);
INSERT INTO `dd_diandi_shop_cart` VALUES (77, NULL, NULL, 84, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1587000283);
INSERT INTO `dd_diandi_shop_cart` VALUES (83, NULL, NULL, 86, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1587012330);
INSERT INTO `dd_diandi_shop_cart` VALUES (84, NULL, NULL, 86, 28, '33_35', '基础版_基础服务', 2, 0.50, 1.00, 1.00, 1587012333);
INSERT INTO `dd_diandi_shop_cart` VALUES (88, NULL, NULL, 92, 28, '33_35', '基础版_基础服务', 1, 0.50, 0.50, 1.00, 1587097251);
INSERT INTO `dd_diandi_shop_cart` VALUES (86, NULL, NULL, 88, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1587040259);
INSERT INTO `dd_diandi_shop_cart` VALUES (90, NULL, NULL, 82, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1587100486);
INSERT INTO `dd_diandi_shop_cart` VALUES (91, NULL, NULL, 93, 25, '0', '', 1, 459.00, 459.00, 510.00, 1587188720);
INSERT INTO `dd_diandi_shop_cart` VALUES (92, NULL, NULL, 93, 27, '0', '', 1, 355.00, 355.00, 410.00, 1587188726);
INSERT INTO `dd_diandi_shop_cart` VALUES (93, NULL, NULL, 83, 28, '33_36', '基础版_至尊服务', 5, 0.50, 2.50, 1.00, 1587299159);
INSERT INTO `dd_diandi_shop_cart` VALUES (94, NULL, NULL, 83, 23, '29_30_31', '熟_生_大的', 1, 200.00, 200.00, 344.00, 1587299168);
INSERT INTO `dd_diandi_shop_cart` VALUES (97, NULL, NULL, 97, 25, '0', '', 2, 459.00, 918.00, 510.00, 1587529302);
INSERT INTO `dd_diandi_shop_cart` VALUES (98, NULL, NULL, 99, 27, '0', '', 5, 355.00, 1775.00, 410.00, 1587538666);
INSERT INTO `dd_diandi_shop_cart` VALUES (99, NULL, NULL, 99, 26, '0', '', 7, 499.00, 3493.00, 526.00, 1587538672);
INSERT INTO `dd_diandi_shop_cart` VALUES (101, NULL, NULL, 79, 27, '0', '', 1, 355.00, 355.00, 410.00, 1587629533);
INSERT INTO `dd_diandi_shop_cart` VALUES (102, NULL, NULL, 79, 23, '29_30_32', '熟_生_小的', 2, 150.00, 300.00, 344.00, 1587629558);
INSERT INTO `dd_diandi_shop_cart` VALUES (103, NULL, NULL, 79, 26, '0', '', 1, 499.00, 499.00, 526.00, 1587629571);
INSERT INTO `dd_diandi_shop_cart` VALUES (118, NULL, NULL, 76, 23, '29_30_31', '熟_生_大的', 4, 200.00, 800.00, 344.00, 1589158522);
INSERT INTO `dd_diandi_shop_cart` VALUES (120, 43, 4, 417, 63, '20_7', '紫色_xxl', 3, 2.00, 6.00, 3.00, 1594555137);
INSERT INTO `dd_diandi_shop_cart` VALUES (121, 43, 4, 417, 62, '0', '', 1, 34.00, 34.00, 45.00, 1594555142);
INSERT INTO `dd_diandi_shop_cart` VALUES (122, 43, 4, 417, 62, '0', '', 1, 34.00, 34.00, 45.00, 1594555142);
INSERT INTO `dd_diandi_shop_cart` VALUES (123, 43, 4, 418, 63, '20_7', '紫色_xxl', 1, 2.00, 2.00, 3.00, 1594562427);
INSERT INTO `dd_diandi_shop_cart` VALUES (124, 43, 4, 418, 63, '20_7', '紫色_xxl', 1, 2.00, 2.00, 3.00, 1594562427);
INSERT INTO `dd_diandi_shop_cart` VALUES (125, 43, 4, 418, 62, '0', '', 1, 34.00, 34.00, 45.00, 1594562431);
INSERT INTO `dd_diandi_shop_cart` VALUES (126, 43, 4, 418, 62, '0', '', 1, 34.00, 34.00, 45.00, 1594562431);
INSERT INTO `dd_diandi_shop_cart` VALUES (128, 43, 4, 424, 62, '0', '', 7, 34.00, 238.00, 45.00, 1594606589);
INSERT INTO `dd_diandi_shop_cart` VALUES (129, 43, 4, 426, 61, '0', '', 2, 12.00, 24.00, 34.00, 1594641785);

-- ----------------------------
-- Table structure for dd_diandi_shop_category
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_category`;
CREATE TABLE `dd_diandi_shop_category`  (
  `category_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `parent_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `image_id` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `sort` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`category_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10065 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分类管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_category
-- ----------------------------
INSERT INTO `dd_diandi_shop_category` VALUES (10034, 43, 4, '洛川苹果', 10033, '202003/10/3b2c68c3-e1a1-32a0-b183-ad1d92a384b3.jpg', 1, 0, 0, 0);
INSERT INTO `dd_diandi_shop_category` VALUES (10037, 43, 4, '富平柿饼', 10033, '', 1, 0, 0, 0);
INSERT INTO `dd_diandi_shop_category` VALUES (10038, 43, 4, '蛋糕', 10035, '', 1, 0, 0, 0);
INSERT INTO `dd_diandi_shop_category` VALUES (10039, 43, 4, '甜点', 10035, '', 3, 0, 0, 0);
INSERT INTO `dd_diandi_shop_category` VALUES (10040, 43, 4, '照相机', 0, '202007/12/46513df6-c836-377e-ab77-90c873d1e94d.jpg', 1, 0, 0, 1594552918);
INSERT INTO `dd_diandi_shop_category` VALUES (10041, 43, 4, '照相机', 10040, '202006/25/02430ba6-3956-3bf9-af21-0e0e0a1675aa.png', 2, 0, 0, 1593053867);
INSERT INTO `dd_diandi_shop_category` VALUES (10044, 43, 4, '投影仪', 0, '202007/12/dc5c6e95-f240-3f2b-b6d6-6bb37d8dd6c0.jpg', 3, 0, 0, 1594552946);
INSERT INTO `dd_diandi_shop_category` VALUES (10045, 43, 4, '投影仪', 10044, '202004/01/9ae70ef5-b078-3017-96e7-ae4394970606.jpg', 4, 0, 0, 0);
INSERT INTO `dd_diandi_shop_category` VALUES (10046, 43, 4, '打印机', 0, '202007/12/56fdcf71-377a-3d8a-831b-2546fc976cdb.jpg', 4, 0, 0, 1594552961);
INSERT INTO `dd_diandi_shop_category` VALUES (10047, 43, 4, '打印机', 10046, '202004/01/3e963eea-e5b9-308f-857b-abd9f6dcd6d8.jpg', 6, 0, 0, 0);
INSERT INTO `dd_diandi_shop_category` VALUES (10048, 43, 4, '扫描仪', 0, '202007/12/1aedd7ba-3198-3440-b1b1-810428b6dcd5.jpg', 8, 0, 0, 1594552977);
INSERT INTO `dd_diandi_shop_category` VALUES (10049, 43, 4, '扫描仪', 10048, '202004/01/09130816-1708-3b51-a187-548e32360070.jpg', 9, 0, 0, 0);
INSERT INTO `dd_diandi_shop_category` VALUES (10051, 43, 4, '67', 10050, '', 6, 0, 1593057231, 1593057231);
INSERT INTO `dd_diandi_shop_category` VALUES (10053, 43, 4, '子类a', 10052, '202007/07/b8626bfe-0e8b-38d6-adea-639915c5a881.jpg', 1, 0, 1594098244, 1594098244);
INSERT INTO `dd_diandi_shop_category` VALUES (10054, 43, 4, '子类b', 10052, '202007/07/bfc6907e-c5ac-3728-9ec8-3587aadb33e7.png', 1, 0, 1594098298, 1594098298);
INSERT INTO `dd_diandi_shop_category` VALUES (10056, 43, 4, '子类1', 10055, '202007/07/eefcf5ae-5059-3815-a74c-9ad743e84afa.png', 1, 0, 1594098403, 1594098403);
INSERT INTO `dd_diandi_shop_category` VALUES (10057, 43, 4, '智能穿戴', 10058, '202007/13/13314837-7d99-3894-b761-e2b632770b8d.png', 6, 0, 1594602852, 1594603438);
INSERT INTO `dd_diandi_shop_category` VALUES (10058, 43, 4, '智能穿戴', 0, '202007/13/0d786bac-91d8-3892-91c0-bf710f534d6f.png', 0, 0, 1594603394, 1594603394);
INSERT INTO `dd_diandi_shop_category` VALUES (10059, 43, 4, '健康家居', 0, '202007/13/45a123a2-b41f-3701-b05d-b214a6147ce8.jpg', 7, 0, 1594613664, 1594613664);
INSERT INTO `dd_diandi_shop_category` VALUES (10060, 43, 4, '枕头', 10059, '202007/13/9973c8d5-1f62-31d8-967d-75f5eaadf3d5.jpg', 0, 0, 1594613707, 1594613707);
INSERT INTO `dd_diandi_shop_category` VALUES (10061, 43, 4, '检测', 0, '202007/14/bd6cb9b9-22be-377e-8227-729c2677399e.jpg', 0, 0, 1594708996, 1594709640);
INSERT INTO `dd_diandi_shop_category` VALUES (10062, 43, 4, '体适能', 10061, '202007/14/a5a6cd4c-0dcb-3fad-91b6-e518d86096a3.jpg', 0, 0, 1594709052, 1594709052);
INSERT INTO `dd_diandi_shop_category` VALUES (10063, 44, 5, '智能硬件', 0, '', 0, 0, 1595079956, 1595079956);
INSERT INTO `dd_diandi_shop_category` VALUES (10064, 44, 5, '打印机', 10063, '', 0, 0, 1595079970, 1595079970);

-- ----------------------------
-- Table structure for dd_diandi_shop_comment
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_comment`;
CREATE TABLE `dd_diandi_shop_comment`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `user_id` int(11) NULL DEFAULT NULL COMMENT '评论人',
  `comment` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '评论内容',
  `order_id` int(11) NULL DEFAULT NULL,
  `images` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `update_time` int(30) NULL DEFAULT NULL,
  `create_time` int(30) NULL DEFAULT NULL COMMENT '评论时间',
  `status` tinyint(255) NULL DEFAULT 0 COMMENT '是否审核',
  `star_level` int(11) NULL DEFAULT NULL COMMENT '星级',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 10 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci COMMENT = '商家评论' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_comment
-- ----------------------------
INSERT INTO `dd_diandi_shop_comment` VALUES (2, NULL, NULL, 76, '45678', NULL, '202003/19/526551b0-073c-3d91-9e63-825c6291c677.jpg,202003/19/3428b230-e9c6-3856-a4e4-2d8cf3a9b7f9.jpg,202003/19/91824eae-674e-3d46-bd24-49de1e34242c.jpg', 1584618547, 1588079922, 1, 1);
INSERT INTO `dd_diandi_shop_comment` VALUES (3, NULL, NULL, 76, '45678', NULL, '202003/19/a3e1378f-df4e-3f65-9d39-9e81f4e45637.jpg,202003/19/54e7a81b-3af8-31a0-bbd0-2162f34bbe59.jpg,202003/19/88206fe3-939c-30c9-95ef-efa804558c74.jpg,202003/19/fdad358b-4230-3c45-a783-aab679c5ff48.jpg', 1584618583, 1588079929, 1, 1);
INSERT INTO `dd_diandi_shop_comment` VALUES (4, NULL, NULL, 76, '45678', NULL, '202003/19/a3e1378f-df4e-3f65-9d39-9e81f4e45637.jpg,202003/19/54e7a81b-3af8-31a0-bbd0-2162f34bbe59.jpg,202003/19/88206fe3-939c-30c9-95ef-efa804558c74.jpg,202003/19/fdad358b-4230-3c45-a783-aab679c5ff48.jpg', 1584618623, 1588080242, 1, 1);
INSERT INTO `dd_diandi_shop_comment` VALUES (5, NULL, NULL, 76, '45678', NULL, '202003/19/a3e1378f-df4e-3f65-9d39-9e81f4e45637.jpg,202003/19/54e7a81b-3af8-31a0-bbd0-2162f34bbe59.jpg,202003/19/88206fe3-939c-30c9-95ef-efa804558c74.jpg,202003/19/fdad358b-4230-3c45-a783-aab679c5ff48.jpg', 1584618629, 1588080668, 1, 1);
INSERT INTO `dd_diandi_shop_comment` VALUES (6, NULL, NULL, 76, '而给他人', NULL, '202003/19/2177afbf-cc19-34a6-aa86-e125f6de6d6f.jpg,202003/19/badd22e7-3728-3cbf-8253-e159e62645c5.jpg,202003/19/c1495a18-7e38-3873-9ea8-123af88feccd.jpg', 1584619130, 1588126661, 0, 1);
INSERT INTO `dd_diandi_shop_comment` VALUES (7, NULL, NULL, 76, '污染土壤', NULL, '202003/19/72d1c388-1447-39da-a81e-1d0334849263.jpg,202003/19/c18c5d40-276a-38bd-b2ea-0485e5b2bbac.png,202003/19/41557688-69d4-376f-937f-16fdfe477aa3.png,202003/19/cdcf2d5e-de44-3b01-8583-9e0a2af57077.jpg', 1584621687, 1584621687, 0, 4);
INSERT INTO `dd_diandi_shop_comment` VALUES (8, NULL, NULL, 76, '评价', 156, '202003/19/c79b1881-919b-38cc-9d91-b52719e4060f.jpg,202003/19/948de7c4-5c2e-31a1-8fdc-ba1dffcebc0e.jpg,202003/19/620213f5-5f40-3dbc-bdda-2100267f3a36.jpg', 1584622201, 1584622201, 0, 5);
INSERT INTO `dd_diandi_shop_comment` VALUES (9, 38, 1, 2, '243', NULL, 'a:1:{i:0;s:50:\"202006/20/13f914a6-4794-3e1e-9669-663ddaab269f.png\";}', 1592583624, 1592583752, 1, 0);

-- ----------------------------
-- Table structure for dd_diandi_shop_delivery
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_delivery`;
CREATE TABLE `dd_diandi_shop_delivery`  (
  `delivery_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `method` tinyint(3) UNSIGNED NOT NULL DEFAULT 10,
  `sort` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `province` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `city` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `district` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`delivery_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10006 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_delivery
-- ----------------------------
INSERT INTO `dd_diandi_shop_delivery` VALUES (10001, NULL, NULL, '陕西区域', 10, 100, 4, 1574556909, 4294967295, NULL, NULL, NULL);
INSERT INTO `dd_diandi_shop_delivery` VALUES (10002, NULL, NULL, '邮政', 20, 1, 5, 1574595963, 1574595963, NULL, NULL, NULL);
INSERT INTO `dd_diandi_shop_delivery` VALUES (10003, NULL, NULL, '通过运费', 10, 100, 7, 1575992319, 1575992319, NULL, NULL, NULL);
INSERT INTO `dd_diandi_shop_delivery` VALUES (10004, NULL, NULL, '突然又让他', 10, 5, 0, 1577638173, 1577638066, NULL, NULL, NULL);
INSERT INTO `dd_diandi_shop_delivery` VALUES (10005, NULL, NULL, '突然又让他', 11, 5, 0, 1577638427, 1577638427, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for dd_diandi_shop_delivery_rule
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_delivery_rule`;
CREATE TABLE `dd_diandi_shop_delivery_rule`  (
  `rule_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `delivery_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `region` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `first` double UNSIGNED NOT NULL DEFAULT 0,
  `first_fee` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `additional` double UNSIGNED NOT NULL DEFAULT 0,
  `additional_fee` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL,
  PRIMARY KEY (`rule_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10004 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_delivery_rule
-- ----------------------------
INSERT INTO `dd_diandi_shop_delivery_rule` VALUES (10001, NULL, NULL, 10001, '2899,2913,2918,2931,2946,2958,2972,2984,2997,3008,3016', 1, 0.00, 0, 0.00, 4, 1574556909);
INSERT INTO `dd_diandi_shop_delivery_rule` VALUES (10002, NULL, NULL, 10002, '2,20,38,61,76,84,104,124,150,168,180,197,208,221,232,244,250,264,271,278,290,304,319,337,352,362,372,376,389,398,407,422,430,442,449,462,467,481,492,500,508,515,522,530,537,545,553,558,566,574,581,586,597,607,614,619,627,634,640,646,656,675,692,702,711,720,730,748,759,764,775,782,793,802,821,833,842,853,861,871,880,887,896,906,913,920,927,934,948,960,972,980,986,993,1003,1010,1015,1025,1035,1047,1057,1066,1074,1081,1088,1093,1098,1110,1118,1127,1136,1142,1150,1155,1160,1169,1183,1190,1196,1209,1222,1234,1245,1253,1264,1274,1279,1285,1299,1302,1306,1325,1339,1350,1362,1376,1387,1399,1408,1415,1421,1434,1447,1459,1466,1471,1476,1479,1492,1504,1513,1522,1533,1546,1556,1572,1583,1593,1599,1612,1623,1630,1637,1643,1650,1664,1674,1685,1696,1707,1710,1724,1731,1740,1754,1764,1768,1774,1782,1791,1802,1809,1813,1822,1828,1838,1848,1854,1867,1880,1890,1900,1905,1912,1924,1936,1949,1955,1965,1977,1988,1999,2003,2011,2017,2025,2035,2041,2050,2056,2065,2070,2077,2082,2091,2123,2146,2150,2156,2163,2177,2189,2207,2215,2220,2225,2230,2236,2245,2258,2264,2276,2283,2292,2297,2302,2306,2324,2363,2368,2388,2395,2401,2409,2416,2426,2434,2440,2446,2458,2468,2475,2486,2493,2501,2510,2516,2521,2535,2554,2573,2584,2589,2604,2611,2620,2631,2640,2657,2671,2686,2696,2706,2712,2724,2730,2741,2750,2761,2775,2784,2788,2801,2807,2812,2817,2826,2845,2857,2870,2882,2890,2899,2913,2918,2931,2946,2958,2972,2984,2997,3008,3016,3023,3032,3036,3039,3045,3053,3058,3065,3073,3081,3090,3098,3108,3117,3127,3135,3142,3147,3152,3158,3165,3172,3179,3186,3190,3196,3202,3207,3216,3221,3225,3229,3237,3242,3252,3262,3267,3280,3289,3301,3309,3317,3326,3339,3378,3386,3416,3454,3458,3461,3491,3504,3518,3532,3551,3578,3592,3613,3632,3666,3683,3697,3704,3711,3717,3722,3728,3739,3745,3747', 1, 10.00, 0, 0.00, 5, 1574595963);
INSERT INTO `dd_diandi_shop_delivery_rule` VALUES (10003, NULL, NULL, 10003, '2,20,38,61,76,84,104,124,150,168,180,197,208,221,232,244,250,264,271,278,290,304,319,337,352,362,372,376,389,398,407,422,430,442,449,462,467,481,492,500,508,515,522,530,537,545,553,558,566,574,581,586,597,607,614,619,627,634,640,646,656,675,692,702,711,720,730,748,759,764,775,782,793,802,821,833,842,853,861,871,880,887,896,906,913,920,927,934,948,960,972,980,986,993,1003,1010,1015,1025,1035,1047,1057,1066,1074,1081,1088,1093,1098,1110,1118,1127,1136,1142,1150,1155,1160,1169,1183,1190,1196,1209,1222,1234,1245,1253,1264,1274,1279,1285,1299,1302,1306,1325,1339,1350,1362,1376,1387,1399,1408,1415,1421,1434,1447,1459,1466,1471,1476,1479,1492,1504,1513,1522,1533,1546,1556,1572,1583,1593,1599,1612,1623,1630,1637,1643,1650,1664,1674,1685,1696,1707,1710,1724,1731,1740,1754,1764,1768,1774,1782,1791,1802,1809,1813,1822,1828,1838,1848,1854,1867,1880,1890,1900,1905,1912,1924,1936,1949,1955,1965,1977,1988,1999,2003,2011,2017,2025,2035,2041,2050,2056,2065,2070,2077,2082,2091,2123,2146,2150,2156,2163,2177,2189,2207,2215,2220,2225,2230,2236,2245,2258,2264,2276,2283,2292,2297,2302,2306,2324,2363,2368,2388,2395,2401,2409,2416,2426,2434,2440,2446,2458,2468,2475,2486,2493,2501,2510,2516,2521,2535,2554,2573,2584,2589,2604,2611,2620,2631,2640,2657,2671,2686,2696,2706,2712,2724,2730,2741,2750,2761,2775,2784,2788,2801,2807,2812,2817,2826,2845,2857,2870,2882,2890,2899,2913,2918,2931,2946,2958,2972,2984,2997,3008,3016,3023,3032,3036,3039,3045,3053,3058,3065,3073,3081,3090,3098,3108,3117,3127,3135,3142,3147,3152,3158,3165,3172,3179,3186,3190,3196,3202,3207,3216,3221,3225,3229,3237,3242,3252,3262,3267,3280,3289,3301,3309,3317,3326,3339,3378,3386,3416,3454,3458,3461,3491,3504,3518,3532,3551,3578,3592,3613,3632,3666,3683,3697,3704,3711,3717,3722,3728,3739,3745,3747', 1, 10.00, 8, 5.00, 7, 1575992319);

-- ----------------------------
-- Table structure for dd_diandi_shop_goods
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_goods`;
CREATE TABLE `dd_diandi_shop_goods`  (
  `goods_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商户id',
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '公司id',
  `goods_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品名称',
  `category_pid` int(11) NULL DEFAULT NULL COMMENT '商品父级分类',
  `stock` int(11) NULL DEFAULT 0 COMMENT '库存',
  `video` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品视频',
  `category_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品分类',
  `spec_type` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否开启多规格',
  `deduct_stock_type` tinyint(3) UNSIGNED NOT NULL DEFAULT 20 COMMENT '库存减少方式',
  `thumb` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品主图',
  `line_price` decimal(10, 2) NULL DEFAULT NULL COMMENT '市场价格',
  `goods_weight` decimal(10, 0) NULL DEFAULT NULL COMMENT '商品重量',
  `goods_price` decimal(10, 2) NULL DEFAULT NULL COMMENT '商品售价',
  `content` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '商品介绍',
  `sales_initial` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '虚拟销量',
  `sales_actual` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '真实销量',
  `goods_sort` int(11) UNSIGNED NOT NULL DEFAULT 100 COMMENT '商品排序',
  `delivery_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '运费模板',
  `goods_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 10 COMMENT '商品是否上架0下架1上架',
  `is_delete` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否删除',
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `images` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '商品相册',
  `browse` int(11) NULL DEFAULT 0,
  `label` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`goods_id`) USING BTREE,
  INDEX `category_id`(`category_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 71 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_goods
-- ----------------------------
INSERT INTO `dd_diandi_shop_goods` VALUES (30, 43, 4, '打印机，三星品牌，优质服务', 10040, 12, '', 10041, 0, 20, '202007/12/4bfe9fba-196f-33cd-96a6-bbd951998f74.jpg', 23.00, 213, 10.00, '<p>打印机，三星品牌，优质服务</p>', 23, 0, 2, 0, 1, 0, 0, 1589551782, 1594553033, 'a:2:{i:0;s:50:\"202007/12/fe18e766-4930-3f67-8cac-5697b4d2682c.jpg\";i:1;s:50:\"202007/12/91bfe65d-6892-31f6-b0b0-d38f738768c4.jpg\";}', 0, '');
INSERT INTO `dd_diandi_shop_goods` VALUES (31, 43, 4, '投影仪', 10044, 12, '', 10045, 0, 20, '202007/12/c894805f-d13d-34fe-b137-ad55f75e38e6.jpg', 34.00, 213, 12.00, '<p>投影仪</p>', 34, 0, 24, 0, 1, 0, 0, 1589551905, 1594553075, 'a:1:{i:0;s:50:\"202007/12/bfea0df4-f579-33ce-a010-77991cbdb04b.jpg\";}', 0, '');
INSERT INTO `dd_diandi_shop_goods` VALUES (61, 43, 4, '联想打印机', 10046, 344, '', 10047, 0, 20, '202007/12/43ea95f8-4460-3231-a4ca-9f8c409664cc.jpg', 34.00, 213, 12.00, '<p>联想打印机</p>', 346, 1, 657, 0, 0, 0, 0, 1592317659, 1594553122, 'a:2:{i:0;s:50:\"202007/12/72ba9dab-52ca-344a-8547-4b49e62ce9a8.jpg\";i:1;s:50:\"202007/12/7b2623d9-827b-332e-b3d1-aa0821941dec.jpg\";}', 45, '');
INSERT INTO `dd_diandi_shop_goods` VALUES (62, 43, 4, '麦克风', 10040, 45, '', 10041, 0, 10, '202007/12/1bdf9c72-2593-3389-8017-f2e80eff7c74.jpg', 45.00, 213, 34.00, '<p>麦克风</p>', 34, 0, 23, 0, 0, 0, 0, 1592318640, 1594553160, 'a:1:{i:0;s:50:\"202007/12/5505b044-1fbd-34d8-a168-fda2b45da6b4.jpg\";}', 24, '');
INSERT INTO `dd_diandi_shop_goods` VALUES (63, 43, 4, '键盘鼠标套装', 10040, 4, '', 10041, 1, 20, '202007/12/2eb5233c-fe5b-3134-9be2-2db1bbebd3cc.jpg', 23.00, 213, 10.00, '<p>键盘鼠标套装</p>', 23, 0, 2, 0, 0, 0, 0, 1592453709, 1594553200, 'a:1:{i:0;s:50:\"202007/12/85083e76-59d2-399c-a605-4d1c6d1c3eea.jpg\";}', 44, '');
INSERT INTO `dd_diandi_shop_goods` VALUES (64, 43, 4, '路由器', 10040, 12, '', 10041, 1, 20, '202007/12/53e6bc41-8aab-375f-a5ab-9ae27a9c0551.jpg', 56.00, 54, 45.00, '<p>路由器</p>', 65, 0, 23, 0, 0, 0, 0, 1592643940, 1594553239, 'a:1:{i:0;s:50:\"202007/12/c5efb879-0e49-3dfd-96bb-e73cc363cf20.jpg\";}', 33, '');
INSERT INTO `dd_diandi_shop_goods` VALUES (67, 43, 4, '智能健康手表', 10058, 1000, '', 10057, 1, 10, '202007/13/8dbded6d-aa9e-3366-b63f-19a965ba7690.png', 1500.00, 50, 1000.00, '<p style=\"text-align: center;\"><span style=\"font-size: 20px;\">智能健康手表</span></p><p style=\"text-align: center;\"><span style=\"font-size: 20px;\">心电、心率测量、超长待机续航、专业健康管理</span></p><p style=\"text-align: center;\"><img width=\"729\" src=\"http://demo.hopesfire.com/attachment/diandi_shop/image/20200713/1594603606372582.png\" title=\"1594603606372582.png\" alt=\"1594603582(1).png\" height=\"576\"/></p>', 5, 0, 1, 0, 0, 0, 0, 1594603639, 1594710519, 'a:1:{i:0;s:50:\"202007/13/698d1591-346c-3d8f-96ab-d41510b4b6b1.png\";}', 1, '健康');
INSERT INTO `dd_diandi_shop_goods` VALUES (68, 43, 4, '蝶形颈椎枕', 10059, 1000, '', 10060, 0, 10, '202007/13/ccbf172a-a614-3a79-956d-40da12b7bdec.jpg', 250.00, 100, 200.00, '<p><span style=\"color: rgb(51, 51, 51); font-family: arial, 宋体, sans-serif; font-size: 14px; text-indent: 28px; background-color: rgb(255, 255, 255);\">蝶形增强款颈椎保健枕，全面照顾人体侧睡、仰睡时的人体颈部区域。枕头中间高度偏低，并设计有凸出延伸部分托扶脊态，适合平躺；而枕头两侧微高，同时增加外倾弧度，主动适应人体侧睡需求。</span></p><p style=\"text-align: center;\"><span style=\"color: rgb(51, 51, 51); font-family: arial, 宋体, sans-serif; font-size: 14px; text-indent: 28px; background-color: rgb(255, 255, 255);\"><img width=\"100%\" src=\"http://demo.hopesfire.com/attachment/diandi_shop/image/20200713/1594613850153479.jpg\" title=\"1594613850153479.jpg\" alt=\"32fa828ba61ea8d383a372de960a304e241f5862.jpg\"/></span></p><p><span style=\"color: rgb(51, 51, 51); font-family: arial, 宋体, sans-serif; font-size: 14px; text-indent: 28px; background-color: rgb(255, 255, 255);\"></span></p><h3 class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\">释压助眠</h3><p>舒适柔软的触感和均匀完整的支撑，让人体完全放松，消除紧张和压力，从而很快的进入睡眠状态。选用顶级的温感记忆绵材料，最大的特点是具有黏弹性和温感性，当它接触到人体时，会发生温度感应，起到吸收压力和抵消反弹力的作用，并使头颈肩部接触面无压迫感，血脉通畅，体现真正的零压力感觉；科学的设计更符合更符合人体头部、颈部、肩部三处人体工学原理：和头颈生理曲度一致的造型设计，使用时高端枕颈，低端枕头，更科学自然；中间微凹及凹下圆弧处为头部、颈部提供更正确的支撑；前面斜度对颈部、肩部提供更好的支撑；两侧微高2厘米，更符合翻身和侧睡时颈部被肩膀抬高的高度；底面凹沟槽增加枕头柔软度，更好地包容头颈，化解人体压力，不阻碍血液循环，不易产生疲劳及酸痛，减少睡眠过程中不必要的翻身次数，使休息质量成倍提高！</p><p><a class=\"lemma-anchor para-title\" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a></p><h3 class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\">科学护颈</h3><p>人体的脊椎可以分为四个生理弯曲：颈曲、胸曲、腰曲和骶曲，从侧面看成一个“S”形，其中颈曲向前凸,胸曲向后凸,腰曲向前凸，骶曲向后凸。为了迎合人体的这种特殊的曲线要求，金口碑经过多次研究生产出了这款蝶形枕，枕芯外形依据人体生理的弯曲曲线，按人体工程学，经电脑CAD精心设计而成，完全符合人体工程学和脑波图原理。独创了“蝴蝶型颈枕帖扶系统”，中间贴近颈部部分的凹弧设计，贴合头部部分的凹槽设计，可以对颈椎、头部全程托扶，睡眠再长，脊椎都轻松、健康。人性化的蝶形设计及高超的生产技术，结合力学及人体工学，有效支撑颈部，保证您时刻能保持最正确自然姿势，让您快速进入良好的睡眠状态。根据人体头颈部的生理曲线设计，高端枕颈，低端枕头，完美支撑头部与颈椎，彻底放松头、颈、肩的肌肉和神经，彻底改变老式枕头颈部悬空、生理曲度扭曲的状况，避免传统睡枕不科学曲度家中颈椎不适的问题。</p><p><a class=\"lemma-anchor para-title\" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a></p><h3 class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\">透气护肤</h3><p>采用上下穿孔设计，透气性更佳，排汗功能更强，枕头不易受潮，能够有效的避免脸部过敏问题。会呼吸枕头的人性化设计，在您翻身的同时，穿孔的枕头能够进行一次大的呼吸，让您感受到夏日里的凉气，享受高品质的睡眠。</p><p><a class=\"lemma-anchor para-title\" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a><a class=\"lemma-anchor \" style=\"color: rgb(19, 110, 194); position: absolute; top: -50px;\"></a></p><p><span style=\"color: rgb(51, 51, 51); font-family: arial, 宋体, sans-serif; font-size: 14px; text-indent: 28px; background-color: rgb(255, 255, 255);\"><br/></span><br/></p>', 312, 0, 7, 0, 0, 0, 0, 1594613890, 1594710488, 'a:1:{i:0;s:50:\"202007/13/015bb3e0-cf8c-3ee5-9dca-f66b5d504318.jpg\";}', 1, '健康');
INSERT INTO `dd_diandi_shop_goods` VALUES (69, 43, 4, '心电记录仪', 10058, 1000, '', 10057, 0, 10, '202007/13/705abf01-23ff-307e-8ac6-72a2cf50dbf1.png', 1500.00, 10, 1000.00, '<p>心知了，更知你心<br/></p>', 5, 0, 3, 0, 0, 0, 0, 1594614351, 1594710504, 'a:1:{i:0;s:50:\"202007/13/1d81a02c-369b-3c3a-866e-b84d454e066e.png\";}', 2, '健康');
INSERT INTO `dd_diandi_shop_goods` VALUES (70, 44, 5, '店滴ai-打印机', 10063, 999, '', 10064, 0, 10, '202007/18/7d1e2677-c7f3-3066-988d-8ae078a052c7.jpg', 1200.00, 12, 899.00, '<p>店滴ai-打印机</p>', 55, 0, 2, 0, 0, 0, 0, 1595080038, 1595083595, 'a:1:{i:0;s:50:\"202007/18/1e60c8bc-35a0-38b9-921a-a712323f5166.jpg\";}', 0, '');

-- ----------------------------
-- Table structure for dd_diandi_shop_goods_image
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_goods_image`;
CREATE TABLE `dd_diandi_shop_goods_image`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `goods_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `image_id` int(11) NOT NULL,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_goods_image
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_shop_goods_label
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_goods_label`;
CREATE TABLE `dd_diandi_shop_goods_label`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商户id',
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '公司id',
  `label` varchar(4) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '商品标签',
  `color` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '标签颜色',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `store_id`(`store_id`, `bloc_id`, `label`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 16 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_goods_label
-- ----------------------------
INSERT INTO `dd_diandi_shop_goods_label` VALUES (9, 32, 2, '就得', '#ff0000');
INSERT INTO `dd_diandi_shop_goods_label` VALUES (14, 38, 1, '好的', '#2E547B');
INSERT INTO `dd_diandi_shop_goods_label` VALUES (15, 43, 4, '健康', '#409EFF');

-- ----------------------------
-- Table structure for dd_diandi_shop_goods_param
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_goods_param`;
CREATE TABLE `dd_diandi_shop_goods_param`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '公司id',
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商户id',
  `goods_id` int(10) NULL DEFAULT 0 COMMENT '商品id',
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '属性名称',
  `value` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '属性值',
  `displayorder` int(11) NULL DEFAULT 0 COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 39 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_goods_param
-- ----------------------------
INSERT INTO `dd_diandi_shop_goods_param` VALUES (23, NULL, NULL, 16, '第一属性89005', '345', 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (24, NULL, NULL, 16, '第二属性', '3234354', 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (25, NULL, NULL, 16, '第一属性55', '345', 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (26, NULL, NULL, 16, '第一属性89', '345', 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (27, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (28, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (29, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (30, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (31, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (32, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (33, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (34, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (35, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (36, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (37, NULL, NULL, 0, '', NULL, 0);
INSERT INTO `dd_diandi_shop_goods_param` VALUES (38, NULL, NULL, 16, '新的一个额', '343434343', 0);

-- ----------------------------
-- Table structure for dd_diandi_shop_goods_spec
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_goods_spec`;
CREATE TABLE `dd_diandi_shop_goods_spec`  (
  `goods_spec_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商品属性id',
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商户的',
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '公司id',
  `goods_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品id',
  `goods_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品编码',
  `goods_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '销售价格',
  `line_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '市场价格',
  `stock_num` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '库存',
  `goods_sales` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品销量',
  `goods_weight` double UNSIGNED NOT NULL DEFAULT 0 COMMENT '重量',
  `spec_sku_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '商品规格组合id',
  `goods_costprice` decimal(10, 2) NULL DEFAULT NULL COMMENT '成本价格',
  `spec_item_thumb` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品属性图片',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`goods_spec_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 300 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_goods_spec
-- ----------------------------
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (33, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '37', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (34, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '39', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (35, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '37', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (36, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '40', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (37, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '38', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (38, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '39', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (39, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '38', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (40, NULL, NULL, 6, '123', 2.00, 3.00, 1, 0, 5, '40', NULL, NULL, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (53, NULL, NULL, 7, '123', 2.00, 3.00, 1, 0, 5, '23_25', NULL, NULL, 1583232006, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (54, NULL, NULL, 7, '123', 2.00, 3.00, 1, 0, 5, '23_26', NULL, NULL, 1583232006, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (55, NULL, NULL, 7, '123', 2.00, 3.00, 1, 0, 5, '24_25', NULL, NULL, 1583232006, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (56, NULL, NULL, 7, '123', 2.00, 3.00, 1, 0, 5, '24_26', NULL, NULL, 1583232006, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (57, NULL, NULL, 8, '123', 2.00, 3.00, 1, 0, 5, '6aab44ceae17acc97f3946a4ae4169d5_9648021d040b0f3b8245ee4e842df62c', NULL, NULL, 1583234360, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (58, NULL, NULL, 8, '123', 2.00, 3.00, 1, 0, 5, '6aab44ceae17acc97f3946a4ae4169d5_811d1ee703b1cd21ce7d2595007e96f8', NULL, NULL, 1583234360, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (59, NULL, NULL, 8, '123', 2.00, 3.00, 1, 0, 5, '74315a26b2fb3d5f1a46955deec72b12_9648021d040b0f3b8245ee4e842df62c', NULL, NULL, 1583234360, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (60, NULL, NULL, 8, '123', 2.00, 3.00, 1, 0, 5, '74315a26b2fb3d5f1a46955deec72b12_811d1ee703b1cd21ce7d2595007e96f8', NULL, NULL, 1583234360, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (108, NULL, NULL, 11, '123', 545.00, 5441.00, 1, 0, 251, '5_8', 12.00, NULL, 1583237271, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (109, NULL, NULL, 11, '123', 545.00, 5441.00, 1, 0, 251, '5_27', 12.00, NULL, 1583237271, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (110, NULL, NULL, 11, '123', 545.00, 5441.00, 1, 0, 251, '6_8', 12.00, NULL, 1583237271, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (111, NULL, NULL, 11, '123', 545.00, 5441.00, 1, 0, 251, '6_27', 12.00, NULL, 1583237271, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (112, NULL, NULL, 11, '123', 545.00, 5441.00, 1, 0, 251, '20_8', 12.00, NULL, 1583237271, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (113, NULL, NULL, 11, '123', 545.00, 5441.00, 1, 0, 251, '20_27', 12.00, NULL, 1583237271, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (115, NULL, NULL, 13, '123', 5.00, 847.00, 1, 0, 4878, '28', 2.00, NULL, 1583237564, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (118, NULL, NULL, 10, '123', 2.00, 3.00, 1, 0, 5, '6_7', 4.00, NULL, 1583244802, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (151, NULL, NULL, 16, '123', 32.00, 43.00, 12, 0, 76, '5_7', 56.00, NULL, 1583251465, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (174, NULL, NULL, 2, '123', 2.00, 3.00, 1, 0, 5, '5_8', 4.00, NULL, 1584648894, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (175, NULL, NULL, 2, '123', 7.00, 8.00, 6, 0, 10, '5_7', 9.00, NULL, 1584648894, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (176, NULL, NULL, 2, '123', 12.00, 13.00, 11, 0, 15, '6_8', 14.00, NULL, 1584648894, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (177, NULL, NULL, 2, '123', 17.00, 18.00, 16, 0, 20, '6_7', 19.00, NULL, 1584648894, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (200, NULL, NULL, 28, '123', 0.50, 1.00, 999, 0, 50, '33_35', 0.20, NULL, 1586427732, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (201, NULL, NULL, 28, '123', 0.50, 1.00, 999, 0, 50, '33_36', 0.20, NULL, 1586427732, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (202, NULL, NULL, 28, '123', 0.50, 1.00, 999, 0, 50, '34_35', 0.20, NULL, 1586427732, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (203, NULL, NULL, 28, '123', 0.50, 1.00, 999, 0, 50, '34_36', 0.20, NULL, 1586427732, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (254, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '5_8_11', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (255, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '5_8_37', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (256, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '5_7_11', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (257, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '5_7_37', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (258, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '6_8_11', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (259, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '6_8_37', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (260, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '6_7_11', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (261, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '6_7_37', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (262, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '20_8_11', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (263, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '20_8_37', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (264, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '20_7_11', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (265, NULL, NULL, 34, '123', 2.00, 3.00, 1, 0, 5, '20_7_37', 4.00, NULL, 1591515873, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (266, NULL, NULL, 35, '123', 2.00, 3.00, 1, 0, 5, '38_40', 4.00, NULL, 1591516846, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (267, NULL, NULL, 35, '123', 2.00, 3.00, 1, 0, 5, '38_41', 4.00, NULL, 1591516846, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (268, NULL, NULL, 35, '123', 2.00, 3.00, 1, 0, 5, '39_40', 4.00, NULL, 1591516846, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (269, NULL, NULL, 35, '123', 2.00, 3.00, 1, 0, 5, '39_41', 4.00, NULL, 1591516846, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (284, NULL, NULL, 23, '123', 200.00, 344.00, 12, 0, 4, '29_30_31', 3.00, NULL, 1594289807, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (285, NULL, NULL, 23, '123', 150.00, 344.00, 12, 0, 4, '29_30_32', 3.00, NULL, 1594289807, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (286, NULL, NULL, 29, '123', 2.00, 3.00, 1, 0, 5, '5_7', 4.00, NULL, 1594549026, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (287, NULL, NULL, 29, '123', 2.00, 3.00, 1, 0, 5, '5_8', 4.00, NULL, 1594549026, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (288, NULL, NULL, 29, '123', 2.00, 3.00, 1, 0, 5, '6_7', 4.00, NULL, 1594549026, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (289, NULL, NULL, 29, '123', 2.00, 3.00, 1, 0, 5, '6_8', 4.00, NULL, 1594549026, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (290, NULL, NULL, 63, '123', 2.00, 3.00, 1, 0, 5, '5_8', 4.00, NULL, 1594553200, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (291, NULL, NULL, 63, '123', 2.00, 3.00, 1, 0, 5, '5_7', 4.00, NULL, 1594553200, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (292, NULL, NULL, 63, '123', 2.00, 3.00, 1, 0, 5, '20_8', 4.00, NULL, 1594553200, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (293, NULL, NULL, 63, '123', 2.00, 3.00, 1, 0, 5, '20_7', 4.00, NULL, 1594553200, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (294, NULL, NULL, 64, '123', 3.00, 4.00, 2, 0, 6, '5_8', 5.00, NULL, 1594553239, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (295, NULL, NULL, 64, '123', 3.00, 4.00, 2, 0, 6, '5_7', 5.00, NULL, 1594553239, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (296, NULL, NULL, 64, '123', 3.00, 4.00, 2, 0, 6, '5_42', 5.00, NULL, 1594553239, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (297, NULL, NULL, 64, '123', 3.00, 4.00, 2, 0, 6, '6_8', 5.00, NULL, 1594553239, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (298, NULL, NULL, 64, '123', 3.00, 4.00, 2, 0, 6, '6_7', 5.00, NULL, 1594553239, 0);
INSERT INTO `dd_diandi_shop_goods_spec` VALUES (299, NULL, NULL, 64, '123', 3.00, 4.00, 2, 0, 6, '6_42', 5.00, NULL, 1594553239, 0);

-- ----------------------------
-- Table structure for dd_diandi_shop_goods_spec_rel
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_goods_spec_rel`;
CREATE TABLE `dd_diandi_shop_goods_spec_rel`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商户id',
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '公司id',
  `goods_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '商品id',
  `thumb` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '商品图片',
  `spec_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '属性id',
  `spec_value_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '属性值组合id',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `spec_item_show` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 426 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_goods_spec_rel
-- ----------------------------
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (37, NULL, NULL, 6, '202003/03/7a10093f-6af4-31d7-b965-315c7dd6d200.jpg', 185, 5, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (38, NULL, NULL, 6, '202003/03/3644d417-8cbe-3a40-af72-798278e1b867.jpg', 185, 21, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (39, NULL, NULL, 6, '202003/03/fee2cf42-6492-3019-9d16-5b6aba2fe15e.jpg', 186, 8, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (40, NULL, NULL, 6, '202003/03/787c07d4-3293-3854-a03c-3c9f77e936bd.jpg', 186, 22, 1583182485, 0);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (73, NULL, NULL, 7, '202003/03/e5e33531-d6ed-3faa-b9a1-e2d4859912a5.jpg', 192, 23, 1583232005, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (74, NULL, NULL, 7, '202003/03/78735517-61d4-3c86-a5fd-2cebb3878a63.jpg', 192, 24, 1583232005, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (75, NULL, NULL, 7, '202003/03/45477969-df13-3414-8a33-04766f37f0f1.jpg', 185, 25, 1583232005, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (76, NULL, NULL, 7, '202003/03/7e62e6bb-0170-3694-b1db-6231fd23f45d.jpg', 185, 26, 1583232005, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (77, NULL, NULL, 8, '202003/03/dd5d0463-aad9-3b95-b50d-d4e51f81969e.jpg', 185, 5, 1583234360, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (78, NULL, NULL, 8, '202003/03/7f5abff3-b980-343f-88a2-eb2e245a9fd9.jpg', 185, 6, 1583234360, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (79, NULL, NULL, 8, '202003/03/233675eb-18da-3a8a-8782-6fb3fd64d4c6.jpg', 186, 7, 1583234360, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (80, NULL, NULL, 8, '202003/03/df379cc3-4523-33a0-9b44-c36cb7da594b.jpg', 186, 8, 1583234360, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (81, NULL, NULL, 9, '202003/03/74ab2f16-eed5-39cd-9c8e-0d71577b75bf.jpg', 185, 6, 1583235467, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (82, NULL, NULL, 9, '202003/03/e8096948-30fd-3d73-9e71-f1b3ab90f9e5.png', 185, 5, 1583235467, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (83, NULL, NULL, 9, '202003/03/17b8cf21-4cd3-3ba6-971d-fd091af1597e.jpg', 186, 7, 1583235467, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (84, NULL, NULL, 9, '202003/03/837772b0-1320-32ec-b2a0-942f13a193fe.jpg', 186, 7, 1583235467, 1);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (164, NULL, NULL, 11, '202003/03/5cffe221-25a9-3053-b42c-9dc6d2ce606a.jpg', 185, 5, 1583237270, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (165, NULL, NULL, 11, '202003/03/f28a7263-6255-3fb1-8c5a-bd4f61e6cfe6.jpg', 185, 6, 1583237271, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (166, NULL, NULL, 11, '202003/03/178740e1-1e1f-3738-ab95-abeea832e678.jpg', 185, 20, 1583237271, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (167, NULL, NULL, 11, '202003/03/eeebf802-9034-3e69-8304-d0b7d94f3892.jpg', 186, 8, 1583237271, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (168, NULL, NULL, 11, '202003/03/3f1b2992-e539-3f58-acdd-21852ffa3dc8.jpg', 186, 27, 1583237271, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (170, NULL, NULL, 13, '202003/03/13243d1f-d2c1-3dc2-8fa0-01ae26fdb42f.jpg', 193, 28, 1583237564, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (175, NULL, NULL, 10, '202003/03/74ab2f16-eed5-39cd-9c8e-0d71577b75bf.jpg', 185, 6, 1583244802, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (176, NULL, NULL, 10, '202003/03/e8096948-30fd-3d73-9e71-f1b3ab90f9e5.png', 185, 5, 1583244802, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (177, NULL, NULL, 10, '202003/03/837772b0-1320-32ec-b2a0-942f13a193fe.jpg', 186, 7, 1583244802, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (178, NULL, NULL, 10, '202003/03/0a837a6a-c617-31fc-a7ba-9f518eff057b.jpg', 186, 27, 1583244802, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (243, NULL, NULL, 16, '202003/03/3dac6d32-22d7-3fe1-8942-bae152067d26.jpg', 185, 5, 1583251465, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (244, NULL, NULL, 16, '202003/03/5fed5b56-b0eb-3e88-9cd1-3c15598373e5.jpg', 186, 7, 1583251465, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (269, NULL, NULL, 1, '', 185, 5, 1584269332, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (270, NULL, NULL, 1, '', 185, 6, 1584269332, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (271, NULL, NULL, 1, '', 186, 8, 1584269332, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (272, NULL, NULL, 1, '', 186, 7, 1584269332, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (293, NULL, NULL, 2, '202003/20/d2318066-666c-3217-8b93-c8e8ce8154a3.jpg', 185, 5, 1584648893, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (294, NULL, NULL, 2, '202003/20/a03fd3b1-7bed-350a-bdb9-aef4c7da1ea0.png', 185, 6, 1584648893, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (295, NULL, NULL, 2, '202003/20/a4d7fbc3-011c-3f1e-80e4-636e58dcfd07.png', 186, 8, 1584648893, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (296, NULL, NULL, 2, '202003/20/7915208e-b6fe-39d8-9834-e426d0151c2c.jpg', 186, 7, 1584648894, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (334, NULL, NULL, 28, '', 197, 33, 1586427732, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (335, NULL, NULL, 28, '', 197, 34, 1586427732, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (336, NULL, NULL, 28, '', 198, 35, 1586427732, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (337, NULL, NULL, 28, '', 198, 36, 1586427732, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (384, NULL, NULL, 34, '', 185, 5, 1591515873, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (385, NULL, NULL, 34, '', 185, 6, 1591515873, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (386, NULL, NULL, 34, '', 185, 20, 1591515873, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (387, NULL, NULL, 34, '', 186, 8, 1591515873, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (388, NULL, NULL, 34, '', 186, 7, 1591515873, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (389, NULL, NULL, 34, '', 187, 11, 1591515873, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (390, NULL, NULL, 34, '', 187, 37, 1591515873, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (391, NULL, NULL, 35, '', 186, 38, 1591516845, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (392, NULL, NULL, 35, '', 186, 39, 1591516846, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (393, NULL, NULL, 35, '', 185, 40, 1591516846, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (394, NULL, NULL, 35, '', 185, 41, 1591516846, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (408, NULL, NULL, 23, '202004/02/ebff6681-0e2a-36f5-aa7e-f25839df1604.jpg', 194, 29, 1594289807, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (409, NULL, NULL, 23, '202004/02/d722f20c-26b7-3855-9135-e97f6cd1f1a0.jpg', 195, 30, 1594289807, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (410, NULL, NULL, 23, '', 196, 31, 1594289807, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (411, NULL, NULL, 23, '', 196, 32, 1594289807, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (412, NULL, NULL, 29, '', 185, 5, 1594549026, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (413, NULL, NULL, 29, '', 185, 6, 1594549026, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (414, NULL, NULL, 29, '', 186, 7, 1594549026, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (415, NULL, NULL, 29, '', 186, 8, 1594549026, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (416, NULL, NULL, 63, '', 185, 5, 1594553200, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (417, NULL, NULL, 63, '', 185, 20, 1594553200, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (418, NULL, NULL, 63, '', 186, 8, 1594553200, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (419, NULL, NULL, 63, '', 186, 7, 1594553200, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (420, NULL, NULL, 64, '', 185, 5, 1594553239, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (421, NULL, NULL, 64, '', 185, 6, 1594553239, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (422, NULL, NULL, 64, '', 186, 8, 1594553239, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (423, NULL, NULL, 64, '', 186, 7, 1594553239, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (424, NULL, NULL, 64, '', 186, 42, 1594553239, NULL);
INSERT INTO `dd_diandi_shop_goods_spec_rel` VALUES (425, NULL, NULL, 67, '202007/13/521764f9-4078-363d-8fef-708294afaa8b.png', 185, 43, 1594607079, NULL);

-- ----------------------------
-- Table structure for dd_diandi_shop_order
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_order`;
CREATE TABLE `dd_diandi_shop_order`  (
  `order_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_type` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `order_no` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `order_body` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `total_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `pay_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `pay_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 10,
  `pay_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `express_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `express_company` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `express_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `delivery_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `delivery_time` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '发货时间',
  `receipt_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 10,
  `receipt_time` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收货时间',
  `order_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 10,
  `transaction_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `print_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`) USING BTREE,
  UNIQUE INDEX `order_no`(`order_no`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 132 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_order
-- ----------------------------
INSERT INTO `dd_diandi_shop_order` VALUES (114, NULL, 4, 43, '2020071251985455', '店滴开发', 0.01, 0.01, 1, 1594535723, 0.00, '', '', 1, '1594606375', 10, 0, 2, '4200000581202007129274281040', 404, 0, '', NULL, 1594535667, 1594535667);
INSERT INTO `dd_diandi_shop_order` VALUES (115, NULL, 4, 43, '2020071250501019', '店滴开发', 0.01, 0.01, 1, 1594535838, 0.00, '', '', 0, '0', 10, 0, 1, '4200000593202007120278308858', 404, 0, '', NULL, 1594535826, 1594535826);
INSERT INTO `dd_diandi_shop_order` VALUES (116, NULL, 4, 43, '2020071210210050', '多规格测试', 12.00, 12.00, 0, 0, 0.00, '', '', 0, '0', 10, 0, 0, '', 404, 0, '', NULL, 1594539807, 1594539807);
INSERT INTO `dd_diandi_shop_order` VALUES (117, NULL, 4, 43, '2020071257565153', '店滴开发', 0.01, 0.01, 1, 1594545740, 0.00, '', '', 0, '0', 10, 0, 1, '4200000575202007129308838624', 404, 0, '', NULL, 1594545721, 1594545721);
INSERT INTO `dd_diandi_shop_order` VALUES (118, NULL, 4, 43, '2020071297531011', '店滴开发', 0.01, 0.01, 0, 0, 0.00, '', '', 0, '0', 10, 0, 0, '', 404, 0, '', NULL, 1594546234, 1594546234);
INSERT INTO `dd_diandi_shop_order` VALUES (119, NULL, 4, 43, '2020071251100579', '店滴开发', 0.01, 0.01, 0, 0, 0.00, '', '', 0, '0', 10, 0, 0, '', 404, 0, '', NULL, 1594546323, 1594546323);
INSERT INTO `dd_diandi_shop_order` VALUES (120, NULL, 4, 43, '2020071298555650', '店滴开发', 0.01, 0.01, 0, 0, 0.00, '', '', 0, '0', 10, 0, 0, '', 404, 0, '', NULL, 1594546347, 1594546347);
INSERT INTO `dd_diandi_shop_order` VALUES (121, 1, 4, 43, '2020071210252535', '店滴开发', 0.01, 0.01, 1, 1594546416, 0.00, '', '', 0, '0', 10, 0, 1, '4200000590202007122887871986', 404, 0, '', NULL, 1594546399, 1594546399);
INSERT INTO `dd_diandi_shop_order` VALUES (122, 1, 4, 43, '2020071250995697', '店滴开发', 0.01, 0.01, 1, 1594546926, 0.00, '', '', 0, '0', 10, 0, 1, '4200000574202007126193755940', 404, 0, '', NULL, 1594546914, 1594546914);
INSERT INTO `dd_diandi_shop_order` VALUES (123, 1, 4, 43, '2020071210099575', '店滴开发', 0.01, 0.01, 1, 1594547029, 0.00, '', '', 0, '0', 10, 0, 1, '4200000584202007120431648036', 404, 0, '', NULL, 1594547021, 1594547021);
INSERT INTO `dd_diandi_shop_order` VALUES (124, 1, 4, 43, '2020071210210052', '店滴开发', 0.01, 0.01, 1, 1594547161, 0.00, '', '', 0, '0', 10, 0, 1, '4200000586202007127223074139', 404, 0, '', NULL, 1594547151, 1594547151);
INSERT INTO `dd_diandi_shop_order` VALUES (125, 1, 4, 43, '2020071253481015', '店滴开发', 0.01, 0.01, 1, 1594547309, 0.00, '', '', 0, '0', 10, 0, 1, '4200000575202007128141662610', 404, 0, '', NULL, 1594547301, 1594547301);
INSERT INTO `dd_diandi_shop_order` VALUES (126, 1, 4, 43, '2020071254979956', '店滴开发', 0.01, 0.01, 1, 1594547423, 0.00, '', '', 0, '0', 10, 0, 1, '4200000585202007123881968080', 404, 0, '', NULL, 1594547414, 1594547414);
INSERT INTO `dd_diandi_shop_order` VALUES (127, 1, 4, 43, '2020071257991024', '店滴开发', 0.01, 0.01, 1, 1594548771, 0.00, '', '', 0, '0', 10, 0, 1, '4200000574202007123799750608', 404, 0, '', NULL, 1594548761, 1594548761);
INSERT INTO `dd_diandi_shop_order` VALUES (128, 0, 4, 43, '2020071257975657', '投影仪', 0.01, 0.01, 1, 1594549076, 0.00, '', '', 0, '0', 10, 0, 1, '4200000577202007125612303582', 404, 0, '', NULL, 1594549065, 1594549065);
INSERT INTO `dd_diandi_shop_order` VALUES (129, 0, 4, 43, '2020071210255561', '投影仪', 0.01, 0.01, 1, 1594549220, 0.00, '', '', 1, '1594550867', 1, 1594562931, 3, '4200000593202007126127218035', 404, 0, '', NULL, 1594549215, 1594549215);
INSERT INTO `dd_diandi_shop_order` VALUES (130, 0, 4, 43, '2020071310297539', '联想打印机', 12.00, 12.00, 0, 0, 0.00, '', '', 0, '0', 10, 0, 0, '', 404, 0, '', NULL, 1594600703, 1594600703);
INSERT INTO `dd_diandi_shop_order` VALUES (131, 1, 4, 43, '2020071448985053', '联想打印机', 0.01, 0.01, 1, 1594710791, 0.00, '', '', 0, '0', 10, 0, 1, '4200000597202007144553310857', 423, 0, '', NULL, 1594710784, 1594710784);

-- ----------------------------
-- Table structure for dd_diandi_shop_order_address
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_order_address`;
CREATE TABLE `dd_diandi_shop_order_address`  (
  `order_address_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `province_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `city_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `delivery_time` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `region_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `detail` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `order_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`order_address_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 205 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_order_address
-- ----------------------------
INSERT INTO `dd_diandi_shop_order_address` VALUES (124, NULL, NULL, '博尚新都社区', '17778984690', 2898, 2931, NULL, 2934, '具体地址', 174, 76, 0, 1585079564, 1585079564);
INSERT INTO `dd_diandi_shop_order_address` VALUES (125, NULL, NULL, '博尚新都社区', '17778984690', 2898, 2931, NULL, 2934, '具体地址', 175, 76, 0, 1585079803, 1585079803);
INSERT INTO `dd_diandi_shop_order_address` VALUES (126, NULL, NULL, '博尚新都社区', '17778984690', 2898, 2931, NULL, 2934, '具体地址', 176, 76, 0, 1585079849, 1585079849);
INSERT INTO `dd_diandi_shop_order_address` VALUES (138, NULL, NULL, '王春生', '17778984690', 1, 3, NULL, 1, '收货具体地址555人', 38, 76, 0, 1588131520, 1588131520);
INSERT INTO `dd_diandi_shop_order_address` VALUES (139, NULL, NULL, '王春生', '17778984690', 1, 3, NULL, 1, '收货具体地址555人', 47, 76, 0, 1588136424, 1588136424);
INSERT INTO `dd_diandi_shop_order_address` VALUES (140, NULL, NULL, '王春生', '17778984690', 1, 3, NULL, 1, '收货具体地址555人', 48, 76, 0, 1588136458, 1588136458);
INSERT INTO `dd_diandi_shop_order_address` VALUES (141, NULL, NULL, '王春生', '17778984690', 1, 3, NULL, 1, '收货具体地址555人', 50, 76, 0, 1588141709, 1588141709);
INSERT INTO `dd_diandi_shop_order_address` VALUES (142, NULL, NULL, '王春生', '17778984690', 1, 3, NULL, 1, '收货具体地址555人', 51, 76, 0, 1588146580, 1588146580);
INSERT INTO `dd_diandi_shop_order_address` VALUES (143, NULL, NULL, '王春生', '17778984690', 1, 3, NULL, 1, '收货具体地址555人', 52, 76, 0, 1589128148, 1589128148);
INSERT INTO `dd_diandi_shop_order_address` VALUES (144, NULL, NULL, '王春生', '17778984690', 1, 3, NULL, 1, '收货具体地址555人', 53, 76, 0, 1589128196, 1589128196);
INSERT INTO `dd_diandi_shop_order_address` VALUES (147, 4, 43, '王春生', '17749039605', 801, 802, '', 813, '具体地址', 56, 396, 0, 1594180145, 1594180145);
INSERT INTO `dd_diandi_shop_order_address` VALUES (148, 4, 43, '王春生', '17749039605', 801, 802, '', 813, '具体地址', 57, 396, 0, 1594287650, 1594287650);
INSERT INTO `dd_diandi_shop_order_address` VALUES (149, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 58, 404, 0, 1594288514, 1594288514);
INSERT INTO `dd_diandi_shop_order_address` VALUES (150, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 59, 404, 0, 1594288959, 1594288959);
INSERT INTO `dd_diandi_shop_order_address` VALUES (151, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 60, 404, 0, 1594289473, 1594289473);
INSERT INTO `dd_diandi_shop_order_address` VALUES (152, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 61, 404, 0, 1594289581, 1594289581);
INSERT INTO `dd_diandi_shop_order_address` VALUES (153, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 62, 404, 0, 1594289653, 1594289653);
INSERT INTO `dd_diandi_shop_order_address` VALUES (154, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 63, 404, 0, 1594289752, 1594289752);
INSERT INTO `dd_diandi_shop_order_address` VALUES (155, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 64, 404, 0, 1594289838, 1594289838);
INSERT INTO `dd_diandi_shop_order_address` VALUES (156, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 65, 404, 0, 1594289851, 1594289851);
INSERT INTO `dd_diandi_shop_order_address` VALUES (157, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 66, 404, 0, 1594291975, 1594291975);
INSERT INTO `dd_diandi_shop_order_address` VALUES (158, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 67, 404, 0, 1594297291, 1594297291);
INSERT INTO `dd_diandi_shop_order_address` VALUES (159, 4, 43, '王春生', '15029641258', 801, 802, NULL, 813, '详细地址', 68, 404, 0, 1594300363, 1594300363);
INSERT INTO `dd_diandi_shop_order_address` VALUES (160, 4, 43, '王春生', '15029641258', 801, 802, NULL, 813, '详细地址', 69, 404, 0, 1594300434, 1594300434);
INSERT INTO `dd_diandi_shop_order_address` VALUES (161, 4, 43, '王春生', '15029641258', 801, 802, NULL, 813, '详细地址', 79, 404, 0, 1594301040, 1594301040);
INSERT INTO `dd_diandi_shop_order_address` VALUES (162, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 80, 404, 0, 1594301139, 1594301139);
INSERT INTO `dd_diandi_shop_order_address` VALUES (163, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 83, 404, 0, 1594301993, 1594301993);
INSERT INTO `dd_diandi_shop_order_address` VALUES (164, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 84, 404, 0, 1594302213, 1594302213);
INSERT INTO `dd_diandi_shop_order_address` VALUES (165, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 86, 404, 0, 1594302408, 1594302408);
INSERT INTO `dd_diandi_shop_order_address` VALUES (187, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 114, 404, 0, 1594535667, 1594535667);
INSERT INTO `dd_diandi_shop_order_address` VALUES (188, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 115, 404, 0, 1594535826, 1594535826);
INSERT INTO `dd_diandi_shop_order_address` VALUES (189, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 116, 404, 0, 1594539807, 1594539807);
INSERT INTO `dd_diandi_shop_order_address` VALUES (190, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 117, 404, 0, 1594545721, 1594545721);
INSERT INTO `dd_diandi_shop_order_address` VALUES (191, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 118, 404, 0, 1594546234, 1594546234);
INSERT INTO `dd_diandi_shop_order_address` VALUES (192, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 119, 404, 0, 1594546323, 1594546323);
INSERT INTO `dd_diandi_shop_order_address` VALUES (193, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 120, 404, 0, 1594546347, 1594546347);
INSERT INTO `dd_diandi_shop_order_address` VALUES (194, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 121, 404, 0, 1594546399, 1594546399);
INSERT INTO `dd_diandi_shop_order_address` VALUES (195, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 122, 404, 0, 1594546914, 1594546914);
INSERT INTO `dd_diandi_shop_order_address` VALUES (196, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 123, 404, 0, 1594547021, 1594547021);
INSERT INTO `dd_diandi_shop_order_address` VALUES (197, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 124, 404, 0, 1594547151, 1594547151);
INSERT INTO `dd_diandi_shop_order_address` VALUES (198, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 125, 404, 0, 1594547301, 1594547301);
INSERT INTO `dd_diandi_shop_order_address` VALUES (199, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 126, 404, 0, 1594547414, 1594547414);
INSERT INTO `dd_diandi_shop_order_address` VALUES (200, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 127, 404, 0, 1594548761, 1594548761);
INSERT INTO `dd_diandi_shop_order_address` VALUES (201, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 128, 404, 0, 1594549065, 1594549065);
INSERT INTO `dd_diandi_shop_order_address` VALUES (202, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 129, 404, 0, 1594549215, 1594549215);
INSERT INTO `dd_diandi_shop_order_address` VALUES (203, 4, 43, '王春生', '15029641258', 801, 802, '', 813, '详细地址', 130, 404, 0, 1594600703, 1594600703);
INSERT INTO `dd_diandi_shop_order_address` VALUES (204, 4, 43, '吕', '18710864070', 585, 597, '', 601, '武林路1号', 131, 423, 0, 1594710784, 1594710784);

-- ----------------------------
-- Table structure for dd_diandi_shop_order_goods
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_order_goods`;
CREATE TABLE `dd_diandi_shop_order_goods`  (
  `order_goods_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(255) NULL DEFAULT NULL,
  `goods_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `goods_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `thumb` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0',
  `stock_up` int(11) NULL DEFAULT 0 COMMENT '库存是否处理',
  `deduct_stock_type` tinyint(3) UNSIGNED NULL DEFAULT 20,
  `spec_type` tinyint(3) UNSIGNED NULL DEFAULT 0,
  `spec_sku_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `goods_spec_id` int(11) UNSIGNED NULL DEFAULT 0,
  `goods_attr` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `content` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `goods_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `goods_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `line_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `goods_weight` double UNSIGNED NOT NULL DEFAULT 0,
  `total_num` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `total_price` decimal(10, 2) UNSIGNED NOT NULL DEFAULT 0.00,
  `order_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '下单人',
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`order_goods_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 267 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_order_goods
-- ----------------------------
INSERT INTO `dd_diandi_shop_order_goods` VALUES (249, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 114, 404, 0, NULL, 1594535667, 1594535667);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (250, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 115, 404, 0, NULL, 1594535826, 1594535826);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (251, 4, 43, 29, '多规格测试', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '5_7', 214, NULL, '<p>3254353</p>', '123', 12.00, 23.00, 5, 1, 12.00, 116, 404, 0, NULL, 1594539807, 1594539807);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (252, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 117, 404, 0, NULL, 1594545721, 1594545721);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (253, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 118, 404, 0, NULL, 1594546234, 1594546234);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (254, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 119, 404, 0, NULL, 1594546323, 1594546323);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (255, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 120, 404, 0, NULL, 1594546347, 1594546347);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (256, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 121, 404, 0, NULL, 1594546399, 1594546399);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (257, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 122, 404, 0, NULL, 1594546914, 1594546914);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (258, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 123, 404, 0, NULL, 1594547021, 1594547021);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (259, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 124, 404, 0, NULL, 1594547151, 1594547151);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (260, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 125, 404, 0, NULL, 1594547301, 1594547301);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (261, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 126, 404, 0, NULL, 1594547414, 1594547414);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (262, 4, 43, 28, '店滴开发', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '33_35', 200, NULL, '<p>店滴开发</p>', '123', 0.50, 0.50, 50, 1, 0.50, 127, 404, 0, NULL, 1594548761, 1594548761);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (263, 4, 43, 29, '投影仪', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '5_7', 286, NULL, '<p>3254353</p>', '123', 0.01, 23.00, 5, 1, 0.01, 128, 404, 0, NULL, 1594549065, 1594549065);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (264, 4, 43, 29, '投影仪', 'https://demo.hopesfire.com/attachment/202006/30/3f7ae5d4-5dc3-3fe1-a9a0-9c89bfa7c0ec.jpg', 1, 10, 0, '5_7', 286, NULL, '<p>3254353</p>', '123', 0.01, 23.00, 5, 1, 0.01, 129, 404, 0, NULL, 1594549215, 1594549215);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (265, 4, 43, 61, '联想打印机', 'https://demo.hopesfire.com/attachment/202007/12/43ea95f8-4460-3231-a4ca-9f8c409664cc.jpg', 0, 20, 1, '', 0, '', '<p>联想打印机</p>', NULL, 12.00, 34.00, 213, 1, 12.00, 130, 404, 0, NULL, 1594600703, 1594600703);
INSERT INTO `dd_diandi_shop_order_goods` VALUES (266, 4, 43, 61, '联想打印机', 'https://demo.hopesfire.com/attachment/202007/12/43ea95f8-4460-3231-a4ca-9f8c409664cc.jpg', 0, 20, 1, '', 0, '', '<p>联想打印机</p>', NULL, 12.00, 34.00, 213, 1, 12.00, 131, 423, 0, NULL, 1594710784, 1594710784);

-- ----------------------------
-- Table structure for dd_diandi_shop_setting
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_setting`;
CREATE TABLE `dd_diandi_shop_setting`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `type` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `section` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `key` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT 1,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_setting
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_shop_spec
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_spec`;
CREATE TABLE `dd_diandi_shop_spec`  (
  `spec_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `spec_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) NOT NULL,
  PRIMARY KEY (`spec_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 199 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_spec
-- ----------------------------
INSERT INTO `dd_diandi_shop_spec` VALUES (185, NULL, NULL, '颜色', 0, 1578336531);
INSERT INTO `dd_diandi_shop_spec` VALUES (186, NULL, NULL, '尺寸', 0, 1578336531);
INSERT INTO `dd_diandi_shop_spec` VALUES (187, NULL, NULL, '材料', 0, 1578341609);
INSERT INTO `dd_diandi_shop_spec` VALUES (188, NULL, NULL, '', 0, 1578557108);
INSERT INTO `dd_diandi_shop_spec` VALUES (189, NULL, NULL, '尺寸w', 0, 1578638143);
INSERT INTO `dd_diandi_shop_spec` VALUES (190, NULL, NULL, '号码', 0, 1578638524);
INSERT INTO `dd_diandi_shop_spec` VALUES (191, NULL, NULL, '没想到', 0, 1578639354);
INSERT INTO `dd_diandi_shop_spec` VALUES (192, NULL, NULL, '产地', 0, 1583222492);
INSERT INTO `dd_diandi_shop_spec` VALUES (193, NULL, NULL, '周期', 0, 1583237534);
INSERT INTO `dd_diandi_shop_spec` VALUES (194, NULL, NULL, '红', 0, 1585821036);
INSERT INTO `dd_diandi_shop_spec` VALUES (195, NULL, NULL, '绿', 0, 1585821093);
INSERT INTO `dd_diandi_shop_spec` VALUES (196, NULL, NULL, '大小', 0, 1586334033);
INSERT INTO `dd_diandi_shop_spec` VALUES (197, NULL, NULL, '版本', 0, 1586427299);
INSERT INTO `dd_diandi_shop_spec` VALUES (198, NULL, NULL, '服务', 0, 1586427299);

-- ----------------------------
-- Table structure for dd_diandi_shop_spec_value
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_spec_value`;
CREATE TABLE `dd_diandi_shop_spec_value`  (
  `spec_value_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `spec_value` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `spec_id` int(11) NOT NULL,
  `create_time` int(11) NOT NULL,
  PRIMARY KEY (`spec_value_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 44 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_spec_value
-- ----------------------------
INSERT INTO `dd_diandi_shop_spec_value` VALUES (5, NULL, NULL, '红色', 185, 1578336600);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (6, NULL, NULL, '绿色', 185, 1578336600);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (7, NULL, NULL, 'xxl', 186, 1578336600);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (8, NULL, NULL, 'xl', 186, 1578336600);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (9, NULL, NULL, '蓝色', 185, 1578341347);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (10, NULL, NULL, '木头', 187, 1578341609);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (11, NULL, NULL, '熟料', 187, 1578341609);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (12, NULL, NULL, '你', 186, 1578414324);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (13, NULL, NULL, 'xxl', 189, 1578638143);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (14, NULL, NULL, 'aaa', 190, 1578638524);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (15, NULL, NULL, 'bbb', 190, 1578638524);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (16, NULL, NULL, '剥离力', 187, 1578638778);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (17, NULL, NULL, 'aaa', 191, 1578639354);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (18, NULL, NULL, 'mm', 186, 1578639524);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (19, NULL, NULL, '绿色额', 185, 1578642091);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (20, NULL, NULL, '紫色', 185, 1578642219);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (21, NULL, NULL, '白色', 185, 1583177389);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (22, NULL, NULL, 'xxl,', 186, 1583177389);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (23, NULL, NULL, '西安', 192, 1583222493);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (24, NULL, NULL, '北京', 192, 1583222493);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (25, NULL, NULL, '好的', 185, 1583222493);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (26, NULL, NULL, 'ok', 185, 1583222493);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (27, NULL, NULL, 'xxls', 186, 1583235818);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (28, NULL, NULL, '一年', 193, 1583237534);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (29, NULL, NULL, '熟', 194, 1585821036);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (30, NULL, NULL, '生', 195, 1585821093);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (31, NULL, NULL, '大的', 196, 1586334033);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (32, NULL, NULL, '小的', 196, 1586334033);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (33, NULL, NULL, '基础版', 197, 1586427299);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (34, NULL, NULL, '商务版', 197, 1586427299);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (35, NULL, NULL, '基础服务', 198, 1586427299);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (36, NULL, NULL, '至尊服务', 198, 1586427299);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (37, NULL, NULL, '石头', 187, 1591515873);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (38, NULL, NULL, '1号', 186, 1591516845);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (39, NULL, NULL, '2号', 186, 1591516845);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (40, NULL, NULL, '红黑', 185, 1591516846);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (41, NULL, NULL, '紫黄', 185, 1591516846);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (42, NULL, NULL, 'm', 186, 1592643940);
INSERT INTO `dd_diandi_shop_spec_value` VALUES (43, 43, 4, '黑色', 185, 1594607079);

-- ----------------------------
-- Table structure for dd_diandi_shop_store
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_store`;
CREATE TABLE `dd_diandi_shop_store`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '所属公司',
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '商家名称',
  `banner` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '横幅背景',
  `distance` int(11) NULL DEFAULT NULL COMMENT '配送范围',
  `logo` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '商家logo',
  `intro` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '简介',
  `address` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '商家地址',
  `shareimg` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '分享图片',
  `certificate` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '资质证书',
  `hotSearch` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '热搜',
  `lng_lat` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '经纬度',
  `service` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '服务',
  `mobile` bigint(20) NULL DEFAULT NULL COMMENT '商家电话',
  `sendtime` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '配送时间',
  `Lodop_ip` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '打印机IP',
  `shippingDees` decimal(10, 0) NULL DEFAULT NULL COMMENT '基础配送费',
  `notice` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '公告',
  `surroundings` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '商家环境',
  `startingPrice` decimal(10, 0) NULL DEFAULT NULL COMMENT '起送价',
  `describe` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '商家详情',
  `create_time` int(11) NULL DEFAULT NULL,
  `update_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `bloc_id`(`bloc_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 3 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_store
-- ----------------------------
INSERT INTO `dd_diandi_shop_store` VALUES (1, NULL, '空港食品23', '202003/17/0da786a7-7a24-3d37-b6ec-9b45429f907e.jpg', 20, '202003/17/2610ca45-5d32-3ef2-8d0e-fb1b9b9912e8.jpg', '·空港食品简介', '而固特异如何', '202005/11/6ddd5a93-a590-304d-aeb9-ba7a6343e5c0.jpg', '', '456', '122332,354564', '服务保障', 1777898469, '9:00-12:00,17:00-19:00', '', 10, '公告内容', '', 50, '3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划', NULL, NULL);
INSERT INTO `dd_diandi_shop_store` VALUES (2, NULL, '空港食品23', '202003/17/0da786a7-7a24-3d37-b6ec-9b45429f907e.jpg', NULL, '202003/17/2610ca45-5d32-3ef2-8d0e-fb1b9b9912e8.jpg', '·空港食品简介', '而固特异如何', '', '', '456', '', '', 1777898469, '', '', 10, '公告内容', '', 50, '3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划3456和他人员更换角色让她的规划', NULL, NULL);

-- ----------------------------
-- Table structure for dd_diandi_shop_wxapp
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_wxapp`;
CREATE TABLE `dd_diandi_shop_wxapp`  (
  `wxapp_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `app_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `app_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `app_secret` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `is_service` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `service_image_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `is_phone` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `phone_no` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `phone_image_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `mchid` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `apikey` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`wxapp_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_wxapp
-- ----------------------------
INSERT INTO `dd_diandi_shop_wxapp` VALUES (4, NULL, NULL, '店滴会员卡', 'wx028eb56f4b4a7d99', '44f188b226d3c04c403d798d8963817b', 0, 0, 0, '', 0, '1228641802', 't2phkrvdglrunljg20vo3etlmtvzz1rp', 1574520971, 1576077780);
INSERT INTO `dd_diandi_shop_wxapp` VALUES (5, NULL, NULL, '环球帮帮', 'wxae23c79633b11f60', '8c1ffb25f42813859955fcaf5d802044', 0, 0, 0, '', 0, '', '', 1574570697, 1574570697);
INSERT INTO `dd_diandi_shop_wxapp` VALUES (7, NULL, NULL, '配齐果果', 'wx7f5ba7aa15d8fdae', '2c21717134583f99634cb9002dbae46e', 0, 0, 0, '', 0, '', '', 1575803519, 1575803519);

-- ----------------------------
-- Table structure for dd_diandi_shop_wxapp_help
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_wxapp_help`;
CREATE TABLE `dd_diandi_shop_wxapp_help`  (
  `help_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `sort` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`help_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10004 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_wxapp_help
-- ----------------------------
INSERT INTO `dd_diandi_shop_wxapp_help` VALUES (10001, NULL, NULL, '关于小程序', '小程序本身无需下载，无需注册，不占用手机内存，可以跨平台使用，响应迅速，体验接近原生APP。', 100, 4, 1574520971, 1574520971);
INSERT INTO `dd_diandi_shop_wxapp_help` VALUES (10002, NULL, NULL, '关于小程序', '小程序本身无需下载，无需注册，不占用手机内存，可以跨平台使用，响应迅速，体验接近原生APP。', 100, 5, 1574570697, 1574570697);
INSERT INTO `dd_diandi_shop_wxapp_help` VALUES (10003, NULL, NULL, '关于小程序', '小程序本身无需下载，无需注册，不占用手机内存，可以跨平台使用，响应迅速，体验接近原生APP。', 100, 7, 1575803519, 1575803519);

-- ----------------------------
-- Table structure for dd_diandi_shop_wxapp_navbar
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_wxapp_navbar`;
CREATE TABLE `dd_diandi_shop_wxapp_navbar`  (
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `wxapp_title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `top_text_color` tinyint(3) UNSIGNED NOT NULL DEFAULT 10,
  `top_background_color` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`wxapp_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_wxapp_navbar
-- ----------------------------
INSERT INTO `dd_diandi_shop_wxapp_navbar` VALUES (4, NULL, NULL, '店滴会员卡', 20, '#fd4a5f', 1574520971, 1574520971);
INSERT INTO `dd_diandi_shop_wxapp_navbar` VALUES (5, NULL, NULL, '环球帮帮', 20, '#fd4a5f', 1574570697, 1574570697);
INSERT INTO `dd_diandi_shop_wxapp_navbar` VALUES (7, NULL, NULL, '配齐果果', 20, '#fd4a5f', 1575803519, 1575803519);

-- ----------------------------
-- Table structure for dd_diandi_shop_wxapp_page
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_wxapp_page`;
CREATE TABLE `dd_diandi_shop_wxapp_page`  (
  `page_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `page_type` tinyint(3) UNSIGNED NOT NULL DEFAULT 10,
  `page_data` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `create_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` int(11) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`page_id`) USING BTREE,
  INDEX `wxapp_id`(`wxapp_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10004 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_wxapp_page
-- ----------------------------
INSERT INTO `dd_diandi_shop_wxapp_page` VALUES (10001, NULL, NULL, 10, '{\"items\":{\"s10001\":{\"id\":\"s10001\",\"type\":\"search\",\"params\":{\"placeholder\":\"\\u641c\\u7d22\\u5546\\u54c1\"},\"style\":{\"textAlign\":\"center\",\"searchStyle\":\"radius\"}},\"n848946677208394\":{\"id\":\"n848946677208394\",\"type\":\"banner\",\"style\":{\"btnColor\":\"#ffffff\",\"btnShape\":\"rectangle\"},\"data\":{\"n3703534890892803\":{\"imgUrl\":\"https:\\/\\/app.hopesfire.com\\/addons\\/yiovo_shop\\/web\\/uploads\\/201911290714147c8a27371.jpg\",\"imgName\":\"https:\\/\\/app.hopesfire.com\\/addons\\/yiovo_shop\\/web\\/uploads\\/201911290714147c8a27371.jpg\",\"linkUrl\":\"\"},\"n500864643777582\":{\"imgUrl\":\"https:\\/\\/app.hopesfire.com\\/addons\\/yiovo_shop\\/web\\/uploads\\/201911290714325e7453399.jpg\",\"imgName\":\"https:\\/\\/app.hopesfire.com\\/addons\\/yiovo_shop\\/web\\/uploads\\/201911290714325e7453399.jpg\",\"linkUrl\":\"\"}}}}}', 4, 1574520971, 1574982881);
INSERT INTO `dd_diandi_shop_wxapp_page` VALUES (10002, NULL, NULL, 10, '{\"items\":{\"s10001\":{\"id\":\"s10001\",\"type\":\"search\",\"params\":{\"placeholder\":\"\\u641c\\u7d22\\u5546\\u54c1\"},\"style\":{\"textAlign\":\"center\",\"searchStyle\":\"radius\"}},\"s10002\":{\"id\":\"s10002\",\"type\":\"banner\",\"style\":{\"btnColor\":\"#ffffff\",\"btnShape\":\"square\"},\"data\":{\"sd10001\":{\"imgName\":\"https:\\/\\/app.hopesfire.com\\/addons\\/yiovo_shop\\/web\\/uploads\\/20191124192721ad61e5190.jpg\",\"imgUrl\":\"https:\\/\\/app.hopesfire.com\\/addons\\/yiovo_shop\\/web\\/uploads\\/20191124192721ad61e5190.jpg\",\"linkUrl\":\"\"}}}}}', 5, 1574570697, 1574600683);
INSERT INTO `dd_diandi_shop_wxapp_page` VALUES (10003, NULL, NULL, 10, '{\"items\":{\"s10001\":{\"id\":\"s10001\",\"type\":\"search\",\"params\":{\"placeholder\":\"\\u641c\\u7d22\\u5546\\u54c1\"},\"style\":{\"textAlign\":\"center\",\"searchStyle\":\"radius\"}},\"s10002\":{\"id\":\"s10002\",\"type\":\"banner\",\"style\":{\"btnColor\":\"#ffffff\",\"btnShape\":\"round\"},\"data\":{\"sd10001\":{\"imgUrl\":\"https:\\/\\/app.hopesfire.com\\/addons\\/diandi_shop\\/web\\/uploads\\/2019121023511323a671326.jpg\",\"imgName\":\"https:\\/\\/app.hopesfire.com\\/addons\\/diandi_shop\\/web\\/uploads\\/2019121023511323a671326.jpg\",\"linkUrl\":\"\"},\"sd10002\":{\"imgUrl\":\"https:\\/\\/app.hopesfire.com\\/addons\\/diandi_shop\\/web\\/uploads\\/20191210235122e78390203.jpg\",\"imgName\":\"https:\\/\\/app.hopesfire.com\\/addons\\/diandi_shop\\/web\\/uploads\\/20191210235122e78390203.jpg\",\"linkUrl\":\"\"}}}}}', 7, 1575803519, 1575993531);

-- ----------------------------
-- Table structure for dd_diandi_shop_wxapp_slide
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_shop_wxapp_slide`;
CREATE TABLE `dd_diandi_shop_wxapp_slide`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL,
  `images` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `background` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `createtime` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `updatetime` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 8 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '幻灯片' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_shop_wxapp_slide
-- ----------------------------
INSERT INTO `dd_diandi_shop_wxapp_slide` VALUES (5, NULL, NULL, '202002/02/c5ae51fd-21d7-31bb-99c1-b70547cfa7ff.jpg', '#e06666', '', '1580637128', '1580617100');
INSERT INTO `dd_diandi_shop_wxapp_slide` VALUES (6, NULL, NULL, '202002/02/1ee6a69f-2e06-3b9e-ac89-b05cda5c98f9.jpg', '#d9ead3', '', '1580637149', '1580617235');
INSERT INTO `dd_diandi_shop_wxapp_slide` VALUES (7, NULL, NULL, '202002/02/f75080df-b020-3e40-92e7-7f294b58f500.jpg', '#e6b8af', '', '1580637162', '1580617248');

-- ----------------------------
-- Table structure for dd_diandi_store
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_store`;
CREATE TABLE `dd_diandi_store`  (
  `store_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '商户id',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '门店名称',
  `logo` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '关联公司',
  `province` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '省份',
  `city` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '城市',
  `address` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '详细地址',
  `county` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '区县',
  `mobile` varchar(11) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '联系电话',
  `create_time` varchar(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `update_time` varchar(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `status` int(10) NULL DEFAULT 0 COMMENT '\'0:待审核\',\'1:已通过\',\'3:已拉黑\'',
  `lng_lat` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '经纬度',
  `extra` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT '商户扩展字段',
  PRIMARY KEY (`store_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 45 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_store
-- ----------------------------
INSERT INTO `dd_diandi_store` VALUES (27, '商户1', '202005/16/3597fcdf-ba7b-36eb-a749-a14b7f493079.jpg', 0, '1532', '1674', '详细地址', '1677', '17778984690', NULL, NULL, 2, '116.456270,39.919990', 'a:14:{s:5:\"intro\";s:12:\"简介内容\";s:8:\"shareimg\";s:50:\"202005/16/522e9b41-07b0-3c09-bb1a-97eab2c178da.jpg\";s:8:\"distance\";s:3:\"100\";s:8:\"sendtime\";s:9:\"5:00-6:00\";s:13:\"startingPrice\";s:2:\"12\";s:12:\"shippingDees\";s:2:\"16\";s:6:\"banner\";s:50:\"202005/16/1483b20a-c4e8-3423-971f-459431f6e795.jpg\";s:8:\"Lodop_ip\";s:9:\"127.0.0.1\";s:7:\"service\";s:12:\"服务内容\";s:9:\"hotSearch\";s:6:\"热狗\";s:6:\"notice\";s:12:\"公告内容\";s:3:\"des\";s:12:\"详细介绍\";s:12:\"surroundings\";a:1:{i:0;s:50:\"202005/12/873a0bbf-0ad3-35e4-91d2-bc205cbb6efb.jpg\";}s:11:\"certificate\";a:2:{i:0;s:50:\"202005/12/5b72fe31-e3b5-31ad-82d5-2d4878fcfcc6.jpg\";i:1;s:50:\"202005/12/a9a7c926-791d-344e-bb61-e4db7611aa40.png\";}}');
INSERT INTO `dd_diandi_store` VALUES (28, '商户A1', '202005/12/c663ffe4-6a8a-3273-a92b-295776711313.jpg', 3, '220', '232', '详细地址', '233', '17778984690', NULL, NULL, 1, '{\"lng\":\"116.456270\",\"lat\":\"39.919990\"}', 'b:0;');
INSERT INTO `dd_diandi_store` VALUES (29, '商户2-3', '202005/12/b60d42a7-5bff-33a2-a577-7947cb932a63.jpg', 3, '37', '76', '567', '78', '5454464', NULL, NULL, 2, '{\"lng\":\"116.456270\",\"lat\":\"39.919990\"}', 'a:14:{s:5:\"intro\";s:0:\"\";s:8:\"shareimg\";s:0:\"\";s:8:\"distance\";s:0:\"\";s:8:\"sendtime\";s:0:\"\";s:13:\"startingPrice\";s:0:\"\";s:12:\"shippingDees\";s:0:\"\";s:6:\"banner\";s:0:\"\";s:8:\"Lodop_ip\";s:0:\"\";s:7:\"service\";s:0:\"\";s:9:\"hotSearch\";s:0:\"\";s:6:\"notice\";s:0:\"\";s:3:\"des\";s:0:\"\";s:12:\"surroundings\";s:0:\"\";s:11:\"certificate\";s:0:\"\";}');
INSERT INTO `dd_diandi_store` VALUES (30, '商户134', '202005/16/3597fcdf-ba7b-36eb-a749-a14b7f493079.jpg', 0, '19', '20', '详细地址', '21', '17778984690', NULL, NULL, 1, '{\"lng\":\"116.456270\",\"lat\":\"39.919990\"}', 'b:0;');
INSERT INTO `dd_diandi_store` VALUES (31, '新的测试', '202005/16/83c5dd53-0241-3669-a9e1-47f513433989.png', 0, '2898', '2899', '567', '2900', '17778984690', NULL, NULL, 1, '116.456270,39.919990', NULL);
INSERT INTO `dd_diandi_store` VALUES (32, '途火科技1', '202005/16/3597fcdf-ba7b-36eb-a749-a14b7f493079.jpg', 3, '1', '2', '详细地址', '7', '17778984690', NULL, NULL, 1, '{\"lng\":\"116.456270\",\"lat\":\"39.919990\"}', 'b:0;');
INSERT INTO `dd_diandi_store` VALUES (35, '经纬度格式', '202005/16/3597fcdf-ba7b-36eb-a749-a14b7f493079.jpg', 0, '220', '232', '详细地址', '234', '5454464', NULL, NULL, NULL, '{\"lng\":\"116.456270\",\"lat\":\"39.919990\"}', 'a:14:{s:5:\"intro\";s:0:\"\";s:8:\"shareimg\";s:0:\"\";s:8:\"distance\";s:0:\"\";s:8:\"sendtime\";s:0:\"\";s:13:\"startingPrice\";s:0:\"\";s:12:\"shippingDees\";s:0:\"\";s:6:\"banner\";s:0:\"\";s:8:\"Lodop_ip\";s:0:\"\";s:7:\"service\";s:0:\"\";s:9:\"hotSearch\";s:0:\"\";s:6:\"notice\";s:0:\"\";s:3:\"des\";s:0:\"\";s:12:\"surroundings\";s:0:\"\";s:11:\"certificate\";s:0:\"\";}');
INSERT INTO `dd_diandi_store` VALUES (38, '抽奖', '202007/07/b7446834-ac1e-3e27-9d31-1006baeff8b2.jpg', 1, '820', '906', '详细地址', '911', '17778984690', NULL, NULL, 2, '{\"lng\":\"108.946429\",\"lat\":\"34.347336\"}', 'a:15:{s:5:\"intro\";s:0:\"\";s:12:\"contact_type\";s:0:\"\";s:8:\"shareimg\";s:0:\"\";s:8:\"distance\";s:0:\"\";s:8:\"sendtime\";s:0:\"\";s:13:\"startingPrice\";s:0:\"\";s:12:\"shippingDees\";s:0:\"\";s:6:\"banner\";s:0:\"\";s:8:\"Lodop_ip\";s:0:\"\";s:7:\"service\";s:0:\"\";s:9:\"hotSearch\";s:30:\"轻食餐,礼盒,枸杞,茶叶\";s:6:\"notice\";s:0:\"\";s:3:\"des\";s:0:\"\";s:12:\"surroundings\";s:0:\"\";s:11:\"certificate\";s:0:\"\";}');
INSERT INTO `dd_diandi_store` VALUES (43, '长全大健康', '202007/07/3a3b5141-9245-3028-b076-5b30b67d4edd.png', 4, '37', '61', '详细地址', '62', '17778984690', NULL, NULL, 1, '{\"lng\":\"109.339442\",\"lat\":\"34.14549\"}', 'a:19:{s:5:\"intro\";s:20:\"上班下班都有Ta\";s:12:\"contact_type\";s:1:\"2\";s:8:\"shareimg\";s:0:\"\";s:8:\"distance\";s:1:\"5\";s:8:\"sendtime\";s:23:\"12:00-13:00,17:00-18:00\";s:13:\"startingPrice\";s:2:\"20\";s:12:\"shippingDees\";s:1:\"0\";s:6:\"banner\";s:0:\"\";s:8:\"Lodop_ip\";s:9:\"127.0.0.1\";s:7:\"service\";s:12:\"商家提供\";s:9:\"hotSearch\";s:33:\"打印机,笔记本,鼠标,键盘\";s:6:\"notice\";s:60:\"安全第一、客户至上、品质为重、服务至臻。\";s:4:\"USER\";s:0:\"\";s:4:\"UKEY\";s:0:\"\";s:2:\"SN\";s:0:\"\";s:8:\"printNum\";s:0:\"\";s:3:\"des\";s:0:\"\";s:12:\"surroundings\";s:0:\"\";s:11:\"certificate\";s:0:\"\";}');
INSERT INTO `dd_diandi_store` VALUES (44, '店滴AI销售平台', '202005/29/7b29556a-4b5b-3d40-9e00-7e52916f79a1.png', 5, '1', '2', '详细地址', '3', '17778984690', NULL, NULL, 1, '{\"lng\":\"109.231357\",\"lat\":\"34.156484\"}', 'N;');

-- ----------------------------
-- Table structure for dd_diandi_store_record
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_store_record`;
CREATE TABLE `dd_diandi_store_record`  (
  `id` int(11) NOT NULL,
  `user_id` int(11) NULL DEFAULT NULL COMMENT '用户id',
  `create_time` int(11) NULL DEFAULT NULL,
  `update_time` int(11) NULL DEFAULT NULL,
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商家id',
  `num` int(11) NULL DEFAULT NULL COMMENT '浏览次数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Fixed;

-- ----------------------------
-- Records of dd_diandi_store_record
-- ----------------------------

-- ----------------------------
-- Table structure for dd_diandi_store_seat
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_store_seat`;
CREATE TABLE `dd_diandi_store_seat`  (
  `seat_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '座位id',
  `store_id` int(11) NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '座位编码',
  `images` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT '座位相册',
  `thumb` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '座位主图',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '座位描述',
  `status` int(10) NULL DEFAULT 1 COMMENT '座位状态:1\'启用\',0\'禁用\'',
  `create_time` varchar(0) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `update_time` varchar(0) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`seat_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci COMMENT = '座位' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_store_seat
-- ----------------------------
INSERT INTO `dd_diandi_store_seat` VALUES (1, 15, '座位名称', '4214', NULL, '202004/05/bda32976-f173-3301-a68d-9902d9c6a023.jpg', '共和国那个贺哥', 1, NULL, NULL);
INSERT INTO `dd_diandi_store_seat` VALUES (2, 15, '座位名称', '4214', NULL, '202004/05/bda32976-f173-3301-a68d-9902d9c6a023.jpg', '座位描述', 1, NULL, NULL);
INSERT INTO `dd_diandi_store_seat` VALUES (3, 17, '座位名称', '4214', NULL, '202004/05/bda32976-f173-3301-a68d-9902d9c6a023.jpg', '343546', 1, NULL, NULL);
INSERT INTO `dd_diandi_store_seat` VALUES (4, 17, '座位名称', '4214', NULL, '202004/05/bda32976-f173-3301-a68d-9902d9c6a023.jpg', '座位描述', 1, NULL, NULL);

-- ----------------------------
-- Table structure for dd_diandi_store_service
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_store_service`;
CREATE TABLE `dd_diandi_store_service`  (
  `service_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '服务id',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '服务项',
  `store_id` int(11) NULL DEFAULT NULL,
  `info` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '简介',
  `desc` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '详细说明',
  `images` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT '服务相册',
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL COMMENT '服务内容',
  `create_time` varchar(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `update_time` varchar(0) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  `status` enum('启用','禁用') CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT '启用',
  `is_special` tinyint(4) NULL DEFAULT NULL COMMENT '是否是特色',
  PRIMARY KEY (`service_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_store_service
-- ----------------------------
INSERT INTO `dd_diandi_store_service` VALUES (1, '服务项目', 15, '特色说明', '服务借鉴说明㕆', 'a:3:{i:0;s:50:\"202004/06/4c55bbbc-a4b3-38c5-9ba4-7bfec02b0e7f.jpg\";i:1;s:50:\"202004/06/2527b43f-9eec-3b3c-b329-bdde1c1e1fb0.jpg\";i:2;s:50:\"202004/06/a5ef645b-517f-30fc-943c-bc501f5e6be4.jpg\";}', '45435', NULL, NULL, '启用', 1);

-- ----------------------------
-- Table structure for dd_diandi_store_share
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_store_share`;
CREATE TABLE `dd_diandi_store_share`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL COMMENT '商户id',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '标题',
  `thumb` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '内容',
  `desc` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_store_share
-- ----------------------------
INSERT INTO `dd_diandi_store_share` VALUES (3, 15, '分享标题', '202004/05/ff82651d-00ae-3c75-bd8e-f7285f760538.jpg', '分享描述');
INSERT INTO `dd_diandi_store_share` VALUES (4, 16, '分享标题', '202004/05/ff82651d-00ae-3c75-bd8e-f7285f760538.jpg', '分享描述');
INSERT INTO `dd_diandi_store_share` VALUES (5, 17, '分享标题', '202004/05/ff82651d-00ae-3c75-bd8e-f7285f760538.jpg', '分享描述');
INSERT INTO `dd_diandi_store_share` VALUES (6, 18, '', '', '');
INSERT INTO `dd_diandi_store_share` VALUES (7, 19, '', '', '');
INSERT INTO `dd_diandi_store_share` VALUES (8, 20, '', '', '');

-- ----------------------------
-- Table structure for dd_diandi_store_slide
-- ----------------------------
DROP TABLE IF EXISTS `dd_diandi_store_slide`;
CREATE TABLE `dd_diandi_store_slide`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `images` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片',
  `background` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '背景色',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '链接地址',
  `createtime` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `updatetime` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '幻灯片' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_diandi_store_slide
-- ----------------------------
INSERT INTO `dd_diandi_store_slide` VALUES (5, '202002/02/c5ae51fd-21d7-31bb-99c1-b70547cfa7ff.jpg', '#e06666', '', '1580637128', '1580617100');
INSERT INTO `dd_diandi_store_slide` VALUES (6, '202002/02/1ee6a69f-2e06-3b9e-ac89-b05cda5c98f9.jpg', '#d9ead3', '', '1580637149', '1580617235');
INSERT INTO `dd_diandi_store_slide` VALUES (7, '202002/02/f75080df-b020-3e40-92e7-7f294b58f500.jpg', '#e6b8af', '', '1580637162', '1580617248');
INSERT INTO `dd_diandi_store_slide` VALUES (8, '202004/04/8dbbabe8-e260-3b10-9433-816bb5648c30.jpg', '#4c1130', '1', NULL, NULL);

-- ----------------------------
-- Table structure for dd_dictionary
-- ----------------------------
DROP TABLE IF EXISTS `dd_dictionary`;
CREATE TABLE `dd_dictionary`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `value` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_dictionary
-- ----------------------------

-- ----------------------------
-- Table structure for dd_excelss
-- ----------------------------
DROP TABLE IF EXISTS `dd_excelss`;
CREATE TABLE `dd_excelss`  (
  `a` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d4` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d5` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a6` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b6` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c6` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d6` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a7` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b7` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `c7` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `d7` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `a8` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `b8` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `f35` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL
) ENGINE = MyISAM CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_excelss
-- ----------------------------
INSERT INTO `dd_excelss` VALUES ('1', '变换及热回收初期雨水池', '123-P-1001A/B', '初期雨水泵', 'OH1型', '机械密封', 'PLAN32', '50', '40', '常压', 'ZG230-450', '304SS', 'dⅡCT4', '15', '2950', '404', NULL, '泵, 离心泵， OH1型，铸铁，有轴封 -', '铸铁，', 'set', '2', 'CNY', '86586', '86586', '86586', '大连利欧华能泵业有限公司', 'BP-T19002-EQU-19035', '2019-8-26 0:00:00', 'T19002', '广西华谊能源化工有限公司工业气体岛项目净化及CO分离装置工程总承包', '煤制乙二醇', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('2', '变换及热回收初期雨水池', '123-P-2001A/B', '初期雨水泵', 'OH1型', '机械密封', 'PLAN32', '50', '40', '常压', 'ZG230-450', '304SS', 'dⅡCT4', '15', '2950', '404', NULL, '泵, 离心泵， OH1型，铸铁，有轴封 -', '铸铁，', 'set', '2', 'CNY', '86586', '86586', '86586', '大连利欧华能泵业有限公司', 'BP-T19002-EQU-19035', '2019-8-26 0:00:00', 'T19002', '广西华谊能源化工有限公司工业气体岛项目净化及CO分离装置工程总承包', '煤制乙二醇', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('3', '净化初期雨水池', '135-P-1001A/B', '初期雨水泵', 'OH1型', '机械密封', 'PLAN32', '100', '40', '常压', 'ZG230-450', '304SS', 'dⅡCT4', '30', '2950', '573', NULL, '泵, 离心泵， OH1型，铸铁，有轴封 -', '铸铁，', 'set', '2', 'CNY', '119230', '119230', '119230', '大连利欧华能泵业有限公司', 'BP-T19002-EQU-19035', '2019-8-26 0:00:00', 'T19002', '广西华谊能源化工有限公司工业气体岛项目净化及CO分离装置工程总承包', '煤制乙二醇', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('4', '净化初期雨水池', '135-P-2001A/B', '初期雨水泵', 'OH1型', '机械密封', 'PLAN32', '100', '40', '常压', 'ZG230-450', '304SS', 'dⅡCT4', '30', '2950', '573', NULL, '泵, 离心泵， OH1型，铸铁，有轴封 -', '铸铁，', 'set', '2', 'CNY', '119230', '119230', '119230', '大连利欧华能泵业有限公司', 'BP-T19002-EQU-19035', '2019-8-26 0:00:00', 'T19002', '广西华谊能源化工有限公司工业气体岛项目净化及CO分离装置工程总承包', '煤制乙二醇', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('5', '液化及辅料制备单元', 'P-2201A/B', '调浆水泵', 'OH1型', '机械密封', 'PLAN11', '253', '77', '0.1', '304SS', '304SS', 'N/A', '90', '1480', '685.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '2', 'CNY', '182120', '182120', '182120', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('6', '液化及辅料制备单元', 'P-2204AB', '粉浆泵', 'OH1型', '机械密封', 'PLAN54', '495', '70', '0.02', '304SS', '304SS', 'N/A', '220', '1480', '770.166667', NULL, '泵,离心泵，OH1型，304不锈钢，有轴封 -', '304不锈钢，', 'set', '2', 'CNY', '410960', '410960', '410960', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('7', '液化及辅料制备单元', 'P-2206AB', '2#液化醪泵', 'OH1型', '机械密封', 'PLAN54', '369', '130', '0.142', '304SS', '304SS', 'N/A', '315', '1480', '854.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '2', 'CNY', '462500', '462500', '462500', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('8', '液化及辅料制备单元', 'P-2206C', '液化醪接力泵', 'OH1型', '机械密封', 'PLAN54', '369', '93', '0.85', '304SS', '304SS', 'N/A', '220', '1480', '939.166667', NULL, '泵,离心泵，OH1型，304不锈钢，有轴封 -', '304不锈钢，', 'set', '1', 'CNY', '289180', '144590', '144590', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('9', '液化及辅料制备单元', 'P-2206DE', '1#液化醪泵', 'OH1型', '机械密封', 'PLAN54', '369', '36', '0.142', '304SS', '304SS', 'N/A', '75', '1475', '1023.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '2', 'CNY', '133700', '133700', '133700', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('10', '液化及辅料制备单元', 'P-2210', 'CIP碱液泵', 'OH1型', '机械密封', 'PLAN11+62', '61', '35', '0.06', 'A890 3A 双相不锈钢', 'A890 3A 双相不锈钢', 'N/A', '18.5', '2910', '1108.166667', NULL, '泵,离心泵，OH1型，316不锈钢，有轴封 -', '316不锈钢，', 'set', '1', 'CNY', '55200', '27600', '27600', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('11', '液化及辅料制备单元', 'P-2211', '低压CIP泵', 'OH1型', '机械密封', 'PLAN11+62', '506', '65', '0.07', '304SS', '304SS', 'N/A', '160', '1480', '1192.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '1', 'CNY', '241340', '120670', '120670', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('12', '液化及辅料制备单元', 'P-2212', '高压CIP泵', 'OH1型', '机械密封', 'PLAN11+62', '216', '125', '0.07', '304SS', '304SS', 'N/A', '160', '2960', '1277.166667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '1', 'CNY', '163480', '81740', '81740', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('13', '液化及辅料制备单元', 'P-2213', '废碱液泵', 'OH1型', '机械密封', 'PLAN11+62', '55', '35', '0.07', '304SS', '304SS', 'N/A', '11', '2910', '1361.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '1', 'CNY', '46980', '23490', '23490', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('14', '液化及辅料制备单元', 'P-2214AB', '蒸汽凝水泵', 'OH1型', '机械密封', 'PLAN21', '110', '50', '0.02', 'C.S', '304', 'N/A', '30', '1465', '1446.166667', NULL, '泵,离心泵，OH1型，碳钢，有轴封 -', '碳钢，', 'set', '2', 'CNY', '90000', '90000', '90000', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('15', '液化及辅料制备单元', 'P-2216', '碱液卸料泵', 'OH1型', '机械密封', 'PLAN11+62', '22', '10', '-0.011', 'A890 3A 双相不锈', 'A890 3A 双相不锈', 'N/A', '2.2', '1420', '1530.666667', NULL, '泵,离心泵，OH1型，316不锈钢，有轴封 -', '316不锈钢，', 'set', '1', 'CNY', '42680', '21340', '21340', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('16', '发酵单元', 'P-2301', '活化液泵', 'OH1型', '机械密封', 'PLAN54', '35', '49', '0.067', '304SS', '304SS', 'N/A', '15', '2910', '1615.166667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '1', 'CNY', '50240', '25120', '25120', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('17', '发酵单元', 'P-2302ABC', '酒母泵A/B/C', 'OH1型', '机械密封', 'PLAN54', '407', '52', '0.149', '304SS', '304SS', 'N/A', '110', '1485', '1699.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '3', 'CNY', '178080', '267120', '267120', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('18', '发酵单元', 'P-2303A~H', '发酵液泵A-H', 'OH1型', '机械密封', 'PLAN54', '1400', '30', '0.175', '304SS', '304SS', 'N/A', '185', '980', '1784.166667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '8', 'CNY', '352320', '1409280', '1409280', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('19', '发酵单元', 'P-2304AB', '成熟醪泵', 'OH1型', '机械密封', 'PLAN54', '398', '91', '0.158', '304SS', '304SS', 'N/A', '185', '1480', '1868.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '2', 'CNY', '243880', '243880', '243880', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('20', '发酵单元', 'P-2305AB', '洗涤塔泵', 'OH1型', '机械密封', 'PLAN11', '26', '42', '0.035', '304SS', '304SS', 'N/A', '7.5', '2910', '1953.166667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '2', 'CNY', '41540', '41540', '41540', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('21', '发酵单元', 'P-2306~2309', '发酵1#-4#CIP泵', 'OH1型', '机械密封', 'PLAN54', '220', '35', '0.024', '304SS', '304SS', 'N/A', '37', '1480', '2037.666667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '4', 'CNY', '94820', '189640', '189640', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);
INSERT INTO `dd_excelss` VALUES ('22', '发酵单元', 'P-2310AB', '密封液循环泵', 'OH1型', '机械密封', 'PLAN11', '22', '71', '0.004', '304SS', '304SS', 'N/A', '15', '2950', '2122.166667', NULL, '泵, 离心泵， OH1型， 304不锈钢，有轴封 -', '304不锈钢，', 'set', '2', 'CNY', '51140', '51140', '51140', '大连苏尔寿泵及压缩机有限公司', 'BP-T19032-EQU-19018', '2019-9-20 0:00:00', 'T19032', '国投生物（海伦）年产30万吨燃料乙醇项目 EPC总承包', '其它', '整体', 'DDP', '项目现场', NULL);

-- ----------------------------
-- Table structure for dd_member
-- ----------------------------
DROP TABLE IF EXISTS `dd_member`;
CREATE TABLE `dd_member`  (
  `member_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NULL DEFAULT NULL,
  `level` int(11) NULL DEFAULT NULL,
  `openid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `store_id` int(11) NULL DEFAULT NULL,
  `bloc_id` int(11) NOT NULL,
  `username` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mobile` bigint(11) NULL DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nickName` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `avatarUrl` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `gender` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '0男1女',
  `country` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `province` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `status` int(11) NULL DEFAULT 0,
  `city` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `address_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `wxapp_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `verification_token` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` bigint(11) UNSIGNED NOT NULL DEFAULT 0,
  `update_time` bigint(11) UNSIGNED NOT NULL DEFAULT 0,
  `auth_key` varchar(32) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `password_hash` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `password_reset_token` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`member_id`) USING BTREE,
  INDEX `openid`(`openid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 492 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_member
-- ----------------------------
INSERT INTO `dd_member` VALUES (76, NULL, 1, 'oE5EC0aqNTAdAXpPfikBpkHiSG1o', 0, 0, '王春生', 17778984690, '', '', '', 0, '', '', 0, '', 0, 0, 'LOUHYVzzbOsjJqRLZsyJy1bUV9lEzeDm_1591169367', 1584005614, 1591169366, '6yP7Yhvb63LQo4lP8Q9afWSkJgnEofUv', '$2y$13$5Vz6dEkrtQYpPnxxxecLG./iqXYj5FaPDt761CTN.KLDNpAh46jY.', 'obU4Vd09ToTDi8q9VEdT_XOasYUVaujL_1591169366');
INSERT INTO `dd_member` VALUES (77, NULL, 1, 'oE5EC0afM4V4brNtOqODsq8EnYuQ', NULL, 0, '心雨', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'HGfBlGl8Q6pH0Zbr2spMCqWE44lvHLX6_1586935837', 1586935836, 1586935836, 'BTqhWRp3sbeG_e0v0qyOempilPyWrqxo', '$2y$13$9znBNU5WMdcCYhMP41T0h.yOG36Y6xZFeOZzvw0Q5dentiNHnx5Ly', 'aZzlBOCKqK13jgIKxH_4ISUlfB_i-8b7_1586935837');
INSERT INTO `dd_member` VALUES (78, NULL, 1, 'oE5EC0XZjjKrQXgKc_ONaHO7nu8U', NULL, 0, '冯教授', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_IHfaZRnQhBdJ2iKwPlfQDM_oobJLEaH_1586938161', 1586938161, 1586938161, 'NbuwjxPh6vXzSLaBN3Iq4fDSHmKXD5BR', '$2y$13$5XbU4va1BYafWpG8nCdwF.c6LXvwcA.glVBEojmQGbAkXpYRPEnxm', '7phXmrVb9UDRLuUYGVC7QZy4uq4Jx9Bm_1586938161');
INSERT INTO `dd_member` VALUES (79, NULL, 1, 'oE5EC0aRDVDME1L39dYWzt9bUGlI', NULL, 0, '盛科', 15600388714, NULL, '', '', 0, '', '', 0, '', 0, 0, 'z8XjkW94HB2efhUaaZTDK_vUgRB2JC7h_1586938850', 1586938849, 1586938849, '812_g-ek2Lt1P4VjOtf-mRpI3-cveSiO', '$2y$13$GnUAPChzzd8YxpT3yK5RqedbNmwEd1o2QXEN.au.tjkxhikCi6XZm', 'Nvq_YScdm-hAK6cNtPE2Q5Y8byrpHIOD_1586938850');
INSERT INTO `dd_member` VALUES (80, NULL, 1, 'oE5EC0eK9X-hguDmEkSqLpakXHIE', NULL, 0, 'callzjk', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'mIMshxdka-fiMIeY3cKcOaFeYAuXRExh_1586941211', 1586941211, 1586941211, 'fgkLU6INwFC8Z9xk9SQKUwHLOJGfxvX8', '$2y$13$/FQasaZJhDDO19xZcb745u.CBY0LgVpzamH9pASgCsqHZjOp0Y6rK', 'YvJfQWR229CanLkgAnRkCuH36hp-9w3O_1586941211');
INSERT INTO `dd_member` VALUES (81, NULL, 1, 'oE5EC0TLr-jpEqRV-x7WqjPax7jA', NULL, 0, '魏剑帆', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jYZla-ATHyN68eBPAEyYQ8Gi83722jVg_1586982257', 1586982257, 1586982257, 'h2zFSRcWU4vYrY6TQlpq7b8JsJ0Dc7L5', '$2y$13$EppJ4zs9k5qJgzbWiZpDou4k6XKHjegQb2hGxv7VdygpMmPSYszDa', 'x2LQe7VJ2aBRP3JEPb6K-1XhMyqQ_8O8_1586982257');
INSERT INTO `dd_member` VALUES (82, NULL, 1, 'oE5EC0Uvc4QkT_TgcfhgSfpO4LLQ', NULL, 0, '赵博', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '8AVOURHN_tWXEAADZ_2vaByPKlztwTcD_1586999119', 1586999118, 1586999118, 'GsYkPT_tzZmek1MvLksXNOVCsxNichJf', '$2y$13$mreeHcE5nXkH6s0H/uiIj.7UHIUEhdFsmsgl4B80Bpg9waPnU/YFW', 'nF3ApTwwjOx1YQphmdsh6U-_PppEOO_b_1586999119');
INSERT INTO `dd_member` VALUES (83, NULL, 1, 'oE5EC0S5K7EMf1tCf1S3tIBXIbCw', NULL, 0, 'ruibaofu', 13513366999, NULL, '', '', 0, '', '', 0, '', 0, 0, '-FypVMOyPcojmiNQwwjTty_jMLAzS5E5_1586999197', 1586999197, 1586999197, 'DYVKJ4MG_a-Tx3fx9y_TfxJEcN4jMPv5', '$2y$13$.43Y5ity0B3Gno9M9J3r5e/7rcgm6RKECcEsJBL/M6rD6lJ1THB5a', 'P1S1Sp1JcKzC6JXiF0phM_WeYkdPUb6A_1586999197');
INSERT INTO `dd_member` VALUES (84, NULL, 1, 'oE5EC0U4u2ZwyzuwckZrXPBolhnQ', NULL, 0, 'Sam', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'K7eCPLgRGj6fBUTWTSddVTDh_lq7_szH_1587000233', 1587000233, 1587000233, 'v7zRu-EkyRMSHS0UsIJW58EbRnGAG630', '$2y$13$JhxvYZjZT9PHXJ5lhx.E5eYn4nMqMeHGoG4nNkan/yeFXfuZ/QsNO', 'IiH-F32nioh6NAAYGtzjt-MEpvToLCor_1587000233');
INSERT INTO `dd_member` VALUES (85, NULL, 1, 'oE5EC0WVJ2F3utO_BOm6LluEuN8c', NULL, 0, 'S', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Ow47vmThaDQMLNdjEthyN9O9sHVdH3LW_1587009910', 1587009909, 1587009909, 'gOIIUeaKc8-QjE6Jh2VGIVHHoEvaPmYa', '$2y$13$DvpmC/vJI1QfIN2kXH52NOibiKvBijqbCPNiEguSBLzIMs6UwABzy', '6LwLxYYPdmN5y4-z_4pb20APe3RIgcEt_1587009910');
INSERT INTO `dd_member` VALUES (86, NULL, 1, 'oE5EC0T_WvEAoNipm3VSSPRzdvkY', NULL, 0, '崔新道', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'H2hL-Q0jgT607dMyXCpuHAePcMz_R36-_1587012328', 1587012327, 1587012327, 'MEAi44sd2iDMkWgrwLJl_gbh3kWQUKRH', '$2y$13$LOva1fXx.H.WCCMmSQyuk.scFO.niKfKN5/uLePvSGfp2c5fU02VW', 'KTRlhjEWEYNZ2nqf5SyMqDm2CXnCKiO9_1587012328');
INSERT INTO `dd_member` VALUES (87, NULL, 1, 'oE5EC0b6D5Y4rbunZ898h-xcS6D8', NULL, 0, '阿白', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'FX4KfKyiHw36xmxZ7q_2SV_C68ZACyzt_1587027160', 1587027160, 1587027160, 'oIciN-MAF89XKtdVZH_567MkgcToPxcJ', '$2y$13$d97LA/40HzH88rh3Foq5ouToSbJZmk927RvTukyPQiow4s77aRwgy', 'tP6mNHuSOyHvfLwtGQFckK0lr03kRzdu_1587027160');
INSERT INTO `dd_member` VALUES (88, NULL, 1, 'oE5EC0WsKZhxybJwn8JYdHRg3RQ4', NULL, 0, '莫思', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'WUCHWu7FQXmHhmaBI0hl6kvjshRcEuj8_1587040257', 1587040257, 1587040257, 'SMyEuXI3LkHGrQieucFx1Iw78A3m7Jrb', '$2y$13$n/SiuBEdViGzoiakOQTwjODZBdP9PdIpQ81BW1H6AphWpnuxojeVi', 'UbdyiXSm5NOC9mxXAAHw-PdWS5yqTAMD_1587040257');
INSERT INTO `dd_member` VALUES (89, NULL, 1, 'oE5EC0RVdf3EtKdWYEpJ2kQbDxwY', NULL, 0, '王昌栋', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Ltn1w9BHaqahs18TYcKBonMmpA4sHtyD_1587042026', 1587042025, 1587042025, 'l1e8-lo74giTLmO2mRaMpktj4-xXmik7', '$2y$13$xo2DV3pSZxprt8b1pxO3Eer/KqsZXtb93uAnVP9/Cf9le6AVQvMhC', 'l8yVHEQCWTT3Kn-UZU5Sk0vnRHFa10CZ_1587042026');
INSERT INTO `dd_member` VALUES (90, NULL, 1, 'oE5EC0W553U-JFQL3uczY04PMAnk', NULL, 0, 'judy醒妞', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'rhlg8O9ffIXRZxywiHLscOkCWNsmQB4P_1587085724', 1587085724, 1587085724, 'cDKfgxRDxRvJEbnvxBUmvkU_5LPYPtMO', '$2y$13$KiXwz1mDnMZXPVLGbxn.s.UAK3e1OT04QMNmJqguObKUHHJKV.QG2', '5WO-IM0jKSBZHoGvuZOzFsVvd_r-0wZh_1587085724');
INSERT INTO `dd_member` VALUES (91, NULL, 1, 'oE5EC0UUZxACRdtFZdO_Hfl5FkpE', NULL, 0, '惠协发', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '1-MLTpzD9YJQgN3T76R4VHO4Xa19n2F8_1587097119', 1587097119, 1587097119, 'EM4AZW5ohcJ8YO6uqP5tvHWKaW-mVBma', '$2y$13$Wmg921guVULJFiTfv/XhDO0grX.y3j3uX1lgjmbmEuYiLvvITbgky', 'oxMJ6O2wyxX3uCL3Y-cz6QR6GA_BKpNb_1587097119');
INSERT INTO `dd_member` VALUES (92, NULL, 1, 'oE5EC0WCXthR-YCz6nD_YwaMBlbQ', NULL, 0, '董', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'w5fgviJYoYSi6hGlvf9ZPHI-6345-QNI_1587097248', 1587097248, 1587097248, 'iaDZTc4vMu6mUV8GIgOBOsY7Hk7PFqqr', '$2y$13$defZuV15jtgb1n86cFgGoeIIUlEuLg7BVcE3vVCzl6RzBMEp4r6D.', 'LrZunr10RLUPkAxpLhkmGf-ine5t9_6u_1587097248');
INSERT INTO `dd_member` VALUES (93, NULL, 1, 'oE5EC0QznY0pnfvROYus5_4Wcc5I', NULL, 0, '周周', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'On7b8PsZrw82BDmAIw7fht6Hhh4wfvx6_1587188717', 1587188716, 1587188716, 'VZMlVC1phfEYo0wuinwkwKE-eMrl6B5j', '$2y$13$GYDgXMNH76K.CLUTb/QA6.SgxX2uLAWuYp6JFiD3UlX54Fu1UK4jC', 'Uq4VX9r1s454VHYJ2cGbVCVuyX0RisTq_1587188717');
INSERT INTO `dd_member` VALUES (94, NULL, 1, 'oE5EC0ZnVtq0pi_hAlyRzcE8oLOM', NULL, 0, '森', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'j2w85_sVkmN3KO1UVpZew-kXvIpee5m7_1587219784', 1587219784, 1587219784, 'wGwHh2iBaQhmQxILQdoyS1XGGkWdmVBN', '$2y$13$mPh..edy8TqctSN/BUx5Pu.EuuoffvrGWngD1sJ4texk9jTuD27Tu', 'D0uFdjBUTTeQpMH2kfur46w4-GVvLx2l_1587219784');
INSERT INTO `dd_member` VALUES (95, NULL, 1, 'oE5EC0azpuPFyRcyIbxPkE3zRk5w', NULL, 0, '李珮心', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'UczyD5hWym9OxUDaippTixB7GAQ-R1E0_1587280987', 1587280987, 1587280987, 'oib-vxoO_JTKThYq9mOO1BRevC3G7fyF', '$2y$13$N0ntfcKMfypeG4h.4Xy9z.ItsnOyVTyPUMS8WKOd79hFJF/VThR8m', '1-eN7xD1KXBzZgcq4AB18JRltINAc2OD_1587280987');
INSERT INTO `dd_member` VALUES (96, NULL, 1, 'oE5EC0V37yTXf0P_GUKb2KlrWG5s', NULL, 0, '清风明月', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '11yEBw_ayoU5A90CCzhMUmKThKP0d8Qy_1587380962', 1587380962, 1587380962, 'o7Mul1Dyk7tlNKPdLBpUmEv4HSXhRJWK', '$2y$13$OMMRs.Pl8N.ZdJXaoy0bo.nFukBVOzsIWLG5a7jyRaNbqhQGPk7yK', 'AvvWXWrRAp0THrhBpUtK7IBPgwENAG_F_1587380962');
INSERT INTO `dd_member` VALUES (97, NULL, 1, 'oE5EC0YZmEGxxdRNlY6KPT4MMXvw', NULL, 0, '达柯店', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'aG-Y-w86S8VBKeP4nzV76AB-9n1AA-ca_1587509316', 1587509315, 1587509315, 'vyi5whg7C6WXwYy5rhdh3_3zqEhmh087', '$2y$13$fIG95KKB36PcUnhZpT6hn.9OvnliIXGvkOZc1YTcR.03kTXMMDXZS', '3BOtYs7v1I91PNwSLcX2ZK9AT78h47uX_1587509316');
INSERT INTO `dd_member` VALUES (98, NULL, 1, 'oE5EC0cmqtVK_Qs8JLTaFCYQ7rX8', NULL, 0, '阿白', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'rqUgDq1eytecIEBtjFyYtx-pFrlutFCk_1587518780', 1587518780, 1587518780, 'hpbFh0x9cPC7b3ZvPKyFcK18Ib7RUjNz', '$2y$13$DNSdB79klPXRQp50FSAkZ.JgeN2dqjNN651.7T30BU9I6KuMlINAu', 'OIs2PEujq87zK8eGaupFaMEozjBD-ag1_1587518780');
INSERT INTO `dd_member` VALUES (99, NULL, 1, 'oE5EC0e33D-2Z6VZVnCw4DjSsDxo', NULL, 0, '自强不息', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DshF7prnE9mE52-TKzdBo2Kd_l7iaP_1_1587538658', 1587538658, 1587538658, 'DgjQ69rvQzjxRO82jIps-NB9o3biyLg3', '$2y$13$1gbfnz5WNdkrJQQkSxvPl.q6.0ypNoGLuLy8D1ZcADyiLZuf/lhcS', 'A9-o6HCELP74yfxWP9b_LIehfJp10HTD_1587538658');
INSERT INTO `dd_member` VALUES (100, NULL, 1, 'oE5EC0Wqyg790huSMiaMwmKpAyGw', NULL, 0, '、New_lifeZ', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '9TBQ-D9P1ehjr4v6T75eFMky6k629Y2K_1587548101', 1587548100, 1587548100, 'fgrIdwCo6kKCLR3NLhZNY7aJF2XmQ6_4', '$2y$13$.aJWqJFOBmff/thk.t0tyObInDi.78PjM1SRXJFLiBPq5SZw4swie', '5bwmlI8hXjuIeTYWgqQDhV1PrXg6ifsx_1587548101');
INSERT INTO `dd_member` VALUES (101, NULL, 1, 'oE5EC0VxLFXLk44_vWuL8t2FyuXI', NULL, 0, 'Dobby', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'oAZ68w2nUbGQVN4NtsCNCcEO8KAqckz3_1587752939', 1587752938, 1587752938, '_lJ7JoFB0AKy-iomWhkiCc-TSgU2IGBA', '$2y$13$5qneg.9eIc9jko8W2cV22O.ZGuq800JB202Nnl.94Lengu3.m76q2', '53rgPb1SpmUix8ercezKnBpDeo5j9iFY_1587752939');
INSERT INTO `dd_member` VALUES (102, NULL, 1, 'oWwx95ah9DFDURUj8LRMjRUA955k', 38, 1, '王春生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wAihLQswLN2zDnnWRAql3-H1GwutLu5F_1593146594', 1593146593, 1593146593, 'zPNaDCy659slK_VPjYk2SEVMKAtFlg1e', '$2y$13$Ui3OpM8uCZs1bqMyVh.xlO8tPOq7XDoZ61an6kLbEh/zC5/xP./jG', 'W6dJk14taLbYRGie3WiB4-LIX5OwJg2Y_1593146594');
INSERT INTO `dd_member` VALUES (103, NULL, 1, 'oWwx95aYnQqdMbl4qhxJFFeLod-0', 38, 1, 'Shinawatra', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'A3AIEipVlxlGNf5PqMhv-z5PQ8HF9W6Q_1593678855', 1593678854, 1593678854, 'pwIhWWZi9HDbd1MWmY5cTr9kNwoMWWLT', '$2y$13$qE3ukGn3NI.AH3Xg0o7U6O3ockAQYZG1kq4O48RXybCdGVWoHeLd2', 'oGkKdAhZdCcm_SIzq8FCY7-dQtEC447q_1593678855');
INSERT INTO `dd_member` VALUES (104, NULL, 1, 'oWwx95UjQy5wOJ84RlUeq0UukVMo', 38, 1, '蓝色妖姬', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_oIjgksmSRr1y1bN2MPvjsytquKtykBS_1593679601', 1593679600, 1593679600, 'OMu8U2QZUnyoPpghAWnjfQnwwE44X6jW', '$2y$13$xmodAsI/1WkxjYpbQEmcjuMyaVZHNmhvAU5fsskxbRoWGdxOlbgF2', 'KFCzjT5hbtZKEksRWq-zXAJTqDMB6qyc_1593679601');
INSERT INTO `dd_member` VALUES (105, NULL, 1, 'oWwx95bS5_-Emi0ec9BMQcQbTjfs', 38, 1, '手毛', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'cPdG3VvQDCubzuu34KtQuXv1_vfFNXfS_1593680337', 1593680337, 1593680337, 'HqavVdjAnAZK-R2HBpOy9daQSeHOfAPZ', '$2y$13$KiJHfFk3d74lNSks/k8R1uGAKy4viWz7y58ERld7QIIjCVvkHLAEi', 'gCEQB304EMja53cA-h90gKZbGJyy8fi3_1593680337');
INSERT INTO `dd_member` VALUES (106, NULL, 1, 'oWwx95U6umbfQutwUn-2f1z7Ag1c', 38, 1, '唐吉柯德', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'JvJrdmwNJiLcLjECfSUQT_1qQSE2pBF8_1593684101', 1593684101, 1593684101, 'OXfGjP9SYpYj4t9b2pONmX1R0lSJKJpG', '$2y$13$SatYS4n/RYdobVkO4ewCBu2rkORQQTeZnLSEexO4z4NMJtUryYkWO', '69XFRyzKre5WT6aYpOkzguyXl4PEUaCs_1593684101');
INSERT INTO `dd_member` VALUES (107, NULL, 1, 'oWwx95el-5IOjlOt9crzJpFD9t3U', 38, 1, '魏剑帆', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'GU7cKtTncsR1OPnJkgOnqWfFWljpQGHo_1593688440', 1593688439, 1593688439, 'cyqsE9wGAtK1NU5Yvq0H7Cq3cI105A-R', '$2y$13$K9sNMrHPLXJG9/7VG2IKZeZHlhzh71.Guin6t0AnfytwAVsa1SaI2', 'V31VLMKjBiUGl8k8cr6Q8s5Kt66YG3xo_1593688440');
INSERT INTO `dd_member` VALUES (108, NULL, 1, 'oWwx95VtjIP0mZhvgFmZvlyd503M', 38, 1, '吴雅玲', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '6pD0sflgCI5BXqohJSxup2yFMTIjn3A7_1593737459', 1593737459, 1593737459, 'g24Tzngy5GXV7pRYczRXvsdeFW5YACNN', '$2y$13$j60rLo9pjgXeCoCM9/aHUeWg8thcXFzXXYxnXLDYrDukbculPGyri', 'GiZYWMN2bEbilRCJG0wXmMYMrUMP-E99_1593737459');
INSERT INTO `dd_member` VALUES (109, NULL, 1, 'oWwx95fScDYPK-58fTvt94z4q7kg', 38, 1, 'Tower', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'xWefhFZ2Ew7oamSX-KC0AZRtqDRdfl-3_1593838107', 1593838106, 1593838106, '7LGErB_kIp4NIqEz7DejdATeEaUByPMk', '$2y$13$RSByRQt2xDkAgkO06KfUwe8c7vYMeMmBiktHmE7eGprSqyTrQfZja', '_bEtmeYK2QbXCzE0qJ2Gmw8CLzi7wB0d_1593838107');
INSERT INTO `dd_member` VALUES (110, NULL, 1, 'oWwx95ZQN3L0ZR5p6emrMQdtM29E', 38, 1, '文长', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3rqsTUun-uV8VUqUr0gWZD9k6dD2QcKi_1593838211', 1593838211, 1593838211, 'FlNlZOjhAvYOM3VBPpBRMzA1R1rKYcZR', '$2y$13$5O.8a4RLSKSCisZJsGYO8.RKMjBnGPi1Bn/3pay0jYQ8H1cgwFxI2', 'gMjqAwGA35U_1iyIeujlTaImczh75uHt_1593838211');
INSERT INTO `dd_member` VALUES (111, NULL, 1, 'oWwx95byAAaFSFJpD6tedMkKDimE', 38, 1, 'Vennon', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '1hlvPPHs7jaStVry7xYMxl_apm53Jhku_1593838473', 1593838473, 1593838473, 'BK-omN8O0_4LbB8xJt1vOds3Lr6_ok10', '$2y$13$tWyXM.estJb6.dlVohpIHuMFJKAgNwBNqgmtz8ex7IFD331h7ZhIa', 'Dy_ZOEBVqc97h9HphlHfUjsFee7hOFTb_1593838473');
INSERT INTO `dd_member` VALUES (112, NULL, 1, 'oWwx95Uu0dFTSruN9lp3_FscZIVo', 38, 1, 'HUGOOOOO', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'PbKDG9B39nUDWa8diXB54t1FHpar-wD5_1593844368', 1593844367, 1593844367, 'BSgbCCX9MO5c_BoX5S9iafvRpuWzPZam', '$2y$13$4ZRargRNb83t1uZ1TYBmGOXi8skbjs37V6wrcurXAEBt6X6xhR41K', '7G8CkLM6Q2OggOzt4EG6eonM-LtjG_Pa_1593844368');
INSERT INTO `dd_member` VALUES (113, NULL, 1, 'oWwx95Tn0AG1GjOqSYk6kuIZUFpg', 38, 1, '超_越梦想', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'bM4ibvJtqujBTMbX_KTWXOgAXX3bpevM_1593857692', 1593857692, 1593857692, '1it18CYljVFQxw8_vIn3tzAqPnn4fUce', '$2y$13$oXKWFlchB6TeqTBzk4799.0luYS6I4.TIsDL3iBIte61E3KP/BTo6', 'Ml_UprF5jw44h5sjH9ZNUiCi4lWgdTet_1593857692');
INSERT INTO `dd_member` VALUES (114, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7piNglekBZdq0J23pOWop7l78MR1wXf-_1593860005', 1593860005, 1593860005, 'iZpBm9ycWSF19ur2cT-t5Aq8seb5HnYt', '$2y$13$t0XxeY/P5.mldWU2DsD5G.yCE/0vpcrXfPP3Lc8bFFohjiZ6E/wR6', 'Enq0XnMl4zxS0-qpqI9xNNiicp1Fe_nU_1593860005');
INSERT INTO `dd_member` VALUES (115, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Gpiq9EIRoLoxD0Fd3wZMwf3XDE28cPLk_1593860013', 1593860012, 1593860012, 's78YuozGMVTc5M9ADcZ5MfEUgLQ55dzN', '$2y$13$DoqVOBV3dWaIINs09y7WHuBvwUzVPTjT8iIR6q87McSWLxlAZIKge', 'I8pRzAensIG0YbxH__01gfao0hQ1ullv_1593860013');
INSERT INTO `dd_member` VALUES (116, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'EDe4zxldBaK3zFJWWOq9cr3gUTCf6t4p_1593860022', 1593860021, 1593860021, 'OUm_9YO_-vr5XK1bktYro5xbJLYsgEqy', '$2y$13$Mz/NNQjsDyqcrhIAW.KF/.50muJgK6HOt/ij.B4nDgrV5X7dqh.8a', '7jpgF2fwSrrzb41dt9v9C2y5CMjCxKLJ_1593860022');
INSERT INTO `dd_member` VALUES (117, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'pZoKHnpDXjjM3M96xkrYzIlOQSu6kOpA_1593860032', 1593860032, 1593860032, 'OA83eD21KQPmh6cfCQhnJYPfYtde5WmX', '$2y$13$uRHPGR1G4MqOuYVINRMsReUQOpjX3VefIKUmlfye/o7R5lQn.EBF6', 'DpXPbffCpF3Bfx_k-JtcBc58AOk069pO_1593860032');
INSERT INTO `dd_member` VALUES (118, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '53hwGVmrpVrM9164cIOqvE85R0Nlv7rY_1593860038', 1593860038, 1593860038, '6NsAwLhGoGZzTcF9Fret-NyNoZj8Og4a', '$2y$13$5ENrJMkB1WTTx2FeshcICe/kYXEX5ePJ.vJq6qGKxz9kY3VOpnuLa', 'w9jWgw1TD88CrTGJ974A6jtrvW7IdmfW_1593860038');
INSERT INTO `dd_member` VALUES (119, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Z2rTN21rxqGgq5b6oP0ofaltlyutmCvM_1593860049', 1593860048, 1593860048, 'Ai7NEQJlX2wLU6zSCwBjVGnCPfYpNwMi', '$2y$13$twv/bvwW/XRf8opSa29bKOLSV85DXP9AABgWUPjldaejQNHge.slS', 'kAVop7n_q7As-NKDapbiN3Nbk2GimRIe_1593860049');
INSERT INTO `dd_member` VALUES (120, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'YaSbkYhyqgMxVOW4nFOE32KItyLxyuzK_1593860065', 1593860064, 1593860064, 'b2xV2D22Ti0yqpcHpHBZYFdNGYhHhaTZ', '$2y$13$blMw32oWtC5ce713L7oMjuziA7IlC7Pk94H7EW9TDQBOStouz94pK', 'cQLAd3QHpEtFWvUvnUHuupg_iA9eV0nq_1593860065');
INSERT INTO `dd_member` VALUES (121, NULL, 1, 'oWwx95QxKmEpXXu9v1Mi40BFc0jY', 38, 1, '洪宗翰', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '-IiddQM215lQ9v0rh9WZ6vpfzoLmKUAX_1593907376', 1593907375, 1593907375, 'sTUIgjzjvKCOb_wX2jf4-7TSRXwzSmpr', '$2y$13$gL5pT4m6dXY/A5Ryyn2G8eF.D8h36PjrDS8v5xAQKO/dWqbAP7QpG', '5GU8bYHy1Q34EAvi0Wt-grG1Wo8fmhLs_1593907376');
INSERT INTO `dd_member` VALUES (122, NULL, 1, 'oWwx95fUmd6ZKXbZvB9fVREpKQcE', 38, 1, '智智智豪（中国人保）', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'QN8yzVkGIzKQcOWihDQ1LByejBN9FjmO_1593923789', 1593923789, 1593923789, 'rNCdVVWqTyD968ygvglzYazNSvRkfNQA', '$2y$13$OTuMMTXRKALCVBqRmV1y6.ckbPJEh3eyvpgRLKPMYUT3lCZ9TKuvK', 'olNShuf6MV4lX0smhlbwH_VCuaUtU2cc_1593923789');
INSERT INTO `dd_member` VALUES (123, NULL, 1, 'oWwx95b84Uaq7zHo5A5gKgyuzEOA', 38, 1, 'seeyou', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '8BS9sgtw7FuSMJPDXSu4Wx2gPM57Pv0m_1593923818', 1593923817, 1593923817, 'hKMpAutlRBJX-w4js1bq1xhKCDWmnuKr', '$2y$13$8ihcmBgdyG3Xhv75PrInRO9UmBz8g9njuJvSAsEmuMGqC0EeK5WoW', 'uQn9dHWH_4JNtuiAhEmKXWv2zvgh-cgO_1593923818');
INSERT INTO `dd_member` VALUES (124, NULL, 1, 'oWwx95b84Uaq7zHo5A5gKgyuzEOA', 38, 1, 'seeyou', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_h8pJxvBuC_syU-OgRkK_bpJs6qEXriR_1593923818', 1593923818, 1593923818, 'K_OVeMumSMk-dBGKVi9QXrWjk7OXxEOd', '$2y$13$iqM1O2kOe4WG8SjmyOPMROAgpMSnKxJLKqTlDluro41uSMl8tb/si', 'XX78CA-RQF42o_wdIbD9ox3l0kKJUisq_1593923818');
INSERT INTO `dd_member` VALUES (125, NULL, 1, 'oWwx95T2EI8jLOPtR0h_wcaSJfRY', 38, 1, '潇湘子', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'mmWGZVif4Ve8ONhfFeelmRXIM4lezvOG_1593923905', 1593923904, 1593923904, 'fs19EVsOUZ7w_eIkfSuBx0iyuWy4vFsC', '$2y$13$/.Y5taEvZe0SzlL1i.d02.FywUVf8g6zUKfUW0sEHsOtyp2qWmdFi', 'LTXTCRCn29Ry6os1FZff3HcwoRESvWwU_1593923905');
INSERT INTO `dd_member` VALUES (126, NULL, 1, 'oWwx95T2EI8jLOPtR0h_wcaSJfRY', 38, 1, '潇湘子', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'iInxB3Uq19eE7R8hskk1IomMNMz2sg7f_1593923905', 1593923904, 1593923904, 'Igh8g_sbqJgbrKTPscBF5TuJw5lxbwqM', '$2y$13$gW433s5q5tW4lcRe1VyyyuciRmm4J3/aa61QfWak8p1mogILBXcWm', 'b9_l3u8c65iLkB_CP0wNlxjsbfLLNSKX_1593923905');
INSERT INTO `dd_member` VALUES (127, NULL, 1, 'oWwx95RHEU5GTx8osGiSivcrhhYw', 38, 1, '虫宝宝', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DPLN-9-jD_O4jiD1mEcTWpYfy5W5syzw_1593923964', 1593923964, 1593923964, 'M2jjaCiDQXDvAoNeY_9hei1H6MDYDxge', '$2y$13$eQTZ90.7KGKBgqy0o/MV1uJydModFJyAtu85YfVYVP9hzgCpkNZtm', '13DzLZ-unNkjesM0coytd29wwoyLavRB_1593923964');
INSERT INTO `dd_member` VALUES (128, NULL, 1, 'oWwx95cJhp1LDYlrz6a16VdaUKB4', 38, 1, '。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'O3bGriGFnbWtKxVActt_4Ix9bQjZQvZL_1593924130', 1593924130, 1593924130, 'fBarbhIeAdn8cSBpHr4ZDIrkMmdkjW6N', '$2y$13$4EqBkNbp/0TFmMBc7SCQsOPbVuWYRj3hSkSIMiCXtGh5b0NWvZjK2', 'hcJYa1BZ9bJXFl_eisDFtaFK6bJK4jYS_1593924130');
INSERT INTO `dd_member` VALUES (129, NULL, 1, 'oWwx95UNtWQtIRO5wzhuyW0DQTJY', 38, 1, '汗青~', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'QwliHQlgaDwWeN7H7ByMbG-aR6uX3iv4_1593924214', 1593924213, 1593924213, 'xauMVpKWgAJDiLMhmItdtloVidRtdVwR', '$2y$13$gOeAMnNmg9d4T8utjuwHQOPdt2QPT7llt9UAgI9sbId6lUpk3D7LW', 'm4DqNb3KadBY_kPYI5wVn1KPGtd2QxW1_1593924214');
INSERT INTO `dd_member` VALUES (130, NULL, 1, 'oWwx95QupqBkxFdzIsA08arSSqvg', 38, 1, '帅哥', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'JHTK_mxIQKqk9uQbOUQ2xKnC6HsHozOT_1593924612', 1593924611, 1593924611, 'PhlYihswOV2av9LQ9HPj1nbrQaSUinAy', '$2y$13$42aNfdVZ1crqVmAiK8l3re0sFeR79VXFa2M1.f10SZiIEGSrj5jAy', '-6iC3FaLFXiiz082QPr7wL0WePtVuxfk_1593924612');
INSERT INTO `dd_member` VALUES (131, NULL, 1, 'oWwx95YGCSa0JJkiLTWH87wfjKNU', 38, 1, '焕樟', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '1G1Vg2YXsZ0pd3QqslP2cjM3rZdi2TLS_1593924619', 1593924619, 1593924619, 'ZjgrYfk_tN3vL-xne3WDwuU-CFcvDjMT', '$2y$13$13jUHrtwa.Oh1gI0i05LjOPV1.3W5YOISy/YpFZfj16u0Rcw4ZK.a', 'nOu_PT6hXrFGNDKJzzBZCo_KNscyxwB2_1593924619');
INSERT INTO `dd_member` VALUES (132, NULL, 1, 'oWwx95VX0ex0-524YQ7bHAbMikGA', 38, 1, '幕后煮屎', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '4F0gGGdT7TPiYwJtQ-lSRZsjRpVkkXHq_1593924621', 1593924621, 1593924621, 'EJGGMy5xSbOE_otnmIf8tJXoSrioJ6fU', '$2y$13$rN8dPc7QyZ0E4dtags.8Ueealw.owpqL9vlQdKZdAsawj3bFL9BI2', 'Z44m6w5syBs2XhSZi-mti6BKMb1Hewjr_1593924621');
INSERT INTO `dd_member` VALUES (133, NULL, 1, 'oWwx95bUPvC9eFHmc5OQn9pNzieA', 38, 1, '洪', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3Nw98kLml3TbAL78dBzlYgSJxFnhEV-p_1593924622', 1593924621, 1593924621, 'phu5kAmE1YHSbbtaUrStRTbsm5q7JnWG', '$2y$13$GBLsp0H8ZS6B493e0ZDdt.BTsA7pA8u3/qD2ai0RRQ.JvcywFez5C', 'T_aVDy5-HlAWb3ds81rmD4YSG5aCjfWJ_1593924622');
INSERT INTO `dd_member` VALUES (134, NULL, 1, 'oWwx95aiC0o4AcsgKyhcIiw6bMSY', 38, 1, 'Mat兄', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'N0DyelWKHWrTzruniv7WXAQMjKR34y14_1593924629', 1593924628, 1593924628, 'TvOJLPwiXx9eDlbxQOd-cod_3s2eDKir', '$2y$13$8tZUVDwK55gei6WvqjY3jOyHVoNRWeDBEPQ1QkddM7VaFsPX26TRm', 'PN4Y_FCOnsfRnGmc71B7xic_4jEov69u_1593924629');
INSERT INTO `dd_member` VALUES (135, NULL, 1, 'oWwx95aiC0o4AcsgKyhcIiw6bMSY', 38, 1, 'Mat兄', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'zEfzdCLFqbmQ09Wktq5F7KqKFQsmTnPx_1593924629', 1593924628, 1593924628, 'wY6W1VkNcjtsZvaVcU7CuO7QGtlaxTX7', '$2y$13$TXMno33xmkueNNgHVhzaEOGU2BSBcga8GrcEieu8bTbYyRWBK0TeS', 'dnsJlIY8MxiNsZAhSaDEU0aRNCcGKmza_1593924629');
INSERT INTO `dd_member` VALUES (136, NULL, 1, 'oWwx95angs8CK7RMLUheh4R9jjhQ', 38, 1, 'Austin', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'MZJqp-_QyPMA5s-tTCcJQJb0QN1DfCUs_1593924642', 1593924641, 1593924641, 'udbYqss_9kkbWsmnH1uvwoYhEC2_qr6M', '$2y$13$OnZEvuX9IDwg0OvDGib9UuX/HHyvRwEU5DMiRn8SQpQEofze/bxQq', 'dLZdrM8TfcBuKh3YKkvGS2AY-UWdcbjf_1593924642');
INSERT INTO `dd_member` VALUES (137, NULL, 1, 'oWwx95es4EofB5-M2CoYfSymoAXw', 38, 1, 'somnus ಥ_ಥ', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '8pIwT5anuwsovK_hGR0kBmyjl2hzp2Gd_1593924670', 1593924670, 1593924670, 't7MdvDp5hROwfTFohRt3kR5k-D4lKv0G', '$2y$13$2MDAgI67t0ohL6DG8tU51ulVUfFRhrtYiKnrLdKZAV9dFhfqFBGn2', 'twL3bWagMZv3zkwF0PQGYb6R54YRzbO6_1593924670');
INSERT INTO `dd_member` VALUES (138, NULL, 1, 'oWwx95Y9Z94yJyw-r1pZDP_xaTjo', 38, 1, 'Anoxia', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'tO_wDuk5U6fk3Vy74ZHtzC6JF4bDwklI_1593924671', 1593924671, 1593924671, 'FFTEsZtiA_0VWNMTBaoPyJsmesvhAu3t', '$2y$13$Hk62Z4dckSJqf4I9LNouY.MIlCf6E7oMJYx7q6LkYJtzWrh6Yoak2', 'vApuroXNbYh7Yd8M4vPiS1EjfkZ4iB-r_1593924671');
INSERT INTO `dd_member` VALUES (139, NULL, 1, 'oWwx95dTaQ22ZyKdJho5OP7aDs9Y', 38, 1, '范雪松', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'LYCPR3aBxw3eNuwmnW7ho0lILRmFkSzy_1593924681', 1593924681, 1593924681, 'DtWBc5MnppZUZFpbYv6fQqRMvCwAN0Dv', '$2y$13$fOR2Gr5oV30cHOOgD5y0gONmm0HvLSGK.8x8Ll1sLcEtAzC6utBZ.', 'gpLeAo3DYpXKTOFlnmNT_92Gqe4NihAE_1593924681');
INSERT INTO `dd_member` VALUES (140, NULL, 1, 'oWwx95TWeSjQUpljC8z4SaCIj2rQ', 38, 1, '大孖', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'J4_xP17Dg6yX6Q0R0yxBvBHmTK7Ai5fB_1593924685', 1593924685, 1593924685, 'FNFTVP0HR66NWIyl5eB-jO9XsK3Xcohe', '$2y$13$NxpKewvWD1mUQVW8NnJri.HUCPDlVga6txr81RzN/TeVwi/stfycS', 'ZTbcGSETywfVOufpWh_wqEeAJauoNnQS_1593924685');
INSERT INTO `dd_member` VALUES (141, NULL, 1, 'oWwx95Qz2yTiAuNAYxjtmxsfpMGU', 38, 1, '窦炎超', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'eWpm26wORtbAX44T23pAwk0qUTIIvW72_1593924716', 1593924715, 1593924715, 'Z4oLr0d544jAo2hRMqbwVEySCtdt8ZQP', '$2y$13$QnjdQ8JrmbN0cbbBsOVNmukjDOwu1e.zpP/UxzSujVbafu1jI.WNS', 'VQFPQtjdMoozyb1X_GMMEH5oNyyZcYwk_1593924716');
INSERT INTO `dd_member` VALUES (142, NULL, 1, 'oWwx95Q5WcHD_segCtQaEy_VwasY', 38, 1, '肥飞哥', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'YEuEAyjEaVCnPU6ltpJ4FLv_lXyF8BpJ_1593924716', 1593924716, 1593924716, 'zTQKR9abOu7RsnjQZ4IEm6oRlHBwewAw', '$2y$13$cyX5Otl7U.ta2si2PT.5DObG9RRqETBojzeBiQ0w7Hwxk3TBbE6di', 'fLWc4Hl8mIKM3yCf9jD_PVmkJG3J-Yzd_1593924716');
INSERT INTO `dd_member` VALUES (143, NULL, 1, 'oWwx95edxLvOPPfmi0jIbrL6Vmyg', 38, 1, '斌', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'WV_ARCM7XL4efP_Y3BvAZfEEH53oo_7m_1593924736', 1593924736, 1593924736, 'MzJ9tDGhy-CfEl543bisv5cvsCbYseIY', '$2y$13$Wx2C7zKDQJbh2poKcbncBupCzoBNs3VgTRVOK35.SwHFzDkFHppDy', '9hTqc8WSMylCNpE74rm942lOGfN_ag0B_1593924736');
INSERT INTO `dd_member` VALUES (144, NULL, 1, 'oWwx95WVJAXEUdSAcWA0buS7qpms', 38, 1, '由零开始', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'r0x0vFxKSRry0k2q_BIyOycm4CYbVbOV_1593924752', 1593924752, 1593924752, 'wzw13BEDTWbVO8Dl--tr0Pw-0rBWJTNK', '$2y$13$jsJY5bxzPEuSuNClcpmvf.0EVAzaZPPCXNxsFT/x3ggDPAINORUOO', 'DF1tRqWjdsCN5EoRdJvxcb98AvM8WAy4_1593924752');
INSERT INTO `dd_member` VALUES (145, NULL, 1, 'oWwx95XDdiaLumnaAOQJ82ZukGZs', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Q7i18HDEyQ52LdU93nHYELkurYVWgU6C_1593924773', 1593924772, 1593924772, 'NFS3sS5PSzV9XkxtU42PZvx-Ohj7zwKb', '$2y$13$ZRN32FyJ3uROMACVIJz7FuHWrs2KiKcCt4MpsxPUmcNQKr.FBs9oy', 'atN6yxtrVD1P3nt0WTAeUO5NT6zYGllw_1593924773');
INSERT INTO `dd_member` VALUES (146, NULL, 1, 'oWwx95XDdiaLumnaAOQJ82ZukGZs', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'CPra3qGfz3kGW5gVnQ7bTbqyoVudiUw-_1593924778', 1593924777, 1593924777, 'OZj4P0ujWbSYkDPX7I23WFa1Wv0K7IeV', '$2y$13$OnGdTRF0Ip2xxm22V6L/nuD3vsZSAz8tBYieE1oHGvBRH8b0yi0am', '8dxr6VbYwJtgbGp4QfI5ihYpWv5Be5EU_1593924778');
INSERT INTO `dd_member` VALUES (147, NULL, 1, 'oWwx95VxvbMy0xOUO251AjVilZEA', 38, 1, 'kk', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'nu5eGAyF6bf-hJn-9x7Miy_syrJVBr3V_1593924797', 1593924797, 1593924797, 'L2UxZDhBelV0qxUJbAS0HtFkSvM1ZPt-', '$2y$13$UA3V7R16e.lw0onx1DeUrOukDRCanRCzvJlxheQI.56ZQGBQIUDFu', 'vdT8YgiPw5Z1lPestVX7LHGLua1EVUeV_1593924797');
INSERT INTO `dd_member` VALUES (148, NULL, 1, 'oWwx95S5AuK19yoRupdRJUuHB9U4', 38, 1, 'H_@o', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'E1u9CUF7PykCSMrJdBFpqqJljBU8c7xW_1593924806', 1593924805, 1593924805, 'aDGzLyUI6eAoygFUnsarTL-_HfUQaPaz', '$2y$13$1xf/QdRo/6VEaPFHlVOo.uyJ.NRdHIKUxUnbNs5J58CFeDnUDrTX.', 'ucHKmGiWi1EQmvsY3e_0zwUg3xW7vEKl_1593924806');
INSERT INTO `dd_member` VALUES (149, NULL, 1, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'yFhCXKys-HUH1ArfruQbFvWLVGyZ43IR_1593924837', 1593924837, 1593924837, 'STIkONZW4Hshe_N9kOgyhj6L4leoiWke', '$2y$13$skFcJXdhfIBQDQU2569xveIvpzBptPXyt8lZPvGfD0oNAongv0dHm', 'T5KumvRtKTST5uCBR5KZAnZKB5cQPShY_1593924837');
INSERT INTO `dd_member` VALUES (150, NULL, 1, 'oWwx95SduDaN_RjCtk9ZPKoPG3FQ', 38, 1, 'Dark', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'J7e6qlZoPbzBUHOu2TS2e-rvkHhukvP7_1593924843', 1593924842, 1593924842, 'mFD5xyc5N2D8TM60KAsmi4mJ340sLpt8', '$2y$13$4r1tBNVvJxee4h3PY9geqOWeBdw4EwnmpxBOtxydpjLgJCS6AdsgG', 'r772u9WskawByFXMyjjCUzyavStDHt4d_1593924843');
INSERT INTO `dd_member` VALUES (151, NULL, 1, 'oWwx95V8aF5EpCOmqcGdJPbZWTjE', 38, 1, '斧头', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'xO9A04ddHPHXSyH_gNS4lfS3EeDWHgVd_1593924843', 1593924842, 1593924842, 'CqyQnyuohE9gCGSnJRMGO1pAzVpovTHe', '$2y$13$g8CNtxWB4zy9mG1e.SDqV.JLGgs78aHuTk0bG1xJ909zpHTQaufuG', 'lu_m-ibAlVlwANEhzfhHvGZIZ5rXMVmb_1593924843');
INSERT INTO `dd_member` VALUES (152, NULL, 1, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'hBJY4Cnmzza1GHxcGWILpLYsPPQ8XZ1t_1593924844', 1593924843, 1593924843, 'kIH4mCgW7u0cnZ-CNy0RlXsfmOPgIgm5', '$2y$13$dpF3tZVE10pi5mydNfGmtu1Qk8wF1HGFSfc84D3Qkq57xw3Qsdd6i', '9BT7j3rJwSP1T6PWTnycdyCaDZTiXrAm_1593924844');
INSERT INTO `dd_member` VALUES (153, NULL, 1, 'oWwx95Y9tcFkHR1uJW-IxWfEFT9Q', 38, 1, '棛坑', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '-Xt_G44nrWuZQI0dj2eQSYV0uN1f2vWr_1593924846', 1593924846, 1593924846, 'y85xVYCdp3lqMehPDjlBj6kYATQ1zZfN', '$2y$13$ex9nbfvpXWL6ERzx9xOI7ufQ5YFtDSFDsGC138.lnHkuRjSD7gcI2', 'L8TY6pyZv1b7rVfTEfDTuhucv37mpQFw_1593924846');
INSERT INTO `dd_member` VALUES (154, NULL, 1, 'oWwx95Ry2FyqlBrMOz-Es_G4W5zQ', 38, 1, 'DDRetom', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'aHzvxBS_k2_EvSsp_VrE6N4AOeOlx6f5_1593924854', 1593924854, 1593924854, 'PFvOht1hybA6ylMaHQ0ti1gGL5tLBXdW', '$2y$13$Dq2Nm9YBsBbN2WY4B86MQOSCBMmdvdrJHzemckEbY/s58t85chY1W', '4UyxscpdVjXs5DGTxEJl-D5jM19rGvsb_1593924854');
INSERT INTO `dd_member` VALUES (155, NULL, 1, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'juvbGg6SRxjvOAk1SGk6j5qYy0PvUCAE_1593924857', 1593924857, 1593924857, 'RikgFk8__eshHgjWnd22nW0FsezPFHDb', '$2y$13$mTr3qrhPz4e0fIkQGmjPtOwKqKsEk5rcpHUl939Ti05/uJNjllk.K', 'ICjMfBe4Js1jkACX-lpR_m0BLalG8bpD_1593924857');
INSERT INTO `dd_member` VALUES (156, NULL, 1, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jF4qjz8YRNhprP-srjZkgRwMzMX86uj1_1593924863', 1593924863, 1593924863, '7u3jtWURf-B10D5JcMPogTvbpDB_Yeio', '$2y$13$/j0jcbArYUKGrNqbXkeSz.mU9mAi60lbi8f1uPvL2U98OH6e7xu12', 'pMWDx-1rnaRdNvLIEZOq4HLFQvwIpVyv_1593924863');
INSERT INTO `dd_member` VALUES (157, NULL, 1, 'oWwx95QkO8n-IvBWqKYrp_YitK_4', 38, 1, 'wh!Te_Su.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'TdQeGoUJO6oz3azuSyfxwPWSD1GJb9ul_1593924890', 1593924889, 1593924889, 'WL_D7JMb69WrQ-nFdUZ8yKIFbdu3Fpqw', '$2y$13$dNWJ/ZNaFbc4AvsCvciQR.UcESYb2/J7xblL4AdHtvlLLoS7fpI3W', 'nP1uceBbVg-LQve0LySlYvc3qbE3qf7g_1593924890');
INSERT INTO `dd_member` VALUES (158, NULL, 1, 'oWwx95TGg-GFTEBQ_3GIWLv6GjNA', 38, 1, '荔银肠粉+梁明祯', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'RevUHmgnY9ew2svqMf7SQX5kwkrv7ksk_1593924931', 1593924931, 1593924931, 'kYFIB_pAJ-CUhYM-FlT-pv3sU2TebKyd', '$2y$13$qvcgyQC1f/sLxeSkMNahgursYB26XuJgdGv8ow2tNYZLVwTWoA14m', 'J2MvrLvm3kuephzhp2z4pIqil1hD9XoP_1593924931');
INSERT INTO `dd_member` VALUES (159, NULL, 1, 'oWwx95TGg-GFTEBQ_3GIWLv6GjNA', 38, 1, '荔银肠粉+梁明祯', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'VQolRgaFf6glukHL-cmyBDEriQBDwgUC_1593924931', 1593924931, 1593924931, '6TRgDbijBv6HyzxlF-9HB9H-AO-qgYG5', '$2y$13$6gQhEH25Kf3LSqv81n2DGeHr55klhiwx63Rnc44M6xDpX6XlFgKGm', 'xI5qNWlMthufynubYNVYxAtUiypqina6_1593924931');
INSERT INTO `dd_member` VALUES (160, NULL, 1, 'oWwx95XCDzN44_VhWEDv2x99R_HY', 38, 1, '醬爆', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wSWXJDmOjG-quvUptNIeRMeAKR3_f_Pa_1593924939', 1593924938, 1593924938, 'rzT5rRZ7C0BzJnVAckIsgimDSmF4G-ze', '$2y$13$GzI8ymS0YJFfy21fFMZ0c.lBdg//QdGuMKn.iFEbxnpeTFKf6AKVC', '4XQeDNctnARULAVjcrEmt_kzEqjwDDYc_1593924939');
INSERT INTO `dd_member` VALUES (161, NULL, 1, 'oWwx95djPF6zaDB6MHSosC_fnd_I', 38, 1, '好想吃肉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'UKXIv6whuWzjt90czHvvRdD9vHmUTT8a_1593924965', 1593924964, 1593924964, 'gN1LLAlFze9qd_qzeciP3HPaBv8H6Ahq', '$2y$13$yvXUrydfjbtfWObF4nH7B.Us/PriR0OaZCt200bQlw.60DMcCi.By', 'zPw8iddk_9fNYSYEGhwxkppU8LyM96E6_1593924965');
INSERT INTO `dd_member` VALUES (162, NULL, 1, 'oWwx95Zre5iFBePGUNbIjlyjZkOo', 38, 1, '风再起时', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'FySmRDx6kTFKk91B_xjfSf2u7PBhydR-_1593924965', 1593924964, 1593924964, 'VDn94egABdjCngwGHdZydmt8Lp9LKKjK', '$2y$13$d1kPIgry3aDUe4lDDhck/uwNr6/DqwzND0rIQhCdZ/I910Zh/dptq', '2zz6PPrmlDAEze7A02-txQRe82DD8v2g_1593924965');
INSERT INTO `dd_member` VALUES (163, NULL, 1, 'oWwx95ckFuhBxc6xVxwsVubg43Ys', 38, 1, 'Crazy Zhang', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'BgjLraJD5L2ZZMfFOp3hYiNjRn2nxlNW_1593924974', 1593924974, 1593924974, 'HRaNflVjmYmxjVuJuEJPiue9bD5kXz5C', '$2y$13$LKKqYndnlj.MLEok7rqMzOZafkglMqlH9B7UtzPNvrFQ8Xu60HK2a', 'fWo5SGCP5rmh5mbZZerF5nsCMFmvATr-_1593924974');
INSERT INTO `dd_member` VALUES (164, NULL, 1, 'oWwx95U2iRF1zq_sxoxsUEeai-O0', 38, 1, '呵呵哈哈', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'TtlzQh1TRc483nHpZeuXVvRphaLCjHA__1593924980', 1593924979, 1593924979, 'F_CofFYZ5fhuRcbSG3wAgIaq0YsZqXun', '$2y$13$diPXZLnaOKW.10OxVrA3UO0X471/ghq0ilqexg0fQ8UBa9k8Zr8Lq', 'CPEWXszWh5egaEu0CtE4uXgHXRGVyjqb_1593924980');
INSERT INTO `dd_member` VALUES (165, NULL, 1, 'oWwx95QWly3AxrWJz6OO-NILYRxA', 38, 1, 'Chen Peidong', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'pNjyvkFzM0C1SD0lprsp4rgpugZ3qV3k_1593924985', 1593924984, 1593924984, 'TG0gcZZLpuK921xP7I-okPRGTAmoOy2z', '$2y$13$hMXLV1Tc2PCAh8cqRxigGexzjt6jT2DsOZa6A0NmQxd0rQWatQ9I6', 'VwRQaUIa6M6YrBzJ3BF8NoJ0R-x3cOjQ_1593924985');
INSERT INTO `dd_member` VALUES (166, NULL, 1, 'oWwx95Y94Ab3QmRWso-kbt4vjjrc', 38, 1, 'A.（致力音乐）大脸', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'VhX60gxyuAtascf6jXsC3z6OxPIg-avq_1593924996', 1593924996, 1593924996, '_Lz8YzKU4q269B8Z_OAY5IETkPOyhiaj', '$2y$13$WOaph275RmdLaUjUsf/aJuJgYMyZEQ63CfDkbisXIqxa5U9rFpkiy', '2iWQYDWnyzWr-sHobRXfBaitkf36FV6i_1593924996');
INSERT INTO `dd_member` VALUES (167, NULL, 1, 'oWwx95QyTAxbyRwDkxlhpZRjg1vA', 38, 1, 'Nikkou-旭', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '0phJLSpOI_TDgRedr_O46P67KBnmOcNN_1593925078', 1593925078, 1593925078, 'eEu3bxmMaOowY9wffQCANupvDnr1Rw5V', '$2y$13$66ObRoIjtc98.X1SwGLyNuDWZymj6ujWZSu5/Ap6KAislP9lxgEvm', '5EgvIAjk4DRvRCn0magmnm436d4T7oAQ_1593925078');
INSERT INTO `dd_member` VALUES (168, NULL, 1, 'oWwx95ZuB0BR_h3lZpDrbezXwqYY', 38, 1, 'Lion U', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3eHjnuGkrnGCT9jugf-B8-7xVIKwDzU1_1593925227', 1593925227, 1593925227, '2TaHDxKV6dvm4oL7l3v1E1qVELVfriXk', '$2y$13$tFU.XbwcKt/noAVQsrDJ8.xOZD7wAF1W2zpwo5cCwchMcBIMQPjW2', 'QviHb1b9gMiX3o6ve-DrmgqC2GUalJuM_1593925227');
INSERT INTO `dd_member` VALUES (169, NULL, 1, 'oWwx95S4nsCm_iYEVmxMlHWtQQZQ', 38, 1, 'A.俊(银行金融顾问)', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 't3zAS7H2hZ4PPdwcz5_IrpLEm5_bgvq4_1593925273', 1593925273, 1593925273, '0h7sAwpRq2OAHS2O7qSwFlmfONLQeD0E', '$2y$13$tZbOmR7gHZL0gsGFbTs2puo46YZB37CmXua7X2p0oXC4XZ3NPakca', '5WtUXtX33XHUexU4B9ReQxKq02XJIQMe_1593925273');
INSERT INTO `dd_member` VALUES (170, NULL, 1, 'oWwx95UsvEhFHFFqoE4cqnMsM19I', 38, 1, 'A冷清秋', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wyWOsc1li7j-87T8sDVRS68jIm4w6Yaj_1593925285', 1593925284, 1593925284, '7OuMN2xRLxVttyJcbhn13gFe4wBfrOa9', '$2y$13$UdKxabjkHaAPymoeyK0d2uk1eW6RVAIXaQRxW5/HHaWSNie8EgzlW', '3zvHAXPhfSoCZhsjvJcGJGq_hCyXb8Mv_1593925285');
INSERT INTO `dd_member` VALUES (171, NULL, 1, 'oWwx95Y2s9eg6mtgJrQJcEKHtUEA', 38, 1, 'wuuy', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'QVNqpxHHwBabpUqfsHgL_K0JXdUQf1UO_1593925315', 1593925314, 1593925314, '57BWt2wDL7EtYg1gsu5lqW_nf8Lic6Pw', '$2y$13$T74MEmg.OYPIbV/gnPJZ5uu2TG0C49s6TTCWUWsX.EA76KO4C36nC', 'DfTydp1BzPRJolTmaKM4v6s9tdMG7pNy_1593925315');
INSERT INTO `dd_member` VALUES (172, NULL, 1, 'oWwx95QDCP0kt2ZHVYc7vcAlHAtM', 38, 1, ' paul', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'CxAPueG4YE6dgXvo_XNeSNEo6vbrBaSJ_1593925324', 1593925324, 1593925324, 'Q8pZiqOlnnsg8iFZdBrmkDoQhMh1u9dV', '$2y$13$.9Ri1vtoNxpROsOMOf2tXuQ9UulP3QAm8Y/aFEPf5yVovUAwjAcZm', 'z_d_XBAGQwObWcVV0MNrU0oZknengeJ9_1593925324');
INSERT INTO `dd_member` VALUES (173, NULL, 1, 'oWwx95aCj6E43hOMr-BseW0J05d0', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DxIriMkliVtiDuzm8mHXRxRJ-G79wxJH_1593925327', 1593925327, 1593925327, '4PvjOyZWjuPbglVUkY_ynP0y-5kvzIj9', '$2y$13$bxVH/bvTo2HVy6YBrZtOcO/vmfvSVAH3cjuoYCxfFhgiG6hN1dIVi', 'G5rwXepaCNSHt_754ryeEJQUrYK6Ur0U_1593925327');
INSERT INTO `dd_member` VALUES (174, NULL, 1, 'oWwx95bvTUpC9A2LyW4iTItR5_8s', 38, 1, 'GZLSJ', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'aeLjQu-orgiyJ3xUa4l6bEdDlHWlNhlJ_1593925335', 1593925334, 1593925334, 'sjBUCbdV4Ss1KMxx-Lu-IuSJNjcvnLKS', '$2y$13$qXIJx3tuLRuke6QxSvGoDed6m4h7Tanka/sHR92w02Crqkk/Ka2uO', 'j_J6IbezFt4KUig0jed1Br6fmaALaMcQ_1593925335');
INSERT INTO `dd_member` VALUES (175, NULL, 1, 'oWwx95VMlgvDWg9mh6tJmyoSsmzU', 38, 1, 'z.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'SUMCtQGC29QbHuCc1IK-At-qGhCngof7_1593925341', 1593925341, 1593925341, 'RPRvIboJmy2S-h7843mEBJ-AuQ6vuUt_', '$2y$13$NZP/aJnAo4ziupbH2UlGyukSxXzsrspLF8o4Ea.2oX66kiNebS8Ge', 'xJqU1I_px2V9eIMovKSY4kgBJ8DIsfWb_1593925341');
INSERT INTO `dd_member` VALUES (176, NULL, 1, 'oWwx95cQRhxhiLkN8O7hytpfOSp0', 38, 1, 'Super Su', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ZMDiTzKePe1u0A76Zaj58xMs0rk-tU5v_1593925348', 1593925347, 1593925347, 'lUws0UhFW3XI3iC8BXoBh11JP3nEWmka', '$2y$13$JFFQYvirLR.iQDCavmsmY.3e.FP8BgNWxTuVrVQl68UlXBVIBfXBu', 'vNbAQ0jpPGdihl-McVZ24ql7vr-OHO-8_1593925348');
INSERT INTO `dd_member` VALUES (177, NULL, 1, 'oWwx95f2DepAi8gUw5gVw_GFu3qA', 38, 1, '孟慶樂.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'lZRA7BDtMr63jCyNt0R0HHVs9gyb9VUU_1593925389', 1593925389, 1593925389, 'uE4y4BWGhM9kc_kuyOHppf3O2LqQh6IH', '$2y$13$GZHQ0dZmULcJt53dI1SlqOZqkpfR3lG4jLyReV1zEelYsCkdNBWRG', 'brATJ7iaIZgdm_Mfpdpm0X3X56tCyQVF_1593925389');
INSERT INTO `dd_member` VALUES (178, NULL, 1, 'oWwx95TSUJxzWtDaZ9oy7JfUmukU', 38, 1, '广州穷二代', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3SklxToARokw5jTgVuCS3rz9Q_7qoRfr_1593925441', 1593925441, 1593925441, 'H3oD4eTtFqWEWhVmFQHG3rKqPyK9TcyN', '$2y$13$09AitNlFNhVSraw9iPMs3.O/kU6nvb2C4zlB3hLqR6jguFZUkZoG6', 'Q1z5EiUx12X6A1sx_NE-cLC4BE07tyUf_1593925441');
INSERT INTO `dd_member` VALUES (179, NULL, 1, 'oWwx95eNZTIrj4Djdw-xXLiFgtvM', 38, 1, '视角盛宴', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Hxl_KXCRX4iD85t9LCyP7fg_1_RzqkNq_1593925447', 1593925446, 1593925446, 'kv4YgTv2obAGi1A-dSQhYTBvJi7JmPkK', '$2y$13$VRieZuGs.x6zVhmEfTncyecHQzZDhKmX8VadlqFaqck97mpKyNkO2', 'Wb84meoFBHI57Mk74IrzBWjr0-n2eUyf_1593925447');
INSERT INTO `dd_member` VALUES (180, NULL, 1, 'oWwx95e0x1PTt5gKX7Js6O8BZTEA', 38, 1, '嘿，', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'KBJmAka6wKFHLptyeeVPh2M1EpMHbfX4_1593925598', 1593925598, 1593925598, 'C2s3LmIrEejqYV6Isaiti2nueaWFrDGw', '$2y$13$UmdUOZqQt8akJL.guK3yb./kS01WQ2.73mR0H5o0syLvBpXzLhMuC', '7doecdLGK8wJyl6rhSMSpf448H2c_jum_1593925598');
INSERT INTO `dd_member` VALUES (181, NULL, 1, 'oWwx95YzcjIW7jeega7eGcScvig4', 38, 1, '明-燈-大-师-兄', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3jYHTYYZXPOJ3OqT1VpXHZW0GYfrZlWw_1593925610', 1593925609, 1593925609, '6vNm0djN6EihBf1dk-7-2bbadsMrhcgY', '$2y$13$.WjWTLtR.wuI1xq8XJX8COejPixTUrb4SsdERScpSMuZsghaMfDgO', '8TBJwYU-uknuh7kiyMLHHflrl-zB0YHh_1593925610');
INSERT INTO `dd_member` VALUES (182, NULL, 1, 'oWwx95UijcxDtGSFHX579scd0dcc', 38, 1, 'yiuarmy.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'eqIMOpwewqifTqF9VBeVcBIC6pmliA1X_1593925683', 1593925683, 1593925683, '_f-W0vhvkK36CB82YE8mpfi2jx2_0igv', '$2y$13$OiNM4hKO44KNEFbhxsQafOa.0ka7PyLS8BDfHkjGOL/qYSsTD6BU.', 'sqQbYI8iHEqD3WI0aoaldJwovVUmxzMZ_1593925683');
INSERT INTO `dd_member` VALUES (183, NULL, 1, 'oWwx95f-dDV38tnYjw94CBJbgklA', 38, 1, '༄ེིོུཉ  俊  ཉ྄ིོུ༄', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'rSD9YW0P8fLTJpmLLzsCay-_eIFf7ct5_1593925684', 1593925684, 1593925684, 'HKDLGTPQuCyEqW4CLBDp-YlrgmMZZRYQ', '$2y$13$Z/8..KR94xmmoaDuiRAr7OeMJCX9dbavboPpdSV/34TUsyfYRjT3i', '_vg0s6Cd8yvBje4PV_GZpEFmY0GqU6I3_1593925684');
INSERT INTO `dd_member` VALUES (184, NULL, 1, 'oWwx95aCj6E43hOMr-BseW0J05d0', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Szk98JhIJB0xX_x8JtTT0qeml3x3zEpF_1593925715', 1593925715, 1593925715, 'BgbQHDhs2AK_ByLTi8WmUyyXATC4emmm', '$2y$13$LYfmzCOjyXXZm3GTgsI5Uuel5z5q9VdnXXlWrqW03QfdvhKWKFKwG', '8c2iMrWIYze2DYWQkW7uuBD_KYle14E__1593925715');
INSERT INTO `dd_member` VALUES (185, NULL, 1, 'oWwx95aCj6E43hOMr-BseW0J05d0', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '69RZIIhPFk4CnrNeJDrPB1TxFpD9B4gG_1593925719', 1593925719, 1593925719, 'EUP_dx5hl-rIqh5S0o90SofVkZiSF7tT', '$2y$13$RrYPl5fpWak9ZJzUOStAROtxcn9RGn07G4bOx7XihPvUD3Qtunr6a', 'WxgJZGov-bxLDai21_PrxMJoxO_l2NS-_1593925719');
INSERT INTO `dd_member` VALUES (186, NULL, 1, 'oWwx95aCj6E43hOMr-BseW0J05d0', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'x2MboRF8Gd8Snj7C03PSaXOY7wl800iL_1593925727', 1593925726, 1593925726, 'LNzJHKA3qrwirYr8MQ2NDe_7n3zyM4fW', '$2y$13$KMLxySMiC1cPb0MkI/fOFOiF9zuKfzZ/p5djGXpiV1lQxAXCsYfQm', '-xf1AxO8d0NrLWGCfTVglI8dJMxeFHt4_1593925727');
INSERT INTO `dd_member` VALUES (187, NULL, 1, 'oWwx95aCj6E43hOMr-BseW0J05d0', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7fDTKGu2VQKUL_kT5zMaeYYriCmNVKEj_1593925731', 1593925730, 1593925730, 'WiMwTiuAeKJ11sKmv_bXD9SBKjDSXpVL', '$2y$13$KJZGUYZxb02WglN8xxC/au6LSRVNU4cx/xCjt08xMg5zlKZl38JrK', 'UWjcCKbR-xRPEFyk1A6vm2Jamc9VlEpG_1593925731');
INSERT INTO `dd_member` VALUES (188, NULL, 1, 'oWwx95aCj6E43hOMr-BseW0J05d0', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DP0nu9fc1dzRuFh3N0IQ1M0APKWVvD2O_1593925736', 1593925735, 1593925735, 'pocZVRJxEqtYzlnHZusxeD4u60Y4GV3x', '$2y$13$FYqMyrK9ehP4fgSEmg4Dhej6V0Cp7eGcnJPC7thtiAJ37IKqg.Ale', 'f1MWUNh9IeAkwvEwsRM3SLXmgUtOXP_e_1593925736');
INSERT INTO `dd_member` VALUES (189, NULL, 1, 'oWwx95TfR-qsGHuIz88vYJ9e5WqY', 38, 1, 'seven', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DaaggVoabt9CS98O1U48-YKXFIziKOOP_1593925772', 1593925771, 1593925771, 'T10qRoXtntX4p2bie9-cHY4XnUScC-e8', '$2y$13$I9Z8JBb8Dj1P1Pj2QPRjlOIXBe4aII7RxmZV3z8Kg40RYKJ8wRcjG', 'Dz_jHPHhXx6i9mawJ5JhWHjnxcdOIEQH_1593925772');
INSERT INTO `dd_member` VALUES (190, NULL, 1, 'oWwx95UY-Cl9ihSEfkPzjDkAjffM', 38, 1, '卡卡', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '0mlui0LEXACqgTESzEy_CJKxMmkc7eUK_1593925793', 1593925792, 1593925792, 'mqpg75QiTuW0TmeUWgdj88RLVlvZ8_ge', '$2y$13$RzSBtHqS/2oMn2mmYzkfK.EtUrfIDeV6.XbGDTAJiNO5POKZCQt6.', 'YXFZQocHa8BEEjVkFTqEA9S41iyc54Pc_1593925793');
INSERT INTO `dd_member` VALUES (191, NULL, 1, 'oWwx95Qy1F5qdIOtIsXvsiJGTBuY', 38, 1, '公益骑士团百夫长', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Nf98WK5i8qMepqNhzENat34BgeoxHONR_1593925826', 1593925825, 1593925825, 'jICvAFSYHjgEHiACb7Xc9lj9NaZDozQA', '$2y$13$xCg6DqLD1yChp0eAmBmwyeZQga/85tGoo7grHO8tQMJWFLvv5P76G', 'WONusck_v3AYjq0NKd9V8_yQrGikBZTx_1593925826');
INSERT INTO `dd_member` VALUES (192, NULL, 1, 'oWwx95VbLCNULgox4bl5T2S34mK8', 38, 1, 'slitlee', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'FE7mvrUFvV8T-h0dnVeIY0udYBny-AuI_1593925842', 1593925842, 1593925842, '1opPEeJrcT_3h-we_ckoHab-bXuRZOdG', '$2y$13$S0lgwoV58ylQmMW1uAMMK.FRF7sFS6wUplDVRzTRj1r4Xsf2oPQNu', 'ocqDUf0g8BWmQaT11XJ4Q5GVQ1vqmUgd_1593925842');
INSERT INTO `dd_member` VALUES (193, NULL, 1, 'oWwx95V_v6Fbbaea1cIkq4-jo8Vk', 38, 1, '翔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_RMb1pgZobzohj9GJn_J0jij-iFKNU_L_1593925846', 1593925846, 1593925846, 'tIxo6SH4VDM9bLMZPXiqNyxOLn6biUgk', '$2y$13$LxiKJs3OinRBqBmObaeite6KOq0JHVVsHlt3daFGayYNBfLWS/SZa', 'Kg9HFFTb4ePmvrLdS5Hi7EJYTdcYL5Iw_1593925846');
INSERT INTO `dd_member` VALUES (194, NULL, 1, 'oWwx95VVMaTGDgfNPGz0cU81q2FM', 38, 1, 'M', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'diK_AFThPCHWh21-fpG5m0Ql68I22x-x_1593925859', 1593925858, 1593925858, 'Rv-pLfMED7SsVc_s8fnMC8yELcDOD37z', '$2y$13$S5ZTwLCR06O8cH6hN/qn7OE6LespHkhFC7hq3AfHLGOqsoiCG4Wnq', 'OMFNdvLYkVwupg2mWBrP8qEVtwy8cSyI_1593925859');
INSERT INTO `dd_member` VALUES (195, NULL, 1, 'oWwx95Zt1rTcul0x0mrCDru0GEt4', 38, 1, '城府', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'HqD_fzp2aNTOr7pypZRmBJrBlU1owOCB_1593925899', 1593925899, 1593925899, 'rgzNatJoZnSvNFHeGDA_0a0FqFAwKrU5', '$2y$13$YveK7X8EjLhSbbOl2KKeB.0eO1Ob7Bk76afgAjjAj9HCpQ1TDc7R2', '3lJwUb_h02cfoywfsDCln26GTDok6-Xz_1593925899');
INSERT INTO `dd_member` VALUES (196, NULL, 1, 'oWwx95Zt1rTcul0x0mrCDru0GEt4', 38, 1, '城府', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '65UA3wt_gcq-PjAI7b5anGyfY_ZeTF2C_1593925900', 1593925899, 1593925899, 'A1Km4YpGQymNeLkwk626ZZ13oKxVJHEm', '$2y$13$U5yrCP9w7mCbwe/w8tj78OH6A.Pi6SVNBrusJHwycz/z6S7iNsF7W', 'B6SQ0nA-h6VX-6WdKJiioQ4f-6kPqJCD_1593925900');
INSERT INTO `dd_member` VALUES (197, NULL, 1, 'oWwx95e4yoSFr0dQfIGLJJe-Cmng', 38, 1, '隔壁，，杜某人', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'tdOBihxK4F0uk_PippWv7llOewUOUDUH_1593925911', 1593925910, 1593925910, 'u731n8EVTZHBVtt0NBiaDvFoBrxUqjD3', '$2y$13$pnnXD369zpXkOadoL3VlW.rBOb.LACKSr/IkqvwSpCSYy9jFsELZ6', 'qIPXrSJBdE3aMQD8MixxDcNrqhLhJBQn_1593925911');
INSERT INTO `dd_member` VALUES (198, NULL, 1, 'oWwx95W3ahhl4_LqDDg3UyuoAvVM', 38, 1, '　⃢~⃢　 ࿐', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'nsECbvp9kKmQOAxbdHS4MOSXx9nBol5T_1593925914', 1593925913, 1593925913, 'ta1pqK-WH3zHiVBy7B4iV5lL3OVU2Q-i', '$2y$13$i0UbIM67qtOkUI7oNXN1MO1h8Et3tPyXig65kF7H6ti0fagMHlz7.', 'bYsjjuuCl_zeeAvJD6NntYtTXkLQ__qD_1593925914');
INSERT INTO `dd_member` VALUES (199, NULL, 1, 'oWwx95TbKBt5rJHzneqGTHygwStg', 38, 1, 'LIU', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ddoCK7yzw1-xEhDlwCzwdDwHiBgIa5WV_1593925916', 1593925916, 1593925916, '3kFmlJ-XmRoJqnc3bCECoC5eixRKX71z', '$2y$13$ecI1nb1E1CSEtORwDvK9meU90qrMmMRPcH.f2pwx8ogt8Y151ueVm', 'BZp9njWESHsv7PGvL0KZ30_mT5WPndLb_1593925916');
INSERT INTO `dd_member` VALUES (200, NULL, 1, 'oWwx95byto3vNcaFviGyyPWZ0Pms', 38, 1, '凤明天龙太子18680499668', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Sccj7m6PK9KK4Tcek3Ivq7dRmct4ApB7_1593925931', 1593925930, 1593925930, 'OymhcJ49Ty60Gj6UsDjeEtiKwu85FEwh', '$2y$13$g6Z8XPlYgc2fTtyixFUcBeaHSelYkvja3eitoRPLVySiNWBwtssHe', 'Pi2EA8pgZdqsy00PGFtMd_xmew6lnwfI_1593925931');
INSERT INTO `dd_member` VALUES (201, NULL, 1, 'oWwx95YTm1laTwozc4rB58ZWxPi0', 38, 1, 'Tony', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'tWfrvn1q6irt-jSEIXAIZGqKnkgaL013_1593925949', 1593925949, 1593925949, 'yL5Lt2ydZcXp01z6gaya5tQvMSoh5rqn', '$2y$13$l/D.v32ghsHya8/nLELCK.S/ZV8AjtnGwL/8vu7bd.Wj.S88M3MEW', 'PRlgYVbTCTu39VmA_4SrO3NERyjKSDph_1593925949');
INSERT INTO `dd_member` VALUES (202, NULL, 1, 'oWwx95axLoyVjgyzE85rFq6FbCzI', 38, 1, '艾伦', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'bAw879fbIDmgDXhw6X3b2VlzkZbUmHg9_1593925985', 1593925984, 1593925984, 'gvnaZ2gXlbtoxxx8fGTGtpGPea34cdqf', '$2y$13$YZo0n8K85i8CyNm5jgSJgezRbDZKFt1sha8f3ovjr2uLBHEoXfvPi', 'ER3jgabj48p07KSwOr6OrTCc9KE8eJQV_1593925985');
INSERT INTO `dd_member` VALUES (203, NULL, 1, 'oWwx95YDBWO594lcy6sMsX4Le4AE', 38, 1, '¡¿Rock_six', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'IcaqypQlqNyM3OqWax53JN4X-0Gaged-_1593925996', 1593925996, 1593925996, 'OnqYoKaSBEvsaDhCEWu4PDUJDD0iBy8U', '$2y$13$9ZXHm99HFmShfMr/hCOxseBXAxyoAwyIGYlqGUWAzH6cTeJPaRthK', 'xlLX2Jt6-jhL949VuHC8jX6IEy7uuheJ_1593925996');
INSERT INTO `dd_member` VALUES (204, NULL, 1, 'oWwx95QWrtLjsFQrSV0TYSUnSn5g', 38, 1, '麦克斯韦方程组', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'MS_RCW0wSe7NCGoiEKfUD9iC4jcyAy0h_1593926030', 1593926029, 1593926029, 'QONbkRouRg-m1aXsLzqQuSPmkFfuwd4b', '$2y$13$84y7SGltnpUEsnTpqOe2r.KqTA/5wQCFMPBJy7JUf3xnubAZgoxj2', 'lJLlKoZiEVIRz5gm362z2Z_8m8edmcri_1593926030');
INSERT INTO `dd_member` VALUES (205, NULL, 1, 'oWwx95e5IcPMLd_AZU68gsO1fSAc', 38, 1, '༺ 邋ж遢ж爞ད༻', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'QGVz5c5fDV88AQ-dyYOwWaveT_DXETE8_1593926031', 1593926030, 1593926030, 'Jawxrs0p_aEnkK-LLM6rD4ot3cpIWiAI', '$2y$13$XJrYkFDnwRc3BxKvvZXRtOAm2zCJaKQVJgKCXmJw6XkqJJI6iwWAa', '-Swk5m9f35rlxKsqSuP1XnxF8qrzpctK_1593926031');
INSERT INTO `dd_member` VALUES (206, NULL, 1, 'oWwx95WRPuhSsgnD2AOYjp34LPGw', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '5teqpsUWy2ny_aLNCSUsVp8W8hjYi4IG_1593926082', 1593926082, 1593926082, 'VPLGK0FNi43XecauOIefr2R6HZe4lFpA', '$2y$13$kFoaYP5yJ0M8p3evSF8/3.0s1mbztsfmZO3N/fy8q76sUMkaxyS2q', 'A9HyGz62aNKlDQpP4mSuEFw2PvS1I9PC_1593926082');
INSERT INTO `dd_member` VALUES (207, NULL, 1, 'oWwx95eavsf1OoO3kYyoJ8DImGtI', 38, 1, 'Laurence', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ErE0cYrxjpw9Z-YExF9rCnq87jmNinIz_1593926082', 1593926081, 1593926081, 'wFBb2h0lr7YGFVLxLghzzJ0xyyyYKYiT', '$2y$13$1lHKcr7CLoRsjyn3/aJQtuPY5jXXWdfCzjAcHTXN06DqLIW3TAD.i', 'dnleZyOWgaaka5qVYJrmJYg5YiKYcG9T_1593926082');
INSERT INTO `dd_member` VALUES (208, NULL, 1, 'oWwx95WRPuhSsgnD2AOYjp34LPGw', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'oJrS4VIGCqioxr8RsI3r50C3gLMt2i_X_1593926082', 1593926082, 1593926082, 'bbSlVysdk5J0RPx49r4xfDtdBfBUBuM-', '$2y$13$x56sPSeEqL0BVOYR3H6BXemxo6w9ZxBUiTfqll3CVvB7fpOx29Vz.', 'H_JAzhPvwwljOU2qVb5v7qKnwVnaz1eI_1593926082');
INSERT INTO `dd_member` VALUES (209, NULL, 1, 'oWwx95RZVdPoZEpTJmI6Lne3GRro', 38, 1, '良良仔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'L5eniOGK-2Z7CR8AiukhMcXEbWS5AmFL_1593926131', 1593926131, 1593926131, '_fPx4MWIds47AC3FBwaOywr7ZSVVP9h4', '$2y$13$GEfNznlMkijG/JFMX5snoup3kdn5.UlrXk6yhQ9odMltKlcCxmr2.', 'Gfsu23IDARAuMMYuu72W1UMsGSdVAhJg_1593926131');
INSERT INTO `dd_member` VALUES (210, NULL, 1, 'oWwx95bixQV8uqc8fVgcBm1M-SBs', 38, 1, '冯建业', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'hVKFLOUq38my8yZM6bgDWNvIn-oYw8ut_1593926139', 1593926138, 1593926138, '9p3FMZkg-DZO27P8lW5cTqkKFOxHAbS0', '$2y$13$Cq6MkYgsXGyWmA57BU1jlub0B54/fmLEa/2GRYGwpS20I0VRPbLVa', 'LTnyHCMqnrP0HpmPYTVNQZDtyF2l5MLu_1593926139');
INSERT INTO `dd_member` VALUES (211, NULL, 1, 'oWwx95YVXCrF8M-F-_AdkvYLJgWQ', 38, 1, '诚乐仔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'yih6LPYOhafvytnF7rODnha6MFsccjol_1593926159', 1593926159, 1593926159, '-DNHRecA6sFElmrpkKj2TDGNstuepyBv', '$2y$13$VlOdmjeUYK/6haJvnhn52.s8VuEcB0c2UzvInMOJ8snPAf6HOF2I2', 'Wr1moheWfnHncB3bx3-FEzjljzZlONn7_1593926159');
INSERT INTO `dd_member` VALUES (212, NULL, 1, 'oWwx95ULt2z2QrRGqApirsNpmLTI', 38, 1, 'Always KeviN', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ubteXshoBYGbbeNZyyLX-AvsCQvcn_Ao_1593926213', 1593926213, 1593926213, 'e8qX346Nh-ltAwukeoKbRPen5HFWZnvK', '$2y$13$3JgIZiz/xZKEkhWjVquWcONoxOykgly4t9g11kJia9h.x1N4Xpwcu', '5miFio9zYTMfybnBI23HkUZjj5X6dL8B_1593926213');
INSERT INTO `dd_member` VALUES (213, NULL, 1, 'oWwx95TtDfgIzTsZDKnvQLAV-g88', 38, 1, 'Rocket.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'G4xQchypBpBG_sXtwA9T2R131TN1QBnm_1593926221', 1593926221, 1593926221, 'CPqlz2uoNIYt1L4rqBnL2X2hOEGG3zGl', '$2y$13$1NhTyXNA5g9ZW1rXneq5BOv4DPaJKqkpvNoBIhu7cPYBnqFfFs/GK', 'DfZ_FVYQfx3Q5eduZ-JUhktb3286ZzEE_1593926221');
INSERT INTO `dd_member` VALUES (214, NULL, 1, 'oWwx95TmP4ERRjoWIh4V2dodZGSQ', 38, 1, '晴天', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ZtXNZrcRhGSjKT1OuHNZ6WBVozZPHB2B_1593926265', 1593926265, 1593926265, '_TCyenT_7SveC6pQZwgMriLZ_nsUtdR4', '$2y$13$9kEtikjp7Gg.FhbFjgpc1.efhIuhI/FIPRZG.m3xokRVLYuupLfZ2', 'R450M9XH4_PcQ3Y_4_Rdbu2s1xZ-Xws0_1593926265');
INSERT INTO `dd_member` VALUES (215, NULL, 1, 'oWwx95dBxU7TNfoT7HWzpWgzAILk', 38, 1, 'Ye   Zhi.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7lesKOD05r3QoelEzxOPBJifVPHjyCoQ_1593926330', 1593926329, 1593926329, '_JPwR0MR-4M3S_M5E_JXhxvWEoz1zcVJ', '$2y$13$YlIXuKdAkN1CVr3RSoEzw.VY81j/e8Ml7FogRFszKcPJIYfQIRs/2', 'gg3XSb3I9FZyiwx-2jSsFOBfJc2pMl66_1593926330');
INSERT INTO `dd_member` VALUES (216, NULL, 1, 'oWwx95cHXNj_-joRvyvVTHUD7QX8', 38, 1, 'LaugHing＾', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'kChG3vAj8PYbOnsOwJq0DXLG0RIFeIBG_1593926383', 1593926382, 1593926382, 'mAIZmWq0YY1b3h2lSE0Q-vT25x93X3s0', '$2y$13$NrvN/vqbVpOty15u31COY.ok4XAoqUJ8TklQvxxL1l0PkJDKTUZdm', '4hw78f88wf7MptiKvM96ABGfccOmVe-__1593926383');
INSERT INTO `dd_member` VALUES (217, NULL, 1, 'oWwx95cHXNj_-joRvyvVTHUD7QX8', 38, 1, 'LaugHing＾', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'IsjDvQBjT-V1azBbjmZPf1siY9Em-iGE_1593926383', 1593926382, 1593926382, '5qLjIZpUtWQNnM0CbWPbIlSY1kZP9HP4', '$2y$13$mSG5UoheNcWPZ4mXg4tA7eMpRZd/DzBiyQug4YKSiGD9tONDhYPm2', 'D8q8KIbTt4ygFPAUsVv31wqaSFnUpwbD_1593926383');
INSERT INTO `dd_member` VALUES (218, NULL, 1, 'oWwx95SZoJ5p3HWagGVcFljWbUSM', 38, 1, '许 .', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'vnakxBiUpJUTMN7ftuVHer8ubSUDyA-c_1593926470', 1593926470, 1593926470, 'pQGUVHDfj8QeiR8j8YDsuyqbWwK1Som_', '$2y$13$0km3jb0lMpU9yjumSxydiuOS3p9L.pJDOPJcNEfs7jC8ItoWj7ecK', 'pYn5y7CjUT-oCNxorJHNE2tSQnnqUz5e_1593926470');
INSERT INTO `dd_member` VALUES (219, NULL, 1, 'oWwx95Y4Ymfrb5L_gsNKjd8ayn9c', 38, 1, '鲍泽云', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '0NfnMzx0T_JGGAnkE7q1hHEsv_Wic4A9_1593926531', 1593926531, 1593926531, 'c0fepIq8hxM1eegvPcIequKTFDcA7WWu', '$2y$13$9sEaVqHKvjB/r/egGmV8ruf5hU4kX7b6v.ntPDb717JbwtKEZX2l6', 'Z7_3P8AKiOwT1BQKaGBebukyR7_IeOo7_1593926531');
INSERT INTO `dd_member` VALUES (220, NULL, 1, 'oWwx95VhSyj47r5z8NuotoTs67jE', 38, 1, '清风随月', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'PzM92MHsb1gr20rG7wkts0GWgxH_3650_1593926591', 1593926590, 1593926590, 'b8lqqb8HCqalQkotZ3tEsr9oOyOl06TO', '$2y$13$7eE4XoNrOcQxJLIsvic0/uVixKTg/iBjRD3AzkRXBz9CFZxmP9cte', 'D4OxhDMq-qfQO78xlXXo_PBh-1WtA8Uz_1593926591');
INSERT INTO `dd_member` VALUES (221, NULL, 1, 'oWwx95d-De2nYQgBwIMxuu2NUh2U', 38, 1, 'L', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'LxNNboL3nCSLmI5Fem8a4Bc9sM0IrtEL_1593926592', 1593926592, 1593926592, 'G9weaCQIoK4u-hVU5ZmabyJRwvXhJvee', '$2y$13$nf.0XRP4LOkEKAciRcYgb.Hrm189aH7Mh0z4TvWq8ClZWQVXkmlKi', 'e3tm6tbFMo6YrZ46GkrcJ3d_UphWTi8g_1593926592');
INSERT INTO `dd_member` VALUES (222, NULL, 1, 'oWwx95ef3fQA5r1W2W7f-EJykh6U', 38, 1, '', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '9P-bAY7OQCRN3PU5yBa2XefMWp47XKGD_1593926634', 1593926634, 1593926634, 'JWif4YPtl596Fcef4_NJB7Iqsmn4GUif', '$2y$13$4DOOGExTAnsATWM0zlZ2XO1EggoRlCp10O3Ai0A/c.AMJ7kPh0bPS', 'yGw33TKuuISasS7LhBW2k-Jg9pQY17ZN_1593926634');
INSERT INTO `dd_member` VALUES (223, NULL, 1, 'oWwx95WxbirLThUUqtYP2FbOQK5I', 38, 1, 'A原广发 七彩孔雀 尚感恩 中茶雨林', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_s6iOxcgerJNZ5RTXgVASppkSmQJ8185_1593926637', 1593926636, 1593926636, 'ZxplQao8RpKXFr4ohMo7MED25gPN2ub3', '$2y$13$fzIxHqsSl5SEzBBrGeiphusFS.w85YaD2PLgrdZ6t3isWYV/fsJdy', 'JpiM9iknyaF5TUFzUcRaVLfabXA0_nki_1593926637');
INSERT INTO `dd_member` VALUES (224, NULL, 1, 'oWwx95e9Jt8ojP9datgBk9HIt-DQ', 38, 1, '几页', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'CRajdqMIf6UDiE5Lt9KvnJ8YZ5NM3GA8_1593926679', 1593926679, 1593926679, 'I8EJ0AfQsEC7Z_QGOtUAhdcECs9xrh3x', '$2y$13$v/mjPvmUbYpyWA3Oi0PTLeCKhlDgHMN9SwyLBGZbWq06n8p1RmjMi', 's39H1Nwrzj3yocfoO2wIn3fLFQq7jrRG_1593926679');
INSERT INTO `dd_member` VALUES (225, NULL, 1, 'oWwx95Ymodlx89WvLjuynyb-aJzc', 38, 1, '余情别恋', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wLb8j1CGtB6Hz-EgJH9-bsuayzbyy6aG_1593926905', 1593926904, 1593926904, 'I1k3KMqCPQOx_MYX_vA_Nm2Yn7DlQW5i', '$2y$13$TzjDbljCm1TwVvsdJrcyTOPy.zRc4mvZ/Yo3KLE9DTdsP2ckPWzoO', '2gq2WaeX7kzJpW85BryfZb6hsBIoZo7s_1593926905');
INSERT INTO `dd_member` VALUES (226, NULL, 1, 'oWwx95bKhxQBTIRsID2wGbS1KUVo', 38, 1, '天照', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'lYRpkujtd6CEefylWF4Ly_sn7NBqFq-U_1593926905', 1593926904, 1593926904, 'l-SLUaRypmjQHWE515kYYM3AGxBCxx_I', '$2y$13$iR5Deh1OG5vqUv1MVfaZKe3/4U1rKXWaNSpgvhh0qikKmQuDier2m', 'TYFVcYLYdupgQLrTbHjl5o6Cqmo--8WX_1593926905');
INSERT INTO `dd_member` VALUES (227, NULL, 1, 'oWwx95TPPv-Cl0qB5wcfxYnE8rto', 38, 1, '志飞', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'BUOwVdTQpAuViTrwXx_BWfUWBm24m2L4_1593926941', 1593926941, 1593926941, 'gdPj4j2k95FGs_pH-zk6Qy39qrXBdJSc', '$2y$13$a8qzelXsE8P5LYmK2rgYHe3fQPWhJ46KUhyZMFGFkxMA1RlNnaUG6', 'unLKk938qafyfA1O07V8Qsjt1ym8X-Jr_1593926941');
INSERT INTO `dd_member` VALUES (228, NULL, 1, 'oWwx95fLgyy6EK74ur-WyItiSS5Q', 38, 1, '永不放弃', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'JweQmItUzdcEkzwZqvqlSZFuDhTE9uYC_1593926988', 1593926987, 1593926987, 'DXpf1uS0ureXexlpEV1S3Z59Lh6u5pnu', '$2y$13$A.BEHBgTeKMxCtWKOExoLOiugBFW8kTuzH5mOTxXPl/8xVrzbSVqq', 'VZdIJnr4cpXuVThwXxSSau6-do3x2UFs_1593926988');
INSERT INTO `dd_member` VALUES (229, NULL, 1, 'oWwx95fLgyy6EK74ur-WyItiSS5Q', 38, 1, '永不放弃', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'lceJOWc4eiEXj0pPDSIIgzjokWzBuTXJ_1593926988', 1593926988, 1593926988, 'f7ImNq3eIrstr8J37uf84_ExnVJqGpNc', '$2y$13$S1UJnPAL3r8lBmy2x23/ZOf2F7XJNM4U5W2YzDQWlYvWzvddUx2j6', 'jE5aTCLUTEtEtg6r120iBsr3uTMAs1Mt_1593926988');
INSERT INTO `dd_member` VALUES (230, NULL, 1, 'oWwx95ZmgNYwntJFN1KHrWadVwxU', 38, 1, '爱晨之心/:lvu ', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Hp70uoQqv77512pIbltSOX_hT_IKJQos_1593927010', 1593927009, 1593927009, '1IMys2Cum-8uBjRYCFEBJU4uafrAX3H_', '$2y$13$rceFKvBybnh8psHob3fPSOjnobqy8KlC6YKYa52jNQavzeoOmOft2', 'TCqDcwEB54cmpNfo8J5916Ri2rqcxV4o_1593927010');
INSERT INTO `dd_member` VALUES (231, NULL, 1, 'oWwx95ey6ucWwxAvo-dnWor0BSiY', 38, 1, '自由散人', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'dkn7buIfezThHQ69bLNC3ErLY0cBfl8h_1593927031', 1593927031, 1593927031, 'tn4S7yQej0HxUqXrw5M2OOkpPGxhR4oH', '$2y$13$AYf.TnNah0U3SejWCaHwIeLIcsGMRiSNp2dm93mgEuXxO1QkItKti', '49oAPwUXlfYdEbLFl8Z3F5gJR1BSPE2-_1593927031');
INSERT INTO `dd_member` VALUES (232, NULL, 1, 'oWwx95aMY7rZF9HpDvLa6n-_6l0w', 38, 1, '油条', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'iTAdTQNgDwHYistykgebYmhqpH7aBWd5_1593927095', 1593927095, 1593927095, 'cF1n3SCgtQ18JSrbdv57xWLDIW2PmcCm', '$2y$13$BEtQy3JuJg5riqK8HI05vOXSZpWT/Ecvql9uozM40IQ7qVLbPHAAO', 'd60spSXGSVsWaMbar7adVoxvCrawM91k_1593927095');
INSERT INTO `dd_member` VALUES (233, NULL, 1, 'oWwx95SnS9zAdYxp0bZeKYyCLEUI', 38, 1, 'Beaя', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'dOV06I2WGdTHS6veANBHE2uu1UX39Q2W_1593927142', 1593927141, 1593927141, '5Yg_SxvtEXq5T8t3VWGqCQNW8ZrjRXrK', '$2y$13$3JMT.dpXSJdtHOBj9OSsQO7v/hPqJQRCNzKmUl..3ApWHJT05oFSK', 'n9WasrAv_SC4x7dpF_Qdt5M-TGjqYIJT_1593927142');
INSERT INTO `dd_member` VALUES (234, NULL, 1, 'oWwx95V5jFdHyKg_LyrWo5XRj2cs', 38, 1, '啊武', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'E3yMpzHb6ukFiey4btiKqeCHK6cho9Kp_1593927180', 1593927179, 1593927179, 'jgUuyKjFm23vgmO-fvf3rCy0GgrEpwTx', '$2y$13$I33oxYvfxQQZ1.JXzAC1Mu966cCGBQD384M2pBPXie34rJPY.mj8K', 'ckQjXiuv06ob-E2KGNqU-fwLg0T4zDey_1593927180');
INSERT INTO `dd_member` VALUES (235, NULL, 1, 'oWwx95aDYuXrPE7yggYg9dN_rFjc', 38, 1, '小黄蕉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'gew6kruWzT_do7chLqWineFaFJDHZ1HJ_1593927187', 1593927187, 1593927187, 'nNOFisRW0CqBKlGbwk5x_Pu1px5ITV4-', '$2y$13$Iu.KRaG0PNwYHZwg4lgBm.dvumGjMGu1qZNOKb.BC6VGV0NuDRQJa', 'z3DV_fYlkvuDghPy_7DxKu41eHtWvM4y_1593927187');
INSERT INTO `dd_member` VALUES (236, NULL, 1, 'oWwx95UjWN_WvAhU1zfwA114nFSA', 38, 1, '天道酬勤', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Hk1XE4GIbN6oLi5WoVixsVyFE8MjTNyx_1593927189', 1593927188, 1593927188, 'OjDF2S5K2DJFlooVvSb6eP3h3uTTW3va', '$2y$13$bEVibX9pI6ik/.HKg71rD.R3y8CX47eJ5268W31J253V40ZqNtBdu', 'fhOCvjYvm1jhanaqmcAc56C5z0TxCJqi_1593927189');
INSERT INTO `dd_member` VALUES (237, NULL, 1, 'oWwx95aoO7jiK75EBI2VI3Su2S08', 38, 1, 'strive_28', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3zgNeh3p4SPG4Z5pI_aEosHX1ZGKq5r9_1593927247', 1593927247, 1593927247, 'KsAxROP9DbBG9nqSkY6i-W0hVCzx1dOg', '$2y$13$13Dylf.alXHLpyaVYGBLYez04r1XUU.J95Oik1CU4V0PvXIyfXRkK', 'EscFRuPRl-AJNFBmbnmNT1ouRScOl46v_1593927247');
INSERT INTO `dd_member` VALUES (238, NULL, 1, 'oWwx95QjJvCVR8s7QGvukjrWIjPM', 38, 1, '因为青春，', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'vsP6PYEqajhzg3Aggm-GXpSFKf_Roo39_1593927249', 1593927249, 1593927249, 'zKljFy16LREHmN9NSwbfht4UJyuHyDxR', '$2y$13$I1fVRC7keS5icg.iEytwFeRn3Kcgb9wPv.wVz0vcLB5807hvKsUsS', '9urUG9YjJvQ_8idFANVs9I5L-OsHAwR3_1593927249');
INSERT INTO `dd_member` VALUES (239, NULL, 1, 'oWwx95R2d3oqDnUNg7BumRwaVkeI', 38, 1, 'kevin', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'zKNCdyezkqegV2bHq3qQm5Omw36jffhQ_1593927344', 1593927343, 1593927343, 'LAC9dj4oEr4ixHAYNYik8pevTz-wC55r', '$2y$13$OZ9VMat2r.1idqhmM5AxI..f8zBZrgCyNRhdVJg9ah1SSRZ0sqwRO', '0jMcaxdQbJOiJp5FGQUCwopVr6xUUE3Y_1593927344');
INSERT INTO `dd_member` VALUES (240, NULL, 1, 'oWwx95for5NPYLBtGJicSDhUMbT8', 38, 1, 'Anla、熊哥哥哥哥哥', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'UFvKKf4fBNh-hIlBktxqeTlWOb3K-iin_1593927344', 1593927344, 1593927344, 'froqOFnc_SI2CNRCY_OA-H9AtQrhlS8Y', '$2y$13$ryqkWD3mEMK0h9t08fOzpuDGwpPwbANOQIydEG6KydGFJzQmzzejm', 'Iu-X7nmYZj5xHgTRkaKCFMJMj3u99BmZ_1593927344');
INSERT INTO `dd_member` VALUES (241, NULL, 1, 'oWwx95VUOs6R6Qz_bQvKVgVy0EWU', 38, 1, '晨风', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'RXcztlHARmBCJ2i3G-w8WGxbnjqy8L3W_1593927360', 1593927359, 1593927359, 'mws7WFkdf4FNGmG_Eb1XCSBCWo9VuB9g', '$2y$13$b8p9/7H39.scegJafiSYGejFa3KGBroTRcXlFUAfABtJQQcsYf9JG', '_gAhsL10emMvK8fD0JL199ddzCTDj4zl_1593927360');
INSERT INTO `dd_member` VALUES (242, NULL, 1, 'oWwx95bxrJGORmlUa4VDLsVwh1mk', 38, 1, '刘桂添', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '6JspyOBCwnl_go98e9uS6f9DbZ440ZGH_1593927368', 1593927367, 1593927367, 'xQIM5QsxLY6ODTIEE5N9y5sZEdplIIh7', '$2y$13$p4.ZuJUyP1dUja8eyhRX4uHqqVbN4jbgG66BIGYpHjnbRE2OB.4fy', 'jvWC3yE2XwdBkVpoYyJCAHAerfzpqzKX_1593927368');
INSERT INTO `dd_member` VALUES (243, NULL, 1, 'oWwx95ch-K97IPbDS6RxmotlqbPU', 38, 1, 'Hika\'s color -RUIGE', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'W5CSJL-pUiijV_qpHkeuGl30gKFjJxYh_1593927415', 1593927415, 1593927415, 'AOmdmvrYEgVVH5aUhO8v3i-57Ax0ru3e', '$2y$13$KnKNwK61w7m/UoTmw0OicuXVfhpLWYBVzgk4E9kAlNyrCZCLjQepy', 'JVMvfgL8zGk2s62B8t6jTULe47CzR3Q5_1593927415');
INSERT INTO `dd_member` VALUES (244, NULL, 1, 'oWwx95UmgMIBXmshRaaN2frIkOvI', 38, 1, 'Donut', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'cPEN6t_Lo24jg5uCce0E64mhuQJKYg_e_1593927422', 1593927421, 1593927421, 'LigQYvsK6Y0_peMTiakabJ2nTJplJPRr', '$2y$13$5C7PR0Bd74ptIQO0jH2wyexPS7C9ZfUUroOUpJCrX8KoPtXiqdW/u', '2cRfqgpiQKi5S78A4jAOpBB0MXeda_Xz_1593927422');
INSERT INTO `dd_member` VALUES (245, NULL, 1, 'oWwx95b1DaKyZ6TkkeFZO2ls0GYY', 38, 1, 'captain kush.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'eo5X4MDoRH0NZXXDd2yYGB3vaNIqdE0s_1593927437', 1593927437, 1593927437, 'apK1gvAqc03PtpQv23189fBfK2PorYP3', '$2y$13$dPZqifsvNywrPLHbvoOcm.XXHM64E0SOZJ8vR1lbnirBzRWGqCCdO', 'RdNiTlSeQDQ_Vp6dK4haed76k5_vYgyj_1593927437');
INSERT INTO `dd_member` VALUES (246, NULL, 1, 'oWwx95S7epuP9FZyjL7mKYEk5SMw', 38, 1, '无念。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '11doa2SOZTZlA2sOiENnALDkZwIszewt_1593927561', 1593927560, 1593927560, 'gditAmQM6_cNv1ujJNu5uxQJvUkT-ImP', '$2y$13$sP/s/opg6KE/Avxp4TARrOdOCIaMRE8B2CtUqMZmhLgbl8dIrq12y', 'SVI5hPApYQ0tBNT48DwCxJQooIA-JzrG_1593927561');
INSERT INTO `dd_member` VALUES (247, NULL, 1, 'oWwx95Xyn5NSHoM5aNKrMCd60A00', 38, 1, '明哥仔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'gUjHdvVvfNV018u45vIF3p5LkKh5kpWD_1593927661', 1593927661, 1593927661, 'bfJliG5785wRLVv8cltDdInb_Qragxwc', '$2y$13$ZBa1szELrAl6DQnoqy1/L.qyexd73fxt9y91ZHZ4asF3xYWPFyzJi', 'JUuTAmYzcwekf-rovValRFIAWmSWJml7_1593927661');
INSERT INTO `dd_member` VALUES (248, NULL, 1, 'oWwx95WCjKDXyoTMw77MRRmthCZc', 38, 1, '何楚毅', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'hGVCQW84S0D5Yr1oMendmNDwVfRQs1RK_1593927663', 1593927662, 1593927662, 'WJDLa4-dkVp6tA3M1iXAQMkNJJs74OnQ', '$2y$13$f8dXoPpiHM1zqXoG2Rz7NOcGcwEWJu47jGLqTWxiJTBogDexc/7yG', 'kM3QwNweN2XRwjOzka1aabgGZvZDTmyv_1593927663');
INSERT INTO `dd_member` VALUES (249, NULL, 1, 'oWwx95XRnbiom_x151uU7Ro2v-84', 38, 1, 'Tim18665771303', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'SVeUkTAxrFwNQHua8UHoQpJDI2UaP3ez_1593927757', 1593927757, 1593927757, 'wckINSz5qwT7Fp4trimkoGrmyHfivTvv', '$2y$13$6giZzWTFH3aG.L2l8moCMO5pKk.sjzGFYcAD2MnyQqAijhAGy.f0W', 'MdxFAPgJnCcLFP2sZoDMRsdoEyOko6o6_1593927757');
INSERT INTO `dd_member` VALUES (250, NULL, 1, 'oWwx95U2Xvrpb8qiy8UYITC_zpVE', 38, 1, 'Alone', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'EXJBNABd3SheJ-QL7FmtANscfr3cUO6Y_1593927766', 1593927765, 1593927765, 'eAD0hFmb6j5JF-bEZPiO_qtSDtrXJzGu', '$2y$13$1k0MjfllRxyn4u8ScPTFnOGaZpgps9mWCLm2mcOScR81e8lQkT/Jm', 'HkrzL6_4l9p7Rq0DMdTgVouu0ClADpc0_1593927766');
INSERT INTO `dd_member` VALUES (251, NULL, 1, 'oWwx95UQrR6U47VQ9VAYRl51uxUQ', 38, 1, '晨曦', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '8ipNY-g2nIIVtwzIVKrcp_Ti-70auq6b_1593927828', 1593927827, 1593927827, 'Atou_H0u1xItLyedAwRl9ayJ5qebmzJr', '$2y$13$59cn087ODC4ACc36PDJ6ee/NgusGvujOMRQfpHURYwvtO0NWs33L.', 'eC2jW3GGbaN00sSsseBkp3FnQu37jeQx_1593927828');
INSERT INTO `dd_member` VALUES (252, NULL, 1, 'oWwx95UQrR6U47VQ9VAYRl51uxUQ', 38, 1, '晨曦', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'XgasR0Rw23CfyCQaKVajZZYF1X0wzo7__1593927828', 1593927828, 1593927828, 'T46Vrrf2QUUqjZBdOzzXaCAP17ERJRzx', '$2y$13$wLe78hAmZnSRqGWvuqVIwO27MaKu8SeIzU/OamJCo.hTiDMmlrDiq', '1k-9PG2BlSVOy1iN6i6xRCw72oGUPyc4_1593927828');
INSERT INTO `dd_member` VALUES (253, NULL, 1, 'oWwx95fxfsM7plNBLno82HIXKdy0', 38, 1, '吖聪cong', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'h895mH79qkBQrPBWTdnuztKTx2jNJdps_1593927932', 1593927932, 1593927932, '1exj-NKClxSn6D-kRt0vlmSd6Lsr9pXz', '$2y$13$ay/TsLm0rwynRxq.i50mwunhITDhDlT278pLSro.gaP7h50k9Lkyu', 'T3wchPlx3AsEZ7QpSv5PgdsO-w4BN5Lq_1593927932');
INSERT INTO `dd_member` VALUES (254, NULL, 1, 'oWwx95bAKEF_GKY0JKwD1iADtgu0', 38, 1, '佐治', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_GFWYY5AsFn93lqYzS6nIRlX0CO4kXBH_1593928050', 1593928050, 1593928050, 'Udd-RFGIHE8On6hXaAI_PQoEBTCyJdbd', '$2y$13$khwTP2UBeRveMc8RbmXChOrhqZnb7aAZlQeOCpZ.jJwHsfnY8Nyzy', 'M0W7t6Bf0Rko9EE7iK9NV2I4kMylzfm2_1593928050');
INSERT INTO `dd_member` VALUES (255, NULL, 1, 'oWwx95feH3vHeht0pvbwHPFOjdp4', 38, 1, 'hUanG伟Wen', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'P3diTLPWYjhKgRVy8LEzmfEoXIV2NmPD_1593928146', 1593928145, 1593928145, 'M9OuBUqTzNzM9oDw_raaucwxitFextfV', '$2y$13$ki24C8kq1KSHfmsIFIkpL.W7CRGf9NUSyOZ3e7KAcB4bfIU7izSN2', '03ZYG09GXGOHDAvATNl2hWP0uE6Rxy8V_1593928146');
INSERT INTO `dd_member` VALUES (256, NULL, 1, 'oWwx95ZipdChJ-PYiVyt7B517rlc', 38, 1, '悟空', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '0sZxBwKI5Ap-kQlMdFDj_VVWJ03SlYzj_1593928157', 1593928157, 1593928157, 'Tb7ockMaeTOhT2OErp-mHiRSy83-BjZv', '$2y$13$2FLvdjxiw7bXoUGuAzbhI.o7GR74OrN4trdRgwMUkgbOXnV7iW0Li', 'QXPGE9USFIPSK-puvH0_CrmWSQLktuL-_1593928157');
INSERT INTO `dd_member` VALUES (257, NULL, 1, 'oWwx95TDWkjoZN7P7_bm6aWRK7_0', 38, 1, '如是', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'TRgE_bBrs_iTVkfBy13YDYeZApNe97-C_1593928283', 1593928283, 1593928283, 'tSzrjH9FZjYjbmMsSFJJ-yKPUKd1Rx9h', '$2y$13$oDW0skvF9ZUpw4vNX.Da7OkSkipMgwfINWGSuXQ9PpzQ.oj38hkj2', 'dbT7tJTo6xMt5Rzi6LjJutuQKmk4-ks4_1593928283');
INSERT INTO `dd_member` VALUES (258, NULL, 1, 'oWwx95Y_b-lF1yCBLsimrltQIH-U', 38, 1, '陈开星', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '5x8tCCVohulptMGm3stf_9ce_V2V--CZ_1593928412', 1593928412, 1593928412, 'eQElXNPGKsXh8c_t__UUmywk9hVmorXi', '$2y$13$e2WJMVQY2aQTc3JWrcMPA.T.zu6lzRojX7pemwlnlnkVpLq8/7dFK', 'z0bt5jDoa9Bh0m4NpG1GyWHQVhXt6sK3_1593928412');
INSERT INTO `dd_member` VALUES (259, NULL, 1, 'oWwx95RA-j0ZWWHPdE8b_24SOLDc', 38, 1, 'HJRONG', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'LpW30RcF3pU_MdqGi8NL1TY5i1y3INmy_1593928502', 1593928501, 1593928501, 'ALZSZM3hUer4YKalNFM35Z1oD1mu0bfo', '$2y$13$LHpsyF.HfCYyeyMLF2qau.s4ZOSewHhCB/9EFzdhSTzg2OhsGABgO', 'gtOqOyOp1nn1lHmSLml5AQj7zZ1oi5VS_1593928502');
INSERT INTO `dd_member` VALUES (260, NULL, 1, 'oWwx95VS4932aDxK4zKHmoJhhZY4', 38, 1, '陈大豪。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'iG4mns9vT5pdm-IFXjl84le8LU4JJMGw_1593928560', 1593928560, 1593928560, 'doIm_GcbHKytMcIDEEPRGrg0X4K9F24e', '$2y$13$qLJj/Zd.uqUenWiWo.HX0.68xRaF9xp8UGzT8L7KD/1L6W7NKyoh.', 'e4aLCz8kS0KiidX5CcOnwxJgzqDZ3J1N_1593928560');
INSERT INTO `dd_member` VALUES (261, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '2z9aYAlCy5NnmAwB9ALcp1li9DYGUBSE_1593928618', 1593928617, 1593928617, 'RDF-n4OGJx1gfqzOtV4iRpIeb9ouUUy5', '$2y$13$8DQxkMS5N9SwO9bcnw1MROxfjacxgxODcFG6K9xR2QTgIsjPoZSwS', 'KlZ0eDEOg701hZtsNnPs1mhXQLkDRe0C_1593928618');
INSERT INTO `dd_member` VALUES (262, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ukUPNpRf-S6mOqlINCtp9WxdMFvYZHX6_1593928626', 1593928625, 1593928625, 'q7WnZCtZCFGCuZhHuYmOKlNBvsHjqH6l', '$2y$13$w7tZZDT/gAplXCG.Ddw26OLcr0Q8m7yfOv5MT14uoggKb65N5btwm', 'N41CsME2umJaJcvwACBaEKtGGj0YCmOB_1593928626');
INSERT INTO `dd_member` VALUES (263, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'BRDZrlD-J8h0jCvPBLLd6WR65tVqI6kn_1593928670', 1593928670, 1593928670, 'Oy_fQL1Wku51gj_dvMsGIaktnYW8MWpD', '$2y$13$cHxNDNSQ0e304N8zRjrzV.lqdjrNyzpQO18etlBWgNz9kI9JBqCdC', 'AyvTnvp8Ar9y2SZwe1Xuu66X_FqfBNUv_1593928670');
INSERT INTO `dd_member` VALUES (264, NULL, 1, 'oWwx95ZFm07zSdqR976eaFz3EaIw', 38, 1, '～ ssfLily～', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'LHJPbPbLiWBWn2ZCxHl7grbhD1LQvUGx_1593928710', 1593928709, 1593928709, 'ylEGHiq9HAmYg4_wc9-_n9CH-daTiBF_', '$2y$13$6Wva6GfADVDC2FRkHF2aMO1sxtnGIC.oFJ59TfAGLV8pPDvsodtve', 'Rwkfz3hArwFoNYzf-zpCkbu99FUYQ_pC_1593928710');
INSERT INTO `dd_member` VALUES (265, NULL, 1, 'oWwx95fEsoSKZwkdLNPspWop43Wk', 38, 1, '尹杉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '9tOcS1siCG9L1mp3zFIoseybTwNt_8Wp_1593928818', 1593928818, 1593928818, 'rVSZOu4e4R8WJHFnLbeJTjNsA10z9TI_', '$2y$13$/PohRFXP2x5pOwHjBvCgxeSixHDDItVLpCDZqsqEXXmCktldS0AfO', 'LXye0BEDAaXavbxp6hmzTuZXvSrJFMnj_1593928818');
INSERT INTO `dd_member` VALUES (266, NULL, 1, 'oWwx95VhtUaVi0mXSyOBeostTi6c', 38, 1, '錕 ', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '-avbpMcNh2cUPMLEXcr2D6eA19rVhqSC_1593928845', 1593928844, 1593928844, 'b7SmZu7Jo9jWm8s0dCKXYGdg6sBiYheA', '$2y$13$/LdsxQ3I4MoTxJ6UFGeGA.sm4hrtMK8nD.af6KTnlhP1r.wU6tvz.', 'HqAolHBY_Izr-CM5LMg12mSVa--IVB8k_1593928845');
INSERT INTO `dd_member` VALUES (267, NULL, 1, 'oWwx95Xw0NLN_QiNTH_rGNyz5u6w', 38, 1, '2020', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'tyDSuVVd9aPSsduoQHCuvClxX_S7ZpH__1593929015', 1593929015, 1593929015, 'lQoarTLrHUSKRP5EbC8JmIcTBm3Q6RmR', '$2y$13$X/.XFn0mPifq2kF5Ej66VeoVzbzHRdzB9Vd8AKjlmXqgVgMb5Rlte', 'X9PfMEuNKnPQRAuBatt07jltZyu30Nr4_1593929015');
INSERT INTO `dd_member` VALUES (268, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'phE7NuhsEVC-BRZoTdDaNmi8dNZALC7V_1593929018', 1593929018, 1593929018, 'iL4wob5HbxBSZTN8eKds7fnuF51BiF0t', '$2y$13$rW4eo4sQNnvxmU81fsJAhOd4p2Q8M7/WqDd0EG0kaH2ic34ajgOSy', 'Ik3Gt3x2yzdhIqa4VKYfTzPc3qRvxPYv_1593929018');
INSERT INTO `dd_member` VALUES (269, NULL, 1, 'oWwx95QpsogZjILc_JveW32gqfv8', 38, 1, '泳', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_3iK3CV8Ibjt3Y_ycGV_YHnpMnp4Bq48_1593929046', 1593929046, 1593929046, '3PmJ4PRD0Low2g14HbfbPPs-dtTT8Rq4', '$2y$13$MC2VQhQWNCohOQQjR3O34OPvLrhRk3UjUFjrgK271CeIeETCbmMLK', 'wFovn6_QpFO5uMnupnlrsWlom9ceq2Ph_1593929046');
INSERT INTO `dd_member` VALUES (270, NULL, 1, 'oWwx95cdOFfq2Lf97HpQmHWgjqS8', 38, 1, 'J', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'HBqY2wyYlJOkmsrmp6U06J1Bnzpf2Ny8_1593929051', 1593929051, 1593929051, 'EEEU7Jx7x19jmTAi0uJ9iLAFBbtGpcco', '$2y$13$mTUewnBE8io.mUb1dpuHbONykw5wKgOqpRng02n1MjaWqurWEPZle', '4bTchLWFOEtF1pbUthKp8nbgElkgvrzw_1593929051');
INSERT INTO `dd_member` VALUES (271, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'EdRrasLneWRBIFUOIyrZBdYSVSHKhY46_1593929109', 1593929108, 1593929108, 'Le61moLkUBzJQsTGC7NEsVicg_vQuSer', '$2y$13$mtbznFqQjQ8GN/4ElW4jTuK9.97ln2.296xpd82XIctPPm0ziQsDy', '2NWuHruWJgYTtigiV_qEPm-nuBKXgg_Y_1593929109');
INSERT INTO `dd_member` VALUES (272, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'gbgy-qPyZdDxnrUKNIobKkM5_nb-948E_1593929116', 1593929115, 1593929115, 'emZFT7GPCWMb_zZheBrAcutnwX6JYfg6', '$2y$13$BxjjoGWuLNf0e42aZwvaRuDCecGmRWc7PTgazREndmKA4Me7veurm', 'bwpzBmt4Nw44DY10ELwpg1kJSG47fneh_1593929116');
INSERT INTO `dd_member` VALUES (273, NULL, 1, 'oWwx95V0bubaaklQ4Knw4c4dW-wA', 38, 1, 'SOUL。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'IkWPNWeRc0YBsfadn7ZuQzATawQF43Vp_1593929137', 1593929137, 1593929137, 'MceJwlAqGGkNg44bYI6jLagodqTYeEJ2', '$2y$13$.Duy.JwCe3RSBjsuqxjuE.BQ.RC.9HTAB9TrekVp5/IBNnMdyVO66', 'QtMo_IdtWYaYmp4HRIDJQL_LxGwWimx__1593929137');
INSERT INTO `dd_member` VALUES (274, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'laYv4uf4pSNDnupOv2UPrGowUgaxCzko_1593929189', 1593929189, 1593929189, 'wAzkgDf6Yi1PHz1H2ser23to8p_uUUYv', '$2y$13$1MuG0FdUtUDvkJ9f5jqZouH.gvJGGOXUPFAm7XPXl/CVbUf/drjN6', 'mDe0pMUvcqMDqQ5TcH-KLrwJvnTGoYaW_1593929189');
INSERT INTO `dd_member` VALUES (275, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '-UhRW-uGAEI5KkMcAOKx-3uyoECLlJNH_1593929284', 1593929283, 1593929283, 'N9-Z8DYnthe20LxAE-D5OeEFarN3gjJl', '$2y$13$ajNB7E32G56Fwxc.AnTc9u.VLN4Sv0pewDrvrzCyWrgEQeqUm3PkS', 'pNfPv625zS6LqGqLatl4saOGwaFS9nly_1593929284');
INSERT INTO `dd_member` VALUES (276, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DvlKpdGCNhRTw1-q2cDa1HY15tspz9iJ_1593929288', 1593929287, 1593929287, 'UzsASvZNxnLojV-y1OJD1FqPF9_bZfLn', '$2y$13$ICI0unKEPjNGjkkhFmfGZu5A9bLvQI7uNN8aKFfbK0THob3wJSa.y', 'QRSzoreCbpt9h_EdXS19UvNeoD25HoTX_1593929288');
INSERT INTO `dd_member` VALUES (277, NULL, 1, 'oWwx95etNxh_PsCgpVMXnH-XM8Oo', 38, 1, '草鱼', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Jm-52-7J0cgbID_p6-AOgywDEl6g8M-3_1593929293', 1593929292, 1593929292, 'R8QPv6Xj5iPj07iI4fRGyDKSkJYLzScr', '$2y$13$PnTeuWMt/bg8f/XKgYiBFummxQxgjSCwwtW0WreRfoz.WA76z1PRm', '4t2N3CsiIf6KJMIauuu0pZXKXxBYwEAj_1593929293');
INSERT INTO `dd_member` VALUES (278, NULL, 1, 'oWwx95R_x1FMqRYMFFw8PWfT7nL0', 38, 1, '培', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '4lOBMPIjh4NUhrrFRVOAsyIXZoily7-3_1593929294', 1593929293, 1593929293, 'fu3SNiv8VncUNg1zHmFeqQBADncXpKsr', '$2y$13$lpH3SC09B8q8fABCiyamruuLJ2TyJfRyOOSKkdvRsEcde9KbYyu8i', 'K2jFScLi_s6OBR2w_hUDQfwtcyTHUkkj_1593929294');
INSERT INTO `dd_member` VALUES (279, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'aC77f7iR-jm4FVtD07KWd8HiRz7mDKvD_1593929301', 1593929301, 1593929301, 'Ex0zfYAkvlK2SrluEHRsQQoSM6wZyz3K', '$2y$13$vGOjlyFSVXymYeEfHR6kgen7yk/KWekX1GX6ZGqLn31wRz.9WgCP2', 'YADzW292ha_xyz3-wuVRN-RFi6i_XGqF_1593929301');
INSERT INTO `dd_member` VALUES (280, NULL, 1, 'oWwx95bO2rhjj-ijlmKgzRZ3-ySM', 38, 1, 'Marc ku', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'bah1NCScBECMt7aIQcvgR24CYWKXAqI6_1593929309', 1593929308, 1593929308, 'lKABty7rSNb8M88Q50RyR3LJEo9pBiOZ', '$2y$13$8o74QteWxVqBAMyinWg/UOgx5aRdUa/Vx6zYcGgRvO0iAh17AUPLm', 'pQXNeSpMPEQu0GD9PisaupYw1kJps65c_1593929309');
INSERT INTO `dd_member` VALUES (281, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'BEPuQwMLdjjr1hniBR5WmbfJBtK18_hg_1593929312', 1593929311, 1593929311, 'Zq9GdVvZDZRYXW1esfoh-WTyO-7RbQEU', '$2y$13$XR4jmk2LXZyqe87HMWyGzOXrpzVzfMIoFdX2cdZSraKuQ0/PQR.Pq', 'bg4eEnxz8jyvT69WKA51h39bRm3yOozD_1593929312');
INSERT INTO `dd_member` VALUES (282, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'HCRa-81qwzvK_J_FfKtmAu7wGLBxUbY6_1593929321', 1593929321, 1593929321, 'qtDjn1ncXySMbgkXEKpgMo_Z-wEbOMvt', '$2y$13$GfJFVLHTZ.E/gHE56KANI.KI4aDr6Y5M8gnT1qphGJtiIbV0TOA7i', 'dE_jMNR7vdtLzDoEX1wgQFCT6QqipwWG_1593929321');
INSERT INTO `dd_member` VALUES (283, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '0bbHDC00Si506ACKL3f5giLBJvT5F2gV_1593929330', 1593929329, 1593929329, 'P0biFKX3xVo9AQ5q1O_1LSV8Bri75dyv', '$2y$13$NU7XoVyfuGhUwzHH90qNDelWAuZD.sBk.orm15TMMGI9Mb/uyJsxK', 'rVDZQrL0vvdYbpeuTA7QvlmDBTitCDIC_1593929330');
INSERT INTO `dd_member` VALUES (284, NULL, 1, 'oWwx95Z8gRNa3HdSZ0kdUNcHJQgE', 38, 1, '菠萝咕咾肉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'V6FFutgEtFapez2w6UXweey5n-0HUcah_1593929353', 1593929352, 1593929352, 'dbFrZnHpv65yTdAwzyUjLjQDPsQ2cbyQ', '$2y$13$Ilijoj9OuCIDGS5IXjx4x.GRWZfJiO6ti5MqSLzXtK7KjHCVZArga', 'HyZ1qT8B04QsqObMuy9i5ym2ViokPy1r_1593929353');
INSERT INTO `dd_member` VALUES (285, NULL, 1, 'oWwx95aWqQ3OaO911ab6Kloi4VHY', 38, 1, '皮卡丘!', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'D_Fiyu2gcFUMTL9BBSjqKcXw-Nmqaa5s_1593929375', 1593929375, 1593929375, 'HNLa9xvN4OCfKFbt2r_g28yXAmhAYX2i', '$2y$13$vp3kAeb7z9UKsU3cmO4ybuR8eE6RBCRMU8A2AroibFOxU1hAME5z6', 'H-E9A6rjOoY678tRAPiNcR9w6nbBVdll_1593929375');
INSERT INTO `dd_member` VALUES (286, NULL, 1, 'oWwx95ZpOvXKZnNRu8W-oSTFuYQM', 38, 1, 'ka', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'uICNNw_x4ry35CnqPPietskBDNyV_Kya_1593929425', 1593929425, 1593929425, '1r3Vdfsg7uPoRgMfPb-FKOBQLXGZNP7n', '$2y$13$qF8FNVpHlRORN0BXzHm0POfHT/pkxorGmkf9IeoueRv6k.wnbJjc.', 'u4_jCcM93e6GN_8FVDUhtZhm6t0NacQL_1593929425');
INSERT INTO `dd_member` VALUES (287, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'JAChBU0quJ1FdgLhbb1ifDy-stv4UsZo_1593929469', 1593929468, 1593929468, 'OVM80OCx0HJcNgob0wRIolTCZyo4XSI8', '$2y$13$ZyfcN1cCyJze89.9Kv9nKeVwS1UMPFsijbHZCuKpXB7ThKP55ozEq', 'UsdOX3bAh0DG7OO_6Uzhl2mkrQhsnyrq_1593929469');
INSERT INTO `dd_member` VALUES (288, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'eYDoHqueqTK5Jsa_vrQRDxQGohMCalf2_1593929487', 1593929486, 1593929486, '4MeHSkhv3Gg8lW0QMGzq3p8Z8QzN6kqg', '$2y$13$ttIW1nLDLgkXGwy08gB/OesY.7riEtYyLmppnkgmVb/VVM5l7pzUu', '_UcNW0ngAyjyk8lOVCDRu4zhacYnxxc5_1593929487');
INSERT INTO `dd_member` VALUES (289, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'RoJfXhCJqfcuRmCkmvhXK1GrOqL7rM-Y_1593929513', 1593929513, 1593929513, 'bB1vtQcHyqOXBuCirRueEEJPBo0P8HYo', '$2y$13$OicMb5Q5c6ELCduZEw.SAuKVnyquJgTMPrPGjVs36/uk8bGWv79p.', '1yEN_hQ-zg3t56z8-5BNz2MOgz-XvbXj_1593929513');
INSERT INTO `dd_member` VALUES (290, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '5z43TjhvVao09dTHCLJr9nFSNlRn9iGz_1593929517', 1593929516, 1593929516, 'uqd1zL3z1TG9QIjEK_wVm08PdB1Mjf6v', '$2y$13$q8La/hGoNQAHHlEpJ0qEWO6IFZsFL2n.vISlppbY.cV1w3GkC0wPm', 'V_pism15NXyIJTH8C10C1pvQrQ-FK5Ef_1593929517');
INSERT INTO `dd_member` VALUES (291, NULL, 1, 'oWwx95R-27dwirXJYgBVMBcghgxE', 38, 1, '中信银行FYH', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jhiyUiJF7YfiIvwIcPLKpFSVD85dmsE8_1593929566', 1593929566, 1593929566, 'exsgFbTaauXXiHojiqqOb7YFk_9D1bh-', '$2y$13$U0084zgSSFeheqybZNogJeeLBIlqrCel1EjfBWcGZ6XCP5vWmZcx.', '2o59JReCeYzMx0ntpjL88YmGvcu5zUFy_1593929566');
INSERT INTO `dd_member` VALUES (292, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ScIQ-kf3CcnOh_fk9JCb6_9F9dMrATtf_1593929642', 1593929641, 1593929641, 'Gr_iG0UJdQyrFrnGyPWYNjJZPYEMsqV4', '$2y$13$V4owWLnZmbTJqW1Iwx6TB.hljtQwwMAk6lmDCKGq2NaAh3IOO5qu.', 'oga4gsqf03CnhPfD2CZjxMzAmlS9cqv0_1593929642');
INSERT INTO `dd_member` VALUES (293, NULL, 1, 'oWwx95dHBZDmSxZn1j8ZZ31ti7fI', 38, 1, 'AA许', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'GZZv6fG_E8cr0rCUxWmrmYOhrWrvLaTO_1593929665', 1593929664, 1593929664, 'cI4bbLLpu9JAZWN989bKZjzj0jLIn1BB', '$2y$13$0NsDDafXXVI.I61KJ4ZbSOiFvBNnY80WjDEqHfRNnjd.hYLJ49FLi', 'fd-6B0tAro0wdqEXCt05T5tFIR270OVv_1593929665');
INSERT INTO `dd_member` VALUES (294, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'aXJEWswGPUoWB81f0Jf6tJ1tdf1V5S7c_1593929680', 1593929679, 1593929679, 'IgSxWaUAB89L6o-N7VnaqFeb6578CFwA', '$2y$13$ld5trFshOMT9aEzuH0hu8.yvRq1g2SCp3scYmYrxE8tAv.npjXHJS', 'Trds8kMzAe4XCwVrz0OjMZtLMF3fnrrr_1593929680');
INSERT INTO `dd_member` VALUES (295, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'mV3aNwxnJnWZoaumenNRcaem53lNYvjB_1593929683', 1593929682, 1593929682, '9MU2DdBvZvb4-L13NLO7HyUeuNgAO9pn', '$2y$13$TBw3yvjhcGFIMuUxQY6JXOcHllghqzVCAjN1PJOiBJVx90m4aWENC', 'IPTV5t68Q2TGwQ_3Y2w-8kqEQmU9QJeh_1593929683');
INSERT INTO `dd_member` VALUES (296, NULL, 1, 'oWwx95WWaZyWmPvc9aedY_vhEKLk', 38, 1, '⁶⁶⁶⁸⁸⁸', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'KdnVOcxGA108CIJu4y8o2OU7Ud-gHEvo_1593929780', 1593929779, 1593929779, 'wU8OKLz3PXOix0iykaFZg8rIclFZ_1L6', '$2y$13$N7SOF4myiZCbjLMY03tN3ecx.BH/boNN4nIn3hHnhA75Tnrm1Emri', 'iHVvzuIEuN7pwaCElTsnbCI-Ey49QOp4_1593929780');
INSERT INTO `dd_member` VALUES (297, NULL, 1, 'oWwx95Tudd79nq5m46RT3AM9Gdy4', 38, 1, '听语', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'sb_QpJ8DmLrxAGYe8upqLuUpxFRdJpQR_1593929813', 1593929813, 1593929813, 'nsA9xFkWYJt6LY2z3PFxbq3J5-v1Xd-Y', '$2y$13$KG1fctBuMb41akSgobpOSun/0dodju9TCpTUj1qc6/MW6hxUiWHfi', '7dK95HMwNFItPOQo0QoFaQjU_HIBIn6u_1593929813');
INSERT INTO `dd_member` VALUES (298, NULL, 1, 'oWwx95YWqExUs_Wqo3kU8tgIlcOI', 38, 1, '檬_', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'S5JQOV7Xd88MVg2cMYvmzlK7WHW3vwn7_1593930030', 1593930029, 1593930029, 'WPXc6wlP58ZM7o2NiJUvMgzTUmdRAngp', '$2y$13$VjNFHMeoAgWVJPSReyGv/ORCrYcJJQg8Q3uw9JYih/aNYDC/hKQ0K', 'y1Yh8ghFDN3f03dQEUqslJ_zAQIooq0k_1593930030');
INSERT INTO `dd_member` VALUES (299, NULL, 1, 'oWwx95ep53Q927bs9qhsz2cN2FFU', 38, 1, 'XL', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'dxz98AN9qvnn3xFXzb3iQ3DQ3mWfn4D6_1593930259', 1593930258, 1593930258, 'uQ91BNNWj4yJIuzDD3W38BcuHBlbkS_O', '$2y$13$v92GWUzv5lM.6FZ5uH15LOC7OEEIv9EdPr1cWKlabBrmeLjrYCBYy', 'PLi1EEreKrMeWFKjDA36J6rXh6syKOMo_1593930259');
INSERT INTO `dd_member` VALUES (300, NULL, 1, 'oWwx95RPBSAiq0PZh0n_P8V28jSs', 38, 1, '阿海13178826806', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'NrkWGe7USkww1cM63z0ZgAgvhas_Iy-D_1593930378', 1593930377, 1593930377, 'nw5ny45L6c7_ooHDpfdcZXXsyHaRFXwc', '$2y$13$j4dnpMTaKhB5iVPk20qbUeZ/EZWitZTqHiyFihOzQVlehYSyMvul2', 'dVfhI23zzMS_c3HiC-MxYeZvP2C_zJP3_1593930378');
INSERT INTO `dd_member` VALUES (301, NULL, 1, 'oWwx95X8ZFbA0Dd2-7Fo8a4sIUgc', 38, 1, 'HZ。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'uDaj1_QwyThBwNHJU2vBPMmsqCKfgVp5_1593930867', 1593930867, 1593930867, 'PReBWXXeKC6iet4QwFxsy-TQfOmtGNkx', '$2y$13$94WLKz4EkQJBfH5F//bjNOHfnHPkXumtYxfkr/ZAvbHQOh90HIuca', 'ixPdg5zxtMMbgPr6HpK-QoBTuqxJt6xU_1593930867');
INSERT INTO `dd_member` VALUES (302, NULL, 1, 'oWwx95c-7nsSjv-vro95uP97u7b0', 38, 1, 'Usual', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'PRCFb4RY8j4yx_hwQDeiySubywb8vPbG_1593930914', 1593930914, 1593930914, 'fIf5TTVm8w4oH-um-zdg_qLO1vsmtTRF', '$2y$13$f3McgCEZBT4xWguCvwjUpuszqg0gVmRZq.jI6CN3393TmDAK5cwK2', '9qI3y06vQu9wnWRV2y6cOL0H5XPQxv2d_1593930914');
INSERT INTO `dd_member` VALUES (303, NULL, 1, 'oWwx95VbcQ_SxxsA-xXWfMBiMmFM', 38, 1, '6.舜君', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'kqcdDyh-jBtQ0oTzCPpdJG7jFyv4u9Ff_1593930986', 1593930986, 1593930986, 'eWDQT_JqtZIwrs25X4nTkIlIlGpwFHnx', '$2y$13$lS6spYNqkszR0wTFpU5EMObdv6hCpowr2Wexv5UMiKaD/a51t8o8u', 'GoE3qX4RisLo20j5NqP9U-Za0qegGc3O_1593930986');
INSERT INTO `dd_member` VALUES (304, NULL, 1, 'oWwx95a76ckXDjIKNrhe-xc2lV1M', 38, 1, '辰宇', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'qcEN9ttaA7uyoSSmzmRwgc1zbJ_rhtXl_1593931066', 1593931065, 1593931065, 'qtgYzb8IR_dzMW-bSY_uevoGspTnyZUn', '$2y$13$2hpUWw4K9eEJbXg/cc7J5eVfnaqZifkUd29dRLTV.1DP9TpTl7McS', 'JkDEewexqpbbEhcwNqj7B3QGgJkfuWR8_1593931066');
INSERT INTO `dd_member` VALUES (305, NULL, 1, 'oWwx95a2X7zCE2cduhR7WcSFWP0Y', 38, 1, '虞千寂', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7v__IAtPGIYAXXEGP6BW40_Gm1GTl_HJ_1593931113', 1593931112, 1593931112, '0kszDmTTZ6xfFEcB50RFPoydbHgOxtl2', '$2y$13$/95w8Xwfg2NAQ9Tcy0WCWOZgdx0bCjyYYL1rk/wdpTKHDP0zMlY9G', 'YIVFvAoVDC2Gwx21KqbsnQKq_MmjXrOF_1593931113');
INSERT INTO `dd_member` VALUES (306, NULL, 1, 'oWwx95YxlBJRb1SZyQ_qsXqrZigY', 38, 1, '若希若得', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '8r0SvwNlBwXqyc3BTyqXG-N7FoHPHS76_1593931198', 1593931197, 1593931197, 'uW4NXTCYf_VE1QD-_2iuzwmMMjhe9ilB', '$2y$13$fGlcMAldw/epU3KkpCds0uuuK7.5paSZj8GeYoA5mrz6NNoxh/lby', 'jdSkR6HRVFfjJr9CzB54y9mi9ufrvX-Q_1593931198');
INSERT INTO `dd_member` VALUES (307, NULL, 1, 'oWwx95fyfOa6Bh9nrQa9SR2IcXX4', 38, 1, 'Hayward', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'zoj2tNnr1hP-et_IZnrSV646p0uEuYj7_1593931268', 1593931268, 1593931268, 'IcB8s1SAhjGOcfPwyAWPFhwI0GiOo38a', '$2y$13$G9HuPDQD.RU6oPXrJgsW0.NTm4sSvUDnRbg5.GfZEmxbqYh/is4jO', 'nrxdHMevH9PCuayzdiKkplm_USUzJQRZ_1593931268');
INSERT INTO `dd_member` VALUES (308, NULL, 1, 'oWwx95bI9qiXd0rzYrYqXbcOM3wo', 38, 1, 'Very Tall', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'hny__Sfwr51r-H8XeWlHX3ArDlCidPiV_1593931905', 1593931904, 1593931904, 'iz8PYpnpy75rRxkYYW6C3vQFGgJDBjIz', '$2y$13$0avasi/vnlbFtJA70W2YkeaDfOXa7Ryfl5tPJBKTmyfv/Ci1fOEWm', '9xVMt43Vgyz6o5j9p1EaK4JfEcxMxbv4_1593931905');
INSERT INTO `dd_member` VALUES (309, NULL, 1, 'oWwx95R58IVaBdp9vtbPKD3t51r8', 38, 1, '刘刘刘刘权', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'F5CXJB78uYDLU61YQDMR7yAUciTNZ_yt_1593932257', 1593932257, 1593932257, '202Fm6M6v2CPoFNtIg1Fu-fbkGPCYw47', '$2y$13$/XIebb/mf71z9eFXm9gSMeq9.TCcGj5hLiTRZXsJTav.8ByR8VNd6', 'KFKri0cRsv-jLFVMKxg4iAAHLzorqE9X_1593932257');
INSERT INTO `dd_member` VALUES (310, NULL, 1, 'oWwx95ZAW3fX5XfpBjh0sBlMH4PI', 38, 1, 'ho。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'OzDOQHFs8mg1Hu2CiFVWNUk0N4vIuFo6_1593932318', 1593932318, 1593932318, 'M6hc7lkhBjnuXJeiEcr7ojRyg_rz-01B', '$2y$13$xCTWkMHSbuNWdRHF7mKnJe6drRsTZqJaKO/Sqx7UeYkIuzavfG3vi', 'pfKHYdrPs4Jtg18SPGqh6thy3CKbDbN7_1593932318');
INSERT INTO `dd_member` VALUES (311, NULL, 1, 'oWwx95YFJEca4KINGv7eK7SR6qXg', 38, 1, 'iYouFebruary9', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DSDeXHBorC452pBvD2K36OJQmanY3FBD_1593932416', 1593932415, 1593932415, 'Jx9VQ5YNocqX1IfOhqqbcsotaN5RA0Lq', '$2y$13$hWDP6sIhAvfoTIkZCoG1aev7VskNRnyKkVWdiehJCqmfAjEzcEOBm', 'Qr04I6-dZXidGftYdzjUREEas-W0Svfa_1593932416');
INSERT INTO `dd_member` VALUES (312, NULL, 1, 'oWwx95QHgolc0-EswBZrhy7lkXmU', 38, 1, ' 兜兜[色]有乃', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'HXDMxR59GI7V0kF6cnf-DRxTuksG-4s7_1593932612', 1593932611, 1593932611, 'ezjPS8z1Wj3MFxesNKu6NTJMSMBAWjkF', '$2y$13$li7IMp2Ja6A4CVtxCEKHZeaDXWJ2lm8yquB3i54izzhE8epgtW/aG', 'wn1UzhPXGPNPOeC4hGf--_PPwqEb-bbg_1593932612');
INSERT INTO `dd_member` VALUES (313, NULL, 1, 'oWwx95afkiUc3rHzHBpmv9PRlf_U', 38, 1, '何强', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jOopqleRSB27_wgKagX58e4pLR5zMSLE_1593933103', 1593933102, 1593933102, 'yZobaWFWkOXi26Qm4V_dghENVdKiH_pm', '$2y$13$e6XSS4qottndO010c71xpuSu6ol5mRzvuvaFX37WmcKhfosgu6PWi', '3jrA209hUWYkPyZsXWHnNEZfY2zs5n1e_1593933103');
INSERT INTO `dd_member` VALUES (314, NULL, 1, 'oWwx95Ymzobx4MINmv_GOSSdCWJM', 38, 1, '澳', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Yb3U6GZnC2VV2ZuWy1vGTe1qbKg0N6sd_1593933116', 1593933115, 1593933115, '-EtBSz8PblyuUQqsDqRspKAP6Ns1qc9L', '$2y$13$VXPgezfDjMUt2AEQhmLJeeLO6wo48j9TEhD3HnTFO58hTqJOhPqlC', 'zyIVjpVfGvAKPWoFLSKDG0n1B1DOcPex_1593933116');
INSERT INTO `dd_member` VALUES (315, NULL, 1, 'oWwx95c9zSDg8kynVPj-bkS-PWYo', 38, 1, 'Le 动 超人', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'k1XY9M3g1bMS8ur5hTLbgAtH3g0EWyqN_1593933131', 1593933131, 1593933131, 'IUE3jM-8YdgIwm6XQhSymMcW9y0g5lq4', '$2y$13$5HQAMe/JcqrojEPdSHxUdOyM.d.aAZNXBUG18fKtRUZdXRh4JJE9e', 'mk5ZLhz82cuX47SX-shgBvLb9_qlzMoX_1593933131');
INSERT INTO `dd_member` VALUES (316, NULL, 1, 'oWwx95eUVMnHXYhsJG_cfXC2wsP0', 38, 1, 'vista', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'nIfuvq8mdpq4GNHrFwHW2fSukR1kWms3_1593933178', 1593933178, 1593933178, 'gZQBj572ByX_zG49V5rkaqCXp5Fsp6dQ', '$2y$13$x30zH/Ikj1sImmtEgivSVueYUZ0UVN25wGfOhwDBnCokLhYrzt2Ea', 'LRw7EJo2g3LhWVo-qSN-qbAm24BPXyAc_1593933178');
INSERT INTO `dd_member` VALUES (317, NULL, 1, 'oWwx95cFaoKLQ5MoE9iwSpxJAHgM', 38, 1, '如果我是陈奕迅.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '790s68AZ4aVoRD02QAXTsfZ45td1eaeg_1593933206', 1593933206, 1593933206, 'TGH3-pXPdrmkOEreRa1RDd9bU1de9wUf', '$2y$13$V2Bf001TDDMcT2FIkefqj.7vWZP9HyHDkQiRG45lA7NTWFrUOrfVK', '_-R5qEJOWTdSoACsipuNxg0sWAhYDh5C_1593933206');
INSERT INTO `dd_member` VALUES (318, NULL, 1, 'oWwx95alJQUu3IUsgl6HSZWqae4o', 38, 1, '荔银肠粉 王缉官', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'gSI4cob-IVUM2cVZhwja_OymdCzEf50o_1593933360', 1593933360, 1593933360, 'n9OP-jfXkrymTCorHFx4E2PiZQAD9IVC', '$2y$13$tNc9AT9s2G.LSQX51BWgKOeiLBzhrvFjJ.Y.CNcfzt4t542b3Jl/S', '-b6Z7-FoKciAwRhUMEatAIGJpKMUotYX_1593933360');
INSERT INTO `dd_member` VALUES (319, NULL, 1, 'oWwx95dR5pwiJMju3b8Ow7Afzru4', 38, 1, '我不', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'F7rpm7k59BQ2sQwA-8MkqlDcDFYgSx9i_1593933365', 1593933364, 1593933364, 'SYaxzPx1Mzc-dUtyaJqj2R1_7r6SrOsW', '$2y$13$2.sPFbeOpkgHIXXZCoPHheaAoHPuTlcKtxxPe4urkas29urQ8hrSa', '8WMs9I_OMXdhganbi7nmMRTEbtaqHe-Y_1593933365');
INSERT INTO `dd_member` VALUES (320, NULL, 1, 'oWwx95Rzs11GCq6Gg0JlKg9omlsE', 38, 1, '周 ', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'J41wM_CiI-sNhxhBfOXwIPdyQj4zDE13_1593933854', 1593933854, 1593933854, 'wOXQX76u0gPyusiRR5dV_6e4Ue0MX9CU', '$2y$13$l0nzDbk4k61gnqQmqaWuTudtmVG5jxxVfUABfoUzD9R6vmwFE43Yq', 'attm95IfHpaP8P2ww7eXFiT4jsXBXj5O_1593933854');
INSERT INTO `dd_member` VALUES (321, NULL, 1, 'oWwx95esBs7aIdyZCG3y4muc0oXI', 38, 1, '【叶孤城】', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'C1nfwfkLHb22OzKwWMfboZNMpWKUmst0_1593933859', 1593933859, 1593933859, 'wAbwIIb1jm9Z425dEDvEnik405Z5k74Z', '$2y$13$zUdD9rVfy6wq9jERz26VEOJyw9LGVbBXq3aom10M4Tss6qpFwDmFm', 'Ah-PQPXOZ5whKXjglnSMXi1Y77EsU33l_1593933859');
INSERT INTO `dd_member` VALUES (322, NULL, 1, 'oWwx95fWWbZssQuma1T1gc4yAZO0', 38, 1, 'Wing笑', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'x_2EjxbBViSVfpDBzvi6wBNE_-4NLxbl_1593934043', 1593934042, 1593934042, 'IJmm46KpMXGb5b3BcTEcf0cD50JGqKD2', '$2y$13$2SYIm0KHMHesTtCQBlE/Huwubu0uE7QRIpD/2xKiyhPS8dNWEeLES', 'VZ1_42QpBHRwWtLyBPt8UcyhC7s_NK5x_1593934043');
INSERT INTO `dd_member` VALUES (323, NULL, 1, 'oWwx95ZNkhLeSKu4v4-swOhYRtjo', 38, 1, 'wiwi', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'VlzDxxvbpjh6AWN5Y1_w19g7xyCFUhWL_1593934101', 1593934101, 1593934101, '9AIjH9iAHZqkPhNdyolW1FXTmaJrJdxg', '$2y$13$30b2I6Zg7gal/jxVNvv.OO9TeXoTR3byTGKgLhmptbldgLq.RakT.', 'MdSHYq3-wV8weQuePB3I5YWzXphxT1JL_1593934101');
INSERT INTO `dd_member` VALUES (324, NULL, 1, 'oWwx95UHX_6_RfDAalKobz7_G5Nk', 38, 1, '䒕 ..྿', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '8lCtwVnRJOoMAaY4Qcdm2SxCdpsH4bfY_1593934338', 1593934337, 1593934337, 'AAWn72CG0EqOQRbPjCUnIgxeSepQr46t', '$2y$13$pW7QEX6RqAWnRVL3uOzhiuCjfwEK3xIuIfAbSRhUlixEKhl4PFA4.', 'H_6_kYwknGhsqXxVAGjmyQ-oK0-sZLnW_1593934338');
INSERT INTO `dd_member` VALUES (325, NULL, 1, 'oWwx95Z8oN_Dn1led45nzJs0ljOs', 38, 1, '天天', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'RSePuB0KJuCAM0qucGxArPBo8ocKGN05_1593935306', 1593935305, 1593935305, 'DPDc3sza6GpSJNnKHC5UFQ0OPR1VETcx', '$2y$13$D7vudHD6ZwfTgzQtr1a82O.I5K9uZf4kYD/q./kaJ3vfSvIb.uXVG', 'dB_iDbAxbkffCHXnTR1ehmOPXZo-vn-R_1593935306');
INSERT INTO `dd_member` VALUES (326, NULL, 1, 'oWwx95Xe1AzQKcLX8NduJPU_2Yo0', 38, 1, '魚餶', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'nNO1csHfcT7OsjJBwfxpWDAH8GPuQGzm_1593935417', 1593935417, 1593935417, 'KhIfIG8aPw0OZtQo8XRAwUVofagjcORm', '$2y$13$LiyPuHR77aLJmUKUx6khse2LiH7H1Uu4QRqPDCfkV7DHXbOWBb9fm', 'X6yJbDb5I7TQzj9K2MJsRAMOAiHiSiaZ_1593935417');
INSERT INTO `dd_member` VALUES (327, NULL, 1, 'oWwx95TAptMKoMiz1kr_dOJSB58Y', 38, 1, '敢敢', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Jv1ayePEc_00tQ_AV_RgdVpd25UTt-g8_1593935485', 1593935485, 1593935485, 'JMzCYJgE_5WVYkax0pvDPGQX8xEbQXxC', '$2y$13$Sj3z0KkYeZLFkqBlIgvU0epERl3vXUkIWCydPONnw3ZdoLKbJEYeu', 'czf32t1t_OiWvBDu2AzSLPI-02aOt67f_1593935485');
INSERT INTO `dd_member` VALUES (328, NULL, 1, 'oWwx95erviPbq5Cgg08cQ5-1BZso', 38, 1, '29', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'cUYPKlnOUct34GF0bcIfHMQ92ejHXrVh_1593935979', 1593935978, 1593935978, 'SeWWdMCtIpbRuUs7kmCBQUmT9dolAH2m', '$2y$13$pC7c4h1BIMqpsRKac9UXs.DyJvBCg1LjV5L4fazlaEvGyfmjp21Xa', 'qyhIoUDnk-9WXxu2r0FgxeMxuuUgKjQw_1593935979');
INSERT INTO `dd_member` VALUES (329, NULL, 1, 'oWwx95S8RYn9STEfqIRpMw4-XNlQ', 38, 1, '阿华18682187200', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'qkJwydaUmRsys_8Qt-mnOwrJ6pZj_X9I_1593935996', 1593935995, 1593935995, 'eb6FE31hsa7YeHBlVCRqgrCy2OChXZMf', '$2y$13$0culta32QCIPS9Avsc/Fa.FTxtqysNT9t/IsiU0ZBymWgCUzJco4W', '1nA0R9Um6cjrbOaxuGvpxAwRxab3yk-D_1593935996');
INSERT INTO `dd_member` VALUES (330, NULL, 1, 'oWwx95S8RYn9STEfqIRpMw4-XNlQ', 38, 1, '阿华18682187200', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'SQpC4JEQXOmmqNnFrUA3AmZ0lzkg4gpV_1593935996', 1593935995, 1593935995, 'i-jFJG1BGJQmhaC5uhTLyoEyhUDLqEpy', '$2y$13$bGt3Y32nBf3.AhrnKQ8AAeaIR6dwtf5c6U6.oFK83gBnuE89MqrUS', 'b8rgoP3eWtkL-CfuSy2zvBE5oav-knGt_1593935996');
INSERT INTO `dd_member` VALUES (331, NULL, 1, 'oWwx95S8RYn9STEfqIRpMw4-XNlQ', 38, 1, '阿华18682187200', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '6GJVOGwAi0L05gNxw3HG1w0luxMZlV7__1593935996', 1593935996, 1593935996, '5hvROt_MhHrN8gu706z56sXHk-VOp-DY', '$2y$13$h1Uryl16/bGoxfdY66mCQuMVsf/JStGLpXrwSdFqIuY/p4EgypH.i', 'H3BoGJhowUaw89lEWmA5axfmSTho_YrF_1593935996');
INSERT INTO `dd_member` VALUES (332, NULL, 1, 'oWwx95VgmRwMGPsqSTB_Eres_aLs', 38, 1, '咸鱼一条', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3FV6g77fZqjNF60yjqH03JejKBLBsG81_1593936478', 1593936478, 1593936478, 'iqfU9nVLLmOPPuDGmbp6kunev-Mw84Zq', '$2y$13$v4XnzjzsacteHOrBcNw.ee22d7nSBkZLJadLzJ8Z1fwFhbZJBahlm', 'ssHMkc7Gqo13tifeyfvVcl90TgLa76Dm_1593936478');
INSERT INTO `dd_member` VALUES (333, NULL, 1, 'oWwx95VnJLU8jR6MfWA87H8a_uVU', 38, 1, '哇啦哥', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'GLUJVgEwCS8H0913Zw8ZhQhhFtgVjcMy_1593936574', 1593936574, 1593936574, 'kTLMWUNtDgoS05UINAsk5YSQ4y1Pi5S2', '$2y$13$ajABXbD8fXAsX32yTCI8RemECrqWpghM6AHZpLjaksflK3tFJeTby', '3XKQ2W653512k8eEcvGw7IVd0jqCMJrP_1593936574');
INSERT INTO `dd_member` VALUES (334, NULL, 1, 'oWwx95SDR-TKMyF6EdedG8_2X29o', 38, 1, '哎呦喂', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'AtNnXNyODJdSf1x_h3j24bRafcmRN_L__1593936654', 1593936653, 1593936653, 'TLw0GGbuU8lJy-Xjhe37HWiiawVnxd--', '$2y$13$ajvIYPuoNxJGHu8s7AFZQedajh3Tfd75h6FPgXkQ9p4hwaLH2UdsC', 'pIs3eKTTKvwg9wuflxW6eXxS5oCBP2Bo_1593936654');
INSERT INTO `dd_member` VALUES (335, NULL, 1, 'oWwx95e7DZUKz1OgVHN7VI5Wkavw', 38, 1, '廖華', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'YTex818w1MgjM18kEAO_y5EDo9m_eXah_1593936787', 1593936786, 1593936786, 'B5nyrdib3xwkmXSkGC0L_qBPlc0NLIFJ', '$2y$13$D.gpTOb/0vaFfmNIKV6rM./RxI.ELrjxF53IY3LU9L0.F2QyDosI2', 'jfyhkes-uMWfwXqoXCGtRN3SGbvxwv1A_1593936787');
INSERT INTO `dd_member` VALUES (336, NULL, 1, 'oWwx95eL2RIZ42Vp3uon1uavco00', 38, 1, 'Jack ', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'NsHMFe2y4sQssjESBFrV8PtYBlAS6KwG_1593937107', 1593937107, 1593937107, 'LbwOCGbEiiioTK4YAaXQJOMZrVnVt34A', '$2y$13$sRWDUK2l1J/CNyZGKnkNouqW0YeTeBxTzAcJ2q.JfDMKSQSNUqlfy', '8hqsIl-VJ41T2VROD2gH3d9SRP74A_AI_1593937107');
INSERT INTO `dd_member` VALUES (337, NULL, 1, 'oWwx95UXW_1kXYh2YaYvVR3kp0qA', 38, 1, '周文', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Ib04XTMlyjbnZvVOGA8pgZLGMKBipw1m_1593937154', 1593937153, 1593937153, 'dFVwgIoKLXOPTPqqfx6tEPsWhn0tiQGF', '$2y$13$OB9kVxMXHDHGEvtqplyWNezw07HZQqHyUgtNq8vrqizZck7TyN1ru', 'bwv1euU6uK2LnwQKrhpTfCrrZI0UWpXE_1593937154');
INSERT INTO `dd_member` VALUES (338, NULL, 1, 'oWwx95RG2iNu5DLznhJWHKhehhrs', 38, 1, '㍿ 自律哥哥', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'GtAxTHlSRqJZZHkpRLAVQ4KgJL6kxf_o_1593937173', 1593937173, 1593937173, 'L6I7GmC4nE0bUPoESEHYDgwptQmQ9mbM', '$2y$13$XV4klqoZrrxuO/2NNxDdVuArV8221N33VS.TrYCya0gLCLQzy/Hga', 'n-AKmw1kSZykml5s8bIS6YIfs1vt-jK5_1593937173');
INSERT INTO `dd_member` VALUES (339, NULL, 1, 'oWwx95QMl_LL8vsr8ZvX6Bbqg_DI', 38, 1, 'Shine', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'BULGQ4uMIxSvC5ZdAtN5Y9ZjzShMuKQQ_1593937374', 1593937373, 1593937373, 'JxWc8_wpDW1MiDaCeqpBipMzdBNH54x-', '$2y$13$KMyxg1KlmIc7i9ZZYz3oA.eDvYDeCnVk6L7sKCg7mqvdLcnumcvca', 'PjlrOWJvUnbqDbWmeRrTxT2aTFAweahO_1593937374');
INSERT INTO `dd_member` VALUES (340, NULL, 1, 'oWwx95aeliP3NPIKtngNx2yUDvDM', 38, 1, 'A聚宝盆不回复弹语音', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'BvQxyyc--whBXz0CewFRU7I-tI70M8eT_1593938119', 1593938118, 1593938118, 'KOFmAtWA3QAEvyVIUIk1V56skXDuXDs6', '$2y$13$CYdYcylGbjaXYtH81E7hGub7oT.URFfYyaLa655L97UeVwrFTVIUG', 'JpkMBEZawgX2bG5AqLM4BoPO_wK5dv8S_1593938119');
INSERT INTO `dd_member` VALUES (341, NULL, 1, 'oWwx95fhSvGt1kVt0RZW7Geu589Q', 38, 1, 'Calvin Cho 曹雨生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'R49y5ZnMpdvZHEdZ2kAadIZEvU9rw1Wy_1593938276', 1593938276, 1593938276, 'sJLQtCKx4M_XMvdgdc82pGhHGw0q-RlU', '$2y$13$a7RN6rbzgs4rizYBfssgveZ/SXtwIuTSgHo7ok4x3TKHI4AZqQ27.', 'gQAQOomIgJyAvTYWQqtS_oQs5QhpEuT8_1593938276');
INSERT INTO `dd_member` VALUES (342, NULL, 1, 'oWwx95UNAekkTp5PBYEkq0hn8UA0', 38, 1, '下饭', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'WVSsyt9gJj67mcHjp8KqyyE9mGMNDyGC_1593938665', 1593938665, 1593938665, '2miFQ9NwmZ_v_zYYrJ7KybiAautCcgMs', '$2y$13$MU5Iz//NNHV.GuVQySkuyuWuHJKV5amGzlwLhkjfP/raEMsF5BxpC', 'f6E9Wf1ohLK-eZ1mARg8LFem2GXYcTVz_1593938665');
INSERT INTO `dd_member` VALUES (343, NULL, 1, 'oWwx95Vhc4LBj2Dn9P73in01Cd9g', 38, 1, '秦步苍', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Xm33FELLl3T6lLmU7uW3UW5sCjvHzf0v_1593939205', 1593939204, 1593939204, 't8OI8e_L3lvNM1SewNhnQa73ZelARetZ', '$2y$13$K46xbfcncLxNlJjkyn9SIOUBwRWiJHpeNY/rRW/URLzlug6y5tCcO', '9RysHhLMmHe5gSd-eagWTxDymZAHAsEm_1593939205');
INSERT INTO `dd_member` VALUES (344, NULL, 1, 'oWwx95TSaVDJ6BPLcRwhebSkJpao', 38, 1, 'JoyLam', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'MB0e66t6uf3X6Vlb7cDMXWbNMjN2kH0T_1593939261', 1593939261, 1593939261, 'FubIw1ICpx-2fayxD1838eJySBN4fCTe', '$2y$13$rhAvEayq.sLLceXo0aogA.Lm4Z9W3skfmhtyy000BcoXh2rhTm9Lq', 'z1Qte9cYoJUFR0DVfNetpeIULYFpK93A_1593939261');
INSERT INTO `dd_member` VALUES (345, NULL, 1, 'oWwx95bCwMp5P0jH-PVT_UvGbtCk', 38, 1, '天道酬勤', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'SVW0h9bjeLm-AxP0Ez2qpWCzXScvQFpc_1593939670', 1593939670, 1593939670, 'R2dK7I92B0C05dlLiqUh2l02uiZp60Or', '$2y$13$bpnu8FD4rf8lz5/lF2yYSuLEzxMK1.qaCOGo4mcdfSoBtBw.9y9ti', '6UpF9UJQCUuwOpORPXO6F9AU3PibtaZb_1593939670');
INSERT INTO `dd_member` VALUES (346, NULL, 1, 'oWwx95QTic1-xMVqhDaTMPlfU9_M', 38, 1, 'liang', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '-MUMelmcFJ0o4bMJKWowMmUn_thk0sqv_1593940968', 1593940967, 1593940967, 'R0P967EsUJux93s7DD8jevCztQ2bif7e', '$2y$13$mOlwap6CPM1W/CVuUCBhgO7rJYsNwCOLqizWyNcXqT1b6sTggKv.y', 'pKfloPZrSlBg2w_HGU0619-4gRAr3xY0_1593940968');
INSERT INTO `dd_member` VALUES (347, NULL, 1, 'oWwx95TL1NuzD3tms9tmtczgGaXI', 38, 1, '黄丞辉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'r9HI3vLOxnAWgfLUkAj9LtCn6H7PW9rF_1593941281', 1593941281, 1593941281, 'SPRdl8HcGEpMvlMpyC2FvoYWvJ0dfdu5', '$2y$13$yrxZbwx5iWEtHZL0Fb09vubEfPJI9EG3MxCMl5UHZCGnWF9GqTHie', 'pgx2lAg0HIL0hyHVpTuVp_j1XXAqc-oz_1593941281');
INSERT INTO `dd_member` VALUES (348, NULL, 1, 'oWwx95cJlIktjcpewYxVcfYNjA3o', 38, 1, 'Apocalypse', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'LrtxYkp--TKegJPo_6rrA2yLMB6nRm29_1593941923', 1593941922, 1593941922, 'qQ-FKH54QB9JLtOcItRsKN78SVXCDc1K', '$2y$13$dR6kiFXjsNKaMdH8wdC0hu3LLh8yEdmQFfs1neveHglJhxMjc/1dy', 'bKZmokS42UGhE4Z5IbxHsF7pOpEAzSxW_1593941923');
INSERT INTO `dd_member` VALUES (349, NULL, 1, 'oWwx95cJlIktjcpewYxVcfYNjA3o', 38, 1, 'Apocalypse', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'hKos4h_bEjdeHcIq_iHs6Y8v8xDqQXVv_1593941923', 1593941923, 1593941923, 'qA3IkHEwC5Otvge-X5UjzYFH1QQ_fScy', '$2y$13$QkkcgHymXmt62T7SbYe0BO1iTarzT.C5XZG1E7qTMw7jT12WOP5Q2', 'LEBGO4H1z10w4cY7-hsxqUSQ9psyrb1K_1593941923');
INSERT INTO `dd_member` VALUES (350, NULL, 1, 'oWwx95Ze550ftQnYXt4oaeGbWePw', 38, 1, '温@13288826007', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wG-SdIJJKdO3JFdavk124C7ZgIkvY7yZ_1593942461', 1593942461, 1593942461, '47FZtIr3MROscszoY8a9fh3S5W7CGKvy', '$2y$13$BHzknWKbkB4hWEF.FF6XUuyz0WmyV1uwsft5PNHCcBNTaFchavuUK', 'uJoMlwrdNpgLFt4uEug3UL7HLLyJUEqF_1593942461');
INSERT INTO `dd_member` VALUES (351, NULL, 1, 'oWwx95dlDb6eZthHxVy3YLicZfVo', 38, 1, '陈生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'haPduUQtGtdnBFTuwy9pbJq7iFEi1V3G_1593942903', 1593942903, 1593942903, '04B56GwjhFBiqPPHpXIn5K_XRTHi5WSh', '$2y$13$eOPWaNRoIzdiD68E5L5Q2uj8BZvxHl4/SwgQTLBPZN3GFAivI8vVa', 'HUttiIeDeeIy3Y1Qn2T_xvzQ68QUMNln_1593942903');
INSERT INTO `dd_member` VALUES (352, NULL, 1, 'oWwx95cHvRegIhVYjr1KdZkmzENg', 38, 1, '江湖夜雨', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'eUNhp_QNxa6Zry2O8hj4QACCR9IEG2Vl_1593944855', 1593944855, 1593944855, '1me9X9JHLO9m_2mQGOcNL3-Z3-AREFkF', '$2y$13$0hAdls.2jdXIhVTLb495uuAP.eMsh5XSjAj8JdeGO4PUIlqh6b.LK', 'E8P5FDDORb1t1zuYYYmzKBd52zXdAbWn_1593944855');
INSERT INTO `dd_member` VALUES (353, NULL, 1, 'oWwx95WdzAt-6WFe4N0cQmYu-hEk', 38, 1, '巴黎的春天', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '_IrH_kQj8_u8EjWD8gKi-ZvpeSQElJ1r_1593946183', 1593946182, 1593946182, 'M_zyQtW1B64IUh0aFj8p2iGnHSbZyryv', '$2y$13$kvD9hygoQ8ojyrRI0cwZY..vsJda.1UFup1tqe8lXhh8aThuT89lC', 'xRC77iBo7_4d0_N22F8acOfCS4IKSOhS_1593946183');
INSERT INTO `dd_member` VALUES (354, NULL, 1, 'oWwx95auUAOxHSWQcSBblu-IgtX8', 38, 1, '阿乔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7IrO5cT18MCtcWt23G8XGg_Juk5YOGlB_1593947214', 1593947213, 1593947213, 'FRjfhauI5pOKYuGg6WJmWwcKAdKc6Y0-', '$2y$13$XIxVe6vX4MhrrJHIPYpIyOPRSlEOV7v1YsFL8D8f.1tiXmwvpnxoK', 'NX-u-DVR_0W5HXQUcH-MPP8VMeeYzIPW_1593947214');
INSERT INTO `dd_member` VALUES (355, NULL, 1, 'oWwx95YSXsjOPTtz5Za25XoMLB4w', 38, 1, '米贵', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'nLY5PTBvdTBvJM1ZjxCGqD4bxdGHaucG_1593947429', 1593947428, 1593947428, 'vjshbehrN9u_0AW4bDvG8DtYMi32SgrK', '$2y$13$TgNlXQ8GW8f1uGHejWvY/u4oKKiTrnyFCuxQIzcPKkT.q1GjGft4m', 'U7J5dycQd1TqYwCK1fE7yzo34yz3pecA_1593947429');
INSERT INTO `dd_member` VALUES (356, NULL, 1, 'oWwx95RDWZQ9s49KNvm2zq7RZVbE', 38, 1, 'moyu', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'l1K6UqD6BXMLaHaXhtaV0y7Uw04QNvuj_1593948021', 1593948020, 1593948020, '4C0YC9lO75wjVY46QXS5eq8mnuRMPlcg', '$2y$13$o3tGNm.DUwnH/ERSDFmgbOSqDy67q82dwd8.EbmYoqKlk3lWfaz2O', 'XQ3aePHxNrzKnVeOMVz6WvCeplxc-Mbu_1593948021');
INSERT INTO `dd_member` VALUES (357, NULL, 1, 'oWwx95ZLpAlnL9I9dOpm4i2SdEqY', 38, 1, '偉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '8BdhvzdxAxcIAf0qN2v1bx2xUhaU23w8_1593948173', 1593948173, 1593948173, '6J2WGmZV9rjBDuA4nM44SCrSuHrmQTG0', '$2y$13$HdKF9qRdVFI2ZAnpnRUUv.o7eIL0ejl2H6621kriQLEFwN/o3o0.a', 'tz4-O87xTqRPsfVmxBL0WTV0Mttro1Yw_1593948173');
INSERT INTO `dd_member` VALUES (358, NULL, 1, 'oWwx95bObt-npid0s5wn1f8taLHU', 38, 1, '琪琪', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wLHXM2GFnlJL7aSkY7zwdxRe_q5N5Lzx_1593948430', 1593948429, 1593948429, 'DFzpUfhnYWXypXO7fncOdK2aFnJca5HG', '$2y$13$zzBaWyxpESG9GGiFM4/gnuM8t96CvrS/l4ECul8qOV5tdijy/8GLi', '49FBVVCJ3PdClWVkuF3N-Gj1opbGfQ4N_1593948430');
INSERT INTO `dd_member` VALUES (359, NULL, 1, 'oWwx95ZFmHEuuFJ06iCpLxgJzabU', 38, 1, '峰芒毕露', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '4S1RLdpb593zK8oILNZdohYJjQjrwdAB_1593949026', 1593949026, 1593949026, '_XwYcBWWIZUsOXgSrXEpp0lC3pFm3Hnu', '$2y$13$0oTUY5gjIN8uMILJ.FFRkefKdYwfV8fL3SaI0RVcklW/wpA8OCPw.', 'EBf3ORiETtJnoE7_y0lwHg5mU1IylRC-_1593949026');
INSERT INTO `dd_member` VALUES (360, NULL, 1, 'oWwx95WDk5UfFEc-2RIqjqF0VYYs', 38, 1, '卷卷卷卷', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'lhDld9uf-oylwPhJgE_1FYZUkTnUrkiE_1593950189', 1593950189, 1593950189, '5CNAhJcSd8wCIyrCL3oFzKxf5o9YLi4h', '$2y$13$0Poqzt4IVOcvFOPYsPp7g.CmRVuFbv1LABClsbKRk7dHyAcH35pLi', 'LK4UKhcJkLxZrf5UPfrg8FG3sUhUPXSx_1593950189');
INSERT INTO `dd_member` VALUES (361, NULL, 1, 'oWwx95QZU7mSzWW_PUpt8lnEny2Y', 38, 1, '蜡笔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'hC1lpY5hrlX_BCJ0DUojCgDeLXo-rt5x_1593951118', 1593951117, 1593951117, 'O77a4tDlcBPli9RlTyybnIWyo8hesA2q', '$2y$13$uoyz/mBSpGixh2CLHzB9oubzcmH5cSAGlcMmvqUHLzqmT7Qb1xf/6', 'AT2qry6OohL2U8WbKA308jEjqnEwrvbb_1593951118');
INSERT INTO `dd_member` VALUES (362, NULL, 1, 'oWwx95WCZuME8gu6PsvrMX2txSX0', 38, 1, '。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jF_2Eb-r0AwgcgU-gSXIHHNhVTLhuido_1593951348', 1593951348, 1593951348, 'oAhbT3x8lDUpjXhUhYcXLsyBzH3bU26H', '$2y$13$3W.RgWqUhY4XX4KDRsemeeP3VQBRE8KRhPGDL1phE2j5KLpduAnda', '3UcRAmuKufsg2-RU8Xics-LneOL2ppat_1593951348');
INSERT INTO `dd_member` VALUES (363, NULL, 1, 'oWwx95U_AKVpkAMxlxuK7nAFY6KM', 38, 1, 'Ambition', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'I56E-yWdi9ZvPHM2O_6SWVdugYAhN2AU_1593951949', 1593951949, 1593951949, 'h1YJOwD7KcmMJU8C_9y6hy989oNHaM0h', '$2y$13$GNUcbGwjwPYD8VduNarNCucOgFiBinEFlQCw7LjyTAMJ0tEvy8pFC', 'RYTREEW7tHWBQTHgYzxH9nWyY3pxaemm_1593951949');
INSERT INTO `dd_member` VALUES (364, NULL, 1, 'oWwx95WUGKUod0p1SzmqGA60t86Y', 38, 1, 'atom', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'LW6_1i6HLoqgWmXjEmE91u9Ay2Ovn_iF_1593953513', 1593953513, 1593953513, 'zno3HJ7yje9s74vVMHPartDri3I-9dBo', '$2y$13$TLVUFD3ZaRyX1U/0g5fqfexBpnjupgcSm0SseiqmrsVrGTo6dbWeW', 'eFRXZEPZAKYVW-nxk_FwnON80R612JAn_1593953513');
INSERT INTO `dd_member` VALUES (365, NULL, 1, 'oWwx95QkFpQamegonOCTAO2syqJY', 38, 1, '弘毅', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'nLYaV3io02bjsu-JZ2lIOYOYELhfKrYL_1593955230', 1593955230, 1593955230, '3ZYjXzR1EfayCG6vwkVT1bBcAFCr7Tqu', '$2y$13$XQEenGOXznTBKy1ROYt.Q..uCQSt3xQC..aS0wGBxRTuhLoNGrJ2C', 'KTjiUEOcI5St0BhTRcilAwtapzsU0OXL_1593955230');
INSERT INTO `dd_member` VALUES (366, NULL, 1, 'oWwx95f3LeXys-qlKawzv7dnAOIE', 38, 1, 'Smallchris', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '74Bvrur-_EjaDgWjpg9BoKNtNSRs8e6O_1593956920', 1593956920, 1593956920, 'WC7ory-cFUkVIs8_K_lMkjc0J45ITq93', '$2y$13$8D3zWMepl9q1DUHEF5hrMubUElHiwWLCygneuDUIaWgpLe4umFJsq', 'g2mIwviCcjOVsyYpiyIBN-dno787_XwF_1593956920');
INSERT INTO `dd_member` VALUES (367, NULL, 1, 'oWwx95W9ZwVUtjrZmFpAfkJVyMbg', 38, 1, 'A白云阿浩', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'nnSmDrJQj3MY5wsEZQZh99TSxVQx8iMN_1593958131', 1593958130, 1593958130, 'dC7vCj07NH1z3F-s4-GQqv7edzcBHsjW', '$2y$13$CYQILx5CtxWe/4yGzaFZvegQa5Z0MupIguQo17YTECp3OFDCaJcZu', 'c7Vk543tPIyGppRNi5B1YO2bAYYhnGvM_1593958131');
INSERT INTO `dd_member` VALUES (368, NULL, 1, 'oWwx95cdG4v1bqwppYKM5SmbBOHg', 38, 1, '想上王者的菜鸡', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'C_2sCkPXfYeMm-FQA7WQWGv1nOzRjdae_1593958310', 1593958309, 1593958309, 'K1AabDLlslnJOXj_vJhvVgl2ZFZWHb65', '$2y$13$gTW9C9Dp7JXZiaFW3Ix4jOC1v7CfOaD9YwP7J7uUaYGp.7sjUlilK', 'z0gFgzcSaIFza6WfxnRcfUvSXZp2RBEA_1593958310');
INSERT INTO `dd_member` VALUES (369, NULL, 1, 'oWwx95RUI27Xs76VKxK55hCIaMbo', 38, 1, '范金林', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'BPvl2cPjJiKVvKBpVPt9C7YfwqT_62Le_1593959460', 1593959459, 1593959459, 'jbX7gVvdnRDE18Ux0ZKe927DIIAknMdz', '$2y$13$WWRKC3AnvFehyk03dkjEwe4LnundN2ZOLwxKx8xrHvRRTi2pv/9Ke', '4hkOJWTqHB6pqPnp6UxQ8vHi7WGw0w1K_1593959460');
INSERT INTO `dd_member` VALUES (370, NULL, 1, 'oWwx95Ssm2NwgNbt5c6G4USSCams', 38, 1, '重视治肚饿', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'U2erzX_NOee0PPI79piO7qPVzQe3D0ik_1593961295', 1593961295, 1593961295, 'YTRMNkjnjkGYsDwDBagLUi_tL5JS6vKZ', '$2y$13$acD2mkJ7BywRunreN9EEcuNlSgn5MTOck3Xrtl4ExTEW3gpY38C/i', 'XlSbVrG9vlI9rq_bzQyyqGKtH5xXy0J8_1593961295');
INSERT INTO `dd_member` VALUES (371, NULL, 1, 'oWwx95dvgkq8hwLjLS-D-VhRr4Xk', 38, 1, 'peter大雄', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'rkspkgUG-Oy4EOj7gXazlCXoe3H6Vkxl_1593963299', 1593963299, 1593963299, '7MGf9Odi-1ZYbzxP5v6ehrSX3WKQ109G', '$2y$13$bScCo5YQX1iYYDzMrK69COODmDPCxlaQY25W7FsgocDJjVCPbUZtC', 'ENpneBtvja0V9ygRctfMjCs21l00oLqt_1593963299');
INSERT INTO `dd_member` VALUES (372, NULL, 1, 'oWwx95YsurWIHz21WIVzmEFRJ7mw', 38, 1, 'ads', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Mq_-0NxAPa7jY_tHw5zzTiV0NiMkHwxx_1593965015', 1593965015, 1593965015, 'uyRnrNlV5DpkEoX72DjZxBHCZfUkM6oi', '$2y$13$iPTlTAyjtUpVAWrlJg3YJ.D3c.aHGb/uiefvAn7CKzx9RfJBMCiqa', '3J2VWYfM_oZmPbPGTAU4Yjq-czXQQE_l_1593965015');
INSERT INTO `dd_member` VALUES (373, NULL, 1, 'oWwx95c5JvkpEho9KE7uaxSKd7i8', 38, 1, '吖吖', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7y9K-TsE80IxUWqSUMn3uIaZPZDJiPHK_1593965774', 1593965773, 1593965773, '7n77KFEeMgYeNfVIpD-krz34jBvYSuc_', '$2y$13$Hso83fwQxckSclLHtjWhNua1.tATO/YRXhWQHt7TAhFNapcqSTiaq', 'MHscZtMX5XMkqEkO83GE4pypIiJxVGBM_1593965774');
INSERT INTO `dd_member` VALUES (374, NULL, 1, 'oWwx95WtvwNu3C1PYYqizFf51k7M', 38, 1, '哈米仔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 't9FtNjltcQNZjB0bgLbSIQCjHuOAOIPq_1593968877', 1593968876, 1593968876, 'Du6YdXJFmvCWMcCHW8qUB4cf_x5dtOvb', '$2y$13$pmY6C9Tgu2VOWID3ZpHL0e9TGPuMiKLqF.Y/4Eoc9GPErFrMI64dy', '1-OpVa2295S9ONix0vDUqjigUq51MQLK_1593968877');
INSERT INTO `dd_member` VALUES (375, NULL, 1, 'oWwx95TA-GqTIoKLZEW3263wzB1g', 38, 1, '女人的眼淚都是男人的罪besos', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'oBOQy3l-S4vnKFvEWhG5RPKshgc7OXhT_1593986478', 1593986477, 1593986477, 'BYtFfcOMT1Nz9jhFYLkUSFy_ZcMUfo1J', '$2y$13$KFj5NaGOkMJAfVvuTy4Gh.bmjN627u4N6BAzbsPh5IhseHZ9xyhj6', 'JXrBJEpW37iMzUlBVq2aHsji06vaqlkT_1593986478');
INSERT INTO `dd_member` VALUES (376, NULL, 1, 'oWwx95U4xREYBja2MoWMaQJJd7e4', 38, 1, 'Fy', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DmNR15daK43tF83AuFFkIRhi9zE1BKVC_1593992856', 1593992855, 1593992855, 'BOCF3ve4OwnIvDyuKu04q7FYvG6MDffL', '$2y$13$L7VyAr4nuT4cvAFoRBL8YOCQ1JHmNelR3naNJwfe9sO5gmhOQ8Y8C', 'Pau4dElGbtWRAwlZm_Xh3plOcGm8_a6z_1593992856');
INSERT INTO `dd_member` VALUES (377, NULL, 1, 'oWwx95Y9nWkj9N24PsYGv4gnciO4', 38, 1, 'RO乐观自信爱', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Dlfqj0pfSVfYvdpLQYXamNy9epgPdT4P_1593995234', 1593995234, 1593995234, 'vwmOPa6d6NO_J86ykrN9UqPHnmLKsLCH', '$2y$13$1nNNfumIqRH75TvZeDyrn.D.SUbdK5zZXDTra8CsGYLEKQfeqpgD6', 'QObVYqcPT0PsQ2rd77mHkse5r8XuvxiR_1593995234');
INSERT INTO `dd_member` VALUES (378, NULL, 1, 'oWwx95fic3zWjQFOIitNiVTYbG3c', 38, 1, '往事如风', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7S-M9EbSMtz6SOVl056ogEE67Me5wbSY_1593998509', 1593998509, 1593998509, 't65nOQeiY6cvBeznMBbzcW6wxeEmrfCF', '$2y$13$zUzH1uPfjcfpbOk5ORYaDupkMVDyVz3GQlsYi36HzLR6netPBwmRC', 'yngrFAXzwM8oIQ7xPKWYE7EgiNtvvJ6X_1593998509');
INSERT INTO `dd_member` VALUES (379, NULL, 1, 'oWwx95UUus8qk3qkuwa_tsE78waI', 38, 1, '大雁', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'GF-ILb4t24g2kYdefOkQ_uujj4G8oX_1_1593999757', 1593999757, 1593999757, '2G902pibh4fZElm9AXZQhZYe0-_hHQpG', '$2y$13$DZTGDocXMMLq1Sz1Oo0kY.Qlh/33MMADq2wkrKthkyvP8IsnUBWa2', 'Cf9Aw19-FStfUzA5QFkpoWRlTXpHoN6W_1593999757');
INSERT INTO `dd_member` VALUES (380, NULL, 1, 'oWwx95UUus8qk3qkuwa_tsE78waI', 38, 1, '大雁', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'x9YOOv8GvqZryhBCHbgS358Bh88VExUC_1593999758', 1593999757, 1593999757, 'nPFcWzjMMYwkiwP0-A_-9xsptKQh0iAF', '$2y$13$CGIeaBCRd2VQAQ.jwDgCLOV0..wbplAo/FWMuD7IR2M8ewJr5kgIO', '8nJKPGOLAd4mBuSxhgcGcpGlMH5X2q1W_1593999758');
INSERT INTO `dd_member` VALUES (381, NULL, 1, 'oWwx95UUus8qk3qkuwa_tsE78waI', 38, 1, '大雁', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'OLLuBx0UuwfulXhoOl5w-djvSPtOKR4l_1593999758', 1593999757, 1593999757, 'nDuAfnsIzKvYVv7ev_JJEFZ7uYJHYzEL', '$2y$13$0g4W3ZSu1f2/lbJWv/LbQu0C2gYnEov44e9CApEhfO4K6RepBSaVK', 'Ub7DHe44GJtIBxvDFyAfuxZh_dNdciIL_1593999758');
INSERT INTO `dd_member` VALUES (382, NULL, 1, 'oWwx95cxQYVB0dprWMGBU4mgXRWg', 38, 1, 'bombomb', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'h9HGo4NAZws8BdcyURiyQ2Sp_xmkSRyY_1594001811', 1594001811, 1594001811, 'k5UWkvndp1qxG8hZa6YsP7TJSpVKeJt7', '$2y$13$I5LmMW7WgCBMr/srRgQfpeFEkuA3np3zexv8Yda0q1lmnu7ZaV5ne', 'ZwkBSTqEabLOg7bqwyha38yWlQ19_Ltq_1594001811');
INSERT INTO `dd_member` VALUES (383, NULL, 1, 'oWwx95Q6KNe5-kftnSmG3c50laj4', 38, 1, 'farcry', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'B_Ol2DQrtf-NE91TzLByw6IW2Yl5GcCJ_1594012216', 1594012216, 1594012216, 'OUapkm01wKNlrOP9TkoN49f7F0jtMC9t', '$2y$13$1Rm6q2occ9FGoVeCLh64GO3QWh0Al03R8bYNS822aOIzOI7rTYEyK', 'AFJagm0rUHWz6ZKmJKeW_01N8Q0QviHS_1594012216');
INSERT INTO `dd_member` VALUES (384, NULL, 1, 'oWwx95UzYjpI6io899o07X_atN14', 38, 1, 'Martin', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'j35RMVzUv-lXLF0UJfRSdfANrRF3pszQ_1594014039', 1594014039, 1594014039, 'sLKifHQDwX7VRAJen_lBsJok-mBh1fzI', '$2y$13$YtIwbksP34tki1uXCBaDU.azcfH6sMZzbyuYmDmRaLSh.HXx6v.yK', '9blUMpF374RtNArjTMsM3rQe7-xfrYSx_1594014039');
INSERT INTO `dd_member` VALUES (385, NULL, 1, 'oWwx95ZipwkKuYFsIE-3rYRkbDkM', 38, 1, '红鸥', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'crrcVu-IphPqRbKRY6MYE9lJhZGzpner_1594014144', 1594014143, 1594014143, 'mcb6hKZo1IumSObK4VOEvNT-Ulr44W14', '$2y$13$9tN7CkqCTNR5fDvE4muV3.OCx2rKHcWddzaoqW6cGlEH.kG8u6Hy6', 'zhvdRtq3Gbvq3tMWdsxmqcOQ7yaafk8b_1594014144');
INSERT INTO `dd_member` VALUES (386, NULL, 1, 'oWwx95fjylE8RPFt4AXmMs5MZOo4', 38, 1, '德健', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ZAMLOa5-xPO3Dcg1DOA78IxPW8jY8CWz_1594034037', 1594034036, 1594034036, 'CZ2MmZNbqk-ctlecW8p4KzucYsEUmhbS', '$2y$13$Uru/VI68PEBvXJcLFWBflOlLZHT/4unoQpK1rFKWhj8Hr56vRb8Re', 'qehshOYS0XUMPxvSf-oH3n7G_KBmNPMm_1594034037');
INSERT INTO `dd_member` VALUES (387, NULL, 1, 'oWwx95QSEu23shUFlOFC7iFgm_bE', 38, 1, '人生如梦', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'TxHXMpJqHNgLE4EvTROZNOR7jMxIVqkv_1594036072', 1594036071, 1594036071, 'z1jZqfJ2WbkQb2b_-NOAlqmcMBaVHjeP', '$2y$13$IcgamllctDxefw4Lvpnqxu0Kiqi3zF2AXMQmAJvi8ZJDi0Qs2NP86', 'bQcdifviqiK4gmYqj-ptDeV6z62cJbIi_1594036072');
INSERT INTO `dd_member` VALUES (388, NULL, 1, 'oWwx95Qjbq6XwMUShKkLGhZAopqc', 38, 1, 'Ken', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ObBPRlnzTC62VU40kL8WkgJiB1iQpIjd_1594037538', 1594037538, 1594037538, 'OPkV8W47moJOJOkmwJykh406iHETU2G9', '$2y$13$gOS6N6QxSENFu.J9844tE.e6rbClGv8JV/3LpK5HIh6rlj5PhSP3K', 'NCQbqAfMwBLGMqocreiMVldTfMLtNk2r_1594037538');
INSERT INTO `dd_member` VALUES (389, NULL, 1, 'oWwx95Qjbq6XwMUShKkLGhZAopqc', 38, 1, 'Ken', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'I1NcvKrbFG1wg5bQKrziepIDbIKEOiey_1594037539', 1594037538, 1594037538, '_PvWaLn1HTCdaR6RxXy_fWefeTUHXkmo', '$2y$13$aaOtnYc6rWM7rAJbnjunD.M1D02Nw8/tdY5Hf0YiIKTlqXdpSfqg.', '5XJmzaAOKGon_3x4NsItK2jyQFLfF77U_1594037539');
INSERT INTO `dd_member` VALUES (390, NULL, 1, 'oWwx95WtxbV-uQRmsagCFJ1ouzek', 38, 1, '单纯，小男孩', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Y0WpDlWU_U4Qrx-8JullIhRiJ5oQ6uVx_1594038811', 1594038810, 1594038810, '8URoom-SrfoPNsK8hoU1F0onwgHsD__E', '$2y$13$noKMOQmQMitIKgRSqGeZOu1H2V5jiyvnUI3sEd.hNNbpOBOT1lMt6', 'KI_ReEK83wxJfp_r5JfWfnXHSKLYBGPV_1594038811');
INSERT INTO `dd_member` VALUES (391, NULL, 1, 'oWwx95WM8urOg9SF3qcdzuT5_4b0', 38, 1, 'vousmevoyez', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'QVG8tY6z4yDTQUdXRF1OTfcB0UQ2f5oa_1594050462', 1594050461, 1594050461, 'CcsWcdnsUrbyC-WuI3xjiP4_zAw9UE-g', '$2y$13$y5XWRfAn0OVHiXSeQNB.fu/3cviN2cMUz78RgsMdwZqeHvT8tf016', 'rwUaMBpVg7c5erS9oLeEOtlRmGI_esXK_1594050462');
INSERT INTO `dd_member` VALUES (392, NULL, 1, 'oWwx95dIs-iLQ4bu48345OaORxvs', 38, 1, '阿巫', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '7YBaNcixv0_yVZOD4Z-JDAMmMDxx6sCB_1594052341', 1594052341, 1594052341, '_Yh9uOwu5NSH1fxYUomI94WSHBa3aQJf', '$2y$13$8c4lmcbWMzi6iOhIpmkJD.20fd5cH8P14r.oIpwF01iEJpRA.JiHK', 'r9AH7eVz_2kSZz0DyvPw-mTqyyBu_rhJ_1594052341');
INSERT INTO `dd_member` VALUES (393, NULL, 1, 'oWwx95b7o4ZptmEoIDbTLHLGffHk', 38, 1, '我能', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'TF-BIPX9KeW4eIWMnEQwu01Jq3a9kN6d_1594078618', 1594078618, 1594078618, '05l9UHUjQFb3ZOant1WaahsmI4zLmeie', '$2y$13$XqZRJgXFdH3I2J9qK7GGf.KbYmDAAW1x9ynT3PxEuv59MxPAhJPX.', 'FGXrFWyk-Y7Utf-QC2b_KRCJl3o3Hn9j_1594078618');
INSERT INTO `dd_member` VALUES (394, NULL, 1, 'oWwx95aU4eNDRrGd7kCmpWfuVB04', 38, 1, '张淳珠', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'YeGzxNsmbsYP3MbZ7JTNHK6_qLEniw7p_1594090533', 1594090533, 1594090533, 'zsCmzi_x1dx49MEdEsf88tsMIOh_Kovk', '$2y$13$kSvh2GcpNgVIvnJWJBiW3.je7Z4YVieQX22tr86tvDN0hFsTewqoO', 'iJiCwFj1HV5XabD7-MY-dCHT3S9RFpjW_1594090533');
INSERT INTO `dd_member` VALUES (395, NULL, 1, 'oWwx95Q3-BCBWnqFAb88VPY-9QHc', 38, 1, '你别皱眉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'OdcBboZD5IlWXl0eI18gKxPPfe7tuDP2_1594097732', 1594097732, 1594097732, '3wHUyPtM4sOP6QLYClFeTO8TSXC3Vg7p', '$2y$13$ZkVrohmt1jqJ0ADmAFli..wtW7xuB.vyTQ7QAda76un5J36d0XGy.', '3VrLJBzHNCYSnggrbPtwOLUgX3MB4qXd_1594097732');
INSERT INTO `dd_member` VALUES (397, NULL, 1, 'oWwx95TjI2Rfp_NItHO6no7UDCzo', 38, 1, '益母草', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'IFrn4bEVEdEGjUsGoWYUrs7rOMA4FiCb_1594111786', 1594111785, 1594111785, 'ivywxtLw1fQ0wC_TYlc7jfWynSgWD5NT', '$2y$13$IH50Y1guyP3awMyvOMl3T.MvhwU8.ZSOyOgU24LITy1myMPUo0fdO', 'uhYiiryLAAY4fTYKXsh-AMAj8jztXC08_1594111786');
INSERT INTO `dd_member` VALUES (398, NULL, 1, 'oWwx95a_4X8wrhNVSCZg4JU9G1nQ', 38, 1, 'Hong洪', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'PenU3FNBaHjqSu7ts4ZrYmXFCPBXTue4_1594112113', 1594112112, 1594112112, 'cUz5B3En7nh2ioeOnGNK5tydo1i3jLX3', '$2y$13$g8WHdgkagtjOFvPDZJU.Xe3O/jp41N6u4XeffofpTsBb1wgLmfSaq', '6tDMiC5Q7aYdXuLzD0tfpqsEHR7Pebls_1594112113');
INSERT INTO `dd_member` VALUES (399, NULL, 1, 'oWwx95eYknZ1ekcNTUZsV4tTFobQ', 38, 1, '游', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'mhY7ntxRobOEPnikkM15zzWYIRACnj1F_1594132699', 1594132698, 1594132698, 'Ns-LvCSt4jUO5nZZRsUP45dsc80NUsqO', '$2y$13$80QQrLOI8LTmTIy4EKcq8eo4eSTYYFE0vK0.A.MjYXubEg0kbTQ.m', 'eBn2o_IytHWoS9wXPdqWM-MFi2RZek3o_1594132699');
INSERT INTO `dd_member` VALUES (400, NULL, 1, 'oWwx95d7D4Qwt9YdS7b-68Pn4RjI', 38, 1, '龙行天下', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'MGkeZ5hpIvNqqO5GNeiRP5rpzQ2GOL5Q_1594140135', 1594140134, 1594140134, 'u9f8Bm1mo-B5Lh-p4sQSBNAtYtPNgnGh', '$2y$13$tQ.fLr4ER23xBr.6GffznetPrBDB5HVhOz0SIUo5oahZ9w5WvJAri', 'khk1Lv5OjyshKu9gB22z_8QkNM9p_PZF_1594140135');
INSERT INTO `dd_member` VALUES (401, NULL, 1, 'oWwx95dnuI6zmPbTMcr1epZDBxqo', 38, 1, '郭子扬', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'qfy4Lz2ttjUocmg-sLMdSGb3zuSFeRrv_1594189196', 1594189196, 1594189196, 'MvJw99dSab58rarc7iXMy97-EynvREKW', '$2y$13$2QiFSiX7Pk.Qb6S8w9mNieLuPdu80ZkAdPP6xbCBbRkpbpx8SIoCO', 'EM-cMxBr1i9MUSN1cXyaIR1mpyWTYs0K_1594189196');
INSERT INTO `dd_member` VALUES (402, NULL, 1, 'oWwx95TaY36SODogDD18xnWEcMLQ', 38, 1, '施丹', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'SFkDqqHDN4qPrnyYn0I7f0PskR5Ikp2H_1594207181', 1594207180, 1594207180, 'cGa0Wo4Dq1Reh-FciErJqFrZ23dwwTEL', '$2y$13$2FFc48QhhiqimJB7w/FC9OKA3rclIqk75cwZ7VBJZwGrCZOLMboG.', 'C353ojHtej9iQZhdxm7YTlagPNei88rL_1594207181');
INSERT INTO `dd_member` VALUES (403, NULL, 1, 'oWwx95RfQzygbFELN2wHaKgg321U', 38, 1, 'AA、Mr.wen温', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'QI5hD3FmSjIG_OohQzKg7T_z3Ha2phTZ_1594209346', 1594209346, 1594209346, 'D7aQpSbVE4dWfM0Y3W4v2miEDhK5CyHe', '$2y$13$rnHZVTNqRQmeDxULyfjWO.T6P5B1e.WF.dSBXdJ0UpKPOPN4EGnPO', '3NFtm6NMMP3dVm0ZlawKYNEMY7YJVjTG_1594209346');
INSERT INTO `dd_member` VALUES (404, NULL, 1, 'oO3nO4g0FJrWQ23lrIx_6gydcnmw', 43, 4, '王春生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'dUFnkgKYODo--PQz4zE1XWSTWCqmDvaX_1594286938', 1594481259, 1594286936, 'PbIfBXPxeNt2o6v7yde2JtYCezECdDIk', '$2y$13$jWKW7R4UoKUx5rvOAKJ1LOIlOC.ZeHm00rHvc/.7hkj/4T7MY/R52', 'burqWfhZG-Wzf54dO-csJUIBeLt2O49__1594286938');
INSERT INTO `dd_member` VALUES (405, NULL, 1, 'oWwx95eUAUa9n_OYTV97vIwdpjD4', 38, 1, 'Evil', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'HqhUvD8vMhpYwdLGOzF61Dr2ksBRqXVK_1594295254', 1594295253, 1594295253, 'jZPfcvt7rcmRolAzqS7zanYhWisjzn27', '$2y$13$UGAP7R60Fkr3wP/qCXebz.jhAljM6GYtoT96r3wf9JVYceM5o0fvq', '2zLw20Bkk3X5E4AwTCsXBBth_5oB31gY_1594295254');
INSERT INTO `dd_member` VALUES (406, NULL, 1, 'oWwx95ZcxrZPTsRASuphO2Sg1ncM', 38, 1, 'anyway', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DK-arTRMf89eAGRvXbNpkGEzP5KghVLF_1594316076', 1594316075, 1594316075, 'dfwxuImxF68DidNa4NvpJaxFJwcn0x-d', '$2y$13$yGzYSBJgb34WUONkTv.dCOTD8zDtB75xaXFjz.gIzoW2DGfaGC0W6', 'NqK4TWwQy7wk54db4G1eepdwnF4q6jQI_1594316076');
INSERT INTO `dd_member` VALUES (407, NULL, 1, 'oWwx95YrvOe-U98Juf-AwnCURw6w', 38, 1, '鹏飞', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '9kZowFIst-WtZA5Nzrnaemo8TlPXkpV7_1594317592', 1594317592, 1594317592, 'mRQV5T6lWp11VTZPRx9DkvDoy17KXYML', '$2y$13$gVcZZ7H1mbXCcDVwNcfywuP5MADmBI1pffYvw/FLQ8ryMjHwmjjN2', 'kBq8lY_pSSNUsJec8vYguFOSC3IGw3vI_1594317592');
INSERT INTO `dd_member` VALUES (408, NULL, 1, 'oWwx95YwkRM8M90Mi2SXqJg-9Qy8', 38, 1, 'hokamen', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'zcRgo7tAC7Y7KEQJJSaOf1P_STVSYsEg_1594336058', 1594336057, 1594336057, '2EtsK6C1b0CQvg5Et6DFktshZO8CzuC4', '$2y$13$LDbjslq.gIL6xiimtA8zIupOLtjZG0QvPNdmFKBACSkh4qwKkIhti', 'HDkih31Ac25ewZ4EaNVr7TGeBQej575A_1594336058');
INSERT INTO `dd_member` VALUES (409, NULL, 1, 'oWwx95ShTiiTK2pGmxKmqfgE7gSs', 38, 1, 'Night叶锐群', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'NM9hpomUJV_YMbY_S8U15c5Ujaq7nvQg_1594348791', 1594348790, 1594348790, 'HxS8QqUbmaMAvP-uQ9KmeRA901JzJm3q', '$2y$13$HYEmdb2aWwxd3lGAmpIm5uPhXsryelcfFOa0e5zsuTWnp4t1HPv9a', 'jeG4QWAhUOtAUE1TWkP9_wjICwiVDEpw_1594348791');
INSERT INTO `dd_member` VALUES (410, NULL, 1, 'oWwx95aMMCaJQK1tD6pD9LKKOEww', 38, 1, '流金岁月', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'ogRObcm1dKy0z-NqVLBt50hIRe_EnfqM_1594360974', 1594360973, 1594360973, 'EPcbfoWIknhHNU_BpJNawVy7lvcXISIB', '$2y$13$k.AnuNlzIPgfK9LHWjutUuSFIhvX98A9nRBmTLwWsgyHO/wqgfhpe', 'ZT36oVCSoZtb57LSRIKiFFzFOr_AtaqW_1594360974');
INSERT INTO `dd_member` VALUES (411, NULL, 1, 'oWwx95dKs2XO1lyadTdnJdDjZ2GY', 38, 1, '邓先生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DVsYAUsdlyMVFQMDSyPUWheGa5FqDJgy_1594367609', 1594367608, 1594367608, '5PAUi9ox2MsncIymv67Pl8TzKn0wsx5B', '$2y$13$xG8xa.84LX7JMkBfI1xFz.gAexspTtb1KIQ1d7Zi0BVqMOmBBve0a', 'ex9ieK95yhtm3FBuBvXdjsGVOg5AEA6Z_1594367609');
INSERT INTO `dd_member` VALUES (412, NULL, 1, 'oWwx95UkFtJfShCXlHLH5Ilp4SNQ', 38, 1, '阿泉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Ng2-kf6dJKeVnrAHbspn9vNPFIfQYwED_1594425841', 1594425841, 1594425841, 'OTGlq0HtaJbQbFeDU9tNZiPtuvivtlqy', '$2y$13$J32Z9RzTZhJj9Y3lSE1HeusYs2if84oJj2w38BJqDFqYQckVerXTC', '5zCwOR4zAYnT2pQfHQcaoPXAAMM7zM_q_1594425841');
INSERT INTO `dd_member` VALUES (413, NULL, 1, 'oWwx95RYWnfhDKnnATajUAqahEus', 38, 1, '小倩', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '-jEXdFgiq4Ewe-7teSoKyWXBFUG6elSn_1594529866', 1594529865, 1594529865, '-20-uiEqhI5BSUZfCF01gDsufOxFddaW', '$2y$13$b1e8Ls87mvKhCFfpAcKIwuPffs1lwU0JstLHbSCa.6PdZufPq/xsW', 'Ljo_TA2L6VdAtUrEO1kB6auIHdFv-MG2_1594529866');
INSERT INTO `dd_member` VALUES (414, NULL, 1, 'oWwx95YjNG3q6ZRiwCK1dQqWQwj4', 38, 1, '王彦霖', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '4X0mc3lW2n4ozm9sDsLmBp_4_7_41F0D_1594531638', 1594531638, 1594531638, '8vcScM8DicdPoEHatcUtA8FTnRUi-WCr', '$2y$13$sHOHgIAnIN0hYOplm6/rau25xY5/L2VqjktlztQ9fT4bU3jn0CpGG', 'Bg10pibfNw-u2VgrH3DQG_FyCpVbkMTX_1594531638');
INSERT INTO `dd_member` VALUES (415, NULL, 1, 'oWwx95dAWUrOdf8wjKUazkIvghlM', 38, 1, '福星高照', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '9a6G5nTbW1yxXKMy9LVrVGTlkOit-109_1594532744', 1594532744, 1594532744, 'q3IFyw1pgWdAte5ylScrXMUYXFTDPfIb', '$2y$13$zQkjq0ohvtoLgaRnLs0ofuiwphw1dLI7izceE7/jM7d09Lr/HUrmi', 'N3MGANBA_AzFWnsg8nnw7PK7w9ypcp4P_1594532744');
INSERT INTO `dd_member` VALUES (416, NULL, 1, 'oWwx95fwp9pIX0Bxy9NFMlqstvFE', 38, 1, '林怡如', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'dyvrhcbU229f1n1i3E8m0PgNODtwQmu1_1594535812', 1594535812, 1594535812, '4kJbl-Vj2wSYqWZfQlODwZzwsCedpHw3', '$2y$13$ktuRIwQ1/TxHc4DmsnLADePd5X4p0P/XZwxe5v88Ogw3UIHsZQN2i', '2QN_3Ve1aB9r64Kjh122TPWSAgtzwavq_1594535812');
INSERT INTO `dd_member` VALUES (417, NULL, 1, 'oO3nO4nDS9kD25TJCvOoSrRAnu3w', 43, 4, '低调', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'bekoUTm5_I30hlnuu-3vNQLGOeHzZi1A_1594555080', 1594555079, 1594555079, '0jSW6GNLF4AUSUB7sZh88lM54DECQdGZ', '$2y$13$vdQR0VI/cdXdX1HBJrgSg.ppT9JqGSs4XtLOfI9HWzWYgwkPHxU7G', 'JcOoN0o0uCyJDCluI92u0Ic_pTEsvdqU_1594555080');
INSERT INTO `dd_member` VALUES (418, NULL, 1, 'oO3nO4tIc_cM6TRVICrxDJ8yRpTE', 43, 4, '蓝色妖姬', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'osXXMf7vkY5fp-JDnMvHELwnfnKuBQIs_1594562369', 1594562368, 1594562368, 'gCAwFATQPjDkttyl4dp60dQqYuHV00xJ', '$2y$13$eo8pYjQgUOba43skH5WPTOd7CBQmhcqsoAzU2DlKT4N5T8d7oVOBW', 'JiUNhOrdV7VjSSjsIBrpdc3cwSI5dRWL_1594562369');
INSERT INTO `dd_member` VALUES (419, NULL, 1, 'oWwx95RCtD9RJbVYjDG3dU3oUKLg', 38, 1, '刘佳玉', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '0JnwzBadZrkNYy5dolkdY_Yt-VmAC2IZ_1594569810', 1594569809, 1594569809, '2G8CBOvPOegPnea6oowXtD3fmC_tYAo3', '$2y$13$IWdRB95C5MrLT/aCW5sMq.rnnXdWqgM9yMyxDQWtsL9c2B33Z.tRC', 'T5nMD9EzIn9wjnbfKTGpoHKbouzm8eCY_1594569810');
INSERT INTO `dd_member` VALUES (420, NULL, 1, 'oWwx95auD2ce4OKGCmpy_o01HAi8', 38, 1, '毛毛', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'RZ7ZcIkCfaK_fsEGS9YyHkg5mINOwtV8_1594587920', 1594587920, 1594587920, 'Q_hnuLiqKUBwSiNUf-AfbGYP1mVDhqx-', '$2y$13$k6ut1uv9koKLDZ3z2t2.9esyOD/yVuJtwo/NudrHY62J90eAVrJum', 'f0BxkYSwsWh6iTAJkGndnaFPtyJsdXQP_1594587920');
INSERT INTO `dd_member` VALUES (421, NULL, 1, 'oO3nO4gD2sEB7rBkuOQml-g7OuJg', 43, 4, '京东专卖店大柯', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'UXBOV3gCsoMkViZ2m_fvIBn6_DF6XeLy_1594600344', 1594600344, 1594600344, '5Euwa1OsMEcpMm91djiyleR6yt2iZeHN', '$2y$13$BuGbLYPQzB1dcPgaOGW5c.srLqp7TFs6gndnS7SB2weyj5XxXtGYK', 'T2GSDAOHdHAlQh1k_qdQlpUUmcXfqKhM_1594600344');
INSERT INTO `dd_member` VALUES (422, NULL, 1, 'oO3nO4jxLp0F_uUZuw0K4QTolDTs', 43, 4, '赵博', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'WEvdaHthe1BLg8l-_l1risYVAWRtm2hH_1594600522', 1594600522, 1594600522, 'LBUWce_2Slzei6MhU7_QE0NP1pNV27Tb', '$2y$13$JkR8vyVAVQvCKC6ItpH5F.S9nig/6c.thIjjD/176UDNCM34/OBoG', 'XMvR_WoopLI_dDZ9ZcusSfYlrrDmtjii_1594600522');
INSERT INTO `dd_member` VALUES (423, NULL, 1, 'oO3nO4lv6mLpT3o2pfmZwPtVjdZE', 43, 4, '吕少驾到', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'mSiJWQz1PC9c21LzP3Uj-JMOed0MZI8F_1594601921', 1594601921, 1594601921, 'Q8lPlLwcKkUKEB91wmr9WrAEyGq_rCrT', '$2y$13$xG9KhB4YtYyMe7kAEMD9NOxnxBSe3.h/9qCWsY2tRNf5QpwNE3JUa', 'MO6cI7GJObLMq8z9xtW4cpXuMoE5XVKk_1594601921');
INSERT INTO `dd_member` VALUES (424, NULL, 1, 'oO3nO4hltqpP4l1SS84D6t6mkDYI', 43, 4, '健康管理师丶鹏宇', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'DF4HEhHxwaBNA115EFTTWMUyXrW8mjZy_1594603718', 1594603717, 1594603717, 'fcz42TsjhhEu4i11fp041uKJ2x2iKIUw', '$2y$13$s2B16yJCuofreDKyhTTnguIRTf69bjIaXCBxszz6w2eVvaOPF7uny', 'vccehqDkVE7yCIYlINN-jh_n2OrcKbCu_1594603718');
INSERT INTO `dd_member` VALUES (425, NULL, 1, 'oO3nO4tFIBkmMTqrRwOy7KGGwzGw', 43, 4, '陈为庆', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'z6IK60uZZ95UNBf4X55ENi7AZJHUyKCr_1594604667', 1594604666, 1594604666, 'M5Li2NFOLSxbv2jCtt7faGmcYXA-xiVp', '$2y$13$q3dR6QS0Vp1pTWmuSswH0eqxQlA1XwpZA8dLZvzc8rVG24FMsg3Ly', 'tryTULskINWtMb4p20XzUxMs5g4H01fs_1594604667');
INSERT INTO `dd_member` VALUES (426, NULL, 1, 'oO3nO4s8AdIm6O_995RjExmEEUXA', 43, 4, 'Awen', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Musjic7ZxwaYimgqvYQ_gr6l4VvsqhQB_1594641013', 1594641012, 1594641012, '6oDIwO4U17KESgxGWT8WOaKRRwQfzwPE', '$2y$13$E6H/uWiZFVTdhCB1fi0KO.K0qp35UMEAbGI8JXq1InOsw4EPzfqPe', 'Bj2XMMQ78YWlUl3vxx_CC8nOptnPCyhd_1594641013');
INSERT INTO `dd_member` VALUES (427, NULL, 1, 'oWwx95UMFlQbQ6BezzNHce47--Cc', 38, 1, 'Awen', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'lk0NBvCP81X5wPbVfQlgx11Rdt_7GwoO_1594642223', 1594642223, 1594642223, 'RnVLV7-ft_gN3hBTUNYLQfK5BPy42Ple', '$2y$13$XJHFZi9gM0436kJ6xe1nUuLV6t8ScW4u9gOwGTzzONKFSr0jxiJB.', 'vQ6O_FdCKF4i86PGSQBKiL-5VnXA27vE_1594642223');
INSERT INTO `dd_member` VALUES (428, NULL, 1, 'oWwx95R8nBnklnJOD40dtbgf3m6A', 38, 1, '放生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'svBuN4hfGNrKOlLS4mxjmPqQccAOWyZm_1594657828', 1594657828, 1594657828, 'WcLAhtzl2Yj0PIg4w9LAjYZ_FCvf2t7y', '$2y$13$z.HYDKlbGOiTV8qrRgqKQuYXPhecpojqcHR2ZnFBfng5laBr14wpy', 'uUYoDuuJX13vfFtraIdT1pYwEyZScOSp_1594657828');
INSERT INTO `dd_member` VALUES (429, NULL, 1, 'oWwx95c2k7mxyn6kqdEa2WN6pk_k', 38, 1, 'Harry', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'enFnF_zHPX7_xxd_UaaNCKrSmhfbAjXZ_1594657856', 1594657855, 1594657855, 'MQEa5ycPel_YNlxTSBjXOmWX0WPh9X2U', '$2y$13$p80XF/3DcjMYl/irCfx5f.5pgIEXQsJiokoGmqY3d/c66aiF9/uCG', 'i6zfijC91n1jQ8VzyiE8Ba_RpaN5mdNz_1594657856');
INSERT INTO `dd_member` VALUES (430, NULL, 1, 'oWwx95aYrCkR6ZPvKRMiaIILC3AI', 38, 1, 'Yh#', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'zhyF4zmGjSNR8mIaSLFpxCevg30rrKgQ_1594657876', 1594657875, 1594657875, 'PZGmvg5kfDbVhsJYL9S4iS-RcnH3cfmp', '$2y$13$heYcYVwH07X6B9Z0DQc3QuumgMMFu4tFSxfjmjRSaMoUQHB23qRrK', 'O9Wh_Halekbpqi9D9gVbQzuSflPBfHYw_1594657876');
INSERT INTO `dd_member` VALUES (431, NULL, 1, 'oWwx95cCY3RxC0G69Tc0gffp4Hqw', 38, 1, '.com', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '3X7hzxDFQm9QNJdLZEDodJRmIV-vInoI_1594658083', 1594658083, 1594658083, 'yMUGXj7cg_c1A_-5X75pEMmLUCcd6Vsu', '$2y$13$vkQ9zj43DuWh5gaMh2rvqOheQ5sLkNR3.LsBqQ5B5NaC5FGSyRVey', 'l-R-EQ62iZ2XnC1k4v_LGmT4A8huHd35_1594658083');
INSERT INTO `dd_member` VALUES (432, NULL, 1, 'oWwx95fd39s4U4c3yXlyEAKoEyVU', 38, 1, '邓瀚昌', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'cYPDV_OKZ7S5pjELf4cCk994cF7LbWXj_1594658299', 1594658298, 1594658298, 'Sc9gzabbrVeNv9Pp8j2mXRo-vqOXhw_E', '$2y$13$AJzepOKWWpQUiAxbTmXmoOsGxrdy/ZkBmoeJPu3L7Y9Vq0LDoktGu', 'O0DHqN1DgGQJaY35or2FgTe7MG0I9ed4_1594658299');
INSERT INTO `dd_member` VALUES (433, NULL, 1, 'oWwx95YL3rW9WaxU-Hu6cE-JKALg', 38, 1, 'AA  小张', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'vBVTjuqWUzHBvLWm9bqnZIg_Iq20egHI_1594658398', 1594658397, 1594658397, 'TCt2Nl1kESWJAIllNYHNI062yoS0Om8T', '$2y$13$oTvv6PQnctX6gw65K9j3keaitEFccLwGrmt3M3augoocQ9wJptxyy', 'M4yeuesicyq2CxvM3zhsyqN8AugW228B_1594658398');
INSERT INTO `dd_member` VALUES (434, NULL, 1, 'oWwx95VnoUaI2XT1H910fMYj0ksg', 38, 1, 'FaciliTY', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'yEHhSiKh8gmHhfLMVp86iD1YH35qw1J-_1594658697', 1594658696, 1594658696, 'ghZRQn9soQZAtagEjm_eENPFNpA9MbxF', '$2y$13$GwMXnyIM/5PgfetxqVdqgeN60XiEemFMt8ATONWKJGu19vf329JbK', 'sUSZukDkXoz4u29UXdXSn-agUXe_FuEC_1594658697');
INSERT INTO `dd_member` VALUES (435, NULL, 1, 'oWwx95duRGq0VjV2k3J8dpFa63Zo', 38, 1, '男朋友', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jOqPj1287LjKjjZ5ISij05HrVebcBltP_1594658761', 1594658761, 1594658761, 'dIBk234bUbQSm8-XRPVdRpXw21zmarj5', '$2y$13$f9Y3f2IE6nFlwUTYwUF0GeuL45pexapMFmdOuUJ0EVQxZ3RlBlNi.', 'M9yVYCyjl9PezLjAKZDTobb4wPJzOEKY_1594658761');
INSERT INTO `dd_member` VALUES (436, NULL, 1, 'oWwx95ZHpeX2OoLs1S5nU8O1fjzo', 38, 1, '村口的灯泡', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wyINhYgoMZakj85O8kr4KWvJzHQXDvaV_1594658868', 1594658868, 1594658868, 'bQap8zeAygQWcNvam-CBgZ3i2z20cX3V', '$2y$13$5NFii2ue0p9z3GLN/fsUeeNmc27ZW.qTXaoRLnrJQSYGgB.A3lByO', 'o5MwEh5cYqJ0Z2rZWYDrVgIESUiR1Jc0_1594658868');
INSERT INTO `dd_member` VALUES (437, NULL, 1, 'oWwx95XwZ5-HeDTCX69vFed1x3Rg', 38, 1, '坚果', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'JfYoOU2Av_g73-7ZDRALwf-oFBJMIgnr_1594659038', 1594659037, 1594659037, 'LurtrhAp4VU1flzTXVIlIo91EMPN6BLn', '$2y$13$cSLjGxAFrzWIQS.5Z.B.9.TVvRkX3nHz9e.3o1G1XALl1qpQ/HQ9i', 'ljclUiR__bsLeOj8CS85FlKmUAda-YFd_1594659038');
INSERT INTO `dd_member` VALUES (438, NULL, 1, 'oWwx95VOZqlijJz86LHK11EEpfbY', 38, 1, '小威', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'L3X6J0sHZ9V19n7DDowKHp2JW-oENZOZ_1594660290', 1594660289, 1594660289, '-YSWe0E-Xd_AcCmaSMVcKYCYAPaD4vmC', '$2y$13$1dbB0e1jo02MzUDT7E1P3ur9uE3d6O.Lz/6/eLdlRk40t0qNYH.8S', 'wyB85FZMgEVjUSAlOq5yAWnAeM3UqOHP_1594660290');
INSERT INTO `dd_member` VALUES (439, NULL, 1, 'oWwx95SJBu43k_4v0gjiI43UgzwY', 38, 1, 'A丽丽（富城）13822295018）', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'prF0b2rvYQCB5snAB8FFD6BhGQhVGkUg_1594661190', 1594661189, 1594661189, 'O6ctG6PLM44ZHg1XGvh9ehFIoFpiH1D_', '$2y$13$xkPnUVuXZDTlBwTfp5N7S.1w.t6lNBK9/vdjXcPVnwU9TtqthjAwi', 'ozqAdx3VjWTCMBij0X-hOYMPrHV3abEA_1594661190');
INSERT INTO `dd_member` VALUES (440, NULL, 1, 'oWwx95ZE4Nog8oRkc8Pi98bogPdM', 38, 1, 'NordsTrom Shoes', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'QHBzAKvoynWeUCyAJN2fDBcQuajhYXpk_1594662904', 1594662904, 1594662904, 'd5vSh_8irvRKXlPnSiFJrV9t266lgemG', '$2y$13$1bC0L5etlXcgXmPaKMppfuNDjuWoAUhppBHCKTvk3ACtxounwjdBu', 'OeIRBVKvLD0CWRNxpXNSS0b0tszQ6bPi_1594662904');
INSERT INTO `dd_member` VALUES (441, NULL, 1, 'oWwx95YtDFuWfXRKmbA3Ihgs7mFk', 38, 1, 'juzi_chan', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'H8dymApVEvRgkV1lCKA8e_T1V4kum6RY_1594683282', 1594683281, 1594683281, 'T-BfcqSKet46v6AtcP99E7M7Zjlx1bIY', '$2y$13$WEKL9NeDSD9yWM9A5WX2K.A1N/29EnEKJzB3UWyDgpeZJ9BG2uUJa', '9QNVP_d0_YZZOMTYSiO03a02mVHWec17_1594683282');
INSERT INTO `dd_member` VALUES (442, NULL, 1, 'oWwx95btuLBzVgeIYyyaFdqfGL_I', 38, 1, '王生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '89NLbcJWKZj8Jh7pg7dGFfX7JDsFOWpT_1594713189', 1594713189, 1594713189, 'R6r0ZqoUEEbKsWK8X6dfBedQ9jPLJ0A1', '$2y$13$a5ROKp3anbPsAZ0q8BlelOT4A8LPyIOUoAaQHT8hB8Fz.fEdgrfSe', 'XRuVIC9YMjfkuGN73K9ZbVNRiUUJ3s0Z_1594713189');
INSERT INTO `dd_member` VALUES (443, NULL, 1, 'oO3nO4rICl0Cyle_iuJIatpxj0k0', 43, 4, '林木康', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '6DGsCqIUzR3_31gtJmuEm1BBRBfEj1P4_1594728057', 1594728056, 1594728056, 'ImiA4yykAD-5Kcgh0I2TiZW-Yrupgy5G', '$2y$13$RcTG2O5e3wnm4WhFmjO9weSn9cEulgiQfdv.4twRTEuF4krrfpk1m', 'ZNCY1HhcrXGeRdOnRxrJA-AeSr9PsWqt_1594728057');
INSERT INTO `dd_member` VALUES (444, NULL, 1, 'oWwx95ZyJc8y040oTLEbe8oL1Si0', 38, 1, '陈正茜', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '6zlISf2FKMbUaeP99zO6tkuilI2famaN_1594887366', 1594887365, 1594887365, 'ZacrQjVCK9Pe1B93-DwPb8S8e7vbh85x', '$2y$13$Up76FGMXZngSU9F1RUgude9Ca68xIz9OorViH8JI0xQjhPQdAl/f2', '_KUo5J6oQDucIvoo70JFQsX9V0SVGYy3_1594887366');
INSERT INTO `dd_member` VALUES (445, NULL, 1, 'oWwx95SASwtnSLAKfOMLBtyGeqB0', 38, 1, '荡失路', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'z1FpxX3EY8f-nryVJtDf3p0nS9QrPQHW_1595134086', 1595134086, 1595134086, 'KglazGg9IUkksRHRad7PVZnvF_QWu7ly', '$2y$13$iuruOW1.F2WBHeFqqucNG.HWP/dzFvjzJGdxAgcHGTmTL/AXffxaK', 'Ubkosq7aq6ZnTksARtiNDFPtXtW5jylK_1595134086');
INSERT INTO `dd_member` VALUES (446, NULL, 1, 'oWwx95T1kiE6B1qqm8CtDXLWa5xE', 38, 1, 'David', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '2nbAfU1ByIjctm9mAs3jQR8aBY32Eqgs_1595134244', 1595134243, 1595134243, 'DcYBLEXLFBhe63oV5Aqld0S0WVaAJVOi', '$2y$13$kFwxIArAmpVez.n3t9/bP.DHjvhaGpzkoGNiksNRHeMDShcrROB16', 'VG61zuRz56ulP9V6symmhYyaryMRewCK_1595134244');
INSERT INTO `dd_member` VALUES (447, NULL, 1, 'oWwx95WsSyoVoWGuRTC7JjoFS9Bo', 38, 1, 'H先生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'n_Xyi-vwht4ZsxlkZEzE59TDfvBl8m_N_1595134247', 1595134247, 1595134247, 'ApwW6GGB3sC3-0Axl1dAz_VwjfMjRp-z', '$2y$13$rS0Y8elMDbwF6l4RHhOOb.e0lPjcSyYwncZTHYCRzbVb1ag.dF3GC', 'RM8zmcX-JHo1jDV8kvhJMAr78rvggAgO_1595134247');
INSERT INTO `dd_member` VALUES (448, NULL, 1, 'oWwx95YNUf-w7-1VjrZOYU5PlMwU', 38, 1, '陈风帆', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'CP9fFNwt_njSx2h-8I_xT8S0tzF4vuFa_1595134253', 1595134253, 1595134253, 'CjQG5dmyJdrjgzQwcfAJK4nJbVODQ8oo', '$2y$13$0965HyXVffCS2Ul3sCRDi.GC4qtVsBszNOpi4eBHDgJv5rGEnBN2W', 'uhWGu8ReUTqr09gXN4RLQwBHt_xc4kFp_1595134253');
INSERT INTO `dd_member` VALUES (449, NULL, 1, 'oWwx95bgrQF4G1zgA2iNH-eyePEY', 38, 1, 'Jenday', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'qR7ITl4dQzv__ePuqFZoS4Fn4vqbs2hN_1595134283', 1595134282, 1595134282, '4HhwjH1YH93X0Mh-mKzw2ZeWK8WKzVIT', '$2y$13$qBPZa2V3HQ9i5gsy5sQV4eZIcMfqJpnTEHzBdtKZCKLjXJ6oJJjFS', 'vRcGerIlhtqm-CiObsxBTPqLwsqQxfwE_1595134283');
INSERT INTO `dd_member` VALUES (450, NULL, 1, 'oWwx95WSgqlCu2qCFjCo11vRaQYs', 38, 1, 'ChiKit傑', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'RKHXnUgqaZaTuiMM30Tr4T8gegyjuQj5_1595134292', 1595134291, 1595134291, 'R-KWaTguNty7nAJPZKb62nVR-PEQiA_N', '$2y$13$jkl5AZ6Gh5cqixDxA0ncEuDEZM3G0w7ZVZrOmHFDLC4SZzVR40tHe', '5Q2i10vU6luhsJCLraL-xDGVghje7Ek__1595134292');
INSERT INTO `dd_member` VALUES (451, NULL, 1, 'oWwx95WvQ_Xwd7RwAagXlcSjreyU', 38, 1, 'Lavine', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '2ZRGgC--GEYr-xqt2N8f7FAqOEokbyDP_1595134328', 1595134327, 1595134327, 'QyAdUFMCu3Sp6AauKYybczmW2dVl_Gtk', '$2y$13$VPG3YI2F3nVscFgHvasmH.MTU48kGRAbaVwFMXDgin3qYmLX9ui0u', 'qOjIVsCoVxwLcdxtC43OGxQNqYuXTvlb_1595134328');
INSERT INTO `dd_member` VALUES (452, NULL, 1, 'oWwx95ZFVysQ4Olo9PuBYqTnN4aQ', 38, 1, 'Chilam', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '9dhZ3ye4j75UMyHARVkzfjVZD5uPLnOI_1595134427', 1595134426, 1595134426, 'jVzPJFn9PWSbv_ls8qP6v4PDFOWNmh8F', '$2y$13$Zh1r2IsVuk.g1pDtrlfWKOVRTYN497H08kiL/x6SfmY1KqifiTKfq', 'wm7IyVPrAbAqx1FkcjE6jLMxOerxDdMy_1595134427');
INSERT INTO `dd_member` VALUES (453, NULL, 1, 'oWwx95bdceyfdnPvRGJDewQQcIqI', 38, 1, '.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wNKYYj26D_auBROD74Lv2i2PwULuxyCS_1595134498', 1595134497, 1595134497, '0Hq9bj2xy_QWUDDUiTMB1CCT8fnutagA', '$2y$13$lI.QfFBVgqzEqFbt987q6.DxF66O4bNSgV7yBy9Xc8GUS1PBV2xfm', 'pglMIfVIRsKmUAYXMl-WgvExdHqrCmr4_1595134498');
INSERT INTO `dd_member` VALUES (454, NULL, 1, 'oWwx95YUymlSTdQGTg8NvZw8mHjM', 38, 1, '虎门东风日产冯伟雄', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Mu8MCC2jDSoqZO7AJJGLeONLi7J2I8mT_1595134507', 1595134506, 1595134506, '-lOSyjq-KLzosaRm5hmU9ccM4Y76o_PI', '$2y$13$vPpkY7u7Jd6ezZI32w.Qkuh1/9Dh.q30slueSKVscdCLfroLzUnMy', 'pRJblcLCbd0BBFk8kOChHZjefeDclfvu_1595134507');
INSERT INTO `dd_member` VALUES (455, NULL, 1, 'oWwx95d0Hd0EFVPi5lseRR0pdrgI', 38, 1, 'Bad Boy先森', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'wlc5wVUw4kg3egU9C4zbNnldvbjbMq4r_1595134821', 1595134820, 1595134820, 'yMQdgG4cJLRYJ-AXFhQEV6SnhO9y1g_j', '$2y$13$RCU/MLxvUO4FXRcSeA7Yse4IZHev5Xgx8g5hCCNnqJ7iz58JWSm7i', 'ftYGV-WvrR3aaXadNHhz3X4ZpEFb0-fa_1595134821');
INSERT INTO `dd_member` VALUES (456, NULL, 1, 'oWwx95cEkjzea329yDC0j--fjgME', 38, 1, 'ぬ叐已丄綫', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'w45GxQMcXCrIwbfYrQgR9U0DYfAt8XOV_1595135227', 1595135227, 1595135227, 'CB8nt1z_OYoaj_-eWCRVr2yCHvjXA2h8', '$2y$13$tO7ojN3zUzYPpfqB338m6uV0qrLwuhrcPBKskae3fer53LsqE9UTW', 'EcI963lQvib5NGSjr9xtJZUoM8-GZmfN_1595135227');
INSERT INTO `dd_member` VALUES (457, NULL, 1, 'oWwx95ejujk33sLwKFmH1V-HamYE', 38, 1, '.', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'n8tE-5WjqKYoJpmtv9hqPyLOLnTLo8m2_1595135701', 1595135701, 1595135701, 'nsSrlNFKG2Ft1PpVQhEJ4VENsI9hDOkW', '$2y$13$QsIuxPDgdtakxyh0GulpguqKrv4pSc62ZryezVxBY377tDsKTDz..', 'NucJ7xH6bqWdfriReyWEDh1kZ0P8KD82_1595135701');
INSERT INTO `dd_member` VALUES (458, NULL, 1, 'oWwx95cTD3oHPwWqV6gUogCuG2Wk', 38, 1, '彬彬', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'S5a8pcGGOiQ5nfnZYVEsdTMi9DKS8v7A_1595135755', 1595135755, 1595135755, 'HSiqBb5_2uIHQ8ENSRMQfKto9ivRFO0w', '$2y$13$DK30xCLN6ZW3eyub9StXguKdlWS0yjPO8j.fDFFMZmBbe9GD5XTJG', 'jIr-cHYwuJRno5QZn2qkx-kUPLtwPyor_1595135755');
INSERT INTO `dd_member` VALUES (459, NULL, 1, 'oWwx95TawshiF6EH3tkcfOilPhRg', 38, 1, '東东东', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'cxmJgql1qEKHi6Cz0LWbpuT3DHfdFg26_1595135779', 1595135778, 1595135778, 'OHbDZ1eRUjcptiZ1yVYDDLGaicA8Od6H', '$2y$13$GbB4RoJm95uZqcZUjwUikudrPxDGfvrmYSUcr4VfVSrKQOtOxtiBe', 'Xc5py9-nUGYXDl4AmNzWdP8p1snA_b86_1595135779');
INSERT INTO `dd_member` VALUES (460, NULL, 1, 'oWwx95e0UMr3jcSu72di3KU7qg2U', 38, 1, '何纬健(耐克阿迪折扣代发  招代理)', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '6JaOB7D6V-P-fKivzY08pS8NMUHh72u4_1595136084', 1595136083, 1595136083, 'ITS-O5II5_8Fp_mvnGJqdnEO9T34dvPk', '$2y$13$6JUXbqsWbngbpSKapbOz4ekZSABlnvNpAJFup1Bfh0UjJomBtYuOK', 'DDIYu8KR4qY_516pbKsnbWHRf0-UfIP4_1595136084');
INSERT INTO `dd_member` VALUES (461, NULL, 1, 'oWwx95X6WmKy8FmkOSkcUQ84dhls', 38, 1, '霸王_羽', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'xwa2rDUdtIfcO1L4w6U_9EgzJ-hzQ_u6_1595136175', 1595136174, 1595136174, 'VU8IK5Fnr5A1ScNTKKnXM3i5ttExfWOV', '$2y$13$EQxNVxlNfXPZhaO2EGnczejD0Ab52viD4BWx3IQS1LZCkPfirIWbm', 'UpagKQNSmduzwmPRKOQYyvljTBx2-ff2_1595136175');
INSERT INTO `dd_member` VALUES (462, NULL, 1, 'oWwx95USRyRtTqdM7equa9uYlf3c', 38, 1, '律', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jaDtIPjw2bRhAE6UiW8ZyNeL5tL4GjfF_1595136204', 1595136203, 1595136203, '1rzBIQwLrt3kBvOxpLM4b7dC45XqiJsx', '$2y$13$i3l7cWZgQuN/egwZn3f3peTfvL9ljjrB.y2Er5zTXCnsG75D3ayMm', 'hjAdVtrDNZoLOMptX88WXMU693HZYV32_1595136204');
INSERT INTO `dd_member` VALUES (463, NULL, 1, 'oWwx95TGO5vO2q1lBoDl4PjoVUQQ', 38, 1, 'Richard', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Y9JBO9FwJv6HCT-qLzHEUc411BqWfyGg_1595136943', 1595136942, 1595136942, 'oCotvqQ97E3-Y31xkKtOtWONOfgnoNnd', '$2y$13$wA/aDU9kOHkmMPEjHcU9eegF06rqPN9KOHeQHzso.BUHe3YAwXZ.u', '5PdKJdNpmLXgAHQ2qFKBZQDJ3YQ-PvO1_1595136943');
INSERT INTO `dd_member` VALUES (464, NULL, 1, 'oWwx95Sv0t1lm5N3X5Y3kVtzcunE', 38, 1, '美好明天', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'FF5g3QZz9Iz4UC4fLRyIuAN29YvZaOH2_1595136957', 1595136957, 1595136957, 'vdYyetcBlocs8lZLIeGJoOP2y2OpZqjz', '$2y$13$3a37tHeFCtPMonccgXCTROkD28MeCmnNaMHXQuB.XevWyAGnVMp/2', 'T_3jkzFS1218x5HVFyw2RwuxGQeejTKl_1595136957');
INSERT INTO `dd_member` VALUES (465, NULL, 1, 'oWwx95dyWlq7oMCwTzUwedEMIYus', 38, 1, '赤霄', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'pckfmtVUxwpdsam9gDtSyvAFymbSEN8i_1595137149', 1595137148, 1595137148, 'oINUbwVUV46wWgj9GjlluEGDcvGafxQh', '$2y$13$HTKW8r56yq96op6SfwVTfeO2n8FGVJpzPTrzT86ZaqmafF7CqMilq', 'Fbs2pDoJsImLQydib4FHCZHUWPSgeYQy_1595137149');
INSERT INTO `dd_member` VALUES (466, NULL, 1, 'oWwx95fT9nrd6XzGmov5Q8HaBrl8', 38, 1, '阿杰', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'AwU76TiVqsCtWsVZNsYGRdUP9JDh5alR_1595137779', 1595137779, 1595137779, '7AZ3PXT2XsdHwZiSnzO1YtthR3VxU2RY', '$2y$13$pSJA2sFTQR1l232qYgek0O4wH63K3ZSUWHOaoL4/D0U1tn3UxntVW', 'XOhXb4_Gm8ThK0GAWlalXN05mdhRlw94_1595137779');
INSERT INTO `dd_member` VALUES (467, NULL, 1, 'oWwx95Tb7CAyFvWaWii7EaBUAGuo', 38, 1, '夜空中最亮的猩', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'RJQ6rj8xJSNrwVJddrJp33wJfTn6ST4n_1595138132', 1595138132, 1595138132, 'le_6slQCOvMvkBIbEYOMFl60cE91kBIF', '$2y$13$zPRjRrcNmoZmyZ6Eff.e0.haPRh1rV8I6srCwZnH.F3oiMUVTd.Qi', 'nsBX-TGSJ21Nlfkh66wgIG6JcoNVdeaS_1595138132');
INSERT INTO `dd_member` VALUES (468, NULL, 1, 'oWwx95bJODYAlmpj13m98kT1ZtI4', 38, 1, 'A 广州 金哥', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'IT17l7BD86qj1jvjdMnWP_vVMuDZ7het_1595138402', 1595138401, 1595138401, 'tJTB0LfC-W43WV5P0TMxLMF4TjCdhjJR', '$2y$13$FQXBXokOTM6y9PSY.4k6pe/bCCKwA5MhiW9CcMF9pYihseZVevuX.', 'BLf2-Kpon-wc-FNmaPlUQytpTjwsI4Of_1595138402');
INSERT INTO `dd_member` VALUES (469, NULL, 1, 'oWwx95TlPPCqP67nW7gmRsvaOHJ0', 38, 1, 'C.朗', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '5q8Q5xr6Spm_Ds350fgg0GtUqY9GUZ5n_1595139376', 1595139376, 1595139376, 'uRnsHgUwKjw8riygi1xeVAAEP6QAvpAC', '$2y$13$TyBuHafWJ0L/6yg3B8sUOOFpGhKcSxkOFVSbngym.oSVyCRgCNxAS', '_vmZaQkP8XMmbUXrphgxi8RmKb-Sghfo_1595139376');
INSERT INTO `dd_member` VALUES (470, NULL, 1, 'oWwx95dWQRMQmZMd5FRtHv8mPvyo', 38, 1, 'Alan', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'zGjxjN74zKI5d4sSiqcpzyjxYhsZeAhz_1595140627', 1595140627, 1595140627, 'V_R_14mKvvjCQ5ArJBr27FkZB4z5s1ld', '$2y$13$7EnPAQkZaJXZnTwZ3tJl9uklzzfDXrSqc7tQjCYvi7tDkDApsD48G', 'TVgoHofK8HgWK6jYLxh_TP3X80_uXjS8_1595140627');
INSERT INTO `dd_member` VALUES (471, NULL, 1, 'oWwx95dkVkiBhFZ-JD04QqrWMkh8', 38, 1, '大头大头下雨不愁', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'SwqeXZu0w3XiMprxkeSR0orj1l8M1SS9_1595142235', 1595142235, 1595142235, 'MkeyTOcCWsSsnJF78sQ3gfTb0jcNhoL6', '$2y$13$T.n2lJWh4rZcTavz3msmxu9XZxwDVcRfkKIvBLwsP8gGYG10957Ba', '4_BIVmt8nUpDEew8rREDefiRRlPFyMGt_1595142235');
INSERT INTO `dd_member` VALUES (472, NULL, 1, 'oWwx95Y5jSnapV6nup0oKaKADwr0', 38, 1, '畫家', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, '27ulIgbKjNWZJJVIj5l6AokTyeyhmGV8_1595142632', 1595142631, 1595142631, 'S3w1G1lk_e4b8e-THXy87Y-78VTbItqB', '$2y$13$U5LVafxX8qB2YCLI89G6fe.n/82Q9UmQ7D17AIdl.YwM6vlCuG/HC', '3Dr_7R1C8uuLlx6SYtUu8hhL9Y7pMZiN_1595142632');
INSERT INTO `dd_member` VALUES (473, NULL, 1, 'oWwx95avKYZ62JNILXpcpECVF-xc', 38, 1, 'abc', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'leYDgngC_CnDkvUdJvblMXxaTg8Un38l_1595142760', 1595142760, 1595142760, 'AhnBZL4XIFnJzKvnfospCFnqt_zVoUt7', '$2y$13$2zsmxqBEX1FUO6jpNXkCh.EpCVnTLgq4LYWwYYP5jd1dVaGWBnXU6', 'TAVNLCAKRHjiQ4hbaqXjS5t3ijFURDDJ_1595142760');
INSERT INTO `dd_member` VALUES (474, NULL, 1, 'oWwx95a_IghAN1lD2HmRUSiCMU9A', 38, 1, '哈喽喔', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'tR95BiQXGi24bys1cBOGF-FRSchyOn7l_1595142827', 1595142826, 1595142826, 'n9zMpIsDn9dW6JM2SePbNmUxIAxGKzbV', '$2y$13$54DruDm0b7kuAe8BtxR8G.wV0d4ArZC/YoiXQ1RU6u3WF18VUq0SG', 'KgsvZo5g-4RUgWDpi-9Yku1r2cjRZFO9_1595142827');
INSERT INTO `dd_member` VALUES (475, NULL, 1, 'oWwx95ZA5CGMdjzzMUZvtkiWgpnI', 38, 1, '听风者', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'GRNarxl1vgQ72hnkiMtInxfpbQ5uaw-H_1595143233', 1595143233, 1595143233, 'ZBPaF2CLWVdAwr6bnujK45RU4A9uYxCz', '$2y$13$akYejzm.Lhrle4oyOrnUKOhFrP11qcrUH/4aePjcHB98X2az18DAW', 'N76k1nrC-cF1bLV4XR9JhjiC1_q4378J_1595143233');
INSERT INTO `dd_member` VALUES (476, NULL, 1, 'oWwx95SMLehtznHgvK659u8JSJRQ', 38, 1, '_Serious_', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'jBzx2_lXFxhfFCJ1l2OZ1BsLVh13SmKq_1595144186', 1595144186, 1595144186, 'pQhX3aoHKhhnHGyrRdzWMH4cCPMK8jbx', '$2y$13$CvaBUkpFAKP4YRWjPdMM4eyp0hYFfj1bVvlE04O76BM.WxnVTnKlu', 'vJ58HMadLfSz7qwpsumIoyEMUDv6FFJe_1595144186');
INSERT INTO `dd_member` VALUES (477, NULL, 1, 'oWwx95aFAndT8grCQnfsVxrSZALA', 38, 1, '恒朗五金', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Dt_3WsC6EaWNl-oJadA31rEdDUk2Dec3_1595145922', 1595145921, 1595145921, 'GZyX1KprgeahNPsWhBsDlTQ-AzmB7urY', '$2y$13$l9GGT.U9gukFnCjeqBxOZ.oCldo24F4jE3m7KVcebT.gxKPYo4Ga6', 'rbm9hB7DwFB-LQ3ght4ioacelhUr4F44_1595145922');
INSERT INTO `dd_member` VALUES (478, NULL, 1, 'oWwx95XS_c0KPuNv3kNo5tlNNOrw', 38, 1, '有米陪伴', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'd2wi-zyJQhnKna-UnlYDSyEK1SoIOGuV_1595149797', 1595149796, 1595149796, 'Hi5dJMWrNPQck8DBjEbLugPNBO3mEX9g', '$2y$13$vEsnD9gB7J.nGfgUWfeDWew7LhW3.CrOzSSG6KUCluPH.A4zQMCxG', 'MrVWK7L6PxWkdNJnOiHUJ0fL76wETW4L_1595149797');
INSERT INTO `dd_member` VALUES (479, NULL, 1, 'oWwx95UNZh7BJdIqVOGzAZDTDUrY', 38, 1, 'J', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'XrXlnMNaYE3A8aHZI9jEqprHNB_2zZkM_1595152523', 1595152523, 1595152523, 'hcq7GD8p1Xl1IKDK6c_QGPezzG68Sxce', '$2y$13$cQtLSZVLP7T5uZYTp2NiZeOHTCUMvvWXv8jaXYUrgMMVCUJBQNgDO', 'S52tYg8VFZ4dEGvRqFUxxRjmqbG-fIPf_1595152523');
INSERT INTO `dd_member` VALUES (480, NULL, 1, 'oWwx95SJMGQ27uNs8ySgK7eHf9us', 38, 1, '嘟嘟', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'cVMApev4XNYmn_wupFWHng73lzbTwrWj_1595152626', 1595152625, 1595152625, '3qYeOr8Kdj4g3a71DxYU8iUVgSNNdudk', '$2y$13$fmemkbnNDLJp5JWt4gtfc.G4ATe4DdsE1MGSNkTCP5uJ6ZQTj9yuC', 'dWOxKG_K9yZcTJH3584GMO9yCOzm6adU_1595152626');
INSERT INTO `dd_member` VALUES (481, NULL, 1, 'oWwx95R06cicDIk8fzs1Lm4pFdQ8', 38, 1, 'burte', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'lOmMIpC0OHFzewZ8D9QJlaxx5I_Fimeg_1595155049', 1595155049, 1595155049, 'R87DX3WxkUcZM0104HwQ9-ZrwIgQn0hU', '$2y$13$/v1o0uCDZjSndV.Qj1r5M.2CVmnLVJsQJrfJ7yP8UocrkQsYlA67K', 'qIxn-9CM2hIOs_MBL2ciI3MyaoP4_L-x_1595155049');
INSERT INTO `dd_member` VALUES (482, NULL, 1, 'oWwx95SM6OMm1ZzCN0K2_1qAmd90', 38, 1, 'Earthbound', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'xYkbs4g1-O1lc5PMMozkosZTJPKgdUtm_1595156576', 1595156576, 1595156576, 'Ek5L7LBt-2pG4D0szyQy4Y3oIH5drJBn', '$2y$13$GuYUrUH9bObYoYaBd3ubI.XGpJdaU8R4n4uckATYCD13oNb936/1i', 'Q_LAN_oKzKIOp1QUYhV8xiMZBSIMt1Zt_1595156576');
INSERT INTO `dd_member` VALUES (483, NULL, 1, 'oWwx95XPV9DMh-SsOwQqXSdhfLl0', 38, 1, 'A0   红太狼', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'TheQeR0fl8e9bF6doCHVW5TiyFfbBpgd_1595158186', 1595158185, 1595158185, 'lbApXVwJujacBpa4lCfFeNbc8K2o1ACp', '$2y$13$h4LgGKDi7ohaG2Ftn/uAe.lagoD4y9NJ6AJJtyL1pOwjzhIzLJ4hO', 'cGzwNO3aKuMcNrzbsUg4EygXv2w9WgzY_1595158186');
INSERT INTO `dd_member` VALUES (484, NULL, 1, 'oWwx95Yzm7r_UNh7-tuYRoqa5qtM', 38, 1, '。。', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'A8U6veni3mRFr251oilfgmah5RhHyCGJ_1595160846', 1595160845, 1595160845, 'jZfAjODIrKW_E-RbQCDW2TrwbaFwwJOb', '$2y$13$pbYLeNg9FtXRywRwhHmw3uNGYLKQaDbadUNhZjEXW21DeGD8KFW6W', '0K1btO3Hft9mg7LVH90DfFPUFIMhTSqG_1595160846');
INSERT INTO `dd_member` VALUES (485, NULL, 1, 'oWwx95YoKB2wRBUDQ23rm7TO-c9M', 38, 1, '了没', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'M44kCAH-dNgl53FmuYbyH-37tUZOgRdu_1595163237', 1595163237, 1595163237, 'j_GcmXEsFEm1EBY05MO31LMnBeK6H6Cu', '$2y$13$giuoL5xYn8ilx2LU204O5.w0Vb8qcCxePeiTjKFUwr0LxKsaxNKHu', 'nvy12ammsdnL7fOpZ_4HZ7uqTckK7UMf_1595163237');
INSERT INTO `dd_member` VALUES (486, NULL, 1, 'oWwx95TVtDmuiXB_1VaJBjlcjkAg', 38, 1, '春江墨鱼', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'd0gwG5tuQnkhDQgRcEGNvsoTSa6liuch_1595174096', 1595174096, 1595174096, 'B-Rk5DGG4gaRL5I4KQdzEQM1x2OxgZ8D', '$2y$13$w01aWD7ndoLS8UUeueb4WOFGMB.c15SCS/kVDIDwcmqyI9QfCkWG.', 'l_XTJKxyZPVWH14-0lwNZTwJzmgH3FIG_1595174096');
INSERT INTO `dd_member` VALUES (487, NULL, 1, 'oWwx95eEYAUyq_IgnXKP-4b_js0k', 38, 1, '玄武载乾坤', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Uv-XWSyTffxNyb1aFkHiip9H2tgDexii_1595182726', 1595182726, 1595182726, 'EDjq7jaNUpxf95bY5wqQ_TtNhZzA9WjB', '$2y$13$nyp871xD/xZ7wRa9XZNatOjDp5an/LLEm4BhVGnDdlxSPiQIg9Gea', 'Q1xnh_-dH2Y760WFR6L2D5kzzO4RiYyq_1595182726');
INSERT INTO `dd_member` VALUES (488, NULL, 1, 'oWwx95VTtSaAIXJ5CuzW2MgM-TpI', 38, 1, '重生', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'awvKNd5AajL0jifD9C0xYifmnRDM5t2u_1595203451', 1595203451, 1595203451, 'e36xxtfzOtVs8P-zhHn2lGVz8cBJGPPA', '$2y$13$Hcconw6QBOp.bgnU4O91ruT.VpxZC3Tb/afL7PBKrmNTjDnYm07IC', '2jfnyNnbE-HWFW-pC-idORpgnCie_at6_1595203451');
INSERT INTO `dd_member` VALUES (489, NULL, 1, 'oWwx95YOzzDm5lZLV9c4wPUHmdbE', 38, 1, '构图DV', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'Oefvxcr15Y7yurbg0sNGpAvSrhB78RM3_1595219225', 1595219224, 1595219224, 'A69mBt3DFllbHH0pezKojTit4T1u24Cw', '$2y$13$8y9MI7bOK1E6r3ckqU552eDFiztsRbAwSax9nXgnxxOtMjlAsOE0O', 'E3DORLBzthQoyXQU1Am-zcCtZ4BxkYpK_1595219225');
INSERT INTO `dd_member` VALUES (490, NULL, 1, 'oWwx95ZSeykgE0wZiR9IJA8xD5ac', 38, 1, 'CN-C-Xi', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'CHU7GtodQDlWIwlzbRFh0SwP_yF3WRor_1595227365', 1595227364, 1595227364, 'xStgMHNl12vMHh3j98AruKRF3uUIfvIj', '$2y$13$9AQnpSx.cVAiLPhuM9fhPOguQ6Mb4kOMaPvWwgSnSl0TLMXGsp0S.', '4mPdxogzU0r9LDL51GDoC_1eYgbmWo0e_1595227365');
INSERT INTO `dd_member` VALUES (491, NULL, 1, 'oWwx95TiMhnqqy4g4_EvyUdp9IUg', 38, 1, '火拳', 0, NULL, '', '', 0, '', '', 0, '', 0, 0, 'qz-8Anufx6MysgWz0K5fSYEaex2tYS0__1595227597', 1595227597, 1595227597, '8GhiBng3OdyswzwA8MUV_zSE0dnMbH3y', '$2y$13$q9g.drl73V89Tapacz9X6ec0ZoW4pS52HcfrbxZT8W/AhBYYDuJiW', 't3PnG6rJD2bZMg3sxvCpdpkbGwPBAC26_1595227597');

-- ----------------------------
-- Table structure for dd_member_account
-- ----------------------------
DROP TABLE IF EXISTS `dd_member_account`;
CREATE TABLE `dd_member_account`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL,
  `store_id` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '商户id',
  `member_id` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '用户id',
  `level` int(11) NULL DEFAULT -1 COMMENT '会员等级',
  `user_money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '当前余额',
  `accumulate_money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '累计余额',
  `give_money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '累计赠送余额',
  `consume_money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '累计消费金额',
  `frozen_money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '冻结金额',
  `user_integral` int(11) NULL DEFAULT 0 COMMENT '当前积分',
  `accumulate_integral` int(11) NULL DEFAULT 0 COMMENT '累计积分',
  `give_integral` int(11) NULL DEFAULT 0 COMMENT '累计赠送积分',
  `consume_integral` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '累计消费积分',
  `frozen_integral` int(11) NULL DEFAULT 0 COMMENT '冻结积分',
  `status` tinyint(4) NULL DEFAULT 1 COMMENT '状态[-1:删除;0:禁用;1启用]',
  `create_time` int(11) NULL DEFAULT NULL,
  `update_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `member_id`(`member_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 461 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '会员_账户统计表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_member_account
-- ----------------------------
INSERT INTO `dd_member_account` VALUES (373, 4, 43, 404, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594286938, 1594286938);
INSERT INTO `dd_member_account` VALUES (374, 1, 38, 405, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594295254, 1594295254);
INSERT INTO `dd_member_account` VALUES (375, 1, 38, 406, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594316076, 1594316076);
INSERT INTO `dd_member_account` VALUES (376, 1, 38, 407, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594317592, 1594317592);
INSERT INTO `dd_member_account` VALUES (377, 1, 38, 408, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594336058, 1594336058);
INSERT INTO `dd_member_account` VALUES (378, 1, 38, 409, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594348791, 1594348791);
INSERT INTO `dd_member_account` VALUES (379, 1, 38, 410, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594360974, 1594360974);
INSERT INTO `dd_member_account` VALUES (380, 1, 38, 411, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594367609, 1594367609);
INSERT INTO `dd_member_account` VALUES (381, 1, 38, 412, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594425841, 1594425841);
INSERT INTO `dd_member_account` VALUES (382, 1, 38, 413, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594529866, 1594529866);
INSERT INTO `dd_member_account` VALUES (383, 1, 38, 414, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594531638, 1594531638);
INSERT INTO `dd_member_account` VALUES (384, 1, 38, 415, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594532744, 1594532744);
INSERT INTO `dd_member_account` VALUES (385, 1, 38, 416, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594535812, 1594535812);
INSERT INTO `dd_member_account` VALUES (386, 4, 43, 417, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594555080, 1594555080);
INSERT INTO `dd_member_account` VALUES (387, 4, 43, 418, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594562369, 1594562369);
INSERT INTO `dd_member_account` VALUES (388, 1, 38, 419, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594569810, 1594569810);
INSERT INTO `dd_member_account` VALUES (389, 1, 38, 420, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594587920, 1594587920);
INSERT INTO `dd_member_account` VALUES (390, 4, 43, 421, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594600344, 1594600344);
INSERT INTO `dd_member_account` VALUES (391, 4, 43, 422, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594600522, 1594600522);
INSERT INTO `dd_member_account` VALUES (392, 4, 43, 423, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594601921, 1594601921);
INSERT INTO `dd_member_account` VALUES (393, 4, 43, 424, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594603718, 1594603718);
INSERT INTO `dd_member_account` VALUES (394, 4, 43, 425, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594604667, 1594604667);
INSERT INTO `dd_member_account` VALUES (395, 4, 43, 426, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594641013, 1594641013);
INSERT INTO `dd_member_account` VALUES (396, 1, 38, 427, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594642223, 1594642223);
INSERT INTO `dd_member_account` VALUES (397, 1, 38, 428, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594657828, 1594657828);
INSERT INTO `dd_member_account` VALUES (398, 1, 38, 429, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594657856, 1594657856);
INSERT INTO `dd_member_account` VALUES (399, 1, 38, 430, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594657876, 1594657876);
INSERT INTO `dd_member_account` VALUES (400, 1, 38, 431, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594658083, 1594658083);
INSERT INTO `dd_member_account` VALUES (401, 1, 38, 432, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594658299, 1594658299);
INSERT INTO `dd_member_account` VALUES (402, 1, 38, 433, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594658398, 1594658398);
INSERT INTO `dd_member_account` VALUES (403, 1, 38, 434, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594658697, 1594658697);
INSERT INTO `dd_member_account` VALUES (404, 1, 38, 435, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594658761, 1594658761);
INSERT INTO `dd_member_account` VALUES (405, 1, 38, 436, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594658868, 1594658868);
INSERT INTO `dd_member_account` VALUES (406, 1, 38, 437, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594659038, 1594659038);
INSERT INTO `dd_member_account` VALUES (407, 1, 38, 438, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594660290, 1594660290);
INSERT INTO `dd_member_account` VALUES (408, 1, 38, 439, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594661190, 1594661190);
INSERT INTO `dd_member_account` VALUES (409, 1, 38, 440, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594662904, 1594662904);
INSERT INTO `dd_member_account` VALUES (410, 1, 38, 441, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594683282, 1594683282);
INSERT INTO `dd_member_account` VALUES (411, 1, 38, 442, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594713189, 1594713189);
INSERT INTO `dd_member_account` VALUES (412, 4, 43, 443, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594728057, 1594728057);
INSERT INTO `dd_member_account` VALUES (413, 1, 38, 444, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1594887366, 1594887366);
INSERT INTO `dd_member_account` VALUES (414, 1, 38, 445, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134086, 1595134086);
INSERT INTO `dd_member_account` VALUES (415, 1, 38, 446, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134244, 1595134244);
INSERT INTO `dd_member_account` VALUES (416, 1, 38, 447, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134247, 1595134247);
INSERT INTO `dd_member_account` VALUES (417, 1, 38, 448, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134253, 1595134253);
INSERT INTO `dd_member_account` VALUES (418, 1, 38, 449, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134283, 1595134283);
INSERT INTO `dd_member_account` VALUES (419, 1, 38, 450, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134292, 1595134292);
INSERT INTO `dd_member_account` VALUES (420, 1, 38, 451, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134328, 1595134328);
INSERT INTO `dd_member_account` VALUES (421, 1, 38, 452, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134427, 1595134427);
INSERT INTO `dd_member_account` VALUES (422, 1, 38, 453, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134498, 1595134498);
INSERT INTO `dd_member_account` VALUES (423, 1, 38, 454, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134507, 1595134507);
INSERT INTO `dd_member_account` VALUES (424, 1, 38, 455, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595134821, 1595134821);
INSERT INTO `dd_member_account` VALUES (425, 1, 38, 456, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595135227, 1595135227);
INSERT INTO `dd_member_account` VALUES (426, 1, 38, 457, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595135701, 1595135701);
INSERT INTO `dd_member_account` VALUES (427, 1, 38, 458, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595135755, 1595135755);
INSERT INTO `dd_member_account` VALUES (428, 1, 38, 459, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595135779, 1595135779);
INSERT INTO `dd_member_account` VALUES (429, 1, 38, 460, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595136084, 1595136084);
INSERT INTO `dd_member_account` VALUES (430, 1, 38, 461, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595136175, 1595136175);
INSERT INTO `dd_member_account` VALUES (431, 1, 38, 462, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595136204, 1595136204);
INSERT INTO `dd_member_account` VALUES (432, 1, 38, 463, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595136943, 1595136943);
INSERT INTO `dd_member_account` VALUES (433, 1, 38, 464, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595136957, 1595136957);
INSERT INTO `dd_member_account` VALUES (434, 1, 38, 465, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595137149, 1595137149);
INSERT INTO `dd_member_account` VALUES (435, 1, 38, 466, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595137779, 1595137779);
INSERT INTO `dd_member_account` VALUES (436, 1, 38, 467, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595138132, 1595138132);
INSERT INTO `dd_member_account` VALUES (437, 1, 38, 468, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595138402, 1595138402);
INSERT INTO `dd_member_account` VALUES (438, 1, 38, 469, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595139376, 1595139376);
INSERT INTO `dd_member_account` VALUES (439, 1, 38, 470, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595140627, 1595140627);
INSERT INTO `dd_member_account` VALUES (440, 1, 38, 471, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595142235, 1595142235);
INSERT INTO `dd_member_account` VALUES (441, 1, 38, 472, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595142632, 1595142632);
INSERT INTO `dd_member_account` VALUES (442, 1, 38, 473, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595142760, 1595142760);
INSERT INTO `dd_member_account` VALUES (443, 1, 38, 474, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595142827, 1595142827);
INSERT INTO `dd_member_account` VALUES (444, 1, 38, 475, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595143233, 1595143233);
INSERT INTO `dd_member_account` VALUES (445, 1, 38, 476, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595144186, 1595144186);
INSERT INTO `dd_member_account` VALUES (446, 1, 38, 477, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595145922, 1595145922);
INSERT INTO `dd_member_account` VALUES (447, 1, 38, 478, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595149797, 1595149797);
INSERT INTO `dd_member_account` VALUES (448, 1, 38, 479, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595152523, 1595152523);
INSERT INTO `dd_member_account` VALUES (449, 1, 38, 480, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595152626, 1595152626);
INSERT INTO `dd_member_account` VALUES (450, 1, 38, 481, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595155049, 1595155049);
INSERT INTO `dd_member_account` VALUES (451, 1, 38, 482, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595156576, 1595156576);
INSERT INTO `dd_member_account` VALUES (452, 1, 38, 483, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595158186, 1595158186);
INSERT INTO `dd_member_account` VALUES (453, 1, 38, 484, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595160846, 1595160846);
INSERT INTO `dd_member_account` VALUES (454, 1, 38, 485, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595163237, 1595163237);
INSERT INTO `dd_member_account` VALUES (455, 1, 38, 486, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595174096, 1595174096);
INSERT INTO `dd_member_account` VALUES (456, 1, 38, 487, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595182726, 1595182726);
INSERT INTO `dd_member_account` VALUES (457, 1, 38, 488, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595203451, 1595203451);
INSERT INTO `dd_member_account` VALUES (458, 1, 38, 489, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595219225, 1595219225);
INSERT INTO `dd_member_account` VALUES (459, 1, 38, 490, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595227365, 1595227365);
INSERT INTO `dd_member_account` VALUES (460, 1, 38, 491, 1, 0.00, 0.00, 0.00, 0.00, 0.00, 0, 0, 0, 0.00, 0, 1, 1595227597, 1595227597);

-- ----------------------------
-- Table structure for dd_member_group
-- ----------------------------
DROP TABLE IF EXISTS `dd_member_group`;
CREATE TABLE `dd_member_group`  (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NULL DEFAULT NULL COMMENT '等级权重',
  `item_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `create_time` int(11) NULL DEFAULT NULL,
  `update_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`group_id`) USING BTREE,
  UNIQUE INDEX `item_name`(`item_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_member_group
-- ----------------------------
INSERT INTO `dd_member_group` VALUES (1, 1, '普通用户', 1580865152, NULL);
INSERT INTO `dd_member_group` VALUES (2, 2, 'vip1', 1580865194, NULL);
INSERT INTO `dd_member_group` VALUES (3, 3, 'vip2', 1580865207, NULL);

-- ----------------------------
-- Table structure for dd_menu
-- ----------------------------
DROP TABLE IF EXISTS `dd_menu`;
CREATE TABLE `dd_menu`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `parent` int(11) NULL DEFAULT NULL,
  `route` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `order` int(11) NULL DEFAULT 0,
  `data` blob NULL,
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `icon` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `is_sys` enum('system','addons') CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'system',
  `module_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `parent`(`parent`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 362 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_menu
-- ----------------------------
INSERT INTO `dd_menu` VALUES (1, '权限管理', NULL, '/admin/default/index', 5, NULL, 'sysai', 'fa fa-fw fa-sitemap', 'system', '');
INSERT INTO `dd_menu` VALUES (2, '权限维护', 1, '/admin/permission/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (3, '菜单路由', 1, '/admin/route/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (4, '用户组', 27, '/admin/group/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (5, '权限分配', 1, '/admin/assignment/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (6, '系统菜单', 1, '/admin/menu/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (9, '权限规则', 1, '/admin/rule/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (11, '系统设置', 75, '/system/settings/weburl', 1, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (25, '会员管理', NULL, '/member/dd-member/index', 7, NULL, 'member', 'fa fa-fw fa-user-plus', 'system', '');
INSERT INTO `dd_menu` VALUES (26, 'AI会员管理', 33, '/diandiai/dd-ai-member/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (27, '管理员管理', NULL, NULL, 4, NULL, 'sysai', 'fa fa-fw fa-group', 'system', '');
INSERT INTO `dd_menu` VALUES (28, '管理员', 27, '/admin/user/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (33, '人脸识别', NULL, '/diandiai/dd-ai-member/index', 8, NULL, 'aimember', 'fa fa-fw fa-eye', 'system', '');
INSERT INTO `dd_menu` VALUES (35, '人脸库管理', NULL, '/diandiai/dd-ai-faces/index', 9, NULL, 'aimember', 'fa fa-fw fa-camera-retro', 'system', '');
INSERT INTO `dd_menu` VALUES (36, '应用管理', 35, '/diandiai/dd-ai-applications/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (37, '人脸库分组', 35, '/diandiai/dd-ai-groups/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (38, '人脸管理', 35, '/diandiai/dd-ai-faces/index', NULL, NULL, 'aimember', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (39, '站点管理', NULL, '/website/dd-website-slide/index', 3, NULL, 'sysai', 'fa fa-fw fa-cubes', 'system', '');
INSERT INTO `dd_menu` VALUES (40, '幻灯片', 39, '/website/dd-website-slide/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (41, '文章管理', 39, '/article/dd-article/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (42, '文章分类', 41, '/article/dd-article-category/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (43, '文章列表', 41, '/article/dd-article/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (44, '联系我们', 39, '/website/dd-website-contact/index', NULL, NULL, 'sysai', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (45, '顶部导航', 1, '/admin/menu-top/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (46, '会员管理', 25, '/member/dd-member/index', NULL, NULL, 'member', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (49, '会员等级', 25, '/member/dd-member-group/index', NULL, NULL, 'member', '', 'system', NULL);
INSERT INTO `dd_menu` VALUES (60, '商品管理', 63, '/diandi_shop/goods/dd-goods/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (61, '商品分类', 63, '/diandi_shop/goods/dd-category/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (62, '订单管理', NULL, NULL, 4, NULL, 'plugins', 'fa fa-fw fa-list', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (63, '商品管理', NULL, NULL, 3, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (64, '订单管理', 62, '/diandi_shop/order/dd-order/index', NULL, NULL, 'plugins', 'fa fa-fw fa-clone', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (69, '商家设置', NULL, '/diandi_shop/setting/store/index', 2, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (70, '商家设置', 69, '/diandi_shop/setting/store/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (71, '评论管理', 69, '/diandi_shop/setting/comment/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (74, '配送点管理', 69, '/diandi_shop/setting/area/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (75, '系统管理', NULL, NULL, 1, NULL, 'sysai', 'fa fa-fw fa-dashboard', 'system', '');
INSERT INTO `dd_menu` VALUES (197, '站点设置', 39, '/website/setting/website', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (221, '商品标签', 63, '/diandi_shop/goods/label/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_shop');
INSERT INTO `dd_menu` VALUES (222, '公司管理', NULL, '/admin/bloc/index', 2, NULL, 'sysai', 'fa fa-fw fa-cogs', 'system', '');
INSERT INTO `dd_menu` VALUES (223, '快速生成', NULL, NULL, 10, NULL, 'sysai', 'fa fa-fw fa-key', 'system', '');
INSERT INTO `dd_menu` VALUES (224, '模块生成', 223, '/gii/addons', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (246, '配置项管理', 75, '/settings/default/index', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (247, '商圈管理1', NULL, 'area1', 0, NULL, 'plugins', NULL, 'addons', 'diandi_store');
INSERT INTO `dd_menu` VALUES (248, '商圈管理11', 247, 'area1_1', 0, NULL, 'plugins', NULL, 'addons', 'diandi_store');
INSERT INTO `dd_menu` VALUES (249, '商圈管理12', 247, 'area1_2', 0, NULL, 'plugins', NULL, 'addons', 'diandi_store');
INSERT INTO `dd_menu` VALUES (250, '商圈管理2', NULL, 'area2', 0, NULL, 'plugins', NULL, 'addons', 'diandi_store');
INSERT INTO `dd_menu` VALUES (251, '商圈管理21', 250, 'area2_1', 0, NULL, 'plugins', NULL, 'addons', 'diandi_store');
INSERT INTO `dd_menu` VALUES (252, '商圈管理22', 250, 'area2_2', 0, NULL, 'plugins', NULL, 'addons', 'diandi_store');
INSERT INTO `dd_menu` VALUES (253, '订座', NULL, '/diandi_store/default/index', NULL, NULL, 'plugins', NULL, 'addons', 'diandi_store');
INSERT INTO `dd_menu` VALUES (254, '扩展模块', NULL, '/addons/addons/index', 2, NULL, 'sysai', 'fa fa-fw fa-cloud-download', 'system', '');
INSERT INTO `dd_menu` VALUES (298, '店滴电商采集', 12, '/diandi_gathergoods/default/index', NULL, NULL, 'plugins', NULL, 'addons', 'diandi_gathergoods');
INSERT INTO `dd_menu` VALUES (299, '数据采集', NULL, '/diandi_gathergoods/ceshi/index', NULL, NULL, 'plugins', 'fa fa-fw fa-cart-plus', 'addons', 'diandi_gathergoods');
INSERT INTO `dd_menu` VALUES (300, '淘宝采集', 299, '/diandi_gathergoods/tao/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_gathergoods');
INSERT INTO `dd_menu` VALUES (302, '店滴分销', 12, '/diandi_distribution/default/index', NULL, NULL, 'plugins', NULL, 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (303, '聚合支付', 12, '/diandi_aggregate/default/index', NULL, NULL, 'plugins', NULL, 'addons', 'diandi_aggregate');
INSERT INTO `dd_menu` VALUES (304, '首页', NULL, NULL, NULL, NULL, 'plugins', 'fa fa-fw fa-cog', 'addons', 'diandi_aggregate');
INSERT INTO `dd_menu` VALUES (305, '参数配置', 304, '/diandi_aggregate/set/config/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_aggregate');
INSERT INTO `dd_menu` VALUES (306, '基础配置', NULL, NULL, NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (307, '价格配置', 306, '/diandi_distribution/conf/price-conf/index', NULL, NULL, 'plugins', 'fa fa-fw fa-jpy', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (308, '团队管理', 306, '/diandi_distribution/level/member-level/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (309, '分销商等级', 306, '/diandi_distribution/level/level/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (310, '商品', NULL, NULL, NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (311, '分销活动', 310, '/diandi_distribution/goods/goods/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (312, '礼包管理', 310, '/diandi_distribution/goods/gift/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (314, '材料管理', NULL, NULL, NULL, NULL, 'plugins', 'fa fa-fw fa-bar-chart', 'addons', 'diandi_pro');
INSERT INTO `dd_menu` VALUES (315, '产品管理', 314, '/diandi_pro/goods/goods/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_pro');
INSERT INTO `dd_menu` VALUES (317, '公共属性', 314, '/diandi_pro/template/param/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_pro');
INSERT INTO `dd_menu` VALUES (318, '模板库', 314, '/diandi_pro/template/template/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_pro');
INSERT INTO `dd_menu` VALUES (319, '科目管理', 314, '/diandi_pro/goods/category/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_pro');
INSERT INTO `dd_menu` VALUES (320, '数据库', 75, '/system/database/backups', NULL, NULL, 'sysai', '', 'system', '');
INSERT INTO `dd_menu` VALUES (334, '店滴抽奖', 12, '/diandi_lottery/default/index', NULL, NULL, 'plugins', NULL, 'addons', 'diandi_lottery');
INSERT INTO `dd_menu` VALUES (335, '抽奖管理', NULL, NULL, NULL, NULL, 'plugins', 'fa fa-fw fa-cog', 'addons', 'diandi_lottery');
INSERT INTO `dd_menu` VALUES (336, '抽奖说明', 335, '/diandi_lottery/template/index', NULL, NULL, 'plugins', 'fa fa-fw fa-th-list', 'addons', 'diandi_lottery');
INSERT INTO `dd_menu` VALUES (337, '抽奖联系人', 335, '/diandi_lottery/contact/index', NULL, NULL, 'plugins', 'fa fa-fw fa-user-plus', 'addons', 'diandi_lottery');
INSERT INTO `dd_menu` VALUES (338, '参与记录', 335, '/diandi_lottery/prizewin/index', NULL, NULL, 'plugins', 'fa fa-fw fa-edit', 'addons', 'diandi_lottery');
INSERT INTO `dd_menu` VALUES (339, '幻灯片', 335, '/diandi_lottery/slide/index', NULL, NULL, 'plugins', 'fa fa-fw fa-photo', 'addons', 'diandi_lottery');
INSERT INTO `dd_menu` VALUES (340, '抽奖活动', 335, '/diandi_lottery/active/index', NULL, NULL, 'plugins', 'fa fa-fw fa-bars', 'addons', 'diandi_lottery');
INSERT INTO `dd_menu` VALUES (341, '店滴分销', 306, '/diandi_distribution/default/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (342, '首页广告位', 310, '/diandi_distribution/goods/location/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (343, '商品推荐', 310, '/diandi_distribution/goods/location-goods/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (344, '幻灯片', 306, '/diandi_distribution/conf/slide/index', NULL, NULL, 'plugins', '', 'addons', 'diandi_distribution');
INSERT INTO `dd_menu` VALUES (361, '电信运营商', NULL, '/diandi_operator/default/index', NULL, NULL, 'plugins', NULL, 'addons', 'diandi_operator');

-- ----------------------------
-- Table structure for dd_menu_cate
-- ----------------------------
DROP TABLE IF EXISTS `dd_menu_cate`;
CREATE TABLE `dd_menu_cate`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `sort` int(11) NULL DEFAULT NULL,
  `create_time` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `update_time` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `icon` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 12 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_menu_cate
-- ----------------------------
INSERT INTO `dd_menu_cate` VALUES (1, '系统', 'sysai', 1, '1580017720', '1580016659', 'fa fa-fw fa-home');
INSERT INTO `dd_menu_cate` VALUES (2, '店滴AI', 'aimember', 2, '1580017890', '1580016673', 'fa fa-fw fa-eye');
INSERT INTO `dd_menu_cate` VALUES (3, '会员', 'member', 3, '1580017910', '1580016684', 'fa fa-fw fa-user-plus');

-- ----------------------------
-- Table structure for dd_message_notice_log
-- ----------------------------
DROP TABLE IF EXISTS `dd_message_notice_log`;
CREATE TABLE `dd_message_notice_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bloc_id` int(11) NULL DEFAULT NULL COMMENT '公司id',
  `store_id` int(11) NULL DEFAULT NULL COMMENT '商户id',
  `message` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '消息内容',
  `is_read` tinyint(3) NOT NULL COMMENT '是否阅读',
  `user_id` int(11) NOT NULL COMMENT '用户',
  `sign` varchar(22) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `type` tinyint(3) NOT NULL COMMENT '消息类型',
  `status` tinyint(3) NULL DEFAULT NULL COMMENT '消息状态',
  `create_time` int(11) NOT NULL,
  `end_time` int(11) NOT NULL,
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '链接地址',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_message_notice_log
-- ----------------------------

-- ----------------------------
-- Table structure for dd_modules
-- ----------------------------
DROP TABLE IF EXISTS `dd_modules`;
CREATE TABLE `dd_modules`  (
  `mid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '模块id',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '英文标识',
  `type` enum('base','business','marketing','member','other','system','enterprise','services') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'base' COMMENT '模块类型',
  `title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名称',
  `version` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '版本',
  `identifie` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ability` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '简介',
  `description` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '描述',
  `author` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '作者',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '社区地址',
  `settings` tinyint(1) NOT NULL COMMENT '配置',
  `logo` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'logo',
  PRIMARY KEY (`mid`) USING BTREE,
  INDEX `idx_name`(`name`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 19 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_modules
-- ----------------------------
INSERT INTO `dd_modules` VALUES (17, 'diandi_shop', 'business', '店滴会员卡', '1.0.0', NULL, '店滴会员卡', '店滴会员卡', 'chunchun', '23', 1, '202002/16/b4b9135c-5c04-38bf-ae78-2eb751fb428a.png');
INSERT INTO `dd_modules` VALUES (18, 'Nihao', 'business', '你好', '1.0.0', NULL, '简介', '描述', '王春生', 'www', 1, '202002/23/3c29f377-bd1e-3587-a345-fe9af72cad42.png');

-- ----------------------------
-- Table structure for dd_region
-- ----------------------------
DROP TABLE IF EXISTS `dd_region`;
CREATE TABLE `dd_region`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NULL DEFAULT NULL,
  `shortname` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `merger_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `level` tinyint(4) UNSIGNED NULL DEFAULT 0,
  `pinyin` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `zip_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `first` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `lng` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `lat` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `name,level`(`name`, `pid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3749 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dd_region
-- ----------------------------
INSERT INTO `dd_region` VALUES (1, 0, '北京', '北京市', '中国,北京', 1, 'beijing', '', '', 'B', '116.405285', '39.904989');
INSERT INTO `dd_region` VALUES (2, 1, '北京', '北京市', '中国,北京,北京市', 2, 'beijing', '010', '100000', 'B', '116.405285', '39.904989');
INSERT INTO `dd_region` VALUES (3, 2, '东城', '东城区', '中国,北京,北京市,东城区', 3, 'dongcheng', '010', '100010', 'D', '116.41005', '39.93157');
INSERT INTO `dd_region` VALUES (4, 2, '西城', '西城区', '中国,北京,北京市,西城区', 3, 'xicheng', '010', '100032', 'X', '116.36003', '39.9305');
INSERT INTO `dd_region` VALUES (5, 2, '朝阳', '朝阳区', '中国,北京,北京市,朝阳区', 3, 'chaoyang', '010', '100020', 'C', '116.48548', '39.9484');
INSERT INTO `dd_region` VALUES (6, 2, '丰台', '丰台区', '中国,北京,北京市,丰台区', 3, 'fengtai', '010', '100071', 'F', '116.28625', '39.8585');
INSERT INTO `dd_region` VALUES (7, 2, '石景山', '石景山区', '中国,北京,北京市,石景山区', 3, 'shijingshan', '010', '100043', 'S', '116.2229', '39.90564');
INSERT INTO `dd_region` VALUES (8, 2, '海淀', '海淀区', '中国,北京,北京市,海淀区', 3, 'haidian', '010', '100089', 'H', '116.29812', '39.95931');
INSERT INTO `dd_region` VALUES (9, 2, '门头沟', '门头沟区', '中国,北京,北京市,门头沟区', 3, 'mentougou', '010', '102300', 'M', '116.10137', '39.94043');
INSERT INTO `dd_region` VALUES (10, 2, '房山', '房山区', '中国,北京,北京市,房山区', 3, 'fangshan', '010', '102488', 'F', '116.14257', '39.74786');
INSERT INTO `dd_region` VALUES (11, 2, '通州', '通州区', '中国,北京,北京市,通州区', 3, 'tongzhou', '010', '101149', 'T', '116.65716', '39.90966');
INSERT INTO `dd_region` VALUES (12, 2, '顺义', '顺义区', '中国,北京,北京市,顺义区', 3, 'shunyi', '010', '101300', 'S', '116.65417', '40.1302');
INSERT INTO `dd_region` VALUES (13, 2, '昌平', '昌平区', '中国,北京,北京市,昌平区', 3, 'changping', '010', '102200', 'C', '116.2312', '40.22072');
INSERT INTO `dd_region` VALUES (14, 2, '大兴', '大兴区', '中国,北京,北京市,大兴区', 3, 'daxing', '010', '102600', 'D', '116.34149', '39.72668');
INSERT INTO `dd_region` VALUES (15, 2, '怀柔', '怀柔区', '中国,北京,北京市,怀柔区', 3, 'huairou', '010', '101400', 'H', '116.63168', '40.31602');
INSERT INTO `dd_region` VALUES (16, 2, '平谷', '平谷区', '中国,北京,北京市,平谷区', 3, 'pinggu', '010', '101200', 'P', '117.12133', '40.14056');
INSERT INTO `dd_region` VALUES (17, 2, '密云', '密云县', '中国,北京,北京市,密云县', 3, 'miyun', '010', '101500', 'M', '116.84295', '40.37618');
INSERT INTO `dd_region` VALUES (18, 2, '延庆', '延庆县', '中国,北京,北京市,延庆县', 3, 'yanqing', '010', '102100', 'Y', '115.97494', '40.45672');
INSERT INTO `dd_region` VALUES (19, 0, '天津', '天津市', '中国,天津', 1, 'tianjin', '', '', 'T', '117.190182', '39.125596');
INSERT INTO `dd_region` VALUES (20, 19, '天津', '天津市', '中国,天津,天津市', 2, 'tianjin', '022', '300000', 'T', '117.190182', '39.125596');
INSERT INTO `dd_region` VALUES (21, 20, '和平', '和平区', '中国,天津,天津市,和平区', 3, 'heping', '022', '300041', 'H', '117.21456', '39.11718');
INSERT INTO `dd_region` VALUES (22, 20, '河东', '河东区', '中国,天津,天津市,河东区', 3, 'hedong', '022', '300171', 'H', '117.22562', '39.12318');
INSERT INTO `dd_region` VALUES (23, 20, '河西', '河西区', '中国,天津,天津市,河西区', 3, 'hexi', '022', '300202', 'H', '117.22327', '39.10959');
INSERT INTO `dd_region` VALUES (24, 20, '南开', '南开区', '中国,天津,天津市,南开区', 3, 'nankai', '022', '300110', 'N', '117.15074', '39.13821');
INSERT INTO `dd_region` VALUES (25, 20, '河北', '河北区', '中国,天津,天津市,河北区', 3, 'hebei', '022', '300143', 'H', '117.19697', '39.14816');
INSERT INTO `dd_region` VALUES (26, 20, '红桥', '红桥区', '中国,天津,天津市,红桥区', 3, 'hongqiao', '022', '300131', 'H', '117.15145', '39.16715');
INSERT INTO `dd_region` VALUES (27, 20, '东丽', '东丽区', '中国,天津,天津市,东丽区', 3, 'dongli', '022', '300300', 'D', '117.31436', '39.0863');
INSERT INTO `dd_region` VALUES (28, 20, '西青', '西青区', '中国,天津,天津市,西青区', 3, 'xiqing', '022', '300380', 'X', '117.00927', '39.14123');
INSERT INTO `dd_region` VALUES (29, 20, '津南', '津南区', '中国,天津,天津市,津南区', 3, 'jinnan', '022', '300350', 'J', '117.38537', '38.99139');
INSERT INTO `dd_region` VALUES (30, 20, '北辰', '北辰区', '中国,天津,天津市,北辰区', 3, 'beichen', '022', '300400', 'B', '117.13217', '39.22131');
INSERT INTO `dd_region` VALUES (31, 20, '武清', '武清区', '中国,天津,天津市,武清区', 3, 'wuqing', '022', '301700', 'W', '117.04443', '39.38415');
INSERT INTO `dd_region` VALUES (32, 20, '宝坻', '宝坻区', '中国,天津,天津市,宝坻区', 3, 'baodi', '022', '301800', 'B', '117.3103', '39.71761');
INSERT INTO `dd_region` VALUES (33, 20, '滨海新区', '滨海新区', '中国,天津,天津市,滨海新区', 3, 'binhaixinqu', '022', '300451', 'B', '117.70162', '39.02668');
INSERT INTO `dd_region` VALUES (34, 20, '宁河', '宁河县', '中国,天津,天津市,宁河县', 3, 'ninghe', '022', '301500', 'N', '117.8255', '39.33048');
INSERT INTO `dd_region` VALUES (35, 20, '静海', '静海县', '中国,天津,天津市,静海县', 3, 'jinghai', '022', '301600', 'J', '116.97436', '38.94582');
INSERT INTO `dd_region` VALUES (36, 20, '蓟县', '蓟县', '中国,天津,天津市,蓟县', 3, 'jixian', '022', '301900', 'J', '117.40799', '40.04567');
INSERT INTO `dd_region` VALUES (37, 0, '河北', '河北省', '中国,河北省', 1, 'hebei', '', '', 'H', '114.502461', '38.045474');
INSERT INTO `dd_region` VALUES (38, 37, '石家庄', '石家庄市', '中国,河北省,石家庄市', 2, 'shijiazhuang', '0311', '050011', 'S', '114.502461', '38.045474');
INSERT INTO `dd_region` VALUES (39, 38, '长安', '长安区', '中国,河北省,石家庄市,长安区', 3, 'chang\'an', '0311', '050011', 'C', '114.53906', '38.03665');
INSERT INTO `dd_region` VALUES (40, 38, '桥西', '桥西区', '中国,河北省,石家庄市,桥西区', 3, 'qiaoxi', '0311', '050091', 'Q', '114.46977', '38.03221');
INSERT INTO `dd_region` VALUES (41, 38, '新华', '新华区', '中国,河北省,石家庄市,新华区', 3, 'xinhua', '0311', '050051', 'X', '114.46326', '38.05088');
INSERT INTO `dd_region` VALUES (42, 38, '井陉矿区', '井陉矿区', '中国,河北省,石家庄市,井陉矿区', 3, 'jingxingkuangqu', '0311', '050100', 'J', '114.06518', '38.06705');
INSERT INTO `dd_region` VALUES (43, 38, '裕华', '裕华区', '中国,河北省,石家庄市,裕华区', 3, 'yuhua', '0311', '050031', 'Y', '114.53115', '38.00604');
INSERT INTO `dd_region` VALUES (44, 38, '藁城', '藁城区', '中国,河北省,石家庄市,藁城区', 3, 'gaocheng', '0311', '052160', NULL, '114.84671', '38.02162');
INSERT INTO `dd_region` VALUES (45, 38, '鹿泉', '鹿泉区', '中国,河北省,石家庄市,鹿泉区', 3, 'luquan', '0311', '050200', 'L', '114.31347', '38.08782');
INSERT INTO `dd_region` VALUES (46, 38, '栾城', '栾城区', '中国,河北省,石家庄市,栾城区', 3, 'luancheng', '0311', '051430', NULL, '114.64834', '37.90022');
INSERT INTO `dd_region` VALUES (47, 38, '井陉', '井陉县', '中国,河北省,石家庄市,井陉县', 3, 'jingxing', '0311', '050300', 'J', '114.14257', '38.03688');
INSERT INTO `dd_region` VALUES (48, 38, '正定', '正定县', '中国,河北省,石家庄市,正定县', 3, 'zhengding', '0311', '050800', 'Z', '114.57296', '38.14445');
INSERT INTO `dd_region` VALUES (49, 38, '行唐', '行唐县', '中国,河北省,石家庄市,行唐县', 3, 'xingtang', '0311', '050600', 'X', '114.55316', '38.43654');
INSERT INTO `dd_region` VALUES (50, 38, '灵寿', '灵寿县', '中国,河北省,石家庄市,灵寿县', 3, 'lingshou', '0311', '050500', 'L', '114.38259', '38.30845');
INSERT INTO `dd_region` VALUES (51, 38, '高邑', '高邑县', '中国,河北省,石家庄市,高邑县', 3, 'gaoyi', '0311', '051330', 'G', '114.61142', '37.61556');
INSERT INTO `dd_region` VALUES (52, 38, '深泽', '深泽县', '中国,河北省,石家庄市,深泽县', 3, 'shenze', '0311', '052560', 'S', '115.20358', '38.18353');
INSERT INTO `dd_region` VALUES (53, 38, '赞皇', '赞皇县', '中国,河北省,石家庄市,赞皇县', 3, 'zanhuang', '0311', '051230', 'Z', '114.38775', '37.66135');
INSERT INTO `dd_region` VALUES (54, 38, '无极', '无极县', '中国,河北省,石家庄市,无极县', 3, 'wuji', '0311', '052460', 'W', '114.97509', '38.17653');
INSERT INTO `dd_region` VALUES (55, 38, '平山', '平山县', '中国,河北省,石家庄市,平山县', 3, 'pingshan', '0311', '050400', 'P', '114.186', '38.25994');
INSERT INTO `dd_region` VALUES (56, 38, '元氏', '元氏县', '中国,河北省,石家庄市,元氏县', 3, 'yuanshi', '0311', '051130', 'Y', '114.52539', '37.76668');
INSERT INTO `dd_region` VALUES (57, 38, '赵县', '赵县', '中国,河北省,石家庄市,赵县', 3, 'zhaoxian', '0311', '051530', 'Z', '114.77612', '37.75628');
INSERT INTO `dd_region` VALUES (58, 38, '辛集', '辛集市', '中国,河北省,石家庄市,辛集市', 3, 'xinji', '0311', '052360', 'X', '115.20626', '37.94079');
INSERT INTO `dd_region` VALUES (59, 38, '晋州', '晋州市', '中国,河北省,石家庄市,晋州市', 3, 'jinzhou', '0311', '052260', 'J', '115.04348', '38.03135');
INSERT INTO `dd_region` VALUES (60, 38, '新乐', '新乐市', '中国,河北省,石家庄市,新乐市', 3, 'xinle', '0311', '050700', 'X', '114.68985', '38.34417');
INSERT INTO `dd_region` VALUES (61, 37, '唐山', '唐山市', '中国,河北省,唐山市', 2, 'tangshan', '0315', '063000', 'T', '118.175393', '39.635113');
INSERT INTO `dd_region` VALUES (62, 61, '路南', '路南区', '中国,河北省,唐山市,路南区', 3, 'lunan', '0315', '063000', 'L', '118.15431', '39.62505');
INSERT INTO `dd_region` VALUES (63, 61, '路北', '路北区', '中国,河北省,唐山市,路北区', 3, 'lubei', '0315', '063000', 'L', '118.20079', '39.62436');
INSERT INTO `dd_region` VALUES (64, 61, '古冶', '古冶区', '中国,河北省,唐山市,古冶区', 3, 'guye', '0315', '063100', 'G', '118.45803', '39.71993');
INSERT INTO `dd_region` VALUES (65, 61, '开平', '开平区', '中国,河北省,唐山市,开平区', 3, 'kaiping', '0315', '063021', 'K', '118.26171', '39.67128');
INSERT INTO `dd_region` VALUES (66, 61, '丰南', '丰南区', '中国,河北省,唐山市,丰南区', 3, 'fengnan', '0315', '063300', 'F', '118.11282', '39.56483');
INSERT INTO `dd_region` VALUES (67, 61, '丰润', '丰润区', '中国,河北省,唐山市,丰润区', 3, 'fengrun', '0315', '064000', 'F', '118.12976', '39.8244');
INSERT INTO `dd_region` VALUES (68, 61, '曹妃甸', '曹妃甸区', '中国,河北省,唐山市,曹妃甸区', 3, 'caofeidian', '0315', '063200', 'C', '118.460379', '39.273070');
INSERT INTO `dd_region` VALUES (69, 61, '滦县', '滦县', '中国,河北省,唐山市,滦县', 3, 'luanxian', '0315', '063700', 'L', '118.70346', '39.74056');
INSERT INTO `dd_region` VALUES (70, 61, '滦南', '滦南县', '中国,河北省,唐山市,滦南县', 3, 'luannan', '0315', '063500', 'L', '118.6741', '39.5039');
INSERT INTO `dd_region` VALUES (71, 61, '乐亭', '乐亭县', '中国,河北省,唐山市,乐亭县', 3, 'laoting', '0315', '063600', 'L', '118.9125', '39.42561');
INSERT INTO `dd_region` VALUES (72, 61, '迁西', '迁西县', '中国,河北省,唐山市,迁西县', 3, 'qianxi', '0315', '064300', 'Q', '118.31616', '40.14587');
INSERT INTO `dd_region` VALUES (73, 61, '玉田', '玉田县', '中国,河北省,唐山市,玉田县', 3, 'yutian', '0315', '064100', 'Y', '117.7388', '39.90049');
INSERT INTO `dd_region` VALUES (74, 61, '遵化', '遵化市', '中国,河北省,唐山市,遵化市', 3, 'zunhua', '0315', '064200', 'Z', '117.96444', '40.18741');
INSERT INTO `dd_region` VALUES (75, 61, '迁安', '迁安市', '中国,河北省,唐山市,迁安市', 3, 'qian\'an', '0315', '064400', 'Q', '118.70068', '39.99833');
INSERT INTO `dd_region` VALUES (76, 37, '秦皇岛', '秦皇岛市', '中国,河北省,秦皇岛市', 2, 'qinhuangdao', '0335', '066000', 'Q', '119.586579', '39.942531');
INSERT INTO `dd_region` VALUES (77, 76, '海港', '海港区', '中国,河北省,秦皇岛市,海港区', 3, 'haigang', '0335', '066000', 'H', '119.61046', '39.9345');
INSERT INTO `dd_region` VALUES (78, 76, '山海关', '山海关区', '中国,河北省,秦皇岛市,山海关区', 3, 'shanhaiguan', '0335', '066200', 'S', '119.77563', '39.97869');
INSERT INTO `dd_region` VALUES (79, 76, '北戴河', '北戴河区', '中国,河北省,秦皇岛市,北戴河区', 3, 'beidaihe', '0335', '066100', 'B', '119.48388', '39.83408');
INSERT INTO `dd_region` VALUES (80, 76, '青龙', '青龙满族自治县', '中国,河北省,秦皇岛市,青龙满族自治县', 3, 'qinglong', '0335', '066500', 'Q', '118.95242', '40.40743');
INSERT INTO `dd_region` VALUES (81, 76, '昌黎', '昌黎县', '中国,河北省,秦皇岛市,昌黎县', 3, 'changli', '0335', '066600', 'C', '119.16595', '39.70884');
INSERT INTO `dd_region` VALUES (82, 76, '抚宁', '抚宁县', '中国,河北省,秦皇岛市,抚宁县', 3, 'funing', '0335', '066300', 'F', '119.24487', '39.87538');
INSERT INTO `dd_region` VALUES (83, 76, '卢龙', '卢龙县', '中国,河北省,秦皇岛市,卢龙县', 3, 'lulong', '0335', '066400', 'L', '118.89288', '39.89176');
INSERT INTO `dd_region` VALUES (84, 37, '邯郸', '邯郸市', '中国,河北省,邯郸市', 2, 'handan', '0310', '056002', 'H', '114.490686', '36.612273');
INSERT INTO `dd_region` VALUES (85, 84, '邯山', '邯山区', '中国,河北省,邯郸市,邯山区', 3, 'hanshan', '0310', '056001', 'H', '114.48375', '36.60006');
INSERT INTO `dd_region` VALUES (86, 84, '丛台', '丛台区', '中国,河北省,邯郸市,丛台区', 3, 'congtai', '0310', '056002', 'C', '114.49343', '36.61847');
INSERT INTO `dd_region` VALUES (87, 84, '复兴', '复兴区', '中国,河北省,邯郸市,复兴区', 3, 'fuxing', '0310', '056003', 'F', '114.45928', '36.61134');
INSERT INTO `dd_region` VALUES (88, 84, '峰峰矿区', '峰峰矿区', '中国,河北省,邯郸市,峰峰矿区', 3, 'fengfengkuangqu', '0310', '056200', 'F', '114.21148', '36.41937');
INSERT INTO `dd_region` VALUES (89, 84, '邯郸', '邯郸县', '中国,河北省,邯郸市,邯郸县', 3, 'handan', '0310', '056101', 'H', '114.53103', '36.59385');
INSERT INTO `dd_region` VALUES (90, 84, '临漳', '临漳县', '中国,河北省,邯郸市,临漳县', 3, 'linzhang', '0310', '056600', 'L', '114.6195', '36.33461');
INSERT INTO `dd_region` VALUES (91, 84, '成安', '成安县', '中国,河北省,邯郸市,成安县', 3, 'cheng\'an', '0310', '056700', 'C', '114.66995', '36.44411');
INSERT INTO `dd_region` VALUES (92, 84, '大名', '大名县', '中国,河北省,邯郸市,大名县', 3, 'daming', '0310', '056900', 'D', '115.15362', '36.27994');
INSERT INTO `dd_region` VALUES (93, 84, '涉县', '涉县', '中国,河北省,邯郸市,涉县', 3, 'shexian', '0310', '056400', 'S', '113.69183', '36.58072');
INSERT INTO `dd_region` VALUES (94, 84, '磁县', '磁县', '中国,河北省,邯郸市,磁县', 3, 'cixian', '0310', '056500', 'C', '114.37387', '36.37392');
INSERT INTO `dd_region` VALUES (95, 84, '肥乡', '肥乡县', '中国,河北省,邯郸市,肥乡县', 3, 'feixiang', '0310', '057550', 'F', '114.79998', '36.54807');
INSERT INTO `dd_region` VALUES (96, 84, '永年', '永年县', '中国,河北省,邯郸市,永年县', 3, 'yongnian', '0310', '057150', 'Y', '114.48925', '36.78356');
INSERT INTO `dd_region` VALUES (97, 84, '邱县', '邱县', '中国,河北省,邯郸市,邱县', 3, 'qiuxian', '0310', '057450', 'Q', '115.17407', '36.82082');
INSERT INTO `dd_region` VALUES (98, 84, '鸡泽', '鸡泽县', '中国,河北省,邯郸市,鸡泽县', 3, 'jize', '0310', '057350', 'J', '114.8742', '36.92374');
INSERT INTO `dd_region` VALUES (99, 84, '广平', '广平县', '中国,河北省,邯郸市,广平县', 3, 'guangping', '0310', '057650', 'G', '114.94653', '36.48046');
INSERT INTO `dd_region` VALUES (100, 84, '馆陶', '馆陶县', '中国,河北省,邯郸市,馆陶县', 3, 'guantao', '0310', '057750', 'G', '115.29913', '36.53719');
INSERT INTO `dd_region` VALUES (101, 84, '魏县', '魏县', '中国,河北省,邯郸市,魏县', 3, 'weixian', '0310', '056800', 'W', '114.93518', '36.36171');
INSERT INTO `dd_region` VALUES (102, 84, '曲周', '曲周县', '中国,河北省,邯郸市,曲周县', 3, 'quzhou', '0310', '057250', 'Q', '114.95196', '36.77671');
INSERT INTO `dd_region` VALUES (103, 84, '武安', '武安市', '中国,河北省,邯郸市,武安市', 3, 'wu\'an', '0310', '056300', 'W', '114.20153', '36.69281');
INSERT INTO `dd_region` VALUES (104, 37, '邢台', '邢台市', '中国,河北省,邢台市', 2, 'xingtai', '0319', '054001', 'X', '114.508851', '37.0682');
INSERT INTO `dd_region` VALUES (105, 104, '桥东', '桥东区', '中国,河北省,邢台市,桥东区', 3, 'qiaodong', '0319', '054001', 'Q', '114.50725', '37.06801');
INSERT INTO `dd_region` VALUES (106, 104, '桥西', '桥西区', '中国,河北省,邢台市,桥西区', 3, 'qiaoxi', '0319', '054000', 'Q', '114.46803', '37.05984');
INSERT INTO `dd_region` VALUES (107, 104, '邢台', '邢台县', '中国,河北省,邢台市,邢台县', 3, 'xingtai', '0319', '054001', 'X', '114.56575', '37.0456');
INSERT INTO `dd_region` VALUES (108, 104, '临城', '临城县', '中国,河北省,邢台市,临城县', 3, 'lincheng', '0319', '054300', 'L', '114.50387', '37.43977');
INSERT INTO `dd_region` VALUES (109, 104, '内丘', '内丘县', '中国,河北省,邢台市,内丘县', 3, 'neiqiu', '0319', '054200', 'N', '114.51212', '37.28671');
INSERT INTO `dd_region` VALUES (110, 104, '柏乡', '柏乡县', '中国,河北省,邢台市,柏乡县', 3, 'baixiang', '0319', '055450', 'B', '114.69332', '37.48242');
INSERT INTO `dd_region` VALUES (111, 104, '隆尧', '隆尧县', '中国,河北省,邢台市,隆尧县', 3, 'longyao', '0319', '055350', 'L', '114.77615', '37.35351');
INSERT INTO `dd_region` VALUES (112, 104, '任县', '任县', '中国,河北省,邢台市,任县', 3, 'renxian', '0319', '055150', 'R', '114.6842', '37.12575');
INSERT INTO `dd_region` VALUES (113, 104, '南和', '南和县', '中国,河北省,邢台市,南和县', 3, 'nanhe', '0319', '054400', 'N', '114.68371', '37.00488');
INSERT INTO `dd_region` VALUES (114, 104, '宁晋', '宁晋县', '中国,河北省,邢台市,宁晋县', 3, 'ningjin', '0319', '055550', 'N', '114.92117', '37.61696');
INSERT INTO `dd_region` VALUES (115, 104, '巨鹿', '巨鹿县', '中国,河北省,邢台市,巨鹿县', 3, 'julu', '0319', '055250', 'J', '115.03524', '37.21801');
INSERT INTO `dd_region` VALUES (116, 104, '新河', '新河县', '中国,河北省,邢台市,新河县', 3, 'xinhe', '0319', '055650', 'X', '115.24987', '37.52718');
INSERT INTO `dd_region` VALUES (117, 104, '广宗', '广宗县', '中国,河北省,邢台市,广宗县', 3, 'guangzong', '0319', '054600', 'G', '115.14254', '37.0746');
INSERT INTO `dd_region` VALUES (118, 104, '平乡', '平乡县', '中国,河北省,邢台市,平乡县', 3, 'pingxiang', '0319', '054500', 'P', '115.03002', '37.06317');
INSERT INTO `dd_region` VALUES (119, 104, '威县', '威县', '中国,河北省,邢台市,威县', 3, 'weixian', '0319', '054700', 'W', '115.2637', '36.9768');
INSERT INTO `dd_region` VALUES (120, 104, '清河', '清河县', '中国,河北省,邢台市,清河县', 3, 'qinghe', '0319', '054800', 'Q', '115.66479', '37.07122');
INSERT INTO `dd_region` VALUES (121, 104, '临西', '临西县', '中国,河北省,邢台市,临西县', 3, 'linxi', '0319', '054900', 'L', '115.50097', '36.87078');
INSERT INTO `dd_region` VALUES (122, 104, '南宫', '南宫市', '中国,河北省,邢台市,南宫市', 3, 'nangong', '0319', '055750', 'N', '115.39068', '37.35799');
INSERT INTO `dd_region` VALUES (123, 104, '沙河', '沙河市', '中国,河北省,邢台市,沙河市', 3, 'shahe', '0319', '054100', 'S', '114.4981', '36.8577');
INSERT INTO `dd_region` VALUES (124, 37, '保定', '保定市', '中国,河北省,保定市', 2, 'baoding', '0312', '071052', 'B', '115.482331', '38.867657');
INSERT INTO `dd_region` VALUES (125, 124, '新市', '新市区', '中国,河北省,保定市,新市区', 3, 'xinshi', '0312', '071051', 'X', '115.4587', '38.87751');
INSERT INTO `dd_region` VALUES (126, 124, '北市', '北市区', '中国,河北省,保定市,北市区', 3, 'beishi', '0312', '071000', 'B', '115.49715', '38.88322');
INSERT INTO `dd_region` VALUES (127, 124, '南市', '南市区', '中国,河北省,保定市,南市区', 3, 'nanshi', '0312', '071001', 'N', '115.52859', '38.85455');
INSERT INTO `dd_region` VALUES (128, 124, '满城', '满城县', '中国,河北省,保定市,满城县', 3, 'mancheng', '0312', '072150', 'M', '115.32296', '38.94972');
INSERT INTO `dd_region` VALUES (129, 124, '清苑', '清苑县', '中国,河北省,保定市,清苑县', 3, 'qingyuan', '0312', '071100', 'Q', '115.49267', '38.76709');
INSERT INTO `dd_region` VALUES (130, 124, '涞水', '涞水县', '中国,河北省,保定市,涞水县', 3, 'laishui', '0312', '074100', NULL, '115.71517', '39.39404');
INSERT INTO `dd_region` VALUES (131, 124, '阜平', '阜平县', '中国,河北省,保定市,阜平县', 3, 'fuping', '0312', '073200', 'F', '114.19683', '38.84763');
INSERT INTO `dd_region` VALUES (132, 124, '徐水', '徐水县', '中国,河北省,保定市,徐水县', 3, 'xushui', '0312', '072550', 'X', '115.65829', '39.02099');
INSERT INTO `dd_region` VALUES (133, 124, '定兴', '定兴县', '中国,河北省,保定市,定兴县', 3, 'dingxing', '0312', '072650', 'D', '115.80786', '39.26312');
INSERT INTO `dd_region` VALUES (134, 124, '唐县', '唐县', '中国,河北省,保定市,唐县', 3, 'tangxian', '0312', '072350', 'T', '114.98516', '38.74513');
INSERT INTO `dd_region` VALUES (135, 124, '高阳', '高阳县', '中国,河北省,保定市,高阳县', 3, 'gaoyang', '0312', '071500', 'G', '115.7788', '38.70003');
INSERT INTO `dd_region` VALUES (136, 124, '容城', '容城县', '中国,河北省,保定市,容城县', 3, 'rongcheng', '0312', '071700', 'R', '115.87158', '39.0535');
INSERT INTO `dd_region` VALUES (137, 124, '涞源', '涞源县', '中国,河北省,保定市,涞源县', 3, 'laiyuan', '0312', '074300', NULL, '114.69128', '39.35388');
INSERT INTO `dd_region` VALUES (138, 124, '望都', '望都县', '中国,河北省,保定市,望都县', 3, 'wangdu', '0312', '072450', 'W', '115.1567', '38.70996');
INSERT INTO `dd_region` VALUES (139, 124, '安新', '安新县', '中国,河北省,保定市,安新县', 3, 'anxin', '0312', '071600', 'A', '115.93557', '38.93532');
INSERT INTO `dd_region` VALUES (140, 124, '易县', '易县', '中国,河北省,保定市,易县', 3, 'yixian', '0312', '074200', 'Y', '115.4981', '39.34885');
INSERT INTO `dd_region` VALUES (141, 124, '曲阳', '曲阳县', '中国,河北省,保定市,曲阳县', 3, 'quyang', '0312', '073100', 'Q', '114.70123', '38.62154');
INSERT INTO `dd_region` VALUES (142, 124, '蠡县', '蠡县', '中国,河北省,保定市,蠡县', 3, 'lixian', '0312', '071400', NULL, '115.57717', '38.48974');
INSERT INTO `dd_region` VALUES (143, 124, '顺平', '顺平县', '中国,河北省,保定市,顺平县', 3, 'shunping', '0312', '072250', 'S', '115.1347', '38.83854');
INSERT INTO `dd_region` VALUES (144, 124, '博野', '博野县', '中国,河北省,保定市,博野县', 3, 'boye', '0312', '071300', 'B', '115.47033', '38.4564');
INSERT INTO `dd_region` VALUES (145, 124, '雄县', '雄县', '中国,河北省,保定市,雄县', 3, 'xiongxian', '0312', '071800', 'X', '116.10873', '38.99442');
INSERT INTO `dd_region` VALUES (146, 124, '涿州', '涿州市', '中国,河北省,保定市,涿州市', 3, 'zhuozhou', '0312', '072750', NULL, '115.98062', '39.48622');
INSERT INTO `dd_region` VALUES (147, 124, '定州', '定州市', '中国,河北省,保定市,定州市', 3, 'dingzhou', '0312', '073000', 'D', '114.9902', '38.51623');
INSERT INTO `dd_region` VALUES (148, 124, '安国', '安国市', '中国,河北省,保定市,安国市', 3, 'anguo', '0312', '071200', 'A', '115.32321', '38.41391');
INSERT INTO `dd_region` VALUES (149, 124, '高碑店', '高碑店市', '中国,河北省,保定市,高碑店市', 3, 'gaobeidian', '0312', '074000', 'G', '115.87368', '39.32655');
INSERT INTO `dd_region` VALUES (150, 37, '张家口', '张家口市', '中国,河北省,张家口市', 2, 'zhangjiakou', '0313', '075000', 'Z', '114.884091', '40.811901');
INSERT INTO `dd_region` VALUES (151, 150, '桥东', '桥东区', '中国,河北省,张家口市,桥东区', 3, 'qiaodong', '0313', '075000', 'Q', '114.8943', '40.78844');
INSERT INTO `dd_region` VALUES (152, 150, '桥西', '桥西区', '中国,河北省,张家口市,桥西区', 3, 'qiaoxi', '0313', '075061', 'Q', '114.86962', '40.81945');
INSERT INTO `dd_region` VALUES (153, 150, '宣化', '宣化区', '中国,河北省,张家口市,宣化区', 3, 'xuanhua', '0313', '075100', 'X', '115.06543', '40.60957');
INSERT INTO `dd_region` VALUES (154, 150, '下花园', '下花园区', '中国,河北省,张家口市,下花园区', 3, 'xiahuayuan', '0313', '075300', 'X', '115.28744', '40.50236');
INSERT INTO `dd_region` VALUES (155, 150, '宣化', '宣化县', '中国,河北省,张家口市,宣化县', 3, 'xuanhua', '0313', '075100', 'X', '115.15497', '40.56618');
INSERT INTO `dd_region` VALUES (156, 150, '张北', '张北县', '中国,河北省,张家口市,张北县', 3, 'zhangbei', '0313', '076450', 'Z', '114.71432', '41.15977');
INSERT INTO `dd_region` VALUES (157, 150, '康保', '康保县', '中国,河北省,张家口市,康保县', 3, 'kangbao', '0313', '076650', 'K', '114.60031', '41.85225');
INSERT INTO `dd_region` VALUES (158, 150, '沽源', '沽源县', '中国,河北省,张家口市,沽源县', 3, 'guyuan', '0313', '076550', 'G', '115.68859', '41.66959');
INSERT INTO `dd_region` VALUES (159, 150, '尚义', '尚义县', '中国,河北省,张家口市,尚义县', 3, 'shangyi', '0313', '076750', 'S', '113.97134', '41.07782');
INSERT INTO `dd_region` VALUES (160, 150, '蔚县', '蔚县', '中国,河北省,张家口市,蔚县', 3, 'yuxian', '0313', '075700', 'W', '114.58892', '39.84067');
INSERT INTO `dd_region` VALUES (161, 150, '阳原', '阳原县', '中国,河北省,张家口市,阳原县', 3, 'yangyuan', '0313', '075800', 'Y', '114.15051', '40.10361');
INSERT INTO `dd_region` VALUES (162, 150, '怀安', '怀安县', '中国,河北省,张家口市,怀安县', 3, 'huai\'an', '0313', '076150', 'H', '114.38559', '40.67425');
INSERT INTO `dd_region` VALUES (163, 150, '万全', '万全县', '中国,河北省,张家口市,万全县', 3, 'wanquan', '0313', '076250', 'W', '114.7405', '40.76694');
INSERT INTO `dd_region` VALUES (164, 150, '怀来', '怀来县', '中国,河北省,张家口市,怀来县', 3, 'huailai', '0313', '075400', 'H', '115.51773', '40.41536');
INSERT INTO `dd_region` VALUES (165, 150, '涿鹿', '涿鹿县', '中国,河北省,张家口市,涿鹿县', 3, 'zhuolu', '0313', '075600', NULL, '115.22403', '40.37636');
INSERT INTO `dd_region` VALUES (166, 150, '赤城', '赤城县', '中国,河北省,张家口市,赤城县', 3, 'chicheng', '0313', '075500', 'C', '115.83187', '40.91438');
INSERT INTO `dd_region` VALUES (167, 150, '崇礼', '崇礼县', '中国,河北省,张家口市,崇礼县', 3, 'chongli', '0313', '076350', 'C', '115.27993', '40.97519');
INSERT INTO `dd_region` VALUES (168, 37, '承德', '承德市', '中国,河北省,承德市', 2, 'chengde', '0314', '067000', 'C', '117.939152', '40.976204');
INSERT INTO `dd_region` VALUES (169, 168, '双桥', '双桥区', '中国,河北省,承德市,双桥区', 3, 'shuangqiao', '0314', '067000', 'S', '117.9432', '40.97466');
INSERT INTO `dd_region` VALUES (170, 168, '双滦', '双滦区', '中国,河北省,承德市,双滦区', 3, 'shuangluan', '0314', '067001', 'S', '117.74487', '40.95375');
INSERT INTO `dd_region` VALUES (171, 168, '鹰手营子矿区', '鹰手营子矿区', '中国,河北省,承德市,鹰手营子矿区', 3, 'yingshouyingzikuangqu', '0314', '067200', 'Y', '117.65985', '40.54744');
INSERT INTO `dd_region` VALUES (172, 168, '承德', '承德县', '中国,河北省,承德市,承德县', 3, 'chengde', '0314', '067400', 'C', '118.17639', '40.76985');
INSERT INTO `dd_region` VALUES (173, 168, '兴隆', '兴隆县', '中国,河北省,承德市,兴隆县', 3, 'xinglong', '0314', '067300', 'X', '117.50073', '40.41709');
INSERT INTO `dd_region` VALUES (174, 168, '平泉', '平泉县', '中国,河北省,承德市,平泉县', 3, 'pingquan', '0314', '067500', 'P', '118.70196', '41.01839');
INSERT INTO `dd_region` VALUES (175, 168, '滦平', '滦平县', '中国,河北省,承德市,滦平县', 3, 'luanping', '0314', '068250', 'L', '117.33276', '40.94148');
INSERT INTO `dd_region` VALUES (176, 168, '隆化', '隆化县', '中国,河北省,承德市,隆化县', 3, 'longhua', '0314', '068150', 'L', '117.7297', '41.31412');
INSERT INTO `dd_region` VALUES (177, 168, '丰宁', '丰宁满族自治县', '中国,河北省,承德市,丰宁满族自治县', 3, 'fengning', '0314', '068350', 'F', '116.6492', '41.20481');
INSERT INTO `dd_region` VALUES (178, 168, '宽城', '宽城满族自治县', '中国,河北省,承德市,宽城满族自治县', 3, 'kuancheng', '0314', '067600', 'K', '118.49176', '40.60829');
INSERT INTO `dd_region` VALUES (179, 168, '围场', '围场满族蒙古族自治县', '中国,河北省,承德市,围场满族蒙古族自治县', 3, 'weichang', '0314', '068450', 'W', '117.7601', '41.94368');
INSERT INTO `dd_region` VALUES (180, 37, '沧州', '沧州市', '中国,河北省,沧州市', 2, 'cangzhou', '0317', '061001', 'C', '116.857461', '38.310582');
INSERT INTO `dd_region` VALUES (181, 180, '新华', '新华区', '中国,河北省,沧州市,新华区', 3, 'xinhua', '0317', '061000', 'X', '116.86643', '38.31438');
INSERT INTO `dd_region` VALUES (182, 180, '运河', '运河区', '中国,河北省,沧州市,运河区', 3, 'yunhe', '0317', '061001', 'Y', '116.85706', '38.31352');
INSERT INTO `dd_region` VALUES (183, 180, '沧县', '沧县', '中国,河北省,沧州市,沧县', 3, 'cangxian', '0317', '061000', 'C', '116.87817', '38.29361');
INSERT INTO `dd_region` VALUES (184, 180, '青县', '青县', '中国,河北省,沧州市,青县', 3, 'qingxian', '0317', '062650', 'Q', '116.80316', '38.58345');
INSERT INTO `dd_region` VALUES (185, 180, '东光', '东光县', '中国,河北省,沧州市,东光县', 3, 'dongguang', '0317', '061600', 'D', '116.53668', '37.8857');
INSERT INTO `dd_region` VALUES (186, 180, '海兴', '海兴县', '中国,河北省,沧州市,海兴县', 3, 'haixing', '0317', '061200', 'H', '117.49758', '38.13958');
INSERT INTO `dd_region` VALUES (187, 180, '盐山', '盐山县', '中国,河北省,沧州市,盐山县', 3, 'yanshan', '0317', '061300', 'Y', '117.23092', '38.05647');
INSERT INTO `dd_region` VALUES (188, 180, '肃宁', '肃宁县', '中国,河北省,沧州市,肃宁县', 3, 'suning', '0317', '062350', 'S', '115.82971', '38.42272');
INSERT INTO `dd_region` VALUES (189, 180, '南皮', '南皮县', '中国,河北省,沧州市,南皮县', 3, 'nanpi', '0317', '061500', 'N', '116.70224', '38.04109');
INSERT INTO `dd_region` VALUES (190, 180, '吴桥', '吴桥县', '中国,河北省,沧州市,吴桥县', 3, 'wuqiao', '0317', '061800', 'W', '116.3847', '37.62546');
INSERT INTO `dd_region` VALUES (191, 180, '献县', '献县', '中国,河北省,沧州市,献县', 3, 'xianxian', '0317', '062250', 'X', '116.12695', '38.19228');
INSERT INTO `dd_region` VALUES (192, 180, '孟村', '孟村回族自治县', '中国,河北省,沧州市,孟村回族自治县', 3, 'mengcun', '0317', '061400', 'M', '117.10412', '38.05338');
INSERT INTO `dd_region` VALUES (193, 180, '泊头', '泊头市', '中国,河北省,沧州市,泊头市', 3, 'botou', '0317', '062150', 'B', '116.57824', '38.08359');
INSERT INTO `dd_region` VALUES (194, 180, '任丘', '任丘市', '中国,河北省,沧州市,任丘市', 3, 'renqiu', '0317', '062550', 'R', '116.1033', '38.71124');
INSERT INTO `dd_region` VALUES (195, 180, '黄骅', '黄骅市', '中国,河北省,沧州市,黄骅市', 3, 'huanghua', '0317', '061100', 'H', '117.33883', '38.3706');
INSERT INTO `dd_region` VALUES (196, 180, '河间', '河间市', '中国,河北省,沧州市,河间市', 3, 'hejian', '0317', '062450', 'H', '116.0993', '38.44549');
INSERT INTO `dd_region` VALUES (197, 37, '廊坊', '廊坊市', '中国,河北省,廊坊市', 2, 'langfang', '0316', '065000', 'L', '116.713873', '39.529244');
INSERT INTO `dd_region` VALUES (198, 197, '安次', '安次区', '中国,河北省,廊坊市,安次区', 3, 'anci', '0316', '065000', 'A', '116.70308', '39.52057');
INSERT INTO `dd_region` VALUES (199, 197, '广阳', '广阳区', '中国,河北省,廊坊市,广阳区', 3, 'guangyang', '0316', '065000', 'G', '116.71069', '39.52278');
INSERT INTO `dd_region` VALUES (200, 197, '固安', '固安县', '中国,河北省,廊坊市,固安县', 3, 'gu\'an', '0316', '065500', 'G', '116.29916', '39.43833');
INSERT INTO `dd_region` VALUES (201, 197, '永清', '永清县', '中国,河北省,廊坊市,永清县', 3, 'yongqing', '0316', '065600', 'Y', '116.50091', '39.32069');
INSERT INTO `dd_region` VALUES (202, 197, '香河', '香河县', '中国,河北省,廊坊市,香河县', 3, 'xianghe', '0316', '065400', 'X', '117.00634', '39.76133');
INSERT INTO `dd_region` VALUES (203, 197, '大城', '大城县', '中国,河北省,廊坊市,大城县', 3, 'daicheng', '0316', '065900', 'D', '116.65353', '38.70534');
INSERT INTO `dd_region` VALUES (204, 197, '文安', '文安县', '中国,河北省,廊坊市,文安县', 3, 'wen\'an', '0316', '065800', 'W', '116.45846', '38.87325');
INSERT INTO `dd_region` VALUES (205, 197, '大厂', '大厂回族自治县', '中国,河北省,廊坊市,大厂回族自治县', 3, 'dachang', '0316', '065300', 'D', '116.98916', '39.88649');
INSERT INTO `dd_region` VALUES (206, 197, '霸州', '霸州市', '中国,河北省,廊坊市,霸州市', 3, 'bazhou', '0316', '065700', 'B', '116.39154', '39.12569');
INSERT INTO `dd_region` VALUES (207, 197, '三河', '三河市', '中国,河北省,廊坊市,三河市', 3, 'sanhe', '0316', '065200', 'S', '117.07229', '39.98358');
INSERT INTO `dd_region` VALUES (208, 37, '衡水', '衡水市', '中国,河北省,衡水市', 2, 'hengshui', '0318', '053000', 'H', '115.665993', '37.735097');
INSERT INTO `dd_region` VALUES (209, 208, '桃城', '桃城区', '中国,河北省,衡水市,桃城区', 3, 'taocheng', '0318', '053000', 'T', '115.67529', '37.73499');
INSERT INTO `dd_region` VALUES (210, 208, '枣强', '枣强县', '中国,河北省,衡水市,枣强县', 3, 'zaoqiang', '0318', '053100', 'Z', '115.72576', '37.51027');
INSERT INTO `dd_region` VALUES (211, 208, '武邑', '武邑县', '中国,河北省,衡水市,武邑县', 3, 'wuyi', '0318', '053400', 'W', '115.88748', '37.80181');
INSERT INTO `dd_region` VALUES (212, 208, '武强', '武强县', '中国,河北省,衡水市,武强县', 3, 'wuqiang', '0318', '053300', 'W', '115.98226', '38.04138');
INSERT INTO `dd_region` VALUES (213, 208, '饶阳', '饶阳县', '中国,河北省,衡水市,饶阳县', 3, 'raoyang', '0318', '053900', 'R', '115.72558', '38.23529');
INSERT INTO `dd_region` VALUES (214, 208, '安平', '安平县', '中国,河北省,衡水市,安平县', 3, 'anping', '0318', '053600', 'A', '115.51876', '38.23388');
INSERT INTO `dd_region` VALUES (215, 208, '故城', '故城县', '中国,河北省,衡水市,故城县', 3, 'gucheng', '0318', '053800', 'G', '115.97076', '37.34773');
INSERT INTO `dd_region` VALUES (216, 208, '景县', '景县', '中国,河北省,衡水市,景县', 3, 'jingxian', '0318', '053500', 'J', '116.26904', '37.6926');
INSERT INTO `dd_region` VALUES (217, 208, '阜城', '阜城县', '中国,河北省,衡水市,阜城县', 3, 'fucheng', '0318', '053700', 'F', '116.14431', '37.86881');
INSERT INTO `dd_region` VALUES (218, 208, '冀州', '冀州市', '中国,河北省,衡水市,冀州市', 3, 'jizhou', '0318', '053200', 'J', '115.57934', '37.55082');
INSERT INTO `dd_region` VALUES (219, 208, '深州', '深州市', '中国,河北省,衡水市,深州市', 3, 'shenzhou', '0318', '053800', 'S', '115.55993', '38.00109');
INSERT INTO `dd_region` VALUES (220, 0, '山西', '山西省', '中国,山西省', 1, 'shanxi', '', '', 'S', '112.549248', '37.857014');
INSERT INTO `dd_region` VALUES (221, 220, '太原', '太原市', '中国,山西省,太原市', 2, 'taiyuan', '0351', '030082', 'T', '112.549248', '37.857014');
INSERT INTO `dd_region` VALUES (222, 221, '小店', '小店区', '中国,山西省,太原市,小店区', 3, 'xiaodian', '0351', '030032', 'X', '112.56878', '37.73565');
INSERT INTO `dd_region` VALUES (223, 221, '迎泽', '迎泽区', '中国,山西省,太原市,迎泽区', 3, 'yingze', '0351', '030002', 'Y', '112.56338', '37.86326');
INSERT INTO `dd_region` VALUES (224, 221, '杏花岭', '杏花岭区', '中国,山西省,太原市,杏花岭区', 3, 'xinghualing', '0351', '030009', 'X', '112.56237', '37.88429');
INSERT INTO `dd_region` VALUES (225, 221, '尖草坪', '尖草坪区', '中国,山西省,太原市,尖草坪区', 3, 'jiancaoping', '0351', '030023', 'J', '112.48709', '37.94193');
INSERT INTO `dd_region` VALUES (226, 221, '万柏林', '万柏林区', '中国,山西省,太原市,万柏林区', 3, 'wanbailin', '0351', '030024', 'W', '112.51553', '37.85923');
INSERT INTO `dd_region` VALUES (227, 221, '晋源', '晋源区', '中国,山西省,太原市,晋源区', 3, 'jinyuan', '0351', '030025', 'J', '112.47985', '37.72479');
INSERT INTO `dd_region` VALUES (228, 221, '清徐', '清徐县', '中国,山西省,太原市,清徐县', 3, 'qingxu', '0351', '030400', 'Q', '112.35888', '37.60758');
INSERT INTO `dd_region` VALUES (229, 221, '阳曲', '阳曲县', '中国,山西省,太原市,阳曲县', 3, 'yangqu', '0351', '030100', 'Y', '112.67861', '38.05989');
INSERT INTO `dd_region` VALUES (230, 221, '娄烦', '娄烦县', '中国,山西省,太原市,娄烦县', 3, 'loufan', '0351', '030300', 'L', '111.79473', '38.06689');
INSERT INTO `dd_region` VALUES (231, 221, '古交', '古交市', '中国,山西省,太原市,古交市', 3, 'gujiao', '0351', '030200', 'G', '112.16918', '37.90983');
INSERT INTO `dd_region` VALUES (232, 220, '大同', '大同市', '中国,山西省,大同市', 2, 'datong', '0352', '037008', 'D', '113.295259', '40.09031');
INSERT INTO `dd_region` VALUES (233, 232, '城区', '城区', '中国,山西省,大同市,城区', 3, 'chengqu', '0352', '037008', 'C', '113.298', '40.07566');
INSERT INTO `dd_region` VALUES (234, 232, '矿区', '矿区', '中国,山西省,大同市,矿区', 3, 'kuangqu', '0352', '037003', 'K', '113.1772', '40.03685');
INSERT INTO `dd_region` VALUES (235, 232, '南郊', '南郊区', '中国,山西省,大同市,南郊区', 3, 'nanjiao', '0352', '037001', 'N', '113.14947', '40.00539');
INSERT INTO `dd_region` VALUES (236, 232, '新荣', '新荣区', '中国,山西省,大同市,新荣区', 3, 'xinrong', '0352', '037002', 'X', '113.13504', '40.25618');
INSERT INTO `dd_region` VALUES (237, 232, '阳高', '阳高县', '中国,山西省,大同市,阳高县', 3, 'yanggao', '0352', '038100', 'Y', '113.75012', '40.36256');
INSERT INTO `dd_region` VALUES (238, 232, '天镇', '天镇县', '中国,山西省,大同市,天镇县', 3, 'tianzhen', '0352', '038200', 'T', '114.0931', '40.42299');
INSERT INTO `dd_region` VALUES (239, 232, '广灵', '广灵县', '中国,山西省,大同市,广灵县', 3, 'guangling', '0352', '037500', 'G', '114.28204', '39.76082');
INSERT INTO `dd_region` VALUES (240, 232, '灵丘', '灵丘县', '中国,山西省,大同市,灵丘县', 3, 'lingqiu', '0352', '034400', 'L', '114.23672', '39.44043');
INSERT INTO `dd_region` VALUES (241, 232, '浑源', '浑源县', '中国,山西省,大同市,浑源县', 3, 'hunyuan', '0352', '037400', 'H', '113.69552', '39.69962');
INSERT INTO `dd_region` VALUES (242, 232, '左云', '左云县', '中国,山西省,大同市,左云县', 3, 'zuoyun', '0352', '037100', 'Z', '112.70266', '40.01336');
INSERT INTO `dd_region` VALUES (243, 232, '大同', '大同县', '中国,山西省,大同市,大同县', 3, 'datong', '0352', '037300', 'D', '113.61212', '40.04012');
INSERT INTO `dd_region` VALUES (244, 220, '阳泉', '阳泉市', '中国,山西省,阳泉市', 2, 'yangquan', '0353', '045000', 'Y', '113.583285', '37.861188');
INSERT INTO `dd_region` VALUES (245, 244, '城区', '城区', '中国,山西省,阳泉市,城区', 3, 'chengqu', '0353', '045000', 'C', '113.60069', '37.8474');
INSERT INTO `dd_region` VALUES (246, 244, '矿区', '矿区', '中国,山西省,阳泉市,矿区', 3, 'kuangqu', '0353', '045000', 'K', '113.55677', '37.86895');
INSERT INTO `dd_region` VALUES (247, 244, '郊区', '郊区', '中国,山西省,阳泉市,郊区', 3, 'jiaoqu', '0353', '045011', 'J', '113.58539', '37.94139');
INSERT INTO `dd_region` VALUES (248, 244, '平定', '平定县', '中国,山西省,阳泉市,平定县', 3, 'pingding', '0353', '045200', 'P', '113.65789', '37.78601');
INSERT INTO `dd_region` VALUES (249, 244, '盂县', '盂县', '中国,山西省,阳泉市,盂县', 3, 'yuxian', '0353', '045100', 'Y', '113.41235', '38.08579');
INSERT INTO `dd_region` VALUES (250, 220, '长治', '长治市', '中国,山西省,长治市', 2, 'changzhi', '0355', '046000', 'C', '113.113556', '36.191112');
INSERT INTO `dd_region` VALUES (251, 250, '城区', '城区', '中国,山西省,长治市,城区', 3, 'chengqu', '0355', '046011', 'C', '113.12308', '36.20351');
INSERT INTO `dd_region` VALUES (252, 250, '郊区', '郊区', '中国,山西省,长治市,郊区', 3, 'jiaoqu', '0355', '046011', 'J', '113.12653', '36.19918');
INSERT INTO `dd_region` VALUES (253, 250, '长治', '长治县', '中国,山西省,长治市,长治县', 3, 'changzhi', '0355', '047100', 'C', '113.04791', '36.04722');
INSERT INTO `dd_region` VALUES (254, 250, '襄垣', '襄垣县', '中国,山西省,长治市,襄垣县', 3, 'xiangyuan', '0355', '046200', 'X', '113.05157', '36.53527');
INSERT INTO `dd_region` VALUES (255, 250, '屯留', '屯留县', '中国,山西省,长治市,屯留县', 3, 'tunliu', '0355', '046100', 'T', '112.89196', '36.31579');
INSERT INTO `dd_region` VALUES (256, 250, '平顺', '平顺县', '中国,山西省,长治市,平顺县', 3, 'pingshun', '0355', '047400', 'P', '113.43603', '36.20005');
INSERT INTO `dd_region` VALUES (257, 250, '黎城', '黎城县', '中国,山西省,长治市,黎城县', 3, 'licheng', '0355', '047600', 'L', '113.38766', '36.50301');
INSERT INTO `dd_region` VALUES (258, 250, '壶关', '壶关县', '中国,山西省,长治市,壶关县', 3, 'huguan', '0355', '047300', 'H', '113.207', '36.11301');
INSERT INTO `dd_region` VALUES (259, 250, '长子', '长子县', '中国,山西省,长治市,长子县', 3, 'zhangzi', '0355', '046600', 'C', '112.87731', '36.12125');
INSERT INTO `dd_region` VALUES (260, 250, '武乡', '武乡县', '中国,山西省,长治市,武乡县', 3, 'wuxiang', '0355', '046300', 'W', '112.86343', '36.83687');
INSERT INTO `dd_region` VALUES (261, 250, '沁县', '沁县', '中国,山西省,长治市,沁县', 3, 'qinxian', '0355', '046400', 'Q', '112.69863', '36.75628');
INSERT INTO `dd_region` VALUES (262, 250, '沁源', '沁源县', '中国,山西省,长治市,沁源县', 3, 'qinyuan', '0355', '046500', 'Q', '112.33758', '36.50008');
INSERT INTO `dd_region` VALUES (263, 250, '潞城', '潞城市', '中国,山西省,长治市,潞城市', 3, 'lucheng', '0355', '047500', 'L', '113.22888', '36.33414');
INSERT INTO `dd_region` VALUES (264, 220, '晋城', '晋城市', '中国,山西省,晋城市', 2, 'jincheng', '0356', '048000', 'J', '112.851274', '35.497553');
INSERT INTO `dd_region` VALUES (265, 264, '城区', '城区', '中国,山西省,晋城市,城区', 3, 'chengqu', '0356', '048000', 'C', '112.85319', '35.50175');
INSERT INTO `dd_region` VALUES (266, 264, '沁水', '沁水县', '中国,山西省,晋城市,沁水县', 3, 'qinshui', '0356', '048200', 'Q', '112.1871', '35.69102');
INSERT INTO `dd_region` VALUES (267, 264, '阳城', '阳城县', '中国,山西省,晋城市,阳城县', 3, 'yangcheng', '0356', '048100', 'Y', '112.41485', '35.48614');
INSERT INTO `dd_region` VALUES (268, 264, '陵川', '陵川县', '中国,山西省,晋城市,陵川县', 3, 'lingchuan', '0356', '048300', 'L', '113.2806', '35.77532');
INSERT INTO `dd_region` VALUES (269, 264, '泽州', '泽州县', '中国,山西省,晋城市,泽州县', 3, 'zezhou', '0356', '048012', 'Z', '112.83947', '35.50789');
INSERT INTO `dd_region` VALUES (270, 264, '高平', '高平市', '中国,山西省,晋城市,高平市', 3, 'gaoping', '0356', '048400', 'G', '112.92288', '35.79705');
INSERT INTO `dd_region` VALUES (271, 220, '朔州', '朔州市', '中国,山西省,朔州市', 2, 'shuozhou', '0349', '038500', 'S', '112.433387', '39.331261');
INSERT INTO `dd_region` VALUES (272, 271, '朔城', '朔城区', '中国,山西省,朔州市,朔城区', 3, 'shuocheng', '0349', '036000', 'S', '112.43189', '39.31982');
INSERT INTO `dd_region` VALUES (273, 271, '平鲁', '平鲁区', '中国,山西省,朔州市,平鲁区', 3, 'pinglu', '0349', '038600', 'P', '112.28833', '39.51155');
INSERT INTO `dd_region` VALUES (274, 271, '山阴', '山阴县', '中国,山西省,朔州市,山阴县', 3, 'shanyin', '0349', '036900', 'S', '112.81662', '39.52697');
INSERT INTO `dd_region` VALUES (275, 271, '应县', '应县', '中国,山西省,朔州市,应县', 3, 'yingxian', '0349', '037600', 'Y', '113.19052', '39.55279');
INSERT INTO `dd_region` VALUES (276, 271, '右玉', '右玉县', '中国,山西省,朔州市,右玉县', 3, 'youyu', '0349', '037200', 'Y', '112.46902', '39.99011');
INSERT INTO `dd_region` VALUES (277, 271, '怀仁', '怀仁县', '中国,山西省,朔州市,怀仁县', 3, 'huairen', '0349', '038300', 'H', '113.10009', '39.82806');
INSERT INTO `dd_region` VALUES (278, 220, '晋中', '晋中市', '中国,山西省,晋中市', 2, 'jinzhong', '0354', '030600', 'J', '112.736465', '37.696495');
INSERT INTO `dd_region` VALUES (279, 278, '榆次', '榆次区', '中国,山西省,晋中市,榆次区', 3, 'yuci', '0354', '030600', 'Y', '112.70788', '37.6978');
INSERT INTO `dd_region` VALUES (280, 278, '榆社', '榆社县', '中国,山西省,晋中市,榆社县', 3, 'yushe', '0354', '031800', 'Y', '112.97558', '37.0721');
INSERT INTO `dd_region` VALUES (281, 278, '左权', '左权县', '中国,山西省,晋中市,左权县', 3, 'zuoquan', '0354', '032600', 'Z', '113.37918', '37.08235');
INSERT INTO `dd_region` VALUES (282, 278, '和顺', '和顺县', '中国,山西省,晋中市,和顺县', 3, 'heshun', '0354', '032700', 'H', '113.56988', '37.32963');
INSERT INTO `dd_region` VALUES (283, 278, '昔阳', '昔阳县', '中国,山西省,晋中市,昔阳县', 3, 'xiyang', '0354', '045300', 'X', '113.70517', '37.61863');
INSERT INTO `dd_region` VALUES (284, 278, '寿阳', '寿阳县', '中国,山西省,晋中市,寿阳县', 3, 'shouyang', '0354', '045400', 'S', '113.17495', '37.88899');
INSERT INTO `dd_region` VALUES (285, 278, '太谷', '太谷县', '中国,山西省,晋中市,太谷县', 3, 'taigu', '0354', '030800', 'T', '112.55246', '37.42161');
INSERT INTO `dd_region` VALUES (286, 278, '祁县', '祁县', '中国,山西省,晋中市,祁县', 3, 'qixian', '0354', '030900', 'Q', '112.33358', '37.3579');
INSERT INTO `dd_region` VALUES (287, 278, '平遥', '平遥县', '中国,山西省,晋中市,平遥县', 3, 'pingyao', '0354', '031100', 'P', '112.17553', '37.1892');
INSERT INTO `dd_region` VALUES (288, 278, '灵石', '灵石县', '中国,山西省,晋中市,灵石县', 3, 'lingshi', '0354', '031300', 'L', '111.7774', '36.84814');
INSERT INTO `dd_region` VALUES (289, 278, '介休', '介休市', '中国,山西省,晋中市,介休市', 3, 'jiexiu', '0354', '032000', 'J', '111.91824', '37.02771');
INSERT INTO `dd_region` VALUES (290, 220, '运城', '运城市', '中国,山西省,运城市', 2, 'yuncheng', '0359', '044000', 'Y', '111.003957', '35.022778');
INSERT INTO `dd_region` VALUES (291, 290, '盐湖', '盐湖区', '中国,山西省,运城市,盐湖区', 3, 'yanhu', '0359', '044000', 'Y', '110.99827', '35.0151');
INSERT INTO `dd_region` VALUES (292, 290, '临猗', '临猗县', '中国,山西省,运城市,临猗县', 3, 'linyi', '0359', '044100', 'L', '110.77432', '35.14455');
INSERT INTO `dd_region` VALUES (293, 290, '万荣', '万荣县', '中国,山西省,运城市,万荣县', 3, 'wanrong', '0359', '044200', 'W', '110.83657', '35.41556');
INSERT INTO `dd_region` VALUES (294, 290, '闻喜', '闻喜县', '中国,山西省,运城市,闻喜县', 3, 'wenxi', '0359', '043800', 'W', '111.22265', '35.35553');
INSERT INTO `dd_region` VALUES (295, 290, '稷山', '稷山县', '中国,山西省,运城市,稷山县', 3, 'jishan', '0359', '043200', NULL, '110.97924', '35.59993');
INSERT INTO `dd_region` VALUES (296, 290, '新绛', '新绛县', '中国,山西省,运城市,新绛县', 3, 'xinjiang', '0359', '043100', 'X', '111.22509', '35.61566');
INSERT INTO `dd_region` VALUES (297, 290, '绛县', '绛县', '中国,山西省,运城市,绛县', 3, 'jiangxian', '0359', '043600', NULL, '111.56668', '35.49096');
INSERT INTO `dd_region` VALUES (298, 290, '垣曲', '垣曲县', '中国,山西省,运城市,垣曲县', 3, 'yuanqu', '0359', '043700', 'Y', '111.67166', '35.29923');
INSERT INTO `dd_region` VALUES (299, 290, '夏县', '夏县', '中国,山西省,运城市,夏县', 3, 'xiaxian', '0359', '044400', 'X', '111.21966', '35.14121');
INSERT INTO `dd_region` VALUES (300, 290, '平陆', '平陆县', '中国,山西省,运城市,平陆县', 3, 'pinglu', '0359', '044300', 'P', '111.21704', '34.83772');
INSERT INTO `dd_region` VALUES (301, 290, '芮城', '芮城县', '中国,山西省,运城市,芮城县', 3, 'ruicheng', '0359', '044600', NULL, '110.69455', '34.69384');
INSERT INTO `dd_region` VALUES (302, 290, '永济', '永济市', '中国,山西省,运城市,永济市', 3, 'yongji', '0359', '044500', 'Y', '110.44537', '34.86556');
INSERT INTO `dd_region` VALUES (303, 290, '河津', '河津市', '中国,山西省,运城市,河津市', 3, 'hejin', '0359', '043300', 'H', '110.7116', '35.59478');
INSERT INTO `dd_region` VALUES (304, 220, '忻州', '忻州市', '中国,山西省,忻州市', 2, 'xinzhou', '0350', '034000', 'X', '112.733538', '38.41769');
INSERT INTO `dd_region` VALUES (305, 304, '忻府', '忻府区', '中国,山西省,忻州市,忻府区', 3, 'xinfu', '0350', '034000', 'X', '112.74603', '38.40414');
INSERT INTO `dd_region` VALUES (306, 304, '定襄', '定襄县', '中国,山西省,忻州市,定襄县', 3, 'dingxiang', '0350', '035400', 'D', '112.95733', '38.47387');
INSERT INTO `dd_region` VALUES (307, 304, '五台', '五台县', '中国,山西省,忻州市,五台县', 3, 'wutai', '0350', '035500', 'W', '113.25256', '38.72774');
INSERT INTO `dd_region` VALUES (308, 304, '代县', '代县', '中国,山西省,忻州市,代县', 3, 'daixian', '0350', '034200', 'D', '112.95913', '39.06717');
INSERT INTO `dd_region` VALUES (309, 304, '繁峙', '繁峙县', '中国,山西省,忻州市,繁峙县', 3, 'fanshi', '0350', '034300', 'F', '113.26303', '39.18886');
INSERT INTO `dd_region` VALUES (310, 304, '宁武', '宁武县', '中国,山西省,忻州市,宁武县', 3, 'ningwu', '0350', '036700', 'N', '112.30423', '39.00211');
INSERT INTO `dd_region` VALUES (311, 304, '静乐', '静乐县', '中国,山西省,忻州市,静乐县', 3, 'jingle', '0350', '035100', 'J', '111.94158', '38.3602');
INSERT INTO `dd_region` VALUES (312, 304, '神池', '神池县', '中国,山西省,忻州市,神池县', 3, 'shenchi', '0350', '036100', 'S', '112.20541', '39.09');
INSERT INTO `dd_region` VALUES (313, 304, '五寨', '五寨县', '中国,山西省,忻州市,五寨县', 3, 'wuzhai', '0350', '036200', 'W', '111.8489', '38.90757');
INSERT INTO `dd_region` VALUES (314, 304, '岢岚', '岢岚县', '中国,山西省,忻州市,岢岚县', 3, 'kelan', '0350', '036300', NULL, '111.57388', '38.70452');
INSERT INTO `dd_region` VALUES (315, 304, '河曲', '河曲县', '中国,山西省,忻州市,河曲县', 3, 'hequ', '0350', '036500', 'H', '111.13821', '39.38439');
INSERT INTO `dd_region` VALUES (316, 304, '保德', '保德县', '中国,山西省,忻州市,保德县', 3, 'baode', '0350', '036600', 'B', '111.08656', '39.02248');
INSERT INTO `dd_region` VALUES (317, 304, '偏关', '偏关县', '中国,山西省,忻州市,偏关县', 3, 'pianguan', '0350', '036400', 'P', '111.50863', '39.43609');
INSERT INTO `dd_region` VALUES (318, 304, '原平', '原平市', '中国,山西省,忻州市,原平市', 3, 'yuanping', '0350', '034100', 'Y', '112.70584', '38.73181');
INSERT INTO `dd_region` VALUES (319, 220, '临汾', '临汾市', '中国,山西省,临汾市', 2, 'linfen', '0357', '041000', 'L', '111.517973', '36.08415');
INSERT INTO `dd_region` VALUES (320, 319, '尧都', '尧都区', '中国,山西省,临汾市,尧都区', 3, 'yaodu', '0357', '041000', 'Y', '111.5787', '36.08298');
INSERT INTO `dd_region` VALUES (321, 319, '曲沃', '曲沃县', '中国,山西省,临汾市,曲沃县', 3, 'quwo', '0357', '043400', 'Q', '111.47525', '35.64119');
INSERT INTO `dd_region` VALUES (322, 319, '翼城', '翼城县', '中国,山西省,临汾市,翼城县', 3, 'yicheng', '0357', '043500', 'Y', '111.7181', '35.73881');
INSERT INTO `dd_region` VALUES (323, 319, '襄汾', '襄汾县', '中国,山西省,临汾市,襄汾县', 3, 'xiangfen', '0357', '041500', 'X', '111.44204', '35.87711');
INSERT INTO `dd_region` VALUES (324, 319, '洪洞', '洪洞县', '中国,山西省,临汾市,洪洞县', 3, 'hongtong', '0357', '041600', 'H', '111.67501', '36.25425');
INSERT INTO `dd_region` VALUES (325, 319, '古县', '古县', '中国,山西省,临汾市,古县', 3, 'guxian', '0357', '042400', 'G', '111.92041', '36.26688');
INSERT INTO `dd_region` VALUES (326, 319, '安泽', '安泽县', '中国,山西省,临汾市,安泽县', 3, 'anze', '0357', '042500', 'A', '112.24981', '36.14803');
INSERT INTO `dd_region` VALUES (327, 319, '浮山', '浮山县', '中国,山西省,临汾市,浮山县', 3, 'fushan', '0357', '042600', 'F', '111.84744', '35.96854');
INSERT INTO `dd_region` VALUES (328, 319, '吉县', '吉县', '中国,山西省,临汾市,吉县', 3, 'jixian', '0357', '042200', 'J', '110.68148', '36.09873');
INSERT INTO `dd_region` VALUES (329, 319, '乡宁', '乡宁县', '中国,山西省,临汾市,乡宁县', 3, 'xiangning', '0357', '042100', 'X', '110.84652', '35.97072');
INSERT INTO `dd_region` VALUES (330, 319, '大宁', '大宁县', '中国,山西省,临汾市,大宁县', 3, 'daning', '0357', '042300', 'D', '110.75216', '36.46624');
INSERT INTO `dd_region` VALUES (331, 319, '隰县', '隰县', '中国,山西省,临汾市,隰县', 3, 'xixian', '0357', '041300', NULL, '110.93881', '36.69258');
INSERT INTO `dd_region` VALUES (332, 319, '永和', '永和县', '中国,山西省,临汾市,永和县', 3, 'yonghe', '0357', '041400', 'Y', '110.63168', '36.7584');
INSERT INTO `dd_region` VALUES (333, 319, '蒲县', '蒲县', '中国,山西省,临汾市,蒲县', 3, 'puxian', '0357', '041200', 'P', '111.09674', '36.41243');
INSERT INTO `dd_region` VALUES (334, 319, '汾西', '汾西县', '中国,山西省,临汾市,汾西县', 3, 'fenxi', '0357', '031500', 'F', '111.56811', '36.65063');
INSERT INTO `dd_region` VALUES (335, 319, '侯马', '侯马市', '中国,山西省,临汾市,侯马市', 3, 'houma', '0357', '043000', 'H', '111.37207', '35.61903');
INSERT INTO `dd_region` VALUES (336, 319, '霍州', '霍州市', '中国,山西省,临汾市,霍州市', 3, 'huozhou', '0357', '031400', 'H', '111.755', '36.5638');
INSERT INTO `dd_region` VALUES (337, 220, '吕梁', '吕梁市', '中国,山西省,吕梁市', 2, 'lvliang', '0358', '033000', 'L', '111.134335', '37.524366');
INSERT INTO `dd_region` VALUES (338, 337, '离石', '离石区', '中国,山西省,吕梁市,离石区', 3, 'lishi', '0358', '033000', 'L', '111.15059', '37.5177');
INSERT INTO `dd_region` VALUES (339, 337, '文水', '文水县', '中国,山西省,吕梁市,文水县', 3, 'wenshui', '0358', '032100', 'W', '112.02829', '37.43841');
INSERT INTO `dd_region` VALUES (340, 337, '交城', '交城县', '中国,山西省,吕梁市,交城县', 3, 'jiaocheng', '0358', '030500', 'J', '112.1585', '37.5512');
INSERT INTO `dd_region` VALUES (341, 337, '兴县', '兴县', '中国,山西省,吕梁市,兴县', 3, 'xingxian', '0358', '033600', 'X', '111.12692', '38.46321');
INSERT INTO `dd_region` VALUES (342, 337, '临县', '临县', '中国,山西省,吕梁市,临县', 3, 'linxian', '0358', '033200', 'L', '110.99282', '37.95271');
INSERT INTO `dd_region` VALUES (343, 337, '柳林', '柳林县', '中国,山西省,吕梁市,柳林县', 3, 'liulin', '0358', '033300', 'L', '110.88922', '37.42932');
INSERT INTO `dd_region` VALUES (344, 337, '石楼', '石楼县', '中国,山西省,吕梁市,石楼县', 3, 'shilou', '0358', '032500', 'S', '110.8352', '36.99731');
INSERT INTO `dd_region` VALUES (345, 337, '岚县', '岚县', '中国,山西省,吕梁市,岚县', 3, 'lanxian', '0358', '033500', NULL, '111.67627', '38.27874');
INSERT INTO `dd_region` VALUES (346, 337, '方山', '方山县', '中国,山西省,吕梁市,方山县', 3, 'fangshan', '0358', '033100', 'F', '111.24011', '37.88979');
INSERT INTO `dd_region` VALUES (347, 337, '中阳', '中阳县', '中国,山西省,吕梁市,中阳县', 3, 'zhongyang', '0358', '033400', 'Z', '111.1795', '37.35715');
INSERT INTO `dd_region` VALUES (348, 337, '交口', '交口县', '中国,山西省,吕梁市,交口县', 3, 'jiaokou', '0358', '032400', 'J', '111.18103', '36.98213');
INSERT INTO `dd_region` VALUES (349, 337, '孝义', '孝义市', '中国,山西省,吕梁市,孝义市', 3, 'xiaoyi', '0358', '032300', 'X', '111.77362', '37.14414');
INSERT INTO `dd_region` VALUES (350, 337, '汾阳', '汾阳市', '中国,山西省,吕梁市,汾阳市', 3, 'fenyang', '0358', '032200', 'F', '111.7882', '37.26605');
INSERT INTO `dd_region` VALUES (351, 0, '内蒙古', '内蒙古自治区', '中国,内蒙古自治区', 1, 'innermongolia', '', '', 'N', '111.670801', '40.818311');
INSERT INTO `dd_region` VALUES (352, 351, '呼和浩特', '呼和浩特市', '中国,内蒙古自治区,呼和浩特市', 2, 'hohhot', '0471', '010000', 'H', '111.670801', '40.818311');
INSERT INTO `dd_region` VALUES (353, 352, '新城', '新城区', '中国,内蒙古自治区,呼和浩特市,新城区', 3, 'xincheng', '0471', '010050', 'X', '111.66554', '40.85828');
INSERT INTO `dd_region` VALUES (354, 352, '回民', '回民区', '中国,内蒙古自治区,呼和浩特市,回民区', 3, 'huimin', '0471', '010030', 'H', '111.62402', '40.80827');
INSERT INTO `dd_region` VALUES (355, 352, '玉泉', '玉泉区', '中国,内蒙古自治区,呼和浩特市,玉泉区', 3, 'yuquan', '0471', '010020', 'Y', '111.67456', '40.75227');
INSERT INTO `dd_region` VALUES (356, 352, '赛罕', '赛罕区', '中国,内蒙古自治区,呼和浩特市,赛罕区', 3, 'saihan', '0471', '010020', 'S', '111.70224', '40.79207');
INSERT INTO `dd_region` VALUES (357, 352, '土默特左旗', '土默特左旗', '中国,内蒙古自治区,呼和浩特市,土默特左旗', 3, 'tumotezuoqi', '0471', '010100', 'T', '111.14898', '40.72229');
INSERT INTO `dd_region` VALUES (358, 352, '托克托', '托克托县', '中国,内蒙古自治区,呼和浩特市,托克托县', 3, 'tuoketuo', '0471', '010200', 'T', '111.19101', '40.27492');
INSERT INTO `dd_region` VALUES (359, 352, '和林格尔', '和林格尔县', '中国,内蒙古自治区,呼和浩特市,和林格尔县', 3, 'helingeer', '0471', '011500', 'H', '111.82205', '40.37892');
INSERT INTO `dd_region` VALUES (360, 352, '清水河', '清水河县', '中国,内蒙古自治区,呼和浩特市,清水河县', 3, 'qingshuihe', '0471', '011600', 'Q', '111.68316', '39.9097');
INSERT INTO `dd_region` VALUES (361, 352, '武川', '武川县', '中国,内蒙古自治区,呼和浩特市,武川县', 3, 'wuchuan', '0471', '011700', 'W', '111.45785', '41.09289');
INSERT INTO `dd_region` VALUES (362, 351, '包头', '包头市', '中国,内蒙古自治区,包头市', 2, 'baotou', '0472', '014025', 'B', '109.840405', '40.658168');
INSERT INTO `dd_region` VALUES (363, 362, '东河', '东河区', '中国,内蒙古自治区,包头市,东河区', 3, 'donghe', '0472', '014040', 'D', '110.0462', '40.58237');
INSERT INTO `dd_region` VALUES (364, 362, '昆都仑', '昆都仑区', '中国,内蒙古自治区,包头市,昆都仑区', 3, 'kundulun', '0472', '014010', 'K', '109.83862', '40.64175');
INSERT INTO `dd_region` VALUES (365, 362, '青山', '青山区', '中国,内蒙古自治区,包头市,青山区', 3, 'qingshan', '0472', '014030', 'Q', '109.90131', '40.64329');
INSERT INTO `dd_region` VALUES (366, 362, '石拐', '石拐区', '中国,内蒙古自治区,包头市,石拐区', 3, 'shiguai', '0472', '014070', 'S', '110.27322', '40.67297');
INSERT INTO `dd_region` VALUES (367, 362, '白云鄂博矿区', '白云鄂博矿区', '中国,内蒙古自治区,包头市,白云鄂博矿区', 3, 'baiyunebokuangqu', '0472', '014080', 'B', '109.97367', '41.76968');
INSERT INTO `dd_region` VALUES (368, 362, '九原', '九原区', '中国,内蒙古自治区,包头市,九原区', 3, 'jiuyuan', '0472', '014060', 'J', '109.96496', '40.60554');
INSERT INTO `dd_region` VALUES (369, 362, '土默特右旗', '土默特右旗', '中国,内蒙古自治区,包头市,土默特右旗', 3, 'tumoteyouqi', '0472', '014100', 'T', '110.52417', '40.5688');
INSERT INTO `dd_region` VALUES (370, 362, '固阳', '固阳县', '中国,内蒙古自治区,包头市,固阳县', 3, 'guyang', '0472', '014200', 'G', '110.06372', '41.01851');
INSERT INTO `dd_region` VALUES (371, 362, '达茂旗', '达尔罕茂明安联合旗', '中国,内蒙古自治区,包头市,达尔罕茂明安联合旗', 3, 'damaoqi', '0472', '014500', 'D', '110.43258', '41.69875');
INSERT INTO `dd_region` VALUES (372, 351, '乌海', '乌海市', '中国,内蒙古自治区,乌海市', 2, 'wuhai', '0473', '016000', 'W', '106.825563', '39.673734');
INSERT INTO `dd_region` VALUES (373, 372, '海勃湾', '海勃湾区', '中国,内蒙古自治区,乌海市,海勃湾区', 3, 'haibowan', '0473', '016000', 'H', '106.8222', '39.66955');
INSERT INTO `dd_region` VALUES (374, 372, '海南', '海南区', '中国,内蒙古自治区,乌海市,海南区', 3, 'hainan', '0473', '016030', 'H', '106.88656', '39.44128');
INSERT INTO `dd_region` VALUES (375, 372, '乌达', '乌达区', '中国,内蒙古自治区,乌海市,乌达区', 3, 'wuda', '0473', '016040', 'W', '106.72723', '39.505');
INSERT INTO `dd_region` VALUES (376, 351, '赤峰', '赤峰市', '中国,内蒙古自治区,赤峰市', 2, 'chifeng', '0476', '024000', 'C', '118.956806', '42.275317');
INSERT INTO `dd_region` VALUES (377, 376, '红山', '红山区', '中国,内蒙古自治区,赤峰市,红山区', 3, 'hongshan', '0476', '024020', 'H', '118.95755', '42.24312');
INSERT INTO `dd_region` VALUES (378, 376, '元宝山', '元宝山区', '中国,内蒙古自治区,赤峰市,元宝山区', 3, 'yuanbaoshan', '0476', '024076', 'Y', '119.28921', '42.04005');
INSERT INTO `dd_region` VALUES (379, 376, '松山', '松山区', '中国,内蒙古自治区,赤峰市,松山区', 3, 'songshan', '0476', '024005', 'S', '118.9328', '42.28613');
INSERT INTO `dd_region` VALUES (380, 376, '阿鲁科尔沁旗', '阿鲁科尔沁旗', '中国,内蒙古自治区,赤峰市,阿鲁科尔沁旗', 3, 'alukeerqinqi', '0476', '025550', 'A', '120.06527', '43.87988');
INSERT INTO `dd_region` VALUES (381, 376, '巴林左旗', '巴林左旗', '中国,内蒙古自治区,赤峰市,巴林左旗', 3, 'balinzuoqi', '0476', '025450', 'B', '119.38012', '43.97031');
INSERT INTO `dd_region` VALUES (382, 376, '巴林右旗', '巴林右旗', '中国,内蒙古自治区,赤峰市,巴林右旗', 3, 'balinyouqi', '0476', '025150', 'B', '118.66461', '43.53387');
INSERT INTO `dd_region` VALUES (383, 376, '林西', '林西县', '中国,内蒙古自治区,赤峰市,林西县', 3, 'linxi', '0476', '025250', 'L', '118.04733', '43.61165');
INSERT INTO `dd_region` VALUES (384, 376, '克什克腾旗', '克什克腾旗', '中国,内蒙古自治区,赤峰市,克什克腾旗', 3, 'keshiketengqi', '0476', '025350', 'K', '117.54562', '43.26501');
INSERT INTO `dd_region` VALUES (385, 376, '翁牛特旗', '翁牛特旗', '中国,内蒙古自治区,赤峰市,翁牛特旗', 3, 'wengniuteqi', '0476', '024500', 'W', '119.03042', '42.93147');
INSERT INTO `dd_region` VALUES (386, 376, '喀喇沁旗', '喀喇沁旗', '中国,内蒙古自治区,赤峰市,喀喇沁旗', 3, 'kalaqinqi', '0476', '024400', 'K', '118.70144', '41.92917');
INSERT INTO `dd_region` VALUES (387, 376, '宁城', '宁城县', '中国,内蒙古自治区,赤峰市,宁城县', 3, 'ningcheng', '0476', '024200', 'N', '119.34375', '41.59661');
INSERT INTO `dd_region` VALUES (388, 376, '敖汉旗', '敖汉旗', '中国,内蒙古自治区,赤峰市,敖汉旗', 3, 'aohanqi', '0476', '024300', 'A', '119.92163', '42.29071');
INSERT INTO `dd_region` VALUES (389, 351, '通辽', '通辽市', '中国,内蒙古自治区,通辽市', 2, 'tongliao', '0475', '028000', 'T', '122.263119', '43.617429');
INSERT INTO `dd_region` VALUES (390, 389, '科尔沁', '科尔沁区', '中国,内蒙古自治区,通辽市,科尔沁区', 3, 'keerqin', '0475', '028000', 'K', '122.25573', '43.62257');
INSERT INTO `dd_region` VALUES (391, 389, '科尔沁左翼中旗', '科尔沁左翼中旗', '中国,内蒙古自治区,通辽市,科尔沁左翼中旗', 3, 'keerqinzuoyizhongqi', '0475', '029300', 'K', '123.31912', '44.13014');
INSERT INTO `dd_region` VALUES (392, 389, '科尔沁左翼后旗', '科尔沁左翼后旗', '中国,内蒙古自治区,通辽市,科尔沁左翼后旗', 3, 'keerqinzuoyihouqi', '0475', '028100', 'K', '122.35745', '42.94897');
INSERT INTO `dd_region` VALUES (393, 389, '开鲁', '开鲁县', '中国,内蒙古自治区,通辽市,开鲁县', 3, 'kailu', '0475', '028400', 'K', '121.31884', '43.60003');
INSERT INTO `dd_region` VALUES (394, 389, '库伦旗', '库伦旗', '中国,内蒙古自治区,通辽市,库伦旗', 3, 'kulunqi', '0475', '028200', 'K', '121.776', '42.72998');
INSERT INTO `dd_region` VALUES (395, 389, '奈曼旗', '奈曼旗', '中国,内蒙古自治区,通辽市,奈曼旗', 3, 'naimanqi', '0475', '028300', 'N', '120.66348', '42.84527');
INSERT INTO `dd_region` VALUES (396, 389, '扎鲁特旗', '扎鲁特旗', '中国,内蒙古自治区,通辽市,扎鲁特旗', 3, 'zhaluteqi', '0475', '029100', 'Z', '120.91507', '44.55592');
INSERT INTO `dd_region` VALUES (397, 389, '霍林郭勒', '霍林郭勒市', '中国,内蒙古自治区,通辽市,霍林郭勒市', 3, 'huolinguole', '0475', '029200', 'H', '119.65429', '45.53454');
INSERT INTO `dd_region` VALUES (398, 351, '鄂尔多斯', '鄂尔多斯市', '中国,内蒙古自治区,鄂尔多斯市', 2, 'ordos', '0477', '017004', 'E', '109.99029', '39.817179');
INSERT INTO `dd_region` VALUES (399, 398, '东胜', '东胜区', '中国,内蒙古自治区,鄂尔多斯市,东胜区', 3, 'dongsheng', '0477', '017000', 'D', '109.96289', '39.82236');
INSERT INTO `dd_region` VALUES (400, 398, '达拉特旗', '达拉特旗', '中国,内蒙古自治区,鄂尔多斯市,达拉特旗', 3, 'dalateqi', '0477', '014300', 'D', '110.03317', '40.4001');
INSERT INTO `dd_region` VALUES (401, 398, '准格尔旗', '准格尔旗', '中国,内蒙古自治区,鄂尔多斯市,准格尔旗', 3, 'zhungeerqi', '0477', '017100', 'Z', '111.23645', '39.86783');
INSERT INTO `dd_region` VALUES (402, 398, '鄂托克前旗', '鄂托克前旗', '中国,内蒙古自治区,鄂尔多斯市,鄂托克前旗', 3, 'etuokeqianqi', '0477', '016200', 'E', '107.48403', '38.18396');
INSERT INTO `dd_region` VALUES (403, 398, '鄂托克旗', '鄂托克旗', '中国,内蒙古自治区,鄂尔多斯市,鄂托克旗', 3, 'etuokeqi', '0477', '016100', 'E', '107.98226', '39.09456');
INSERT INTO `dd_region` VALUES (404, 398, '杭锦旗', '杭锦旗', '中国,内蒙古自治区,鄂尔多斯市,杭锦旗', 3, 'hangjinqi', '0477', '017400', 'H', '108.72934', '39.84023');
INSERT INTO `dd_region` VALUES (405, 398, '乌审旗', '乌审旗', '中国,内蒙古自治区,鄂尔多斯市,乌审旗', 3, 'wushenqi', '0477', '017300', 'W', '108.8461', '38.59092');
INSERT INTO `dd_region` VALUES (406, 398, '伊金霍洛旗', '伊金霍洛旗', '中国,内蒙古自治区,鄂尔多斯市,伊金霍洛旗', 3, 'yijinhuoluoqi', '0477', '017200', 'Y', '109.74908', '39.57393');
INSERT INTO `dd_region` VALUES (407, 351, '呼伦贝尔', '呼伦贝尔市', '中国,内蒙古自治区,呼伦贝尔市', 2, 'hulunber', '0470', '021008', 'H', '119.758168', '49.215333');
INSERT INTO `dd_region` VALUES (408, 407, '海拉尔', '海拉尔区', '中国,内蒙古自治区,呼伦贝尔市,海拉尔区', 3, 'hailaer', '0470', '021000', 'H', '119.7364', '49.2122');
INSERT INTO `dd_region` VALUES (409, 407, '扎赉诺尔', '扎赉诺尔区', '中国,内蒙古自治区,呼伦贝尔市,扎赉诺尔区', 3, 'zhalainuoer', '0470', '021410', 'Z', '117.792702', '49.486943');
INSERT INTO `dd_region` VALUES (410, 407, '阿荣旗', '阿荣旗', '中国,内蒙古自治区,呼伦贝尔市,阿荣旗', 3, 'arongqi', '0470', '162750', 'A', '123.45941', '48.12581');
INSERT INTO `dd_region` VALUES (411, 407, '莫旗', '莫力达瓦达斡尔族自治旗', '中国,内蒙古自治区,呼伦贝尔市,莫力达瓦达斡尔族自治旗', 3, 'moqi', '0470', '162850', 'M', '124.51498', '48.48055');
INSERT INTO `dd_region` VALUES (412, 407, '鄂伦春', '鄂伦春自治旗', '中国,内蒙古自治区,呼伦贝尔市,鄂伦春自治旗', 3, 'elunchun', '0470', '165450', 'E', '123.72604', '50.59777');
INSERT INTO `dd_region` VALUES (413, 407, '鄂温', '鄂温克族自治旗', '中国,内蒙古自治区,呼伦贝尔市,鄂温克族自治旗', 3, 'ewen', '0470', '021100', 'E', '119.7565', '49.14284');
INSERT INTO `dd_region` VALUES (414, 407, '陈巴尔虎旗', '陈巴尔虎旗', '中国,内蒙古自治区,呼伦贝尔市,陈巴尔虎旗', 3, 'chenbaerhuqi', '0470', '021500', 'C', '119.42434', '49.32684');
INSERT INTO `dd_region` VALUES (415, 407, '新巴尔虎左旗', '新巴尔虎左旗', '中国,内蒙古自治区,呼伦贝尔市,新巴尔虎左旗', 3, 'xinbaerhuzuoqi', '0470', '021200', 'X', '118.26989', '48.21842');
INSERT INTO `dd_region` VALUES (416, 407, '新巴尔虎右旗', '新巴尔虎右旗', '中国,内蒙古自治区,呼伦贝尔市,新巴尔虎右旗', 3, 'xinbaerhuyouqi', '0470', '021300', 'X', '116.82366', '48.66473');
INSERT INTO `dd_region` VALUES (417, 407, '满洲里', '满洲里市', '中国,内蒙古自治区,呼伦贝尔市,满洲里市', 3, 'manzhouli', '0470', '021400', 'M', '117.47946', '49.58272');
INSERT INTO `dd_region` VALUES (418, 407, '牙克石', '牙克石市', '中国,内蒙古自治区,呼伦贝尔市,牙克石市', 3, 'yakeshi', '0470', '022150', 'Y', '120.7117', '49.2856');
INSERT INTO `dd_region` VALUES (419, 407, '扎兰屯', '扎兰屯市', '中国,内蒙古自治区,呼伦贝尔市,扎兰屯市', 3, 'zhalantun', '0470', '162650', 'Z', '122.73757', '48.01363');
INSERT INTO `dd_region` VALUES (420, 407, '额尔古纳', '额尔古纳市', '中国,内蒙古自治区,呼伦贝尔市,额尔古纳市', 3, 'eerguna', '0470', '022250', 'E', '120.19094', '50.24249');
INSERT INTO `dd_region` VALUES (421, 407, '根河', '根河市', '中国,内蒙古自治区,呼伦贝尔市,根河市', 3, 'genhe', '0470', '022350', 'G', '121.52197', '50.77996');
INSERT INTO `dd_region` VALUES (422, 351, '巴彦淖尔', '巴彦淖尔市', '中国,内蒙古自治区,巴彦淖尔市', 2, 'bayannur', '0478', '015001', 'B', '107.416959', '40.757402');
INSERT INTO `dd_region` VALUES (423, 422, '临河', '临河区', '中国,内蒙古自治区,巴彦淖尔市,临河区', 3, 'linhe', '0478', '015001', 'L', '107.42668', '40.75827');
INSERT INTO `dd_region` VALUES (424, 422, '五原', '五原县', '中国,内蒙古自治区,巴彦淖尔市,五原县', 3, 'wuyuan', '0478', '015100', 'W', '108.26916', '41.09631');
INSERT INTO `dd_region` VALUES (425, 422, '磴口', '磴口县', '中国,内蒙古自治区,巴彦淖尔市,磴口县', 3, 'dengkou', '0478', '015200', NULL, '107.00936', '40.33062');
INSERT INTO `dd_region` VALUES (426, 422, '乌拉特前旗', '乌拉特前旗', '中国,内蒙古自治区,巴彦淖尔市,乌拉特前旗', 3, 'wulateqianqi', '0478', '014400', 'W', '108.65219', '40.73649');
INSERT INTO `dd_region` VALUES (427, 422, '乌拉特中旗', '乌拉特中旗', '中国,内蒙古自治区,巴彦淖尔市,乌拉特中旗', 3, 'wulatezhongqi', '0478', '015300', 'W', '108.52587', '41.56789');
INSERT INTO `dd_region` VALUES (428, 422, '乌拉特后旗', '乌拉特后旗', '中国,内蒙古自治区,巴彦淖尔市,乌拉特后旗', 3, 'wulatehouqi', '0478', '015500', 'W', '106.98971', '41.43151');
INSERT INTO `dd_region` VALUES (429, 422, '杭锦后旗', '杭锦后旗', '中国,内蒙古自治区,巴彦淖尔市,杭锦后旗', 3, 'hangjinhouqi', '0478', '015400', 'H', '107.15133', '40.88627');
INSERT INTO `dd_region` VALUES (430, 351, '乌兰察布', '乌兰察布市', '中国,内蒙古自治区,乌兰察布市', 2, 'ulanqab', '0474', '012000', 'W', '113.114543', '41.034126');
INSERT INTO `dd_region` VALUES (431, 430, '集宁', '集宁区', '中国,内蒙古自治区,乌兰察布市,集宁区', 3, 'jining', '0474', '012000', 'J', '113.11452', '41.0353');
INSERT INTO `dd_region` VALUES (432, 430, '卓资', '卓资县', '中国,内蒙古自治区,乌兰察布市,卓资县', 3, 'zhuozi', '0474', '012300', 'Z', '112.57757', '40.89414');
INSERT INTO `dd_region` VALUES (433, 430, '化德', '化德县', '中国,内蒙古自治区,乌兰察布市,化德县', 3, 'huade', '0474', '013350', 'H', '114.01071', '41.90433');
INSERT INTO `dd_region` VALUES (434, 430, '商都', '商都县', '中国,内蒙古自治区,乌兰察布市,商都县', 3, 'shangdu', '0474', '013450', 'S', '113.57772', '41.56213');
INSERT INTO `dd_region` VALUES (435, 430, '兴和', '兴和县', '中国,内蒙古自治区,乌兰察布市,兴和县', 3, 'xinghe', '0474', '013650', 'X', '113.83395', '40.87186');
INSERT INTO `dd_region` VALUES (436, 430, '凉城', '凉城县', '中国,内蒙古自治区,乌兰察布市,凉城县', 3, 'liangcheng', '0474', '013750', 'L', '112.49569', '40.53346');
INSERT INTO `dd_region` VALUES (437, 430, '察右前旗', '察哈尔右翼前旗', '中国,内蒙古自治区,乌兰察布市,察哈尔右翼前旗', 3, 'chayouqianqi', '0474', '012200', 'C', '113.22131', '40.7788');
INSERT INTO `dd_region` VALUES (438, 430, '察右中旗', '察哈尔右翼中旗', '中国,内蒙古自治区,乌兰察布市,察哈尔右翼中旗', 3, 'chayouzhongqi', '0474', '013550', 'C', '112.63537', '41.27742');
INSERT INTO `dd_region` VALUES (439, 430, '察右后旗', '察哈尔右翼后旗', '中国,内蒙古自治区,乌兰察布市,察哈尔右翼后旗', 3, 'chayouhouqi', '0474', '012400', 'C', '113.19216', '41.43554');
INSERT INTO `dd_region` VALUES (440, 430, '四子王旗', '四子王旗', '中国,内蒙古自治区,乌兰察布市,四子王旗', 3, 'siziwangqi', '0474', '011800', 'S', '111.70654', '41.53312');
INSERT INTO `dd_region` VALUES (441, 430, '丰镇', '丰镇市', '中国,内蒙古自治区,乌兰察布市,丰镇市', 3, 'fengzhen', '0474', '012100', 'F', '113.10983', '40.4369');
INSERT INTO `dd_region` VALUES (442, 351, '兴安盟', '兴安盟', '中国,内蒙古自治区,兴安盟', 2, 'hinggan', '0482', '137401', 'X', '122.070317', '46.076268');
INSERT INTO `dd_region` VALUES (443, 442, '乌兰浩特', '乌兰浩特市', '中国,内蒙古自治区,兴安盟,乌兰浩特市', 3, 'wulanhaote', '0482', '137401', 'W', '122.06378', '46.06235');
INSERT INTO `dd_region` VALUES (444, 442, '阿尔山', '阿尔山市', '中国,内蒙古自治区,兴安盟,阿尔山市', 3, 'aershan', '0482', '137800', 'A', '119.94317', '47.17716');
INSERT INTO `dd_region` VALUES (445, 442, '科右前旗', '科尔沁右翼前旗', '中国,内蒙古自治区,兴安盟,科尔沁右翼前旗', 3, 'keyouqianqi', '0482', '137423', 'K', '121.95269', '46.0795');
INSERT INTO `dd_region` VALUES (446, 442, '科右中旗', '科尔沁右翼中旗', '中国,内蒙古自治区,兴安盟,科尔沁右翼中旗', 3, 'keyouzhongqi', '0482', '029400', 'K', '121.46807', '45.05605');
INSERT INTO `dd_region` VALUES (447, 442, '扎赉特旗', '扎赉特旗', '中国,内蒙古自治区,兴安盟,扎赉特旗', 3, 'zhalaiteqi', '0482', '137600', 'Z', '122.91229', '46.7267');
INSERT INTO `dd_region` VALUES (448, 442, '突泉', '突泉县', '中国,内蒙古自治区,兴安盟,突泉县', 3, 'tuquan', '0482', '137500', 'T', '121.59396', '45.38187');
INSERT INTO `dd_region` VALUES (449, 351, '锡林郭勒盟', '锡林郭勒盟', '中国,内蒙古自治区,锡林郭勒盟', 2, 'xilingol', '0479', '026000', 'X', '116.090996', '43.944018');
INSERT INTO `dd_region` VALUES (450, 449, '二连浩特', '二连浩特市', '中国,内蒙古自治区,锡林郭勒盟,二连浩特市', 3, 'erlianhaote', '0479', '011100', 'E', '111.98297', '43.65303');
INSERT INTO `dd_region` VALUES (451, 449, '锡林浩特', '锡林浩特市', '中国,内蒙古自治区,锡林郭勒盟,锡林浩特市', 3, 'xilinhaote', '0479', '026021', 'X', '116.08603', '43.93341');
INSERT INTO `dd_region` VALUES (452, 449, '阿巴嘎旗', '阿巴嘎旗', '中国,内蒙古自治区,锡林郭勒盟,阿巴嘎旗', 3, 'abagaqi', '0479', '011400', 'A', '114.96826', '44.02174');
INSERT INTO `dd_region` VALUES (453, 449, '苏尼特左旗', '苏尼特左旗', '中国,内蒙古自治区,锡林郭勒盟,苏尼特左旗', 3, 'sunitezuoqi', '0479', '011300', 'S', '113.6506', '43.85687');
INSERT INTO `dd_region` VALUES (454, 449, '苏尼特右旗', '苏尼特右旗', '中国,内蒙古自治区,锡林郭勒盟,苏尼特右旗', 3, 'suniteyouqi', '0479', '011200', 'S', '112.65741', '42.7469');
INSERT INTO `dd_region` VALUES (455, 449, '东乌旗', '东乌珠穆沁旗', '中国,内蒙古自治区,锡林郭勒盟,东乌珠穆沁旗', 3, 'dongwuqi', '0479', '026300', 'D', '116.97293', '45.51108');
INSERT INTO `dd_region` VALUES (456, 449, '西乌旗', '西乌珠穆沁旗', '中国,内蒙古自治区,锡林郭勒盟,西乌珠穆沁旗', 3, 'xiwuqi', '0479', '026200', 'X', '117.60983', '44.59623');
INSERT INTO `dd_region` VALUES (457, 449, '太仆寺旗', '太仆寺旗', '中国,内蒙古自治区,锡林郭勒盟,太仆寺旗', 3, 'taipusiqi', '0479', '027000', 'T', '115.28302', '41.87727');
INSERT INTO `dd_region` VALUES (458, 449, '镶黄旗', '镶黄旗', '中国,内蒙古自治区,锡林郭勒盟,镶黄旗', 3, 'xianghuangqi', '0479', '013250', 'X', '113.84472', '42.23927');
INSERT INTO `dd_region` VALUES (459, 449, '正镶白旗', '正镶白旗', '中国,内蒙古自治区,锡林郭勒盟,正镶白旗', 3, 'zhengxiangbaiqi', '0479', '013800', 'Z', '115.00067', '42.30712');
INSERT INTO `dd_region` VALUES (460, 449, '正蓝旗', '正蓝旗', '中国,内蒙古自治区,锡林郭勒盟,正蓝旗', 3, 'zhenglanqi', '0479', '027200', 'Z', '116.00363', '42.25229');
INSERT INTO `dd_region` VALUES (461, 449, '多伦', '多伦县', '中国,内蒙古自治区,锡林郭勒盟,多伦县', 3, 'duolun', '0479', '027300', 'D', '116.48565', '42.203');
INSERT INTO `dd_region` VALUES (462, 351, '阿拉善盟', '阿拉善盟', '中国,内蒙古自治区,阿拉善盟', 2, 'alxa', '0483', '750306', 'A', '105.706422', '38.844814');
INSERT INTO `dd_region` VALUES (463, 462, '阿拉善左旗', '阿拉善左旗', '中国,内蒙古自治区,阿拉善盟,阿拉善左旗', 3, 'alashanzuoqi', '0483', '750306', 'A', '105.67532', '38.8293');
INSERT INTO `dd_region` VALUES (464, 462, '阿拉善右旗', '阿拉善右旗', '中国,内蒙古自治区,阿拉善盟,阿拉善右旗', 3, 'alashanyouqi', '0483', '737300', 'A', '101.66705', '39.21533');
INSERT INTO `dd_region` VALUES (465, 462, '额济纳旗', '额济纳旗', '中国,内蒙古自治区,阿拉善盟,额济纳旗', 3, 'ejinaqi', '0483', '735400', 'E', '101.06887', '41.96755');
INSERT INTO `dd_region` VALUES (466, 0, '辽宁', '辽宁省', '中国,辽宁省', 1, 'liaoning', '', '', 'L', '123.429096', '41.796767');
INSERT INTO `dd_region` VALUES (467, 466, '沈阳', '沈阳市', '中国,辽宁省,沈阳市', 2, 'shenyang', '024', '110013', 'S', '123.429096', '41.796767');
INSERT INTO `dd_region` VALUES (468, 467, '和平', '和平区', '中国,辽宁省,沈阳市,和平区', 3, 'heping', '024', '110001', 'H', '123.4204', '41.78997');
INSERT INTO `dd_region` VALUES (469, 467, '沈河', '沈河区', '中国,辽宁省,沈阳市,沈河区', 3, 'shenhe', '024', '110011', 'S', '123.45871', '41.79625');
INSERT INTO `dd_region` VALUES (470, 467, '大东', '大东区', '中国,辽宁省,沈阳市,大东区', 3, 'dadong', '024', '110041', 'D', '123.46997', '41.80539');
INSERT INTO `dd_region` VALUES (471, 467, '皇姑', '皇姑区', '中国,辽宁省,沈阳市,皇姑区', 3, 'huanggu', '024', '110031', 'H', '123.42527', '41.82035');
INSERT INTO `dd_region` VALUES (472, 467, '铁西', '铁西区', '中国,辽宁省,沈阳市,铁西区', 3, 'tiexi', '024', '110021', 'T', '123.37675', '41.80269');
INSERT INTO `dd_region` VALUES (473, 467, '苏家屯', '苏家屯区', '中国,辽宁省,沈阳市,苏家屯区', 3, 'sujiatun', '024', '110101', 'S', '123.34405', '41.66475');
INSERT INTO `dd_region` VALUES (474, 467, '浑南', '浑南区', '中国,辽宁省,沈阳市,浑南区', 3, 'hunnan', '024', '110015', 'H', '123.457707', '41.719450');
INSERT INTO `dd_region` VALUES (475, 467, '沈北新区', '沈北新区', '中国,辽宁省,沈阳市,沈北新区', 3, 'shenbeixinqu', '024', '110121', 'S', '123.52658', '42.05297');
INSERT INTO `dd_region` VALUES (476, 467, '于洪', '于洪区', '中国,辽宁省,沈阳市,于洪区', 3, 'yuhong', '024', '110141', 'Y', '123.30807', '41.794');
INSERT INTO `dd_region` VALUES (477, 467, '辽中', '辽中县', '中国,辽宁省,沈阳市,辽中县', 3, 'liaozhong', '024', '110200', 'L', '122.72659', '41.51302');
INSERT INTO `dd_region` VALUES (478, 467, '康平', '康平县', '中国,辽宁省,沈阳市,康平县', 3, 'kangping', '024', '110500', 'K', '123.35446', '42.75081');
INSERT INTO `dd_region` VALUES (479, 467, '法库', '法库县', '中国,辽宁省,沈阳市,法库县', 3, 'faku', '024', '110400', 'F', '123.41214', '42.50608');
INSERT INTO `dd_region` VALUES (480, 467, '新民', '新民市', '中国,辽宁省,沈阳市,新民市', 3, 'xinmin', '024', '110300', 'X', '122.82867', '41.99847');
INSERT INTO `dd_region` VALUES (481, 466, '大连', '大连市', '中国,辽宁省,大连市', 2, 'dalian', '0411', '116011', 'D', '121.618622', '38.91459');
INSERT INTO `dd_region` VALUES (482, 481, '中山', '中山区', '中国,辽宁省,大连市,中山区', 3, 'zhongshan', '0411', '116001', 'Z', '121.64465', '38.91859');
INSERT INTO `dd_region` VALUES (483, 481, '西岗', '西岗区', '中国,辽宁省,大连市,西岗区', 3, 'xigang', '0411', '116011', 'X', '121.61238', '38.91469');
INSERT INTO `dd_region` VALUES (484, 481, '沙河口', '沙河口区', '中国,辽宁省,大连市,沙河口区', 3, 'shahekou', '0411', '116021', 'S', '121.58017', '38.90536');
INSERT INTO `dd_region` VALUES (485, 481, '甘井子', '甘井子区', '中国,辽宁省,大连市,甘井子区', 3, 'ganjingzi', '0411', '116033', 'G', '121.56567', '38.95017');
INSERT INTO `dd_region` VALUES (486, 481, '旅顺口', '旅顺口区', '中国,辽宁省,大连市,旅顺口区', 3, 'lvshunkou', '0411', '116041', 'L', '121.26202', '38.85125');
INSERT INTO `dd_region` VALUES (487, 481, '金州', '金州区', '中国,辽宁省,大连市,金州区', 3, 'jinzhou', '0411', '116100', 'J', '121.71893', '39.1004');
INSERT INTO `dd_region` VALUES (488, 481, '长海', '长海县', '中国,辽宁省,大连市,长海县', 3, 'changhai', '0411', '116500', 'C', '122.58859', '39.27274');
INSERT INTO `dd_region` VALUES (489, 481, '瓦房店', '瓦房店市', '中国,辽宁省,大连市,瓦房店市', 3, 'wafangdian', '0411', '116300', 'W', '121.98104', '39.62843');
INSERT INTO `dd_region` VALUES (490, 481, '普兰店', '普兰店市', '中国,辽宁省,大连市,普兰店市', 3, 'pulandian', '0411', '116200', 'P', '121.96316', '39.39465');
INSERT INTO `dd_region` VALUES (491, 481, '庄河', '庄河市', '中国,辽宁省,大连市,庄河市', 3, 'zhuanghe', '0411', '116400', 'Z', '122.96725', '39.68815');
INSERT INTO `dd_region` VALUES (492, 466, '鞍山', '鞍山市', '中国,辽宁省,鞍山市', 2, 'anshan', '0412', '114001', 'A', '122.995632', '41.110626');
INSERT INTO `dd_region` VALUES (493, 492, '铁东', '铁东区', '中国,辽宁省,鞍山市,铁东区', 3, 'tiedong', '0412', '114001', 'T', '122.99085', '41.08975');
INSERT INTO `dd_region` VALUES (494, 492, '铁西', '铁西区', '中国,辽宁省,鞍山市,铁西区', 3, 'tiexi', '0413', '114013', 'T', '122.96967', '41.11977');
INSERT INTO `dd_region` VALUES (495, 492, '立山', '立山区', '中国,辽宁省,鞍山市,立山区', 3, 'lishan', '0414', '114031', 'L', '123.02948', '41.15008');
INSERT INTO `dd_region` VALUES (496, 492, '千山', '千山区', '中国,辽宁省,鞍山市,千山区', 3, 'qianshan', '0415', '114041', 'Q', '122.96048', '41.07507');
INSERT INTO `dd_region` VALUES (497, 492, '台安', '台安县', '中国,辽宁省,鞍山市,台安县', 3, 'tai\'an', '0417', '114100', 'T', '122.43585', '41.41265');
INSERT INTO `dd_region` VALUES (498, 492, '岫岩', '岫岩满族自治县', '中国,辽宁省,鞍山市,岫岩满族自治县', 3, 'xiuyan', '0418', '114300', NULL, '123.28875', '40.27996');
INSERT INTO `dd_region` VALUES (499, 492, '海城', '海城市', '中国,辽宁省,鞍山市,海城市', 3, 'haicheng', '0416', '114200', 'H', '122.68457', '40.88142');
INSERT INTO `dd_region` VALUES (500, 466, '抚顺', '抚顺市', '中国,辽宁省,抚顺市', 2, 'fushun', '024', '113008', 'F', '123.921109', '41.875956');
INSERT INTO `dd_region` VALUES (501, 500, '新抚', '新抚区', '中国,辽宁省,抚顺市,新抚区', 3, 'xinfu', '024', '113008', 'X', '123.91264', '41.86205');
INSERT INTO `dd_region` VALUES (502, 500, '东洲', '东洲区', '中国,辽宁省,抚顺市,东洲区', 3, 'dongzhou', '024', '113003', 'D', '124.03759', '41.8519');
INSERT INTO `dd_region` VALUES (503, 500, '望花', '望花区', '中国,辽宁省,抚顺市,望花区', 3, 'wanghua', '024', '113001', 'W', '123.78283', '41.85532');
INSERT INTO `dd_region` VALUES (504, 500, '顺城', '顺城区', '中国,辽宁省,抚顺市,顺城区', 3, 'shuncheng', '024', '113006', 'S', '123.94506', '41.88321');
INSERT INTO `dd_region` VALUES (505, 500, '抚顺', '抚顺县', '中国,辽宁省,抚顺市,抚顺县', 3, 'fushun', '024', '113006', 'F', '124.17755', '41.71217');
INSERT INTO `dd_region` VALUES (506, 500, '新宾', '新宾满族自治县', '中国,辽宁省,抚顺市,新宾满族自治县', 3, 'xinbin', '024', '113200', 'X', '125.04049', '41.73409');
INSERT INTO `dd_region` VALUES (507, 500, '清原', '清原满族自治县', '中国,辽宁省,抚顺市,清原满族自治县', 3, 'qingyuan', '024', '113300', 'Q', '124.92807', '42.10221');
INSERT INTO `dd_region` VALUES (508, 466, '本溪', '本溪市', '中国,辽宁省,本溪市', 2, 'benxi', '0414', '117000', 'B', '123.770519', '41.297909');
INSERT INTO `dd_region` VALUES (509, 508, '平山', '平山区', '中国,辽宁省,本溪市,平山区', 3, 'pingshan', '0414', '117000', 'P', '123.76892', '41.2997');
INSERT INTO `dd_region` VALUES (510, 508, '溪湖', '溪湖区', '中国,辽宁省,本溪市,溪湖区', 3, 'xihu', '0414', '117002', 'X', '123.76764', '41.32921');
INSERT INTO `dd_region` VALUES (511, 508, '明山', '明山区', '中国,辽宁省,本溪市,明山区', 3, 'mingshan', '0414', '117021', 'M', '123.81746', '41.30827');
INSERT INTO `dd_region` VALUES (512, 508, '南芬', '南芬区', '中国,辽宁省,本溪市,南芬区', 3, 'nanfen', '0414', '117014', 'N', '123.74523', '41.1006');
INSERT INTO `dd_region` VALUES (513, 508, '本溪', '本溪满族自治县', '中国,辽宁省,本溪市,本溪满族自治县', 3, 'benxi', '0414', '117100', 'B', '124.12741', '41.30059');
INSERT INTO `dd_region` VALUES (514, 508, '桓仁', '桓仁满族自治县', '中国,辽宁省,本溪市,桓仁满族自治县', 3, 'huanren', '0414', '117200', 'H', '125.36062', '41.26798');
INSERT INTO `dd_region` VALUES (515, 466, '丹东', '丹东市', '中国,辽宁省,丹东市', 2, 'dandong', '0415', '118000', 'D', '124.383044', '40.124296');
INSERT INTO `dd_region` VALUES (516, 515, '元宝', '元宝区', '中国,辽宁省,丹东市,元宝区', 3, 'yuanbao', '0415', '118000', 'Y', '124.39575', '40.13651');
INSERT INTO `dd_region` VALUES (517, 515, '振兴', '振兴区', '中国,辽宁省,丹东市,振兴区', 3, 'zhenxing', '0415', '118002', 'Z', '124.36035', '40.10489');
INSERT INTO `dd_region` VALUES (518, 515, '振安', '振安区', '中国,辽宁省,丹东市,振安区', 3, 'zhen\'an', '0415', '118001', 'Z', '124.42816', '40.15826');
INSERT INTO `dd_region` VALUES (519, 515, '宽甸', '宽甸满族自治县', '中国,辽宁省,丹东市,宽甸满族自治县', 3, 'kuandian', '0415', '118200', 'K', '124.78247', '40.73187');
INSERT INTO `dd_region` VALUES (520, 515, '东港', '东港市', '中国,辽宁省,丹东市,东港市', 3, 'donggang', '0415', '118300', 'D', '124.16287', '39.86256');
INSERT INTO `dd_region` VALUES (521, 515, '凤城', '凤城市', '中国,辽宁省,丹东市,凤城市', 3, 'fengcheng', '0415', '118100', 'F', '124.06671', '40.45302');
INSERT INTO `dd_region` VALUES (522, 466, '锦州', '锦州市', '中国,辽宁省,锦州市', 2, 'jinzhou', '0416', '121000', 'J', '121.135742', '41.119269');
INSERT INTO `dd_region` VALUES (523, 522, '古塔', '古塔区', '中国,辽宁省,锦州市,古塔区', 3, 'guta', '0416', '121001', 'G', '121.12832', '41.11725');
INSERT INTO `dd_region` VALUES (524, 522, '凌河', '凌河区', '中国,辽宁省,锦州市,凌河区', 3, 'linghe', '0416', '121000', 'L', '121.15089', '41.11496');
INSERT INTO `dd_region` VALUES (525, 522, '太和', '太和区', '中国,辽宁省,锦州市,太和区', 3, 'taihe', '0416', '121011', 'T', '121.10354', '41.10929');
INSERT INTO `dd_region` VALUES (526, 522, '黑山', '黑山县', '中国,辽宁省,锦州市,黑山县', 3, 'heishan', '0416', '121400', 'H', '122.12081', '41.69417');
INSERT INTO `dd_region` VALUES (527, 522, '义县', '义县', '中国,辽宁省,锦州市,义县', 3, 'yixian', '0416', '121100', 'Y', '121.24035', '41.53458');
INSERT INTO `dd_region` VALUES (528, 522, '凌海', '凌海市', '中国,辽宁省,锦州市,凌海市', 3, 'linghai', '0416', '121200', 'L', '121.35705', '41.1737');
INSERT INTO `dd_region` VALUES (529, 522, '北镇', '北镇市', '中国,辽宁省,锦州市,北镇市', 3, 'beizhen', '0416', '121300', 'B', '121.79858', '41.59537');
INSERT INTO `dd_region` VALUES (530, 466, '营口', '营口市', '中国,辽宁省,营口市', 2, 'yingkou', '0417', '115003', 'Y', '122.235151', '40.667432');
INSERT INTO `dd_region` VALUES (531, 530, '站前', '站前区', '中国,辽宁省,营口市,站前区', 3, 'zhanqian', '0417', '115002', 'Z', '122.25896', '40.67266');
INSERT INTO `dd_region` VALUES (532, 530, '西市', '西市区', '中国,辽宁省,营口市,西市区', 3, 'xishi', '0417', '115004', 'X', '122.20641', '40.6664');
INSERT INTO `dd_region` VALUES (533, 530, '鲅鱼圈', '鲅鱼圈区', '中国,辽宁省,营口市,鲅鱼圈区', 3, 'bayuquan', '0417', '115007', NULL, '122.13266', '40.26865');
INSERT INTO `dd_region` VALUES (534, 530, '老边', '老边区', '中国,辽宁省,营口市,老边区', 3, 'laobian', '0417', '115005', 'L', '122.37996', '40.6803');
INSERT INTO `dd_region` VALUES (535, 530, '盖州', '盖州市', '中国,辽宁省,营口市,盖州市', 3, 'gaizhou', '0417', '115200', 'G', '122.35464', '40.40446');
INSERT INTO `dd_region` VALUES (536, 530, '大石桥', '大石桥市', '中国,辽宁省,营口市,大石桥市', 3, 'dashiqiao', '0417', '115100', 'D', '122.50927', '40.64567');
INSERT INTO `dd_region` VALUES (537, 466, '阜新', '阜新市', '中国,辽宁省,阜新市', 2, 'fuxin', '0418', '123000', 'F', '121.648962', '42.011796');
INSERT INTO `dd_region` VALUES (538, 537, '海州', '海州区', '中国,辽宁省,阜新市,海州区', 3, 'haizhou', '0418', '123000', 'H', '121.65626', '42.01336');
INSERT INTO `dd_region` VALUES (539, 537, '新邱', '新邱区', '中国,辽宁省,阜新市,新邱区', 3, 'xinqiu', '0418', '123005', 'X', '121.79251', '42.09181');
INSERT INTO `dd_region` VALUES (540, 537, '太平', '太平区', '中国,辽宁省,阜新市,太平区', 3, 'taiping', '0418', '123003', 'T', '121.67865', '42.01065');
INSERT INTO `dd_region` VALUES (541, 537, '清河门', '清河门区', '中国,辽宁省,阜新市,清河门区', 3, 'qinghemen', '0418', '123006', 'Q', '121.4161', '41.78309');
INSERT INTO `dd_region` VALUES (542, 537, '细河', '细河区', '中国,辽宁省,阜新市,细河区', 3, 'xihe', '0418', '123000', 'X', '121.68013', '42.02533');
INSERT INTO `dd_region` VALUES (543, 537, '阜新', '阜新蒙古族自治县', '中国,辽宁省,阜新市,阜新蒙古族自治县', 3, 'fuxin', '0418', '123100', 'F', '121.75787', '42.0651');
INSERT INTO `dd_region` VALUES (544, 537, '彰武', '彰武县', '中国,辽宁省,阜新市,彰武县', 3, 'zhangwu', '0418', '123200', 'Z', '122.54022', '42.38625');
INSERT INTO `dd_region` VALUES (545, 466, '辽阳', '辽阳市', '中国,辽宁省,辽阳市', 2, 'liaoyang', '0419', '111000', 'L', '123.18152', '41.269402');
INSERT INTO `dd_region` VALUES (546, 545, '白塔', '白塔区', '中国,辽宁省,辽阳市,白塔区', 3, 'baita', '0419', '111000', 'B', '123.1747', '41.27025');
INSERT INTO `dd_region` VALUES (547, 545, '文圣', '文圣区', '中国,辽宁省,辽阳市,文圣区', 3, 'wensheng', '0419', '111000', 'W', '123.18521', '41.26267');
INSERT INTO `dd_region` VALUES (548, 545, '宏伟', '宏伟区', '中国,辽宁省,辽阳市,宏伟区', 3, 'hongwei', '0419', '111003', 'H', '123.1929', '41.21852');
INSERT INTO `dd_region` VALUES (549, 545, '弓长岭', '弓长岭区', '中国,辽宁省,辽阳市,弓长岭区', 3, 'gongchangling', '0419', '111008', 'G', '123.41963', '41.15181');
INSERT INTO `dd_region` VALUES (550, 545, '太子河', '太子河区', '中国,辽宁省,辽阳市,太子河区', 3, 'taizihe', '0419', '111000', 'T', '123.18182', '41.25337');
INSERT INTO `dd_region` VALUES (551, 545, '辽阳', '辽阳县', '中国,辽宁省,辽阳市,辽阳县', 3, 'liaoyang', '0419', '111200', 'L', '123.10574', '41.20542');
INSERT INTO `dd_region` VALUES (552, 545, '灯塔', '灯塔市', '中国,辽宁省,辽阳市,灯塔市', 3, 'dengta', '0419', '111300', 'D', '123.33926', '41.42612');
INSERT INTO `dd_region` VALUES (553, 466, '盘锦', '盘锦市', '中国,辽宁省,盘锦市', 2, 'panjin', '0427', '124010', 'P', '122.06957', '41.124484');
INSERT INTO `dd_region` VALUES (554, 553, '双台子', '双台子区', '中国,辽宁省,盘锦市,双台子区', 3, 'shuangtaizi', '0427', '124000', 'S', '122.06011', '41.1906');
INSERT INTO `dd_region` VALUES (555, 553, '兴隆台', '兴隆台区', '中国,辽宁省,盘锦市,兴隆台区', 3, 'xinglongtai', '0427', '124010', 'X', '122.07529', '41.12402');
INSERT INTO `dd_region` VALUES (556, 553, '大洼', '大洼县', '中国,辽宁省,盘锦市,大洼县', 3, 'dawa', '0427', '124200', 'D', '122.08239', '41.00244');
INSERT INTO `dd_region` VALUES (557, 553, '盘山', '盘山县', '中国,辽宁省,盘锦市,盘山县', 3, 'panshan', '0427', '124000', 'P', '121.99777', '41.23805');
INSERT INTO `dd_region` VALUES (558, 466, '铁岭', '铁岭市', '中国,辽宁省,铁岭市', 2, 'tieling', '024', '112000', 'T', '123.844279', '42.290585');
INSERT INTO `dd_region` VALUES (559, 558, '银州', '银州区', '中国,辽宁省,铁岭市,银州区', 3, 'yinzhou', '024', '112000', 'Y', '123.8573', '42.29507');
INSERT INTO `dd_region` VALUES (560, 558, '清河', '清河区', '中国,辽宁省,铁岭市,清河区', 3, 'qinghe', '024', '112003', 'Q', '124.15911', '42.54679');
INSERT INTO `dd_region` VALUES (561, 558, '铁岭', '铁岭县', '中国,辽宁省,铁岭市,铁岭县', 3, 'tieling', '024', '112000', 'T', '123.77325', '42.22498');
INSERT INTO `dd_region` VALUES (562, 558, '西丰', '西丰县', '中国,辽宁省,铁岭市,西丰县', 3, 'xifeng', '024', '112400', 'X', '124.7304', '42.73756');
INSERT INTO `dd_region` VALUES (563, 558, '昌图', '昌图县', '中国,辽宁省,铁岭市,昌图县', 3, 'changtu', '024', '112500', 'C', '124.11206', '42.78428');
INSERT INTO `dd_region` VALUES (564, 558, '调兵山', '调兵山市', '中国,辽宁省,铁岭市,调兵山市', 3, 'diaobingshan', '024', '112700', 'D', '123.56689', '42.4675');
INSERT INTO `dd_region` VALUES (565, 558, '开原', '开原市', '中国,辽宁省,铁岭市,开原市', 3, 'kaiyuan', '024', '112300', 'K', '124.03945', '42.54585');
INSERT INTO `dd_region` VALUES (566, 466, '朝阳', '朝阳市', '中国,辽宁省,朝阳市', 2, 'chaoyang', '0421', '122000', 'C', '120.451176', '41.576758');
INSERT INTO `dd_region` VALUES (567, 566, '双塔', '双塔区', '中国,辽宁省,朝阳市,双塔区', 3, 'shuangta', '0421', '122000', 'S', '120.45385', '41.566');
INSERT INTO `dd_region` VALUES (568, 566, '龙城', '龙城区', '中国,辽宁省,朝阳市,龙城区', 3, 'longcheng', '0421', '122000', 'L', '120.43719', '41.59264');
INSERT INTO `dd_region` VALUES (569, 566, '朝阳', '朝阳县', '中国,辽宁省,朝阳市,朝阳县', 3, 'chaoyang', '0421', '122000', 'C', '120.17401', '41.4324');
INSERT INTO `dd_region` VALUES (570, 566, '建平', '建平县', '中国,辽宁省,朝阳市,建平县', 3, 'jianping', '0421', '122400', 'J', '119.64392', '41.40315');
INSERT INTO `dd_region` VALUES (571, 566, '喀喇沁左翼', '喀喇沁左翼蒙古族自治县', '中国,辽宁省,朝阳市,喀喇沁左翼蒙古族自治县', 3, 'kalaqinzuoyi', '0421', '122300', 'K', '119.74185', '41.12801');
INSERT INTO `dd_region` VALUES (572, 566, '北票', '北票市', '中国,辽宁省,朝阳市,北票市', 3, 'beipiao', '0421', '122100', 'B', '120.76977', '41.80196');
INSERT INTO `dd_region` VALUES (573, 566, '凌源', '凌源市', '中国,辽宁省,朝阳市,凌源市', 3, 'lingyuan', '0421', '122500', 'L', '119.40148', '41.24558');
INSERT INTO `dd_region` VALUES (574, 466, '葫芦岛', '葫芦岛市', '中国,辽宁省,葫芦岛市', 2, 'huludao', '0429', '125000', 'H', '120.856394', '40.755572');
INSERT INTO `dd_region` VALUES (575, 574, '连山', '连山区', '中国,辽宁省,葫芦岛市,连山区', 3, 'lianshan', '0429', '125001', 'L', '120.86393', '40.75554');
INSERT INTO `dd_region` VALUES (576, 574, '龙港', '龙港区', '中国,辽宁省,葫芦岛市,龙港区', 3, 'longgang', '0429', '125003', 'L', '120.94866', '40.71919');
INSERT INTO `dd_region` VALUES (577, 574, '南票', '南票区', '中国,辽宁省,葫芦岛市,南票区', 3, 'nanpiao', '0429', '125027', 'N', '120.74978', '41.10707');
INSERT INTO `dd_region` VALUES (578, 574, '绥中', '绥中县', '中国,辽宁省,葫芦岛市,绥中县', 3, 'suizhong', '0429', '125200', 'S', '120.34451', '40.32552');
INSERT INTO `dd_region` VALUES (579, 574, '建昌', '建昌县', '中国,辽宁省,葫芦岛市,建昌县', 3, 'jianchang', '0429', '125300', 'J', '119.8377', '40.82448');
INSERT INTO `dd_region` VALUES (580, 574, '兴城', '兴城市', '中国,辽宁省,葫芦岛市,兴城市', 3, 'xingcheng', '0429', '125100', 'X', '120.72537', '40.61492');
INSERT INTO `dd_region` VALUES (581, 466, '金普新区', '金普新区', '中国,辽宁省,金普新区', 2, 'jinpuxinqu', '0411', '116100', 'J', '121.789627', '39.055451');
INSERT INTO `dd_region` VALUES (582, 581, '金州新区', '金州新区', '中国,辽宁省,金普新区,金州新区', 3, 'jinzhouxinqu', '0411', '116100', 'J', '121.784821', '39.052252');
INSERT INTO `dd_region` VALUES (583, 581, '普湾新区', '普湾新区', '中国,辽宁省,金普新区,普湾新区', 3, 'puwanxinqu', '0411', '116200', 'P', '121.812812', '39.330093');
INSERT INTO `dd_region` VALUES (584, 581, '保税区', '保税区', '中国,辽宁省,金普新区,保税区', 3, 'baoshuiqu', '0411', '116100', 'B', '121.94289', '39.224614');
INSERT INTO `dd_region` VALUES (585, 0, '吉林', '吉林省', '中国,吉林省', 1, 'jilin', '', '', 'J', '125.3245', '43.886841');
INSERT INTO `dd_region` VALUES (586, 585, '长春', '长春市', '中国,吉林省,长春市', 2, 'changchun', '0431', '130022', 'C', '125.3245', '43.886841');
INSERT INTO `dd_region` VALUES (587, 586, '南关', '南关区', '中国,吉林省,长春市,南关区', 3, 'nanguan', '0431', '130022', 'N', '125.35035', '43.86401');
INSERT INTO `dd_region` VALUES (588, 586, '宽城', '宽城区', '中国,吉林省,长春市,宽城区', 3, 'kuancheng', '0431', '130051', 'K', '125.32635', '43.90182');
INSERT INTO `dd_region` VALUES (589, 586, '朝阳', '朝阳区', '中国,吉林省,长春市,朝阳区', 3, 'chaoyang', '0431', '130012', 'C', '125.2883', '43.83339');
INSERT INTO `dd_region` VALUES (590, 586, '二道', '二道区', '中国,吉林省,长春市,二道区', 3, 'erdao', '0431', '130031', 'E', '125.37429', '43.86501');
INSERT INTO `dd_region` VALUES (591, 586, '绿园', '绿园区', '中国,吉林省,长春市,绿园区', 3, 'lvyuan', '0431', '130062', 'L', '125.25582', '43.88045');
INSERT INTO `dd_region` VALUES (592, 586, '双阳', '双阳区', '中国,吉林省,长春市,双阳区', 3, 'shuangyang', '0431', '130600', 'S', '125.65631', '43.52803');
INSERT INTO `dd_region` VALUES (593, 586, '九台', '九台区', '中国,吉林省,长春市,九台区', 3, 'jiutai', '0431', '130500', 'J', '125.8395', '44.15163');
INSERT INTO `dd_region` VALUES (594, 586, '农安', '农安县', '中国,吉林省,长春市,农安县', 3, 'nong\'an', '0431', '130200', 'N', '125.18481', '44.43265');
INSERT INTO `dd_region` VALUES (595, 586, '榆树', '榆树市', '中国,吉林省,长春市,榆树市', 3, 'yushu', '0431', '130400', 'Y', '126.55688', '44.82523');
INSERT INTO `dd_region` VALUES (596, 586, '德惠', '德惠市', '中国,吉林省,长春市,德惠市', 3, 'dehui', '0431', '130300', 'D', '125.70538', '44.53719');
INSERT INTO `dd_region` VALUES (597, 585, '吉林', '吉林市', '中国,吉林省,吉林市', 2, 'jilin', '0432', '132011', 'J', '126.55302', '43.843577');
INSERT INTO `dd_region` VALUES (598, 597, '昌邑', '昌邑区', '中国,吉林省,吉林市,昌邑区', 3, 'changyi', '0432', '132002', 'C', '126.57424', '43.88183');
INSERT INTO `dd_region` VALUES (599, 597, '龙潭', '龙潭区', '中国,吉林省,吉林市,龙潭区', 3, 'longtan', '0432', '132021', 'L', '126.56213', '43.91054');
INSERT INTO `dd_region` VALUES (600, 597, '船营', '船营区', '中国,吉林省,吉林市,船营区', 3, 'chuanying', '0432', '132011', 'C', '126.54096', '43.83344');
INSERT INTO `dd_region` VALUES (601, 597, '丰满', '丰满区', '中国,吉林省,吉林市,丰满区', 3, 'fengman', '0432', '132013', 'F', '126.56237', '43.82236');
INSERT INTO `dd_region` VALUES (602, 597, '永吉', '永吉县', '中国,吉林省,吉林市,永吉县', 3, 'yongji', '0432', '132200', 'Y', '126.4963', '43.67197');
INSERT INTO `dd_region` VALUES (603, 597, '蛟河', '蛟河市', '中国,吉林省,吉林市,蛟河市', 3, 'jiaohe', '0432', '132500', NULL, '127.34426', '43.72696');
INSERT INTO `dd_region` VALUES (604, 597, '桦甸', '桦甸市', '中国,吉林省,吉林市,桦甸市', 3, 'huadian', '0432', '132400', NULL, '126.74624', '42.97206');
INSERT INTO `dd_region` VALUES (605, 597, '舒兰', '舒兰市', '中国,吉林省,吉林市,舒兰市', 3, 'shulan', '0432', '132600', 'S', '126.9653', '44.40582');
INSERT INTO `dd_region` VALUES (606, 597, '磐石', '磐石市', '中国,吉林省,吉林市,磐石市', 3, 'panshi', '0432', '132300', 'P', '126.0625', '42.94628');
INSERT INTO `dd_region` VALUES (607, 585, '四平', '四平市', '中国,吉林省,四平市', 2, 'siping', '0434', '136000', 'S', '124.370785', '43.170344');
INSERT INTO `dd_region` VALUES (608, 607, '铁西', '铁西区', '中国,吉林省,四平市,铁西区', 3, 'tiexi', '0434', '136000', 'T', '124.37369', '43.17456');
INSERT INTO `dd_region` VALUES (609, 607, '铁东', '铁东区', '中国,吉林省,四平市,铁东区', 3, 'tiedong', '0434', '136001', 'T', '124.40976', '43.16241');
INSERT INTO `dd_region` VALUES (610, 607, '梨树', '梨树县', '中国,吉林省,四平市,梨树县', 3, 'lishu', '0434', '136500', 'L', '124.33563', '43.30717');
INSERT INTO `dd_region` VALUES (611, 607, '伊通', '伊通满族自治县', '中国,吉林省,四平市,伊通满族自治县', 3, 'yitong', '0434', '130700', 'Y', '125.30596', '43.34434');
INSERT INTO `dd_region` VALUES (612, 607, '公主岭', '公主岭市', '中国,吉林省,四平市,公主岭市', 3, 'gongzhuling', '0434', '136100', 'G', '124.82266', '43.50453');
INSERT INTO `dd_region` VALUES (613, 607, '双辽', '双辽市', '中国,吉林省,四平市,双辽市', 3, 'shuangliao', '0434', '136400', 'S', '123.50106', '43.52099');
INSERT INTO `dd_region` VALUES (614, 585, '辽源', '辽源市', '中国,吉林省,辽源市', 2, 'liaoyuan', '0437', '136200', 'L', '125.145349', '42.902692');
INSERT INTO `dd_region` VALUES (615, 614, '龙山', '龙山区', '中国,吉林省,辽源市,龙山区', 3, 'longshan', '0437', '136200', 'L', '125.13641', '42.89714');
INSERT INTO `dd_region` VALUES (616, 614, '西安', '西安区', '中国,吉林省,辽源市,西安区', 3, 'xi\'an', '0437', '136201', 'X', '125.14904', '42.927');
INSERT INTO `dd_region` VALUES (617, 614, '东丰', '东丰县', '中国,吉林省,辽源市,东丰县', 3, 'dongfeng', '0437', '136300', 'D', '125.53244', '42.6783');
INSERT INTO `dd_region` VALUES (618, 614, '东辽', '东辽县', '中国,吉林省,辽源市,东辽县', 3, 'dongliao', '0437', '136600', 'D', '124.98596', '42.92492');
INSERT INTO `dd_region` VALUES (619, 585, '通化', '通化市', '中国,吉林省,通化市', 2, 'tonghua', '0435', '134001', 'T', '125.936501', '41.721177');
INSERT INTO `dd_region` VALUES (620, 619, '东昌', '东昌区', '中国,吉林省,通化市,东昌区', 3, 'dongchang', '0435', '134001', 'D', '125.9551', '41.72849');
INSERT INTO `dd_region` VALUES (621, 619, '二道江', '二道江区', '中国,吉林省,通化市,二道江区', 3, 'erdaojiang', '0435', '134003', 'E', '126.04257', '41.7741');
INSERT INTO `dd_region` VALUES (622, 619, '通化', '通化县', '中国,吉林省,通化市,通化县', 3, 'tonghua', '0435', '134100', 'T', '125.75936', '41.67928');
INSERT INTO `dd_region` VALUES (623, 619, '辉南', '辉南县', '中国,吉林省,通化市,辉南县', 3, 'huinan', '0435', '135100', 'H', '126.04684', '42.68497');
INSERT INTO `dd_region` VALUES (624, 619, '柳河', '柳河县', '中国,吉林省,通化市,柳河县', 3, 'liuhe', '0435', '135300', 'L', '125.74475', '42.28468');
INSERT INTO `dd_region` VALUES (625, 619, '梅河口', '梅河口市', '中国,吉林省,通化市,梅河口市', 3, 'meihekou', '0435', '135000', 'M', '125.71041', '42.53828');
INSERT INTO `dd_region` VALUES (626, 619, '集安', '集安市', '中国,吉林省,通化市,集安市', 3, 'ji\'an', '0435', '134200', 'J', '126.18829', '41.12268');
INSERT INTO `dd_region` VALUES (627, 585, '白山', '白山市', '中国,吉林省,白山市', 2, 'baishan', '0439', '134300', 'B', '126.427839', '41.942505');
INSERT INTO `dd_region` VALUES (628, 627, '浑江', '浑江区', '中国,吉林省,白山市,浑江区', 3, 'hunjiang', '0439', '134300', 'H', '126.422342', '41.945656');
INSERT INTO `dd_region` VALUES (629, 627, '江源', '江源区', '中国,吉林省,白山市,江源区', 3, 'jiangyuan', '0439', '134700', 'J', '126.59079', '42.05664');
INSERT INTO `dd_region` VALUES (630, 627, '抚松', '抚松县', '中国,吉林省,白山市,抚松县', 3, 'fusong', '0439', '134500', 'F', '127.2803', '42.34198');
INSERT INTO `dd_region` VALUES (631, 627, '靖宇', '靖宇县', '中国,吉林省,白山市,靖宇县', 3, 'jingyu', '0439', '135200', 'J', '126.81308', '42.38863');
INSERT INTO `dd_region` VALUES (632, 627, '长白', '长白朝鲜族自治县', '中国,吉林省,白山市,长白朝鲜族自治县', 3, 'changbai', '0439', '134400', 'C', '128.20047', '41.41996');
INSERT INTO `dd_region` VALUES (633, 627, '临江', '临江市', '中国,吉林省,白山市,临江市', 3, 'linjiang', '0439', '134600', 'L', '126.91751', '41.81142');
INSERT INTO `dd_region` VALUES (634, 585, '松原', '松原市', '中国,吉林省,松原市', 2, 'songyuan', '0438', '138000', 'S', '124.823608', '45.118243');
INSERT INTO `dd_region` VALUES (635, 634, '宁江', '宁江区', '中国,吉林省,松原市,宁江区', 3, 'ningjiang', '0438', '138000', 'N', '124.81689', '45.17175');
INSERT INTO `dd_region` VALUES (636, 634, '前郭尔罗斯', '前郭尔罗斯蒙古族自治县', '中国,吉林省,松原市,前郭尔罗斯蒙古族自治县', 3, 'qianguoerluosi', '0438', '138000', 'Q', '124.82351', '45.11726');
INSERT INTO `dd_region` VALUES (637, 634, '长岭', '长岭县', '中国,吉林省,松原市,长岭县', 3, 'changling', '0438', '131500', 'C', '123.96725', '44.27581');
INSERT INTO `dd_region` VALUES (638, 634, '乾安', '乾安县', '中国,吉林省,松原市,乾安县', 3, 'qian\'an', '0438', '131400', 'Q', '124.02737', '45.01068');
INSERT INTO `dd_region` VALUES (639, 634, '扶余', '扶余市', '中国,吉林省,松原市,扶余市', 3, 'fuyu', '0438', '131200', 'F', '126.042758', '44.986199');
INSERT INTO `dd_region` VALUES (640, 585, '白城', '白城市', '中国,吉林省,白城市', 2, 'baicheng', '0436', '137000', 'B', '122.841114', '45.619026');
INSERT INTO `dd_region` VALUES (641, 640, '洮北', '洮北区', '中国,吉林省,白城市,洮北区', 3, 'taobei', '0436', '137000', NULL, '122.85104', '45.62167');
INSERT INTO `dd_region` VALUES (642, 640, '镇赉', '镇赉县', '中国,吉林省,白城市,镇赉县', 3, 'zhenlai', '0436', '137300', 'Z', '123.19924', '45.84779');
INSERT INTO `dd_region` VALUES (643, 640, '通榆', '通榆县', '中国,吉林省,白城市,通榆县', 3, 'tongyu', '0436', '137200', 'T', '123.08761', '44.81388');
INSERT INTO `dd_region` VALUES (644, 640, '洮南', '洮南市', '中国,吉林省,白城市,洮南市', 3, 'taonan', '0436', '137100', NULL, '122.78772', '45.33502');
INSERT INTO `dd_region` VALUES (645, 640, '大安', '大安市', '中国,吉林省,白城市,大安市', 3, 'da\'an', '0436', '131300', 'D', '124.29519', '45.50846');
INSERT INTO `dd_region` VALUES (646, 585, '延边', '延边朝鲜族自治州', '中国,吉林省,延边朝鲜族自治州', 2, 'yanbian', '0433', '133000', 'Y', '129.513228', '42.904823');
INSERT INTO `dd_region` VALUES (647, 646, '延吉', '延吉市', '中国,吉林省,延边朝鲜族自治州,延吉市', 3, 'yanji', '0433', '133000', 'Y', '129.51357', '42.90682');
INSERT INTO `dd_region` VALUES (648, 646, '图们', '图们市', '中国,吉林省,延边朝鲜族自治州,图们市', 3, 'tumen', '0433', '133100', 'T', '129.84381', '42.96801');
INSERT INTO `dd_region` VALUES (649, 646, '敦化', '敦化市', '中国,吉林省,延边朝鲜族自治州,敦化市', 3, 'dunhua', '0433', '133700', 'D', '128.23242', '43.37304');
INSERT INTO `dd_region` VALUES (650, 646, '珲春', '珲春市', '中国,吉林省,延边朝鲜族自治州,珲春市', 3, 'hunchun', '0433', '133300', NULL, '130.36572', '42.86242');
INSERT INTO `dd_region` VALUES (651, 646, '龙井', '龙井市', '中国,吉林省,延边朝鲜族自治州,龙井市', 3, 'longjing', '0433', '133400', 'L', '129.42584', '42.76804');
INSERT INTO `dd_region` VALUES (652, 646, '和龙', '和龙市', '中国,吉林省,延边朝鲜族自治州,和龙市', 3, 'helong', '0433', '133500', 'H', '129.01077', '42.5464');
INSERT INTO `dd_region` VALUES (653, 646, '汪清', '汪清县', '中国,吉林省,延边朝鲜族自治州,汪清县', 3, 'wangqing', '0433', '133200', 'W', '129.77121', '43.31278');
INSERT INTO `dd_region` VALUES (654, 646, '安图', '安图县', '中国,吉林省,延边朝鲜族自治州,安图县', 3, 'antu', '0433', '133600', 'A', '128.90625', '43.11533');
INSERT INTO `dd_region` VALUES (655, 0, '黑龙江', '黑龙江省', '中国,黑龙江省', 1, 'heilongjiang', '', '', 'H', '126.642464', '45.756967');
INSERT INTO `dd_region` VALUES (656, 655, '哈尔滨', '哈尔滨市', '中国,黑龙江省,哈尔滨市', 2, 'harbin', '0451', '150010', 'H', '126.642464', '45.756967');
INSERT INTO `dd_region` VALUES (657, 656, '道里', '道里区', '中国,黑龙江省,哈尔滨市,道里区', 3, 'daoli', '0451', '150010', 'D', '126.61705', '45.75586');
INSERT INTO `dd_region` VALUES (658, 656, '南岗', '南岗区', '中国,黑龙江省,哈尔滨市,南岗区', 3, 'nangang', '0451', '150006', 'N', '126.66854', '45.75996');
INSERT INTO `dd_region` VALUES (659, 656, '道外', '道外区', '中国,黑龙江省,哈尔滨市,道外区', 3, 'daowai', '0451', '150020', 'D', '126.64938', '45.79187');
INSERT INTO `dd_region` VALUES (660, 656, '平房', '平房区', '中国,黑龙江省,哈尔滨市,平房区', 3, 'pingfang', '0451', '150060', 'P', '126.63729', '45.59777');
INSERT INTO `dd_region` VALUES (661, 656, '松北', '松北区', '中国,黑龙江省,哈尔滨市,松北区', 3, 'songbei', '0451', '150028', 'S', '126.56276', '45.80831');
INSERT INTO `dd_region` VALUES (662, 656, '香坊', '香坊区', '中国,黑龙江省,哈尔滨市,香坊区', 3, 'xiangfang', '0451', '150036', 'X', '126.67968', '45.72383');
INSERT INTO `dd_region` VALUES (663, 656, '呼兰', '呼兰区', '中国,黑龙江省,哈尔滨市,呼兰区', 3, 'hulan', '0451', '150500', 'H', '126.58792', '45.88895');
INSERT INTO `dd_region` VALUES (664, 656, '阿城', '阿城区', '中国,黑龙江省,哈尔滨市,阿城区', 3, 'a\'cheng', '0451', '150300', 'A', '126.97525', '45.54144');
INSERT INTO `dd_region` VALUES (665, 656, '双城', '双城区', '中国,黑龙江省,哈尔滨市,双城区', 3, 'shuangcheng', '0451', '150100', 'S', '126.308784', '45.377942');
INSERT INTO `dd_region` VALUES (666, 656, '依兰', '依兰县', '中国,黑龙江省,哈尔滨市,依兰县', 3, 'yilan', '0451', '154800', 'Y', '129.56817', '46.3247');
INSERT INTO `dd_region` VALUES (667, 656, '方正', '方正县', '中国,黑龙江省,哈尔滨市,方正县', 3, 'fangzheng', '0451', '150800', 'F', '128.82952', '45.85162');
INSERT INTO `dd_region` VALUES (668, 656, '宾县', '宾县', '中国,黑龙江省,哈尔滨市,宾县', 3, 'binxian', '0451', '150400', 'B', '127.48675', '45.75504');
INSERT INTO `dd_region` VALUES (669, 656, '巴彦', '巴彦县', '中国,黑龙江省,哈尔滨市,巴彦县', 3, 'bayan', '0451', '151800', 'B', '127.40799', '46.08148');
INSERT INTO `dd_region` VALUES (670, 656, '木兰', '木兰县', '中国,黑龙江省,哈尔滨市,木兰县', 3, 'mulan', '0451', '151900', 'M', '128.0448', '45.94944');
INSERT INTO `dd_region` VALUES (671, 656, '通河', '通河县', '中国,黑龙江省,哈尔滨市,通河县', 3, 'tonghe', '0451', '150900', 'T', '128.74603', '45.99007');
INSERT INTO `dd_region` VALUES (672, 656, '延寿', '延寿县', '中国,黑龙江省,哈尔滨市,延寿县', 3, 'yanshou', '0451', '150700', 'Y', '128.33419', '45.4554');
INSERT INTO `dd_region` VALUES (673, 656, '尚志', '尚志市', '中国,黑龙江省,哈尔滨市,尚志市', 3, 'shangzhi', '0451', '150600', 'S', '127.96191', '45.21736');
INSERT INTO `dd_region` VALUES (674, 656, '五常', '五常市', '中国,黑龙江省,哈尔滨市,五常市', 3, 'wuchang', '0451', '150200', 'W', '127.16751', '44.93184');
INSERT INTO `dd_region` VALUES (675, 655, '齐齐哈尔', '齐齐哈尔市', '中国,黑龙江省,齐齐哈尔市', 2, 'qiqihar', '0452', '161005', 'Q', '123.953486', '47.348079');
INSERT INTO `dd_region` VALUES (676, 675, '龙沙', '龙沙区', '中国,黑龙江省,齐齐哈尔市,龙沙区', 3, 'longsha', '0452', '161000', 'L', '123.95752', '47.31776');
INSERT INTO `dd_region` VALUES (677, 675, '建华', '建华区', '中国,黑龙江省,齐齐哈尔市,建华区', 3, 'jianhua', '0452', '161006', 'J', '124.0133', '47.36718');
INSERT INTO `dd_region` VALUES (678, 675, '铁锋', '铁锋区', '中国,黑龙江省,齐齐哈尔市,铁锋区', 3, 'tiefeng', '0452', '161000', 'T', '123.97821', '47.34075');
INSERT INTO `dd_region` VALUES (679, 675, '昂昂溪', '昂昂溪区', '中国,黑龙江省,齐齐哈尔市,昂昂溪区', 3, 'angangxi', '0452', '161031', 'A', '123.82229', '47.15513');
INSERT INTO `dd_region` VALUES (680, 675, '富拉尔基', '富拉尔基区', '中国,黑龙江省,齐齐哈尔市,富拉尔基区', 3, 'fulaerji', '0452', '161041', 'F', '123.62918', '47.20884');
INSERT INTO `dd_region` VALUES (681, 675, '碾子山', '碾子山区', '中国,黑龙江省,齐齐哈尔市,碾子山区', 3, 'nianzishan', '0452', '161046', 'N', '122.88183', '47.51662');
INSERT INTO `dd_region` VALUES (682, 675, '梅里斯', '梅里斯达斡尔族区', '中国,黑龙江省,齐齐哈尔市,梅里斯达斡尔族区', 3, 'meilisi', '0452', '161021', 'M', '123.75274', '47.30946');
INSERT INTO `dd_region` VALUES (683, 675, '龙江', '龙江县', '中国,黑龙江省,齐齐哈尔市,龙江县', 3, 'longjiang', '0452', '161100', 'L', '123.20532', '47.33868');
INSERT INTO `dd_region` VALUES (684, 675, '依安', '依安县', '中国,黑龙江省,齐齐哈尔市,依安县', 3, 'yi\'an', '0452', '161500', 'Y', '125.30896', '47.8931');
INSERT INTO `dd_region` VALUES (685, 675, '泰来', '泰来县', '中国,黑龙江省,齐齐哈尔市,泰来县', 3, 'tailai', '0452', '162400', 'T', '123.42285', '46.39386');
INSERT INTO `dd_region` VALUES (686, 675, '甘南', '甘南县', '中国,黑龙江省,齐齐哈尔市,甘南县', 3, 'gannan', '0452', '162100', 'G', '123.50317', '47.92437');
INSERT INTO `dd_region` VALUES (687, 675, '富裕', '富裕县', '中国,黑龙江省,齐齐哈尔市,富裕县', 3, 'fuyu', '0452', '161200', 'F', '124.47457', '47.77431');
INSERT INTO `dd_region` VALUES (688, 675, '克山', '克山县', '中国,黑龙江省,齐齐哈尔市,克山县', 3, 'keshan', '0452', '161600', 'K', '125.87396', '48.03265');
INSERT INTO `dd_region` VALUES (689, 675, '克东', '克东县', '中国,黑龙江省,齐齐哈尔市,克东县', 3, 'kedong', '0452', '164800', 'K', '126.24917', '48.03828');
INSERT INTO `dd_region` VALUES (690, 675, '拜泉', '拜泉县', '中国,黑龙江省,齐齐哈尔市,拜泉县', 3, 'baiquan', '0452', '164700', 'B', '126.09167', '47.60817');
INSERT INTO `dd_region` VALUES (691, 675, '讷河', '讷河市', '中国,黑龙江省,齐齐哈尔市,讷河市', 3, 'nehe', '0452', '161300', NULL, '124.87713', '48.48388');
INSERT INTO `dd_region` VALUES (692, 655, '鸡西', '鸡西市', '中国,黑龙江省,鸡西市', 2, 'jixi', '0467', '158100', 'J', '130.975966', '45.300046');
INSERT INTO `dd_region` VALUES (693, 692, '鸡冠', '鸡冠区', '中国,黑龙江省,鸡西市,鸡冠区', 3, 'jiguan', '0467', '158100', 'J', '130.98139', '45.30396');
INSERT INTO `dd_region` VALUES (694, 692, '恒山', '恒山区', '中国,黑龙江省,鸡西市,恒山区', 3, 'hengshan', '0467', '158130', 'H', '130.90493', '45.21071');
INSERT INTO `dd_region` VALUES (695, 692, '滴道', '滴道区', '中国,黑龙江省,鸡西市,滴道区', 3, 'didao', '0467', '158150', 'D', '130.84841', '45.35109');
INSERT INTO `dd_region` VALUES (696, 692, '梨树', '梨树区', '中国,黑龙江省,鸡西市,梨树区', 3, 'lishu', '0467', '158160', 'L', '130.69848', '45.09037');
INSERT INTO `dd_region` VALUES (697, 692, '城子河', '城子河区', '中国,黑龙江省,鸡西市,城子河区', 3, 'chengzihe', '0467', '158170', 'C', '131.01132', '45.33689');
INSERT INTO `dd_region` VALUES (698, 692, '麻山', '麻山区', '中国,黑龙江省,鸡西市,麻山区', 3, 'mashan', '0467', '158180', 'M', '130.47811', '45.21209');
INSERT INTO `dd_region` VALUES (699, 692, '鸡东', '鸡东县', '中国,黑龙江省,鸡西市,鸡东县', 3, 'jidong', '0467', '158200', 'J', '131.12423', '45.26025');
INSERT INTO `dd_region` VALUES (700, 692, '虎林', '虎林市', '中国,黑龙江省,鸡西市,虎林市', 3, 'hulin', '0467', '158400', 'H', '132.93679', '45.76291');
INSERT INTO `dd_region` VALUES (701, 692, '密山', '密山市', '中国,黑龙江省,鸡西市,密山市', 3, 'mishan', '0467', '158300', 'M', '131.84625', '45.5297');
INSERT INTO `dd_region` VALUES (702, 655, '鹤岗', '鹤岗市', '中国,黑龙江省,鹤岗市', 2, 'hegang', '0468', '154100', 'H', '130.277487', '47.332085');
INSERT INTO `dd_region` VALUES (703, 702, '向阳', '向阳区', '中国,黑龙江省,鹤岗市,向阳区', 3, 'xiangyang', '0468', '154100', 'X', '130.2943', '47.34247');
INSERT INTO `dd_region` VALUES (704, 702, '工农', '工农区', '中国,黑龙江省,鹤岗市,工农区', 3, 'gongnong', '0468', '154101', 'G', '130.27468', '47.31869');
INSERT INTO `dd_region` VALUES (705, 702, '南山', '南山区', '中国,黑龙江省,鹤岗市,南山区', 3, 'nanshan', '0468', '154104', 'N', '130.27676', '47.31404');
INSERT INTO `dd_region` VALUES (706, 702, '兴安', '兴安区', '中国,黑龙江省,鹤岗市,兴安区', 3, 'xing\'an', '0468', '154102', 'X', '130.23965', '47.2526');
INSERT INTO `dd_region` VALUES (707, 702, '东山', '东山区', '中国,黑龙江省,鹤岗市,东山区', 3, 'dongshan', '0468', '154106', 'D', '130.31706', '47.33853');
INSERT INTO `dd_region` VALUES (708, 702, '兴山', '兴山区', '中国,黑龙江省,鹤岗市,兴山区', 3, 'xingshan', '0468', '154105', 'X', '130.29271', '47.35776');
INSERT INTO `dd_region` VALUES (709, 702, '萝北', '萝北县', '中国,黑龙江省,鹤岗市,萝北县', 3, 'luobei', '0468', '154200', 'L', '130.83346', '47.57959');
INSERT INTO `dd_region` VALUES (710, 702, '绥滨', '绥滨县', '中国,黑龙江省,鹤岗市,绥滨县', 3, 'suibin', '0468', '156200', 'S', '131.86029', '47.2903');
INSERT INTO `dd_region` VALUES (711, 655, '双鸭山', '双鸭山市', '中国,黑龙江省,双鸭山市', 2, 'shuangyashan', '0469', '155100', 'S', '131.157304', '46.643442');
INSERT INTO `dd_region` VALUES (712, 711, '尖山', '尖山区', '中国,黑龙江省,双鸭山市,尖山区', 3, 'jianshan', '0469', '155100', 'J', '131.15841', '46.64635');
INSERT INTO `dd_region` VALUES (713, 711, '岭东', '岭东区', '中国,黑龙江省,双鸭山市,岭东区', 3, 'lingdong', '0469', '155120', 'L', '131.16473', '46.59043');
INSERT INTO `dd_region` VALUES (714, 711, '四方台', '四方台区', '中国,黑龙江省,双鸭山市,四方台区', 3, 'sifangtai', '0469', '155130', 'S', '131.33593', '46.59499');
INSERT INTO `dd_region` VALUES (715, 711, '宝山', '宝山区', '中国,黑龙江省,双鸭山市,宝山区', 3, 'baoshan', '0469', '155131', 'B', '131.4016', '46.57718');
INSERT INTO `dd_region` VALUES (716, 711, '集贤', '集贤县', '中国,黑龙江省,双鸭山市,集贤县', 3, 'jixian', '0469', '155900', 'J', '131.14053', '46.72678');
INSERT INTO `dd_region` VALUES (717, 711, '友谊', '友谊县', '中国,黑龙江省,双鸭山市,友谊县', 3, 'youyi', '0469', '155800', 'Y', '131.80789', '46.76739');
INSERT INTO `dd_region` VALUES (718, 711, '宝清', '宝清县', '中国,黑龙江省,双鸭山市,宝清县', 3, 'baoqing', '0469', '155600', 'B', '132.19695', '46.32716');
INSERT INTO `dd_region` VALUES (719, 711, '饶河', '饶河县', '中国,黑龙江省,双鸭山市,饶河县', 3, 'raohe', '0469', '155700', 'R', '134.01986', '46.79899');
INSERT INTO `dd_region` VALUES (720, 655, '大庆', '大庆市', '中国,黑龙江省,大庆市', 2, 'daqing', '0459', '163000', 'D', '125.11272', '46.590734');
INSERT INTO `dd_region` VALUES (721, 720, '萨尔图', '萨尔图区', '中国,黑龙江省,大庆市,萨尔图区', 3, 'saertu', '0459', '163001', 'S', '125.08792', '46.59359');
INSERT INTO `dd_region` VALUES (722, 720, '龙凤', '龙凤区', '中国,黑龙江省,大庆市,龙凤区', 3, 'longfeng', '0459', '163711', 'L', '125.11657', '46.53273');
INSERT INTO `dd_region` VALUES (723, 720, '让胡路', '让胡路区', '中国,黑龙江省,大庆市,让胡路区', 3, 'ranghulu', '0459', '163712', 'R', '124.87075', '46.6522');
INSERT INTO `dd_region` VALUES (724, 720, '红岗', '红岗区', '中国,黑龙江省,大庆市,红岗区', 3, 'honggang', '0459', '163511', 'H', '124.89248', '46.40128');
INSERT INTO `dd_region` VALUES (725, 720, '大同', '大同区', '中国,黑龙江省,大庆市,大同区', 3, 'datong', '0459', '163515', 'D', '124.81591', '46.03295');
INSERT INTO `dd_region` VALUES (726, 720, '肇州', '肇州县', '中国,黑龙江省,大庆市,肇州县', 3, 'zhaozhou', '0459', '166400', 'Z', '125.27059', '45.70414');
INSERT INTO `dd_region` VALUES (727, 720, '肇源', '肇源县', '中国,黑龙江省,大庆市,肇源县', 3, 'zhaoyuan', '0459', '166500', 'Z', '125.08456', '45.52032');
INSERT INTO `dd_region` VALUES (728, 720, '林甸', '林甸县', '中国,黑龙江省,大庆市,林甸县', 3, 'lindian', '0459', '166300', 'L', '124.87564', '47.18601');
INSERT INTO `dd_region` VALUES (729, 720, '杜尔伯特', '杜尔伯特蒙古族自治县', '中国,黑龙江省,大庆市,杜尔伯特蒙古族自治县', 3, 'duerbote', '0459', '166200', 'D', '124.44937', '46.86507');
INSERT INTO `dd_region` VALUES (730, 655, '伊春', '伊春市', '中国,黑龙江省,伊春市', 2, 'yichun', '0458', '153000', 'Y', '128.899396', '47.724775');
INSERT INTO `dd_region` VALUES (731, 730, '伊春', '伊春区', '中国,黑龙江省,伊春市,伊春区', 3, 'yichun', '0458', '153000', 'Y', '128.90752', '47.728');
INSERT INTO `dd_region` VALUES (732, 730, '南岔', '南岔区', '中国,黑龙江省,伊春市,南岔区', 3, 'nancha', '0458', '153100', 'N', '129.28362', '47.13897');
INSERT INTO `dd_region` VALUES (733, 730, '友好', '友好区', '中国,黑龙江省,伊春市,友好区', 3, 'youhao', '0458', '153031', 'Y', '128.84039', '47.85371');
INSERT INTO `dd_region` VALUES (734, 730, '西林', '西林区', '中国,黑龙江省,伊春市,西林区', 3, 'xilin', '0458', '153025', 'X', '129.31201', '47.48103');
INSERT INTO `dd_region` VALUES (735, 730, '翠峦', '翠峦区', '中国,黑龙江省,伊春市,翠峦区', 3, 'cuiluan', '0458', '153013', 'C', '128.66729', '47.72503');
INSERT INTO `dd_region` VALUES (736, 730, '新青', '新青区', '中国,黑龙江省,伊春市,新青区', 3, 'xinqing', '0458', '153036', 'X', '129.53653', '48.29067');
INSERT INTO `dd_region` VALUES (737, 730, '美溪', '美溪区', '中国,黑龙江省,伊春市,美溪区', 3, 'meixi', '0458', '153021', 'M', '129.13708', '47.63513');
INSERT INTO `dd_region` VALUES (738, 730, '金山屯', '金山屯区', '中国,黑龙江省,伊春市,金山屯区', 3, 'jinshantun', '0458', '153026', 'J', '129.43768', '47.41349');
INSERT INTO `dd_region` VALUES (739, 730, '五营', '五营区', '中国,黑龙江省,伊春市,五营区', 3, 'wuying', '0458', '153033', 'W', '129.24545', '48.10791');
INSERT INTO `dd_region` VALUES (740, 730, '乌马河', '乌马河区', '中国,黑龙江省,伊春市,乌马河区', 3, 'wumahe', '0458', '153011', 'W', '128.79672', '47.728');
INSERT INTO `dd_region` VALUES (741, 730, '汤旺河', '汤旺河区', '中国,黑龙江省,伊春市,汤旺河区', 3, 'tangwanghe', '0458', '153037', 'T', '129.57226', '48.45182');
INSERT INTO `dd_region` VALUES (742, 730, '带岭', '带岭区', '中国,黑龙江省,伊春市,带岭区', 3, 'dailing', '0458', '153106', 'D', '129.02352', '47.02553');
INSERT INTO `dd_region` VALUES (743, 730, '乌伊岭', '乌伊岭区', '中国,黑龙江省,伊春市,乌伊岭区', 3, 'wuyiling', '0458', '153038', 'W', '129.43981', '48.59602');
INSERT INTO `dd_region` VALUES (744, 730, '红星', '红星区', '中国,黑龙江省,伊春市,红星区', 3, 'hongxing', '0458', '153035', 'H', '129.3887', '48.23944');
INSERT INTO `dd_region` VALUES (745, 730, '上甘岭', '上甘岭区', '中国,黑龙江省,伊春市,上甘岭区', 3, 'shangganling', '0458', '153032', 'S', '129.02447', '47.97522');
INSERT INTO `dd_region` VALUES (746, 730, '嘉荫', '嘉荫县', '中国,黑龙江省,伊春市,嘉荫县', 3, 'jiayin', '0458', '153200', 'J', '130.39825', '48.8917');
INSERT INTO `dd_region` VALUES (747, 730, '铁力', '铁力市', '中国,黑龙江省,伊春市,铁力市', 3, 'tieli', '0458', '152500', 'T', '128.0317', '46.98571');
INSERT INTO `dd_region` VALUES (748, 655, '佳木斯', '佳木斯市', '中国,黑龙江省,佳木斯市', 2, 'jiamusi', '0454', '154002', 'J', '130.361634', '46.809606');
INSERT INTO `dd_region` VALUES (749, 748, '向阳', '向阳区', '中国,黑龙江省,佳木斯市,向阳区', 3, 'xiangyang', '0454', '154002', 'X', '130.36519', '46.80778');
INSERT INTO `dd_region` VALUES (750, 748, '前进', '前进区', '中国,黑龙江省,佳木斯市,前进区', 3, 'qianjin', '0454', '154002', 'Q', '130.37497', '46.81401');
INSERT INTO `dd_region` VALUES (751, 748, '东风', '东风区', '中国,黑龙江省,佳木斯市,东风区', 3, 'dongfeng', '0454', '154005', 'D', '130.40366', '46.82257');
INSERT INTO `dd_region` VALUES (752, 748, '郊区', '郊区', '中国,黑龙江省,佳木斯市,郊区', 3, 'jiaoqu', '0454', '154004', 'J', '130.32731', '46.80958');
INSERT INTO `dd_region` VALUES (753, 748, '桦南', '桦南县', '中国,黑龙江省,佳木斯市,桦南县', 3, 'huanan', '0454', '154400', NULL, '130.55361', '46.23921');
INSERT INTO `dd_region` VALUES (754, 748, '桦川', '桦川县', '中国,黑龙江省,佳木斯市,桦川县', 3, 'huachuan', '0454', '154300', NULL, '130.71893', '47.02297');
INSERT INTO `dd_region` VALUES (755, 748, '汤原', '汤原县', '中国,黑龙江省,佳木斯市,汤原县', 3, 'tangyuan', '0454', '154700', 'T', '129.90966', '46.72755');
INSERT INTO `dd_region` VALUES (756, 748, '抚远', '抚远县', '中国,黑龙江省,佳木斯市,抚远县', 3, 'fuyuan', '0454', '156500', 'F', '134.29595', '48.36794');
INSERT INTO `dd_region` VALUES (757, 748, '同江', '同江市', '中国,黑龙江省,佳木斯市,同江市', 3, 'tongjiang', '0454', '156400', 'T', '132.51095', '47.64211');
INSERT INTO `dd_region` VALUES (758, 748, '富锦', '富锦市', '中国,黑龙江省,佳木斯市,富锦市', 3, 'fujin', '0454', '156100', 'F', '132.03707', '47.25132');
INSERT INTO `dd_region` VALUES (759, 655, '七台河', '七台河市', '中国,黑龙江省,七台河市', 2, 'qitaihe', '0464', '154600', 'Q', '131.015584', '45.771266');
INSERT INTO `dd_region` VALUES (760, 759, '新兴', '新兴区', '中国,黑龙江省,七台河市,新兴区', 3, 'xinxing', '0464', '154604', 'X', '130.93212', '45.81624');
INSERT INTO `dd_region` VALUES (761, 759, '桃山', '桃山区', '中国,黑龙江省,七台河市,桃山区', 3, 'taoshan', '0464', '154600', 'T', '131.01786', '45.76782');
INSERT INTO `dd_region` VALUES (762, 759, '茄子河', '茄子河区', '中国,黑龙江省,七台河市,茄子河区', 3, 'qiezihe', '0464', '154622', 'Q', '131.06807', '45.78519');
INSERT INTO `dd_region` VALUES (763, 759, '勃利', '勃利县', '中国,黑龙江省,七台河市,勃利县', 3, 'boli', '0464', '154500', 'B', '130.59179', '45.755');
INSERT INTO `dd_region` VALUES (764, 655, '牡丹江', '牡丹江市', '中国,黑龙江省,牡丹江市', 2, 'mudanjiang', '0453', '157000', 'M', '129.618602', '44.582962');
INSERT INTO `dd_region` VALUES (765, 764, '东安', '东安区', '中国,黑龙江省,牡丹江市,东安区', 3, 'dong\'an', '0453', '157000', 'D', '129.62665', '44.58133');
INSERT INTO `dd_region` VALUES (766, 764, '阳明', '阳明区', '中国,黑龙江省,牡丹江市,阳明区', 3, 'yangming', '0453', '157013', 'Y', '129.63547', '44.59603');
INSERT INTO `dd_region` VALUES (767, 764, '爱民', '爱民区', '中国,黑龙江省,牡丹江市,爱民区', 3, 'aimin', '0453', '157009', 'A', '129.59077', '44.59648');
INSERT INTO `dd_region` VALUES (768, 764, '西安', '西安区', '中国,黑龙江省,牡丹江市,西安区', 3, 'xi\'an', '0453', '157000', 'X', '129.61616', '44.57766');
INSERT INTO `dd_region` VALUES (769, 764, '东宁', '东宁县', '中国,黑龙江省,牡丹江市,东宁县', 3, 'dongning', '0453', '157200', 'D', '131.12793', '44.0661');
INSERT INTO `dd_region` VALUES (770, 764, '林口', '林口县', '中国,黑龙江省,牡丹江市,林口县', 3, 'linkou', '0453', '157600', 'L', '130.28393', '45.27809');
INSERT INTO `dd_region` VALUES (771, 764, '绥芬河', '绥芬河市', '中国,黑龙江省,牡丹江市,绥芬河市', 3, 'suifenhe', '0453', '157300', 'S', '131.15139', '44.41249');
INSERT INTO `dd_region` VALUES (772, 764, '海林', '海林市', '中国,黑龙江省,牡丹江市,海林市', 3, 'hailin', '0453', '157100', 'H', '129.38156', '44.59');
INSERT INTO `dd_region` VALUES (773, 764, '宁安', '宁安市', '中国,黑龙江省,牡丹江市,宁安市', 3, 'ning\'an', '0453', '157400', 'N', '129.48303', '44.34016');
INSERT INTO `dd_region` VALUES (774, 764, '穆棱', '穆棱市', '中国,黑龙江省,牡丹江市,穆棱市', 3, 'muling', '0453', '157500', 'M', '130.52465', '44.919');
INSERT INTO `dd_region` VALUES (775, 655, '黑河', '黑河市', '中国,黑龙江省,黑河市', 2, 'heihe', '0456', '164300', 'H', '127.499023', '50.249585');
INSERT INTO `dd_region` VALUES (776, 775, '爱辉', '爱辉区', '中国,黑龙江省,黑河市,爱辉区', 3, 'aihui', '0456', '164300', 'A', '127.50074', '50.25202');
INSERT INTO `dd_region` VALUES (777, 775, '嫩江', '嫩江县', '中国,黑龙江省,黑河市,嫩江县', 3, 'nenjiang', '0456', '161400', 'N', '125.22607', '49.17844');
INSERT INTO `dd_region` VALUES (778, 775, '逊克', '逊克县', '中国,黑龙江省,黑河市,逊克县', 3, 'xunke', '0456', '164400', 'X', '128.47882', '49.57983');
INSERT INTO `dd_region` VALUES (779, 775, '孙吴', '孙吴县', '中国,黑龙江省,黑河市,孙吴县', 3, 'sunwu', '0456', '164200', 'S', '127.33599', '49.42539');
INSERT INTO `dd_region` VALUES (780, 775, '北安', '北安市', '中国,黑龙江省,黑河市,北安市', 3, 'bei\'an', '0456', '164000', 'B', '126.48193', '48.23872');
INSERT INTO `dd_region` VALUES (781, 775, '五大连池', '五大连池市', '中国,黑龙江省,黑河市,五大连池市', 3, 'wudalianchi', '0456', '164100', 'W', '126.20294', '48.51507');
INSERT INTO `dd_region` VALUES (782, 655, '绥化', '绥化市', '中国,黑龙江省,绥化市', 2, 'suihua', '0455', '152000', 'S', '126.99293', '46.637393');
INSERT INTO `dd_region` VALUES (783, 782, '北林', '北林区', '中国,黑龙江省,绥化市,北林区', 3, 'beilin', '0455', '152000', 'B', '126.98564', '46.63735');
INSERT INTO `dd_region` VALUES (784, 782, '望奎', '望奎县', '中国,黑龙江省,绥化市,望奎县', 3, 'wangkui', '0455', '152100', 'W', '126.48187', '46.83079');
INSERT INTO `dd_region` VALUES (785, 782, '兰西', '兰西县', '中国,黑龙江省,绥化市,兰西县', 3, 'lanxi', '0455', '151500', 'L', '126.28994', '46.2525');
INSERT INTO `dd_region` VALUES (786, 782, '青冈', '青冈县', '中国,黑龙江省,绥化市,青冈县', 3, 'qinggang', '0455', '151600', 'Q', '126.11325', '46.68534');
INSERT INTO `dd_region` VALUES (787, 782, '庆安', '庆安县', '中国,黑龙江省,绥化市,庆安县', 3, 'qing\'an', '0455', '152400', 'Q', '127.50753', '46.88016');
INSERT INTO `dd_region` VALUES (788, 782, '明水', '明水县', '中国,黑龙江省,绥化市,明水县', 3, 'mingshui', '0455', '151700', 'M', '125.90594', '47.17327');
INSERT INTO `dd_region` VALUES (789, 782, '绥棱', '绥棱县', '中国,黑龙江省,绥化市,绥棱县', 3, 'suileng', '0455', '152200', 'S', '127.11584', '47.24267');
INSERT INTO `dd_region` VALUES (790, 782, '安达', '安达市', '中国,黑龙江省,绥化市,安达市', 3, 'anda', '0455', '151400', 'A', '125.34375', '46.4177');
INSERT INTO `dd_region` VALUES (791, 782, '肇东', '肇东市', '中国,黑龙江省,绥化市,肇东市', 3, 'zhaodong', '0455', '151100', 'Z', '125.96243', '46.05131');
INSERT INTO `dd_region` VALUES (792, 782, '海伦', '海伦市', '中国,黑龙江省,绥化市,海伦市', 3, 'hailun', '0455', '152300', 'H', '126.9682', '47.46093');
INSERT INTO `dd_region` VALUES (793, 655, '大兴安岭', '大兴安岭地区', '中国,黑龙江省,大兴安岭地区', 2, 'daxinganling', '0457', '165000', 'D', '124.711526', '52.335262');
INSERT INTO `dd_region` VALUES (794, 793, '加格达奇', '加格达奇区', '中国,黑龙江省,大兴安岭地区,加格达奇区', 3, 'jiagedaqi', '0457', '165000', 'J', '124.30954', '51.98144');
INSERT INTO `dd_region` VALUES (795, 793, '新林', '新林区', '中国,黑龙江省,大兴安岭地区,新林区', 3, 'xinlin', '0457', '165000', 'X', '124.397983', '51.67341');
INSERT INTO `dd_region` VALUES (796, 793, '松岭', '松岭区', '中国,黑龙江省,大兴安岭地区,松岭区', 3, 'songling', '0457', '165000', 'S', '124.189713', '51.985453');
INSERT INTO `dd_region` VALUES (797, 793, '呼中', '呼中区', '中国,黑龙江省,大兴安岭地区,呼中区', 3, 'huzhong', '0457', '165000', 'H', '123.60009', '52.03346');
INSERT INTO `dd_region` VALUES (798, 793, '呼玛', '呼玛县', '中国,黑龙江省,大兴安岭地区,呼玛县', 3, 'huma', '0457', '165100', 'H', '126.66174', '51.73112');
INSERT INTO `dd_region` VALUES (799, 793, '塔河', '塔河县', '中国,黑龙江省,大兴安岭地区,塔河县', 3, 'tahe', '0457', '165200', 'T', '124.70999', '52.33431');
INSERT INTO `dd_region` VALUES (800, 793, '漠河', '漠河县', '中国,黑龙江省,大兴安岭地区,漠河县', 3, 'mohe', '0457', '165300', 'M', '122.53759', '52.97003');
INSERT INTO `dd_region` VALUES (801, 0, '上海', '上海市', '中国,上海', 1, 'shanghai', '', '', 'S', '121.472644', '31.231706');
INSERT INTO `dd_region` VALUES (802, 801, '上海', '上海市', '中国,上海,上海市', 2, 'shanghai', '021', '200000', 'S', '121.472644', '31.231706');
INSERT INTO `dd_region` VALUES (803, 802, '黄浦', '黄浦区', '中国,上海,上海市,黄浦区', 3, 'huangpu', '021', '200001', 'H', '121.49295', '31.22337');
INSERT INTO `dd_region` VALUES (804, 802, '徐汇', '徐汇区', '中国,上海,上海市,徐汇区', 3, 'xuhui', '021', '200030', 'X', '121.43676', '31.18831');
INSERT INTO `dd_region` VALUES (805, 802, '长宁', '长宁区', '中国,上海,上海市,长宁区', 3, 'changning', '021', '200050', 'C', '121.42462', '31.22036');
INSERT INTO `dd_region` VALUES (806, 802, '静安', '静安区', '中国,上海,上海市,静安区', 3, 'jing\'an', '021', '200040', 'J', '121.4444', '31.22884');
INSERT INTO `dd_region` VALUES (807, 802, '普陀', '普陀区', '中国,上海,上海市,普陀区', 3, 'putuo', '021', '200333', 'P', '121.39703', '31.24951');
INSERT INTO `dd_region` VALUES (808, 802, '闸北', '闸北区', '中国,上海,上海市,闸北区', 3, 'zhabei', '021', '200070', 'Z', '121.44636', '31.28075');
INSERT INTO `dd_region` VALUES (809, 802, '虹口', '虹口区', '中国,上海,上海市,虹口区', 3, 'hongkou', '021', '200086', 'H', '121.48162', '31.27788');
INSERT INTO `dd_region` VALUES (810, 802, '杨浦', '杨浦区', '中国,上海,上海市,杨浦区', 3, 'yangpu', '021', '200082', 'Y', '121.526', '31.2595');
INSERT INTO `dd_region` VALUES (811, 802, '闵行', '闵行区', '中国,上海,上海市,闵行区', 3, 'minhang', '021', '201100', NULL, '121.38162', '31.11246');
INSERT INTO `dd_region` VALUES (812, 802, '宝山', '宝山区', '中国,上海,上海市,宝山区', 3, 'baoshan', '021', '201900', 'B', '121.4891', '31.4045');
INSERT INTO `dd_region` VALUES (813, 802, '嘉定', '嘉定区', '中国,上海,上海市,嘉定区', 3, 'jiading', '021', '201800', 'J', '121.2655', '31.37473');
INSERT INTO `dd_region` VALUES (814, 802, '浦东', '浦东新区', '中国,上海,上海市,浦东新区', 3, 'pudong', '021', '200135', 'P', '121.5447', '31.22249');
INSERT INTO `dd_region` VALUES (815, 802, '金山', '金山区', '中国,上海,上海市,金山区', 3, 'jinshan', '021', '200540', 'J', '121.34164', '30.74163');
INSERT INTO `dd_region` VALUES (816, 802, '松江', '松江区', '中国,上海,上海市,松江区', 3, 'songjiang', '021', '201600', 'S', '121.22879', '31.03222');
INSERT INTO `dd_region` VALUES (817, 802, '青浦', '青浦区', '中国,上海,上海市,青浦区', 3, 'qingpu', '021', '201700', 'Q', '121.12417', '31.14974');
INSERT INTO `dd_region` VALUES (818, 802, '奉贤', '奉贤区', '中国,上海,上海市,奉贤区', 3, 'fengxian', '021', '201400', 'F', '121.47412', '30.9179');
INSERT INTO `dd_region` VALUES (819, 802, '崇明', '崇明县', '中国,上海,上海市,崇明县', 3, 'chongming', '021', '202150', 'C', '121.39758', '31.62278');
INSERT INTO `dd_region` VALUES (820, 0, '江苏', '江苏省', '中国,江苏省', 1, 'jiangsu', '', '', 'J', '118.767413', '32.041544');
INSERT INTO `dd_region` VALUES (821, 820, '南京', '南京市', '中国,江苏省,南京市', 2, 'nanjing', '025', '210008', 'N', '118.767413', '32.041544');
INSERT INTO `dd_region` VALUES (822, 821, '玄武', '玄武区', '中国,江苏省,南京市,玄武区', 3, 'xuanwu', '025', '210018', 'X', '118.79772', '32.04856');
INSERT INTO `dd_region` VALUES (823, 821, '秦淮', '秦淮区', '中国,江苏省,南京市,秦淮区', 3, 'qinhuai', '025', '210001', 'Q', '118.79815', '32.01112');
INSERT INTO `dd_region` VALUES (824, 821, '建邺', '建邺区', '中国,江苏省,南京市,建邺区', 3, 'jianye', '025', '210004', 'J', '118.76641', '32.03096');
INSERT INTO `dd_region` VALUES (825, 821, '鼓楼', '鼓楼区', '中国,江苏省,南京市,鼓楼区', 3, 'gulou', '025', '210009', 'G', '118.76974', '32.06632');
INSERT INTO `dd_region` VALUES (826, 821, '浦口', '浦口区', '中国,江苏省,南京市,浦口区', 3, 'pukou', '025', '211800', 'P', '118.62802', '32.05881');
INSERT INTO `dd_region` VALUES (827, 821, '栖霞', '栖霞区', '中国,江苏省,南京市,栖霞区', 3, 'qixia', '025', '210046', 'Q', '118.88064', '32.11352');
INSERT INTO `dd_region` VALUES (828, 821, '雨花台', '雨花台区', '中国,江苏省,南京市,雨花台区', 3, 'yuhuatai', '025', '210012', 'Y', '118.7799', '31.99202');
INSERT INTO `dd_region` VALUES (829, 821, '江宁', '江宁区', '中国,江苏省,南京市,江宁区', 3, 'jiangning', '025', '211100', 'J', '118.8399', '31.95263');
INSERT INTO `dd_region` VALUES (830, 821, '六合', '六合区', '中国,江苏省,南京市,六合区', 3, 'luhe', '025', '211500', 'L', '118.8413', '32.34222');
INSERT INTO `dd_region` VALUES (831, 821, '溧水', '溧水区', '中国,江苏省,南京市,溧水区', 3, 'lishui', '025', '211200', NULL, '119.028732', '31.653061');
INSERT INTO `dd_region` VALUES (832, 821, '高淳', '高淳区', '中国,江苏省,南京市,高淳区', 3, 'gaochun', '025', '211300', 'G', '118.87589', '31.327132');
INSERT INTO `dd_region` VALUES (833, 820, '无锡', '无锡市', '中国,江苏省,无锡市', 2, 'wuxi', '0510', '214000', 'W', '120.301663', '31.574729');
INSERT INTO `dd_region` VALUES (834, 833, '崇安', '崇安区', '中国,江苏省,无锡市,崇安区', 3, 'chong\'an', '0510', '214001', 'C', '120.29975', '31.58002');
INSERT INTO `dd_region` VALUES (835, 833, '南长', '南长区', '中国,江苏省,无锡市,南长区', 3, 'nanchang', '0510', '214021', 'N', '120.30873', '31.56359');
INSERT INTO `dd_region` VALUES (836, 833, '北塘', '北塘区', '中国,江苏省,无锡市,北塘区', 3, 'beitang', '0510', '214044', 'B', '120.29405', '31.60592');
INSERT INTO `dd_region` VALUES (837, 833, '锡山', '锡山区', '中国,江苏省,无锡市,锡山区', 3, 'xishan', '0510', '214101', 'X', '120.35699', '31.5886');
INSERT INTO `dd_region` VALUES (838, 833, '惠山', '惠山区', '中国,江苏省,无锡市,惠山区', 3, 'huishan', '0510', '214174', 'H', '120.29849', '31.68088');
INSERT INTO `dd_region` VALUES (839, 833, '滨湖', '滨湖区', '中国,江苏省,无锡市,滨湖区', 3, 'binhu', '0510', '214123', 'B', '120.29461', '31.52162');
INSERT INTO `dd_region` VALUES (840, 833, '江阴', '江阴市', '中国,江苏省,无锡市,江阴市', 3, 'jiangyin', '0510', '214431', 'J', '120.2853', '31.91996');
INSERT INTO `dd_region` VALUES (841, 833, '宜兴', '宜兴市', '中国,江苏省,无锡市,宜兴市', 3, 'yixing', '0510', '214200', 'Y', '119.82357', '31.33978');
INSERT INTO `dd_region` VALUES (842, 820, '徐州', '徐州市', '中国,江苏省,徐州市', 2, 'xuzhou', '0516', '221003', 'X', '117.184811', '34.261792');
INSERT INTO `dd_region` VALUES (843, 842, '鼓楼', '鼓楼区', '中国,江苏省,徐州市,鼓楼区', 3, 'gulou', '0516', '221005', 'G', '117.18559', '34.28851');
INSERT INTO `dd_region` VALUES (844, 842, '云龙', '云龙区', '中国,江苏省,徐州市,云龙区', 3, 'yunlong', '0516', '221007', 'Y', '117.23053', '34.24895');
INSERT INTO `dd_region` VALUES (845, 842, '贾汪', '贾汪区', '中国,江苏省,徐州市,贾汪区', 3, 'jiawang', '0516', '221003', 'J', '117.45346', '34.44264');
INSERT INTO `dd_region` VALUES (846, 842, '泉山', '泉山区', '中国,江苏省,徐州市,泉山区', 3, 'quanshan', '0516', '221006', 'Q', '117.19378', '34.24418');
INSERT INTO `dd_region` VALUES (847, 842, '铜山', '铜山区', '中国,江苏省,徐州市,铜山区', 3, 'tongshan', '0516', '221106', 'T', '117.183894', '34.19288');
INSERT INTO `dd_region` VALUES (848, 842, '丰县', '丰县', '中国,江苏省,徐州市,丰县', 3, 'fengxian', '0516', '221700', 'F', '116.59957', '34.69972');
INSERT INTO `dd_region` VALUES (849, 842, '沛县', '沛县', '中国,江苏省,徐州市,沛县', 3, 'peixian', '0516', '221600', 'P', '116.93743', '34.72163');
INSERT INTO `dd_region` VALUES (850, 842, '睢宁', '睢宁县', '中国,江苏省,徐州市,睢宁县', 3, 'suining', '0516', '221200', NULL, '117.94104', '33.91269');
INSERT INTO `dd_region` VALUES (851, 842, '新沂', '新沂市', '中国,江苏省,徐州市,新沂市', 3, 'xinyi', '0516', '221400', 'X', '118.35452', '34.36942');
INSERT INTO `dd_region` VALUES (852, 842, '邳州', '邳州市', '中国,江苏省,徐州市,邳州市', 3, 'pizhou', '0516', '221300', NULL, '117.95858', '34.33329');
INSERT INTO `dd_region` VALUES (853, 820, '常州', '常州市', '中国,江苏省,常州市', 2, 'changzhou', '0519', '213000', 'C', '119.946973', '31.772752');
INSERT INTO `dd_region` VALUES (854, 853, '天宁', '天宁区', '中国,江苏省,常州市,天宁区', 3, 'tianning', '0519', '213000', 'T', '119.95132', '31.75211');
INSERT INTO `dd_region` VALUES (855, 853, '钟楼', '钟楼区', '中国,江苏省,常州市,钟楼区', 3, 'zhonglou', '0519', '213023', 'Z', '119.90178', '31.80221');
INSERT INTO `dd_region` VALUES (856, 853, '戚墅堰', '戚墅堰区', '中国,江苏省,常州市,戚墅堰区', 3, 'qishuyan', '0519', '213025', 'Q', '120.06106', '31.71956');
INSERT INTO `dd_region` VALUES (857, 853, '新北', '新北区', '中国,江苏省,常州市,新北区', 3, 'xinbei', '0519', '213022', 'X', '119.97131', '31.83046');
INSERT INTO `dd_region` VALUES (858, 853, '武进', '武进区', '中国,江苏省,常州市,武进区', 3, 'wujin', '0519', '213100', 'W', '119.94244', '31.70086');
INSERT INTO `dd_region` VALUES (859, 853, '溧阳', '溧阳市', '中国,江苏省,常州市,溧阳市', 3, 'liyang', '0519', '213300', NULL, '119.4837', '31.41538');
INSERT INTO `dd_region` VALUES (860, 853, '金坛', '金坛市', '中国,江苏省,常州市,金坛市', 3, 'jintan', '0519', '213200', 'J', '119.57757', '31.74043');
INSERT INTO `dd_region` VALUES (861, 820, '苏州', '苏州市', '中国,江苏省,苏州市', 2, 'suzhou', '0512', '215002', 'S', '120.619585', '31.299379');
INSERT INTO `dd_region` VALUES (862, 861, '虎丘', '虎丘区', '中国,江苏省,苏州市,虎丘区', 3, 'huqiu', '0512', '215004', 'H', '120.57345', '31.2953');
INSERT INTO `dd_region` VALUES (863, 861, '吴中', '吴中区', '中国,江苏省,苏州市,吴中区', 3, 'wuzhong', '0512', '215128', 'W', '120.63211', '31.26226');
INSERT INTO `dd_region` VALUES (864, 861, '相城', '相城区', '中国,江苏省,苏州市,相城区', 3, 'xiangcheng', '0512', '215131', 'X', '120.64239', '31.36889');
INSERT INTO `dd_region` VALUES (865, 861, '姑苏', '姑苏区', '中国,江苏省,苏州市,姑苏区', 3, 'gusu', '0512', '215031', 'G', '120.619585', '31.299379');
INSERT INTO `dd_region` VALUES (866, 861, '吴江', '吴江区', '中国,江苏省,苏州市,吴江区', 3, 'wujiang', '0512', '215200', 'W', '120.638317', '31.159815');
INSERT INTO `dd_region` VALUES (867, 861, '常熟', '常熟市', '中国,江苏省,苏州市,常熟市', 3, 'changshu', '0512', '215500', 'C', '120.75225', '31.65374');
INSERT INTO `dd_region` VALUES (868, 861, '张家港', '张家港市', '中国,江苏省,苏州市,张家港市', 3, 'zhangjiagang', '0512', '215600', 'Z', '120.55538', '31.87532');
INSERT INTO `dd_region` VALUES (869, 861, '昆山', '昆山市', '中国,江苏省,苏州市,昆山市', 3, 'kunshan', '0512', '215300', 'K', '120.98074', '31.38464');
INSERT INTO `dd_region` VALUES (870, 861, '太仓', '太仓市', '中国,江苏省,苏州市,太仓市', 3, 'taicang', '0512', '215400', 'T', '121.10891', '31.4497');
INSERT INTO `dd_region` VALUES (871, 820, '南通', '南通市', '中国,江苏省,南通市', 2, 'nantong', '0513', '226001', 'N', '120.864608', '32.016212');
INSERT INTO `dd_region` VALUES (872, 871, '崇川', '崇川区', '中国,江苏省,南通市,崇川区', 3, 'chongchuan', '0513', '226001', 'C', '120.8573', '32.0098');
INSERT INTO `dd_region` VALUES (873, 871, '港闸', '港闸区', '中国,江苏省,南通市,港闸区', 3, 'gangzha', '0513', '226001', 'G', '120.81778', '32.03163');
INSERT INTO `dd_region` VALUES (874, 871, '通州', '通州区', '中国,江苏省,南通市,通州区', 3, 'tongzhou', '0513', '226300', 'T', '121.07293', '32.0676');
INSERT INTO `dd_region` VALUES (875, 871, '海安', '海安县', '中国,江苏省,南通市,海安县', 3, 'hai\'an', '0513', '226600', 'H', '120.45852', '32.54514');
INSERT INTO `dd_region` VALUES (876, 871, '如东', '如东县', '中国,江苏省,南通市,如东县', 3, 'rudong', '0513', '226400', 'R', '121.18942', '32.31439');
INSERT INTO `dd_region` VALUES (877, 871, '启东', '启东市', '中国,江苏省,南通市,启东市', 3, 'qidong', '0513', '226200', 'Q', '121.65985', '31.81083');
INSERT INTO `dd_region` VALUES (878, 871, '如皋', '如皋市', '中国,江苏省,南通市,如皋市', 3, 'rugao', '0513', '226500', 'R', '120.55969', '32.37597');
INSERT INTO `dd_region` VALUES (879, 871, '海门', '海门市', '中国,江苏省,南通市,海门市', 3, 'haimen', '0513', '226100', 'H', '121.16995', '31.89422');
INSERT INTO `dd_region` VALUES (880, 820, '连云港', '连云港市', '中国,江苏省,连云港市', 2, 'lianyungang', '0518', '222002', 'L', '119.178821', '34.600018');
INSERT INTO `dd_region` VALUES (881, 880, '连云', '连云区', '中国,江苏省,连云港市,连云区', 3, 'lianyun', '0518', '222042', 'L', '119.37304', '34.75293');
INSERT INTO `dd_region` VALUES (882, 880, '海州', '海州区', '中国,江苏省,连云港市,海州区', 3, 'haizhou', '0518', '222003', 'H', '119.13128', '34.56986');
INSERT INTO `dd_region` VALUES (883, 880, '赣榆', '赣榆区', '中国,江苏省,连云港市,赣榆区', 3, 'ganyu', '0518', '222100', 'G', '119.128774', '34.839154');
INSERT INTO `dd_region` VALUES (884, 880, '东海', '东海县', '中国,江苏省,连云港市,东海县', 3, 'donghai', '0518', '222300', 'D', '118.77145', '34.54215');
INSERT INTO `dd_region` VALUES (885, 880, '灌云', '灌云县', '中国,江苏省,连云港市,灌云县', 3, 'guanyun', '0518', '222200', 'G', '119.23925', '34.28391');
INSERT INTO `dd_region` VALUES (886, 880, '灌南', '灌南县', '中国,江苏省,连云港市,灌南县', 3, 'guannan', '0518', '222500', 'G', '119.35632', '34.09');
INSERT INTO `dd_region` VALUES (887, 820, '淮安', '淮安市', '中国,江苏省,淮安市', 2, 'huai\'an', '0517', '223001', 'H', '119.021265', '33.597506');
INSERT INTO `dd_region` VALUES (888, 887, '清河', '清河区', '中国,江苏省,淮安市,清河区', 3, 'qinghe', '0517', '223001', 'Q', '119.00778', '33.59949');
INSERT INTO `dd_region` VALUES (889, 887, '淮安', '淮安区', '中国,江苏省,淮安市,淮安区', 3, 'huai\'an', '0517', '223200', 'H', '119.021265', '33.597506');
INSERT INTO `dd_region` VALUES (890, 887, '淮阴', '淮阴区', '中国,江苏省,淮安市,淮阴区', 3, 'huaiyin', '0517', '223300', 'H', '119.03485', '33.63171');
INSERT INTO `dd_region` VALUES (891, 887, '清浦', '清浦区', '中国,江苏省,淮安市,清浦区', 3, 'qingpu', '0517', '223002', 'Q', '119.02648', '33.55232');
INSERT INTO `dd_region` VALUES (892, 887, '涟水', '涟水县', '中国,江苏省,淮安市,涟水县', 3, 'lianshui', '0517', '223400', 'L', '119.26083', '33.78094');
INSERT INTO `dd_region` VALUES (893, 887, '洪泽', '洪泽县', '中国,江苏省,淮安市,洪泽县', 3, 'hongze', '0517', '223100', 'H', '118.87344', '33.29429');
INSERT INTO `dd_region` VALUES (894, 887, '盱眙', '盱眙县', '中国,江苏省,淮安市,盱眙县', 3, 'xuyi', '0517', '211700', NULL, '118.54495', '33.01086');
INSERT INTO `dd_region` VALUES (895, 887, '金湖', '金湖县', '中国,江苏省,淮安市,金湖县', 3, 'jinhu', '0517', '211600', 'J', '119.02307', '33.02219');
INSERT INTO `dd_region` VALUES (896, 820, '盐城', '盐城市', '中国,江苏省,盐城市', 2, 'yancheng', '0515', '224005', 'Y', '120.139998', '33.377631');
INSERT INTO `dd_region` VALUES (897, 896, '亭湖', '亭湖区', '中国,江苏省,盐城市,亭湖区', 3, 'tinghu', '0515', '224005', 'T', '120.16583', '33.37825');
INSERT INTO `dd_region` VALUES (898, 896, '盐都', '盐都区', '中国,江苏省,盐城市,盐都区', 3, 'yandu', '0515', '224055', 'Y', '120.15441', '33.3373');
INSERT INTO `dd_region` VALUES (899, 896, '响水', '响水县', '中国,江苏省,盐城市,响水县', 3, 'xiangshui', '0515', '224600', 'X', '119.56985', '34.20513');
INSERT INTO `dd_region` VALUES (900, 896, '滨海', '滨海县', '中国,江苏省,盐城市,滨海县', 3, 'binhai', '0515', '224500', 'B', '119.82058', '33.98972');
INSERT INTO `dd_region` VALUES (901, 896, '阜宁', '阜宁县', '中国,江苏省,盐城市,阜宁县', 3, 'funing', '0515', '224400', 'F', '119.80175', '33.78228');
INSERT INTO `dd_region` VALUES (902, 896, '射阳', '射阳县', '中国,江苏省,盐城市,射阳县', 3, 'sheyang', '0515', '224300', 'S', '120.26043', '33.77636');
INSERT INTO `dd_region` VALUES (903, 896, '建湖', '建湖县', '中国,江苏省,盐城市,建湖县', 3, 'jianhu', '0515', '224700', 'J', '119.79852', '33.47241');
INSERT INTO `dd_region` VALUES (904, 896, '东台', '东台市', '中国,江苏省,盐城市,东台市', 3, 'dongtai', '0515', '224200', 'D', '120.32376', '32.85078');
INSERT INTO `dd_region` VALUES (905, 896, '大丰', '大丰市', '中国,江苏省,盐城市,大丰市', 3, 'dafeng', '0515', '224100', 'D', '120.46594', '33.19893');
INSERT INTO `dd_region` VALUES (906, 820, '扬州', '扬州市', '中国,江苏省,扬州市', 2, 'yangzhou', '0514', '225002', 'Y', '119.421003', '32.393159');
INSERT INTO `dd_region` VALUES (907, 906, '广陵', '广陵区', '中国,江苏省,扬州市,广陵区', 3, 'guangling', '0514', '225002', 'G', '119.43186', '32.39472');
INSERT INTO `dd_region` VALUES (908, 906, '邗江', '邗江区', '中国,江苏省,扬州市,邗江区', 3, 'hanjiang', '0514', '225002', NULL, '119.39816', '32.3765');
INSERT INTO `dd_region` VALUES (909, 906, '江都', '江都区', '中国,江苏省,扬州市,江都区', 3, 'jiangdu', '0514', '225200', 'J', '119.567481', '32.426564');
INSERT INTO `dd_region` VALUES (910, 906, '宝应', '宝应县', '中国,江苏省,扬州市,宝应县', 3, 'baoying', '0514', '225800', 'B', '119.31213', '33.23549');
INSERT INTO `dd_region` VALUES (911, 906, '仪征', '仪征市', '中国,江苏省,扬州市,仪征市', 3, 'yizheng', '0514', '211400', 'Y', '119.18432', '32.27197');
INSERT INTO `dd_region` VALUES (912, 906, '高邮', '高邮市', '中国,江苏省,扬州市,高邮市', 3, 'gaoyou', '0514', '225600', 'G', '119.45965', '32.78135');
INSERT INTO `dd_region` VALUES (913, 820, '镇江', '镇江市', '中国,江苏省,镇江市', 2, 'zhenjiang', '0511', '212004', 'Z', '119.452753', '32.204402');
INSERT INTO `dd_region` VALUES (914, 913, '京口', '京口区', '中国,江苏省,镇江市,京口区', 3, 'jingkou', '0511', '212003', 'J', '119.46947', '32.19809');
INSERT INTO `dd_region` VALUES (915, 913, '润州', '润州区', '中国,江苏省,镇江市,润州区', 3, 'runzhou', '0511', '212005', 'R', '119.41134', '32.19523');
INSERT INTO `dd_region` VALUES (916, 913, '丹徒', '丹徒区', '中国,江苏省,镇江市,丹徒区', 3, 'dantu', '0511', '212028', 'D', '119.43383', '32.13183');
INSERT INTO `dd_region` VALUES (917, 913, '丹阳', '丹阳市', '中国,江苏省,镇江市,丹阳市', 3, 'danyang', '0511', '212300', 'D', '119.57525', '31.99121');
INSERT INTO `dd_region` VALUES (918, 913, '扬中', '扬中市', '中国,江苏省,镇江市,扬中市', 3, 'yangzhong', '0511', '212200', 'Y', '119.79718', '32.2363');
INSERT INTO `dd_region` VALUES (919, 913, '句容', '句容市', '中国,江苏省,镇江市,句容市', 3, 'jurong', '0511', '212400', 'J', '119.16482', '31.95591');
INSERT INTO `dd_region` VALUES (920, 820, '泰州', '泰州市', '中国,江苏省,泰州市', 2, 'taizhou', '0523', '225300', 'T', '119.915176', '32.484882');
INSERT INTO `dd_region` VALUES (921, 920, '海陵', '海陵区', '中国,江苏省,泰州市,海陵区', 3, 'hailing', '0523', '225300', 'H', '119.91942', '32.49101');
INSERT INTO `dd_region` VALUES (922, 920, '高港', '高港区', '中国,江苏省,泰州市,高港区', 3, 'gaogang', '0523', '225321', 'G', '119.88089', '32.31833');
INSERT INTO `dd_region` VALUES (923, 920, '姜堰', '姜堰区', '中国,江苏省,泰州市,姜堰区', 3, 'jiangyan', '0523', '225500', 'J', '120.148208', '32.508483');
INSERT INTO `dd_region` VALUES (924, 920, '兴化', '兴化市', '中国,江苏省,泰州市,兴化市', 3, 'xinghua', '0523', '225700', 'X', '119.85238', '32.90944');
INSERT INTO `dd_region` VALUES (925, 920, '靖江', '靖江市', '中国,江苏省,泰州市,靖江市', 3, 'jingjiang', '0523', '214500', 'J', '120.27291', '32.01595');
INSERT INTO `dd_region` VALUES (926, 920, '泰兴', '泰兴市', '中国,江苏省,泰州市,泰兴市', 3, 'taixing', '0523', '225400', 'T', '120.05194', '32.17187');
INSERT INTO `dd_region` VALUES (927, 820, '宿迁', '宿迁市', '中国,江苏省,宿迁市', 2, 'suqian', '0527', '223800', 'S', '118.293328', '33.945154');
INSERT INTO `dd_region` VALUES (928, 927, '宿城', '宿城区', '中国,江苏省,宿迁市,宿城区', 3, 'sucheng', '0527', '223800', 'S', '118.29141', '33.94219');
INSERT INTO `dd_region` VALUES (929, 927, '宿豫', '宿豫区', '中国,江苏省,宿迁市,宿豫区', 3, 'suyu', '0527', '223800', 'S', '118.32922', '33.94673');
INSERT INTO `dd_region` VALUES (930, 927, '沭阳', '沭阳县', '中国,江苏省,宿迁市,沭阳县', 3, 'shuyang', '0527', '223600', NULL, '118.76873', '34.11446');
INSERT INTO `dd_region` VALUES (931, 927, '泗阳', '泗阳县', '中国,江苏省,宿迁市,泗阳县', 3, 'siyang', '0527', '223700', NULL, '118.7033', '33.72096');
INSERT INTO `dd_region` VALUES (932, 927, '泗洪', '泗洪县', '中国,江苏省,宿迁市,泗洪县', 3, 'sihong', '0527', '223900', NULL, '118.21716', '33.45996');
INSERT INTO `dd_region` VALUES (933, 0, '浙江', '浙江省', '中国,浙江省', 1, 'zhejiang', '', '', 'Z', '120.153576', '30.287459');
INSERT INTO `dd_region` VALUES (934, 933, '杭州', '杭州市', '中国,浙江省,杭州市', 2, 'hangzhou', '0571', '310026', 'H', '120.153576', '30.287459');
INSERT INTO `dd_region` VALUES (935, 934, '上城', '上城区', '中国,浙江省,杭州市,上城区', 3, 'shangcheng', '0571', '310002', 'S', '120.16922', '30.24255');
INSERT INTO `dd_region` VALUES (936, 934, '下城', '下城区', '中国,浙江省,杭州市,下城区', 3, 'xiacheng', '0571', '310006', 'X', '120.18096', '30.28153');
INSERT INTO `dd_region` VALUES (937, 934, '江干', '江干区', '中国,浙江省,杭州市,江干区', 3, 'jianggan', '0571', '310016', 'J', '120.20517', '30.2572');
INSERT INTO `dd_region` VALUES (938, 934, '拱墅', '拱墅区', '中国,浙江省,杭州市,拱墅区', 3, 'gongshu', '0571', '310011', 'G', '120.14209', '30.31968');
INSERT INTO `dd_region` VALUES (939, 934, '西湖', '西湖区', '中国,浙江省,杭州市,西湖区', 3, 'xihu', '0571', '310013', 'X', '120.12979', '30.25949');
INSERT INTO `dd_region` VALUES (940, 934, '滨江', '滨江区', '中国,浙江省,杭州市,滨江区', 3, 'binjiang', '0571', '310051', 'B', '120.21194', '30.20835');
INSERT INTO `dd_region` VALUES (941, 934, '萧山', '萧山区', '中国,浙江省,杭州市,萧山区', 3, 'xiaoshan', '0571', '311200', 'X', '120.26452', '30.18505');
INSERT INTO `dd_region` VALUES (942, 934, '余杭', '余杭区', '中国,浙江省,杭州市,余杭区', 3, 'yuhang', '0571', '311100', 'Y', '120.29986', '30.41829');
INSERT INTO `dd_region` VALUES (943, 934, '桐庐', '桐庐县', '中国,浙江省,杭州市,桐庐县', 3, 'tonglu', '0571', '311500', 'T', '119.68853', '29.79779');
INSERT INTO `dd_region` VALUES (944, 934, '淳安', '淳安县', '中国,浙江省,杭州市,淳安县', 3, 'chun\'an', '0571', '311700', 'C', '119.04257', '29.60988');
INSERT INTO `dd_region` VALUES (945, 934, '建德', '建德市', '中国,浙江省,杭州市,建德市', 3, 'jiande', '0571', '311600', 'J', '119.28158', '29.47603');
INSERT INTO `dd_region` VALUES (946, 934, '富阳', '富阳区', '中国,浙江省,杭州市,富阳区', 3, 'fuyang', '0571', '311400', 'F', '119.96041', '30.04878');
INSERT INTO `dd_region` VALUES (947, 934, '临安', '临安市', '中国,浙江省,杭州市,临安市', 3, 'lin\'an', '0571', '311300', 'L', '119.72473', '30.23447');
INSERT INTO `dd_region` VALUES (948, 933, '宁波', '宁波市', '中国,浙江省,宁波市', 2, 'ningbo', '0574', '315000', 'N', '121.549792', '29.868388');
INSERT INTO `dd_region` VALUES (949, 948, '海曙', '海曙区', '中国,浙江省,宁波市,海曙区', 3, 'haishu', '0574', '315000', 'H', '121.55106', '29.85977');
INSERT INTO `dd_region` VALUES (950, 948, '江东', '江东区', '中国,浙江省,宁波市,江东区', 3, 'jiangdong', '0574', '315040', 'J', '121.57028', '29.86701');
INSERT INTO `dd_region` VALUES (951, 948, '江北', '江北区', '中国,浙江省,宁波市,江北区', 3, 'jiangbei', '0574', '315020', 'J', '121.55681', '29.88776');
INSERT INTO `dd_region` VALUES (952, 948, '北仑', '北仑区', '中国,浙江省,宁波市,北仑区', 3, 'beilun', '0574', '315800', 'B', '121.84408', '29.90069');
INSERT INTO `dd_region` VALUES (953, 948, '镇海', '镇海区', '中国,浙江省,宁波市,镇海区', 3, 'zhenhai', '0574', '315200', 'Z', '121.71615', '29.94893');
INSERT INTO `dd_region` VALUES (954, 948, '鄞州', '鄞州区', '中国,浙江省,宁波市,鄞州区', 3, 'yinzhou', '0574', '315100', NULL, '121.54754', '29.81614');
INSERT INTO `dd_region` VALUES (955, 948, '象山', '象山县', '中国,浙江省,宁波市,象山县', 3, 'xiangshan', '0574', '315700', 'X', '121.86917', '29.47758');
INSERT INTO `dd_region` VALUES (956, 948, '宁海', '宁海县', '中国,浙江省,宁波市,宁海县', 3, 'ninghai', '0574', '315600', 'N', '121.43072', '29.2889');
INSERT INTO `dd_region` VALUES (957, 948, '余姚', '余姚市', '中国,浙江省,宁波市,余姚市', 3, 'yuyao', '0574', '315400', 'Y', '121.15341', '30.03867');
INSERT INTO `dd_region` VALUES (958, 948, '慈溪', '慈溪市', '中国,浙江省,宁波市,慈溪市', 3, 'cixi', '0574', '315300', 'C', '121.26641', '30.16959');
INSERT INTO `dd_region` VALUES (959, 948, '奉化', '奉化市', '中国,浙江省,宁波市,奉化市', 3, 'fenghua', '0574', '315500', 'F', '121.41003', '29.65537');
INSERT INTO `dd_region` VALUES (960, 933, '温州', '温州市', '中国,浙江省,温州市', 2, 'wenzhou', '0577', '325000', 'W', '120.672111', '28.000575');
INSERT INTO `dd_region` VALUES (961, 960, '鹿城', '鹿城区', '中国,浙江省,温州市,鹿城区', 3, 'lucheng', '0577', '325000', 'L', '120.65505', '28.01489');
INSERT INTO `dd_region` VALUES (962, 960, '龙湾', '龙湾区', '中国,浙江省,温州市,龙湾区', 3, 'longwan', '0577', '325013', 'L', '120.83053', '27.91284');
INSERT INTO `dd_region` VALUES (963, 960, '瓯海', '瓯海区', '中国,浙江省,温州市,瓯海区', 3, 'ouhai', '0577', '325005', NULL, '120.63751', '28.00714');
INSERT INTO `dd_region` VALUES (964, 960, '洞头', '洞头县', '中国,浙江省,温州市,洞头县', 3, 'dongtou', '0577', '325700', 'D', '121.15606', '27.83634');
INSERT INTO `dd_region` VALUES (965, 960, '永嘉', '永嘉县', '中国,浙江省,温州市,永嘉县', 3, 'yongjia', '0577', '325100', 'Y', '120.69317', '28.15456');
INSERT INTO `dd_region` VALUES (966, 960, '平阳', '平阳县', '中国,浙江省,温州市,平阳县', 3, 'pingyang', '0577', '325400', 'P', '120.56506', '27.66245');
INSERT INTO `dd_region` VALUES (967, 960, '苍南', '苍南县', '中国,浙江省,温州市,苍南县', 3, 'cangnan', '0577', '325800', 'C', '120.42608', '27.51739');
INSERT INTO `dd_region` VALUES (968, 960, '文成', '文成县', '中国,浙江省,温州市,文成县', 3, 'wencheng', '0577', '325300', 'W', '120.09063', '27.78678');
INSERT INTO `dd_region` VALUES (969, 960, '泰顺', '泰顺县', '中国,浙江省,温州市,泰顺县', 3, 'taishun', '0577', '325500', 'T', '119.7182', '27.55694');
INSERT INTO `dd_region` VALUES (970, 960, '瑞安', '瑞安市', '中国,浙江省,温州市,瑞安市', 3, 'rui\'an', '0577', '325200', 'R', '120.65466', '27.78041');
INSERT INTO `dd_region` VALUES (971, 960, '乐清', '乐清市', '中国,浙江省,温州市,乐清市', 3, 'yueqing', '0577', '325600', 'L', '120.9617', '28.12404');
INSERT INTO `dd_region` VALUES (972, 933, '嘉兴', '嘉兴市', '中国,浙江省,嘉兴市', 2, 'jiaxing', '0573', '314000', 'J', '120.750865', '30.762653');
INSERT INTO `dd_region` VALUES (973, 972, '南湖', '南湖区', '中国,浙江省,嘉兴市,南湖区', 3, 'nanhu', '0573', '314051', 'N', '120.78524', '30.74865');
INSERT INTO `dd_region` VALUES (974, 972, '秀洲', '秀洲区', '中国,浙江省,嘉兴市,秀洲区', 3, 'xiuzhou', '0573', '314031', 'X', '120.70867', '30.76454');
INSERT INTO `dd_region` VALUES (975, 972, '嘉善', '嘉善县', '中国,浙江省,嘉兴市,嘉善县', 3, 'jiashan', '0573', '314100', 'J', '120.92559', '30.82993');
INSERT INTO `dd_region` VALUES (976, 972, '海盐', '海盐县', '中国,浙江省,嘉兴市,海盐县', 3, 'haiyan', '0573', '314300', 'H', '120.9457', '30.52547');
INSERT INTO `dd_region` VALUES (977, 972, '海宁', '海宁市', '中国,浙江省,嘉兴市,海宁市', 3, 'haining', '0573', '314400', 'H', '120.6813', '30.5097');
INSERT INTO `dd_region` VALUES (978, 972, '平湖', '平湖市', '中国,浙江省,嘉兴市,平湖市', 3, 'pinghu', '0573', '314200', 'P', '121.02166', '30.69618');
INSERT INTO `dd_region` VALUES (979, 972, '桐乡', '桐乡市', '中国,浙江省,嘉兴市,桐乡市', 3, 'tongxiang', '0573', '314500', 'T', '120.56485', '30.6302');
INSERT INTO `dd_region` VALUES (980, 933, '湖州', '湖州市', '中国,浙江省,湖州市', 2, 'huzhou', '0572', '313000', 'H', '120.102398', '30.867198');
INSERT INTO `dd_region` VALUES (981, 980, '吴兴', '吴兴区', '中国,浙江省,湖州市,吴兴区', 3, 'wuxing', '0572', '313000', 'W', '120.12548', '30.85752');
INSERT INTO `dd_region` VALUES (982, 980, '南浔', '南浔区', '中国,浙江省,湖州市,南浔区', 3, 'nanxun', '0572', '313009', 'N', '120.42038', '30.86686');
INSERT INTO `dd_region` VALUES (983, 980, '德清', '德清县', '中国,浙江省,湖州市,德清县', 3, 'deqing', '0572', '313200', 'D', '119.97836', '30.53369');
INSERT INTO `dd_region` VALUES (984, 980, '长兴', '长兴县', '中国,浙江省,湖州市,长兴县', 3, 'changxing', '0572', '313100', 'C', '119.90783', '31.00606');
INSERT INTO `dd_region` VALUES (985, 980, '安吉', '安吉县', '中国,浙江省,湖州市,安吉县', 3, 'anji', '0572', '313300', 'A', '119.68158', '30.63798');
INSERT INTO `dd_region` VALUES (986, 933, '绍兴', '绍兴市', '中国,浙江省,绍兴市', 2, 'shaoxing', '0575', '312000', 'S', '120.582112', '29.997117');
INSERT INTO `dd_region` VALUES (987, 986, '越城', '越城区', '中国,浙江省,绍兴市,越城区', 3, 'yuecheng', '0575', '312000', 'Y', '120.5819', '29.98895');
INSERT INTO `dd_region` VALUES (988, 986, '柯桥', '柯桥区', '中国,浙江省,绍兴市,柯桥区', 3, 'keqiao', '0575', '312030', 'K', '120.492736', '30.08763');
INSERT INTO `dd_region` VALUES (989, 986, '上虞', '上虞区', '中国,浙江省,绍兴市,上虞区', 3, 'shangyu', '0575', '312300', 'S', '120.476075', '30.078038');
INSERT INTO `dd_region` VALUES (990, 986, '新昌', '新昌县', '中国,浙江省,绍兴市,新昌县', 3, 'xinchang', '0575', '312500', 'X', '120.90435', '29.49991');
INSERT INTO `dd_region` VALUES (991, 986, '诸暨', '诸暨市', '中国,浙江省,绍兴市,诸暨市', 3, 'zhuji', '0575', '311800', 'Z', '120.23629', '29.71358');
INSERT INTO `dd_region` VALUES (992, 986, '嵊州', '嵊州市', '中国,浙江省,绍兴市,嵊州市', 3, 'shengzhou', '0575', '312400', NULL, '120.82174', '29.58854');
INSERT INTO `dd_region` VALUES (993, 933, '金华', '金华市', '中国,浙江省,金华市', 2, 'jinhua', '0579', '321000', 'J', '119.649506', '29.089524');
INSERT INTO `dd_region` VALUES (994, 993, '婺城', '婺城区', '中国,浙江省,金华市,婺城区', 3, 'wucheng', '0579', '321000', NULL, '119.57135', '29.09521');
INSERT INTO `dd_region` VALUES (995, 993, '金东', '金东区', '中国,浙江省,金华市,金东区', 3, 'jindong', '0579', '321000', 'J', '119.69302', '29.0991');
INSERT INTO `dd_region` VALUES (996, 993, '武义', '武义县', '中国,浙江省,金华市,武义县', 3, 'wuyi', '0579', '321200', 'W', '119.8164', '28.89331');
INSERT INTO `dd_region` VALUES (997, 993, '浦江', '浦江县', '中国,浙江省,金华市,浦江县', 3, 'pujiang', '0579', '322200', 'P', '119.89181', '29.45353');
INSERT INTO `dd_region` VALUES (998, 993, '磐安', '磐安县', '中国,浙江省,金华市,磐安县', 3, 'pan\'an', '0579', '322300', 'P', '120.45022', '29.05733');
INSERT INTO `dd_region` VALUES (999, 993, '兰溪', '兰溪市', '中国,浙江省,金华市,兰溪市', 3, 'lanxi', '0579', '321100', 'L', '119.45965', '29.20841');
INSERT INTO `dd_region` VALUES (1000, 993, '义乌', '义乌市', '中国,浙江省,金华市,义乌市', 3, 'yiwu', '0579', '322000', 'Y', '120.0744', '29.30558');
INSERT INTO `dd_region` VALUES (1001, 993, '东阳', '东阳市', '中国,浙江省,金华市,东阳市', 3, 'dongyang', '0579', '322100', 'D', '120.24185', '29.28942');
INSERT INTO `dd_region` VALUES (1002, 993, '永康', '永康市', '中国,浙江省,金华市,永康市', 3, 'yongkang', '0579', '321300', 'Y', '120.04727', '28.88844');
INSERT INTO `dd_region` VALUES (1003, 933, '衢州', '衢州市', '中国,浙江省,衢州市', 2, 'quzhou', '0570', '324002', NULL, '118.87263', '28.941708');
INSERT INTO `dd_region` VALUES (1004, 1003, '柯城', '柯城区', '中国,浙江省,衢州市,柯城区', 3, 'kecheng', '0570', '324100', 'K', '118.87109', '28.96858');
INSERT INTO `dd_region` VALUES (1005, 1003, '衢江', '衢江区', '中国,浙江省,衢州市,衢江区', 3, 'qujiang', '0570', '324022', NULL, '118.9598', '28.97977');
INSERT INTO `dd_region` VALUES (1006, 1003, '常山', '常山县', '中国,浙江省,衢州市,常山县', 3, 'changshan', '0570', '324200', 'C', '118.51025', '28.90191');
INSERT INTO `dd_region` VALUES (1007, 1003, '开化', '开化县', '中国,浙江省,衢州市,开化县', 3, 'kaihua', '0570', '324300', 'K', '118.41616', '29.13785');
INSERT INTO `dd_region` VALUES (1008, 1003, '龙游', '龙游县', '中国,浙江省,衢州市,龙游县', 3, 'longyou', '0570', '324400', 'L', '119.17221', '29.02823');
INSERT INTO `dd_region` VALUES (1009, 1003, '江山', '江山市', '中国,浙江省,衢州市,江山市', 3, 'jiangshan', '0570', '324100', 'J', '118.62674', '28.7386');
INSERT INTO `dd_region` VALUES (1010, 933, '舟山', '舟山市', '中国,浙江省,舟山市', 2, 'zhoushan', '0580', '316000', 'Z', '122.106863', '30.016028');
INSERT INTO `dd_region` VALUES (1011, 1010, '定海', '定海区', '中国,浙江省,舟山市,定海区', 3, 'dinghai', '0580', '316000', 'D', '122.10677', '30.01985');
INSERT INTO `dd_region` VALUES (1012, 1010, '普陀', '普陀区', '中国,浙江省,舟山市,普陀区', 3, 'putuo', '0580', '316100', 'P', '122.30278', '29.94908');
INSERT INTO `dd_region` VALUES (1013, 1010, '岱山', '岱山县', '中国,浙江省,舟山市,岱山县', 3, 'daishan', '0580', '316200', NULL, '122.20486', '30.24385');
INSERT INTO `dd_region` VALUES (1014, 1010, '嵊泗', '嵊泗县', '中国,浙江省,舟山市,嵊泗县', 3, 'shengsi', '0580', '202450', NULL, '122.45129', '30.72678');
INSERT INTO `dd_region` VALUES (1015, 933, '台州', '台州市', '中国,浙江省,台州市', 2, 'taizhou', '0576', '318000', 'T', '121.428599', '28.661378');
INSERT INTO `dd_region` VALUES (1016, 1015, '椒江', '椒江区', '中国,浙江省,台州市,椒江区', 3, 'jiaojiang', '0576', '318000', 'J', '121.44287', '28.67301');
INSERT INTO `dd_region` VALUES (1017, 1015, '黄岩', '黄岩区', '中国,浙江省,台州市,黄岩区', 3, 'huangyan', '0576', '318020', 'H', '121.25891', '28.65077');
INSERT INTO `dd_region` VALUES (1018, 1015, '路桥', '路桥区', '中国,浙江省,台州市,路桥区', 3, 'luqiao', '0576', '318050', 'L', '121.37381', '28.58016');
INSERT INTO `dd_region` VALUES (1019, 1015, '玉环', '玉环县', '中国,浙江省,台州市,玉环县', 3, 'yuhuan', '0576', '317600', 'Y', '121.23242', '28.13637');
INSERT INTO `dd_region` VALUES (1020, 1015, '三门', '三门县', '中国,浙江省,台州市,三门县', 3, 'sanmen', '0576', '317100', 'S', '121.3937', '29.1051');
INSERT INTO `dd_region` VALUES (1021, 1015, '天台', '天台县', '中国,浙江省,台州市,天台县', 3, 'tiantai', '0576', '317200', 'T', '121.00848', '29.1429');
INSERT INTO `dd_region` VALUES (1022, 1015, '仙居', '仙居县', '中国,浙江省,台州市,仙居县', 3, 'xianju', '0576', '317300', 'X', '120.72872', '28.84672');
INSERT INTO `dd_region` VALUES (1023, 1015, '温岭', '温岭市', '中国,浙江省,台州市,温岭市', 3, 'wenling', '0576', '317500', 'W', '121.38595', '28.37176');
INSERT INTO `dd_region` VALUES (1024, 1015, '临海', '临海市', '中国,浙江省,台州市,临海市', 3, 'linhai', '0576', '317000', 'L', '121.13885', '28.85603');
INSERT INTO `dd_region` VALUES (1025, 933, '丽水', '丽水市', '中国,浙江省,丽水市', 2, 'lishui', '0578', '323000', 'L', '119.921786', '28.451993');
INSERT INTO `dd_region` VALUES (1026, 1025, '莲都', '莲都区', '中国,浙江省,丽水市,莲都区', 3, 'liandu', '0578', '323000', 'L', '119.9127', '28.44583');
INSERT INTO `dd_region` VALUES (1027, 1025, '青田', '青田县', '中国,浙江省,丽水市,青田县', 3, 'qingtian', '0578', '323900', 'Q', '120.29028', '28.13897');
INSERT INTO `dd_region` VALUES (1028, 1025, '缙云', '缙云县', '中国,浙江省,丽水市,缙云县', 3, 'jinyun', '0578', '321400', NULL, '120.09036', '28.65944');
INSERT INTO `dd_region` VALUES (1029, 1025, '遂昌', '遂昌县', '中国,浙江省,丽水市,遂昌县', 3, 'suichang', '0578', '323300', 'S', '119.27606', '28.59291');
INSERT INTO `dd_region` VALUES (1030, 1025, '松阳', '松阳县', '中国,浙江省,丽水市,松阳县', 3, 'songyang', '0578', '323400', 'S', '119.48199', '28.4494');
INSERT INTO `dd_region` VALUES (1031, 1025, '云和', '云和县', '中国,浙江省,丽水市,云和县', 3, 'yunhe', '0578', '323600', 'Y', '119.57287', '28.11643');
INSERT INTO `dd_region` VALUES (1032, 1025, '庆元', '庆元县', '中国,浙江省,丽水市,庆元县', 3, 'qingyuan', '0578', '323800', 'Q', '119.06256', '27.61842');
INSERT INTO `dd_region` VALUES (1033, 1025, '景宁', '景宁畲族自治县', '中国,浙江省,丽水市,景宁畲族自治县', 3, 'jingning', '0578', '323500', 'J', '119.63839', '27.97393');
INSERT INTO `dd_region` VALUES (1034, 1025, '龙泉', '龙泉市', '中国,浙江省,丽水市,龙泉市', 3, 'longquan', '0578', '323700', 'L', '119.14163', '28.0743');
INSERT INTO `dd_region` VALUES (1035, 933, '舟山新区', '舟山群岛新区', '中国,浙江省,舟山群岛新区', 2, 'zhoushan', '0580', '316000', 'Z', '122.317657', '29.813242');
INSERT INTO `dd_region` VALUES (1036, 1035, '金塘', '金塘岛', '中国,浙江省,舟山群岛新区,金塘岛', 3, 'jintang', '0580', '316000', 'J', '121.893373', '30.040641');
INSERT INTO `dd_region` VALUES (1037, 1035, '六横', '六横岛', '中国,浙江省,舟山群岛新区,六横岛', 3, 'liuheng', '0580', '316000', 'L', '122.14265', '29.662938');
INSERT INTO `dd_region` VALUES (1038, 1035, '衢山', '衢山岛', '中国,浙江省,舟山群岛新区,衢山岛', 3, 'qushan', '0580', '316000', NULL, '122.358425', '30.442642');
INSERT INTO `dd_region` VALUES (1039, 1035, '舟山', '舟山本岛西北部', '中国,浙江省,舟山群岛新区,舟山本岛西北部', 3, 'zhoushan', '0580', '316000', 'Z', '122.03064', '30.140377');
INSERT INTO `dd_region` VALUES (1040, 1035, '岱山', '岱山岛西南部', '中国,浙江省,舟山群岛新区,岱山岛西南部', 3, 'daishan', '0580', '316000', NULL, '122.180123', '30.277269');
INSERT INTO `dd_region` VALUES (1041, 1035, '泗礁', '泗礁岛', '中国,浙江省,舟山群岛新区,泗礁岛', 3, 'sijiao', '0580', '316000', NULL, '122.45803', '30.725112');
INSERT INTO `dd_region` VALUES (1042, 1035, '朱家尖', '朱家尖岛', '中国,浙江省,舟山群岛新区,朱家尖岛', 3, 'zhujiajian', '0580', '316000', 'Z', '122.390636', '29.916303');
INSERT INTO `dd_region` VALUES (1043, 1035, '洋山', '洋山岛', '中国,浙江省,舟山群岛新区,洋山岛', 3, 'yangshan', '0580', '316000', 'Y', '121.995891', '30.094637');
INSERT INTO `dd_region` VALUES (1044, 1035, '长涂', '长涂岛', '中国,浙江省,舟山群岛新区,长涂岛', 3, 'changtu', '0580', '316000', 'C', '122.284681', '30.24888');
INSERT INTO `dd_region` VALUES (1045, 1035, '虾峙', '虾峙岛', '中国,浙江省,舟山群岛新区,虾峙岛', 3, 'xiazhi', '0580', '316000', 'X', '122.244686', '29.752941');
INSERT INTO `dd_region` VALUES (1046, 0, '安徽', '安徽省', '中国,安徽省', 1, 'anhui', '', '', 'A', '117.283042', '31.86119');
INSERT INTO `dd_region` VALUES (1047, 1046, '合肥', '合肥市', '中国,安徽省,合肥市', 2, 'hefei', '0551', '230001', 'H', '117.283042', '31.86119');
INSERT INTO `dd_region` VALUES (1048, 1047, '瑶海', '瑶海区', '中国,安徽省,合肥市,瑶海区', 3, 'yaohai', '0551', '230011', 'Y', '117.30947', '31.85809');
INSERT INTO `dd_region` VALUES (1049, 1047, '庐阳', '庐阳区', '中国,安徽省,合肥市,庐阳区', 3, 'luyang', '0551', '230001', 'L', '117.26452', '31.87874');
INSERT INTO `dd_region` VALUES (1050, 1047, '蜀山', '蜀山区', '中国,安徽省,合肥市,蜀山区', 3, 'shushan', '0551', '230031', 'S', '117.26104', '31.85117');
INSERT INTO `dd_region` VALUES (1051, 1047, '包河', '包河区', '中国,安徽省,合肥市,包河区', 3, 'baohe', '0551', '230041', 'B', '117.30984', '31.79502');
INSERT INTO `dd_region` VALUES (1052, 1047, '长丰', '长丰县', '中国,安徽省,合肥市,长丰县', 3, 'changfeng', '0551', '231100', 'C', '117.16549', '32.47959');
INSERT INTO `dd_region` VALUES (1053, 1047, '肥东', '肥东县', '中国,安徽省,合肥市,肥东县', 3, 'feidong', '0551', '231600', 'F', '117.47128', '31.88525');
INSERT INTO `dd_region` VALUES (1054, 1047, '肥西', '肥西县', '中国,安徽省,合肥市,肥西县', 3, 'feixi', '0551', '231200', 'F', '117.16845', '31.72143');
INSERT INTO `dd_region` VALUES (1055, 1047, '庐江', '庐江县', '中国,安徽省,合肥市,庐江县', 3, 'lujiang', '0565', '231500', 'L', '117.289844', '31.251488');
INSERT INTO `dd_region` VALUES (1056, 1047, '巢湖', '巢湖市', '中国,安徽省,合肥市,巢湖市', 3, 'chaohu', '0565', '238000', 'C', '117.874155', '31.600518');
INSERT INTO `dd_region` VALUES (1057, 1046, '芜湖', '芜湖市', '中国,安徽省,芜湖市', 2, 'wuhu', '0551', '241000', 'W', '118.376451', '31.326319');
INSERT INTO `dd_region` VALUES (1058, 1057, '镜湖', '镜湖区', '中国,安徽省,芜湖市,镜湖区', 3, 'jinghu', '0553', '241000', 'J', '118.38525', '31.34038');
INSERT INTO `dd_region` VALUES (1059, 1057, '弋江', '弋江区', '中国,安徽省,芜湖市,弋江区', 3, 'yijiang', '0553', '241000', NULL, '118.37265', '31.31178');
INSERT INTO `dd_region` VALUES (1060, 1057, '鸠江', '鸠江区', '中国,安徽省,芜湖市,鸠江区', 3, 'jiujiang', '0553', '241000', NULL, '118.39215', '31.36928');
INSERT INTO `dd_region` VALUES (1061, 1057, '三山', '三山区', '中国,安徽省,芜湖市,三山区', 3, 'sanshan', '0553', '241000', 'S', '118.22509', '31.20703');
INSERT INTO `dd_region` VALUES (1062, 1057, '芜湖', '芜湖县', '中国,安徽省,芜湖市,芜湖县', 3, 'wuhu', '0553', '241100', 'W', '118.57525', '31.13476');
INSERT INTO `dd_region` VALUES (1063, 1057, '繁昌', '繁昌县', '中国,安徽省,芜湖市,繁昌县', 3, 'fanchang', '0553', '241200', 'F', '118.19982', '31.08319');
INSERT INTO `dd_region` VALUES (1064, 1057, '南陵', '南陵县', '中国,安徽省,芜湖市,南陵县', 3, 'nanling', '0553', '242400', 'N', '118.33688', '30.91969');
INSERT INTO `dd_region` VALUES (1065, 1057, '无为', '无为县', '中国,安徽省,芜湖市,无为县', 3, 'wuwei', '0565', '238300', 'W', '117.911432', '31.303075');
INSERT INTO `dd_region` VALUES (1066, 1046, '蚌埠', '蚌埠市', '中国,安徽省,蚌埠市', 2, 'bengbu', '0552', '233000', 'B', '117.36237', '32.934037');
INSERT INTO `dd_region` VALUES (1067, 1066, '龙子湖', '龙子湖区', '中国,安徽省,蚌埠市,龙子湖区', 3, 'longzihu', '0552', '233000', 'L', '117.39379', '32.94301');
INSERT INTO `dd_region` VALUES (1068, 1066, '蚌山', '蚌山区', '中国,安徽省,蚌埠市,蚌山区', 3, 'bengshan', '0552', '233000', 'B', '117.36767', '32.94411');
INSERT INTO `dd_region` VALUES (1069, 1066, '禹会', '禹会区', '中国,安徽省,蚌埠市,禹会区', 3, 'yuhui', '0552', '233010', 'Y', '117.35315', '32.93336');
INSERT INTO `dd_region` VALUES (1070, 1066, '淮上', '淮上区', '中国,安徽省,蚌埠市,淮上区', 3, 'huaishang', '0552', '233002', 'H', '117.35983', '32.96423');
INSERT INTO `dd_region` VALUES (1071, 1066, '怀远', '怀远县', '中国,安徽省,蚌埠市,怀远县', 3, 'huaiyuan', '0552', '233400', 'H', '117.20507', '32.97007');
INSERT INTO `dd_region` VALUES (1072, 1066, '五河', '五河县', '中国,安徽省,蚌埠市,五河县', 3, 'wuhe', '0552', '233300', 'W', '117.89144', '33.14457');
INSERT INTO `dd_region` VALUES (1073, 1066, '固镇', '固镇县', '中国,安徽省,蚌埠市,固镇县', 3, 'guzhen', '0552', '233700', 'G', '117.31558', '33.31803');
INSERT INTO `dd_region` VALUES (1074, 1046, '淮南', '淮南市', '中国,安徽省,淮南市', 2, 'huainan', '0554', '232001', 'H', '117.025449', '32.645947');
INSERT INTO `dd_region` VALUES (1075, 1074, '大通', '大通区', '中国,安徽省,淮南市,大通区', 3, 'datong', '0554', '232033', 'D', '117.05255', '32.63265');
INSERT INTO `dd_region` VALUES (1076, 1074, '田家庵', '田家庵区', '中国,安徽省,淮南市,田家庵区', 3, 'tianjiaan', '0554', '232000', 'T', '117.01739', '32.64697');
INSERT INTO `dd_region` VALUES (1077, 1074, '谢家集', '谢家集区', '中国,安徽省,淮南市,谢家集区', 3, 'xiejiaji', '0554', '232052', 'X', '116.86377', '32.59818');
INSERT INTO `dd_region` VALUES (1078, 1074, '八公山', '八公山区', '中国,安徽省,淮南市,八公山区', 3, 'bagongshan', '0554', '232072', 'B', '116.83694', '32.62941');
INSERT INTO `dd_region` VALUES (1079, 1074, '潘集', '潘集区', '中国,安徽省,淮南市,潘集区', 3, 'panji', '0554', '232082', 'P', '116.81622', '32.78287');
INSERT INTO `dd_region` VALUES (1080, 1074, '凤台', '凤台县', '中国,安徽省,淮南市,凤台县', 3, 'fengtai', '0554', '232100', 'F', '116.71569', '32.70752');
INSERT INTO `dd_region` VALUES (1081, 1046, '马鞍山', '马鞍山市', '中国,安徽省,马鞍山市', 2, 'ma\'anshan', '0555', '243001', 'M', '118.507906', '31.689362');
INSERT INTO `dd_region` VALUES (1082, 1081, '花山', '花山区', '中国,安徽省,马鞍山市,花山区', 3, 'huashan', '0555', '243000', 'H', '118.51231', '31.7001');
INSERT INTO `dd_region` VALUES (1083, 1081, '雨山', '雨山区', '中国,安徽省,马鞍山市,雨山区', 3, 'yushan', '0555', '243071', 'Y', '118.49869', '31.68219');
INSERT INTO `dd_region` VALUES (1084, 1081, '博望', '博望区', '中国,安徽省,马鞍山市,博望区', 3, 'bowang', '0555', '243131', 'B', '118.844387', '31.561871');
INSERT INTO `dd_region` VALUES (1085, 1081, '当涂', '当涂县', '中国,安徽省,马鞍山市,当涂县', 3, 'dangtu', '0555', '243100', 'D', '118.49786', '31.57098');
INSERT INTO `dd_region` VALUES (1086, 1081, '含山', '含山县', '中国,安徽省,马鞍山市,含山县', 3, 'hanshan', '0555', '238100', 'H', '118.105545', '31.727758');
INSERT INTO `dd_region` VALUES (1087, 1081, '和县', '和县', '中国,安徽省,马鞍山市,和县', 3, 'hexian', '0555', '238200', 'H', '118.351405', '31.741794');
INSERT INTO `dd_region` VALUES (1088, 1046, '淮北', '淮北市', '中国,安徽省,淮北市', 2, 'huaibei', '0561', '235000', 'H', '116.794664', '33.971707');
INSERT INTO `dd_region` VALUES (1089, 1088, '杜集', '杜集区', '中国,安徽省,淮北市,杜集区', 3, 'duji', '0561', '235000', 'D', '116.82998', '33.99363');
INSERT INTO `dd_region` VALUES (1090, 1088, '相山', '相山区', '中国,安徽省,淮北市,相山区', 3, 'xiangshan', '0561', '235000', 'X', '116.79464', '33.95979');
INSERT INTO `dd_region` VALUES (1091, 1088, '烈山', '烈山区', '中国,安徽省,淮北市,烈山区', 3, 'lieshan', '0561', '235000', 'L', '116.81448', '33.89355');
INSERT INTO `dd_region` VALUES (1092, 1088, '濉溪', '濉溪县', '中国,安徽省,淮北市,濉溪县', 3, 'suixi', '0561', '235100', NULL, '116.76785', '33.91455');
INSERT INTO `dd_region` VALUES (1093, 1046, '铜陵', '铜陵市', '中国,安徽省,铜陵市', 2, 'tongling', '0562', '244000', 'T', '117.816576', '30.929935');
INSERT INTO `dd_region` VALUES (1094, 1093, '铜官山', '铜官山区', '中国,安徽省,铜陵市,铜官山区', 3, 'tongguanshan', '0562', '244000', 'T', '117.81525', '30.93423');
INSERT INTO `dd_region` VALUES (1095, 1093, '狮子山', '狮子山区', '中国,安徽省,铜陵市,狮子山区', 3, 'shizishan', '0562', '244000', 'S', '117.89178', '30.92631');
INSERT INTO `dd_region` VALUES (1096, 1093, '郊区', '郊区', '中国,安徽省,铜陵市,郊区', 3, 'jiaoqu', '0562', '244000', 'J', '117.80868', '30.91976');
INSERT INTO `dd_region` VALUES (1097, 1093, '铜陵', '铜陵县', '中国,安徽省,铜陵市,铜陵县', 3, 'tongling', '0562', '244100', 'T', '117.79113', '30.95365');
INSERT INTO `dd_region` VALUES (1098, 1046, '安庆', '安庆市', '中国,安徽省,安庆市', 2, 'anqing', '0556', '246001', 'A', '117.053571', '30.524816');
INSERT INTO `dd_region` VALUES (1099, 1098, '迎江', '迎江区', '中国,安徽省,安庆市,迎江区', 3, 'yingjiang', '0556', '246001', 'Y', '117.0493', '30.50421');
INSERT INTO `dd_region` VALUES (1100, 1098, '大观', '大观区', '中国,安徽省,安庆市,大观区', 3, 'daguan', '0556', '246002', 'D', '117.03426', '30.51216');
INSERT INTO `dd_region` VALUES (1101, 1098, '宜秀', '宜秀区', '中国,安徽省,安庆市,宜秀区', 3, 'yixiu', '0556', '246003', 'Y', '117.06127', '30.50783');
INSERT INTO `dd_region` VALUES (1102, 1098, '怀宁', '怀宁县', '中国,安徽省,安庆市,怀宁县', 3, 'huaining', '0556', '246100', 'H', '116.82968', '30.73376');
INSERT INTO `dd_region` VALUES (1103, 1098, '枞阳', '枞阳县', '中国,安徽省,安庆市,枞阳县', 3, 'zongyang', '0556', '246700', NULL, '117.22015', '30.69956');
INSERT INTO `dd_region` VALUES (1104, 1098, '潜山', '潜山县', '中国,安徽省,安庆市,潜山县', 3, 'qianshan', '0556', '246300', 'Q', '116.57574', '30.63037');
INSERT INTO `dd_region` VALUES (1105, 1098, '太湖', '太湖县', '中国,安徽省,安庆市,太湖县', 3, 'taihu', '0556', '246400', 'T', '116.3088', '30.4541');
INSERT INTO `dd_region` VALUES (1106, 1098, '宿松', '宿松县', '中国,安徽省,安庆市,宿松县', 3, 'susong', '0556', '246500', 'S', '116.12915', '30.1536');
INSERT INTO `dd_region` VALUES (1107, 1098, '望江', '望江县', '中国,安徽省,安庆市,望江县', 3, 'wangjiang', '0556', '246200', 'W', '116.68814', '30.12585');
INSERT INTO `dd_region` VALUES (1108, 1098, '岳西', '岳西县', '中国,安徽省,安庆市,岳西县', 3, 'yuexi', '0556', '246600', 'Y', '116.35995', '30.84983');
INSERT INTO `dd_region` VALUES (1109, 1098, '桐城', '桐城市', '中国,安徽省,安庆市,桐城市', 3, 'tongcheng', '0556', '231400', 'T', '116.95071', '31.05216');
INSERT INTO `dd_region` VALUES (1110, 1046, '黄山', '黄山市', '中国,安徽省,黄山市', 2, 'huangshan', '0559', '245000', 'H', '118.317325', '29.709239');
INSERT INTO `dd_region` VALUES (1111, 1110, '屯溪', '屯溪区', '中国,安徽省,黄山市,屯溪区', 3, 'tunxi', '0559', '245000', 'T', '118.33368', '29.71138');
INSERT INTO `dd_region` VALUES (1112, 1110, '黄山', '黄山区', '中国,安徽省,黄山市,黄山区', 3, 'huangshan', '0559', '242700', 'H', '118.1416', '30.2729');
INSERT INTO `dd_region` VALUES (1113, 1110, '徽州', '徽州区', '中国,安徽省,黄山市,徽州区', 3, 'huizhou', '0559', '245061', 'H', '118.33654', '29.82784');
INSERT INTO `dd_region` VALUES (1114, 1110, '歙县', '歙县', '中国,安徽省,黄山市,歙县', 3, 'shexian', '0559', '245200', NULL, '118.43676', '29.86745');
INSERT INTO `dd_region` VALUES (1115, 1110, '休宁', '休宁县', '中国,安徽省,黄山市,休宁县', 3, 'xiuning', '0559', '245400', 'X', '118.18136', '29.78607');
INSERT INTO `dd_region` VALUES (1116, 1110, '黟县', '黟县', '中国,安徽省,黄山市,黟县', 3, 'yixian', '0559', '245500', NULL, '117.94137', '29.92588');
INSERT INTO `dd_region` VALUES (1117, 1110, '祁门', '祁门县', '中国,安徽省,黄山市,祁门县', 3, 'qimen', '0559', '245600', 'Q', '117.71847', '29.85723');
INSERT INTO `dd_region` VALUES (1118, 1046, '滁州', '滁州市', '中国,安徽省,滁州市', 2, 'chuzhou', '0550', '239000', 'C', '118.316264', '32.303627');
INSERT INTO `dd_region` VALUES (1119, 1118, '琅琊', '琅琊区', '中国,安徽省,滁州市,琅琊区', 3, 'langya', '0550', '239000', 'L', '118.30538', '32.29521');
INSERT INTO `dd_region` VALUES (1120, 1118, '南谯', '南谯区', '中国,安徽省,滁州市,南谯区', 3, 'nanqiao', '0550', '239000', 'N', '118.31222', '32.31861');
INSERT INTO `dd_region` VALUES (1121, 1118, '来安', '来安县', '中国,安徽省,滁州市,来安县', 3, 'lai\'an', '0550', '239200', 'L', '118.43438', '32.45176');
INSERT INTO `dd_region` VALUES (1122, 1118, '全椒', '全椒县', '中国,安徽省,滁州市,全椒县', 3, 'quanjiao', '0550', '239500', 'Q', '118.27291', '32.08524');
INSERT INTO `dd_region` VALUES (1123, 1118, '定远', '定远县', '中国,安徽省,滁州市,定远县', 3, 'dingyuan', '0550', '233200', 'D', '117.68035', '32.52488');
INSERT INTO `dd_region` VALUES (1124, 1118, '凤阳', '凤阳县', '中国,安徽省,滁州市,凤阳县', 3, 'fengyang', '0550', '233100', 'F', '117.56454', '32.86507');
INSERT INTO `dd_region` VALUES (1125, 1118, '天长', '天长市', '中国,安徽省,滁州市,天长市', 3, 'tianchang', '0550', '239300', 'T', '118.99868', '32.69124');
INSERT INTO `dd_region` VALUES (1126, 1118, '明光', '明光市', '中国,安徽省,滁州市,明光市', 3, 'mingguang', '0550', '239400', 'M', '117.99093', '32.77819');
INSERT INTO `dd_region` VALUES (1127, 1046, '阜阳', '阜阳市', '中国,安徽省,阜阳市', 2, 'fuyang', '0558', '236033', 'F', '115.819729', '32.896969');
INSERT INTO `dd_region` VALUES (1128, 1127, '颍州', '颍州区', '中国,安徽省,阜阳市,颍州区', 3, 'yingzhou', '0558', '236001', NULL, '115.80694', '32.88346');
INSERT INTO `dd_region` VALUES (1129, 1127, '颍东', '颍东区', '中国,安徽省,阜阳市,颍东区', 3, 'yingdong', '0558', '236058', NULL, '115.85659', '32.91296');
INSERT INTO `dd_region` VALUES (1130, 1127, '颍泉', '颍泉区', '中国,安徽省,阜阳市,颍泉区', 3, 'yingquan', '0558', '236045', NULL, '115.80712', '32.9249');
INSERT INTO `dd_region` VALUES (1131, 1127, '临泉', '临泉县', '中国,安徽省,阜阳市,临泉县', 3, 'linquan', '0558', '236400', 'L', '115.26232', '33.06758');
INSERT INTO `dd_region` VALUES (1132, 1127, '太和', '太和县', '中国,安徽省,阜阳市,太和县', 3, 'taihe', '0558', '236600', 'T', '115.62191', '33.16025');
INSERT INTO `dd_region` VALUES (1133, 1127, '阜南', '阜南县', '中国,安徽省,阜阳市,阜南县', 3, 'funan', '0558', '236300', 'F', '115.58563', '32.63551');
INSERT INTO `dd_region` VALUES (1134, 1127, '颍上', '颍上县', '中国,安徽省,阜阳市,颍上县', 3, 'yingshang', '0558', '236200', NULL, '116.26458', '32.62998');
INSERT INTO `dd_region` VALUES (1135, 1127, '界首', '界首市', '中国,安徽省,阜阳市,界首市', 3, 'jieshou', '0558', '236500', 'J', '115.37445', '33.25714');
INSERT INTO `dd_region` VALUES (1136, 1046, '宿州', '宿州市', '中国,安徽省,宿州市', 2, 'suzhou', '0557', '234000', 'S', '116.984084', '33.633891');
INSERT INTO `dd_region` VALUES (1137, 1136, '埇桥', '埇桥区', '中国,安徽省,宿州市,埇桥区', 3, 'yongqiao', '0557', '234000', NULL, '116.97731', '33.64058');
INSERT INTO `dd_region` VALUES (1138, 1136, '砀山', '砀山县', '中国,安徽省,宿州市,砀山县', 3, 'dangshan', '0557', '235300', NULL, '116.35363', '34.42356');
INSERT INTO `dd_region` VALUES (1139, 1136, '萧县', '萧县', '中国,安徽省,宿州市,萧县', 3, 'xiaoxian', '0557', '235200', 'X', '116.94546', '34.1879');
INSERT INTO `dd_region` VALUES (1140, 1136, '灵璧', '灵璧县', '中国,安徽省,宿州市,灵璧县', 3, 'lingbi', '0557', '234200', 'L', '117.55813', '33.54339');
INSERT INTO `dd_region` VALUES (1141, 1136, '泗县', '泗县', '中国,安徽省,宿州市,泗县', 3, 'sixian', '0557', '234300', NULL, '117.91033', '33.48295');
INSERT INTO `dd_region` VALUES (1142, 1046, '六安', '六安市', '中国,安徽省,六安市', 2, 'lu\'an', '0564', '237000', 'L', '116.507676', '31.752889');
INSERT INTO `dd_region` VALUES (1143, 1142, '金安', '金安区', '中国,安徽省,六安市,金安区', 3, 'jin\'an', '0564', '237005', 'J', '116.50912', '31.75573');
INSERT INTO `dd_region` VALUES (1144, 1142, '裕安', '裕安区', '中国,安徽省,六安市,裕安区', 3, 'yu\'an', '0564', '237010', 'Y', '116.47985', '31.73787');
INSERT INTO `dd_region` VALUES (1145, 1142, '寿县', '寿县', '中国,安徽省,六安市,寿县', 3, 'shouxian', '0564', '232200', 'S', '116.78466', '32.57653');
INSERT INTO `dd_region` VALUES (1146, 1142, '霍邱', '霍邱县', '中国,安徽省,六安市,霍邱县', 3, 'huoqiu', '0564', '237400', 'H', '116.27795', '32.353');
INSERT INTO `dd_region` VALUES (1147, 1142, '舒城', '舒城县', '中国,安徽省,六安市,舒城县', 3, 'shucheng', '0564', '231300', 'S', '116.94491', '31.46413');
INSERT INTO `dd_region` VALUES (1148, 1142, '金寨', '金寨县', '中国,安徽省,六安市,金寨县', 3, 'jinzhai', '0564', '237300', 'J', '115.93463', '31.7351');
INSERT INTO `dd_region` VALUES (1149, 1142, '霍山', '霍山县', '中国,安徽省,六安市,霍山县', 3, 'huoshan', '0564', '237200', 'H', '116.33291', '31.3929');
INSERT INTO `dd_region` VALUES (1150, 1046, '亳州', '亳州市', '中国,安徽省,亳州市', 2, 'bozhou', '0558', '236802', NULL, '115.782939', '33.869338');
INSERT INTO `dd_region` VALUES (1151, 1150, '谯城', '谯城区', '中国,安徽省,亳州市,谯城区', 3, 'qiaocheng', '0558', '236800', NULL, '115.77941', '33.87532');
INSERT INTO `dd_region` VALUES (1152, 1150, '涡阳', '涡阳县', '中国,安徽省,亳州市,涡阳县', 3, 'guoyang', '0558', '233600', 'W', '116.21682', '33.50911');
INSERT INTO `dd_region` VALUES (1153, 1150, '蒙城', '蒙城县', '中国,安徽省,亳州市,蒙城县', 3, 'mengcheng', '0558', '233500', 'M', '116.5646', '33.26477');
INSERT INTO `dd_region` VALUES (1154, 1150, '利辛', '利辛县', '中国,安徽省,亳州市,利辛县', 3, 'lixin', '0558', '236700', 'L', '116.208', '33.14198');
INSERT INTO `dd_region` VALUES (1155, 1046, '池州', '池州市', '中国,安徽省,池州市', 2, 'chizhou', '0566', '247100', 'C', '117.489157', '30.656037');
INSERT INTO `dd_region` VALUES (1156, 1155, '贵池', '贵池区', '中国,安徽省,池州市,贵池区', 3, 'guichi', '0566', '247100', 'G', '117.48722', '30.65283');
INSERT INTO `dd_region` VALUES (1157, 1155, '东至', '东至县', '中国,安徽省,池州市,东至县', 3, 'dongzhi', '0566', '247200', 'D', '117.02719', '30.0969');
INSERT INTO `dd_region` VALUES (1158, 1155, '石台', '石台县', '中国,安徽省,池州市,石台县', 3, 'shitai', '0566', '245100', 'S', '117.48666', '30.21042');
INSERT INTO `dd_region` VALUES (1159, 1155, '青阳', '青阳县', '中国,安徽省,池州市,青阳县', 3, 'qingyang', '0566', '242800', 'Q', '117.84744', '30.63932');
INSERT INTO `dd_region` VALUES (1160, 1046, '宣城', '宣城市', '中国,安徽省,宣城市', 2, 'xuancheng', '0563', '242000', 'X', '118.757995', '30.945667');
INSERT INTO `dd_region` VALUES (1161, 1160, '宣州', '宣州区', '中国,安徽省,宣城市,宣州区', 3, 'xuanzhou', '0563', '242000', 'X', '118.75462', '30.94439');
INSERT INTO `dd_region` VALUES (1162, 1160, '郎溪', '郎溪县', '中国,安徽省,宣城市,郎溪县', 3, 'langxi', '0563', '242100', 'L', '119.17923', '31.12599');
INSERT INTO `dd_region` VALUES (1163, 1160, '广德', '广德县', '中国,安徽省,宣城市,广德县', 3, 'guangde', '0563', '242200', 'G', '119.41769', '30.89371');
INSERT INTO `dd_region` VALUES (1164, 1160, '泾县', '泾县', '中国,安徽省,宣城市,泾县', 3, 'jingxian', '0563', '242500', NULL, '118.41964', '30.69498');
INSERT INTO `dd_region` VALUES (1165, 1160, '绩溪', '绩溪县', '中国,安徽省,宣城市,绩溪县', 3, 'jixi', '0563', '245300', 'J', '118.59765', '30.07069');
INSERT INTO `dd_region` VALUES (1166, 1160, '旌德', '旌德县', '中国,安徽省,宣城市,旌德县', 3, 'jingde', '0563', '242600', NULL, '118.54299', '30.28898');
INSERT INTO `dd_region` VALUES (1167, 1160, '宁国', '宁国市', '中国,安徽省,宣城市,宁国市', 3, 'ningguo', '0563', '242300', 'N', '118.98349', '30.6238');
INSERT INTO `dd_region` VALUES (1168, 0, '福建', '福建省', '中国,福建省', 1, 'fujian', '', '', 'F', '119.306239', '26.075302');
INSERT INTO `dd_region` VALUES (1169, 1168, '福州', '福州市', '中国,福建省,福州市', 2, 'fuzhou', '0591', '350001', 'F', '119.306239', '26.075302');
INSERT INTO `dd_region` VALUES (1170, 1169, '鼓楼', '鼓楼区', '中国,福建省,福州市,鼓楼区', 3, 'gulou', '0591', '350001', 'G', '119.30384', '26.08225');
INSERT INTO `dd_region` VALUES (1171, 1169, '台江', '台江区', '中国,福建省,福州市,台江区', 3, 'taijiang', '0591', '350004', 'T', '119.30899', '26.06204');
INSERT INTO `dd_region` VALUES (1172, 1169, '仓山', '仓山区', '中国,福建省,福州市,仓山区', 3, 'cangshan', '0591', '350007', 'C', '119.31543', '26.04335');
INSERT INTO `dd_region` VALUES (1173, 1169, '马尾', '马尾区', '中国,福建省,福州市,马尾区', 3, 'mawei', '0591', '350015', 'M', '119.4555', '25.98942');
INSERT INTO `dd_region` VALUES (1174, 1169, '晋安', '晋安区', '中国,福建省,福州市,晋安区', 3, 'jin\'an', '0591', '350011', 'J', '119.32828', '26.0818');
INSERT INTO `dd_region` VALUES (1175, 1169, '闽侯', '闽侯县', '中国,福建省,福州市,闽侯县', 3, 'minhou', '0591', '350100', 'M', '119.13388', '26.15014');
INSERT INTO `dd_region` VALUES (1176, 1169, '连江', '连江县', '中国,福建省,福州市,连江县', 3, 'lianjiang', '0591', '350500', 'L', '119.53433', '26.19466');
INSERT INTO `dd_region` VALUES (1177, 1169, '罗源', '罗源县', '中国,福建省,福州市,罗源县', 3, 'luoyuan', '0591', '350600', 'L', '119.5509', '26.48752');
INSERT INTO `dd_region` VALUES (1178, 1169, '闽清', '闽清县', '中国,福建省,福州市,闽清县', 3, 'minqing', '0591', '350800', 'M', '118.8623', '26.21901');
INSERT INTO `dd_region` VALUES (1179, 1169, '永泰', '永泰县', '中国,福建省,福州市,永泰县', 3, 'yongtai', '0591', '350700', 'Y', '118.936', '25.86816');
INSERT INTO `dd_region` VALUES (1180, 1169, '平潭', '平潭县', '中国,福建省,福州市,平潭县', 3, 'pingtan', '0591', '350400', 'P', '119.791197', '25.503672');
INSERT INTO `dd_region` VALUES (1181, 1169, '福清', '福清市', '中国,福建省,福州市,福清市', 3, 'fuqing', '0591', '350300', 'F', '119.38507', '25.72086');
INSERT INTO `dd_region` VALUES (1182, 1169, '长乐', '长乐市', '中国,福建省,福州市,长乐市', 3, 'changle', '0591', '350200', 'C', '119.52313', '25.96276');
INSERT INTO `dd_region` VALUES (1183, 1168, '厦门', '厦门市', '中国,福建省,厦门市', 2, 'xiamen', '0592', '361003', 'X', '118.11022', '24.490474');
INSERT INTO `dd_region` VALUES (1184, 1183, '思明', '思明区', '中国,福建省,厦门市,思明区', 3, 'siming', '0592', '361001', 'S', '118.08233', '24.44543');
INSERT INTO `dd_region` VALUES (1185, 1183, '海沧', '海沧区', '中国,福建省,厦门市,海沧区', 3, 'haicang', '0592', '361026', 'H', '118.03289', '24.48461');
INSERT INTO `dd_region` VALUES (1186, 1183, '湖里', '湖里区', '中国,福建省,厦门市,湖里区', 3, 'huli', '0592', '361006', 'H', '118.14621', '24.51253');
INSERT INTO `dd_region` VALUES (1187, 1183, '集美', '集美区', '中国,福建省,厦门市,集美区', 3, 'jimei', '0592', '361021', 'J', '118.09719', '24.57584');
INSERT INTO `dd_region` VALUES (1188, 1183, '同安', '同安区', '中国,福建省,厦门市,同安区', 3, 'tong\'an', '0592', '361100', 'T', '118.15197', '24.72308');
INSERT INTO `dd_region` VALUES (1189, 1183, '翔安', '翔安区', '中国,福建省,厦门市,翔安区', 3, 'xiang\'an', '0592', '361101', 'X', '118.24783', '24.61863');
INSERT INTO `dd_region` VALUES (1190, 1168, '莆田', '莆田市', '中国,福建省,莆田市', 2, 'putian', '0594', '351100', 'P', '119.007558', '25.431011');
INSERT INTO `dd_region` VALUES (1191, 1190, '城厢', '城厢区', '中国,福建省,莆田市,城厢区', 3, 'chengxiang', '0594', '351100', 'C', '118.99462', '25.41872');
INSERT INTO `dd_region` VALUES (1192, 1190, '涵江', '涵江区', '中国,福建省,莆田市,涵江区', 3, 'hanjiang', '0594', '351111', 'H', '119.11621', '25.45876');
INSERT INTO `dd_region` VALUES (1193, 1190, '荔城', '荔城区', '中国,福建省,莆田市,荔城区', 3, 'licheng', '0594', '351100', 'L', '119.01339', '25.43369');
INSERT INTO `dd_region` VALUES (1194, 1190, '秀屿', '秀屿区', '中国,福建省,莆田市,秀屿区', 3, 'xiuyu', '0594', '351152', 'X', '119.10553', '25.31831');
INSERT INTO `dd_region` VALUES (1195, 1190, '仙游', '仙游县', '中国,福建省,莆田市,仙游县', 3, 'xianyou', '0594', '351200', 'X', '118.69177', '25.36214');
INSERT INTO `dd_region` VALUES (1196, 1168, '三明', '三明市', '中国,福建省,三明市', 2, 'sanming', '0598', '365000', 'S', '117.635001', '26.265444');
INSERT INTO `dd_region` VALUES (1197, 1196, '梅列', '梅列区', '中国,福建省,三明市,梅列区', 3, 'meilie', '0598', '365000', 'M', '117.64585', '26.27171');
INSERT INTO `dd_region` VALUES (1198, 1196, '三元', '三元区', '中国,福建省,三明市,三元区', 3, 'sanyuan', '0598', '365001', 'S', '117.60788', '26.23372');
INSERT INTO `dd_region` VALUES (1199, 1196, '明溪', '明溪县', '中国,福建省,三明市,明溪县', 3, 'mingxi', '0598', '365200', 'M', '117.20498', '26.35294');
INSERT INTO `dd_region` VALUES (1200, 1196, '清流', '清流县', '中国,福建省,三明市,清流县', 3, 'qingliu', '0598', '365300', 'Q', '116.8146', '26.17144');
INSERT INTO `dd_region` VALUES (1201, 1196, '宁化', '宁化县', '中国,福建省,三明市,宁化县', 3, 'ninghua', '0598', '365400', 'N', '116.66101', '26.25874');
INSERT INTO `dd_region` VALUES (1202, 1196, '大田', '大田县', '中国,福建省,三明市,大田县', 3, 'datian', '0598', '366100', 'D', '117.8471', '25.6926');
INSERT INTO `dd_region` VALUES (1203, 1196, '尤溪', '尤溪县', '中国,福建省,三明市,尤溪县', 3, 'youxi', '0598', '365100', 'Y', '118.19049', '26.17002');
INSERT INTO `dd_region` VALUES (1204, 1196, '沙县', '沙县', '中国,福建省,三明市,沙县', 3, 'shaxian', '0598', '365500', 'S', '117.79266', '26.39615');
INSERT INTO `dd_region` VALUES (1205, 1196, '将乐', '将乐县', '中国,福建省,三明市,将乐县', 3, 'jiangle', '0598', '353300', 'J', '117.47317', '26.72837');
INSERT INTO `dd_region` VALUES (1206, 1196, '泰宁', '泰宁县', '中国,福建省,三明市,泰宁县', 3, 'taining', '0598', '354400', 'T', '117.17578', '26.9001');
INSERT INTO `dd_region` VALUES (1207, 1196, '建宁', '建宁县', '中国,福建省,三明市,建宁县', 3, 'jianning', '0598', '354500', 'J', '116.84603', '26.83091');
INSERT INTO `dd_region` VALUES (1208, 1196, '永安', '永安市', '中国,福建省,三明市,永安市', 3, 'yong\'an', '0598', '366000', 'Y', '117.36517', '25.94136');
INSERT INTO `dd_region` VALUES (1209, 1168, '泉州', '泉州市', '中国,福建省,泉州市', 2, 'quanzhou', '0595', '362000', 'Q', '118.589421', '24.908853');
INSERT INTO `dd_region` VALUES (1210, 1209, '鲤城', '鲤城区', '中国,福建省,泉州市,鲤城区', 3, 'licheng', '0595', '362000', 'L', '118.56591', '24.88741');
INSERT INTO `dd_region` VALUES (1211, 1209, '丰泽', '丰泽区', '中国,福建省,泉州市,丰泽区', 3, 'fengze', '0595', '362000', 'F', '118.61328', '24.89119');
INSERT INTO `dd_region` VALUES (1212, 1209, '洛江', '洛江区', '中国,福建省,泉州市,洛江区', 3, 'luojiang', '0595', '362011', 'L', '118.67111', '24.93984');
INSERT INTO `dd_region` VALUES (1213, 1209, '泉港', '泉港区', '中国,福建省,泉州市,泉港区', 3, 'quangang', '0595', '362114', 'Q', '118.91586', '25.12005');
INSERT INTO `dd_region` VALUES (1214, 1209, '惠安', '惠安县', '中国,福建省,泉州市,惠安县', 3, 'hui\'an', '0595', '362100', 'H', '118.79687', '25.03059');
INSERT INTO `dd_region` VALUES (1215, 1209, '安溪', '安溪县', '中国,福建省,泉州市,安溪县', 3, 'anxi', '0595', '362400', 'A', '118.18719', '25.05627');
INSERT INTO `dd_region` VALUES (1216, 1209, '永春', '永春县', '中国,福建省,泉州市,永春县', 3, 'yongchun', '0595', '362600', 'Y', '118.29437', '25.32183');
INSERT INTO `dd_region` VALUES (1217, 1209, '德化', '德化县', '中国,福建省,泉州市,德化县', 3, 'dehua', '0595', '362500', 'D', '118.24176', '25.49224');
INSERT INTO `dd_region` VALUES (1218, 1209, '金门', '金门县', '中国,福建省,泉州市,金门县', 3, 'jinmen', '', '', 'J', '118.32263', '24.42922');
INSERT INTO `dd_region` VALUES (1219, 1209, '石狮', '石狮市', '中国,福建省,泉州市,石狮市', 3, 'shishi', '0595', '362700', 'S', '118.64779', '24.73242');
INSERT INTO `dd_region` VALUES (1220, 1209, '晋江', '晋江市', '中国,福建省,泉州市,晋江市', 3, 'jinjiang', '0595', '362200', 'J', '118.55194', '24.78141');
INSERT INTO `dd_region` VALUES (1221, 1209, '南安', '南安市', '中国,福建省,泉州市,南安市', 3, 'nan\'an', '0595', '362300', 'N', '118.38589', '24.96055');
INSERT INTO `dd_region` VALUES (1222, 1168, '漳州', '漳州市', '中国,福建省,漳州市', 2, 'zhangzhou', '0596', '363005', 'Z', '117.661801', '24.510897');
INSERT INTO `dd_region` VALUES (1223, 1222, '芗城', '芗城区', '中国,福建省,漳州市,芗城区', 3, 'xiangcheng', '0596', '363000', NULL, '117.65402', '24.51081');
INSERT INTO `dd_region` VALUES (1224, 1222, '龙文', '龙文区', '中国,福建省,漳州市,龙文区', 3, 'longwen', '0596', '363005', 'L', '117.70971', '24.50323');
INSERT INTO `dd_region` VALUES (1225, 1222, '云霄', '云霄县', '中国,福建省,漳州市,云霄县', 3, 'yunxiao', '0596', '363300', 'Y', '117.34051', '23.95534');
INSERT INTO `dd_region` VALUES (1226, 1222, '漳浦', '漳浦县', '中国,福建省,漳州市,漳浦县', 3, 'zhangpu', '0596', '363200', 'Z', '117.61367', '24.11706');
INSERT INTO `dd_region` VALUES (1227, 1222, '诏安', '诏安县', '中国,福建省,漳州市,诏安县', 3, 'zhao\'an', '0596', '363500', NULL, '117.17501', '23.71148');
INSERT INTO `dd_region` VALUES (1228, 1222, '长泰', '长泰县', '中国,福建省,漳州市,长泰县', 3, 'changtai', '0596', '363900', 'C', '117.75924', '24.62526');
INSERT INTO `dd_region` VALUES (1229, 1222, '东山', '东山县', '中国,福建省,漳州市,东山县', 3, 'dongshan', '0596', '363400', 'D', '117.42822', '23.70109');
INSERT INTO `dd_region` VALUES (1230, 1222, '南靖', '南靖县', '中国,福建省,漳州市,南靖县', 3, 'nanjing', '0596', '363600', 'N', '117.35736', '24.51448');
INSERT INTO `dd_region` VALUES (1231, 1222, '平和', '平和县', '中国,福建省,漳州市,平和县', 3, 'pinghe', '0596', '363700', 'P', '117.3124', '24.36395');
INSERT INTO `dd_region` VALUES (1232, 1222, '华安', '华安县', '中国,福建省,漳州市,华安县', 3, 'hua\'an', '0596', '363800', 'H', '117.54077', '25.00563');
INSERT INTO `dd_region` VALUES (1233, 1222, '龙海', '龙海市', '中国,福建省,漳州市,龙海市', 3, 'longhai', '0596', '363100', 'L', '117.81802', '24.44655');
INSERT INTO `dd_region` VALUES (1234, 1168, '南平', '南平市', '中国,福建省,南平市', 2, 'nanping', '0599', '353000', 'N', '118.178459', '26.635627');
INSERT INTO `dd_region` VALUES (1235, 1234, '延平', '延平区', '中国,福建省,南平市,延平区', 3, 'yanping', '0600', '353000', 'Y', '118.18189', '26.63745');
INSERT INTO `dd_region` VALUES (1236, 1234, '建阳', '建阳区', '中国,福建省,南平市,建阳区', 3, 'jianyang', '0599', '354200', 'J', '118.12267', '27.332067');
INSERT INTO `dd_region` VALUES (1237, 1234, '顺昌', '顺昌县', '中国,福建省,南平市,顺昌县', 3, 'shunchang', '0605', '353200', 'S', '117.8103', '26.79298');
INSERT INTO `dd_region` VALUES (1238, 1234, '浦城', '浦城县', '中国,福建省,南平市,浦城县', 3, 'pucheng', '0606', '353400', 'P', '118.54007', '27.91888');
INSERT INTO `dd_region` VALUES (1239, 1234, '光泽', '光泽县', '中国,福建省,南平市,光泽县', 3, 'guangze', '0607', '354100', 'G', '117.33346', '27.54231');
INSERT INTO `dd_region` VALUES (1240, 1234, '松溪', '松溪县', '中国,福建省,南平市,松溪县', 3, 'songxi', '0608', '353500', 'S', '118.78533', '27.52624');
INSERT INTO `dd_region` VALUES (1241, 1234, '政和', '政和县', '中国,福建省,南平市,政和县', 3, 'zhenghe', '0609', '353600', 'Z', '118.85571', '27.36769');
INSERT INTO `dd_region` VALUES (1242, 1234, '邵武', '邵武市', '中国,福建省,南平市,邵武市', 3, 'shaowu', '0601', '354000', 'S', '117.4924', '27.34033');
INSERT INTO `dd_region` VALUES (1243, 1234, '武夷山', '武夷山市', '中国,福建省,南平市,武夷山市', 3, 'wuyishan', '0602', '354300', 'W', '118.03665', '27.75543');
INSERT INTO `dd_region` VALUES (1244, 1234, '建瓯', '建瓯市', '中国,福建省,南平市,建瓯市', 3, 'jianou', '0603', '353100', 'J', '118.29766', '27.02301');
INSERT INTO `dd_region` VALUES (1245, 1168, '龙岩', '龙岩市', '中国,福建省,龙岩市', 2, 'longyan', '0597', '364000', 'L', '117.02978', '25.091603');
INSERT INTO `dd_region` VALUES (1246, 1245, '新罗', '新罗区', '中国,福建省,龙岩市,新罗区', 3, 'xinluo', '0597', '364000', 'X', '117.03693', '25.09834');
INSERT INTO `dd_region` VALUES (1247, 1245, '长汀', '长汀县', '中国,福建省,龙岩市,长汀县', 3, 'changting', '0597', '366300', 'C', '116.35888', '25.82773');
INSERT INTO `dd_region` VALUES (1248, 1245, '永定', '永定区', '中国,福建省,龙岩市,永定区', 3, 'yongding', '0597', '364100', 'Y', '116.73199', '24.72302');
INSERT INTO `dd_region` VALUES (1249, 1245, '上杭', '上杭县', '中国,福建省,龙岩市,上杭县', 3, 'shanghang', '0597', '364200', 'S', '116.42022', '25.04943');
INSERT INTO `dd_region` VALUES (1250, 1245, '武平', '武平县', '中国,福建省,龙岩市,武平县', 3, 'wuping', '0597', '364300', 'W', '116.10229', '25.09244');
INSERT INTO `dd_region` VALUES (1251, 1245, '连城', '连城县', '中国,福建省,龙岩市,连城县', 3, 'liancheng', '0597', '366200', 'L', '116.75454', '25.7103');
INSERT INTO `dd_region` VALUES (1252, 1245, '漳平', '漳平市', '中国,福建省,龙岩市,漳平市', 3, 'zhangping', '0597', '364400', 'Z', '117.41992', '25.29109');
INSERT INTO `dd_region` VALUES (1253, 1168, '宁德', '宁德市', '中国,福建省,宁德市', 2, 'ningde', '0593', '352100', 'N', '119.527082', '26.65924');
INSERT INTO `dd_region` VALUES (1254, 1253, '蕉城', '蕉城区', '中国,福建省,宁德市,蕉城区', 3, 'jiaocheng', '0593', '352100', 'J', '119.52643', '26.66048');
INSERT INTO `dd_region` VALUES (1255, 1253, '霞浦', '霞浦县', '中国,福建省,宁德市,霞浦县', 3, 'xiapu', '0593', '355100', 'X', '119.99893', '26.88578');
INSERT INTO `dd_region` VALUES (1256, 1253, '古田', '古田县', '中国,福建省,宁德市,古田县', 3, 'gutian', '0593', '352200', 'G', '118.74688', '26.57682');
INSERT INTO `dd_region` VALUES (1257, 1253, '屏南', '屏南县', '中国,福建省,宁德市,屏南县', 3, 'pingnan', '0593', '352300', 'P', '118.98861', '26.91099');
INSERT INTO `dd_region` VALUES (1258, 1253, '寿宁', '寿宁县', '中国,福建省,宁德市,寿宁县', 3, 'shouning', '0593', '355500', 'S', '119.5039', '27.45996');
INSERT INTO `dd_region` VALUES (1259, 1253, '周宁', '周宁县', '中国,福建省,宁德市,周宁县', 3, 'zhouning', '0593', '355400', 'Z', '119.33837', '27.10664');
INSERT INTO `dd_region` VALUES (1260, 1253, '柘荣', '柘荣县', '中国,福建省,宁德市,柘荣县', 3, 'zherong', '0593', '355300', NULL, '119.89971', '27.23543');
INSERT INTO `dd_region` VALUES (1261, 1253, '福安', '福安市', '中国,福建省,宁德市,福安市', 3, 'fu\'an', '0593', '355000', 'F', '119.6495', '27.08673');
INSERT INTO `dd_region` VALUES (1262, 1253, '福鼎', '福鼎市', '中国,福建省,宁德市,福鼎市', 3, 'fuding', '0593', '355200', 'F', '120.21664', '27.3243');
INSERT INTO `dd_region` VALUES (1263, 0, '江西', '江西省', '中国,江西省', 1, 'jiangxi', '', '', 'J', '115.892151', '28.676493');
INSERT INTO `dd_region` VALUES (1264, 1263, '南昌', '南昌市', '中国,江西省,南昌市', 2, 'nanchang', '0791', '330008', 'N', '115.892151', '28.676493');
INSERT INTO `dd_region` VALUES (1265, 1264, '东湖', '东湖区', '中国,江西省,南昌市,东湖区', 3, 'donghu', '0791', '330006', 'D', '115.8988', '28.68505');
INSERT INTO `dd_region` VALUES (1266, 1264, '西湖', '西湖区', '中国,江西省,南昌市,西湖区', 3, 'xihu', '0791', '330009', 'X', '115.87728', '28.65688');
INSERT INTO `dd_region` VALUES (1267, 1264, '青云谱', '青云谱区', '中国,江西省,南昌市,青云谱区', 3, 'qingyunpu', '0791', '330001', 'Q', '115.915', '28.63199');
INSERT INTO `dd_region` VALUES (1268, 1264, '湾里', '湾里区', '中国,江西省,南昌市,湾里区', 3, 'wanli', '0791', '330004', 'W', '115.73104', '28.71529');
INSERT INTO `dd_region` VALUES (1269, 1264, '青山湖', '青山湖区', '中国,江西省,南昌市,青山湖区', 3, 'qingshanhu', '0791', '330029', 'Q', '115.9617', '28.68206');
INSERT INTO `dd_region` VALUES (1270, 1264, '南昌', '南昌县', '中国,江西省,南昌市,南昌县', 3, 'nanchang', '0791', '330200', 'N', '115.94393', '28.54559');
INSERT INTO `dd_region` VALUES (1271, 1264, '新建', '新建县', '中国,江西省,南昌市,新建县', 3, 'xinjian', '0791', '330100', 'X', '115.81546', '28.69248');
INSERT INTO `dd_region` VALUES (1272, 1264, '安义', '安义县', '中国,江西省,南昌市,安义县', 3, 'anyi', '0791', '330500', 'A', '115.54879', '28.84602');
INSERT INTO `dd_region` VALUES (1273, 1264, '进贤', '进贤县', '中国,江西省,南昌市,进贤县', 3, 'jinxian', '0791', '331700', 'J', '116.24087', '28.37679');
INSERT INTO `dd_region` VALUES (1274, 1263, '景德镇', '景德镇市', '中国,江西省,景德镇市', 2, 'jingdezhen', '0798', '333000', 'J', '117.214664', '29.29256');
INSERT INTO `dd_region` VALUES (1275, 1274, '昌江', '昌江区', '中国,江西省,景德镇市,昌江区', 3, 'changjiang', '0799', '333000', 'C', '117.18359', '29.27321');
INSERT INTO `dd_region` VALUES (1276, 1274, '珠山', '珠山区', '中国,江西省,景德镇市,珠山区', 3, 'zhushan', '0800', '333000', 'Z', '117.20233', '29.30127');
INSERT INTO `dd_region` VALUES (1277, 1274, '浮梁', '浮梁县', '中国,江西省,景德镇市,浮梁县', 3, 'fuliang', '0802', '333400', 'F', '117.21517', '29.35156');
INSERT INTO `dd_region` VALUES (1278, 1274, '乐平', '乐平市', '中国,江西省,景德镇市,乐平市', 3, 'leping', '0801', '333300', 'L', '117.12887', '28.96295');
INSERT INTO `dd_region` VALUES (1279, 1263, '萍乡', '萍乡市', '中国,江西省,萍乡市', 2, 'pingxiang', '0799', '337000', 'P', '113.852186', '27.622946');
INSERT INTO `dd_region` VALUES (1280, 1279, '安源', '安源区', '中国,江西省,萍乡市,安源区', 3, 'anyuan', '0800', '337000', 'A', '113.89135', '27.61653');
INSERT INTO `dd_region` VALUES (1281, 1279, '湘东', '湘东区', '中国,江西省,萍乡市,湘东区', 3, 'xiangdong', '0801', '337016', 'X', '113.73294', '27.64007');
INSERT INTO `dd_region` VALUES (1282, 1279, '莲花', '莲花县', '中国,江西省,萍乡市,莲花县', 3, 'lianhua', '0802', '337100', 'L', '113.96142', '27.12866');
INSERT INTO `dd_region` VALUES (1283, 1279, '上栗', '上栗县', '中国,江西省,萍乡市,上栗县', 3, 'shangli', '0803', '337009', 'S', '113.79403', '27.87467');
INSERT INTO `dd_region` VALUES (1284, 1279, '芦溪', '芦溪县', '中国,江西省,萍乡市,芦溪县', 3, 'luxi', '0804', '337053', 'L', '114.02951', '27.63063');
INSERT INTO `dd_region` VALUES (1285, 1263, '九江', '九江市', '中国,江西省,九江市', 2, 'jiujiang', '0792', '332000', 'J', '115.992811', '29.712034');
INSERT INTO `dd_region` VALUES (1286, 1285, '庐山', '庐山区', '中国,江西省,九江市,庐山区', 3, 'lushan', '0792', '332005', 'L', '115.98904', '29.67177');
INSERT INTO `dd_region` VALUES (1287, 1285, '浔阳', '浔阳区', '中国,江西省,九江市,浔阳区', 3, 'xunyang', '0792', '332000', NULL, '115.98986', '29.72786');
INSERT INTO `dd_region` VALUES (1288, 1285, '九江', '九江县', '中国,江西省,九江市,九江县', 3, 'jiujiang', '0792', '332100', 'J', '115.91128', '29.60852');
INSERT INTO `dd_region` VALUES (1289, 1285, '武宁', '武宁县', '中国,江西省,九江市,武宁县', 3, 'wuning', '0792', '332300', 'W', '115.10061', '29.2584');
INSERT INTO `dd_region` VALUES (1290, 1285, '修水', '修水县', '中国,江西省,九江市,修水县', 3, 'xiushui', '0792', '332400', 'X', '114.54684', '29.02539');
INSERT INTO `dd_region` VALUES (1291, 1285, '永修', '永修县', '中国,江西省,九江市,永修县', 3, 'yongxiu', '0792', '330300', 'Y', '115.80911', '29.02093');
INSERT INTO `dd_region` VALUES (1292, 1285, '德安', '德安县', '中国,江西省,九江市,德安县', 3, 'de\'an', '0792', '330400', 'D', '115.75601', '29.31341');
INSERT INTO `dd_region` VALUES (1293, 1285, '星子', '星子县', '中国,江西省,九江市,星子县', 3, 'xingzi', '0792', '332800', 'X', '116.04492', '29.44608');
INSERT INTO `dd_region` VALUES (1294, 1285, '都昌', '都昌县', '中国,江西省,九江市,都昌县', 3, 'duchang', '0792', '332600', 'D', '116.20401', '29.27327');
INSERT INTO `dd_region` VALUES (1295, 1285, '湖口', '湖口县', '中国,江西省,九江市,湖口县', 3, 'hukou', '0792', '332500', 'H', '116.21853', '29.73818');
INSERT INTO `dd_region` VALUES (1296, 1285, '彭泽', '彭泽县', '中国,江西省,九江市,彭泽县', 3, 'pengze', '0792', '332700', 'P', '116.55011', '29.89589');
INSERT INTO `dd_region` VALUES (1297, 1285, '瑞昌', '瑞昌市', '中国,江西省,九江市,瑞昌市', 3, 'ruichang', '0792', '332200', 'R', '115.66705', '29.67183');
INSERT INTO `dd_region` VALUES (1298, 1285, '共青城', '共青城市', '中国,江西省,九江市,共青城市', 3, 'gongqingcheng', '0792', '332020', 'G', '115.801939', '29.238785');
INSERT INTO `dd_region` VALUES (1299, 1263, '新余', '新余市', '中国,江西省,新余市', 2, 'xinyu', '0790', '338025', 'X', '114.930835', '27.810834');
INSERT INTO `dd_region` VALUES (1300, 1299, '渝水', '渝水区', '中国,江西省,新余市,渝水区', 3, 'yushui', '0790', '338025', 'Y', '114.944', '27.80098');
INSERT INTO `dd_region` VALUES (1301, 1299, '分宜', '分宜县', '中国,江西省,新余市,分宜县', 3, 'fenyi', '0790', '336600', 'F', '114.69189', '27.81475');
INSERT INTO `dd_region` VALUES (1302, 1263, '鹰潭', '鹰潭市', '中国,江西省,鹰潭市', 2, 'yingtan', '0701', '335000', 'Y', '117.033838', '28.238638');
INSERT INTO `dd_region` VALUES (1303, 1302, '月湖', '月湖区', '中国,江西省,鹰潭市,月湖区', 3, 'yuehu', '0701', '335000', 'Y', '117.03732', '28.23913');
INSERT INTO `dd_region` VALUES (1304, 1302, '余江', '余江县', '中国,江西省,鹰潭市,余江县', 3, 'yujiang', '0701', '335200', 'Y', '116.81851', '28.21034');
INSERT INTO `dd_region` VALUES (1305, 1302, '贵溪', '贵溪市', '中国,江西省,鹰潭市,贵溪市', 3, 'guixi', '0701', '335400', 'G', '117.24246', '28.2926');
INSERT INTO `dd_region` VALUES (1306, 1263, '赣州', '赣州市', '中国,江西省,赣州市', 2, 'ganzhou', '0797', '341000', 'G', '114.940278', '25.85097');
INSERT INTO `dd_region` VALUES (1307, 1306, '章贡', '章贡区', '中国,江西省,赣州市,章贡区', 3, 'zhanggong', '0797', '341000', 'Z', '114.94284', '25.8624');
INSERT INTO `dd_region` VALUES (1308, 1306, '南康', '南康区', '中国,江西省,赣州市,南康区', 3, 'nankang', '0797', '341400', 'N', '114.756933', '25.661721');
INSERT INTO `dd_region` VALUES (1309, 1306, '赣县', '赣县', '中国,江西省,赣州市,赣县', 3, 'ganxian', '0797', '341100', 'G', '115.01171', '25.86149');
INSERT INTO `dd_region` VALUES (1310, 1306, '信丰', '信丰县', '中国,江西省,赣州市,信丰县', 3, 'xinfeng', '0797', '341600', 'X', '114.92279', '25.38612');
INSERT INTO `dd_region` VALUES (1311, 1306, '大余', '大余县', '中国,江西省,赣州市,大余县', 3, 'dayu', '0797', '341500', 'D', '114.35757', '25.39561');
INSERT INTO `dd_region` VALUES (1312, 1306, '上犹', '上犹县', '中国,江西省,赣州市,上犹县', 3, 'shangyou', '0797', '341200', 'S', '114.54138', '25.79567');
INSERT INTO `dd_region` VALUES (1313, 1306, '崇义', '崇义县', '中国,江西省,赣州市,崇义县', 3, 'chongyi', '0797', '341300', 'C', '114.30835', '25.68186');
INSERT INTO `dd_region` VALUES (1314, 1306, '安远', '安远县', '中国,江西省,赣州市,安远县', 3, 'anyuan', '0797', '342100', 'A', '115.39483', '25.1371');
INSERT INTO `dd_region` VALUES (1315, 1306, '龙南', '龙南县', '中国,江西省,赣州市,龙南县', 3, 'longnan', '0797', '341700', 'L', '114.78994', '24.91086');
INSERT INTO `dd_region` VALUES (1316, 1306, '定南', '定南县', '中国,江西省,赣州市,定南县', 3, 'dingnan', '0797', '341900', 'D', '115.02713', '24.78395');
INSERT INTO `dd_region` VALUES (1317, 1306, '全南', '全南县', '中国,江西省,赣州市,全南县', 3, 'quannan', '0797', '341800', 'Q', '114.5292', '24.74324');
INSERT INTO `dd_region` VALUES (1318, 1306, '宁都', '宁都县', '中国,江西省,赣州市,宁都县', 3, 'ningdu', '0797', '342800', 'N', '116.01565', '26.47227');
INSERT INTO `dd_region` VALUES (1319, 1306, '于都', '于都县', '中国,江西省,赣州市,于都县', 3, 'yudu', '0797', '342300', 'Y', '115.41415', '25.95257');
INSERT INTO `dd_region` VALUES (1320, 1306, '兴国', '兴国县', '中国,江西省,赣州市,兴国县', 3, 'xingguo', '0797', '342400', 'X', '115.36309', '26.33776');
INSERT INTO `dd_region` VALUES (1321, 1306, '会昌', '会昌县', '中国,江西省,赣州市,会昌县', 3, 'huichang', '0797', '342600', 'H', '115.78555', '25.60068');
INSERT INTO `dd_region` VALUES (1322, 1306, '寻乌', '寻乌县', '中国,江西省,赣州市,寻乌县', 3, 'xunwu', '0797', '342200', 'X', '115.64852', '24.95513');
INSERT INTO `dd_region` VALUES (1323, 1306, '石城', '石城县', '中国,江西省,赣州市,石城县', 3, 'shicheng', '0797', '342700', 'S', '116.3442', '26.32617');
INSERT INTO `dd_region` VALUES (1324, 1306, '瑞金', '瑞金市', '中国,江西省,赣州市,瑞金市', 3, 'ruijin', '0797', '342500', 'R', '116.02703', '25.88557');
INSERT INTO `dd_region` VALUES (1325, 1263, '吉安', '吉安市', '中国,江西省,吉安市', 2, 'ji\'an', '0796', '343000', 'J', '114.986373', '27.111699');
INSERT INTO `dd_region` VALUES (1326, 1325, '吉州', '吉州区', '中国,江西省,吉安市,吉州区', 3, 'jizhou', '0796', '343000', 'J', '114.97598', '27.10669');
INSERT INTO `dd_region` VALUES (1327, 1325, '青原', '青原区', '中国,江西省,吉安市,青原区', 3, 'qingyuan', '0796', '343009', 'Q', '115.01747', '27.10577');
INSERT INTO `dd_region` VALUES (1328, 1325, '吉安', '吉安县', '中国,江西省,吉安市,吉安县', 3, 'ji\'an', '0796', '343100', 'J', '114.90695', '27.04048');
INSERT INTO `dd_region` VALUES (1329, 1325, '吉水', '吉水县', '中国,江西省,吉安市,吉水县', 3, 'jishui', '0796', '331600', 'J', '115.1343', '27.21071');
INSERT INTO `dd_region` VALUES (1330, 1325, '峡江', '峡江县', '中国,江西省,吉安市,峡江县', 3, 'xiajiang', '0796', '331409', 'X', '115.31723', '27.576');
INSERT INTO `dd_region` VALUES (1331, 1325, '新干', '新干县', '中国,江西省,吉安市,新干县', 3, 'xingan', '0796', '331300', 'X', '115.39306', '27.74092');
INSERT INTO `dd_region` VALUES (1332, 1325, '永丰', '永丰县', '中国,江西省,吉安市,永丰县', 3, 'yongfeng', '0796', '331500', 'Y', '115.44238', '27.31785');
INSERT INTO `dd_region` VALUES (1333, 1325, '泰和', '泰和县', '中国,江西省,吉安市,泰和县', 3, 'taihe', '0796', '343700', 'T', '114.90789', '26.79113');
INSERT INTO `dd_region` VALUES (1334, 1325, '遂川', '遂川县', '中国,江西省,吉安市,遂川县', 3, 'suichuan', '0796', '343900', 'S', '114.51629', '26.32598');
INSERT INTO `dd_region` VALUES (1335, 1325, '万安', '万安县', '中国,江西省,吉安市,万安县', 3, 'wan\'an', '0796', '343800', 'W', '114.78659', '26.45931');
INSERT INTO `dd_region` VALUES (1336, 1325, '安福', '安福县', '中国,江西省,吉安市,安福县', 3, 'anfu', '0796', '343200', 'A', '114.61956', '27.39276');
INSERT INTO `dd_region` VALUES (1337, 1325, '永新', '永新县', '中国,江西省,吉安市,永新县', 3, 'yongxin', '0796', '343400', 'Y', '114.24246', '26.94488');
INSERT INTO `dd_region` VALUES (1338, 1325, '井冈山', '井冈山市', '中国,江西省,吉安市,井冈山市', 3, 'jinggangshan', '0796', '343600', 'J', '114.28949', '26.74804');
INSERT INTO `dd_region` VALUES (1339, 1263, '宜春', '宜春市', '中国,江西省,宜春市', 2, 'yichun', '0795', '336000', 'Y', '114.391136', '27.8043');
INSERT INTO `dd_region` VALUES (1340, 1339, '袁州', '袁州区', '中国,江西省,宜春市,袁州区', 3, 'yuanzhou', '0795', '336000', 'Y', '114.38246', '27.79649');
INSERT INTO `dd_region` VALUES (1341, 1339, '奉新', '奉新县', '中国,江西省,宜春市,奉新县', 3, 'fengxin', '0795', '330700', 'F', '115.40036', '28.6879');
INSERT INTO `dd_region` VALUES (1342, 1339, '万载', '万载县', '中国,江西省,宜春市,万载县', 3, 'wanzai', '0795', '336100', 'W', '114.4458', '28.10656');
INSERT INTO `dd_region` VALUES (1343, 1339, '上高', '上高县', '中国,江西省,宜春市,上高县', 3, 'shanggao', '0795', '336400', 'S', '114.92459', '28.23423');
INSERT INTO `dd_region` VALUES (1344, 1339, '宜丰', '宜丰县', '中国,江西省,宜春市,宜丰县', 3, 'yifeng', '0795', '336300', 'Y', '114.7803', '28.38555');
INSERT INTO `dd_region` VALUES (1345, 1339, '靖安', '靖安县', '中国,江西省,宜春市,靖安县', 3, 'jing\'an', '0795', '330600', 'J', '115.36279', '28.86167');
INSERT INTO `dd_region` VALUES (1346, 1339, '铜鼓', '铜鼓县', '中国,江西省,宜春市,铜鼓县', 3, 'tonggu', '0795', '336200', 'T', '114.37036', '28.52311');
INSERT INTO `dd_region` VALUES (1347, 1339, '丰城', '丰城市', '中国,江西省,宜春市,丰城市', 3, 'fengcheng', '0795', '331100', 'F', '115.77114', '28.15918');
INSERT INTO `dd_region` VALUES (1348, 1339, '樟树', '樟树市', '中国,江西省,宜春市,樟树市', 3, 'zhangshu', '0795', '331200', 'Z', '115.5465', '28.05332');
INSERT INTO `dd_region` VALUES (1349, 1339, '高安', '高安市', '中国,江西省,宜春市,高安市', 3, 'gao\'an', '0795', '330800', 'G', '115.3753', '28.4178');
INSERT INTO `dd_region` VALUES (1350, 1263, '抚州', '抚州市', '中国,江西省,抚州市', 2, 'fuzhou', '0794', '344000', 'F', '116.358351', '27.98385');
INSERT INTO `dd_region` VALUES (1351, 1350, '临川', '临川区', '中国,江西省,抚州市,临川区', 3, 'linchuan', '0794', '344000', 'L', '116.35919', '27.97721');
INSERT INTO `dd_region` VALUES (1352, 1350, '南城', '南城县', '中国,江西省,抚州市,南城县', 3, 'nancheng', '0794', '344700', 'N', '116.64419', '27.55381');
INSERT INTO `dd_region` VALUES (1353, 1350, '黎川', '黎川县', '中国,江西省,抚州市,黎川县', 3, 'lichuan', '0794', '344600', 'L', '116.90771', '27.28232');
INSERT INTO `dd_region` VALUES (1354, 1350, '南丰', '南丰县', '中国,江西省,抚州市,南丰县', 3, 'nanfeng', '0794', '344500', 'N', '116.5256', '27.21842');
INSERT INTO `dd_region` VALUES (1355, 1350, '崇仁', '崇仁县', '中国,江西省,抚州市,崇仁县', 3, 'chongren', '0794', '344200', 'C', '116.06021', '27.75962');
INSERT INTO `dd_region` VALUES (1356, 1350, '乐安', '乐安县', '中国,江西省,抚州市,乐安县', 3, 'le\'an', '0794', '344300', 'L', '115.83108', '27.42812');
INSERT INTO `dd_region` VALUES (1357, 1350, '宜黄', '宜黄县', '中国,江西省,抚州市,宜黄县', 3, 'yihuang', '0794', '344400', 'Y', '116.23626', '27.55487');
INSERT INTO `dd_region` VALUES (1358, 1350, '金溪', '金溪县', '中国,江西省,抚州市,金溪县', 3, 'jinxi', '0794', '344800', 'J', '116.77392', '27.90753');
INSERT INTO `dd_region` VALUES (1359, 1350, '资溪', '资溪县', '中国,江西省,抚州市,资溪县', 3, 'zixi', '0794', '335300', 'Z', '117.06939', '27.70493');
INSERT INTO `dd_region` VALUES (1360, 1350, '东乡', '东乡县', '中国,江西省,抚州市,东乡县', 3, 'dongxiang', '0794', '331800', 'D', '116.59039', '28.23614');
INSERT INTO `dd_region` VALUES (1361, 1350, '广昌', '广昌县', '中国,江西省,抚州市,广昌县', 3, 'guangchang', '0794', '344900', 'G', '116.32547', '26.8341');
INSERT INTO `dd_region` VALUES (1362, 1263, '上饶', '上饶市', '中国,江西省,上饶市', 2, 'shangrao', '0793', '334000', 'S', '117.971185', '28.44442');
INSERT INTO `dd_region` VALUES (1363, 1362, '信州', '信州区', '中国,江西省,上饶市,信州区', 3, 'xinzhou', '0793', '334000', 'X', '117.96682', '28.43121');
INSERT INTO `dd_region` VALUES (1364, 1362, '上饶', '上饶县', '中国,江西省,上饶市,上饶县', 3, 'shangrao', '0793', '334100', 'S', '117.90884', '28.44856');
INSERT INTO `dd_region` VALUES (1365, 1362, '广丰', '广丰县', '中国,江西省,上饶市,广丰县', 3, 'guangfeng', '0793', '334600', 'G', '118.19158', '28.43766');
INSERT INTO `dd_region` VALUES (1366, 1362, '玉山', '玉山县', '中国,江西省,上饶市,玉山县', 3, 'yushan', '0793', '334700', 'Y', '118.24462', '28.6818');
INSERT INTO `dd_region` VALUES (1367, 1362, '铅山', '铅山县', '中国,江西省,上饶市,铅山县', 3, 'yanshan', '0793', '334500', 'Q', '117.70996', '28.31549');
INSERT INTO `dd_region` VALUES (1368, 1362, '横峰', '横峰县', '中国,江西省,上饶市,横峰县', 3, 'hengfeng', '0793', '334300', 'H', '117.5964', '28.40716');
INSERT INTO `dd_region` VALUES (1369, 1362, '弋阳', '弋阳县', '中国,江西省,上饶市,弋阳县', 3, 'yiyang', '0793', '334400', NULL, '117.45929', '28.37451');
INSERT INTO `dd_region` VALUES (1370, 1362, '余干', '余干县', '中国,江西省,上饶市,余干县', 3, 'yugan', '0793', '335100', 'Y', '116.69555', '28.70206');
INSERT INTO `dd_region` VALUES (1371, 1362, '鄱阳', '鄱阳县', '中国,江西省,上饶市,鄱阳县', 3, 'poyang', '0793', '333100', NULL, '116.69967', '29.0118');
INSERT INTO `dd_region` VALUES (1372, 1362, '万年', '万年县', '中国,江西省,上饶市,万年县', 3, 'wannian', '0793', '335500', 'W', '117.06884', '28.69537');
INSERT INTO `dd_region` VALUES (1373, 1362, '婺源', '婺源县', '中国,江西省,上饶市,婺源县', 3, 'wuyuan', '0793', '333200', NULL, '117.86105', '29.24841');
INSERT INTO `dd_region` VALUES (1374, 1362, '德兴', '德兴市', '中国,江西省,上饶市,德兴市', 3, 'dexing', '0793', '334200', 'D', '117.57919', '28.94736');
INSERT INTO `dd_region` VALUES (1375, 0, '山东', '山东省', '中国,山东省', 1, 'shandong', '', '', 'S', '117.000923', '36.675807');
INSERT INTO `dd_region` VALUES (1376, 1375, '济南', '济南市', '中国,山东省,济南市', 2, 'jinan', '0531', '250001', 'J', '117.000923', '36.675807');
INSERT INTO `dd_region` VALUES (1377, 1376, '历下', '历下区', '中国,山东省,济南市,历下区', 3, 'lixia', '0531', '250014', 'L', '117.0768', '36.66661');
INSERT INTO `dd_region` VALUES (1378, 1376, '市中区', '市中区', '中国,山东省,济南市,市中区', 3, 'shizhongqu', '0531', '250001', 'S', '116.99741', '36.65101');
INSERT INTO `dd_region` VALUES (1379, 1376, '槐荫', '槐荫区', '中国,山东省,济南市,槐荫区', 3, 'huaiyin', '0531', '250117', 'H', '116.90075', '36.65136');
INSERT INTO `dd_region` VALUES (1380, 1376, '天桥', '天桥区', '中国,山东省,济南市,天桥区', 3, 'tianqiao', '0531', '250031', 'T', '116.98749', '36.67801');
INSERT INTO `dd_region` VALUES (1381, 1376, '历城', '历城区', '中国,山东省,济南市,历城区', 3, 'licheng', '0531', '250100', 'L', '117.06509', '36.67995');
INSERT INTO `dd_region` VALUES (1382, 1376, '长清', '长清区', '中国,山东省,济南市,长清区', 3, 'changqing', '0531', '250300', 'C', '116.75192', '36.55352');
INSERT INTO `dd_region` VALUES (1383, 1376, '平阴', '平阴县', '中国,山东省,济南市,平阴县', 3, 'pingyin', '0531', '250400', 'P', '116.45587', '36.28955');
INSERT INTO `dd_region` VALUES (1384, 1376, '济阳', '济阳县', '中国,山东省,济南市,济阳县', 3, 'jiyang', '0531', '251400', 'J', '117.17327', '36.97845');
INSERT INTO `dd_region` VALUES (1385, 1376, '商河', '商河县', '中国,山东省,济南市,商河县', 3, 'shanghe', '0531', '251600', 'S', '117.15722', '37.31119');
INSERT INTO `dd_region` VALUES (1386, 1376, '章丘', '章丘市', '中国,山东省,济南市,章丘市', 3, 'zhangqiu', '0531', '250200', 'Z', '117.53677', '36.71392');
INSERT INTO `dd_region` VALUES (1387, 1375, '青岛', '青岛市', '中国,山东省,青岛市', 2, 'qingdao', '0532', '266001', 'Q', '120.369557', '36.094406');
INSERT INTO `dd_region` VALUES (1388, 1387, '市南', '市南区', '中国,山东省,青岛市,市南区', 3, 'shinan', '0532', '266001', 'S', '120.38773', '36.06671');
INSERT INTO `dd_region` VALUES (1389, 1387, '市北', '市北区', '中国,山东省,青岛市,市北区', 3, 'shibei', '0532', '266011', 'S', '120.37469', '36.08734');
INSERT INTO `dd_region` VALUES (1390, 1387, '黄岛', '黄岛区', '中国,山东省,青岛市,黄岛区', 3, 'huangdao', '0532', '266500', 'H', '120.19775', '35.96065');
INSERT INTO `dd_region` VALUES (1391, 1387, '崂山', '崂山区', '中国,山东省,青岛市,崂山区', 3, 'laoshan', '0532', '266100', NULL, '120.46923', '36.10717');
INSERT INTO `dd_region` VALUES (1392, 1387, '李沧', '李沧区', '中国,山东省,青岛市,李沧区', 3, 'licang', '0532', '266021', 'L', '120.43286', '36.14502');
INSERT INTO `dd_region` VALUES (1393, 1387, '城阳', '城阳区', '中国,山东省,青岛市,城阳区', 3, 'chengyang', '0532', '266041', 'C', '120.39621', '36.30735');
INSERT INTO `dd_region` VALUES (1394, 1387, '胶州', '胶州市', '中国,山东省,青岛市,胶州市', 3, 'jiaozhou', '0532', '266300', 'J', '120.0335', '36.26442');
INSERT INTO `dd_region` VALUES (1395, 1387, '即墨', '即墨市', '中国,山东省,青岛市,即墨市', 3, 'jimo', '0532', '266200', 'J', '120.44699', '36.38907');
INSERT INTO `dd_region` VALUES (1396, 1387, '平度', '平度市', '中国,山东省,青岛市,平度市', 3, 'pingdu', '0532', '266700', 'P', '119.95996', '36.78688');
INSERT INTO `dd_region` VALUES (1397, 1387, '莱西', '莱西市', '中国,山东省,青岛市,莱西市', 3, 'laixi', '0532', '266600', 'L', '120.51773', '36.88804');
INSERT INTO `dd_region` VALUES (1398, 1387, '西海岸', '西海岸新区', '中国,山东省,青岛市,西海岸新区', 3, 'xihai\'an', '0532', '266500', 'X', '120.19775', '35.96065');
INSERT INTO `dd_region` VALUES (1399, 1375, '淄博', '淄博市', '中国,山东省,淄博市', 2, 'zibo', '0533', '255039', 'Z', '118.047648', '36.814939');
INSERT INTO `dd_region` VALUES (1400, 1399, '淄川', '淄川区', '中国,山东省,淄博市,淄川区', 3, 'zichuan', '0533', '255100', 'Z', '117.96655', '36.64339');
INSERT INTO `dd_region` VALUES (1401, 1399, '张店', '张店区', '中国,山东省,淄博市,张店区', 3, 'zhangdian', '0533', '255022', 'Z', '118.01788', '36.80676');
INSERT INTO `dd_region` VALUES (1402, 1399, '博山', '博山区', '中国,山东省,淄博市,博山区', 3, 'boshan', '0533', '255200', 'B', '117.86166', '36.49469');
INSERT INTO `dd_region` VALUES (1403, 1399, '临淄', '临淄区', '中国,山东省,淄博市,临淄区', 3, 'linzi', '0533', '255400', 'L', '118.30966', '36.8259');
INSERT INTO `dd_region` VALUES (1404, 1399, '周村', '周村区', '中国,山东省,淄博市,周村区', 3, 'zhoucun', '0533', '255300', 'Z', '117.86969', '36.80322');
INSERT INTO `dd_region` VALUES (1405, 1399, '桓台', '桓台县', '中国,山东省,淄博市,桓台县', 3, 'huantai', '0533', '256400', 'H', '118.09698', '36.96036');
INSERT INTO `dd_region` VALUES (1406, 1399, '高青', '高青县', '中国,山东省,淄博市,高青县', 3, 'gaoqing', '0533', '256300', 'G', '117.82708', '37.17197');
INSERT INTO `dd_region` VALUES (1407, 1399, '沂源', '沂源县', '中国,山东省,淄博市,沂源县', 3, 'yiyuan', '0533', '256100', 'Y', '118.17105', '36.18536');
INSERT INTO `dd_region` VALUES (1408, 1375, '枣庄', '枣庄市', '中国,山东省,枣庄市', 2, 'zaozhuang', '0632', '277101', 'Z', '117.557964', '34.856424');
INSERT INTO `dd_region` VALUES (1409, 1408, '市中区', '市中区', '中国,山东省,枣庄市,市中区', 3, 'shizhongqu', '0632', '277101', 'S', '117.55603', '34.86391');
INSERT INTO `dd_region` VALUES (1410, 1408, '薛城', '薛城区', '中国,山东省,枣庄市,薛城区', 3, 'xuecheng', '0632', '277000', 'X', '117.26318', '34.79498');
INSERT INTO `dd_region` VALUES (1411, 1408, '峄城', '峄城区', '中国,山东省,枣庄市,峄城区', 3, 'yicheng', '0632', '277300', NULL, '117.59057', '34.77225');
INSERT INTO `dd_region` VALUES (1412, 1408, '台儿庄', '台儿庄区', '中国,山东省,枣庄市,台儿庄区', 3, 'taierzhuang', '0632', '277400', 'T', '117.73452', '34.56363');
INSERT INTO `dd_region` VALUES (1413, 1408, '山亭', '山亭区', '中国,山东省,枣庄市,山亭区', 3, 'shanting', '0632', '277200', 'S', '117.4663', '35.09541');
INSERT INTO `dd_region` VALUES (1414, 1408, '滕州', '滕州市', '中国,山东省,枣庄市,滕州市', 3, 'tengzhou', '0632', '277500', NULL, '117.165', '35.10534');
INSERT INTO `dd_region` VALUES (1415, 1375, '东营', '东营市', '中国,山东省,东营市', 2, 'dongying', '0546', '257093', 'D', '118.4963', '37.461266');
INSERT INTO `dd_region` VALUES (1416, 1415, '东营', '东营区', '中国,山东省,东营市,东营区', 3, 'dongying', '0546', '257029', 'D', '118.5816', '37.44875');
INSERT INTO `dd_region` VALUES (1417, 1415, '河口', '河口区', '中国,山东省,东营市,河口区', 3, 'hekou', '0546', '257200', 'H', '118.5249', '37.88541');
INSERT INTO `dd_region` VALUES (1418, 1415, '垦利', '垦利县', '中国,山东省,东营市,垦利县', 3, 'kenli', '0546', '257500', 'K', '118.54815', '37.58825');
INSERT INTO `dd_region` VALUES (1419, 1415, '利津', '利津县', '中国,山东省,东营市,利津县', 3, 'lijin', '0546', '257400', 'L', '118.25637', '37.49157');
INSERT INTO `dd_region` VALUES (1420, 1415, '广饶', '广饶县', '中国,山东省,东营市,广饶县', 3, 'guangrao', '0546', '257300', 'G', '118.40704', '37.05381');
INSERT INTO `dd_region` VALUES (1421, 1375, '烟台', '烟台市', '中国,山东省,烟台市', 2, 'yantai', '0635', '264010', 'Y', '121.391382', '37.539297');
INSERT INTO `dd_region` VALUES (1422, 1421, '芝罘', '芝罘区', '中国,山东省,烟台市,芝罘区', 3, 'zhifu', '0635', '264001', 'Z', '121.40023', '37.54064');
INSERT INTO `dd_region` VALUES (1423, 1421, '福山', '福山区', '中国,山东省,烟台市,福山区', 3, 'fushan', '0635', '265500', 'F', '121.26812', '37.49841');
INSERT INTO `dd_region` VALUES (1424, 1421, '牟平', '牟平区', '中国,山东省,烟台市,牟平区', 3, 'muping', '0635', '264100', 'M', '121.60067', '37.38846');
INSERT INTO `dd_region` VALUES (1425, 1421, '莱山', '莱山区', '中国,山东省,烟台市,莱山区', 3, 'laishan', '0635', '264600', 'L', '121.44512', '37.51165');
INSERT INTO `dd_region` VALUES (1426, 1421, '长岛', '长岛县', '中国,山东省,烟台市,长岛县', 3, 'changdao', '0635', '265800', 'C', '120.738', '37.91754');
INSERT INTO `dd_region` VALUES (1427, 1421, '龙口', '龙口市', '中国,山东省,烟台市,龙口市', 3, 'longkou', '0635', '265700', 'L', '120.50634', '37.64064');
INSERT INTO `dd_region` VALUES (1428, 1421, '莱阳', '莱阳市', '中国,山东省,烟台市,莱阳市', 3, 'laiyang', '0635', '265200', 'L', '120.71066', '36.98012');
INSERT INTO `dd_region` VALUES (1429, 1421, '莱州', '莱州市', '中国,山东省,烟台市,莱州市', 3, 'laizhou', '0635', '261400', 'L', '119.94137', '37.17806');
INSERT INTO `dd_region` VALUES (1430, 1421, '蓬莱', '蓬莱市', '中国,山东省,烟台市,蓬莱市', 3, 'penglai', '0635', '265600', 'P', '120.75988', '37.81119');
INSERT INTO `dd_region` VALUES (1431, 1421, '招远', '招远市', '中国,山东省,烟台市,招远市', 3, 'zhaoyuan', '0635', '265400', 'Z', '120.40481', '37.36269');
INSERT INTO `dd_region` VALUES (1432, 1421, '栖霞', '栖霞市', '中国,山东省,烟台市,栖霞市', 3, 'qixia', '0635', '265300', 'Q', '120.85025', '37.33571');
INSERT INTO `dd_region` VALUES (1433, 1421, '海阳', '海阳市', '中国,山东省,烟台市,海阳市', 3, 'haiyang', '0635', '265100', 'H', '121.15976', '36.77622');
INSERT INTO `dd_region` VALUES (1434, 1375, '潍坊', '潍坊市', '中国,山东省,潍坊市', 2, 'weifang', '0536', '261041', 'W', '119.107078', '36.70925');
INSERT INTO `dd_region` VALUES (1435, 1434, '潍城', '潍城区', '中国,山东省,潍坊市,潍城区', 3, 'weicheng', '0536', '261021', 'W', '119.10582', '36.7139');
INSERT INTO `dd_region` VALUES (1436, 1434, '寒亭', '寒亭区', '中国,山东省,潍坊市,寒亭区', 3, 'hanting', '0536', '261100', 'H', '119.21832', '36.77504');
INSERT INTO `dd_region` VALUES (1437, 1434, '坊子', '坊子区', '中国,山东省,潍坊市,坊子区', 3, 'fangzi', '0536', '261200', 'F', '119.16476', '36.65218');
INSERT INTO `dd_region` VALUES (1438, 1434, '奎文', '奎文区', '中国,山东省,潍坊市,奎文区', 3, 'kuiwen', '0536', '261031', 'K', '119.12532', '36.70723');
INSERT INTO `dd_region` VALUES (1439, 1434, '临朐', '临朐县', '中国,山东省,潍坊市,临朐县', 3, 'linqu', '0536', '262600', 'L', '118.544', '36.51216');
INSERT INTO `dd_region` VALUES (1440, 1434, '昌乐', '昌乐县', '中国,山东省,潍坊市,昌乐县', 3, 'changle', '0536', '262400', 'C', '118.83017', '36.7078');
INSERT INTO `dd_region` VALUES (1441, 1434, '青州', '青州市', '中国,山东省,潍坊市,青州市', 3, 'qingzhou', '0536', '262500', 'Q', '118.47915', '36.68505');
INSERT INTO `dd_region` VALUES (1442, 1434, '诸城', '诸城市', '中国,山东省,潍坊市,诸城市', 3, 'zhucheng', '0536', '262200', 'Z', '119.40988', '35.99662');
INSERT INTO `dd_region` VALUES (1443, 1434, '寿光', '寿光市', '中国,山东省,潍坊市,寿光市', 3, 'shouguang', '0536', '262700', 'S', '118.74047', '36.88128');
INSERT INTO `dd_region` VALUES (1444, 1434, '安丘', '安丘市', '中国,山东省,潍坊市,安丘市', 3, 'anqiu', '0536', '262100', 'A', '119.2189', '36.47847');
INSERT INTO `dd_region` VALUES (1445, 1434, '高密', '高密市', '中国,山东省,潍坊市,高密市', 3, 'gaomi', '0536', '261500', 'G', '119.75701', '36.38397');
INSERT INTO `dd_region` VALUES (1446, 1434, '昌邑', '昌邑市', '中国,山东省,潍坊市,昌邑市', 3, 'changyi', '0536', '261300', 'C', '119.39767', '36.86008');
INSERT INTO `dd_region` VALUES (1447, 1375, '济宁', '济宁市', '中国,山东省,济宁市', 2, 'jining', '0537', '272119', 'J', '116.587245', '35.415393');
INSERT INTO `dd_region` VALUES (1448, 1447, '任城', '任城区', '中国,山东省,济宁市,任城区', 3, 'rencheng', '0537', '272113', 'R', '116.59504', '35.40659');
INSERT INTO `dd_region` VALUES (1449, 1447, '兖州', '兖州区', '中国,山东省,济宁市,兖州区', 3, 'yanzhou', '0537', '272000', NULL, '116.826546', '35.552305');
INSERT INTO `dd_region` VALUES (1450, 1447, '微山', '微山县', '中国,山东省,济宁市,微山县', 3, 'weishan', '0537', '277600', 'W', '117.12875', '34.80712');
INSERT INTO `dd_region` VALUES (1451, 1447, '鱼台', '鱼台县', '中国,山东省,济宁市,鱼台县', 3, 'yutai', '0537', '272300', 'Y', '116.64761', '34.99674');
INSERT INTO `dd_region` VALUES (1452, 1447, '金乡', '金乡县', '中国,山东省,济宁市,金乡县', 3, 'jinxiang', '0537', '272200', 'J', '116.31146', '35.065');
INSERT INTO `dd_region` VALUES (1453, 1447, '嘉祥', '嘉祥县', '中国,山东省,济宁市,嘉祥县', 3, 'jiaxiang', '0537', '272400', 'J', '116.34249', '35.40836');
INSERT INTO `dd_region` VALUES (1454, 1447, '汶上', '汶上县', '中国,山东省,济宁市,汶上县', 3, 'wenshang', '0537', '272501', NULL, '116.48742', '35.73295');
INSERT INTO `dd_region` VALUES (1455, 1447, '泗水', '泗水县', '中国,山东省,济宁市,泗水县', 3, 'sishui', '0537', '273200', NULL, '117.27948', '35.66113');
INSERT INTO `dd_region` VALUES (1456, 1447, '梁山', '梁山县', '中国,山东省,济宁市,梁山县', 3, 'liangshan', '0537', '272600', 'L', '116.09683', '35.80322');
INSERT INTO `dd_region` VALUES (1457, 1447, '曲阜', '曲阜市', '中国,山东省,济宁市,曲阜市', 3, 'qufu', '0537', '273100', 'Q', '116.98645', '35.58091');
INSERT INTO `dd_region` VALUES (1458, 1447, '邹城', '邹城市', '中国,山东省,济宁市,邹城市', 3, 'zoucheng', '0537', '273500', 'Z', '116.97335', '35.40531');
INSERT INTO `dd_region` VALUES (1459, 1375, '泰安', '泰安市', '中国,山东省,泰安市', 2, 'tai\'an', '0538', '271000', 'T', '117.129063', '36.194968');
INSERT INTO `dd_region` VALUES (1460, 1459, '泰山', '泰山区', '中国,山东省,泰安市,泰山区', 3, 'taishan', '0538', '271000', 'T', '117.13446', '36.19411');
INSERT INTO `dd_region` VALUES (1461, 1459, '岱岳', '岱岳区', '中国,山东省,泰安市,岱岳区', 3, 'daiyue', '0538', '271000', NULL, '117.04174', '36.1875');
INSERT INTO `dd_region` VALUES (1462, 1459, '宁阳', '宁阳县', '中国,山东省,泰安市,宁阳县', 3, 'ningyang', '0538', '271400', 'N', '116.80542', '35.7599');
INSERT INTO `dd_region` VALUES (1463, 1459, '东平', '东平县', '中国,山东省,泰安市,东平县', 3, 'dongping', '0538', '271500', 'D', '116.47113', '35.93792');
INSERT INTO `dd_region` VALUES (1464, 1459, '新泰', '新泰市', '中国,山东省,泰安市,新泰市', 3, 'xintai', '0538', '271200', 'X', '117.76959', '35.90887');
INSERT INTO `dd_region` VALUES (1465, 1459, '肥城', '肥城市', '中国,山东省,泰安市,肥城市', 3, 'feicheng', '0538', '271600', 'F', '116.76815', '36.18247');
INSERT INTO `dd_region` VALUES (1466, 1375, '威海', '威海市', '中国,山东省,威海市', 2, 'weihai', '0631', '264200', 'W', '122.116394', '37.509691');
INSERT INTO `dd_region` VALUES (1467, 1466, '环翠', '环翠区', '中国,山东省,威海市,环翠区', 3, 'huancui', '0631', '264200', 'H', '122.12344', '37.50199');
INSERT INTO `dd_region` VALUES (1468, 1466, '文登', '文登区', '中国,山东省,威海市,文登区', 3, 'wendeng', '0631', '266440', 'W', '122.057139', '37.196211');
INSERT INTO `dd_region` VALUES (1469, 1466, '荣成', '荣成市', '中国,山东省,威海市,荣成市', 3, 'rongcheng', '0631', '264300', 'R', '122.48773', '37.1652');
INSERT INTO `dd_region` VALUES (1470, 1466, '乳山', '乳山市', '中国,山东省,威海市,乳山市', 3, 'rushan', '0631', '264500', 'R', '121.53814', '36.91918');
INSERT INTO `dd_region` VALUES (1471, 1375, '日照', '日照市', '中国,山东省,日照市', 2, 'rizhao', '0633', '276800', 'R', '119.461208', '35.428588');
INSERT INTO `dd_region` VALUES (1472, 1471, '东港', '东港区', '中国,山东省,日照市,东港区', 3, 'donggang', '0633', '276800', 'D', '119.46237', '35.42541');
INSERT INTO `dd_region` VALUES (1473, 1471, '岚山', '岚山区', '中国,山东省,日照市,岚山区', 3, 'lanshan', '0633', '276808', NULL, '119.31884', '35.12203');
INSERT INTO `dd_region` VALUES (1474, 1471, '五莲', '五莲县', '中国,山东省,日照市,五莲县', 3, 'wulian', '0633', '262300', 'W', '119.207', '35.75004');
INSERT INTO `dd_region` VALUES (1475, 1471, '莒县', '莒县', '中国,山东省,日照市,莒县', 3, 'juxian', '0633', '276500', NULL, '118.83789', '35.58054');
INSERT INTO `dd_region` VALUES (1476, 1375, '莱芜', '莱芜市', '中国,山东省,莱芜市', 2, 'laiwu', '0634', '271100', 'L', '117.677736', '36.214397');
INSERT INTO `dd_region` VALUES (1477, 1476, '莱城', '莱城区', '中国,山东省,莱芜市,莱城区', 3, 'laicheng', '0634', '271199', 'L', '117.65986', '36.2032');
INSERT INTO `dd_region` VALUES (1478, 1476, '钢城', '钢城区', '中国,山东省,莱芜市,钢城区', 3, 'gangcheng', '0634', '271100', 'G', '117.8049', '36.06319');
INSERT INTO `dd_region` VALUES (1479, 1375, '临沂', '临沂市', '中国,山东省,临沂市', 2, 'linyi', '0539', '253000', 'L', '118.326443', '35.065282');
INSERT INTO `dd_region` VALUES (1480, 1479, '兰山', '兰山区', '中国,山东省,临沂市,兰山区', 3, 'lanshan', '0539', '276002', 'L', '118.34817', '35.06872');
INSERT INTO `dd_region` VALUES (1481, 1479, '罗庄', '罗庄区', '中国,山东省,临沂市,罗庄区', 3, 'luozhuang', '0539', '276022', 'L', '118.28466', '34.99627');
INSERT INTO `dd_region` VALUES (1482, 1479, '河东', '河东区', '中国,山东省,临沂市,河东区', 3, 'hedong', '0539', '276034', 'H', '118.41055', '35.08803');
INSERT INTO `dd_region` VALUES (1483, 1479, '沂南', '沂南县', '中国,山东省,临沂市,沂南县', 3, 'yinan', '0539', '276300', 'Y', '118.47061', '35.55131');
INSERT INTO `dd_region` VALUES (1484, 1479, '郯城', '郯城县', '中国,山东省,临沂市,郯城县', 3, 'tancheng', '0539', '276100', NULL, '118.36712', '34.61354');
INSERT INTO `dd_region` VALUES (1485, 1479, '沂水', '沂水县', '中国,山东省,临沂市,沂水县', 3, 'yishui', '0539', '276400', 'Y', '118.63009', '35.78731');
INSERT INTO `dd_region` VALUES (1486, 1479, '兰陵', '兰陵县', '中国,山东省,临沂市,兰陵县', 3, 'lanling', '0539', '277700', 'L', '117.856592', '34.738315');
INSERT INTO `dd_region` VALUES (1487, 1479, '费县', '费县', '中国,山东省,临沂市,费县', 3, 'feixian', '0539', '273400', 'F', '117.97836', '35.26562');
INSERT INTO `dd_region` VALUES (1488, 1479, '平邑', '平邑县', '中国,山东省,临沂市,平邑县', 3, 'pingyi', '0539', '273300', 'P', '117.63867', '35.50573');
INSERT INTO `dd_region` VALUES (1489, 1479, '莒南', '莒南县', '中国,山东省,临沂市,莒南县', 3, 'junan', '0539', '276600', NULL, '118.83227', '35.17539');
INSERT INTO `dd_region` VALUES (1490, 1479, '蒙阴', '蒙阴县', '中国,山东省,临沂市,蒙阴县', 3, 'mengyin', '0539', '276200', 'M', '117.94592', '35.70996');
INSERT INTO `dd_region` VALUES (1491, 1479, '临沭', '临沭县', '中国,山东省,临沂市,临沭县', 3, 'linshu', '0539', '276700', 'L', '118.65267', '34.92091');
INSERT INTO `dd_region` VALUES (1492, 1375, '德州', '德州市', '中国,山东省,德州市', 2, 'dezhou', '0534', '253000', 'D', '116.307428', '37.453968');
INSERT INTO `dd_region` VALUES (1493, 1492, '德城', '德城区', '中国,山东省,德州市,德城区', 3, 'decheng', '0534', '253012', 'D', '116.29943', '37.45126');
INSERT INTO `dd_region` VALUES (1494, 1492, '陵城', '陵城区', '中国,山东省,德州市,陵城区', 3, 'lingcheng', '0534', '253500', 'L', '116.57601', '37.33571');
INSERT INTO `dd_region` VALUES (1495, 1492, '宁津', '宁津县', '中国,山东省,德州市,宁津县', 3, 'ningjin', '0534', '253400', 'N', '116.79702', '37.65301');
INSERT INTO `dd_region` VALUES (1496, 1492, '庆云', '庆云县', '中国,山东省,德州市,庆云县', 3, 'qingyun', '0534', '253700', 'Q', '117.38635', '37.77616');
INSERT INTO `dd_region` VALUES (1497, 1492, '临邑', '临邑县', '中国,山东省,德州市,临邑县', 3, 'linyi', '0534', '251500', 'L', '116.86547', '37.19053');
INSERT INTO `dd_region` VALUES (1498, 1492, '齐河', '齐河县', '中国,山东省,德州市,齐河县', 3, 'qihe', '0534', '251100', 'Q', '116.75515', '36.79532');
INSERT INTO `dd_region` VALUES (1499, 1492, '平原', '平原县', '中国,山东省,德州市,平原县', 3, 'pingyuan', '0534', '253100', 'P', '116.43432', '37.16632');
INSERT INTO `dd_region` VALUES (1500, 1492, '夏津', '夏津县', '中国,山东省,德州市,夏津县', 3, 'xiajin', '0534', '253200', 'X', '116.0017', '36.94852');
INSERT INTO `dd_region` VALUES (1501, 1492, '武城', '武城县', '中国,山东省,德州市,武城县', 3, 'wucheng', '0534', '253300', 'W', '116.07009', '37.21403');
INSERT INTO `dd_region` VALUES (1502, 1492, '乐陵', '乐陵市', '中国,山东省,德州市,乐陵市', 3, 'leling', '0534', '253600', 'L', '117.23141', '37.73164');
INSERT INTO `dd_region` VALUES (1503, 1492, '禹城', '禹城市', '中国,山东省,德州市,禹城市', 3, 'yucheng', '0534', '251200', 'Y', '116.64309', '36.93444');
INSERT INTO `dd_region` VALUES (1504, 1375, '聊城', '聊城市', '中国,山东省,聊城市', 2, 'liaocheng', '0635', '252052', 'L', '115.980367', '36.456013');
INSERT INTO `dd_region` VALUES (1505, 1504, '东昌府', '东昌府区', '中国,山东省,聊城市,东昌府区', 3, 'dongchangfu', '0635', '252000', 'D', '115.97383', '36.44458');
INSERT INTO `dd_region` VALUES (1506, 1504, '阳谷', '阳谷县', '中国,山东省,聊城市,阳谷县', 3, 'yanggu', '0635', '252300', 'Y', '115.79126', '36.11444');
INSERT INTO `dd_region` VALUES (1507, 1504, '莘县', '莘县', '中国,山东省,聊城市,莘县', 3, 'shenxian', '0635', '252400', NULL, '115.6697', '36.23423');
INSERT INTO `dd_region` VALUES (1508, 1504, '茌平', '茌平县', '中国,山东省,聊城市,茌平县', 3, 'chiping', '0635', '252100', NULL, '116.25491', '36.57969');
INSERT INTO `dd_region` VALUES (1509, 1504, '东阿', '东阿县', '中国,山东省,聊城市,东阿县', 3, 'dong\'e', '0635', '252200', 'D', '116.25012', '36.33209');
INSERT INTO `dd_region` VALUES (1510, 1504, '冠县', '冠县', '中国,山东省,聊城市,冠县', 3, 'guanxian', '0635', '252500', 'G', '115.44195', '36.48429');
INSERT INTO `dd_region` VALUES (1511, 1504, '高唐', '高唐县', '中国,山东省,聊城市,高唐县', 3, 'gaotang', '0635', '252800', 'G', '116.23172', '36.86535');
INSERT INTO `dd_region` VALUES (1512, 1504, '临清', '临清市', '中国,山东省,聊城市,临清市', 3, 'linqing', '0635', '252600', 'L', '115.70629', '36.83945');
INSERT INTO `dd_region` VALUES (1513, 1375, '滨州', '滨州市', '中国,山东省,滨州市', 2, 'binzhou', '0543', '256619', 'B', '118.016974', '37.383542');
INSERT INTO `dd_region` VALUES (1514, 1513, '滨城', '滨城区', '中国,山东省,滨州市,滨城区', 3, 'bincheng', '0543', '256613', 'B', '118.02026', '37.38524');
INSERT INTO `dd_region` VALUES (1515, 1513, '沾化', '沾化区', '中国,山东省,滨州市,沾化区', 3, 'zhanhua', '0543', '256800', 'Z', '118.13214', '37.69832');
INSERT INTO `dd_region` VALUES (1516, 1513, '惠民', '惠民县', '中国,山东省,滨州市,惠民县', 3, 'huimin', '0543', '251700', 'H', '117.51113', '37.49013');
INSERT INTO `dd_region` VALUES (1517, 1513, '阳信', '阳信县', '中国,山东省,滨州市,阳信县', 3, 'yangxin', '0543', '251800', 'Y', '117.58139', '37.64198');
INSERT INTO `dd_region` VALUES (1518, 1513, '无棣', '无棣县', '中国,山东省,滨州市,无棣县', 3, 'wudi', '0543', '251900', 'W', '117.61395', '37.74009');
INSERT INTO `dd_region` VALUES (1519, 1513, '博兴', '博兴县', '中国,山东省,滨州市,博兴县', 3, 'boxing', '0543', '256500', 'B', '118.1336', '37.14316');
INSERT INTO `dd_region` VALUES (1520, 1513, '邹平', '邹平县', '中国,山东省,滨州市,邹平县', 3, 'zouping', '0543', '256200', 'Z', '117.74307', '36.86295');
INSERT INTO `dd_region` VALUES (1521, 1513, '北海新区', '北海新区', '中国,山东省,滨州市,北海新区', 3, 'beihaixinqu', '0543', '256200', 'B', '118.016974', '37.383542');
INSERT INTO `dd_region` VALUES (1522, 1375, '菏泽', '菏泽市', '中国,山东省,菏泽市', 2, 'heze', '0530', '274020', 'H', '115.469381', '35.246531');
INSERT INTO `dd_region` VALUES (1523, 1522, '牡丹', '牡丹区', '中国,山东省,菏泽市,牡丹区', 3, 'mudan', '0530', '274009', 'M', '115.41662', '35.25091');
INSERT INTO `dd_region` VALUES (1524, 1522, '曹县', '曹县', '中国,山东省,菏泽市,曹县', 3, 'caoxian', '0530', '274400', 'C', '115.54226', '34.82659');
INSERT INTO `dd_region` VALUES (1525, 1522, '单县', '单县', '中国,山东省,菏泽市,单县', 3, 'shanxian', '0530', '273700', 'D', '116.08703', '34.79514');
INSERT INTO `dd_region` VALUES (1526, 1522, '成武', '成武县', '中国,山东省,菏泽市,成武县', 3, 'chengwu', '0530', '274200', 'C', '115.8897', '34.95332');
INSERT INTO `dd_region` VALUES (1527, 1522, '巨野', '巨野县', '中国,山东省,菏泽市,巨野县', 3, 'juye', '0530', '274900', 'J', '116.09497', '35.39788');
INSERT INTO `dd_region` VALUES (1528, 1522, '郓城', '郓城县', '中国,山东省,菏泽市,郓城县', 3, 'yuncheng', '0530', '274700', NULL, '115.94439', '35.60044');
INSERT INTO `dd_region` VALUES (1529, 1522, '鄄城', '鄄城县', '中国,山东省,菏泽市,鄄城县', 3, 'juancheng', '0530', '274600', NULL, '115.50997', '35.56412');
INSERT INTO `dd_region` VALUES (1530, 1522, '定陶', '定陶县', '中国,山东省,菏泽市,定陶县', 3, 'dingtao', '0530', '274100', 'D', '115.57287', '35.07118');
INSERT INTO `dd_region` VALUES (1531, 1522, '东明', '东明县', '中国,山东省,菏泽市,东明县', 3, 'dongming', '0530', '274500', 'D', '115.09079', '35.28906');
INSERT INTO `dd_region` VALUES (1532, 0, '河南', '河南省', '中国,河南省', 1, 'henan', '', '', 'H', '113.665412', '34.757975');
INSERT INTO `dd_region` VALUES (1533, 1532, '郑州', '郑州市', '中国,河南省,郑州市', 2, 'zhengzhou', '0371', '450000', 'Z', '113.665412', '34.757975');
INSERT INTO `dd_region` VALUES (1534, 1533, '中原', '中原区', '中国,河南省,郑州市,中原区', 3, 'zhongyuan', '0371', '450007', 'Z', '113.61333', '34.74827');
INSERT INTO `dd_region` VALUES (1535, 1533, '二七', '二七区', '中国,河南省,郑州市,二七区', 3, 'erqi', '0371', '450052', 'E', '113.63931', '34.72336');
INSERT INTO `dd_region` VALUES (1536, 1533, '管城', '管城回族区', '中国,河南省,郑州市,管城回族区', 3, 'guancheng', '0371', '450000', 'G', '113.67734', '34.75383');
INSERT INTO `dd_region` VALUES (1537, 1533, '金水', '金水区', '中国,河南省,郑州市,金水区', 3, 'jinshui', '0371', '450003', 'J', '113.66057', '34.80028');
INSERT INTO `dd_region` VALUES (1538, 1533, '上街', '上街区', '中国,河南省,郑州市,上街区', 3, 'shangjie', '0371', '450041', 'S', '113.30897', '34.80276');
INSERT INTO `dd_region` VALUES (1539, 1533, '惠济', '惠济区', '中国,河南省,郑州市,惠济区', 3, 'huiji', '0371', '450053', 'H', '113.61688', '34.86735');
INSERT INTO `dd_region` VALUES (1540, 1533, '中牟', '中牟县', '中国,河南省,郑州市,中牟县', 3, 'zhongmu', '0371', '451450', 'Z', '113.97619', '34.71899');
INSERT INTO `dd_region` VALUES (1541, 1533, '巩义', '巩义市', '中国,河南省,郑州市,巩义市', 3, 'gongyi', '0371', '451200', 'G', '113.022', '34.74794');
INSERT INTO `dd_region` VALUES (1542, 1533, '荥阳', '荥阳市', '中国,河南省,郑州市,荥阳市', 3, 'xingyang', '0371', '450100', NULL, '113.38345', '34.78759');
INSERT INTO `dd_region` VALUES (1543, 1533, '新密', '新密市', '中国,河南省,郑州市,新密市', 3, 'xinmi', '0371', '452300', 'X', '113.3869', '34.53704');
INSERT INTO `dd_region` VALUES (1544, 1533, '新郑', '新郑市', '中国,河南省,郑州市,新郑市', 3, 'xinzheng', '0371', '451100', 'X', '113.73645', '34.3955');
INSERT INTO `dd_region` VALUES (1545, 1533, '登封', '登封市', '中国,河南省,郑州市,登封市', 3, 'dengfeng', '0371', '452470', 'D', '113.05023', '34.45345');
INSERT INTO `dd_region` VALUES (1546, 1532, '开封', '开封市', '中国,河南省,开封市', 2, 'kaifeng', '0378', '475001', 'K', '114.341447', '34.797049');
INSERT INTO `dd_region` VALUES (1547, 1546, '龙亭', '龙亭区', '中国,河南省,开封市,龙亭区', 3, 'longting', '0378', '475100', 'L', '114.35484', '34.79995');
INSERT INTO `dd_region` VALUES (1548, 1546, '顺河', '顺河回族区', '中国,河南省,开封市,顺河回族区', 3, 'shunhe', '0378', '475000', 'S', '114.36123', '34.79586');
INSERT INTO `dd_region` VALUES (1549, 1546, '鼓楼', '鼓楼区', '中国,河南省,开封市,鼓楼区', 3, 'gulou', '0378', '475000', 'G', '114.35559', '34.79517');
INSERT INTO `dd_region` VALUES (1550, 1546, '禹王台', '禹王台区', '中国,河南省,开封市,禹王台区', 3, 'yuwangtai', '0378', '475003', 'Y', '114.34787', '34.77693');
INSERT INTO `dd_region` VALUES (1551, 1546, '祥符', '祥符区', '中国,河南省,开封市,祥符区', 3, 'xiangfu', '0378', '475100', 'X', '114.43859', '34.75874');
INSERT INTO `dd_region` VALUES (1552, 1546, '杞县', '杞县', '中国,河南省,开封市,杞县', 3, 'qixian', '0378', '475200', NULL, '114.7828', '34.55033');
INSERT INTO `dd_region` VALUES (1553, 1546, '通许', '通许县', '中国,河南省,开封市,通许县', 3, 'tongxu', '0378', '475400', 'T', '114.46716', '34.47522');
INSERT INTO `dd_region` VALUES (1554, 1546, '尉氏', '尉氏县', '中国,河南省,开封市,尉氏县', 3, 'weishi', '0378', '475500', 'W', '114.19284', '34.41223');
INSERT INTO `dd_region` VALUES (1555, 1546, '兰考', '兰考县', '中国,河南省,开封市,兰考县', 3, 'lankao', '0378', '475300', 'L', '114.81961', '34.8235');
INSERT INTO `dd_region` VALUES (1556, 1532, '洛阳', '洛阳市', '中国,河南省,洛阳市', 2, 'luoyang', '0379', '471000', 'L', '112.434468', '34.663041');
INSERT INTO `dd_region` VALUES (1557, 1556, '老城', '老城区', '中国,河南省,洛阳市,老城区', 3, 'laocheng', '0379', '471002', 'L', '112.46902', '34.68364');
INSERT INTO `dd_region` VALUES (1558, 1556, '西工', '西工区', '中国,河南省,洛阳市,西工区', 3, 'xigong', '0379', '471000', 'X', '112.4371', '34.67');
INSERT INTO `dd_region` VALUES (1559, 1556, '瀍河', '瀍河回族区', '中国,河南省,洛阳市,瀍河回族区', 3, 'chanhe', '0379', '471002', NULL, '112.50018', '34.67985');
INSERT INTO `dd_region` VALUES (1560, 1556, '涧西', '涧西区', '中国,河南省,洛阳市,涧西区', 3, 'jianxi', '0379', '471003', 'J', '112.39588', '34.65823');
INSERT INTO `dd_region` VALUES (1561, 1556, '吉利', '吉利区', '中国,河南省,洛阳市,吉利区', 3, 'jili', '0379', '471012', 'J', '112.58905', '34.90088');
INSERT INTO `dd_region` VALUES (1562, 1556, '洛龙', '洛龙区', '中国,河南省,洛阳市,洛龙区', 3, 'luolong', '0379', '471000', 'L', '112.46412', '34.61866');
INSERT INTO `dd_region` VALUES (1563, 1556, '孟津', '孟津县', '中国,河南省,洛阳市,孟津县', 3, 'mengjin', '0379', '471100', 'M', '112.44351', '34.826');
INSERT INTO `dd_region` VALUES (1564, 1556, '新安', '新安县', '中国,河南省,洛阳市,新安县', 3, 'xin\'an', '0379', '471800', 'X', '112.13238', '34.72814');
INSERT INTO `dd_region` VALUES (1565, 1556, '栾川', '栾川县', '中国,河南省,洛阳市,栾川县', 3, 'luanchuan', '0379', '471500', NULL, '111.61779', '33.78576');
INSERT INTO `dd_region` VALUES (1566, 1556, '嵩县', '嵩县', '中国,河南省,洛阳市,嵩县', 3, 'songxian', '0379', '471400', NULL, '112.08526', '34.13466');
INSERT INTO `dd_region` VALUES (1567, 1556, '汝阳', '汝阳县', '中国,河南省,洛阳市,汝阳县', 3, 'ruyang', '0379', '471200', 'R', '112.47314', '34.15387');
INSERT INTO `dd_region` VALUES (1568, 1556, '宜阳', '宜阳县', '中国,河南省,洛阳市,宜阳县', 3, 'yiyang', '0379', '471600', 'Y', '112.17907', '34.51523');
INSERT INTO `dd_region` VALUES (1569, 1556, '洛宁', '洛宁县', '中国,河南省,洛阳市,洛宁县', 3, 'luoning', '0379', '471700', 'L', '111.65087', '34.38913');
INSERT INTO `dd_region` VALUES (1570, 1556, '伊川', '伊川县', '中国,河南省,洛阳市,伊川县', 3, 'yichuan', '0379', '471300', 'Y', '112.42947', '34.42205');
INSERT INTO `dd_region` VALUES (1571, 1556, '偃师', '偃师市', '中国,河南省,洛阳市,偃师市', 3, 'yanshi', '0379', '471900', NULL, '112.7922', '34.7281');
INSERT INTO `dd_region` VALUES (1572, 1532, '平顶山', '平顶山市', '中国,河南省,平顶山市', 2, 'pingdingshan', '0375', '467000', 'P', '113.307718', '33.735241');
INSERT INTO `dd_region` VALUES (1573, 1572, '新华', '新华区', '中国,河南省,平顶山市,新华区', 3, 'xinhua', '0375', '467002', 'X', '113.29402', '33.7373');
INSERT INTO `dd_region` VALUES (1574, 1572, '卫东', '卫东区', '中国,河南省,平顶山市,卫东区', 3, 'weidong', '0375', '467021', 'W', '113.33511', '33.73472');
INSERT INTO `dd_region` VALUES (1575, 1572, '石龙', '石龙区', '中国,河南省,平顶山市,石龙区', 3, 'shilong', '0375', '467045', 'S', '112.89879', '33.89878');
INSERT INTO `dd_region` VALUES (1576, 1572, '湛河', '湛河区', '中国,河南省,平顶山市,湛河区', 3, 'zhanhe', '0375', '467000', 'Z', '113.29252', '33.7362');
INSERT INTO `dd_region` VALUES (1577, 1572, '宝丰', '宝丰县', '中国,河南省,平顶山市,宝丰县', 3, 'baofeng', '0375', '467400', 'B', '113.05493', '33.86916');
INSERT INTO `dd_region` VALUES (1578, 1572, '叶县', '叶县', '中国,河南省,平顶山市,叶县', 3, 'yexian', '0375', '467200', 'Y', '113.35104', '33.62225');
INSERT INTO `dd_region` VALUES (1579, 1572, '鲁山', '鲁山县', '中国,河南省,平顶山市,鲁山县', 3, 'lushan', '0375', '467300', 'L', '112.9057', '33.73879');
INSERT INTO `dd_region` VALUES (1580, 1572, '郏县', '郏县', '中国,河南省,平顶山市,郏县', 3, 'jiaxian', '0375', '467100', NULL, '113.21588', '33.97072');
INSERT INTO `dd_region` VALUES (1581, 1572, '舞钢', '舞钢市', '中国,河南省,平顶山市,舞钢市', 3, 'wugang', '0375', '462500', 'W', '113.52417', '33.2938');
INSERT INTO `dd_region` VALUES (1582, 1572, '汝州', '汝州市', '中国,河南省,平顶山市,汝州市', 3, 'ruzhou', '0375', '467500', 'R', '112.84301', '34.16135');
INSERT INTO `dd_region` VALUES (1583, 1532, '安阳', '安阳市', '中国,河南省,安阳市', 2, 'anyang', '0372', '455000', 'A', '114.352482', '36.103442');
INSERT INTO `dd_region` VALUES (1584, 1583, '文峰', '文峰区', '中国,河南省,安阳市,文峰区', 3, 'wenfeng', '0372', '455000', 'W', '114.35708', '36.09046');
INSERT INTO `dd_region` VALUES (1585, 1583, '北关', '北关区', '中国,河南省,安阳市,北关区', 3, 'beiguan', '0372', '455001', 'B', '114.35735', '36.11872');
INSERT INTO `dd_region` VALUES (1586, 1583, '殷都', '殷都区', '中国,河南省,安阳市,殷都区', 3, 'yindu', '0372', '455004', 'Y', '114.3034', '36.1099');
INSERT INTO `dd_region` VALUES (1587, 1583, '龙安', '龙安区', '中国,河南省,安阳市,龙安区', 3, 'long\'an', '0372', '455001', 'L', '114.34814', '36.11904');
INSERT INTO `dd_region` VALUES (1588, 1583, '安阳', '安阳县', '中国,河南省,安阳市,安阳县', 3, 'anyang', '0372', '455000', 'A', '114.36605', '36.06695');
INSERT INTO `dd_region` VALUES (1589, 1583, '汤阴', '汤阴县', '中国,河南省,安阳市,汤阴县', 3, 'tangyin', '0372', '456150', 'T', '114.35839', '35.92152');
INSERT INTO `dd_region` VALUES (1590, 1583, '滑县', '滑县', '中国,河南省,安阳市,滑县', 3, 'huaxian', '0372', '456400', 'H', '114.52066', '35.5807');
INSERT INTO `dd_region` VALUES (1591, 1583, '内黄', '内黄县', '中国,河南省,安阳市,内黄县', 3, 'neihuang', '0372', '456350', 'N', '114.90673', '35.95269');
INSERT INTO `dd_region` VALUES (1592, 1583, '林州', '林州市', '中国,河南省,安阳市,林州市', 3, 'linzhou', '0372', '456550', 'L', '113.81558', '36.07804');
INSERT INTO `dd_region` VALUES (1593, 1532, '鹤壁', '鹤壁市', '中国,河南省,鹤壁市', 2, 'hebi', '0392', '458030', 'H', '114.295444', '35.748236');
INSERT INTO `dd_region` VALUES (1594, 1593, '鹤山', '鹤山区', '中国,河南省,鹤壁市,鹤山区', 3, 'heshan', '0392', '458010', 'H', '114.16336', '35.95458');
INSERT INTO `dd_region` VALUES (1595, 1593, '山城', '山城区', '中国,河南省,鹤壁市,山城区', 3, 'shancheng', '0392', '458000', 'S', '114.18443', '35.89773');
INSERT INTO `dd_region` VALUES (1596, 1593, '淇滨', '淇滨区', '中国,河南省,鹤壁市,淇滨区', 3, 'qibin', '0392', '458000', NULL, '114.29867', '35.74127');
INSERT INTO `dd_region` VALUES (1597, 1593, '浚县', '浚县', '中国,河南省,鹤壁市,浚县', 3, 'xunxian', '0392', '456250', 'J', '114.54879', '35.67085');
INSERT INTO `dd_region` VALUES (1598, 1593, '淇县', '淇县', '中国,河南省,鹤壁市,淇县', 3, 'qixian', '0392', '456750', NULL, '114.1976', '35.60782');
INSERT INTO `dd_region` VALUES (1599, 1532, '新乡', '新乡市', '中国,河南省,新乡市', 2, 'xinxiang', '0373', '453000', 'X', '113.883991', '35.302616');
INSERT INTO `dd_region` VALUES (1600, 1599, '红旗', '红旗区', '中国,河南省,新乡市,红旗区', 3, 'hongqi', '0373', '453000', 'H', '113.87523', '35.30367');
INSERT INTO `dd_region` VALUES (1601, 1599, '卫滨', '卫滨区', '中国,河南省,新乡市,卫滨区', 3, 'weibin', '0373', '453000', 'W', '113.86578', '35.30211');
INSERT INTO `dd_region` VALUES (1602, 1599, '凤泉', '凤泉区', '中国,河南省,新乡市,凤泉区', 3, 'fengquan', '0373', '453011', 'F', '113.91507', '35.38399');
INSERT INTO `dd_region` VALUES (1603, 1599, '牧野', '牧野区', '中国,河南省,新乡市,牧野区', 3, 'muye', '0373', '453002', 'M', '113.9086', '35.3149');
INSERT INTO `dd_region` VALUES (1604, 1599, '新乡', '新乡县', '中国,河南省,新乡市,新乡县', 3, 'xinxiang', '0373', '453700', 'X', '113.80511', '35.19075');
INSERT INTO `dd_region` VALUES (1605, 1599, '获嘉', '获嘉县', '中国,河南省,新乡市,获嘉县', 3, 'huojia', '0373', '453800', 'H', '113.66159', '35.26521');
INSERT INTO `dd_region` VALUES (1606, 1599, '原阳', '原阳县', '中国,河南省,新乡市,原阳县', 3, 'yuanyang', '0373', '453500', 'Y', '113.93994', '35.06565');
INSERT INTO `dd_region` VALUES (1607, 1599, '延津', '延津县', '中国,河南省,新乡市,延津县', 3, 'yanjin', '0373', '453200', 'Y', '114.20266', '35.14327');
INSERT INTO `dd_region` VALUES (1608, 1599, '封丘', '封丘县', '中国,河南省,新乡市,封丘县', 3, 'fengqiu', '0373', '453300', 'F', '114.41915', '35.04166');
INSERT INTO `dd_region` VALUES (1609, 1599, '长垣', '长垣县', '中国,河南省,新乡市,长垣县', 3, 'changyuan', '0373', '453400', 'C', '114.66882', '35.20046');
INSERT INTO `dd_region` VALUES (1610, 1599, '卫辉', '卫辉市', '中国,河南省,新乡市,卫辉市', 3, 'weihui', '0373', '453100', 'W', '114.06454', '35.39843');
INSERT INTO `dd_region` VALUES (1611, 1599, '辉县', '辉县市', '中国,河南省,新乡市,辉县市', 3, 'huixian', '0373', '453600', 'H', '113.8067', '35.46307');
INSERT INTO `dd_region` VALUES (1612, 1532, '焦作', '焦作市', '中国,河南省,焦作市', 2, 'jiaozuo', '0391', '454002', 'J', '113.238266', '35.23904');
INSERT INTO `dd_region` VALUES (1613, 1612, '解放', '解放区', '中国,河南省,焦作市,解放区', 3, 'jiefang', '0391', '454000', 'J', '113.22933', '35.24023');
INSERT INTO `dd_region` VALUES (1614, 1612, '中站', '中站区', '中国,河南省,焦作市,中站区', 3, 'zhongzhan', '0391', '454191', 'Z', '113.18315', '35.23665');
INSERT INTO `dd_region` VALUES (1615, 1612, '马村', '马村区', '中国,河南省,焦作市,马村区', 3, 'macun', '0391', '454171', 'M', '113.3187', '35.26908');
INSERT INTO `dd_region` VALUES (1616, 1612, '山阳', '山阳区', '中国,河南省,焦作市,山阳区', 3, 'shanyang', '0391', '454002', 'S', '113.25464', '35.21436');
INSERT INTO `dd_region` VALUES (1617, 1612, '修武', '修武县', '中国,河南省,焦作市,修武县', 3, 'xiuwu', '0391', '454350', 'X', '113.44775', '35.22357');
INSERT INTO `dd_region` VALUES (1618, 1612, '博爱', '博爱县', '中国,河南省,焦作市,博爱县', 3, 'boai', '0391', '454450', 'B', '113.06698', '35.16943');
INSERT INTO `dd_region` VALUES (1619, 1612, '武陟', '武陟县', '中国,河南省,焦作市,武陟县', 3, 'wuzhi', '0391', '454950', 'W', '113.39718', '35.09505');
INSERT INTO `dd_region` VALUES (1620, 1612, '温县', '温县', '中国,河南省,焦作市,温县', 3, 'wenxian', '0391', '454850', 'W', '113.08065', '34.94022');
INSERT INTO `dd_region` VALUES (1621, 1612, '沁阳', '沁阳市', '中国,河南省,焦作市,沁阳市', 3, 'qinyang', '0391', '454550', 'Q', '112.94494', '35.08935');
INSERT INTO `dd_region` VALUES (1622, 1612, '孟州', '孟州市', '中国,河南省,焦作市,孟州市', 3, 'mengzhou', '0391', '454750', 'M', '112.79138', '34.9071');
INSERT INTO `dd_region` VALUES (1623, 1532, '濮阳', '濮阳市', '中国,河南省,濮阳市', 2, 'puyang', '0393', '457000', NULL, '115.041299', '35.768234');
INSERT INTO `dd_region` VALUES (1624, 1623, '华龙', '华龙区', '中国,河南省,濮阳市,华龙区', 3, 'hualong', '0393', '457001', 'H', '115.07446', '35.77736');
INSERT INTO `dd_region` VALUES (1625, 1623, '清丰', '清丰县', '中国,河南省,濮阳市,清丰县', 3, 'qingfeng', '0393', '457300', 'Q', '115.10415', '35.88507');
INSERT INTO `dd_region` VALUES (1626, 1623, '南乐', '南乐县', '中国,河南省,濮阳市,南乐县', 3, 'nanle', '0393', '457400', 'N', '115.20639', '36.07686');
INSERT INTO `dd_region` VALUES (1627, 1623, '范县', '范县', '中国,河南省,濮阳市,范县', 3, 'fanxian', '0393', '457500', 'F', '115.50405', '35.85178');
INSERT INTO `dd_region` VALUES (1628, 1623, '台前', '台前县', '中国,河南省,濮阳市,台前县', 3, 'taiqian', '0393', '457600', 'T', '115.87158', '35.96923');
INSERT INTO `dd_region` VALUES (1629, 1623, '濮阳', '濮阳县', '中国,河南省,濮阳市,濮阳县', 3, 'puyang', '0393', '457100', NULL, '115.03057', '35.70745');
INSERT INTO `dd_region` VALUES (1630, 1532, '许昌', '许昌市', '中国,河南省,许昌市', 2, 'xuchang', '0374', '461000', 'X', '113.826063', '34.022956');
INSERT INTO `dd_region` VALUES (1631, 1630, '魏都', '魏都区', '中国,河南省,许昌市,魏都区', 3, 'weidu', '0374', '461000', 'W', '113.8227', '34.02544');
INSERT INTO `dd_region` VALUES (1632, 1630, '许昌', '许昌县', '中国,河南省,许昌市,许昌县', 3, 'xuchang', '0374', '461100', 'X', '113.84707', '34.00406');
INSERT INTO `dd_region` VALUES (1633, 1630, '鄢陵', '鄢陵县', '中国,河南省,许昌市,鄢陵县', 3, 'yanling', '0374', '461200', NULL, '114.18795', '34.10317');
INSERT INTO `dd_region` VALUES (1634, 1630, '襄城', '襄城县', '中国,河南省,许昌市,襄城县', 3, 'xiangcheng', '0374', '461700', 'X', '113.48196', '33.84928');
INSERT INTO `dd_region` VALUES (1635, 1630, '禹州', '禹州市', '中国,河南省,许昌市,禹州市', 3, 'yuzhou', '0374', '461670', 'Y', '113.48803', '34.14054');
INSERT INTO `dd_region` VALUES (1636, 1630, '长葛', '长葛市', '中国,河南省,许昌市,长葛市', 3, 'changge', '0374', '461500', 'C', '113.77328', '34.21846');
INSERT INTO `dd_region` VALUES (1637, 1532, '漯河', '漯河市', '中国,河南省,漯河市', 2, 'luohe', '0395', '462000', NULL, '114.026405', '33.575855');
INSERT INTO `dd_region` VALUES (1638, 1637, '源汇', '源汇区', '中国,河南省,漯河市,源汇区', 3, 'yuanhui', '0395', '462000', 'Y', '114.00647', '33.55627');
INSERT INTO `dd_region` VALUES (1639, 1637, '郾城', '郾城区', '中国,河南省,漯河市,郾城区', 3, 'yancheng', '0395', '462300', NULL, '114.00694', '33.58723');
INSERT INTO `dd_region` VALUES (1640, 1637, '召陵', '召陵区', '中国,河南省,漯河市,召陵区', 3, 'zhaoling', '0395', '462300', 'Z', '114.09399', '33.58601');
INSERT INTO `dd_region` VALUES (1641, 1637, '舞阳', '舞阳县', '中国,河南省,漯河市,舞阳县', 3, 'wuyang', '0395', '462400', 'W', '113.59848', '33.43243');
INSERT INTO `dd_region` VALUES (1642, 1637, '临颍', '临颍县', '中国,河南省,漯河市,临颍县', 3, 'linying', '0395', '462600', 'L', '113.93661', '33.81123');
INSERT INTO `dd_region` VALUES (1643, 1532, '三门峡', '三门峡市', '中国,河南省,三门峡市', 2, 'sanmenxia', '0398', '472000', 'S', '111.194099', '34.777338');
INSERT INTO `dd_region` VALUES (1644, 1643, '湖滨', '湖滨区', '中国,河南省,三门峡市,湖滨区', 3, 'hubin', '0398', '472000', 'H', '111.20006', '34.77872');
INSERT INTO `dd_region` VALUES (1645, 1643, '渑池', '渑池县', '中国,河南省,三门峡市,渑池县', 3, 'mianchi', '0398', '472400', NULL, '111.76184', '34.76725');
INSERT INTO `dd_region` VALUES (1646, 1643, '陕县', '陕县', '中国,河南省,三门峡市,陕县', 3, 'shanxian', '0398', '472100', 'S', '111.10333', '34.72052');
INSERT INTO `dd_region` VALUES (1647, 1643, '卢氏', '卢氏县', '中国,河南省,三门峡市,卢氏县', 3, 'lushi', '0398', '472200', 'L', '111.04782', '34.05436');
INSERT INTO `dd_region` VALUES (1648, 1643, '义马', '义马市', '中国,河南省,三门峡市,义马市', 3, 'yima', '0398', '472300', 'Y', '111.87445', '34.74721');
INSERT INTO `dd_region` VALUES (1649, 1643, '灵宝', '灵宝市', '中国,河南省,三门峡市,灵宝市', 3, 'lingbao', '0398', '472500', 'L', '110.8945', '34.51682');
INSERT INTO `dd_region` VALUES (1650, 1532, '南阳', '南阳市', '中国,河南省,南阳市', 2, 'nanyang', '0377', '473002', 'N', '112.540918', '32.999082');
INSERT INTO `dd_region` VALUES (1651, 1650, '宛城', '宛城区', '中国,河南省,南阳市,宛城区', 3, 'wancheng', '0377', '473001', 'W', '112.53955', '33.00378');
INSERT INTO `dd_region` VALUES (1652, 1650, '卧龙', '卧龙区', '中国,河南省,南阳市,卧龙区', 3, 'wolong', '0377', '473003', 'W', '112.53479', '32.98615');
INSERT INTO `dd_region` VALUES (1653, 1650, '南召', '南召县', '中国,河南省,南阳市,南召县', 3, 'nanzhao', '0377', '474650', 'N', '112.43194', '33.49098');
INSERT INTO `dd_region` VALUES (1654, 1650, '方城', '方城县', '中国,河南省,南阳市,方城县', 3, 'fangcheng', '0377', '473200', 'F', '113.01269', '33.25453');
INSERT INTO `dd_region` VALUES (1655, 1650, '西峡', '西峡县', '中国,河南省,南阳市,西峡县', 3, 'xixia', '0377', '474550', 'X', '111.48187', '33.29772');
INSERT INTO `dd_region` VALUES (1656, 1650, '镇平', '镇平县', '中国,河南省,南阳市,镇平县', 3, 'zhenping', '0377', '474250', 'Z', '112.2398', '33.03629');
INSERT INTO `dd_region` VALUES (1657, 1650, '内乡', '内乡县', '中国,河南省,南阳市,内乡县', 3, 'neixiang', '0377', '474350', 'N', '111.84957', '33.04671');
INSERT INTO `dd_region` VALUES (1658, 1650, '淅川', '淅川县', '中国,河南省,南阳市,淅川县', 3, 'xichuan', '0377', '474450', NULL, '111.48663', '33.13708');
INSERT INTO `dd_region` VALUES (1659, 1650, '社旗', '社旗县', '中国,河南省,南阳市,社旗县', 3, 'sheqi', '0377', '473300', 'S', '112.94656', '33.05503');
INSERT INTO `dd_region` VALUES (1660, 1650, '唐河', '唐河县', '中国,河南省,南阳市,唐河县', 3, 'tanghe', '0377', '473400', 'T', '112.83609', '32.69453');
INSERT INTO `dd_region` VALUES (1661, 1650, '新野', '新野县', '中国,河南省,南阳市,新野县', 3, 'xinye', '0377', '473500', 'X', '112.36151', '32.51698');
INSERT INTO `dd_region` VALUES (1662, 1650, '桐柏', '桐柏县', '中国,河南省,南阳市,桐柏县', 3, 'tongbai', '0377', '474750', 'T', '113.42886', '32.37917');
INSERT INTO `dd_region` VALUES (1663, 1650, '邓州', '邓州市', '中国,河南省,南阳市,邓州市', 3, 'dengzhou', '0377', '474150', 'D', '112.0896', '32.68577');
INSERT INTO `dd_region` VALUES (1664, 1532, '商丘', '商丘市', '中国,河南省,商丘市', 2, 'shangqiu', '0370', '476000', 'S', '115.650497', '34.437054');
INSERT INTO `dd_region` VALUES (1665, 1664, '梁园', '梁园区', '中国,河南省,商丘市,梁园区', 3, 'liangyuan', '0370', '476000', 'L', '115.64487', '34.44341');
INSERT INTO `dd_region` VALUES (1666, 1664, '睢阳', '睢阳区', '中国,河南省,商丘市,睢阳区', 3, 'suiyang', '0370', '476100', NULL, '115.65338', '34.38804');
INSERT INTO `dd_region` VALUES (1667, 1664, '民权', '民权县', '中国,河南省,商丘市,民权县', 3, 'minquan', '0370', '476800', 'M', '115.14621', '34.64931');
INSERT INTO `dd_region` VALUES (1668, 1664, '睢县', '睢县', '中国,河南省,商丘市,睢县', 3, 'suixian', '0370', '476900', NULL, '115.07168', '34.44539');
INSERT INTO `dd_region` VALUES (1669, 1664, '宁陵', '宁陵县', '中国,河南省,商丘市,宁陵县', 3, 'ningling', '0370', '476700', 'N', '115.30511', '34.45463');
INSERT INTO `dd_region` VALUES (1670, 1664, '柘城', '柘城县', '中国,河南省,商丘市,柘城县', 3, 'zhecheng', '0370', '476200', NULL, '115.30538', '34.0911');
INSERT INTO `dd_region` VALUES (1671, 1664, '虞城', '虞城县', '中国,河南省,商丘市,虞城县', 3, 'yucheng', '0370', '476300', 'Y', '115.86337', '34.40189');
INSERT INTO `dd_region` VALUES (1672, 1664, '夏邑', '夏邑县', '中国,河南省,商丘市,夏邑县', 3, 'xiayi', '0370', '476400', 'X', '116.13348', '34.23242');
INSERT INTO `dd_region` VALUES (1673, 1664, '永城', '永城市', '中国,河南省,商丘市,永城市', 3, 'yongcheng', '0370', '476600', 'Y', '116.44943', '33.92911');
INSERT INTO `dd_region` VALUES (1674, 1532, '信阳', '信阳市', '中国,河南省,信阳市', 2, 'xinyang', '0376', '464000', 'X', '114.075031', '32.123274');
INSERT INTO `dd_region` VALUES (1675, 1674, '浉河', '浉河区', '中国,河南省,信阳市,浉河区', 3, 'shihe', '0376', '464000', NULL, '114.05871', '32.1168');
INSERT INTO `dd_region` VALUES (1676, 1674, '平桥', '平桥区', '中国,河南省,信阳市,平桥区', 3, 'pingqiao', '0376', '464100', 'P', '114.12435', '32.10095');
INSERT INTO `dd_region` VALUES (1677, 1674, '罗山', '罗山县', '中国,河南省,信阳市,罗山县', 3, 'luoshan', '0376', '464200', 'L', '114.5314', '32.20277');
INSERT INTO `dd_region` VALUES (1678, 1674, '光山', '光山县', '中国,河南省,信阳市,光山县', 3, 'guangshan', '0376', '465450', 'G', '114.91873', '32.00992');
INSERT INTO `dd_region` VALUES (1679, 1674, '新县', '新县', '中国,河南省,信阳市,新县', 3, 'xinxian', '0376', '465550', 'X', '114.87924', '31.64386');
INSERT INTO `dd_region` VALUES (1680, 1674, '商城', '商城县', '中国,河南省,信阳市,商城县', 3, 'shangcheng', '0376', '465350', 'S', '115.40856', '31.79986');
INSERT INTO `dd_region` VALUES (1681, 1674, '固始', '固始县', '中国,河南省,信阳市,固始县', 3, 'gushi', '0376', '465250', 'G', '115.68298', '32.18011');
INSERT INTO `dd_region` VALUES (1682, 1674, '潢川', '潢川县', '中国,河南省,信阳市,潢川县', 3, 'huangchuan', '0376', '465150', NULL, '115.04696', '32.13763');
INSERT INTO `dd_region` VALUES (1683, 1674, '淮滨', '淮滨县', '中国,河南省,信阳市,淮滨县', 3, 'huaibin', '0376', '464400', 'H', '115.4205', '32.46614');
INSERT INTO `dd_region` VALUES (1684, 1674, '息县', '息县', '中国,河南省,信阳市,息县', 3, 'xixian', '0376', '464300', 'X', '114.7402', '32.34279');
INSERT INTO `dd_region` VALUES (1685, 1532, '周口', '周口市', '中国,河南省,周口市', 2, 'zhoukou', '0394', '466000', 'Z', '114.649653', '33.620357');
INSERT INTO `dd_region` VALUES (1686, 1685, '川汇', '川汇区', '中国,河南省,周口市,川汇区', 3, 'chuanhui', '0394', '466000', 'C', '114.64202', '33.6256');
INSERT INTO `dd_region` VALUES (1687, 1685, '扶沟', '扶沟县', '中国,河南省,周口市,扶沟县', 3, 'fugou', '0394', '461300', 'F', '114.39477', '34.05999');
INSERT INTO `dd_region` VALUES (1688, 1685, '西华', '西华县', '中国,河南省,周口市,西华县', 3, 'xihua', '0394', '466600', 'X', '114.52279', '33.78548');
INSERT INTO `dd_region` VALUES (1689, 1685, '商水', '商水县', '中国,河南省,周口市,商水县', 3, 'shangshui', '0394', '466100', 'S', '114.60604', '33.53912');
INSERT INTO `dd_region` VALUES (1690, 1685, '沈丘', '沈丘县', '中国,河南省,周口市,沈丘县', 3, 'shenqiu', '0394', '466300', 'S', '115.09851', '33.40936');
INSERT INTO `dd_region` VALUES (1691, 1685, '郸城', '郸城县', '中国,河南省,周口市,郸城县', 3, 'dancheng', '0394', '477150', 'D', '115.17715', '33.64485');
INSERT INTO `dd_region` VALUES (1692, 1685, '淮阳', '淮阳县', '中国,河南省,周口市,淮阳县', 3, 'huaiyang', '0394', '466700', 'H', '114.88848', '33.73211');
INSERT INTO `dd_region` VALUES (1693, 1685, '太康', '太康县', '中国,河南省,周口市,太康县', 3, 'taikang', '0394', '461400', 'T', '114.83773', '34.06376');
INSERT INTO `dd_region` VALUES (1694, 1685, '鹿邑', '鹿邑县', '中国,河南省,周口市,鹿邑县', 3, 'luyi', '0394', '477200', 'L', '115.48553', '33.85931');
INSERT INTO `dd_region` VALUES (1695, 1685, '项城', '项城市', '中国,河南省,周口市,项城市', 3, 'xiangcheng', '0394', '466200', 'X', '114.87558', '33.4672');
INSERT INTO `dd_region` VALUES (1696, 1532, '驻马店', '驻马店市', '中国,河南省,驻马店市', 2, 'zhumadian', '0396', '463000', 'Z', '114.024736', '32.980169');
INSERT INTO `dd_region` VALUES (1697, 1696, '驿城', '驿城区', '中国,河南省,驻马店市,驿城区', 3, 'yicheng', '0396', '463000', NULL, '113.99377', '32.97316');
INSERT INTO `dd_region` VALUES (1698, 1696, '西平', '西平县', '中国,河南省,驻马店市,西平县', 3, 'xiping', '0396', '463900', 'X', '114.02322', '33.3845');
INSERT INTO `dd_region` VALUES (1699, 1696, '上蔡', '上蔡县', '中国,河南省,驻马店市,上蔡县', 3, 'shangcai', '0396', '463800', 'S', '114.26825', '33.26825');
INSERT INTO `dd_region` VALUES (1700, 1696, '平舆', '平舆县', '中国,河南省,驻马店市,平舆县', 3, 'pingyu', '0396', '463400', 'P', '114.63552', '32.95727');
INSERT INTO `dd_region` VALUES (1701, 1696, '正阳', '正阳县', '中国,河南省,驻马店市,正阳县', 3, 'zhengyang', '0396', '463600', 'Z', '114.38952', '32.6039');
INSERT INTO `dd_region` VALUES (1702, 1696, '确山', '确山县', '中国,河南省,驻马店市,确山县', 3, 'queshan', '0396', '463200', 'Q', '114.02917', '32.80281');
INSERT INTO `dd_region` VALUES (1703, 1696, '泌阳', '泌阳县', '中国,河南省,驻马店市,泌阳县', 3, 'biyang', '0396', '463700', 'M', '113.32681', '32.71781');
INSERT INTO `dd_region` VALUES (1704, 1696, '汝南', '汝南县', '中国,河南省,驻马店市,汝南县', 3, 'runan', '0396', '463300', 'R', '114.36138', '33.00461');
INSERT INTO `dd_region` VALUES (1705, 1696, '遂平', '遂平县', '中国,河南省,驻马店市,遂平县', 3, 'suiping', '0396', '463100', 'S', '114.01297', '33.14571');
INSERT INTO `dd_region` VALUES (1706, 1696, '新蔡', '新蔡县', '中国,河南省,驻马店市,新蔡县', 3, 'xincai', '0396', '463500', 'X', '114.98199', '32.7502');
INSERT INTO `dd_region` VALUES (1707, 1532, ' ', '直辖县级', '中国,河南省,直辖县级', 2, '', '', '', 'Z', '113.665412', '34.757975');
INSERT INTO `dd_region` VALUES (1708, 1707, '济源', '济源市', '中国,河南省,直辖县级,济源市', 3, 'jiyuan', '0391', '454650', 'J', '112.590047', '35.090378');
INSERT INTO `dd_region` VALUES (1709, 0, '湖北', '湖北省', '中国,湖北省', 1, 'hubei', '', '', 'H', '114.298572', '30.584355');
INSERT INTO `dd_region` VALUES (1710, 1709, '武汉', '武汉市', '中国,湖北省,武汉市', 2, 'wuhan', '', '430014', 'W', '114.298572', '30.584355');
INSERT INTO `dd_region` VALUES (1711, 1710, '江岸', '江岸区', '中国,湖北省,武汉市,江岸区', 3, 'jiang\'an', '027', '430014', 'J', '114.30943', '30.59982');
INSERT INTO `dd_region` VALUES (1712, 1710, '江汉', '江汉区', '中国,湖北省,武汉市,江汉区', 3, 'jianghan', '027', '430021', 'J', '114.27093', '30.60146');
INSERT INTO `dd_region` VALUES (1713, 1710, '硚口', '硚口区', '中国,湖北省,武汉市,硚口区', 3, 'qiaokou', '027', '430033', NULL, '114.26422', '30.56945');
INSERT INTO `dd_region` VALUES (1714, 1710, '汉阳', '汉阳区', '中国,湖北省,武汉市,汉阳区', 3, 'hanyang', '027', '430050', 'H', '114.27478', '30.54915');
INSERT INTO `dd_region` VALUES (1715, 1710, '武昌', '武昌区', '中国,湖北省,武汉市,武昌区', 3, 'wuchang', '027', '430061', 'W', '114.31589', '30.55389');
INSERT INTO `dd_region` VALUES (1716, 1710, '青山', '青山区', '中国,湖北省,武汉市,青山区', 3, 'qingshan', '027', '430080', 'Q', '114.39117', '30.63427');
INSERT INTO `dd_region` VALUES (1717, 1710, '洪山', '洪山区', '中国,湖北省,武汉市,洪山区', 3, 'hongshan', '027', '430070', 'H', '114.34375', '30.49989');
INSERT INTO `dd_region` VALUES (1718, 1710, '东西湖', '东西湖区', '中国,湖北省,武汉市,东西湖区', 3, 'dongxihu', '027', '430040', 'D', '114.13708', '30.61989');
INSERT INTO `dd_region` VALUES (1719, 1710, '汉南', '汉南区', '中国,湖北省,武汉市,汉南区', 3, 'hannan', '027', '430090', 'H', '114.08462', '30.30879');
INSERT INTO `dd_region` VALUES (1720, 1710, '蔡甸', '蔡甸区', '中国,湖北省,武汉市,蔡甸区', 3, 'caidian', '027', '430100', 'C', '114.02929', '30.58197');
INSERT INTO `dd_region` VALUES (1721, 1710, '江夏', '江夏区', '中国,湖北省,武汉市,江夏区', 3, 'jiangxia', '027', '430200', 'J', '114.31301', '30.34653');
INSERT INTO `dd_region` VALUES (1722, 1710, '黄陂', '黄陂区', '中国,湖北省,武汉市,黄陂区', 3, 'huangpi', '027', '432200', 'H', '114.37512', '30.88151');
INSERT INTO `dd_region` VALUES (1723, 1710, '新洲', '新洲区', '中国,湖北省,武汉市,新洲区', 3, 'xinzhou', '027', '431400', 'X', '114.80136', '30.84145');
INSERT INTO `dd_region` VALUES (1724, 1709, '黄石', '黄石市', '中国,湖北省,黄石市', 2, 'huangshi', '0714', '435003', 'H', '115.077048', '30.220074');
INSERT INTO `dd_region` VALUES (1725, 1724, '黄石港', '黄石港区', '中国,湖北省,黄石市,黄石港区', 3, 'huangshigang', '0714', '435000', 'H', '115.06604', '30.22279');
INSERT INTO `dd_region` VALUES (1726, 1724, '西塞山', '西塞山区', '中国,湖北省,黄石市,西塞山区', 3, 'xisaishan', '0714', '435001', 'X', '115.11016', '30.20487');
INSERT INTO `dd_region` VALUES (1727, 1724, '下陆', '下陆区', '中国,湖北省,黄石市,下陆区', 3, 'xialu', '0714', '435005', 'X', '114.96112', '30.17368');
INSERT INTO `dd_region` VALUES (1728, 1724, '铁山', '铁山区', '中国,湖北省,黄石市,铁山区', 3, 'tieshan', '0714', '435006', 'T', '114.90109', '30.20678');
INSERT INTO `dd_region` VALUES (1729, 1724, '阳新', '阳新县', '中国,湖北省,黄石市,阳新县', 3, 'yangxin', '0714', '435200', 'Y', '115.21527', '29.83038');
INSERT INTO `dd_region` VALUES (1730, 1724, '大冶', '大冶市', '中国,湖北省,黄石市,大冶市', 3, 'daye', '0714', '435100', 'D', '114.97174', '30.09438');
INSERT INTO `dd_region` VALUES (1731, 1709, '十堰', '十堰市', '中国,湖北省,十堰市', 2, 'shiyan', '0719', '442000', 'S', '110.785239', '32.647017');
INSERT INTO `dd_region` VALUES (1732, 1731, '茅箭', '茅箭区', '中国,湖北省,十堰市,茅箭区', 3, 'maojian', '0719', '442012', 'M', '110.81341', '32.59153');
INSERT INTO `dd_region` VALUES (1733, 1731, '张湾', '张湾区', '中国,湖北省,十堰市,张湾区', 3, 'zhangwan', '0719', '442001', 'Z', '110.77067', '32.65195');
INSERT INTO `dd_region` VALUES (1734, 1731, '郧阳', '郧阳区', '中国,湖北省,十堰市,郧阳区', 3, 'yunyang', '0719', '442500', 'Y', '110.81854', '32.83593');
INSERT INTO `dd_region` VALUES (1735, 1731, '郧西', '郧西县', '中国,湖北省,十堰市,郧西县', 3, 'yunxi', '0719', '442600', 'Y', '110.42556', '32.99349');
INSERT INTO `dd_region` VALUES (1736, 1731, '竹山', '竹山县', '中国,湖北省,十堰市,竹山县', 3, 'zhushan', '0719', '442200', 'Z', '110.23071', '32.22536');
INSERT INTO `dd_region` VALUES (1737, 1731, '竹溪', '竹溪县', '中国,湖北省,十堰市,竹溪县', 3, 'zhuxi', '0719', '442300', 'Z', '109.71798', '32.31901');
INSERT INTO `dd_region` VALUES (1738, 1731, '房县', '房县', '中国,湖北省,十堰市,房县', 3, 'fangxian', '0719', '442100', 'F', '110.74386', '32.05794');
INSERT INTO `dd_region` VALUES (1739, 1731, '丹江口', '丹江口市', '中国,湖北省,十堰市,丹江口市', 3, 'danjiangkou', '0719', '442700', 'D', '111.51525', '32.54085');
INSERT INTO `dd_region` VALUES (1740, 1709, '宜昌', '宜昌市', '中国,湖北省,宜昌市', 2, 'yichang', '0717', '443000', 'Y', '111.290843', '30.702636');
INSERT INTO `dd_region` VALUES (1741, 1740, '西陵', '西陵区', '中国,湖北省,宜昌市,西陵区', 3, 'xiling', '0717', '443000', 'X', '111.28573', '30.71077');
INSERT INTO `dd_region` VALUES (1742, 1740, '伍家岗', '伍家岗区', '中国,湖北省,宜昌市,伍家岗区', 3, 'wujiagang', '0717', '443001', 'W', '111.3609', '30.64434');
INSERT INTO `dd_region` VALUES (1743, 1740, '点军', '点军区', '中国,湖北省,宜昌市,点军区', 3, 'dianjun', '0717', '443006', 'D', '111.26828', '30.6934');
INSERT INTO `dd_region` VALUES (1744, 1740, '猇亭', '猇亭区', '中国,湖北省,宜昌市,猇亭区', 3, 'xiaoting', '0717', '443007', NULL, '111.44079', '30.52663');
INSERT INTO `dd_region` VALUES (1745, 1740, '夷陵', '夷陵区', '中国,湖北省,宜昌市,夷陵区', 3, 'yiling', '0717', '443100', 'Y', '111.3262', '30.76881');
INSERT INTO `dd_region` VALUES (1746, 1740, '远安', '远安县', '中国,湖北省,宜昌市,远安县', 3, 'yuan\'an', '0717', '444200', 'Y', '111.6416', '31.05989');
INSERT INTO `dd_region` VALUES (1747, 1740, '兴山', '兴山县', '中国,湖北省,宜昌市,兴山县', 3, 'xingshan', '0717', '443711', 'X', '110.74951', '31.34686');
INSERT INTO `dd_region` VALUES (1748, 1740, '秭归', '秭归县', '中国,湖北省,宜昌市,秭归县', 3, 'zigui', '0717', '443600', NULL, '110.98156', '30.82702');
INSERT INTO `dd_region` VALUES (1749, 1740, '长阳', '长阳土家族自治县', '中国,湖北省,宜昌市,长阳土家族自治县', 3, 'changyang', '0717', '443500', 'C', '111.20105', '30.47052');
INSERT INTO `dd_region` VALUES (1750, 1740, '五峰', '五峰土家族自治县', '中国,湖北省,宜昌市,五峰土家族自治县', 3, 'wufeng', '0717', '443413', 'W', '110.6748', '30.19856');
INSERT INTO `dd_region` VALUES (1751, 1740, '宜都', '宜都市', '中国,湖北省,宜昌市,宜都市', 3, 'yidu', '0717', '443300', 'Y', '111.45025', '30.37807');
INSERT INTO `dd_region` VALUES (1752, 1740, '当阳', '当阳市', '中国,湖北省,宜昌市,当阳市', 3, 'dangyang', '0717', '444100', 'D', '111.78912', '30.8208');
INSERT INTO `dd_region` VALUES (1753, 1740, '枝江', '枝江市', '中国,湖北省,宜昌市,枝江市', 3, 'zhijiang', '0717', '443200', 'Z', '111.76855', '30.42612');
INSERT INTO `dd_region` VALUES (1754, 1709, '襄阳', '襄阳市', '中国,湖北省,襄阳市', 2, 'xiangyang', '0710', '441021', 'X', '112.144146', '32.042426');
INSERT INTO `dd_region` VALUES (1755, 1754, '襄城', '襄城区', '中国,湖北省,襄阳市,襄城区', 3, 'xiangcheng', '0710', '441021', 'X', '112.13372', '32.01017');
INSERT INTO `dd_region` VALUES (1756, 1754, '樊城', '樊城区', '中国,湖北省,襄阳市,樊城区', 3, 'fancheng', '0710', '441001', 'F', '112.13546', '32.04482');
INSERT INTO `dd_region` VALUES (1757, 1754, '襄州', '襄州区', '中国,湖北省,襄阳市,襄州区', 3, 'xiangzhou', '0710', '441100', 'X', '112.150327', '32.015088');
INSERT INTO `dd_region` VALUES (1758, 1754, '南漳', '南漳县', '中国,湖北省,襄阳市,南漳县', 3, 'nanzhang', '0710', '441500', 'N', '111.84603', '31.77653');
INSERT INTO `dd_region` VALUES (1759, 1754, '谷城', '谷城县', '中国,湖北省,襄阳市,谷城县', 3, 'gucheng', '0710', '441700', 'G', '111.65267', '32.26377');
INSERT INTO `dd_region` VALUES (1760, 1754, '保康', '保康县', '中国,湖北省,襄阳市,保康县', 3, 'baokang', '0710', '441600', 'B', '111.26138', '31.87874');
INSERT INTO `dd_region` VALUES (1761, 1754, '老河口', '老河口市', '中国,湖北省,襄阳市,老河口市', 3, 'laohekou', '0710', '441800', 'L', '111.67117', '32.38476');
INSERT INTO `dd_region` VALUES (1762, 1754, '枣阳', '枣阳市', '中国,湖北省,襄阳市,枣阳市', 3, 'zaoyang', '0710', '441200', 'Z', '112.77444', '32.13142');
INSERT INTO `dd_region` VALUES (1763, 1754, '宜城', '宜城市', '中国,湖北省,襄阳市,宜城市', 3, 'yicheng', '0710', '441400', 'Y', '112.25772', '31.71972');
INSERT INTO `dd_region` VALUES (1764, 1709, '鄂州', '鄂州市', '中国,湖北省,鄂州市', 2, 'ezhou', '0711', '436000', 'E', '114.890593', '30.396536');
INSERT INTO `dd_region` VALUES (1765, 1764, '梁子湖', '梁子湖区', '中国,湖北省,鄂州市,梁子湖区', 3, 'liangzihu', '0711', '436064', 'L', '114.68463', '30.10003');
INSERT INTO `dd_region` VALUES (1766, 1764, '华容', '华容区', '中国,湖北省,鄂州市,华容区', 3, 'huarong', '0711', '436030', 'H', '114.73568', '30.53328');
INSERT INTO `dd_region` VALUES (1767, 1764, '鄂城', '鄂城区', '中国,湖北省,鄂州市,鄂城区', 3, 'echeng', '0711', '436000', 'E', '114.89158', '30.40024');
INSERT INTO `dd_region` VALUES (1768, 1709, '荆门', '荆门市', '中国,湖北省,荆门市', 2, 'jingmen', '0724', '448000', 'J', '112.204251', '31.03542');
INSERT INTO `dd_region` VALUES (1769, 1768, '东宝', '东宝区', '中国,湖北省,荆门市,东宝区', 3, 'dongbao', '0724', '448004', 'D', '112.20147', '31.05192');
INSERT INTO `dd_region` VALUES (1770, 1768, '掇刀', '掇刀区', '中国,湖北省,荆门市,掇刀区', 3, 'duodao', '0724', '448124', 'D', '112.208', '30.97316');
INSERT INTO `dd_region` VALUES (1771, 1768, '京山', '京山县', '中国,湖北省,荆门市,京山县', 3, 'jingshan', '0724', '431800', 'J', '113.11074', '31.0224');
INSERT INTO `dd_region` VALUES (1772, 1768, '沙洋', '沙洋县', '中国,湖北省,荆门市,沙洋县', 3, 'shayang', '0724', '448200', 'S', '112.58853', '30.70916');
INSERT INTO `dd_region` VALUES (1773, 1768, '钟祥', '钟祥市', '中国,湖北省,荆门市,钟祥市', 3, 'zhongxiang', '0724', '431900', 'Z', '112.58932', '31.1678');
INSERT INTO `dd_region` VALUES (1774, 1709, '孝感', '孝感市', '中国,湖北省,孝感市', 2, 'xiaogan', '0712', '432100', 'X', '113.926655', '30.926423');
INSERT INTO `dd_region` VALUES (1775, 1774, '孝南', '孝南区', '中国,湖北省,孝感市,孝南区', 3, 'xiaonan', '0712', '432100', 'X', '113.91111', '30.9168');
INSERT INTO `dd_region` VALUES (1776, 1774, '孝昌', '孝昌县', '中国,湖北省,孝感市,孝昌县', 3, 'xiaochang', '0712', '432900', 'X', '113.99795', '31.25799');
INSERT INTO `dd_region` VALUES (1777, 1774, '大悟', '大悟县', '中国,湖北省,孝感市,大悟县', 3, 'dawu', '0712', '432800', 'D', '114.12564', '31.56176');
INSERT INTO `dd_region` VALUES (1778, 1774, '云梦', '云梦县', '中国,湖北省,孝感市,云梦县', 3, 'yunmeng', '0712', '432500', 'Y', '113.75289', '31.02093');
INSERT INTO `dd_region` VALUES (1779, 1774, '应城', '应城市', '中国,湖北省,孝感市,应城市', 3, 'yingcheng', '0712', '432400', 'Y', '113.57287', '30.92834');
INSERT INTO `dd_region` VALUES (1780, 1774, '安陆', '安陆市', '中国,湖北省,孝感市,安陆市', 3, 'anlu', '0712', '432600', 'A', '113.68557', '31.25693');
INSERT INTO `dd_region` VALUES (1781, 1774, '汉川', '汉川市', '中国,湖北省,孝感市,汉川市', 3, 'hanchuan', '0712', '432300', 'H', '113.83898', '30.66117');
INSERT INTO `dd_region` VALUES (1782, 1709, '荆州', '荆州市', '中国,湖北省,荆州市', 2, 'jingzhou', '0716', '434000', 'J', '112.23813', '30.326857');
INSERT INTO `dd_region` VALUES (1783, 1782, '沙市', '沙市区', '中国,湖北省,荆州市,沙市区', 3, 'shashi', '0716', '434000', 'S', '112.25543', '30.31107');
INSERT INTO `dd_region` VALUES (1784, 1782, '荆州', '荆州区', '中国,湖北省,荆州市,荆州区', 3, 'jingzhou', '0716', '434020', 'J', '112.19006', '30.35264');
INSERT INTO `dd_region` VALUES (1785, 1782, '公安', '公安县', '中国,湖北省,荆州市,公安县', 3, 'gong\'an', '0716', '434300', 'G', '112.23242', '30.05902');
INSERT INTO `dd_region` VALUES (1786, 1782, '监利', '监利县', '中国,湖北省,荆州市,监利县', 3, 'jianli', '0716', '433300', 'J', '112.89462', '29.81494');
INSERT INTO `dd_region` VALUES (1787, 1782, '江陵', '江陵县', '中国,湖北省,荆州市,江陵县', 3, 'jiangling', '0716', '434101', 'J', '112.42468', '30.04174');
INSERT INTO `dd_region` VALUES (1788, 1782, '石首', '石首市', '中国,湖北省,荆州市,石首市', 3, 'shishou', '0716', '434400', 'S', '112.42636', '29.72127');
INSERT INTO `dd_region` VALUES (1789, 1782, '洪湖', '洪湖市', '中国,湖北省,荆州市,洪湖市', 3, 'honghu', '0716', '433200', 'H', '113.47598', '29.827');
INSERT INTO `dd_region` VALUES (1790, 1782, '松滋', '松滋市', '中国,湖北省,荆州市,松滋市', 3, 'songzi', '0716', '434200', 'S', '111.76739', '30.16965');
INSERT INTO `dd_region` VALUES (1791, 1709, '黄冈', '黄冈市', '中国,湖北省,黄冈市', 2, 'huanggang', '0713', '438000', 'H', '114.879365', '30.447711');
INSERT INTO `dd_region` VALUES (1792, 1791, '黄州', '黄州区', '中国,湖北省,黄冈市,黄州区', 3, 'huangzhou', '0713', '438000', 'H', '114.88008', '30.43436');
INSERT INTO `dd_region` VALUES (1793, 1791, '团风', '团风县', '中国,湖北省,黄冈市,团风县', 3, 'tuanfeng', '0713', '438800', 'T', '114.87228', '30.64359');
INSERT INTO `dd_region` VALUES (1794, 1791, '红安', '红安县', '中国,湖北省,黄冈市,红安县', 3, 'hong\'an', '0713', '438401', 'H', '114.6224', '31.28668');
INSERT INTO `dd_region` VALUES (1795, 1791, '罗田', '罗田县', '中国,湖北省,黄冈市,罗田县', 3, 'luotian', '0713', '438600', 'L', '115.39971', '30.78255');
INSERT INTO `dd_region` VALUES (1796, 1791, '英山', '英山县', '中国,湖北省,黄冈市,英山县', 3, 'yingshan', '0713', '438700', 'Y', '115.68142', '30.73516');
INSERT INTO `dd_region` VALUES (1797, 1791, '浠水', '浠水县', '中国,湖北省,黄冈市,浠水县', 3, 'xishui', '0713', '438200', NULL, '115.26913', '30.45265');
INSERT INTO `dd_region` VALUES (1798, 1791, '蕲春', '蕲春县', '中国,湖北省,黄冈市,蕲春县', 3, 'qichun', '0713', '435300', NULL, '115.43615', '30.22613');
INSERT INTO `dd_region` VALUES (1799, 1791, '黄梅', '黄梅县', '中国,湖北省,黄冈市,黄梅县', 3, 'huangmei', '0713', '435500', 'H', '115.94427', '30.07033');
INSERT INTO `dd_region` VALUES (1800, 1791, '麻城', '麻城市', '中国,湖北省,黄冈市,麻城市', 3, 'macheng', '0713', '438300', 'M', '115.00988', '31.17228');
INSERT INTO `dd_region` VALUES (1801, 1791, '武穴', '武穴市', '中国,湖北省,黄冈市,武穴市', 3, 'wuxue', '0713', '435400', 'W', '115.55975', '29.84446');
INSERT INTO `dd_region` VALUES (1802, 1709, '咸宁', '咸宁市', '中国,湖北省,咸宁市', 2, 'xianning', '0715', '437000', 'X', '114.328963', '29.832798');
INSERT INTO `dd_region` VALUES (1803, 1802, '咸安', '咸安区', '中国,湖北省,咸宁市,咸安区', 3, 'xian\'an', '0715', '437000', 'X', '114.29872', '29.8529');
INSERT INTO `dd_region` VALUES (1804, 1802, '嘉鱼', '嘉鱼县', '中国,湖北省,咸宁市,嘉鱼县', 3, 'jiayu', '0715', '437200', 'J', '113.93927', '29.97054');
INSERT INTO `dd_region` VALUES (1805, 1802, '通城', '通城县', '中国,湖北省,咸宁市,通城县', 3, 'tongcheng', '0715', '437400', 'T', '113.81582', '29.24568');
INSERT INTO `dd_region` VALUES (1806, 1802, '崇阳', '崇阳县', '中国,湖北省,咸宁市,崇阳县', 3, 'chongyang', '0715', '437500', 'C', '114.03982', '29.55564');
INSERT INTO `dd_region` VALUES (1807, 1802, '通山', '通山县', '中国,湖北省,咸宁市,通山县', 3, 'tongshan', '0715', '437600', 'T', '114.48239', '29.6063');
INSERT INTO `dd_region` VALUES (1808, 1802, '赤壁', '赤壁市', '中国,湖北省,咸宁市,赤壁市', 3, 'chibi', '0715', '437300', 'C', '113.90039', '29.72454');
INSERT INTO `dd_region` VALUES (1809, 1709, '随州', '随州市', '中国,湖北省,随州市', 2, 'suizhou', '0722', '441300', 'S', '113.37377', '31.717497');
INSERT INTO `dd_region` VALUES (1810, 1809, '曾都', '曾都区', '中国,湖北省,随州市,曾都区', 3, 'zengdu', '0722', '441300', 'Z', '113.37128', '31.71614');
INSERT INTO `dd_region` VALUES (1811, 1809, '随县', '随县', '中国,湖北省,随州市,随县', 3, 'suixian', '0722', '441309', 'S', '113.82663', '31.6179');
INSERT INTO `dd_region` VALUES (1812, 1809, '广水', '广水市', '中国,湖北省,随州市,广水市', 3, 'guangshui', '0722', '432700', 'G', '113.82663', '31.6179');
INSERT INTO `dd_region` VALUES (1813, 1709, '恩施', '恩施土家族苗族自治州', '中国,湖北省,恩施土家族苗族自治州', 2, 'enshi', '0718', '445000', 'E', '109.48699', '30.283114');
INSERT INTO `dd_region` VALUES (1814, 1813, '恩施', '恩施市', '中国,湖北省,恩施土家族苗族自治州,恩施市', 3, 'enshi', '0718', '445000', 'E', '109.47942', '30.29502');
INSERT INTO `dd_region` VALUES (1815, 1813, '利川', '利川市', '中国,湖北省,恩施土家族苗族自治州,利川市', 3, 'lichuan', '0718', '445400', 'L', '108.93591', '30.29117');
INSERT INTO `dd_region` VALUES (1816, 1813, '建始', '建始县', '中国,湖北省,恩施土家族苗族自治州,建始县', 3, 'jianshi', '0718', '445300', 'J', '109.72207', '30.60209');
INSERT INTO `dd_region` VALUES (1817, 1813, '巴东', '巴东县', '中国,湖北省,恩施土家族苗族自治州,巴东县', 3, 'badong', '0718', '444300', 'B', '110.34066', '31.04233');
INSERT INTO `dd_region` VALUES (1818, 1813, '宣恩', '宣恩县', '中国,湖北省,恩施土家族苗族自治州,宣恩县', 3, 'xuanen', '0718', '445500', 'X', '109.49179', '29.98714');
INSERT INTO `dd_region` VALUES (1819, 1813, '咸丰', '咸丰县', '中国,湖北省,恩施土家族苗族自治州,咸丰县', 3, 'xianfeng', '0718', '445600', 'X', '109.152', '29.67983');
INSERT INTO `dd_region` VALUES (1820, 1813, '来凤', '来凤县', '中国,湖北省,恩施土家族苗族自治州,来凤县', 3, 'laifeng', '0718', '445700', 'L', '109.40716', '29.49373');
INSERT INTO `dd_region` VALUES (1821, 1813, '鹤峰', '鹤峰县', '中国,湖北省,恩施土家族苗族自治州,鹤峰县', 3, 'hefeng', '0718', '445800', 'H', '110.03091', '29.89072');
INSERT INTO `dd_region` VALUES (1822, 1709, ' ', '直辖县级', '中国,湖北省,直辖县级', 2, '', '', '', 'Z', '114.298572', '30.584355');
INSERT INTO `dd_region` VALUES (1823, 1822, '仙桃', '仙桃市', '中国,湖北省,直辖县级,仙桃市', 3, 'xiantao', '0728', '433000', 'X', '113.453974', '30.364953');
INSERT INTO `dd_region` VALUES (1824, 1822, '潜江', '潜江市', '中国,湖北省,直辖县级,潜江市', 3, 'qianjiang', '0728', '433100', 'Q', '112.896866', '30.421215');
INSERT INTO `dd_region` VALUES (1825, 1822, '天门', '天门市', '中国,湖北省,直辖县级,天门市', 3, 'tianmen', '0728', '431700', 'T', '113.165862', '30.653061');
INSERT INTO `dd_region` VALUES (1826, 1822, '神农架', '神农架林区', '中国,湖北省,直辖县级,神农架林区', 3, 'shennongjia', '0719', '442400', 'S', '110.671525', '31.744449');
INSERT INTO `dd_region` VALUES (1827, 0, '湖南', '湖南省', '中国,湖南省', 1, 'hunan', '', '', 'H', '112.982279', '28.19409');
INSERT INTO `dd_region` VALUES (1828, 1827, '长沙', '长沙市', '中国,湖南省,长沙市', 2, 'changsha', '0731', '410005', 'C', '112.982279', '28.19409');
INSERT INTO `dd_region` VALUES (1829, 1828, '芙蓉', '芙蓉区', '中国,湖南省,长沙市,芙蓉区', 3, 'furong', '0731', '410011', NULL, '113.03176', '28.1844');
INSERT INTO `dd_region` VALUES (1830, 1828, '天心', '天心区', '中国,湖南省,长沙市,天心区', 3, 'tianxin', '0731', '410004', 'T', '112.98991', '28.1127');
INSERT INTO `dd_region` VALUES (1831, 1828, '岳麓', '岳麓区', '中国,湖南省,长沙市,岳麓区', 3, 'yuelu', '0731', '410013', 'Y', '112.93133', '28.2351');
INSERT INTO `dd_region` VALUES (1832, 1828, '开福', '开福区', '中国,湖南省,长沙市,开福区', 3, 'kaifu', '0731', '410008', 'K', '112.98623', '28.25585');
INSERT INTO `dd_region` VALUES (1833, 1828, '雨花', '雨花区', '中国,湖南省,长沙市,雨花区', 3, 'yuhua', '0731', '410011', 'Y', '113.03567', '28.13541');
INSERT INTO `dd_region` VALUES (1834, 1828, '望城', '望城区', '中国,湖南省,长沙市,望城区', 3, 'wangcheng', '0731', '410200', 'W', '112.819549', '28.347458');
INSERT INTO `dd_region` VALUES (1835, 1828, '长沙', '长沙县', '中国,湖南省,长沙市,长沙县', 3, 'changsha', '0731', '410100', 'C', '113.08071', '28.24595');
INSERT INTO `dd_region` VALUES (1836, 1828, '宁乡', '宁乡县', '中国,湖南省,长沙市,宁乡县', 3, 'ningxiang', '0731', '410600', 'N', '112.55749', '28.25358');
INSERT INTO `dd_region` VALUES (1837, 1828, '浏阳', '浏阳市', '中国,湖南省,长沙市,浏阳市', 3, 'liuyang', '0731', '410300', NULL, '113.64312', '28.16375');
INSERT INTO `dd_region` VALUES (1838, 1827, '株洲', '株洲市', '中国,湖南省,株洲市', 2, 'zhuzhou', '0731', '412000', 'Z', '113.151737', '27.835806');
INSERT INTO `dd_region` VALUES (1839, 1838, '荷塘', '荷塘区', '中国,湖南省,株洲市,荷塘区', 3, 'hetang', '0731', '412000', 'H', '113.17315', '27.85569');
INSERT INTO `dd_region` VALUES (1840, 1838, '芦淞', '芦淞区', '中国,湖南省,株洲市,芦淞区', 3, 'lusong', '0731', '412000', 'L', '113.15562', '27.78525');
INSERT INTO `dd_region` VALUES (1841, 1838, '石峰', '石峰区', '中国,湖南省,株洲市,石峰区', 3, 'shifeng', '0731', '412005', 'S', '113.11776', '27.87552');
INSERT INTO `dd_region` VALUES (1842, 1838, '天元', '天元区', '中国,湖南省,株洲市,天元区', 3, 'tianyuan', '0731', '412007', 'T', '113.12335', '27.83103');
INSERT INTO `dd_region` VALUES (1843, 1838, '株洲', '株洲县', '中国,湖南省,株洲市,株洲县', 3, 'zhuzhou', '0731', '412100', 'Z', '113.14428', '27.69826');
INSERT INTO `dd_region` VALUES (1844, 1838, '攸县', '攸县', '中国,湖南省,株洲市,攸县', 3, 'youxian', '0731', '412300', NULL, '113.34365', '27.00352');
INSERT INTO `dd_region` VALUES (1845, 1838, '茶陵', '茶陵县', '中国,湖南省,株洲市,茶陵县', 3, 'chaling', '0731', '412400', 'C', '113.54364', '26.7915');
INSERT INTO `dd_region` VALUES (1846, 1838, '炎陵', '炎陵县', '中国,湖南省,株洲市,炎陵县', 3, 'yanling', '0731', '412500', 'Y', '113.77163', '26.48818');
INSERT INTO `dd_region` VALUES (1847, 1838, '醴陵', '醴陵市', '中国,湖南省,株洲市,醴陵市', 3, 'liling', '0731', '412200', NULL, '113.49704', '27.64615');
INSERT INTO `dd_region` VALUES (1848, 1827, '湘潭', '湘潭市', '中国,湖南省,湘潭市', 2, 'xiangtan', '0731', '411100', 'X', '112.925083', '27.846725');
INSERT INTO `dd_region` VALUES (1849, 1848, '雨湖', '雨湖区', '中国,湖南省,湘潭市,雨湖区', 3, 'yuhu', '0731', '411100', 'Y', '112.90399', '27.86859');
INSERT INTO `dd_region` VALUES (1850, 1848, '岳塘', '岳塘区', '中国,湖南省,湘潭市,岳塘区', 3, 'yuetang', '0731', '411101', 'Y', '112.9606', '27.85784');
INSERT INTO `dd_region` VALUES (1851, 1848, '湘潭', '湘潭县', '中国,湖南省,湘潭市,湘潭县', 3, 'xiangtan', '0731', '411228', 'X', '112.9508', '27.77893');
INSERT INTO `dd_region` VALUES (1852, 1848, '湘乡', '湘乡市', '中国,湖南省,湘潭市,湘乡市', 3, 'xiangxiang', '0731', '411400', 'X', '112.53512', '27.73543');
INSERT INTO `dd_region` VALUES (1853, 1848, '韶山', '韶山市', '中国,湖南省,湘潭市,韶山市', 3, 'shaoshan', '0731', '411300', 'S', '112.52655', '27.91503');
INSERT INTO `dd_region` VALUES (1854, 1827, '衡阳', '衡阳市', '中国,湖南省,衡阳市', 2, 'hengyang', '0734', '421001', 'H', '112.607693', '26.900358');
INSERT INTO `dd_region` VALUES (1855, 1854, '珠晖', '珠晖区', '中国,湖南省,衡阳市,珠晖区', 3, 'zhuhui', '0734', '421002', 'Z', '112.62054', '26.89361');
INSERT INTO `dd_region` VALUES (1856, 1854, '雁峰', '雁峰区', '中国,湖南省,衡阳市,雁峰区', 3, 'yanfeng', '0734', '421001', 'Y', '112.61654', '26.88866');
INSERT INTO `dd_region` VALUES (1857, 1854, '石鼓', '石鼓区', '中国,湖南省,衡阳市,石鼓区', 3, 'shigu', '0734', '421005', 'S', '112.61069', '26.90232');
INSERT INTO `dd_region` VALUES (1858, 1854, '蒸湘', '蒸湘区', '中国,湖南省,衡阳市,蒸湘区', 3, 'zhengxiang', '0734', '421001', 'Z', '112.6033', '26.89651');
INSERT INTO `dd_region` VALUES (1859, 1854, '南岳', '南岳区', '中国,湖南省,衡阳市,南岳区', 3, 'nanyue', '0734', '421900', 'N', '112.7384', '27.23262');
INSERT INTO `dd_region` VALUES (1860, 1854, '衡阳', '衡阳县', '中国,湖南省,衡阳市,衡阳县', 3, 'hengyang', '0734', '421200', 'H', '112.37088', '26.9706');
INSERT INTO `dd_region` VALUES (1861, 1854, '衡南', '衡南县', '中国,湖南省,衡阳市,衡南县', 3, 'hengnan', '0734', '421131', 'H', '112.67788', '26.73828');
INSERT INTO `dd_region` VALUES (1862, 1854, '衡山', '衡山县', '中国,湖南省,衡阳市,衡山县', 3, 'hengshan', '0734', '421300', 'H', '112.86776', '27.23134');
INSERT INTO `dd_region` VALUES (1863, 1854, '衡东', '衡东县', '中国,湖南省,衡阳市,衡东县', 3, 'hengdong', '0734', '421400', 'H', '112.94833', '27.08093');
INSERT INTO `dd_region` VALUES (1864, 1854, '祁东', '祁东县', '中国,湖南省,衡阳市,祁东县', 3, 'qidong', '0734', '421600', 'Q', '112.09039', '26.79964');
INSERT INTO `dd_region` VALUES (1865, 1854, '耒阳', '耒阳市', '中国,湖南省,衡阳市,耒阳市', 3, 'leiyang', '0734', '421800', NULL, '112.85998', '26.42132');
INSERT INTO `dd_region` VALUES (1866, 1854, '常宁', '常宁市', '中国,湖南省,衡阳市,常宁市', 3, 'changning', '0734', '421500', 'C', '112.4009', '26.40692');
INSERT INTO `dd_region` VALUES (1867, 1827, '邵阳', '邵阳市', '中国,湖南省,邵阳市', 2, 'shaoyang', '0739', '422000', 'S', '111.46923', '27.237842');
INSERT INTO `dd_region` VALUES (1868, 1867, '双清', '双清区', '中国,湖南省,邵阳市,双清区', 3, 'shuangqing', '0739', '422001', 'S', '111.49715', '27.23291');
INSERT INTO `dd_region` VALUES (1869, 1867, '大祥', '大祥区', '中国,湖南省,邵阳市,大祥区', 3, 'daxiang', '0739', '422000', 'D', '111.45412', '27.23332');
INSERT INTO `dd_region` VALUES (1870, 1867, '北塔', '北塔区', '中国,湖南省,邵阳市,北塔区', 3, 'beita', '0739', '422007', 'B', '111.45219', '27.24648');
INSERT INTO `dd_region` VALUES (1871, 1867, '邵东', '邵东县', '中国,湖南省,邵阳市,邵东县', 3, 'shaodong', '0739', '422800', 'S', '111.74441', '27.2584');
INSERT INTO `dd_region` VALUES (1872, 1867, '新邵', '新邵县', '中国,湖南省,邵阳市,新邵县', 3, 'xinshao', '0739', '422900', 'X', '111.46066', '27.32169');
INSERT INTO `dd_region` VALUES (1873, 1867, '邵阳', '邵阳县', '中国,湖南省,邵阳市,邵阳县', 3, 'shaoyang', '0739', '422100', 'S', '111.27459', '26.99143');
INSERT INTO `dd_region` VALUES (1874, 1867, '隆回', '隆回县', '中国,湖南省,邵阳市,隆回县', 3, 'longhui', '0739', '422200', 'L', '111.03216', '27.10937');
INSERT INTO `dd_region` VALUES (1875, 1867, '洞口', '洞口县', '中国,湖南省,邵阳市,洞口县', 3, 'dongkou', '0739', '422300', 'D', '110.57388', '27.05462');
INSERT INTO `dd_region` VALUES (1876, 1867, '绥宁', '绥宁县', '中国,湖南省,邵阳市,绥宁县', 3, 'suining', '0739', '422600', 'S', '110.15576', '26.58636');
INSERT INTO `dd_region` VALUES (1877, 1867, '新宁', '新宁县', '中国,湖南省,邵阳市,新宁县', 3, 'xinning', '0739', '422700', 'X', '110.85131', '26.42936');
INSERT INTO `dd_region` VALUES (1878, 1867, '城步', '城步苗族自治县', '中国,湖南省,邵阳市,城步苗族自治县', 3, 'chengbu', '0739', '422500', 'C', '110.3222', '26.39048');
INSERT INTO `dd_region` VALUES (1879, 1867, '武冈', '武冈市', '中国,湖南省,邵阳市,武冈市', 3, 'wugang', '0739', '422400', 'W', '110.63281', '26.72817');
INSERT INTO `dd_region` VALUES (1880, 1827, '岳阳', '岳阳市', '中国,湖南省,岳阳市', 2, 'yueyang', '0730', '414000', 'Y', '113.132855', '29.37029');
INSERT INTO `dd_region` VALUES (1881, 1880, '岳阳楼', '岳阳楼区', '中国,湖南省,岳阳市,岳阳楼区', 3, 'yueyanglou', '0730', '414000', 'Y', '113.12942', '29.3719');
INSERT INTO `dd_region` VALUES (1882, 1880, '云溪', '云溪区', '中国,湖南省,岳阳市,云溪区', 3, 'yunxi', '0730', '414009', 'Y', '113.27713', '29.47357');
INSERT INTO `dd_region` VALUES (1883, 1880, '君山', '君山区', '中国,湖南省,岳阳市,君山区', 3, 'junshan', '0730', '414005', 'J', '113.00439', '29.45941');
INSERT INTO `dd_region` VALUES (1884, 1880, '岳阳', '岳阳县', '中国,湖南省,岳阳市,岳阳县', 3, 'yueyang', '0730', '414100', 'Y', '113.11987', '29.14314');
INSERT INTO `dd_region` VALUES (1885, 1880, '华容', '华容县', '中国,湖南省,岳阳市,华容县', 3, 'huarong', '0730', '414200', 'H', '112.54089', '29.53019');
INSERT INTO `dd_region` VALUES (1886, 1880, '湘阴', '湘阴县', '中国,湖南省,岳阳市,湘阴县', 3, 'xiangyin', '0730', '414600', 'X', '112.90911', '28.68922');
INSERT INTO `dd_region` VALUES (1887, 1880, '平江', '平江县', '中国,湖南省,岳阳市,平江县', 3, 'pingjiang', '0730', '414500', 'P', '113.58105', '28.70664');
INSERT INTO `dd_region` VALUES (1888, 1880, '汨罗', '汨罗市', '中国,湖南省,岳阳市,汨罗市', 3, 'miluo', '0730', '414400', NULL, '113.06707', '28.80631');
INSERT INTO `dd_region` VALUES (1889, 1880, '临湘', '临湘市', '中国,湖南省,岳阳市,临湘市', 3, 'linxiang', '0730', '414300', 'L', '113.4501', '29.47701');
INSERT INTO `dd_region` VALUES (1890, 1827, '常德', '常德市', '中国,湖南省,常德市', 2, 'changde', '0736', '415000', 'C', '111.691347', '29.040225');
INSERT INTO `dd_region` VALUES (1891, 1890, '武陵', '武陵区', '中国,湖南省,常德市,武陵区', 3, 'wuling', '0736', '415000', 'W', '111.69791', '29.02876');
INSERT INTO `dd_region` VALUES (1892, 1890, '鼎城', '鼎城区', '中国,湖南省,常德市,鼎城区', 3, 'dingcheng', '0736', '415101', 'D', '111.68078', '29.01859');
INSERT INTO `dd_region` VALUES (1893, 1890, '安乡', '安乡县', '中国,湖南省,常德市,安乡县', 3, 'anxiang', '0736', '415600', 'A', '112.16732', '29.41326');
INSERT INTO `dd_region` VALUES (1894, 1890, '汉寿', '汉寿县', '中国,湖南省,常德市,汉寿县', 3, 'hanshou', '0736', '415900', 'H', '111.96691', '28.90299');
INSERT INTO `dd_region` VALUES (1895, 1890, '澧县', '澧县', '中国,湖南省,常德市,澧县', 3, 'lixian', '0736', '415500', NULL, '111.75866', '29.63317');
INSERT INTO `dd_region` VALUES (1896, 1890, '临澧', '临澧县', '中国,湖南省,常德市,临澧县', 3, 'linli', '0736', '415200', 'L', '111.65161', '29.44163');
INSERT INTO `dd_region` VALUES (1897, 1890, '桃源', '桃源县', '中国,湖南省,常德市,桃源县', 3, 'taoyuan', '0736', '415700', 'T', '111.48892', '28.90474');
INSERT INTO `dd_region` VALUES (1898, 1890, '石门', '石门县', '中国,湖南省,常德市,石门县', 3, 'shimen', '0736', '415300', 'S', '111.37966', '29.58424');
INSERT INTO `dd_region` VALUES (1899, 1890, '津市', '津市市', '中国,湖南省,常德市,津市市', 3, 'jinshi', '0736', '415400', 'J', '111.87756', '29.60563');
INSERT INTO `dd_region` VALUES (1900, 1827, '张家界', '张家界市', '中国,湖南省,张家界市', 2, 'zhangjiajie', '0744', '427000', 'Z', '110.479921', '29.127401');
INSERT INTO `dd_region` VALUES (1901, 1900, '永定', '永定区', '中国,湖南省,张家界市,永定区', 3, 'yongding', '0744', '427000', 'Y', '110.47464', '29.13387');
INSERT INTO `dd_region` VALUES (1902, 1900, '武陵源', '武陵源区', '中国,湖南省,张家界市,武陵源区', 3, 'wulingyuan', '0744', '427400', 'W', '110.55026', '29.34574');
INSERT INTO `dd_region` VALUES (1903, 1900, '慈利', '慈利县', '中国,湖南省,张家界市,慈利县', 3, 'cili', '0744', '427200', 'C', '111.13946', '29.42989');
INSERT INTO `dd_region` VALUES (1904, 1900, '桑植', '桑植县', '中国,湖南省,张家界市,桑植县', 3, 'sangzhi', '0744', '427100', 'S', '110.16308', '29.39815');
INSERT INTO `dd_region` VALUES (1905, 1827, '益阳', '益阳市', '中国,湖南省,益阳市', 2, 'yiyang', '0737', '413000', 'Y', '112.355042', '28.570066');
INSERT INTO `dd_region` VALUES (1906, 1905, '资阳', '资阳区', '中国,湖南省,益阳市,资阳区', 3, 'ziyang', '0737', '413001', 'Z', '112.32447', '28.59095');
INSERT INTO `dd_region` VALUES (1907, 1905, '赫山', '赫山区', '中国,湖南省,益阳市,赫山区', 3, 'heshan', '0737', '413002', 'H', '112.37265', '28.57425');
INSERT INTO `dd_region` VALUES (1908, 1905, '南县', '南县', '中国,湖南省,益阳市,南县', 3, 'nanxian', '0737', '413200', 'N', '112.3963', '29.36159');
INSERT INTO `dd_region` VALUES (1909, 1905, '桃江', '桃江县', '中国,湖南省,益阳市,桃江县', 3, 'taojiang', '0737', '413400', 'T', '112.1557', '28.51814');
INSERT INTO `dd_region` VALUES (1910, 1905, '安化', '安化县', '中国,湖南省,益阳市,安化县', 3, 'anhua', '0737', '413500', 'A', '111.21298', '28.37424');
INSERT INTO `dd_region` VALUES (1911, 1905, '沅江', '沅江市', '中国,湖南省,益阳市,沅江市', 3, 'yuanjiang', '0737', '413100', NULL, '112.35427', '28.84403');
INSERT INTO `dd_region` VALUES (1912, 1827, '郴州', '郴州市', '中国,湖南省,郴州市', 2, 'chenzhou', '0735', '423000', 'C', '113.032067', '25.793589');
INSERT INTO `dd_region` VALUES (1913, 1912, '北湖', '北湖区', '中国,湖南省,郴州市,北湖区', 3, 'beihu', '0735', '423000', 'B', '113.01103', '25.78405');
INSERT INTO `dd_region` VALUES (1914, 1912, '苏仙', '苏仙区', '中国,湖南省,郴州市,苏仙区', 3, 'suxian', '0735', '423000', 'S', '113.04226', '25.80045');
INSERT INTO `dd_region` VALUES (1915, 1912, '桂阳', '桂阳县', '中国,湖南省,郴州市,桂阳县', 3, 'guiyang', '0735', '424400', 'G', '112.73364', '25.75406');
INSERT INTO `dd_region` VALUES (1916, 1912, '宜章', '宜章县', '中国,湖南省,郴州市,宜章县', 3, 'yizhang', '0735', '424200', 'Y', '112.95147', '25.39931');
INSERT INTO `dd_region` VALUES (1917, 1912, '永兴', '永兴县', '中国,湖南省,郴州市,永兴县', 3, 'yongxing', '0735', '423300', 'Y', '113.11242', '26.12646');
INSERT INTO `dd_region` VALUES (1918, 1912, '嘉禾', '嘉禾县', '中国,湖南省,郴州市,嘉禾县', 3, 'jiahe', '0735', '424500', 'J', '112.36935', '25.58795');
INSERT INTO `dd_region` VALUES (1919, 1912, '临武', '临武县', '中国,湖南省,郴州市,临武县', 3, 'linwu', '0735', '424300', 'L', '112.56369', '25.27602');
INSERT INTO `dd_region` VALUES (1920, 1912, '汝城', '汝城县', '中国,湖南省,郴州市,汝城县', 3, 'rucheng', '0735', '424100', 'R', '113.68582', '25.55204');
INSERT INTO `dd_region` VALUES (1921, 1912, '桂东', '桂东县', '中国,湖南省,郴州市,桂东县', 3, 'guidong', '0735', '423500', 'G', '113.9468', '26.07987');
INSERT INTO `dd_region` VALUES (1922, 1912, '安仁', '安仁县', '中国,湖南省,郴州市,安仁县', 3, 'anren', '0735', '423600', 'A', '113.26944', '26.70931');
INSERT INTO `dd_region` VALUES (1923, 1912, '资兴', '资兴市', '中国,湖南省,郴州市,资兴市', 3, 'zixing', '0735', '423400', 'Z', '113.23724', '25.97668');
INSERT INTO `dd_region` VALUES (1924, 1827, '永州', '永州市', '中国,湖南省,永州市', 2, 'yongzhou', '0746', '425000', 'Y', '111.608019', '26.434516');
INSERT INTO `dd_region` VALUES (1925, 1924, '零陵', '零陵区', '中国,湖南省,永州市,零陵区', 3, 'lingling', '0746', '425100', 'L', '111.62103', '26.22109');
INSERT INTO `dd_region` VALUES (1926, 1924, '冷水滩', '冷水滩区', '中国,湖南省,永州市,冷水滩区', 3, 'lengshuitan', '0746', '425100', 'L', '111.59214', '26.46107');
INSERT INTO `dd_region` VALUES (1927, 1924, '祁阳', '祁阳县', '中国,湖南省,永州市,祁阳县', 3, 'qiyang', '0746', '426100', 'Q', '111.84011', '26.58009');
INSERT INTO `dd_region` VALUES (1928, 1924, '东安', '东安县', '中国,湖南省,永州市,东安县', 3, 'dong\'an', '0746', '425900', 'D', '111.3164', '26.39202');
INSERT INTO `dd_region` VALUES (1929, 1924, '双牌', '双牌县', '中国,湖南省,永州市,双牌县', 3, 'shuangpai', '0746', '425200', 'S', '111.65927', '25.95988');
INSERT INTO `dd_region` VALUES (1930, 1924, '道县', '道县', '中国,湖南省,永州市,道县', 3, 'daoxian', '0746', '425300', 'D', '111.60195', '25.52766');
INSERT INTO `dd_region` VALUES (1931, 1924, '江永', '江永县', '中国,湖南省,永州市,江永县', 3, 'jiangyong', '0746', '425400', 'J', '111.34082', '25.27233');
INSERT INTO `dd_region` VALUES (1932, 1924, '宁远', '宁远县', '中国,湖南省,永州市,宁远县', 3, 'ningyuan', '0746', '425600', 'N', '111.94625', '25.56913');
INSERT INTO `dd_region` VALUES (1933, 1924, '蓝山', '蓝山县', '中国,湖南省,永州市,蓝山县', 3, 'lanshan', '0746', '425800', 'L', '112.19363', '25.36794');
INSERT INTO `dd_region` VALUES (1934, 1924, '新田', '新田县', '中国,湖南省,永州市,新田县', 3, 'xintian', '0746', '425700', 'X', '112.22103', '25.9095');
INSERT INTO `dd_region` VALUES (1935, 1924, '江华', '江华瑶族自治县', '中国,湖南省,永州市,江华瑶族自治县', 3, 'jianghua', '0746', '425500', 'J', '111.58847', '25.1845');
INSERT INTO `dd_region` VALUES (1936, 1827, '怀化', '怀化市', '中国,湖南省,怀化市', 2, 'huaihua', '0745', '418000', 'H', '109.97824', '27.550082');
INSERT INTO `dd_region` VALUES (1937, 1936, '鹤城', '鹤城区', '中国,湖南省,怀化市,鹤城区', 3, 'hecheng', '0745', '418000', 'H', '109.96509', '27.54942');
INSERT INTO `dd_region` VALUES (1938, 1936, '中方', '中方县', '中国,湖南省,怀化市,中方县', 3, 'zhongfang', '0745', '418005', 'Z', '109.94497', '27.43988');
INSERT INTO `dd_region` VALUES (1939, 1936, '沅陵', '沅陵县', '中国,湖南省,怀化市,沅陵县', 3, 'yuanling', '0745', '419600', NULL, '110.39633', '28.45548');
INSERT INTO `dd_region` VALUES (1940, 1936, '辰溪', '辰溪县', '中国,湖南省,怀化市,辰溪县', 3, 'chenxi', '0745', '419500', 'C', '110.18942', '28.00406');
INSERT INTO `dd_region` VALUES (1941, 1936, '溆浦', '溆浦县', '中国,湖南省,怀化市,溆浦县', 3, 'xupu', '0745', '419300', NULL, '110.59384', '27.90836');
INSERT INTO `dd_region` VALUES (1942, 1936, '会同', '会同县', '中国,湖南省,怀化市,会同县', 3, 'huitong', '0745', '418300', 'H', '109.73568', '26.88716');
INSERT INTO `dd_region` VALUES (1943, 1936, '麻阳', '麻阳苗族自治县', '中国,湖南省,怀化市,麻阳苗族自治县', 3, 'mayang', '0745', '419400', 'M', '109.80194', '27.866');
INSERT INTO `dd_region` VALUES (1944, 1936, '新晃', '新晃侗族自治县', '中国,湖南省,怀化市,新晃侗族自治县', 3, 'xinhuang', '0745', '419200', 'X', '109.17166', '27.35937');
INSERT INTO `dd_region` VALUES (1945, 1936, '芷江', '芷江侗族自治县', '中国,湖南省,怀化市,芷江侗族自治县', 3, 'zhijiang', '0745', '419100', NULL, '109.6849', '27.44297');
INSERT INTO `dd_region` VALUES (1946, 1936, '靖州', '靖州苗族侗族自治县', '中国,湖南省,怀化市,靖州苗族侗族自治县', 3, 'jingzhou', '0745', '418400', 'J', '109.69821', '26.57651');
INSERT INTO `dd_region` VALUES (1947, 1936, '通道', '通道侗族自治县', '中国,湖南省,怀化市,通道侗族自治县', 3, 'tongdao', '0745', '418500', 'T', '109.78515', '26.1571');
INSERT INTO `dd_region` VALUES (1948, 1936, '洪江', '洪江市', '中国,湖南省,怀化市,洪江市', 3, 'hongjiang', '0745', '418100', 'H', '109.83651', '27.20922');
INSERT INTO `dd_region` VALUES (1949, 1827, '娄底', '娄底市', '中国,湖南省,娄底市', 2, 'loudi', '0738', '417000', 'L', '112.008497', '27.728136');
INSERT INTO `dd_region` VALUES (1950, 1949, '娄星', '娄星区', '中国,湖南省,娄底市,娄星区', 3, 'louxing', '0738', '417000', 'L', '112.00193', '27.72992');
INSERT INTO `dd_region` VALUES (1951, 1949, '双峰', '双峰县', '中国,湖南省,娄底市,双峰县', 3, 'shuangfeng', '0738', '417700', 'S', '112.19921', '27.45418');
INSERT INTO `dd_region` VALUES (1952, 1949, '新化', '新化县', '中国,湖南省,娄底市,新化县', 3, 'xinhua', '0738', '417600', 'X', '111.32739', '27.7266');
INSERT INTO `dd_region` VALUES (1953, 1949, '冷水江', '冷水江市', '中国,湖南省,娄底市,冷水江市', 3, 'lengshuijiang', '0738', '417500', 'L', '111.43554', '27.68147');
INSERT INTO `dd_region` VALUES (1954, 1949, '涟源', '涟源市', '中国,湖南省,娄底市,涟源市', 3, 'lianyuan', '0738', '417100', 'L', '111.67233', '27.68831');
INSERT INTO `dd_region` VALUES (1955, 1827, '湘西', '湘西土家族苗族自治州', '中国,湖南省,湘西土家族苗族自治州', 2, 'xiangxi', '0743', '416000', 'X', '109.739735', '28.314296');
INSERT INTO `dd_region` VALUES (1956, 1955, '吉首', '吉首市', '中国,湖南省,湘西土家族苗族自治州,吉首市', 3, 'jishou', '0743', '416000', 'J', '109.69799', '28.26247');
INSERT INTO `dd_region` VALUES (1957, 1955, '泸溪', '泸溪县', '中国,湖南省,湘西土家族苗族自治州,泸溪县', 3, 'luxi', '0743', '416100', NULL, '110.21682', '28.2205');
INSERT INTO `dd_region` VALUES (1958, 1955, '凤凰', '凤凰县', '中国,湖南省,湘西土家族苗族自治州,凤凰县', 3, 'fenghuang', '0743', '416200', 'F', '109.60156', '27.94822');
INSERT INTO `dd_region` VALUES (1959, 1955, '花垣', '花垣县', '中国,湖南省,湘西土家族苗族自治州,花垣县', 3, 'huayuan', '0743', '416400', 'H', '109.48217', '28.5721');
INSERT INTO `dd_region` VALUES (1960, 1955, '保靖', '保靖县', '中国,湖南省,湘西土家族苗族自治州,保靖县', 3, 'baojing', '0743', '416500', 'B', '109.66049', '28.69997');
INSERT INTO `dd_region` VALUES (1961, 1955, '古丈', '古丈县', '中国,湖南省,湘西土家族苗族自治州,古丈县', 3, 'guzhang', '0743', '416300', 'G', '109.94812', '28.61944');
INSERT INTO `dd_region` VALUES (1962, 1955, '永顺', '永顺县', '中国,湖南省,湘西土家族苗族自治州,永顺县', 3, 'yongshun', '0743', '416700', 'Y', '109.85266', '29.00103');
INSERT INTO `dd_region` VALUES (1963, 1955, '龙山', '龙山县', '中国,湖南省,湘西土家族苗族自治州,龙山县', 3, 'longshan', '0743', '416800', 'L', '109.4432', '29.45693');
INSERT INTO `dd_region` VALUES (1964, 0, '广东', '广东省', '中国,广东省', 1, 'guangdong', '', '', 'G', '113.280637', '23.125178');
INSERT INTO `dd_region` VALUES (1965, 1964, '广州', '广州市', '中国,广东省,广州市', 2, 'guangzhou', '020', '510032', 'G', '113.280637', '23.125178');
INSERT INTO `dd_region` VALUES (1966, 1965, '荔湾', '荔湾区', '中国,广东省,广州市,荔湾区', 3, 'liwan', '020', '510170', 'L', '113.2442', '23.12592');
INSERT INTO `dd_region` VALUES (1967, 1965, '越秀', '越秀区', '中国,广东省,广州市,越秀区', 3, 'yuexiu', '020', '510030', 'Y', '113.26683', '23.12897');
INSERT INTO `dd_region` VALUES (1968, 1965, '海珠', '海珠区', '中国,广东省,广州市,海珠区', 3, 'haizhu', '020', '510300', 'H', '113.26197', '23.10379');
INSERT INTO `dd_region` VALUES (1969, 1965, '天河', '天河区', '中国,广东省,广州市,天河区', 3, 'tianhe', '020', '510665', 'T', '113.36112', '23.12467');
INSERT INTO `dd_region` VALUES (1970, 1965, '白云', '白云区', '中国,广东省,广州市,白云区', 3, 'baiyun', '020', '510405', 'B', '113.27307', '23.15787');
INSERT INTO `dd_region` VALUES (1971, 1965, '黄埔', '黄埔区', '中国,广东省,广州市,黄埔区', 3, 'huangpu', '020', '510700', 'H', '113.45895', '23.10642');
INSERT INTO `dd_region` VALUES (1972, 1965, '番禺', '番禺区', '中国,广东省,广州市,番禺区', 3, 'panyu', '020', '511400', 'F', '113.38397', '22.93599');
INSERT INTO `dd_region` VALUES (1973, 1965, '花都', '花都区', '中国,广东省,广州市,花都区', 3, 'huadu', '020', '510800', 'H', '113.22033', '23.40358');
INSERT INTO `dd_region` VALUES (1974, 1965, '南沙', '南沙区', '中国,广东省,广州市,南沙区', 3, 'nansha', '020', '511458', 'N', '113.60845', '22.77144');
INSERT INTO `dd_region` VALUES (1975, 1965, '从化', '从化区', '中国,广东省,广州市,从化区', 3, 'conghua', '020', '510900', 'C', '113.587386', '23.545283');
INSERT INTO `dd_region` VALUES (1976, 1965, '增城', '增城区', '中国,广东省,广州市,增城区', 3, 'zengcheng', '020', '511300', 'Z', '113.829579', '23.290497');
INSERT INTO `dd_region` VALUES (1977, 1964, '韶关', '韶关市', '中国,广东省,韶关市', 2, 'shaoguan', '0751', '512002', 'S', '113.591544', '24.801322');
INSERT INTO `dd_region` VALUES (1978, 1977, '武江', '武江区', '中国,广东省,韶关市,武江区', 3, 'wujiang', '0751', '512026', 'W', '113.58767', '24.79264');
INSERT INTO `dd_region` VALUES (1979, 1977, '浈江', '浈江区', '中国,广东省,韶关市,浈江区', 3, 'zhenjiang', '0751', '512023', NULL, '113.61109', '24.80438');
INSERT INTO `dd_region` VALUES (1980, 1977, '曲江', '曲江区', '中国,广东省,韶关市,曲江区', 3, 'qujiang', '0751', '512101', 'Q', '113.60165', '24.67915');
INSERT INTO `dd_region` VALUES (1981, 1977, '始兴', '始兴县', '中国,广东省,韶关市,始兴县', 3, 'shixing', '0751', '512500', 'S', '114.06799', '24.94759');
INSERT INTO `dd_region` VALUES (1982, 1977, '仁化', '仁化县', '中国,广东省,韶关市,仁化县', 3, 'renhua', '0751', '512300', 'R', '113.74737', '25.08742');
INSERT INTO `dd_region` VALUES (1983, 1977, '翁源', '翁源县', '中国,广东省,韶关市,翁源县', 3, 'wengyuan', '0751', '512600', 'W', '114.13385', '24.3495');
INSERT INTO `dd_region` VALUES (1984, 1977, '乳源', '乳源瑶族自治县', '中国,广东省,韶关市,乳源瑶族自治县', 3, 'ruyuan', '0751', '512700', 'R', '113.27734', '24.77803');
INSERT INTO `dd_region` VALUES (1985, 1977, '新丰', '新丰县', '中国,广东省,韶关市,新丰县', 3, 'xinfeng', '0751', '511100', 'X', '114.20788', '24.05924');
INSERT INTO `dd_region` VALUES (1986, 1977, '乐昌', '乐昌市', '中国,广东省,韶关市,乐昌市', 3, 'lechang', '0751', '512200', 'L', '113.35653', '25.12799');
INSERT INTO `dd_region` VALUES (1987, 1977, '南雄', '南雄市', '中国,广东省,韶关市,南雄市', 3, 'nanxiong', '0751', '512400', 'N', '114.30966', '25.11706');
INSERT INTO `dd_region` VALUES (1988, 1964, '深圳', '深圳市', '中国,广东省,深圳市', 2, 'shenzhen', '0755', '518035', 'S', '114.085947', '22.547');
INSERT INTO `dd_region` VALUES (1989, 1988, '罗湖', '罗湖区', '中国,广东省,深圳市,罗湖区', 3, 'luohu', '0755', '518021', 'L', '114.13116', '22.54836');
INSERT INTO `dd_region` VALUES (1990, 1988, '福田', '福田区', '中国,广东省,深圳市,福田区', 3, 'futian', '0755', '518048', 'F', '114.05571', '22.52245');
INSERT INTO `dd_region` VALUES (1991, 1988, '南山', '南山区', '中国,广东省,深圳市,南山区', 3, 'nanshan', '0755', '518051', 'N', '113.93029', '22.53291');
INSERT INTO `dd_region` VALUES (1992, 1988, '宝安', '宝安区', '中国,广东省,深圳市,宝安区', 3, 'bao\'an', '0755', '518101', 'B', '113.88311', '22.55371');
INSERT INTO `dd_region` VALUES (1993, 1988, '龙岗', '龙岗区', '中国,广东省,深圳市,龙岗区', 3, 'longgang', '0755', '518172', 'L', '114.24771', '22.71986');
INSERT INTO `dd_region` VALUES (1994, 1988, '盐田', '盐田区', '中国,广东省,深圳市,盐田区', 3, 'yantian', '0755', '518081', 'Y', '114.23733', '22.5578');
INSERT INTO `dd_region` VALUES (1995, 1988, '光明新区', '光明新区', '中国,广东省,深圳市,光明新区', 3, 'guangmingxinqu', '0755', '518100', 'G', '113.896026', '22.777292');
INSERT INTO `dd_region` VALUES (1996, 1988, '坪山新区', '坪山新区', '中国,广东省,深圳市,坪山新区', 3, 'pingshanxinqu', '0755', '518000', 'P', '114.34637', '22.690529');
INSERT INTO `dd_region` VALUES (1997, 1988, '大鹏新区', '大鹏新区', '中国,广东省,深圳市,大鹏新区', 3, 'dapengxinqu', '0755', '518000', 'D', '114.479901', '22.587862');
INSERT INTO `dd_region` VALUES (1998, 1988, '龙华新区', '龙华新区', '中国,广东省,深圳市,龙华新区', 3, 'longhuaxinqu', '0755', '518100', 'L', '114.036585', '22.68695');
INSERT INTO `dd_region` VALUES (1999, 1964, '珠海', '珠海市', '中国,广东省,珠海市', 2, 'zhuhai', '0756', '519000', 'Z', '113.552724', '22.255899');
INSERT INTO `dd_region` VALUES (2000, 1999, '香洲', '香洲区', '中国,广东省,珠海市,香洲区', 3, 'xiangzhou', '0756', '519000', 'X', '113.5435', '22.26654');
INSERT INTO `dd_region` VALUES (2001, 1999, '斗门', '斗门区', '中国,广东省,珠海市,斗门区', 3, 'doumen', '0756', '519110', 'D', '113.29644', '22.20898');
INSERT INTO `dd_region` VALUES (2002, 1999, '金湾', '金湾区', '中国,广东省,珠海市,金湾区', 3, 'jinwan', '0756', '519040', 'J', '113.36361', '22.14691');
INSERT INTO `dd_region` VALUES (2003, 1964, '汕头', '汕头市', '中国,广东省,汕头市', 2, 'shantou', '0754', '515041', 'S', '116.708463', '23.37102');
INSERT INTO `dd_region` VALUES (2004, 2003, '龙湖', '龙湖区', '中国,广东省,汕头市,龙湖区', 3, 'longhu', '0754', '515041', 'L', '116.71641', '23.37166');
INSERT INTO `dd_region` VALUES (2005, 2003, '金平', '金平区', '中国,广东省,汕头市,金平区', 3, 'jinping', '0754', '515041', 'J', '116.70364', '23.36637');
INSERT INTO `dd_region` VALUES (2006, 2003, '濠江', '濠江区', '中国,广东省,汕头市,濠江区', 3, 'haojiang', '0754', '515071', NULL, '116.72659', '23.28588');
INSERT INTO `dd_region` VALUES (2007, 2003, '潮阳', '潮阳区', '中国,广东省,汕头市,潮阳区', 3, 'chaoyang', '0754', '515100', 'C', '116.6015', '23.26485');
INSERT INTO `dd_region` VALUES (2008, 2003, '潮南', '潮南区', '中国,广东省,汕头市,潮南区', 3, 'chaonan', '0754', '515144', 'C', '116.43188', '23.25');
INSERT INTO `dd_region` VALUES (2009, 2003, '澄海', '澄海区', '中国,广东省,汕头市,澄海区', 3, 'chenghai', '0754', '515800', 'C', '116.75589', '23.46728');
INSERT INTO `dd_region` VALUES (2010, 2003, '南澳', '南澳县', '中国,广东省,汕头市,南澳县', 3, 'nanao', '0754', '515900', 'N', '117.01889', '23.4223');
INSERT INTO `dd_region` VALUES (2011, 1964, '佛山', '佛山市', '中国,广东省,佛山市', 2, 'foshan', '0757', '528000', 'F', '113.122717', '23.028762');
INSERT INTO `dd_region` VALUES (2012, 2011, '禅城', '禅城区', '中国,广东省,佛山市,禅城区', 3, 'chancheng', '0757', '528000', NULL, '113.1228', '23.00842');
INSERT INTO `dd_region` VALUES (2013, 2011, '南海', '南海区', '中国,广东省,佛山市,南海区', 3, 'nanhai', '0757', '528251', 'N', '113.14299', '23.02877');
INSERT INTO `dd_region` VALUES (2014, 2011, '顺德', '顺德区', '中国,广东省,佛山市,顺德区', 3, 'shunde', '0757', '528300', 'S', '113.29394', '22.80452');
INSERT INTO `dd_region` VALUES (2015, 2011, '三水', '三水区', '中国,广东省,佛山市,三水区', 3, 'sanshui', '0757', '528133', 'S', '112.89703', '23.15564');
INSERT INTO `dd_region` VALUES (2016, 2011, '高明', '高明区', '中国,广东省,佛山市,高明区', 3, 'gaoming', '0757', '528500', 'G', '112.89254', '22.90022');
INSERT INTO `dd_region` VALUES (2017, 1964, '江门', '江门市', '中国,广东省,江门市', 2, 'jiangmen', '0750', '529000', 'J', '113.094942', '22.590431');
INSERT INTO `dd_region` VALUES (2018, 2017, '蓬江', '蓬江区', '中国,广东省,江门市,蓬江区', 3, 'pengjiang', '0750', '529000', 'P', '113.07849', '22.59515');
INSERT INTO `dd_region` VALUES (2019, 2017, '江海', '江海区', '中国,广东省,江门市,江海区', 3, 'jianghai', '0750', '529040', 'J', '113.11099', '22.56024');
INSERT INTO `dd_region` VALUES (2020, 2017, '新会', '新会区', '中国,广东省,江门市,新会区', 3, 'xinhui', '0750', '529100', 'X', '113.03225', '22.45876');
INSERT INTO `dd_region` VALUES (2021, 2017, '台山', '台山市', '中国,广东省,江门市,台山市', 3, 'taishan', '0750', '529200', 'T', '112.79382', '22.2515');
INSERT INTO `dd_region` VALUES (2022, 2017, '开平', '开平市', '中国,广东省,江门市,开平市', 3, 'kaiping', '0750', '529337', 'K', '112.69842', '22.37622');
INSERT INTO `dd_region` VALUES (2023, 2017, '鹤山', '鹤山市', '中国,广东省,江门市,鹤山市', 3, 'heshan', '0750', '529700', 'H', '112.96429', '22.76523');
INSERT INTO `dd_region` VALUES (2024, 2017, '恩平', '恩平市', '中国,广东省,江门市,恩平市', 3, 'enping', '0750', '529400', 'E', '112.30496', '22.18288');
INSERT INTO `dd_region` VALUES (2025, 1964, '湛江', '湛江市', '中国,广东省,湛江市', 2, 'zhanjiang', '0759', '524047', 'Z', '110.405529', '21.195338');
INSERT INTO `dd_region` VALUES (2026, 2025, '赤坎', '赤坎区', '中国,广东省,湛江市,赤坎区', 3, 'chikan', '0759', '524033', 'C', '110.36592', '21.26606');
INSERT INTO `dd_region` VALUES (2027, 2025, '霞山', '霞山区', '中国,广东省,湛江市,霞山区', 3, 'xiashan', '0759', '524011', 'X', '110.39822', '21.19181');
INSERT INTO `dd_region` VALUES (2028, 2025, '坡头', '坡头区', '中国,广东省,湛江市,坡头区', 3, 'potou', '0759', '524057', 'P', '110.45533', '21.24472');
INSERT INTO `dd_region` VALUES (2029, 2025, '麻章', '麻章区', '中国,广东省,湛江市,麻章区', 3, 'mazhang', '0759', '524094', 'M', '110.3342', '21.26333');
INSERT INTO `dd_region` VALUES (2030, 2025, '遂溪', '遂溪县', '中国,广东省,湛江市,遂溪县', 3, 'suixi', '0759', '524300', 'S', '110.25003', '21.37721');
INSERT INTO `dd_region` VALUES (2031, 2025, '徐闻', '徐闻县', '中国,广东省,湛江市,徐闻县', 3, 'xuwen', '0759', '524100', 'X', '110.17379', '20.32812');
INSERT INTO `dd_region` VALUES (2032, 2025, '廉江', '廉江市', '中国,广东省,湛江市,廉江市', 3, 'lianjiang', '0759', '524400', 'L', '110.28442', '21.60917');
INSERT INTO `dd_region` VALUES (2033, 2025, '雷州', '雷州市', '中国,广东省,湛江市,雷州市', 3, 'leizhou', '0759', '524200', 'L', '110.10092', '20.91428');
INSERT INTO `dd_region` VALUES (2034, 2025, '吴川', '吴川市', '中国,广东省,湛江市,吴川市', 3, 'wuchuan', '0759', '524500', 'W', '110.77703', '21.44584');
INSERT INTO `dd_region` VALUES (2035, 1964, '茂名', '茂名市', '中国,广东省,茂名市', 2, 'maoming', '0668', '525000', 'M', '110.919229', '21.659751');
INSERT INTO `dd_region` VALUES (2036, 2035, '茂南', '茂南区', '中国,广东省,茂名市,茂南区', 3, 'maonan', '0668', '525000', 'M', '110.9187', '21.64103');
INSERT INTO `dd_region` VALUES (2037, 2035, '电白', '电白区', '中国,广东省,茂名市,电白区', 3, 'dianbai', '0668', '525400', 'D', '111.007264', '21.507219');
INSERT INTO `dd_region` VALUES (2038, 2035, '高州', '高州市', '中国,广东省,茂名市,高州市', 3, 'gaozhou', '0668', '525200', 'G', '110.85519', '21.92057');
INSERT INTO `dd_region` VALUES (2039, 2035, '化州', '化州市', '中国,广东省,茂名市,化州市', 3, 'huazhou', '0668', '525100', 'H', '110.63949', '21.66394');
INSERT INTO `dd_region` VALUES (2040, 2035, '信宜', '信宜市', '中国,广东省,茂名市,信宜市', 3, 'xinyi', '0668', '525300', 'X', '110.94647', '22.35351');
INSERT INTO `dd_region` VALUES (2041, 1964, '肇庆', '肇庆市', '中国,广东省,肇庆市', 2, 'zhaoqing', '0758', '526040', 'Z', '112.472529', '23.051546');
INSERT INTO `dd_region` VALUES (2042, 2041, '端州', '端州区', '中国,广东省,肇庆市,端州区', 3, 'duanzhou', '0758', '526060', 'D', '112.48495', '23.0519');
INSERT INTO `dd_region` VALUES (2043, 2041, '鼎湖', '鼎湖区', '中国,广东省,肇庆市,鼎湖区', 3, 'dinghu', '0758', '526070', 'D', '112.56643', '23.15846');
INSERT INTO `dd_region` VALUES (2044, 2041, '广宁', '广宁县', '中国,广东省,肇庆市,广宁县', 3, 'guangning', '0758', '526300', 'G', '112.44064', '23.6346');
INSERT INTO `dd_region` VALUES (2045, 2041, '怀集', '怀集县', '中国,广东省,肇庆市,怀集县', 3, 'huaiji', '0758', '526400', 'H', '112.18396', '23.90918');
INSERT INTO `dd_region` VALUES (2046, 2041, '封开', '封开县', '中国,广东省,肇庆市,封开县', 3, 'fengkai', '0758', '526500', 'F', '111.50332', '23.43571');
INSERT INTO `dd_region` VALUES (2047, 2041, '德庆', '德庆县', '中国,广东省,肇庆市,德庆县', 3, 'deqing', '0758', '526600', 'D', '111.78555', '23.14371');
INSERT INTO `dd_region` VALUES (2048, 2041, '高要', '高要市', '中国,广东省,肇庆市,高要市', 3, 'gaoyao', '0758', '526100', 'G', '112.45834', '23.02577');
INSERT INTO `dd_region` VALUES (2049, 2041, '四会', '四会市', '中国,广东省,肇庆市,四会市', 3, 'sihui', '0758', '526200', 'S', '112.73416', '23.32686');
INSERT INTO `dd_region` VALUES (2050, 1964, '惠州', '惠州市', '中国,广东省,惠州市', 2, 'huizhou', '0752', '516000', 'H', '114.412599', '23.079404');
INSERT INTO `dd_region` VALUES (2051, 2050, '惠城', '惠城区', '中国,广东省,惠州市,惠城区', 3, 'huicheng', '0752', '516008', 'H', '114.3828', '23.08377');
INSERT INTO `dd_region` VALUES (2052, 2050, '惠阳', '惠阳区', '中国,广东省,惠州市,惠阳区', 3, 'huiyang', '0752', '516211', 'H', '114.45639', '22.78845');
INSERT INTO `dd_region` VALUES (2053, 2050, '博罗', '博罗县', '中国,广东省,惠州市,博罗县', 3, 'boluo', '0752', '516100', 'B', '114.28964', '23.17307');
INSERT INTO `dd_region` VALUES (2054, 2050, '惠东', '惠东县', '中国,广东省,惠州市,惠东县', 3, 'huidong', '0752', '516300', 'H', '114.72009', '22.98484');
INSERT INTO `dd_region` VALUES (2055, 2050, '龙门', '龙门县', '中国,广东省,惠州市,龙门县', 3, 'longmen', '0752', '516800', 'L', '114.25479', '23.72758');
INSERT INTO `dd_region` VALUES (2056, 1964, '梅州', '梅州市', '中国,广东省,梅州市', 2, 'meizhou', '0753', '514021', 'M', '116.117582', '24.299112');
INSERT INTO `dd_region` VALUES (2057, 2056, '梅江', '梅江区', '中国,广东省,梅州市,梅江区', 3, 'meijiang', '0753', '514000', 'M', '116.11663', '24.31062');
INSERT INTO `dd_region` VALUES (2058, 2056, '梅县', '梅县区', '中国,广东省,梅州市,梅县区', 3, 'meixian', '0753', '514787', 'M', '116.097753', '24.286739');
INSERT INTO `dd_region` VALUES (2059, 2056, '大埔', '大埔县', '中国,广东省,梅州市,大埔县', 3, 'dabu', '0753', '514200', 'D', '116.69662', '24.35325');
INSERT INTO `dd_region` VALUES (2060, 2056, '丰顺', '丰顺县', '中国,广东省,梅州市,丰顺县', 3, 'fengshun', '0753', '514300', 'F', '116.18219', '23.74094');
INSERT INTO `dd_region` VALUES (2061, 2056, '五华', '五华县', '中国,广东省,梅州市,五华县', 3, 'wuhua', '0753', '514400', 'W', '115.77893', '23.92417');
INSERT INTO `dd_region` VALUES (2062, 2056, '平远', '平远县', '中国,广东省,梅州市,平远县', 3, 'pingyuan', '0753', '514600', 'P', '115.89556', '24.57116');
INSERT INTO `dd_region` VALUES (2063, 2056, '蕉岭', '蕉岭县', '中国,广东省,梅州市,蕉岭县', 3, 'jiaoling', '0753', '514100', 'J', '116.17089', '24.65732');
INSERT INTO `dd_region` VALUES (2064, 2056, '兴宁', '兴宁市', '中国,广东省,梅州市,兴宁市', 3, 'xingning', '0753', '514500', 'X', '115.73141', '24.14001');
INSERT INTO `dd_region` VALUES (2065, 1964, '汕尾', '汕尾市', '中国,广东省,汕尾市', 2, 'shanwei', '0660', '516600', 'S', '115.364238', '22.774485');
INSERT INTO `dd_region` VALUES (2066, 2065, '城区', '城区', '中国,广东省,汕尾市,城区', 3, 'chengqu', '0660', '516600', 'C', '115.36503', '22.7789');
INSERT INTO `dd_region` VALUES (2067, 2065, '海丰', '海丰县', '中国,广东省,汕尾市,海丰县', 3, 'haifeng', '0660', '516400', 'H', '115.32336', '22.96653');
INSERT INTO `dd_region` VALUES (2068, 2065, '陆河', '陆河县', '中国,广东省,汕尾市,陆河县', 3, 'luhe', '0660', '516700', 'L', '115.65597', '23.30365');
INSERT INTO `dd_region` VALUES (2069, 2065, '陆丰', '陆丰市', '中国,广东省,汕尾市,陆丰市', 3, 'lufeng', '0660', '516500', 'L', '115.64813', '22.94335');
INSERT INTO `dd_region` VALUES (2070, 1964, '河源', '河源市', '中国,广东省,河源市', 2, 'heyuan', '0762', '517000', 'H', '114.697802', '23.746266');
INSERT INTO `dd_region` VALUES (2071, 2070, '源城', '源城区', '中国,广东省,河源市,源城区', 3, 'yuancheng', '0762', '517000', 'Y', '114.70242', '23.7341');
INSERT INTO `dd_region` VALUES (2072, 2070, '紫金', '紫金县', '中国,广东省,河源市,紫金县', 3, 'zijin', '0762', '517400', 'Z', '115.18365', '23.63867');
INSERT INTO `dd_region` VALUES (2073, 2070, '龙川', '龙川县', '中国,广东省,河源市,龙川县', 3, 'longchuan', '0762', '517300', 'L', '115.26025', '24.10142');
INSERT INTO `dd_region` VALUES (2074, 2070, '连平', '连平县', '中国,广东省,河源市,连平县', 3, 'lianping', '0762', '517100', 'L', '114.49026', '24.37156');
INSERT INTO `dd_region` VALUES (2075, 2070, '和平', '和平县', '中国,广东省,河源市,和平县', 3, 'heping', '0762', '517200', 'H', '114.93841', '24.44319');
INSERT INTO `dd_region` VALUES (2076, 2070, '东源', '东源县', '中国,广东省,河源市,东源县', 3, 'dongyuan', '0762', '517583', 'D', '114.74633', '23.78835');
INSERT INTO `dd_region` VALUES (2077, 1964, '阳江', '阳江市', '中国,广东省,阳江市', 2, 'yangjiang', '0662', '529500', 'Y', '111.975107', '21.859222');
INSERT INTO `dd_region` VALUES (2078, 2077, '江城', '江城区', '中国,广东省,阳江市,江城区', 3, 'jiangcheng', '0662', '529500', 'J', '111.95488', '21.86193');
INSERT INTO `dd_region` VALUES (2079, 2077, '阳东', '阳东区', '中国,广东省,阳江市,阳东区', 3, 'yangdong', '0662', '529900', 'Y', '112.01467', '21.87398');
INSERT INTO `dd_region` VALUES (2080, 2077, '阳西', '阳西县', '中国,广东省,阳江市,阳西县', 3, 'yangxi', '0662', '529800', 'Y', '111.61785', '21.75234');
INSERT INTO `dd_region` VALUES (2081, 2077, '阳春', '阳春市', '中国,广东省,阳江市,阳春市', 3, 'yangchun', '0662', '529600', 'Y', '111.78854', '22.17232');
INSERT INTO `dd_region` VALUES (2082, 1964, '清远', '清远市', '中国,广东省,清远市', 2, 'qingyuan', '0763', '511500', 'Q', '113.036779', '23.704188');
INSERT INTO `dd_region` VALUES (2083, 2082, '清城', '清城区', '中国,广东省,清远市,清城区', 3, 'qingcheng', '0763', '511515', 'Q', '113.06265', '23.69784');
INSERT INTO `dd_region` VALUES (2084, 2082, '清新', '清新区', '中国,广东省,清远市,清新区', 3, 'qingxin', '0763', '511810', 'Q', '113.015203', '23.736949');
INSERT INTO `dd_region` VALUES (2085, 2082, '佛冈', '佛冈县', '中国,广东省,清远市,佛冈县', 3, 'fogang', '0763', '511600', 'F', '113.53286', '23.87231');
INSERT INTO `dd_region` VALUES (2086, 2082, '阳山', '阳山县', '中国,广东省,清远市,阳山县', 3, 'yangshan', '0763', '513100', 'Y', '112.64129', '24.46516');
INSERT INTO `dd_region` VALUES (2087, 2082, '连山', '连山壮族瑶族自治县', '中国,广东省,清远市,连山壮族瑶族自治县', 3, 'lianshan', '0763', '513200', 'L', '112.0802', '24.56807');
INSERT INTO `dd_region` VALUES (2088, 2082, '连南', '连南瑶族自治县', '中国,广东省,清远市,连南瑶族自治县', 3, 'liannan', '0763', '513300', 'L', '112.28842', '24.71726');
INSERT INTO `dd_region` VALUES (2089, 2082, '英德', '英德市', '中国,广东省,清远市,英德市', 3, 'yingde', '0763', '513000', 'Y', '113.415', '24.18571');
INSERT INTO `dd_region` VALUES (2090, 2082, '连州', '连州市', '中国,广东省,清远市,连州市', 3, 'lianzhou', '0763', '513400', 'L', '112.38153', '24.77913');
INSERT INTO `dd_region` VALUES (2091, 1964, '东莞', '东莞市', '中国,广东省,东莞市', 2, 'dongguan', '0769', '523888', 'D', '113.760234', '23.048884');
INSERT INTO `dd_region` VALUES (2092, 2091, '莞城', '莞城区', '中国,广东省,东莞市,莞城区', 3, 'guancheng', '0769', '523128', NULL, '113.751043', '23.053412');
INSERT INTO `dd_region` VALUES (2093, 2091, '南城', '南城区', '中国,广东省,东莞市,南城区', 3, 'nancheng', '0769', '523617', 'N', '113.752125', '23.02018');
INSERT INTO `dd_region` VALUES (2094, 2091, '万江', '万江区', '中国,广东省,东莞市,万江区', 3, 'wanjiang', '0769', '523039', 'W', '113.739053', '23.043842');
INSERT INTO `dd_region` VALUES (2095, 2091, '石碣', '石碣镇', '中国,广东省,东莞市,石碣镇', 3, 'shijie', '0769', '523290', 'S', '113.80217', '23.09899');
INSERT INTO `dd_region` VALUES (2096, 2091, '石龙', '石龙镇', '中国,广东省,东莞市,石龙镇', 3, 'shilong', '0769', '523326', 'S', '113.876381', '23.107444');
INSERT INTO `dd_region` VALUES (2097, 2091, '茶山', '茶山镇', '中国,广东省,东莞市,茶山镇', 3, 'chashan', '0769', '523380', 'C', '113.883526', '23.062375');
INSERT INTO `dd_region` VALUES (2098, 2091, '石排', '石排镇', '中国,广东省,东莞市,石排镇', 3, 'shipai', '0769', '523346', 'S', '113.919859', '23.0863');
INSERT INTO `dd_region` VALUES (2099, 2091, '企石', '企石镇', '中国,广东省,东莞市,企石镇', 3, 'qishi', '0769', '523507', 'Q', '114.013233', '23.066044');
INSERT INTO `dd_region` VALUES (2100, 2091, '横沥', '横沥镇', '中国,广东省,东莞市,横沥镇', 3, 'hengli', '0769', '523471', 'H', '113.957436', '23.025732');
INSERT INTO `dd_region` VALUES (2101, 2091, '桥头', '桥头镇', '中国,广东省,东莞市,桥头镇', 3, 'qiaotou', '0769', '523520', 'Q', '114.01385', '22.939727');
INSERT INTO `dd_region` VALUES (2102, 2091, '谢岗', '谢岗镇', '中国,广东省,东莞市,谢岗镇', 3, 'xiegang', '0769', '523592', 'X', '114.141396', '22.959664');
INSERT INTO `dd_region` VALUES (2103, 2091, '东坑', '东坑镇', '中国,广东省,东莞市,东坑镇', 3, 'dongkeng', '0769', '523451', 'D', '113.939835', '22.992804');
INSERT INTO `dd_region` VALUES (2104, 2091, '常平', '常平镇', '中国,广东省,东莞市,常平镇', 3, 'changping', '0769', '523560', 'C', '114.029627', '23.016116');
INSERT INTO `dd_region` VALUES (2105, 2091, '寮步', '寮步镇', '中国,广东省,东莞市,寮步镇', 3, 'liaobu', '0769', '523411', NULL, '113.884745', '22.991738');
INSERT INTO `dd_region` VALUES (2106, 2091, '大朗', '大朗镇', '中国,广东省,东莞市,大朗镇', 3, 'dalang', '0769', '523770', 'D', '113.9271', '22.965748');
INSERT INTO `dd_region` VALUES (2107, 2091, '麻涌', '麻涌镇', '中国,广东省,东莞市,麻涌镇', 3, 'machong', '0769', '523143', 'M', '113.546177', '23.045315');
INSERT INTO `dd_region` VALUES (2108, 2091, '中堂', '中堂镇', '中国,广东省,东莞市,中堂镇', 3, 'zhongtang', '0769', '523233', 'Z', '113.654422', '23.090164');
INSERT INTO `dd_region` VALUES (2109, 2091, '高埗', '高埗镇', '中国,广东省,东莞市,高埗镇', 3, 'gaobu', '0769', '523282', NULL, '113.735917', '23.068415');
INSERT INTO `dd_region` VALUES (2110, 2091, '樟木头', '樟木头镇', '中国,广东省,东莞市,樟木头镇', 3, 'zhangmutou', '0769', '523619', 'Z', '114.066298', '22.956682');
INSERT INTO `dd_region` VALUES (2111, 2091, '大岭山', '大岭山镇', '中国,广东省,东莞市,大岭山镇', 3, 'dalingshan', '0769', '523835', 'D', '113.782955', '22.885366');
INSERT INTO `dd_region` VALUES (2112, 2091, '望牛墩', '望牛墩镇', '中国,广东省,东莞市,望牛墩镇', 3, 'wangniudun', '0769', '523203', 'W', '113.658847', '23.055018');
INSERT INTO `dd_region` VALUES (2113, 2091, '黄江', '黄江镇', '中国,广东省,东莞市,黄江镇', 3, 'huangjiang', '0769', '523755', 'H', '113.992635', '22.877536');
INSERT INTO `dd_region` VALUES (2114, 2091, '洪梅', '洪梅镇', '中国,广东省,东莞市,洪梅镇', 3, 'hongmei', '0769', '523163', 'H', '113.613081', '22.992675');
INSERT INTO `dd_region` VALUES (2115, 2091, '清溪', '清溪镇', '中国,广东省,东莞市,清溪镇', 3, 'qingxi', '0769', '523660', 'Q', '114.155796', '22.844456');
INSERT INTO `dd_region` VALUES (2116, 2091, '沙田', '沙田镇', '中国,广东省,东莞市,沙田镇', 3, 'shatian', '0769', '523988', 'S', '113.760234', '23.048884');
INSERT INTO `dd_region` VALUES (2117, 2091, '道滘', '道滘镇', '中国,广东省,东莞市,道滘镇', 3, 'daojiao', '0769', '523171', NULL, '113.760234', '23.048884');
INSERT INTO `dd_region` VALUES (2118, 2091, '塘厦', '塘厦镇', '中国,广东省,东莞市,塘厦镇', 3, 'tangxia', '0769', '523713', 'T', '114.10765', '22.822862');
INSERT INTO `dd_region` VALUES (2119, 2091, '虎门', '虎门镇', '中国,广东省,东莞市,虎门镇', 3, 'humen', '0769', '523932', 'H', '113.71118', '22.82615');
INSERT INTO `dd_region` VALUES (2120, 2091, '厚街', '厚街镇', '中国,广东省,东莞市,厚街镇', 3, 'houjie', '0769', '523960', 'H', '113.67301', '22.940815');
INSERT INTO `dd_region` VALUES (2121, 2091, '凤岗', '凤岗镇', '中国,广东省,东莞市,凤岗镇', 3, 'fenggang', '0769', '523690', 'F', '114.141194', '22.744598');
INSERT INTO `dd_region` VALUES (2122, 2091, '长安', '长安镇', '中国,广东省,东莞市,长安镇', 3, 'chang\'an', '0769', '523850', 'C', '113.803939', '22.816644');
INSERT INTO `dd_region` VALUES (2123, 1964, '中山', '中山市', '中国,广东省,中山市', 2, 'zhongshan', '0760', '528403', 'Z', '113.382391', '22.521113');
INSERT INTO `dd_region` VALUES (2124, 2123, '石岐', '石岐区', '中国,广东省,中山市,石岐区', 3, 'shiqi', '0760', '528400', 'S', '113.378835', '22.52522');
INSERT INTO `dd_region` VALUES (2125, 2123, '南区', '南区', '中国,广东省,中山市,南区', 3, 'nanqu', '0760', '528400', 'N', '113.355896', '22.486568');
INSERT INTO `dd_region` VALUES (2126, 2123, '五桂山', '五桂山区', '中国,广东省,中山市,五桂山区', 3, 'wuguishan', '0760', '528458', 'W', '113.41079', '22.51968');
INSERT INTO `dd_region` VALUES (2127, 2123, '火炬', '火炬开发区', '中国,广东省,中山市,火炬开发区', 3, 'huoju', '0760', '528437', 'H', '113.480523', '22.566082');
INSERT INTO `dd_region` VALUES (2128, 2123, '黄圃', '黄圃镇', '中国,广东省,中山市,黄圃镇', 3, 'huangpu', '0760', '528429', 'H', '113.342359', '22.715116');
INSERT INTO `dd_region` VALUES (2129, 2123, '南头', '南头镇', '中国,广东省,中山市,南头镇', 3, 'nantou', '0760', '528421', 'N', '113.296358', '22.713907');
INSERT INTO `dd_region` VALUES (2130, 2123, '东凤', '东凤镇', '中国,广东省,中山市,东凤镇', 3, 'dongfeng', '0760', '528425', 'D', '113.26114', '22.68775');
INSERT INTO `dd_region` VALUES (2131, 2123, '阜沙', '阜沙镇', '中国,广东省,中山市,阜沙镇', 3, 'fusha', '0760', '528434', 'F', '113.353024', '22.666364');
INSERT INTO `dd_region` VALUES (2132, 2123, '小榄', '小榄镇', '中国,广东省,中山市,小榄镇', 3, 'xiaolan', '0760', '528415', 'X', '113.244235', '22.666951');
INSERT INTO `dd_region` VALUES (2133, 2123, '东升', '东升镇', '中国,广东省,中山市,东升镇', 3, 'dongsheng', '0760', '528400', 'D', '113.296298', '22.614003');
INSERT INTO `dd_region` VALUES (2134, 2123, '古镇', '古镇镇', '中国,广东省,中山市,古镇镇', 3, 'guzhen', '0760', '528422', 'G', '113.179745', '22.611019');
INSERT INTO `dd_region` VALUES (2135, 2123, '横栏', '横栏镇', '中国,广东省,中山市,横栏镇', 3, 'henglan', '0760', '528478', 'H', '113.265845', '22.523202');
INSERT INTO `dd_region` VALUES (2136, 2123, '三角', '三角镇', '中国,广东省,中山市,三角镇', 3, 'sanjiao', '0760', '528422', 'S', '113.423624', '22.677033');
INSERT INTO `dd_region` VALUES (2137, 2123, '民众', '民众镇', '中国,广东省,中山市,民众镇', 3, 'minzhong', '0760', '528441', 'M', '113.486025', '22.623468');
INSERT INTO `dd_region` VALUES (2138, 2123, '南朗', '南朗镇', '中国,广东省,中山市,南朗镇', 3, 'nanlang', '0760', '528454', 'N', '113.533939', '22.492378');
INSERT INTO `dd_region` VALUES (2139, 2123, '港口', '港口镇', '中国,广东省,中山市,港口镇', 3, 'gangkou', '0760', '528447', 'G', '113.382391', '22.521113');
INSERT INTO `dd_region` VALUES (2140, 2123, '大涌', '大涌镇', '中国,广东省,中山市,大涌镇', 3, 'dayong', '0760', '528476', 'D', '113.291708', '22.467712');
INSERT INTO `dd_region` VALUES (2141, 2123, '沙溪', '沙溪镇', '中国,广东省,中山市,沙溪镇', 3, 'shaxi', '0760', '528471', 'S', '113.328369', '22.526325');
INSERT INTO `dd_region` VALUES (2142, 2123, '三乡', '三乡镇', '中国,广东省,中山市,三乡镇', 3, 'sanxiang', '0760', '528463', 'S', '113.4334', '22.352494');
INSERT INTO `dd_region` VALUES (2143, 2123, '板芙', '板芙镇', '中国,广东省,中山市,板芙镇', 3, 'banfu', '0760', '528459', 'B', '113.320346', '22.415674');
INSERT INTO `dd_region` VALUES (2144, 2123, '神湾', '神湾镇', '中国,广东省,中山市,神湾镇', 3, 'shenwan', '0760', '528462', 'S', '113.359387', '22.312476');
INSERT INTO `dd_region` VALUES (2145, 2123, '坦洲', '坦洲镇', '中国,广东省,中山市,坦洲镇', 3, 'tanzhou', '0760', '528467', 'T', '113.485677', '22.261269');
INSERT INTO `dd_region` VALUES (2146, 1964, '潮州', '潮州市', '中国,广东省,潮州市', 2, 'chaozhou', '0768', '521000', 'C', '116.632301', '23.661701');
INSERT INTO `dd_region` VALUES (2147, 2146, '湘桥', '湘桥区', '中国,广东省,潮州市,湘桥区', 3, 'xiangqiao', '0768', '521000', 'X', '116.62805', '23.67451');
INSERT INTO `dd_region` VALUES (2148, 2146, '潮安', '潮安区', '中国,广东省,潮州市,潮安区', 3, 'chao\'an', '0768', '515638', 'C', '116.592895', '23.643656');
INSERT INTO `dd_region` VALUES (2149, 2146, '饶平', '饶平县', '中国,广东省,潮州市,饶平县', 3, 'raoping', '0768', '515700', 'R', '117.00692', '23.66994');
INSERT INTO `dd_region` VALUES (2150, 1964, '揭阳', '揭阳市', '中国,广东省,揭阳市', 2, 'jieyang', '0633', '522000', 'J', '116.355733', '23.543778');
INSERT INTO `dd_region` VALUES (2151, 2150, '榕城', '榕城区', '中国,广东省,揭阳市,榕城区', 3, 'rongcheng', '0633', '522000', NULL, '116.3671', '23.52508');
INSERT INTO `dd_region` VALUES (2152, 2150, '揭东', '揭东区', '中国,广东省,揭阳市,揭东区', 3, 'jiedong', '0633', '515500', 'J', '116.412947', '23.569887');
INSERT INTO `dd_region` VALUES (2153, 2150, '揭西', '揭西县', '中国,广东省,揭阳市,揭西县', 3, 'jiexi', '0633', '515400', 'J', '115.83883', '23.42714');
INSERT INTO `dd_region` VALUES (2154, 2150, '惠来', '惠来县', '中国,广东省,揭阳市,惠来县', 3, 'huilai', '0633', '515200', 'H', '116.29599', '23.03289');
INSERT INTO `dd_region` VALUES (2155, 2150, '普宁', '普宁市', '中国,广东省,揭阳市,普宁市', 3, 'puning', '0633', '515300', 'P', '116.16564', '23.29732');
INSERT INTO `dd_region` VALUES (2156, 1964, '云浮', '云浮市', '中国,广东省,云浮市', 2, 'yunfu', '0766', '527300', 'Y', '112.044439', '22.929801');
INSERT INTO `dd_region` VALUES (2157, 2156, '云城', '云城区', '中国,广东省,云浮市,云城区', 3, 'yuncheng', '0766', '527300', 'Y', '112.03908', '22.92996');
INSERT INTO `dd_region` VALUES (2158, 2156, '云安', '云安区', '中国,广东省,云浮市,云安区', 3, 'yun\'an', '0766', '527500', 'Y', '112.00936', '23.07779');
INSERT INTO `dd_region` VALUES (2159, 2156, '新兴', '新兴县', '中国,广东省,云浮市,新兴县', 3, 'xinxing', '0766', '527400', 'X', '112.23019', '22.69734');
INSERT INTO `dd_region` VALUES (2160, 2156, '郁南', '郁南县', '中国,广东省,云浮市,郁南县', 3, 'yunan', '0766', '527100', 'Y', '111.53387', '23.23307');
INSERT INTO `dd_region` VALUES (2161, 2156, '罗定', '罗定市', '中国,广东省,云浮市,罗定市', 3, 'luoding', '0766', '527200', 'L', '111.56979', '22.76967');
INSERT INTO `dd_region` VALUES (2162, 0, '广西', '广西壮族自治区', '中国,广西壮族自治区', 1, 'guangxi', '', '', 'G', '108.320004', '22.82402');
INSERT INTO `dd_region` VALUES (2163, 2162, '南宁', '南宁市', '中国,广西壮族自治区,南宁市', 2, 'nanning', '0771', '530028', 'N', '108.320004', '22.82402');
INSERT INTO `dd_region` VALUES (2164, 2163, '兴宁', '兴宁区', '中国,广西壮族自治区,南宁市,兴宁区', 3, 'xingning', '0771', '530023', 'X', '108.36694', '22.85355');
INSERT INTO `dd_region` VALUES (2165, 2163, '青秀', '青秀区', '中国,广西壮族自治区,南宁市,青秀区', 3, 'qingxiu', '0771', '530213', 'Q', '108.49545', '22.78511');
INSERT INTO `dd_region` VALUES (2166, 2163, '江南', '江南区', '中国,广西壮族自治区,南宁市,江南区', 3, 'jiangnan', '0771', '530031', 'J', '108.27325', '22.78127');
INSERT INTO `dd_region` VALUES (2167, 2163, '西乡塘', '西乡塘区', '中国,广西壮族自治区,南宁市,西乡塘区', 3, 'xixiangtang', '0771', '530001', 'X', '108.31347', '22.83386');
INSERT INTO `dd_region` VALUES (2168, 2163, '良庆', '良庆区', '中国,广西壮族自治区,南宁市,良庆区', 3, 'liangqing', '0771', '530219', 'L', '108.41284', '22.74914');
INSERT INTO `dd_region` VALUES (2169, 2163, '邕宁', '邕宁区', '中国,广西壮族自治区,南宁市,邕宁区', 3, 'yongning', '0771', '530200', NULL, '108.48684', '22.75628');
INSERT INTO `dd_region` VALUES (2170, 2163, '武鸣', '武鸣县', '中国,广西壮族自治区,南宁市,武鸣县', 3, 'wuming', '0771', '530100', 'W', '108.27719', '23.15643');
INSERT INTO `dd_region` VALUES (2171, 2163, '隆安', '隆安县', '中国,广西壮族自治区,南宁市,隆安县', 3, 'long\'an', '0771', '532700', 'L', '107.69192', '23.17336');
INSERT INTO `dd_region` VALUES (2172, 2163, '马山', '马山县', '中国,广西壮族自治区,南宁市,马山县', 3, 'mashan', '0771', '530600', 'M', '108.17697', '23.70931');
INSERT INTO `dd_region` VALUES (2173, 2163, '上林', '上林县', '中国,广西壮族自治区,南宁市,上林县', 3, 'shanglin', '0771', '530500', 'S', '108.60522', '23.432');
INSERT INTO `dd_region` VALUES (2174, 2163, '宾阳', '宾阳县', '中国,广西壮族自治区,南宁市,宾阳县', 3, 'binyang', '0771', '530400', 'B', '108.81185', '23.2196');
INSERT INTO `dd_region` VALUES (2175, 2163, '横县', '横县', '中国,广西壮族自治区,南宁市,横县', 3, 'hengxian', '0771', '530300', 'H', '109.26608', '22.68448');
INSERT INTO `dd_region` VALUES (2176, 2163, '埌东', '埌东新区', '中国,广西壮族自治区,南宁市,埌东新区', 3, 'langdong', '0771', '530000', NULL, '108.419094', '22.812976');
INSERT INTO `dd_region` VALUES (2177, 2162, '柳州', '柳州市', '中国,广西壮族自治区,柳州市', 2, 'liuzhou', '0772', '545001', 'L', '109.411703', '24.314617');
INSERT INTO `dd_region` VALUES (2178, 2177, '城中', '城中区', '中国,广西壮族自治区,柳州市,城中区', 3, 'chengzhong', '0772', '545001', 'C', '109.41082', '24.31543');
INSERT INTO `dd_region` VALUES (2179, 2177, '鱼峰', '鱼峰区', '中国,广西壮族自治区,柳州市,鱼峰区', 3, 'yufeng', '0772', '545005', 'Y', '109.4533', '24.31868');
INSERT INTO `dd_region` VALUES (2180, 2177, '柳南', '柳南区', '中国,广西壮族自治区,柳州市,柳南区', 3, 'liunan', '0772', '545007', 'L', '109.38548', '24.33599');
INSERT INTO `dd_region` VALUES (2181, 2177, '柳北', '柳北区', '中国,广西壮族自治区,柳州市,柳北区', 3, 'liubei', '0772', '545002', 'L', '109.40202', '24.36267');
INSERT INTO `dd_region` VALUES (2182, 2177, '柳江', '柳江县', '中国,广西壮族自治区,柳州市,柳江县', 3, 'liujiang', '0772', '545100', 'L', '109.33273', '24.25596');
INSERT INTO `dd_region` VALUES (2183, 2177, '柳城', '柳城县', '中国,广西壮族自治区,柳州市,柳城县', 3, 'liucheng', '0772', '545200', 'L', '109.23877', '24.64951');
INSERT INTO `dd_region` VALUES (2184, 2177, '鹿寨', '鹿寨县', '中国,广西壮族自治区,柳州市,鹿寨县', 3, 'luzhai', '0772', '545600', 'L', '109.75177', '24.47306');
INSERT INTO `dd_region` VALUES (2185, 2177, '融安', '融安县', '中国,广西壮族自治区,柳州市,融安县', 3, 'rong\'an', '0772', '545400', 'R', '109.39761', '25.22465');
INSERT INTO `dd_region` VALUES (2186, 2177, '融水', '融水苗族自治县', '中国,广西壮族自治区,柳州市,融水苗族自治县', 3, 'rongshui', '0772', '545300', 'R', '109.25634', '25.06628');
INSERT INTO `dd_region` VALUES (2187, 2177, '三江', '三江侗族自治县', '中国,广西壮族自治区,柳州市,三江侗族自治县', 3, 'sanjiang', '0772', '545500', 'S', '109.60446', '25.78428');
INSERT INTO `dd_region` VALUES (2188, 2177, '柳东', '柳东新区', '中国,广西壮族自治区,柳州市,柳东新区', 3, 'liudong', '0772', '545000', 'L', '109.437053', '24.329204');
INSERT INTO `dd_region` VALUES (2189, 2162, '桂林', '桂林市', '中国,广西壮族自治区,桂林市', 2, 'guilin', '0773', '541100', 'G', '110.299121', '25.274215');
INSERT INTO `dd_region` VALUES (2190, 2189, '秀峰', '秀峰区', '中国,广西壮族自治区,桂林市,秀峰区', 3, 'xiufeng', '0773', '541001', 'X', '110.28915', '25.28249');
INSERT INTO `dd_region` VALUES (2191, 2189, '叠彩', '叠彩区', '中国,广西壮族自治区,桂林市,叠彩区', 3, 'diecai', '0773', '541001', 'D', '110.30195', '25.31381');
INSERT INTO `dd_region` VALUES (2192, 2189, '象山', '象山区', '中国,广西壮族自治区,桂林市,象山区', 3, 'xiangshan', '0773', '541002', 'X', '110.28108', '25.26168');
INSERT INTO `dd_region` VALUES (2193, 2189, '七星', '七星区', '中国,广西壮族自治区,桂林市,七星区', 3, 'qixing', '0773', '541004', 'Q', '110.31793', '25.2525');
INSERT INTO `dd_region` VALUES (2194, 2189, '雁山', '雁山区', '中国,广西壮族自治区,桂林市,雁山区', 3, 'yanshan', '0773', '541006', 'Y', '110.30911', '25.06038');
INSERT INTO `dd_region` VALUES (2195, 2189, '临桂', '临桂区', '中国,广西壮族自治区,桂林市,临桂区', 3, 'lingui', '0773', '541100', 'L', '110.205487', '25.246257');
INSERT INTO `dd_region` VALUES (2196, 2189, '阳朔', '阳朔县', '中国,广西壮族自治区,桂林市,阳朔县', 3, 'yangshuo', '0773', '541900', 'Y', '110.49475', '24.77579');
INSERT INTO `dd_region` VALUES (2197, 2189, '灵川', '灵川县', '中国,广西壮族自治区,桂林市,灵川县', 3, 'lingchuan', '0773', '541200', 'L', '110.32949', '25.41292');
INSERT INTO `dd_region` VALUES (2198, 2189, '全州', '全州县', '中国,广西壮族自治区,桂林市,全州县', 3, 'quanzhou', '0773', '541503', 'Q', '111.07211', '25.92799');
INSERT INTO `dd_region` VALUES (2199, 2189, '兴安', '兴安县', '中国,广西壮族自治区,桂林市,兴安县', 3, 'xing\'an', '0773', '541300', 'X', '110.67144', '25.61167');
INSERT INTO `dd_region` VALUES (2200, 2189, '永福', '永福县', '中国,广西壮族自治区,桂林市,永福县', 3, 'yongfu', '0773', '541800', 'Y', '109.98333', '24.98004');
INSERT INTO `dd_region` VALUES (2201, 2189, '灌阳', '灌阳县', '中国,广西壮族自治区,桂林市,灌阳县', 3, 'guanyang', '0773', '541600', 'G', '111.15954', '25.48803');
INSERT INTO `dd_region` VALUES (2202, 2189, '龙胜', '龙胜各族自治县', '中国,广西壮族自治区,桂林市,龙胜各族自治县', 3, 'longsheng', '0773', '541700', 'L', '110.01226', '25.79614');
INSERT INTO `dd_region` VALUES (2203, 2189, '资源', '资源县', '中国,广西壮族自治区,桂林市,资源县', 3, 'ziyuan', '0773', '541400', 'Z', '110.65255', '26.04237');
INSERT INTO `dd_region` VALUES (2204, 2189, '平乐', '平乐县', '中国,广西壮族自治区,桂林市,平乐县', 3, 'pingle', '0773', '542400', 'P', '110.64175', '24.63242');
INSERT INTO `dd_region` VALUES (2205, 2189, '荔浦', '荔浦县', '中国,广西壮族自治区,桂林市,荔浦县', 3, 'lipu', '0773', '546600', 'L', '110.3971', '24.49589');
INSERT INTO `dd_region` VALUES (2206, 2189, '恭城', '恭城瑶族自治县', '中国,广西壮族自治区,桂林市,恭城瑶族自治县', 3, 'gongcheng', '0773', '542500', 'G', '110.83035', '24.83286');
INSERT INTO `dd_region` VALUES (2207, 2162, '梧州', '梧州市', '中国,广西壮族自治区,梧州市', 2, 'wuzhou', '0774', '543002', 'W', '111.316229', '23.472309');
INSERT INTO `dd_region` VALUES (2208, 2207, '万秀', '万秀区', '中国,广西壮族自治区,梧州市,万秀区', 3, 'wanxiu', '0774', '543000', 'W', '111.32052', '23.47298');
INSERT INTO `dd_region` VALUES (2209, 2207, '长洲', '长洲区', '中国,广西壮族自治区,梧州市,长洲区', 3, 'changzhou', '0774', '543003', 'C', '111.27494', '23.48573');
INSERT INTO `dd_region` VALUES (2210, 2207, '龙圩', '龙圩区', '中国,广西壮族自治区,梧州市,龙圩区', 3, 'longxu', '0774', '543002', 'L', '111.316229', '23.472309');
INSERT INTO `dd_region` VALUES (2211, 2207, '苍梧', '苍梧县', '中国,广西壮族自治区,梧州市,苍梧县', 3, 'cangwu', '0774', '543100', 'C', '111.24533', '23.42049');
INSERT INTO `dd_region` VALUES (2212, 2207, '藤县', '藤县', '中国,广西壮族自治区,梧州市,藤县', 3, 'tengxian', '0774', '543300', 'T', '110.91418', '23.37605');
INSERT INTO `dd_region` VALUES (2213, 2207, '蒙山', '蒙山县', '中国,广西壮族自治区,梧州市,蒙山县', 3, 'mengshan', '0774', '546700', 'M', '110.52221', '24.20168');
INSERT INTO `dd_region` VALUES (2214, 2207, '岑溪', '岑溪市', '中国,广西壮族自治区,梧州市,岑溪市', 3, 'cenxi', '0774', '543200', NULL, '110.99594', '22.9191');
INSERT INTO `dd_region` VALUES (2215, 2162, '北海', '北海市', '中国,广西壮族自治区,北海市', 2, 'beihai', '0779', '536000', 'B', '109.119254', '21.473343');
INSERT INTO `dd_region` VALUES (2216, 2215, '海城', '海城区', '中国,广西壮族自治区,北海市,海城区', 3, 'haicheng', '0779', '536000', 'H', '109.11744', '21.47501');
INSERT INTO `dd_region` VALUES (2217, 2215, '银海', '银海区', '中国,广西壮族自治区,北海市,银海区', 3, 'yinhai', '0779', '536000', 'Y', '109.13029', '21.4783');
INSERT INTO `dd_region` VALUES (2218, 2215, '铁山港', '铁山港区', '中国,广西壮族自治区,北海市,铁山港区', 3, 'tieshangang', '0779', '536017', 'T', '109.45578', '21.59661');
INSERT INTO `dd_region` VALUES (2219, 2215, '合浦', '合浦县', '中国,广西壮族自治区,北海市,合浦县', 3, 'hepu', '0779', '536100', 'H', '109.20068', '21.66601');
INSERT INTO `dd_region` VALUES (2220, 2162, '防城港', '防城港市', '中国,广西壮族自治区,防城港市', 2, 'fangchenggang', '0770', '538001', 'F', '108.345478', '21.614631');
INSERT INTO `dd_region` VALUES (2221, 2220, '港口', '港口区', '中国,广西壮族自治区,防城港市,港口区', 3, 'gangkou', '0770', '538001', 'G', '108.38022', '21.64342');
INSERT INTO `dd_region` VALUES (2222, 2220, '防城', '防城区', '中国,广西壮族自治区,防城港市,防城区', 3, 'fangcheng', '0770', '538021', 'F', '108.35726', '21.76464');
INSERT INTO `dd_region` VALUES (2223, 2220, '上思', '上思县', '中国,广西壮族自治区,防城港市,上思县', 3, 'shangsi', '0770', '535500', 'S', '107.9823', '22.14957');
INSERT INTO `dd_region` VALUES (2224, 2220, '东兴', '东兴市', '中国,广西壮族自治区,防城港市,东兴市', 3, 'dongxing', '0770', '538100', 'D', '107.97204', '21.54713');
INSERT INTO `dd_region` VALUES (2225, 2162, '钦州', '钦州市', '中国,广西壮族自治区,钦州市', 2, 'qinzhou', '0777', '535099', 'Q', '108.624175', '21.967127');
INSERT INTO `dd_region` VALUES (2226, 2225, '钦南', '钦南区', '中国,广西壮族自治区,钦州市,钦南区', 3, 'qinnan', '0777', '535099', 'Q', '108.61775', '21.95137');
INSERT INTO `dd_region` VALUES (2227, 2225, '钦北', '钦北区', '中国,广西壮族自治区,钦州市,钦北区', 3, 'qinbei', '0777', '535099', 'Q', '108.63037', '21.95127');
INSERT INTO `dd_region` VALUES (2228, 2225, '灵山', '灵山县', '中国,广西壮族自治区,钦州市,灵山县', 3, 'lingshan', '0777', '535099', 'L', '109.29153', '22.4165');
INSERT INTO `dd_region` VALUES (2229, 2225, '浦北', '浦北县', '中国,广西壮族自治区,钦州市,浦北县', 3, 'pubei', '0777', '535099', 'P', '109.55572', '22.26888');
INSERT INTO `dd_region` VALUES (2230, 2162, '贵港', '贵港市', '中国,广西壮族自治区,贵港市', 2, 'guigang', '0775', '537100', 'G', '109.602146', '23.0936');
INSERT INTO `dd_region` VALUES (2231, 2230, '港北', '港北区', '中国,广西壮族自治区,贵港市,港北区', 3, 'gangbei', '0775', '537100', 'G', '109.57224', '23.11153');
INSERT INTO `dd_region` VALUES (2232, 2230, '港南', '港南区', '中国,广西壮族自治区,贵港市,港南区', 3, 'gangnan', '0775', '537100', 'G', '109.60617', '23.07226');
INSERT INTO `dd_region` VALUES (2233, 2230, '覃塘', '覃塘区', '中国,广西壮族自治区,贵港市,覃塘区', 3, 'qintang', '0775', '537121', NULL, '109.44293', '23.12677');
INSERT INTO `dd_region` VALUES (2234, 2230, '平南', '平南县', '中国,广西壮族自治区,贵港市,平南县', 3, 'pingnan', '0775', '537300', 'P', '110.39062', '23.54201');
INSERT INTO `dd_region` VALUES (2235, 2230, '桂平', '桂平市', '中国,广西壮族自治区,贵港市,桂平市', 3, 'guiping', '0775', '537200', 'G', '110.08105', '23.39339');
INSERT INTO `dd_region` VALUES (2236, 2162, '玉林', '玉林市', '中国,广西壮族自治区,玉林市', 2, 'yulin', '0775', '537000', 'Y', '110.154393', '22.63136');
INSERT INTO `dd_region` VALUES (2237, 2236, '玉州', '玉州区', '中国,广西壮族自治区,玉林市,玉州区', 3, 'yuzhou', '0775', '537000', 'Y', '110.15114', '22.6281');
INSERT INTO `dd_region` VALUES (2238, 2236, '福绵', '福绵区', '中国,广西壮族自治区,玉林市,福绵区', 3, 'fumian', '0775', '537023', 'F', '110.064816', '22.583057');
INSERT INTO `dd_region` VALUES (2239, 2236, '玉东', '玉东新区', '中国,广西壮族自治区,玉林市,玉东新区', 3, 'yudong', '0775', '537000', 'Y', '110.154393', '22.63136');
INSERT INTO `dd_region` VALUES (2240, 2236, '容县', '容县', '中国,广西壮族自治区,玉林市,容县', 3, 'rongxian', '0775', '537500', 'R', '110.55593', '22.85701');
INSERT INTO `dd_region` VALUES (2241, 2236, '陆川', '陆川县', '中国,广西壮族自治区,玉林市,陆川县', 3, 'luchuan', '0775', '537700', 'L', '110.26413', '22.32454');
INSERT INTO `dd_region` VALUES (2242, 2236, '博白', '博白县', '中国,广西壮族自治区,玉林市,博白县', 3, 'bobai', '0775', '537600', 'B', '109.97744', '22.27286');
INSERT INTO `dd_region` VALUES (2243, 2236, '兴业', '兴业县', '中国,广西壮族自治区,玉林市,兴业县', 3, 'xingye', '0775', '537800', 'X', '109.87612', '22.74237');
INSERT INTO `dd_region` VALUES (2244, 2236, '北流', '北流市', '中国,广西壮族自治区,玉林市,北流市', 3, 'beiliu', '0775', '537400', 'B', '110.35302', '22.70817');
INSERT INTO `dd_region` VALUES (2245, 2162, '百色', '百色市', '中国,广西壮族自治区,百色市', 2, 'baise', '0776', '533000', 'B', '106.616285', '23.897742');
INSERT INTO `dd_region` VALUES (2246, 2245, '右江', '右江区', '中国,广西壮族自治区,百色市,右江区', 3, 'youjiang', '0776', '533000', 'Y', '106.61764', '23.9009');
INSERT INTO `dd_region` VALUES (2247, 2245, '田阳', '田阳县', '中国,广西壮族自治区,百色市,田阳县', 3, 'tianyang', '0776', '533600', 'T', '106.91558', '23.73535');
INSERT INTO `dd_region` VALUES (2248, 2245, '田东', '田东县', '中国,广西壮族自治区,百色市,田东县', 3, 'tiandong', '0776', '531500', 'T', '107.12432', '23.60003');
INSERT INTO `dd_region` VALUES (2249, 2245, '平果', '平果县', '中国,广西壮族自治区,百色市,平果县', 3, 'pingguo', '0776', '531400', 'P', '107.59045', '23.32969');
INSERT INTO `dd_region` VALUES (2250, 2245, '德保', '德保县', '中国,广西壮族自治区,百色市,德保县', 3, 'debao', '0776', '533700', 'D', '106.61917', '23.32515');
INSERT INTO `dd_region` VALUES (2251, 2245, '靖西', '靖西县', '中国,广西壮族自治区,百色市,靖西县', 3, 'jingxi', '0776', '533800', 'J', '106.41766', '23.13425');
INSERT INTO `dd_region` VALUES (2252, 2245, '那坡', '那坡县', '中国,广西壮族自治区,百色市,那坡县', 3, 'napo', '0776', '533900', 'N', '105.84191', '23.40649');
INSERT INTO `dd_region` VALUES (2253, 2245, '凌云', '凌云县', '中国,广西壮族自治区,百色市,凌云县', 3, 'lingyun', '0776', '533100', 'L', '106.56155', '24.34747');
INSERT INTO `dd_region` VALUES (2254, 2245, '乐业', '乐业县', '中国,广西壮族自治区,百色市,乐业县', 3, 'leye', '0776', '533200', 'L', '106.56124', '24.78295');
INSERT INTO `dd_region` VALUES (2255, 2245, '田林', '田林县', '中国,广西壮族自治区,百色市,田林县', 3, 'tianlin', '0776', '533300', 'T', '106.22882', '24.29207');
INSERT INTO `dd_region` VALUES (2256, 2245, '西林', '西林县', '中国,广西壮族自治区,百色市,西林县', 3, 'xilin', '0776', '533500', 'X', '105.09722', '24.48966');
INSERT INTO `dd_region` VALUES (2257, 2245, '隆林', '隆林各族自治县', '中国,广西壮族自治区,百色市,隆林各族自治县', 3, 'longlin', '0776', '533400', 'L', '105.34295', '24.77036');
INSERT INTO `dd_region` VALUES (2258, 2162, '贺州', '贺州市', '中国,广西壮族自治区,贺州市', 2, 'hezhou', '0774', '542800', 'H', '111.552056', '24.414141');
INSERT INTO `dd_region` VALUES (2259, 2258, '八步', '八步区', '中国,广西壮族自治区,贺州市,八步区', 3, 'babu', '0774', '542800', 'B', '111.55225', '24.41179');
INSERT INTO `dd_region` VALUES (2260, 2258, '昭平', '昭平县', '中国,广西壮族自治区,贺州市,昭平县', 3, 'zhaoping', '0774', '546800', 'Z', '110.81082', '24.1701');
INSERT INTO `dd_region` VALUES (2261, 2258, '钟山', '钟山县', '中国,广西壮族自治区,贺州市,钟山县', 3, 'zhongshan', '0774', '542600', 'Z', '111.30459', '24.52482');
INSERT INTO `dd_region` VALUES (2262, 2258, '富川', '富川瑶族自治县', '中国,广西壮族自治区,贺州市,富川瑶族自治县', 3, 'fuchuan', '0774', '542700', 'F', '111.27767', '24.81431');
INSERT INTO `dd_region` VALUES (2263, 2258, '平桂', '平桂管理区', '中国,广西壮族自治区,贺州市,平桂管理区', 3, 'pingui', '0774', '542800', 'P', '111.485651', '24.458041');
INSERT INTO `dd_region` VALUES (2264, 2162, '河池', '河池市', '中国,广西壮族自治区,河池市', 2, 'hechi', '0778', '547000', 'H', '108.062105', '24.695899');
INSERT INTO `dd_region` VALUES (2265, 2264, '金城江', '金城江区', '中国,广西壮族自治区,河池市,金城江区', 3, 'jinchengjiang', '0779', '547000', 'J', '108.03727', '24.6897');
INSERT INTO `dd_region` VALUES (2266, 2264, '南丹', '南丹县', '中国,广西壮族自治区,河池市,南丹县', 3, 'nandan', '0781', '547200', 'N', '107.54562', '24.9776');
INSERT INTO `dd_region` VALUES (2267, 2264, '天峨', '天峨县', '中国,广西壮族自治区,河池市,天峨县', 3, 'tiane', '0782', '547300', 'T', '107.17205', '24.99593');
INSERT INTO `dd_region` VALUES (2268, 2264, '凤山', '凤山县', '中国,广西壮族自治区,河池市,凤山县', 3, 'fengshan', '0783', '547600', 'F', '107.04892', '24.54215');
INSERT INTO `dd_region` VALUES (2269, 2264, '东兰', '东兰县', '中国,广西壮族自治区,河池市,东兰县', 3, 'donglan', '0784', '547400', 'D', '107.37527', '24.51053');
INSERT INTO `dd_region` VALUES (2270, 2264, '罗城', '罗城仫佬族自治县', '中国,广西壮族自治区,河池市,罗城仫佬族自治县', 3, 'luocheng', '0785', '546400', 'L', '108.90777', '24.77923');
INSERT INTO `dd_region` VALUES (2271, 2264, '环江', '环江毛南族自治县', '中国,广西壮族自治区,河池市,环江毛南族自治县', 3, 'huanjiang', '0786', '547100', 'H', '108.26055', '24.82916');
INSERT INTO `dd_region` VALUES (2272, 2264, '巴马', '巴马瑶族自治县', '中国,广西壮族自治区,河池市,巴马瑶族自治县', 3, 'bama', '0787', '547500', 'B', '107.25308', '24.14135');
INSERT INTO `dd_region` VALUES (2273, 2264, '都安', '都安瑶族自治县', '中国,广西壮族自治区,河池市,都安瑶族自治县', 3, 'du\'an', '0788', '530700', 'D', '108.10116', '23.93245');
INSERT INTO `dd_region` VALUES (2274, 2264, '大化', '大化瑶族自治县', '中国,广西壮族自治区,河池市,大化瑶族自治县', 3, 'dahua', '0789', '530800', 'D', '107.9985', '23.74487');
INSERT INTO `dd_region` VALUES (2275, 2264, '宜州', '宜州市', '中国,广西壮族自治区,河池市,宜州市', 3, 'yizhou', '0780', '546300', 'Y', '108.65304', '24.49391');
INSERT INTO `dd_region` VALUES (2276, 2162, '来宾', '来宾市', '中国,广西壮族自治区,来宾市', 2, 'laibin', '0772', '546100', 'L', '109.229772', '23.733766');
INSERT INTO `dd_region` VALUES (2277, 2276, '兴宾', '兴宾区', '中国,广西壮族自治区,来宾市,兴宾区', 3, 'xingbin', '0772', '546100', 'X', '109.23471', '23.72731');
INSERT INTO `dd_region` VALUES (2278, 2276, '忻城', '忻城县', '中国,广西壮族自治区,来宾市,忻城县', 3, 'xincheng', '0772', '546200', 'X', '108.66357', '24.06862');
INSERT INTO `dd_region` VALUES (2279, 2276, '象州', '象州县', '中国,广西壮族自治区,来宾市,象州县', 3, 'xiangzhou', '0772', '545800', 'X', '109.6994', '23.97355');
INSERT INTO `dd_region` VALUES (2280, 2276, '武宣', '武宣县', '中国,广西壮族自治区,来宾市,武宣县', 3, 'wuxuan', '0772', '545900', 'W', '109.66284', '23.59474');
INSERT INTO `dd_region` VALUES (2281, 2276, '金秀', '金秀瑶族自治县', '中国,广西壮族自治区,来宾市,金秀瑶族自治县', 3, 'jinxiu', '0772', '545799', 'J', '110.19079', '24.12929');
INSERT INTO `dd_region` VALUES (2282, 2276, '合山', '合山市', '中国,广西壮族自治区,来宾市,合山市', 3, 'heshan', '0772', '546500', 'H', '108.88586', '23.80619');
INSERT INTO `dd_region` VALUES (2283, 2162, '崇左', '崇左市', '中国,广西壮族自治区,崇左市', 2, 'chongzuo', '0771', '532299', 'C', '107.353926', '22.404108');
INSERT INTO `dd_region` VALUES (2284, 2283, '江州', '江州区', '中国,广西壮族自治区,崇左市,江州区', 3, 'jiangzhou', '0771', '532299', 'J', '107.34747', '22.41135');
INSERT INTO `dd_region` VALUES (2285, 2283, '扶绥', '扶绥县', '中国,广西壮族自治区,崇左市,扶绥县', 3, 'fusui', '0771', '532199', 'F', '107.90405', '22.63413');
INSERT INTO `dd_region` VALUES (2286, 2283, '宁明', '宁明县', '中国,广西壮族自治区,崇左市,宁明县', 3, 'ningming', '0771', '532599', 'N', '107.07299', '22.13655');
INSERT INTO `dd_region` VALUES (2287, 2283, '龙州', '龙州县', '中国,广西壮族自治区,崇左市,龙州县', 3, 'longzhou', '0771', '532499', 'L', '106.85415', '22.33937');
INSERT INTO `dd_region` VALUES (2288, 2283, '大新', '大新县', '中国,广西壮族自治区,崇左市,大新县', 3, 'daxin', '0771', '532399', 'D', '107.19821', '22.83412');
INSERT INTO `dd_region` VALUES (2289, 2283, '天等', '天等县', '中国,广西壮族自治区,崇左市,天等县', 3, 'tiandeng', '0771', '532899', 'T', '107.13998', '23.077');
INSERT INTO `dd_region` VALUES (2290, 2283, '凭祥', '凭祥市', '中国,广西壮族自治区,崇左市,凭祥市', 3, 'pingxiang', '0771', '532699', 'P', '106.75534', '22.10573');
INSERT INTO `dd_region` VALUES (2291, 0, '海南', '海南省', '中国,海南省', 1, 'hainan', '', '', 'H', '110.33119', '20.031971');
INSERT INTO `dd_region` VALUES (2292, 2291, '海口', '海口市', '中国,海南省,海口市', 2, 'haikou', '0898', '570000', 'H', '110.33119', '20.031971');
INSERT INTO `dd_region` VALUES (2293, 2292, '秀英', '秀英区', '中国,海南省,海口市,秀英区', 3, 'xiuying', '0898', '570311', 'X', '110.29345', '20.00752');
INSERT INTO `dd_region` VALUES (2294, 2292, '龙华', '龙华区', '中国,海南省,海口市,龙华区', 3, 'longhua', '0898', '570145', 'L', '110.30194', '20.02866');
INSERT INTO `dd_region` VALUES (2295, 2292, '琼山', '琼山区', '中国,海南省,海口市,琼山区', 3, 'qiongshan', '0898', '571100', 'Q', '110.35418', '20.00321');
INSERT INTO `dd_region` VALUES (2296, 2292, '美兰', '美兰区', '中国,海南省,海口市,美兰区', 3, 'meilan', '0898', '570203', 'M', '110.36908', '20.02864');
INSERT INTO `dd_region` VALUES (2297, 2291, '三亚', '三亚市', '中国,海南省,三亚市', 2, 'sanya', '0898', '572000', 'S', '109.508268', '18.247872');
INSERT INTO `dd_region` VALUES (2298, 2297, '海棠', '海棠区', '中国,海南省,三亚市,海棠区', 3, 'haitang', '0898', '572000', 'H', '109.508268', '18.247872');
INSERT INTO `dd_region` VALUES (2299, 2297, '吉阳', '吉阳区', '中国,海南省,三亚市,吉阳区', 3, 'jiyang', '0898', '572000', 'J', '109.508268', '18.247872');
INSERT INTO `dd_region` VALUES (2300, 2297, '天涯', '天涯区', '中国,海南省,三亚市,天涯区', 3, 'tianya', '0898', '572000', 'T', '109.508268', '18.247872');
INSERT INTO `dd_region` VALUES (2301, 2297, '崖州', '崖州区', '中国,海南省,三亚市,崖州区', 3, 'yazhou', '0898', '572000', 'Y', '109.508268', '18.247872');
INSERT INTO `dd_region` VALUES (2302, 2291, '三沙', '三沙市', '中国,海南省,三沙市', 2, 'sansha', '0898', '573199', 'S', '112.34882', '16.831039');
INSERT INTO `dd_region` VALUES (2303, 2302, '西沙', '西沙群岛', '中国,海南省,三沙市,西沙群岛', 3, 'xishaislands', '0898', '572000', 'X', '112.025528', '16.331342');
INSERT INTO `dd_region` VALUES (2304, 2302, '南沙', '南沙群岛', '中国,海南省,三沙市,南沙群岛', 3, 'nanshaislands', '0898', '573100', 'N', '116.749998', '11.471888');
INSERT INTO `dd_region` VALUES (2305, 2302, '中沙', '中沙群岛', '中国,海南省,三沙市,中沙群岛', 3, 'zhongshaislands', '0898', '573100', 'Z', '117.740071', '15.112856');
INSERT INTO `dd_region` VALUES (2306, 2291, ' ', '直辖县级', '中国,海南省,直辖县级', 2, '', '', '', 'Z', '109.503479', '18.739906');
INSERT INTO `dd_region` VALUES (2307, 2306, '五指山', '五指山市', '中国,海南省,直辖县级,五指山市', 3, 'wuzhishan', '0898', '572200', 'W', '109.516662', '18.776921');
INSERT INTO `dd_region` VALUES (2308, 2306, '琼海', '琼海市', '中国,海南省,直辖县级,琼海市', 3, 'qionghai', '0898', '571400', 'Q', '110.466785', '19.246011');
INSERT INTO `dd_region` VALUES (2309, 2306, '儋州', '儋州市', '中国,海南省,直辖县级,儋州市', 3, 'danzhou', '0898', '571700', NULL, '109.576782', '19.517486');
INSERT INTO `dd_region` VALUES (2310, 2306, '文昌', '文昌市', '中国,海南省,直辖县级,文昌市', 3, 'wenchang', '0898', '571339', 'W', '110.753975', '19.612986');
INSERT INTO `dd_region` VALUES (2311, 2306, '万宁', '万宁市', '中国,海南省,直辖县级,万宁市', 3, 'wanning', '0898', '571500', 'W', '110.388793', '18.796216');
INSERT INTO `dd_region` VALUES (2312, 2306, '东方', '东方市', '中国,海南省,直辖县级,东方市', 3, 'dongfang', '0898', '572600', 'D', '108.653789', '19.10198');
INSERT INTO `dd_region` VALUES (2313, 2306, '定安', '定安县', '中国,海南省,直辖县级,定安县', 3, 'ding\'an', '0898', '571200', 'D', '110.323959', '19.699211');
INSERT INTO `dd_region` VALUES (2314, 2306, '屯昌', '屯昌县', '中国,海南省,直辖县级,屯昌县', 3, 'tunchang', '0898', '571600', 'T', '110.102773', '19.362916');
INSERT INTO `dd_region` VALUES (2315, 2306, '澄迈', '澄迈县', '中国,海南省,直辖县级,澄迈县', 3, 'chengmai', '0898', '571900', 'C', '110.007147', '19.737095');
INSERT INTO `dd_region` VALUES (2316, 2306, '临高', '临高县', '中国,海南省,直辖县级,临高县', 3, 'lingao', '0898', '571800', 'L', '109.687697', '19.908293');
INSERT INTO `dd_region` VALUES (2317, 2306, '白沙', '白沙黎族自治县', '中国,海南省,直辖县级,白沙黎族自治县', 3, 'baisha', '0898', '572800', 'B', '109.452606', '19.224584');
INSERT INTO `dd_region` VALUES (2318, 2306, '昌江', '昌江黎族自治县', '中国,海南省,直辖县级,昌江黎族自治县', 3, 'changjiang', '0898', '572700', 'C', '109.053351', '19.260968');
INSERT INTO `dd_region` VALUES (2319, 2306, '乐东', '乐东黎族自治县', '中国,海南省,直辖县级,乐东黎族自治县', 3, 'ledong', '0898', '572500', 'L', '109.175444', '18.74758');
INSERT INTO `dd_region` VALUES (2320, 2306, '陵水', '陵水黎族自治县', '中国,海南省,直辖县级,陵水黎族自治县', 3, 'lingshui', '0898', '572400', 'L', '110.037218', '18.505006');
INSERT INTO `dd_region` VALUES (2321, 2306, '保亭', '保亭黎族苗族自治县', '中国,海南省,直辖县级,保亭黎族苗族自治县', 3, 'baoting', '0898', '572300', 'B', '109.70245', '18.636371');
INSERT INTO `dd_region` VALUES (2322, 2306, '琼中', '琼中黎族苗族自治县', '中国,海南省,直辖县级,琼中黎族苗族自治县', 3, 'qiongzhong', '0898', '572900', 'Q', '109.839996', '19.03557');
INSERT INTO `dd_region` VALUES (2323, 0, '重庆', '重庆市', '中国,重庆', 1, 'chongqing', '', '', 'Z', '106.504962', '29.533155');
INSERT INTO `dd_region` VALUES (2324, 2323, '重庆', '重庆市', '中国,重庆,重庆市', 2, 'chongqing', '023', '400000', 'Z', '106.504962', '29.533155');
INSERT INTO `dd_region` VALUES (2325, 2324, '万州', '万州区', '中国,重庆,重庆市,万州区', 3, 'wanzhou', '023', '404000', 'W', '108.40869', '30.80788');
INSERT INTO `dd_region` VALUES (2326, 2324, '涪陵', '涪陵区', '中国,重庆,重庆市,涪陵区', 3, 'fuling', '023', '408000', 'F', '107.39007', '29.70292');
INSERT INTO `dd_region` VALUES (2327, 2324, '渝中', '渝中区', '中国,重庆,重庆市,渝中区', 3, 'yuzhong', '023', '400010', 'Y', '106.56901', '29.55279');
INSERT INTO `dd_region` VALUES (2328, 2324, '大渡口', '大渡口区', '中国,重庆,重庆市,大渡口区', 3, 'dadukou', '023', '400080', 'D', '106.48262', '29.48447');
INSERT INTO `dd_region` VALUES (2329, 2324, '江北', '江北区', '中国,重庆,重庆市,江北区', 3, 'jiangbei', '023', '400020', 'J', '106.57434', '29.60658');
INSERT INTO `dd_region` VALUES (2330, 2324, '沙坪坝', '沙坪坝区', '中国,重庆,重庆市,沙坪坝区', 3, 'shapingba', '023', '400030', 'S', '106.45752', '29.54113');
INSERT INTO `dd_region` VALUES (2331, 2324, '九龙坡', '九龙坡区', '中国,重庆,重庆市,九龙坡区', 3, 'jiulongpo', '023', '400050', 'J', '106.51107', '29.50197');
INSERT INTO `dd_region` VALUES (2332, 2324, '南岸', '南岸区', '中国,重庆,重庆市,南岸区', 3, 'nan\'an', '023', '400064', 'N', '106.56347', '29.52311');
INSERT INTO `dd_region` VALUES (2333, 2324, '北碚', '北碚区', '中国,重庆,重庆市,北碚区', 3, 'beibei', '023', '400700', 'B', '106.39614', '29.80574');
INSERT INTO `dd_region` VALUES (2334, 2324, '綦江', '綦江区', '中国,重庆,重庆市,