<?php

use yii\db\Migration;

class m210301_130336_auth_route extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%auth_route}}', [
            'id' => "int(11) NOT NULL AUTO_INCREMENT",
            'name' => "varchar(64) NOT NULL",
            'type' => "smallint(6) NOT NULL",
            'description' => "text NULL",
            'title' => "varchar(64) NULL",
            'pid' => "int(11) NULL DEFAULT '0'",
            'data' => "blob NULL",
            'module_name' => "varchar(50) NULL",
            'created_at' => "int(11) NULL",
            'updated_at' => "int(11) NULL",
            'PRIMARY KEY (`id`,`name`)'
        ], "ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT");
        
        /* 索引设置 */
        $this->createIndex('name','{{%auth_route}}','name',1);
        $this->createIndex('rule_name','{{%auth_route}}','title',0);
        $this->createIndex('type','{{%auth_route}}','type',0);
        
        
        /* 表数据 */
        $this->insert('{{%auth_route}}',['id'=>'3','name'=>'/settings/default/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634163','updated_at'=>'1588634163']);
        $this->insert('{{%auth_route}}',['id'=>'5','name'=>'/settings/default/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'6','name'=>'/settings/default/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'7','name'=>'/settings/default/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'8','name'=>'/settings/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'9','name'=>'/admin/assignment/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'10','name'=>'/admin/assignment/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'11','name'=>'/admin/assignment/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'12','name'=>'/admin/assignment/assign','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'13','name'=>'/admin/assignment/revoke','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'14','name'=>'/admin/assignment/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634166','updated_at'=>'1588634166']);
        $this->insert('{{%auth_route}}',['id'=>'28','name'=>'/admin/default/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'29','name'=>'/admin/default/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'30','name'=>'/admin/default/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'38','name'=>'/admin/group/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'39','name'=>'/admin/group/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'40','name'=>'/admin/group/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'41','name'=>'/admin/group/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'42','name'=>'/admin/group/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634167','updated_at'=>'1588634167']);
        $this->insert('{{%auth_route}}',['id'=>'43','name'=>'/admin/group/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'44','name'=>'/admin/group/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'45','name'=>'/admin/menu/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'46','name'=>'/admin/menu/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'47','name'=>'/admin/menu/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'48','name'=>'/admin/menu/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'49','name'=>'/admin/menu/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'50','name'=>'/admin/menu/update-files','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'51','name'=>'/admin/menu/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'52','name'=>'/admin/menu/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'53','name'=>'/admin/menu-top/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'54','name'=>'/admin/menu-top/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'55','name'=>'/admin/menu-top/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'56','name'=>'/admin/menu-top/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'57','name'=>'/admin/menu-top/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'58','name'=>'/admin/menu-top/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'59','name'=>'/admin/permission/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'60','name'=>'/admin/permission/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'61','name'=>'/admin/permission/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'62','name'=>'/admin/permission/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'63','name'=>'/admin/permission/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'64','name'=>'/admin/permission/assign','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'65','name'=>'/admin/permission/remove','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'66','name'=>'/admin/permission/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'67','name'=>'/admin/role/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'68','name'=>'/admin/role/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'69','name'=>'/admin/role/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'70','name'=>'/admin/role/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634168','updated_at'=>'1588634168']);
        $this->insert('{{%auth_route}}',['id'=>'71','name'=>'/admin/role/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'72','name'=>'/admin/role/assign','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'73','name'=>'/admin/role/remove','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'74','name'=>'/admin/role/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'75','name'=>'/admin/route/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'76','name'=>'/admin/route/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'77','name'=>'/admin/route/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'78','name'=>'/admin/route/assign','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'79','name'=>'/admin/route/remove','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'80','name'=>'/admin/route/refresh','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'81','name'=>'/admin/route/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'82','name'=>'/admin/rule/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'83','name'=>'/admin/rule/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'84','name'=>'/admin/rule/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'85','name'=>'/admin/rule/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'86','name'=>'/admin/rule/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'87','name'=>'/admin/rule/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'88','name'=>'/admin/rule/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'97','name'=>'/admin/user-bloc/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634169','updated_at'=>'1588634169']);
        $this->insert('{{%auth_route}}',['id'=>'98','name'=>'/admin/user/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'99','name'=>'/admin/user/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'100','name'=>'/admin/user/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'101','name'=>'/admin/user/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'102','name'=>'/admin/user/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'103','name'=>'/admin/user/login','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'104','name'=>'/admin/user/logout','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'105','name'=>'/admin/user/signup','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'106','name'=>'/admin/user/request-password-reset','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'107','name'=>'/admin/user/reset-password','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'108','name'=>'/admin/user/change-password','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'109','name'=>'/admin/user/activate','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'110','name'=>'/admin/user/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'125','name'=>'/admin/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'126','name'=>'/modal/modal/website','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634170','updated_at'=>'1588634170']);
        $this->insert('{{%auth_route}}',['id'=>'127','name'=>'/modal/modal/icons','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'128','name'=>'/modal/modal/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'129','name'=>'/modal/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'130','name'=>'/addons/addons/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'131','name'=>'/addons/addons/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'132','name'=>'/addons/addons/uninstalled','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'133','name'=>'/addons/addons/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'134','name'=>'/addons/addons/logo','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'135','name'=>'/addons/addons/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'136','name'=>'/addons/addons/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'137','name'=>'/addons/addons/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'138','name'=>'/addons/addons/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'139','name'=>'/addons/manage/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'140','name'=>'/addons/manage/install','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'141','name'=>'/addons/manage/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'142','name'=>'/addons/manage/uninstall','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'143','name'=>'/addons/manage/auth','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'144','name'=>'/addons/manage/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'145','name'=>'/addons/menu/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'146','name'=>'/addons/menu/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'147','name'=>'/addons/menu/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'148','name'=>'/addons/menu/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'149','name'=>'/addons/menu/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'150','name'=>'/addons/menu/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'151','name'=>'/addons/menu/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'152','name'=>'/addons/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634171','updated_at'=>'1588634171']);
        $this->insert('{{%auth_route}}',['id'=>'153','name'=>'/gii/default/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'154','name'=>'/gii/default/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'155','name'=>'/gii/default/preview','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'156','name'=>'/gii/default/diff','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'157','name'=>'/gii/default/action','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'158','name'=>'/gii/default/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'159','name'=>'/gii/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634172','updated_at'=>'1588634172']);
        $this->insert('{{%auth_route}}',['id'=>'296','name'=>'/base/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'297','name'=>'/base/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'298','name'=>'/module/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'299','name'=>'/module/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'300','name'=>'/module/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'301','name'=>'/site/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'302','name'=>'/site/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'303','name'=>'/site/login','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'304','name'=>'/site/logout','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'305','name'=>'/site/signup','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'306','name'=>'/site/request-password-reset','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'307','name'=>'/site/reset-password','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'308','name'=>'/site/verify-email','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634177','updated_at'=>'1588634177']);
        $this->insert('{{%auth_route}}',['id'=>'309','name'=>'/site/resend-verification-email','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'310','name'=>'/site/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'311','name'=>'/article/dd-article-category/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'312','name'=>'/article/dd-article-category/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'313','name'=>'/article/dd-article-category/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'314','name'=>'/article/dd-article-category/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'315','name'=>'/article/dd-article-category/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'316','name'=>'/article/dd-article-category/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'317','name'=>'/article/dd-article-category/childcate','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'318','name'=>'/article/dd-article-category/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'319','name'=>'/article/dd-article/upload','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'320','name'=>'/article/dd-article/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'321','name'=>'/article/dd-article/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'322','name'=>'/article/dd-article/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'323','name'=>'/article/dd-article/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'324','name'=>'/article/dd-article/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'325','name'=>'/article/dd-article/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'326','name'=>'/article/record/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'327','name'=>'/article/record/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'328','name'=>'/article/record/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'329','name'=>'/article/record/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'330','name'=>'/article/record/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'331','name'=>'/article/record/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'332','name'=>'/demo/form/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'333','name'=>'/demo/form/get-region','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'334','name'=>'/demo/form/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'335','name'=>'/demo/form/maile','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634178','updated_at'=>'1588634178']);
        $this->insert('{{%auth_route}}',['id'=>'336','name'=>'/demo/form/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'337','name'=>'/diandiai/dd-ai-applications/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'338','name'=>'/diandiai/dd-ai-applications/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'339','name'=>'/diandiai/dd-ai-applications/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'340','name'=>'/diandiai/dd-ai-applications/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'341','name'=>'/diandiai/dd-ai-applications/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'342','name'=>'/diandiai/dd-ai-applications/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'343','name'=>'/diandiai/dd-ai-applications/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'344','name'=>'/diandiai/dd-ai-faces/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'345','name'=>'/diandiai/dd-ai-faces/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'346','name'=>'/diandiai/dd-ai-faces/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'347','name'=>'/diandiai/dd-ai-faces/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'348','name'=>'/diandiai/dd-ai-faces/users','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'349','name'=>'/diandiai/dd-ai-faces/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'350','name'=>'/diandiai/dd-ai-faces/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'351','name'=>'/diandiai/dd-ai-faces/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'352','name'=>'/diandiai/dd-ai-groups/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'353','name'=>'/diandiai/dd-ai-groups/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'354','name'=>'/diandiai/dd-ai-groups/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'355','name'=>'/diandiai/dd-ai-groups/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'356','name'=>'/diandiai/dd-ai-groups/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'357','name'=>'/diandiai/dd-ai-groups/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'358','name'=>'/diandiai/dd-ai-groups/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'359','name'=>'/diandiai/dd-ai-member/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'360','name'=>'/diandiai/dd-ai-member/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'361','name'=>'/diandiai/dd-ai-member/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'362','name'=>'/diandiai/dd-ai-member/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634179','updated_at'=>'1588634179']);
        $this->insert('{{%auth_route}}',['id'=>'363','name'=>'/diandiai/dd-ai-member/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'364','name'=>'/diandiai/dd-ai-member/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'365','name'=>'/diandiai/dd-ai-member/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'366','name'=>'/member/dd-member/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'367','name'=>'/member/dd-member/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'368','name'=>'/member/dd-member/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'369','name'=>'/member/dd-member/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'370','name'=>'/member/dd-member/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'371','name'=>'/member/dd-member/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'372','name'=>'/member/dd-member/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'373','name'=>'/member/dd-member-group/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'374','name'=>'/member/dd-member-group/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'375','name'=>'/member/dd-member-group/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'376','name'=>'/member/dd-member-group/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'377','name'=>'/member/dd-member-group/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'378','name'=>'/member/dd-member-group/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'379','name'=>'/member/dd-member-group/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'380','name'=>'/system/index/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'381','name'=>'/system/index/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'382','name'=>'/system/index/childcate','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'383','name'=>'/system/index/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'384','name'=>'/system/settings/baidu','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'385','name'=>'/system/settings/wxapp','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634180','updated_at'=>'1588634180']);
        $this->insert('{{%auth_route}}',['id'=>'386','name'=>'/system/settings/wechatpay','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'387','name'=>'/system/settings/weburl','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'388','name'=>'/system/settings/sms','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'389','name'=>'/system/settings/email','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'390','name'=>'/system/settings/clear-cache','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'391','name'=>'/system/settings/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'392','name'=>'/system/welcome/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'393','name'=>'/system/welcome/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'394','name'=>'/system/welcome/sysai','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'395','name'=>'/system/welcome/member','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'396','name'=>'/system/welcome/aimember','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'397','name'=>'/system/welcome/goods','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'398','name'=>'/system/welcome/marketing','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'399','name'=>'/system/welcome/order','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'400','name'=>'/system/welcome/wxapp','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'401','name'=>'/system/welcome/plugins','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'402','name'=>'/system/welcome/system','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'403','name'=>'/system/welcome/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'404','name'=>'/upload/upload/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'405','name'=>'/upload/upload/uploadimg','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'406','name'=>'/upload/upload/uploadfile','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'407','name'=>'/upload/upload/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'408','name'=>'/user/dd-user/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'409','name'=>'/user/dd-user/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'410','name'=>'/user/dd-user/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'411','name'=>'/user/dd-user/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'412','name'=>'/user/dd-user/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'413','name'=>'/user/dd-user/profile','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'414','name'=>'/user/dd-user/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634181','updated_at'=>'1588634181']);
        $this->insert('{{%auth_route}}',['id'=>'415','name'=>'/user/dd-user/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'416','name'=>'/website/dd-website-contact/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'417','name'=>'/website/dd-website-contact/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'418','name'=>'/website/dd-website-contact/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'419','name'=>'/website/dd-website-contact/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'420','name'=>'/website/dd-website-contact/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'421','name'=>'/website/dd-website-contact/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'422','name'=>'/website/dd-website-contact/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'423','name'=>'/website/dd-website-slide/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'424','name'=>'/website/dd-website-slide/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'425','name'=>'/website/dd-website-slide/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'426','name'=>'/website/dd-website-slide/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'427','name'=>'/website/dd-website-slide/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'428','name'=>'/website/dd-website-slide/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'429','name'=>'/website/dd-website-slide/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'430','name'=>'/website/setting/website','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'431','name'=>'/website/setting/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'432','name'=>'/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588634182','updated_at'=>'1588634182']);
        $this->insert('{{%auth_route}}',['id'=>'433','name'=>'/admin/group/assign','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588749311','updated_at'=>'1588749311']);
        $this->insert('{{%auth_route}}',['id'=>'434','name'=>'/admin/group/remove','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1588749311','updated_at'=>'1588749311']);
        $this->insert('{{%auth_route}}',['id'=>'455','name'=>'/system/settings/map','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1590020676','updated_at'=>'1590020676']);
        $this->insert('{{%auth_route}}',['id'=>'456','name'=>'/system/settings/set-cache','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1590020676','updated_at'=>'1590020676']);
        $this->insert('{{%auth_route}}',['id'=>'1068','name'=>'/member/dd-member/cac-vs','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1600478586','updated_at'=>'1600478586']);
        $this->insert('{{%auth_route}}',['id'=>'1069','name'=>'/system/settings/wechat','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1600478587','updated_at'=>'1600478587']);
        $this->insert('{{%auth_route}}',['id'=>'1210','name'=>'/admin/category/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1211','name'=>'/admin/category/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1212','name'=>'/admin/category/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1213','name'=>'/admin/category/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1214','name'=>'/admin/category/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1215','name'=>'/admin/category/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1216','name'=>'/admin/category/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1217','name'=>'/admin/store/childcate','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1605723025','updated_at'=>'1605723025']);
        $this->insert('{{%auth_route}}',['id'=>'1366','name'=>'/addons/menu/update-files','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731582','updated_at'=>'1610731582']);
        $this->insert('{{%auth_route}}',['id'=>'1477','name'=>'/member/account/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1478','name'=>'/member/account/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1479','name'=>'/member/account/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1480','name'=>'/member/account/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1481','name'=>'/member/account/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1482','name'=>'/member/account/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1483','name'=>'/member/account/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1484','name'=>'/member/dd-member/repassword','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610731583','updated_at'=>'1610731583']);
        $this->insert('{{%auth_route}}',['id'=>'1510','name'=>'/addons/baidu/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812024','updated_at'=>'1610812024']);
        $this->insert('{{%auth_route}}',['id'=>'1511','name'=>'/addons/baidu/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812024','updated_at'=>'1610812024']);
        $this->insert('{{%auth_route}}',['id'=>'1512','name'=>'/addons/baidu/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1513','name'=>'/addons/baidu/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1514','name'=>'/addons/baidu/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1515','name'=>'/addons/baidu/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1516','name'=>'/addons/baidu/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1517','name'=>'/addons/bloc/change-username','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1518','name'=>'/addons/bloc/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1519','name'=>'/addons/bloc/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1520','name'=>'/addons/bloc/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1521','name'=>'/addons/bloc/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1522','name'=>'/addons/bloc/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1523','name'=>'/addons/bloc/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1524','name'=>'/addons/category/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1525','name'=>'/addons/category/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1526','name'=>'/addons/category/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1527','name'=>'/addons/category/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1528','name'=>'/addons/category/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1529','name'=>'/addons/category/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1530','name'=>'/addons/category/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1531','name'=>'/addons/email/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1532','name'=>'/addons/email/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1533','name'=>'/addons/email/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1534','name'=>'/addons/email/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1535','name'=>'/addons/email/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1536','name'=>'/addons/email/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1537','name'=>'/addons/email/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1538','name'=>'/addons/setting/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1539','name'=>'/addons/sms/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1540','name'=>'/addons/sms/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1541','name'=>'/addons/sms/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1542','name'=>'/addons/sms/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1543','name'=>'/addons/sms/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1544','name'=>'/addons/sms/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1545','name'=>'/addons/sms/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1546','name'=>'/addons/user-bloc/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610812025','updated_at'=>'1610812025']);
        $this->insert('{{%auth_route}}',['id'=>'1547','name'=>'/addons/store/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1548','name'=>'/addons/store/get-region','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1549','name'=>'/addons/store/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1550','name'=>'/addons/store/childcate','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1551','name'=>'/addons/store/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1552','name'=>'/addons/store/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1553','name'=>'/addons/store/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1554','name'=>'/addons/store/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1555','name'=>'/addons/store/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1556','name'=>'/addons/storelabel/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1557','name'=>'/addons/storelabel/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1558','name'=>'/addons/storelabel/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1559','name'=>'/addons/storelabel/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1560','name'=>'/addons/storelabel/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1561','name'=>'/addons/storelabel/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1562','name'=>'/addons/storelabel/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1610816283','updated_at'=>'1610816283']);
        $this->insert('{{%auth_route}}',['id'=>'1563','name'=>'/addons/storelabellink/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1564','name'=>'/addons/storelabellink/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1565','name'=>'/addons/storelabellink/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1566','name'=>'/addons/storelabellink/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1567','name'=>'/addons/storelabellink/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1568','name'=>'/addons/storelabellink/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1569','name'=>'/addons/storelabellink/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1570','name'=>'/addons/wechatpay/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1571','name'=>'/addons/wechatpay/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1572','name'=>'/addons/wechatpay/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1573','name'=>'/addons/wechatpay/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1574','name'=>'/addons/wechatpay/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1575','name'=>'/addons/wechatpay/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1576','name'=>'/addons/wechatpay/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1577','name'=>'/addons/wxapp/error','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1578','name'=>'/addons/wxapp/index','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1579','name'=>'/addons/wxapp/view','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1580','name'=>'/addons/wxapp/create','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1581','name'=>'/addons/wxapp/update','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1582','name'=>'/addons/wxapp/delete','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1583','name'=>'/addons/wxapp/*','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1611371821','updated_at'=>'1611371821']);
        $this->insert('{{%auth_route}}',['id'=>'1596','name'=>'/diandi_shop/order/reason/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1597','name'=>'/diandi_shop/order/reason/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1598','name'=>'/diandi_shop/order/reason/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1599','name'=>'/diandi_shop/order/reason/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1600','name'=>'/diandi_shop/order/reason/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1601','name'=>'/diandi_shop/order/refund/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1602','name'=>'/diandi_shop/order/refund/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1603','name'=>'/diandi_shop/order/refund/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1604','name'=>'/diandi_shop/order/refund/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1605','name'=>'/diandi_shop/order/refund/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1606','name'=>'/diandi_shop/order/refund/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1607','name'=>'/diandi_shop/order/refund/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1608','name'=>'/diandi_shop/order/refundlog/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1609','name'=>'/diandi_shop/order/refundlog/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1610','name'=>'/diandi_shop/order/refundlog/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1611','name'=>'/diandi_shop/order/refundlog/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1612','name'=>'/diandi_shop/order/refundlog/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1613','name'=>'/diandi_shop/order/refundlog/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1614','name'=>'/diandi_shop/order/refundlog/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1615','name'=>'/diandi_shop/setting/store/childcate','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1611448441','updated_at'=>'1611448441']);
        $this->insert('{{%auth_route}}',['id'=>'1616','name'=>'/diandi_integral/default/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1617','name'=>'/diandi_integral/default/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1618','name'=>'/diandi_integral/default/xiufu','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1619','name'=>'/diandi_integral/default/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1620','name'=>'/diandi_integral/goods/dd-category/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1621','name'=>'/diandi_integral/goods/dd-category/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1622','name'=>'/diandi_integral/goods/dd-category/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1623','name'=>'/diandi_integral/goods/dd-category/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1624','name'=>'/diandi_integral/goods/dd-category/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1625','name'=>'/diandi_integral/goods/dd-category/goodslist','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1626','name'=>'/diandi_integral/goods/dd-category/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1627','name'=>'/diandi_integral/goods/dd-category/childcate','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1628','name'=>'/diandi_integral/goods/dd-category/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1629','name'=>'/diandi_integral/goods/dd-goods/upload','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1630','name'=>'/diandi_integral/goods/dd-goods/change-username','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1631','name'=>'/diandi_integral/goods/dd-goods/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1632','name'=>'/diandi_integral/goods/dd-goods/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1633','name'=>'/diandi_integral/goods/dd-goods/validate','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1634','name'=>'/diandi_integral/goods/dd-goods/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1635','name'=>'/diandi_integral/goods/dd-goods/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1636','name'=>'/diandi_integral/goods/dd-goods/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1637','name'=>'/diandi_integral/goods/dd-goods/specitem','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1638','name'=>'/diandi_integral/goods/dd-goods/param','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1639','name'=>'/diandi_integral/goods/dd-goods/spec','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1640','name'=>'/diandi_integral/goods/dd-goods/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1641','name'=>'/diandi_integral/order/dd-delivery/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1642','name'=>'/diandi_integral/order/dd-delivery/get-region','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1643','name'=>'/diandi_integral/order/dd-delivery/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1644','name'=>'/diandi_integral/order/dd-delivery/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1645','name'=>'/diandi_integral/order/dd-delivery/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1646','name'=>'/diandi_integral/order/dd-delivery/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1647','name'=>'/diandi_integral/order/dd-delivery/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1648','name'=>'/diandi_integral/order/dd-delivery/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1649','name'=>'/diandi_integral/order/dd-delivery-rule/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1650','name'=>'/diandi_integral/order/dd-delivery-rule/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1651','name'=>'/diandi_integral/order/dd-delivery-rule/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1652','name'=>'/diandi_integral/order/dd-delivery-rule/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1653','name'=>'/diandi_integral/order/dd-delivery-rule/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1654','name'=>'/diandi_integral/order/dd-delivery-rule/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1655','name'=>'/diandi_integral/order/dd-delivery-rule/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1656','name'=>'/diandi_integral/order/dd-order/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1657','name'=>'/diandi_integral/order/dd-order/get-region','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1658','name'=>'/diandi_integral/order/dd-order/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1659','name'=>'/diandi_integral/order/dd-order/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1660','name'=>'/diandi_integral/order/dd-order/upaddress','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1661','name'=>'/diandi_integral/order/dd-order/expresscode','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1662','name'=>'/diandi_integral/order/dd-order/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1663','name'=>'/diandi_integral/order/dd-order/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1664','name'=>'/diandi_integral/order/dd-order/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1665','name'=>'/diandi_integral/order/dd-order/confirm','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1666','name'=>'/diandi_integral/order/dd-order/exportdata','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1667','name'=>'/diandi_integral/order/dd-order/printsip','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1668','name'=>'/diandi_integral/order/dd-order/printcloud','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1669','name'=>'/diandi_integral/order/dd-order/prints','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1670','name'=>'/diandi_integral/order/dd-order/deletes','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1671','name'=>'/diandi_integral/order/dd-order/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1672','name'=>'/diandi_integral/setting/area/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1673','name'=>'/diandi_integral/setting/area/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1674','name'=>'/diandi_integral/setting/area/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1675','name'=>'/diandi_integral/setting/area/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1676','name'=>'/diandi_integral/setting/area/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1677','name'=>'/diandi_integral/setting/area/setdefault','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1678','name'=>'/diandi_integral/setting/area/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1679','name'=>'/diandi_integral/setting/area/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1680','name'=>'/diandi_integral/setting/comment/change-status','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1681','name'=>'/diandi_integral/setting/comment/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1682','name'=>'/diandi_integral/setting/comment/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1683','name'=>'/diandi_integral/setting/comment/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1684','name'=>'/diandi_integral/setting/comment/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1685','name'=>'/diandi_integral/setting/comment/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1686','name'=>'/diandi_integral/setting/comment/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1687','name'=>'/diandi_integral/setting/store/error','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1688','name'=>'/diandi_integral/setting/store/get-region','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1689','name'=>'/diandi_integral/setting/store/index','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1690','name'=>'/diandi_integral/setting/store/childcate','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1691','name'=>'/diandi_integral/setting/store/view','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1692','name'=>'/diandi_integral/setting/store/create','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1693','name'=>'/diandi_integral/setting/store/update','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1694','name'=>'/diandi_integral/setting/store/delete','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1695','name'=>'/diandi_integral/setting/store/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1696','name'=>'/diandi_integral/*','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1613999882','updated_at'=>'1613999882']);
        $this->insert('{{%auth_route}}',['id'=>'1697','name'=>'/diandi_distribution/account/log/exportdatalist','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_distribution','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1698','name'=>'/diandi_distribution/account/order/exportdatalist','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_distribution','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1699','name'=>'/diandi_distribution/account/withdrawlog/exportdatalist','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_distribution','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1700','name'=>'/diandi_distribution/conf/slide/change-order','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_distribution','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1701','name'=>'/diandi_distribution/goods/dd-goods/exportdatalist','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_distribution','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1702','name'=>'/diandi_distribution/goods/location/change-order','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_distribution','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1703','name'=>'/diandi_distribution/member/bank/exportdatalist','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_distribution','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1704','name'=>'/diandi_shop/goods/label/ceshi','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_shop','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1705','name'=>'/diandi_integral/order/dd-order/exportdatalist','type'=>'1','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'diandi_integral','created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1706','name'=>'/member/dd-member/groups','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>NULL,'created_at'=>'1614044208','updated_at'=>'1614044208']);
        $this->insert('{{%auth_route}}',['id'=>'1707','name'=>'/system/settings/store','type'=>'0','description'=>NULL,'title'=>NULL,'pid'=>'0','data'=>NULL,'module_name'=>'sys','created_at'=>'1614044208','updated_at'=>'1614044208']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%auth_route}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

