<?php

use yii\db\Migration;

class m210301_130336_core_paylog extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%core_paylog}}', [
            'plid' => "bigint(11) unsigned NOT NULL AUTO_INCREMENT",
            'bloc_id' => "int(11) NULL",
            'store_id' => "int(11) NULL",
            'type' => "varchar(20) NOT NULL COMMENT '支付类型'",
            'openid' => "varchar(40) NULL COMMENT 'openid'",
            'member_id' => "int(11) NULL",
            'uniontid' => "varchar(64) NULL COMMENT '跨应用标识'",
            'tid' => "varchar(128) NULL",
            'fee' => "decimal(10,2) NOT NULL COMMENT '支付金额'",
            'status' => "tinyint(4) NOT NULL COMMENT '支付状态'",
            'module' => "varchar(50) NOT NULL COMMENT '模块'",
            'tag' => "varchar(2000) NOT NULL",
            'is_usecard' => "tinyint(3) unsigned NULL COMMENT '是否使用会员卡'",
            'card_type' => "tinyint(3) unsigned NULL COMMENT '会员卡类型'",
            'card_id' => "varchar(50) NULL COMMENT '会员卡id'",
            'card_fee' => "decimal(10,2) unsigned NULL COMMENT '会员卡余额'",
            'encrypt_code' => "varchar(100) NULL COMMENT '加密字符串'",
            'is_wish' => "tinyint(11) NULL",
            'create_time' => "int(11) NULL",
            'update_time' => "int(11) NULL",
            'PRIMARY KEY (`plid`)'
        ], "ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT");
        
        /* 索引设置 */
        $this->createIndex('idx_openid','{{%core_paylog}}','openid',0);
        $this->createIndex('idx_tid','{{%core_paylog}}','tid',0);
        $this->createIndex('uniontid','{{%core_paylog}}','uniontid',0);
        
        
        /* 表数据 */
        $this->insert('{{%core_paylog}}',['plid'=>'152','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112197505454','tid'=>'4200000737202011211941658147','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1605971626','update_time'=>'1605971626']);
        $this->insert('{{%core_paylog}}',['plid'=>'153','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112197981015','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1605971930','update_time'=>'1605971930']);
        $this->insert('{{%core_paylog}}',['plid'=>'154','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112154505149','tid'=>'4200000731202011214088423106','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1605972038','update_time'=>'1605972038']);
        $this->insert('{{%core_paylog}}',['plid'=>'155','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112148539956','tid'=>'4200000732202011217699568578','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1605972352','update_time'=>'1605972352']);
        $this->insert('{{%core_paylog}}',['plid'=>'156','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112252491021','tid'=>NULL,'fee'=>'9800.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1605974820','update_time'=>'1605974820']);
        $this->insert('{{%core_paylog}}',['plid'=>'157','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112248989855','tid'=>NULL,'fee'=>'1198.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1605975248','update_time'=>'1605975248']);
        $this->insert('{{%core_paylog}}',['plid'=>'158','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112252515451','tid'=>NULL,'fee'=>'799.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1605997156','update_time'=>'1605997156']);
        $this->insert('{{%core_paylog}}',['plid'=>'159','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112350561005','tid'=>NULL,'fee'=>'99.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606062578','update_time'=>'1606062578']);
        $this->insert('{{%core_paylog}}',['plid'=>'160','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112352100491','tid'=>NULL,'fee'=>'799.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606063332','update_time'=>'1606063332']);
        $this->insert('{{%core_paylog}}',['plid'=>'161','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'2','uniontid'=>'2020112350555553','tid'=>NULL,'fee'=>'799.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606063346','update_time'=>'1606063346']);
        $this->insert('{{%core_paylog}}',['plid'=>'162','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112453971021','tid'=>NULL,'fee'=>'1600.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606186837','update_time'=>'1606186837']);
        $this->insert('{{%core_paylog}}',['plid'=>'163','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'16','uniontid'=>'2020112497975149','tid'=>NULL,'fee'=>'99.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606190986','update_time'=>'1606190986']);
        $this->insert('{{%core_paylog}}',['plid'=>'164','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020112456100995','tid'=>NULL,'fee'=>'1600.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606191096','update_time'=>'1606191096']);
        $this->insert('{{%core_paylog}}',['plid'=>'165','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'15','uniontid'=>'2020112410010154','tid'=>NULL,'fee'=>'9800.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606192958','update_time'=>'1606192958']);
        $this->insert('{{%core_paylog}}',['plid'=>'166','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112551100521','tid'=>NULL,'fee'=>'1600.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606266419','update_time'=>'1606266419']);
        $this->insert('{{%core_paylog}}',['plid'=>'167','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112552481019','tid'=>NULL,'fee'=>'1600.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606266420','update_time'=>'1606266420']);
        $this->insert('{{%core_paylog}}',['plid'=>'168','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112548485550','tid'=>'4200000731202011252047419274','fee'=>'2.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606266464','update_time'=>'1606266464']);
        $this->insert('{{%core_paylog}}',['plid'=>'169','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020112510151565','tid'=>NULL,'fee'=>'0.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606294846','update_time'=>'1606294846']);
        $this->insert('{{%core_paylog}}',['plid'=>'170','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020112554544898','tid'=>NULL,'fee'=>'1360.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606295750','update_time'=>'1606295750']);
        $this->insert('{{%core_paylog}}',['plid'=>'171','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112556101505','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606316072','update_time'=>'1606316072']);
        $this->insert('{{%core_paylog}}',['plid'=>'172','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112556545755','tid'=>NULL,'fee'=>'1600.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606316248','update_time'=>'1606316248']);
        $this->insert('{{%core_paylog}}',['plid'=>'173','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112548579757','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606316256','update_time'=>'1606316256']);
        $this->insert('{{%core_paylog}}',['plid'=>'174','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112555515154','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606316311','update_time'=>'1606316311']);
        $this->insert('{{%core_paylog}}',['plid'=>'175','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112510198101','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606316350','update_time'=>'1606316350']);
        $this->insert('{{%core_paylog}}',['plid'=>'176','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112510210097','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606316399','update_time'=>'1606316399']);
        $this->insert('{{%core_paylog}}',['plid'=>'177','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112598495197','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606317723','update_time'=>'1606317723']);
        $this->insert('{{%core_paylog}}',['plid'=>'178','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112598999852','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606317787','update_time'=>'1606317787']);
        $this->insert('{{%core_paylog}}',['plid'=>'179','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112555544949','tid'=>NULL,'fee'=>'200.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606317863','update_time'=>'1606317863']);
        $this->insert('{{%core_paylog}}',['plid'=>'180','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112548554955','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606318112','update_time'=>'1606318112']);
        $this->insert('{{%core_paylog}}',['plid'=>'181','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112551975510','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606318323','update_time'=>'1606318323']);
        $this->insert('{{%core_paylog}}',['plid'=>'182','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112597555352','tid'=>NULL,'fee'=>'1600.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606318394','update_time'=>'1606318394']);
        $this->insert('{{%core_paylog}}',['plid'=>'183','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112598994950','tid'=>NULL,'fee'=>'1600.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606318539','update_time'=>'1606318539']);
        $this->insert('{{%core_paylog}}',['plid'=>'184','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112656995550','tid'=>NULL,'fee'=>'129.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606326808','update_time'=>'1606326808']);
        $this->insert('{{%core_paylog}}',['plid'=>'185','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112648545349','tid'=>NULL,'fee'=>'0.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606336624','update_time'=>'1606336624']);
        $this->insert('{{%core_paylog}}',['plid'=>'186','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112851494853','tid'=>NULL,'fee'=>'2.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606553235','update_time'=>'1606553235']);
        $this->insert('{{%core_paylog}}',['plid'=>'187','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112854515057','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606553846','update_time'=>'1606553846']);
        $this->insert('{{%core_paylog}}',['plid'=>'188','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112849975210','tid'=>'4200000745202011286111985023','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606556737','update_time'=>'1606556737']);
        $this->insert('{{%core_paylog}}',['plid'=>'189','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112852549952','tid'=>NULL,'fee'=>'99.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606557764','update_time'=>'1606557764']);
        $this->insert('{{%core_paylog}}',['plid'=>'190','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112810153505','tid'=>NULL,'fee'=>'168.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606557790','update_time'=>'1606557790']);
        $this->insert('{{%core_paylog}}',['plid'=>'191','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112810050545','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606557821','update_time'=>'1606557821']);
        $this->insert('{{%core_paylog}}',['plid'=>'192','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112849555648','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606558673','update_time'=>'1606558673']);
        $this->insert('{{%core_paylog}}',['plid'=>'193','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112854991005','tid'=>'4200000747202011289430147409','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606558710','update_time'=>'1606558710']);
        $this->insert('{{%core_paylog}}',['plid'=>'194','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112810253101','tid'=>'4200000727202011288342817219','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606558991','update_time'=>'1606558991']);
        $this->insert('{{%core_paylog}}',['plid'=>'195','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112897100495','tid'=>'4200000830202011284466641896','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606560458','update_time'=>'1606560458']);
        $this->insert('{{%core_paylog}}',['plid'=>'196','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112853981025','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606560597','update_time'=>'1606560597']);
        $this->insert('{{%core_paylog}}',['plid'=>'197','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112854565357','tid'=>'4200000743202011283454950050','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606560870','update_time'=>'1606560870']);
        $this->insert('{{%core_paylog}}',['plid'=>'198','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112898515151','tid'=>'4200000728202011288712971986','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606561451','update_time'=>'1606561451']);
        $this->insert('{{%core_paylog}}',['plid'=>'199','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112855975254','tid'=>'4200000835202011289510235304','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606561527','update_time'=>'1606561527']);
        $this->insert('{{%core_paylog}}',['plid'=>'200','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112897994957','tid'=>'4200000830202011280834609752','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606562186','update_time'=>'1606562186']);
        $this->insert('{{%core_paylog}}',['plid'=>'201','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112850565754','tid'=>'4200000753202011283785344081','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606562498','update_time'=>'1606562498']);
        $this->insert('{{%core_paylog}}',['plid'=>'202','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112848575756','tid'=>'4200000728202011286957224193','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606562672','update_time'=>'1606562672']);
        $this->insert('{{%core_paylog}}',['plid'=>'203','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112852999751','tid'=>'4200000744202011280860542481','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606563380','update_time'=>'1606563380']);
        $this->insert('{{%core_paylog}}',['plid'=>'204','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112851551011','tid'=>'4200000726202011284178601128','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606567763','update_time'=>'1606567763']);
        $this->insert('{{%core_paylog}}',['plid'=>'205','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112850100485','tid'=>'4200000734202011282191715807','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606567954','update_time'=>'1606567954']);
        $this->insert('{{%core_paylog}}',['plid'=>'206','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112897541021','tid'=>'4200000742202011280091126517','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606568106','update_time'=>'1606568106']);
        $this->insert('{{%core_paylog}}',['plid'=>'207','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112851521025','tid'=>'4200000732202011288159458069','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606568547','update_time'=>'1606568547']);
        $this->insert('{{%core_paylog}}',['plid'=>'208','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112855975554','tid'=>'4200000840202011283637035507','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606569527','update_time'=>'1606569527']);
        $this->insert('{{%core_paylog}}',['plid'=>'209','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112855485452','tid'=>'4200000733202011285573692381','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606569575','update_time'=>'1606569575']);
        $this->insert('{{%core_paylog}}',['plid'=>'210','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020112856985155','tid'=>'4200000746202011289016832236','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606570200','update_time'=>'1606570200']);
        $this->insert('{{%core_paylog}}',['plid'=>'211','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112850975552','tid'=>'4200000727202011284254075102','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606571186','update_time'=>'1606571186']);
        $this->insert('{{%core_paylog}}',['plid'=>'212','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112810252531','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606571951','update_time'=>'1606571951']);
        $this->insert('{{%core_paylog}}',['plid'=>'213','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112857559710','tid'=>'4200000731202011288125555712','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606572681','update_time'=>'1606572681']);
        $this->insert('{{%core_paylog}}',['plid'=>'214','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112849525099','tid'=>'4200000831202011283993930550','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606573089','update_time'=>'1606573089']);
        $this->insert('{{%core_paylog}}',['plid'=>'215','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020112857575448','tid'=>'4200000738202011288762653840','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606573145','update_time'=>'1606573145']);
        $this->insert('{{%core_paylog}}',['plid'=>'216','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112897495697','tid'=>'4200000749202011289037190799','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606573274','update_time'=>'1606573274']);
        $this->insert('{{%core_paylog}}',['plid'=>'217','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112856499853','tid'=>'4200000738202011288386308788','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606573400','update_time'=>'1606573400']);
        $this->insert('{{%core_paylog}}',['plid'=>'218','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112849539849','tid'=>'4200000839202011285901946646','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606574113','update_time'=>'1606574113']);
        $this->insert('{{%core_paylog}}',['plid'=>'219','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112850499951','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606574130','update_time'=>'1606574130']);
        $this->insert('{{%core_paylog}}',['plid'=>'220','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112810256999','tid'=>'4200000730202011287664348397','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606574143','update_time'=>'1606574143']);
        $this->insert('{{%core_paylog}}',['plid'=>'221','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112810098525','tid'=>'4200000742202011284865468023','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606574269','update_time'=>'1606574269']);
        $this->insert('{{%core_paylog}}',['plid'=>'222','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112849100975','tid'=>'4200000726202011283788677871','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606574369','update_time'=>'1606574369']);
        $this->insert('{{%core_paylog}}',['plid'=>'223','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112851102505','tid'=>'4200000728202011284010548530','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606574388','update_time'=>'1606574388']);
        $this->insert('{{%core_paylog}}',['plid'=>'224','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112952569810','tid'=>NULL,'fee'=>'619.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606662516','update_time'=>'1606662516']);
        $this->insert('{{%core_paylog}}',['plid'=>'225','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112949555551','tid'=>NULL,'fee'=>'0.20','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606662545','update_time'=>'1606662545']);
        $this->insert('{{%core_paylog}}',['plid'=>'226','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112910210110','tid'=>NULL,'fee'=>'0.20','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606662575','update_time'=>'1606662575']);
        $this->insert('{{%core_paylog}}',['plid'=>'227','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020112953574956','tid'=>NULL,'fee'=>'0.20','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606662805','update_time'=>'1606662805']);
        $this->insert('{{%core_paylog}}',['plid'=>'228','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020112997101525','tid'=>'4200000837202011294152436616','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606662922','update_time'=>'1606662922']);
        $this->insert('{{%core_paylog}}',['plid'=>'229','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113098565249','tid'=>'4200000727202011309485156897','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606666075','update_time'=>'1606666075']);
        $this->insert('{{%core_paylog}}',['plid'=>'230','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113099555453','tid'=>'4200000725202011305169773907','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606666748','update_time'=>'1606666748']);
        $this->insert('{{%core_paylog}}',['plid'=>'231','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113052495651','tid'=>'4200000752202011300247773171','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606667092','update_time'=>'1606667092']);
        $this->insert('{{%core_paylog}}',['plid'=>'232','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113098975448','tid'=>'4200000733202011309766107856','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606667451','update_time'=>'1606667451']);
        $this->insert('{{%core_paylog}}',['plid'=>'233','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113048484956','tid'=>'4200000839202011301916894718','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606667840','update_time'=>'1606667840']);
        $this->insert('{{%core_paylog}}',['plid'=>'234','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113098985599','tid'=>'4200000744202011305145235558','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606667899','update_time'=>'1606667899']);
        $this->insert('{{%core_paylog}}',['plid'=>'235','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020113054979799','tid'=>'4200000739202011305966852541','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606667942','update_time'=>'1606667942']);
        $this->insert('{{%core_paylog}}',['plid'=>'236','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113098100564','tid'=>NULL,'fee'=>'0.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606677755','update_time'=>'1606677755']);
        $this->insert('{{%core_paylog}}',['plid'=>'237','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113010252985','tid'=>'4200000730202011304927463913','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606677775','update_time'=>'1606677775']);
        $this->insert('{{%core_paylog}}',['plid'=>'238','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020113051100541','tid'=>'4200000746202011309387152703','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606678035','update_time'=>'1606678035']);
        $this->insert('{{%core_paylog}}',['plid'=>'239','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020113051101565','tid'=>'4200000741202011303724171801','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606678435','update_time'=>'1606678435']);
        $this->insert('{{%core_paylog}}',['plid'=>'240','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020113010110110','tid'=>'4200000829202011302087272699','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606679438','update_time'=>'1606679438']);
        $this->insert('{{%core_paylog}}',['plid'=>'241','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020113055521004','tid'=>'4200000725202011307983562808','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606679735','update_time'=>'1606679735']);
        $this->insert('{{%core_paylog}}',['plid'=>'242','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020113098515010','tid'=>'4200000736202011303554373004','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606680187','update_time'=>'1606680187']);
        $this->insert('{{%core_paylog}}',['plid'=>'243','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113099974951','tid'=>'4200000836202011302299512048','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606680636','update_time'=>'1606680636']);
        $this->insert('{{%core_paylog}}',['plid'=>'244','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113097539856','tid'=>'4200000751202011304789190841','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606681642','update_time'=>'1606681642']);
        $this->insert('{{%core_paylog}}',['plid'=>'245','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113048505598','tid'=>'4200000740202011301004271424','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606683728','update_time'=>'1606683728']);
        $this->insert('{{%core_paylog}}',['plid'=>'246','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113049519956','tid'=>'4200000837202011304352534931','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606683953','update_time'=>'1606683953']);
        $this->insert('{{%core_paylog}}',['plid'=>'247','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113049101101','tid'=>'4200000832202011303068755943','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606684065','update_time'=>'1606684065']);
        $this->insert('{{%core_paylog}}',['plid'=>'248','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113055524952','tid'=>'4200000724202011309098002066','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606684135','update_time'=>'1606684135']);
        $this->insert('{{%core_paylog}}',['plid'=>'249','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113097521021','tid'=>'4200000736202011303480713068','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606684730','update_time'=>'1606684730']);
        $this->insert('{{%core_paylog}}',['plid'=>'250','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113097485152','tid'=>'4200000830202011304406673623','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606684778','update_time'=>'1606684778']);
        $this->insert('{{%core_paylog}}',['plid'=>'251','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113050985055','tid'=>'4200000836202011305539588377','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606684978','update_time'=>'1606684978']);
        $this->insert('{{%core_paylog}}',['plid'=>'252','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113057525054','tid'=>'4200000738202011302617238680','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606685273','update_time'=>'1606685273']);
        $this->insert('{{%core_paylog}}',['plid'=>'253','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113010056481','tid'=>'4200000840202011304775936499','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606685389','update_time'=>'1606685389']);
        $this->insert('{{%core_paylog}}',['plid'=>'254','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113056991009','tid'=>'4200000838202011305741270536','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606685816','update_time'=>'1606685816']);
        $this->insert('{{%core_paylog}}',['plid'=>'255','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113048974949','tid'=>'4200000740202011308561228207','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606685984','update_time'=>'1606685984']);
        $this->insert('{{%core_paylog}}',['plid'=>'256','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020113010251551','tid'=>'4200000838202011302510309136','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606686111','update_time'=>'1606686111']);
        $this->insert('{{%core_paylog}}',['plid'=>'257','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020113056555348','tid'=>'4200000747202011307462176491','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606688840','update_time'=>'1606688840']);
        $this->insert('{{%core_paylog}}',['plid'=>'258','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'16','uniontid'=>'2020113055505751','tid'=>'4200000737202011302614966958','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606713559','update_time'=>'1606713559']);
        $this->insert('{{%core_paylog}}',['plid'=>'259','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020113010297555','tid'=>'4200000839202011309653356729','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606713567','update_time'=>'1606713567']);
        $this->insert('{{%core_paylog}}',['plid'=>'260','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120197535510','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606786522','update_time'=>'1606786522']);
        $this->insert('{{%core_paylog}}',['plid'=>'261','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120155485497','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606786567','update_time'=>'1606786567']);
        $this->insert('{{%core_paylog}}',['plid'=>'262','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'45','uniontid'=>'2020120152554951','tid'=>'4200000835202012016569617755','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606786804','update_time'=>'1606786804']);
        $this->insert('{{%core_paylog}}',['plid'=>'263','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120153545597','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606786837','update_time'=>'1606786837']);
        $this->insert('{{%core_paylog}}',['plid'=>'264','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'61','uniontid'=>'2020120155564910','tid'=>'4200000729202012014454187980','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606786919','update_time'=>'1606786919']);
        $this->insert('{{%core_paylog}}',['plid'=>'265','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'61','uniontid'=>'2020120155485548','tid'=>'4200000750202012017522038066','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606787863','update_time'=>'1606787863']);
        $this->insert('{{%core_paylog}}',['plid'=>'266','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'61','uniontid'=>'2020120154994948','tid'=>'4200000739202012012028459854','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606788198','update_time'=>'1606788198']);
        $this->insert('{{%core_paylog}}',['plid'=>'267','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120110110048','tid'=>'4200000839202012014313036087','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606790878','update_time'=>'1606790878']);
        $this->insert('{{%core_paylog}}',['plid'=>'268','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'45','uniontid'=>'2020120110051525','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606791197','update_time'=>'1606791197']);
        $this->insert('{{%core_paylog}}',['plid'=>'269','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'45','uniontid'=>'2020120151525049','tid'=>'4200000732202012014531288326','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606791251','update_time'=>'1606791251']);
        $this->insert('{{%core_paylog}}',['plid'=>'270','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110097985','tid'=>'4200000744202012018304040466','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606791389','update_time'=>'1606791389']);
        $this->insert('{{%core_paylog}}',['plid'=>'271','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120156985353','tid'=>'4200000830202012016265486775','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606791848','update_time'=>'1606791848']);
        $this->insert('{{%core_paylog}}',['plid'=>'272','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120157521001','tid'=>'4200000839202012017997153918','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606792793','update_time'=>'1606792793']);
        $this->insert('{{%core_paylog}}',['plid'=>'273','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120156995053','tid'=>'4200000731202012016541860388','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606792920','update_time'=>'1606792920']);
        $this->insert('{{%core_paylog}}',['plid'=>'274','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120156519910','tid'=>'4200000738202012014192932587','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606793400','update_time'=>'1606793400']);
        $this->insert('{{%core_paylog}}',['plid'=>'275','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120157971015','tid'=>'4200000724202012012357957763','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606793961','update_time'=>'1606793961']);
        $this->insert('{{%core_paylog}}',['plid'=>'276','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120150545597','tid'=>'4200000743202012016900942569','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606796562','update_time'=>'1606796562']);
        $this->insert('{{%core_paylog}}',['plid'=>'277','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120110197565','tid'=>'4200000750202012011410362488','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606797070','update_time'=>'1606797070']);
        $this->insert('{{%core_paylog}}',['plid'=>'278','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120198985610','tid'=>'4200000725202012010423542799','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606797275','update_time'=>'1606797275']);
        $this->insert('{{%core_paylog}}',['plid'=>'279','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110157559','tid'=>'4200000739202012015627478575','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606797918','update_time'=>'1606797918']);
        $this->insert('{{%core_paylog}}',['plid'=>'280','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120153985552','tid'=>'4200000727202012011177192828','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606797973','update_time'=>'1606797973']);
        $this->insert('{{%core_paylog}}',['plid'=>'281','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120155561005','tid'=>'4200000831202012014668664792','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606798247','update_time'=>'1606798247']);
        $this->insert('{{%core_paylog}}',['plid'=>'282','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120153505654','tid'=>'4200000738202012015429015126','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606798437','update_time'=>'1606798437']);
        $this->insert('{{%core_paylog}}',['plid'=>'283','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120150505253','tid'=>'4200000724202012016589848791','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606798754','update_time'=>'1606798754']);
        $this->insert('{{%core_paylog}}',['plid'=>'284','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120197575149','tid'=>'4200000739202012015442037845','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606799290','update_time'=>'1606799290']);
        $this->insert('{{%core_paylog}}',['plid'=>'285','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120153579853','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606799605','update_time'=>'1606799605']);
        $this->insert('{{%core_paylog}}',['plid'=>'286','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120199565752','tid'=>'4200000752202012019009352586','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606799676','update_time'=>'1606799676']);
        $this->insert('{{%core_paylog}}',['plid'=>'287','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120156101525','tid'=>'4200000744202012013474081973','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606800040','update_time'=>'1606800040']);
        $this->insert('{{%core_paylog}}',['plid'=>'288','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120151555753','tid'=>'4200000740202012014959457564','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606800435','update_time'=>'1606800435']);
        $this->insert('{{%core_paylog}}',['plid'=>'289','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110252501','tid'=>'4200000753202012013994556058','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606800607','update_time'=>'1606800607']);
        $this->insert('{{%core_paylog}}',['plid'=>'290','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110151511','tid'=>'4200000734202012013308884069','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606800734','update_time'=>'1606800734']);
        $this->insert('{{%core_paylog}}',['plid'=>'291','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120152529953','tid'=>'4200000726202012017208100785','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606800900','update_time'=>'1606800900']);
        $this->insert('{{%core_paylog}}',['plid'=>'292','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110198575','tid'=>'4200000745202012015308479526','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606801102','update_time'=>'1606801102']);
        $this->insert('{{%core_paylog}}',['plid'=>'293','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120198505610','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606801467','update_time'=>'1606801467']);
        $this->insert('{{%core_paylog}}',['plid'=>'294','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120152995510','tid'=>'4200000834202012011165624096','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606801556','update_time'=>'1606801556']);
        $this->insert('{{%core_paylog}}',['plid'=>'295','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120198975249','tid'=>'4200000739202012017091274502','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606801979','update_time'=>'1606801979']);
        $this->insert('{{%core_paylog}}',['plid'=>'296','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120150559997','tid'=>'4200000750202012017475540416','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606802146','update_time'=>'1606802146']);
        $this->insert('{{%core_paylog}}',['plid'=>'297','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110055575','tid'=>'4200000739202012018669448725','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606802413','update_time'=>'1606802413']);
        $this->insert('{{%core_paylog}}',['plid'=>'298','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120199575756','tid'=>'4200000832202012016400326522','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606802620','update_time'=>'1606802620']);
        $this->insert('{{%core_paylog}}',['plid'=>'299','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120153101505','tid'=>'4200000744202012015031449281','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606802853','update_time'=>'1606802853']);
        $this->insert('{{%core_paylog}}',['plid'=>'300','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020120157551015','tid'=>'4200000839202012018041748371','fee'=>'0.20','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606803641','update_time'=>'1606803641']);
        $this->insert('{{%core_paylog}}',['plid'=>'301','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110052545','tid'=>'4200000750202012016871412075','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606803789','update_time'=>'1606803789']);
        $this->insert('{{%core_paylog}}',['plid'=>'302','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120110210156','tid'=>'4200000831202012017061677453','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606803791','update_time'=>'1606803791']);
        $this->insert('{{%core_paylog}}',['plid'=>'303','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020120153564952','tid'=>'4200000750202012015266877492','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606803829','update_time'=>'1606803829']);
        $this->insert('{{%core_paylog}}',['plid'=>'304','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120110199100','tid'=>'4200000727202012016784758084','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606835054','update_time'=>'1606835054']);
        $this->insert('{{%core_paylog}}',['plid'=>'305','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120157541005','tid'=>'4200000839202012016848711345','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606837737','update_time'=>'1606837737']);
        $this->insert('{{%core_paylog}}',['plid'=>'306','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120253100525','tid'=>'4200000839202012026106330616','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606838517','update_time'=>'1606838517']);
        $this->insert('{{%core_paylog}}',['plid'=>'307','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120210197481','tid'=>'4200000832202012020395999471','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606838990','update_time'=>'1606838990']);
        $this->insert('{{%core_paylog}}',['plid'=>'308','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120253524857','tid'=>'4200000726202012023263832095','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606839093','update_time'=>'1606839093']);
        $this->insert('{{%core_paylog}}',['plid'=>'309','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120298545457','tid'=>'4200000745202012028672022820','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606839339','update_time'=>'1606839339']);
        $this->insert('{{%core_paylog}}',['plid'=>'310','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120253989797','tid'=>'4200000832202012024331958047','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606839429','update_time'=>'1606839429']);
        $this->insert('{{%core_paylog}}',['plid'=>'311','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120252525056','tid'=>'4200000725202012020603286490','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606839716','update_time'=>'1606839716']);
        $this->insert('{{%core_paylog}}',['plid'=>'312','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'22','uniontid'=>'2020120252999710','tid'=>'4200000744202012027124462454','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606839956','update_time'=>'1606839956']);
        $this->insert('{{%core_paylog}}',['plid'=>'313','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120257559710','tid'=>'4200000837202012020948834766','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606841145','update_time'=>'1606841145']);
        $this->insert('{{%core_paylog}}',['plid'=>'314','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120298575750','tid'=>'4200000741202012026511910933','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606841579','update_time'=>'1606841579']);
        $this->insert('{{%core_paylog}}',['plid'=>'315','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120210198985','tid'=>'4200000748202012022708811135','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606841886','update_time'=>'1606841886']);
        $this->insert('{{%core_paylog}}',['plid'=>'316','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120210099999','tid'=>'4200000735202012020541894547','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606842029','update_time'=>'1606842029']);
        $this->insert('{{%core_paylog}}',['plid'=>'317','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210152484','tid'=>'4200000834202012023340849977','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606842238','update_time'=>'1606842238']);
        $this->insert('{{%core_paylog}}',['plid'=>'318','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120210210052','tid'=>'4200000734202012025522459586','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606842639','update_time'=>'1606842639']);
        $this->insert('{{%core_paylog}}',['plid'=>'319','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120255975154','tid'=>'4200000726202012026242102356','fee'=>'0.20','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606842823','update_time'=>'1606842823']);
        $this->insert('{{%core_paylog}}',['plid'=>'320','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120299555450','tid'=>'4200000838202012022257757462','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606842956','update_time'=>'1606842956']);
        $this->insert('{{%core_paylog}}',['plid'=>'321','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210250554','tid'=>'4200000748202012022958774233','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606843039','update_time'=>'1606843039']);
        $this->insert('{{%core_paylog}}',['plid'=>'322','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210098519','tid'=>'4200000835202012023628493182','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606846749','update_time'=>'1606846749']);
        $this->insert('{{%core_paylog}}',['plid'=>'323','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120254571025','tid'=>'4200000747202012023441828057','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606847686','update_time'=>'1606847686']);
        $this->insert('{{%core_paylog}}',['plid'=>'324','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120299535510','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606847948','update_time'=>'1606847948']);
        $this->insert('{{%core_paylog}}',['plid'=>'325','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210097549','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606848109','update_time'=>'1606848109']);
        $this->insert('{{%core_paylog}}',['plid'=>'326','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120254985798','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606848278','update_time'=>'1606848278']);
        $this->insert('{{%core_paylog}}',['plid'=>'327','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210154505','tid'=>'4200000830202012024011750857','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606848318','update_time'=>'1606848318']);
        $this->insert('{{%core_paylog}}',['plid'=>'328','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120297559856','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606848874','update_time'=>'1606848874']);
        $this->insert('{{%core_paylog}}',['plid'=>'329','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120252485451','tid'=>'4200000751202012028454181577','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606848900','update_time'=>'1606848900']);
        $this->insert('{{%core_paylog}}',['plid'=>'330','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120250975710','tid'=>'4200000829202012024281807554','fee'=>'0.20','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606849122','update_time'=>'1606849122']);
        $this->insert('{{%core_paylog}}',['plid'=>'331','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120297525653','tid'=>'4200000751202012021453841297','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606849210','update_time'=>'1606849210']);
        $this->insert('{{%core_paylog}}',['plid'=>'332','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120256100495','tid'=>'4200000742202012022040508459','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606849320','update_time'=>'1606849320']);
        $this->insert('{{%core_paylog}}',['plid'=>'333','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120210155525','tid'=>'4200000725202012023986072387','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606849982','update_time'=>'1606849982']);
        $this->insert('{{%core_paylog}}',['plid'=>'334','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120252481024','tid'=>'4200000833202012020763428612','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606850308','update_time'=>'1606850308']);
        $this->insert('{{%core_paylog}}',['plid'=>'335','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120252494950','tid'=>'4200000837202012028367792195','fee'=>'0.20','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606852660','update_time'=>'1606852660']);
        $this->insert('{{%core_paylog}}',['plid'=>'336','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120297544953','tid'=>'4200000748202012027090426184','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606852810','update_time'=>'1606852810']);
        $this->insert('{{%core_paylog}}',['plid'=>'337','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120254499997','tid'=>'4200000753202012024845934371','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606902502','update_time'=>'1606902502']);
        $this->insert('{{%core_paylog}}',['plid'=>'338','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120255524956','tid'=>NULL,'fee'=>'11.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606902967','update_time'=>'1606902967']);
        $this->insert('{{%core_paylog}}',['plid'=>'339','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120253555598','tid'=>'4200000740202012022374544777','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606903861','update_time'=>'1606903861']);
        $this->insert('{{%core_paylog}}',['plid'=>'340','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210299485','tid'=>'4200000834202012027922041721','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606903903','update_time'=>'1606903903']);
        $this->insert('{{%core_paylog}}',['plid'=>'341','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210248539','tid'=>'4200000744202012023821963056','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606904127','update_time'=>'1606904127']);
        $this->insert('{{%core_paylog}}',['plid'=>'342','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120210299505','tid'=>'4200000831202012020282574298','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606907391','update_time'=>'1606907391']);
        $this->insert('{{%core_paylog}}',['plid'=>'343','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120257101539','tid'=>'4200000838202012026153008408','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606915049','update_time'=>'1606915049']);
        $this->insert('{{%core_paylog}}',['plid'=>'344','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120210149999','tid'=>'4200000746202012023228339848','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606915822','update_time'=>'1606915822']);
        $this->insert('{{%core_paylog}}',['plid'=>'345','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120248102494','tid'=>'4200000830202012024568995689','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606915921','update_time'=>'1606915921']);
        $this->insert('{{%core_paylog}}',['plid'=>'346','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120250100564','tid'=>'4200000839202012027621484576','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606916082','update_time'=>'1606916082']);
        $this->insert('{{%core_paylog}}',['plid'=>'347','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120255531005','tid'=>'4200000836202012023230808806','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606916263','update_time'=>'1606916263']);
        $this->insert('{{%core_paylog}}',['plid'=>'348','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120297495197','tid'=>'4200000745202012020302224243','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606916362','update_time'=>'1606916362']);
        $this->insert('{{%core_paylog}}',['plid'=>'349','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120210199102','tid'=>'4200000839202012024731140390','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606916462','update_time'=>'1606916462']);
        $this->insert('{{%core_paylog}}',['plid'=>'350','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120298555450','tid'=>'4200000732202012027653554246','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606916731','update_time'=>'1606916731']);
        $this->insert('{{%core_paylog}}',['plid'=>'351','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120298515157','tid'=>'4200000837202012024451230410','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606916971','update_time'=>'1606916971']);
        $this->insert('{{%core_paylog}}',['plid'=>'352','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120252495310','tid'=>'4200000738202012023380871611','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606917316','update_time'=>'1606917316']);
        $this->insert('{{%core_paylog}}',['plid'=>'353','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120251545557','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606917523','update_time'=>'1606917523']);
        $this->insert('{{%core_paylog}}',['plid'=>'354','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120252525556','tid'=>'4200000749202012023239916632','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606917556','update_time'=>'1606917556']);
        $this->insert('{{%core_paylog}}',['plid'=>'355','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120253525055','tid'=>'4200000730202012025345579576','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606917925','update_time'=>'1606917925']);
        $this->insert('{{%core_paylog}}',['plid'=>'356','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120249564949','tid'=>'4200000744202012020832295028','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606918305','update_time'=>'1606918305']);
        $this->insert('{{%core_paylog}}',['plid'=>'357','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120256974956','tid'=>'4200000735202012027098480581','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606918408','update_time'=>'1606918408']);
        $this->insert('{{%core_paylog}}',['plid'=>'358','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120257559953','tid'=>'4200000732202012024438741860','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606918873','update_time'=>'1606918873']);
        $this->insert('{{%core_paylog}}',['plid'=>'359','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120248989897','tid'=>'4200000741202012021502595421','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606919072','update_time'=>'1606919072']);
        $this->insert('{{%core_paylog}}',['plid'=>'360','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120298514948','tid'=>'4200000837202012029659682195','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606919627','update_time'=>'1606919627']);
        $this->insert('{{%core_paylog}}',['plid'=>'361','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120251564954','tid'=>'4200000741202012029948107414','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606919859','update_time'=>'1606919859']);
        $this->insert('{{%core_paylog}}',['plid'=>'362','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120255481015','tid'=>'4200000741202012022647866938','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606920119','update_time'=>'1606920119']);
        $this->insert('{{%core_paylog}}',['plid'=>'363','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120256495748','tid'=>'4200000742202012028110765908','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606920392','update_time'=>'1606920392']);
        $this->insert('{{%core_paylog}}',['plid'=>'364','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120349531024','tid'=>'4200000738202012036277308967','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606927585','update_time'=>'1606927585']);
        $this->insert('{{%core_paylog}}',['plid'=>'365','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'18','uniontid'=>'2020120350535110','tid'=>'4200000835202012032935639851','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606934354','update_time'=>'1606934354']);
        $this->insert('{{%core_paylog}}',['plid'=>'366','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'64','uniontid'=>'2020120354525255','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606934726','update_time'=>'1606934726']);
        $this->insert('{{%core_paylog}}',['plid'=>'367','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'64','uniontid'=>'2020120398545710','tid'=>'4200000730202012038439229145','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606934923','update_time'=>'1606934923']);
        $this->insert('{{%core_paylog}}',['plid'=>'368','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'18','uniontid'=>'2020120355555610','tid'=>'4200000735202012037450567024','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606935239','update_time'=>'1606935239']);
        $this->insert('{{%core_paylog}}',['plid'=>'369','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120399524955','tid'=>'4200000742202012034179772517','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606936636','update_time'=>'1606936636']);
        $this->insert('{{%core_paylog}}',['plid'=>'370','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'18','uniontid'=>'2020120356975056','tid'=>'4200000724202012030004912989','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606936712','update_time'=>'1606936712']);
        $this->insert('{{%core_paylog}}',['plid'=>'371','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'64','uniontid'=>'2020120350981029','tid'=>'4200000735202012032834951381','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606936834','update_time'=>'1606936834']);
        $this->insert('{{%core_paylog}}',['plid'=>'372','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'16','uniontid'=>'2020120398565449','tid'=>'4200000829202012033174412166','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606937611','update_time'=>'1606937611']);
        $this->insert('{{%core_paylog}}',['plid'=>'373','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120353515155','tid'=>'4200000830202012032037813820','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606942613','update_time'=>'1606942613']);
        $this->insert('{{%core_paylog}}',['plid'=>'374','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120350531011','tid'=>'4200000726202012035229226045','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606943474','update_time'=>'1606943474']);
        $this->insert('{{%core_paylog}}',['plid'=>'375','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120310055571','tid'=>'4200000732202012037075961934','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606943757','update_time'=>'1606943757']);
        $this->insert('{{%core_paylog}}',['plid'=>'376','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120354100561','tid'=>'4200000830202012035140876472','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606944294','update_time'=>'1606944294']);
        $this->insert('{{%core_paylog}}',['plid'=>'377','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120310254535','tid'=>'4200000732202012037609627624','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606944479','update_time'=>'1606944479']);
        $this->insert('{{%core_paylog}}',['plid'=>'378','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120310148101','tid'=>'4200000737202012031234324635','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606945518','update_time'=>'1606945518']);
        $this->insert('{{%core_paylog}}',['plid'=>'379','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120353100975','tid'=>'4200000743202012035416332299','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606960421','update_time'=>'1606960421']);
        $this->insert('{{%core_paylog}}',['plid'=>'380','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120310248565','tid'=>'4200000751202012036477933577','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606967615','update_time'=>'1606967615']);
        $this->insert('{{%core_paylog}}',['plid'=>'381','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120398501021','tid'=>'4200000728202012031664809520','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606968491','update_time'=>'1606968491']);
        $this->insert('{{%core_paylog}}',['plid'=>'382','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120357515254','tid'=>'4200000829202012034820597114','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606968601','update_time'=>'1606968601']);
        $this->insert('{{%core_paylog}}',['plid'=>'383','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120355529752','tid'=>'4200000836202012030951859393','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606968855','update_time'=>'1606968855']);
        $this->insert('{{%core_paylog}}',['plid'=>'384','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120397995352','tid'=>'4200000727202012031982768609','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606968970','update_time'=>'1606968970']);
        $this->insert('{{%core_paylog}}',['plid'=>'385','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120398102495','tid'=>'4200000733202012031896564775','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606969900','update_time'=>'1606969900']);
        $this->insert('{{%core_paylog}}',['plid'=>'386','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120399519710','tid'=>'4200000728202012031453175446','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606970348','update_time'=>'1606970348']);
        $this->insert('{{%core_paylog}}',['plid'=>'387','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120399975450','tid'=>'4200000727202012039523623489','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606971580','update_time'=>'1606971580']);
        $this->insert('{{%core_paylog}}',['plid'=>'388','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120310255485','tid'=>'4200000735202012030777737072','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606971759','update_time'=>'1606971759']);
        $this->insert('{{%core_paylog}}',['plid'=>'389','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120355499810','tid'=>'4200000740202012038327540665','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606972263','update_time'=>'1606972263']);
        $this->insert('{{%core_paylog}}',['plid'=>'390','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120356975052','tid'=>'4200000752202012032361025258','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606972904','update_time'=>'1606972904']);
        $this->insert('{{%core_paylog}}',['plid'=>'391','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120310049561','tid'=>'4200000738202012035072648849','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606973133','update_time'=>'1606973133']);
        $this->insert('{{%core_paylog}}',['plid'=>'392','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120399514898','tid'=>'4200000835202012037889291738','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606973756','update_time'=>'1606973756']);
        $this->insert('{{%core_paylog}}',['plid'=>'393','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120310098529','tid'=>'4200000736202012035199947613','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606974109','update_time'=>'1606974109']);
        $this->insert('{{%core_paylog}}',['plid'=>'394','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120349495553','tid'=>'4200000749202012037749504010','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606974385','update_time'=>'1606974385']);
        $this->insert('{{%core_paylog}}',['plid'=>'395','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120357531029','tid'=>'4200000840202012037966651568','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606974681','update_time'=>'1606974681']);
        $this->insert('{{%core_paylog}}',['plid'=>'396','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120310010154','tid'=>'4200000840202012034506489146','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606974941','update_time'=>'1606974941']);
        $this->insert('{{%core_paylog}}',['plid'=>'397','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120352494850','tid'=>'4200000753202012039267719550','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606975108','update_time'=>'1606975108']);
        $this->insert('{{%core_paylog}}',['plid'=>'398','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120399485257','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606975228','update_time'=>'1606975228']);
        $this->insert('{{%core_paylog}}',['plid'=>'399','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'49','uniontid'=>'2020120310051574','tid'=>'4200000746202012030031321668','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606975293','update_time'=>'1606975293']);
        $this->insert('{{%core_paylog}}',['plid'=>'400','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120399541005','tid'=>'4200000740202012037343639519','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606975388','update_time'=>'1606975388']);
        $this->insert('{{%core_paylog}}',['plid'=>'401','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120310149505','tid'=>'4200000731202012037491849303','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606975598','update_time'=>'1606975598']);
        $this->insert('{{%core_paylog}}',['plid'=>'402','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120310098555','tid'=>NULL,'fee'=>'0.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606975901','update_time'=>'1606975901']);
        $this->insert('{{%core_paylog}}',['plid'=>'403','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120310098535','tid'=>'4200000749202012036836225633','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606975901','update_time'=>'1606975901']);
        $this->insert('{{%core_paylog}}',['plid'=>'404','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120353535556','tid'=>'4200000731202012038543462481','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606976725','update_time'=>'1606976725']);
        $this->insert('{{%core_paylog}}',['plid'=>'405','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120398501025','tid'=>'4200000748202012037118605573','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606977451','update_time'=>'1606977451']);
        $this->insert('{{%core_paylog}}',['plid'=>'406','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120310155535','tid'=>'4200000737202012036019961686','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606977630','update_time'=>'1606977630']);
        $this->insert('{{%core_paylog}}',['plid'=>'407','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'33','uniontid'=>'2020120348555357','tid'=>'4200000835202012031271789766','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606977808','update_time'=>'1606977808']);
        $this->insert('{{%core_paylog}}',['plid'=>'408','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'33','uniontid'=>'2020120353975254','tid'=>'4200000829202012031678302549','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606979909','update_time'=>'1606979909']);
        $this->insert('{{%core_paylog}}',['plid'=>'409','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'33','uniontid'=>'2020120350499710','tid'=>'4200000726202012038338736107','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606980082','update_time'=>'1606980082']);
        $this->insert('{{%core_paylog}}',['plid'=>'410','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'65','uniontid'=>'2020120353981015','tid'=>'4200000738202012035775778201','fee'=>'0.50','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606980357','update_time'=>'1606980357']);
        $this->insert('{{%core_paylog}}',['plid'=>'411','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'67','uniontid'=>'2020120356984953','tid'=>'4200000725202012036641427591','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606986424','update_time'=>'1606986424']);
        $this->insert('{{%core_paylog}}',['plid'=>'412','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'33','uniontid'=>'2020120310056559','tid'=>'4200000732202012035991345721','fee'=>'1000.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606998349','update_time'=>'1606998349']);
        $this->insert('{{%core_paylog}}',['plid'=>'413','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020120349531015','tid'=>'4200000744202012030879271427','fee'=>'10000.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1606999345','update_time'=>'1606999345']);
        $this->insert('{{%core_paylog}}',['plid'=>'414','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'52','uniontid'=>'2020120398485655','tid'=>'4200000835202012034948264327','fee'=>'1000.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607001611','update_time'=>'1607001611']);
        $this->insert('{{%core_paylog}}',['plid'=>'415','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120410010097','tid'=>'4200000743202012049660473416','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607089181','update_time'=>'1607089181']);
        $this->insert('{{%core_paylog}}',['plid'=>'416','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'99','uniontid'=>'2020120549545298','tid'=>'4200000836202012059487154598','fee'=>'1000.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607155617','update_time'=>'1607155617']);
        $this->insert('{{%core_paylog}}',['plid'=>'417','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'100','uniontid'=>'2020120557505610','tid'=>'4200000743202012053618997846','fee'=>'1000.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607157449','update_time'=>'1607157449']);
        $this->insert('{{%core_paylog}}',['plid'=>'418','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'18','uniontid'=>'2020120556100555','tid'=>'4200000746202012057537582826','fee'=>'1000.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607170376','update_time'=>'1607170376']);
        $this->insert('{{%core_paylog}}',['plid'=>'419','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020120610257101','tid'=>NULL,'fee'=>'159.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607214943','update_time'=>'1607214943']);
        $this->insert('{{%core_paylog}}',['plid'=>'420','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120610153100','tid'=>'4200000747202012066547900155','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607249118','update_time'=>'1607249118']);
        $this->insert('{{%core_paylog}}',['plid'=>'421','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120650494949','tid'=>NULL,'fee'=>'138.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607267138','update_time'=>'1607267138']);
        $this->insert('{{%core_paylog}}',['plid'=>'422','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120648554810','tid'=>NULL,'fee'=>'599.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607267184','update_time'=>'1607267184']);
        $this->insert('{{%core_paylog}}',['plid'=>'423','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120756521021','tid'=>NULL,'fee'=>'50.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607273064','update_time'=>'1607273064']);
        $this->insert('{{%core_paylog}}',['plid'=>'424','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120749571029','tid'=>NULL,'fee'=>'50.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607273105','update_time'=>'1607273105']);
        $this->insert('{{%core_paylog}}',['plid'=>'425','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120748531005','tid'=>NULL,'fee'=>'138.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607273136','update_time'=>'1607273136']);
        $this->insert('{{%core_paylog}}',['plid'=>'426','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120753545710','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607275925','update_time'=>'1607275925']);
        $this->insert('{{%core_paylog}}',['plid'=>'427','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120754505550','tid'=>NULL,'fee'=>'30.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607319558','update_time'=>'1607319558']);
        $this->insert('{{%core_paylog}}',['plid'=>'428','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120710256101','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607319583','update_time'=>'1607319583']);
        $this->insert('{{%core_paylog}}',['plid'=>'429','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'66','uniontid'=>'2020120750101984','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607326770','update_time'=>'1607326770']);
        $this->insert('{{%core_paylog}}',['plid'=>'430','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'66','uniontid'=>'2020120757535510','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607326793','update_time'=>'1607326793']);
        $this->insert('{{%core_paylog}}',['plid'=>'431','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'37','uniontid'=>'2020120710156974','tid'=>'4200000749202012075860395657','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607327662','update_time'=>'1607327662']);
        $this->insert('{{%core_paylog}}',['plid'=>'432','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120754505155','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607332422','update_time'=>'1607332422']);
        $this->insert('{{%core_paylog}}',['plid'=>'433','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020120755571024','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607337111','update_time'=>'1607337111']);
        $this->insert('{{%core_paylog}}',['plid'=>'434','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'52','uniontid'=>'2020120810150531','tid'=>'4200000832202012084922430317','fee'=>'29.90','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607406110','update_time'=>'1607406110']);
        $this->insert('{{%core_paylog}}',['plid'=>'435','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'61','uniontid'=>'2020120850561029','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607407346','update_time'=>'1607407346']);
        $this->insert('{{%core_paylog}}',['plid'=>'436','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'61','uniontid'=>'2020120850565457','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607407362','update_time'=>'1607407362']);
        $this->insert('{{%core_paylog}}',['plid'=>'437','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'66','uniontid'=>'2020120851501019','tid'=>'4200000781202012084519750303','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607408787','update_time'=>'1607408787']);
        $this->insert('{{%core_paylog}}',['plid'=>'438','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120855499897','tid'=>'4200000737202012086869505497','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607412807','update_time'=>'1607412807']);
        $this->insert('{{%core_paylog}}',['plid'=>'439','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120851100579','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607415747','update_time'=>'1607415747']);
        $this->insert('{{%core_paylog}}',['plid'=>'440','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120851995652','tid'=>'4200000749202012083969740762','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607435059','update_time'=>'1607435059']);
        $this->insert('{{%core_paylog}}',['plid'=>'441','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120952505710','tid'=>NULL,'fee'=>'29.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607445076','update_time'=>'1607445076']);
        $this->insert('{{%core_paylog}}',['plid'=>'442','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'123','uniontid'=>'2020120949565549','tid'=>NULL,'fee'=>'1299.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607446769','update_time'=>'1607446769']);
        $this->insert('{{%core_paylog}}',['plid'=>'443','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'123','uniontid'=>'2020120997575497','tid'=>NULL,'fee'=>'1299.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607446922','update_time'=>'1607446922']);
        $this->insert('{{%core_paylog}}',['plid'=>'444','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'123','uniontid'=>'2020120910055495','tid'=>NULL,'fee'=>'1299.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607447005','update_time'=>'1607447005']);
        $this->insert('{{%core_paylog}}',['plid'=>'445','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'123','uniontid'=>'2020120953534957','tid'=>NULL,'fee'=>'1299.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607447141','update_time'=>'1607447141']);
        $this->insert('{{%core_paylog}}',['plid'=>'446','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'123','uniontid'=>'2020120953549950','tid'=>'4200000783202012098844931159','fee'=>'1299.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607447141','update_time'=>'1607447141']);
        $this->insert('{{%core_paylog}}',['plid'=>'447','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120998994857','tid'=>NULL,'fee'=>'268.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607462987','update_time'=>'1607462987']);
        $this->insert('{{%core_paylog}}',['plid'=>'448','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120910157995','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607467134','update_time'=>'1607467134']);
        $this->insert('{{%core_paylog}}',['plid'=>'449','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120948979755','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607467920','update_time'=>'1607467920']);
        $this->insert('{{%core_paylog}}',['plid'=>'450','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120956574852','tid'=>NULL,'fee'=>'168.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607468024','update_time'=>'1607468024']);
        $this->insert('{{%core_paylog}}',['plid'=>'451','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120957100101','tid'=>NULL,'fee'=>'690.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607468345','update_time'=>'1607468345']);
        $this->insert('{{%core_paylog}}',['plid'=>'452','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120997101515','tid'=>NULL,'fee'=>'59.80','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607469050','update_time'=>'1607469050']);
        $this->insert('{{%core_paylog}}',['plid'=>'453','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120997984852','tid'=>NULL,'fee'=>'1996.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607469098','update_time'=>'1607469098']);
        $this->insert('{{%core_paylog}}',['plid'=>'454','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120910256100','tid'=>NULL,'fee'=>'50.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607469535','update_time'=>'1607469535']);
        $this->insert('{{%core_paylog}}',['plid'=>'455','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020120949101102','tid'=>NULL,'fee'=>'29.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607469554','update_time'=>'1607469554']);
        $this->insert('{{%core_paylog}}',['plid'=>'456','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120952101575','tid'=>NULL,'fee'=>'50.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607469716','update_time'=>'1607469716']);
        $this->insert('{{%core_paylog}}',['plid'=>'457','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120948101575','tid'=>NULL,'fee'=>'50.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607469728','update_time'=>'1607469728']);
        $this->insert('{{%core_paylog}}',['plid'=>'458','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020120951519757','tid'=>'4200000831202012093080018624','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607484419','update_time'=>'1607484419']);
        $this->insert('{{%core_paylog}}',['plid'=>'459','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'66','uniontid'=>'2020120953971015','tid'=>'4200000837202012099524938680','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607490965','update_time'=>'1607490965']);
        $this->insert('{{%core_paylog}}',['plid'=>'460','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'66','uniontid'=>'2020120997515351','tid'=>'4200000797202012095702572831','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607506906','update_time'=>'1607506906']);
        $this->insert('{{%core_paylog}}',['plid'=>'461','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120910250485','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607514991','update_time'=>'1607514991']);
        $this->insert('{{%core_paylog}}',['plid'=>'462','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120910252509','tid'=>NULL,'fee'=>'24.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607514991','update_time'=>'1607514991']);
        $this->insert('{{%core_paylog}}',['plid'=>'463','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'156','uniontid'=>'2020120950545554','tid'=>NULL,'fee'=>'1000.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607515794','update_time'=>'1607515794']);
        $this->insert('{{%core_paylog}}',['plid'=>'464','bloc_id'=>'8','store_id'=>'51','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020120952974952','tid'=>NULL,'fee'=>'699.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607516420','update_time'=>'1607516420']);
        $this->insert('{{%core_paylog}}',['plid'=>'465','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'156','uniontid'=>'2020120951102484','tid'=>'4200000750202012091225282834','fee'=>'1000.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607516739','update_time'=>'1607516739']);
        $this->insert('{{%core_paylog}}',['plid'=>'466','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121098985399','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607581595','update_time'=>'1607581595']);
        $this->insert('{{%core_paylog}}',['plid'=>'467','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121097535397','tid'=>'4200000801202012103751014684','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607581658','update_time'=>'1607581658']);
        $this->insert('{{%core_paylog}}',['plid'=>'468','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121048545450','tid'=>NULL,'fee'=>'30.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607581680','update_time'=>'1607581680']);
        $this->insert('{{%core_paylog}}',['plid'=>'469','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121010055975','tid'=>NULL,'fee'=>'3.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607581917','update_time'=>'1607581917']);
        $this->insert('{{%core_paylog}}',['plid'=>'470','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121048995310','tid'=>NULL,'fee'=>'3.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607582048','update_time'=>'1607582048']);
        $this->insert('{{%core_paylog}}',['plid'=>'471','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121010210051','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607595967','update_time'=>'1607595967']);
        $this->insert('{{%core_paylog}}',['plid'=>'472','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'30','uniontid'=>'2020121053511024','tid'=>'4200000833202012109233780672','fee'=>'68.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607601525','update_time'=>'1607601525']);
        $this->insert('{{%core_paylog}}',['plid'=>'473','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121199521009','tid'=>'4200000836202012110052796765','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607651036','update_time'=>'1607651036']);
        $this->insert('{{%core_paylog}}',['plid'=>'474','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121110249995','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607685759','update_time'=>'1607685759']);
        $this->insert('{{%core_paylog}}',['plid'=>'475','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121199485251','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607686828','update_time'=>'1607686828']);
        $this->insert('{{%core_paylog}}',['plid'=>'476','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121148574848','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607687024','update_time'=>'1607687024']);
        $this->insert('{{%core_paylog}}',['plid'=>'477','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121151489851','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607687139','update_time'=>'1607687139']);
        $this->insert('{{%core_paylog}}',['plid'=>'478','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121148505597','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607687328','update_time'=>'1607687328']);
        $this->insert('{{%core_paylog}}',['plid'=>'479','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121148495648','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607687456','update_time'=>'1607687456']);
        $this->insert('{{%core_paylog}}',['plid'=>'480','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121154974910','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607687526','update_time'=>'1607687526']);
        $this->insert('{{%core_paylog}}',['plid'=>'481','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121152991009','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607687716','update_time'=>'1607687716']);
        $this->insert('{{%core_paylog}}',['plid'=>'482','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121110050102','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607688701','update_time'=>'1607688701']);
        $this->insert('{{%core_paylog}}',['plid'=>'483','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121198995348','tid'=>NULL,'fee'=>'68.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607688891','update_time'=>'1607688891']);
        $this->insert('{{%core_paylog}}',['plid'=>'484','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121154975355','tid'=>NULL,'fee'=>'27.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607689910','update_time'=>'1607689910']);
        $this->insert('{{%core_paylog}}',['plid'=>'485','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020121198485710','tid'=>NULL,'fee'=>'27.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607690139','update_time'=>'1607690139']);
        $this->insert('{{%core_paylog}}',['plid'=>'486','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'14','uniontid'=>'2020121155985699','tid'=>NULL,'fee'=>'55.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607690151','update_time'=>'1607690151']);
        $this->insert('{{%core_paylog}}',['plid'=>'487','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'25','uniontid'=>'2020121110049505','tid'=>'4200000804202012114068268599','fee'=>'55.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607691869','update_time'=>'1607691869']);
        $this->insert('{{%core_paylog}}',['plid'=>'488','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'52','uniontid'=>'2020121110248101','tid'=>'4200000800202012116964006875','fee'=>'55.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607692383','update_time'=>'1607692383']);
        $this->insert('{{%core_paylog}}',['plid'=>'489','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'363','uniontid'=>'2020121154504853','tid'=>NULL,'fee'=>'27.50','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607696358','update_time'=>'1607696358']);
        $this->insert('{{%core_paylog}}',['plid'=>'490','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'17','uniontid'=>'2020121210110099','tid'=>'4200000783202012120134474599','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607769694','update_time'=>'1607769694']);
        $this->insert('{{%core_paylog}}',['plid'=>'491','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121297505210','tid'=>'4200000838202012125502559916','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607769882','update_time'=>'1607769882']);
        $this->insert('{{%core_paylog}}',['plid'=>'492','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121299571025','tid'=>'4200000784202012123277726302','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607774588','update_time'=>'1607774588']);
        $this->insert('{{%core_paylog}}',['plid'=>'493','bloc_id'=>'11','store_id'=>'53','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121253575097','tid'=>'4200000835202012123840870078','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607778261','update_time'=>'1607778261']);
        $this->insert('{{%core_paylog}}',['plid'=>'494','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121249565554','tid'=>'4200000833202012120481545443','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607784465','update_time'=>'1607784465']);
        $this->insert('{{%core_paylog}}',['plid'=>'495','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121348555410','tid'=>'4200000804202012137413545990','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607801376','update_time'=>'1607801376']);
        $this->insert('{{%core_paylog}}',['plid'=>'496','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'12','uniontid'=>'2020121354995649','tid'=>'4200000800202012138356476624','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607802582','update_time'=>'1607802582']);
        $this->insert('{{%core_paylog}}',['plid'=>'497','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121349974851','tid'=>'4200000782202012133532355284','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607803169','update_time'=>'1607803169']);
        $this->insert('{{%core_paylog}}',['plid'=>'498','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121354994953','tid'=>'4200000781202012136213183335','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607803798','update_time'=>'1607803798']);
        $this->insert('{{%core_paylog}}',['plid'=>'499','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121348485254','tid'=>'4200000780202012138093331774','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607804720','update_time'=>'1607804720']);
        $this->insert('{{%core_paylog}}',['plid'=>'500','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121353494851','tid'=>'4200000805202012130045228003','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607805189','update_time'=>'1607805189']);
        $this->insert('{{%core_paylog}}',['plid'=>'501','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121399975349','tid'=>'4200000840202012139186789307','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607805324','update_time'=>'1607805324']);
        $this->insert('{{%core_paylog}}',['plid'=>'502','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'13','uniontid'=>'2020121356101100','tid'=>'4200000833202012130323352842','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607805336','update_time'=>'1607805336']);
        $this->insert('{{%core_paylog}}',['plid'=>'503','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121310198525','tid'=>'4200000802202012134064280118','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607805710','update_time'=>'1607805710']);
        $this->insert('{{%core_paylog}}',['plid'=>'504','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121353102519','tid'=>'4200000805202012139180163692','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607806358','update_time'=>'1607806358']);
        $this->insert('{{%core_paylog}}',['plid'=>'505','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121351515448','tid'=>'4200000802202012135501878831','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607806723','update_time'=>'1607806723']);
        $this->insert('{{%core_paylog}}',['plid'=>'506','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121353554897','tid'=>'4200000833202012131702912530','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607848629','update_time'=>'1607848629']);
        $this->insert('{{%core_paylog}}',['plid'=>'507','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121357489798','tid'=>'4200000798202012130531335253','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607854777','update_time'=>'1607854777']);
        $this->insert('{{%core_paylog}}',['plid'=>'508','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121349995699','tid'=>'4200000781202012130988584208','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607855233','update_time'=>'1607855233']);
        $this->insert('{{%core_paylog}}',['plid'=>'509','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121348579757','tid'=>'4200000788202012132353708965','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607855696','update_time'=>'1607855696']);
        $this->insert('{{%core_paylog}}',['plid'=>'510','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121399545410','tid'=>'4200000794202012130919498411','fee'=>'10.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607855980','update_time'=>'1607855980']);
        $this->insert('{{%core_paylog}}',['plid'=>'511','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121310250575','tid'=>NULL,'fee'=>'12.00','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607864463','update_time'=>'1607864463']);
        $this->insert('{{%core_paylog}}',['plid'=>'512','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121353564956','tid'=>'4200000791202012138803664903','fee'=>'12.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607864805','update_time'=>'1607864805']);
        $this->insert('{{%core_paylog}}',['plid'=>'513','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121351559910','tid'=>'4200000829202012132598255517','fee'=>'12.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607866595','update_time'=>'1607866595']);
        $this->insert('{{%core_paylog}}',['plid'=>'514','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121354551019','tid'=>'4200000832202012133249670226','fee'=>'12.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607867606','update_time'=>'1607867606']);
        $this->insert('{{%core_paylog}}',['plid'=>'515','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121310151505','tid'=>'4200000787202012138038327611','fee'=>'15.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607868462','update_time'=>'1607868462']);
        $this->insert('{{%core_paylog}}',['plid'=>'516','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'123','uniontid'=>'2020121410299995','tid'=>'4200000779202012143408883477','fee'=>'30.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607915231','update_time'=>'1607915231']);
        $this->insert('{{%core_paylog}}',['plid'=>'517','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'37','uniontid'=>'2020121498549752','tid'=>'4200000789202012142471865936','fee'=>'1.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607920619','update_time'=>'1607920619']);
        $this->insert('{{%core_paylog}}',['plid'=>'518','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'Store2020121454575110','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607929958','update_time'=>'1607929958']);
        $this->insert('{{%core_paylog}}',['plid'=>'519','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'Store2020121456985653','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607930136','update_time'=>'1607930136']);
        $this->insert('{{%core_paylog}}',['plid'=>'520','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'Store2020121453102499','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607930310','update_time'=>'1607930310']);
        $this->insert('{{%core_paylog}}',['plid'=>'521','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'Store2020121499549755','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607930732','update_time'=>'1607930732']);
        $this->insert('{{%core_paylog}}',['plid'=>'522','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'Store2020121448551004','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607931008','update_time'=>'1607931008']);
        $this->insert('{{%core_paylog}}',['plid'=>'523','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'S2020121452975449','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607931748','update_time'=>'1607931748']);
        $this->insert('{{%core_paylog}}',['plid'=>'524','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'S2020121410057489','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607931901','update_time'=>'1607931901']);
        $this->insert('{{%core_paylog}}',['plid'=>'525','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'S2020121457505355','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607931977','update_time'=>'1607931977']);
        $this->insert('{{%core_paylog}}',['plid'=>'526','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'S2020121452545248','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607932068','update_time'=>'1607932068']);
        $this->insert('{{%core_paylog}}',['plid'=>'527','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'S2020121450554856','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607932194','update_time'=>'1607932194']);
        $this->insert('{{%core_paylog}}',['plid'=>'528','bloc_id'=>'10','store_id'=>'49','type'=>'wechat','openid'=>'ow8ul6OL6skkZdDJClxCwZrvjUjU','member_id'=>'23','uniontid'=>'S2020121456985310','tid'=>NULL,'fee'=>'1.00','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607933592','update_time'=>'1607933592']);
        $this->insert('{{%core_paylog}}',['plid'=>'529','bloc_id'=>'8','store_id'=>'60','type'=>'wechat','openid'=>'ow8ul6K41U7zoHNJTLhFRrxYhImw','member_id'=>'14','uniontid'=>'S2020121449100495','tid'=>NULL,'fee'=>'0.10','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607939009','update_time'=>'1607939009']);
        $this->insert('{{%core_paylog}}',['plid'=>'530','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'23','uniontid'=>'2020121457545298','tid'=>'4200000802202012141820235948','fee'=>'13.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607939977','update_time'=>'1607939977']);
        $this->insert('{{%core_paylog}}',['plid'=>'531','bloc_id'=>'8','store_id'=>'61','type'=>'wechat','openid'=>'ow8ul6OL6skkZdDJClxCwZrvjUjU','member_id'=>'23','uniontid'=>'S2020121454101102','tid'=>NULL,'fee'=>'12.00','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607940054','update_time'=>'1607940054']);
        $this->insert('{{%core_paylog}}',['plid'=>'532','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>'ow8ul6OL6skkZdDJClxCwZrvjUjU','member_id'=>'23','uniontid'=>'S2020121452975797','tid'=>NULL,'fee'=>'12.00','status'=>'0','module'=>'diandi_distribution','tag'=>'到店支付','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607941380','update_time'=>'1607941380']);
        $this->insert('{{%core_paylog}}',['plid'=>'533','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'33','uniontid'=>'2020121410151545','tid'=>'4200000801202012144231900044','fee'=>'55.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607946094','update_time'=>'1607946094']);
        $this->insert('{{%core_paylog}}',['plid'=>'534','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'364','uniontid'=>'2020121455529998','tid'=>NULL,'fee'=>'19.90','status'=>'0','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607953767','update_time'=>'1607953767']);
        $this->insert('{{%core_paylog}}',['plid'=>'535','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'161','uniontid'=>'2020121557575449','tid'=>'4200000798202012152088703188','fee'=>'68.00','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1607988457','update_time'=>'1607988457']);
        $this->insert('{{%core_paylog}}',['plid'=>'536','bloc_id'=>'8','store_id'=>'48','type'=>'wechat','openid'=>NULL,'member_id'=>'388','uniontid'=>'2020121552995210','tid'=>'4200000799202012156535435392','fee'=>'19.90','status'=>'1','module'=>'diandi_distribution','tag'=>'小程序下单','is_usecard'=>NULL,'card_type'=>NULL,'card_id'=>NULL,'card_fee'=>NULL,'encrypt_code'=>NULL,'is_wish'=>NULL,'create_time'=>'1608019572','update_time'=>'1608019572']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%core_paylog}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

