<?php
/*
	[FRCMS] Copyright (c) 2013 Finereason.COM
	This is NOT a freeware, use is subject to license.txt
*/
defined('IN_FR') or exit('Access Denied');
function getNextTime($looptype, $day = 0, $hour = 0, $minute = 0, $second = 0) {
    global $fr_time;
    $_second = intval(date('s', $fr_time));
	$_minute = intval(date('i', $fr_time));
	$_hour 	= date("G",$fr_time);
	$_day 	= date('j', $fr_time);
	$_week 	= date('w', $fr_time);
	$_mouth = date('n', $fr_time);
	$_year = date('Y', $fr_time);
	$nexttime =  mktime($_hour, 0, 0, $_mouth, $_day, $_year);
	switch ($looptype) {
	case 'month':
		$isLeapYear = date('L', $fr_time);
		$mouthDays = _getMouthDays($_month, $isLeapYear);
		if ($day == 99) $day = $mouthDays;
		$nexttime += ($hour < $_hour ? -($_hour - $hour) : $hour - $_hour) * 3600;
		if ($hour <= $_hour && $day == $_day) {
			$nexttime +=  ($mouthDays - $_day + $day) * 86400;
		} else {
			$nexttime +=  ($day < $_day ? $mouthDays - $_day + $day : $day - $_day) * 86400;
		}
		break;
	case 'week':
		$nexttime += ($hour < $_hour ? -($_hour - $hour) : $hour - $_hour) * 3600;
		if ($hour <= $_hour && $day == $_week) {
			$nexttime +=  (7 - $_week + $day) * 86400;
		} else {
			$nexttime +=  ($day < $_week ? 7 - $_week + $day : $day - $_week) * 86400;
		}
		break;
	case 'day':
		$nexttime += ($hour < $_hour ? -($_hour - $hour) : $hour - $_hour) * 3600;
		if ($hour <= $_hour) {
			$nexttime +=  86400;
		}
		break;
	case 'hour':
		$nexttime += $minute < $_minute ? 3600 + $minute * 60 :  $minute * 60;
		break;
	case 'now':
		$nexttime =  mktime($_hour, $_minute, $second, $_mouth, $_day, $_year);
		$_time = $day * 24 * 60;
		$_time += $hour * 60;
		$_time += $minute;
		$_time = $_time * 60;
        $_time += $_second;
		$nexttime += $_time;
		break;
	}
    return $nexttime;
}
function _getMouthDays($month, $isLeapYear) {
	if (in_array($month,array('1','3','5','7','8','10','12'))) {
		$days = 31;
	} elseif ($month!=2) {
		$days = 30;
	} else {
		if ($isLeapYear) {
			$days = 29;
		} else {
			$days = 28;
		}
	}
	return $days;
}
function getcronlist($cron=''){
    $cronstr='';
    $crons_root=FR_ROOT.'/inc/crons/';
    $files = glob($crons_root.'*');
    if($files){
        foreach($files as $k=>$v) {
            if(!is_dir($v)) {
    			$filename = str_replace($crons_root, '', $v);
    			if(preg_match("/^[0-9a-z_-]+\.php$/", $filename)) {
    				$fileid = str_replace('.php', '', $filename);
                    $cronstr.="<option value=\"$fileid\"";
                    $cron==$fileid&&$cronstr.=" selected=\"selected\"";
                    $cronstr.=">$filename</option>\r\n";
    			}
            }
    	}
    }
    return $cronstr;
}
function weekday($str=''){
    switch ($str){
    	case 1:return 'һ';break;
    	case 2:return 'ܶ';break;
    	case 3:return '';break;
    	case 4:return '';break;
    	case 5:return '';break;
    	case 6:return '';break;
    	case 0:return '';break;
    	default:return '';
    }
}
function nowtype($day = 0, $hour = 0, $minute = 0, $second = 0){
    $day&&$str=$day.'';
    $hour&&$str=$hour.'Сʱ';
    $minute&&$str=$minute.'';
    $second&&$str=$second.'';
    return $str;
}
?>