﻿/*
* bitmapcutter
* version: 1.0.0 (05/24/2009)
* @ jQuery v1.2.*
*
* Licensed under the GPL:
*   http://gplv3.fsf.org
*
* Copyright 2008, 2009 Jericho [ thisnamemeansnothing[at]gmail.com ] 
*  
*/
var _path = document.getElementsByTagName('script');
_path = _path[_path.length-1].src.replace(/\\/g, '/');
$.getPath = _path.lastIndexOf('/') < 0 ? '.' : _path.substring(0, _path.lastIndexOf('/'));
window.$bcglobal = {
    $originalSize: { width: 0, top: 0 },
    $zoomValue: 1.0,
    $thumbimg: null,
    $img: null,
    $cutter: null
};
$.extend(
    $.fn, {
        f: function(c) {
            return parseInt($(this).css(c));
        },
        loadBitmap: function(callback) {
            var me = this,
                  bitmapCutterHolder = new Image(),
                  src = me.attr('rel');
            bitmapCutterHolder.src = src;
            this.onCompleted = function() {
                $(me).attr('src', src);
                $bcglobal.$originalSize = { width: bitmapCutterHolder.width, height: bitmapCutterHolder.height };
                callback(src);
            };
            if ($.browser.msie) {
                if (bitmapCutterHolder.readyState == "complete") {
                    me.onCompleted();
                }
                else bitmapCutterHolder.onreadystatechange = function() {
                    if (this.readyState == "complete") {
                        me.onCompleted();
                    }
                }
            }
            else {
                bitmapCutterHolder.onload = me.onCompleted;
            }
        },
        scaleBitmap: function() {
            return this.each(function() {
                var me = $(this),
                      os = $bcglobal.$originalSize,
                      zoomValue = $bcglobal.$zoomValue;

                me.hide();
                if (os.width > 0 && os.height > 0) {
                    me.height(os.height * zoomValue)
                          .width(os.width * zoomValue);
                }
                var p = me.parent(),
                      w = me.width(),
                      h = me.height(),
                      t = (p.height() - h) / 2,
                      l = (p.width() - w) / 2;
                me.css({ 'top': t, 'left': l }).show();
                $('.jquery-bitmapcutter-info').html(w + ' : ' + h);
            });
        },
        dragndrop: function(setting) {
            var ps = $.fn.extend({
                limited: {
                    lw: { min: 0, max: 100 },
                    th: { min: 0, max: 100 }
                },
                handler: null,
                callback: function(e) { }
            }, setting);
            var dragndrop = {
                drag: function(e) {
                    var d = e.data.d;
                    var p = {
                        left: Math.min(Math.max(e.pageX + d.left, ps.limited.lw.min), ps.limited.lw.max),
                        top: Math.min(Math.max(e.pageY + d.top, ps.limited.th.min), ps.limited.th.max),
                        target: d.target
                    };
                    ps.callback(p);
                },
                drop: function(e) {
                    $("#cutter").unbind('mousemove', dragndrop.drag).unbind('mouseup', dragndrop.drop);
                }
            };
            return this.each(function() {
                if (ps.handler == null) { ps.handler = $(this) };
                var handler = (typeof ps.handler == 'string' ? $(ps.handler) : ps.handler);
                handler.bind('mousedown', function(e) {
                    var data = {
                        target: $(this),
                        left: $(this).f('left') - e.pageX,
                        top: $(this).f('top') - e.pageY
                    };
                    $("#cutter").bind('mousemove', { d: data }, dragndrop.drag).bind('mouseup', dragndrop.drop);
                });
            });
        },
        bitmapCutter: function(settings) {
            var lang = {
                zoomout: 'Zoom out',
                zoomin: 'Zoom in',
                original: 'Original size',
                clockwise: 'Clockwise rotation({0} degrees)',
                counterclockwise: 'Counterclockwise rotation({0} degrees)',
                generate: 'Generate!',
                process: 'Please wait, transaction is processing......',
                left: 'Left',
                right: 'Right',
                up: 'Up',
                down: 'Down',
                //#recole
                prefixUrl: '',
                imgPath: '',
                fileName: ''
                //recole#
            };
            var ps = $.fn.extend({
                src: '',
                renderTo: $(document.body),
                holderSize: { width: 300, height: 400 },
                cutterSize: { width: 70, height: 70 },
                zoomStep: 0.2,
                zoomIn: 2.0,
                zoomOut: 0.1,
                rotateAngle: 90,
                //pixel
                moveStep: 100,
                onGenerated: function(src) { },
                lang: lang
            }, settings);

            //fill parameters
            ps.lang = $.extend(lang, ps.lang);
            ps.lang.clockwise = ps.lang.clockwise.format(ps.rotateAngle);
            ps.lang.counterclockwise = ps.lang.counterclockwise.format(ps.rotateAngle);
            function izoom(zv) {
                $bcglobal.$zoomValue = zv;
                $bcglobal.$img.scaleBitmap($bcglobal.$zoomValue);
                $bcglobal.$thumbimg.scaleBitmap($bcglobal.$zoomValue);
                scissors.createThumbnail();
            }
            function irotate(angle) {
                var img = $bcglobal.$img,
                  thumbimg = $bcglobal.$thumbimg,
                  zoomValue = $bcglobal.$zoomValue,
                //Use 'rel' but not 'src',  this helps to make sure that the 'src' attribute was not start with 'http://localhost:8888/...'(msie)
                  src = img.attr('rel');
                $.ajax({
                    url: 'photocutter.php',
                    dataType: 'json',
                    //#recole
                    //data: { action: 'RotateBitmap', src: src, angle: angle, t: Math.random() },
                    data: { action: 'RotateBitmap', src: ps.lang.imgPath + src, angle: angle, t: Math.random() },
                    //recole#
                    error: function(msg) {
                        alert('rotate failed!');
                    },
                    success: function(json) {
                        if (json.msg == 'success') {
                            $bcglobal.$originalSize = json.size;
                            //clear cache of img
                            src += '?t=' + Math.random();
                            img.attr('src', src).scaleBitmap();
                            thumbimg.attr('src', src).scaleBitmap();
                            scissors.createThumbnail();
                        }
                        else {
                            alert(json.msg);
                        }
                    }
                });
            }
            function imove(direction) {
                var thumbimg = $bcglobal.$thumbimg,
                      img = $bcglobal.$img,
                      cutter = $bcglobal.$cutter,
                      w = img.width(),
                      h = img.height(),
                      l = img.f('left'),
                      t = img.f('top');

                if (w <= ps.holderSize.width && h <= ps.holderSize.height) {
                    return;
                }
                var limited = {
                    left: { min: Math.min(ps.holderSize.width - w, 0), max: Math.max(ps.holderSize.width - w, 0) },
                    top: { min: Math.min(ps.holderSize.height - h, 0), max: Math.max(ps.holderSize.height - h, 0) }
                };
                /*
                * it's really a weird thing that i cant use '
                *  img.animate({
                *       d: v
                *    }, function() {
                *       thumbimg.fadeIn();
                *        scissors.createThumbnail();
                *   });
                * '
                * here (d was the direction-'left' and 'top', v was the position data to be calculated!)
                * maybe it's the json to haunt me;-)
                */
                if (!img.is(':animated')) {
                    thumbimg.fadeOut();
                    var v = 0, d = {};
                    switch (direction) {
                        case 'left':
                            v = Math.min(limited.left.max, l + ps.moveStep);
                            d = { left: v };
                            break;
                        case 'right':
                            v = Math.max(limited.left.min, l - ps.moveStep);
                            d = { left: v };
                            break;
                        case 'up':
                            v = Math.min(limited.top.max, t + ps.moveStep);
                            d = { top: v };
                            break;
                        case 'down':
                            v = Math.max(limited.top.min, t - ps.moveStep);
                            d = { top: v };
                            break;
                    }

                    img.animate(d, function() {
                        thumbimg.fadeIn();
                        scissors.createThumbnail();
                    });
                }
            }
            var scissors = {
                createThumbnail: function() {
                    var thumbimg = $bcglobal.$thumbimg,
                          img = $bcglobal.$img,
                          cutter = $bcglobal.$cutter;

                    thumbimg.css({
                        'left': -cutter.f('left') + img.f('left'),
                        'top': -cutter.f('top') + img.f('top')
                    });
                },
                zoomin: function() {
                    //window.console && console.log('zoom value: %s', zoomValue);
                    izoom.call(this, Math.min($bcglobal.$zoomValue + ps.zoomStep, ps.zoomIn));
                },
                zoomout: function() {
                    //window.console && console.log('zoom value: %s', zoomValue);
                    izoom.call(this, Math.max($bcglobal.$zoomValue - ps.zoomStep, ps.zoomOut));
                },
                original: function() {
                    izoom.call(this, 1, 1);
                },
                clockwise: function() {
                    irotate.call(this, ps.rotateAngle);
                },
                counterclockwise: function(e) {
                    irotate.call(this, -ps.rotateAngle);
                },
                left: function() {
                    imove.call(this, 'left');
                },
                up: function() {
                    imove.call(this, 'up');
                },
                right: function() {
                    imove.call(this, 'right');
                },
                down: function() {
                    imove.call(this, 'down');
                }
            };
            ps.renderTo = (typeof ps.renderTo == 'string' ? $(ps.renderTo) : ps.renderTo);

            //#recole,加入table
            var $ctable = $('<table  border="0" cellpadding="0" cellspacing="0"><tr><td id="ctable_td_left" valign="top" width="380px"></td><td style="width:10px">&nbsp;</td><td id="ctable_td_right" style="text-align:left;padding-top:27px" valign="top"></td><td style="width:10px">&nbsp;</td></tr></table>').appendTo(ps.renderTo);
            //recole#
            var $opts = $('<div class="jquery-bitmapcutter-opts" style="margin:0;padding:0">' +
            '<img src="images/c_zoom_out.jpg" class="zoomin" />' +
            '<img src="images/c_zoom_in.jpg" class="zoomout" />' +
            '<img src="images/c_s_left.jpg" class="counterclockwise" />' +
            '<img src="images/c_s_right.jpg" class="clockwise" />' +
            '<img src="images/c_m_left.jpg" class="left" />' +
            '<img src="images/c_m_up.jpg" class="up" />' +
            '<img src="images/c_m_right.jpg" class="right" />' +
            '<img src="images/c_m_down.jpg" class="down" />' +
            '<img src="images/c_reset.jpg" class="original" />' +
            '</div>').appendTo($('#ctable_td_left'));

            //var $cl = $('<div class="jquery-bitmapcutter-cl" onselectstart="return false;"></div>').appendTo(ps.renderTo);
            var $cl = $('<div class="jquery-bitmapcutter-cl" onselectstart="return false;"></div>').insertAfter($opts);

            //var $cr = $('<div class="jquery-bitmapcutter-cr"></div>').appendTo(ps.renderTo);
            var $cr = $('<div class="jquery-bitmapcutter-cr" style="text-align:center"></div>').appendTo($('#ctable_td_right'));

            //bitmap holder
            var $holder = $('<div class="jquery-bitmapcutter-holder jquery-loader"/>')
                                    .css(ps.holderSize)
                                        .appendTo($cl);


            //#recole
            //'</div>').insertAfter($cr);
            //recle#


            $opts.css('width', ps.holderSize.width)
            .find('div.r2c1>a:eq(0)')
            .css('margin-left', (ps.holderSize.width - (16 + 6) * 7 + 3) / 2);

            //informations of bitmap
            var $info = $('<div title="Size Of Bitmap" class="jquery-bitmapcutter-info" />')
                                .insertAfter($opts)
                                    .css('width', ps.holderSize.width).hide();

            //cutter
            var $cutter = $('<div id="cutter" class="jquery-bitmapcutter-cutter" title="您可以拖动此框，选择您要裁剪的区域">&nbsp</div>')
                                    .css(ps.cutterSize)
                                        .css({
                                            'opacity': .4,
                                            'left': (ps.holderSize.width - ps.cutterSize.width) / 2,
                                            'top': (ps.holderSize.height - ps.cutterSize.height) / 2
                                        }).appendTo($holder);
            //#recole加入双击裁剪功能
            //.dblclick(function() { $generate.click(); });
            //recole#
            //initialize zoom value
            $bcglobal.$zoomValue = 1;

            //image<div class="color-box"></div>
            var $img = $('<img alt="" rel="' + ps.src + '" />').appendTo($holder);
            $('<div class="color-box"></div>').appendTo($cr);
            var $thumbimg = $('<img alt="预览" rel="' + ps.src + '" />').appendTo($('<div class="jquery-bitmapcutter-thumbnail" style="background-color: #ffffff;" />').css(ps.cutterSize).appendTo($cr));
            var $generate = $('<a href="javascript:void(0)" class="cut" onfocus="this.blur()" title="裁剪" >' + ps.lang.generate + '</a>').appendTo($cr).hide();
            var $newimg = $('<img id="jquery-bitmappcutter-newimg" class="jquery-bitmapcutter-newimg" alt="" src="images/bg.gif" />').appendTo($cr).hide();
            var $savebutton = $('<img src="images/btn_save.gif" alt="" style="margin-top:10px;cursor:pointer" />').insertAfter($newimg).click(function() {$generate.click();setTimeout('saveImage()', 1000);return false; });
            var $reSelect = $('<p class="jquery-bitmapcutter-reselect"><a href="javascript:" onclick="parent.show_isven_popup_window(\'请选择图片\',446,272,\''+$.getPath+'/uploadphoto.php\');return false;" title="重新选择图片" >重选图片</a></p>').insertAfter($savebutton);

            var $processed = $('<div id="div_process">' + ps.lang.process + '</div>').hide().insertAfter($reSelect);

            $img.loadBitmap(function(e) {
                $img.scaleBitmap();
                $holder.removeClass('jquery-loader');

                var ks = {
                    k37: 'left',
                    k38: 'up',
                    k39: 'right',
                    k40: 'down',
                    k45: 'zoomout',
                    k61: 'zoomin'
                };

                $().keypress(function(e) {
                    var k = (e.keyCode || e.which);
                    //window.console && console.log('key code: %s', k);
                    if ((k >= 37 && k <= 40) || k == 45 || k == 61) {
                        var func = eval('scissors.' + eval('(ks.k' + k + ')') + '');
                        func();
                    }
                });

                $thumbimg.attr('src', $img.attr('src')).scaleBitmap();


                //$opts.find('a').each(function() {
                $opts.find('img').each(function() {
                    var me = $(this), c = me.attr('class');
                    //me.attr('title', eval('(ps.lang.' + c + ')'))
                    me.attr('alt', eval('(ps.lang.' + c + ')')).css({ cursor: 'pointer' })
                    .hover(function() { this.src = getSrc(this.src, 1); }, function() { this.src = getSrc(this.src, 0); })
                        .bind('click', eval('(scissors.' + c + ')'));
                });
                function getSrc(src, flag) {
                    var mysrc = '';
                    if (flag == 1) { // 如果是鼠标经过
                        mysrc = src.replace('.jpg', '_hover.jpg');
                    }
                    else {
                        mysrc = src.replace('_hover', '');
                    }
                    //alert(mysrc);
                    return mysrc;
                }

                $cutter.dragndrop({
                    limited: {
                        lw: { min: 0, max: ps.holderSize.width - ps.cutterSize.width },
                        th: { min: 0, max: ps.holderSize.height - ps.cutterSize.height }
                    },
                    callback: function(e) {
                        $cutter.css({
                            left: e.left,
                            top: e.top
                        });
                        scissors.createThumbnail();
                    }
                });

                $generate.click(function() {
                    var me = $(this);

                    //me.fadeOut();
                    //$opts.fadeOut();
                    //$cutter.fadeOut();
                    //$info.hide();
                    //$processed.fadeIn();
                    //$processed.show();
                    $.ajax({
                        url: 'photocutter.php',
                        dataType: 'json',
                        data: {
                            action: 'GenerateBitmap',
                            src: ps.src.split('?')[0], //#recole
                            zoom: $bcglobal.$zoomValue,
                            x: $thumbimg.f('left'),
                            y: $thumbimg.f('top'),
                            width: ps.cutterSize.width,
                            height: ps.cutterSize.height,
                            t: Math.random(),
                            color: $('.jquery-bitmapcutter-thumbnail').getHexBackgroundColor(),
                            //#recole
                            prefixUrl: ps.lang.prefixUrl,
                            imgPath: ps.lang.imgPath,
                            fileName: ps.lang.fileName
                            //recole#
                        },
                        error: function(err) {
                            alert('cant generate it!');
                        },
                        success: function(json) {
                            if (json.msg == 'success') {
                                //me.fadeIn();
                                //$opts.fadeIn();
                                //$cutter.fadeIn();
                                //$info.show();
                                //$processed.fadeOut();
                                //$processed.hide();
                                //$newimg.attr('src', json.src + '?id=' + Math.random()); //.show();
                                ps.onGenerated(json.src);
                            }
                            else {
                                alert(json.msg);
                            }
                        }
                    });
                });
                $bcglobal.$cutter = $cutter;
                $bcglobal.$img = $img;
                $bcglobal.$thumbimg = $thumbimg;
            });
        }
    });
///<summary>
/// text format(same as c-sharp,
/// e.g.: 'example {0}: {2}'.format('A','none'))
/// output: example A: none
///</summary>
String.prototype.format = function() {
    var args = arguments;
    return this.replace(/{(\d{1})}/g, function() {
        return args[arguments[1]];
    });
};
$.fn.getHexBackgroundColor = function() {
    var rgb = $(this).css('background-color');
    if(rgb.indexOf('(')>=0){
        rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
        function hex(x) {
            return ("0" + parseInt(x).toString(16)).slice(-2);
        }
        rgb= "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]); 
    }
    return rgb;
}
