<?php
require(dirname(__FILE__).'/../config.inc.php');
set_time_limit(1800);
if($cfg['sitemap']){
    if(cmapfile(FR_ROOT."/sitemap.xml")){
        $db=connectdb();
        $maplimit=" limit 0,10000";
        $xmlcode='';
        $xmlcode.="<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
        $xmlcode.="<urlset>\n";
        //首页
        $xmlcode.="\t<url>\n";
        $xmlcode.="\t\t<loc>{$cfg['siteurl']}</loc>\n";
        $xmlcode.="\t\t<lastmod>".dtime($fr_time,3)."</lastmod>\n";
        $xmlcode.="\t\t<changefreq>weekly</changefreq>\n";
        $xmlcode.="\t</url>\n";
        //频道首页
        $sql="SELECT `c_channeldir` FROM `{$cfg['tb_pre']}channel` WHERE `c_disabled`=0 AND `c_shownav`=1 and c_channeltype<2 ORDER BY `c_order` ASC";
        $query=$db->query($sql);
        while($row=$db->fetch_array($query)){
            $xmlcode.="\t<url>\n";
            $xmlcode.="\t\t<loc>{$cfg['siteurl']}".formatlink($row['c_channeldir'],'index')."</loc>\n";
            $xmlcode.="\t\t<lastmod>".dtime($fr_time,3)."</lastmod>\n";
            $xmlcode.="\t\t<changefreq>weekly</changefreq>\n";
            $xmlcode.="\t</url>\n";
        }
        //简历
        $sql="select r_id,m_regdate,r_adddate from {$cfg['tb_pre']}resume INNER JOIN `{$cfg['tb_pre']}member` on `r_mid`=`m_id` WHERE `m_flag`=1 and `r_openness`=0 AND `r_personinfo`=1 AND `r_careerwill`=1 AND `r_flag`=1 AND `r_cnstatus`=1 order by r_adddate desc$maplimit";
        $query=$db->query($sql);
        while($row=$db->fetch_array($query)){
            $xmlcode.="\t<url>\n";
            $xmlcode.="\t\t<loc>{$cfg['siteurl']}".formatlink('company','hire',$row['m_regdate'],$row["r_id"])."</loc>\n";
            $xmlcode.="\t\t<lastmod>".dtime(strtotime($row["r_adddate"]),3)."</lastmod>\n";
            $xmlcode.="\t\t<changefreq>daily</changefreq>\n";
            $xmlcode.="\t</url>\n";
        }
        //职位
        $sql="select h_id,h_adddate,h_createdate from {$cfg['tb_pre']}hire INNER JOIN `{$cfg['tb_pre']}member` on `h_comid`=`m_id` WHERE `m_flag`=1 and DATEDIFF(`m_startdate`,'".date('Y-m-d')."')<=0 AND DATEDIFF(`m_enddate`,'".date('Y-m-d')."')>=0 AND DATEDIFF(`h_enddate`,'".date('Y-m-d')."')>=0 AND h_status=1 order by h_adddate desc$maplimit";
        $query=$db->query($sql);
        while($row=$db->fetch_array($query)){
            $xmlcode.="\t<url>\n";
            $xmlcode.="\t\t<loc>{$cfg['siteurl']}".formatlink('company','hire',$row['h_createdate'],$row["h_id"])."</loc>\n";
            $xmlcode.="\t\t<lastmod>".dtime(strtotime($row["h_adddate"]),3)."</lastmod>\n";
            $xmlcode.="\t\t<changefreq>daily</changefreq>\n";
            $xmlcode.="\t</url>\n";
        }
        //企业页面
        $sql="select m_id,m_regdate from `{$cfg['tb_pre']}member` WHERE `m_flag`=1 and DATEDIFF(`m_startdate`,'".date('Y-m-d')."')<=0 AND DATEDIFF(`m_enddate`,'".date('Y-m-d')."')>=0 AND m_typeid=2 order by m_id desc$maplimit";
        $query=$db->query($sql);
        while($row=$db->fetch_array($query)){
            $xmlcode.="\t<url>\n";
            $xmlcode.="\t\t<loc>{$cfg['siteurl']}".formatlink('company','company',$row['m_regdate'],$row["m_id"])."</loc>\n";
            $xmlcode.="\t\t<lastmod>".dtime(strtotime($row["h_adddate"]),3)."</lastmod>\n";
            $xmlcode.="\t\t<changefreq>daily</changefreq>\n";
            $xmlcode.="\t</url>\n";
        }
        //资讯页面
        $sql="select n_id,n_cid,n_addtime from `{$cfg['tb_pre']}news` WHERE n_url='' order by n_addtime desc$maplimit";
        $query=$db->query($sql);
        while($row=$db->fetch_array($query)){
            $rowc=$db->get_one("SELECT `c_channeldir` FROM `{$cfg['tb_pre']}channel` WHERE `c_id`={$row['n_cid']}");
            $xmlcode.="\t<url>\n";
            $xmlcode.="\t\t<loc>{$cfg['siteurl']}".formatlink($rowc['c_channeldir'],'info',$row['n_addtime'],$row['n_id'])."</loc>\n";
            $xmlcode.="\t\t<lastmod>".dtime(strtotime($row["n_addtime"]),3)."</lastmod>\n";
            $xmlcode.="\t\t<changefreq>daily</changefreq>\n";
            $xmlcode.="\t</url>\n";
        }
        $xmlcode.="</urlset>\n";
        fputs(fopen(FR_ROOT."/sitemap.xml",'w'), $xmlcode);
        exit();
    }
}
function change_strcode($str){
    if($str=="") return '';
    $str = str_replace("<br>","\r\n",$str);
    $str = str_replace("&nbsp;"," ",$str);
    return $str;
}
function cmapfile($filename){
    global $cfg;
    if(file_exists($filename)&&time()-filemtime($filename)<3600*intval($cfg['sitemaptime'])){
        return false;
    }else{
        return true;
    }
}
?>