<?php 
/*
'┌──────────────────── 深度空间 深度学习 ──┐
'│深度学习(php)分页类	(PHP Page Engine)
'│Version	: 0.0.3
'│作者：吕海鹏 www.deepstudy.cn
'│建立时间：2010-2-5	最后修改时间：2010-3-17
'└──────────────────── www.deepstudy.cn ──┘

1、	
	require_ once("deep_library/Deep.Class.Page.php");
2、
		//--- 1 分页初始化 -----
		$oPageMySQL=new Deep_Page();
		$oPageMySQL->pageSize=20;	 //定义每页显示记录数 默认10条
		$oPageMySQL->getConnection($conn);
		$oPageMySQL->CountSql("addressList","");
		
		if( isset($_GET['page']) ){
			$oPageMySQL->currentPage = intval( $_GET['page'] );		//intval -- 获取变量的整数值
		}
		$sql="SELECT * FROM addressList order by fName"." limit ".  $oPageMySQL->startResult() .",".$oPageMySQL->pageSize ;
		//-------------------------
3、
	//--- 2 分页导航 -----	
	echo "<div align='center'>".$oPageMySQL->pageNavigateUrl()."</div>";

*/

class Deep_Page
{
	var $page_name;	//page标签，用来控制url页。比如说xxx.php?deep_page=2中的deep_page

	var $pageSize;	//每页显示记录数 默认10条
	var $resultCount;	//总计录数
	var $currentPage;	//当前页
	private  $oMyConnection;	//connection对象
	
	function Deep_Page()
	{
		$this->page_name="page";
		$this->pageSize=10;	//
		$this->currentPage=1;
	}
	
	function __destruct()
	{
	}

	/*
	┌──────────────────── 深度空间 深度学习 ──┐
	│过程名：Function startResult()
	│作  用：sql limit查询开始记录                    
	│参  数： 
	│说  明：
	│日  期：2010/3/17
	└──────────────────── www.DeepTeach.com 2009-7-30──┘
	*/
	public function startResult()
	{
		return ($this->currentPage-1)*$this->pageSize ;
	}

	/*
	'┌──────────────────── 深度空间 深度学习 ──┐
	'│过程名：Function PageNavigateUrl()
	'│作  用：分页导航 显示函数                     
	'│参  数：
	'│说  明：	
	'│日  期：2009/2/28  2010-2-5
	'└──────────────────── www.deepstudy.cn ──┘
	*/
	public function pageNavigateUrl(){
		//global $conn;
		//global $pageSize, $currentPage;
		
		//url 参数 获得
		if(empty($_SERVER['QUERY_STRING'])){
					//echo $url_parameter.="&amp;";		
		}else{
			$url_parameter=ereg_replace("(^|&)".$this->page_name."=".$this->currentPage ,"",$_SERVER['QUERY_STRING'])."&"	 ;
		}

		// 获取总页数 $pageCount 记算总共有多少
		if( $this->resultCount >0 ){
		  if( $this->resultCount < $this->pageSize ){ $pageCount = 1; }        //如果总数据量小于$PageSize，那么只有一页
		  if( $this->resultCount % $this->pageSize ){                 //取总数据量除以每页数的余数
			$pageCount = (int)($this->resultCount / $this->pageSize) + 1;      //如果有余数，则页数等于总数据量除以每页数的结果取整再加一
		  }else{
			$pageCount = $this->resultCount / $this->pageSize;           //如果没有余数，则页数等于总数据量除以每页数的结果
		  }
		}
		else{
		  $pageCount = 0;
		}
		
		$strHTML ="";
		// 翻页链接
		$strHTML .= "<form method='get' onsubmit=\"document.location='?" .$url_parameter. $this->page_name."='+this.page.value;return false;\">";		
		if($this->currentPage<=1){
			$strHTML .= "[首页] [上一页] ";
		}else{
			$strHTML .= "[<a href='?".$url_parameter.$this->page_name."=1'>首页</a>] [<a href='?".$url_parameter.$this->page_name."=".($this->currentPage-1)."'>上一页</a>] ";
		}
		
		if( $this->currentPage >= $pageCount) {
			$strHTML .= "[下一页] [尾页]";
		}
		else{
			$strHTML .= "[<a href='?".$url_parameter.$this->page_name."=".($this->currentPage+1)."'>下一页</a>] [<a href='?".$url_parameter.$this->page_name."=".$pageCount."'>尾页</a>] ";
		}
		
		 $strHTML .=" [页次:<font color='red'>" . $this->currentPage . "</font>/" . $pageCount ;
		 $strHTML .="] [共". $this->resultCount . "条 <font color='red'>". $this->pageSize . "</font>条/页]";
	
		$strHTML .=" 转到<input name='page' value='" . $this->currentPage . "' style='width:30px;'/>页<input type='submit' value='go' />";
		$strHTML .="</form>";
	
		return $strHTML ;
	}


	/*
	'┌──────────────────── 深度空间 深度学习 ──┐
	'│过程名：Function CountSql()
	'│作  用：分页导航 显示函数                     
	'│参  数：
	'│说  明：	返回一个查看记录总数的SQL语句 
	'│日  期：2010-2-5  2010-2-5
	'└──────────────────── www.deepstudy.cn ──┘
	*/
   public Function  CountSql( $tableName, $whereCondition)
   {
		//总记录数
		$tempSql = "select   count(*)   from   " . $tableName ;
		if ($whereCondition != "") $tempSql =$tempSql . "   where   " . $whereCondition;
		
		$stmt = $this->oMyConnection->query($tempSql ); 
		$row = $stmt->fetch();
		
		$this->resultCount=$row[0];
		return $this->resultCount;	//总记录数	
   }


	/*
		'┌──────────────────── 深度空间 深度学习 ──┐
		'│过程名：Function getConnection()
		'│作  用：得到Connection对象 供CountSql函数调用                    
		'│参  数：
		'│说  明：	
		'│日  期：2009/2/28  2010-2-5
		'└──────────────────── www.deepstudy.cn ──┘
	*/
	Public function getConnection($oConnection)
	{
		$this->oMyConnection=$oConnection;
	}






}
?>