<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        if ($this->template->security && isset($this->smarty->security_handler)) {
              $this->sec_obj = $this->smarty->security_policy;
        } else {
              $this->sec_obj = $this->smarty;
        }
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       assert($tag !== false && $count === 1);
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       assert($tag_text === '?>');
       return '?<?php ?>>';
    }

    
#line 127 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_FAKEPHPSTARTTAG                =  6;
    const TP_XMLTAG                         =  7;
    const TP_OTHER                          =  8;
    const TP_PHP_CODE                       =  9;
    const TP_PHP_CODE_START_DOUBLEQUOTE     = 10;
    const TP_PHP_CODE_DOUBLEQUOTE           = 11;
    const TP_PHP_HEREDOC_START              = 12;
    const TP_PHP_HEREDOC_END                = 13;
    const TP_PHP_NOWDOC_START               = 14;
    const TP_PHP_NOWDOC_END                 = 15;
    const TP_PHP_DQ_CONTENT                 = 16;
    const TP_PHP_DQ_EMBED_START             = 17;
    const TP_PHP_DQ_EMBED_END               = 18;
    const TP_LITERALSTART                   = 19;
    const TP_LITERALEND                     = 20;
    const TP_LITERAL                        = 21;
    const TP_LDEL                           = 22;
    const TP_RDEL                           = 23;
    const TP_DOLLAR                         = 24;
    const TP_ID                             = 25;
    const TP_EQUAL                          = 26;
    const TP_FOREACH                        = 27;
    const TP_PTR                            = 28;
    const TP_IF                             = 29;
    const TP_SPACE                          = 30;
    const TP_FOR                            = 31;
    const TP_SEMICOLON                      = 32;
    const TP_INCDEC                         = 33;
    const TP_TO                             = 34;
    const TP_STEP                           = 35;
    const TP_AS                             = 36;
    const TP_APTR                           = 37;
    const TP_LDELSLASH                      = 38;
    const TP_INTEGER                        = 39;
    const TP_COMMA                          = 40;
    const TP_MATH                           = 41;
    const TP_UNIMATH                        = 42;
    const TP_ANDSYM                         = 43;
    const TP_ISIN                           = 44;
    const TP_ISDIVBY                        = 45;
    const TP_ISNOTDIVBY                     = 46;
    const TP_ISEVEN                         = 47;
    const TP_ISNOTEVEN                      = 48;
    const TP_ISEVENBY                       = 49;
    const TP_ISNOTEVENBY                    = 50;
    const TP_ISODD                          = 51;
    const TP_ISNOTODD                       = 52;
    const TP_ISODDBY                        = 53;
    const TP_ISNOTODDBY                     = 54;
    const TP_INSTANCEOF                     = 55;
    const TP_OPENP                          = 56;
    const TP_CLOSEP                         = 57;
    const TP_QMARK                          = 58;
    const TP_NOT                            = 59;
    const TP_TYPECAST                       = 60;
    const TP_DOT                            = 61;
    const TP_BOOLEAN                        = 62;
    const TP_NULL                           = 63;
    const TP_SINGLEQUOTESTRING              = 64;
    const TP_DOUBLECOLON                    = 65;
    const TP_AT                             = 66;
    const TP_HATCH                          = 67;
    const TP_OPENB                          = 68;
    const TP_CLOSEB                         = 69;
    const TP_EQUALS                         = 70;
    const TP_NOTEQUALS                      = 71;
    const TP_GREATERTHAN                    = 72;
    const TP_LESSTHAN                       = 73;
    const TP_GREATEREQUAL                   = 74;
    const TP_LESSEQUAL                      = 75;
    const TP_IDENTITY                       = 76;
    const TP_NONEIDENTITY                   = 77;
    const TP_MOD                            = 78;
    const TP_LAND                           = 79;
    const TP_LOR                            = 80;
    const TP_LXOR                           = 81;
    const TP_QUOTE                          = 82;
    const TP_BACKTICK                       = 83;
    const TP_DOLLARID                       = 84;
    const YY_NO_ACTION = 585;
    const YY_ACCEPT_ACTION = 584;
    const YY_ERROR_ACTION = 583;

    const YY_SZ_ACTTAB = 1995;
static public $yy_action = array(
 /*     0 */   373,  584,   55,  252,  258,  280,    8,  196,  283,  115,
 /*    10 */    59,  107,  247,  119,  255,  112,  257,  122,   41,   43,
 /*    20 */    45,   40,   25,   27,  299,  298,   20,   28,  296,  297,
 /*    30 */    15,   14,    8,  330,   31,   17,  294,  239,  322,   35,
 /*    40 */   196,  112,  146,  294,  326,  337,  162,  312,  313,  314,
 /*    50 */   311,  310,  306,  307,  308,  309,  338,  339,  369,  196,
 /*    60 */   304,   23,   24,  202,   34,   37,   17,  360,    7,  322,
 /*    70 */    41,   43,   45,   40,   25,   27,  299,  298,   20,   28,
 /*    80 */   296,  297,   15,   14,  452,   17,  276,   17,  322,   36,
 /*    90 */   322,  452,  251,  258,  280,    2,  253,  109,  201,  312,
 /*   100 */   313,  314,  311,  310,  306,  307,  308,  309,  338,  339,
 /*   110 */   369,  133,  219,   17,  158,   42,  322,    8,   38,  213,
 /*   120 */   109,  154,  114,  365,   17,  351,  112,  322,  304,   22,
 /*   130 */   196,  227,   47,   46,  242,  315,  316,  317,  328,  243,
 /*   140 */    60,   41,   43,   45,   40,   25,   27,  299,  298,   20,
 /*   150 */    28,  296,  297,   15,   14,   56,   17,  231,   10,  322,
 /*   160 */    35,   54,    4,   60,   54,   32,   17,  117,  272,  241,
 /*   170 */   312,  313,  314,  311,  310,  306,  307,  308,  309,  338,
 /*   180 */   339,  369,  268,   41,   43,   45,   40,   25,   27,  299,
 /*   190 */   298,   20,   28,  296,  297,   15,   14,  139,  348,  282,
 /*   200 */   231,  209,  109,  218,  344,  273,  274,  185,   17,  358,
 /*   210 */   327,  322,  312,  313,  314,  311,  310,  306,  307,  308,
 /*   220 */   309,  338,  339,  369,  202,   41,   43,   45,   40,   25,
 /*   230 */    27,  299,  298,   20,   28,  296,  297,   15,   14,   97,
 /*   240 */   451,  324,  267,  180,  347,   60,  368,  196,  182,  265,
 /*   250 */   294,  207,  327,  196,  312,  313,  314,  311,  310,  306,
 /*   260 */   307,  308,  309,  338,  339,  369,   16,   41,   43,   45,
 /*   270 */    40,   25,   27,  299,  298,   20,   28,  296,  297,   15,
 /*   280 */    14,  149,   96,  261,   17,    8,  182,  199,  229,  116,
 /*   290 */   202,   54,  278,  101,  112,  304,  312,  313,  314,  311,
 /*   300 */   310,  306,  307,  308,  309,  338,  339,  369,  249,   41,
 /*   310 */    43,   45,   40,   25,   27,  299,  298,   20,   28,  296,
 /*   320 */   297,   15,   14,  156,  190,  224,   17,  321,  184,  322,
 /*   330 */   320,   13,  166,  347,  165,  347,  302,  304,  312,  313,
 /*   340 */   314,  311,  310,  306,  307,  308,  309,  338,  339,  369,
 /*   350 */   202,  287,   12,   41,   43,   45,   40,   25,   27,  299,
 /*   360 */   298,   20,   28,  296,  297,   15,   14,  202,  100,  244,
 /*   370 */   198,  362,  372,  381,  202,   19,  186,  222,  196,  114,
 /*   380 */   196,  327,  312,  313,  314,  311,  310,  306,  307,  308,
 /*   390 */   309,  338,  339,  369,  196,  328,    9,   23,   24,  240,
 /*   400 */    98,  271,   65,   21,   44,   41,   43,   45,   40,   25,
 /*   410 */    27,  299,  298,   20,   28,  296,  297,   15,   14,  145,
 /*   420 */   190,   44,  171,   64,  187,  367,  238,   13,   44,  353,
 /*   430 */   168,    5,  152,  304,  312,  313,  314,  311,  310,  306,
 /*   440 */   307,  308,  309,  338,  339,  369,  304,   41,   43,   45,
 /*   450 */    40,   25,   27,  299,  298,   20,   28,  296,  297,   15,
 /*   460 */    14,    8,  105,  236,   98,  342,  343,  380,  263,   98,
 /*   470 */   112,  183,  196,  196,  196,  327,  312,  313,  314,  311,
 /*   480 */   310,  306,  307,  308,  309,  338,  339,  369,  147,   41,
 /*   490 */    43,   45,   40,   25,   27,  299,  298,   20,   28,  296,
 /*   500 */   297,   15,   14,  332,  137,  329,  143,  281,  371,  288,
 /*   510 */   196,  267,  196,  279,  196,  196,  153,  327,  312,  313,
 /*   520 */   314,  311,  310,  306,  307,  308,  309,  338,  339,  369,
 /*   530 */   304,   41,   43,   45,   40,   25,   27,  299,  298,   20,
 /*   540 */    28,  296,  297,   15,   14,  148,  361,  293,  159,  341,
 /*   550 */   366,    6,  291,  196,  196,  270,  196,  196,  233,  304,
 /*   560 */   312,  313,  314,  311,  310,  306,  307,  308,  309,  338,
 /*   570 */   339,  369,  228,   41,   43,   45,   40,   25,   27,  299,
 /*   580 */   298,   20,   28,  296,  297,   15,   14,  349,  225,  305,
 /*   590 */   379,  174,  347,   63,  196,   26,  196,  196,   54,  110,
 /*   600 */   326,  178,  312,  313,  314,  311,  310,  306,  307,  308,
 /*   610 */   309,  338,  339,  369,   48,   41,   43,   45,   40,   25,
 /*   620 */    27,  299,  298,   20,   28,  296,  297,   15,   14,  202,
 /*   630 */   215,  333,  230,  116,  108,  209,  206,  116,  123,  221,
 /*   640 */   226,  246,  196,  262,  312,  313,  314,  311,  310,  306,
 /*   650 */   307,  308,  309,  338,  339,  369,  175,  128,  196,  303,
 /*   660 */   170,  289,  116,  250,    7,   41,   43,   45,   40,   25,
 /*   670 */    27,  299,  298,   20,   28,  296,  297,   15,   14,  144,
 /*   680 */   383,  275,  118,   26,  188,    5,  325,  113,  285,  211,
 /*   690 */   215,  334,  336,  304,  312,  313,  314,  311,  310,  306,
 /*   700 */   307,  308,  309,  338,  339,  369,  323,   41,   43,   45,
 /*   710 */    40,   25,   27,  299,  298,   20,   28,  296,  297,   15,
 /*   720 */    14,   18,  135,  245,  346,  277,  292,   62,  355,  335,
 /*   730 */   259,  126,  300,  242,  157,  327,  312,  313,  314,  311,
 /*   740 */   310,  306,  307,  308,  309,  338,  339,  369,  304,  354,
 /*   750 */   294,  382,  196,  111,   39,  217,  161,  350,  324,  295,
 /*   760 */    41,   43,   45,   40,   25,   27,  299,  298,   20,   28,
 /*   770 */   296,  297,   15,   14,  326,  131,   33,   11,   95,   61,
 /*   780 */    48,  254,  232,  256,  332,  332,  332,  332,  327,  312,
 /*   790 */   313,  314,  311,  310,  306,  307,  308,  309,  338,  339,
 /*   800 */   369,  202,   41,   43,   45,   40,   25,   27,  299,  298,
 /*   810 */    20,   28,  296,  297,   15,   14,  132,  332,  332,  332,
 /*   820 */   332,  332,  332,  378,  332,  332,  332,  332,  332,  327,
 /*   830 */   196,  312,  313,  314,  311,  310,  306,  307,  308,  309,
 /*   840 */   338,  339,  369,  332,  140,  332,  264,  332,  332,  136,
 /*   850 */   332,  332,  332,  332,    2,   44,  121,   57,  304,  125,
 /*   860 */     3,  223,  327,  235,    2,  142,  106,  191,  332,  163,
 /*   870 */   133,  219,  295,  332,   42,  332,  133,  332,  332,  304,
 /*   880 */   133,  219,  332,  304,   42,  332,  332,  332,   29,  332,
 /*   890 */   202,   47,   46,  295,  315,  316,  317,  295,   22,   60,
 /*   900 */     1,   47,   46,  332,  315,  316,  317,  332,  332,   60,
 /*   910 */     1,  269,  454,  332,   56,    2,  332,  106,  205,  454,
 /*   920 */   284,   30,  266,  332,   56,    2,  332,  109,  193,  332,
 /*   930 */   332,  133,  219,   17,  359,   42,  322,  332,  332,  332,
 /*   940 */   332,  133,  197,  332,   44,   42,  332,  332,  220,   22,
 /*   950 */   332,  332,   47,   46,  332,  315,  316,  317,  141,   22,
 /*   960 */    60,    1,   47,   46,  332,  315,  316,  317,  264,  332,
 /*   970 */    60,    1,  304,   23,   24,   56,    2,  332,  109,  201,
 /*   980 */   332,  332,    3,  332,  332,   56,    2,  332,  106,  205,
 /*   990 */   332,  332,  133,  219,  332,  332,   42,  332,  133,  332,
 /*  1000 */   332,  332,  133,  219,  332,  332,   42,  332,  332,  332,
 /*  1010 */    22,  332,  332,   47,   46,  332,  315,  316,  317,  151,
 /*  1020 */    29,   60,    1,   47,   46,  332,  315,  316,  317,  332,
 /*  1030 */   332,   60,    1,  304,   23,   24,   56,    2,  332,  106,
 /*  1040 */   194,  332,  290,   30,  266,  332,   56,    2,  332,  106,
 /*  1050 */   192,  332,  332,  133,  219,  332,  332,   42,  332,  332,
 /*  1060 */   332,  332,  332,  133,  219,  332,  332,   42,  332,  332,
 /*  1070 */   332,   22,  332,  332,   47,   46,  332,  315,  316,  317,
 /*  1080 */   332,   29,   60,    1,   47,   46,  332,  315,  316,  317,
 /*  1090 */   332,  332,   60,    1,  332,  332,  332,   56,    2,  332,
 /*  1100 */   120,  205,  332,  332,  332,  160,  332,   56,    2,  332,
 /*  1110 */   109,  204,  332,  332,  133,  219,  332,  332,   42,  304,
 /*  1120 */    23,   24,  332,  332,  133,  219,  332,  332,   42,  332,
 /*  1130 */   332,  332,   22,  332,  332,   47,   46,  332,  315,  316,
 /*  1140 */   317,  332,   22,   60,    1,   47,   46,  332,  315,  316,
 /*  1150 */   317,  332,  332,   60,  332,  332,  332,  319,   56,    2,
 /*  1160 */   332,  109,  203,  332,  332,  155,  332,  208,   56,  332,
 /*  1170 */   114,  332,  332,  332,  332,  133,  219,  332,  234,   42,
 /*  1180 */   332,  332,  332,  331,  318,  332,  328,  260,   99,  332,
 /*  1190 */   352,  356,  357,   22,  332,  332,   47,   46,  332,  315,
 /*  1200 */   316,  317,  332,  173,   60,  319,    2,  332,  332,  332,
 /*  1210 */   332,  332,  332,  138,  332,  208,   94,  332,  114,   56,
 /*  1220 */   332,  332,  133,  332,  332,  319,  370,  332,  332,  332,
 /*  1230 */   332,  331,  318,   58,  328,  104,   53,  129,  102,  332,
 /*  1240 */   332,  332,  332,  200,  364,  332,  370,  332,  319,  332,
 /*  1250 */   332,  331,  318,  332,  328,  319,   58,  332,  103,   51,
 /*  1260 */   129,  102,  332,  181,  332,  208,  332,  332,  114,  370,
 /*  1270 */   332,  332,  332,  332,  331,  318,  301,  328,  332,  332,
 /*  1280 */   332,  331,  318,  319,  328,  332,  332,  319,  332,  332,
 /*  1290 */   332,  150,  332,  208,   66,  134,  114,  208,   50,  127,
 /*  1300 */   114,  332,  332,  332,  370,  376,  374,  375,  370,  331,
 /*  1310 */   318,  332,  328,  331,  318,  319,  328,  332,  332,  210,
 /*  1320 */   173,  340,  377,  150,  332,  208,   66,  319,  114,  332,
 /*  1330 */   332,  332,  332,  332,  332,  150,  370,  208,   66,  332,
 /*  1340 */   114,  331,  318,  332,  328,  332,  332,  332,  370,  319,
 /*  1350 */   332,  216,  332,  331,  318,  332,  328,  138,  332,  208,
 /*  1360 */    94,  332,  114,  286,  332,  332,  332,  332,  332,  332,
 /*  1370 */   370,  332,  332,  319,  332,  331,  318,  332,  328,  332,
 /*  1380 */   332,  150,  332,  208,   66,  319,  114,  332,  363,  332,
 /*  1390 */   332,  332,  332,  130,  370,  208,   79,  248,  114,  331,
 /*  1400 */   318,  332,  328,  332,  332,  319,  370,  332,  332,  212,
 /*  1410 */   332,  331,  318,  150,  328,  208,   71,  319,  114,  332,
 /*  1420 */   332,  237,  332,  332,  332,  150,  370,  208,   52,  124,
 /*  1430 */   114,  331,  318,  332,  328,  332,  332,  332,  370,  319,
 /*  1440 */   332,  332,  332,  331,  318,  332,  328,  150,  332,  195,
 /*  1450 */    67,  332,  114,  332,  332,  332,  332,  332,  332,  332,
 /*  1460 */   370,  332,  332,  319,  332,  331,  318,  332,  328,  332,
 /*  1470 */   332,  150,  332,  208,   89,  319,  114,  332,  332,  332,
 /*  1480 */   332,  332,  332,  150,  370,  208,   92,  319,  114,  331,
 /*  1490 */   318,  332,  328,  332,  332,  150,  370,  208,   70,  319,
 /*  1500 */   114,  331,  318,  332,  328,  332,  332,  150,  370,  208,
 /*  1510 */    93,  319,  114,  331,  318,  332,  328,  332,  332,  150,
 /*  1520 */   370,  208,   88,  332,  114,  331,  318,  332,  328,  332,
 /*  1530 */   332,  332,  370,  319,  332,  332,  332,  331,  318,  332,
 /*  1540 */   328,  150,  319,  208,   78,  332,  114,  332,  332,  332,
 /*  1550 */   150,  332,  208,   81,  370,  114,  332,  332,  332,  331,
 /*  1560 */   318,  332,  328,  370,  319,  332,  332,  332,  331,  318,
 /*  1570 */   332,  328,  150,  319,  208,   82,  332,  114,  332,  332,
 /*  1580 */   332,  150,  332,  208,   73,  370,  114,  332,  332,  332,
 /*  1590 */   331,  318,  332,  328,  370,  332,  332,  319,  332,  331,
 /*  1600 */   318,  319,  328,  332,  332,  150,  332,  208,   86,  150,
 /*  1610 */   114,  208,   80,  332,  114,  332,  332,  332,  370,  332,
 /*  1620 */   332,  332,  370,  331,  318,  332,  328,  331,  318,  332,
 /*  1630 */   328,  319,  332,  332,  332,  332,  332,  332,  332,  150,
 /*  1640 */   319,  208,   76,  332,  114,  332,  332,  332,  150,  332,
 /*  1650 */   208,   90,  370,  114,  332,  332,  332,  331,  318,  332,
 /*  1660 */   328,  370,  319,  332,  332,  332,  331,  318,  332,  328,
 /*  1670 */   150,  319,  208,   83,  332,  114,  332,  332,  332,  150,
 /*  1680 */   332,  208,   84,  370,  114,  332,  332,  332,  331,  318,
 /*  1690 */   332,  328,  370,  332,  332,  319,  332,  331,  318,  319,
 /*  1700 */   328,  332,  332,  150,  332,  208,   75,  150,  114,  208,
 /*  1710 */    85,  332,  114,  332,  332,  332,  370,  332,  332,  332,
 /*  1720 */   370,  331,  318,  332,  328,  331,  318,  332,  328,  319,
 /*  1730 */   332,  332,  332,  332,  332,  332,  332,  150,  319,  208,
 /*  1740 */    49,  332,  114,  332,  332,  332,  150,  332,  208,   74,
 /*  1750 */   370,  114,  332,  332,  332,  331,  318,  332,  328,  370,
 /*  1760 */   319,  332,  332,  332,  331,  318,  332,  328,  150,  319,
 /*  1770 */   208,   72,  332,  114,  332,  332,  332,  150,  332,  208,
 /*  1780 */    68,  370,  114,  332,  332,  332,  331,  318,  332,  328,
 /*  1790 */   370,  332,  332,  319,  332,  331,  318,  319,  328,  332,
 /*  1800 */   332,  150,  332,  208,   91,  150,  114,  208,   77,  332,
 /*  1810 */   114,  332,  332,  332,  370,  332,  332,  332,  370,  331,
 /*  1820 */   318,  332,  328,  331,  318,  332,  328,  319,  332,  332,
 /*  1830 */   332,  332,  332,  332,  332,  150,  319,  208,   87,  332,
 /*  1840 */   114,  332,  332,  332,  150,  332,  208,   69,  370,  114,
 /*  1850 */   332,  332,  332,  331,  318,  332,  328,  370,  319,  202,
 /*  1860 */   332,  332,  331,  318,  332,  328,  172,  319,  208,  332,
 /*  1870 */   332,  114,  332,  332,  332,  177,  332,  208,  332,  332,
 /*  1880 */   114,  345,  332,  332,  331,  318,  214,  328,  196,  332,
 /*  1890 */   332,  319,  332,  331,  318,  319,  328,  332,  332,  189,
 /*  1900 */   332,  208,  332,  169,  114,  208,  332,  332,  114,  332,
 /*  1910 */   332,  332,  332,  332,    8,  332,  332,  331,  318,  332,
 /*  1920 */   328,  331,  318,  112,  328,  319,  332,  332,  332,  332,
 /*  1930 */   332,  332,  332,  179,  319,  208,  332,  332,  114,  332,
 /*  1940 */   332,  332,  176,  332,  208,  332,  332,  114,  332,  332,
 /*  1950 */   332,  331,  318,  332,  328,  332,  319,  332,  332,  332,
 /*  1960 */   331,  318,  332,  328,  167,  319,  208,  332,  332,  114,
 /*  1970 */   332,  332,  332,  164,  332,  208,  332,  332,  114,  332,
 /*  1980 */   332,  332,  331,  318,  332,  328,  332,  332,  332,  332,
 /*  1990 */   332,  331,  318,  332,  328,
    );
    static public $yy_lookahead = array(
 /*     0 */    23,   86,   87,   88,   89,   90,   56,   30,    9,   10,
 /*    10 */    25,   12,   27,   14,   29,   65,   31,   24,   41,   42,
 /*    20 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*    30 */    53,   54,   56,   23,   22,   22,   33,   61,   25,   26,
 /*    40 */    30,   65,  119,   33,  121,   69,   98,   70,   71,   72,
 /*    50 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   30,
 /*    60 */   112,  113,  114,    1,   35,   34,   22,   23,   56,   25,
 /*    70 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    80 */    51,   52,   53,   54,   23,   22,   83,   22,   25,   26,
 /*    90 */    25,   30,   88,   89,   90,   22,   33,   24,   25,   70,
 /*   100 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   110 */    81,   38,   39,   22,   98,   42,   25,   56,   22,   99,
 /*   120 */    24,   25,  102,   23,   22,   23,   65,   25,  112,   56,
 /*   130 */    30,   66,   59,   60,    2,   62,   63,   64,  118,   37,
 /*   140 */    67,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   150 */    50,   51,   52,   53,   54,   82,   22,   66,   26,   25,
 /*   160 */    26,   28,   26,   67,   28,   22,   22,   24,   25,   25,
 /*   170 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   180 */    80,   81,   39,   41,   42,   43,   44,   45,   46,   47,
 /*   190 */    48,   49,   50,   51,   52,   53,   54,  108,   90,   57,
 /*   200 */    66,   65,   24,   25,   96,   62,   63,   23,   22,   23,
 /*   210 */   121,   25,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   220 */    78,   79,   80,   81,    1,   41,   42,   43,   44,   45,
 /*   230 */    46,   47,   48,   49,   50,   51,   52,   53,   54,  108,
 /*   240 */    23,  120,   89,  122,  123,   67,   23,   30,  103,   23,
 /*   250 */    33,   28,  121,   30,   70,   71,   72,   73,   74,   75,
 /*   260 */    76,   77,   78,   79,   80,   81,   37,   41,   42,   43,
 /*   270 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   280 */    54,   98,  129,  130,   22,   56,  103,   25,   93,   94,
 /*   290 */     1,   28,   16,   17,   65,  112,   70,   71,   72,   73,
 /*   300 */    74,   75,   76,   77,   78,   79,   80,   81,   13,   41,
 /*   310 */    42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*   320 */    52,   53,   54,   98,   61,   36,   22,   25,  103,   25,
 /*   330 */   123,   68,  122,  123,  122,  123,   25,  112,   70,   71,
 /*   340 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   350 */     1,   83,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   360 */    48,   49,   50,   51,   52,   53,   54,    1,  108,  105,
 /*   370 */   106,   23,   23,   23,    1,   58,   99,   66,   30,  102,
 /*   380 */    30,  121,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   390 */    78,   79,   80,   81,   30,  118,   40,  113,  114,   91,
 /*   400 */    92,  124,  104,   37,   55,   41,   42,   43,   44,   45,
 /*   410 */    46,   47,   48,   49,   50,   51,   52,   53,   54,   98,
 /*   420 */    61,   55,   32,  104,  103,   69,   25,   68,   55,   23,
 /*   430 */    40,   26,   98,  112,   70,   71,   72,   73,   74,   75,
 /*   440 */    76,   77,   78,   79,   80,   81,  112,   41,   42,   43,
 /*   450 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   460 */    54,   56,  108,   91,   92,   23,   23,   23,   91,   92,
 /*   470 */    65,   23,   30,   30,   30,  121,   70,   71,   72,   73,
 /*   480 */    74,   75,   76,   77,   78,   79,   80,   81,  119,   41,
 /*   490 */    42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*   500 */    52,   53,   54,   23,  108,   23,  119,   23,   23,   57,
 /*   510 */    30,   89,   30,   23,   30,   30,   98,  121,   70,   71,
 /*   520 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   530 */   112,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   540 */    50,   51,   52,   53,   54,   98,   23,   23,  119,   23,
 /*   550 */    23,   30,  130,   30,   30,   23,   30,   30,   25,  112,
 /*   560 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   570 */    80,   81,   39,   41,   42,   43,   44,   45,   46,   47,
 /*   580 */    48,   49,   50,   51,   52,   53,   54,   23,  109,   23,
 /*   590 */    23,  122,  123,  104,   30,   26,   30,   30,   28,   24,
 /*   600 */   121,  104,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   610 */    78,   79,   80,   81,    2,   41,   42,   43,   44,   45,
 /*   620 */    46,   47,   48,   49,   50,   51,   52,   53,   54,    1,
 /*   630 */    61,  117,   93,   94,   24,   65,   93,   94,  124,   24,
 /*   640 */    25,   36,   30,   69,   70,   71,   72,   73,   74,   75,
 /*   650 */    76,   77,   78,   79,   80,   81,   32,   30,   30,   25,
 /*   660 */    25,   93,   94,   23,   56,   41,   42,   43,   44,   45,
 /*   670 */    46,   47,   48,   49,   50,   51,   52,   53,   54,   98,
 /*   680 */    15,   11,   24,   26,  103,   26,   25,   24,   57,   25,
 /*   690 */    61,   69,   67,  112,   70,   71,   72,   73,   74,   75,
 /*   700 */    76,   77,   78,   79,   80,   81,   25,   41,   42,   43,
 /*   710 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   720 */    54,    2,  108,   57,   25,    5,   23,   25,   18,   67,
 /*   730 */    23,   57,   39,    2,   98,  121,   70,   71,   72,   73,
 /*   740 */    74,   75,   76,   77,   78,   79,   80,   81,  112,   23,
 /*   750 */    33,  112,   30,   24,   30,  111,  119,   20,  120,  126,
 /*   760 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   770 */    51,   52,   53,   54,  121,  108,  107,   56,   95,  119,
 /*   780 */     2,   30,  107,  105,  131,  131,  131,  131,  121,   70,
 /*   790 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   800 */    81,    1,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   810 */    49,   50,   51,   52,   53,   54,  108,  131,  131,  131,
 /*   820 */   131,  131,  131,   23,  131,  131,  131,  131,  131,  121,
 /*   830 */    30,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   840 */    79,   80,   81,  131,   98,  131,    8,  131,  131,  108,
 /*   850 */   131,  131,  131,  131,   22,   55,   24,   25,  112,   27,
 /*   860 */    22,   29,  121,   31,   22,   98,   24,   25,  131,   98,
 /*   870 */    38,   39,  126,  131,   42,  131,   38,  131,  131,  112,
 /*   880 */    38,   39,  131,  112,   42,  131,  131,  131,   56,  131,
 /*   890 */     1,   59,   60,  126,   62,   63,   64,  126,   56,   67,
 /*   900 */    68,   59,   60,  131,   62,   63,   64,  131,  131,   67,
 /*   910 */    68,   69,   23,  131,   82,   22,  131,   24,   25,   30,
 /*   920 */    82,   83,   84,  131,   82,   22,  131,   24,   25,  131,
 /*   930 */   131,   38,   39,   22,   23,   42,   25,  131,  131,  131,
 /*   940 */   131,   38,   39,  131,   55,   42,  131,  131,   37,   56,
 /*   950 */   131,  131,   59,   60,  131,   62,   63,   64,   98,   56,
 /*   960 */    67,   68,   59,   60,  131,   62,   63,   64,    8,  131,
 /*   970 */    67,   68,  112,  113,  114,   82,   22,  131,   24,   25,
 /*   980 */   131,  131,   22,  131,  131,   82,   22,  131,   24,   25,
 /*   990 */   131,  131,   38,   39,  131,  131,   42,  131,   38,  131,
 /*  1000 */   131,  131,   38,   39,  131,  131,   42,  131,  131,  131,
 /*  1010 */    56,  131,  131,   59,   60,  131,   62,   63,   64,   98,
 /*  1020 */    56,   67,   68,   59,   60,  131,   62,   63,   64,  131,
 /*  1030 */   131,   67,   68,  112,  113,  114,   82,   22,  131,   24,
 /*  1040 */    25,  131,   82,   83,   84,  131,   82,   22,  131,   24,
 /*  1050 */    25,  131,  131,   38,   39,  131,  131,   42,  131,  131,
 /*  1060 */   131,  131,  131,   38,   39,  131,  131,   42,  131,  131,
 /*  1070 */   131,   56,  131,  131,   59,   60,  131,   62,   63,   64,
 /*  1080 */   131,   56,   67,   68,   59,   60,  131,   62,   63,   64,
 /*  1090 */   131,  131,   67,   68,  131,  131,  131,   82,   22,  131,
 /*  1100 */    24,   25,  131,  131,  131,   98,  131,   82,   22,  131,
 /*  1110 */    24,   25,  131,  131,   38,   39,  131,  131,   42,  112,
 /*  1120 */   113,  114,  131,  131,   38,   39,  131,  131,   42,  131,
 /*  1130 */   131,  131,   56,  131,  131,   59,   60,  131,   62,   63,
 /*  1140 */    64,  131,   56,   67,   68,   59,   60,  131,   62,   63,
 /*  1150 */    64,  131,  131,   67,  131,  131,  131,   89,   82,   22,
 /*  1160 */   131,   24,   25,  131,  131,   97,  131,   99,   82,  131,
 /*  1170 */   102,  131,  131,  131,  131,   38,   39,  131,  110,   42,
 /*  1180 */   131,  131,  131,  115,  116,  131,  118,    3,    4,  131,
 /*  1190 */     6,    7,    8,   56,  131,  131,   59,   60,  131,   62,
 /*  1200 */    63,   64,  131,   19,   67,   89,   22,  131,  131,  131,
 /*  1210 */   131,  131,  131,   97,  131,   99,  100,  131,  102,   82,
 /*  1220 */   131,  131,   38,  131,  131,   89,  110,  131,  131,  131,
 /*  1230 */   131,  115,  116,   97,  118,   99,  100,  101,  102,  131,
 /*  1240 */   131,  131,  131,  127,  128,  131,  110,  131,   89,  131,
 /*  1250 */   131,  115,  116,  131,  118,   89,   97,  131,   99,  100,
 /*  1260 */   101,  102,  131,   97,  131,   99,  131,  131,  102,  110,
 /*  1270 */   131,  131,  131,  131,  115,  116,  110,  118,  131,  131,
 /*  1280 */   131,  115,  116,   89,  118,  131,  131,   89,  131,  131,
 /*  1290 */   131,   97,  131,   99,  100,   97,  102,   99,  100,  101,
 /*  1300 */   102,  131,  131,  131,  110,    4,    5,    6,  110,  115,
 /*  1310 */   116,  131,  118,  115,  116,   89,  118,  131,  131,  125,
 /*  1320 */    19,   20,   21,   97,  131,   99,  100,   89,  102,  131,
 /*  1330 */   131,  131,  131,  131,  131,   97,  110,   99,  100,  131,
 /*  1340 */   102,  115,  116,  131,  118,  131,  131,  131,  110,   89,
 /*  1350 */   131,  125,  131,  115,  116,  131,  118,   97,  131,   99,
 /*  1360 */   100,  131,  102,  125,  131,  131,  131,  131,  131,  131,
 /*  1370 */   110,  131,  131,   89,  131,  115,  116,  131,  118,  131,
 /*  1380 */   131,   97,  131,   99,  100,   89,  102,  131,  128,  131,
 /*  1390 */   131,  131,  131,   97,  110,   99,  100,  101,  102,  115,
 /*  1400 */   116,  131,  118,  131,  131,   89,  110,  131,  131,  125,
 /*  1410 */   131,  115,  116,   97,  118,   99,  100,   89,  102,  131,
 /*  1420 */   131,  105,  131,  131,  131,   97,  110,   99,  100,  101,
 /*  1430 */   102,  115,  116,  131,  118,  131,  131,  131,  110,   89,
 /*  1440 */   131,  131,  131,  115,  116,  131,  118,   97,  131,   99,
 /*  1450 */   100,  131,  102,  131,  131,  131,  131,  131,  131,  131,
 /*  1460 */   110,  131,  131,   89,  131,  115,  116,  131,  118,  131,
 /*  1470 */   131,   97,  131,   99,  100,   89,  102,  131,  131,  131,
 /*  1480 */   131,  131,  131,   97,  110,   99,  100,   89,  102,  115,
 /*  1490 */   116,  131,  118,  131,  131,   97,  110,   99,  100,   89,
 /*  1500 */   102,  115,  116,  131,  118,  131,  131,   97,  110,   99,
 /*  1510 */   100,   89,  102,  115,  116,  131,  118,  131,  131,   97,
 /*  1520 */   110,   99,  100,  131,  102,  115,  116,  131,  118,  131,
 /*  1530 */   131,  131,  110,   89,  131,  131,  131,  115,  116,  131,
 /*  1540 */   118,   97,   89,   99,  100,  131,  102,  131,  131,  131,
 /*  1550 */    97,  131,   99,  100,  110,  102,  131,  131,  131,  115,
 /*  1560 */   116,  131,  118,  110,   89,  131,  131,  131,  115,  116,
 /*  1570 */   131,  118,   97,   89,   99,  100,  131,  102,  131,  131,
 /*  1580 */   131,   97,  131,   99,  100,  110,  102,  131,  131,  131,
 /*  1590 */   115,  116,  131,  118,  110,  131,  131,   89,  131,  115,
 /*  1600 */   116,   89,  118,  131,  131,   97,  131,   99,  100,   97,
 /*  1610 */   102,   99,  100,  131,  102,  131,  131,  131,  110,  131,
 /*  1620 */   131,  131,  110,  115,  116,  131,  118,  115,  116,  131,
 /*  1630 */   118,   89,  131,  131,  131,  131,  131,  131,  131,   97,
 /*  1640 */    89,   99,  100,  131,  102,  131,  131,  131,   97,  131,
 /*  1650 */    99,  100,  110,  102,  131,  131,  131,  115,  116,  131,
 /*  1660 */   118,  110,   89,  131,  131,  131,  115,  116,  131,  118,
 /*  1670 */    97,   89,   99,  100,  131,  102,  131,  131,  131,   97,
 /*  1680 */   131,   99,  100,  110,  102,  131,  131,  131,  115,  116,
 /*  1690 */   131,  118,  110,  131,  131,   89,  131,  115,  116,   89,
 /*  1700 */   118,  131,  131,   97,  131,   99,  100,   97,  102,   99,
 /*  1710 */   100,  131,  102,  131,  131,  131,  110,  131,  131,  131,
 /*  1720 */   110,  115,  116,  131,  118,  115,  116,  131,  118,   89,
 /*  1730 */   131,  131,  131,  131,  131,  131,  131,   97,   89,   99,
 /*  1740 */   100,  131,  102,  131,  131,  131,   97,  131,   99,  100,
 /*  1750 */   110,  102,  131,  131,  131,  115,  116,  131,  118,  110,
 /*  1760 */    89,  131,  131,  131,  115,  116,  131,  118,   97,   89,
 /*  1770 */    99,  100,  131,  102,  131,  131,  131,   97,  131,   99,
 /*  1780 */   100,  110,  102,  131,  131,  131,  115,  116,  131,  118,
 /*  1790 */   110,  131,  131,   89,  131,  115,  116,   89,  118,  131,
 /*  1800 */   131,   97,  131,   99,  100,   97,  102,   99,  100,  131,
 /*  1810 */   102,  131,  131,  131,  110,  131,  131,  131,  110,  115,
 /*  1820 */   116,  131,  118,  115,  116,  131,  118,   89,  131,  131,
 /*  1830 */   131,  131,  131,  131,  131,   97,   89,   99,  100,  131,
 /*  1840 */   102,  131,  131,  131,   97,  131,   99,  100,  110,  102,
 /*  1850 */   131,  131,  131,  115,  116,  131,  118,  110,   89,    1,
 /*  1860 */   131,  131,  115,  116,  131,  118,   97,   89,   99,  131,
 /*  1870 */   131,  102,  131,  131,  131,   97,  131,   99,  131,  131,
 /*  1880 */   102,   23,  131,  131,  115,  116,   28,  118,   30,  131,
 /*  1890 */   131,   89,  131,  115,  116,   89,  118,  131,  131,   97,
 /*  1900 */   131,   99,  131,   97,  102,   99,  131,  131,  102,  131,
 /*  1910 */   131,  131,  131,  131,   56,  131,  131,  115,  116,  131,
 /*  1920 */   118,  115,  116,   65,  118,   89,  131,  131,  131,  131,
 /*  1930 */   131,  131,  131,   97,   89,   99,  131,  131,  102,  131,
 /*  1940 */   131,  131,   97,  131,   99,  131,  131,  102,  131,  131,
 /*  1950 */   131,  115,  116,  131,  118,  131,   89,  131,  131,  131,
 /*  1960 */   115,  116,  131,  118,   97,   89,   99,  131,  131,  102,
 /*  1970 */   131,  131,  131,   97,  131,   99,  131,  131,  102,  131,
 /*  1980 */   131,  131,  115,  116,  131,  118,  131,  131,  131,  131,
 /*  1990 */   131,  115,  116,  131,  118,
);
    const YY_SHIFT_USE_DFLT = -51;
    const YY_SHIFT_MAX = 246;
    static public $yy_shift_ofst = array(
 /*     0 */  1184, 1015,  832,  832,  964, 1025, 1076,  893,  893, 1015,
 /*    10 */   964,  893,  893,  842,  893,  893,  893,  893,  893,  893,
 /*    20 */   893,  893,  893,  893,  893,  893,  893,  893,  893,  893,
 /*    30 */   893,  893,  893,  893,  893,  893,  893,  893,  893,  903,
 /*    40 */   954,   73,   73,   73, 1137,   73,   73,   73, 1086,   29,
 /*    50 */   -23,  100,  364,  364,   96, 1184,  838, 1858,  800,  223,
 /*    60 */   178,  263,  628,  612,  612,  612,  312,  268,  226,  184,
 /*    70 */   142,  406,  624,  574,  448,  490,  532,  666,  719,  761,
 /*    80 */   761,  761,  761,  761,  761,  761,  761,  761,  761,  761,
 /*    90 */   761,  761,  761,  761,  761, 1301,  960,  134,   -1,   -1,
 /*   100 */    63,   -1,  136,   10,  217,   91,  144,  276,  304,  304,
 /*   110 */   304,  304,  615,  304,  570,  276,  276,  304,  304,  276,
 /*   120 */   144,  262,  304,  133,  722,  724,  133,  722,  729,  722,
 /*   130 */   889,  911,  102,  -15,  349,   44,   13,  186,  366,   65,
 /*   140 */   566,  348,  526,  359,  524,  564,  359,  359,  523,  567,
 /*   150 */   373,  444,  443,  350,   12,  289,  485,  482,  527,  359,
 /*   160 */   484,  359,  480,  442,   62,  133,  133,   62,  729,   62,
 /*   170 */   721,  751,   62,  737,  133,  751,   62,   62,  778,   62,
 /*   180 */   133,   62,  -51,  -51,  -51,  -51,  -51,  -51,  -51,  -51,
 /*   190 */   143,  -24,   61,  405,  229,    3,  533,  569,  390,  132,
 /*   200 */   356,  -50,  311,  -50,  -50,  -50,  295,  401,  717,  699,
 /*   210 */   452,  622,  631,  625,  702,  693,  674,  707,  662,  629,
 /*   220 */   663,  635,  634,  521,  610,  640,  608,  661,  657,  665,
 /*   230 */   670,  681,  658,  659,  605,  627,  710,  726,  703,  664,
 /*   240 */   720,  731,  302,   -7,   31,  317,  575,
);
    const YY_REDUCE_USE_DFLT = -86;
    const YY_REDUCE_MAX = 189;
    static public $yy_reduce_ofst = array(
 /*     0 */   -85, 1116, 1136, 1159, 1328, 1296, 1316, 1284, 1194, 1260,
 /*    10 */  1198, 1226, 1238, 1484, 1475, 1508, 1512, 1542, 1453, 1444,
 /*    20 */  1386, 1374, 1398, 1410, 1422, 1551, 1573, 1704, 1738, 1708,
 /*    30 */  1350, 1747, 1680, 1671, 1606, 1582, 1610, 1640, 1649, 1068,
 /*    40 */  1166, 1769, 1876, 1867, 1845, 1806, 1836, 1778, 1802, 1007,
 /*    50 */   921,  -52,  860,  -52,  277,    4,  153,  321,  183,  225,
 /*    60 */    20,  121,  581,  746,  767,  771,  284,  284,  284,  284,
 /*    70 */   284,  284,  284,  284,  284,  284,  284,  284,  284,  284,
 /*    80 */   284,  284,  284,  284,  284,  284,  284,  284,  284,  284,
 /*    90 */   284,  284,  284,  284,  284,  108,  422,  -77,  377,  308,
 /*   100 */   479,  372,  469,  636,  636,  -77,  354,  543,  708,  354,
 /*   110 */   667,  741,  514,  614,  469,  539,  568,   89,  260,  195,
 /*   120 */   131,  354,  396,  212,  447,  334,  210,  418,  264,   16,
 /*   130 */   145,  653,  653,  644,  145,  653,  653,  653,  145,  653,
 /*   140 */   639,  639,  639,  638,  639,  639,  638,  638,  639,  639,
 /*   150 */   145,  639,  639,  639,  637,  145,  639,  639,  639,  638,
 /*   160 */   639,  638,  639,  639,  145,  207,  207,  145,  678,  145,
 /*   170 */   660,  669,  145,  683,  207,  675,  145,  145,  633,  145,
 /*   180 */   207,  145,  497,  429,  489,  387,  369,  298,  319,  145,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 6, 7, 8, 19, 22, 38, ),
        /* 1 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 2 */ array(22, 24, 25, 27, 29, 31, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 3 */ array(22, 24, 25, 27, 29, 31, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 4 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 5 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 6 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 7 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 8 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 9 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 10 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 11 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 12 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 13 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 69, 82, ),
        /* 14 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 15 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 16 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 17 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 18 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 19 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 20 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 21 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 22 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 23 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 24 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 25 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 26 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 27 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 28 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 29 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 30 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 31 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 32 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 33 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 34 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 35 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 36 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 37 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 38 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 39 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 40 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 68, 82, ),
        /* 41 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 42 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 43 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 44 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 45 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 46 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 47 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 48 */ array(22, 24, 25, 38, 39, 42, 56, 59, 60, 62, 63, 64, 67, 82, ),
        /* 49 */ array(30, 35, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 50 */ array(23, 30, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 51 */ array(23, 30, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 52 */ array(30, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 53 */ array(30, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 54 */ array(22, 24, 25, 67, ),
        /* 55 */ array(3, 4, 6, 7, 8, 19, 22, 38, ),
        /* 56 */ array(8, 22, 38, 82, 83, 84, ),
        /* 57 */ array(1, 23, 28, 30, 56, 65, ),
        /* 58 */ array(1, 23, 30, 55, ),
        /* 59 */ array(1, 23, 28, 30, ),
        /* 60 */ array(24, 25, 67, ),
        /* 61 */ array(28, 61, 68, ),
        /* 62 */ array(1, 30, ),
        /* 63 */ array(2, 30, ),
        /* 64 */ array(2, 30, ),
        /* 65 */ array(2, 30, ),
        /* 66 */ array(40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 67 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 83, ),
        /* 68 */ array(23, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 69 */ array(23, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 70 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 57, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 71 */ array(23, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 72 */ array(32, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 73 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 74 */ array(23, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 75 */ array(23, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 76 */ array(23, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 77 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 57, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 78 */ array(2, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 79 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 80 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 81 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 82 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 83 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 84 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 85 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 86 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 87 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 88 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 89 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 90 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 91 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 92 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 93 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 94 */ array(41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, ),
        /* 95 */ array(4, 5, 6, 19, 20, 21, ),
        /* 96 */ array(8, 22, 38, 82, 83, 84, ),
        /* 97 */ array(22, 25, 26, 66, ),
        /* 98 */ array(9, 10, 12, 14, ),
        /* 99 */ array(9, 10, 12, 14, ),
        /* 100 */ array(22, 25, 26, 33, ),
        /* 101 */ array(9, 10, 12, 14, ),
        /* 102 */ array(26, 28, 65, ),
        /* 103 */ array(23, 30, 33, ),
        /* 104 */ array(23, 30, 33, ),
        /* 105 */ array(22, 25, 66, ),
        /* 106 */ array(22, 25, ),
        /* 107 */ array(16, 17, ),
        /* 108 */ array(22, 25, ),
        /* 109 */ array(22, 25, ),
        /* 110 */ array(22, 25, ),
        /* 111 */ array(22, 25, ),
        /* 112 */ array(24, 25, ),
        /* 113 */ array(22, 25, ),
        /* 114 */ array(28, 65, ),
        /* 115 */ array(16, 17, ),
        /* 116 */ array(16, 17, ),
        /* 117 */ array(22, 25, ),
        /* 118 */ array(22, 25, ),
        /* 119 */ array(16, 17, ),
        /* 120 */ array(22, 25, ),
        /* 121 */ array(22, 25, ),
        /* 122 */ array(22, 25, ),
        /* 123 */ array(28, ),
        /* 124 */ array(30, ),
        /* 125 */ array(30, ),
        /* 126 */ array(28, ),
        /* 127 */ array(30, ),
        /* 128 */ array(24, ),
        /* 129 */ array(30, ),
        /* 130 */ array(1, 23, 30, 55, ),
        /* 131 */ array(22, 23, 25, 37, ),
        /* 132 */ array(22, 23, 25, 37, ),
        /* 133 */ array(25, 27, 29, 31, ),
        /* 134 */ array(1, 23, 55, ),
        /* 135 */ array(22, 23, 25, ),
        /* 136 */ array(22, 25, 26, ),
        /* 137 */ array(22, 23, 25, ),
        /* 138 */ array(1, 37, 55, ),
        /* 139 */ array(22, 25, 66, ),
        /* 140 */ array(23, 30, ),
        /* 141 */ array(23, 30, ),
        /* 142 */ array(23, 30, ),
        /* 143 */ array(61, 68, ),
        /* 144 */ array(23, 30, ),
        /* 145 */ array(23, 30, ),
        /* 146 */ array(61, 68, ),
        /* 147 */ array(61, 68, ),
        /* 148 */ array(23, 30, ),
        /* 149 */ array(23, 30, ),
        /* 150 */ array(1, 55, ),
        /* 151 */ array(23, 30, ),
        /* 152 */ array(23, 30, ),
        /* 153 */ array(23, 30, ),
        /* 154 */ array(22, 56, ),
        /* 155 */ array(1, 36, ),
        /* 156 */ array(23, 30, ),
        /* 157 */ array(23, 30, ),
        /* 158 */ array(23, 30, ),
        /* 159 */ array(61, 68, ),
        /* 160 */ array(23, 30, ),
        /* 161 */ array(61, 68, ),
        /* 162 */ array(23, 30, ),
        /* 163 */ array(23, 30, ),
        /* 164 */ array(1, ),
        /* 165 */ array(28, ),
        /* 166 */ array(28, ),
        /* 167 */ array(1, ),
        /* 168 */ array(24, ),
        /* 169 */ array(1, ),
        /* 170 */ array(56, ),
        /* 171 */ array(30, ),
        /* 172 */ array(1, ),
        /* 173 */ array(20, ),
        /* 174 */ array(28, ),
        /* 175 */ array(30, ),
        /* 176 */ array(1, ),
        /* 177 */ array(1, ),
        /* 178 */ array(2, ),
        /* 179 */ array(1, ),
        /* 180 */ array(28, ),
        /* 181 */ array(1, ),
        /* 182 */ array(),
        /* 183 */ array(),
        /* 184 */ array(),
        /* 185 */ array(),
        /* 186 */ array(),
        /* 187 */ array(),
        /* 188 */ array(),
        /* 189 */ array(),
        /* 190 */ array(22, 24, 25, 39, 62, 63, ),
        /* 191 */ array(56, 61, 65, 69, ),
        /* 192 */ array(23, 30, 56, 65, ),
        /* 193 */ array(26, 56, 65, ),
        /* 194 */ array(37, 56, 65, ),
        /* 195 */ array(33, 83, ),
        /* 196 */ array(25, 39, ),
        /* 197 */ array(26, 61, ),
        /* 198 */ array(32, 40, ),
        /* 199 */ array(2, 26, ),
        /* 200 */ array(40, 69, ),
        /* 201 */ array(56, 65, ),
        /* 202 */ array(25, 66, ),
        /* 203 */ array(56, 65, ),
        /* 204 */ array(56, 65, ),
        /* 205 */ array(56, 65, ),
        /* 206 */ array(13, ),
        /* 207 */ array(25, ),
        /* 208 */ array(33, ),
        /* 209 */ array(25, ),
        /* 210 */ array(57, ),
        /* 211 */ array(69, ),
        /* 212 */ array(57, ),
        /* 213 */ array(67, ),
        /* 214 */ array(25, ),
        /* 215 */ array(39, ),
        /* 216 */ array(57, ),
        /* 217 */ array(23, ),
        /* 218 */ array(67, ),
        /* 219 */ array(61, ),
        /* 220 */ array(24, ),
        /* 221 */ array(25, ),
        /* 222 */ array(25, ),
        /* 223 */ array(30, ),
        /* 224 */ array(24, ),
        /* 225 */ array(23, ),
        /* 226 */ array(56, ),
        /* 227 */ array(25, ),
        /* 228 */ array(26, ),
        /* 229 */ array(15, ),
        /* 230 */ array(11, ),
        /* 231 */ array(25, ),
        /* 232 */ array(24, ),
        /* 233 */ array(26, ),
        /* 234 */ array(36, ),
        /* 235 */ array(30, ),
        /* 236 */ array(18, ),
        /* 237 */ array(23, ),
        /* 238 */ array(23, ),
        /* 239 */ array(25, ),
        /* 240 */ array(5, ),
        /* 241 */ array(2, ),
        /* 242 */ array(25, ),
        /* 243 */ array(24, ),
        /* 244 */ array(34, ),
        /* 245 */ array(58, ),
        /* 246 */ array(24, ),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
        /* 383 */ array(),
);
    static public $yy_default = array(
 /*     0 */   583,  566,  583,  583,  583,  583,  583,  537,  537,  583,
 /*    10 */   583,  537,  537,  583,  583,  583,  583,  583,  583,  583,
 /*    20 */   583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
 /*    30 */   583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
 /*    40 */   583,  583,  583,  583,  583,  583,  583,  583,  583,  451,
 /*    50 */   583,  583,  451,  451,  583,  384,  583,  462,  461,  583,
 /*    60 */   583,  545,  451,  451,  451,  451,  536,  583,  583,  583,
 /*    70 */   583,  583,  583,  583,  583,  583,  583,  583,  583,  453,
 /*    80 */   568,  484,  481,  457,  460,  433,  480,  477,  471,  567,
 /*    90 */   472,  473,  476,  468,  569,  583,  583,  508,  395,  395,
 /*   100 */   583,  395,  501,  485,  485,  508,  583,  401,  583,  583,
 /*   110 */   583,  583,  583,  583,  501,  401,  401,  583,  583,  401,
 /*   120 */   583,  583,  583,  540,  451,  451,  541,  451,  583,  451,
 /*   130 */   461,  583,  583,  583,  461,  583,  583,  583,  461,  509,
 /*   140 */   583,  583,  583,  531,  583,  583,  506,  529,  583,  583,
 /*   150 */   461,  583,  583,  583,  508,  583,  583,  583,  583,  530,
 /*   160 */   583,  528,  583,  583,  486,  542,  543,  465,  583,  466,
 /*   170 */   508,  582,  464,  407,  524,  582,  483,  487,  500,  488,
 /*   180 */   546,  470,  548,  508,  548,  508,  508,  548,  548,  549,
 /*   190 */   583,  462,  462,  456,  462,  485,  583,  490,  583,  522,
 /*   200 */   583,  583,  583,  482,  550,  462,  583,  583,  485,  583,
 /*   210 */   583,  583,  583,  583,  583,  583,  583,  583,  583,  490,
 /*   220 */   583,  583,  583,  583,  583,  583,  544,  583,  583,  583,
 /*   230 */   583,  583,  583,  456,  583,  583,  583,  583,  583,  583,
 /*   240 */   583,  522,  583,  583,  458,  495,  583,  445,  455,  398,
 /*   250 */   432,  386,  385,  434,  581,  443,  459,  444,  387,  442,
 /*   260 */   388,  573,  518,  394,  580,  515,  576,  579,  514,  519,
 /*   270 */   523,  532,  511,  512,  513,  397,  574,  390,  402,  436,
 /*   280 */   389,  435,  495,  396,  570,  534,  535,  575,  533,  400,
 /*   290 */   571,  572,  448,  427,  489,  547,  478,  479,  475,  474,
 /*   300 */   491,  469,  539,  538,  450,  447,  556,  557,  558,  559,
 /*   310 */   555,  554,  551,  552,  553,  492,  493,  496,  497,  499,
 /*   320 */   527,  463,  522,  502,  507,  510,  521,  520,  503,  415,
 /*   330 */   577,  494,  416,  498,  517,  504,  505,  516,  560,  561,
 /*   340 */   405,  429,  428,  425,  406,  426,  525,  526,  408,  424,
 /*   350 */   404,  437,  391,  430,  431,  403,  392,  393,  438,  439,
 /*   360 */   440,  423,  422,  565,  564,  578,  417,  563,  441,  562,
 /*   370 */   467,  446,  418,  419,  412,  411,  410,  409,  413,  414,
 /*   380 */   420,  421,  449,  399,
);
    const YYNOCODE = 132;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 384;
    const YYNRULE = 199;
    const YYERRORSYMBOL = 85;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'VERT',          'COLON',         'COMMENT',     
  'PHPSTARTTAG',   'PHPENDTAG',     'FAKEPHPSTARTTAG',  'XMLTAG',      
  'OTHER',         'PHP_CODE',      'PHP_CODE_START_DOUBLEQUOTE',  'PHP_CODE_DOUBLEQUOTE',
  'PHP_HEREDOC_START',  'PHP_HEREDOC_END',  'PHP_NOWDOC_START',  'PHP_NOWDOC_END',
  'PHP_DQ_CONTENT',  'PHP_DQ_EMBED_START',  'PHP_DQ_EMBED_END',  'LITERALSTART',
  'LITERALEND',    'LITERAL',       'LDEL',          'RDEL',        
  'DOLLAR',        'ID',            'EQUAL',         'FOREACH',     
  'PTR',           'IF',            'SPACE',         'FOR',         
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',        
  'AS',            'APTR',          'LDELSLASH',     'INTEGER',     
  'COMMA',         'MATH',          'UNIMATH',       'ANDSYM',      
  'ISIN',          'ISDIVBY',       'ISNOTDIVBY',    'ISEVEN',      
  'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY',   'ISODD',       
  'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',    'INSTANCEOF',  
  'OPENP',         'CLOSEP',        'QMARK',         'NOT',         
  'TYPECAST',      'DOT',           'BOOLEAN',       'NULL',        
  'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',            'HATCH',       
  'OPENB',         'CLOSEB',        'EQUALS',        'NOTEQUALS',   
  'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',   
  'IDENTITY',      'NONEIDENTITY',  'MOD',           'LAND',        
  'LOR',           'LXOR',          'QUOTE',         'BACKTICK',    
  'DOLLARID',      'error',         'start',         'template',    
  'template_element',  'smartytag',     'literal',       'php_code',    
  'php_code_element',  'php_dq_contents',  'php_dq_content',  'literal_elements',
  'literal_element',  'value',         'attributes',    'variable',    
  'expr',          'ternary',       'varindexed',    'modifier',    
  'modparameters',  'statement',     'statements',    'optspace',    
  'varvar',        'foraction',     'array',         'specialclose',
  'attribute',     'ifcond',        'lop',           'function',    
  'doublequoted_with_quotes',  'static_class_access',  'object',        'arrayindex',  
  'indexdef',      'varvarele',     'objectchain',   'objectelement',
  'method',        'params',        'modparameter',  'arrayelements',
  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template_element ::= smartytag",
 /*   4 */ "template_element ::= COMMENT",
 /*   5 */ "template_element ::= literal",
 /*   6 */ "template_element ::= PHPSTARTTAG php_code PHPENDTAG",
 /*   7 */ "template_element ::= FAKEPHPSTARTTAG",
 /*   8 */ "template_element ::= XMLTAG",
 /*   9 */ "template_element ::= OTHER",
 /*  10 */ "php_code ::= php_code_element php_code",
 /*  11 */ "php_code ::=",
 /*  12 */ "php_code_element ::= PHP_CODE",
 /*  13 */ "php_code_element ::= PHP_CODE_START_DOUBLEQUOTE php_dq_contents PHP_CODE_DOUBLEQUOTE",
 /*  14 */ "php_code_element ::= PHP_HEREDOC_START php_dq_contents PHP_HEREDOC_END",
 /*  15 */ "php_code_element ::= PHP_NOWDOC_START php_dq_contents PHP_NOWDOC_END",
 /*  16 */ "php_dq_contents ::= php_dq_content php_dq_contents",
 /*  17 */ "php_dq_contents ::=",
 /*  18 */ "php_dq_content ::= PHP_DQ_CONTENT",
 /*  19 */ "php_dq_content ::= PHP_DQ_EMBED_START php_code PHP_DQ_EMBED_END",
 /*  20 */ "literal ::= LITERALSTART LITERALEND",
 /*  21 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  22 */ "literal_elements ::= literal_elements literal_element",
 /*  23 */ "literal_elements ::=",
 /*  24 */ "literal_element ::= literal",
 /*  25 */ "literal_element ::= LITERAL",
 /*  26 */ "literal_element ::= PHPSTARTTAG",
 /*  27 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  28 */ "literal_element ::= PHPENDTAG",
 /*  29 */ "smartytag ::= LDEL value RDEL",
 /*  30 */ "smartytag ::= LDEL value attributes RDEL",
 /*  31 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  32 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  33 */ "smartytag ::= LDEL ternary attributes RDEL",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  35 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  36 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  37 */ "smartytag ::= LDEL DOLLAR ID EQUAL ternary attributes RDEL",
 /*  38 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  39 */ "smartytag ::= LDEL varindexed EQUAL ternary attributes RDEL",
 /*  40 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  41 */ "smartytag ::= LDEL FOREACH attributes RDEL",
 /*  42 */ "smartytag ::= LDEL ID RDEL",
 /*  43 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  44 */ "smartytag ::= LDEL ID modifier modparameters attributes RDEL",
 /*  45 */ "smartytag ::= LDEL ID PTR ID modifier modparameters attributes RDEL",
 /*  46 */ "smartytag ::= LDEL IF SPACE expr RDEL",
 /*  47 */ "smartytag ::= LDEL IF SPACE statement RDEL",
 /*  48 */ "smartytag ::= LDEL FOR SPACE statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction RDEL",
 /*  49 */ "foraction ::= EQUAL expr",
 /*  50 */ "foraction ::= INCDEC",
 /*  51 */ "smartytag ::= LDEL FOR SPACE statement TO expr attributes RDEL",
 /*  52 */ "smartytag ::= LDEL FOR SPACE statement TO expr STEP expr RDEL",
 /*  53 */ "smartytag ::= LDEL FOREACH SPACE value AS DOLLAR varvar RDEL",
 /*  54 */ "smartytag ::= LDEL FOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  55 */ "smartytag ::= LDEL FOREACH SPACE array AS DOLLAR varvar RDEL",
 /*  56 */ "smartytag ::= LDEL FOREACH SPACE array AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  57 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  58 */ "smartytag ::= LDELSLASH specialclose RDEL",
 /*  59 */ "specialclose ::= IF",
 /*  60 */ "specialclose ::= FOR",
 /*  61 */ "specialclose ::= FOREACH",
 /*  62 */ "smartytag ::= LDELSLASH ID attributes RDEL",
 /*  63 */ "smartytag ::= LDELSLASH ID modifier modparameters attributes RDEL",
 /*  64 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  65 */ "attributes ::= attributes attribute",
 /*  66 */ "attributes ::= attribute",
 /*  67 */ "attributes ::=",
 /*  68 */ "attribute ::= SPACE ID EQUAL ID",
 /*  69 */ "attribute ::= SPACE ID EQUAL expr",
 /*  70 */ "attribute ::= SPACE ID EQUAL value",
 /*  71 */ "attribute ::= SPACE ID EQUAL ternary",
 /*  72 */ "attribute ::= SPACE ID",
 /*  73 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  74 */ "statements ::= statement",
 /*  75 */ "statements ::= statements COMMA statement",
 /*  76 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  77 */ "expr ::= value",
 /*  78 */ "expr ::= ID",
 /*  79 */ "expr ::= DOLLAR ID COLON ID",
 /*  80 */ "expr ::= expr MATH value",
 /*  81 */ "expr ::= expr UNIMATH value",
 /*  82 */ "expr ::= expr ANDSYM value",
 /*  83 */ "expr ::= array",
 /*  84 */ "expr ::= expr ifcond expr",
 /*  85 */ "expr ::= expr ISIN array",
 /*  86 */ "expr ::= expr ISIN value",
 /*  87 */ "expr ::= expr lop expr",
 /*  88 */ "expr ::= expr ISDIVBY expr",
 /*  89 */ "expr ::= expr ISNOTDIVBY expr",
 /*  90 */ "expr ::= expr ISEVEN",
 /*  91 */ "expr ::= expr ISNOTEVEN",
 /*  92 */ "expr ::= expr ISEVENBY expr",
 /*  93 */ "expr ::= expr ISNOTEVENBY expr",
 /*  94 */ "expr ::= expr ISODD",
 /*  95 */ "expr ::= expr ISNOTODD",
 /*  96 */ "expr ::= expr ISODDBY expr",
 /*  97 */ "expr ::= expr ISNOTODDBY expr",
 /*  98 */ "expr ::= value INSTANCEOF ID",
 /*  99 */ "expr ::= value INSTANCEOF value",
 /* 100 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 101 */ "value ::= variable",
 /* 102 */ "value ::= UNIMATH value",
 /* 103 */ "value ::= NOT value",
 /* 104 */ "value ::= TYPECAST value",
 /* 105 */ "value ::= variable INCDEC",
 /* 106 */ "value ::= INTEGER",
 /* 107 */ "value ::= INTEGER DOT INTEGER",
 /* 108 */ "value ::= BOOLEAN",
 /* 109 */ "value ::= NULL",
 /* 110 */ "value ::= function",
 /* 111 */ "value ::= OPENP expr CLOSEP",
 /* 112 */ "value ::= SINGLEQUOTESTRING",
 /* 113 */ "value ::= doublequoted_with_quotes",
 /* 114 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 115 */ "value ::= smartytag",
 /* 116 */ "value ::= value modifier modparameters",
 /* 117 */ "variable ::= varindexed",
 /* 118 */ "variable ::= DOLLAR varvar AT ID",
 /* 119 */ "variable ::= object",
 /* 120 */ "variable ::= HATCH ID HATCH",
 /* 121 */ "variable ::= HATCH variable HATCH",
 /* 122 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 123 */ "arrayindex ::= arrayindex indexdef",
 /* 124 */ "arrayindex ::=",
 /* 125 */ "indexdef ::= DOT DOLLAR varvar",
 /* 126 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 127 */ "indexdef ::= DOT ID",
 /* 128 */ "indexdef ::= DOT BOOLEAN",
 /* 129 */ "indexdef ::= DOT NULL",
 /* 130 */ "indexdef ::= DOT INTEGER",
 /* 131 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 132 */ "indexdef ::= OPENB ID CLOSEB",
 /* 133 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 134 */ "indexdef ::= OPENB expr CLOSEB",
 /* 135 */ "indexdef ::= OPENB CLOSEB",
 /* 136 */ "varvar ::= varvarele",
 /* 137 */ "varvar ::= varvar varvarele",
 /* 138 */ "varvarele ::= ID",
 /* 139 */ "varvarele ::= LDEL expr RDEL",
 /* 140 */ "object ::= varindexed objectchain",
 /* 141 */ "object ::= varindexed DOUBLECOLON ID",
 /* 142 */ "objectchain ::= objectelement",
 /* 143 */ "objectchain ::= objectchain objectelement",
 /* 144 */ "objectelement ::= PTR ID arrayindex",
 /* 145 */ "objectelement ::= PTR variable arrayindex",
 /* 146 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 147 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 148 */ "objectelement ::= PTR method",
 /* 149 */ "function ::= ID OPENP params CLOSEP",
 /* 150 */ "method ::= ID OPENP params CLOSEP",
 /* 151 */ "params ::= expr COMMA params",
 /* 152 */ "params ::= expr",
 /* 153 */ "params ::=",
 /* 154 */ "modifier ::= VERT AT ID",
 /* 155 */ "modifier ::= VERT ID",
 /* 156 */ "static_class_access ::= method",
 /* 157 */ "static_class_access ::= DOLLAR ID OPENP params CLOSEP",
 /* 158 */ "static_class_access ::= method objectchain",
 /* 159 */ "static_class_access ::= DOLLAR ID OPENP params CLOSEP objectchain",
 /* 160 */ "static_class_access ::= ID",
 /* 161 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 162 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 163 */ "modparameters ::= modparameters modparameter",
 /* 164 */ "modparameters ::=",
 /* 165 */ "modparameter ::= COLON value",
 /* 166 */ "modparameter ::= COLON ID",
 /* 167 */ "ifcond ::= EQUALS",
 /* 168 */ "ifcond ::= NOTEQUALS",
 /* 169 */ "ifcond ::= GREATERTHAN",
 /* 170 */ "ifcond ::= LESSTHAN",
 /* 171 */ "ifcond ::= GREATEREQUAL",
 /* 172 */ "ifcond ::= LESSEQUAL",
 /* 173 */ "ifcond ::= IDENTITY",
 /* 174 */ "ifcond ::= NONEIDENTITY",
 /* 175 */ "ifcond ::= MOD",
 /* 176 */ "lop ::= LAND",
 /* 177 */ "lop ::= LOR",
 /* 178 */ "lop ::= LXOR",
 /* 179 */ "array ::= OPENB arrayelements CLOSEB",
 /* 180 */ "arrayelements ::= arrayelement",
 /* 181 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 182 */ "arrayelements ::=",
 /* 183 */ "arrayelement ::= value APTR expr",
 /* 184 */ "arrayelement ::= ID APTR expr",
 /* 185 */ "arrayelement ::= expr",
 /* 186 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 187 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 188 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 189 */ "doublequoted ::= doublequotedcontent",
 /* 190 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 191 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 192 */ "doublequotedcontent ::= DOLLARID",
 /* 193 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 194 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 195 */ "doublequotedcontent ::= smartytag",
 /* 196 */ "doublequotedcontent ::= OTHER",
 /* 197 */ "optspace ::= SPACE",
 /* 198 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 0 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 0 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 0 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 7 ),
  array( 'lhs' => 89, 'rhs' => 7 ),
  array( 'lhs' => 89, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 8 ),
  array( 'lhs' => 89, 'rhs' => 5 ),
  array( 'lhs' => 89, 'rhs' => 5 ),
  array( 'lhs' => 89, 'rhs' => 13 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 8 ),
  array( 'lhs' => 89, 'rhs' => 9 ),
  array( 'lhs' => 89, 'rhs' => 8 ),
  array( 'lhs' => 89, 'rhs' => 11 ),
  array( 'lhs' => 89, 'rhs' => 8 ),
  array( 'lhs' => 89, 'rhs' => 11 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 111, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 6 ),
  array( 'lhs' => 89, 'rhs' => 5 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 0 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 112, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 4 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 7 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 4 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 2 ),
  array( 'lhs' => 119, 'rhs' => 0 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 5 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 4 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 5 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 2 ),
  array( 'lhs' => 123, 'rhs' => 3 ),
  array( 'lhs' => 123, 'rhs' => 3 ),
  array( 'lhs' => 123, 'rhs' => 5 ),
  array( 'lhs' => 123, 'rhs' => 6 ),
  array( 'lhs' => 123, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 4 ),
  array( 'lhs' => 124, 'rhs' => 4 ),
  array( 'lhs' => 125, 'rhs' => 3 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 0 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 117, 'rhs' => 5 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 6 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 4 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 0 ),
  array( 'lhs' => 126, 'rhs' => 2 ),
  array( 'lhs' => 126, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 127, 'rhs' => 1 ),
  array( 'lhs' => 127, 'rhs' => 3 ),
  array( 'lhs' => 127, 'rhs' => 0 ),
  array( 'lhs' => 128, 'rhs' => 3 ),
  array( 'lhs' => 128, 'rhs' => 3 ),
  array( 'lhs' => 128, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 2 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 129, 'rhs' => 2 ),
  array( 'lhs' => 129, 'rhs' => 1 ),
  array( 'lhs' => 130, 'rhs' => 3 ),
  array( 'lhs' => 130, 'rhs' => 3 ),
  array( 'lhs' => 130, 'rhs' => 1 ),
  array( 'lhs' => 130, 'rhs' => 3 ),
  array( 'lhs' => 130, 'rhs' => 3 ),
  array( 'lhs' => 130, 'rhs' => 1 ),
  array( 'lhs' => 130, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        5 => 0,
        12 => 0,
        18 => 0,
        24 => 0,
        25 => 0,
        59 => 0,
        60 => 0,
        61 => 0,
        77 => 0,
        101 => 0,
        106 => 0,
        108 => 0,
        109 => 0,
        110 => 0,
        112 => 0,
        113 => 0,
        119 => 0,
        156 => 0,
        180 => 0,
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        16 => 10,
        22 => 10,
        102 => 10,
        104 => 10,
        105 => 10,
        158 => 10,
        11 => 11,
        17 => 11,
        20 => 11,
        23 => 11,
        13 => 13,
        14 => 13,
        15 => 13,
        19 => 13,
        21 => 21,
        26 => 26,
        27 => 26,
        28 => 28,
        29 => 29,
        30 => 30,
        31 => 30,
        32 => 30,
        33 => 30,
        34 => 34,
        35 => 34,
        36 => 36,
        37 => 36,
        38 => 38,
        39 => 38,
        40 => 40,
        41 => 40,
        42 => 42,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 46,
        48 => 48,
        49 => 49,
        50 => 50,
        66 => 50,
        152 => 50,
        160 => 50,
        185 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 57,
        62 => 62,
        63 => 63,
        64 => 64,
        65 => 65,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 69,
        71 => 69,
        73 => 69,
        72 => 72,
        74 => 74,
        75 => 75,
        76 => 76,
        78 => 78,
        79 => 79,
        80 => 80,
        81 => 80,
        82 => 80,
        83 => 83,
        136 => 83,
        197 => 83,
        84 => 84,
        87 => 84,
        98 => 84,
        85 => 85,
        86 => 86,
        88 => 88,
        89 => 89,
        90 => 90,
        95 => 90,
        91 => 91,
        94 => 91,
        92 => 92,
        97 => 92,
        93 => 93,
        96 => 93,
        99 => 99,
        100 => 100,
        103 => 103,
        107 => 107,
        111 => 111,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        118 => 118,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        164 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 127,
        129 => 127,
        130 => 130,
        131 => 131,
        134 => 131,
        132 => 132,
        133 => 133,
        135 => 135,
        198 => 135,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        153 => 153,
        154 => 154,
        155 => 154,
        157 => 157,
        159 => 159,
        161 => 161,
        162 => 162,
        163 => 163,
        165 => 165,
        166 => 166,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        181 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        186 => 186,
        187 => 187,
        188 => 188,
        189 => 189,
        190 => 190,
        191 => 190,
        193 => 190,
        192 => 192,
        194 => 194,
        195 => 195,
        196 => 196,
    );
#line 84 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2048 "smarty_internal_templateparser.php"
#line 90 "smarty_internal_templateparser.y"
    function yy_r1(){if ($this->template->extract_code == false) {
                                                  $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
                                               } else {
                                                 // store code in extract buffer
                                                  $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                               } 
                                                 }
#line 2057 "smarty_internal_templateparser.php"
#line 98 "smarty_internal_templateparser.y"
    function yy_r2(){if ($this->template->extract_code == false) {
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                           } else {
                                                             // store code in extract buffer
                                                             $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
                                                           } 
                                                              }
#line 2067 "smarty_internal_templateparser.php"
#line 111 "smarty_internal_templateparser.y"
    function yy_r3(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true);
                                         } else { 
                                           $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
                                         }  
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 2079 "smarty_internal_templateparser.php"
#line 123 "smarty_internal_templateparser.y"
    function yy_r4(){ $this->_retvalue = '';    }
#line 2082 "smarty_internal_templateparser.php"
#line 129 "smarty_internal_templateparser.y"
    function yy_r6(){
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + -2]->minor) . str_replace('<?','&lt;?',$this->yystack[$this->yyidx + -1]->minor) . '?<??>>';
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->compiler->processNocacheCode(htmlspecialchars($this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'?>', ENT_QUOTES), false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->compiler->processNocacheCode('<?php'.$this->yystack[$this->yyidx + -1]->minor.'?>', true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2095 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r7(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 2103 "smarty_internal_templateparser.php"
#line 149 "smarty_internal_templateparser.y"
    function yy_r8(){ $this->compiler->tag_nocache = true; $this->_retvalue = $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true);    }
#line 2106 "smarty_internal_templateparser.php"
#line 152 "smarty_internal_templateparser.y"
    function yy_r9(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor);	
                                     } else {
                                       $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;	
                                     }
                                        }
#line 2114 "smarty_internal_templateparser.php"
#line 160 "smarty_internal_templateparser.y"
    function yy_r10(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2117 "smarty_internal_templateparser.php"
#line 161 "smarty_internal_templateparser.y"
    function yy_r11(){ $this->_retvalue = '';     }
#line 2120 "smarty_internal_templateparser.php"
#line 164 "smarty_internal_templateparser.y"
    function yy_r13(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2123 "smarty_internal_templateparser.php"
#line 177 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2126 "smarty_internal_templateparser.php"
#line 184 "smarty_internal_templateparser.y"
    function yy_r26(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2129 "smarty_internal_templateparser.php"
#line 186 "smarty_internal_templateparser.y"
    function yy_r28(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2132 "smarty_internal_templateparser.php"
#line 194 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2135 "smarty_internal_templateparser.php"
#line 195 "smarty_internal_templateparser.y"
    function yy_r30(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2138 "smarty_internal_templateparser.php"
#line 206 "smarty_internal_templateparser.y"
    function yy_r34(){ $this->_retvalue = $this->compiler->compileTag('assign',array('value'=>$this->yystack[$this->yyidx + -1]->minor,'var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'"));    }
#line 2141 "smarty_internal_templateparser.php"
#line 208 "smarty_internal_templateparser.y"
    function yy_r36(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor,'var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'"),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2144 "smarty_internal_templateparser.php"
#line 210 "smarty_internal_templateparser.y"
    function yy_r38(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor));    }
#line 2147 "smarty_internal_templateparser.php"
#line 213 "smarty_internal_templateparser.y"
    function yy_r40(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2150 "smarty_internal_templateparser.php"
#line 215 "smarty_internal_templateparser.y"
    function yy_r42(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2153 "smarty_internal_templateparser.php"
#line 217 "smarty_internal_templateparser.y"
    function yy_r43(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2156 "smarty_internal_templateparser.php"
#line 219 "smarty_internal_templateparser.y"
    function yy_r44(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                     }
#line 2161 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r45(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -4]->minor),$this->yystack[$this->yyidx + -1]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                                }
#line 2166 "smarty_internal_templateparser.php"
#line 227 "smarty_internal_templateparser.y"
    function yy_r46(){ $this->_retvalue = $this->compiler->compileTag(($this->yystack[$this->yyidx + -3]->minor == 'else if')? 'elseif' : $this->yystack[$this->yyidx + -3]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2169 "smarty_internal_templateparser.php"
#line 230 "smarty_internal_templateparser.y"
    function yy_r48(){
                                                             $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -11]->minor,array('start'=>$this->yystack[$this->yyidx + -9]->minor,'ifexp'=>$this->yystack[$this->yyidx + -6]->minor,'varloop'=>$this->yystack[$this->yyidx + -2]->minor,'loop'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2173 "smarty_internal_templateparser.php"
#line 233 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2176 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r50(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2179 "smarty_internal_templateparser.php"
#line 235 "smarty_internal_templateparser.y"
    function yy_r51(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('start'=>$this->yystack[$this->yyidx + -4]->minor,'to'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2182 "smarty_internal_templateparser.php"
#line 236 "smarty_internal_templateparser.y"
    function yy_r52(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -7]->minor,array('start'=>$this->yystack[$this->yyidx + -5]->minor,'to'=>$this->yystack[$this->yyidx + -3]->minor,'step'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2185 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r53(){
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2189 "smarty_internal_templateparser.php"
#line 240 "smarty_internal_templateparser.y"
    function yy_r54(){
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2193 "smarty_internal_templateparser.php"
#line 242 "smarty_internal_templateparser.y"
    function yy_r55(){ 
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2197 "smarty_internal_templateparser.php"
#line 244 "smarty_internal_templateparser.y"
    function yy_r56(){ 
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2201 "smarty_internal_templateparser.php"
#line 248 "smarty_internal_templateparser.y"
    function yy_r57(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2204 "smarty_internal_templateparser.php"
#line 253 "smarty_internal_templateparser.y"
    function yy_r62(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2207 "smarty_internal_templateparser.php"
#line 254 "smarty_internal_templateparser.y"
    function yy_r63(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                         $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                          }
#line 2212 "smarty_internal_templateparser.php"
#line 258 "smarty_internal_templateparser.y"
    function yy_r64(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2215 "smarty_internal_templateparser.php"
#line 265 "smarty_internal_templateparser.y"
    function yy_r65(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2218 "smarty_internal_templateparser.php"
#line 269 "smarty_internal_templateparser.y"
    function yy_r67(){ $this->_retvalue = array();    }
#line 2221 "smarty_internal_templateparser.php"
#line 272 "smarty_internal_templateparser.y"
    function yy_r68(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2224 "smarty_internal_templateparser.php"
#line 273 "smarty_internal_templateparser.y"
    function yy_r69(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2227 "smarty_internal_templateparser.php"
#line 276 "smarty_internal_templateparser.y"
    function yy_r72(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor=>'true');    }
#line 2230 "smarty_internal_templateparser.php"
#line 283 "smarty_internal_templateparser.y"
    function yy_r74(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2233 "smarty_internal_templateparser.php"
#line 284 "smarty_internal_templateparser.y"
    function yy_r75(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2236 "smarty_internal_templateparser.php"
#line 286 "smarty_internal_templateparser.y"
    function yy_r76(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2239 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r78(){ $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2242 "smarty_internal_templateparser.php"
#line 296 "smarty_internal_templateparser.y"
    function yy_r79(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2245 "smarty_internal_templateparser.php"
#line 298 "smarty_internal_templateparser.y"
    function yy_r80(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2248 "smarty_internal_templateparser.php"
#line 304 "smarty_internal_templateparser.y"
    function yy_r83(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2251 "smarty_internal_templateparser.php"
#line 308 "smarty_internal_templateparser.y"
    function yy_r84(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2254 "smarty_internal_templateparser.php"
#line 309 "smarty_internal_templateparser.y"
    function yy_r85(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2257 "smarty_internal_templateparser.php"
#line 310 "smarty_internal_templateparser.y"
    function yy_r86(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2260 "smarty_internal_templateparser.php"
#line 312 "smarty_internal_templateparser.y"
    function yy_r88(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2263 "smarty_internal_templateparser.php"
#line 313 "smarty_internal_templateparser.y"
    function yy_r89(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2266 "smarty_internal_templateparser.php"
#line 314 "smarty_internal_templateparser.y"
    function yy_r90(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2269 "smarty_internal_templateparser.php"
#line 315 "smarty_internal_templateparser.y"
    function yy_r91(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2272 "smarty_internal_templateparser.php"
#line 316 "smarty_internal_templateparser.y"
    function yy_r92(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2275 "smarty_internal_templateparser.php"
#line 317 "smarty_internal_templateparser.y"
    function yy_r93(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2278 "smarty_internal_templateparser.php"
#line 323 "smarty_internal_templateparser.y"
    function yy_r99(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2281 "smarty_internal_templateparser.php"
#line 329 "smarty_internal_templateparser.y"
    function yy_r100(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2284 "smarty_internal_templateparser.php"
#line 336 "smarty_internal_templateparser.y"
    function yy_r103(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2287 "smarty_internal_templateparser.php"
#line 341 "smarty_internal_templateparser.y"
    function yy_r107(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2290 "smarty_internal_templateparser.php"
#line 351 "smarty_internal_templateparser.y"
    function yy_r111(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2293 "smarty_internal_templateparser.php"
#line 357 "smarty_internal_templateparser.y"
    function yy_r114(){if (!$this->template->security || $this->smarty->security_handler->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor; 
                                                                }    }
#line 2298 "smarty_internal_templateparser.php"
#line 361 "smarty_internal_templateparser.y"
    function yy_r115(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2301 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r116(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -1]->minor,'params'=>$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor));     }
#line 2304 "smarty_internal_templateparser.php"
#line 372 "smarty_internal_templateparser.y"
    function yy_r117(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2308 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r118(){ $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2311 "smarty_internal_templateparser.php"
#line 379 "smarty_internal_templateparser.y"
    function yy_r120(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2314 "smarty_internal_templateparser.php"
#line 380 "smarty_internal_templateparser.y"
    function yy_r121(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2317 "smarty_internal_templateparser.php"
#line 383 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2320 "smarty_internal_templateparser.php"
#line 389 "smarty_internal_templateparser.y"
    function yy_r123(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2323 "smarty_internal_templateparser.php"
#line 391 "smarty_internal_templateparser.y"
    function yy_r124(){return;    }
#line 2326 "smarty_internal_templateparser.php"
#line 395 "smarty_internal_templateparser.y"
    function yy_r125(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2329 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r126(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2332 "smarty_internal_templateparser.php"
#line 397 "smarty_internal_templateparser.y"
    function yy_r127(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2335 "smarty_internal_templateparser.php"
#line 401 "smarty_internal_templateparser.y"
    function yy_r130(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2338 "smarty_internal_templateparser.php"
#line 402 "smarty_internal_templateparser.y"
    function yy_r131(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2341 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r132(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2344 "smarty_internal_templateparser.php"
#line 405 "smarty_internal_templateparser.y"
    function yy_r133(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2347 "smarty_internal_templateparser.php"
#line 409 "smarty_internal_templateparser.y"
    function yy_r135(){$this->_retvalue = '';    }
#line 2350 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r137(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2353 "smarty_internal_templateparser.php"
#line 419 "smarty_internal_templateparser.y"
    function yy_r138(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2356 "smarty_internal_templateparser.php"
#line 422 "smarty_internal_templateparser.y"
    function yy_r139(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2359 "smarty_internal_templateparser.php"
#line 427 "smarty_internal_templateparser.y"
    function yy_r140(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2363 "smarty_internal_templateparser.php"
#line 429 "smarty_internal_templateparser.y"
    function yy_r141(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2367 "smarty_internal_templateparser.php"
#line 432 "smarty_internal_templateparser.y"
    function yy_r142(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2370 "smarty_internal_templateparser.php"
#line 434 "smarty_internal_templateparser.y"
    function yy_r143(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2373 "smarty_internal_templateparser.php"
#line 436 "smarty_internal_templateparser.y"
    function yy_r144(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2376 "smarty_internal_templateparser.php"
#line 437 "smarty_internal_templateparser.y"
    function yy_r145(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2379 "smarty_internal_templateparser.php"
#line 438 "smarty_internal_templateparser.y"
    function yy_r146(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2382 "smarty_internal_templateparser.php"
#line 439 "smarty_internal_templateparser.y"
    function yy_r147(){ $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2385 "smarty_internal_templateparser.php"
#line 441 "smarty_internal_templateparser.y"
    function yy_r148(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2388 "smarty_internal_templateparser.php"
#line 447 "smarty_internal_templateparser.y"
    function yy_r149(){if (!$this->template->security || $this->smarty->security_handler->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if ($this->yystack[$this->yyidx + -3]->minor == 'isset' || $this->yystack[$this->yyidx + -3]->minor == 'empty' || $this->yystack[$this->yyidx + -3]->minor == 'array' || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2397 "smarty_internal_templateparser.php"
#line 458 "smarty_internal_templateparser.y"
    function yy_r150(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";    }
#line 2400 "smarty_internal_templateparser.php"
#line 462 "smarty_internal_templateparser.y"
    function yy_r151(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2403 "smarty_internal_templateparser.php"
#line 466 "smarty_internal_templateparser.y"
    function yy_r153(){ return;    }
#line 2406 "smarty_internal_templateparser.php"
#line 471 "smarty_internal_templateparser.y"
    function yy_r154(){ $this->_retvalue =  $this->yystack[$this->yyidx + 0]->minor;    }
#line 2409 "smarty_internal_templateparser.php"
#line 476 "smarty_internal_templateparser.y"
    function yy_r157(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';     }
#line 2412 "smarty_internal_templateparser.php"
#line 479 "smarty_internal_templateparser.y"
    function yy_r159(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -4]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -2]->minor .')'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2415 "smarty_internal_templateparser.php"
#line 483 "smarty_internal_templateparser.y"
    function yy_r161(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2418 "smarty_internal_templateparser.php"
#line 485 "smarty_internal_templateparser.y"
    function yy_r162(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2421 "smarty_internal_templateparser.php"
#line 496 "smarty_internal_templateparser.y"
    function yy_r163(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2424 "smarty_internal_templateparser.php"
#line 500 "smarty_internal_templateparser.y"
    function yy_r165(){$this->_retvalue = ','.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2427 "smarty_internal_templateparser.php"
#line 501 "smarty_internal_templateparser.y"
    function yy_r166(){$this->_retvalue = ',\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2430 "smarty_internal_templateparser.php"
#line 504 "smarty_internal_templateparser.y"
    function yy_r167(){$this->_retvalue = '==';    }
#line 2433 "smarty_internal_templateparser.php"
#line 505 "smarty_internal_templateparser.y"
    function yy_r168(){$this->_retvalue = '!=';    }
#line 2436 "smarty_internal_templateparser.php"
#line 506 "smarty_internal_templateparser.y"
    function yy_r169(){$this->_retvalue = '>';    }
#line 2439 "smarty_internal_templateparser.php"
#line 507 "smarty_internal_templateparser.y"
    function yy_r170(){$this->_retvalue = '<';    }
#line 2442 "smarty_internal_templateparser.php"
#line 508 "smarty_internal_templateparser.y"
    function yy_r171(){$this->_retvalue = '>=';    }
#line 2445 "smarty_internal_templateparser.php"
#line 509 "smarty_internal_templateparser.y"
    function yy_r172(){$this->_retvalue = '<=';    }
#line 2448 "smarty_internal_templateparser.php"
#line 510 "smarty_internal_templateparser.y"
    function yy_r173(){$this->_retvalue = '===';    }
#line 2451 "smarty_internal_templateparser.php"
#line 511 "smarty_internal_templateparser.y"
    function yy_r174(){$this->_retvalue = '!==';    }
#line 2454 "smarty_internal_templateparser.php"
#line 512 "smarty_internal_templateparser.y"
    function yy_r175(){$this->_retvalue = '%';    }
#line 2457 "smarty_internal_templateparser.php"
#line 514 "smarty_internal_templateparser.y"
    function yy_r176(){$this->_retvalue = '&&';    }
#line 2460 "smarty_internal_templateparser.php"
#line 515 "smarty_internal_templateparser.y"
    function yy_r177(){$this->_retvalue = '||';    }
#line 2463 "smarty_internal_templateparser.php"
#line 516 "smarty_internal_templateparser.y"
    function yy_r178(){$this->_retvalue = ' XOR ';    }
#line 2466 "smarty_internal_templateparser.php"
#line 521 "smarty_internal_templateparser.y"
    function yy_r179(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2469 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2472 "smarty_internal_templateparser.php"
#line 524 "smarty_internal_templateparser.y"
    function yy_r182(){ return;     }
#line 2475 "smarty_internal_templateparser.php"
#line 525 "smarty_internal_templateparser.y"
    function yy_r183(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2478 "smarty_internal_templateparser.php"
#line 526 "smarty_internal_templateparser.y"
    function yy_r184(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2481 "smarty_internal_templateparser.php"
#line 533 "smarty_internal_templateparser.y"
    function yy_r186(){ $this->_retvalue = "''";     }
#line 2484 "smarty_internal_templateparser.php"
#line 534 "smarty_internal_templateparser.y"
    function yy_r187(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2487 "smarty_internal_templateparser.php"
#line 536 "smarty_internal_templateparser.y"
    function yy_r188(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2490 "smarty_internal_templateparser.php"
#line 537 "smarty_internal_templateparser.y"
    function yy_r189(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2493 "smarty_internal_templateparser.php"
#line 539 "smarty_internal_templateparser.y"
    function yy_r190(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2496 "smarty_internal_templateparser.php"
#line 541 "smarty_internal_templateparser.y"
    function yy_r192(){
   $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
   $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2502 "smarty_internal_templateparser.php"
#line 546 "smarty_internal_templateparser.y"
    function yy_r194(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2505 "smarty_internal_templateparser.php"
#line 547 "smarty_internal_templateparser.y"
    function yy_r195(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2510 "smarty_internal_templateparser.php"
#line 550 "smarty_internal_templateparser.y"
    function yy_r196(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2513 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 72 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2576 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 64 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2594 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>