<?php
///////////////////////////////////////////////////////////////////////////////////////
// PHPizabi 0.848b C1 [ALICIA]                               http://www.phpizabi.net //
///////////////////////////////////////////////////////////////////////////////////////
// Please read the license.txt file before using / modifying this software           //
// Original author:         Claude Desjardins, R - feedback@realitymedias.com        //
// Last modification date:  August 13th 2006                                         //
// Version:                 PHPizabi 0.848b C1                                       //
//                                                                                   //
// (C) 2005, 2006 Real!ty Medias / PHPizabi - All rights reserved                    //
///////////////////////////////////////////////////////////////////////////////////////

	/* Check Structure Availability */
	if (!defined("CORE_STRAP")) die("Out of structure call");
	/* Administrative restriction */
	(!me('is_administrator')&&!me('is_superadministrator')?die("Access restricted"):NULL);

	$tpl = new template;
	$tpl -> Load("read");
	
	// PAGINATION PREPARATION /////////////////////////////////////////////////////
	if (!isset($_GET["page"]) || !is_numeric($_GET["page"]) || $_GET["page"] == 0) $page = 1;
	else $page = $_GET["page"];
	
	// READ THE LOG FILE //////////////////////////////////////////////////////////
	if ($handle = fopen("system/cache/logs/{$_GET["id"]}.log", "r")) {
		
		$lineSize=0;
		$n=0;
		$i=(($page * 100) - 100);
		$lastRow = $i + 100;
		
		while (!feof($handle) && $i < $lastRow) {
			$logData = fgets($handle, 4096);
			
			/* Keep Stats of 5 Log Lines */
			if ($n <= 5) $lineSize += strlen($logData);
			
			/* Parse the log */
			if ($n >= $i) {
				
				@list ($userId, $username, $ip, $port, $refer, $userAgent, $getL, $date) = @explode("||", $logData);

				$logEntry[] = array(
					"log.id" => $i,
					"log.userid" => $userId,
					"log.username" => $username,
					"log.ip" => $ip,
					"log.l" => $getL,
					"log.date" => date($CONF["LOCALE_SHORT_TIME"], $date)
				);
				$i++;
			}
			$n++;
		}
		if (!feof($handle)) $nextPage = true;
		fclose($handle);
	}
	
	$tpl -> Loop("logRows", $logEntry);
	
	
	// PAGINATION ////////////////////////////////////////////////////////////////
	if (ckBool($nextPage)) {
		$tpl -> Zone("nextPage", "enabled");
		$tpl -> AssignArray(array(
			"next.page" => $page + 1,
			"next.id" => $_GET["id"],
		));
	}

	if ($page > 1) {
		$tpl -> Zone("prevPage", "enabled");
		$tpl -> AssignArray(array(
			"prev.page" => $page - 1,
			"prev.id" => $_GET["id"],
		));
	}

	
	// ASSIGN STATS ///////////////////////////////////////////////////////////////
	$tpl -> AssignArray(array(
		"log.date" => date($CONF["LOCALE_LONG_DATE"], $_GET["id"]),
		"log.size" => round(filesize("system/cache/logs/{$_GET["id"]}.log")/1048576, 2),
		"log.hits" => number_format(round(filesize("system/cache/logs/{$_GET["id"]}.log") / ($lineSize / 5)), 0, ",", " "),
	));
		

	// TEMPLATE REPROCESS & FLUSH ////////////////////////////////////////////////////
	$tpl -> CleanZones();

	/* Get the frame templates, flush the TPL result into it */
	$frame = new template;
	$frame -> Load("!theme/{$GLOBALS["THEME"]}/templates/admin/frame.tpl");
	$frame -> AssignArray(array(
		"jump" => $tpl->Flush(1)
	));
	
	/* Assign Location Value */
	$locationArray = explode(".", $_GET["L"]);
	for ($i=0; $i<count($locationArray); $i++) {
		$locationAppendResult[] = $locationArray[$i];
		if ($i > 0) $location[] = "<a href=\"?L=".implode(".", $locationAppendResult)."\">{$locationArray[$i]}</a>";
	}
	$frame -> AssignArray(array("location" => implode(" &raquo; ", $location)));
	
	/* Set the forced chromeless mode, flush the template */
	$GLOBALS["CHROMELESS_MODE"] = 1;
	$frame -> Flush();
	
?>