<?php
 namespace App\Http\Controllers\Admin; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Response; use TechSoft\Laravel\Admin\Cms\BasicCms; use TechSoft\Laravel\Admin\Cms\Field\FieldCategory; use TechSoft\Laravel\Admin\Cms\Field\FieldDatetime; use TechSoft\Laravel\Admin\Cms\Field\FieldRichtext; use TechSoft\Laravel\Admin\Cms\Field\FieldText; use TechSoft\Laravel\Admin\Support\AdminCheckController; use TechSoft\Laravel\Admin\Util\AdminCmsUtil; use TechSoft\Laravel\Admin\Util\AdminPowerUtil; use TechSoft\Laravel\Forum\ForumUtil; use TechSoft\Laravel\Forum\Types\PostStatus; use TechSoft\Laravel\Forum\Types\ThreadStatus; class ForumPostController extends AdminCheckController { private $cmsConfigData = [ 'model' => 'forum_post', 'pageTitle' => '帖子回复', 'group' => 'data', 'canView' => true, 'canDelete' => true, 'fields' => [ 'created_at' => ['type' => FieldDatetime::class, 'title' => '时间', 'list' => true, 'add' => true, 'edit' => true, 'view' => true], 'memberUserId' => ['type' => FieldText::class, 'title' => '用户', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'model' => 'forum_category'], 'categoryId' => ['type' => FieldCategory::class, 'title' => '分类', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'model' => 'forum_category'], 'threadId' => ['type' => FieldText::class, 'title' => '帖子', 'list' => true, 'add' => true, 'edit' => true, 'view' => true], 'content' => ['type' => FieldRichtext::class, 'title' => '内容', 'list' => true, 'add' => true, 'edit' => true, 'view' => true], ] ]; public function dataProcessView(&$item, &$record) { $item['memberUserId'] = AdminCmsUtil::memberUserId($item['memberUserId'], '\App\Http\Controllers\Admin\MemberController@dataView'); $thread = ModelUtil::getWithCache('forum_thread', ['id' => $record['threadId']]); $item['threadId'] = '<a href="/thread/' . $record['threadId'] . '" target="_blank">' . htmlspecialchars($thread['title']) . '</a>'; if ($record['status'] === PostStatus::WAIT_VERIFY) { $item['content'] .= ' ' . AdminCmsUtil::pass(action('\App\Http\Controllers\Admin\ForumPostController@verifyPass', ['id' => $record['id']])); $item['content'] .= ' ' . AdminCmsUtil::reject(action('\App\Http\Controllers\Admin\ForumPostController@verifyReject', ['id' => $record['id']])); } } public function verifyList(BasicCms $basicCms) { $this->cmsConfigData['listFilter']['where']['status'] = PostStatus::WAIT_VERIFY; return $basicCms->executeList($this, $this->cmsConfigData); } public function verifyPass($id) { if (AdminPowerUtil::isDemo()) { return AdminPowerUtil::demoResponse(); } ForumUtil::updatePost($id, ['status' => PostStatus::VERIFY_PASS]); return Response::send(0, null, null, '[js]window.__cms.action.refresh();'); } public function verifyReject($id) { if (AdminPowerUtil::isDemo()) { return AdminPowerUtil::demoResponse(); } ForumUtil::deletePost($id); return Response::send(0, null, null, '[js]window.__cms.action.refresh();'); } public function dataList(BasicCms $basicCms) { return $basicCms->executeList($this, $this->cmsConfigData); } public function dataAdd(BasicCms $basicCms) { return $basicCms->executeAdd($this, $this->cmsConfigData); } public function dataEdit(BasicCms $basicCms) { return $basicCms->executeEdit($this, $this->cmsConfigData); } public function dataDelete(BasicCms $basicCms) { return $basicCms->executeDelete($this, $this->cmsConfigData); } public function dataView(BasicCms $basicCms) { return $basicCms->executeView($this, $this->cmsConfigData); } }