<?php
 namespace App\Http\Controllers\Main; use App\Constant\AppConstant; use App\Http\Controllers\BaseController; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Forum\ForumUtil; use TechSoft\Laravel\Forum\Types\ThreadStatus; class SearchController extends BaseController { public function index($page = 1) { $input = InputPackage::buildFromInput(); $keywords = $input->getTrimString('keywords'); $type = Input::get('type'); $tagId = Input::get('tagId'); $order = []; $order[] = ['isTop', 'desc']; $order[] = ['id', 'desc']; switch ($type) { case 'digest': $order [] = ['isDigest', 'desc']; $type = 'digest'; break; default: $type = null; break; } $where = []; if ($tagId) { $where['tagId'] = $tagId; } $where['status'] = ThreadStatus::VERIFY_PASS; $option = []; $option['where'] = $where; $option['order'] = $order; $paginateData = ForumUtil::paginateThreadsByKeywords($keywords, $page, AppConstant::FORUM_THREAD_PAGE_SIZE, $option); $threads = $paginateData['records']; $pageHtml = PageHtmlUtil::render($paginateData['total'], AppConstant::FORUM_THREAD_PAGE_SIZE, $page, '/search?keywords=' . urlencode($keywords) . '&page={page}'); ModelUtil::join($threads, 'memberUserId', '_memberUser', 'member_user', 'id'); ModelUtil::join($threads, 'tagId', '_tag', 'forum_category_tag', 'id'); $latestThreads = ForumUtil::listLatestThreads(10); $viewData = []; $viewData['tagId'] = $tagId; $viewData['type'] = $type; $viewData['threads'] = $threads; $viewData['pageHtml'] = $pageHtml; $viewData['keywords'] = $keywords; $viewData['latestThreads'] = $latestThreads; return $this->_view('search.index', $viewData); } }