<?php
 namespace App\Http\Controllers\Main; use App\Constant\AppConstant; use App\Http\Controllers\BaseController; use Carbon\Carbon; use Illuminate\Support\Facades\Event; use Illuminate\Support\Facades\Input; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Request; use TechOnline\Laravel\Http\Response; use TechOnline\Laravel\Util\TreeUtil; use TechOnline\Utils\PageHtmlUtil; use TechSoft\Laravel\Config\ConfigUtil; use TechSoft\Laravel\Forum\Converter\AtMemberInterceptor; use TechSoft\Laravel\Forum\Events\PostHasNewReply; use TechSoft\Laravel\Forum\Events\ThreadHasNewPost; use TechSoft\Laravel\Forum\ForumUtil; use TechSoft\Laravel\Forum\Types\PostStatus; use TechSoft\Laravel\Forum\Types\ThreadStatus; use TechSoft\Laravel\Html\HtmlConverter; use TechSoft\Laravel\Html\HtmlType; use TechSoft\Laravel\Member\Interfaces\MemberLoginCheck; use TechSoft\Laravel\Member\MemberUtil; use TechSoft\Laravel\Util\HtmlUtil; class ThreadController extends BaseController implements MemberLoginCheck { public static $ignoreAction = [ 'index' ]; public function index($id, $page = 1) { $thread = ForumUtil::loadThread($id); if (empty($thread)) { return Response::send(-1, '帖子不存在'); } if ($thread['status'] !== ThreadStatus::VERIFY_PASS) { return Response::sendError('正在审核中'); } if (empty($thread['contentHtml'])) { if (empty($thread['contentType'])) { $thread['contentType'] = HtmlType::RICH_TEXT; } $thread['contentHtml'] = HtmlConverter::convertToHtml($thread['contentType'], $thread['content'], AtMemberInterceptor::class); ForumUtil::updateThread($thread['id'], $thread); } $categories = ForumUtil::getCategories(); $categoryChain = TreeUtil::chain($categories, $thread['categoryId']); $thread['_memberUser'] = MemberUtil::get($thread['memberUserId']); if ($this->memberUserId()) { $thread['_memberData'] = ForumUtil::loadThreadMemberData($thread['id'], $this->memberUserId()); } $option = []; $option['order'] = ['id', 'asc']; $option['where'] = ['status' => PostStatus::VERIFY_PASS,]; $postPaginateData = ForumUtil::paginateThreadPost($thread['id'], $page, AppConstant::THREAD_POST_PAGE_SIZE, $option); $pageHtml = PageHtmlUtil::render($postPaginateData['total'], AppConstant::THREAD_POST_PAGE_SIZE, $page, '/thread/' . $thread['id'] . '/{page}'); $posts = $postPaginateData['records']; foreach ($posts as &$post) { if (empty($post['contentHtml'])) { if (empty($post['contentType'])) { $post['contentType'] = HtmlType::RICH_TEXT; } $post['contentHtml'] = HtmlConverter::convertToHtml($post['contentType'], $post['content'], AtMemberInterceptor::class); ForumUtil::updatePost($post['id'], $post); } } ModelUtil::join($posts, 'memberUserId', '_memberUser', 'member_user', 'id'); $latestThreads = ForumUtil::listLatestThreads(8); $isAdmin = false; if ($this->memberUserId() && ForumUtil::isCategoryAdmin($this->memberUserId(), $thread['categoryId'])) { $isAdmin = true; } ForumUtil::updateThread($thread['id'], ['clickCount' => $thread['clickCount'] + 1]); $thread['contentHtml'] = HtmlUtil::filter($thread['contentHtml']); $viewData = []; $viewData['thread'] = $thread; $viewData['categoryChain'] = $categoryChain; $viewData['posts'] = $posts; $viewData['pageHtml'] = $pageHtml; $viewData['page'] = $page; $viewData['latestThreads'] = $latestThreads; $viewData['isAdmin'] = $isAdmin; return $this->_view('thread.index', $viewData); } public function edit($id = 0) { $thread = null; if ($id) { $thread = ForumUtil::loadThread($id); if (empty($thread)) { return Response::send(-1, 'thread not found'); } $category = ForumUtil::loadCategory($thread['categoryId']); if ($thread['memberUserId'] != $this->memberUserId()) { return Response::send(-1, 'thread edit forbidden'); } } else { $categoryId = Input::get('categoryId'); $category = ForumUtil::loadCategory($categoryId); if (empty($category)) { return Response::send(-1, 'category not found'); } } $categoryTags = ForumUtil::getCategoryTagMap($category['id']); if (Request::isPost()) { $editorType = ConfigUtil::get('editorType', HtmlType::RICH_TEXT); if ($this->isMobile()) { $editorType = HtmlType::RICH_TEXT; } $data = []; $data['tagId'] = intval(Input::get('tagId')); $data['title'] = Input::get('title'); $data['contentType'] = $editorType; $data['content'] = Input::get('content'); switch (ConfigUtil::get('editorType', HtmlType::RICH_TEXT)) { case HtmlType::RICH_TEXT: $data['content'] = HtmlUtil::filter($data['content']); break; case HtmlType::MARKDOWN: break; } $data['contentHtml'] = null; if (!empty($categoryTags)) { if (empty($data['tagId'])) { return Response::send(-1, '标签为空'); } if (!isset($categoryTags[$data['tagId']])) { return Response::send(-1, '标签不能使用'); } } if (empty($data['title'])) { return Response::send(-1, '标题不能为空'); } if (empty($data['content'])) { return Response::send(-1, '内容不能为空'); } if ($thread) { ForumUtil::updateThread($thread['id'], $data); return Response::send(0, null, null, '/thread/' . $thread['id']); } else { $data['memberUserId'] = $this->memberUserId(); $data['categoryId'] = $category['id']; $data['postCount'] = 0; $data['clickCount'] = 0; $thread = ForumUtil::addThread($data); return Response::send(0, null, null, '/thread/' . $thread['id']); } } $viewData = []; $viewData['category'] = $category; $viewData['categoryTags'] = $categoryTags; $viewData['thread'] = $thread; return $this->_view('thread.edit', $viewData); } public function toggle($threadId, $action) { $thread = ForumUtil::loadThread($threadId); if (empty($thread)) { return Response::send(-1, 'thread not found'); } $threadMemberData = ForumUtil::loadThreadMemberData($threadId, $this->memberUserId()); switch ($action) { case 'up': if ($threadMemberData['up']) { ForumUtil::updateThreadMemberData($threadId, $this->memberUserId(), ['up' => 0]); ForumUtil::updateThread($threadId, ['upCount' => $thread['upCount'] - 1]); } else { ForumUtil::updateThreadMemberData($threadId, $this->memberUserId(), ['up' => 1]); ForumUtil::updateThread($threadId, ['upCount' => $thread['upCount'] + 1]); } break; case 'down': if ($threadMemberData['down']) { ForumUtil::updateThreadMemberData($threadId, $this->memberUserId(), ['down' => 0]); ForumUtil::updateThread($threadId, ['downCount' => $thread['downCount'] - 1]); } else { ForumUtil::updateThreadMemberData($threadId, $this->memberUserId(), ['down' => 1]); ForumUtil::updateThread($threadId, ['downCount' => $thread['downCount'] + 1]); } break; case 'fav': ForumUtil::updateThreadMemberData($threadId, $this->memberUserId(), ['fav' => $threadMemberData['fav'] ? 0 : 1]); break; } return Response::send(0, 'ok'); } public function delete($threadId) { $thread = ForumUtil::loadThread($threadId); if (empty($thread)) { return Response::send(-1, 'thread not found'); } if ($thread['memberUserId'] != $this->memberUserId() && !ForumUtil::isCategoryAdmin($this->memberUserId(), $thread['categoryId'])) { return Response::send(-1, 'thread not yours'); } ForumUtil::deleteThread($threadId); return Response::send(0, null, null, '/forum/' . $thread['categoryId']); } public function setTop($threadId) { $thread = ForumUtil::loadThread($threadId); if (empty($thread)) { return Response::send(-1, 'thread not found'); } if (!ForumUtil::isCategoryAdmin($this->memberUserId(), $thread['categoryId'])) { return Response::send(-1, 'thread not yours'); } ForumUtil::updateThread($threadId, ['isTop' => $thread['isTop'] ? 0 : 1]); return Response::send(0, null, null, '[reload]'); } public function setDigest($threadId) { $thread = ForumUtil::loadThread($threadId); if (empty($thread)) { return Response::send(-1, 'thread not found'); } if (!ForumUtil::isCategoryAdmin($this->memberUserId(), $thread['categoryId'])) { return Response::send(-1, 'thread not yours'); } ForumUtil::updateThread($threadId, ['isDigest' => $thread['isDigest'] ? 0 : 1]); return Response::send(0, null, null, '[reload]'); } public function post($threadId) { $thread = ForumUtil::loadThread($threadId); if (empty($thread)) { return Response::send(-1, 'thread not found'); } $editorType = ConfigUtil::get('editorType', HtmlType::RICH_TEXT); if ($this->isMobile()) { $editorType = HtmlType::RICH_TEXT; } $data = []; $data['contentType'] = $editorType; $data['content'] = Input::get('content'); $data['content'] = HtmlUtil::filter($data['content']); if (empty($data['content'])) { return Response::send(-1, '内容不能为空'); } $data['contentHtml'] = null; $data['categoryId'] = $thread['categoryId']; $data['threadId'] = $thread['id']; $data['memberUserId'] = $this->memberUserId(); $data['replyPostId'] = intval(Input::get('replyPostId')); if (!preg_match('/@(.*?):/', $data['content'])) { $data['replyPostId'] = 0; } $post = ForumUtil::addPost($data); $page = ForumUtil::getPostPageInThread($post['id'], $thread['id'], AppConstant::THREAD_POST_PAGE_SIZE); ForumUtil::updateThread($thread['id'], ['lastReplyTime' => Carbon::now(), 'lastReplyMemberUserId' => $this->memberUserId()]); $event = new ThreadHasNewPost(); $event->thread = $thread; $event->post = $post; $event->postPage = $page; Event::fire($event); if ($data['replyPostId']) { $yourPost = ForumUtil::loadPost($data['replyPostId']); if ($yourPost) { $event = new PostHasNewReply(); $event->thread = $thread; $event->yourPost = ForumUtil::loadPost($data['replyPostId']); $event->replyPost = $post; $event->replyPostPage = $page; Event::fire($event); } } return Response::send(0, null, null, '/thread/' . $thread['id'] . '/' . $page . '?postId=' . $post['id']); } public function postDelete($postId) { $post = ForumUtil::loadPost($postId); if (empty($post)) { return Response::send(-1, 'post not found'); } ForumUtil::deletePost($post['id']); return Response::send(0, null, null, '/thread/' . $post['threadId']); } }