@extends('admin::frameDialog')

@section('pageTitle','分类管理员')

@section('headAppend')
    @parent
    <style type="text/css">
        .user-list {
        }

        .user-list .item {
            display: inline-block;
            margin: 5px 5px 5px 0;
            border: 1px solid #CCC;
            border-radius: 3px;
            padding: 5px;
            color: #333;
            position: relative;
            background: #FFF;
        }

        .user-list .item .remove {
            display: block;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: #CCC;
            color: #FFF;
            line-height: 16px;
            font-size: 16px;
            text-align: center;
            position: absolute;
            right: -8px;
            top: -8px;
        }
    </style>
@endsection

@section('dialogBody')

    <div class="admin-form">
        <form action="?" method="post" data-ajax-form>
            <table>
                <tbody>
                <tr>
                    <td>
                        <div class="line">
                            <div class="label">
                                <label>
                                    用户
                                </label>
                            </div>
                            <div class="field user-list" data-list>
                                @foreach($memberUsers as $memberUser)
                                    <a class="item" href="javascript:;">
                                        <span class="remove uk-icon-remove"></span>
                                        {{$memberUser['username']}}
                                        <input type="hidden" name="memberUserId[]" value="{{$memberUser['id']}}"/>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="line">
                            <div class="label">
                                <label>
                                    搜索增加
                                </label>
                            </div>
                            <div class="field">
                                <input type="text" data-search-keyword/>
                            </div>
                            <div class="field user-list" data-search-list>
                            </div>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
        </form>
    </div>

    <script>
        $(function () {
            var $searchList = $('[data-search-list]');
            var $list = $('[data-list]');

            $list.on('click', '.remove', function () {
                $(this).closest('.item').remove();
            });

            $searchList.on('click', '.item', function () {
                var id = $(this).attr('data-id');
                var name = $(this).attr('data-name');
                var html = '<a class="item" href="javascript:;"><span class="remove uk-icon-remove"></span>' + name + '<input type="hidden" name="memberUserId[]" value="' + id + '"/></a>';
                $list.append(html);
                $(this).remove();
                return false;
            });

            var searchTimer = null;
            var search = function () {
                if (searchTimer) {
                    clearTimeout(searchTimer);
                    searchTimer = null;
                }
                searchTimer = setTimeout(function () {
                    var keyword = $('[data-search-keyword]').val();
                    $.post("{{action('\App\Http\Controllers\Admin\ForumCategoryController@adminSearch')}}", {keyword: keyword}, function (res) {
                        window.api.base.defaultFormCallback(res, {
                            success: function (res) {
                                $searchList.html('');
                                for (var i = 0; i < res.data.list.length; i++) {
                                    var record = res.data.list[i];
                                    $searchList.append('<a class="item" href="javascript:;" data-id="' + record.id + '" data-name="' + record.username + '"><span class="uk-icon-plus"></span> ' + record.username + '</a>');
                                }
                            }
                        });
                    });
                }, 500);
            };
            $('[data-search-keyword]').on('keyup', search).on('keypress', search);
        });
    </script>

@endsection
