@extends('theme.default.m.frame')

@section('pageTitle',htmlspecialchars($memberUser['username']).'赞过的帖子')
@section('headerTitle',htmlspecialchars($memberUser['username']).'赞过的帖子')

@section('bodyContent')

    <div class="pb">
        <div class="body">
            <div class="pb-member-thread-list">

                @if(empty($threads))
                    <div class="empty">
                        没有记录~
                    </div>
                @else
                    @foreach($threads as $thread)
                        <div class="item">
                            <a href="/thread/{{$thread['id']}}" target="_blank">{{$thread['title']}}</a>
                            <br>
                            {{$thread['clickCount'] or 0}}阅读
                            ⋅
                            {{$thread['upCount'] or 0}}点赞
                            ⋅
                            {{$thread['postCount'] or 0}}回复
                            ⋅
                            <span class="time"><time datetime="{{$thread['created_at']}}"></time></span>
                        </div>
                    @endforeach
                @endif

            </div>

            <div class="page-container">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>


@endsection