@extends('theme.default.pc.frame')

@section('pageTitleMain',htmlspecialchars($memberUser['username']).'收藏的帖子')

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/member/{{$memberUser['id']}}">个人中心</a></li>
                <li class="uk-active"><span>收藏的帖子</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-10">

                @include('theme.default.pc.member.oneLeft')

            </div>
            <div class="uk-width-7-10">

                <div class="pb">
                    <div class="head">收藏的帖子</div>
                    <div class="body">

                        <div class="member-thread-list">

                            @if(empty($threads))
                                <div class="empty">
                                    没有记录~
                                </div>
                            @else
                                @foreach($threads as $thread)
                                    <div class="item">
                                        <a href="/thread/{{$thread['id']}}" target="_blank">{{$thread['title']}}</a>
                                        &nbsp;
                                        {{$thread['clickCount'] or 0}}阅读
                                        ⋅
                                        {{$thread['upCount'] or 0}}点赞
                                        ⋅
                                        {{$thread['postCount'] or 0}}回复
                                        ⋅
                                        <span class="time"><time datetime="{{$thread['created_at']}}"></time></span>
                                    </div>
                                @endforeach
                            @endif

                        </div>

                        <div class="page-container">
                            {!! $pageHtml !!}
                        </div>

                    </div>
                </div>


            </div>
        </div>

    </div>


@endsection