@extends('theme.default.pc.frame')

@section('pageTitleMain',htmlspecialchars($memberUser['username']).'的个人中心')

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li class="uk-active"><span>个人中心</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-3-10">

                @include('theme.default.pc.member.oneLeft')

            </div>
            <div class="uk-width-7-10">
                <div class="pb">
                    <div class="head">发布的帖子</div>
                    <div class="body">

                        <div class="member-thread-list">

                            @if(empty($latestThreads))
                                <div class="empty">
                                    没有记录~
                                </div>
                            @else
                                @foreach($latestThreads as $latestThread)
                                    <div class="item">
                                        <a href="/thread/{{$latestThread['id']}}" target="_blank">{{$latestThread['title']}}</a>
                                        &nbsp;
                                        {{$latestThread['clickCount'] or 0}}阅读
                                        ⋅
                                        {{$latestThread['upCount'] or 0}}点赞
                                        ⋅
                                        {{$latestThread['postCount'] or 0}}回复
                                        ⋅
                                        <span class="time"><time datetime="{{$latestThread['created_at']}}"></time></span>
                                    </div>
                                @endforeach
                            @endif

                        </div>

                    </div>
                </div>
                <div class="pb">
                    <div class="head">最新评论</div>
                    <div class="body">

                        <div class="member-comment-list">

                            @if(empty($latestPosts))
                                <div class="empty">
                                    没有记录~
                                </div>
                            @else
                                @foreach($latestPosts as $latestPost)
                                    <div class="item">
                                        <div class="thread">
                                            <a target="_blank" href="/thread/{{$latestPost['_thread']['id']}}">{{$latestPost['_thread']['title']}}</a>
                                            &nbsp;&nbsp;
                                            <span class="time"><time datetime="{{$latestPost['created_at']}}"></time></span>
                                        </div>
                                        <div class="comment">
                                            {!! $latestPost['contentHtml'] !!}
                                        </div>
                                    </div>
                                @endforeach
                            @endif

                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection