@extends('theme.default.pc.frame')

@if($thread)
    @section('pageTitleMain','编辑帖子')
@else
    @section('pageTitleMain','发布帖子')
@endif

@section('bodyScript')
    @parent
    @if($thread)
        @if($thread['contentType']==\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)
            <script src="@assets('assets/main/editor.js')"></script>
        @endif
        @if($thread['contentType']==\TechSoft\Laravel\Html\HtmlType::MARKDOWN)
            <script src="@assets('assets/main/markdown.js')"></script>
        @endif
    @else
        @if(\TechSoft\Laravel\Config\ConfigUtil::get('editorType',\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)==\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)
            <script src="@assets('assets/main/editor.js')"></script>
        @endif
        @if(\TechSoft\Laravel\Config\ConfigUtil::get('editorType',\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)==\TechSoft\Laravel\Html\HtmlType::MARKDOWN)
            <script src="@assets('assets/main/markdown.js')"></script>
        @endif
    @endif
    <script>
        $(function(){
            window.api.editor.basic('content');
        });
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/forum/{{$category['id']}}">{{$category['title']}}</a></li>
                @if($thread)
                    <li class="uk-active"><span>编辑帖子</span></li>
                @else
                    <li class="uk-active"><span>发布帖子</span></li>
                @endif
            </ul>
        </div>

        <div class="pb pb-post">
            <form action="?" class="uk-form" data-ajax-form method="post">
                @if(!empty($categoryTags))
                    <div class="line">
                        <div class="label">标签</div>
                        <div class="field">
                            <div class="widget-radio widget-radio-primary" data-tab-only>
                                @foreach($categoryTags as $categoryTagId=>$categoryTagTitle)
                                    <label><input type="radio" name="tagId" value="{{$categoryTagId}}" @if(isset($thread['tagId']) && $thread['tagId']==$categoryTagId) checked @endif  />{{$categoryTagTitle}}</label>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
                <div class="line">
                    <div class="label">标题</div>
                    <div class="field">
                        <input type="text" name="title" style="width:800px;" value="{{$thread['title'] or ''}}"/>
                    </div>
                </div>
                <div class="line">
                    <div class="label">内容</div>
                    <div class="field">
                        <div style="width:800px;">
                            @if($thread)
                                @if($thread['contentType']==\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)
                                    <script type="text/plain" id="content" name="content">{!! $thread['content'] or '' !!}</script>
                                @endif
                                @if($thread['contentType']==\TechSoft\Laravel\Html\HtmlType::MARKDOWN)
                                    <textarea name="content" id="content">{!! $thread['content'] or '' !!}</textarea>
                                @endif
                            @else
                                @if(\TechSoft\Laravel\Config\ConfigUtil::get('editorType',\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)==\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)
                                    <script type="text/plain" id="content" name="content">{!! $thread['content'] or '' !!}</script>
                                @endif
                                @if(\TechSoft\Laravel\Config\ConfigUtil::get('editorType',\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)==\TechSoft\Laravel\Html\HtmlType::MARKDOWN)
                                    <textarea name="content" id="content">{!! $thread['content'] or '' !!}</textarea>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
                <div class="line">
                    <div class="label">&nbsp;</div>
                    <div class="field">
                        <button class="uk-button uk-button-main">提交</button>
                    </div>
                </div>
                <input type="hidden" name="categoryId" value="{{$category['id'] or 0}}">
            </form>
        </div>

    </div>

@endsection