<?php
 namespace TechSoft\Laravel\Shop\Util; use Illuminate\Support\Facades\Cache; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Util\TreeUtil; use TechSoft\Laravel\Shop\Types\GoodsSaleStatus; use TechSoft\Laravel\Types\SwitchType; class GoodsUtil { const CACHE_KEY_PREFIX = 'soft.shop.goods.'; public static function unified2KeyValue($spec) { if (!$spec) { return []; } $pcs = explode('|', $spec); $kvs = []; foreach ($pcs as $pc) { $kv = explode(':', $pc); $kvs[$kv[0]] = $kv[1]; } return $kvs; } public static function keyValue2Unified($spec) { ksort($spec, SORT_STRING); $kvs = []; foreach ($spec as $k => $v) { $kvs[] = "$k:$v"; } return join('|', $kvs); } public static function listCategory($cacheMinutes = 60) { if (!$cacheMinutes) { return ModelUtil::all('category'); } else { return Cache::remember(self::CACHE_KEY_PREFIX . 'category', $cacheMinutes, function () { return ModelUtil::all('category'); }); } } public static function listChildCategoryTree($pid = 0, $cacheMinutes = 60) { $categories = self::listCategory($cacheMinutes); $categoryTree = TreeUtil::nodeMerge($categories, $pid, 'id', 'pid', 'sort', 'asc'); return $categoryTree; } public static function getCategory($id, $cacheMinutes = 60) { if (!$cacheMinutes) { $categories = ModelUtil::all('category'); } else { $categories = Cache::remember(self::CACHE_KEY_PREFIX . 'category', $cacheMinutes, function () { return ModelUtil::all('category'); }); } foreach ($categories as $category) { if ($category['id'] == $id) { return $category; } } return null; } public static function getCategoryChildIds($categoryId, $cacheMinutes = 60) { $categories = self::listCategory($cacheMinutes); $categoryIds = TreeUtil::allChildIds($categories, $categoryId); return $categoryIds; } public static function clearCategoryCache() { Cache::forget(self::CACHE_KEY_PREFIX . 'category'); } public static function getSimple($goodsId) { return ModelUtil::get('goods', ['id' => $goodsId]); } public static function get($goodsId) { $goods = ModelUtil::get('goods', ['id' => $goodsId]); if (empty($goods)) { return null; } $goodsSpecs = ModelUtil::all('goods_spec', ['goodsId' => $goodsId]); if (empty($goodsSpecs)) { $stock = $goods['stock']; } else { $stock = 0; foreach ($goodsSpecs as $goodsSpec) { $stock += $goodsSpec['stock']; } } $goods['_stock'] = $stock; $goods['_hasSpec'] = (count($goodsSpecs) > 0); $goods['_ts'] = time(); if (!empty($goods['startTimeEnable'])) { $goods['_startTimeTs'] = strtotime($goods['startTime']); } if (!empty($goods['endTimeEnable'])) { $goods['_endTimeTs'] = strtotime($goods['endTime']); } return $goods; } public static function getDetail($goodsId) { $detail = ModelUtil::get('goods_detail', ['goodsId' => $goodsId]); if ($detail) { if (isset($detail['images'])) { $detail['images'] = @json_decode($detail['images'], true); if (empty($detail['images'])) { $detail['images'] = []; } } } return $detail; } public static function getStat($goodsId) { return ModelUtil::get('goods_stat', ['goodsId' => $goodsId]); } public static function getAttr($goodsId) { $ms = ModelUtil::all('goods_attr', ['goodsId' => $goodsId]); $attr = []; foreach ($ms as $m) { $attr[] = [ 'name' => $m['name'], 'value' => $m['value'], ]; } return $attr; } public static function getSpec($goodsId) { $map = []; $info = []; $param = []; if ($goodsId) { $ms = ModelUtil::all('goods_spec', ['goodsId' => $goodsId]); foreach ($ms as $m) { $pcs = explode('|', $m['spec']); foreach ($pcs as $pc) { $pair = explode(':', $pc); $pair[0] = trim($pair[0]); $pair[1] = trim($pair[1]); if (!isset($map[$pair[0]])) { $map[$pair[0]] = [$pair[1]]; } else { if (!in_array($pair[1], $map[$pair[0]])) { $map[$pair[0]][] = $pair[1]; } } } $spec = $m['spec']; unset($m['id']); unset($m['created_at']); unset($m['updated_at']); unset($m['goodsId']); unset($m['spec']); $info[$spec] = $m; } } foreach ($map as $k => $v) { $param[] = [ 'name' => $k, 'values' => $v, ]; } return [ 'param' => $param, 'map' => $map, 'info' => $info, ]; } public static function getSpecWithStock($goodsId) { $map = []; $info = []; if ($goodsId) { $ms = ModelUtil::all('goods_spec', ['goodsId' => $goodsId]); foreach ($ms as $m) { if (empty($m['stock'])) { continue; } $pcs = explode('|', $m['spec']); foreach ($pcs as $pc) { $pair = explode(':', $pc); $pair[0] = trim($pair[0]); $pair[1] = trim($pair[1]); if (!isset($map[$pair[0]])) { $map[$pair[0]] = [$pair[1]]; } else { if (!in_array($pair[1], $map[$pair[0]])) { $map[$pair[0]][] = $pair[1]; } } } $spec = $m['spec']; unset($m['id']); unset($m['created_at']); unset($m['updated_at']); unset($m['goodsId']); unset($m['spec']); $info[$spec] = $m; } } return [ 'map' => $map, 'info' => $info, ]; } public static function isSpecGoods($goodsId) { return ModelUtil::exists('goods_spec', ['goodsId' => $goodsId]); } public static function paginateGoods($search, $page, $pageSize, $option = []) { $option['whereIn'] = []; if (!empty($search['categoryId'])) { $childCategoryIds = self::getCategoryChildIds($search['categoryId']); $childCategoryIds[] = $search['categoryId']; $option['whereIn'][] = ['categoryId', $childCategoryIds]; } if (!empty($search['keyword'])) { $option['whereOperate'] = ['title', 'like', '%' . $search['keyword'] . '%']; } if (isset($search['goodsId'])) { $option['whereIn'][] = ['id', array_unique($search['goodsId'])]; } $option['where']['saleStatus'] = GoodsSaleStatus::ON; $option['where']['isVisible'] = SwitchType::YES; $option['order'] = ['id', 'desc']; $paginateData = ModelUtil::paginate('goods', $page, $pageSize, $option); if (!empty($paginateData['records'])) { $goodsIds = array_pluck($paginateData['records'], 'id'); $goodsSpecs = ModelUtil::model('goods_spec')->whereIn('goodsId', $goodsIds)->get()->toArray(); $goodsStock = []; foreach ($goodsSpecs as $goodsSpec) { if (!isset($goodsStock[$goodsSpec['goodsId']])) { $goodsStock[$goodsSpec['goodsId']] = $goodsSpec['stock']; } else { $goodsStock[$goodsSpec['goodsId']] += $goodsSpec['stock']; } } foreach ($paginateData['records'] as $i => $record) { if (isset($goodsStock[$record['id']])) { $paginateData['records'][$i]['_stock'] = $goodsStock[$record['id']]; $paginateData['records'][$i]['_hasSpec'] = true; } else { $paginateData['records'][$i]['_stock'] = $record['stock']; $paginateData['records'][$i]['_hasSpec'] = false; } } foreach ($paginateData['records'] as $i => $record) { $paginateData['records'][$i]['_ts'] = time(); if (!empty($record['startTimeEnable'])) { $paginateData['records'][$i]['_startTimeTs'] = strtotime($record['startTime']); } if (!empty($record['endTimeEnable'])) { $paginateData['records'][$i]['_endTimeTs'] = strtotime($record['endTime']); } } } return $paginateData; } public static function paginateGoodsByCategory($categoryId, $page, $pageSize, $option = []) { $childCategoryIds = self::getCategoryChildIds($categoryId); $childCategoryIds[] = $categoryId; if (isset($option['whereIn'])) { $option['whereIn'][] = ['categoryId', $childCategoryIds]; } else { $option['whereIn'] = ['categoryId', $childCategoryIds]; } $option['where']['saleStatus'] = GoodsSaleStatus::ON; $option['where']['isVisible'] = SwitchType::YES; $paginateData = ModelUtil::paginate('goods', $page, $pageSize, $option); if (!empty($paginateData['records'])) { $goodsIds = array_pluck($paginateData['records'], 'id'); $goodsSpecs = ModelUtil::model('goods_spec')->whereIn('goodsId', $goodsIds)->get()->toArray(); $goodsStock = []; foreach ($goodsSpecs as $goodsSpec) { if (!isset($goodsStock[$goodsSpec['goodsId']])) { $goodsStock[$goodsSpec['goodsId']] = $goodsSpec['stock']; } else { $goodsStock[$goodsSpec['goodsId']] += $goodsSpec['stock']; } } foreach ($paginateData['records'] as &$record) { if (isset($goodsStock[$record['id']])) { $record['_stock'] = $goodsStock[$record['id']]; } else { $record['_stock'] = $record['stock']; } } } return $paginateData; } public static function paginateGoodsByKeyword($keyword, $page, $pageSize, $option = []) { $option['whereOperate'] = ['title', 'like', '%' . $keyword . '%']; $option['where']['saleStatus'] = GoodsSaleStatus::ON; $option['where']['isVisible'] = SwitchType::YES; $paginateData = ModelUtil::paginate('goods', $page, $pageSize, $option); if (!empty($paginateData['records'])) { $goodsIds = array_pluck($paginateData['records'], 'id'); $goodsSpecs = ModelUtil::model('goods_spec')->whereIn('goodsId', $goodsIds)->get()->toArray(); $goodsStock = []; foreach ($goodsSpecs as $goodsSpec) { if (!isset($goodsStock[$goodsSpec['goodsId']])) { $goodsStock[$goodsSpec['goodsId']] = $goodsSpec['stock']; } else { $goodsStock[$goodsSpec['goodsId']] += $goodsSpec['stock']; } } foreach ($paginateData['records'] as &$record) { if (isset($goodsStock[$record['id']])) { $record['_stock'] = $goodsStock[$record['id']]; } else { $record['_stock'] = $record['stock']; } } } return $paginateData; } public static function addCart($memberUserId, $goodsId, $spec = null, $amount = 1) { if (empty($spec)) { $spec = ''; } $cartGoodsExists = ModelUtil::all('cart', ['memberUserId' => $memberUserId, 'goodsId' => $goodsId]); if (!empty($cartGoodsExists)) { foreach ($cartGoodsExists as $cart) { if ($cart['spec'] == $spec) { ModelUtil::update('cart', ['id' => $cart['id']], ['amount' => $cart['amount'] + $amount]); $cart['amount'] = $cart['amount'] + $amount; return $cart; } } } return ModelUtil::insert('cart', [ 'memberUserId' => $memberUserId, 'goodsId' => $goodsId, 'spec' => $spec, 'amount' => $amount, ]); } public static function addStoreCart($storeId, $memberUserId, $goodsId, $spec = null, $amount = 1) { if (empty($spec)) { $spec = ''; } $cartGoodsExists = ModelUtil::all('cart', ['storeId' => $storeId, 'memberUserId' => $memberUserId, 'goodsId' => $goodsId]); if (!empty($cartGoodsExists)) { foreach ($cartGoodsExists as $goods) { if ($goods['spec'] == $spec) { return ModelUtil::update('cart', ['id' => $goods['id']], ['amount' => $goods['amount'] + $amount]); } } } return ModelUtil::insert('cart', [ 'storeId' => $storeId, 'memberUserId' => $memberUserId, 'goodsId' => $goodsId, 'spec' => $spec, 'amount' => $amount, ]); } public static function updateCart($id, $data) { return ModelUtil::update('cart', ['id' => $id], $data); } public static function updateOrder($orderId, $data) { return ModelUtil::update('order', ['id' => $orderId], $data); } public static function getCartCount($memberUserId) { return ModelUtil::count('cart', ['memberUserId' => $memberUserId]); } public static function getStoreCartCount($storeId, $memberUserId) { return ModelUtil::count('cart', ['storeId' => $storeId, 'memberUserId' => $memberUserId]); } public static function listCartWithGoodsInfo($memberUserId, $cartIds = null) { $carts = ModelUtil::model('cart') ->where(['memberUserId' => $memberUserId]); if (null != $cartIds) { $carts = $carts->whereIn('id', $cartIds); } $carts = $carts->orderBy('id', 'desc')->get()->toArray(); ModelUtil::join($carts, 'goodsId', '_goods', 'goods', 'id'); $cleanCarts = []; foreach ($carts as &$cart) { if (empty($cart['_goods'])) { continue; } if (!empty($cart['spec'])) { $spec = ModelUtil::get('goods_spec', ['goodsId' => $cart['goodsId'], 'spec' => $cart['spec']]); if (empty($spec)) { $cart['spec'] = []; continue; } $cart['_goodsSpec'] = $spec; $cart['spec'] = GoodsUtil::unified2KeyValue($cart['spec']); $cart['_goodsSpec']['spec'] = GoodsUtil::unified2KeyValue($cart['_goodsSpec']['spec']); } $cleanCarts[] = $cart; } return $cleanCarts; } public static function listStoreCartWithGoodsInfo($storeId, $memberUserId, $cartIds = null) { $carts = ModelUtil::model('cart') ->where(['storeId' => $storeId, 'memberUserId' => $memberUserId]); if (!empty($cartIds)) { $carts = $carts->whereIn('id', $cartIds); } $carts = $carts->orderBy('id', 'desc')->get()->toArray(); ModelUtil::join($carts, 'goodsId', '_goods', 'goods', 'id'); foreach ($carts as &$cart) { if (empty($cart['_goods'])) { continue; } if (!empty($cart['spec'])) { $spec = ModelUtil::get('goods_spec', ['goodsId' => $cart['goodsId'], 'spec' => $cart['spec']]); if (empty($spec)) { $cart['spec'] = []; continue; } $cart['_goodsSpec'] = $spec; $cart['spec'] = GoodsUtil::unified2KeyValue($cart['spec']); $cart['_goodsSpec']['spec'] = GoodsUtil::unified2KeyValue($cart['_goodsSpec']['spec']); } else { $cart['spec'] = []; } } return $carts; } public static function listCartOutput($list) { $listOutput = []; foreach ($list as $item) { $itemOutput = [ 'id' => $item['id'], 'amount' => $item['amount'], 'spec' => $item['spec'], 'goodsId' => $item['goodsId'], 'goodsTitle' => $item['_goods']['title'], ]; if (!empty($item['_goodsSpec']['cover'])) { $itemOutput['goodsCover'] = $item['_goodsSpec']['cover']; } else { $itemOutput['goodsCover'] = $item['_goods']['cover']; } if (!empty($item['_goodsSpec'])) { $itemOutput['goodsPrice'] = $item['_goodsSpec']['price']; } else { $itemOutput['goodsPrice'] = $item['_goods']['price']; } $listOutput[] = $itemOutput; } return $listOutput; } public static function getCartWithGoodsInfo($cartId) { $cart = ModelUtil::get('cart', ['id' => $cartId]); if (empty($cart)) { return null; } $cart['_goods'] = ModelUtil::get('goods', ['id' => $cart['goodsId']]); if (!empty($cart['_goods'])) { if (!empty($cart['spec'])) { $spec = ModelUtil::get('goods_spec', ['goodsId' => $cart['goodsId'], 'spec' => $cart['spec']]); if ($spec) { $cart['_goodsSpec'] = $spec; $cart['spec'] = GoodsUtil::unified2KeyValue($cart['spec']); $cart['_goodsSpec']['spec'] = GoodsUtil::unified2KeyValue($cart['_goodsSpec']['spec']); } } } return $cart; } public static function getSnapshot($goodsId, $snapshotId) { $goodsSnapshot = ModelUtil::get('goods_snapshot', [ 'id' => $snapshotId, 'goodsId' => $goodsId, ]); if ($goodsSnapshot) { $goodsSnapshot['attrData'] = @json_decode($goodsSnapshot['attrData'], true); $goodsSnapshot['specSpec'] = GoodsUtil::unified2KeyValue($goodsSnapshot['specSpec']); $goodsSnapshot['detailImages'] = @json_decode($goodsSnapshot['detailImages'], true); } return $goodsSnapshot; } public static function getOrCreateSnapshot($goodsId, $spec = '') { if (empty($spec)) { $spec = ''; } $goods = ModelUtil::get('goods', ['id' => $goodsId]); if (empty($goods)) { return null; } if (is_array($spec)) { $spec = GoodsUtil::keyValue2Unified($spec); } if ($spec) { $goodsSpec = ModelUtil::get('goods_spec', ['goodsId' => $goodsId, 'spec' => $spec]); if (empty($goodsSpec)) { return null; } } else { $goodsSpec = null; } $goodsAttrs = ModelUtil::model('goods_attr')->where(['goodsId' => $goodsId])->orderBy('id', 'desc')->get()->toArray(); $goodsDetail = ModelUtil::get('goods_detail', ['goodsId' => $goodsId]); $where = []; $where['goodsId'] = $goods['id']; $where['goodsUpdatedTime'] = $goods['updated_at']; $where['specUpdatedTime'] = $goodsSpec ? $goodsSpec['updated_at'] : '2000-01-01 00:00:00'; $where['goodsUpdatedTime'] = empty($goodsAttrs) ? '2000-01-01 00:00:00' : $goodsAttrs[0]['updated_at']; $where['detailUpdatedTime'] = $goodsDetail['updated_at']; $goodsSnapshot = ModelUtil::get('goods_snapshot', $where); if (!empty($goodsSnapshot)) { return $goodsSnapshot; } $goodsSnapshot = []; foreach ($where as $k => $v) { $goodsSnapshot[$k] = $v; } $goodsSnapshot['goodsId'] = $goods['id']; $goodsKeys = [ 'categoryId', 'title', 'price', 'marketPrice', 'shippingPrice', 'credit', 'shippingCredit', 'cover', 'image', 'isVirtual', ]; $goodsSpecKeys = [ 'spec', 'price', 'marketPrice', 'credit', 'cover', ]; foreach ($goodsKeys as $goodsKey) { if (isset($goods[$goodsKey])) { $goodsSnapshot[$goodsKey] = $goods[$goodsKey]; } } if ($goodsSpec) { foreach ($goodsSpecKeys as $goodsSpecKey) { if (isset($goodsSpec[$goodsSpecKey])) { $goodsSnapshot['spec' . ucfirst($goodsSpecKey)] = $goodsSpec[$goodsSpecKey]; } } } $attrData = []; foreach ($goodsAttrs as $goodsAttr) { $attrData[] = [ 'name' => $goodsAttr['name'], 'value' => $goodsAttr['value'], ]; } $goodsSnapshot['attrData'] = json_encode($attrData); $goodsSnapshot['detailImages'] = $goodsDetail['images']; $goodsSnapshot['detailContent'] = $goodsDetail['content']; $goodsSnapshot = ModelUtil::insert('goods_snapshot', $goodsSnapshot); return $goodsSnapshot; } public static function paginateOrderInfo($memberUserId, $page, $pageSize, $option = []) { $option['where']['memberUserId'] = $memberUserId; $paginateData = ModelUtil::paginate('order', $page, $pageSize, $option); foreach ($paginateData['records'] as &$record) { $orderGoods = ModelUtil::all('order_goods', ['orderId' => $record['id']]); if (!empty($orderGoods[0]['goodsSnapshotId'])) { ModelUtil::join($orderGoods, 'goodsSnapshotId', '_goodsSnapshot', 'goods_snapshot', 'id'); } foreach ($orderGoods as &$orderGood) { if (!empty($orderGood['_goodsSnapshot'])) { $orderGood['_goodsSnapshot']['specSpec'] = GoodsUtil::unified2KeyValue($orderGood['_goodsSnapshot']['specSpec']); } } $record['_orderGoods'] = $orderGoods; } return $paginateData; } public static function paginateOrderInfoAll($page, $pageSize, $option = []) { $paginateData = ModelUtil::paginate('order', $page, $pageSize, $option); foreach ($paginateData['records'] as &$record) { $orderGoods = ModelUtil::all('order_goods', ['orderId' => $record['id']]); if (!empty($orderGoods[0]['goodsSnapshotId'])) { ModelUtil::join($orderGoods, 'goodsSnapshotId', '_goodsSnapshot', 'goods_snapshot', 'id'); } foreach ($orderGoods as &$orderGood) { if (!empty($orderGood['_goodsSnapshot'])) { $orderGood['_goodsSnapshot']['specSpec'] = GoodsUtil::unified2KeyValue($orderGood['_goodsSnapshot']['specSpec']); } } $record['_orderGoods'] = $orderGoods; } return $paginateData; } public static function getOrderInfo($orderId) { $order = ModelUtil::get('order', ['id' => $orderId]); if (empty($order)) { return null; } $orderGoods = ModelUtil::all('order_goods', ['orderId' => $order['id']]); if (!empty($orderGoods[0]['goodsSnapshotId'])) { ModelUtil::join($orderGoods, 'goodsSnapshotId', '_goodsSnapshot', 'goods_snapshot', 'id'); } foreach ($orderGoods as &$orderGood) { if (!empty($orderGood['_goodsSnapshot'])) { $orderGood['_goodsSnapshot']['specSpec'] = GoodsUtil::unified2KeyValue($orderGood['_goodsSnapshot']['specSpec']); } } $order['_orderGoods'] = $orderGoods; $isAllVirtual = true; foreach ($orderGoods as &$orderGood) { if (isset($orderGood['_goodsSnapshot'])) { if (!$orderGood['_goodsSnapshot']['isVirtual']) { $isAllVirtual = false; break; } } } $order['_isAllVirtual'] = $isAllVirtual; return $order; } public static function isGoodsStockValid($goodsId, $amount = 1, $spec = null) { if (self::isSpecGoods($goodsId)) { if (empty($spec)) { return false; } $goodsSpec = ModelUtil::getWithLock('goods_spec', ['goodsId' => $goodsId, 'spec' => $spec]); if (empty($goodsSpec)) { return false; } if ($goodsSpec['stock'] < $amount) { return false; } } else { $goods = ModelUtil::getWithLock('goods', ['id' => $goodsId]); if (empty($goods)) { return false; } if ($goods['stock'] < $amount) { return false; } } return true; } public static function deleteCart($memberUserId, $cartId) { ModelUtil::delete('cart', ['id' => $cartId, 'memberUserId' => $memberUserId]); } } 