
DROP TABLE IF EXISTS `cmseasy_archive`;-- 
CREATE TABLE `cmseasy_archive` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `catid` int(6) NOT NULL,
  `typeid` int(6) NOT NULL,
  `title` varchar(255) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `tag` varchar(255) DEFAULT NULL,
  `username` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL,
  `view` int(11) NOT NULL DEFAULT '0',
  `color` char(20) DEFAULT NULL,
  `strong` tinyint(1) DEFAULT '0',
  `toppost` tinyint(1) DEFAULT '0',
  `font` char(6) DEFAULT NULL,
  `spid` int(11) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `mtitle` varchar(255) DEFAULT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `description` text,
  `listorder` int(11) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  `author` varchar(20) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `state` tinyint(2) DEFAULT '1',
  `checked` tinyint(2) DEFAULT '0',
  `introduce` text,
  `introduce_len` int(5) NOT NULL,
  `content` mediumtext,
  `template` varchar(50) DEFAULT NULL,
  `templatewap` varchar(50) DEFAULT NULL,
  `showform` varchar(50) DEFAULT NULL,
  `htmlrule` varchar(100) DEFAULT NULL,
  `ishtml` tinyint(2) DEFAULT '0',
  `iswaphtml` tinyint(2) DEFAULT '0',
  `linkto` varchar(255) DEFAULT '',
  `attr1` varchar(20) DEFAULT NULL,
  `attr2` varchar(20) DEFAULT NULL,
  `attr3` varchar(255) DEFAULT '',
  `comment_num` int(11) DEFAULT '0',
  `attachment_id` varchar(50) DEFAULT NULL,
  `attachment_path` varchar(150) DEFAULT NULL,
  `grade` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pics` text,
  `type` char(10) NOT NULL,
  `province_id` int(3) NOT NULL,
  `city_id` int(3) DEFAULT NULL,
  `section_id` int(3) DEFAULT NULL,
  `outtime` date NOT NULL,
  `my_size` varchar(100) DEFAULT NULL,
  `my_zhaopinbumen` varchar(100) DEFAULT NULL,
  `my_jobtype` varchar(10) DEFAULT NULL,
  `my_jobtitle` varchar(100) DEFAULT NULL,
  `my_jobnumber` varchar(100) DEFAULT NULL,
  `my_jobgender` varchar(10) DEFAULT NULL,
  `my_jobwork` text,
  `my_jobacademic` varchar(10) DEFAULT NULL,
  `my_jobage` varchar(100) DEFAULT NULL,
  `my_jobworkareas` varchar(100) DEFAULT NULL,
  `my_jobrequirements` text,
  `my_contactname` varchar(100) DEFAULT NULL,
  `my_vr` varchar(100) DEFAULT NULL,
  `isecoding` tinyint(1) unsigned DEFAULT '0',
  `ecoding` varchar(255) DEFAULT NULL,
  `iscomment` tinyint(1) DEFAULT '1',
  `updatedate` datetime DEFAULT NULL COMMENT '修改时间',
  `my_field` varchar(255) DEFAULT NULL COMMENT '商品信息字段',
  `praise` varchar(255) DEFAULT NULL,
  `salesnum` int(11) DEFAULT NULL,
  `langid` int(11) DEFAULT NULL,
  `inventory` int(11) NOT NULL DEFAULT '0',
  `readmenoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '阅读收费',
  `domwmenoy` decimal(10,2) NOT NULL COMMENT '下载收费',
  `combined` varchar(500) DEFAULT NULL COMMENT '组合商品',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`),
  KEY `keyword` (`keyword`),
  KEY `title` (`title`),
  KEY `type` (`type`),
  KEY `catid` (`typeid`),
  KEY `typeid` (`catid`),
  KEY `tag` (`tag`)
) ENGINE=MyISAM AUTO_INCREMENT=140 DEFAULT CHARSET=utf8;-- 

DROP TABLE IF EXISTS `cmseasy_b_category`;-- 
CREATE TABLE `cmseasy_b_category` (
  `catid` int(6) NOT NULL AUTO_INCREMENT,
  `parentid` int(6) NOT NULL,
  `catname` varchar(255) NOT NULL,
  `subtitle` varchar(255) DEFAULT '',
  `scategory` varchar(50) DEFAULT NULL,
  `listorder` int(11) DEFAULT NULL,
  `image` varchar(150) DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `keyword` varchar(150) DEFAULT NULL,
  `description` text,
  `categorycontent` mediumtext,
  `htmldir` varchar(50) NOT NULL,
  `template` varchar(50) DEFAULT NULL,
  `listtemplate` varchar(50) DEFAULT NULL,
  `showtemplate` varchar(50) DEFAULT NULL,
  `showform` varchar(50) DEFAULT NULL,
  `templatewap` varchar(50) DEFAULT NULL,
  `listtemplatewap` varchar(50) DEFAULT NULL,
  `showtemplatewap` varchar(50) DEFAULT NULL,
  `htmlrule` varchar(100) DEFAULT NULL,
  `listhtmlrule` varchar(100) DEFAULT NULL,
  `showhtmlrule` varchar(100) DEFAULT NULL,
  `module` varchar(16) NOT NULL DEFAULT 'article',
  `isshow` tinyint(2) DEFAULT '1',
  `ishtml` tinyint(2) DEFAULT '0',
  `iswaphtml` tinyint(2) DEFAULT '0',
  `ispages` tinyint(2) DEFAULT NULL,
  `includecatarchives` tinyint(2) DEFAULT '0',
  `addarcenable` tinyint(2) DEFAULT NULL,
  `linkto` varchar(150) DEFAULT NULL,
  `attr1` varchar(20) DEFAULT NULL,
  `attr2` varchar(20) DEFAULT NULL,
  `attr3` varchar(20) DEFAULT NULL,
  `thumb` varchar(100) DEFAULT NULL,
  `thumb_width` int(3) DEFAULT NULL,
  `thumb_height` int(3) DEFAULT NULL,
  `isnav` tinyint(1) DEFAULT NULL,
  `ismobilenav` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `isecoding` tinyint(1) unsigned DEFAULT '0',
  `ecoding` varchar(255) DEFAULT NULL,
  `nofollow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '控制nofollow',
  `isblank` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设置新窗口打开',
  `contentrank` varchar(255) DEFAULT '',
  `isshopping` tinyint(1) NOT NULL DEFAULT '0',
  `langid` int(11) DEFAULT NULL,
  `readmenoy` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '阅读收费',
  `domwmenoy` decimal(10,2) NOT NULL COMMENT '下载收费',
  PRIMARY KEY (`catid`),
  UNIQUE KEY `category` (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;-- 


INSERT INTO `cmseasy_archive` VALUES('128','71','0','我们的客户十二','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:25:25','admin','','/html/upload/images/201902/img61.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASY2YiRx7DOqq5nbYT838','1','2019-02-27 15:25:25','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('129','71','0','我们的客户十一','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:26:05','admin','','/html/upload/images/201902/img62.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYAUpfCpFm5B2ABha521','1','2019-02-27 15:26:05','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('130','71','0','我们的客户十','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:26:20','admin','','/html/upload/images/201902/img63.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYu3xOSYqjHyPmDPS787','1','2019-02-27 15:26:20','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('131','71','0','我们的客户九','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:26:35','admin','','/html/upload/images/201902/img64.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYMxYJlEnpEnIkGKm466','1','2019-02-27 15:26:35','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('132','71','0','我们的客户八','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:26:51','admin','','/html/upload/images/201902/img65.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYfrYm3Ej2IoKz1S2598','1','2019-02-27 15:26:51','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('133','71','0','我们的客户七','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:27:08','admin','','/html/upload/images/201902/img66.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYrTPMnkyWlvO6swE166','1','2019-02-27 15:27:08','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('134','71','0','我们的客户六','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:27:20','admin','','/html/upload/images/201902/img61.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYSBxuDXCTLImO4pr795','1','2019-02-27 15:27:20','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('135','71','0','我们的客户五','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:27:33','admin','','/html/upload/images/201902/img62.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYXN88zsoz7fxP7DT731','1','2019-02-27 15:27:33','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('136','71','0','我们的客户四','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:27:47','admin','','/html/upload/images/201902/img63.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYjHchFW4wgY3gWEu182','1','2019-02-27 15:27:47','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('137','71','0','我们的客户三','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:28:00','admin','','/html/upload/images/201902/img64.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYNMX8F9Q9Pws8sLO647','1','2019-02-27 15:28:00','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('138','71','0','我们的客户二','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:28:18','admin','','/html/upload/images/201902/img65.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYC0kHk271tCshnbO691','1','2019-02-27 15:28:18','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('139','71','0','我们的客户一','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:28:34','admin','','/html/upload/images/201902/img66.jpg','1','1','','0','','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYGTr5A5fQYDhUY7w286','1','2019-02-27 15:28:34','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('117','62','0','国际海上运输','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 16:53:34','admin','','/html/upload/images/201902/img11.jpg','1','1','国际海上货物运输是指承运人按照海上货物运输合同的约定，以海运船舶作为运载工具，以收取运费作为报酬，将托运人托运的货物经海路由一国港口运送至另一国港口的行为。国际海运（International Ocean Freight）是国际贸易中最主要的运输方式，国际贸易总运量中的三分之二以上，我国绝大部分进出口货物，都是通过海洋运输方式运输的。当中国海运业在世界海运中占据一席之地时，它的优、劣势也在全球化竞争洪流中暴露无遗，而这正是中国港航企业发展模式进行战略性转变需正视和重视的现实。我国海运业在世界海运发展中的优势','0','<p>国际海上货物运输是指承运人按照海上货物运输合同的约定，以海运船舶作为运载工具，以收取运费作为报酬，将托运人托运的货物经海路由一国港口运送至另一国港口的行为。</p><p>国际海运（International Ocean Freight）是国际贸易中最主要的运输方式，国际贸易总运量中的三分之二以上，我国绝大部分进出口货物，都是通过海洋运输方式运输的。</p><p>当中国海运业在世界海运中占据一席之地时，它的优、劣势也在全球化竞争洪流中暴露无遗，而这正是中国港航企业发展模式进行战略性转变需正视和重视的现实。我国海运业在世界海运发展中的优势</p><p>根据国际货币基金组织预测，2006年国际经济走势仍将保持平稳增长，美国和全球将分别有3.6%和4.3%的增长率，而我国GDP增长速度也将保持在8.5%以上。<br/></p><p>经济强势带动了世界贸易量的上升。2003年国际贸易总值为15.35万亿美元，而2004年就上升到18.58万亿美元，提高了21%。2005年达21.1462万亿美元。在国际贸易中，“中国因素”是最大亮点。2004年我国进出口、出口和进口值分别为11547.4亿美元、5933.6亿美元和5613.8亿美元，分别增长了35.7%、35.4%和36%，进出口总值首次超过了1万亿美元的水平。2005年货物进出口贸易额达到14221亿美元，进口和出口值均占世界第三位。另外，中国占世界贸易的比重有所上升，出口比重由2004年的6.5%上升到7.3%，增加了0.8个百分点；进口比重由5.9%上升到6.1%，增加0.2个百分点。我国进出口外贸呈现良好的增长势头，在国际贸易中继续扮演着重要角色。</p><p>国际干散货市场2001年10月份BDI指数下跌到845点，为全年的最低点。2002年指数稍微有些上扬，但涨幅不大，年底收于1731点。2003年下半年，出现大幅度上涨，10月份飙升到4470点，年底收于4467点。2004年保持良好的增长势头，全年最高点达到6101点，年底收于4438点。2005年3月份为全年最高点4956点，年底收于2321点。从2002年开始，干散货整体运量呈现加速上升势头。由于全球经济发展对于大宗基础原材料需求很大，像铁矿石、煤炭等运量增长很快，而其中中国作为全球经济发展最快的国家之一，起了非常大的作用。近10年我国大宗干散货海运量年均增长率为17%，大大高于国际市场水平，而世界干散货航运市场70%的增量来自于中国。以铁矿石为例，2003年我国进口量达到1.48亿吨，占全球海运量的28.5%。2004年全球铁矿石海运量为6亿吨，我国进口了2.08亿吨，占34.6%。2005年受国家调控影响，增长速度有所下降，但仍有新增需求6000万吨，全年进口量达到2.48亿吨，增长率为20%左右。可以预计，在中国这个巨大引擎的带动下，国际干散货航运市场2006年仍将保持持续增长，年平均增长率将达到6%。</p><p>石油运输方面，世界经济对于石油依存度很高。据专家计算，全球经济每增长1%，将每天需要40万桶石油的支持。而作为石油运输的主要方式，水路运输完成了92%的油品贸易。2003年全球原油海运量为16亿吨，2004年进一步提高，预计2005-2007年国际原油海运量平均增长速度为3%左右。我国近几年石油需求大幅上升，2004年已经成为世界第二大石油消费国和进口国。2003年我国进口原油9112万吨，占全球原油贸易量的5.4%，2004年进口原油1.22亿吨，首次突破了1亿吨大关。2005年原油消费量超过3亿吨，供需缺口将进一步拉大，2005年原油进口量达到1.27亿吨。预计未来几年我国对于石油的需求将保持较高速度增长，对于国际石油海运将起到越来越大的影响。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img11.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img12.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img13.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYKQGj1CGv5EU5gqO769','1','2019-02-27 16:53:34','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('118','64','0','国内海上运输','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 16:53:34','admin','','/html/upload/images/201902/img12.jpg','1','1','国际干散货市场2001年10月份BDI指数下跌到845点，为全年的最低点。2002年指数稍微有些上扬，但涨幅不大，年底收于1731点。2003年下半年，出现大幅度上涨，10月份飙升到4470点，年底收于4467点。2004年保持良好的增长势头，全年最高点达到6101点，年底收于4438点。2005年3月份为全年最高点4956点，年底收于2321点。从2002年开始，干散货整体运量呈现加速上升势头。由于全球经济发展对于大宗基础原材料需求很大，像铁矿石、煤炭等运量增长很快，而其中中国作为全球经济发展最快的国家之一，起了非常大的作用。近10年我国大宗干散货海运量年均增长率为17%，大大高于国际市场水平，而世界干散货航运市场70%的增量来自于中国。以铁矿石为例，2003年我国进口量达到1.48亿吨，占全球海运量的28.5%。2004年全球铁矿石海运量为6亿吨，我国进口了2.08亿吨，占34.6%。2005年受国家调控影响，增长速度有所下降，但仍有新增需求6000万吨，全年进口量达到2.48亿吨，增长率为20%左右。可以预计，在中国这个巨大引擎的带动下，国际干散货航运市场2006年仍将保持持续增长，年平均增长率将达到6%。','0','<p>国际干散货市场2001年10月份BDI指数下跌到845点，为全年的最低点。2002年指数稍微有些上扬，但涨幅不大，年底收于1731点。2003年下半年，出现大幅度上涨，10月份飙升到4470点，年底收于4467点。2004年保持良好的增长势头，全年最高点达到6101点，年底收于4438点。2005年3月份为全年最高点4956点，年底收于2321点。从2002年开始，干散货整体运量呈现加速上升势头。由于全球经济发展对于大宗基础原材料需求很大，像铁矿石、煤炭等运量增长很快，而其中中国作为全球经济发展最快的国家之一，起了非常大的作用。近10年我国大宗干散货海运量年均增长率为17%，大大高于国际市场水平，而世界干散货航运市场70%的增量来自于中国。以铁矿石为例，2003年我国进口量达到1.48亿吨，占全球海运量的28.5%。2004年全球铁矿石海运量为6亿吨，我国进口了2.08亿吨，占34.6%。2005年受国家调控影响，增长速度有所下降，但仍有新增需求6000万吨，全年进口量达到2.48亿吨，增长率为20%左右。可以预计，在中国这个巨大引擎的带动下，国际干散货航运市场2006年仍将保持持续增长，年平均增长率将达到6%。</p><p>石油运输方面，世界经济对于石油依存度很高。据专家计算，全球经济每增长1%，将每天需要40万桶石油的支持。而作为石油运输的主要方式，水路运输完成了92%的油品贸易。2003年全球原油海运量为16亿吨，2004年进一步提高，预计2005-2007年国际原油海运量平均增长速度为3%左右。我国近几年石油需求大幅上升，2004年已经成为世界第二大石油消费国和进口国。2003年我国进口原油9112万吨，占全球原油贸易量的5.4%，2004年进口原油1.22亿吨，首次突破了1亿吨大关。2005年原油消费量超过3亿吨，供需缺口将进一步拉大，2005年原油进口量达到1.27亿吨。预计未来几年我国对于石油的需求将保持较高速度增长，对于国际石油海运将起到越来越大的影响。</p><p>集装箱运输方面，在太平洋航线和亚欧航线的带动下，从2002年开始集装箱贸易量有了快速增长。2003年国际集装箱贸易总量为7900万TEU，同比增长8.2%，2004年增长幅度上升到11%，为8770万TEU。2005年太平洋航线运量将上升12%，亚欧航线增长15%，而大西洋航线保持稳定，增幅不大，2005年整体集装箱运量将在原有基础上提高10%左右。我国集装箱海运量占世界总量的20%左右，在太平洋东行航线和亚欧西行航线上更是占有60%以上的运量。我国2005年集装箱吞吐量达到7580万TEU，增长率达到23.7%，高于世界平均水平。</p><p>从船队建设看</p><p>全球1000总吨以上干散货船5700艘，共29634.8万载重吨，分布在数百个船公司。中国船公司拥有579艘，2440.5万载重吨；香港地区船公司拥有261艘，1819万载重吨。中国和香港地区共有运力4259.6万载重吨，占世界14.4%。我国从事国际航运的船公司已达231家，总运力达到2210多万载重吨，居世界第九位。我国航运企业在国外设立的独资、合资航运企业和办事机构已达数百家，承运的第三国货物比重日益提高。。</p><p>在国际海运中运输的货物，种类繁多，针对不同类型的货物而采用运输货物的船舶类型、装卸设备也就不同。七海针对具体货物从船型、装卸设备两方面介绍如何运送超大件货物。</p><p>1． 卡车。卡车的运输采用PCTC（PURE CAR TRUCK CARRIER），其主要特点是采用单层甲板（一般高度在3－4米之间）舱内可以容纳大型卡车，其船舶尾跳最大载重量可达45吨，每平方米载重量可达3吨，因此可以允许超重卡车通过船舶尾跳进入船舱。</p><p>2． 大型设备。一般来讲，大型设备的运输比较复杂，有些部件体积较大，吨位较大，不能采用一般的集装箱运输，而有些零配件可采用集装箱运输。这种设备一般采用RORO AND CONTAINER 这种船型，可以同时装载大型部件和集装箱，因此是众多大型设备运输所选择的理想船型。</p><p>那么这种船型配备哪些装卸设备比较合理呢？</p><p>BOLSTER FLATBED 这种设备适用于长4米以内、重28吨以内的大型部件。由吊车将货物吊到平板上，起吊高度不超过一米，（可避免货物在起吊过程中因摆动、翻转所引起的货物损坏），然后用特制尼龙带（其刚性等同于钢丝绳，但相对于钢丝绳来说可大大减轻其对货物表面的磨损）或钢丝绳加垫片，将货物固定在平板上，由叉车通过船舶尾跳将货物运进船舱。</p><p>ROLLTRAILER 这种设备适用于运输超重、超大货物，理论上可以承载25米长、重达120吨的货物，但由于受到尾跳承载能力与拖头的运输能力的限制，实际的承载能力会偏小一些。ROLLTRAILER由自代拖头通过船舶尾跳运进舱内，可以实现货物的零破损。</p><p>3． 火车车厢。由于火车车箱较长，有40米长所以采用一般的ROLLTRAILER运输会由于舱口的限制，车身无法旋转装进舱内。SPECIALDESIGNED TRAILERS（特殊轮胎转向架）可以解决这个问题，该设备轮胎可以实现360度旋转，可通过船舶尾跳进舱时掉头运进舱内。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:3:{i:1;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img12.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img13.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img14.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYE2DKoPSvFXugsp1302','1','2019-02-27 16:53:34','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('119','64','0','国际航空运输','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 16:53:35','admin','','/html/upload/images/201902/img13.jpg','1','1','航空运输是指使用飞机、直升机及其他航空器运送人员、货物、邮件的一种运输方式。旅客、行李、货物和邮件的始发、中途和终点站 有一点在一国境外的航空运输。主要在国际航线上 进行。国际航线是通过政府间的双边航空运输协定 建立的。在运输过程中为保证国际航行的安全和效 益，必须按统一的程序和规则进行广泛的国际合作 和协调。国际民用航空组织和地区性民用航空组织 在国际航空运输中发挥了重要作用。中国的国际航 空运输始于1950年7&#039;月，当时和前苏联合办的中苏 民用航空公司开辟了北京为始发点到前苏联赤塔、 伊尔库茨克和阿拉木图三条国际航线。','0','<p>航空运输是指使用飞机、直升机及其他航空器运送人员、货物、邮件的一种运输方式。旅客、行李、货物和邮件的始发、中途和终点站 有一点在一国境外的航空运输。主要在国际航线上 进行。国际航线是通过政府间的双边航空运输协定 建立的。在运输过程中为保证国际航行的安全和效 益，必须按统一的程序和规则进行广泛的国际合作 和协调。国际民用航空组织和地区性民用航空组织 在国际航空运输中发挥了重要作用。中国的国际航 空运输始于1950年7&#39;月，当时和前苏联合办的中苏 民用航空公司开辟了北京为始发点到前苏联赤塔、 伊尔库茨克和阿拉木图三条国际航线。&nbsp;</p><p>航空运输始于1871年。当时普法战争中的法国人用气球把政府官员和物资、邮件等运出被普军围困的巴黎。1918年5月5日，飞机运输首次出现，航线为纽约-华盛顿-芝加哥。同年6月8日，伦敦与巴黎之间开始定期邮政航班飞行。30年代有了民用运输机，各种技术性能不断改进，航空工业的发展促进航空运输的发展。第二次世界大战结束后，在世界范围内逐渐建立了航线网，以各国主要城市为起讫点的世界航线网遍及各大洲。1990年，世界定期航班完成总周转量达2356.7亿吨千米。</p><p>1．托运人托运货物应向承运人填交货物运输单，并根据国家主管部门规定随附必要的有效证明文件。托运人应对运输单填写内容的真实性和正确性负责。托运人填交的货物运输单经承运人接受，并由承运人填发货物运输单后，航空货物运输合同即告成立。</p><p>2．托运人要求包用飞机运输货物，应填交包机申请书，经承运人同意接受并签订包机运输协议书以后，航空包机货物运输合同即告成立，签订协议书的当个人，均应遵守民航主管机关有关包机运输的规定。</p><p>3．托运人对运输的货物，应当按照国家主管部门规定的包装标准包装；没有统一规定包装标准的，托运人应当根据保证运输安全的原则，按货物的性质和承载飞机等条件包装。凡不符合上述包装要求的，承运人有权拒绝承运不符合规格的货物。</p><p>4．托运人必须在托运的货物上标明发站、到站和托运人、收货人的单位。姓名和地址，按照国家规定标明包装储运指标标志。</p><p>5．国家规定必须保险的货物，托运人应在托运时投保货物运输险。</p><p>6．托运人托运货物，应按照民航主管机关规定的费率缴付运费和其他费用。除托运人和承运人另有协议外，运费及其他费用一律于承运入开具货物运单时一次付清。</p><p>7．承运人应于货物运达到货地点后二十四小时内向收货人发出到货通知、收货人应及时凭提货证明到指定地点提取货物，货物从发出到货通知的次日起，免费保管三月。收货人逾期提取，应按运输规则缴讨保管费。</p><p>8．收货人在提取货物时，对货物半途而废或重量无异议，并在货物运输单上签收，承运人即解除运输责任。</p><p>9．因承运入的过失或故意造成托运人或收货人损失，托运人或收货人要求赔偿，应在填写货物运输事故记录的次日起一百八十日内，以书面形式向承运人提出，并附有关证明文件。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:4:{i:1;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img13.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img14.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img15.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img16.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYaItLV1pjDLWDtw9259','1','2019-02-27 16:53:35','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('120','63','0','国内航空运输','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 16:53:36','admin','','/html/upload/images/201902/img14.jpg','1','1','技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地面导航设施建立的走廊式保护空域，是飞机航线飞行的领域。其划定是以连接各个地面导航设施的直线为中心线，在航路范围内规定上限高度、下限高度和宽度。对在其范围内飞行的飞机，要实施空中交通管制。航空港是民用飞机场及有关服务设施构成的整体，是飞机安全起降的基地，也是旅客、货物、邮件的集散地。飞机是主要载运工具。机型选用根据所飞航线的具体情况和考虑整体经济技术性能而定。通信导航设施是沟通信息、引导飞机安全飞行并到达目的地安全着陆（见航空领航）的设施。','0','<p>技术设备是实现航空运输的物质基础。主要包括航路、航空港、飞机和通信导航设施等。航路是根据地面导航设施建立的走廊式保护空域，是飞机航线飞行的领域。其划定是以连接各个地面导航设施的直线为中心线，在航路范围内规定上限高度、下限高度和宽度。对在其范围内飞行的飞机，要实施空中交通管制。航空港是民用飞机场及有关服务设施构成的整体，是飞机安全起降的基地，也是旅客、货物、邮件的集散地。飞机是主要载运工具。机型选用根据所飞航线的具体情况和考虑整体经济技术性能而定。通信导航设施是沟通信息、引导飞机安全飞行并到达目的地安全着陆（见航空领航）的设施。</p><p>基于航空运输对发展国民经济和促进国际交往的重要意义，多数国家都很重视发展航空运输事业。政府设立专门机构进行管理，如中国设立民用航空总局，美国设联邦航空局，前苏联设民用航空部等；实行多种优惠政策支持航空运输企业的发展，如政府直接投资、贷款、减免捐税、给予财政补贴等。</p><p>航空运输企业经营的形式主要有班期运输、包机运输和专机运输。通常以班期运输为主，后两种是按需要临时安排。班期运输是按班期时刻表，以固定的机型沿固定航线、按固定时间执行运输任务。当待运客货量较多时，还可组织沿班期运输航线的加班飞行。航空运输的经营质量主要从安全水平、经济效益和服务质量3方面予以评价。<br/></p><p>航空运输始于1871年。当时普法战争中的法国人用气球把政府官员和物资、邮件等运出被普军围困的巴黎。1918年5月5日，飞机运输首次出现，航线为纽约-华盛顿-芝加哥。同年6月8日，伦敦与巴黎之间开始定期邮政航班飞行。30年代有了民用运输机，各种技术性能不断改进，航空工业的发展促进航空运输的发展。第二次世界大战结束后，在世界范围内逐渐建立了航线网，以各国主要城市为起讫点的世界航线网遍及各大洲。1990年，世界定期航班完成总周转量达2356.7亿吨千米。<br/></p><p>货物重量按毛重计算。计算单位为公斤。重量不足1公斤，按1公斤算，超过1公斤的尾数四舍五入。<br/></p><p>非宽体飞机装载的每件货物重量一般不超过80公斤，体积一般不超过40*60*100米。宽体飞机装载每件货物重量一般不超过250公斤。体积一般不超过250*200*160厘米。超过以上重量和体积的货物，由西北公司依据具体条件确定可否收运。<br/></p><p>每件货物的长、宽、高之和不得少于40厘米．<br/></p><p>每公斤的体积超过6000立方厘米的货物按轻泡货物计重。轻泡货物以每6000立方厘米折合1公斤计量。<br/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:4:{i:1;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img14.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img15.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img16.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img11.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYtds17nV7esGc9wP931','1','2019-02-27 16:53:36','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('121','63','0','国际陆运','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 16:53:37','admin','','/html/upload/images/201902/img15.jpg','1','1','运输是指用特定的设备和工具，将物品从一个地点向另一个地点运送的物流活动，它是在不同地域范围内，以改变物的空间位置为目的对物进行的空间位移。通过这种位移创造商品的空间效益，实现其使用价值,满足社会的不同需要。运输是物流的中心环节之一，也是现代物流活动最重要的一个功能。 运输是一个汉语词汇，意思是yùn shū，意思是用交通工具把物资运到另一地方，是实现人和物空间位置变化的活动。物流的运输则专指“物”的载运及输送。它是在不同地域范围间（如两个城市.两个工厂之间，或一大企业内相距较远的两车之间），以改变“物”的空间位置为目的的活动，是对“物”进行的空间位移。','0','<p>运输是指用特定的设备和工具，将物品从一个地点向另一个地点运送的物流活动，它是在不同地域范围内，以改变物的空间位置为目的对物进行的空间位移。通过这种位移创造商品的空间效益，实现其使用价值,满足社会的不同需要。运输是物流的中心环节之一，也是现代物流活动最重要的一个功能。&nbsp;</p><p>运输是一个汉语词汇，意思是yùn shū，意思是用交通工具把物资运到另一地方，是实现人和物空间位置变化的活动。</p><p>物流的运输则专指“物”的载运及输送。它是在不同地域范围间（如两个城市.两个工厂之间，或一大企业内相距较远的两车之间），以改变“物”的空间位置为目的的活动，是对“物”进行的空间位移。</p><p>运输一般分为运输和配送。关于运输和配送的区分，有许多不同的观点，可以这样来说，所有物品的移动都是运输，而配送则专指短距离、小批量的运输。因此，可以说运输是指整体，配送则是指其中的一部分，而且配送的侧重点在于一个&#39;&#39;配&#39;&#39;字，它的主要意义也体现在&#39;&#39;配&#39;&#39;字上；而&#39;&#39;送&#39;&#39;是为最终实现资源配置的&#39;&#39;配&#39;&#39;而服务的。</p><p>运输功能要素。包括供应及销售物流中的车、船、飞机等方式的运输，生产物流中的管道、传送带等方式的运输。</p><p>运输是指把人.财.物由一个地方转移到另外一个地方的过程.运输又被认为是国民经济的根本．</p><p>运输的主要工具有自行车.板车.三轮车.摩托车.汽车.火车.飞机.轮船.宇宙飞船.火箭.等等</p><p>运输按服务对象不同分为客运和货运</p><p>公共运输,泛指所有收费提供交通服务的运输方式。</p><p>轿车托运:(轿车运输)是指将汽车做为商品出厂后,通过大型汽车运输工具,到达指定地方的运输方式&lt;/CN&gt;</p><p>运输运价的构成</p><p>发到基价，运行基价构成，货物运输杂费</p><p>零担货物年车运价=每吨运价×计费重量</p><p>整车货物每吨运价= 发到基价+运行基价×运价里程</p><p>集装箱货物每箱运价= 发到基价+运行基价×运价里程</p><p>货物运输有保值作用。也就是说，任何产品从生产出来到最终消费，都必须经过一段时间、一段距离，在这段时间和距离过程中，都要经过运输、保管、包装、装卸搬运等多环节、多次数的货物运输活动。在这个过程中，产品可能会淋雨受潮、水浸、生锈、破损、丢失等。货物运输的使命就是防止上述现象的发生，保证产品从生产者到消费者移动过程中的质量和数量，起到产品的保值作用，即保护产品的存在价值，使该产品在到达消费者时使用价值不变。</p><p><br/></p><p class=\"title-text\" style=\"margin: 0px; padding: 0px; font-size: 18px; font-weight: 400;\"><span style=\"font-size: 16px;\">搞好运输，能够节约自然资源、人力资源和能源，同时也能够节约费用。比如，集装箱化运输，可以简化商品包装，节省大量包装用纸和木材；实现机械化装卸作业，仓库保管自动化，能节省大量作业人员，大幅度降低人员开支。重视货物运输可节约费用的事例比比皆是。被称为&quot;中国货物运输管理觉醒第一人&quot;的海尔企业集团，加强运输管理，建设起现代化的国际自动化货物运输中心，一年时间将库存占压资金和采购资金，从15亿元降低到7亿元，节省了8亿元开支。</span><br/></p><p>货物运输可以克服时间间隔、距离间隔和人的间隔，这自然也是货物运输的实质。现代化的货物运输在缩短<br/></p><p>距离方面的例证不胜枚举。在北京可以买到世界各国的新鲜水果，全国各地的水果也常年不断；邮政部门改善了货物运输，使信件大大缩短了时间距离，全国快递两天内就到美国联邦快递，能做到隔天送达亚洲15个城市；日本的配送中心可以做到，上午10点前订货、当天送到。这种运输速度，把人们之间的地理距离和时间距离一下子拉得很近。随着货物运输现代化的不断推进，国际运输能力大大加强，极大地促进了国际贸易，使人们逐渐感到这个地球变小了，各大洲的距离更近了。<br/></p><p>城市里的居民不知不觉地享受到货运进步的成果。南方产的香蕉全国各大城市一年四季都能买到；新疆的哈密瓜、宁夏的白兰瓜、东北大米、天津小站米等都不分季节地供应市场；则是国际运输业发达，国际运费降低的缘故。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:4:{i:1;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img15.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img16.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img11.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img12.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASY8W8FDgLhJUVu326181','1','2019-02-27 16:53:37','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('122','63','0','国内陆运','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 17:25:27','admin','','/html/upload/images/201902/img16.jpg','1','1','一、运输具有生产的本质属性运输的生产过程是以一定的生产关系联系起来的、具有劳动技能的人们使用劳动工具（如车、船、飞机及其他设施）和劳动对象（货物和旅客）进行生产，并创造产品的生产过程。运输的产品，对旅客运输来说，是人的空间位移；对货物运输来说，是货物的空间位移。显然，运输是以改变“人和物”的空间位置为目的的生产活动，这一点和通常意义下以改变劳动对象物理、化学、生物属性为主的工农业生产不同。二、运输生产是在流通过程中完成的','0','<p>一、运输具有生产的本质属性</p><p>运输的生产过程是以一定的生产关系联系起来的、具有劳动技能的人们使用劳动工具（如车、船、飞机及其他设施）和劳动对象（货物和旅客）进行生产，并创造产品的生产过程。运输的产品，对旅客运输来说，是人的空间位移；对货物运输来说，是货物的空间位移。显然，运输是以改变“人和物”的空间位置为目的的生产活动，这一点和通常意义下以改变劳动对象物理、化学、生物属性为主的工农业生产不同。</p><p><br/></p><p>二、运输生产是在流通过程中完成的</p><p>运输是把产品从生产地运往消费地的活动，因此从整个社会生产过程来说，运输是在流通领域内继续的生产过程，并在其中完成。</p><p><br/></p><p>三、运输产品是无形的</p><p>运输生产不像工农业生产那样改变劳动对象的物理、化学性质和形态，而只改变劳动对象的空间位置，并不创造新的实物形态产品。因此，在满足社会运输需求的情况下，多余的运输产品或运输支出，都是一种浪费。</p><p><br/></p><p>四、运输产品属于边生产边消费</p><p>工农业产品的生产和消费在时间和空间上可以完全分离，而运输产品的生产和消费不论在时间和空间上都是不可分离地结合在一起的，属于边生产边消费。</p><p><br/></p><p>五、运输产品的非储存性</p><p>由于运输产品是无形的，不具有物质实体，又由于它的边生产边消费属性。因此运输产品既不能调拨，也不能存储。</p><p><br/></p><p>六、运输产品的同一性</p><p>对不同的运输方式来说，虽然他们使用不同的运输工具，具有不同的技术经济特征，在不同的线路上进行运输生产活动，但它们对社会具有相同的效用，即都实现了物品的空间位移。运输产品的同一性使得各种运输方式之间可以相互补充、协调、替代，形成一个有效的综合运输系统。</p><p><br/></p><p>1、运输是物流的主要功能要素之一</p><p>按物流的概念，物流是“物”的物理性运动，这种运动不但改变了物的时间状态，也改变了物的空间状态。而运输承担了改变空间状态的主要任务，运输是改变空间状态的主要手段，运输再配以搬运、配送等活动，就能圆满完成改变空间状态的全部任务。</p><p>2、运输是社会物质生产的必要条件之一</p><p>3、运输可以创造“场所效用”</p><p>场所效用的含义是：同种“物”由于空间场所不同，其使用价值的实现程度则不同，其效益的实现也不同。由于改变场所而最大发挥使用价值，最大限度提高了投入产出比，这就称之为“场所效用”。通过运输，将“物”运到场所效用最高的地方，就能发挥“物”的潜力，实现资源的优化配置。从这个意义来讲，也相当于通过运输提高了物的使用价值。</p><p>4、运输是“第三利润源”的主要源泉。</p><p><br/></p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','a:4:{i:1;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img16.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:2;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img11.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:3;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img12.jpg\";s:3:\"alt\";s:9:\"undefined\";}i:4;a:2:{s:3:\"url\";s:36:\"/html/upload/images/201902/img13.jpg\";s:3:\"alt\";s:9:\"undefined\";}}','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYqvAWUMzIM2w2K9q290','1','2019-02-27 17:25:27','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('123','70','0','无人便利店风口正当时，“便利家”获联创永宣冯涛数百万元天使投资','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:05:18','admin','','/html/upload/images/201902/15512511376125.jpg','1','1','6氪获悉，无人便利店“便利家”已获得数百万人民币天使轮投资，资方为联创永宣冯涛。无人便利店风口正当时，缤果盒子、F5未来商店、深兰科技、Easy Go等一众玩家云集，亚马逊、罗森、阿里巴巴、沃尔玛等巨头亦纷纷试水。“便利家”创立于2017年3月，位于上海。便利家有微型无人便利店和中型无人便利店两款产品，和一众玩家相比，便利家的差异化在于：灵活。便利家的“微型无人便利店”，最小单位占地面积不到1平方','0','<p>6氪获悉，无人便利店“便利家”已获得数百万人民币天使轮投资，资方为联创永宣冯涛。</p><p>无人便利店风口正当时，缤果盒子、F5未来商店、深兰科技、Easy Go等一众玩家云集，亚马逊、罗森、阿里巴巴、沃尔玛等巨头亦纷纷试水。&nbsp;</p><p>“便利家”创立于2017年3月，位于上海。便利家有微型无人便利店和中型无人便利店两款产品，和一众玩家相比，便利家的差异化在于：灵活。&nbsp;</p><p>便利家的“微型无人便利店”，最小单位占地面积不到1平方米（0.68平方米），投放地点更加灵活，包括地铁站、写字楼、高校等，一个最小单位便利店的成本约为1.3万元（批量化生产后可能更低）。最小单位的无人便利店，可以根据人流量的分布，“拼”起来更大单位面积的便利店。低于100人，可放置一个；100人左右，可以拼两个；大于500人，可以拼四个。便利家的“中型无人便利店”，是由6个微型便利店拼起来的，同时在空间里增设桌椅，为消费者提供休憩区间，可放置在地理位置相对开阔的小区、公园等。</p><p>技术上，便利家在每一层货架中设置了RFID，并在各个角落缝隙做了密封屏蔽，让识别率更高。流程很简单，用支付宝扫码开门，拿完即走，支付宝自动扣款（微信正在洽谈中）。未来，便利家希望在门把手上做掌纹识别，当消费者进行“拉开门”这个动作的时候，就能够进行识别。<br/></p><p>概念上，便利家其实更接近于售货机，创始人范韶伟认为，便利家是对传统售货机的一个改进。一方面，传统售货机的经营品类大多以饮料和固定包装零食为主，而便利家将以符合健康趋势的“鲜食类”为主；另一方面，传统售货机的出货流程是先付款、再出货，管道的陈列方式使得空间利用率低，如果是鲜食类商品，还有可能在掉下来的过程中发生变形。而便利家为先拿货、再扣款，可以叠放、密集排列，使得空间利用率更高。“同等面积下，我们的放货率比传统售货机多一倍。”</p><p>便利家的选品逻辑是，根据不同的场地，选择不同的商品，比如在写字楼满足白领的早午餐需求，提供便当、三明治、沙拉等等；在高校提供零食、卤味、面包等等。比照全家的平均客单价（14元），便利家将平均客单价设定在10元左右。此外，通过小程序，消费者可以反馈自己想吃的食物，根据数据反向指导品类的选择。<br/></p><p>微型、中型便利店之外，便利家还有第三个方面的业务——对于传统夫妻店的改造。线下夫妻店的特点在于大小不一、面积不一，便利家提供的无人便利店改造方案，一是夫妻店共享场地资源，进行销售分成；二是加盟方式，收益比例更高。一方面，小店店主不需要一天十几个小时守着门店，另一方面，在无人售卖之外，还可以延展其它的生意获得更多利润，比如奶茶、咖啡等。</p><p>“不管是无人零售还是有人零售，本质上还是零售的生意。”范韶伟说。既然是零售的生意，在网点的布局上，需要站在全局的角度，“最怕东一榔头、西一棒子。”</p><p>点、线、面的合理布局，才能最大程度的降低运营成本和物流成本。这其中需要考虑两个重要因素：人流量以及铺设点位的协同。便利家的思路是，在人流量密集的地方布一个中型无人便利店，再在周围100米的范围内，去布局10个微型无人便利店，形成“最小补货单元”， 1个人可以负责20台设备的补货。</p><p>至于RFID贴标签的成本问题，范韶伟持有乐观的态度，目前标签成本在0.5-0.6元，但随着RFID在零售市场的普及，RFID标签的价格一定会降低。</p><p>本轮融资后，便利家将在上海建立试运营点，中型+微型无人便利店，预期铺设20个网点。目前，便利家正在寻求Pre-A轮融资，用于扩大量产和投放运营。</p><p>团队方面，CEO范韶伟毕业于哈尔滨工业大学，曾任商派软件渠道部北部大区经理，是一位连续创业者。COO吴威为上海交通大学硕士，在快消品领域连续创业；CTO彭庚庚毕业于上海大学计算机工程专业，曾任腾讯OMG事业群广告平台部高级工程师。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYxOlTYHaG5zFRwPB647','1','2019-02-27 15:05:18','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('124','70','0','腾讯500万美元领投AI创企ObEN，进一步布局社交AI','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:05:45','admin','','/html/upload/images/201902/15512511584127.jpg','1','1','除了做基础技术的研究外，腾讯曾表示要通过业务驱动来推动各种应用场景的人工智能化。结合腾讯的主营业务，也不难猜到未来公司要在游戏、社交、内容和平台工具型四大应用方向发力。尤其是在社交领域，去年扎克伯格曾表示要推出VR版的Facebook，并展示了虚拟人物形象工具Oculus Avatars；今年7月，Facebook表示Facebook AR工作室将与美图合作，向其提供三款AR相机特效。如今，腾讯也','0','<p>除了做基础技术的研究外，腾讯曾表示要通过业务驱动来推动各种应用场景的人工智能化。</p><p>结合腾讯的主营业务，也不难猜到未来公司要在游戏、社交、内容和平台工具型四大应用方向发力。</p><p>尤其是在社交领域，去年扎克伯格曾表示要推出VR版的Facebook，并展示了虚拟人物形象工具Oculus Avatars；今年7月，Facebook表示Facebook AR工作室将与美图合作，向其提供三款AR相机特效。如今，腾讯也要有所行动了。</p><p>7月18日晚间，人工智能初创公司ObEN宣布获得500万美元战略投资。该轮融资由腾讯领投，CMC董事长黎瑞刚及峰尚资本跟投。投融资信息平台crunchbase的数据显示，目前ObEN共完成四轮融资，总金额达到1370万美元。此前的投资人还包括S如山资本、软银韩国风险投资公司和HTC VIVE X等。</p><p>公开资料介绍，ObEN创办于2014年，可以通过构建个性化的虚拟声音、形象和个性来创造用户的人工智能虚拟形象，并帮助用户在新兴的数字世界中存储、管理、运营他们的虚拟形象。也就是说，ObEN可以利用人工智能工具，根据用户的照片和声音创建虚拟形象，从而让用户有不同的AR、VR社交体验。</p><p>以前ObEN主要帮助游戏玩家创建虚拟形象，如今公司将重点转向于帮助明星打造虚拟形象。通过该虚拟形象，明星可以与粉丝进行实时互动。未来某一天，也许粉丝还可以向明星寻求建议并得到相应的反馈。另外，这一虚拟形象不仅与明星长的非常像，而且说话的方式也是一样的。总的来说，这样一个虚拟形象总好过于一个聊天机器人。</p><p>据介绍，ObEN还首次融合了语音、计算视觉以及自然语言处理技术，研发了全栈式虚拟明星所需要的虚拟声音、三维形象及个性化技术。如今ObEN正在打造一个全新的商业平台。在这里，明星和粉丝可以通过个性化的人工智能在移动端、增强现实、虚拟现实以及智能设备、物联网等平台上直接互动。ObEN的个性化的人工智能产品预计将在今年晚些时候发布。</p><p>而最新一轮融资，将被用于加速ObEN的产品开发，并帮助推动其明星人工智能版权平台广泛应用到各类数字平台上。对于这次合作，腾讯投资的执行董事姚磊文说道，ObEN将带来由明星人工智能驱动的全新娱乐方式和内容。</p><p>早前，ObEN就曾表示要做“每个人的人工智能社交平台”。在这方面，公司已经先后进行过多次布局。</p><p>在今年3月的HTC Vive生态圈大会上，ObEN宣布与HTC Vive合作，开发了一个让用户一起VR游玩、VR“K歌”的微信小程序。在这一程序中，VR用户可以向好友发送邀请；接到邀请的好友可以上传自拍和音频，最终使用建成的形象与邀请者一起漫步海滩，或者参观景点。</p><p>随后的4月底，ObEN推出了一个整合有VR社交体验的微信聊天服务短片，当然用户需要戴上HTC Vive头显。在短片中，用户需要先拍一张自拍，上传到微信制作虚拟形象，然后带上HTC Vive，就可以接收微信好友发来的信息，并可以用语音直接进行回复。未来，拥有VR、AR功能的微信或许又可以收割大量亚洲用户。</p><p>6月底，ObEN又宣布与韩国SM娱乐成立合资公司幻星有限公司（AI Stars）。据悉，ObEN要利用人工智能技术为SM娱乐旗下的知名艺人制作AI虚拟形象，而幻星有限公司正是管理这些”AI明星“的经纪公司。<br/></p><p>这次腾讯领投ObEN，是否可以进一步推动公司社交业务的人工智能化。如今，各大公司不仅在忙于建立人工智能实验室，而且像Facebook这样的公司已经成立了更具象的Facebook AR实验室。另外，据说苹果很快就会推出ARKit平台。未来，腾讯是否还会成立单独的AR实验室，进一步布局社交AI业务？</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYrfy4FQR4f1uPEe1342','1','2019-02-27 15:05:45','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('125','69','0','美业信息化规模将现，门庭管店为他们提供了一套SaaS管理软件','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:06:06','admin','','/html/upload/images/201902/15512511782355.jpg','1','1','数据显示，2015年，我国服务业同比增长8.3%，分别高于国内生产总值和第二产业增加值增速1.4和2.3个百分点，占国内生产总值的比重达到50.5%，首次过半，而与发达国家相比，我国服务业仍有20%-30%的发展空间。美业属于实体服务业，整个市场有上千亿的规模，但是信息化程度和零售餐饮业相比着实比较低。其中的原因就是餐饮和零售客流量大，触达人群广，而美业客流量相对小，加上从业人员素质导致信息化程度','0','<p>数据显示，2015年，我国服务业同比增长8.3%，分别高于国内生产总值和第二产业增加值增速1.4和2.3个百分点，占国内生产总值的比重达到50.5%，首次过半，而与发达国家相比，我国服务业仍有20%-30%的发展空间。美业属于实体服务业，整个市场有上千亿的规模，但是信息化程度和零售餐饮业相比着实比较低。其中的原因就是餐饮和零售客流量大，触达人群广，而美业客流量相对小，加上从业人员素质导致信息化程度低、管理效率低。</p><p>美业现在的主要管理方式是纸质账本和简单的收银、结算软件，纸质管理约占行业客户的90%，功能简单只能用于管理会员卡的单机版管理软件约占9%。美业的客户与店面的粘性比较高，虽然是低频次消费，但是一旦用户选择一家店，在接收到较好服务之后很难再转向其它店，因此美业在预约管理、客户管理等需求上要高于餐饮和零售，应用的软件形态并不一定以结算收银为主，重点是CRM系统、收银、绩效考核、预约为一体的管理软件。</p><p>36氪近日了解的门庭管店是一款美业 SaaS 产品，主要功能有&nbsp;SCRM 会员管理、智能预约、绩效工资、 营销卡券、全能收银等。门庭管店产品在客户方是微信公众号和小程序；美容师端是用于客户关系维系、工资查询和预约的移动端；前台端是 Upad，主要是收银和预约；还有一个店长用的总后台，主要是 PC 或者一体化智能机，做整体的数据管理。</p><p>其实管理的过程也是沉淀数据的过程，也是开发闭环和生态的过程，CEO 孟凡刚告知记者，门庭管店现在先用营销工具+SaaS 系统，切入线下美业门店，建立强关系，然后通过收银系统嵌入微信、支付宝支付，将门店的线上流水导入平台沉垫大量资金，最后在基于 SaaS 交易数据、消费行为数据进行大数据分析延伸美业产品、项目供应链。比如门庭管店最近正在做韩国的皮肤检测仪，检测完之后放在客户档案里，综合到智能管理平台，这样顾客再来的时候就可以针对个人特点进行服务。</p><p>美业的变革形成了两个阵营，一个阵营是大型会所，积累了很多老顾客，老顾客随着年龄的增长对养生的需求越来越强烈，一旦切入了养生，就和80、90这些互联网主力军有些脱离；还有一类是近两年新开的店，新开的店没有老会员的资源，那么如何针对80、90人群做服务就变成了主要任务 ，年轻人属于互联网使用场景人群，因此新店更容易植入 SaaS 软件。门庭管店更偏向于年轻化的店，在积累了一段时间的经验和资金之后再做老店。</p><p>对于没有信息化的店，前期的数据录入是最麻烦的，门庭管店会派客服帮助整理数据，时间大概是2-3天。其次就是软件使用的普及，关于这一点，门庭管店有专门的培训，包括音视频的远程培训。收费模式上分为私有云部署和公有云，公有云不过万元，之后每年有1000元维护费用。整个软件的安装大概能为门店省下一个人的成本。</p><p>门庭管店的客户包括克丽缇娜、丝域养发、庆熙美学、千禧鸟、自然美等。</p><p>行业竞品方面，美业 SaaS 提供商还包括博卡、喔噻、美约汇、美丽加、点美、美业邦等。</p><p>孟凡刚认为做美业 SaaS 的一个门槛就是软件研发能力，只有有比较强的研发能力才能开发出页面简洁、功能齐全、适用于管理的产品，客户与公司粘性才会提高，所以门庭管店来的想法是以做出更智能化的产品；其次一点就是销售能力，门庭管店现在采用合伙人方式，代理渠道可以发展自己的客户，目前门庭合伙人有100多个。</p><p>团队现在30人，一半以上为技术人员，CEO 孟凡刚曾任会友科技 CEO、随车记 CEO，有8年的互联网及移动互联网运营管理经验。公司已经完成了天使轮融资，计划进行下一轮融资。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASY8uB7PeNLDbOtICr645','1','2019-02-27 15:06:06','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('126','69','0','点击在线求助，应答的却都是机器人，这样真的好吗？','','','admin','1','0','','0','0','','0','','','','','0','2019-02-27 15:06:29','admin','','/html/upload/images/201902/15512512077574.jpg','1','1','编者按：人工智能技术的发展正在不断地改变着人们的生活与工作方式，它在一定程度上推动了社会的发展与进步，这一点是毋庸置疑的。但人工智能并不是万能的，因为机器并不具备人类的思维与情绪。当你打开网站上的在线求助窗口，却发现回答你的只是冷冰冰的机器人的时候，恐怕应该会很失望吧。2016年4月，马克·扎克伯格在Facebook的F8会议上为Messenger上的开发者们描述了一个光明的未来，并宣布将进入“像','0','<p>编者按：人工智能技术的发展正在不断地改变着人们的生活与工作方式，它在一定程度上推动了社会的发展与进步，这一点是毋庸置疑的。但人工智能并不是万能的，因为机器并不具备人类的思维与情绪。当你打开网站上的在线求助窗口，却发现回答你的只是冷冰冰的机器人的时候，恐怕应该会很失望吧。</p><p>2016年4月，马克·扎克伯格在Facebook的F8会议上为Messenger上的开发者们描述了一个光明的未来，并宣布将进入“像和朋友一样与机器人聊天”的新时代。世界各地的开发人员，这些开发人员都拥有Facebook、Google和Microsoft等大公司的认证，都声称独立移动应用程序的时代结束了，并一起庆祝新的方式的到来——对话商务（Conversational Commerce）和聊天机器人（Chatbots）。11个月前，Facebook宣布其官方开发的聊天机器人“M”的beta测试中AI失败率为70％，随后便更新了其平台，并建议开发人员在Messenger中开发更轻量级的应用程序，同时禁用会话输入。</p><p>关于Wordhop.io，一直以来我们都知道两件事。第一件事就是，AI真的很难，要实现让机器人100％像朋友一样与人类交流还需要很多年。毕竟，机器人不能像人一样产生共鸣。第二，Facebook消费者不会因为他们想购物或对天气感兴趣而给一个企业发送消息。这些体验是以具备聊天机器人为前提条件的，并且还需要已从信息传递领域拓展到社交网络领域的行业数据的支撑。</p><p>Facebook用户真正想要的就是，在有问题的时候可以迅速得到商家的回复。</p><p>消费者在Facebook上给商家发送消息的主要原因是想要获得服务。其他的一切都是浮云。这样的交互式预售可能从客户的发问开始，及时的答复可以推进交易的进行。如果客户联系销售客服，通常是因为他们真的有问题需要请教客服。一些答案可以由机器人回答，而更复杂的问题可以交给人来解决，在有得力工具的情况下，人类的回复速度可以媲美机器人。</p><p>然而许多机器人开发者没有将注意力集中在最有需求的那部分上，而是寻求创造新的用户体验，或重新开发升级旧的关于chatbot的概念。如果机器人开发者觉得参与率低，这可能不是因为AI失败了，而是因为他们把消费者往一条最开始就不想走的路上引。没有利用已存在的消费者行为模式，也没有训练机器人回应客户的需求，AI的作用只是，实现机器人开发商想象中的创造性体验并指导消费者通过该体验来进行交互。</p><p>Facebook现在建议机器人开发人员完全禁用会话输入。</p><p>我个人并不认为，像Facebook建议的那样禁用聊天输入是针对AI和NLP的技术限制的正确解决方案。无对话能力的通信机器人对于新闻机器人是可以接受的，这其中的体验由通知和内容消费驱动。但是，如果是以服务为基础的业务的话，则需要为用户提供一个可以与你友好互动的平台。如果文字输入是Messenger的主要方式，那么就会限制客户的沟通意愿和能动性，并迫使他们寻求你能想象到的其他方式的客户服务，又或者只是延迟回复都会让客户更加失望。想一想IVR吧，每次听完菜单选项后，你要按几下“0”。</p><p>商界应该采用自动和人工相结合的方式，这样才能满足Facebook用户的需求。</p><p>中国的微信的小程序是整合于消息互动的，这满足了开发者对聊天机器人的期待，但是这是东方的文化现象，而西方企业则应该首先利用已有的消费者行为，并且要更好地利用这样的行为数据。如果你不是“聊天机器人会取代人工服务”这一概念的拥趸，只是坚守开业之初对顾客的承诺，那么引入这样的科技就可以帮助你加强与客户间的交流。如果你能够实现现在Facebook消费者们的期望，那么随着时间的推移，你也可以增加新的功能，并将消费者往你所期待的方向引领。最终你很可能会满足他们的需求。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYMEemHfOS9b2GVhh439','1','2019-02-27 15:06:29','','','0','1','0','0.00','0.00','');-- 
INSERT INTO `cmseasy_archive` VALUES('127','69','0','传滴滴即将接入ofo，共享单车大战格局或生变','','','admin','1','8','','0','0','','0','','','','','0','2019-02-27 17:11:48','admin','','/html/upload/images/201902/15512512329155.jpg','1','1','36氪从ofo内部获得消息，可能在今年4月份，ofo将会接入到滴滴出行的App上，届时用户可以直接在滴滴上面使用ofo的服务。“这件事最近被频繁地提上日程，内部消息是下个月就有可能接入。”一名ofo内部员工说。36氪向滴滴官方、ofo官方求证了此消息，但截止发稿时，两家公司均未对此确认或否认。ofo创始人戴威曾在去年12月表示，何时接入滴滴APP，没有明确的时间表。“ofo的模式是没有GPS的，用','0','<p>36氪从ofo内部获得消息，可能在今年4月份，ofo将会接入到滴滴出行的App上，届时用户可以直接在滴滴上面使用ofo的服务。</p><p>“这件事最近被频繁地提上日程，内部消息是下个月就有可能接入。”一名ofo内部员工说。36氪向滴滴官方、ofo官方求证了此消息，但截止发稿时，两家公司均未对此确认或否认。</p><p>ofo创始人戴威曾在去年12月表示，何时接入滴滴APP，没有明确的时间表。“ofo的模式是没有GPS的，用户看到车就用，整个逻辑跟滴滴平台打车的逻辑不太一样，但近期我们会跟滴滴联合推出一些东西。”</p><p><br/></p><p style=\"text-align: center;\"><img src=\"/html/upload/images/201902/img16.jpg\" alt=\"img16.jpg\"/></p><p><br/></p><p>不过类似的接入并非没有先例。今年2月，微信联合摩拜单车宣布，用户通过微信“扫一扫”扫描摩拜单车车身上的二维码，就可直接进入摩拜单车微信小程序，点击开锁即可用车。</p><p>这并不是第一次传出ofo会接入滴滴的消息，也不是两个平台的第一次深度绑定。此前，滴滴参与了ofo最近三轮的融资。根据腾讯科技的报道，一位共享单车投资人透露，ofo经过多轮融资以后，滴滴已经成为ofo最大股东，占股超过30%。“这意味着，滴滴在ofo的话语权更强了，同时，ofo的成与败，滴滴将是最大利息相关方。”</p><p>这也不难理解，滴滴将ofo接入之后，将作为巨大的用户流量入口为其导流，而ofo则进一步巩固生意体量，在滴滴的加持下提高行业地位和想象空间。</p><p>而且，如果真的将ofo接入进来，也意味着滴滴及其背后的资本在进一步弥补自己在出行领域的缺口。</p><p>有知情人向36氪透露，曾经滴滴也想做共享单车，但是出于某些原因没能实现，最终只能作为ofo的投资方。不过这并不意味着滴滴不会更进一步涉足这个市场。</p><p>滴滴投资ofo，无非是瞄准了“最后三公里”的机会。</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201902/img13.jpg\" alt=\"img13.jpg\"/></p><p><br/></p><p>当前国内在“最后三公里”领域仍是一个非常初级的阶段，也没有系统性服务商。而在北上广的一线城市，交通的繁复令各大出行平台对“最后三公里”争夺日趋激烈。</p><p>“从出发地到目的地3公里，到底是打车还是骑车，这对于用户来说是可以选择的，选哪一个都说得过去。”一名ofo内部员工说，而滴滴的做法就是自己要把不同的选项全部覆盖。</p><p>在滴滴和ofo及其投资人看来，共享单车领域已经迎来了一个快速增长期。Ofo的一名公关曾对媒体表示，以专车和快车为例，2012 年之后的这几年，发展速度是非常快的。ofo 则是在 1 年的时间里，把日订单量从 200 单做到了50万单，“过去的专车快车，现在的 ofo 都是经历着高速的增长，这个势头是类似的”。上述公关人员说。</p><p>去年12月末，ofo联合滴滴推出红包活动，这是ofo被滴滴战略投资后双方首次进行大规模合作。而活动采取的红包策略，也被认为是滴滴历来进行市场推广的利器之一。</p><p>按照滴滴方的说法，2017年仍旧会将主要精力放在出行领域，希望能够打通每个人的出行。这意味着所有的出行方式都将会被覆盖到，共享单车也会是滴滴发力的方向之一。</p><p>36氪认为，滴滴进一步接入共享单车还有一个重要的原因在于，与“苛刻”的互联网专车规定相比，共享单车发展初期便受到了政策鼓励，约束条件也颇为合理。而去年至今一直受网约车新政影响的滴滴出行无论是从政策角度，还是从新的业务增长角度来看，都有可能会更进一步从共享单车的风口上分得一杯羹。</p><p>不过，36氪还有疑问，没有导航的ofo要怎么接入滴滴，以及接入之后到底会给用户带来哪些影响？</p><p>“据我了解到的情况是，滴滴可能会把技术和导航这快的事情承包给第三方公司。”上述ofo内部员工说，接入滴滴之后的ofo可能依旧没有导航，用户在页面上主要行使扫码开锁和支付功能。</p><p>至于用户体验方面，上述内部员工表示，“本来ofo的主体功能就比较单一，操作起来非常的简单，相信可以无缝对接到滴滴平台上，”他强调，“毕竟未来的趋势是，人们手机上装载的app数量将会越来越少”。</p><p><br/></p>','0','0','0','','0','0','','','','','0','','','0','N;','','0','0','0','0000-00-00','','','','','','','','','','','','','','0','CMSEASYwfSD4XXa5DVkOdd269','1','2019-02-27 17:11:48','','','0','1','0','0.00','0.00','');-- 



INSERT INTO `cmseasy_b_category` VALUES('18','15','酒店装修','HotelDecoration','','0','/html/upload/images/201902/15503063138825.jpg','','','','<p>中国装饰装修企业最高资质和品牌之一。十余年来致力于为开发商提供【住宅全装修】系统服务，具备卓越的全装修产业链整体解决能力。</p>','jiu-dian-zhuang-xiu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('19','15','商业、办公、会所','Commercial Decoration','','0','/html/upload/images/201902/15503063444368.jpg','','','','<p>中国装饰装修企业最高资质和品牌之一。十余年来致力于为开发商提供【住宅全装修】系统服务，具备卓越的全装修产业链整体解决能力。</p>','shang-ye--ban-gong--hui-suo','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('58','52','公司动态','','','0','','','','','','gong-si-dong-tai','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('59','52','行业资讯','','','0','','','','','','xing-ye-zi-xun','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('61','0','集团产业','Group industry','','2000','','','','','','Groupindustry','archive/list_pic.html','archive/list_pic.html','archive/show_products.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('21','20','公司简介','','','0','','','','','<p>中国某某建筑装饰有限公司成立于1999年，注册资本1亿3700万元，经建设部核定为建筑装饰工程专业承包壹级资质、建筑幕墙施工壹级资质、建筑装饰专项工程设计甲级资质和建筑幕墙专项工程设计甲级资质。 中国某某建筑装饰公司总部坐落于广州天河。公司拥有技术力量雄厚、设备先进的集办公、设计深化、新材料运用、信息化管理、工厂化配套于一体的研发中心，并在北京、上海、南京、芜湖等地相继设有分公司和办事处。</p><p>中国某某建筑装饰依靠独特的企业文化吸引了大批优秀人才，现有200余人的设计师团队，其中35名“全国资深室内建筑师和杰出中青年室内建筑师”，10名“IAID最具影响力中青年设计师”，多人获“中国优秀酒店设计师”、“中国十佳餐馆室内设计师”、“全国优秀医院设计师”和“江苏省十佳青年设计师”称号；有众多吃苦耐劳、能力突出的业务人员，建立了8个分工明确、各具特色的营销团队；有近100人的专业施工项目经理（建造师）队伍，其中40多人荣获全国、省市优秀项目经理。</p><p>中国某某建筑装饰公司制定了“凭实力竞争，靠质量取胜，创一流服务”的企业方针；提出了“建一项工程，树一方口碑，开一片市场”的口号；确立了“用户满意为最高服务质量标准”的理念。坚持以用户满意为中心的经营发展战略，不图眼前利益，更不为一己之利而损害客户的权益，坚持品牌的内在品质价值、信誉价值和客户价值。通过ISO9001、ISO14001和GBT28001三个体系的认证，科学有效的组织和实施用户满意的工程。公司承接的大批工程荣获了“全国建筑工程装饰奖”、省市级优质工程奖和国家、省市级设计奖。 在打造精品工程的同时，中国某某建筑装饰公司制定了“与用户有关的控制程序”，从设计文件、施工标准、竣工验收到维修服务，全面开展用户满意度评价工作，实施全过程的动态分析和持续改进，中国某某建筑装饰品牌得到了客户的广泛认可和好评。中国某某建筑装饰被评为“中国驰名商标”，荣获“高新技术企业”并连续十二年位列全国建筑装饰行业企业前茅，连续多年跻身江苏省建筑装饰行业前三甲，获得了“全国改革开放三十年建筑装饰行业突出贡献企业”以及“全国建筑装饰行业信息化建设先进单位”的荣誉，通过向幕墙、家具、景观、机电、智能安装等配套产业的拓展，不断扩大装饰的内涵，让客户在中国某某建筑装饰得到“一次性委托，全方位服务”的享受，让客户价值增值。</p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>','gong-si-jian-jie','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('22','20','公司文化','','','0','','','','','<p>核心价值观：诚信、创新、服务</p><p>企业核心： 诚信&nbsp;</p><p>企业精神： 团结拼搏、开拓求实、满足用户、科技进步。</p><p>&nbsp;</p><p>客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢得客户的理解、尊重和支持。</p><p>市场：为客户降低采购成本和风险，为客户投资提供切实保障。&nbsp;</p><p>发展：追求永续发展的目标，并把它建立在客户满意的基础上。</p><p>&nbsp;</p><p>关于“为合作伙伴创造价值”</p><p>公司认为客户、供应商、公司股东、公司员工等一切和自身有合作关系的单位和个人都是自己的合作伙伴，并只有通过努力为合作伙伴创造价值，才能体现自身的价值并获得发展和成功。</p><p>关于“诚实、宽容、创新、服务”</p><p>公司认为诚信是一切合作的基础，宽容是解决问题的前提，创新是发展事业的利器，服务是创造价值的根本。公司会坚持持续改进、满足顾客期望、 确保品质第一、开拓全球市场。</p><p><br/></p>','gong-si-wen-hua','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('23','20','公司荣誉','','','0','','','','','','gong-si-rong-yu','archive/list_pic2.html','archive/list_pic2.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('24','20','合作伙伴','期待您的加入','','0','','','','','','OurPartners','archive/list_pic3.html','archive/list_pic3.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('38','35','影音服务','','','0','','','','','','ying-yin-fu-wu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('26','25','媒体报道','','','0','','','','','','mei-ti-bao-dao','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('27','25','行业动态','','','0','','','','','','xing-ye-dong-tai','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('28','25','公司新闻','','','0','','','','','','gong-si-xin-wen','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('47','44','居住建筑','','','0','','','','','','ju-zhu-jian-zhu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('31','29','联系方式','','','0','','','','','<p>地址：这里是您的公司地址&nbsp;</p><p>电话：400-123-4567</p><p>传真：+86-123-4567</p><p>邮编：000000</p><p>邮箱：admin@admin.com</p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>','lian-xi-fang-shi','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('32','29','留言反馈','','','0','','','','','','liu-yan-fan-kui','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','/index.php?case=guestbook&amp;act=index','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('4','1','企业文化','corporate culture','','0','/html/upload/images/201506/wenhua.jpg','','','','<p>企业文化，或称组织文化（Corporate Culture或Organizational Culture），是一个组织由其价值观、信念、仪式、符号、处事方式等组成的其特有的文化形象。</p><div>职工文化，也称企业职工文化，是与企业文化相对应的文化形态，职工文化以职工为本，是一种素质文化，企业文化以企业为本，是一种管理文化。[1]&nbsp;<p>企业文化是在一定的条件下，企业生产经营和管理活动中所创造的具有该企业特色的精神财富和物质形态。它包括文化观念、价值观念、企业精神、道德规范、行为准则、历史传统、企业制度、文化环境、企业产品等。其中价值观是企业文化的核心。</p><p>企业文化是企业的灵魂，是推动企业发展的不竭动力。它包含着非常丰富的内容，其核心是企业的精神和价值观。这里的价值观不是泛指企业管理中的各种文化现象，而是企业或企业中的员工在从事商品生产与经营中所持有的价值观念。</p></div>','culture','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('16','15','住宅装修','Residential Decoration','','0','/html/upload/images/201902/15503061271190.jpg','','','','<p>中国装饰装修企业最高资质和品牌之一。十余年来致力于为开发商提供【住宅全装修】系统服务，具备卓越的全装修产业链整体解决能力。</p>','zhu-zhai-zhuang-xiu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('17','15','豪宅装修','Luxury Homes','','0','/html/upload/images/201902/15503062817599.jpg','','','','<p>中国装饰装修企业最高资质和品牌之一。十余年来致力于为开发商提供【住宅全装修】系统服务，具备卓越的全装修产业链整体解决能力。</p>','hao-zhai-zhuang-xiu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('6','3','文档下载','','','0','','','','','','download','archive/list_down.html','archive/list_down.html','archive/show_down.html','0','archive/list_down.html','archive/list_down.html','archive/show_down.html','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('7','1','职位招聘','Recruiting talents','','0','/html/upload/images/201506/zhaopin.jpg','','','Have the energy have the dream, have the grade, the creative team','','job','archive/list_job.html','archive/list_job.html','archive/show_job.html','0','archive/list_job.html','archive/list_job.html','archive/show_job.html','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('8','3','产品运营','','','0','','','','','','operate','archive/list_pic.html','archive/list_pic.html','archive/show_products.html','0','','','','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('9','2','公司动态','','','0','/html/upload/images/201506/dongtai.jpg','','','','','dynamics','archive/list_text_pic.html','archive/list_text_pic.html','archive/show.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('10','3','产品设计','','','0','','','','','','design','archive/list_pic.html','archive/list_pic.html','archive/show_products.html','0','','','','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('11','1','公司荣誉','Company honor','','0','/html/upload/images/201506/rongyu.jpg','','','','<p>企业荣誉指企业获得的来自社会和公众的奖项与赞许。包括政府组织机构评选颁发的各类奖项、媒体和市场研究机构的奖项、公众通过正式和非正式渠道对企业的赞许表达。企业荣誉是品牌口碑的重要表现形式，对品牌的最终影响程序还取决于品牌对企业荣誉的宣传程序、媒体参与度、公众认可度等。企业荣誉是可测量的品牌口碑指标。</p>','honor','archive/list_pic.html','archive/list_pic.html','archive/show_products.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('12','1','发展历程','Company development process','','0','/html/upload/images/201506/gushi.jpg','','','','<p>流程管理（process management），是一种以规范化的构造端到端的卓越业务流程为中心，以持续的提高组织业务绩效为目的的系统化方法，常见商业管理教育如EMBA、MBA及CEO必读12篇等均对&ldquo;流程管理&rdquo;有所介绍，有时也被称为BPM业务流程管理。它应该是一个操作性的定位描述，指的是流程分析、流程定义与重定义、资源分配、时间安排、流程质量与效率测评、流程优化等。因为流程管理是为了客户需求而设计的，因而这种流程会随着内外环境的变化而需要被优化。</p>','history','archive/list_history.html','archive/list_page.html','archive/show.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('13','2','行业新闻','','','0','/html/upload/images/201506/hangye.jpg','','','','','honor','archive/list_text.html','archive/list_text.html','archive/show.html','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('39','35','安防系统','','','0','','','','','','an-fang-xi-tong','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('63','61','仓储物流','','','0','','','','','','cang-chu-wu-liu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('64','61','车辆运输','','','0','','','','','','che-liang-yun-shu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('65','0','新闻资讯','NEWS','','3000','','','','','','NEWS','archive/list_text_pic.html','archive/list_text_pic.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('66','0','企业文化','ORPORATE CULTURE','','4000','','','','','<p>核心价值观：诚信、创新、服务</p><p>企业核心： 诚信&nbsp;</p><p>企业精神： 团结拼搏、开拓求实、满足用户、科技进步。</p><p>&nbsp;</p><p>客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢得客户的理解、尊重和支持。</p><p>市场：为客户降低采购成本和风险，为客户投资提供切实保障。&nbsp;</p><p>发展：追求永续发展的目标，并把它建立在客户满意的基础上。</p><p>&nbsp;</p><p>关于“为合作伙伴创造价值”</p><p>公司认为客户、供应商、公司股东、公司员工等一切和自身有合作关系的单位和个人都是自己的合作伙伴，并只有通过努力为合作伙伴创造价值，才能体现自身的价值并获得发展和成功。</p><p>关于“诚实、宽容、创新、服务”</p><p>公司认为诚信是一切合作的基础，宽容是解决问题的前提，创新是发展事业的利器，服务是创造价值的根本。公司会坚持持续改进、满足顾客期望、 确保品质第一、开拓全球市场。</p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>','ORPORATECULTURE','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('67','0','联系我们','CONTACT US','','6000','','','','','<p>地址：这里是您的公司地址&nbsp;</p><p>电话：400-123-4567</p><p>传真：+86-123-4567</p><p>邮编：000000</p><p>邮箱：admin@eyoucms.com</p><p><br/></p>','CONTACTUS','archive/list_ditu.html','archive/list_ditu.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('68','0','人才招聘','Talent recruitment','','5000','/html/upload/images/201902/15512506181273.jpg','','','','<p style=\"text-align: center;\">一，企业愿景：造客户最满意的物流企业。</p><p style=\"text-align: center;\"><br/>二、企业宗旨：造最优质的产品，做最诚信的服务。&nbsp;</p><p style=\"text-align: center;\"><br/>三、发展目标：“创行业一流，做全国第一。”&nbsp;</p><p style=\"text-align: center;\"><br/>四、企业精神：&nbsp;“团结拼搏、仁爱奉献；开拓创新、敢为天下。”&nbsp;</p><p><br/></p><p style=\"text-align: center\"><img src=\"/html/upload/images/201902/15512506084451.jpg\" title=\"15512506084451.jpg\" alt=\"1.jpg\"/></p><p><br/></p>','Talentrecruitment','archive/list_page.html','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('69','65','公司动态','','','0','','','','','','gong-si-dong-tai','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('70','65','行业新闻','','','0','','','','','','xing-ye-xin-wen','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('37','35','照明系统','','','0','','','','','','zhao-ming-xi-tong','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('48','44','城市规划','','','0','','','','','','cheng-shi-gui-hua','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('46','44','公共建筑','','','0','','','','','','gong-gong-jian-zhu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('49','43','公司新闻','','','0','','','','','','gong-si-xin-wen','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('50','43','行业动态','','','0','','','','','','xing-ye-dong-tai','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('62','61','综合运输','','','0','','','','','','zong-he-yun-shu','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('60','0','关于我们','ABOUT US','','1000','/html/upload/images/201902/15512502578872.jpg','','','','<p>广东某某物流有限公司-专业轿车运输公司依据市场需求应运而生，公司借助十多年物流运输经验建立起的覆盖全国的轿车运输服务网络，培养了一批具有高素质的专业驾驶员和优秀的管理人员队伍。</p><p><br/></p><p>关于“为合作伙伴创造价值”<br/></p><p>公司认为客户、供应商、公司股东、公司员工等一切和自身有合作关系的单位和个人都是自己的合作伙伴，并只有通过努力为合作伙伴创造价值，才能体现自身的价值并获得发展和成功。<br/></p><p><br/></p><p>关于“诚实、宽容、创新、服务”<br/></p><p>公司认为诚信是一切合作的基础，宽容是解决问题的前提，创新是发展事业的利器，服务是创造价值的根本。公司会坚持持续改进、满足顾客期望、 确保品质第一、开拓全球市场。<br/></p><p>各种运输方式和运输工具都有各自的特点，不同类物品对运输的要求也不尽相同，合理选择运输方式，是合理组织运输、保证运输质量、提高运输效益的一项重要内容。<br/></p><p><br/></p><p>运输方式的选择就是从铁路、公路、航空、水路、管道运输等方式或联合运输中作出选择，通过对不同方式的运价和服务水平进行评价而作出决定。</p><p>由于运输成本在总物流成本占有重要的比例，而且，不同运输方式的运价相差很大，因此，运价是选择运输方式的五个非常重要因素。但是运输成本最低的运输方式通常会导致物流系统中其他部分成本的上升，因此难以保证整个物流系统的成本最低。所以，尽管运价是影响决策的一个因素，但它绝不是唯一的因素，企业必须考虑运输服务的质量以及这种服务带来到对整个物流系统动作成本的影响。运输服务质量通常包括运输时间、运输可靠性、运输安全性、服务容易性等。<br/></p><p>不同运输方式下的运输时间将对物流系统名结点所有要求的存货水平或造成不同的影响，即较长的运输时间需要较高的存货水平。运输方式的可靠性和安全交货的程度也会影响各结点的存货水平、物料搬运设备和劳动力的使用、货损赔偿以及通信的时间与成本。<br/></p><p>由此可见，运输方式的选择要根据物流系统的总体要求、结合不同方式的成本与服务特点，选择适合的运输方式。运输方式的选择是综合考虑运输价格、运输时间、运输服务可靠性、安全性和容易性等因素基础上做出的决定。<br/></p><p>公路运输需求将继续保持快速增长。近20多年来，我国公路基础设施建设迅速发展，公路运输能力大大提高，在国民经济增长和人民生活水平提高方面发挥着越来越重要的作用。但与日益增长的运输需求相比，公路运输仍存在着有效供给不足的问题。随着我国经济的进一步发展，公路运输需求将继续保持快速增长。在公路货运中大宗货物、初级产品所占的份额呈下降趋势，对运输服务质量和服务水平的要求日益提高。<br/></p><p>智能运输系统是未来公路运输的发展方向智能运输系统简称ITS，是将先进的信息技术、数据通讯传输技术、电子控制技术及计算机处理技术等综合运用于整个地面运输管理体系，使人、车、路及环境密切配合、和谐统一，使汽车运行智能化，从而建立一种在大范围内，全方位发挥作用的实时、准确、高效的公路运输综合管理系统。<br/></p><p>智能运输系统可提高公路交通安全水平，减少交通堵塞，提高公路网的通行能力，降低汽车运输对环境的污染，提高汽车运输生产率和经济效益。随着智能运输系统技术的发展，电子技术、信息技术、通信技术和系统工程等高科技在公路运输领域将得到广泛应用，物流运输信息管理、运输工具控制技术、运输安全技术等均将产生巨大的飞跃，从而大幅度提高公路网络的通行能力。<br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>','guan-yu-wo-men','archive/list_page.html','archive/list_page.html','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('55','53','风电','','','0','','','','','','feng-dian','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('56','53','水电','','','0','','','','','','shui-dian','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('57','53','太阳能','','','0','','','','','','tai-yang-neng','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('40','34','公司动态','','','0','','','','','','gong-si-dong-tai','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('41','34','行业新闻','','','0','','','','','','xing-ye-xin-wen','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','1','1','0','','0','0','','0','1','0.00','0.00');-- 
INSERT INTO `cmseasy_b_category` VALUES('71','0','我们的客户','Our customers','','7000','','','','','','Ourcustomers','0','0','0','0','0','0','0','','','','article','1','0','0','1','1','0','','','','','','0','0','0','0','0','','0','0','','0','1','0.00','0.00');-- 
