DROP TABLE IF EXISTS ts_ad;
CREATE TABLE `ts_ad` (
  `ad_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `place` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:中部 1:头部 2:左侧 3:右侧 4:底部',
  `content` text,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_closable` tinyint(1) NOT NULL DEFAULT '0',
  `ctime` int(11) DEFAULT NULL,
  `mtime` int(11) DEFAULT NULL,
  `display_order` smallint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ad_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO ts_ad VALUES ('1','顶部广告A1','1','&lt;p&gt;&lt;a target=&quot;_self&quot; title=&quot;&quot; href=&quot;http://zhimei.okhaoa.com&quot;&gt;&lt;img style=&quot;height:158px;width:960px;float:none;margin:0px;&quot; alt=&quot;&quot; src=&quot;http://zhimei.36hua.cn/data/uploads/2012/0309/00/4f58e20aa0d9f.gif&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','0','0','1311220105','1333801172','1');
INSERT INTO ts_ad VALUES ('2','中部广告B1','0','&lt;p&gt;&lt;a target=&quot;_blank&quot; title=&quot;&quot; href=&quot;http://www.okhaoa.com&quot;&gt;&lt;img style=&quot;float:none;margin:0px;&quot; alt=&quot;&quot; src=&quot;http://b.imimg.cn/ad/2012/02/1328767939888.222.300.jpg&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','0','0','1311220801','1333847816','2');
INSERT INTO ts_ad VALUES ('3','首页左侧广告','2','&lt;p&gt;&lt;a target=&quot;_blank&quot; title=&quot;&quot; href=&quot;http://www.okhaoa.com&quot;&gt;&lt;img style=&quot;float:none;margin:0px;&quot; alt=&quot;&quot; src=&quot;http://i.mmcdn.cn/simba/img/T1eHOQXc4dXXXXXXXX.jpg?noq=y&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','0','0','1311221294','1333847881','3');
INSERT INTO ts_ad VALUES ('4','右侧广告A3','3','&lt;p&gt;&lt;a target=&quot;_self&quot; title=&quot;&quot; href=&quot;http://www.okhaoa.com&quot;&gt;&lt;img style=&quot;float:none;margin:0px;&quot; alt=&quot;&quot; src=&quot;http://static.im20.com.cn/zhimei/ad/2012/03/1330942930577.222.300.jpg&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','0','0','1311221323','1333847890','4');
INSERT INTO ts_ad VALUES ('5','底部广告A2','4','&lt;p&gt;&lt;a target=&quot;_self&quot; title=&quot;&quot; href=&quot;http://www.okhaoa.com&quot;&gt;&lt;img style=&quot;height:80px;width:966px;float:none;margin:0px;&quot; alt=&quot;&quot; src=&quot;http://s6.mogujie.cn/pic/111220/1_kqytaq22krbeg2dwgfjeg5sckzsew_960x80.jpg&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','0','0','1311221331','1333847899','5');
INSERT INTO ts_ad VALUES ('6','首页动画右栏文字','6','&lt;ul class=&quot;gray png&quot;&gt;&lt;li&gt;&lt;h3&gt;&lt;span class=&quot;yahe&quot;&gt;知美网免费送小米手机&lt;/span&gt;&lt;/h3&gt;&lt;p class=&quot;aligncenter&quot;&gt;白拿小米？机不可失！第&lt;a class=&quot;gray&quot;&gt;二&lt;/a&gt;期走起！&lt;/p&gt;&lt;/li&gt;&lt;li&gt;&lt;h3&gt;&lt;span class=&quot;yahe&quot;&gt;纯爷们必选&lt;/span&gt;&lt;/h3&gt;&lt;p class=&quot;aligncenter&quot;&gt;不是飞行员，但要有件飞行夹克&lt;/p&gt;&lt;/li&gt;&lt;li&gt;&lt;h3&gt;&lt;span class=&quot;yahe&quot;&gt;让女人爱恨交加的高跟鞋&lt;/span&gt;&lt;/h3&gt;&lt;p class=&quot;aligncenter&quot;&gt;来晒晒你的高跟鞋欲望，还能赢礼物！&lt;/p&gt;&lt;/li&gt;&lt;/ul&gt;','1','0','1331023087','1333847991','6');
INSERT INTO ts_ad VALUES ('7','首页切换图片1','5','&lt;p&gt;&lt;a title=&quot;好乐淘&quot; target=&quot;_blank&quot; href=&quot;http://www.okhaoa.com&quot;&gt;&lt;img style=&quot;float:none;margin:0px;&quot; alt=&quot;&quot; src=&quot;http://www.taoshare.net/img/ad/01.jpg&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','1','0','1331023109','1334712355','7');
INSERT INTO ts_ad VALUES ('8','首页切换图片2','5','&lt;p&gt;&lt;a target=&quot;_self&quot; title=&quot;&quot; href=&quot;http://www.okhaoa.com/&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://b.zhimei.com/ad/2012/03/1330567886676.950.300.jpg&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','1','0','1331023130','1333848005','8');
INSERT INTO ts_ad VALUES ('9','首页切换图片3','5','&lt;p&gt;&lt;a target=&quot;_self&quot; title=&quot;&quot; href=&quot;http://www.okhaoa.com/&quot;&gt;&lt;img style=&quot;float:none;margin:0px;&quot; alt=&quot;&quot; src=&quot;http://b.zhimei.com/ad/2012/03/1330929591393.950.300.jpg&quot; /&gt;&lt;/a&gt;&lt;/p&gt;','1','0','1331023177','1333848015','9');
INSERT INTO ts_ad VALUES ('10','首页切换图片4','5','&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;http://b.zhimei.com/ad/2012/02/1330480319640.950.300.jpg&quot; /&gt;&lt;/p&gt;','1','0','1331225455','1333848042','10');
INSERT INTO ts_ad VALUES ('11','首页中部广告','0','&lt;div class=&quot;cneterbanner cf&quot;&gt;&lt;span class=&quot;floatright&quot; id=&quot;js-ad-show4&quot;&gt;&lt;a class=&quot;js-ad-click&quot; data-id=&quot;4f607b8d0cf258903628e9b9&quot; target=&quot;_blank&quot; title=&quot;&quot; href=&quot;http://www.okhaoa.com&quot;&gt;&lt;img src=&quot;http://static.im20.com.cn/zhimei/ad/2012/03/1331723143872.470.80.gif&quot; /&gt;&lt;/a&gt; &lt;/span&gt; &lt;span id=&quot;js-ad-show5&quot;&gt;&lt;a class=&quot;js-ad-click&quot; data-id=&quot;4f607bcc0cf258903628ea04&quot; target=&quot;_blank&quot; href=&quot;http://www.36hua.cn&quot;&gt;&lt;img src=&quot;http://static.im20.com.cn/zhimei/ad/2012/03/1331723202110.470.80.png&quot; /&gt;&lt;/a&gt; &lt;/span&gt;&lt;/div&gt;','0','0','1331972301','1333847832','11');

DROP TABLE IF EXISTS ts_admin_log;
CREATE TABLE `ts_admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `uid` int(11) NOT NULL COMMENT '操作人UID',
  `type` tinyint(4) NOT NULL,
  `data` text NOT NULL,
  `ctime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO ts_admin_log VALUES ('1','1','2','a:2:{i:0;s:30:\"扩展 - 工具 - 数据备份\";i:1;a:1:{i:0;s:19:\"120418_ae03cc9204_1\";}}','1334753448');
INSERT INTO ts_admin_log VALUES ('2','1','2','a:2:{i:0;s:21:\"应用 - 卸载应用\";i:1;N;}','1334757539');
INSERT INTO ts_admin_log VALUES ('3','1','2','a:2:{i:0;s:30:\"扩展 - 工具 - 数据备份\";i:1;a:1:{i:0;s:19:\"120418_def1f52f7f_1\";}}','1334757627');
INSERT INTO ts_admin_log VALUES ('4','1','3','a:3:{i:0;s:22:\"用户 - 用户管理 \";i:1;a:10:{s:3:\"uid\";s:1:\"1\";s:5:\"email\";s:20:\"hope_fox@foxmail.com\";s:8:\"password\";s:32:\"c311bafa78812dc7b856d890e443fe67\";s:5:\"uname\";s:6:\"小编\";s:6:\"domain\";s:0:\"\";s:3:\"sex\";s:1:\"0\";s:9:\"is_active\";s:1:\"1\";s:6:\"scorea\";s:1:\"0\";s:10:\"experience\";s:4:\"2950\";s:13:\"user_group_id\";s:1:\"1\";}i:2;a:10:{s:3:\"uid\";i:1;s:5:\"email\";s:15:\"admin@admin.com\";s:8:\"password\";s:9:\"642779123\";s:5:\"uname\";s:6:\"Popeye\";s:6:\"domain\";s:0:\"\";s:3:\"sex\";s:1:\"0\";s:5:\"score\";s:4:\"1851\";s:10:\"experience\";s:4:\"2950\";s:9:\"is_active\";s:1:\"1\";s:13:\"user_group_id\";s:1:\"1\";}}','1334757680');
INSERT INTO ts_admin_log VALUES ('5','1','1','a:2:{i:0;s:30:\"扩展 - 工具 - 数据备份\";i:1;a:1:{i:0;s:30:\"全部数据表都备份成功\";}}','1334757737');
INSERT INTO ts_admin_log VALUES ('6','1','3','a:3:{i:0;s:22:\"用户 - 用户管理 \";i:1;a:10:{s:3:\"uid\";s:1:\"1\";s:5:\"email\";s:15:\"admin@admin.com\";s:8:\"password\";s:32:\"b3467ab5f4393291d8088313460f49af\";s:5:\"uname\";s:6:\"Popeye\";s:6:\"domain\";s:0:\"\";s:3:\"sex\";s:1:\"0\";s:9:\"is_active\";s:1:\"1\";s:6:\"scorea\";s:1:\"0\";s:10:\"experience\";s:4:\"2950\";s:13:\"user_group_id\";s:1:\"1\";}i:2;a:10:{s:3:\"uid\";i:1;s:5:\"email\";s:15:\"admin@admin.com\";s:8:\"password\";s:9:\"642779123\";s:5:\"uname\";s:6:\"Popeye\";s:6:\"domain\";s:0:\"\";s:3:\"sex\";s:1:\"0\";s:5:\"score\";s:4:\"1851\";s:10:\"experience\";s:4:\"2950\";s:9:\"is_active\";s:1:\"1\";s:13:\"user_group_id\";s:1:\"1\";}}','1334757943');
INSERT INTO ts_admin_log VALUES ('7','1','2','a:2:{i:0;s:30:\"扩展 - 工具 - 数据备份\";i:1;a:1:{i:0;s:19:\"120418_94d8585068_1\";}}','1334757949');
INSERT INTO ts_admin_log VALUES ('8','1','3','a:3:{i:0;s:22:\"用户 - 用户管理 \";i:1;a:10:{s:3:\"uid\";s:1:\"1\";s:5:\"email\";s:15:\"admin@admin.com\";s:8:\"password\";s:32:\"b3467ab5f4393291d8088313460f49af\";s:5:\"uname\";s:6:\"Popeye\";s:6:\"domain\";s:0:\"\";s:3:\"sex\";s:1:\"0\";s:9:\"is_active\";s:1:\"1\";s:6:\"scorea\";s:1:\"0\";s:10:\"experience\";s:4:\"2950\";s:13:\"user_group_id\";s:1:\"1\";}i:2;a:10:{s:3:\"uid\";i:1;s:5:\"email\";s:15:\"admin@admin.com\";s:8:\"password\";s:6:\"123456\";s:5:\"uname\";s:6:\"小编\";s:6:\"domain\";s:0:\"\";s:3:\"sex\";s:1:\"0\";s:5:\"score\";s:4:\"1851\";s:10:\"experience\";s:4:\"2950\";s:9:\"is_active\";s:1:\"1\";s:13:\"user_group_id\";s:0:\"\";}}','1335668476');
INSERT INTO ts_admin_log VALUES ('9','1','3','a:3:{i:0;s:22:\"全局 - 站点配置 \";i:1;a:18:{s:19:\"site_system_version\";s:12:\"ThinkSNS 2.3\";s:26:\"site_system_version_number\";s:5:\"15520\";s:8:\"__hash__\";s:32:\"f9d2155a200139766ad5aa2e4606504c\";s:9:\"site_name\";s:9:\"淘分享\";s:11:\"site_slogan\";s:51:\"随时随地收集、分享生活的创意和美丽\";s:20:\"site_header_keywords\";s:25:\"购物分享,购物导航\";s:23:\"site_header_description\";s:248:\"分享收集生活中的美好，找到与你气味相投的人，遇见世界上的另外一个你。这里有关于手工DIY、时尚生活、插画手绘、短发发型、背景墙、lookbook、美食菜谱、潮流等等应有尽有的图片。\";s:11:\"site_closed\";i:0;s:18:\"site_closed_reason\";s:0:\"\";s:14:\"site_anonymous\";s:1:\"1\";s:21:\"site_anonymous_square\";s:1:\"1\";s:21:\"site_anonymous_search\";s:1:\"1\";s:19:\"site_user_domain_on\";s:1:\"1\";s:17:\"site_user_visited\";s:1:\"1\";s:22:\"site_appalias_wordwrap\";s:1:\"1\";s:8:\"site_icp\";s:0:\"\";s:10:\"site_theme\";s:6:\"zhimei\";s:11:\"site_verify\";a:1:{i:0;s:8:\"register\";}}i:2;a:16:{s:9:\"site_name\";s:12:\"品图加加\";s:11:\"site_slogan\";s:51:\"随时随地收集、分享生活的创意和美丽\";s:20:\"site_header_keywords\";s:24:\"品图——识天下！\";s:23:\"site_header_description\";s:248:\"分享收集生活中的美好，找到与你气味相投的人，遇见世界上的另外一个你。这里有关于手工DIY、时尚生活、插画手绘、短发发型、背景墙、lookbook、美食菜谱、潮流等等应有尽有的图片。\";s:11:\"site_closed\";i:0;s:18:\"site_closed_reason\";s:0:\"\";s:14:\"site_anonymous\";s:1:\"1\";s:21:\"site_anonymous_square\";s:1:\"1\";s:21:\"site_anonymous_search\";s:1:\"1\";s:19:\"site_user_domain_on\";s:1:\"1\";s:17:\"site_user_visited\";s:1:\"1\";s:22:\"site_appalias_wordwrap\";s:1:\"1\";s:8:\"site_icp\";s:0:\"\";s:10:\"site_theme\";s:6:\"zhimei\";s:9:\"site_logo\";s:0:\"\";s:11:\"site_verify\";a:1:{i:0;s:8:\"register\";}}}','1342099203');
INSERT INTO ts_admin_log VALUES ('10','1','1','a:2:{i:0;s:30:\"扩展 - 工具 - 数据备份\";i:1;a:1:{i:0;s:30:\"全部数据表都备份成功\";}}','1342101129');
INSERT INTO ts_admin_log VALUES ('11','1','1','a:2:{i:0;s:22:\"应用 - 安装应用 \";i:1;a:22:{s:9:\"host_type\";i:0;s:12:\"homepage_url\";s:0:\"\";s:23:\"sidebar_support_submenu\";i:0;s:11:\"author_name\";s:6:\"haixia\";s:12:\"author_email\";s:19:\"haixia@thinksns.com\";s:19:\"author_homepage_url\";s:0:\"\";s:16:\"contributor_name\";s:39:\"廖素南，陈伟川，赵杰，申川\";s:12:\"release_date\";s:10:\"2008-08-08\";s:16:\"last_update_date\";s:9:\"2011-2-16\";s:8:\"app_name\";s:5:\"group\";s:9:\"app_alias\";s:6:\"群组\";s:11:\"description\";s:30:\"创建群组，发起话题。\";s:8:\"category\";s:6:\"工具\";s:9:\"app_entry\";s:11:\"Index/index\";s:8:\"icon_url\";s:66:\"http://vip.pintujiajia.com/zhimei/apps/group/Appinfo/ico_app24.png\";s:14:\"large_icon_url\";s:64:\"http://vip.pintujiajia.com/zhimei/apps/group/Appinfo/ico_app.png\";s:11:\"admin_entry\";s:11:\"Admin/index\";s:16:\"statistics_entry\";s:26:\"GroupStatistics/statistics\";s:13:\"sidebar_title\";s:0:\"\";s:13:\"sidebar_entry\";s:0:\"\";s:16:\"sidebar_icon_url\";s:0:\"\";s:25:\"sidebar_is_submenu_active\";i:0;}}','1342103127');
INSERT INTO ts_admin_log VALUES ('12','1','3','a:2:{i:0;s:21:\"应用 - 设置状态\";i:1;a:2:{s:6:\"app_id\";s:1:\"1\";s:6:\"status\";s:1:\"1\";}}','1342103133');
INSERT INTO ts_admin_log VALUES ('13','1','2','a:2:{i:0;s:21:\"应用 - 卸载应用\";i:1;a:26:{s:4:\"name\";s:6:\"群组\";s:11:\"description\";s:30:\"创建群组，发起话题。\";s:9:\"host_type\";s:1:\"0\";s:9:\"app_entry\";s:11:\"Index/index\";s:8:\"icon_url\";s:66:\"http://vip.pintujiajia.com/zhimei/apps/group/Appinfo/ico_app24.png\";s:14:\"large_icon_url\";s:64:\"http://vip.pintujiajia.com/zhimei/apps/group/Appinfo/ico_app.png\";s:14:\"version_number\";s:5:\"16095\";s:11:\"admin_entry\";s:11:\"Admin/index\";s:16:\"statistics_entry\";s:26:\"GroupStatistics/statistics\";s:12:\"homepage_url\";s:0:\"\";s:8:\"category\";s:6:\"工具\";s:12:\"release_date\";s:10:\"2008-08-08\";s:16:\"last_update_date\";s:9:\"2011-2-16\";s:13:\"sidebar_title\";s:0:\"\";s:13:\"sidebar_entry\";s:0:\"\";s:16:\"sidebar_icon_url\";s:0:\"\";s:23:\"sidebar_support_submenu\";s:1:\"0\";s:11:\"author_name\";s:6:\"haixia\";s:12:\"author_email\";s:19:\"haixia@thinksns.com\";s:19:\"author_homepage_url\";s:0:\"\";s:17:\"contributor_names\";s:39:\"廖素南，陈伟川，赵杰，申川\";s:15:\"host_type_alias\";s:12:\"本地应用\";s:9:\"app_alias\";s:6:\"群组\";s:9:\"path_name\";s:5:\"group\";s:8:\"app_name\";s:5:\"group\";s:16:\"contributor_name\";s:39:\"廖素南，陈伟川，赵杰，申川\";}}','1342106364');
INSERT INTO ts_admin_log VALUES ('14','1','2','a:2:{i:0;s:30:\"扩展 - 工具 - 数据备份\";i:1;a:1:{i:0;s:19:\"120712_60183b0e65_1\";}}','1342159994');
INSERT INTO ts_admin_log VALUES ('15','1','3','a:3:{i:0;s:22:\"全局 - 站点配置 \";i:1;a:19:{s:19:\"site_system_version\";s:12:\"ThinkSNS 2.3\";s:26:\"site_system_version_number\";s:5:\"15520\";s:8:\"__hash__\";s:32:\"f9d2155a200139766ad5aa2e4606504c\";s:9:\"site_name\";s:12:\"品图加加\";s:11:\"site_slogan\";s:51:\"随时随地收集、分享生活的创意和美丽\";s:20:\"site_header_keywords\";s:24:\"品图——识天下！\";s:23:\"site_header_description\";s:248:\"分享收集生活中的美好，找到与你气味相投的人，遇见世界上的另外一个你。这里有关于手工DIY、时尚生活、插画手绘、短发发型、背景墙、lookbook、美食菜谱、潮流等等应有尽有的图片。\";s:11:\"site_closed\";i:0;s:18:\"site_closed_reason\";s:0:\"\";s:14:\"site_anonymous\";s:1:\"1\";s:21:\"site_anonymous_square\";s:1:\"1\";s:21:\"site_anonymous_search\";s:1:\"1\";s:19:\"site_user_domain_on\";s:1:\"1\";s:17:\"site_user_visited\";s:1:\"1\";s:22:\"site_appalias_wordwrap\";s:1:\"1\";s:8:\"site_icp\";s:0:\"\";s:10:\"site_theme\";s:6:\"zhimei\";s:9:\"site_logo\";s:0:\"\";s:11:\"site_verify\";a:1:{i:0;s:8:\"register\";}}i:2;a:16:{s:9:\"site_name\";s:12:\"品图加加\";s:11:\"site_slogan\";s:24:\"品图——识天下！\";s:20:\"site_header_keywords\";s:6:\"品图\";s:23:\"site_header_description\";s:248:\"分享收集生活中的美好，找到与你气味相投的人，遇见世界上的另外一个你。这里有关于手工DIY、时尚生活、插画手绘、短发发型、背景墙、lookbook、美食菜谱、潮流等等应有尽有的图片。\";s:11:\"site_closed\";i:0;s:18:\"site_closed_reason\";s:0:\"\";s:14:\"site_anonymous\";s:1:\"1\";s:21:\"site_anonymous_square\";s:1:\"1\";s:21:\"site_anonymous_search\";s:1:\"1\";s:19:\"site_user_domain_on\";s:1:\"1\";s:17:\"site_user_visited\";s:1:\"1\";s:22:\"site_appalias_wordwrap\";s:1:\"1\";s:8:\"site_icp\";s:0:\"\";s:10:\"site_theme\";s:6:\"zhimei\";s:9:\"site_logo\";s:0:\"\";s:11:\"site_verify\";a:1:{i:0;s:8:\"register\";}}}','1342160027');
INSERT INTO ts_admin_log VALUES ('16','1','3','a:3:{i:0;s:22:\"全局 - 平台配置 \";i:1;a:8:{s:12:\"sina_wb_akey\";s:0:\"\";s:12:\"sina_wb_skey\";s:0:\"\";s:10:\"douban_key\";s:0:\"\";s:13:\"douban_secret\";s:0:\"\";s:6:\"qq_key\";s:0:\"\";s:9:\"qq_secret\";s:0:\"\";s:10:\"taobao_key\";s:8:\"12166995\";s:13:\"taobao_secret\";s:32:\"fe0c6fafc476d2fc0555e2f52389f786\";}i:2;a:10:{s:12:\"sina_wb_akey\";s:0:\"\";s:12:\"sina_wb_skey\";s:0:\"\";s:10:\"douban_key\";s:0:\"\";s:13:\"douban_secret\";s:0:\"\";s:6:\"qq_key\";s:0:\"\";s:9:\"qq_secret\";s:0:\"\";s:10:\"taobao_key\";s:8:\"12166995\";s:13:\"taobao_secret\";s:32:\"fe0c6fafc476d2fc0555e2f52389f786\";s:12:\"taobaoke_key\";s:15:\"mm_18680880_0_0\";s:13:\"taobaoke_nick\";s:15:\"山东孟尝君\";}}','1342160194');

DROP TABLE IF EXISTS ts_app;
CREATE TABLE `ts_app` (
  `app_id` int(11) NOT NULL AUTO_INCREMENT,
  `app_name` varchar(255) NOT NULL,
  `app_alias` varchar(255) NOT NULL,
  `description` text,
  `version` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0:关闭 1:默认 2:可选',
  `category` varchar(255) DEFAULT NULL,
  `release_date` varchar(255) DEFAULT NULL,
  `last_update_date` varchar(255) DEFAULT NULL,
  `host_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0：本地应用 1：远程应用',
  `app_entry` varchar(255) DEFAULT NULL,
  `icon_url` varchar(255) DEFAULT NULL,
  `large_icon_url` varchar(255) DEFAULT NULL,
  `admin_entry` varchar(255) DEFAULT NULL,
  `statistics_entry` varchar(255) DEFAULT NULL,
  `homepage_url` varchar(255) DEFAULT NULL,
  `sidebar_title` varchar(255) DEFAULT NULL,
  `sidebar_entry` varchar(255) DEFAULT NULL,
  `sidebar_icon_url` varchar(255) DEFAULT NULL,
  `sidebar_support_submenu` tinyint(1) NOT NULL DEFAULT '0',
  `sidebar_is_submenu_active` tinyint(1) NOT NULL DEFAULT '0',
  `author_name` varchar(255) DEFAULT NULL,
  `author_email` varchar(255) DEFAULT NULL,
  `author_homepage_url` varchar(255) DEFAULT NULL,
  `contributor_name` text,
  `display_order` smallint(5) NOT NULL DEFAULT '0',
  `ctime` int(11) DEFAULT NULL,
  PRIMARY KEY (`app_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_area;
CREATE TABLE `ts_area` (
  `area_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `pid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=3235 DEFAULT CHARSET=utf8;

INSERT INTO ts_area VALUES ('1','北京','0');
INSERT INTO ts_area VALUES ('2','北京市','1');
INSERT INTO ts_area VALUES ('3','东城区','2');
INSERT INTO ts_area VALUES ('4','西城区','2');
INSERT INTO ts_area VALUES ('5','崇文区','2');
INSERT INTO ts_area VALUES ('6','宣武区','2');
INSERT INTO ts_area VALUES ('7','朝阳区','2');
INSERT INTO ts_area VALUES ('8','丰台区','2');
INSERT INTO ts_area VALUES ('9','石景山区','2');
INSERT INTO ts_area VALUES ('10','海淀区','2');
INSERT INTO ts_area VALUES ('11','门头沟区','2');
INSERT INTO ts_area VALUES ('12','房山区','2');
INSERT INTO ts_area VALUES ('13','通州区','2');
INSERT INTO ts_area VALUES ('14','顺义区','2');
INSERT INTO ts_area VALUES ('15','昌平区','2');
INSERT INTO ts_area VALUES ('16','大兴区','2');
INSERT INTO ts_area VALUES ('17','怀柔区','2');
INSERT INTO ts_area VALUES ('18','平谷区','2');
INSERT INTO ts_area VALUES ('19','密云县','2');
INSERT INTO ts_area VALUES ('20','延庆县','2');
INSERT INTO ts_area VALUES ('21','天津','0');
INSERT INTO ts_area VALUES ('22','天津市','21');
INSERT INTO ts_area VALUES ('23','和平区','22');
INSERT INTO ts_area VALUES ('24','河东区','22');
INSERT INTO ts_area VALUES ('25','河西区','22');
INSERT INTO ts_area VALUES ('26','南开区','22');
INSERT INTO ts_area VALUES ('27','河北区','22');
INSERT INTO ts_area VALUES ('28','红桥区','22');
INSERT INTO ts_area VALUES ('29','塘沽区','22');
INSERT INTO ts_area VALUES ('30','汉沽区','22');
INSERT INTO ts_area VALUES ('31','大港区','22');
INSERT INTO ts_area VALUES ('32','东丽区','22');
INSERT INTO ts_area VALUES ('33','西青区','22');
INSERT INTO ts_area VALUES ('34','津南区','22');
INSERT INTO ts_area VALUES ('35','北辰区','22');
INSERT INTO ts_area VALUES ('36','武清区','22');
INSERT INTO ts_area VALUES ('37','宝坻区','22');
INSERT INTO ts_area VALUES ('38','宁河县','22');
INSERT INTO ts_area VALUES ('39','静海县','22');
INSERT INTO ts_area VALUES ('40','蓟县','22');
INSERT INTO ts_area VALUES ('41','河北','0');
INSERT INTO ts_area VALUES ('42','石家庄市','41');
INSERT INTO ts_area VALUES ('43','长安区','42');
INSERT INTO ts_area VALUES ('44','桥东区','42');
INSERT INTO ts_area VALUES ('45','桥西区','42');
INSERT INTO ts_area VALUES ('46','新华区','42');
INSERT INTO ts_area VALUES ('47','井陉矿区','42');
INSERT INTO ts_area VALUES ('48','裕华区','42');
INSERT INTO ts_area VALUES ('49','井陉县','42');
INSERT INTO ts_area VALUES ('50','正定县','42');
INSERT INTO ts_area VALUES ('51','栾城县','42');
INSERT INTO ts_area VALUES ('52','行唐县','42');
INSERT INTO ts_area VALUES ('53','灵寿县','42');
INSERT INTO ts_area VALUES ('54','高邑县','42');
INSERT INTO ts_area VALUES ('55','深泽县','42');
INSERT INTO ts_area VALUES ('56','赞皇县','42');
INSERT INTO ts_area VALUES ('57','无极县','42');
INSERT INTO ts_area VALUES ('58','平山县','42');
INSERT INTO ts_area VALUES ('59','元氏县','42');
INSERT INTO ts_area VALUES ('60','赵县','42');
INSERT INTO ts_area VALUES ('61','辛集市','42');
INSERT INTO ts_area VALUES ('62','藁城市','42');
INSERT INTO ts_area VALUES ('63','晋州市','42');
INSERT INTO ts_area VALUES ('64','新乐市','42');
INSERT INTO ts_area VALUES ('65','鹿泉市','42');
INSERT INTO ts_area VALUES ('66','唐山市','41');
INSERT INTO ts_area VALUES ('67','路南区','66');
INSERT INTO ts_area VALUES ('68','路北区','66');
INSERT INTO ts_area VALUES ('69','古冶区','66');
INSERT INTO ts_area VALUES ('70','开平区','66');
INSERT INTO ts_area VALUES ('71','丰南区','66');
INSERT INTO ts_area VALUES ('72','丰润区','66');
INSERT INTO ts_area VALUES ('73','滦县','66');
INSERT INTO ts_area VALUES ('74','滦南县','66');
INSERT INTO ts_area VALUES ('75','乐亭县','66');
INSERT INTO ts_area VALUES ('76','迁西县','66');
INSERT INTO ts_area VALUES ('77','玉田县','66');
INSERT INTO ts_area VALUES ('78','唐海县','66');
INSERT INTO ts_area VALUES ('79','遵化市','66');
INSERT INTO ts_area VALUES ('80','迁安市','66');
INSERT INTO ts_area VALUES ('81','秦皇岛市','41');
INSERT INTO ts_area VALUES ('82','海港区','81');
INSERT INTO ts_area VALUES ('83','山海关区','81');
INSERT INTO ts_area VALUES ('84','北戴河区','81');
INSERT INTO ts_area VALUES ('85','青龙满族自治县','81');
INSERT INTO ts_area VALUES ('86','昌黎县','81');
INSERT INTO ts_area VALUES ('87','抚宁县','81');
INSERT INTO ts_area VALUES ('88','卢龙县','81');
INSERT INTO ts_area VALUES ('89','邯郸市','41');
INSERT INTO ts_area VALUES ('90','邯山区','89');
INSERT INTO ts_area VALUES ('91','丛台区','89');
INSERT INTO ts_area VALUES ('92','复兴区','89');
INSERT INTO ts_area VALUES ('93','峰峰矿区','89');
INSERT INTO ts_area VALUES ('94','邯郸县','89');
INSERT INTO ts_area VALUES ('95','临漳县','89');
INSERT INTO ts_area VALUES ('96','成安县','89');
INSERT INTO ts_area VALUES ('97','大名县','89');
INSERT INTO ts_area VALUES ('98','涉县','89');
INSERT INTO ts_area VALUES ('99','磁县','89');
INSERT INTO ts_area VALUES ('100','肥乡县','89');
INSERT INTO ts_area VALUES ('101','永年县','89');
INSERT INTO ts_area VALUES ('102','邱县','89');
INSERT INTO ts_area VALUES ('103','鸡泽县','89');
INSERT INTO ts_area VALUES ('104','广平县','89');
INSERT INTO ts_area VALUES ('105','馆陶县','89');
INSERT INTO ts_area VALUES ('106','魏县','89');
INSERT INTO ts_area VALUES ('107','曲周县','89');
INSERT INTO ts_area VALUES ('108','武安市','89');
INSERT INTO ts_area VALUES ('109','邢台市','41');
INSERT INTO ts_area VALUES ('110','桥东区','109');
INSERT INTO ts_area VALUES ('111','桥西区','109');
INSERT INTO ts_area VALUES ('112','邢台县','109');
INSERT INTO ts_area VALUES ('113','临城县','109');
INSERT INTO ts_area VALUES ('114','内丘县','109');
INSERT INTO ts_area VALUES ('115','柏乡县','109');
INSERT INTO ts_area VALUES ('116','隆尧县','109');
INSERT INTO ts_area VALUES ('117','任县','109');
INSERT INTO ts_area VALUES ('118','南和县','109');
INSERT INTO ts_area VALUES ('119','宁晋县','109');
INSERT INTO ts_area VALUES ('120','巨鹿县','109');
INSERT INTO ts_area VALUES ('121','新河县','109');
INSERT INTO ts_area VALUES ('122','广宗县','109');
INSERT INTO ts_area VALUES ('123','平乡县','109');
INSERT INTO ts_area VALUES ('124','威县','109');
INSERT INTO ts_area VALUES ('125','清河县','109');
INSERT INTO ts_area VALUES ('126','临西县','109');
INSERT INTO ts_area VALUES ('127','南宫市','109');
INSERT INTO ts_area VALUES ('128','沙河市','109');
INSERT INTO ts_area VALUES ('129','保定市','41');
INSERT INTO ts_area VALUES ('130','新市区','129');
INSERT INTO ts_area VALUES ('131','北市区','129');
INSERT INTO ts_area VALUES ('132','南市区','129');
INSERT INTO ts_area VALUES ('133','满城县','129');
INSERT INTO ts_area VALUES ('134','清苑县','129');
INSERT INTO ts_area VALUES ('135','涞水县','129');
INSERT INTO ts_area VALUES ('136','阜平县','129');
INSERT INTO ts_area VALUES ('137','徐水县','129');
INSERT INTO ts_area VALUES ('138','定兴县','129');
INSERT INTO ts_area VALUES ('139','唐县','129');
INSERT INTO ts_area VALUES ('140','高阳县','129');
INSERT INTO ts_area VALUES ('141','容城县','129');
INSERT INTO ts_area VALUES ('142','涞源县','129');
INSERT INTO ts_area VALUES ('143','望都县','129');
INSERT INTO ts_area VALUES ('144','安新县','129');
INSERT INTO ts_area VALUES ('145','易县','129');
INSERT INTO ts_area VALUES ('146','曲阳县','129');
INSERT INTO ts_area VALUES ('147','蠡县','129');
INSERT INTO ts_area VALUES ('148','顺平县','129');
INSERT INTO ts_area VALUES ('149','博野县','129');
INSERT INTO ts_area VALUES ('150','雄县','129');
INSERT INTO ts_area VALUES ('151','涿州市','129');
INSERT INTO ts_area VALUES ('152','定州市','129');
INSERT INTO ts_area VALUES ('153','安国市','129');
INSERT INTO ts_area VALUES ('154','高碑店市','129');
INSERT INTO ts_area VALUES ('155','张家口市','41');
INSERT INTO ts_area VALUES ('156','桥东区','155');
INSERT INTO ts_area VALUES ('157','桥西区','155');
INSERT INTO ts_area VALUES ('158','宣化区','155');
INSERT INTO ts_area VALUES ('159','下花园区','155');
INSERT INTO ts_area VALUES ('160','宣化县','155');
INSERT INTO ts_area VALUES ('161','张北县','155');
INSERT INTO ts_area VALUES ('162','康保县','155');
INSERT INTO ts_area VALUES ('163','沽源县','155');
INSERT INTO ts_area VALUES ('164','尚义县','155');
INSERT INTO ts_area VALUES ('165','蔚县','155');
INSERT INTO ts_area VALUES ('166','阳原县','155');
INSERT INTO ts_area VALUES ('167','怀安县','155');
INSERT INTO ts_area VALUES ('168','万全县','155');
INSERT INTO ts_area VALUES ('169','怀来县','155');
INSERT INTO ts_area VALUES ('170','涿鹿县','155');
INSERT INTO ts_area VALUES ('171','赤城县','155');
INSERT INTO ts_area VALUES ('172','崇礼县','155');
INSERT INTO ts_area VALUES ('173','承德市','41');
INSERT INTO ts_area VALUES ('174','双桥区','173');
INSERT INTO ts_area VALUES ('175','双滦区','173');
INSERT INTO ts_area VALUES ('176','鹰手营子矿区','173');
INSERT INTO ts_area VALUES ('177','承德县','173');
INSERT INTO ts_area VALUES ('178','兴隆县','173');
INSERT INTO ts_area VALUES ('179','平泉县','173');
INSERT INTO ts_area VALUES ('180','滦平县','173');
INSERT INTO ts_area VALUES ('181','隆化县','173');
INSERT INTO ts_area VALUES ('182','丰宁满族自治县','173');
INSERT INTO ts_area VALUES ('183','宽城满族自治县','173');
INSERT INTO ts_area VALUES ('184','围场满族蒙古族自治县','173');
INSERT INTO ts_area VALUES ('185','沧州市','41');
INSERT INTO ts_area VALUES ('186','新华区','185');
INSERT INTO ts_area VALUES ('187','运河区','185');
INSERT INTO ts_area VALUES ('188','沧县','185');
INSERT INTO ts_area VALUES ('189','青县','185');
INSERT INTO ts_area VALUES ('190','东光县','185');
INSERT INTO ts_area VALUES ('191','海兴县','185');
INSERT INTO ts_area VALUES ('192','盐山县','185');
INSERT INTO ts_area VALUES ('193','肃宁县','185');
INSERT INTO ts_area VALUES ('194','南皮县','185');
INSERT INTO ts_area VALUES ('195','吴桥县','185');
INSERT INTO ts_area VALUES ('196','献县','185');
INSERT INTO ts_area VALUES ('197','孟村回族自治县','185');
INSERT INTO ts_area VALUES ('198','泊头市','185');
INSERT INTO ts_area VALUES ('199','任丘市','185');
INSERT INTO ts_area VALUES ('200','黄骅市','185');
INSERT INTO ts_area VALUES ('201','河间市','185');
INSERT INTO ts_area VALUES ('202','廊坊市','41');
INSERT INTO ts_area VALUES ('203','安次区','202');
INSERT INTO ts_area VALUES ('204','广阳区','202');
INSERT INTO ts_area VALUES ('205','固安县','202');
INSERT INTO ts_area VALUES ('206','永清县','202');
INSERT INTO ts_area VALUES ('207','香河县','202');
INSERT INTO ts_area VALUES ('208','大城县','202');
INSERT INTO ts_area VALUES ('209','文安县','202');
INSERT INTO ts_area VALUES ('210','大厂回族自治县','202');
INSERT INTO ts_area VALUES ('211','霸州市','202');
INSERT INTO ts_area VALUES ('212','三河市','202');
INSERT INTO ts_area VALUES ('213','衡水市','41');
INSERT INTO ts_area VALUES ('214','桃城区','213');
INSERT INTO ts_area VALUES ('215','枣强县','213');
INSERT INTO ts_area VALUES ('216','武邑县','213');
INSERT INTO ts_area VALUES ('217','武强县','213');
INSERT INTO ts_area VALUES ('218','饶阳县','213');
INSERT INTO ts_area VALUES ('219','安平县','213');
INSERT INTO ts_area VALUES ('220','故城县','213');
INSERT INTO ts_area VALUES ('221','景县','213');
INSERT INTO ts_area VALUES ('222','阜城县','213');
INSERT INTO ts_area VALUES ('223','冀州市','213');
INSERT INTO ts_area VALUES ('224','深州市','213');
INSERT INTO ts_area VALUES ('225','山西','0');
INSERT INTO ts_area VALUES ('226','太原市','225');
INSERT INTO ts_area VALUES ('227','小店区','226');
INSERT INTO ts_area VALUES ('228','迎泽区','226');
INSERT INTO ts_area VALUES ('229','杏花岭区','226');
INSERT INTO ts_area VALUES ('230','尖草坪区','226');
INSERT INTO ts_area VALUES ('231','万柏林区','226');
INSERT INTO ts_area VALUES ('232','晋源区','226');
INSERT INTO ts_area VALUES ('233','清徐县','226');
INSERT INTO ts_area VALUES ('234','阳曲县','226');
INSERT INTO ts_area VALUES ('235','娄烦县','226');
INSERT INTO ts_area VALUES ('236','古交市','226');
INSERT INTO ts_area VALUES ('237','大同市','225');
INSERT INTO ts_area VALUES ('238','城区','237');
INSERT INTO ts_area VALUES ('239','矿区','237');
INSERT INTO ts_area VALUES ('240','南郊区','237');
INSERT INTO ts_area VALUES ('241','新荣区','237');
INSERT INTO ts_area VALUES ('242','阳高县','237');
INSERT INTO ts_area VALUES ('243','天镇县','237');
INSERT INTO ts_area VALUES ('244','广灵县','237');
INSERT INTO ts_area VALUES ('245','灵丘县','237');
INSERT INTO ts_area VALUES ('246','浑源县','237');
INSERT INTO ts_area VALUES ('247','左云县','237');
INSERT INTO ts_area VALUES ('248','大同县','237');
INSERT INTO ts_area VALUES ('249','阳泉市','225');
INSERT INTO ts_area VALUES ('250','城区','249');
INSERT INTO ts_area VALUES ('251','矿区','249');
INSERT INTO ts_area VALUES ('252','郊区','249');
INSERT INTO ts_area VALUES ('253','平定县','249');
INSERT INTO ts_area VALUES ('254','盂县','249');
INSERT INTO ts_area VALUES ('255','长治市','225');
INSERT INTO ts_area VALUES ('256','城区','255');
INSERT INTO ts_area VALUES ('257','郊区','255');
INSERT INTO ts_area VALUES ('258','长治县','255');
INSERT INTO ts_area VALUES ('259','襄垣县','255');
INSERT INTO ts_area VALUES ('260','屯留县','255');
INSERT INTO ts_area VALUES ('261','平顺县','255');
INSERT INTO ts_area VALUES ('262','黎城县','255');
INSERT INTO ts_area VALUES ('263','壶关县','255');
INSERT INTO ts_area VALUES ('264','长子县','255');
INSERT INTO ts_area VALUES ('265','武乡县','255');
INSERT INTO ts_area VALUES ('266','沁县','255');
INSERT INTO ts_area VALUES ('267','沁源县','255');
INSERT INTO ts_area VALUES ('268','潞城市','255');
INSERT INTO ts_area VALUES ('269','晋城市','225');
INSERT INTO ts_area VALUES ('270','城区','269');
INSERT INTO ts_area VALUES ('271','沁水县','269');
INSERT INTO ts_area VALUES ('272','阳城县','269');
INSERT INTO ts_area VALUES ('273','陵川县','269');
INSERT INTO ts_area VALUES ('274','泽州县','269');
INSERT INTO ts_area VALUES ('275','高平市','269');
INSERT INTO ts_area VALUES ('276','朔州市','225');
INSERT INTO ts_area VALUES ('277','朔城区','276');
INSERT INTO ts_area VALUES ('278','平鲁区','276');
INSERT INTO ts_area VALUES ('279','山阴县','276');
INSERT INTO ts_area VALUES ('280','应县','276');
INSERT INTO ts_area VALUES ('281','右玉县','276');
INSERT INTO ts_area VALUES ('282','怀仁县','276');
INSERT INTO ts_area VALUES ('283','晋中市','225');
INSERT INTO ts_area VALUES ('284','榆次区','283');
INSERT INTO ts_area VALUES ('285','榆社县','283');
INSERT INTO ts_area VALUES ('286','左权县','283');
INSERT INTO ts_area VALUES ('287','和顺县','283');
INSERT INTO ts_area VALUES ('288','昔阳县','283');
INSERT INTO ts_area VALUES ('289','寿阳县','283');
INSERT INTO ts_area VALUES ('290','太谷县','283');
INSERT INTO ts_area VALUES ('291','祁县','283');
INSERT INTO ts_area VALUES ('292','平遥县','283');
INSERT INTO ts_area VALUES ('293','灵石县','283');
INSERT INTO ts_area VALUES ('294','介休市','283');
INSERT INTO ts_area VALUES ('295','运城市','225');
INSERT INTO ts_area VALUES ('296','盐湖区','295');
INSERT INTO ts_area VALUES ('297','临猗县','295');
INSERT INTO ts_area VALUES ('298','万荣县','295');
INSERT INTO ts_area VALUES ('299','闻喜县','295');
INSERT INTO ts_area VALUES ('300','稷山县','295');
INSERT INTO ts_area VALUES ('301','新绛县','295');
INSERT INTO ts_area VALUES ('302','绛县','295');
INSERT INTO ts_area VALUES ('303','垣曲县','295');
INSERT INTO ts_area VALUES ('304','夏县','295');
INSERT INTO ts_area VALUES ('305','平陆县','295');
INSERT INTO ts_area VALUES ('306','芮城县','295');
INSERT INTO ts_area VALUES ('307','永济市','295');
INSERT INTO ts_area VALUES ('308','河津市','295');
INSERT INTO ts_area VALUES ('309','忻州市','225');
INSERT INTO ts_area VALUES ('310','忻府区','309');
INSERT INTO ts_area VALUES ('311','定襄县','309');
INSERT INTO ts_area VALUES ('312','五台县','309');
INSERT INTO ts_area VALUES ('313','代县','309');
INSERT INTO ts_area VALUES ('314','繁峙县','309');
INSERT INTO ts_area VALUES ('315','宁武县','309');
INSERT INTO ts_area VALUES ('316','静乐县','309');
INSERT INTO ts_area VALUES ('317','神池县','309');
INSERT INTO ts_area VALUES ('318','五寨县','309');
INSERT INTO ts_area VALUES ('319','岢岚县','309');
INSERT INTO ts_area VALUES ('320','河曲县','309');
INSERT INTO ts_area VALUES ('321','保德县','309');
INSERT INTO ts_area VALUES ('322','偏关县','309');
INSERT INTO ts_area VALUES ('323','原平市','309');
INSERT INTO ts_area VALUES ('324','临汾市','225');
INSERT INTO ts_area VALUES ('325','尧都区','324');
INSERT INTO ts_area VALUES ('326','曲沃县','324');
INSERT INTO ts_area VALUES ('327','翼城县','324');
INSERT INTO ts_area VALUES ('328','襄汾县','324');
INSERT INTO ts_area VALUES ('329','洪洞县','324');
INSERT INTO ts_area VALUES ('330','古县','324');
INSERT INTO ts_area VALUES ('331','安泽县','324');
INSERT INTO ts_area VALUES ('332','浮山县','324');
INSERT INTO ts_area VALUES ('333','吉县','324');
INSERT INTO ts_area VALUES ('334','乡宁县','324');
INSERT INTO ts_area VALUES ('335','大宁县','324');
INSERT INTO ts_area VALUES ('336','隰县','324');
INSERT INTO ts_area VALUES ('337','永和县','324');
INSERT INTO ts_area VALUES ('338','蒲县','324');
INSERT INTO ts_area VALUES ('339','汾西县','324');
INSERT INTO ts_area VALUES ('340','侯马市','324');
INSERT INTO ts_area VALUES ('341','霍州市','324');
INSERT INTO ts_area VALUES ('342','吕梁市','225');
INSERT INTO ts_area VALUES ('343','离石区','342');
INSERT INTO ts_area VALUES ('344','文水县','342');
INSERT INTO ts_area VALUES ('345','交城县','342');
INSERT INTO ts_area VALUES ('346','兴县','342');
INSERT INTO ts_area VALUES ('347','临县','342');
INSERT INTO ts_area VALUES ('348','柳林县','342');
INSERT INTO ts_area VALUES ('349','石楼县','342');
INSERT INTO ts_area VALUES ('350','岚县','342');
INSERT INTO ts_area VALUES ('351','方山县','342');
INSERT INTO ts_area VALUES ('352','中阳县','342');
INSERT INTO ts_area VALUES ('353','交口县','342');
INSERT INTO ts_area VALUES ('354','孝义市','342');
INSERT INTO ts_area VALUES ('355','汾阳市','342');
INSERT INTO ts_area VALUES ('356','内蒙古','0');
INSERT INTO ts_area VALUES ('357','呼和浩特市','356');
INSERT INTO ts_area VALUES ('358','新城区','357');
INSERT INTO ts_area VALUES ('359','回民区','357');
INSERT INTO ts_area VALUES ('360','玉泉区','357');
INSERT INTO ts_area VALUES ('361','赛罕区','357');
INSERT INTO ts_area VALUES ('362','土默特左旗','357');
INSERT INTO ts_area VALUES ('363','托克托县','357');
INSERT INTO ts_area VALUES ('364','和林格尔县','357');
INSERT INTO ts_area VALUES ('365','清水河县','357');
INSERT INTO ts_area VALUES ('366','武川县','357');
INSERT INTO ts_area VALUES ('367','包头市','356');
INSERT INTO ts_area VALUES ('368','东河区','367');
INSERT INTO ts_area VALUES ('369','昆都仑区','367');
INSERT INTO ts_area VALUES ('370','青山区','367');
INSERT INTO ts_area VALUES ('371','石拐区','367');
INSERT INTO ts_area VALUES ('372','白云矿区','367');
INSERT INTO ts_area VALUES ('373','九原区','367');
INSERT INTO ts_area VALUES ('374','土默特右旗','367');
INSERT INTO ts_area VALUES ('375','固阳县','367');
INSERT INTO ts_area VALUES ('376','达尔罕茂明安联合旗','367');
INSERT INTO ts_area VALUES ('377','乌海市','356');
INSERT INTO ts_area VALUES ('378','海勃湾区','377');
INSERT INTO ts_area VALUES ('379','海南区','377');
INSERT INTO ts_area VALUES ('380','乌达区','377');
INSERT INTO ts_area VALUES ('381','赤峰市','356');
INSERT INTO ts_area VALUES ('382','红山区','381');
INSERT INTO ts_area VALUES ('383','元宝山区','381');
INSERT INTO ts_area VALUES ('384','松山区','381');
INSERT INTO ts_area VALUES ('385','阿鲁科尔沁旗','381');
INSERT INTO ts_area VALUES ('386','巴林左旗','381');
INSERT INTO ts_area VALUES ('387','巴林右旗','381');
INSERT INTO ts_area VALUES ('388','林西县','381');
INSERT INTO ts_area VALUES ('389','克什克腾旗','381');
INSERT INTO ts_area VALUES ('390','翁牛特旗','381');
INSERT INTO ts_area VALUES ('391','喀喇沁旗','381');
INSERT INTO ts_area VALUES ('392','宁城县','381');
INSERT INTO ts_area VALUES ('393','敖汉旗','381');
INSERT INTO ts_area VALUES ('394','通辽市','356');
INSERT INTO ts_area VALUES ('395','科尔沁区','394');
INSERT INTO ts_area VALUES ('396','科尔沁左翼中旗','394');
INSERT INTO ts_area VALUES ('397','科尔沁左翼后旗','394');
INSERT INTO ts_area VALUES ('398','开鲁县','394');
INSERT INTO ts_area VALUES ('399','库伦旗','394');
INSERT INTO ts_area VALUES ('400','奈曼旗','394');
INSERT INTO ts_area VALUES ('401','扎鲁特旗','394');
INSERT INTO ts_area VALUES ('402','霍林郭勒市','394');
INSERT INTO ts_area VALUES ('403','鄂尔多斯市','356');
INSERT INTO ts_area VALUES ('404','市辖区','403');
INSERT INTO ts_area VALUES ('405','  东胜区','403');
INSERT INTO ts_area VALUES ('406','达拉特旗','403');
INSERT INTO ts_area VALUES ('407','准格尔旗','403');
INSERT INTO ts_area VALUES ('408','鄂托克前旗','403');
INSERT INTO ts_area VALUES ('409','鄂托克旗','403');
INSERT INTO ts_area VALUES ('410','杭锦旗','403');
INSERT INTO ts_area VALUES ('411','乌审旗','403');
INSERT INTO ts_area VALUES ('412','伊金霍洛旗','403');
INSERT INTO ts_area VALUES ('413','呼伦贝尔市','356');
INSERT INTO ts_area VALUES ('414','海拉尔区','413');
INSERT INTO ts_area VALUES ('415','阿荣旗','413');
INSERT INTO ts_area VALUES ('416','莫力达瓦达斡尔族自治旗','413');
INSERT INTO ts_area VALUES ('417','鄂伦春自治旗','413');
INSERT INTO ts_area VALUES ('418','鄂温克族自治旗','413');
INSERT INTO ts_area VALUES ('419','陈巴尔虎旗','413');
INSERT INTO ts_area VALUES ('420','新巴尔虎左旗','413');
INSERT INTO ts_area VALUES ('421','新巴尔虎右旗','413');
INSERT INTO ts_area VALUES ('422','满洲里市','413');
INSERT INTO ts_area VALUES ('423','牙克石市','413');
INSERT INTO ts_area VALUES ('424','扎兰屯市','413');
INSERT INTO ts_area VALUES ('425','额尔古纳市','413');
INSERT INTO ts_area VALUES ('426','根河市','413');
INSERT INTO ts_area VALUES ('427','巴彦淖尔市','356');
INSERT INTO ts_area VALUES ('428','临河区','427');
INSERT INTO ts_area VALUES ('429','五原县','427');
INSERT INTO ts_area VALUES ('430','磴口县','427');
INSERT INTO ts_area VALUES ('431','乌拉特前旗','427');
INSERT INTO ts_area VALUES ('432','乌拉特中旗','427');
INSERT INTO ts_area VALUES ('433','乌拉特后旗','427');
INSERT INTO ts_area VALUES ('434','杭锦后旗','427');
INSERT INTO ts_area VALUES ('435','乌兰察布市','356');
INSERT INTO ts_area VALUES ('436','集宁区','435');
INSERT INTO ts_area VALUES ('437','卓资县','435');
INSERT INTO ts_area VALUES ('438','化德县','435');
INSERT INTO ts_area VALUES ('439','商都县','435');
INSERT INTO ts_area VALUES ('440','兴和县','435');
INSERT INTO ts_area VALUES ('441','凉城县','435');
INSERT INTO ts_area VALUES ('442','察哈尔右翼前旗','435');
INSERT INTO ts_area VALUES ('443','察哈尔右翼中旗','435');
INSERT INTO ts_area VALUES ('444','察哈尔右翼后旗','435');
INSERT INTO ts_area VALUES ('445','四子王旗','435');
INSERT INTO ts_area VALUES ('446','丰镇市','435');
INSERT INTO ts_area VALUES ('447','兴安盟','356');
INSERT INTO ts_area VALUES ('448','乌兰浩特市','447');
INSERT INTO ts_area VALUES ('449','阿尔山市','447');
INSERT INTO ts_area VALUES ('450','科尔沁右翼前旗','447');
INSERT INTO ts_area VALUES ('451','科尔沁右翼中旗','447');
INSERT INTO ts_area VALUES ('452','扎赉特旗','447');
INSERT INTO ts_area VALUES ('453','突泉县','447');
INSERT INTO ts_area VALUES ('454','锡林郭勒盟','356');
INSERT INTO ts_area VALUES ('455','二连浩特市','454');
INSERT INTO ts_area VALUES ('456','锡林浩特市','454');
INSERT INTO ts_area VALUES ('457','阿巴嘎旗','454');
INSERT INTO ts_area VALUES ('458','苏尼特左旗','454');
INSERT INTO ts_area VALUES ('459','苏尼特右旗','454');
INSERT INTO ts_area VALUES ('460','东乌珠穆沁旗','454');
INSERT INTO ts_area VALUES ('461','西乌珠穆沁旗','454');
INSERT INTO ts_area VALUES ('462','太仆寺旗','454');
INSERT INTO ts_area VALUES ('463','镶黄旗','454');
INSERT INTO ts_area VALUES ('464','正镶白旗','454');
INSERT INTO ts_area VALUES ('465','正蓝旗','454');
INSERT INTO ts_area VALUES ('466','多伦县','454');
INSERT INTO ts_area VALUES ('467','阿拉善盟','356');
INSERT INTO ts_area VALUES ('468','阿拉善左旗','467');
INSERT INTO ts_area VALUES ('469','阿拉善右旗','467');
INSERT INTO ts_area VALUES ('470','额济纳旗','467');
INSERT INTO ts_area VALUES ('471','辽宁','0');
INSERT INTO ts_area VALUES ('472','沈阳市','471');
INSERT INTO ts_area VALUES ('473','和平区','472');
INSERT INTO ts_area VALUES ('474','沈河区','472');
INSERT INTO ts_area VALUES ('475','大东区','472');
INSERT INTO ts_area VALUES ('476','皇姑区','472');
INSERT INTO ts_area VALUES ('477','铁西区','472');
INSERT INTO ts_area VALUES ('478','苏家屯区','472');
INSERT INTO ts_area VALUES ('479','东陵区','472');
INSERT INTO ts_area VALUES ('480','沈北新区','472');
INSERT INTO ts_area VALUES ('481','于洪区','472');
INSERT INTO ts_area VALUES ('482','辽中县','472');
INSERT INTO ts_area VALUES ('483','康平县','472');
INSERT INTO ts_area VALUES ('484','法库县','472');
INSERT INTO ts_area VALUES ('485','新民市','472');
INSERT INTO ts_area VALUES ('486','大连市','471');
INSERT INTO ts_area VALUES ('487','中山区','486');
INSERT INTO ts_area VALUES ('488','西岗区','486');
INSERT INTO ts_area VALUES ('489','沙河口区','486');
INSERT INTO ts_area VALUES ('490','甘井子区','486');
INSERT INTO ts_area VALUES ('491','旅顺口区','486');
INSERT INTO ts_area VALUES ('492','金州区','486');
INSERT INTO ts_area VALUES ('493','长海县','486');
INSERT INTO ts_area VALUES ('494','瓦房店市','486');
INSERT INTO ts_area VALUES ('495','普兰店市','486');
INSERT INTO ts_area VALUES ('496','庄河市','486');
INSERT INTO ts_area VALUES ('497','鞍山市','471');
INSERT INTO ts_area VALUES ('498','铁东区','497');
INSERT INTO ts_area VALUES ('499','铁西区','497');
INSERT INTO ts_area VALUES ('500','立山区','497');
INSERT INTO ts_area VALUES ('501','千山区','497');
INSERT INTO ts_area VALUES ('502','台安县','497');
INSERT INTO ts_area VALUES ('503','岫岩满族自治县','497');
INSERT INTO ts_area VALUES ('504','海城市','497');
INSERT INTO ts_area VALUES ('505','抚顺市','471');
INSERT INTO ts_area VALUES ('506','新抚区','505');
INSERT INTO ts_area VALUES ('507','东洲区','505');
INSERT INTO ts_area VALUES ('508','望花区','505');
INSERT INTO ts_area VALUES ('509','顺城区','505');
INSERT INTO ts_area VALUES ('510','抚顺县','505');
INSERT INTO ts_area VALUES ('511','新宾满族自治县','505');
INSERT INTO ts_area VALUES ('512','清原满族自治县','505');
INSERT INTO ts_area VALUES ('513','本溪市','471');
INSERT INTO ts_area VALUES ('514','平山区','513');
INSERT INTO ts_area VALUES ('515','溪湖区','513');
INSERT INTO ts_area VALUES ('516','明山区','513');
INSERT INTO ts_area VALUES ('517','南芬区','513');
INSERT INTO ts_area VALUES ('518','本溪满族自治县','513');
INSERT INTO ts_area VALUES ('519','桓仁满族自治县','513');
INSERT INTO ts_area VALUES ('520','丹东市','471');
INSERT INTO ts_area VALUES ('521','元宝区','520');
INSERT INTO ts_area VALUES ('522','振兴区','520');
INSERT INTO ts_area VALUES ('523','振安区','520');
INSERT INTO ts_area VALUES ('524','宽甸满族自治县','520');
INSERT INTO ts_area VALUES ('525','东港市','520');
INSERT INTO ts_area VALUES ('526','凤城市','520');
INSERT INTO ts_area VALUES ('527','锦州市','471');
INSERT INTO ts_area VALUES ('528','古塔区','527');
INSERT INTO ts_area VALUES ('529','凌河区','527');
INSERT INTO ts_area VALUES ('530','太和区','527');
INSERT INTO ts_area VALUES ('531','黑山县','527');
INSERT INTO ts_area VALUES ('532','义县','527');
INSERT INTO ts_area VALUES ('533','凌海市','527');
INSERT INTO ts_area VALUES ('534','北镇市','527');
INSERT INTO ts_area VALUES ('535','营口市','471');
INSERT INTO ts_area VALUES ('536','站前区','535');
INSERT INTO ts_area VALUES ('537','西市区','535');
INSERT INTO ts_area VALUES ('538','鲅鱼圈区','535');
INSERT INTO ts_area VALUES ('539','老边区','535');
INSERT INTO ts_area VALUES ('540','盖州市','535');
INSERT INTO ts_area VALUES ('541','大石桥市','535');
INSERT INTO ts_area VALUES ('542','阜新市','471');
INSERT INTO ts_area VALUES ('543','海州区','542');
INSERT INTO ts_area VALUES ('544','新邱区','542');
INSERT INTO ts_area VALUES ('545','太平区','542');
INSERT INTO ts_area VALUES ('546','清河门区','542');
INSERT INTO ts_area VALUES ('547','细河区','542');
INSERT INTO ts_area VALUES ('548','阜新蒙古族自治县','542');
INSERT INTO ts_area VALUES ('549','彰武县','542');
INSERT INTO ts_area VALUES ('550','辽阳市','471');
INSERT INTO ts_area VALUES ('551','白塔区','550');
INSERT INTO ts_area VALUES ('552','文圣区','550');
INSERT INTO ts_area VALUES ('553','宏伟区','550');
INSERT INTO ts_area VALUES ('554','弓长岭区','550');
INSERT INTO ts_area VALUES ('555','太子河区','550');
INSERT INTO ts_area VALUES ('556','辽阳县','550');
INSERT INTO ts_area VALUES ('557','灯塔市','550');
INSERT INTO ts_area VALUES ('558','盘锦市','471');
INSERT INTO ts_area VALUES ('559','双台子区','558');
INSERT INTO ts_area VALUES ('560','兴隆台区','558');
INSERT INTO ts_area VALUES ('561','大洼县','558');
INSERT INTO ts_area VALUES ('562','盘山县','558');
INSERT INTO ts_area VALUES ('563','铁岭市','471');
INSERT INTO ts_area VALUES ('564','银州区','563');
INSERT INTO ts_area VALUES ('565','清河区','563');
INSERT INTO ts_area VALUES ('566','铁岭县','563');
INSERT INTO ts_area VALUES ('567','西丰县','563');
INSERT INTO ts_area VALUES ('568','昌图县','563');
INSERT INTO ts_area VALUES ('569','调兵山市','563');
INSERT INTO ts_area VALUES ('570','开原市','563');
INSERT INTO ts_area VALUES ('571','朝阳市','471');
INSERT INTO ts_area VALUES ('572','双塔区','571');
INSERT INTO ts_area VALUES ('573','龙城区','571');
INSERT INTO ts_area VALUES ('574','朝阳县','571');
INSERT INTO ts_area VALUES ('575','建平县','571');
INSERT INTO ts_area VALUES ('576','喀喇沁左翼蒙古族自治县','571');
INSERT INTO ts_area VALUES ('577','北票市','571');
INSERT INTO ts_area VALUES ('578','凌源市','571');
INSERT INTO ts_area VALUES ('579','葫芦岛市','471');
INSERT INTO ts_area VALUES ('580','连山区','579');
INSERT INTO ts_area VALUES ('581','龙港区','579');
INSERT INTO ts_area VALUES ('582','南票区','579');
INSERT INTO ts_area VALUES ('583','绥中县','579');
INSERT INTO ts_area VALUES ('584','建昌县','579');
INSERT INTO ts_area VALUES ('585','兴城市','579');
INSERT INTO ts_area VALUES ('586','吉林','0');
INSERT INTO ts_area VALUES ('587','长春市','586');
INSERT INTO ts_area VALUES ('588','南关区','587');
INSERT INTO ts_area VALUES ('589','宽城区','587');
INSERT INTO ts_area VALUES ('590','朝阳区','587');
INSERT INTO ts_area VALUES ('591','二道区','587');
INSERT INTO ts_area VALUES ('592','绿园区','587');
INSERT INTO ts_area VALUES ('593','双阳区','587');
INSERT INTO ts_area VALUES ('594','农安县','587');
INSERT INTO ts_area VALUES ('595','九台市','587');
INSERT INTO ts_area VALUES ('596','榆树市','587');
INSERT INTO ts_area VALUES ('597','德惠市','587');
INSERT INTO ts_area VALUES ('598','吉林市','586');
INSERT INTO ts_area VALUES ('599','昌邑区','598');
INSERT INTO ts_area VALUES ('600','龙潭区','598');
INSERT INTO ts_area VALUES ('601','船营区','598');
INSERT INTO ts_area VALUES ('602','丰满区','598');
INSERT INTO ts_area VALUES ('603','永吉县','598');
INSERT INTO ts_area VALUES ('604','蛟河市','598');
INSERT INTO ts_area VALUES ('605','桦甸市','598');
INSERT INTO ts_area VALUES ('606','舒兰市','598');
INSERT INTO ts_area VALUES ('607','磐石市','598');
INSERT INTO ts_area VALUES ('608','四平市','586');
INSERT INTO ts_area VALUES ('609','铁西区','608');
INSERT INTO ts_area VALUES ('610','铁东区','608');
INSERT INTO ts_area VALUES ('611','梨树县','608');
INSERT INTO ts_area VALUES ('612','伊通满族自治县','608');
INSERT INTO ts_area VALUES ('613','公主岭市','608');
INSERT INTO ts_area VALUES ('614','双辽市','608');
INSERT INTO ts_area VALUES ('615','辽源市','586');
INSERT INTO ts_area VALUES ('616','龙山区','615');
INSERT INTO ts_area VALUES ('617','西安区','615');
INSERT INTO ts_area VALUES ('618','东丰县','615');
INSERT INTO ts_area VALUES ('619','东辽县','615');
INSERT INTO ts_area VALUES ('620','通化市','586');
INSERT INTO ts_area VALUES ('621','东昌区','620');
INSERT INTO ts_area VALUES ('622','二道江区','620');
INSERT INTO ts_area VALUES ('623','通化县','620');
INSERT INTO ts_area VALUES ('624','辉南县','620');
INSERT INTO ts_area VALUES ('625','柳河县','620');
INSERT INTO ts_area VALUES ('626','梅河口市','620');
INSERT INTO ts_area VALUES ('627','集安市','620');
INSERT INTO ts_area VALUES ('628','白山市','586');
INSERT INTO ts_area VALUES ('629','八道江区','628');
INSERT INTO ts_area VALUES ('630','  江源区','628');
INSERT INTO ts_area VALUES ('631','抚松县','628');
INSERT INTO ts_area VALUES ('632','靖宇县','628');
INSERT INTO ts_area VALUES ('633','长白朝鲜族自治县','628');
INSERT INTO ts_area VALUES ('634','临江市','628');
INSERT INTO ts_area VALUES ('635','松原市','586');
INSERT INTO ts_area VALUES ('636','宁江区','635');
INSERT INTO ts_area VALUES ('637','前郭尔罗斯蒙古族自治县','635');
INSERT INTO ts_area VALUES ('638','长岭县','635');
INSERT INTO ts_area VALUES ('639','乾安县','635');
INSERT INTO ts_area VALUES ('640','扶余县','635');
INSERT INTO ts_area VALUES ('641','白城市','586');
INSERT INTO ts_area VALUES ('642','洮北区','641');
INSERT INTO ts_area VALUES ('643','镇赉县','641');
INSERT INTO ts_area VALUES ('644','通榆县','641');
INSERT INTO ts_area VALUES ('645','洮南市','641');
INSERT INTO ts_area VALUES ('646','大安市','641');
INSERT INTO ts_area VALUES ('647','延边朝鲜族自治州','586');
INSERT INTO ts_area VALUES ('648','延吉市','647');
INSERT INTO ts_area VALUES ('649','图们市','647');
INSERT INTO ts_area VALUES ('650','敦化市','647');
INSERT INTO ts_area VALUES ('651','珲春市','647');
INSERT INTO ts_area VALUES ('652','龙井市','647');
INSERT INTO ts_area VALUES ('653','和龙市','647');
INSERT INTO ts_area VALUES ('654','汪清县','647');
INSERT INTO ts_area VALUES ('655','安图县','647');
INSERT INTO ts_area VALUES ('656','黑龙江','0');
INSERT INTO ts_area VALUES ('657','哈尔滨市','656');
INSERT INTO ts_area VALUES ('658','道里区','657');
INSERT INTO ts_area VALUES ('659','南岗区','657');
INSERT INTO ts_area VALUES ('660','道外区','657');
INSERT INTO ts_area VALUES ('661','平房区','657');
INSERT INTO ts_area VALUES ('662','松北区','657');
INSERT INTO ts_area VALUES ('663','香坊区','657');
INSERT INTO ts_area VALUES ('664','呼兰区','657');
INSERT INTO ts_area VALUES ('665','阿城区                 ','657');
INSERT INTO ts_area VALUES ('666','依兰县','657');
INSERT INTO ts_area VALUES ('667','方正县','657');
INSERT INTO ts_area VALUES ('668','宾县','657');
INSERT INTO ts_area VALUES ('669','巴彦县','657');
INSERT INTO ts_area VALUES ('670','木兰县','657');
INSERT INTO ts_area VALUES ('671','通河县','657');
INSERT INTO ts_area VALUES ('672','延寿县','657');
INSERT INTO ts_area VALUES ('673','双城市','657');
INSERT INTO ts_area VALUES ('674','尚志市','657');
INSERT INTO ts_area VALUES ('675','五常市','657');
INSERT INTO ts_area VALUES ('676','齐齐哈尔市','656');
INSERT INTO ts_area VALUES ('677','龙沙区','676');
INSERT INTO ts_area VALUES ('678','建华区','676');
INSERT INTO ts_area VALUES ('679','铁锋区','676');
INSERT INTO ts_area VALUES ('680','昂昂溪区','676');
INSERT INTO ts_area VALUES ('681','富拉尔基区','676');
INSERT INTO ts_area VALUES ('682','碾子山区','676');
INSERT INTO ts_area VALUES ('683','梅里斯达斡尔族区','676');
INSERT INTO ts_area VALUES ('684','龙江县','676');
INSERT INTO ts_area VALUES ('685','依安县','676');
INSERT INTO ts_area VALUES ('686','泰来县','676');
INSERT INTO ts_area VALUES ('687','甘南县','676');
INSERT INTO ts_area VALUES ('688','富裕县','676');
INSERT INTO ts_area VALUES ('689','克山县','676');
INSERT INTO ts_area VALUES ('690','克东县','676');
INSERT INTO ts_area VALUES ('691','拜泉县','676');
INSERT INTO ts_area VALUES ('692','讷河市','676');
INSERT INTO ts_area VALUES ('693','鸡西市','656');
INSERT INTO ts_area VALUES ('694','鸡冠区','693');
INSERT INTO ts_area VALUES ('695','恒山区','693');
INSERT INTO ts_area VALUES ('696','滴道区','693');
INSERT INTO ts_area VALUES ('697','梨树区','693');
INSERT INTO ts_area VALUES ('698','城子河区','693');
INSERT INTO ts_area VALUES ('699','麻山区','693');
INSERT INTO ts_area VALUES ('700','鸡东县','693');
INSERT INTO ts_area VALUES ('701','虎林市','693');
INSERT INTO ts_area VALUES ('702','密山市','693');
INSERT INTO ts_area VALUES ('703','鹤岗市','656');
INSERT INTO ts_area VALUES ('704','向阳区','703');
INSERT INTO ts_area VALUES ('705','工农区','703');
INSERT INTO ts_area VALUES ('706','南山区','703');
INSERT INTO ts_area VALUES ('707','兴安区','703');
INSERT INTO ts_area VALUES ('708','东山区','703');
INSERT INTO ts_area VALUES ('709','兴山区','703');
INSERT INTO ts_area VALUES ('710','萝北县','703');
INSERT INTO ts_area VALUES ('711','绥滨县','703');
INSERT INTO ts_area VALUES ('712','双鸭山市','656');
INSERT INTO ts_area VALUES ('713','尖山区','712');
INSERT INTO ts_area VALUES ('714','岭东区','712');
INSERT INTO ts_area VALUES ('715','四方台区','712');
INSERT INTO ts_area VALUES ('716','宝山区','712');
INSERT INTO ts_area VALUES ('717','集贤县','712');
INSERT INTO ts_area VALUES ('718','友谊县','712');
INSERT INTO ts_area VALUES ('719','宝清县','712');
INSERT INTO ts_area VALUES ('720','饶河县','712');
INSERT INTO ts_area VALUES ('721','大庆市','656');
INSERT INTO ts_area VALUES ('722','萨尔图区','721');
INSERT INTO ts_area VALUES ('723','龙凤区','721');
INSERT INTO ts_area VALUES ('724','让胡路区','721');
INSERT INTO ts_area VALUES ('725','红岗区','721');
INSERT INTO ts_area VALUES ('726','大同区','721');
INSERT INTO ts_area VALUES ('727','肇州县','721');
INSERT INTO ts_area VALUES ('728','肇源县','721');
INSERT INTO ts_area VALUES ('729','林甸县','721');
INSERT INTO ts_area VALUES ('730','杜尔伯特蒙古族自治县','721');
INSERT INTO ts_area VALUES ('731','伊春市','656');
INSERT INTO ts_area VALUES ('732','伊春区','731');
INSERT INTO ts_area VALUES ('733','南岔区','731');
INSERT INTO ts_area VALUES ('734','友好区','731');
INSERT INTO ts_area VALUES ('735','西林区','731');
INSERT INTO ts_area VALUES ('736','翠峦区','731');
INSERT INTO ts_area VALUES ('737','新青区','731');
INSERT INTO ts_area VALUES ('738','美溪区','731');
INSERT INTO ts_area VALUES ('739','金山屯区','731');
INSERT INTO ts_area VALUES ('740','五营区','731');
INSERT INTO ts_area VALUES ('741','乌马河区','731');
INSERT INTO ts_area VALUES ('742','汤旺河区','731');
INSERT INTO ts_area VALUES ('743','带岭区','731');
INSERT INTO ts_area VALUES ('744','乌伊岭区','731');
INSERT INTO ts_area VALUES ('745','红星区','731');
INSERT INTO ts_area VALUES ('746','上甘岭区','731');
INSERT INTO ts_area VALUES ('747','嘉荫县','731');
INSERT INTO ts_area VALUES ('748','铁力市','731');
INSERT INTO ts_area VALUES ('749','佳木斯市','656');
INSERT INTO ts_area VALUES ('750','向阳区','749');
INSERT INTO ts_area VALUES ('751','前进区','749');
INSERT INTO ts_area VALUES ('752','东风区','749');
INSERT INTO ts_area VALUES ('753','郊区','749');
INSERT INTO ts_area VALUES ('754','桦南县','749');
INSERT INTO ts_area VALUES ('755','桦川县','749');
INSERT INTO ts_area VALUES ('756','汤原县','749');
INSERT INTO ts_area VALUES ('757','抚远县','749');
INSERT INTO ts_area VALUES ('758','同江市','749');
INSERT INTO ts_area VALUES ('759','富锦市','749');
INSERT INTO ts_area VALUES ('760','七台河市','656');
INSERT INTO ts_area VALUES ('761','新兴区','760');
INSERT INTO ts_area VALUES ('762','桃山区','760');
INSERT INTO ts_area VALUES ('763','茄子河区','760');
INSERT INTO ts_area VALUES ('764','勃利县','760');
INSERT INTO ts_area VALUES ('765','牡丹江市','656');
INSERT INTO ts_area VALUES ('766','东安区','765');
INSERT INTO ts_area VALUES ('767','阳明区','765');
INSERT INTO ts_area VALUES ('768','爱民区','765');
INSERT INTO ts_area VALUES ('769','西安区','765');
INSERT INTO ts_area VALUES ('770','东宁县','765');
INSERT INTO ts_area VALUES ('771','林口县','765');
INSERT INTO ts_area VALUES ('772','绥芬河市','765');
INSERT INTO ts_area VALUES ('773','海林市','765');
INSERT INTO ts_area VALUES ('774','宁安市','765');
INSERT INTO ts_area VALUES ('775','穆棱市','765');
INSERT INTO ts_area VALUES ('776','黑河市','656');
INSERT INTO ts_area VALUES ('777','爱辉区','776');
INSERT INTO ts_area VALUES ('778','嫩江县','776');
INSERT INTO ts_area VALUES ('779','逊克县','776');
INSERT INTO ts_area VALUES ('780','孙吴县','776');
INSERT INTO ts_area VALUES ('781','北安市','776');
INSERT INTO ts_area VALUES ('782','五大连池市','776');
INSERT INTO ts_area VALUES ('783','绥化市','656');
INSERT INTO ts_area VALUES ('784','北林区','783');
INSERT INTO ts_area VALUES ('785','望奎县','783');
INSERT INTO ts_area VALUES ('786','兰西县','783');
INSERT INTO ts_area VALUES ('787','青冈县','783');
INSERT INTO ts_area VALUES ('788','庆安县','783');
INSERT INTO ts_area VALUES ('789','明水县','783');
INSERT INTO ts_area VALUES ('790','绥棱县','783');
INSERT INTO ts_area VALUES ('791','安达市','783');
INSERT INTO ts_area VALUES ('792','肇东市','783');
INSERT INTO ts_area VALUES ('793','海伦市','783');
INSERT INTO ts_area VALUES ('794','大兴安岭地区','656');
INSERT INTO ts_area VALUES ('795','加格达奇区','794');
INSERT INTO ts_area VALUES ('796','松岭区','794');
INSERT INTO ts_area VALUES ('797','新林区','794');
INSERT INTO ts_area VALUES ('798','呼中区','794');
INSERT INTO ts_area VALUES ('799','呼玛县','794');
INSERT INTO ts_area VALUES ('800','塔河县','794');
INSERT INTO ts_area VALUES ('801','漠河县','794');
INSERT INTO ts_area VALUES ('802','上海','0');
INSERT INTO ts_area VALUES ('803','上海市','802');
INSERT INTO ts_area VALUES ('804','黄浦区','803');
INSERT INTO ts_area VALUES ('805','卢湾区','803');
INSERT INTO ts_area VALUES ('806','徐汇区','803');
INSERT INTO ts_area VALUES ('807','长宁区','803');
INSERT INTO ts_area VALUES ('808','静安区','803');
INSERT INTO ts_area VALUES ('809','普陀区','803');
INSERT INTO ts_area VALUES ('810','闸北区','803');
INSERT INTO ts_area VALUES ('811','虹口区','803');
INSERT INTO ts_area VALUES ('812','杨浦区','803');
INSERT INTO ts_area VALUES ('813','闵行区','803');
INSERT INTO ts_area VALUES ('814','宝山区','803');
INSERT INTO ts_area VALUES ('815','嘉定区','803');
INSERT INTO ts_area VALUES ('816','浦东新区','803');
INSERT INTO ts_area VALUES ('817','金山区','803');
INSERT INTO ts_area VALUES ('818','松江区','803');
INSERT INTO ts_area VALUES ('819','青浦区','803');
INSERT INTO ts_area VALUES ('820','南汇区','803');
INSERT INTO ts_area VALUES ('821','奉贤区','803');
INSERT INTO ts_area VALUES ('822','崇明县','803');
INSERT INTO ts_area VALUES ('823','江苏','0');
INSERT INTO ts_area VALUES ('824','南京市','823');
INSERT INTO ts_area VALUES ('825','玄武区','824');
INSERT INTO ts_area VALUES ('826','白下区','824');
INSERT INTO ts_area VALUES ('827','秦淮区','824');
INSERT INTO ts_area VALUES ('828','建邺区','824');
INSERT INTO ts_area VALUES ('829','鼓楼区','824');
INSERT INTO ts_area VALUES ('830','下关区','824');
INSERT INTO ts_area VALUES ('831','浦口区','824');
INSERT INTO ts_area VALUES ('832','栖霞区','824');
INSERT INTO ts_area VALUES ('833','雨花台区','824');
INSERT INTO ts_area VALUES ('834','江宁区','824');
INSERT INTO ts_area VALUES ('835','六合区','824');
INSERT INTO ts_area VALUES ('836','溧水县','824');
INSERT INTO ts_area VALUES ('837','高淳县','824');
INSERT INTO ts_area VALUES ('838','无锡市','823');
INSERT INTO ts_area VALUES ('839','崇安区','838');
INSERT INTO ts_area VALUES ('840','南长区','838');
INSERT INTO ts_area VALUES ('841','北塘区','838');
INSERT INTO ts_area VALUES ('842','锡山区','838');
INSERT INTO ts_area VALUES ('843','惠山区','838');
INSERT INTO ts_area VALUES ('844','滨湖区','838');
INSERT INTO ts_area VALUES ('845','江阴市','838');
INSERT INTO ts_area VALUES ('846','宜兴市','838');
INSERT INTO ts_area VALUES ('847','徐州市','823');
INSERT INTO ts_area VALUES ('848','鼓楼区','847');
INSERT INTO ts_area VALUES ('849','云龙区','847');
INSERT INTO ts_area VALUES ('850','九里区','847');
INSERT INTO ts_area VALUES ('851','贾汪区','847');
INSERT INTO ts_area VALUES ('852','泉山区','847');
INSERT INTO ts_area VALUES ('853','丰县','847');
INSERT INTO ts_area VALUES ('854','沛县','847');
INSERT INTO ts_area VALUES ('855','铜山县','847');
INSERT INTO ts_area VALUES ('856','睢宁县','847');
INSERT INTO ts_area VALUES ('857','新沂市','847');
INSERT INTO ts_area VALUES ('858','邳州市','847');
INSERT INTO ts_area VALUES ('859','常州市','823');
INSERT INTO ts_area VALUES ('860','天宁区','859');
INSERT INTO ts_area VALUES ('861','钟楼区','859');
INSERT INTO ts_area VALUES ('862','戚墅堰区','859');
INSERT INTO ts_area VALUES ('863','新北区','859');
INSERT INTO ts_area VALUES ('864','武进区','859');
INSERT INTO ts_area VALUES ('865','溧阳市','859');
INSERT INTO ts_area VALUES ('866','金坛市','859');
INSERT INTO ts_area VALUES ('867','苏州市','823');
INSERT INTO ts_area VALUES ('868','沧浪区','867');
INSERT INTO ts_area VALUES ('869','平江区','867');
INSERT INTO ts_area VALUES ('870','金阊区','867');
INSERT INTO ts_area VALUES ('871','虎丘区','867');
INSERT INTO ts_area VALUES ('872','吴中区','867');
INSERT INTO ts_area VALUES ('873','相城区','867');
INSERT INTO ts_area VALUES ('874','常熟市','867');
INSERT INTO ts_area VALUES ('875','张家港市','867');
INSERT INTO ts_area VALUES ('876','昆山市','867');
INSERT INTO ts_area VALUES ('877','吴江市','867');
INSERT INTO ts_area VALUES ('878','太仓市','867');
INSERT INTO ts_area VALUES ('879','南通市','823');
INSERT INTO ts_area VALUES ('880','崇川区','879');
INSERT INTO ts_area VALUES ('881','港闸区','879');
INSERT INTO ts_area VALUES ('882','海安县','879');
INSERT INTO ts_area VALUES ('883','如东县','879');
INSERT INTO ts_area VALUES ('884','启东市','879');
INSERT INTO ts_area VALUES ('885','如皋市','879');
INSERT INTO ts_area VALUES ('886','通州市','879');
INSERT INTO ts_area VALUES ('887','海门市','879');
INSERT INTO ts_area VALUES ('888','连云港市','823');
INSERT INTO ts_area VALUES ('889','连云区','888');
INSERT INTO ts_area VALUES ('890','新浦区','888');
INSERT INTO ts_area VALUES ('891','海州区','888');
INSERT INTO ts_area VALUES ('892','赣榆县','888');
INSERT INTO ts_area VALUES ('893','东海县','888');
INSERT INTO ts_area VALUES ('894','灌云县','888');
INSERT INTO ts_area VALUES ('895','灌南县','888');
INSERT INTO ts_area VALUES ('896','淮安市','823');
INSERT INTO ts_area VALUES ('897','清河区','896');
INSERT INTO ts_area VALUES ('898','楚州区','896');
INSERT INTO ts_area VALUES ('899','淮阴区','896');
INSERT INTO ts_area VALUES ('900','清浦区','896');
INSERT INTO ts_area VALUES ('901','涟水县','896');
INSERT INTO ts_area VALUES ('902','洪泽县','896');
INSERT INTO ts_area VALUES ('903','盱眙县','896');
INSERT INTO ts_area VALUES ('904','金湖县','896');
INSERT INTO ts_area VALUES ('905','盐城市','823');
INSERT INTO ts_area VALUES ('906','亭湖区','905');
INSERT INTO ts_area VALUES ('907','盐都区','905');
INSERT INTO ts_area VALUES ('908','响水县','905');
INSERT INTO ts_area VALUES ('909','滨海县','905');
INSERT INTO ts_area VALUES ('910','阜宁县','905');
INSERT INTO ts_area VALUES ('911','射阳县','905');
INSERT INTO ts_area VALUES ('912','建湖县','905');
INSERT INTO ts_area VALUES ('913','东台市','905');
INSERT INTO ts_area VALUES ('914','大丰市','905');
INSERT INTO ts_area VALUES ('915','扬州市','823');
INSERT INTO ts_area VALUES ('916','广陵区','915');
INSERT INTO ts_area VALUES ('917','邗江区','915');
INSERT INTO ts_area VALUES ('918','维扬区','915');
INSERT INTO ts_area VALUES ('919','宝应县','915');
INSERT INTO ts_area VALUES ('920','仪征市','915');
INSERT INTO ts_area VALUES ('921','高邮市','915');
INSERT INTO ts_area VALUES ('922','江都市','915');
INSERT INTO ts_area VALUES ('923','镇江市','823');
INSERT INTO ts_area VALUES ('924','京口区','923');
INSERT INTO ts_area VALUES ('925','润州区','923');
INSERT INTO ts_area VALUES ('926','丹徒区','923');
INSERT INTO ts_area VALUES ('927','丹阳市','923');
INSERT INTO ts_area VALUES ('928','扬中市','923');
INSERT INTO ts_area VALUES ('929','句容市','923');
INSERT INTO ts_area VALUES ('930','泰州市','823');
INSERT INTO ts_area VALUES ('931','海陵区','930');
INSERT INTO ts_area VALUES ('932','高港区','930');
INSERT INTO ts_area VALUES ('933','兴化市','930');
INSERT INTO ts_area VALUES ('934','靖江市','930');
INSERT INTO ts_area VALUES ('935','泰兴市','930');
INSERT INTO ts_area VALUES ('936','姜堰市','930');
INSERT INTO ts_area VALUES ('937','宿迁市','823');
INSERT INTO ts_area VALUES ('938','宿城区','937');
INSERT INTO ts_area VALUES ('939','宿豫区','937');
INSERT INTO ts_area VALUES ('940','沭阳县','937');
INSERT INTO ts_area VALUES ('941','泗阳县','937');
INSERT INTO ts_area VALUES ('942','泗洪县','937');
INSERT INTO ts_area VALUES ('943','浙江','0');
INSERT INTO ts_area VALUES ('944','杭州市','943');
INSERT INTO ts_area VALUES ('945','上城区','944');
INSERT INTO ts_area VALUES ('946','下城区','944');
INSERT INTO ts_area VALUES ('947','江干区','944');
INSERT INTO ts_area VALUES ('948','拱墅区','944');
INSERT INTO ts_area VALUES ('949','西湖区','944');
INSERT INTO ts_area VALUES ('950','滨江区','944');
INSERT INTO ts_area VALUES ('951','萧山区','944');
INSERT INTO ts_area VALUES ('952','余杭区','944');
INSERT INTO ts_area VALUES ('953','桐庐县','944');
INSERT INTO ts_area VALUES ('954','淳安县','944');
INSERT INTO ts_area VALUES ('955','建德市','944');
INSERT INTO ts_area VALUES ('956','富阳市','944');
INSERT INTO ts_area VALUES ('957','临安市','944');
INSERT INTO ts_area VALUES ('958','宁波市','943');
INSERT INTO ts_area VALUES ('959','海曙区','958');
INSERT INTO ts_area VALUES ('960','江东区','958');
INSERT INTO ts_area VALUES ('961','江北区','958');
INSERT INTO ts_area VALUES ('962','北仑区','958');
INSERT INTO ts_area VALUES ('963','镇海区','958');
INSERT INTO ts_area VALUES ('964','鄞州区','958');
INSERT INTO ts_area VALUES ('965','象山县','958');
INSERT INTO ts_area VALUES ('966','宁海县','958');
INSERT INTO ts_area VALUES ('967','余姚市','958');
INSERT INTO ts_area VALUES ('968','慈溪市','958');
INSERT INTO ts_area VALUES ('969','奉化市','958');
INSERT INTO ts_area VALUES ('970','温州市','943');
INSERT INTO ts_area VALUES ('971','鹿城区','970');
INSERT INTO ts_area VALUES ('972','龙湾区','970');
INSERT INTO ts_area VALUES ('973','瓯海区','970');
INSERT INTO ts_area VALUES ('974','洞头县','970');
INSERT INTO ts_area VALUES ('975','永嘉县','970');
INSERT INTO ts_area VALUES ('976','平阳县','970');
INSERT INTO ts_area VALUES ('977','苍南县','970');
INSERT INTO ts_area VALUES ('978','文成县','970');
INSERT INTO ts_area VALUES ('979','泰顺县','970');
INSERT INTO ts_area VALUES ('980','瑞安市','970');
INSERT INTO ts_area VALUES ('981','乐清市','970');
INSERT INTO ts_area VALUES ('982','嘉兴市','943');
INSERT INTO ts_area VALUES ('983','南湖区','982');
INSERT INTO ts_area VALUES ('984','秀洲区','982');
INSERT INTO ts_area VALUES ('985','嘉善县','982');
INSERT INTO ts_area VALUES ('986','海盐县','982');
INSERT INTO ts_area VALUES ('987','海宁市','982');
INSERT INTO ts_area VALUES ('988','平湖市','982');
INSERT INTO ts_area VALUES ('989','桐乡市','982');
INSERT INTO ts_area VALUES ('990','湖州市','943');
INSERT INTO ts_area VALUES ('991','吴兴区','990');
INSERT INTO ts_area VALUES ('992','南浔区','990');
INSERT INTO ts_area VALUES ('993','德清县','990');
INSERT INTO ts_area VALUES ('994','长兴县','990');
INSERT INTO ts_area VALUES ('995','安吉县','990');
INSERT INTO ts_area VALUES ('996','绍兴市','943');
INSERT INTO ts_area VALUES ('997','越城区','996');
INSERT INTO ts_area VALUES ('998','绍兴县','996');
INSERT INTO ts_area VALUES ('999','新昌县','996');
INSERT INTO ts_area VALUES ('1000','诸暨市','996');
INSERT INTO ts_area VALUES ('1001','上虞市','996');
INSERT INTO ts_area VALUES ('1002','嵊州市','996');
INSERT INTO ts_area VALUES ('1003','金华市','943');
INSERT INTO ts_area VALUES ('1004','婺城区','1003');
INSERT INTO ts_area VALUES ('1005','金东区','1003');
INSERT INTO ts_area VALUES ('1006','武义县','1003');
INSERT INTO ts_area VALUES ('1007','浦江县','1003');
INSERT INTO ts_area VALUES ('1008','磐安县','1003');
INSERT INTO ts_area VALUES ('1009','兰溪市','1003');
INSERT INTO ts_area VALUES ('1010','义乌市','1003');
INSERT INTO ts_area VALUES ('1011','东阳市','1003');
INSERT INTO ts_area VALUES ('1012','永康市','1003');
INSERT INTO ts_area VALUES ('1013','衢州市','943');
INSERT INTO ts_area VALUES ('1014','柯城区','1013');
INSERT INTO ts_area VALUES ('1015','衢江区','1013');
INSERT INTO ts_area VALUES ('1016','常山县','1013');
INSERT INTO ts_area VALUES ('1017','开化县','1013');
INSERT INTO ts_area VALUES ('1018','龙游县','1013');
INSERT INTO ts_area VALUES ('1019','江山市','1013');
INSERT INTO ts_area VALUES ('1020','舟山市','943');
INSERT INTO ts_area VALUES ('1021','定海区','1020');
INSERT INTO ts_area VALUES ('1022','普陀区','1020');
INSERT INTO ts_area VALUES ('1023','岱山县','1020');
INSERT INTO ts_area VALUES ('1024','嵊泗县','1020');
INSERT INTO ts_area VALUES ('1025','台州市','943');
INSERT INTO ts_area VALUES ('1026','椒江区','1025');
INSERT INTO ts_area VALUES ('1027','黄岩区','1025');
INSERT INTO ts_area VALUES ('1028','路桥区','1025');
INSERT INTO ts_area VALUES ('1029','玉环县','1025');
INSERT INTO ts_area VALUES ('1030','三门县','1025');
INSERT INTO ts_area VALUES ('1031','天台县','1025');
INSERT INTO ts_area VALUES ('1032','仙居县','1025');
INSERT INTO ts_area VALUES ('1033','温岭市','1025');
INSERT INTO ts_area VALUES ('1034','临海市','1025');
INSERT INTO ts_area VALUES ('1035','丽水市','943');
INSERT INTO ts_area VALUES ('1036','莲都区','1035');
INSERT INTO ts_area VALUES ('1037','青田县','1035');
INSERT INTO ts_area VALUES ('1038','缙云县','1035');
INSERT INTO ts_area VALUES ('1039','遂昌县','1035');
INSERT INTO ts_area VALUES ('1040','松阳县','1035');
INSERT INTO ts_area VALUES ('1041','云和县','1035');
INSERT INTO ts_area VALUES ('1042','庆元县','1035');
INSERT INTO ts_area VALUES ('1043','景宁畲族自治县','1035');
INSERT INTO ts_area VALUES ('1044','龙泉市','1035');
INSERT INTO ts_area VALUES ('1045','安徽','0');
INSERT INTO ts_area VALUES ('1046','合肥市','1045');
INSERT INTO ts_area VALUES ('1047','瑶海区','1046');
INSERT INTO ts_area VALUES ('1048','庐阳区','1046');
INSERT INTO ts_area VALUES ('1049','蜀山区','1046');
INSERT INTO ts_area VALUES ('1050','包河区','1046');
INSERT INTO ts_area VALUES ('1051','长丰县','1046');
INSERT INTO ts_area VALUES ('1052','肥东县','1046');
INSERT INTO ts_area VALUES ('1053','肥西县','1046');
INSERT INTO ts_area VALUES ('1054','芜湖市','1045');
INSERT INTO ts_area VALUES ('1055','镜湖区','1054');
INSERT INTO ts_area VALUES ('1056','弋江区','1054');
INSERT INTO ts_area VALUES ('1057','鸠江区','1054');
INSERT INTO ts_area VALUES ('1058','三山区','1054');
INSERT INTO ts_area VALUES ('1059','芜湖县','1054');
INSERT INTO ts_area VALUES ('1060','繁昌县','1054');
INSERT INTO ts_area VALUES ('1061','南陵县','1054');
INSERT INTO ts_area VALUES ('1062','蚌埠市','1045');
INSERT INTO ts_area VALUES ('1063','龙子湖区','1062');
INSERT INTO ts_area VALUES ('1064','蚌山区','1062');
INSERT INTO ts_area VALUES ('1065','禹会区','1062');
INSERT INTO ts_area VALUES ('1066','淮上区','1062');
INSERT INTO ts_area VALUES ('1067','怀远县','1062');
INSERT INTO ts_area VALUES ('1068','五河县','1062');
INSERT INTO ts_area VALUES ('1069','固镇县','1062');
INSERT INTO ts_area VALUES ('1070','淮南市','1045');
INSERT INTO ts_area VALUES ('1071','大通区','1070');
INSERT INTO ts_area VALUES ('1072','田家庵区','1070');
INSERT INTO ts_area VALUES ('1073','谢家集区','1070');
INSERT INTO ts_area VALUES ('1074','八公山区','1070');
INSERT INTO ts_area VALUES ('1075','潘集区','1070');
INSERT INTO ts_area VALUES ('1076','凤台县','1070');
INSERT INTO ts_area VALUES ('1077','马鞍山市','1045');
INSERT INTO ts_area VALUES ('1078','金家庄区','1077');
INSERT INTO ts_area VALUES ('1079','花山区','1077');
INSERT INTO ts_area VALUES ('1080','雨山区','1077');
INSERT INTO ts_area VALUES ('1081','当涂县','1077');
INSERT INTO ts_area VALUES ('1082','淮北市','1045');
INSERT INTO ts_area VALUES ('1083','杜集区','1082');
INSERT INTO ts_area VALUES ('1084','相山区','1082');
INSERT INTO ts_area VALUES ('1085','烈山区','1082');
INSERT INTO ts_area VALUES ('1086','濉溪县','1082');
INSERT INTO ts_area VALUES ('1087','铜陵市','1045');
INSERT INTO ts_area VALUES ('1088','铜官山区','1087');
INSERT INTO ts_area VALUES ('1089','狮子山区','1087');
INSERT INTO ts_area VALUES ('1090','郊区','1087');
INSERT INTO ts_area VALUES ('1091','铜陵县','1087');
INSERT INTO ts_area VALUES ('1092','安庆市','1045');
INSERT INTO ts_area VALUES ('1093','迎江区','1092');
INSERT INTO ts_area VALUES ('1094','大观区','1092');
INSERT INTO ts_area VALUES ('1095','宜秀区','1092');
INSERT INTO ts_area VALUES ('1096','怀宁县','1092');
INSERT INTO ts_area VALUES ('1097','枞阳县','1092');
INSERT INTO ts_area VALUES ('1098','潜山县','1092');
INSERT INTO ts_area VALUES ('1099','太湖县','1092');
INSERT INTO ts_area VALUES ('1100','宿松县','1092');
INSERT INTO ts_area VALUES ('1101','望江县','1092');
INSERT INTO ts_area VALUES ('1102','岳西县','1092');
INSERT INTO ts_area VALUES ('1103','桐城市','1092');
INSERT INTO ts_area VALUES ('1104','黄山市','1045');
INSERT INTO ts_area VALUES ('1105','屯溪区','1104');
INSERT INTO ts_area VALUES ('1106','黄山区','1104');
INSERT INTO ts_area VALUES ('1107','徽州区','1104');
INSERT INTO ts_area VALUES ('1108','歙县','1104');
INSERT INTO ts_area VALUES ('1109','休宁县','1104');
INSERT INTO ts_area VALUES ('1110','黟县','1104');
INSERT INTO ts_area VALUES ('1111','祁门县','1104');
INSERT INTO ts_area VALUES ('1112','滁州市','1045');
INSERT INTO ts_area VALUES ('1113','琅琊区','1112');
INSERT INTO ts_area VALUES ('1114','南谯区','1112');
INSERT INTO ts_area VALUES ('1115','来安县','1112');
INSERT INTO ts_area VALUES ('1116','全椒县','1112');
INSERT INTO ts_area VALUES ('1117','定远县','1112');
INSERT INTO ts_area VALUES ('1118','凤阳县','1112');
INSERT INTO ts_area VALUES ('1119','天长市','1112');
INSERT INTO ts_area VALUES ('1120','明光市','1112');
INSERT INTO ts_area VALUES ('1121','阜阳市','1045');
INSERT INTO ts_area VALUES ('1122','颍州区','1121');
INSERT INTO ts_area VALUES ('1123','颍东区','1121');
INSERT INTO ts_area VALUES ('1124','颍泉区','1121');
INSERT INTO ts_area VALUES ('1125','临泉县','1121');
INSERT INTO ts_area VALUES ('1126','太和县','1121');
INSERT INTO ts_area VALUES ('1127','阜南县','1121');
INSERT INTO ts_area VALUES ('1128','颍上县','1121');
INSERT INTO ts_area VALUES ('1129','界首市','1121');
INSERT INTO ts_area VALUES ('1130','宿州市','1045');
INSERT INTO ts_area VALUES ('1131','埇桥区','1130');
INSERT INTO ts_area VALUES ('1132','砀山县','1130');
INSERT INTO ts_area VALUES ('1133','萧县','1130');
INSERT INTO ts_area VALUES ('1134','灵璧县','1130');
INSERT INTO ts_area VALUES ('1135','泗县','1130');
INSERT INTO ts_area VALUES ('1136','巢湖市','1045');
INSERT INTO ts_area VALUES ('1137','居巢区','1136');
INSERT INTO ts_area VALUES ('1138','庐江县','1136');
INSERT INTO ts_area VALUES ('1139','无为县','1136');
INSERT INTO ts_area VALUES ('1140','含山县','1136');
INSERT INTO ts_area VALUES ('1141','和县','1136');
INSERT INTO ts_area VALUES ('1142','六安市','1045');
INSERT INTO ts_area VALUES ('1143','金安区','1142');
INSERT INTO ts_area VALUES ('1144','裕安区','1142');
INSERT INTO ts_area VALUES ('1145','寿县','1142');
INSERT INTO ts_area VALUES ('1146','霍邱县','1142');
INSERT INTO ts_area VALUES ('1147','舒城县','1142');
INSERT INTO ts_area VALUES ('1148','金寨县','1142');
INSERT INTO ts_area VALUES ('1149','霍山县','1142');
INSERT INTO ts_area VALUES ('1150','亳州市','1045');
INSERT INTO ts_area VALUES ('1151','谯城区','1150');
INSERT INTO ts_area VALUES ('1152','涡阳县','1150');
INSERT INTO ts_area VALUES ('1153','蒙城县','1150');
INSERT INTO ts_area VALUES ('1154','利辛县','1150');
INSERT INTO ts_area VALUES ('1155','池州市','1045');
INSERT INTO ts_area VALUES ('1156','贵池区','1155');
INSERT INTO ts_area VALUES ('1157','东至县','1155');
INSERT INTO ts_area VALUES ('1158','石台县','1155');
INSERT INTO ts_area VALUES ('1159','青阳县','1155');
INSERT INTO ts_area VALUES ('1160','宣城市','1045');
INSERT INTO ts_area VALUES ('1161','宣州区','1160');
INSERT INTO ts_area VALUES ('1162','郎溪县','1160');
INSERT INTO ts_area VALUES ('1163','广德县','1160');
INSERT INTO ts_area VALUES ('1164','泾县','1160');
INSERT INTO ts_area VALUES ('1165','绩溪县','1160');
INSERT INTO ts_area VALUES ('1166','旌德县','1160');
INSERT INTO ts_area VALUES ('1167','宁国市','1160');
INSERT INTO ts_area VALUES ('1168','福建','0');
INSERT INTO ts_area VALUES ('1169','福州市','1168');
INSERT INTO ts_area VALUES ('1170','鼓楼区','1169');
INSERT INTO ts_area VALUES ('1171','台江区','1169');
INSERT INTO ts_area VALUES ('1172','仓山区','1169');
INSERT INTO ts_area VALUES ('1173','马尾区','1169');
INSERT INTO ts_area VALUES ('1174','晋安区','1169');
INSERT INTO ts_area VALUES ('1175','闽侯县','1169');
INSERT INTO ts_area VALUES ('1176','连江县','1169');
INSERT INTO ts_area VALUES ('1177','罗源县','1169');
INSERT INTO ts_area VALUES ('1178','闽清县','1169');
INSERT INTO ts_area VALUES ('1179','永泰县','1169');
INSERT INTO ts_area VALUES ('1180','平潭县','1169');
INSERT INTO ts_area VALUES ('1181','福清市','1169');
INSERT INTO ts_area VALUES ('1182','长乐市','1169');
INSERT INTO ts_area VALUES ('1183','厦门市','1168');
INSERT INTO ts_area VALUES ('1184','思明区','1183');
INSERT INTO ts_area VALUES ('1185','海沧区','1183');
INSERT INTO ts_area VALUES ('1186','湖里区','1183');
INSERT INTO ts_area VALUES ('1187','集美区','1183');
INSERT INTO ts_area VALUES ('1188','同安区','1183');
INSERT INTO ts_area VALUES ('1189','翔安区','1183');
INSERT INTO ts_area VALUES ('1190','莆田市','1168');
INSERT INTO ts_area VALUES ('1191','城厢区','1190');
INSERT INTO ts_area VALUES ('1192','涵江区','1190');
INSERT INTO ts_area VALUES ('1193','荔城区','1190');
INSERT INTO ts_area VALUES ('1194','秀屿区','1190');
INSERT INTO ts_area VALUES ('1195','仙游县','1190');
INSERT INTO ts_area VALUES ('1196','三明市','1168');
INSERT INTO ts_area VALUES ('1197','梅列区','1196');
INSERT INTO ts_area VALUES ('1198','三元区','1196');
INSERT INTO ts_area VALUES ('1199','明溪县','1196');
INSERT INTO ts_area VALUES ('1200','清流县','1196');
INSERT INTO ts_area VALUES ('1201','宁化县','1196');
INSERT INTO ts_area VALUES ('1202','大田县','1196');
INSERT INTO ts_area VALUES ('1203','尤溪县','1196');
INSERT INTO ts_area VALUES ('1204','沙县','1196');
INSERT INTO ts_area VALUES ('1205','将乐县','1196');
INSERT INTO ts_area VALUES ('1206','泰宁县','1196');
INSERT INTO ts_area VALUES ('1207','建宁县','1196');
INSERT INTO ts_area VALUES ('1208','永安市','1196');
INSERT INTO ts_area VALUES ('1209','泉州市','1168');
INSERT INTO ts_area VALUES ('1210','鲤城区','1209');
INSERT INTO ts_area VALUES ('1211','丰泽区','1209');
INSERT INTO ts_area VALUES ('1212','洛江区','1209');
INSERT INTO ts_area VALUES ('1213','泉港区','1209');
INSERT INTO ts_area VALUES ('1214','惠安县','1209');
INSERT INTO ts_area VALUES ('1215','安溪县','1209');
INSERT INTO ts_area VALUES ('1216','永春县','1209');
INSERT INTO ts_area VALUES ('1217','德化县','1209');
INSERT INTO ts_area VALUES ('1218','金门县','1209');
INSERT INTO ts_area VALUES ('1219','石狮市','1209');
INSERT INTO ts_area VALUES ('1220','晋江市','1209');
INSERT INTO ts_area VALUES ('1221','南安市','1209');
INSERT INTO ts_area VALUES ('1222','漳州市','1168');
INSERT INTO ts_area VALUES ('1223','芗城区','1222');
INSERT INTO ts_area VALUES ('1224','龙文区','1222');
INSERT INTO ts_area VALUES ('1225','云霄县','1222');
INSERT INTO ts_area VALUES ('1226','漳浦县','1222');
INSERT INTO ts_area VALUES ('1227','诏安县','1222');
INSERT INTO ts_area VALUES ('1228','长泰县','1222');
INSERT INTO ts_area VALUES ('1229','东山县','1222');
INSERT INTO ts_area VALUES ('1230','南靖县','1222');
INSERT INTO ts_area VALUES ('1231','平和县','1222');
INSERT INTO ts_area VALUES ('1232','华安县','1222');
INSERT INTO ts_area VALUES ('1233','龙海市','1222');
INSERT INTO ts_area VALUES ('1234','南平市','1168');
INSERT INTO ts_area VALUES ('1235','延平区','1234');
INSERT INTO ts_area VALUES ('1236','顺昌县','1234');
INSERT INTO ts_area VALUES ('1237','浦城县','1234');
INSERT INTO ts_area VALUES ('1238','光泽县','1234');
INSERT INTO ts_area VALUES ('1239','松溪县','1234');
INSERT INTO ts_area VALUES ('1240','政和县','1234');
INSERT INTO ts_area VALUES ('1241','邵武市','1234');
INSERT INTO ts_area VALUES ('1242','武夷山市','1234');
INSERT INTO ts_area VALUES ('1243','建瓯市','1234');
INSERT INTO ts_area VALUES ('1244','建阳市','1234');
INSERT INTO ts_area VALUES ('1245','龙岩市','1168');
INSERT INTO ts_area VALUES ('1246','新罗区','1245');
INSERT INTO ts_area VALUES ('1247','长汀县','1245');
INSERT INTO ts_area VALUES ('1248','永定县','1245');
INSERT INTO ts_area VALUES ('1249','上杭县','1245');
INSERT INTO ts_area VALUES ('1250','武平县','1245');
INSERT INTO ts_area VALUES ('1251','连城县','1245');
INSERT INTO ts_area VALUES ('1252','漳平市','1245');
INSERT INTO ts_area VALUES ('1253','宁德市','1168');
INSERT INTO ts_area VALUES ('1254','蕉城区','1253');
INSERT INTO ts_area VALUES ('1255','霞浦县','1253');
INSERT INTO ts_area VALUES ('1256','古田县','1253');
INSERT INTO ts_area VALUES ('1257','屏南县','1253');
INSERT INTO ts_area VALUES ('1258','寿宁县','1253');
INSERT INTO ts_area VALUES ('1259','周宁县','1253');
INSERT INTO ts_area VALUES ('1260','柘荣县','1253');
INSERT INTO ts_area VALUES ('1261','福安市','1253');
INSERT INTO ts_area VALUES ('1262','福鼎市','1253');
INSERT INTO ts_area VALUES ('1263','江西','0');
INSERT INTO ts_area VALUES ('1264','南昌市','1263');
INSERT INTO ts_area VALUES ('1265','东湖区','1264');
INSERT INTO ts_area VALUES ('1266','西湖区','1264');
INSERT INTO ts_area VALUES ('1267','青云谱区','1264');
INSERT INTO ts_area VALUES ('1268','湾里区','1264');
INSERT INTO ts_area VALUES ('1269','青山湖区','1264');
INSERT INTO ts_area VALUES ('1270','南昌县','1264');
INSERT INTO ts_area VALUES ('1271','新建县','1264');
INSERT INTO ts_area VALUES ('1272','安义县','1264');
INSERT INTO ts_area VALUES ('1273','进贤县','1264');
INSERT INTO ts_area VALUES ('1274','景德镇市','1263');
INSERT INTO ts_area VALUES ('1275','昌江区','1274');
INSERT INTO ts_area VALUES ('1276','珠山区','1274');
INSERT INTO ts_area VALUES ('1277','浮梁县','1274');
INSERT INTO ts_area VALUES ('1278','乐平市','1274');
INSERT INTO ts_area VALUES ('1279','萍乡市','1263');
INSERT INTO ts_area VALUES ('1280','安源区','1279');
INSERT INTO ts_area VALUES ('1281','湘东区','1279');
INSERT INTO ts_area VALUES ('1282','莲花县','1279');
INSERT INTO ts_area VALUES ('1283','上栗县','1279');
INSERT INTO ts_area VALUES ('1284','芦溪县','1279');
INSERT INTO ts_area VALUES ('1285','九江市','1263');
INSERT INTO ts_area VALUES ('1286','庐山区','1285');
INSERT INTO ts_area VALUES ('1287','浔阳区','1285');
INSERT INTO ts_area VALUES ('1288','九江县','1285');
INSERT INTO ts_area VALUES ('1289','武宁县','1285');
INSERT INTO ts_area VALUES ('1290','修水县','1285');
INSERT INTO ts_area VALUES ('1291','永修县','1285');
INSERT INTO ts_area VALUES ('1292','德安县','1285');
INSERT INTO ts_area VALUES ('1293','星子县','1285');
INSERT INTO ts_area VALUES ('1294','都昌县','1285');
INSERT INTO ts_area VALUES ('1295','湖口县','1285');
INSERT INTO ts_area VALUES ('1296','彭泽县','1285');
INSERT INTO ts_area VALUES ('1297','瑞昌市','1285');
INSERT INTO ts_area VALUES ('1298','新余市','1263');
INSERT INTO ts_area VALUES ('1299','渝水区','1298');
INSERT INTO ts_area VALUES ('1300','分宜县','1298');
INSERT INTO ts_area VALUES ('1301','鹰潭市','1263');
INSERT INTO ts_area VALUES ('1302','月湖区','1301');
INSERT INTO ts_area VALUES ('1303','余江县','1301');
INSERT INTO ts_area VALUES ('1304','贵溪市','1301');
INSERT INTO ts_area VALUES ('1305','赣州市','1263');
INSERT INTO ts_area VALUES ('1306','章贡区','1305');
INSERT INTO ts_area VALUES ('1307','赣县','1305');
INSERT INTO ts_area VALUES ('1308','信丰县','1305');
INSERT INTO ts_area VALUES ('1309','大余县','1305');
INSERT INTO ts_area VALUES ('1310','上犹县','1305');
INSERT INTO ts_area VALUES ('1311','崇义县','1305');
INSERT INTO ts_area VALUES ('1312','安远县','1305');
INSERT INTO ts_area VALUES ('1313','龙南县','1305');
INSERT INTO ts_area VALUES ('1314','定南县','1305');
INSERT INTO ts_area VALUES ('1315','全南县','1305');
INSERT INTO ts_area VALUES ('1316','宁都县','1305');
INSERT INTO ts_area VALUES ('1317','于都县','1305');
INSERT INTO ts_area VALUES ('1318','兴国县','1305');
INSERT INTO ts_area VALUES ('1319','会昌县','1305');
INSERT INTO ts_area VALUES ('1320','寻乌县','1305');
INSERT INTO ts_area VALUES ('1321','石城县','1305');
INSERT INTO ts_area VALUES ('1322','瑞金市','1305');
INSERT INTO ts_area VALUES ('1323','南康市','1305');
INSERT INTO ts_area VALUES ('1324','吉安市','1263');
INSERT INTO ts_area VALUES ('1325','吉州区','1324');
INSERT INTO ts_area VALUES ('1326','青原区','1324');
INSERT INTO ts_area VALUES ('1327','吉安县','1324');
INSERT INTO ts_area VALUES ('1328','吉水县','1324');
INSERT INTO ts_area VALUES ('1329','峡江县','1324');
INSERT INTO ts_area VALUES ('1330','新干县','1324');
INSERT INTO ts_area VALUES ('1331','永丰县','1324');
INSERT INTO ts_area VALUES ('1332','泰和县','1324');
INSERT INTO ts_area VALUES ('1333','遂川县','1324');
INSERT INTO ts_area VALUES ('1334','万安县','1324');
INSERT INTO ts_area VALUES ('1335','安福县','1324');
INSERT INTO ts_area VALUES ('1336','永新县','1324');
INSERT INTO ts_area VALUES ('1337','井冈山市','1324');
INSERT INTO ts_area VALUES ('1338','宜春市','1263');
INSERT INTO ts_area VALUES ('1339','袁州区','1338');
INSERT INTO ts_area VALUES ('1340','奉新县','1338');
INSERT INTO ts_area VALUES ('1341','万载县','1338');
INSERT INTO ts_area VALUES ('1342','上高县','1338');
INSERT INTO ts_area VALUES ('1343','宜丰县','1338');
INSERT INTO ts_area VALUES ('1344','靖安县','1338');
INSERT INTO ts_area VALUES ('1345','铜鼓县','1338');
INSERT INTO ts_area VALUES ('1346','丰城市','1338');
INSERT INTO ts_area VALUES ('1347','樟树市','1338');
INSERT INTO ts_area VALUES ('1348','高安市','1338');
INSERT INTO ts_area VALUES ('1349','抚州市','1263');
INSERT INTO ts_area VALUES ('1350','临川区','1349');
INSERT INTO ts_area VALUES ('1351','南城县','1349');
INSERT INTO ts_area VALUES ('1352','黎川县','1349');
INSERT INTO ts_area VALUES ('1353','南丰县','1349');
INSERT INTO ts_area VALUES ('1354','崇仁县','1349');
INSERT INTO ts_area VALUES ('1355','乐安县','1349');
INSERT INTO ts_area VALUES ('1356','宜黄县','1349');
INSERT INTO ts_area VALUES ('1357','金溪县','1349');
INSERT INTO ts_area VALUES ('1358','资溪县','1349');
INSERT INTO ts_area VALUES ('1359','东乡县','1349');
INSERT INTO ts_area VALUES ('1360','广昌县','1349');
INSERT INTO ts_area VALUES ('1361','上饶市','1263');
INSERT INTO ts_area VALUES ('1362','信州区','1361');
INSERT INTO ts_area VALUES ('1363','上饶县','1361');
INSERT INTO ts_area VALUES ('1364','广丰县','1361');
INSERT INTO ts_area VALUES ('1365','玉山县','1361');
INSERT INTO ts_area VALUES ('1366','铅山县','1361');
INSERT INTO ts_area VALUES ('1367','横峰县','1361');
INSERT INTO ts_area VALUES ('1368','弋阳县','1361');
INSERT INTO ts_area VALUES ('1369','余干县','1361');
INSERT INTO ts_area VALUES ('1370','鄱阳县','1361');
INSERT INTO ts_area VALUES ('1371','万年县','1361');
INSERT INTO ts_area VALUES ('1372','婺源县','1361');
INSERT INTO ts_area VALUES ('1373','德兴市','1361');
INSERT INTO ts_area VALUES ('1374','山东','0');
INSERT INTO ts_area VALUES ('1375','济南市','1374');
INSERT INTO ts_area VALUES ('1376','历下区','1375');
INSERT INTO ts_area VALUES ('1377','市中区','1375');
INSERT INTO ts_area VALUES ('1378','槐荫区','1375');
INSERT INTO ts_area VALUES ('1379','天桥区','1375');
INSERT INTO ts_area VALUES ('1380','历城区','1375');
INSERT INTO ts_area VALUES ('1381','长清区','1375');
INSERT INTO ts_area VALUES ('1382','平阴县','1375');
INSERT INTO ts_area VALUES ('1383','济阳县','1375');
INSERT INTO ts_area VALUES ('1384','商河县','1375');
INSERT INTO ts_area VALUES ('1385','章丘市','1375');
INSERT INTO ts_area VALUES ('1386','青岛市','1374');
INSERT INTO ts_area VALUES ('1387','市南区','1386');
INSERT INTO ts_area VALUES ('1388','市北区','1386');
INSERT INTO ts_area VALUES ('1389','四方区','1386');
INSERT INTO ts_area VALUES ('1390','黄岛区','1386');
INSERT INTO ts_area VALUES ('1391','崂山区','1386');
INSERT INTO ts_area VALUES ('1392','李沧区','1386');
INSERT INTO ts_area VALUES ('1393','城阳区','1386');
INSERT INTO ts_area VALUES ('1394','胶州市','1386');
INSERT INTO ts_area VALUES ('1395','即墨市','1386');
INSERT INTO ts_area VALUES ('1396','平度市','1386');
INSERT INTO ts_area VALUES ('1397','胶南市','1386');
INSERT INTO ts_area VALUES ('1398','莱西市','1386');
INSERT INTO ts_area VALUES ('1399','淄博市','1374');
INSERT INTO ts_area VALUES ('1400','淄川区','1399');
INSERT INTO ts_area VALUES ('1401','张店区','1399');
INSERT INTO ts_area VALUES ('1402','博山区','1399');
INSERT INTO ts_area VALUES ('1403','临淄区','1399');
INSERT INTO ts_area VALUES ('1404','周村区','1399');
INSERT INTO ts_area VALUES ('1405','桓台县','1399');
INSERT INTO ts_area VALUES ('1406','高青县','1399');
INSERT INTO ts_area VALUES ('1407','沂源县','1399');
INSERT INTO ts_area VALUES ('1408','枣庄市','1374');
INSERT INTO ts_area VALUES ('1409','市中区','1408');
INSERT INTO ts_area VALUES ('1410','薛城区','1408');
INSERT INTO ts_area VALUES ('1411','峄城区','1408');
INSERT INTO ts_area VALUES ('1412','台儿庄区','1408');
INSERT INTO ts_area VALUES ('1413','山亭区','1408');
INSERT INTO ts_area VALUES ('1414','滕州市','1408');
INSERT INTO ts_area VALUES ('1415','东营市','1374');
INSERT INTO ts_area VALUES ('1416','东营区','1415');
INSERT INTO ts_area VALUES ('1417','河口区','1415');
INSERT INTO ts_area VALUES ('1418','垦利县','1415');
INSERT INTO ts_area VALUES ('1419','利津县','1415');
INSERT INTO ts_area VALUES ('1420','广饶县','1415');
INSERT INTO ts_area VALUES ('1421','烟台市','1374');
INSERT INTO ts_area VALUES ('1422','芝罘区','1421');
INSERT INTO ts_area VALUES ('1423','福山区','1421');
INSERT INTO ts_area VALUES ('1424','牟平区','1421');
INSERT INTO ts_area VALUES ('1425','莱山区','1421');
INSERT INTO ts_area VALUES ('1426','长岛县','1421');
INSERT INTO ts_area VALUES ('1427','龙口市','1421');
INSERT INTO ts_area VALUES ('1428','莱阳市','1421');
INSERT INTO ts_area VALUES ('1429','莱州市','1421');
INSERT INTO ts_area VALUES ('1430','蓬莱市','1421');
INSERT INTO ts_area VALUES ('1431','招远市','1421');
INSERT INTO ts_area VALUES ('1432','栖霞市','1421');
INSERT INTO ts_area VALUES ('1433','海阳市','1421');
INSERT INTO ts_area VALUES ('1434','潍坊市','1374');
INSERT INTO ts_area VALUES ('1435','潍城区','1434');
INSERT INTO ts_area VALUES ('1436','寒亭区','1434');
INSERT INTO ts_area VALUES ('1437','坊子区','1434');
INSERT INTO ts_area VALUES ('1438','奎文区','1434');
INSERT INTO ts_area VALUES ('1439','临朐县','1434');
INSERT INTO ts_area VALUES ('1440','昌乐县','1434');
INSERT INTO ts_area VALUES ('1441','青州市','1434');
INSERT INTO ts_area VALUES ('1442','诸城市','1434');
INSERT INTO ts_area VALUES ('1443','寿光市','1434');
INSERT INTO ts_area VALUES ('1444','安丘市','1434');
INSERT INTO ts_area VALUES ('1445','高密市','1434');
INSERT INTO ts_area VALUES ('1446','昌邑市','1434');
INSERT INTO ts_area VALUES ('1447','济宁市','1374');
INSERT INTO ts_area VALUES ('1448','市中区','1447');
INSERT INTO ts_area VALUES ('1449','任城区','1447');
INSERT INTO ts_area VALUES ('1450','微山县','1447');
INSERT INTO ts_area VALUES ('1451','鱼台县','1447');
INSERT INTO ts_area VALUES ('1452','金乡县','1447');
INSERT INTO ts_area VALUES ('1453','嘉祥县','1447');
INSERT INTO ts_area VALUES ('1454','汶上县','1447');
INSERT INTO ts_area VALUES ('1455','泗水县','1447');
INSERT INTO ts_area VALUES ('1456','梁山县','1447');
INSERT INTO ts_area VALUES ('1457','曲阜市','1447');
INSERT INTO ts_area VALUES ('1458','兖州市','1447');
INSERT INTO ts_area VALUES ('1459','邹城市','1447');
INSERT INTO ts_area VALUES ('1460','泰安市','1374');
INSERT INTO ts_area VALUES ('1461','泰山区','1460');
INSERT INTO ts_area VALUES ('1462','岱岳区','1460');
INSERT INTO ts_area VALUES ('1463','宁阳县','1460');
INSERT INTO ts_area VALUES ('1464','东平县','1460');
INSERT INTO ts_area VALUES ('1465','新泰市','1460');
INSERT INTO ts_area VALUES ('1466','肥城市','1460');
INSERT INTO ts_area VALUES ('1467','威海市','1374');
INSERT INTO ts_area VALUES ('1468','环翠区','1467');
INSERT INTO ts_area VALUES ('1469','文登市','1467');
INSERT INTO ts_area VALUES ('1470','荣成市','1467');
INSERT INTO ts_area VALUES ('1471','乳山市','1467');
INSERT INTO ts_area VALUES ('1472','日照市','1374');
INSERT INTO ts_area VALUES ('1473','东港区','1472');
INSERT INTO ts_area VALUES ('1474','岚山区','1472');
INSERT INTO ts_area VALUES ('1475','五莲县','1472');
INSERT INTO ts_area VALUES ('1476','莒县','1472');
INSERT INTO ts_area VALUES ('1477','莱芜市','1374');
INSERT INTO ts_area VALUES ('1478','莱城区','1477');
INSERT INTO ts_area VALUES ('1479','钢城区','1477');
INSERT INTO ts_area VALUES ('1480','临沂市','1374');
INSERT INTO ts_area VALUES ('1481','兰山区','1480');
INSERT INTO ts_area VALUES ('1482','罗庄区','1480');
INSERT INTO ts_area VALUES ('1483','河东区','1480');
INSERT INTO ts_area VALUES ('1484','沂南县','1480');
INSERT INTO ts_area VALUES ('1485','郯城县','1480');
INSERT INTO ts_area VALUES ('1486','沂水县','1480');
INSERT INTO ts_area VALUES ('1487','苍山县','1480');
INSERT INTO ts_area VALUES ('1488','费县','1480');
INSERT INTO ts_area VALUES ('1489','平邑县','1480');
INSERT INTO ts_area VALUES ('1490','莒南县','1480');
INSERT INTO ts_area VALUES ('1491','蒙阴县','1480');
INSERT INTO ts_area VALUES ('1492','临沭县','1480');
INSERT INTO ts_area VALUES ('1493','德州市','1374');
INSERT INTO ts_area VALUES ('1494','德城区','1493');
INSERT INTO ts_area VALUES ('1495','陵县','1493');
INSERT INTO ts_area VALUES ('1496','宁津县','1493');
INSERT INTO ts_area VALUES ('1497','庆云县','1493');
INSERT INTO ts_area VALUES ('1498','临邑县','1493');
INSERT INTO ts_area VALUES ('1499','齐河县','1493');
INSERT INTO ts_area VALUES ('1500','平原县','1493');
INSERT INTO ts_area VALUES ('1501','夏津县','1493');
INSERT INTO ts_area VALUES ('1502','武城县','1493');
INSERT INTO ts_area VALUES ('1503','乐陵市','1493');
INSERT INTO ts_area VALUES ('1504','禹城市','1493');
INSERT INTO ts_area VALUES ('1505','聊城市','1374');
INSERT INTO ts_area VALUES ('1506','东昌府区','1505');
INSERT INTO ts_area VALUES ('1507','阳谷县','1505');
INSERT INTO ts_area VALUES ('1508','莘县','1505');
INSERT INTO ts_area VALUES ('1509','茌平县','1505');
INSERT INTO ts_area VALUES ('1510','东阿县','1505');
INSERT INTO ts_area VALUES ('1511','冠县','1505');
INSERT INTO ts_area VALUES ('1512','高唐县','1505');
INSERT INTO ts_area VALUES ('1513','临清市','1505');
INSERT INTO ts_area VALUES ('1514','滨州市','1374');
INSERT INTO ts_area VALUES ('1515','滨城区','1514');
INSERT INTO ts_area VALUES ('1516','惠民县','1514');
INSERT INTO ts_area VALUES ('1517','阳信县','1514');
INSERT INTO ts_area VALUES ('1518','无棣县','1514');
INSERT INTO ts_area VALUES ('1519','沾化县','1514');
INSERT INTO ts_area VALUES ('1520','博兴县','1514');
INSERT INTO ts_area VALUES ('1521','邹平县','1514');
INSERT INTO ts_area VALUES ('1522','菏泽市','1374');
INSERT INTO ts_area VALUES ('1523','牡丹区','1522');
INSERT INTO ts_area VALUES ('1524','曹县','1522');
INSERT INTO ts_area VALUES ('1525','单县','1522');
INSERT INTO ts_area VALUES ('1526','成武县','1522');
INSERT INTO ts_area VALUES ('1527','巨野县','1522');
INSERT INTO ts_area VALUES ('1528','郓城县','1522');
INSERT INTO ts_area VALUES ('1529','鄄城县','1522');
INSERT INTO ts_area VALUES ('1530','定陶县','1522');
INSERT INTO ts_area VALUES ('1531','东明县','1522');
INSERT INTO ts_area VALUES ('1532','河南','0');
INSERT INTO ts_area VALUES ('1533','郑州市','1532');
INSERT INTO ts_area VALUES ('1534','中原区','1533');
INSERT INTO ts_area VALUES ('1535','二七区','1533');
INSERT INTO ts_area VALUES ('1536','管城回族区','1533');
INSERT INTO ts_area VALUES ('1537','金水区','1533');
INSERT INTO ts_area VALUES ('1538','上街区','1533');
INSERT INTO ts_area VALUES ('1539','惠济区','1533');
INSERT INTO ts_area VALUES ('1540','中牟县','1533');
INSERT INTO ts_area VALUES ('1541','巩义市','1533');
INSERT INTO ts_area VALUES ('1542','荥阳市','1533');
INSERT INTO ts_area VALUES ('1543','新密市','1533');
INSERT INTO ts_area VALUES ('1544','新郑市','1533');
INSERT INTO ts_area VALUES ('1545','登封市','1533');
INSERT INTO ts_area VALUES ('1546','开封市','1532');
INSERT INTO ts_area VALUES ('1547','龙亭区','1546');
INSERT INTO ts_area VALUES ('1548','顺河回族区','1546');
INSERT INTO ts_area VALUES ('1549','鼓楼区','1546');
INSERT INTO ts_area VALUES ('1550','禹王台区','1546');
INSERT INTO ts_area VALUES ('1551','金明区','1546');
INSERT INTO ts_area VALUES ('1552','杞县','1546');
INSERT INTO ts_area VALUES ('1553','通许县','1546');
INSERT INTO ts_area VALUES ('1554','尉氏县','1546');
INSERT INTO ts_area VALUES ('1555','开封县','1546');
INSERT INTO ts_area VALUES ('1556','兰考县','1546');
INSERT INTO ts_area VALUES ('1557','洛阳市','1532');
INSERT INTO ts_area VALUES ('1558','老城区','1557');
INSERT INTO ts_area VALUES ('1559','西工区','1557');
INSERT INTO ts_area VALUES ('1560','瀍河回族区','1557');
INSERT INTO ts_area VALUES ('1561','涧西区','1557');
INSERT INTO ts_area VALUES ('1562','吉利区','1557');
INSERT INTO ts_area VALUES ('1563','洛龙区','1557');
INSERT INTO ts_area VALUES ('1564','孟津县','1557');
INSERT INTO ts_area VALUES ('1565','新安县','1557');
INSERT INTO ts_area VALUES ('1566','栾川县','1557');
INSERT INTO ts_area VALUES ('1567','嵩县','1557');
INSERT INTO ts_area VALUES ('1568','汝阳县','1557');
INSERT INTO ts_area VALUES ('1569','宜阳县','1557');
INSERT INTO ts_area VALUES ('1570','洛宁县','1557');
INSERT INTO ts_area VALUES ('1571','伊川县','1557');
INSERT INTO ts_area VALUES ('1572','偃师市','1557');
INSERT INTO ts_area VALUES ('1573','平顶山市','1532');
INSERT INTO ts_area VALUES ('1574','新华区','1573');
INSERT INTO ts_area VALUES ('1575','卫东区','1573');
INSERT INTO ts_area VALUES ('1576','石龙区','1573');
INSERT INTO ts_area VALUES ('1577','湛河区','1573');
INSERT INTO ts_area VALUES ('1578','宝丰县','1573');
INSERT INTO ts_area VALUES ('1579','叶县','1573');
INSERT INTO ts_area VALUES ('1580','鲁山县','1573');
INSERT INTO ts_area VALUES ('1581','郏县','1573');
INSERT INTO ts_area VALUES ('1582','舞钢市','1573');
INSERT INTO ts_area VALUES ('1583','汝州市','1573');
INSERT INTO ts_area VALUES ('1584','安阳市','1532');
INSERT INTO ts_area VALUES ('1585','文峰区','1584');
INSERT INTO ts_area VALUES ('1586','北关区','1584');
INSERT INTO ts_area VALUES ('1587','殷都区','1584');
INSERT INTO ts_area VALUES ('1588','龙安区','1584');
INSERT INTO ts_area VALUES ('1589','安阳县','1584');
INSERT INTO ts_area VALUES ('1590','汤阴县','1584');
INSERT INTO ts_area VALUES ('1591','滑县','1584');
INSERT INTO ts_area VALUES ('1592','内黄县','1584');
INSERT INTO ts_area VALUES ('1593','林州市','1584');
INSERT INTO ts_area VALUES ('1594','鹤壁市','1532');
INSERT INTO ts_area VALUES ('1595','鹤山区','1594');
INSERT INTO ts_area VALUES ('1596','山城区','1594');
INSERT INTO ts_area VALUES ('1597','淇滨区','1594');
INSERT INTO ts_area VALUES ('1598','浚县','1594');
INSERT INTO ts_area VALUES ('1599','淇县','1594');
INSERT INTO ts_area VALUES ('1600','新乡市','1532');
INSERT INTO ts_area VALUES ('1601','红旗区','1600');
INSERT INTO ts_area VALUES ('1602','卫滨区','1600');
INSERT INTO ts_area VALUES ('1603','凤泉区','1600');
INSERT INTO ts_area VALUES ('1604','牧野区','1600');
INSERT INTO ts_area VALUES ('1605','新乡县','1600');
INSERT INTO ts_area VALUES ('1606','获嘉县','1600');
INSERT INTO ts_area VALUES ('1607','原阳县','1600');
INSERT INTO ts_area VALUES ('1608','延津县','1600');
INSERT INTO ts_area VALUES ('1609','封丘县','1600');
INSERT INTO ts_area VALUES ('1610','长垣县','1600');
INSERT INTO ts_area VALUES ('1611','卫辉市','1600');
INSERT INTO ts_area VALUES ('1612','辉县市','1600');
INSERT INTO ts_area VALUES ('1613','焦作市','1532');
INSERT INTO ts_area VALUES ('1614','解放区','1613');
INSERT INTO ts_area VALUES ('1615','中站区','1613');
INSERT INTO ts_area VALUES ('1616','马村区','1613');
INSERT INTO ts_area VALUES ('1617','山阳区','1613');
INSERT INTO ts_area VALUES ('1618','修武县','1613');
INSERT INTO ts_area VALUES ('1619','博爱县','1613');
INSERT INTO ts_area VALUES ('1620','武陟县','1613');
INSERT INTO ts_area VALUES ('1621','温县','1613');
INSERT INTO ts_area VALUES ('1622','济源市','1613');
INSERT INTO ts_area VALUES ('1623','沁阳市','1613');
INSERT INTO ts_area VALUES ('1624','孟州市','1613');
INSERT INTO ts_area VALUES ('1625','濮阳市','1532');
INSERT INTO ts_area VALUES ('1626','华龙区','1625');
INSERT INTO ts_area VALUES ('1627','清丰县','1625');
INSERT INTO ts_area VALUES ('1628','南乐县','1625');
INSERT INTO ts_area VALUES ('1629','范县','1625');
INSERT INTO ts_area VALUES ('1630','台前县','1625');
INSERT INTO ts_area VALUES ('1631','濮阳县','1625');
INSERT INTO ts_area VALUES ('1632','许昌市','1532');
INSERT INTO ts_area VALUES ('1633','魏都区','1632');
INSERT INTO ts_area VALUES ('1634','许昌县','1632');
INSERT INTO ts_area VALUES ('1635','鄢陵县','1632');
INSERT INTO ts_area VALUES ('1636','襄城县','1632');
INSERT INTO ts_area VALUES ('1637','禹州市','1632');
INSERT INTO ts_area VALUES ('1638','长葛市','1632');
INSERT INTO ts_area VALUES ('1639','漯河市','1532');
INSERT INTO ts_area VALUES ('1640','源汇区','1639');
INSERT INTO ts_area VALUES ('1641','郾城区','1639');
INSERT INTO ts_area VALUES ('1642','召陵区','1639');
INSERT INTO ts_area VALUES ('1643','舞阳县','1639');
INSERT INTO ts_area VALUES ('1644','临颍县','1639');
INSERT INTO ts_area VALUES ('1645','三门峡市','1532');
INSERT INTO ts_area VALUES ('1646','湖滨区','1645');
INSERT INTO ts_area VALUES ('1647','渑池县','1645');
INSERT INTO ts_area VALUES ('1648','陕县','1645');
INSERT INTO ts_area VALUES ('1649','卢氏县','1645');
INSERT INTO ts_area VALUES ('1650','义马市','1645');
INSERT INTO ts_area VALUES ('1651','灵宝市','1645');
INSERT INTO ts_area VALUES ('1652','南阳市','1532');
INSERT INTO ts_area VALUES ('1653','宛城区','1652');
INSERT INTO ts_area VALUES ('1654','卧龙区','1652');
INSERT INTO ts_area VALUES ('1655','南召县','1652');
INSERT INTO ts_area VALUES ('1656','方城县','1652');
INSERT INTO ts_area VALUES ('1657','西峡县','1652');
INSERT INTO ts_area VALUES ('1658','镇平县','1652');
INSERT INTO ts_area VALUES ('1659','内乡县','1652');
INSERT INTO ts_area VALUES ('1660','淅川县','1652');
INSERT INTO ts_area VALUES ('1661','社旗县','1652');
INSERT INTO ts_area VALUES ('1662','唐河县','1652');
INSERT INTO ts_area VALUES ('1663','新野县','1652');
INSERT INTO ts_area VALUES ('1664','桐柏县','1652');
INSERT INTO ts_area VALUES ('1665','邓州市','1652');
INSERT INTO ts_area VALUES ('1666','商丘市','1532');
INSERT INTO ts_area VALUES ('1667','梁园区','1666');
INSERT INTO ts_area VALUES ('1668','睢阳区','1666');
INSERT INTO ts_area VALUES ('1669','民权县','1666');
INSERT INTO ts_area VALUES ('1670','睢县','1666');
INSERT INTO ts_area VALUES ('1671','宁陵县','1666');
INSERT INTO ts_area VALUES ('1672','柘城县','1666');
INSERT INTO ts_area VALUES ('1673','虞城县','1666');
INSERT INTO ts_area VALUES ('1674','夏邑县','1666');
INSERT INTO ts_area VALUES ('1675','永城市','1666');
INSERT INTO ts_area VALUES ('1676','信阳市','1532');
INSERT INTO ts_area VALUES ('1677','浉河区','1676');
INSERT INTO ts_area VALUES ('1678','平桥区','1676');
INSERT INTO ts_area VALUES ('1679','罗山县','1676');
INSERT INTO ts_area VALUES ('1680','光山县','1676');
INSERT INTO ts_area VALUES ('1681','新县','1676');
INSERT INTO ts_area VALUES ('1682','商城县','1676');
INSERT INTO ts_area VALUES ('1683','固始县','1676');
INSERT INTO ts_area VALUES ('1684','潢川县','1676');
INSERT INTO ts_area VALUES ('1685','淮滨县','1676');
INSERT INTO ts_area VALUES ('1686','息县','1676');
INSERT INTO ts_area VALUES ('1687','周口市','1532');
INSERT INTO ts_area VALUES ('1688','川汇区','1687');
INSERT INTO ts_area VALUES ('1689','扶沟县','1687');
INSERT INTO ts_area VALUES ('1690','西华县','1687');
INSERT INTO ts_area VALUES ('1691','商水县','1687');
INSERT INTO ts_area VALUES ('1692','沈丘县','1687');
INSERT INTO ts_area VALUES ('1693','郸城县','1687');
INSERT INTO ts_area VALUES ('1694','淮阳县','1687');
INSERT INTO ts_area VALUES ('1695','太康县','1687');
INSERT INTO ts_area VALUES ('1696','鹿邑县','1687');
INSERT INTO ts_area VALUES ('1697','项城市','1687');
INSERT INTO ts_area VALUES ('1698','驻马店市','1532');
INSERT INTO ts_area VALUES ('1699','驿城区','1698');
INSERT INTO ts_area VALUES ('1700','西平县','1698');
INSERT INTO ts_area VALUES ('1701','上蔡县','1698');
INSERT INTO ts_area VALUES ('1702','平舆县','1698');
INSERT INTO ts_area VALUES ('1703','正阳县','1698');
INSERT INTO ts_area VALUES ('1704','确山县','1698');
INSERT INTO ts_area VALUES ('1705','泌阳县','1698');
INSERT INTO ts_area VALUES ('1706','汝南县','1698');
INSERT INTO ts_area VALUES ('1707','遂平县','1698');
INSERT INTO ts_area VALUES ('1708','新蔡县','1698');
INSERT INTO ts_area VALUES ('1709','湖北','0');
INSERT INTO ts_area VALUES ('1710','武汉市','1709');
INSERT INTO ts_area VALUES ('1711','江岸区','1710');
INSERT INTO ts_area VALUES ('1712','江汉区','1710');
INSERT INTO ts_area VALUES ('1713','硚口区','1710');
INSERT INTO ts_area VALUES ('1714','汉阳区','1710');
INSERT INTO ts_area VALUES ('1715','武昌区','1710');
INSERT INTO ts_area VALUES ('1716','青山区','1710');
INSERT INTO ts_area VALUES ('1717','洪山区','1710');
INSERT INTO ts_area VALUES ('1718','东西湖区','1710');
INSERT INTO ts_area VALUES ('1719','汉南区','1710');
INSERT INTO ts_area VALUES ('1720','蔡甸区','1710');
INSERT INTO ts_area VALUES ('1721','江夏区','1710');
INSERT INTO ts_area VALUES ('1722','黄陂区','1710');
INSERT INTO ts_area VALUES ('1723','新洲区','1710');
INSERT INTO ts_area VALUES ('1724','黄石市','1709');
INSERT INTO ts_area VALUES ('1725','黄石港区','1724');
INSERT INTO ts_area VALUES ('1726','西塞山区','1724');
INSERT INTO ts_area VALUES ('1727','下陆区','1724');
INSERT INTO ts_area VALUES ('1728','铁山区','1724');
INSERT INTO ts_area VALUES ('1729','阳新县','1724');
INSERT INTO ts_area VALUES ('1730','大冶市','1724');
INSERT INTO ts_area VALUES ('1731','十堰市','1709');
INSERT INTO ts_area VALUES ('1732','茅箭区','1731');
INSERT INTO ts_area VALUES ('1733','张湾区','1731');
INSERT INTO ts_area VALUES ('1734','郧县','1731');
INSERT INTO ts_area VALUES ('1735','郧西县','1731');
INSERT INTO ts_area VALUES ('1736','竹山县','1731');
INSERT INTO ts_area VALUES ('1737','竹溪县','1731');
INSERT INTO ts_area VALUES ('1738','房县','1731');
INSERT INTO ts_area VALUES ('1739','丹江口市','1731');
INSERT INTO ts_area VALUES ('1740','宜昌市','1709');
INSERT INTO ts_area VALUES ('1741','西陵区','1740');
INSERT INTO ts_area VALUES ('1742','伍家岗区','1740');
INSERT INTO ts_area VALUES ('1743','点军区','1740');
INSERT INTO ts_area VALUES ('1744','猇亭区','1740');
INSERT INTO ts_area VALUES ('1745','夷陵区','1740');
INSERT INTO ts_area VALUES ('1746','远安县','1740');
INSERT INTO ts_area VALUES ('1747','兴山县','1740');
INSERT INTO ts_area VALUES ('1748','秭归县','1740');
INSERT INTO ts_area VALUES ('1749','长阳土家族自治县','1740');
INSERT INTO ts_area VALUES ('1750','五峰土家族自治县','1740');
INSERT INTO ts_area VALUES ('1751','宜都市','1740');
INSERT INTO ts_area VALUES ('1752','当阳市','1740');
INSERT INTO ts_area VALUES ('1753','枝江市','1740');
INSERT INTO ts_area VALUES ('1754','襄樊市','1709');
INSERT INTO ts_area VALUES ('1755','襄城区','1754');
INSERT INTO ts_area VALUES ('1756','樊城区','1754');
INSERT INTO ts_area VALUES ('1757','襄阳区','1754');
INSERT INTO ts_area VALUES ('1758','南漳县','1754');
INSERT INTO ts_area VALUES ('1759','谷城县','1754');
INSERT INTO ts_area VALUES ('1760','保康县','1754');
INSERT INTO ts_area VALUES ('1761','老河口市','1754');
INSERT INTO ts_area VALUES ('1762','枣阳市','1754');
INSERT INTO ts_area VALUES ('1763','宜城市','1754');
INSERT INTO ts_area VALUES ('1764','鄂州市','1709');
INSERT INTO ts_area VALUES ('1765','梁子湖区','1764');
INSERT INTO ts_area VALUES ('1766','华容区','1764');
INSERT INTO ts_area VALUES ('1767','鄂城区','1764');
INSERT INTO ts_area VALUES ('1768','荆门市','1709');
INSERT INTO ts_area VALUES ('1769','东宝区','1768');
INSERT INTO ts_area VALUES ('1770','掇刀区','1768');
INSERT INTO ts_area VALUES ('1771','京山县','1768');
INSERT INTO ts_area VALUES ('1772','沙洋县','1768');
INSERT INTO ts_area VALUES ('1773','钟祥市','1768');
INSERT INTO ts_area VALUES ('1774','孝感市','1709');
INSERT INTO ts_area VALUES ('1775','孝南区','1774');
INSERT INTO ts_area VALUES ('1776','孝昌县','1774');
INSERT INTO ts_area VALUES ('1777','大悟县','1774');
INSERT INTO ts_area VALUES ('1778','云梦县','1774');
INSERT INTO ts_area VALUES ('1779','应城市','1774');
INSERT INTO ts_area VALUES ('1780','安陆市','1774');
INSERT INTO ts_area VALUES ('1781','汉川市','1774');
INSERT INTO ts_area VALUES ('1782','荆州市','1709');
INSERT INTO ts_area VALUES ('1783','沙市区','1782');
INSERT INTO ts_area VALUES ('1784','荆州区','1782');
INSERT INTO ts_area VALUES ('1785','公安县','1782');
INSERT INTO ts_area VALUES ('1786','监利县','1782');
INSERT INTO ts_area VALUES ('1787','江陵县','1782');
INSERT INTO ts_area VALUES ('1788','石首市','1782');
INSERT INTO ts_area VALUES ('1789','洪湖市','1782');
INSERT INTO ts_area VALUES ('1790','松滋市','1782');
INSERT INTO ts_area VALUES ('1791','黄冈市','1709');
INSERT INTO ts_area VALUES ('1792','黄州区','1791');
INSERT INTO ts_area VALUES ('1793','团风县','1791');
INSERT INTO ts_area VALUES ('1794','红安县','1791');
INSERT INTO ts_area VALUES ('1795','罗田县','1791');
INSERT INTO ts_area VALUES ('1796','英山县','1791');
INSERT INTO ts_area VALUES ('1797','浠水县','1791');
INSERT INTO ts_area VALUES ('1798','蕲春县','1791');
INSERT INTO ts_area VALUES ('1799','黄梅县','1791');
INSERT INTO ts_area VALUES ('1800','麻城市','1791');
INSERT INTO ts_area VALUES ('1801','武穴市','1791');
INSERT INTO ts_area VALUES ('1802','咸宁市','1709');
INSERT INTO ts_area VALUES ('1803','咸安区','1802');
INSERT INTO ts_area VALUES ('1804','嘉鱼县','1802');
INSERT INTO ts_area VALUES ('1805','通城县','1802');
INSERT INTO ts_area VALUES ('1806','崇阳县','1802');
INSERT INTO ts_area VALUES ('1807','通山县','1802');
INSERT INTO ts_area VALUES ('1808','赤壁市','1802');
INSERT INTO ts_area VALUES ('1809','随州市','1709');
INSERT INTO ts_area VALUES ('1810','曾都区','1809');
INSERT INTO ts_area VALUES ('1811','广水市','1809');
INSERT INTO ts_area VALUES ('1812','恩施土家族苗族自治州','1709');
INSERT INTO ts_area VALUES ('1813','恩施市','1812');
INSERT INTO ts_area VALUES ('1814','利川市','1812');
INSERT INTO ts_area VALUES ('1815','建始县','1812');
INSERT INTO ts_area VALUES ('1816','巴东县','1812');
INSERT INTO ts_area VALUES ('1817','宣恩县','1812');
INSERT INTO ts_area VALUES ('1818','咸丰县','1812');
INSERT INTO ts_area VALUES ('1819','来凤县','1812');
INSERT INTO ts_area VALUES ('1820','鹤峰县','1812');
INSERT INTO ts_area VALUES ('1821','省直辖县级行政单位','1709');
INSERT INTO ts_area VALUES ('1822','仙桃市','1821');
INSERT INTO ts_area VALUES ('1823','潜江市','1821');
INSERT INTO ts_area VALUES ('1824','天门市','1821');
INSERT INTO ts_area VALUES ('1825','神农架林区','1821');
INSERT INTO ts_area VALUES ('1826','湖南','0');
INSERT INTO ts_area VALUES ('1827','长沙市','1826');
INSERT INTO ts_area VALUES ('1828','芙蓉区','1827');
INSERT INTO ts_area VALUES ('1829','天心区','1827');
INSERT INTO ts_area VALUES ('1830','岳麓区','1827');
INSERT INTO ts_area VALUES ('1831','开福区','1827');
INSERT INTO ts_area VALUES ('1832','雨花区','1827');
INSERT INTO ts_area VALUES ('1833','长沙县','1827');
INSERT INTO ts_area VALUES ('1834','望城县','1827');
INSERT INTO ts_area VALUES ('1835','宁乡县','1827');
INSERT INTO ts_area VALUES ('1836','浏阳市','1827');
INSERT INTO ts_area VALUES ('1837','株洲市','1826');
INSERT INTO ts_area VALUES ('1838','荷塘区','1837');
INSERT INTO ts_area VALUES ('1839','芦淞区','1837');
INSERT INTO ts_area VALUES ('1840','石峰区','1837');
INSERT INTO ts_area VALUES ('1841','天元区','1837');
INSERT INTO ts_area VALUES ('1842','株洲县','1837');
INSERT INTO ts_area VALUES ('1843','攸县','1837');
INSERT INTO ts_area VALUES ('1844','茶陵县','1837');
INSERT INTO ts_area VALUES ('1845','炎陵县','1837');
INSERT INTO ts_area VALUES ('1846','醴陵市','1837');
INSERT INTO ts_area VALUES ('1847','湘潭市','1826');
INSERT INTO ts_area VALUES ('1848','雨湖区','1847');
INSERT INTO ts_area VALUES ('1849','岳塘区','1847');
INSERT INTO ts_area VALUES ('1850','湘潭县','1847');
INSERT INTO ts_area VALUES ('1851','湘乡市','1847');
INSERT INTO ts_area VALUES ('1852','韶山市','1847');
INSERT INTO ts_area VALUES ('1853','衡阳市','1826');
INSERT INTO ts_area VALUES ('1854','珠晖区','1853');
INSERT INTO ts_area VALUES ('1855','雁峰区','1853');
INSERT INTO ts_area VALUES ('1856','石鼓区','1853');
INSERT INTO ts_area VALUES ('1857','蒸湘区','1853');
INSERT INTO ts_area VALUES ('1858','南岳区','1853');
INSERT INTO ts_area VALUES ('1859','衡阳县','1853');
INSERT INTO ts_area VALUES ('1860','衡南县','1853');
INSERT INTO ts_area VALUES ('1861','衡山县','1853');
INSERT INTO ts_area VALUES ('1862','衡东县','1853');
INSERT INTO ts_area VALUES ('1863','祁东县','1853');
INSERT INTO ts_area VALUES ('1864','耒阳市','1853');
INSERT INTO ts_area VALUES ('1865','常宁市','1853');
INSERT INTO ts_area VALUES ('1866','邵阳市','1826');
INSERT INTO ts_area VALUES ('1867','双清区','1866');
INSERT INTO ts_area VALUES ('1868','大祥区','1866');
INSERT INTO ts_area VALUES ('1869','北塔区','1866');
INSERT INTO ts_area VALUES ('1870','邵东县','1866');
INSERT INTO ts_area VALUES ('1871','新邵县','1866');
INSERT INTO ts_area VALUES ('1872','邵阳县','1866');
INSERT INTO ts_area VALUES ('1873','隆回县','1866');
INSERT INTO ts_area VALUES ('1874','洞口县','1866');
INSERT INTO ts_area VALUES ('1875','绥宁县','1866');
INSERT INTO ts_area VALUES ('1876','新宁县','1866');
INSERT INTO ts_area VALUES ('1877','城步苗族自治县','1866');
INSERT INTO ts_area VALUES ('1878','武冈市','1866');
INSERT INTO ts_area VALUES ('1879','岳阳市','1826');
INSERT INTO ts_area VALUES ('1880','岳阳楼区','1879');
INSERT INTO ts_area VALUES ('1881','云溪区','1879');
INSERT INTO ts_area VALUES ('1882','君山区','1879');
INSERT INTO ts_area VALUES ('1883','岳阳县','1879');
INSERT INTO ts_area VALUES ('1884','华容县','1879');
INSERT INTO ts_area VALUES ('1885','湘阴县','1879');
INSERT INTO ts_area VALUES ('1886','平江县','1879');
INSERT INTO ts_area VALUES ('1887','汨罗市','1879');
INSERT INTO ts_area VALUES ('1888','临湘市','1879');
INSERT INTO ts_area VALUES ('1889','常德市','1826');
INSERT INTO ts_area VALUES ('1890','武陵区','1889');
INSERT INTO ts_area VALUES ('1891','鼎城区','1889');
INSERT INTO ts_area VALUES ('1892','安乡县','1889');
INSERT INTO ts_area VALUES ('1893','汉寿县','1889');
INSERT INTO ts_area VALUES ('1894','澧县','1889');
INSERT INTO ts_area VALUES ('1895','临澧县','1889');
INSERT INTO ts_area VALUES ('1896','桃源县','1889');
INSERT INTO ts_area VALUES ('1897','石门县','1889');
INSERT INTO ts_area VALUES ('1898','津市市','1889');
INSERT INTO ts_area VALUES ('1899','张家界市','1826');
INSERT INTO ts_area VALUES ('1900','永定区','1899');
INSERT INTO ts_area VALUES ('1901','武陵源区','1899');
INSERT INTO ts_area VALUES ('1902','慈利县','1899');
INSERT INTO ts_area VALUES ('1903','桑植县','1899');
INSERT INTO ts_area VALUES ('1904','益阳市','1826');
INSERT INTO ts_area VALUES ('1905','资阳区','1904');
INSERT INTO ts_area VALUES ('1906','赫山区','1904');
INSERT INTO ts_area VALUES ('1907','南县','1904');
INSERT INTO ts_area VALUES ('1908','桃江县','1904');
INSERT INTO ts_area VALUES ('1909','安化县','1904');
INSERT INTO ts_area VALUES ('1910','沅江市','1904');
INSERT INTO ts_area VALUES ('1911','郴州市','1826');
INSERT INTO ts_area VALUES ('1912','北湖区','1911');
INSERT INTO ts_area VALUES ('1913','苏仙区','1911');
INSERT INTO ts_area VALUES ('1914','桂阳县','1911');
INSERT INTO ts_area VALUES ('1915','宜章县','1911');
INSERT INTO ts_area VALUES ('1916','永兴县','1911');
INSERT INTO ts_area VALUES ('1917','嘉禾县','1911');
INSERT INTO ts_area VALUES ('1918','临武县','1911');
INSERT INTO ts_area VALUES ('1919','汝城县','1911');
INSERT INTO ts_area VALUES ('1920','桂东县','1911');
INSERT INTO ts_area VALUES ('1921','安仁县','1911');
INSERT INTO ts_area VALUES ('1922','资兴市','1911');
INSERT INTO ts_area VALUES ('1923','永州市','1826');
INSERT INTO ts_area VALUES ('1924','零陵区','1923');
INSERT INTO ts_area VALUES ('1925','冷水滩区','1923');
INSERT INTO ts_area VALUES ('1926','祁阳县','1923');
INSERT INTO ts_area VALUES ('1927','东安县','1923');
INSERT INTO ts_area VALUES ('1928','双牌县','1923');
INSERT INTO ts_area VALUES ('1929','道县','1923');
INSERT INTO ts_area VALUES ('1930','江永县','1923');
INSERT INTO ts_area VALUES ('1931','宁远县','1923');
INSERT INTO ts_area VALUES ('1932','蓝山县','1923');
INSERT INTO ts_area VALUES ('1933','新田县','1923');
INSERT INTO ts_area VALUES ('1934','江华瑶族自治县','1923');
INSERT INTO ts_area VALUES ('1935','怀化市','1826');
INSERT INTO ts_area VALUES ('1936','鹤城区','1935');
INSERT INTO ts_area VALUES ('1937','中方县','1935');
INSERT INTO ts_area VALUES ('1938','沅陵县','1935');
INSERT INTO ts_area VALUES ('1939','辰溪县','1935');
INSERT INTO ts_area VALUES ('1940','溆浦县','1935');
INSERT INTO ts_area VALUES ('1941','会同县','1935');
INSERT INTO ts_area VALUES ('1942','麻阳苗族自治县','1935');
INSERT INTO ts_area VALUES ('1943','新晃侗族自治县','1935');
INSERT INTO ts_area VALUES ('1944','芷江侗族自治县','1935');
INSERT INTO ts_area VALUES ('1945','靖州苗族侗族自治县','1935');
INSERT INTO ts_area VALUES ('1946','通道侗族自治县','1935');
INSERT INTO ts_area VALUES ('1947','洪江市','1935');
INSERT INTO ts_area VALUES ('1948','娄底市','1826');
INSERT INTO ts_area VALUES ('1949','娄星区','1948');
INSERT INTO ts_area VALUES ('1950','双峰县','1948');
INSERT INTO ts_area VALUES ('1951','新化县','1948');
INSERT INTO ts_area VALUES ('1952','冷水江市','1948');
INSERT INTO ts_area VALUES ('1953','涟源市','1948');
INSERT INTO ts_area VALUES ('1954','湘西土家族苗族自治州','1826');
INSERT INTO ts_area VALUES ('1955','吉首市','1954');
INSERT INTO ts_area VALUES ('1956','泸溪县','1954');
INSERT INTO ts_area VALUES ('1957','凤凰县','1954');
INSERT INTO ts_area VALUES ('1958','花垣县','1954');
INSERT INTO ts_area VALUES ('1959','保靖县','1954');
INSERT INTO ts_area VALUES ('1960','古丈县','1954');
INSERT INTO ts_area VALUES ('1961','永顺县','1954');
INSERT INTO ts_area VALUES ('1962','龙山县','1954');
INSERT INTO ts_area VALUES ('1963','广东','0');
INSERT INTO ts_area VALUES ('1964','广州市','1963');
INSERT INTO ts_area VALUES ('1965','荔湾区','1964');
INSERT INTO ts_area VALUES ('1966','越秀区','1964');
INSERT INTO ts_area VALUES ('1967','海珠区','1964');
INSERT INTO ts_area VALUES ('1968','天河区','1964');
INSERT INTO ts_area VALUES ('1969','白云区','1964');
INSERT INTO ts_area VALUES ('1970','黄埔区','1964');
INSERT INTO ts_area VALUES ('1971','番禺区','1964');
INSERT INTO ts_area VALUES ('1972','花都区','1964');
INSERT INTO ts_area VALUES ('1973','南沙区','1964');
INSERT INTO ts_area VALUES ('1974','萝岗区','1964');
INSERT INTO ts_area VALUES ('1975','增城市','1964');
INSERT INTO ts_area VALUES ('1976','从化市','1964');
INSERT INTO ts_area VALUES ('1977','韶关市','1963');
INSERT INTO ts_area VALUES ('1978','武江区','1977');
INSERT INTO ts_area VALUES ('1979','浈江区','1977');
INSERT INTO ts_area VALUES ('1980','曲江区','1977');
INSERT INTO ts_area VALUES ('1981','始兴县','1977');
INSERT INTO ts_area VALUES ('1982','仁化县','1977');
INSERT INTO ts_area VALUES ('1983','翁源县','1977');
INSERT INTO ts_area VALUES ('1984','乳源瑶族自治县','1977');
INSERT INTO ts_area VALUES ('1985','新丰县','1977');
INSERT INTO ts_area VALUES ('1986','乐昌市','1977');
INSERT INTO ts_area VALUES ('1987','南雄市','1977');
INSERT INTO ts_area VALUES ('1988','深圳市','1963');
INSERT INTO ts_area VALUES ('1989','罗湖区','1988');
INSERT INTO ts_area VALUES ('1990','福田区','1988');
INSERT INTO ts_area VALUES ('1991','南山区','1988');
INSERT INTO ts_area VALUES ('1992','宝安区','1988');
INSERT INTO ts_area VALUES ('1993','龙岗区','1988');
INSERT INTO ts_area VALUES ('1994','盐田区','1988');
INSERT INTO ts_area VALUES ('1995','珠海市','1963');
INSERT INTO ts_area VALUES ('1996','香洲区','1995');
INSERT INTO ts_area VALUES ('1997','斗门区','1995');
INSERT INTO ts_area VALUES ('1998','金湾区','1995');
INSERT INTO ts_area VALUES ('1999','汕头市','1963');
INSERT INTO ts_area VALUES ('2000','龙湖区','1999');
INSERT INTO ts_area VALUES ('2001','金平区','1999');
INSERT INTO ts_area VALUES ('2002','濠江区','1999');
INSERT INTO ts_area VALUES ('2003','潮阳区','1999');
INSERT INTO ts_area VALUES ('2004','潮南区','1999');
INSERT INTO ts_area VALUES ('2005','澄海区','1999');
INSERT INTO ts_area VALUES ('2006','南澳县','1999');
INSERT INTO ts_area VALUES ('2007','佛山市','1963');
INSERT INTO ts_area VALUES ('2008','禅城区','2007');
INSERT INTO ts_area VALUES ('2009','南海区','2007');
INSERT INTO ts_area VALUES ('2010','顺德区','2007');
INSERT INTO ts_area VALUES ('2011','三水区','2007');
INSERT INTO ts_area VALUES ('2012','高明区','2007');
INSERT INTO ts_area VALUES ('2013','江门市','1963');
INSERT INTO ts_area VALUES ('2014','蓬江区','2013');
INSERT INTO ts_area VALUES ('2015','江海区','2013');
INSERT INTO ts_area VALUES ('2016','新会区','2013');
INSERT INTO ts_area VALUES ('2017','台山市','2013');
INSERT INTO ts_area VALUES ('2018','开平市','2013');
INSERT INTO ts_area VALUES ('2019','鹤山市','2013');
INSERT INTO ts_area VALUES ('2020','恩平市','2013');
INSERT INTO ts_area VALUES ('2021','湛江市','1963');
INSERT INTO ts_area VALUES ('2022','赤坎区','2021');
INSERT INTO ts_area VALUES ('2023','霞山区','2021');
INSERT INTO ts_area VALUES ('2024','坡头区','2021');
INSERT INTO ts_area VALUES ('2025','麻章区','2021');
INSERT INTO ts_area VALUES ('2026','遂溪县','2021');
INSERT INTO ts_area VALUES ('2027','徐闻县','2021');
INSERT INTO ts_area VALUES ('2028','廉江市','2021');
INSERT INTO ts_area VALUES ('2029','雷州市','2021');
INSERT INTO ts_area VALUES ('2030','吴川市','2021');
INSERT INTO ts_area VALUES ('2031','茂名市','1963');
INSERT INTO ts_area VALUES ('2032','茂南区','2031');
INSERT INTO ts_area VALUES ('2033','茂港区','2031');
INSERT INTO ts_area VALUES ('2034','电白县','2031');
INSERT INTO ts_area VALUES ('2035','高州市','2031');
INSERT INTO ts_area VALUES ('2036','化州市','2031');
INSERT INTO ts_area VALUES ('2037','信宜市','2031');
INSERT INTO ts_area VALUES ('2038','肇庆市','1963');
INSERT INTO ts_area VALUES ('2039','端州区','2038');
INSERT INTO ts_area VALUES ('2040','鼎湖区','2038');
INSERT INTO ts_area VALUES ('2041','广宁县','2038');
INSERT INTO ts_area VALUES ('2042','怀集县','2038');
INSERT INTO ts_area VALUES ('2043','封开县','2038');
INSERT INTO ts_area VALUES ('2044','德庆县','2038');
INSERT INTO ts_area VALUES ('2045','高要市','2038');
INSERT INTO ts_area VALUES ('2046','四会市','2038');
INSERT INTO ts_area VALUES ('2047','惠州市','1963');
INSERT INTO ts_area VALUES ('2048','惠城区','2047');
INSERT INTO ts_area VALUES ('2049','惠阳区','2047');
INSERT INTO ts_area VALUES ('2050','博罗县','2047');
INSERT INTO ts_area VALUES ('2051','惠东县','2047');
INSERT INTO ts_area VALUES ('2052','龙门县','2047');
INSERT INTO ts_area VALUES ('2053','梅州市','1963');
INSERT INTO ts_area VALUES ('2054','梅江区','2053');
INSERT INTO ts_area VALUES ('2055','梅县','2053');
INSERT INTO ts_area VALUES ('2056','大埔县','2053');
INSERT INTO ts_area VALUES ('2057','丰顺县','2053');
INSERT INTO ts_area VALUES ('2058','五华县','2053');
INSERT INTO ts_area VALUES ('2059','平远县','2053');
INSERT INTO ts_area VALUES ('2060','蕉岭县','2053');
INSERT INTO ts_area VALUES ('2061','兴宁市','2053');
INSERT INTO ts_area VALUES ('2062','汕尾市','1963');
INSERT INTO ts_area VALUES ('2063','城区','2062');
INSERT INTO ts_area VALUES ('2064','海丰县','2062');
INSERT INTO ts_area VALUES ('2065','陆河县','2062');
INSERT INTO ts_area VALUES ('2066','陆丰市','2062');
INSERT INTO ts_area VALUES ('2067','河源市','1963');
INSERT INTO ts_area VALUES ('2068','源城区','2067');
INSERT INTO ts_area VALUES ('2069','紫金县','2067');
INSERT INTO ts_area VALUES ('2070','龙川县','2067');
INSERT INTO ts_area VALUES ('2071','连平县','2067');
INSERT INTO ts_area VALUES ('2072','和平县','2067');
INSERT INTO ts_area VALUES ('2073','东源县','2067');
INSERT INTO ts_area VALUES ('2074','阳江市','1963');
INSERT INTO ts_area VALUES ('2075','江城区','2074');
INSERT INTO ts_area VALUES ('2076','阳西县','2074');
INSERT INTO ts_area VALUES ('2077','阳东县','2074');
INSERT INTO ts_area VALUES ('2078','阳春市','2074');
INSERT INTO ts_area VALUES ('2079','清远市','1963');
INSERT INTO ts_area VALUES ('2080','清城区','2079');
INSERT INTO ts_area VALUES ('2081','佛冈县','2079');
INSERT INTO ts_area VALUES ('2082','阳山县','2079');
INSERT INTO ts_area VALUES ('2083','连山壮族瑶族自治县','2079');
INSERT INTO ts_area VALUES ('2084','连南瑶族自治县','2079');
INSERT INTO ts_area VALUES ('2085','清新县','2079');
INSERT INTO ts_area VALUES ('2086','英德市','2079');
INSERT INTO ts_area VALUES ('2087','连州市','2079');
INSERT INTO ts_area VALUES ('2088','东莞市','1963');
INSERT INTO ts_area VALUES ('2089','中山市','1963');
INSERT INTO ts_area VALUES ('2090','潮州市','1963');
INSERT INTO ts_area VALUES ('2091','湘桥区','2090');
INSERT INTO ts_area VALUES ('2092','潮安县','2090');
INSERT INTO ts_area VALUES ('2093','饶平县','2090');
INSERT INTO ts_area VALUES ('2094','揭阳市','1963');
INSERT INTO ts_area VALUES ('2095','榕城区','2094');
INSERT INTO ts_area VALUES ('2096','揭东县','2094');
INSERT INTO ts_area VALUES ('2097','揭西县','2094');
INSERT INTO ts_area VALUES ('2098','惠来县','2094');
INSERT INTO ts_area VALUES ('2099','普宁市','2094');
INSERT INTO ts_area VALUES ('2100','云浮市','1963');
INSERT INTO ts_area VALUES ('2101','云城区','2100');
INSERT INTO ts_area VALUES ('2102','新兴县','2100');
INSERT INTO ts_area VALUES ('2103','郁南县','2100');
INSERT INTO ts_area VALUES ('2104','云安县','2100');
INSERT INTO ts_area VALUES ('2105','罗定市','2100');
INSERT INTO ts_area VALUES ('2106','广西','0');
INSERT INTO ts_area VALUES ('2107','南宁市','2106');
INSERT INTO ts_area VALUES ('2108','兴宁区','2107');
INSERT INTO ts_area VALUES ('2109','青秀区','2107');
INSERT INTO ts_area VALUES ('2110','江南区','2107');
INSERT INTO ts_area VALUES ('2111','西乡塘区','2107');
INSERT INTO ts_area VALUES ('2112','良庆区','2107');
INSERT INTO ts_area VALUES ('2113','邕宁区','2107');
INSERT INTO ts_area VALUES ('2114','武鸣县','2107');
INSERT INTO ts_area VALUES ('2115','隆安县','2107');
INSERT INTO ts_area VALUES ('2116','马山县','2107');
INSERT INTO ts_area VALUES ('2117','上林县','2107');
INSERT INTO ts_area VALUES ('2118','宾阳县','2107');
INSERT INTO ts_area VALUES ('2119','横县','2107');
INSERT INTO ts_area VALUES ('2120','柳州市','2106');
INSERT INTO ts_area VALUES ('2121','城中区','2120');
INSERT INTO ts_area VALUES ('2122','鱼峰区','2120');
INSERT INTO ts_area VALUES ('2123','柳南区','2120');
INSERT INTO ts_area VALUES ('2124','柳北区','2120');
INSERT INTO ts_area VALUES ('2125','柳江县','2120');
INSERT INTO ts_area VALUES ('2126','柳城县','2120');
INSERT INTO ts_area VALUES ('2127','鹿寨县','2120');
INSERT INTO ts_area VALUES ('2128','融安县','2120');
INSERT INTO ts_area VALUES ('2129','融水苗族自治县','2120');
INSERT INTO ts_area VALUES ('2130','三江侗族自治县','2120');
INSERT INTO ts_area VALUES ('2131','桂林市','2106');
INSERT INTO ts_area VALUES ('2132','秀峰区','2131');
INSERT INTO ts_area VALUES ('2133','叠彩区','2131');
INSERT INTO ts_area VALUES ('2134','象山区','2131');
INSERT INTO ts_area VALUES ('2135','七星区','2131');
INSERT INTO ts_area VALUES ('2136','雁山区','2131');
INSERT INTO ts_area VALUES ('2137','阳朔县','2131');
INSERT INTO ts_area VALUES ('2138','临桂县','2131');
INSERT INTO ts_area VALUES ('2139','灵川县','2131');
INSERT INTO ts_area VALUES ('2140','全州县','2131');
INSERT INTO ts_area VALUES ('2141','兴安县','2131');
INSERT INTO ts_area VALUES ('2142','永福县','2131');
INSERT INTO ts_area VALUES ('2143','灌阳县','2131');
INSERT INTO ts_area VALUES ('2144','龙胜各族自治县','2131');
INSERT INTO ts_area VALUES ('2145','资源县','2131');
INSERT INTO ts_area VALUES ('2146','平乐县','2131');
INSERT INTO ts_area VALUES ('2147','荔蒲县','2131');
INSERT INTO ts_area VALUES ('2148','恭城瑶族自治县','2131');
INSERT INTO ts_area VALUES ('2149','梧州市','2106');
INSERT INTO ts_area VALUES ('2150','万秀区','2149');
INSERT INTO ts_area VALUES ('2151','蝶山区','2149');
INSERT INTO ts_area VALUES ('2152','长洲区','2149');
INSERT INTO ts_area VALUES ('2153','苍梧县','2149');
INSERT INTO ts_area VALUES ('2154','藤县','2149');
INSERT INTO ts_area VALUES ('2155','蒙山县','2149');
INSERT INTO ts_area VALUES ('2156','岑溪市','2149');
INSERT INTO ts_area VALUES ('2157','北海市','2106');
INSERT INTO ts_area VALUES ('2158','海城区','2157');
INSERT INTO ts_area VALUES ('2159','银海区','2157');
INSERT INTO ts_area VALUES ('2160','铁山港区','2157');
INSERT INTO ts_area VALUES ('2161','合浦县','2157');
INSERT INTO ts_area VALUES ('2162','防城港市','2106');
INSERT INTO ts_area VALUES ('2163','港口区','2162');
INSERT INTO ts_area VALUES ('2164','防城区','2162');
INSERT INTO ts_area VALUES ('2165','上思县','2162');
INSERT INTO ts_area VALUES ('2166','东兴市','2162');
INSERT INTO ts_area VALUES ('2167','钦州市','2106');
INSERT INTO ts_area VALUES ('2168','钦南区','2167');
INSERT INTO ts_area VALUES ('2169','钦北区','2167');
INSERT INTO ts_area VALUES ('2170','灵山县','2167');
INSERT INTO ts_area VALUES ('2171','浦北县','2167');
INSERT INTO ts_area VALUES ('2172','贵港市','2106');
INSERT INTO ts_area VALUES ('2173','港北区','2172');
INSERT INTO ts_area VALUES ('2174','港南区','2172');
INSERT INTO ts_area VALUES ('2175','覃塘区','2172');
INSERT INTO ts_area VALUES ('2176','平南县','2172');
INSERT INTO ts_area VALUES ('2177','桂平市','2172');
INSERT INTO ts_area VALUES ('2178','玉林市','2106');
INSERT INTO ts_area VALUES ('2179','玉州区','2178');
INSERT INTO ts_area VALUES ('2180','容县','2178');
INSERT INTO ts_area VALUES ('2181','陆川县','2178');
INSERT INTO ts_area VALUES ('2182','博白县','2178');
INSERT INTO ts_area VALUES ('2183','兴业县','2178');
INSERT INTO ts_area VALUES ('2184','北流市','2178');
INSERT INTO ts_area VALUES ('2185','百色市','2106');
INSERT INTO ts_area VALUES ('2186','右江区','2185');
INSERT INTO ts_area VALUES ('2187','田阳县','2185');
INSERT INTO ts_area VALUES ('2188','田东县','2185');
INSERT INTO ts_area VALUES ('2189','平果县','2185');
INSERT INTO ts_area VALUES ('2190','德保县','2185');
INSERT INTO ts_area VALUES ('2191','靖西县','2185');
INSERT INTO ts_area VALUES ('2192','那坡县','2185');
INSERT INTO ts_area VALUES ('2193','凌云县','2185');
INSERT INTO ts_area VALUES ('2194','乐业县','2185');
INSERT INTO ts_area VALUES ('2195','田林县','2185');
INSERT INTO ts_area VALUES ('2196','西林县','2185');
INSERT INTO ts_area VALUES ('2197','隆林各族自治县','2185');
INSERT INTO ts_area VALUES ('2198','贺州市','2106');
INSERT INTO ts_area VALUES ('2199','八步区','2198');
INSERT INTO ts_area VALUES ('2200','昭平县','2198');
INSERT INTO ts_area VALUES ('2201','钟山县','2198');
INSERT INTO ts_area VALUES ('2202','富川瑶族自治县','2198');
INSERT INTO ts_area VALUES ('2203','河池市','2106');
INSERT INTO ts_area VALUES ('2204','金城江区','2203');
INSERT INTO ts_area VALUES ('2205','南丹县','2203');
INSERT INTO ts_area VALUES ('2206','天峨县','2203');
INSERT INTO ts_area VALUES ('2207','凤山县','2203');
INSERT INTO ts_area VALUES ('2208','东兰县','2203');
INSERT INTO ts_area VALUES ('2209','罗城仫佬族自治县','2203');
INSERT INTO ts_area VALUES ('2210','环江毛南族自治县','2203');
INSERT INTO ts_area VALUES ('2211','巴马瑶族自治县','2203');
INSERT INTO ts_area VALUES ('2212','都安瑶族自治县','2203');
INSERT INTO ts_area VALUES ('2213','大化瑶族自治县','2203');
INSERT INTO ts_area VALUES ('2214','宜州市','2203');
INSERT INTO ts_area VALUES ('2215','来宾市','2106');
INSERT INTO ts_area VALUES ('2216','兴宾区','2215');
INSERT INTO ts_area VALUES ('2217','忻城县','2215');
INSERT INTO ts_area VALUES ('2218','象州县','2215');
INSERT INTO ts_area VALUES ('2219','武宣县','2215');
INSERT INTO ts_area VALUES ('2220','金秀瑶族自治县','2215');
INSERT INTO ts_area VALUES ('2221','合山市','2215');
INSERT INTO ts_area VALUES ('2222','崇左市','2106');
INSERT INTO ts_area VALUES ('2223','江洲区','2222');
INSERT INTO ts_area VALUES ('2224','扶绥县','2222');
INSERT INTO ts_area VALUES ('2225','宁明县','2222');
INSERT INTO ts_area VALUES ('2226','龙州县','2222');
INSERT INTO ts_area VALUES ('2227','大新县','2222');
INSERT INTO ts_area VALUES ('2228','天等县','2222');
INSERT INTO ts_area VALUES ('2229','凭祥市','2222');
INSERT INTO ts_area VALUES ('2230','海南','0');
INSERT INTO ts_area VALUES ('2231','海口市','2230');
INSERT INTO ts_area VALUES ('2232','秀英区','2231');
INSERT INTO ts_area VALUES ('2233','龙华区','2231');
INSERT INTO ts_area VALUES ('2234','琼山区','2231');
INSERT INTO ts_area VALUES ('2235','美兰区','2231');
INSERT INTO ts_area VALUES ('2236','三亚市','2230');
INSERT INTO ts_area VALUES ('2237','省直辖县级行政单位','2230');
INSERT INTO ts_area VALUES ('2238','五指山市','2237');
INSERT INTO ts_area VALUES ('2239','琼海市','2237');
INSERT INTO ts_area VALUES ('2240','儋州市','2237');
INSERT INTO ts_area VALUES ('2241','文昌市','2237');
INSERT INTO ts_area VALUES ('2242','万宁市','2237');
INSERT INTO ts_area VALUES ('2243','东方市','2237');
INSERT INTO ts_area VALUES ('2244','定安县','2237');
INSERT INTO ts_area VALUES ('2245','屯昌县','2237');
INSERT INTO ts_area VALUES ('2246','澄迈县','2237');
INSERT INTO ts_area VALUES ('2247','临高县','2237');
INSERT INTO ts_area VALUES ('2248','白沙黎族自治县','2237');
INSERT INTO ts_area VALUES ('2249','昌江黎族自治县','2237');
INSERT INTO ts_area VALUES ('2250','乐东黎族自治县','2237');
INSERT INTO ts_area VALUES ('2251','陵水黎族自治县','2237');
INSERT INTO ts_area VALUES ('2252','保亭黎族苗族自治县','2237');
INSERT INTO ts_area VALUES ('2253','琼中黎族苗族自治县','2237');
INSERT INTO ts_area VALUES ('2254','西沙群岛','2237');
INSERT INTO ts_area VALUES ('2255','南沙群岛','2237');
INSERT INTO ts_area VALUES ('2256','中沙群岛的岛礁及其海域','2237');
INSERT INTO ts_area VALUES ('2257','重庆市','0');
INSERT INTO ts_area VALUES ('2258','重庆市','2257');
INSERT INTO ts_area VALUES ('2259','万州区','2258');
INSERT INTO ts_area VALUES ('2260','涪陵区','2258');
INSERT INTO ts_area VALUES ('2261','渝中区','2258');
INSERT INTO ts_area VALUES ('2262','大渡口区','2258');
INSERT INTO ts_area VALUES ('2263','江北区','2258');
INSERT INTO ts_area VALUES ('2264','沙坪坝区','2258');
INSERT INTO ts_area VALUES ('2265','九龙坡区','2258');
INSERT INTO ts_area VALUES ('2266','南岸区','2258');
INSERT INTO ts_area VALUES ('2267','北碚区','2258');
INSERT INTO ts_area VALUES ('2268','万盛区','2258');
INSERT INTO ts_area VALUES ('2269','双桥区','2258');
INSERT INTO ts_area VALUES ('2270','渝北区','2258');
INSERT INTO ts_area VALUES ('2271','巴南区','2258');
INSERT INTO ts_area VALUES ('2272','黔江区','2258');
INSERT INTO ts_area VALUES ('2273','长寿区','2258');
INSERT INTO ts_area VALUES ('2274','江津区','2258');
INSERT INTO ts_area VALUES ('2275','合川区','2258');
INSERT INTO ts_area VALUES ('2276','永川区','2258');
INSERT INTO ts_area VALUES ('2277','南川区','2258');
INSERT INTO ts_area VALUES ('2278','綦江县','2258');
INSERT INTO ts_area VALUES ('2279','潼南县','2258');
INSERT INTO ts_area VALUES ('2280','铜梁县','2258');
INSERT INTO ts_area VALUES ('2281','大足县','2258');
INSERT INTO ts_area VALUES ('2282','荣昌县','2258');
INSERT INTO ts_area VALUES ('2283','璧山县','2258');
INSERT INTO ts_area VALUES ('2284','梁平县','2258');
INSERT INTO ts_area VALUES ('2285','城口县','2258');
INSERT INTO ts_area VALUES ('2286','丰都县','2258');
INSERT INTO ts_area VALUES ('2287','垫江县','2258');
INSERT INTO ts_area VALUES ('2288','武隆县','2258');
INSERT INTO ts_area VALUES ('2289','忠县','2258');
INSERT INTO ts_area VALUES ('2290','开县','2258');
INSERT INTO ts_area VALUES ('2291','云阳县','2258');
INSERT INTO ts_area VALUES ('2292','奉节县','2258');
INSERT INTO ts_area VALUES ('2293','巫山县','2258');
INSERT INTO ts_area VALUES ('2294','巫溪县','2258');
INSERT INTO ts_area VALUES ('2295','石柱土家族自治县','2258');
INSERT INTO ts_area VALUES ('2296','秀山土家族苗族自治县','2258');
INSERT INTO ts_area VALUES ('2297','酉阳土家族苗族自治县','2258');
INSERT INTO ts_area VALUES ('2298','彭水苗族土家族自治县','2258');
INSERT INTO ts_area VALUES ('2299','四川','0');
INSERT INTO ts_area VALUES ('2300','成都市','2299');
INSERT INTO ts_area VALUES ('2301','锦江区','2300');
INSERT INTO ts_area VALUES ('2302','青羊区','2300');
INSERT INTO ts_area VALUES ('2303','金牛区','2300');
INSERT INTO ts_area VALUES ('2304','武侯区','2300');
INSERT INTO ts_area VALUES ('2305','成华区','2300');
INSERT INTO ts_area VALUES ('2306','龙泉驿区','2300');
INSERT INTO ts_area VALUES ('2307','青白江区','2300');
INSERT INTO ts_area VALUES ('2308','新都区','2300');
INSERT INTO ts_area VALUES ('2309','温江区','2300');
INSERT INTO ts_area VALUES ('2310','金堂县','2300');
INSERT INTO ts_area VALUES ('2311','双流县','2300');
INSERT INTO ts_area VALUES ('2312','郫县','2300');
INSERT INTO ts_area VALUES ('2313','大邑县','2300');
INSERT INTO ts_area VALUES ('2314','蒲江县','2300');
INSERT INTO ts_area VALUES ('2315','新津县','2300');
INSERT INTO ts_area VALUES ('2316','都江堰市','2300');
INSERT INTO ts_area VALUES ('2317','彭州市','2300');
INSERT INTO ts_area VALUES ('2318','邛崃市','2300');
INSERT INTO ts_area VALUES ('2319','崇州市','2300');
INSERT INTO ts_area VALUES ('2320','自贡市','2299');
INSERT INTO ts_area VALUES ('2321','自流井区','2320');
INSERT INTO ts_area VALUES ('2322','贡井区','2320');
INSERT INTO ts_area VALUES ('2323','大安区','2320');
INSERT INTO ts_area VALUES ('2324','沿滩区','2320');
INSERT INTO ts_area VALUES ('2325','荣县','2320');
INSERT INTO ts_area VALUES ('2326','富顺县','2320');
INSERT INTO ts_area VALUES ('2327','攀枝花市','2299');
INSERT INTO ts_area VALUES ('2328','东区','2327');
INSERT INTO ts_area VALUES ('2329','西区','2327');
INSERT INTO ts_area VALUES ('2330','仁和区','2327');
INSERT INTO ts_area VALUES ('2331','米易县','2327');
INSERT INTO ts_area VALUES ('2332','盐边县','2327');
INSERT INTO ts_area VALUES ('2333','泸州市','2299');
INSERT INTO ts_area VALUES ('2334','江阳区','2333');
INSERT INTO ts_area VALUES ('2335','纳溪区','2333');
INSERT INTO ts_area VALUES ('2336','龙马潭区','2333');
INSERT INTO ts_area VALUES ('2337','泸县','2333');
INSERT INTO ts_area VALUES ('2338','合江县','2333');
INSERT INTO ts_area VALUES ('2339','叙永县','2333');
INSERT INTO ts_area VALUES ('2340','古蔺县','2333');
INSERT INTO ts_area VALUES ('2341','德阳市','2299');
INSERT INTO ts_area VALUES ('2342','旌阳区','2341');
INSERT INTO ts_area VALUES ('2343','中江县','2341');
INSERT INTO ts_area VALUES ('2344','罗江县','2341');
INSERT INTO ts_area VALUES ('2345','广汉市','2341');
INSERT INTO ts_area VALUES ('2346','什邡市','2341');
INSERT INTO ts_area VALUES ('2347','绵竹市','2341');
INSERT INTO ts_area VALUES ('2348','绵阳市','2299');
INSERT INTO ts_area VALUES ('2349','涪城区','2348');
INSERT INTO ts_area VALUES ('2350','游仙区','2348');
INSERT INTO ts_area VALUES ('2351','三台县','2348');
INSERT INTO ts_area VALUES ('2352','盐亭县','2348');
INSERT INTO ts_area VALUES ('2353','安县','2348');
INSERT INTO ts_area VALUES ('2354','梓潼县','2348');
INSERT INTO ts_area VALUES ('2355','北川羌族自治县','2348');
INSERT INTO ts_area VALUES ('2356','平武县','2348');
INSERT INTO ts_area VALUES ('2357','江油市','2348');
INSERT INTO ts_area VALUES ('2358','广元市','2299');
INSERT INTO ts_area VALUES ('2359','市中区','2358');
INSERT INTO ts_area VALUES ('2360','元坝区','2358');
INSERT INTO ts_area VALUES ('2361','朝天区','2358');
INSERT INTO ts_area VALUES ('2362','旺苍县','2358');
INSERT INTO ts_area VALUES ('2363','青川县','2358');
INSERT INTO ts_area VALUES ('2364','剑阁县','2358');
INSERT INTO ts_area VALUES ('2365','苍溪县','2358');
INSERT INTO ts_area VALUES ('2366','遂宁市','2299');
INSERT INTO ts_area VALUES ('2367','船山区','2366');
INSERT INTO ts_area VALUES ('2368','安居区','2366');
INSERT INTO ts_area VALUES ('2369','蓬溪县','2366');
INSERT INTO ts_area VALUES ('2370','射洪县','2366');
INSERT INTO ts_area VALUES ('2371','大英县','2366');
INSERT INTO ts_area VALUES ('2372','内江市','2299');
INSERT INTO ts_area VALUES ('2373','市中区','2372');
INSERT INTO ts_area VALUES ('2374','东兴区','2372');
INSERT INTO ts_area VALUES ('2375','威远县','2372');
INSERT INTO ts_area VALUES ('2376','资中县','2372');
INSERT INTO ts_area VALUES ('2377','隆昌县','2372');
INSERT INTO ts_area VALUES ('2378','乐山市','2299');
INSERT INTO ts_area VALUES ('2379','市中区','2378');
INSERT INTO ts_area VALUES ('2380','沙湾区','2378');
INSERT INTO ts_area VALUES ('2381','五通桥区','2378');
INSERT INTO ts_area VALUES ('2382','金口河区','2378');
INSERT INTO ts_area VALUES ('2383','犍为县','2378');
INSERT INTO ts_area VALUES ('2384','井研县','2378');
INSERT INTO ts_area VALUES ('2385','夹江县','2378');
INSERT INTO ts_area VALUES ('2386','沐川县','2378');
INSERT INTO ts_area VALUES ('2387','峨边彝族自治县','2378');
INSERT INTO ts_area VALUES ('2388','马边彝族自治县','2378');
INSERT INTO ts_area VALUES ('2389','峨眉山市','2378');
INSERT INTO ts_area VALUES ('2390','南充市','2299');
INSERT INTO ts_area VALUES ('2391','顺庆区','2390');
INSERT INTO ts_area VALUES ('2392','高坪区','2390');
INSERT INTO ts_area VALUES ('2393','嘉陵区','2390');
INSERT INTO ts_area VALUES ('2394','南部县','2390');
INSERT INTO ts_area VALUES ('2395','营山县','2390');
INSERT INTO ts_area VALUES ('2396','蓬安县','2390');
INSERT INTO ts_area VALUES ('2397','仪陇县','2390');
INSERT INTO ts_area VALUES ('2398','西充县','2390');
INSERT INTO ts_area VALUES ('2399','阆中市','2390');
INSERT INTO ts_area VALUES ('2400','眉山市','2299');
INSERT INTO ts_area VALUES ('2401','东坡区','2400');
INSERT INTO ts_area VALUES ('2402','仁寿县','2400');
INSERT INTO ts_area VALUES ('2403','彭山县','2400');
INSERT INTO ts_area VALUES ('2404','洪雅县','2400');
INSERT INTO ts_area VALUES ('2405','丹棱县','2400');
INSERT INTO ts_area VALUES ('2406','青神县','2400');
INSERT INTO ts_area VALUES ('2407','宜宾市','2299');
INSERT INTO ts_area VALUES ('2408','翠屏区','2407');
INSERT INTO ts_area VALUES ('2409','宜宾县','2407');
INSERT INTO ts_area VALUES ('2410','南溪县','2407');
INSERT INTO ts_area VALUES ('2411','江安县','2407');
INSERT INTO ts_area VALUES ('2412','长宁县','2407');
INSERT INTO ts_area VALUES ('2413','高县','2407');
INSERT INTO ts_area VALUES ('2414','珙县','2407');
INSERT INTO ts_area VALUES ('2415','筠连县','2407');
INSERT INTO ts_area VALUES ('2416','兴文县','2407');
INSERT INTO ts_area VALUES ('2417','屏山县','2407');
INSERT INTO ts_area VALUES ('2418','广安市','2299');
INSERT INTO ts_area VALUES ('2419','广安区','2418');
INSERT INTO ts_area VALUES ('2420','岳池县','2418');
INSERT INTO ts_area VALUES ('2421','武胜县','2418');
INSERT INTO ts_area VALUES ('2422','邻水县','2418');
INSERT INTO ts_area VALUES ('2423','华蓥市','2418');
INSERT INTO ts_area VALUES ('2424','达州市','2299');
INSERT INTO ts_area VALUES ('2425','通川区','2424');
INSERT INTO ts_area VALUES ('2426','达县','2424');
INSERT INTO ts_area VALUES ('2427','宣汉县','2424');
INSERT INTO ts_area VALUES ('2428','开江县','2424');
INSERT INTO ts_area VALUES ('2429','大竹县','2424');
INSERT INTO ts_area VALUES ('2430','渠县','2424');
INSERT INTO ts_area VALUES ('2431','万源市','2424');
INSERT INTO ts_area VALUES ('2432','雅安市','2299');
INSERT INTO ts_area VALUES ('2433','雨城区','2432');
INSERT INTO ts_area VALUES ('2434','名山县','2432');
INSERT INTO ts_area VALUES ('2435','荥经县','2432');
INSERT INTO ts_area VALUES ('2436','汉源县','2432');
INSERT INTO ts_area VALUES ('2437','石棉县','2432');
INSERT INTO ts_area VALUES ('2438','天全县','2432');
INSERT INTO ts_area VALUES ('2439','芦山县','2432');
INSERT INTO ts_area VALUES ('2440','宝兴县','2432');
INSERT INTO ts_area VALUES ('2441','巴中市','2299');
INSERT INTO ts_area VALUES ('2442','巴州区','2441');
INSERT INTO ts_area VALUES ('2443','通江县','2441');
INSERT INTO ts_area VALUES ('2444','南江县','2441');
INSERT INTO ts_area VALUES ('2445','平昌县','2441');
INSERT INTO ts_area VALUES ('2446','资阳市','2299');
INSERT INTO ts_area VALUES ('2447','雁江区','2446');
INSERT INTO ts_area VALUES ('2448','安岳县','2446');
INSERT INTO ts_area VALUES ('2449','乐至县','2446');
INSERT INTO ts_area VALUES ('2450','简阳市','2446');
INSERT INTO ts_area VALUES ('2451','阿坝藏族羌族自治州','2299');
INSERT INTO ts_area VALUES ('2452','汶川县','2451');
INSERT INTO ts_area VALUES ('2453','理县','2451');
INSERT INTO ts_area VALUES ('2454','茂县','2451');
INSERT INTO ts_area VALUES ('2455','松潘县','2451');
INSERT INTO ts_area VALUES ('2456','九寨沟县','2451');
INSERT INTO ts_area VALUES ('2457','金川县','2451');
INSERT INTO ts_area VALUES ('2458','小金县','2451');
INSERT INTO ts_area VALUES ('2459','黑水县','2451');
INSERT INTO ts_area VALUES ('2460','马尔康县','2451');
INSERT INTO ts_area VALUES ('2461','壤塘县','2451');
INSERT INTO ts_area VALUES ('2462','阿坝县','2451');
INSERT INTO ts_area VALUES ('2463','若尔盖县','2451');
INSERT INTO ts_area VALUES ('2464','红原县','2451');
INSERT INTO ts_area VALUES ('2465','甘孜藏族自治州','2299');
INSERT INTO ts_area VALUES ('2466','康定县','2465');
INSERT INTO ts_area VALUES ('2467','泸定县','2465');
INSERT INTO ts_area VALUES ('2468','丹巴县','2465');
INSERT INTO ts_area VALUES ('2469','九龙县','2465');
INSERT INTO ts_area VALUES ('2470','雅江县','2465');
INSERT INTO ts_area VALUES ('2471','道孚县','2465');
INSERT INTO ts_area VALUES ('2472','炉霍县','2465');
INSERT INTO ts_area VALUES ('2473','甘孜县','2465');
INSERT INTO ts_area VALUES ('2474','新龙县','2465');
INSERT INTO ts_area VALUES ('2475','德格县','2465');
INSERT INTO ts_area VALUES ('2476','白玉县','2465');
INSERT INTO ts_area VALUES ('2477','石渠县','2465');
INSERT INTO ts_area VALUES ('2478','色达县','2465');
INSERT INTO ts_area VALUES ('2479','理塘县','2465');
INSERT INTO ts_area VALUES ('2480','巴塘县','2465');
INSERT INTO ts_area VALUES ('2481','乡城县','2465');
INSERT INTO ts_area VALUES ('2482','稻城县','2465');
INSERT INTO ts_area VALUES ('2483','得荣县','2465');
INSERT INTO ts_area VALUES ('2484','凉山彝族自治州','2299');
INSERT INTO ts_area VALUES ('2485','西昌市','2484');
INSERT INTO ts_area VALUES ('2486','木里藏族自治县','2484');
INSERT INTO ts_area VALUES ('2487','盐源县','2484');
INSERT INTO ts_area VALUES ('2488','德昌县','2484');
INSERT INTO ts_area VALUES ('2489','会理县','2484');
INSERT INTO ts_area VALUES ('2490','会东县','2484');
INSERT INTO ts_area VALUES ('2491','宁南县','2484');
INSERT INTO ts_area VALUES ('2492','普格县','2484');
INSERT INTO ts_area VALUES ('2493','布拖县','2484');
INSERT INTO ts_area VALUES ('2494','金阳县','2484');
INSERT INTO ts_area VALUES ('2495','昭觉县','2484');
INSERT INTO ts_area VALUES ('2496','喜德县','2484');
INSERT INTO ts_area VALUES ('2497','冕宁县','2484');
INSERT INTO ts_area VALUES ('2498','越西县','2484');
INSERT INTO ts_area VALUES ('2499','甘洛县','2484');
INSERT INTO ts_area VALUES ('2500','美姑县','2484');
INSERT INTO ts_area VALUES ('2501','雷波县','2484');
INSERT INTO ts_area VALUES ('2502','贵州','0');
INSERT INTO ts_area VALUES ('2503','贵阳市','2502');
INSERT INTO ts_area VALUES ('2504','南明区','2503');
INSERT INTO ts_area VALUES ('2505','云岩区','2503');
INSERT INTO ts_area VALUES ('2506','花溪区','2503');
INSERT INTO ts_area VALUES ('2507','乌当区','2503');
INSERT INTO ts_area VALUES ('2508','白云区','2503');
INSERT INTO ts_area VALUES ('2509','小河区','2503');
INSERT INTO ts_area VALUES ('2510','开阳县','2503');
INSERT INTO ts_area VALUES ('2511','息烽县','2503');
INSERT INTO ts_area VALUES ('2512','修文县','2503');
INSERT INTO ts_area VALUES ('2513','清镇市','2503');
INSERT INTO ts_area VALUES ('2514','六盘水市','2502');
INSERT INTO ts_area VALUES ('2515','钟山区','2514');
INSERT INTO ts_area VALUES ('2516','六枝特区','2514');
INSERT INTO ts_area VALUES ('2517','水城县','2514');
INSERT INTO ts_area VALUES ('2518','盘县','2514');
INSERT INTO ts_area VALUES ('2519','遵义市','2502');
INSERT INTO ts_area VALUES ('2520','红花岗区','2519');
INSERT INTO ts_area VALUES ('2521','汇川区','2519');
INSERT INTO ts_area VALUES ('2522','遵义县','2519');
INSERT INTO ts_area VALUES ('2523','桐梓县','2519');
INSERT INTO ts_area VALUES ('2524','绥阳县','2519');
INSERT INTO ts_area VALUES ('2525','正安县','2519');
INSERT INTO ts_area VALUES ('2526','道真仡佬族苗族自治县','2519');
INSERT INTO ts_area VALUES ('2527','务川仡佬族苗族自治县','2519');
INSERT INTO ts_area VALUES ('2528','凤冈县','2519');
INSERT INTO ts_area VALUES ('2529','湄潭县','2519');
INSERT INTO ts_area VALUES ('2530','余庆县','2519');
INSERT INTO ts_area VALUES ('2531','习水县','2519');
INSERT INTO ts_area VALUES ('2532','赤水市','2519');
INSERT INTO ts_area VALUES ('2533','仁怀市','2519');
INSERT INTO ts_area VALUES ('2534','安顺市','2502');
INSERT INTO ts_area VALUES ('2535','西秀区','2534');
INSERT INTO ts_area VALUES ('2536','平坝县','2534');
INSERT INTO ts_area VALUES ('2537','普定县','2534');
INSERT INTO ts_area VALUES ('2538','镇宁布依族苗族自治县','2534');
INSERT INTO ts_area VALUES ('2539','关岭布依族苗族自治县','2534');
INSERT INTO ts_area VALUES ('2540','紫云苗族布依族自治县','2534');
INSERT INTO ts_area VALUES ('2541','铜仁地区','2502');
INSERT INTO ts_area VALUES ('2542','铜仁市','2541');
INSERT INTO ts_area VALUES ('2543','江口县','2541');
INSERT INTO ts_area VALUES ('2544','玉屏侗族自治县','2541');
INSERT INTO ts_area VALUES ('2545','石阡县','2541');
INSERT INTO ts_area VALUES ('2546','思南县','2541');
INSERT INTO ts_area VALUES ('2547','印江土家族苗族自治县','2541');
INSERT INTO ts_area VALUES ('2548','德江县','2541');
INSERT INTO ts_area VALUES ('2549','沿河土家族自治县','2541');
INSERT INTO ts_area VALUES ('2550','松桃苗族自治县','2541');
INSERT INTO ts_area VALUES ('2551','万山特区','2541');
INSERT INTO ts_area VALUES ('2552','黔西南布依族苗族自治州','2502');
INSERT INTO ts_area VALUES ('2553','兴义市','2552');
INSERT INTO ts_area VALUES ('2554','兴仁县','2552');
INSERT INTO ts_area VALUES ('2555','普安县','2552');
INSERT INTO ts_area VALUES ('2556','晴隆县','2552');
INSERT INTO ts_area VALUES ('2557','贞丰县','2552');
INSERT INTO ts_area VALUES ('2558','望谟县','2552');
INSERT INTO ts_area VALUES ('2559','册亨县','2552');
INSERT INTO ts_area VALUES ('2560','安龙县','2552');
INSERT INTO ts_area VALUES ('2561','毕节地区','2502');
INSERT INTO ts_area VALUES ('2562','毕节市','2561');
INSERT INTO ts_area VALUES ('2563','大方县','2561');
INSERT INTO ts_area VALUES ('2564','黔西县','2561');
INSERT INTO ts_area VALUES ('2565','金沙县','2561');
INSERT INTO ts_area VALUES ('2566','织金县','2561');
INSERT INTO ts_area VALUES ('2567','纳雍县','2561');
INSERT INTO ts_area VALUES ('2568','威宁彝族回族苗族自治县','2561');
INSERT INTO ts_area VALUES ('2569','赫章县','2561');
INSERT INTO ts_area VALUES ('2570','黔东南苗族侗族自治州','2502');
INSERT INTO ts_area VALUES ('2571','凯里市','2570');
INSERT INTO ts_area VALUES ('2572','黄平县','2570');
INSERT INTO ts_area VALUES ('2573','施秉县','2570');
INSERT INTO ts_area VALUES ('2574','三穗县','2570');
INSERT INTO ts_area VALUES ('2575','镇远县','2570');
INSERT INTO ts_area VALUES ('2576','岑巩县','2570');
INSERT INTO ts_area VALUES ('2577','天柱县','2570');
INSERT INTO ts_area VALUES ('2578','锦屏县','2570');
INSERT INTO ts_area VALUES ('2579','剑河县','2570');
INSERT INTO ts_area VALUES ('2580','台江县','2570');
INSERT INTO ts_area VALUES ('2581','黎平县','2570');
INSERT INTO ts_area VALUES ('2582','榕江县','2570');
INSERT INTO ts_area VALUES ('2583','从江县','2570');
INSERT INTO ts_area VALUES ('2584','雷山县','2570');
INSERT INTO ts_area VALUES ('2585','麻江县','2570');
INSERT INTO ts_area VALUES ('2586','丹寨县','2570');
INSERT INTO ts_area VALUES ('2587','黔南布依族苗族自治州','2502');
INSERT INTO ts_area VALUES ('2588','都匀市','2587');
INSERT INTO ts_area VALUES ('2589','福泉市','2587');
INSERT INTO ts_area VALUES ('2590','荔波县','2587');
INSERT INTO ts_area VALUES ('2591','贵定县','2587');
INSERT INTO ts_area VALUES ('2592','瓮安县','2587');
INSERT INTO ts_area VALUES ('2593','独山县','2587');
INSERT INTO ts_area VALUES ('2594','平塘县','2587');
INSERT INTO ts_area VALUES ('2595','罗甸县','2587');
INSERT INTO ts_area VALUES ('2596','长顺县','2587');
INSERT INTO ts_area VALUES ('2597','龙里县','2587');
INSERT INTO ts_area VALUES ('2598','惠水县','2587');
INSERT INTO ts_area VALUES ('2599','三都水族自治县','2587');
INSERT INTO ts_area VALUES ('2600','云南','0');
INSERT INTO ts_area VALUES ('2601','昆明市','2600');
INSERT INTO ts_area VALUES ('2602','五华区','2601');
INSERT INTO ts_area VALUES ('2603','盘龙区','2601');
INSERT INTO ts_area VALUES ('2604','官渡区','2601');
INSERT INTO ts_area VALUES ('2605','西山区','2601');
INSERT INTO ts_area VALUES ('2606','东川区','2601');
INSERT INTO ts_area VALUES ('2607','呈贡县','2601');
INSERT INTO ts_area VALUES ('2608','晋宁县','2601');
INSERT INTO ts_area VALUES ('2609','富民县','2601');
INSERT INTO ts_area VALUES ('2610','宜良县','2601');
INSERT INTO ts_area VALUES ('2611','石林彝族自治县','2601');
INSERT INTO ts_area VALUES ('2612','嵩明县','2601');
INSERT INTO ts_area VALUES ('2613','禄劝彝族苗族自治县','2601');
INSERT INTO ts_area VALUES ('2614','寻甸回族彝族自治县','2601');
INSERT INTO ts_area VALUES ('2615','安宁市','2601');
INSERT INTO ts_area VALUES ('2616','曲靖市','2600');
INSERT INTO ts_area VALUES ('2617','麒麟区','2616');
INSERT INTO ts_area VALUES ('2618','马龙县','2616');
INSERT INTO ts_area VALUES ('2619','陆良县','2616');
INSERT INTO ts_area VALUES ('2620','师宗县','2616');
INSERT INTO ts_area VALUES ('2621','罗平县','2616');
INSERT INTO ts_area VALUES ('2622','富源县','2616');
INSERT INTO ts_area VALUES ('2623','会泽县','2616');
INSERT INTO ts_area VALUES ('2624','沾益县','2616');
INSERT INTO ts_area VALUES ('2625','宣威市','2616');
INSERT INTO ts_area VALUES ('2626','玉溪市','2600');
INSERT INTO ts_area VALUES ('2627','红塔区','2626');
INSERT INTO ts_area VALUES ('2628','江川县','2626');
INSERT INTO ts_area VALUES ('2629','澄江县','2626');
INSERT INTO ts_area VALUES ('2630','通海县','2626');
INSERT INTO ts_area VALUES ('2631','华宁县','2626');
INSERT INTO ts_area VALUES ('2632','易门县','2626');
INSERT INTO ts_area VALUES ('2633','峨山彝族自治县','2626');
INSERT INTO ts_area VALUES ('2634','新平彝族傣族自治县','2626');
INSERT INTO ts_area VALUES ('2635','元江哈尼族彝族傣族自治县','2626');
INSERT INTO ts_area VALUES ('2636','保山市','2600');
INSERT INTO ts_area VALUES ('2637','隆阳区','2636');
INSERT INTO ts_area VALUES ('2638','施甸县','2636');
INSERT INTO ts_area VALUES ('2639','腾冲县','2636');
INSERT INTO ts_area VALUES ('2640','龙陵县','2636');
INSERT INTO ts_area VALUES ('2641','昌宁县','2636');
INSERT INTO ts_area VALUES ('2642','昭通市','2600');
INSERT INTO ts_area VALUES ('2643','昭阳区','2642');
INSERT INTO ts_area VALUES ('2644','鲁甸县','2642');
INSERT INTO ts_area VALUES ('2645','巧家县','2642');
INSERT INTO ts_area VALUES ('2646','盐津县','2642');
INSERT INTO ts_area VALUES ('2647','大关县','2642');
INSERT INTO ts_area VALUES ('2648','永善县','2642');
INSERT INTO ts_area VALUES ('2649','绥江县','2642');
INSERT INTO ts_area VALUES ('2650','镇雄县','2642');
INSERT INTO ts_area VALUES ('2651','彝良县','2642');
INSERT INTO ts_area VALUES ('2652','威信县','2642');
INSERT INTO ts_area VALUES ('2653','水富县','2642');
INSERT INTO ts_area VALUES ('2654','丽江市','2600');
INSERT INTO ts_area VALUES ('2655','古城区','2654');
INSERT INTO ts_area VALUES ('2656','玉龙纳西族自治县','2654');
INSERT INTO ts_area VALUES ('2657','永胜县','2654');
INSERT INTO ts_area VALUES ('2658','华坪县','2654');
INSERT INTO ts_area VALUES ('2659','宁蒗彝族自治县','2654');
INSERT INTO ts_area VALUES ('2660','普洱市','2600');
INSERT INTO ts_area VALUES ('2661','思茅区','2660');
INSERT INTO ts_area VALUES ('2662','宁洱哈尼族彝族自治县','2660');
INSERT INTO ts_area VALUES ('2663','墨江哈尼族自治县','2660');
INSERT INTO ts_area VALUES ('2664','景东彝族自治县','2660');
INSERT INTO ts_area VALUES ('2665','景谷傣族彝族自治县','2660');
INSERT INTO ts_area VALUES ('2666','镇沅彝族哈尼族拉祜族自治县','2660');
INSERT INTO ts_area VALUES ('2667','江城哈尼族彝族自治县','2660');
INSERT INTO ts_area VALUES ('2668','孟连傣族拉祜族佤族自治县','2660');
INSERT INTO ts_area VALUES ('2669','澜沧拉祜族自治县','2660');
INSERT INTO ts_area VALUES ('2670','西盟佤族自治县','2660');
INSERT INTO ts_area VALUES ('2671','临沧市','2600');
INSERT INTO ts_area VALUES ('2672','临翔区','2671');
INSERT INTO ts_area VALUES ('2673','凤庆县','2671');
INSERT INTO ts_area VALUES ('2674','云县','2671');
INSERT INTO ts_area VALUES ('2675','永德县','2671');
INSERT INTO ts_area VALUES ('2676','镇康县','2671');
INSERT INTO ts_area VALUES ('2677','双江拉祜族佤族布朗族傣族自治县','2671');
INSERT INTO ts_area VALUES ('2678','耿马傣族佤族自治县','2671');
INSERT INTO ts_area VALUES ('2679','沧源佤族自治县','2671');
INSERT INTO ts_area VALUES ('2680','楚雄彝族自治州','2600');
INSERT INTO ts_area VALUES ('2681','楚雄市','2680');
INSERT INTO ts_area VALUES ('2682','双柏县','2680');
INSERT INTO ts_area VALUES ('2683','牟定县','2680');
INSERT INTO ts_area VALUES ('2684','南华县','2680');
INSERT INTO ts_area VALUES ('2685','姚安县','2680');
INSERT INTO ts_area VALUES ('2686','大姚县','2680');
INSERT INTO ts_area VALUES ('2687','永仁县','2680');
INSERT INTO ts_area VALUES ('2688','元谋县','2680');
INSERT INTO ts_area VALUES ('2689','武定县','2680');
INSERT INTO ts_area VALUES ('2690','禄丰县','2680');
INSERT INTO ts_area VALUES ('2691','红河哈尼族彝族自治州','2600');
INSERT INTO ts_area VALUES ('2692','个旧市','2691');
INSERT INTO ts_area VALUES ('2693','开远市','2691');
INSERT INTO ts_area VALUES ('2694','蒙自县','2691');
INSERT INTO ts_area VALUES ('2695','屏边苗族自治县','2691');
INSERT INTO ts_area VALUES ('2696','建水县','2691');
INSERT INTO ts_area VALUES ('2697','石屏县','2691');
INSERT INTO ts_area VALUES ('2698','弥勒县','2691');
INSERT INTO ts_area VALUES ('2699','泸西县','2691');
INSERT INTO ts_area VALUES ('2700','元阳县','2691');
INSERT INTO ts_area VALUES ('2701','红河县','2691');
INSERT INTO ts_area VALUES ('2702','金平苗族瑶族傣族自治县','2691');
INSERT INTO ts_area VALUES ('2703','绿春县','2691');
INSERT INTO ts_area VALUES ('2704','河口瑶族自治县','2691');
INSERT INTO ts_area VALUES ('2705','文山壮族苗族自治州','2600');
INSERT INTO ts_area VALUES ('2706','文山县','2705');
INSERT INTO ts_area VALUES ('2707','砚山县','2705');
INSERT INTO ts_area VALUES ('2708','西畴县','2705');
INSERT INTO ts_area VALUES ('2709','麻栗坡县','2705');
INSERT INTO ts_area VALUES ('2710','马关县','2705');
INSERT INTO ts_area VALUES ('2711','丘北县','2705');
INSERT INTO ts_area VALUES ('2712','广南县','2705');
INSERT INTO ts_area VALUES ('2713','富宁县','2705');
INSERT INTO ts_area VALUES ('2714','西双版纳傣族自治州','2600');
INSERT INTO ts_area VALUES ('2715','景洪市','2714');
INSERT INTO ts_area VALUES ('2716','勐海县','2714');
INSERT INTO ts_area VALUES ('2717','勐腊县','2714');
INSERT INTO ts_area VALUES ('2718','大理白族自治州','2600');
INSERT INTO ts_area VALUES ('2719','大理市','2718');
INSERT INTO ts_area VALUES ('2720','漾濞彝族自治县','2718');
INSERT INTO ts_area VALUES ('2721','祥云县','2718');
INSERT INTO ts_area VALUES ('2722','宾川县','2718');
INSERT INTO ts_area VALUES ('2723','弥渡县','2718');
INSERT INTO ts_area VALUES ('2724','南涧彝族自治县','2718');
INSERT INTO ts_area VALUES ('2725','巍山彝族回族自治县','2718');
INSERT INTO ts_area VALUES ('2726','永平县','2718');
INSERT INTO ts_area VALUES ('2727','云龙县','2718');
INSERT INTO ts_area VALUES ('2728','洱源县','2718');
INSERT INTO ts_area VALUES ('2729','剑川县','2718');
INSERT INTO ts_area VALUES ('2730','鹤庆县','2718');
INSERT INTO ts_area VALUES ('2731','德宏傣族景颇族自治州','2600');
INSERT INTO ts_area VALUES ('2732','瑞丽市','2731');
INSERT INTO ts_area VALUES ('2733','潞西市','2731');
INSERT INTO ts_area VALUES ('2734','梁河县','2731');
INSERT INTO ts_area VALUES ('2735','盈江县','2731');
INSERT INTO ts_area VALUES ('2736','陇川县','2731');
INSERT INTO ts_area VALUES ('2737','怒江傈僳族自治州','2600');
INSERT INTO ts_area VALUES ('2738','泸水县','2737');
INSERT INTO ts_area VALUES ('2739','福贡县','2737');
INSERT INTO ts_area VALUES ('2740','贡山独龙族怒族自治县','2737');
INSERT INTO ts_area VALUES ('2741','兰坪白族普米族自治县','2737');
INSERT INTO ts_area VALUES ('2742','迪庆藏族自治州','2600');
INSERT INTO ts_area VALUES ('2743','香格里拉县','2742');
INSERT INTO ts_area VALUES ('2744','德钦县','2742');
INSERT INTO ts_area VALUES ('2745','维西傈僳族自治县','2742');
INSERT INTO ts_area VALUES ('2746','西藏','0');
INSERT INTO ts_area VALUES ('2747','拉萨市','2746');
INSERT INTO ts_area VALUES ('2748','城关区','2747');
INSERT INTO ts_area VALUES ('2749','林周县','2747');
INSERT INTO ts_area VALUES ('2750','当雄县','2747');
INSERT INTO ts_area VALUES ('2751','尼木县','2747');
INSERT INTO ts_area VALUES ('2752','曲水县','2747');
INSERT INTO ts_area VALUES ('2753','堆龙德庆县','2747');
INSERT INTO ts_area VALUES ('2754','达孜县','2747');
INSERT INTO ts_area VALUES ('2755','墨竹工卡县','2747');
INSERT INTO ts_area VALUES ('2756','昌都地区','2746');
INSERT INTO ts_area VALUES ('2757','昌都县','2756');
INSERT INTO ts_area VALUES ('2758','江达县','2756');
INSERT INTO ts_area VALUES ('2759','贡觉县','2756');
INSERT INTO ts_area VALUES ('2760','类乌齐县','2756');
INSERT INTO ts_area VALUES ('2761','丁青县','2756');
INSERT INTO ts_area VALUES ('2762','察雅县','2756');
INSERT INTO ts_area VALUES ('2763','八宿县','2756');
INSERT INTO ts_area VALUES ('2764','左贡县','2756');
INSERT INTO ts_area VALUES ('2765','芒康县','2756');
INSERT INTO ts_area VALUES ('2766','洛隆县','2756');
INSERT INTO ts_area VALUES ('2767','边坝县','2756');
INSERT INTO ts_area VALUES ('2768','山南地区','2746');
INSERT INTO ts_area VALUES ('2769','乃东县','2768');
INSERT INTO ts_area VALUES ('2770','扎囊县','2768');
INSERT INTO ts_area VALUES ('2771','贡嘎县','2768');
INSERT INTO ts_area VALUES ('2772','桑日县','2768');
INSERT INTO ts_area VALUES ('2773','琼结县','2768');
INSERT INTO ts_area VALUES ('2774','曲松县','2768');
INSERT INTO ts_area VALUES ('2775','措美县','2768');
INSERT INTO ts_area VALUES ('2776','洛扎县','2768');
INSERT INTO ts_area VALUES ('2777','加查县','2768');
INSERT INTO ts_area VALUES ('2778','隆子县','2768');
INSERT INTO ts_area VALUES ('2779','错那县','2768');
INSERT INTO ts_area VALUES ('2780','浪卡子县','2768');
INSERT INTO ts_area VALUES ('2781','日喀则地区','2746');
INSERT INTO ts_area VALUES ('2782','日喀则市','2781');
INSERT INTO ts_area VALUES ('2783','南木林县','2781');
INSERT INTO ts_area VALUES ('2784','江孜县','2781');
INSERT INTO ts_area VALUES ('2785','定日县','2781');
INSERT INTO ts_area VALUES ('2786','萨迦县','2781');
INSERT INTO ts_area VALUES ('2787','拉孜县','2781');
INSERT INTO ts_area VALUES ('2788','昂仁县','2781');
INSERT INTO ts_area VALUES ('2789','谢通门县','2781');
INSERT INTO ts_area VALUES ('2790','白朗县','2781');
INSERT INTO ts_area VALUES ('2791','仁布县','2781');
INSERT INTO ts_area VALUES ('2792','康马县','2781');
INSERT INTO ts_area VALUES ('2793','定结县','2781');
INSERT INTO ts_area VALUES ('2794','仲巴县','2781');
INSERT INTO ts_area VALUES ('2795','亚东县','2781');
INSERT INTO ts_area VALUES ('2796','吉隆县','2781');
INSERT INTO ts_area VALUES ('2797','聂拉木县','2781');
INSERT INTO ts_area VALUES ('2798','萨嘎县','2781');
INSERT INTO ts_area VALUES ('2799','岗巴县','2781');
INSERT INTO ts_area VALUES ('2800','那曲地区','2746');
INSERT INTO ts_area VALUES ('2801','那曲县','2800');
INSERT INTO ts_area VALUES ('2802','嘉黎县','2800');
INSERT INTO ts_area VALUES ('2803','比如县','2800');
INSERT INTO ts_area VALUES ('2804','聂荣县','2800');
INSERT INTO ts_area VALUES ('2805','安多县','2800');
INSERT INTO ts_area VALUES ('2806','申扎县','2800');
INSERT INTO ts_area VALUES ('2807','索县','2800');
INSERT INTO ts_area VALUES ('2808','班戈县','2800');
INSERT INTO ts_area VALUES ('2809','巴青县','2800');
INSERT INTO ts_area VALUES ('2810','尼玛县','2800');
INSERT INTO ts_area VALUES ('2811','阿里地区','2746');
INSERT INTO ts_area VALUES ('2812','普兰县','2811');
INSERT INTO ts_area VALUES ('2813','札达县','2811');
INSERT INTO ts_area VALUES ('2814','噶尔县','2811');
INSERT INTO ts_area VALUES ('2815','日土县','2811');
INSERT INTO ts_area VALUES ('2816','革吉县','2811');
INSERT INTO ts_area VALUES ('2817','改则县','2811');
INSERT INTO ts_area VALUES ('2818','措勤县','2811');
INSERT INTO ts_area VALUES ('2819','林芝地区','2746');
INSERT INTO ts_area VALUES ('2820','林芝县','2819');
INSERT INTO ts_area VALUES ('2821','工布江达县','2819');
INSERT INTO ts_area VALUES ('2822','米林县','2819');
INSERT INTO ts_area VALUES ('2823','墨脱县','2819');
INSERT INTO ts_area VALUES ('2824','波密县','2819');
INSERT INTO ts_area VALUES ('2825','察隅县','2819');
INSERT INTO ts_area VALUES ('2826','朗县','2819');
INSERT INTO ts_area VALUES ('2827','陕西','0');
INSERT INTO ts_area VALUES ('2828','西安市','2827');
INSERT INTO ts_area VALUES ('2829','新城区','2828');
INSERT INTO ts_area VALUES ('2830','碑林区','2828');
INSERT INTO ts_area VALUES ('2831','莲湖区','2828');
INSERT INTO ts_area VALUES ('2832','灞桥区','2828');
INSERT INTO ts_area VALUES ('2833','未央区','2828');
INSERT INTO ts_area VALUES ('2834','雁塔区','2828');
INSERT INTO ts_area VALUES ('2835','阎良区','2828');
INSERT INTO ts_area VALUES ('2836','临潼区','2828');
INSERT INTO ts_area VALUES ('2837','长安区','2828');
INSERT INTO ts_area VALUES ('2838','蓝田县','2828');
INSERT INTO ts_area VALUES ('2839','周至县','2828');
INSERT INTO ts_area VALUES ('2840','户县','2828');
INSERT INTO ts_area VALUES ('2841','高陵县','2828');
INSERT INTO ts_area VALUES ('2842','铜川市','2827');
INSERT INTO ts_area VALUES ('2843','王益区','2842');
INSERT INTO ts_area VALUES ('2844','印台区','2842');
INSERT INTO ts_area VALUES ('2845','耀州区','2842');
INSERT INTO ts_area VALUES ('2846','宜君县','2842');
INSERT INTO ts_area VALUES ('2847','宝鸡市','2827');
INSERT INTO ts_area VALUES ('2848','渭滨区','2847');
INSERT INTO ts_area VALUES ('2849','金台区','2847');
INSERT INTO ts_area VALUES ('2850','陈仓区','2847');
INSERT INTO ts_area VALUES ('2851','凤翔县','2847');
INSERT INTO ts_area VALUES ('2852','岐山县','2847');
INSERT INTO ts_area VALUES ('2853','扶风县','2847');
INSERT INTO ts_area VALUES ('2854','眉县','2847');
INSERT INTO ts_area VALUES ('2855','陇县','2847');
INSERT INTO ts_area VALUES ('2856','千阳县','2847');
INSERT INTO ts_area VALUES ('2857','麟游县','2847');
INSERT INTO ts_area VALUES ('2858','凤县','2847');
INSERT INTO ts_area VALUES ('2859','太白县','2847');
INSERT INTO ts_area VALUES ('2860','咸阳市','2827');
INSERT INTO ts_area VALUES ('2861','秦都区','2860');
INSERT INTO ts_area VALUES ('2862','杨凌区','2860');
INSERT INTO ts_area VALUES ('2863','渭城区','2860');
INSERT INTO ts_area VALUES ('2864','三原县','2860');
INSERT INTO ts_area VALUES ('2865','泾阳县','2860');
INSERT INTO ts_area VALUES ('2866','乾县','2860');
INSERT INTO ts_area VALUES ('2867','礼泉县','2860');
INSERT INTO ts_area VALUES ('2868','永寿县','2860');
INSERT INTO ts_area VALUES ('2869','彬县','2860');
INSERT INTO ts_area VALUES ('2870','长武县','2860');
INSERT INTO ts_area VALUES ('2871','旬邑县','2860');
INSERT INTO ts_area VALUES ('2872','淳化县','2860');
INSERT INTO ts_area VALUES ('2873','武功县','2860');
INSERT INTO ts_area VALUES ('2874','兴平市','2860');
INSERT INTO ts_area VALUES ('2875','渭南市','2827');
INSERT INTO ts_area VALUES ('2876','临渭区','2875');
INSERT INTO ts_area VALUES ('2877','华县','2875');
INSERT INTO ts_area VALUES ('2878','潼关县','2875');
INSERT INTO ts_area VALUES ('2879','大荔县','2875');
INSERT INTO ts_area VALUES ('2880','合阳县','2875');
INSERT INTO ts_area VALUES ('2881','澄城县','2875');
INSERT INTO ts_area VALUES ('2882','蒲城县','2875');
INSERT INTO ts_area VALUES ('2883','白水县','2875');
INSERT INTO ts_area VALUES ('2884','富平县','2875');
INSERT INTO ts_area VALUES ('2885','韩城市','2875');
INSERT INTO ts_area VALUES ('2886','华阴市','2875');
INSERT INTO ts_area VALUES ('2887','延安市','2827');
INSERT INTO ts_area VALUES ('2888','宝塔区','2887');
INSERT INTO ts_area VALUES ('2889','延长县','2887');
INSERT INTO ts_area VALUES ('2890','延川县','2887');
INSERT INTO ts_area VALUES ('2891','子长县','2887');
INSERT INTO ts_area VALUES ('2892','安塞县','2887');
INSERT INTO ts_area VALUES ('2893','志丹县','2887');
INSERT INTO ts_area VALUES ('2894','吴起县','2887');
INSERT INTO ts_area VALUES ('2895','甘泉县','2887');
INSERT INTO ts_area VALUES ('2896','富县','2887');
INSERT INTO ts_area VALUES ('2897','洛川县','2887');
INSERT INTO ts_area VALUES ('2898','宜川县','2887');
INSERT INTO ts_area VALUES ('2899','黄龙县','2887');
INSERT INTO ts_area VALUES ('2900','黄陵县','2887');
INSERT INTO ts_area VALUES ('2901','汉中市','2827');
INSERT INTO ts_area VALUES ('2902','汉台区','2901');
INSERT INTO ts_area VALUES ('2903','南郑县','2901');
INSERT INTO ts_area VALUES ('2904','城固县','2901');
INSERT INTO ts_area VALUES ('2905','洋县','2901');
INSERT INTO ts_area VALUES ('2906','西乡县','2901');
INSERT INTO ts_area VALUES ('2907','勉县','2901');
INSERT INTO ts_area VALUES ('2908','宁强县','2901');
INSERT INTO ts_area VALUES ('2909','略阳县','2901');
INSERT INTO ts_area VALUES ('2910','镇巴县','2901');
INSERT INTO ts_area VALUES ('2911','留坝县','2901');
INSERT INTO ts_area VALUES ('2912','佛坪县','2901');
INSERT INTO ts_area VALUES ('2913','榆林市','2827');
INSERT INTO ts_area VALUES ('2914','榆阳区','2913');
INSERT INTO ts_area VALUES ('2915','神木县','2913');
INSERT INTO ts_area VALUES ('2916','府谷县','2913');
INSERT INTO ts_area VALUES ('2917','横山县','2913');
INSERT INTO ts_area VALUES ('2918','靖边县','2913');
INSERT INTO ts_area VALUES ('2919','定边县','2913');
INSERT INTO ts_area VALUES ('2920','绥德县','2913');
INSERT INTO ts_area VALUES ('2921','米脂县','2913');
INSERT INTO ts_area VALUES ('2922','佳县','2913');
INSERT INTO ts_area VALUES ('2923','吴堡县','2913');
INSERT INTO ts_area VALUES ('2924','清涧县','2913');
INSERT INTO ts_area VALUES ('2925','子洲县','2913');
INSERT INTO ts_area VALUES ('2926','安康市','2827');
INSERT INTO ts_area VALUES ('2927','汉滨区','2926');
INSERT INTO ts_area VALUES ('2928','汉阴县','2926');
INSERT INTO ts_area VALUES ('2929','石泉县','2926');
INSERT INTO ts_area VALUES ('2930','宁陕县','2926');
INSERT INTO ts_area VALUES ('2931','紫阳县','2926');
INSERT INTO ts_area VALUES ('2932','岚皋县','2926');
INSERT INTO ts_area VALUES ('2933','平利县','2926');
INSERT INTO ts_area VALUES ('2934','镇坪县','2926');
INSERT INTO ts_area VALUES ('2935','旬阳县','2926');
INSERT INTO ts_area VALUES ('2936','白河县','2926');
INSERT INTO ts_area VALUES ('2937','商洛市','2827');
INSERT INTO ts_area VALUES ('2938','商州区','2937');
INSERT INTO ts_area VALUES ('2939','洛南县','2937');
INSERT INTO ts_area VALUES ('2940','丹凤县','2937');
INSERT INTO ts_area VALUES ('2941','商南县','2937');
INSERT INTO ts_area VALUES ('2942','山阳县','2937');
INSERT INTO ts_area VALUES ('2943','镇安县','2937');
INSERT INTO ts_area VALUES ('2944','柞水县','2937');
INSERT INTO ts_area VALUES ('2945','甘肃','0');
INSERT INTO ts_area VALUES ('2946','兰州市','2945');
INSERT INTO ts_area VALUES ('2947','城关区','2946');
INSERT INTO ts_area VALUES ('2948','七里河区','2946');
INSERT INTO ts_area VALUES ('2949','西固区','2946');
INSERT INTO ts_area VALUES ('2950','安宁区','2946');
INSERT INTO ts_area VALUES ('2951','红古区','2946');
INSERT INTO ts_area VALUES ('2952','永登县','2946');
INSERT INTO ts_area VALUES ('2953','皋兰县','2946');
INSERT INTO ts_area VALUES ('2954','榆中县','2946');
INSERT INTO ts_area VALUES ('2955','嘉峪关市','2945');
INSERT INTO ts_area VALUES ('2956','金昌市','2945');
INSERT INTO ts_area VALUES ('2957','金川区','2956');
INSERT INTO ts_area VALUES ('2958','永昌县','2956');
INSERT INTO ts_area VALUES ('2959','白银市','2945');
INSERT INTO ts_area VALUES ('2960','白银区','2959');
INSERT INTO ts_area VALUES ('2961','平川区','2959');
INSERT INTO ts_area VALUES ('2962','靖远县','2959');
INSERT INTO ts_area VALUES ('2963','会宁县','2959');
INSERT INTO ts_area VALUES ('2964','景泰县','2959');
INSERT INTO ts_area VALUES ('2965','天水市','2945');
INSERT INTO ts_area VALUES ('2966','秦州区','2965');
INSERT INTO ts_area VALUES ('2967','麦积区','2965');
INSERT INTO ts_area VALUES ('2968','清水县','2965');
INSERT INTO ts_area VALUES ('2969','秦安县','2965');
INSERT INTO ts_area VALUES ('2970','甘谷县','2965');
INSERT INTO ts_area VALUES ('2971','武山县','2965');
INSERT INTO ts_area VALUES ('2972','张家川回族自治县','2965');
INSERT INTO ts_area VALUES ('2973','武威市','2945');
INSERT INTO ts_area VALUES ('2974','凉州区','2973');
INSERT INTO ts_area VALUES ('2975','民勤县','2973');
INSERT INTO ts_area VALUES ('2976','古浪县','2973');
INSERT INTO ts_area VALUES ('2977','天祝藏族自治县','2973');
INSERT INTO ts_area VALUES ('2978','张掖市','2945');
INSERT INTO ts_area VALUES ('2979','甘州区','2978');
INSERT INTO ts_area VALUES ('2980','肃南裕固族自治县','2978');
INSERT INTO ts_area VALUES ('2981','民乐县','2978');
INSERT INTO ts_area VALUES ('2982','临泽县','2978');
INSERT INTO ts_area VALUES ('2983','高台县','2978');
INSERT INTO ts_area VALUES ('2984','山丹县','2978');
INSERT INTO ts_area VALUES ('2985','平凉市','2945');
INSERT INTO ts_area VALUES ('2986','崆峒区','2985');
INSERT INTO ts_area VALUES ('2987','泾川县','2985');
INSERT INTO ts_area VALUES ('2988','灵台县','2985');
INSERT INTO ts_area VALUES ('2989','崇信县','2985');
INSERT INTO ts_area VALUES ('2990','华亭县','2985');
INSERT INTO ts_area VALUES ('2991','庄浪县','2985');
INSERT INTO ts_area VALUES ('2992','静宁县','2985');
INSERT INTO ts_area VALUES ('2993','酒泉市','2945');
INSERT INTO ts_area VALUES ('2994','肃州区','2993');
INSERT INTO ts_area VALUES ('2995','金塔县','2993');
INSERT INTO ts_area VALUES ('2996','瓜州县','2993');
INSERT INTO ts_area VALUES ('2997','肃北蒙古族自治县','2993');
INSERT INTO ts_area VALUES ('2998','阿克塞哈萨克族自治县','2993');
INSERT INTO ts_area VALUES ('2999','玉门市','2993');
INSERT INTO ts_area VALUES ('3000','敦煌市','2993');
INSERT INTO ts_area VALUES ('3001','庆阳市','2945');
INSERT INTO ts_area VALUES ('3002','西峰区','3001');
INSERT INTO ts_area VALUES ('3003','庆城县','3001');
INSERT INTO ts_area VALUES ('3004','环县','3001');
INSERT INTO ts_area VALUES ('3005','华池县','3001');
INSERT INTO ts_area VALUES ('3006','合水县','3001');
INSERT INTO ts_area VALUES ('3007','正宁县','3001');
INSERT INTO ts_area VALUES ('3008','宁县','3001');
INSERT INTO ts_area VALUES ('3009','镇原县','3001');
INSERT INTO ts_area VALUES ('3010','定西市','2945');
INSERT INTO ts_area VALUES ('3011','安定区','3010');
INSERT INTO ts_area VALUES ('3012','通渭县','3010');
INSERT INTO ts_area VALUES ('3013','陇西县','3010');
INSERT INTO ts_area VALUES ('3014','渭源县','3010');
INSERT INTO ts_area VALUES ('3015','临洮县','3010');
INSERT INTO ts_area VALUES ('3016','漳县','3010');
INSERT INTO ts_area VALUES ('3017','岷县','3010');
INSERT INTO ts_area VALUES ('3018','陇南市','2945');
INSERT INTO ts_area VALUES ('3019','武都区','3018');
INSERT INTO ts_area VALUES ('3020','成县','3018');
INSERT INTO ts_area VALUES ('3021','文县','3018');
INSERT INTO ts_area VALUES ('3022','宕昌县','3018');
INSERT INTO ts_area VALUES ('3023','康县','3018');
INSERT INTO ts_area VALUES ('3024','西和县','3018');
INSERT INTO ts_area VALUES ('3025','礼县','3018');
INSERT INTO ts_area VALUES ('3026','徽县','3018');
INSERT INTO ts_area VALUES ('3027','两当县','3018');
INSERT INTO ts_area VALUES ('3028','临夏回族自治州','2945');
INSERT INTO ts_area VALUES ('3029','临夏市','3028');
INSERT INTO ts_area VALUES ('3030','临夏县','3028');
INSERT INTO ts_area VALUES ('3031','康乐县','3028');
INSERT INTO ts_area VALUES ('3032','永靖县','3028');
INSERT INTO ts_area VALUES ('3033','广河县','3028');
INSERT INTO ts_area VALUES ('3034','和政县','3028');
INSERT INTO ts_area VALUES ('3035','东乡族自治县','3028');
INSERT INTO ts_area VALUES ('3036','积石山保安族东乡族撒拉族自治县','3028');
INSERT INTO ts_area VALUES ('3037','甘南藏族自治州','2945');
INSERT INTO ts_area VALUES ('3038','合作市','3037');
INSERT INTO ts_area VALUES ('3039','临潭县','3037');
INSERT INTO ts_area VALUES ('3040','卓尼县','3037');
INSERT INTO ts_area VALUES ('3041','舟曲县','3037');
INSERT INTO ts_area VALUES ('3042','迭部县','3037');
INSERT INTO ts_area VALUES ('3043','玛曲县','3037');
INSERT INTO ts_area VALUES ('3044','碌曲县','3037');
INSERT INTO ts_area VALUES ('3045','夏河县','3037');
INSERT INTO ts_area VALUES ('3046','青海','0');
INSERT INTO ts_area VALUES ('3047','西宁市','3046');
INSERT INTO ts_area VALUES ('3048','城东区','3047');
INSERT INTO ts_area VALUES ('3049','城中区','3047');
INSERT INTO ts_area VALUES ('3050','城西区','3047');
INSERT INTO ts_area VALUES ('3051','城北区','3047');
INSERT INTO ts_area VALUES ('3052','大通回族土族自治县','3047');
INSERT INTO ts_area VALUES ('3053','湟中县','3047');
INSERT INTO ts_area VALUES ('3054','湟源县','3047');
INSERT INTO ts_area VALUES ('3055','海东地区','3046');
INSERT INTO ts_area VALUES ('3056','平安县','3055');
INSERT INTO ts_area VALUES ('3057','民和回族土族自治县','3055');
INSERT INTO ts_area VALUES ('3058','乐都县','3055');
INSERT INTO ts_area VALUES ('3059','互助土族自治县','3055');
INSERT INTO ts_area VALUES ('3060','化隆回族自治县','3055');
INSERT INTO ts_area VALUES ('3061','循化撒拉族自治县','3055');
INSERT INTO ts_area VALUES ('3062','海北藏族自治州','3046');
INSERT INTO ts_area VALUES ('3063','门源回族自治县','3062');
INSERT INTO ts_area VALUES ('3064','祁连县','3062');
INSERT INTO ts_area VALUES ('3065','海晏县','3062');
INSERT INTO ts_area VALUES ('3066','刚察县','3062');
INSERT INTO ts_area VALUES ('3067','黄南藏族自治州','3046');
INSERT INTO ts_area VALUES ('3068','同仁县','3067');
INSERT INTO ts_area VALUES ('3069','尖扎县','3067');
INSERT INTO ts_area VALUES ('3070','泽库县','3067');
INSERT INTO ts_area VALUES ('3071','河南蒙古族自治县','3067');
INSERT INTO ts_area VALUES ('3072','海南藏族自治州','3046');
INSERT INTO ts_area VALUES ('3073','共和县','3072');
INSERT INTO ts_area VALUES ('3074','同德县','3072');
INSERT INTO ts_area VALUES ('3075','贵德县','3072');
INSERT INTO ts_area VALUES ('3076','兴海县','3072');
INSERT INTO ts_area VALUES ('3077','贵南县','3072');
INSERT INTO ts_area VALUES ('3078','果洛藏族自治州','3046');
INSERT INTO ts_area VALUES ('3079','玛沁县','3078');
INSERT INTO ts_area VALUES ('3080','班玛县','3078');
INSERT INTO ts_area VALUES ('3081','甘德县','3078');
INSERT INTO ts_area VALUES ('3082','达日县','3078');
INSERT INTO ts_area VALUES ('3083','久治县','3078');
INSERT INTO ts_area VALUES ('3084','玛多县','3078');
INSERT INTO ts_area VALUES ('3085','玉树藏族自治州','3046');
INSERT INTO ts_area VALUES ('3086','玉树县','3085');
INSERT INTO ts_area VALUES ('3087','杂多县','3085');
INSERT INTO ts_area VALUES ('3088','称多县','3085');
INSERT INTO ts_area VALUES ('3089','治多县','3085');
INSERT INTO ts_area VALUES ('3090','囊谦县','3085');
INSERT INTO ts_area VALUES ('3091','曲麻莱县','3085');
INSERT INTO ts_area VALUES ('3092','海西蒙古族藏族自治州','3046');
INSERT INTO ts_area VALUES ('3093','格尔木市','3092');
INSERT INTO ts_area VALUES ('3094','德令哈市','3092');
INSERT INTO ts_area VALUES ('3095','乌兰县','3092');
INSERT INTO ts_area VALUES ('3096','都兰县','3092');
INSERT INTO ts_area VALUES ('3097','天峻县','3092');
INSERT INTO ts_area VALUES ('3098','宁夏','0');
INSERT INTO ts_area VALUES ('3099','银川市','3098');
INSERT INTO ts_area VALUES ('3100','兴庆区','3099');
INSERT INTO ts_area VALUES ('3101','西夏区','3099');
INSERT INTO ts_area VALUES ('3102','金凤区','3099');
INSERT INTO ts_area VALUES ('3103','永宁县','3099');
INSERT INTO ts_area VALUES ('3104','贺兰县','3099');
INSERT INTO ts_area VALUES ('3105','灵武市','3099');
INSERT INTO ts_area VALUES ('3106','石嘴山市','3098');
INSERT INTO ts_area VALUES ('3107','大武口区','3106');
INSERT INTO ts_area VALUES ('3108','惠农区','3106');
INSERT INTO ts_area VALUES ('3109','平罗县','3106');
INSERT INTO ts_area VALUES ('3110','吴忠市','3098');
INSERT INTO ts_area VALUES ('3111','利通区','3110');
INSERT INTO ts_area VALUES ('3112','盐池县','3110');
INSERT INTO ts_area VALUES ('3113','同心县','3110');
INSERT INTO ts_area VALUES ('3114','青铜峡市','3110');
INSERT INTO ts_area VALUES ('3115','固原市','3098');
INSERT INTO ts_area VALUES ('3116','原州区','3115');
INSERT INTO ts_area VALUES ('3117','西吉县','3115');
INSERT INTO ts_area VALUES ('3118','隆德县','3115');
INSERT INTO ts_area VALUES ('3119','泾源县','3115');
INSERT INTO ts_area VALUES ('3120','彭阳县','3115');
INSERT INTO ts_area VALUES ('3121','中卫市','3098');
INSERT INTO ts_area VALUES ('3122','沙坡头区','3121');
INSERT INTO ts_area VALUES ('3123','中宁县','3121');
INSERT INTO ts_area VALUES ('3124','海原县','3121');
INSERT INTO ts_area VALUES ('3125','新疆','0');
INSERT INTO ts_area VALUES ('3126','乌鲁木齐市','3125');
INSERT INTO ts_area VALUES ('3127','天山区','3126');
INSERT INTO ts_area VALUES ('3128','沙依巴克区','3126');
INSERT INTO ts_area VALUES ('3129','新市区','3126');
INSERT INTO ts_area VALUES ('3130','水磨沟区','3126');
INSERT INTO ts_area VALUES ('3131','头屯河区','3126');
INSERT INTO ts_area VALUES ('3132','达坂城区','3126');
INSERT INTO ts_area VALUES ('3133','米东区','3126');
INSERT INTO ts_area VALUES ('3134','乌鲁木齐县','3126');
INSERT INTO ts_area VALUES ('3135','克拉玛依市','3125');
INSERT INTO ts_area VALUES ('3136','独山子区','3135');
INSERT INTO ts_area VALUES ('3137','克拉玛依区','3135');
INSERT INTO ts_area VALUES ('3138','白碱滩区','3135');
INSERT INTO ts_area VALUES ('3139','乌尔禾区','3135');
INSERT INTO ts_area VALUES ('3140','吐鲁番地区','3125');
INSERT INTO ts_area VALUES ('3141','吐鲁番市','3140');
INSERT INTO ts_area VALUES ('3142','鄯善县','3140');
INSERT INTO ts_area VALUES ('3143','托克逊县','3140');
INSERT INTO ts_area VALUES ('3144','哈密地区','3125');
INSERT INTO ts_area VALUES ('3145','昌吉回族自治州','3125');
INSERT INTO ts_area VALUES ('3146','昌吉市','3145');
INSERT INTO ts_area VALUES ('3147','阜康市','3145');
INSERT INTO ts_area VALUES ('3148','呼图壁县','3145');
INSERT INTO ts_area VALUES ('3149','玛纳斯县','3145');
INSERT INTO ts_area VALUES ('3150','奇台县','3145');
INSERT INTO ts_area VALUES ('3151','吉木萨尔县','3145');
INSERT INTO ts_area VALUES ('3152','木垒哈萨克自治县','3145');
INSERT INTO ts_area VALUES ('3153','博尔塔拉蒙古自治州','3125');
INSERT INTO ts_area VALUES ('3154','博乐市','3153');
INSERT INTO ts_area VALUES ('3155','精河县','3153');
INSERT INTO ts_area VALUES ('3156','温泉县','3153');
INSERT INTO ts_area VALUES ('3157','巴音郭楞蒙古自治州','3125');
INSERT INTO ts_area VALUES ('3158','库尔勒市','3157');
INSERT INTO ts_area VALUES ('3159','轮台县','3157');
INSERT INTO ts_area VALUES ('3160','尉犁县','3157');
INSERT INTO ts_area VALUES ('3161','若羌县','3157');
INSERT INTO ts_area VALUES ('3162','且末县','3157');
INSERT INTO ts_area VALUES ('3163','焉耆回族自治县','3157');
INSERT INTO ts_area VALUES ('3164','和静县','3157');
INSERT INTO ts_area VALUES ('3165','和硕县','3157');
INSERT INTO ts_area VALUES ('3166','博湖县','3157');
INSERT INTO ts_area VALUES ('3167','阿克苏地区','3125');
INSERT INTO ts_area VALUES ('3168','阿克苏市','3167');
INSERT INTO ts_area VALUES ('3169','温宿县','3167');
INSERT INTO ts_area VALUES ('3170','库车县','3167');
INSERT INTO ts_area VALUES ('3171','沙雅县','3167');
INSERT INTO ts_area VALUES ('3172','新和县','3167');
INSERT INTO ts_area VALUES ('3173','拜城县','3167');
INSERT INTO ts_area VALUES ('3174','乌什县','3167');
INSERT INTO ts_area VALUES ('3175','阿瓦提县','3167');
INSERT INTO ts_area VALUES ('3176','柯坪县','3167');
INSERT INTO ts_area VALUES ('3177','克孜勒苏柯尔克孜自治州','3125');
INSERT INTO ts_area VALUES ('3178','阿图什市','3177');
INSERT INTO ts_area VALUES ('3179','阿克陶县','3177');
INSERT INTO ts_area VALUES ('3180','阿合奇县','3177');
INSERT INTO ts_area VALUES ('3181','乌恰县','3177');
INSERT INTO ts_area VALUES ('3182','喀什地区','3125');
INSERT INTO ts_area VALUES ('3183','喀什市','3182');
INSERT INTO ts_area VALUES ('3184','疏附县','3182');
INSERT INTO ts_area VALUES ('3185','疏勒县','3182');
INSERT INTO ts_area VALUES ('3186','英吉沙县','3182');
INSERT INTO ts_area VALUES ('3187','泽普县','3182');
INSERT INTO ts_area VALUES ('3188','莎车县','3182');
INSERT INTO ts_area VALUES ('3189','叶城县','3182');
INSERT INTO ts_area VALUES ('3190','麦盖提县','3182');
INSERT INTO ts_area VALUES ('3191','岳普湖县','3182');
INSERT INTO ts_area VALUES ('3192','伽师县','3182');
INSERT INTO ts_area VALUES ('3193','巴楚县','3182');
INSERT INTO ts_area VALUES ('3194','塔什库尔干塔吉克自治县','3182');
INSERT INTO ts_area VALUES ('3195','和田地区','3125');
INSERT INTO ts_area VALUES ('3196','和田市','3195');
INSERT INTO ts_area VALUES ('3197','和田县','3195');
INSERT INTO ts_area VALUES ('3198','墨玉县','3195');
INSERT INTO ts_area VALUES ('3199','皮山县','3195');
INSERT INTO ts_area VALUES ('3200','洛浦县','3195');
INSERT INTO ts_area VALUES ('3201','策勒县','3195');
INSERT INTO ts_area VALUES ('3202','于田县','3195');
INSERT INTO ts_area VALUES ('3203','民丰县','3195');
INSERT INTO ts_area VALUES ('3204','伊犁哈萨克自治州','3125');
INSERT INTO ts_area VALUES ('3205','伊宁市','3204');
INSERT INTO ts_area VALUES ('3206','奎屯市','3204');
INSERT INTO ts_area VALUES ('3207','伊宁县','3204');
INSERT INTO ts_area VALUES ('3208','察布查尔锡伯自治县','3204');
INSERT INTO ts_area VALUES ('3209','霍城县','3204');
INSERT INTO ts_area VALUES ('3210','巩留县','3204');
INSERT INTO ts_area VALUES ('3211','新源县','3204');
INSERT INTO ts_area VALUES ('3212','昭苏县','3204');
INSERT INTO ts_area VALUES ('3213','特克斯县','3204');
INSERT INTO ts_area VALUES ('3214','尼勒克县','3204');
INSERT INTO ts_area VALUES ('3215','塔城地区','3125');
INSERT INTO ts_area VALUES ('3216','塔城市','3215');
INSERT INTO ts_area VALUES ('3217','乌苏市','3215');
INSERT INTO ts_area VALUES ('3218','额敏县','3215');
INSERT INTO ts_area VALUES ('3219','沙湾县','3215');
INSERT INTO ts_area VALUES ('3220','托里县','3215');
INSERT INTO ts_area VALUES ('3221','裕民县','3215');
INSERT INTO ts_area VALUES ('3222','和布克赛尔蒙古自治县','3215');
INSERT INTO ts_area VALUES ('3223','阿勒泰地区','3125');
INSERT INTO ts_area VALUES ('3224','阿勒泰市','3223');
INSERT INTO ts_area VALUES ('3225','布尔津县','3223');
INSERT INTO ts_area VALUES ('3226','富蕴县','3223');
INSERT INTO ts_area VALUES ('3227','福海县','3223');
INSERT INTO ts_area VALUES ('3228','哈巴河县','3223');
INSERT INTO ts_area VALUES ('3229','青河县','3223');
INSERT INTO ts_area VALUES ('3230','吉木乃县','3223');
INSERT INTO ts_area VALUES ('3231','石河子市','3223');
INSERT INTO ts_area VALUES ('3232','阿拉尔市','3223');
INSERT INTO ts_area VALUES ('3233','图木舒克市','3223');
INSERT INTO ts_area VALUES ('3234','五家渠','3223');

DROP TABLE IF EXISTS ts_attach;
CREATE TABLE `ts_attach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attach_type` varchar(50) NOT NULL DEFAULT 'attach',
  `userId` int(11) unsigned DEFAULT NULL,
  `uploadTime` int(11) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `size` varchar(20) DEFAULT NULL,
  `extension` varchar(20) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `private` tinyint(1) DEFAULT '0',
  `isDel` tinyint(1) DEFAULT '0',
  `savepath` varchar(255) DEFAULT NULL,
  `savename` varchar(255) DEFAULT NULL,
  `savedomain` tinyint(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userId` (`userId`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8;

INSERT INTO ts_attach VALUES ('41','topics','1','1333955531','banner.jpg','image/jpeg','53059','jpg','dbea57918831319f833382004ff23621','0','0','2012/0409/15/','4f828bcb90c94.jpg','0');
INSERT INTO ts_attach VALUES ('46','topics','1','1334715717','45_1_3714116411842_960X270.jpg','image/jpeg','100483','jpg','ff655c361d8b34384f39a6bae1307c5c','0','0','2012/0418/10/','4f8e25452f00e.jpg','0');
INSERT INTO ts_attach VALUES ('45','topics','1','1334591784','43_1_2208946912059_960X270.jpg','image/jpeg','88206','jpg','0cf79df93350f106345a2e4c65ffd5f2','0','0','2012/0416/23/','4f8c41282d71b.jpg','0');
INSERT INTO ts_attach VALUES ('44','topics','1','1334279609','banner.jpg','image/jpeg','82171','jpg','d8245b7dc7b45c463ec2a78960e2ef13','0','0','2012/0413/09/','4f877db93eb20.jpg','0');
INSERT INTO ts_attach VALUES ('22','kissy','1','1331225098','banner1.gif','image/gif','33003','gif','b6e14e70fe1f005e5bbaca1d5468fc68','0','0','2012/0309/00/','4f58e20aa0d9f.gif','0');
INSERT INTO ts_attach VALUES ('23','kissy','1','1331225478','banner2.gif','image/gif','15947','gif','cfd7e228223000e930650103f252ca1c','0','0','2012/0309/00/','4f58e3861cd03.gif','0');
INSERT INTO ts_attach VALUES ('24','kissy','1','1331375904','4f58e3861cd03[1].gif','image/gif','17714','gif','1f53fbd0723f24aae033f73e2e966109','0','0','2012/0310/18/','4f5b2f2007d18.gif','0');
INSERT INTO ts_attach VALUES ('25','kissy','1','1331376003','4f58e3861cd03[1].gif','image/gif','21465','gif','bcb1d9d9d744023e07bd9e6b665291e1','0','0','2012/0310/18/','4f5b2f8377367.gif','0');
INSERT INTO ts_attach VALUES ('26','topics','2','1331402841','shell.php.jpg','image/jpeg','132060','jpg','7a1dd92422677a8a14f56fd3eb2adf3c','0','0','2012/0311/02/','4f5b98590b100.jpg','0');
INSERT INTO ts_attach VALUES ('27','topics','2','1331402930','shell.php.jpg','image/jpeg','132060','jpg','7a1dd92422677a8a14f56fd3eb2adf3c','0','0','2012/0311/02/','4f5b98b249ee1.jpg','0');
INSERT INTO ts_attach VALUES ('28','topics','2','1331403072','shell.php.jpg','image/jpeg','132060','jpg','7a1dd92422677a8a14f56fd3eb2adf3c','0','0','2012/0311/02/','4f5b99400bd90.jpg','0');
INSERT INTO ts_attach VALUES ('29','topics','2','1331403366','shell.php;.jpg','image/jpeg','132060','jpg','7a1dd92422677a8a14f56fd3eb2adf3c','0','0','2012/0311/02/','4f5b9a66cb259.jpg','0');
INSERT INTO ts_attach VALUES ('30','kissy','2','1331403612','shell.php%00.jpg','image/jpeg','132060','jpg','7a1dd92422677a8a14f56fd3eb2adf3c','0','0','2012/0311/02/','4f5b9b5c6d0ce.jpg','0');
INSERT INTO ts_attach VALUES ('31','kissy','2','1331403737','14649_104514746227878_100000080597097_129924_6846671_n.jpg','image/jpeg','114569','jpg','ab0058a08a1307ce556495ae76472a16','0','0','2012/0311/02/','4f5b9bd92a47d.jpg','0');
INSERT INTO ts_attach VALUES ('32','topics','2','1331403855','shell.phpU+0025U+0030.jpg','image/jpeg','132060','jpg','7a1dd92422677a8a14f56fd3eb2adf3c','0','0','2012/0311/02/','4f5b9c4f04cda.jpg','0');
INSERT INTO ts_attach VALUES ('33','topics','2','1331405749','.htaccess.jpg','application/octet-stream','70','jpg','74b0df623aa80c6c495b0dea01eb7e73','0','0','2012/0311/02/','4f5ba3b514612.jpg','0');
INSERT INTO ts_attach VALUES ('34','topics','2','1331405782','.htaccess.jpg','image/jpg','70','jpg','74b0df623aa80c6c495b0dea01eb7e73','0','0','2012/0311/02/','4f5ba3d6ee401.jpg','0');
INSERT INTO ts_attach VALUES ('35','topics','2','1331405822','.htaccess.jpg','image/jpeg','70','jpg','74b0df623aa80c6c495b0dea01eb7e73','0','0','2012/0311/02/','4f5ba3fed315e.jpg','0');
INSERT INTO ts_attach VALUES ('36','topics','2','1331405840','index.php.jpg','image/jpeg','56863','jpg','657123378474c1d8304c48f4106b0595','0','0','2012/0311/02/','4f5ba4109dde8.jpg','0');
INSERT INTO ts_attach VALUES ('37','topics','2','1331405865','index.php.jpg','image/jpeg','56863','jpg','657123378474c1d8304c48f4106b0595','0','0','2012/0311/02/','4f5ba42956a19.jpg','0');
INSERT INTO ts_attach VALUES ('38','topics','1','1331957650','bf352ed2-9fc9-41ae-8877-911b5993d2da.jpg','image/jpeg','163912','jpg','92936921e0e1969eb6c8d8e63b374ce0','0','0','2012/0317/12/','4f640f92b18bb.jpg','0');
INSERT INTO ts_attach VALUES ('39','kissy','1','1332149406','4f5b2f8377367[1].gif','image/gif','25806','gif','881e85b9e7507f968374e3a72fd487b3','0','0','2012/0319/17/','4f66fc9ed8627.gif','0');
INSERT INTO ts_attach VALUES ('42','topics','1','1334039090','banner1.jpg','image/pjpeg','72844','jpg','45c78601d5eb6dd58c8c1fe453bdbb74','0','0','2012/0410/14/','4f83d232ac1d1.jpg','0');

DROP TABLE IF EXISTS ts_blog;
CREATE TABLE `ts_blog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(20) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `category` mediumint(5) DEFAULT NULL,
  `category_title` varchar(255) DEFAULT NULL,
  `cover` varchar(255) DEFAULT NULL,
  `content` longtext,
  `readCount` int(11) NOT NULL DEFAULT '0',
  `commentCount` int(11) NOT NULL DEFAULT '0',
  `recommendCount` int(11) NOT NULL DEFAULT '0',
  `tags` varchar(255) DEFAULT NULL,
  `cTime` int(11) DEFAULT NULL,
  `mTime` int(11) DEFAULT NULL,
  `rTime` int(11) NOT NULL DEFAULT '0',
  `isHot` varchar(1) NOT NULL DEFAULT '0',
  `type` int(1) DEFAULT NULL,
  `status` varchar(1) NOT NULL DEFAULT '1',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `private_data` varchar(255) DEFAULT NULL,
  `hot` int(11) NOT NULL DEFAULT '0',
  `canableComment` tinyint(1) NOT NULL DEFAULT '1',
  `attach` text,
  PRIMARY KEY (`id`),
  KEY `hot` (`hot`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO ts_blog VALUES ('1','1','','测试呢','1','未分类','','&lt;p&gt;测试。&lt;a target=\"_self&amp;quot; title=&amp;quot;\" href=\"http://www.baidu.com\"&gt;www.baidu.com&lt;/a&gt;&lt;/p&gt;','3','0','0','','1310379312','1310379312','0','0','0','2','0','d41d8cd98f00b204e9800998ecf8427e','3','0','');
INSERT INTO ts_blog VALUES ('2','50','','今天心情不错  减肥成功2斤','2','减肥','','&lt;p&gt;今天心情不错 &amp;nbsp; 减肥成功2斤&lt;/p&gt;','23','0','0','','1311428763','1311428763','0','0','0','2','0','d41d8cd98f00b204e9800998ecf8427e','23','0','');
INSERT INTO ts_blog VALUES ('3','169','','的的得到的得到的得到的得到的的的得到的得到的得到的','3','都达到','','&lt;p&gt;的得到的得到的得到的得到的的的的的得到的得到的得到的得到的的的得到的得到的得到的得到的的淡淡的的的得到的得到的得到的得到的的得到的得到的得到的得到的&lt;/p&gt;','0','0','0','','1315783526','1315783526','0','0','0','2','0','d41d8cd98f00b204e9800998ecf8427e','0','0','');
INSERT INTO ts_blog VALUES ('4','199','','sdfgd','4','sdfg','','&lt;p&gt;sdfgsdfgdfg&lt;/p&gt;','0','0','0','','1316511637','1316511637','0','0','0','2','0','d41d8cd98f00b204e9800998ecf8427e','0','0','');

DROP TABLE IF EXISTS ts_blog_category;
CREATE TABLE `ts_blog_category` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO ts_blog_category VALUES ('1','未分类','0','0');
INSERT INTO ts_blog_category VALUES ('2','减肥','50','0');
INSERT INTO ts_blog_category VALUES ('3','都达到','169','0');
INSERT INTO ts_blog_category VALUES ('4','sdfg','199','0');

DROP TABLE IF EXISTS ts_blog_item;
CREATE TABLE `ts_blog_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sourceId` int(11) DEFAULT NULL,
  `snapday` int(11) DEFAULT NULL,
  `pubdate` int(11) DEFAULT NULL,
  `boot` tinyint(1) NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `summary` text,
  PRIMARY KEY (`id`),
  KEY `source_id` (`sourceId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_blog_mention;
CREATE TABLE `ts_blog_mention` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blogid` int(20) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogid` (`blogid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_blog_outline;
CREATE TABLE `ts_blog_outline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(20) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `category` mediumint(5) DEFAULT NULL,
  `cover` varchar(255) DEFAULT NULL,
  `content` longtext,
  `readCount` int(11) NOT NULL DEFAULT '0',
  `commentCount` int(11) NOT NULL DEFAULT '0',
  `tags` varchar(255) DEFAULT NULL,
  `cTime` int(11) DEFAULT NULL,
  `mTime` int(11) DEFAULT NULL,
  `isHot` varchar(1) NOT NULL DEFAULT '0',
  `type` int(1) DEFAULT NULL,
  `status` varchar(1) NOT NULL DEFAULT '1',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `hot` int(11) NOT NULL DEFAULT '0',
  `friendId` text,
  `canableComment` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `hot` (`hot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_blog_source;
CREATE TABLE `ts_blog_source` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(10) DEFAULT NULL,
  `username` char(30) DEFAULT NULL,
  `cTime` int(11) DEFAULT NULL,
  `lastSnap` int(11) DEFAULT NULL,
  `isNew` tinyint(1) DEFAULT NULL,
  `changes` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_blog_subscribe;
CREATE TABLE `ts_blog_subscribe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sourceId` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `type` tinyint(4) DEFAULT '0',
  `newNum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sourceId` (`sourceId`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_category;
CREATE TABLE `ts_category` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `tid` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `cleft` int(11) NOT NULL,
  `cright` int(11) NOT NULL,
  `corder` int(5) NOT NULL DEFAULT '0',
  `namespace` varchar(255) NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_comment;
CREATE TABLE `ts_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` char(15) DEFAULT NULL,
  `appid` int(11) DEFAULT NULL,
  `appuid` int(11) DEFAULT NULL,
  `name` varchar(30) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `comment` text,
  `cTime` int(12) DEFAULT NULL,
  `toId` int(11) NOT NULL DEFAULT '0',
  `status` int(1) DEFAULT '0',
  `quietly` tinyint(1) NOT NULL DEFAULT '0',
  `to_uid` int(11) NOT NULL DEFAULT '0',
  `data` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `appid` (`appid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_credit_setting;
CREATE TABLE `ts_credit_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT 'user',
  `info` text NOT NULL,
  `score` int(11) NOT NULL DEFAULT '0',
  `experience` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=144 DEFAULT CHARSET=utf8;

INSERT INTO ts_credit_setting VALUES ('114','delete_blog','删除博客','blog','{action}{sign}了{score}{typecn}','-5','-5');
INSERT INTO ts_credit_setting VALUES ('37','invite_friend','邀请好友','register','{action}{sign}了{score}{typecn}','10','10');
INSERT INTO ts_credit_setting VALUES ('39','add_weibo','发布微薄','weibo','{action}{sign}了{score}{typecn}','1','2');
INSERT INTO ts_credit_setting VALUES ('40','user_login','用户登录','user','{action}{sign}了{score}{typecn}','0','1');
INSERT INTO ts_credit_setting VALUES ('42','space_visited','空间被访问','user','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('112','delete_vote','删除投票','vote','{action}{sign}了{score}{typecn}','-20','-20');
INSERT INTO ts_credit_setting VALUES ('111','joined_vote','投票被参与','vote','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('110','join_vote','参与投票','vote','{action}{sign}了{score}{typecn}','1','5');
INSERT INTO ts_credit_setting VALUES ('92','init_default','注册积分','register','{action}{sign}了{score}{typecn}','200','0');
INSERT INTO ts_credit_setting VALUES ('59','add_comment','评论别人','comment','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('60','reply_comment','回复别人的评论','comment','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('61','replied_comment','评论被回复','comment','{action}{sign}了{score}{typecn}','2','2');
INSERT INTO ts_credit_setting VALUES ('63','reply_weibo','回复微博','weibo','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('64','replied_weibo','微博被回复','weibo','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('81','is_commented','被别人评论','comment','{action}{sign}了{score}{typecn}','1','2');
INSERT INTO ts_credit_setting VALUES ('121','add_photo','上传图片','photo','{action}{sign}了{score}{typecn}','2','2');
INSERT INTO ts_credit_setting VALUES ('83','share_to_weibo','分享到微薄','weibo','{action}{sign}了{score}{typecn}','3','3');
INSERT INTO ts_credit_setting VALUES ('113','add_blog','发表博客','blog','{action}{sign}了{score}{typecn}','5','5');
INSERT INTO ts_credit_setting VALUES ('120','delete_album','删除相册','photo','{action}{sign}了{score}{typecn}','-10','-10');
INSERT INTO ts_credit_setting VALUES ('119','add_album','创建相册','photo','{action}{sign}了{score}{typecn}','10','10');
INSERT INTO ts_credit_setting VALUES ('109','add_vote','发起投票','vote','{action}{sign}了{score}{typecn}','20','20');
INSERT INTO ts_credit_setting VALUES ('88','delete_comment','删除评论','comment','{action}{sign}了{score}{typecn}','-2','-2');
INSERT INTO ts_credit_setting VALUES ('89','delete_weibo','删除微薄','weibo','{action}{sign}了{score}{typecn}','-2','-2');
INSERT INTO ts_credit_setting VALUES ('90','forward_weibo','转发微薄','weibo','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('91','forwarded_weibo','微博被转发','weibo','{action}{sign}了{score}{typecn}','1','1');
INSERT INTO ts_credit_setting VALUES ('93','delete_weibo_comment','删除微博评论','weibo','{action}{sign}了{score}{typecn}','-1','-1');
INSERT INTO ts_credit_setting VALUES ('94','add_medal','获得勋章','medal','{action}{sign}了{score}{typecn}','5','5');
INSERT INTO ts_credit_setting VALUES ('95','delete_medal','丢失勋章','medal','{action}{sign}了{score}{typecn}','-5','0');
INSERT INTO ts_credit_setting VALUES ('115','add_event','发起活动','event','{action}{sign}了{score}{typecn}','10','10');
INSERT INTO ts_credit_setting VALUES ('116','delete_event','删除活动','event','{action}{sign}了{score}{typecn}','-10','-10');
INSERT INTO ts_credit_setting VALUES ('117','join_event','参加活动','event','{action}{sign}了{score}{typecn}','3','2');
INSERT INTO ts_credit_setting VALUES ('118','cancel_join_event','取消参加活动','event','{action}{sign}了{score}{typecn}','-3','-2');
INSERT INTO ts_credit_setting VALUES ('122','add_poster','发起招贴','poster','{action}{sign}了{score}{typecn}','2','2');
INSERT INTO ts_credit_setting VALUES ('123','delete_poster','删除招贴','poster','{action}{sign}了{score}{typecn}','-2','-2');

DROP TABLE IF EXISTS ts_credit_type;
CREATE TABLE `ts_credit_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `alias` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO ts_credit_type VALUES ('1','score','积分');
INSERT INTO ts_credit_type VALUES ('2','experience','经验');

DROP TABLE IF EXISTS ts_credit_user;
CREATE TABLE `ts_credit_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `score` int(11) NOT NULL,
  `experience` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=465 DEFAULT CHARSET=utf8;

INSERT INTO ts_credit_user VALUES ('1','1','1852','2952');
INSERT INTO ts_credit_user VALUES ('2','2','1499','1451');
INSERT INTO ts_credit_user VALUES ('31','31','247','50');
INSERT INTO ts_credit_user VALUES ('32','32','252','53');
INSERT INTO ts_credit_user VALUES ('33','33','245','46');
INSERT INTO ts_credit_user VALUES ('34','34','239','40');
INSERT INTO ts_credit_user VALUES ('35','35','244','45');
INSERT INTO ts_credit_user VALUES ('36','36','242','43');
INSERT INTO ts_credit_user VALUES ('37','37','248','49');
INSERT INTO ts_credit_user VALUES ('38','38','248','49');
INSERT INTO ts_credit_user VALUES ('39','39','242','43');
INSERT INTO ts_credit_user VALUES ('40','40','249','50');
INSERT INTO ts_credit_user VALUES ('41','41','245','46');
INSERT INTO ts_credit_user VALUES ('42','42','243','45');
INSERT INTO ts_credit_user VALUES ('43','43','244','46');
INSERT INTO ts_credit_user VALUES ('44','44','243','44');
INSERT INTO ts_credit_user VALUES ('45','45','268','72');
INSERT INTO ts_credit_user VALUES ('46','46','264','68');
INSERT INTO ts_credit_user VALUES ('47','47','270','74');
INSERT INTO ts_credit_user VALUES ('48','48','269','73');
INSERT INTO ts_credit_user VALUES ('49','49','284','88');
INSERT INTO ts_credit_user VALUES ('50','50','280','82');
INSERT INTO ts_credit_user VALUES ('51','51','259','63');
INSERT INTO ts_credit_user VALUES ('52','52','269','73');
INSERT INTO ts_credit_user VALUES ('53','53','257','61');
INSERT INTO ts_credit_user VALUES ('54','56','266','70');
INSERT INTO ts_credit_user VALUES ('55','57','250','52');
INSERT INTO ts_credit_user VALUES ('56','58','285','91');
INSERT INTO ts_credit_user VALUES ('57','59','213','14');
INSERT INTO ts_credit_user VALUES ('58','55','23','23');
INSERT INTO ts_credit_user VALUES ('60','60','219','19');
INSERT INTO ts_credit_user VALUES ('61','61','209','9');
INSERT INTO ts_credit_user VALUES ('62','62','225','25');
INSERT INTO ts_credit_user VALUES ('63','63','222','22');
INSERT INTO ts_credit_user VALUES ('64','64','287','90');
INSERT INTO ts_credit_user VALUES ('65','192','224','25');
INSERT INTO ts_credit_user VALUES ('66','65','236','36');
INSERT INTO ts_credit_user VALUES ('67','66','241','42');
INSERT INTO ts_credit_user VALUES ('68','67','285','89');
INSERT INTO ts_credit_user VALUES ('69','68','229','29');
INSERT INTO ts_credit_user VALUES ('70','69','241','41');
INSERT INTO ts_credit_user VALUES ('71','70','245','47');
INSERT INTO ts_credit_user VALUES ('72','71','208','8');
INSERT INTO ts_credit_user VALUES ('73','72','220','20');
INSERT INTO ts_credit_user VALUES ('75','74','210','10');
INSERT INTO ts_credit_user VALUES ('76','75','230','30');
INSERT INTO ts_credit_user VALUES ('77','76','239','40');
INSERT INTO ts_credit_user VALUES ('78','77','209','9');
INSERT INTO ts_credit_user VALUES ('79','78','210','10');
INSERT INTO ts_credit_user VALUES ('80','79','243','45');
INSERT INTO ts_credit_user VALUES ('81','80','210','10');
INSERT INTO ts_credit_user VALUES ('83','82','210','10');
INSERT INTO ts_credit_user VALUES ('84','83','220','20');
INSERT INTO ts_credit_user VALUES ('85','84','244','45');
INSERT INTO ts_credit_user VALUES ('86','85','285','90');
INSERT INTO ts_credit_user VALUES ('87','86','398','201');
INSERT INTO ts_credit_user VALUES ('88','87','255','56');
INSERT INTO ts_credit_user VALUES ('89','90','209','9');
INSERT INTO ts_credit_user VALUES ('90','91','209','9');
INSERT INTO ts_credit_user VALUES ('91','89','43','43');
INSERT INTO ts_credit_user VALUES ('92','92','215','15');
INSERT INTO ts_credit_user VALUES ('93','233','246','52');
INSERT INTO ts_credit_user VALUES ('94','93','232','32');
INSERT INTO ts_credit_user VALUES ('95','94','218','18');
INSERT INTO ts_credit_user VALUES ('96','95','219','19');
INSERT INTO ts_credit_user VALUES ('97','96','226','26');
INSERT INTO ts_credit_user VALUES ('98','97','215','15');
INSERT INTO ts_credit_user VALUES ('99','98','235','36');
INSERT INTO ts_credit_user VALUES ('100','102','226','26');
INSERT INTO ts_credit_user VALUES ('101','99','235','35');
INSERT INTO ts_credit_user VALUES ('102','100','224','24');
INSERT INTO ts_credit_user VALUES ('103','103','278','79');
INSERT INTO ts_credit_user VALUES ('104','101','239','39');
INSERT INTO ts_credit_user VALUES ('105','104','227','27');
INSERT INTO ts_credit_user VALUES ('107','105','232','32');
INSERT INTO ts_credit_user VALUES ('108','106','220','20');
INSERT INTO ts_credit_user VALUES ('109','107','219','19');
INSERT INTO ts_credit_user VALUES ('110','109','225','25');
INSERT INTO ts_credit_user VALUES ('112','111','218','18');
INSERT INTO ts_credit_user VALUES ('113','112','241','41');
INSERT INTO ts_credit_user VALUES ('114','272','201','5');
INSERT INTO ts_credit_user VALUES ('115','349','217','18');
INSERT INTO ts_credit_user VALUES ('116','113','208','8');
INSERT INTO ts_credit_user VALUES ('117','114','261','63');
INSERT INTO ts_credit_user VALUES ('118','115','255','56');
INSERT INTO ts_credit_user VALUES ('120','117','225','25');
INSERT INTO ts_credit_user VALUES ('121','118','219','19');
INSERT INTO ts_credit_user VALUES ('122','122','228','28');
INSERT INTO ts_credit_user VALUES ('123','119','219','19');
INSERT INTO ts_credit_user VALUES ('124','120','250','51');
INSERT INTO ts_credit_user VALUES ('125','121','228','28');
INSERT INTO ts_credit_user VALUES ('126','123','255','56');
INSERT INTO ts_credit_user VALUES ('127','205','219','19');
INSERT INTO ts_credit_user VALUES ('128','124','225','25');
INSERT INTO ts_credit_user VALUES ('130','126','375','189');
INSERT INTO ts_credit_user VALUES ('132','127','237','39');
INSERT INTO ts_credit_user VALUES ('133','128','218','18');
INSERT INTO ts_credit_user VALUES ('134','129','224','24');
INSERT INTO ts_credit_user VALUES ('135','130','224','24');
INSERT INTO ts_credit_user VALUES ('136','131','224','24');
INSERT INTO ts_credit_user VALUES ('137','132','224','24');
INSERT INTO ts_credit_user VALUES ('138','134','226','26');
INSERT INTO ts_credit_user VALUES ('139','135','227','27');
INSERT INTO ts_credit_user VALUES ('140','397','217','19');
INSERT INTO ts_credit_user VALUES ('141','136','229','29');
INSERT INTO ts_credit_user VALUES ('142','137','223','23');
INSERT INTO ts_credit_user VALUES ('143','138','234','36');
INSERT INTO ts_credit_user VALUES ('144','139','218','18');
INSERT INTO ts_credit_user VALUES ('145','140','228','28');
INSERT INTO ts_credit_user VALUES ('146','141','237','38');
INSERT INTO ts_credit_user VALUES ('147','142','228','29');
INSERT INTO ts_credit_user VALUES ('148','403','217','18');
INSERT INTO ts_credit_user VALUES ('149','143','225','25');
INSERT INTO ts_credit_user VALUES ('150','144','234','35');
INSERT INTO ts_credit_user VALUES ('151','145','234','34');
INSERT INTO ts_credit_user VALUES ('152','146','223','23');
INSERT INTO ts_credit_user VALUES ('153','147','228','28');
INSERT INTO ts_credit_user VALUES ('154','148','223','23');
INSERT INTO ts_credit_user VALUES ('155','149','224','24');
INSERT INTO ts_credit_user VALUES ('156','88','39','39');
INSERT INTO ts_credit_user VALUES ('157','150','238','39');
INSERT INTO ts_credit_user VALUES ('158','151','227','28');
INSERT INTO ts_credit_user VALUES ('159','152','236','40');
INSERT INTO ts_credit_user VALUES ('160','153','239','40');
INSERT INTO ts_credit_user VALUES ('161','154','227','29');
INSERT INTO ts_credit_user VALUES ('163','156','225','25');
INSERT INTO ts_credit_user VALUES ('164','157','229','30');
INSERT INTO ts_credit_user VALUES ('165','158','255','58');
INSERT INTO ts_credit_user VALUES ('166','159','251','52');
INSERT INTO ts_credit_user VALUES ('167','160','219','19');
INSERT INTO ts_credit_user VALUES ('168','435','246','47');
INSERT INTO ts_credit_user VALUES ('169','161','218','18');
INSERT INTO ts_credit_user VALUES ('170','162','208','8');
INSERT INTO ts_credit_user VALUES ('171','163','241','43');
INSERT INTO ts_credit_user VALUES ('172','164','225','26');
INSERT INTO ts_credit_user VALUES ('173','165','223','23');
INSERT INTO ts_credit_user VALUES ('174','231','625','25');
INSERT INTO ts_credit_user VALUES ('175','166','208','8');
INSERT INTO ts_credit_user VALUES ('176','167','247','48');
INSERT INTO ts_credit_user VALUES ('177','168','227','27');
INSERT INTO ts_credit_user VALUES ('178','169','257','59');
INSERT INTO ts_credit_user VALUES ('179','451','209','9');
INSERT INTO ts_credit_user VALUES ('180','171','215','15');
INSERT INTO ts_credit_user VALUES ('181','172','229','30');
INSERT INTO ts_credit_user VALUES ('182','462','33','36');
INSERT INTO ts_credit_user VALUES ('183','173','216','16');
INSERT INTO ts_credit_user VALUES ('184','174','235','35');
INSERT INTO ts_credit_user VALUES ('185','175','227','27');
INSERT INTO ts_credit_user VALUES ('186','176','220','20');
INSERT INTO ts_credit_user VALUES ('187','177','221','22');
INSERT INTO ts_credit_user VALUES ('188','178','218','18');
INSERT INTO ts_credit_user VALUES ('189','464','26','27');
INSERT INTO ts_credit_user VALUES ('190','179','216','16');
INSERT INTO ts_credit_user VALUES ('191','180','217','17');
INSERT INTO ts_credit_user VALUES ('192','181','255','57');
INSERT INTO ts_credit_user VALUES ('193','182','228','28');
INSERT INTO ts_credit_user VALUES ('194','183','217','17');
INSERT INTO ts_credit_user VALUES ('195','184','223','23');
INSERT INTO ts_credit_user VALUES ('196','185','250','53');
INSERT INTO ts_credit_user VALUES ('198','187','227','28');
INSERT INTO ts_credit_user VALUES ('199','188','211','15');
INSERT INTO ts_credit_user VALUES ('201','190','225','25');
INSERT INTO ts_credit_user VALUES ('202','191','259','69');
INSERT INTO ts_credit_user VALUES ('203','193','251','53');
INSERT INTO ts_credit_user VALUES ('204','481','26','27');
INSERT INTO ts_credit_user VALUES ('205','195','228','29');
INSERT INTO ts_credit_user VALUES ('206','196','216','16');
INSERT INTO ts_credit_user VALUES ('207','197','216','16');
INSERT INTO ts_credit_user VALUES ('208','486','15','15');
INSERT INTO ts_credit_user VALUES ('209','198','224','24');
INSERT INTO ts_credit_user VALUES ('210','199','223','23');
INSERT INTO ts_credit_user VALUES ('211','200','239','43');
INSERT INTO ts_credit_user VALUES ('212','201','219','20');
INSERT INTO ts_credit_user VALUES ('213','202','226','26');
INSERT INTO ts_credit_user VALUES ('214','203','220','20');
INSERT INTO ts_credit_user VALUES ('215','170','29','30');
INSERT INTO ts_credit_user VALUES ('216','204','230','35');
INSERT INTO ts_credit_user VALUES ('217','206','217','17');
INSERT INTO ts_credit_user VALUES ('218','207','216','16');
INSERT INTO ts_credit_user VALUES ('219','208','228','28');
INSERT INTO ts_credit_user VALUES ('220','209','233','35');
INSERT INTO ts_credit_user VALUES ('221','210','226','26');
INSERT INTO ts_credit_user VALUES ('222','211','221','21');
INSERT INTO ts_credit_user VALUES ('223','212','236','40');
INSERT INTO ts_credit_user VALUES ('224','213','218','18');
INSERT INTO ts_credit_user VALUES ('225','214','216','16');
INSERT INTO ts_credit_user VALUES ('226','133','41','41');
INSERT INTO ts_credit_user VALUES ('227','215','225','25');
INSERT INTO ts_credit_user VALUES ('228','217','235','35');
INSERT INTO ts_credit_user VALUES ('229','218','225','25');
INSERT INTO ts_credit_user VALUES ('230','219','222','22');
INSERT INTO ts_credit_user VALUES ('231','220','218','18');
INSERT INTO ts_credit_user VALUES ('232','221','215','15');
INSERT INTO ts_credit_user VALUES ('233','222','215','15');
INSERT INTO ts_credit_user VALUES ('234','223','452','52');
INSERT INTO ts_credit_user VALUES ('235','525','10','11');
INSERT INTO ts_credit_user VALUES ('236','224','461','64');
INSERT INTO ts_credit_user VALUES ('237','225','434','42');
INSERT INTO ts_credit_user VALUES ('239','155556','10','10');
INSERT INTO ts_credit_user VALUES ('240','226','200','0');
INSERT INTO ts_credit_user VALUES ('241','227','212','19');
INSERT INTO ts_credit_user VALUES ('242','228','238','45');
INSERT INTO ts_credit_user VALUES ('243','229','253','58');
INSERT INTO ts_credit_user VALUES ('244','230','219','20');
INSERT INTO ts_credit_user VALUES ('245','232','400','0');
INSERT INTO ts_credit_user VALUES ('246','234','199','0');
INSERT INTO ts_credit_user VALUES ('247','235','210','10');
INSERT INTO ts_credit_user VALUES ('248','236','207','9');
INSERT INTO ts_credit_user VALUES ('249','237','223','23');
INSERT INTO ts_credit_user VALUES ('250','238','200','0');
INSERT INTO ts_credit_user VALUES ('251','239','205','6');
INSERT INTO ts_credit_user VALUES ('252','240','200','0');
INSERT INTO ts_credit_user VALUES ('253','241','200','0');
INSERT INTO ts_credit_user VALUES ('254','242','224','31');
INSERT INTO ts_credit_user VALUES ('255','243','201','1');
INSERT INTO ts_credit_user VALUES ('256','244','220','25');
INSERT INTO ts_credit_user VALUES ('257','245','228','37');
INSERT INTO ts_credit_user VALUES ('258','246','213','13');
INSERT INTO ts_credit_user VALUES ('259','247','224','34');
INSERT INTO ts_credit_user VALUES ('260','248','201','1');
INSERT INTO ts_credit_user VALUES ('261','249','207','7');
INSERT INTO ts_credit_user VALUES ('262','250','207','10');
INSERT INTO ts_credit_user VALUES ('263','251','214','15');
INSERT INTO ts_credit_user VALUES ('264','252','213','13');
INSERT INTO ts_credit_user VALUES ('265','253','206','7');
INSERT INTO ts_credit_user VALUES ('266','254','200','0');
INSERT INTO ts_credit_user VALUES ('267','255','200','0');
INSERT INTO ts_credit_user VALUES ('268','256','200','0');
INSERT INTO ts_credit_user VALUES ('269','257','205','9');
INSERT INTO ts_credit_user VALUES ('270','258','200','0');
INSERT INTO ts_credit_user VALUES ('271','259','220','21');
INSERT INTO ts_credit_user VALUES ('272','260','200','0');
INSERT INTO ts_credit_user VALUES ('273','261','212','13');
INSERT INTO ts_credit_user VALUES ('274','262','200','0');
INSERT INTO ts_credit_user VALUES ('275','263','218','19');
INSERT INTO ts_credit_user VALUES ('276','264','200','0');
INSERT INTO ts_credit_user VALUES ('277','265','200','0');
INSERT INTO ts_credit_user VALUES ('278','266','203','5');
INSERT INTO ts_credit_user VALUES ('279','267','206','6');
INSERT INTO ts_credit_user VALUES ('280','268','212','13');
INSERT INTO ts_credit_user VALUES ('281','269','200','0');
INSERT INTO ts_credit_user VALUES ('282','270','210','10');
INSERT INTO ts_credit_user VALUES ('283','271','210','10');
INSERT INTO ts_credit_user VALUES ('284','273','201','1');
INSERT INTO ts_credit_user VALUES ('285','274','210','10');
INSERT INTO ts_credit_user VALUES ('286','275','200','0');
INSERT INTO ts_credit_user VALUES ('287','276','200','0');
INSERT INTO ts_credit_user VALUES ('288','277','200','0');
INSERT INTO ts_credit_user VALUES ('289','278','200','0');
INSERT INTO ts_credit_user VALUES ('290','279','200','0');
INSERT INTO ts_credit_user VALUES ('292','281','200','0');
INSERT INTO ts_credit_user VALUES ('293','282','210','10');
INSERT INTO ts_credit_user VALUES ('294','283','200','0');
INSERT INTO ts_credit_user VALUES ('295','284','200','0');
INSERT INTO ts_credit_user VALUES ('296','285','200','0');
INSERT INTO ts_credit_user VALUES ('297','286','200','0');
INSERT INTO ts_credit_user VALUES ('298','287','202','2');
INSERT INTO ts_credit_user VALUES ('299','288','200','0');
INSERT INTO ts_credit_user VALUES ('300','289','210','11');
INSERT INTO ts_credit_user VALUES ('301','290','212','14');
INSERT INTO ts_credit_user VALUES ('302','291','200','0');
INSERT INTO ts_credit_user VALUES ('303','292','206','6');
INSERT INTO ts_credit_user VALUES ('304','293','200','0');
INSERT INTO ts_credit_user VALUES ('305','294','200','0');
INSERT INTO ts_credit_user VALUES ('306','295','205','7');
INSERT INTO ts_credit_user VALUES ('307','296','205','5');
INSERT INTO ts_credit_user VALUES ('308','297','200','0');
INSERT INTO ts_credit_user VALUES ('309','298','200','0');
INSERT INTO ts_credit_user VALUES ('310','299','203','3');
INSERT INTO ts_credit_user VALUES ('311','300','201','2');
INSERT INTO ts_credit_user VALUES ('312','301','200','0');
INSERT INTO ts_credit_user VALUES ('313','302','200','0');
INSERT INTO ts_credit_user VALUES ('314','303','200','0');
INSERT INTO ts_credit_user VALUES ('315','304','216','21');
INSERT INTO ts_credit_user VALUES ('316','305','200','0');
INSERT INTO ts_credit_user VALUES ('317','306','200','0');
INSERT INTO ts_credit_user VALUES ('318','307','200','0');
INSERT INTO ts_credit_user VALUES ('319','308','211','12');
INSERT INTO ts_credit_user VALUES ('320','309','210','10');
INSERT INTO ts_credit_user VALUES ('321','310','200','0');
INSERT INTO ts_credit_user VALUES ('322','311','210','13');
INSERT INTO ts_credit_user VALUES ('323','312','200','0');
INSERT INTO ts_credit_user VALUES ('324','313','200','0');
INSERT INTO ts_credit_user VALUES ('325','314','200','0');
INSERT INTO ts_credit_user VALUES ('326','315','200','0');
INSERT INTO ts_credit_user VALUES ('327','316','200','0');
INSERT INTO ts_credit_user VALUES ('328','317','200','0');
INSERT INTO ts_credit_user VALUES ('329','318','200','0');
INSERT INTO ts_credit_user VALUES ('330','319','210','11');
INSERT INTO ts_credit_user VALUES ('331','320','221','29');
INSERT INTO ts_credit_user VALUES ('332','321','207','10');
INSERT INTO ts_credit_user VALUES ('333','322','200','0');
INSERT INTO ts_credit_user VALUES ('334','323','201','2');
INSERT INTO ts_credit_user VALUES ('335','324','200','0');
INSERT INTO ts_credit_user VALUES ('336','325','200','0');
INSERT INTO ts_credit_user VALUES ('337','326','222','30');
INSERT INTO ts_credit_user VALUES ('338','327','205','5');
INSERT INTO ts_credit_user VALUES ('339','328','210','10');
INSERT INTO ts_credit_user VALUES ('340','329','200','0');
INSERT INTO ts_credit_user VALUES ('341','330','200','0');
INSERT INTO ts_credit_user VALUES ('343','332','200','0');
INSERT INTO ts_credit_user VALUES ('344','333','210','10');
INSERT INTO ts_credit_user VALUES ('345','334','200','0');
INSERT INTO ts_credit_user VALUES ('346','335','200','0');
INSERT INTO ts_credit_user VALUES ('347','336','200','0');
INSERT INTO ts_credit_user VALUES ('348','337','200','0');
INSERT INTO ts_credit_user VALUES ('349','338','200','0');
INSERT INTO ts_credit_user VALUES ('350','339','200','0');
INSERT INTO ts_credit_user VALUES ('351','341','205','5');
INSERT INTO ts_credit_user VALUES ('352','342','200','0');
INSERT INTO ts_credit_user VALUES ('353','343','202','3');
INSERT INTO ts_credit_user VALUES ('354','344','200','0');
INSERT INTO ts_credit_user VALUES ('355','345','205','5');
INSERT INTO ts_credit_user VALUES ('356','346','200','0');
INSERT INTO ts_credit_user VALUES ('357','347','201','1');
INSERT INTO ts_credit_user VALUES ('358','348','200','0');
INSERT INTO ts_credit_user VALUES ('359','350','200','0');
INSERT INTO ts_credit_user VALUES ('360','351','200','0');
INSERT INTO ts_credit_user VALUES ('361','353','200','0');
INSERT INTO ts_credit_user VALUES ('362','352','200','0');
INSERT INTO ts_credit_user VALUES ('363','354','200','0');
INSERT INTO ts_credit_user VALUES ('364','355','200','0');
INSERT INTO ts_credit_user VALUES ('365','356','200','0');
INSERT INTO ts_credit_user VALUES ('366','357','211','11');
INSERT INTO ts_credit_user VALUES ('367','358','201','2');
INSERT INTO ts_credit_user VALUES ('368','359','200','0');
INSERT INTO ts_credit_user VALUES ('369','360','200','0');
INSERT INTO ts_credit_user VALUES ('370','361','200','0');
INSERT INTO ts_credit_user VALUES ('371','362','205','5');
INSERT INTO ts_credit_user VALUES ('372','363','209','12');
INSERT INTO ts_credit_user VALUES ('373','364','200','2');
INSERT INTO ts_credit_user VALUES ('374','365','216','16');
INSERT INTO ts_credit_user VALUES ('375','366','211','11');
INSERT INTO ts_credit_user VALUES ('376','367','200','0');
INSERT INTO ts_credit_user VALUES ('377','368','201','1');
INSERT INTO ts_credit_user VALUES ('378','369','200','0');
INSERT INTO ts_credit_user VALUES ('379','370','200','0');
INSERT INTO ts_credit_user VALUES ('380','371','201','2');
INSERT INTO ts_credit_user VALUES ('381','372','200','0');
INSERT INTO ts_credit_user VALUES ('382','373','209','11');
INSERT INTO ts_credit_user VALUES ('383','374','200','0');
INSERT INTO ts_credit_user VALUES ('384','375','200','0');
INSERT INTO ts_credit_user VALUES ('385','376','200','0');
INSERT INTO ts_credit_user VALUES ('386','377','200','0');
INSERT INTO ts_credit_user VALUES ('387','378','201','2');
INSERT INTO ts_credit_user VALUES ('388','379','200','0');
INSERT INTO ts_credit_user VALUES ('389','380','207','7');
INSERT INTO ts_credit_user VALUES ('390','381','210','10');
INSERT INTO ts_credit_user VALUES ('391','382','201','1');
INSERT INTO ts_credit_user VALUES ('392','383','200','0');
INSERT INTO ts_credit_user VALUES ('393','385','205','5');
INSERT INTO ts_credit_user VALUES ('394','386','200','0');
INSERT INTO ts_credit_user VALUES ('395','387','200','0');
INSERT INTO ts_credit_user VALUES ('396','388','200','0');
INSERT INTO ts_credit_user VALUES ('397','389','200','0');
INSERT INTO ts_credit_user VALUES ('398','390','200','0');
INSERT INTO ts_credit_user VALUES ('399','391','210','10');
INSERT INTO ts_credit_user VALUES ('400','392','200','0');
INSERT INTO ts_credit_user VALUES ('401','393','200','0');
INSERT INTO ts_credit_user VALUES ('402','394','200','0');
INSERT INTO ts_credit_user VALUES ('403','395','201','2');
INSERT INTO ts_credit_user VALUES ('404','396','200','0');
INSERT INTO ts_credit_user VALUES ('405','398','200','0');
INSERT INTO ts_credit_user VALUES ('406','400','200','0');
INSERT INTO ts_credit_user VALUES ('407','401','206','9');
INSERT INTO ts_credit_user VALUES ('408','402','201','2');
INSERT INTO ts_credit_user VALUES ('409','404','206','7');
INSERT INTO ts_credit_user VALUES ('410','405','202','9');
INSERT INTO ts_credit_user VALUES ('411','406','210','10');
INSERT INTO ts_credit_user VALUES ('412','407','200','0');
INSERT INTO ts_credit_user VALUES ('413','411','200','0');
INSERT INTO ts_credit_user VALUES ('414','412','201','1');
INSERT INTO ts_credit_user VALUES ('415','413','200','0');
INSERT INTO ts_credit_user VALUES ('416','414','207','8');
INSERT INTO ts_credit_user VALUES ('417','415','206','6');
INSERT INTO ts_credit_user VALUES ('418','416','210','10');
INSERT INTO ts_credit_user VALUES ('419','417','200','0');
INSERT INTO ts_credit_user VALUES ('420','418','200','0');
INSERT INTO ts_credit_user VALUES ('421','419','200','0');
INSERT INTO ts_credit_user VALUES ('422','420','200','0');
INSERT INTO ts_credit_user VALUES ('423','421','206','7');
INSERT INTO ts_credit_user VALUES ('424','422','208','12');
INSERT INTO ts_credit_user VALUES ('425','423','200','0');
INSERT INTO ts_credit_user VALUES ('426','424','212','12');
INSERT INTO ts_credit_user VALUES ('427','425','200','0');
INSERT INTO ts_credit_user VALUES ('428','426','208','9');
INSERT INTO ts_credit_user VALUES ('429','427','205','5');
INSERT INTO ts_credit_user VALUES ('430','428','200','0');
INSERT INTO ts_credit_user VALUES ('431','429','200','0');
INSERT INTO ts_credit_user VALUES ('432','430','200','0');
INSERT INTO ts_credit_user VALUES ('433','431','200','0');
INSERT INTO ts_credit_user VALUES ('435','433','210','10');
INSERT INTO ts_credit_user VALUES ('436','434','210','10');
INSERT INTO ts_credit_user VALUES ('437','436','200','0');
INSERT INTO ts_credit_user VALUES ('438','437','211','12');
INSERT INTO ts_credit_user VALUES ('439','438','200','0');
INSERT INTO ts_credit_user VALUES ('440','439','216','16');
INSERT INTO ts_credit_user VALUES ('441','440','200','0');
INSERT INTO ts_credit_user VALUES ('442','441','210','10');
INSERT INTO ts_credit_user VALUES ('443','442','202','4');
INSERT INTO ts_credit_user VALUES ('444','443','200','0');
INSERT INTO ts_credit_user VALUES ('445','444','203','4');
INSERT INTO ts_credit_user VALUES ('446','445','210','14');
INSERT INTO ts_credit_user VALUES ('447','446','210','10');
INSERT INTO ts_credit_user VALUES ('448','447','200','0');
INSERT INTO ts_credit_user VALUES ('449','448','200','0');
INSERT INTO ts_credit_user VALUES ('450','449','202','3');
INSERT INTO ts_credit_user VALUES ('451','4','-1','-1');
INSERT INTO ts_credit_user VALUES ('452','450','202','2');
INSERT INTO ts_credit_user VALUES ('453','452','209','10');
INSERT INTO ts_credit_user VALUES ('454','453','212','12');
INSERT INTO ts_credit_user VALUES ('455','454','212','15');
INSERT INTO ts_credit_user VALUES ('456','455','201','2');
INSERT INTO ts_credit_user VALUES ('457','456','201','1');
INSERT INTO ts_credit_user VALUES ('458','13','-4','-4');
INSERT INTO ts_credit_user VALUES ('459','125','-1','-1');
INSERT INTO ts_credit_user VALUES ('460','3','-1','-1');
INSERT INTO ts_credit_user VALUES ('461','5','-2','-2');
INSERT INTO ts_credit_user VALUES ('462','12','-1','-1');
INSERT INTO ts_credit_user VALUES ('463','457','200','0');
INSERT INTO ts_credit_user VALUES ('464','458','201','2');

DROP TABLE IF EXISTS ts_daren;
CREATE TABLE `ts_daren` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `darenid` varchar(255) NOT NULL,
  `dateline` char(20) NOT NULL,
  `darenuid` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=505 DEFAULT CHARSET=utf8;

INSERT INTO ts_daren VALUES ('497','1','1396','1331177675','340');
INSERT INTO ts_daren VALUES ('498','1','1395','1331177713','340');
INSERT INTO ts_daren VALUES ('500','1','1348','1331177816','2');
INSERT INTO ts_daren VALUES ('501','1','1532','1333933432','1');
INSERT INTO ts_daren VALUES ('504','1','2149','1334671526','1');
INSERT INTO ts_daren VALUES ('503','1','1863','1334545485','2');

DROP TABLE IF EXISTS ts_denounce;
CREATE TABLE `ts_denounce` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `from` varchar(255) NOT NULL COMMENT '目前存入各个应用的名称，比如blog,weibo，说明举报的是不同应用下的内容',
  `aid` int(11) NOT NULL COMMENT '记录内容表的主键ID',
  `state` tinyint(4) NOT NULL COMMENT '记录状态，0，默认，表示刚举报；1，表示已删除；2，表示已经通过可以正常显示；',
  `uid` int(11) NOT NULL COMMENT '记录举报人的UID',
  `fuid` int(11) NOT NULL COMMENT '记录被举报人UID',
  `reason` text NOT NULL COMMENT '举报理由',
  `content` varchar(255) NOT NULL,
  `ctime` int(11) NOT NULL COMMENT '记录举报的时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO ts_denounce VALUES ('1','weibo','353','1','126','1','测试的，','【商城大促】Molyda正品2011热卖夏装 韩国丝雪纺连衣裙C2443','1314775336');
INSERT INTO ts_denounce VALUES ('2','weibo','1493','1','1','395','','vcruan 出口欧洲针织棉小西装 两色入 不一样包退(现货)-淘宝网','1333387628');

DROP TABLE IF EXISTS ts_document;
CREATE TABLE `ts_document` (
  `document_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text,
  `author_id` int(11) DEFAULT NULL,
  `last_editor_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_on_footer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否在页脚显示',
  `ctime` int(11) DEFAULT NULL,
  `mtime` int(11) DEFAULT NULL,
  `display_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`document_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO ts_document VALUES ('1','关于我们','<p>本程序是在开源程序基础上进行二次开发，仿美丽说，蘑菇街程序，微博 + sns +淘宝客模式，盈利方向清晰。</p><p>&nbsp;</p><p>使用php+mysql 架构，LAMP架构完美使用。</p><p>&nbsp;</p><p>非常方便进行二次开发。</p><p>&nbsp;</p>','4','1','1','1','1292213500','1310229087','1');
INSERT INTO ts_document VALUES ('2','联系我们','&lt;p&gt;联系我们&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;','4','1','1','1','1292213562','1330154864','2');

DROP TABLE IF EXISTS ts_event;
CREATE TABLE `ts_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `title` text NOT NULL,
  `explain` text NOT NULL,
  `contact` varchar(32) NOT NULL,
  `type` tinyint(4) NOT NULL,
  `sTime` int(11) DEFAULT NULL,
  `eTime` int(11) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `cTime` int(11) NOT NULL,
  `deadline` int(11) NOT NULL,
  `joinCount` int(11) NOT NULL DEFAULT '0',
  `attentionCount` int(11) NOT NULL DEFAULT '0',
  `limitCount` int(11) NOT NULL DEFAULT '0',
  `commentCount` int(11) NOT NULL DEFAULT '0',
  `coverId` int(11) NOT NULL DEFAULT '0',
  `optsId` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ts_event VALUES ('1','1','张学友演唱会','<p>张学友演唱会欢迎参加！张学友演唱会欢迎参加！</p>','张小姐，13466658978','1','1322719392','1323065006','中山体育馆','1322719451','1322892209','0','0','999999999','0','0','1');

DROP TABLE IF EXISTS ts_event_opts;
CREATE TABLE `ts_event_opts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost` char(10) NOT NULL DEFAULT '0',
  `costExplain` varchar(255) DEFAULT '0',
  `province` char(10) DEFAULT NULL,
  `city` char(10) DEFAULT NULL,
  `area` varchar(10) DEFAULT NULL,
  `opts` varchar(50) NOT NULL DEFAULT '0',
  `isHot` tinyint(1) NOT NULL DEFAULT '0',
  `rTime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ts_event_opts VALUES ('1','4','价高者得','广东','中山市','','a:2:{s:6:\"friend\";i:0;s:5:\"allow\";i:0;}','0','0');

DROP TABLE IF EXISTS ts_event_photo;
CREATE TABLE `ts_event_photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eventId` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `filepath` varchar(255) NOT NULL,
  `savename` varchar(255) NOT NULL,
  `aid` int(11) NOT NULL,
  `cTime` int(11) NOT NULL,
  `commentCount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_event_type;
CREATE TABLE `ts_event_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO ts_event_type VALUES ('1','音乐/演出');
INSERT INTO ts_event_type VALUES ('2','展览');
INSERT INTO ts_event_type VALUES ('3','电影');
INSERT INTO ts_event_type VALUES ('4','讲座/沙龙');
INSERT INTO ts_event_type VALUES ('5','戏剧/曲艺');
INSERT INTO ts_event_type VALUES ('8','体育');
INSERT INTO ts_event_type VALUES ('9','旅行');
INSERT INTO ts_event_type VALUES ('10','公益');
INSERT INTO ts_event_type VALUES ('11','其它');

DROP TABLE IF EXISTS ts_event_user;
CREATE TABLE `ts_event_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eventId` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `contact` text,
  `action` char(10) NOT NULL DEFAULT 'attention',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `cTime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ts_event_user VALUES ('1','1','1','张小姐，13466658978','admin','1','1322719451');

DROP TABLE IF EXISTS ts_expression;
CREATE TABLE `ts_expression` (
  `expression_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'miniblog',
  `emotion` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  PRIMARY KEY (`expression_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO ts_expression VALUES ('1','拥抱','miniblog','[拥抱]','hug.gif');
INSERT INTO ts_expression VALUES ('2','示爱','miniblog','[示爱]','kiss.gif');
INSERT INTO ts_expression VALUES ('3','呲牙','miniblog','[呲牙]','lol.gif');
INSERT INTO ts_expression VALUES ('4','可爱','miniblog','[可爱]','loveliness.gif');
INSERT INTO ts_expression VALUES ('5','折磨','miniblog','[折磨]','mad.gif');
INSERT INTO ts_expression VALUES ('6','难过','miniblog','[难过]','sad.gif');
INSERT INTO ts_expression VALUES ('7','流汗','miniblog','[流汗]','sweat.gif');
INSERT INTO ts_expression VALUES ('8','憨笑','miniblog','[憨笑]','biggrin.gif');
INSERT INTO ts_expression VALUES ('9','大哭','miniblog','[大哭]','cry.gif');
INSERT INTO ts_expression VALUES ('10','惊恐','miniblog','[惊恐]','funk.gif');
INSERT INTO ts_expression VALUES ('11','握手','miniblog','[握手]','handshake.gif');
INSERT INTO ts_expression VALUES ('12','发怒','miniblog','[发怒]','huffy.gif');
INSERT INTO ts_expression VALUES ('13','惊讶','miniblog','[惊讶]','shocked.gif');
INSERT INTO ts_expression VALUES ('14','害羞','miniblog','[害羞]','shy.gif');
INSERT INTO ts_expression VALUES ('15','微笑','miniblog','[微笑]','smile.gif');
INSERT INTO ts_expression VALUES ('16','偷笑','miniblog','[偷笑]','titter.gif');
INSERT INTO ts_expression VALUES ('17','调皮','miniblog','[调皮]','tongue.gif');
INSERT INTO ts_expression VALUES ('18','胜利','miniblog','[胜利]','victory.gif');

DROP TABLE IF EXISTS ts_fav;
CREATE TABLE `ts_fav` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `favid` varchar(255) NOT NULL,
  `dateline` char(20) NOT NULL,
  `favuid` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=929 DEFAULT CHARSET=utf8;

INSERT INTO ts_fav VALUES ('716','229','951','1326296353','1');
INSERT INTO ts_fav VALUES ('717','1','946','1326333376','2');
INSERT INTO ts_fav VALUES ('718','1','975','1326603392','2');
INSERT INTO ts_fav VALUES ('719','233','1017','1328859564','1');
INSERT INTO ts_fav VALUES ('720','235','1021','1328863105','1');
INSERT INTO ts_fav VALUES ('721','235','1024','1328863123','1');
INSERT INTO ts_fav VALUES ('722','235','1010','1328863574','1');
INSERT INTO ts_fav VALUES ('723','235','1016','1328863719','1');
INSERT INTO ts_fav VALUES ('724','2','1004','1329109402','1');
INSERT INTO ts_fav VALUES ('725','2','1065','1329113284','1');
INSERT INTO ts_fav VALUES ('726','249','1128','1329140419','1');
INSERT INTO ts_fav VALUES ('727','251','1013','1329280101','1');
INSERT INTO ts_fav VALUES ('728','252','1129','1329288915','1');
INSERT INTO ts_fav VALUES ('729','252','1002','1329311068','1');
INSERT INTO ts_fav VALUES ('730','254','1129','1329330390','1');
INSERT INTO ts_fav VALUES ('731','259','1083','1329502569','1');
INSERT INTO ts_fav VALUES ('732','2','1081','1329550752','1');
INSERT INTO ts_fav VALUES ('733','257','1097','1329560482','2');
INSERT INTO ts_fav VALUES ('734','261','1048','1329570040','1');
INSERT INTO ts_fav VALUES ('735','261','1129','1329570062','1');
INSERT INTO ts_fav VALUES ('736','259','1168','1329576957','1');
INSERT INTO ts_fav VALUES ('737','259','1167','1329577834','1');
INSERT INTO ts_fav VALUES ('738','233','1168','1329658086','1');
INSERT INTO ts_fav VALUES ('739','233','1119','1329719879','1');
INSERT INTO ts_fav VALUES ('740','233','1098','1329720972','1');
INSERT INTO ts_fav VALUES ('771','2','1124','1330612763','1');
INSERT INTO ts_fav VALUES ('745','233','1145','1329810638','251');
INSERT INTO ts_fav VALUES ('746','233','1150','1329811080','252');
INSERT INTO ts_fav VALUES ('747','2','1145','1329822785','251');
INSERT INTO ts_fav VALUES ('748','2','1186','1329823135','233');
INSERT INTO ts_fav VALUES ('749','272','1171','1329841057','257');
INSERT INTO ts_fav VALUES ('750','233','1046','1329888135','1');
INSERT INTO ts_fav VALUES ('751','233','1124','1329888138','1');
INSERT INTO ts_fav VALUES ('752','244','1224','1329918231','257');
INSERT INTO ts_fav VALUES ('753','244','1223','1329918234','2');
INSERT INTO ts_fav VALUES ('754','2','1100','1329924550','1');
INSERT INTO ts_fav VALUES ('755','2','1066','1329973296','1');
INSERT INTO ts_fav VALUES ('756','277','1218','1330017186','2');
INSERT INTO ts_fav VALUES ('757','277','1221','1330017191','2');
INSERT INTO ts_fav VALUES ('759','2','1239','1330309760','1');
INSERT INTO ts_fav VALUES ('797','343','1234','1331183183','1');
INSERT INTO ts_fav VALUES ('761','288','1187','1330315207','2');
INSERT INTO ts_fav VALUES ('762','295','1110','1330478940','247');
INSERT INTO ts_fav VALUES ('763','233','1243','1330499170','1');
INSERT INTO ts_fav VALUES ('764','2','1244','1330515229','1');
INSERT INTO ts_fav VALUES ('766','300','1286','1330517893','2');
INSERT INTO ts_fav VALUES ('767','300','1275','1330517895','1');
INSERT INTO ts_fav VALUES ('768','2','1048','1330532045','1');
INSERT INTO ts_fav VALUES ('773','2','1113','1330694267','1');
INSERT INTO ts_fav VALUES ('789','233','1348','1331087245','2');
INSERT INTO ts_fav VALUES ('804','2','1402','1331232800','1');
INSERT INTO ts_fav VALUES ('776','320','1260','1330943365','2');
INSERT INTO ts_fav VALUES ('777','320','1087','1330943367','233');
INSERT INTO ts_fav VALUES ('778','320','1233','1330943371','1');
INSERT INTO ts_fav VALUES ('779','320','1234','1330943374','1');
INSERT INTO ts_fav VALUES ('780','320','1237','1330943378','1');
INSERT INTO ts_fav VALUES ('788','233','1357','1331087244','1');
INSERT INTO ts_fav VALUES ('787','233','1358','1331087240','1');
INSERT INTO ts_fav VALUES ('783','242','1346','1331024016','1');
INSERT INTO ts_fav VALUES ('784','242','1325','1331024019','320');
INSERT INTO ts_fav VALUES ('785','242','1352','1331024021','1');
INSERT INTO ts_fav VALUES ('786','242','1323','1331024023','320');
INSERT INTO ts_fav VALUES ('790','233','1346','1331087246','1');
INSERT INTO ts_fav VALUES ('791','233','1352','1331087248','1');
INSERT INTO ts_fav VALUES ('805','235','1238','1331279819','1');
INSERT INTO ts_fav VALUES ('798','347','1348','1331216593','2');
INSERT INTO ts_fav VALUES ('799','347','1312','1331216595','290');
INSERT INTO ts_fav VALUES ('800','347','1375','1331216596','2');
INSERT INTO ts_fav VALUES ('801','347','1380','1331216597','2');
INSERT INTO ts_fav VALUES ('802','347','1087','1331216598','233');
INSERT INTO ts_fav VALUES ('806','361','1292','1331285312','2');
INSERT INTO ts_fav VALUES ('807','367','1378','1331359394','2');
INSERT INTO ts_fav VALUES ('808','2','1422','1331451680','319');
INSERT INTO ts_fav VALUES ('809','373','1453','1331458359','245');
INSERT INTO ts_fav VALUES ('810','373','1456','1331458362','245');
INSERT INTO ts_fav VALUES ('831','2','1383','1332209666','259');
INSERT INTO ts_fav VALUES ('812','242','1443','1331530849','1');
INSERT INTO ts_fav VALUES ('814','2','1393','1331609217','1');
INSERT INTO ts_fav VALUES ('815','2','1372','1331609224','1');
INSERT INTO ts_fav VALUES ('816','386','1466','1331610570','2');
INSERT INTO ts_fav VALUES ('819','237','1126','1331658206','1');
INSERT INTO ts_fav VALUES ('822','348','1365','1331702566','2');
INSERT INTO ts_fav VALUES ('823','235','1122','1331716911','1');
INSERT INTO ts_fav VALUES ('824','402','1484','1331818042','2');
INSERT INTO ts_fav VALUES ('825','2','1084','1331902493','1');
INSERT INTO ts_fav VALUES ('826','2','1309','1331982071','311');
INSERT INTO ts_fav VALUES ('827','420','1526','1332080828','1');
INSERT INTO ts_fav VALUES ('828','2','1238','1332088605','1');
INSERT INTO ts_fav VALUES ('829','416','1554','1332110205','2');
INSERT INTO ts_fav VALUES ('832','363','1404','1332215013','347');
INSERT INTO ts_fav VALUES ('833','363','1239','1332216519','1');
INSERT INTO ts_fav VALUES ('834','2','1575','1332308987','1');
INSERT INTO ts_fav VALUES ('835','434','1532','1332411120','1');
INSERT INTO ts_fav VALUES ('836','2','1018','1332426774','1');
INSERT INTO ts_fav VALUES ('837','444','1608','1332511785','2');
INSERT INTO ts_fav VALUES ('838','444','1599','1332511849','426');
INSERT INTO ts_fav VALUES ('839','444','1610','1332511850','437');
INSERT INTO ts_fav VALUES ('840','444','1541','1332511852','414');
INSERT INTO ts_fav VALUES ('841','444','1500','1332511855','2');
INSERT INTO ts_fav VALUES ('842','444','1481','1332511857','320');
INSERT INTO ts_fav VALUES ('843','444','1458','1332511858','245');
INSERT INTO ts_fav VALUES ('844','444','1553','1332511863','2');
INSERT INTO ts_fav VALUES ('845','444','1611','1332511926','439');
INSERT INTO ts_fav VALUES ('846','444','1595','1332512149','2');
INSERT INTO ts_fav VALUES ('847','444','1516','1332512198','2');
INSERT INTO ts_fav VALUES ('849','2','1570','1332523790','1');
INSERT INTO ts_fav VALUES ('850','2','1009','1332529621','1');
INSERT INTO ts_fav VALUES ('851','444','1625','1332561801','2');
INSERT INTO ts_fav VALUES ('852','1','1487','1333415793','2');
INSERT INTO ts_fav VALUES ('853','1','1463','1333415809','2');
INSERT INTO ts_fav VALUES ('854','1','1267','1333415828','290');
INSERT INTO ts_fav VALUES ('855','1','1608','1333415858','2');
INSERT INTO ts_fav VALUES ('856','1','1550','1333415943','248');
INSERT INTO ts_fav VALUES ('857','2','1577','1333550920','1');
INSERT INTO ts_fav VALUES ('858','31','1829','1334068378','1');
INSERT INTO ts_fav VALUES ('859','31','1827','1334068382','1');
INSERT INTO ts_fav VALUES ('860','31','1826','1334068383','1');
INSERT INTO ts_fav VALUES ('861','31','1825','1334068384','1');
INSERT INTO ts_fav VALUES ('862','31','1824','1334068386','1');
INSERT INTO ts_fav VALUES ('863','31','1821','1334068387','1');
INSERT INTO ts_fav VALUES ('864','31','1823','1334068388','1');
INSERT INTO ts_fav VALUES ('865','31','1822','1334068389','1');
INSERT INTO ts_fav VALUES ('866','31','1820','1334068390','1');
INSERT INTO ts_fav VALUES ('867','31','1794','1334068394','1');
INSERT INTO ts_fav VALUES ('868','31','1796','1334068395','1');
INSERT INTO ts_fav VALUES ('869','31','1793','1334068397','1');
INSERT INTO ts_fav VALUES ('870','31','1792','1334068398','1');
INSERT INTO ts_fav VALUES ('871','31','1789','1334068399','1');
INSERT INTO ts_fav VALUES ('872','31','1752','1334068402','1');
INSERT INTO ts_fav VALUES ('873','31','1668','1334068405','1');
INSERT INTO ts_fav VALUES ('874','31','1667','1334068407','1');
INSERT INTO ts_fav VALUES ('875','31','1790','1334068574','1');
INSERT INTO ts_fav VALUES ('876','31','1800','1334068594','1');
INSERT INTO ts_fav VALUES ('877','31','1804','1334068596','1');
INSERT INTO ts_fav VALUES ('878','31','1803','1334068597','1');
INSERT INTO ts_fav VALUES ('879','31','1802','1334068597','1');
INSERT INTO ts_fav VALUES ('880','31','1805','1334068599','1');
INSERT INTO ts_fav VALUES ('881','31','1808','1334068599','1');
INSERT INTO ts_fav VALUES ('882','31','1801','1334068600','1');
INSERT INTO ts_fav VALUES ('883','31','1809','1334068602','1');
INSERT INTO ts_fav VALUES ('884','31','1815','1334068604','1');
INSERT INTO ts_fav VALUES ('885','31','1818','1334068623','1');
INSERT INTO ts_fav VALUES ('886','31','1819','1334068624','1');
INSERT INTO ts_fav VALUES ('887','31','1817','1334068625','1');
INSERT INTO ts_fav VALUES ('888','31','1810','1334068628','1');
INSERT INTO ts_fav VALUES ('889','31','1814','1334068629','1');
INSERT INTO ts_fav VALUES ('890','31','1799','1334068635','1');
INSERT INTO ts_fav VALUES ('891','31','1795','1334068640','1');
INSERT INTO ts_fav VALUES ('892','31','1785','1334068644','2');
INSERT INTO ts_fav VALUES ('893','31','1783','1334068649','2');
INSERT INTO ts_fav VALUES ('894','31','1781','1334068653','2');
INSERT INTO ts_fav VALUES ('895','31','1782','1334068653','1');
INSERT INTO ts_fav VALUES ('896','31','1778','1334068655','2');
INSERT INTO ts_fav VALUES ('897','31','1776','1334068657','2');
INSERT INTO ts_fav VALUES ('898','31','1777','1334068658','2');
INSERT INTO ts_fav VALUES ('899','31','1768','1334068661','1');
INSERT INTO ts_fav VALUES ('900','31','1765','1334068665','2');
INSERT INTO ts_fav VALUES ('901','31','1766','1334068666','2');
INSERT INTO ts_fav VALUES ('902','31','1762','1334068670','2');
INSERT INTO ts_fav VALUES ('903','31','1759','1334068671','1');
INSERT INTO ts_fav VALUES ('904','31','1758','1334068674','1');
INSERT INTO ts_fav VALUES ('905','31','1760','1334068676','1');
INSERT INTO ts_fav VALUES ('906','31','1753','1334068677','1');
INSERT INTO ts_fav VALUES ('907','31','1749','1334068679','1');
INSERT INTO ts_fav VALUES ('908','31','1751','1334068680','1');
INSERT INTO ts_fav VALUES ('909','31','1754','1334068682','1');
INSERT INTO ts_fav VALUES ('910','31','1748','1334068684','1');
INSERT INTO ts_fav VALUES ('911','31','1746','1334068686','1');
INSERT INTO ts_fav VALUES ('912','31','1743','1334068687','1');
INSERT INTO ts_fav VALUES ('913','31','1745','1334068688','1');
INSERT INTO ts_fav VALUES ('914','31','1744','1334068689','1');
INSERT INTO ts_fav VALUES ('915','31','1747','1334068692','1');
INSERT INTO ts_fav VALUES ('916','31','1739','1334068694','1');
INSERT INTO ts_fav VALUES ('917','31','1741','1334068696','1');
INSERT INTO ts_fav VALUES ('918','31','1737','1334068698','1');
INSERT INTO ts_fav VALUES ('919','31','1733','1334068698','1');
INSERT INTO ts_fav VALUES ('920','31','1731','1334068700','1');
INSERT INTO ts_fav VALUES ('921','31','1726','1334068700','2');
INSERT INTO ts_fav VALUES ('922','31','1729','1334068701','1');
INSERT INTO ts_fav VALUES ('923','31','1725','1334068703','1');
INSERT INTO ts_fav VALUES ('924','31','1715','1334068707','1');
INSERT INTO ts_fav VALUES ('925','31','1711','1334068708','1');
INSERT INTO ts_fav VALUES ('926','31','1706','1334068712','1');
INSERT INTO ts_fav VALUES ('927','31','1710','1334068715','1');
INSERT INTO ts_fav VALUES ('928','31','1709','1334068719','1');

DROP TABLE IF EXISTS ts_feed;
CREATE TABLE `ts_feed` (
  `feed_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `data` text NOT NULL,
  `ctime` int(11) NOT NULL,
  `type` varchar(120) NOT NULL,
  PRIMARY KEY (`feed_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3712 DEFAULT CHARSET=utf8;

INSERT INTO ts_feed VALUES ('3638','1','a:3:{s:3:\"fid\";i:2;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334157645','weibo_follow');
INSERT INTO ts_feed VALUES ('3637','1','a:3:{s:3:\"fid\";i:219;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334155976','weibo_follow');
INSERT INTO ts_feed VALUES ('3636','1','a:3:{s:3:\"fid\";i:220;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334155972','weibo_follow');
INSERT INTO ts_feed VALUES ('3635','1','a:3:{s:3:\"fid\";i:217;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334155969','weibo_follow');
INSERT INTO ts_feed VALUES ('3634','452','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:452;s:4:\"type\";s:12:\"weibo_follow\";}','1334113969','weibo_follow');
INSERT INTO ts_feed VALUES ('3633','1','a:3:{s:3:\"fid\";i:452;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334113969','weibo_follow');
INSERT INTO ts_feed VALUES ('3639','1','a:3:{s:3:\"fid\";i:223;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334157649','weibo_follow');
INSERT INTO ts_feed VALUES ('3640','2','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:2;s:4:\"type\";s:12:\"weibo_follow\";}','1334278616','weibo_follow');
INSERT INTO ts_feed VALUES ('3641','1','a:3:{s:3:\"fid\";i:452;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334282769','weibo_follow');
INSERT INTO ts_feed VALUES ('3642','1','a:3:{s:3:\"fid\";i:222;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334286374','weibo_follow');
INSERT INTO ts_feed VALUES ('3643','31','a:3:{s:3:\"fid\";i:2;s:3:\"uid\";i:31;s:4:\"type\";s:12:\"weibo_follow\";}','1334287728','weibo_follow');
INSERT INTO ts_feed VALUES ('3644','2','a:3:{s:3:\"fid\";i:31;s:3:\"uid\";i:2;s:4:\"type\";s:12:\"weibo_follow\";}','1334311667','weibo_follow');
INSERT INTO ts_feed VALUES ('3645','1','a:3:{s:3:\"fid\";i:221;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334330131','weibo_follow');
INSERT INTO ts_feed VALUES ('3646','1','a:3:{s:3:\"fid\";i:453;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334469301','weibo_follow');
INSERT INTO ts_feed VALUES ('3647','453','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469301','weibo_follow');
INSERT INTO ts_feed VALUES ('3648','453','a:3:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3649','453','a:3:{s:3:\"fid\";s:2:\"31\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3650','453','a:3:{s:3:\"fid\";s:3:\"217\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3651','453','a:3:{s:3:\"fid\";s:3:\"219\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3652','453','a:3:{s:3:\"fid\";s:3:\"220\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3653','453','a:3:{s:3:\"fid\";s:3:\"221\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3654','453','a:3:{s:3:\"fid\";s:3:\"222\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3655','453','a:3:{s:3:\"fid\";s:3:\"223\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3656','453','a:3:{s:3:\"fid\";s:3:\"452\";s:3:\"uid\";i:453;s:4:\"type\";s:12:\"weibo_follow\";}','1334469307','weibo_follow');
INSERT INTO ts_feed VALUES ('3657','1','a:3:{s:3:\"fid\";i:454;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334469639','weibo_follow');
INSERT INTO ts_feed VALUES ('3658','454','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469639','weibo_follow');
INSERT INTO ts_feed VALUES ('3659','454','a:3:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3660','454','a:3:{s:3:\"fid\";s:2:\"31\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3661','454','a:3:{s:3:\"fid\";s:3:\"217\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3662','454','a:3:{s:3:\"fid\";s:3:\"219\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3663','454','a:3:{s:3:\"fid\";s:3:\"220\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3664','454','a:3:{s:3:\"fid\";s:3:\"221\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3665','454','a:3:{s:3:\"fid\";s:3:\"222\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3666','454','a:3:{s:3:\"fid\";s:3:\"223\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3667','454','a:3:{s:3:\"fid\";s:3:\"452\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3668','454','a:3:{s:3:\"fid\";s:3:\"453\";s:3:\"uid\";i:454;s:4:\"type\";s:12:\"weibo_follow\";}','1334469643','weibo_follow');
INSERT INTO ts_feed VALUES ('3669','1','a:3:{s:3:\"fid\";i:455;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334564655','weibo_follow');
INSERT INTO ts_feed VALUES ('3670','455','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564655','weibo_follow');
INSERT INTO ts_feed VALUES ('3671','455','a:3:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3672','455','a:3:{s:3:\"fid\";s:2:\"31\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3673','455','a:3:{s:3:\"fid\";s:3:\"217\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3674','455','a:3:{s:3:\"fid\";s:3:\"219\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3675','455','a:3:{s:3:\"fid\";s:3:\"220\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3676','455','a:3:{s:3:\"fid\";s:3:\"221\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3677','455','a:3:{s:3:\"fid\";s:3:\"222\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3678','455','a:3:{s:3:\"fid\";s:3:\"223\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3679','455','a:3:{s:3:\"fid\";s:3:\"452\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3680','455','a:3:{s:3:\"fid\";s:3:\"453\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3681','455','a:3:{s:3:\"fid\";s:3:\"454\";s:3:\"uid\";i:455;s:4:\"type\";s:12:\"weibo_follow\";}','1334564687','weibo_follow');
INSERT INTO ts_feed VALUES ('3682','1','a:3:{s:3:\"fid\";i:456;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334623782','weibo_follow');
INSERT INTO ts_feed VALUES ('3683','456','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:456;s:4:\"type\";s:12:\"weibo_follow\";}','1334623782','weibo_follow');
INSERT INTO ts_feed VALUES ('3684','1','a:3:{s:3:\"fid\";i:457;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334670155','weibo_follow');
INSERT INTO ts_feed VALUES ('3685','457','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670156','weibo_follow');
INSERT INTO ts_feed VALUES ('3686','457','a:3:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3687','457','a:3:{s:3:\"fid\";s:3:\"217\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3688','457','a:3:{s:3:\"fid\";s:3:\"219\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3689','457','a:3:{s:3:\"fid\";s:3:\"220\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3690','457','a:3:{s:3:\"fid\";s:3:\"221\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3691','457','a:3:{s:3:\"fid\";s:3:\"222\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3692','457','a:3:{s:3:\"fid\";s:3:\"223\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3693','457','a:3:{s:3:\"fid\";s:3:\"452\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3694','457','a:3:{s:3:\"fid\";s:2:\"31\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3695','457','a:3:{s:3:\"fid\";s:3:\"453\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3696','457','a:3:{s:3:\"fid\";s:3:\"454\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3697','457','a:3:{s:3:\"fid\";s:3:\"455\";s:3:\"uid\";i:457;s:4:\"type\";s:12:\"weibo_follow\";}','1334670161','weibo_follow');
INSERT INTO ts_feed VALUES ('3698','1','a:3:{s:3:\"fid\";i:458;s:3:\"uid\";i:1;s:4:\"type\";s:12:\"weibo_follow\";}','1334713355','weibo_follow');
INSERT INTO ts_feed VALUES ('3699','458','a:3:{s:3:\"fid\";i:1;s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713355','weibo_follow');
INSERT INTO ts_feed VALUES ('3700','458','a:3:{s:3:\"fid\";s:1:\"2\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3701','458','a:3:{s:3:\"fid\";s:3:\"217\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3702','458','a:3:{s:3:\"fid\";s:3:\"219\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3703','458','a:3:{s:3:\"fid\";s:3:\"220\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3704','458','a:3:{s:3:\"fid\";s:3:\"221\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3705','458','a:3:{s:3:\"fid\";s:3:\"222\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3706','458','a:3:{s:3:\"fid\";s:3:\"223\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3707','458','a:3:{s:3:\"fid\";s:3:\"452\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3708','458','a:3:{s:3:\"fid\";s:2:\"31\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3709','458','a:3:{s:3:\"fid\";s:3:\"453\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3710','458','a:3:{s:3:\"fid\";s:3:\"454\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');
INSERT INTO ts_feed VALUES ('3711','458','a:3:{s:3:\"fid\";s:3:\"455\";s:3:\"uid\";i:458;s:4:\"type\";s:12:\"weibo_follow\";}','1334713359','weibo_follow');

DROP TABLE IF EXISTS ts_fengmian;
CREATE TABLE `ts_fengmian` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `fengid` varchar(255) NOT NULL,
  `dateline` char(20) NOT NULL,
  `fenguid` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=464 DEFAULT CHARSET=utf8;

INSERT INTO ts_fengmian VALUES ('387','2','24','1327577892','1');
INSERT INTO ts_fengmian VALUES ('386','2','14','1327577883','1');
INSERT INTO ts_fengmian VALUES ('385','1','7','1327577640','2');
INSERT INTO ts_fengmian VALUES ('384','1','6','1327577635','2');
INSERT INTO ts_fengmian VALUES ('383','1','5','1327575156','2');
INSERT INTO ts_fengmian VALUES ('388','230','2','1328839445','1');
INSERT INTO ts_fengmian VALUES ('389','235','2','1328863732','1');
INSERT INTO ts_fengmian VALUES ('390','235','12','1328863944','1');
INSERT INTO ts_fengmian VALUES ('391','242','42','1329027952','242');
INSERT INTO ts_fengmian VALUES ('392','247','58','1329111512','247');
INSERT INTO ts_fengmian VALUES ('393','233','23','1329189524','1');
INSERT INTO ts_fengmian VALUES ('403','233','48','1329812733','1');
INSERT INTO ts_fengmian VALUES ('404','233','2','1329887822','1');
INSERT INTO ts_fengmian VALUES ('397','259','22','1329556684','1');
INSERT INTO ts_fengmian VALUES ('428','400','217','1331795834','400');
INSERT INTO ts_fengmian VALUES ('402','233','92','1329812618','268');
INSERT INTO ts_fengmian VALUES ('406','233','12','1329887824','1');
INSERT INTO ts_fengmian VALUES ('409','288','12','1330313702','1');
INSERT INTO ts_fengmian VALUES ('410','292','2','1330432719','1');
INSERT INTO ts_fengmian VALUES ('411','295','117','1330479173','295');
INSERT INTO ts_fengmian VALUES ('412','308','22','1330596863','1');
INSERT INTO ts_fengmian VALUES ('413','233','77','1330936313','1');
INSERT INTO ts_fengmian VALUES ('414','233','57','1330936314','1');
INSERT INTO ts_fengmian VALUES ('415','233','47','1330936316','1');
INSERT INTO ts_fengmian VALUES ('416','323','2','1331004246','1');
INSERT INTO ts_fengmian VALUES ('446','445','30','1332521259','233');
INSERT INTO ts_fengmian VALUES ('418','2','41','1331232726','1');
INSERT INTO ts_fengmian VALUES ('419','350','177','1331267956','350');
INSERT INTO ts_fengmian VALUES ('420','357','154','1331279089','1');
INSERT INTO ts_fengmian VALUES ('421','357','77','1331279090','1');
INSERT INTO ts_fengmian VALUES ('422','357','57','1331279091','1');
INSERT INTO ts_fengmian VALUES ('423','357','48','1331279092','1');
INSERT INTO ts_fengmian VALUES ('424','2','57','1331431543','1');
INSERT INTO ts_fengmian VALUES ('425','378','47','1331485102','1');
INSERT INTO ts_fengmian VALUES ('426','382','206','1331544411','382');
INSERT INTO ts_fengmian VALUES ('429','416','188','1331996034','2');
INSERT INTO ts_fengmian VALUES ('430','363','239','1332215600','1');
INSERT INTO ts_fengmian VALUES ('431','429','12','1332302884','1');
INSERT INTO ts_fengmian VALUES ('432','429','22','1332302885','1');
INSERT INTO ts_fengmian VALUES ('433','429','30','1332303029','233');
INSERT INTO ts_fengmian VALUES ('434','429','2','1332303617','1');
INSERT INTO ts_fengmian VALUES ('435','1','166','1332303659','326');
INSERT INTO ts_fengmian VALUES ('438','430','30','1332307820','233');
INSERT INTO ts_fengmian VALUES ('439','431','166','1332310538','326');
INSERT INTO ts_fengmian VALUES ('440','431','143','1332310881','320');
INSERT INTO ts_fengmian VALUES ('442','434','2','1332407253','1');
INSERT INTO ts_fengmian VALUES ('443','434','12','1332422793','1');
INSERT INTO ts_fengmian VALUES ('448','2','30','1332569288','233');
INSERT INTO ts_fengmian VALUES ('449','2','3','1333983212','1');
INSERT INTO ts_fengmian VALUES ('450','2','12','1334036556','1');
INSERT INTO ts_fengmian VALUES ('451','2','23','1334064019','1');
INSERT INTO ts_fengmian VALUES ('452','2','22','1334064027','1');
INSERT INTO ts_fengmian VALUES ('453','2','2','1334064030','1');
INSERT INTO ts_fengmian VALUES ('454','2','239','1334064030','1');
INSERT INTO ts_fengmian VALUES ('455','1','287','1334064391','2');
INSERT INTO ts_fengmian VALUES ('456','31','287','1334068829','2');
INSERT INTO ts_fengmian VALUES ('457','31','2','1334068830','1');
INSERT INTO ts_fengmian VALUES ('458','31','12','1334068831','1');
INSERT INTO ts_fengmian VALUES ('459','31','22','1334068831','1');
INSERT INTO ts_fengmian VALUES ('460','31','23','1334068832','1');
INSERT INTO ts_fengmian VALUES ('461','31','239','1334068832','1');
INSERT INTO ts_fengmian VALUES ('462','31','3','1334068833','1');
INSERT INTO ts_fengmian VALUES ('463','31','284','1334068838','1');

DROP TABLE IF EXISTS ts_friend;
CREATE TABLE `ts_friend` (
  `friend_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `friend_uid` int(11) NOT NULL,
  `friend_uname` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `message` varchar(255) DEFAULT NULL,
  `ctime` int(11) NOT NULL,
  PRIMARY KEY (`friend_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_friend_group;
CREATE TABLE `ts_friend_group` (
  `friend_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`friend_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_friend_group_link;
CREATE TABLE `ts_friend_group_link` (
  `uid` int(11) NOT NULL,
  `friend_uid` int(11) NOT NULL,
  `friend_uname` varchar(255) NOT NULL,
  `friend_group_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_goodstag;
CREATE TABLE `ts_goodstag` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) NOT NULL,
  `goodsid` int(10) NOT NULL,
  `fenlei` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1676 DEFAULT CHARSET=utf8;

INSERT INTO ts_goodstag VALUES ('242','鞋子','306','');
INSERT INTO ts_goodstag VALUES ('243','减肥','307','');
INSERT INTO ts_goodstag VALUES ('244','欧美','308','');
INSERT INTO ts_goodstag VALUES ('245','衬衫','308','');
INSERT INTO ts_goodstag VALUES ('246','衬衫','313','');
INSERT INTO ts_goodstag VALUES ('247','欧美','313','');
INSERT INTO ts_goodstag VALUES ('248','衣服','314','');
INSERT INTO ts_goodstag VALUES ('249','欧美','314','');
INSERT INTO ts_goodstag VALUES ('250','欧美','316','');
INSERT INTO ts_goodstag VALUES ('251','衬衫','316','');
INSERT INTO ts_goodstag VALUES ('252','裙子','317','');
INSERT INTO ts_goodstag VALUES ('253','休闲','317','');
INSERT INTO ts_goodstag VALUES ('254','背心','318','');
INSERT INTO ts_goodstag VALUES ('255','复古','318','');
INSERT INTO ts_goodstag VALUES ('256','衣服','319','');
INSERT INTO ts_goodstag VALUES ('257','条纹','319','');
INSERT INTO ts_goodstag VALUES ('258','打底裤','319','');
INSERT INTO ts_goodstag VALUES ('259','新款','319','');
INSERT INTO ts_goodstag VALUES ('260','包包','320','');
INSERT INTO ts_goodstag VALUES ('261','链条包','320','');
INSERT INTO ts_goodstag VALUES ('262','复古','320','');
INSERT INTO ts_goodstag VALUES ('263','英伦','320','');
INSERT INTO ts_goodstag VALUES ('264','配饰','321','');
INSERT INTO ts_goodstag VALUES ('265','项链','321','');
INSERT INTO ts_goodstag VALUES ('266','手机链','321','');
INSERT INTO ts_goodstag VALUES ('267','陶瓷','321','');
INSERT INTO ts_goodstag VALUES ('268','鞋子','322','');
INSERT INTO ts_goodstag VALUES ('269','徐濠萦','322','');
INSERT INTO ts_goodstag VALUES ('270','厚底凉鞋','322','');
INSERT INTO ts_goodstag VALUES ('271','衣服','323','');
INSERT INTO ts_goodstag VALUES ('272','连衣裙','323','');
INSERT INTO ts_goodstag VALUES ('273','雪纺','323','');
INSERT INTO ts_goodstag VALUES ('274','衣服','324','');
INSERT INTO ts_goodstag VALUES ('275','短T','324','');
INSERT INTO ts_goodstag VALUES ('276','鞋子','325','');
INSERT INTO ts_goodstag VALUES ('277','坡跟凉鞋','325','');
INSERT INTO ts_goodstag VALUES ('278','民族风','325','');
INSERT INTO ts_goodstag VALUES ('279','包包','326','');
INSERT INTO ts_goodstag VALUES ('280','旅行箱','326','');
INSERT INTO ts_goodstag VALUES ('281','旅行','326','');
INSERT INTO ts_goodstag VALUES ('282','行李箱','326','');
INSERT INTO ts_goodstag VALUES ('283','配饰','327','');
INSERT INTO ts_goodstag VALUES ('284','腰带','327','');
INSERT INTO ts_goodstag VALUES ('285','彩色','327','');
INSERT INTO ts_goodstag VALUES ('286','衣服','328','');
INSERT INTO ts_goodstag VALUES ('287','热裤','328','');
INSERT INTO ts_goodstag VALUES ('288','可爱','328','');
INSERT INTO ts_goodstag VALUES ('289','休闲','328','');
INSERT INTO ts_goodstag VALUES ('290','鞋子','329','');
INSERT INTO ts_goodstag VALUES ('291','罗马鞋','329','');
INSERT INTO ts_goodstag VALUES ('292','宽松','329','');
INSERT INTO ts_goodstag VALUES ('293','包包','330','');
INSERT INTO ts_goodstag VALUES ('294','钱包','330','');
INSERT INTO ts_goodstag VALUES ('295','卡包','330','');
INSERT INTO ts_goodstag VALUES ('296','圈点','330','');
INSERT INTO ts_goodstag VALUES ('297','包包','331','');
INSERT INTO ts_goodstag VALUES ('298','草编包','331','');
INSERT INTO ts_goodstag VALUES ('299','配饰','332','');
INSERT INTO ts_goodstag VALUES ('300','发夹','332','');
INSERT INTO ts_goodstag VALUES ('301','可爱','332','');
INSERT INTO ts_goodstag VALUES ('302','OL','333','');
INSERT INTO ts_goodstag VALUES ('303','针织衫','333','');
INSERT INTO ts_goodstag VALUES ('304','裙子','333','');
INSERT INTO ts_goodstag VALUES ('305','两色','333','');
INSERT INTO ts_goodstag VALUES ('306','裙子','334','');
INSERT INTO ts_goodstag VALUES ('307','甜美','334','');
INSERT INTO ts_goodstag VALUES ('308','连衣裙','334','');
INSERT INTO ts_goodstag VALUES ('309','凉鞋','334','');
INSERT INTO ts_goodstag VALUES ('310','水桶包','334','');
INSERT INTO ts_goodstag VALUES ('311','衣服','336','打底裤');
INSERT INTO ts_goodstag VALUES ('312','紧身裤','336','打底裤');
INSERT INTO ts_goodstag VALUES ('313','欧美','336','打底裤');
INSERT INTO ts_goodstag VALUES ('314','九分裤','336','打底裤');
INSERT INTO ts_goodstag VALUES ('315','灰色','336','打底裤');
INSERT INTO ts_goodstag VALUES ('316','legging','336','打底裤');
INSERT INTO ts_goodstag VALUES ('317','衣服','337','中老年服装');
INSERT INTO ts_goodstag VALUES ('318','夏装','337','中老年服装');
INSERT INTO ts_goodstag VALUES ('319','韩版','337','中老年服装');
INSERT INTO ts_goodstag VALUES ('320','衣服','339','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('321','衣服','340','连衣裙');
INSERT INTO ts_goodstag VALUES ('322','','341','');
INSERT INTO ts_goodstag VALUES ('323','裙子','341','');
INSERT INTO ts_goodstag VALUES ('324','衣服','341','');
INSERT INTO ts_goodstag VALUES ('325','裙子','342','');
INSERT INTO ts_goodstag VALUES ('326','衣服','346','衬衫');
INSERT INTO ts_goodstag VALUES ('327','裤子','347','');
INSERT INTO ts_goodstag VALUES ('328','衣服','347','');
INSERT INTO ts_goodstag VALUES ('329','红色','347','');
INSERT INTO ts_goodstag VALUES ('330','配饰','350','磨豆机/咖啡机');
INSERT INTO ts_goodstag VALUES ('331','磨豆机','350','磨豆机/咖啡机');
INSERT INTO ts_goodstag VALUES ('332','衣服','353','连衣裙');
INSERT INTO ts_goodstag VALUES ('333','连衣裙','353','连衣裙');
INSERT INTO ts_goodstag VALUES ('334','短裤','354','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('335','衣服','354','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('336','衣服','355','休闲长裤');
INSERT INTO ts_goodstag VALUES ('337','连衣裤','355','休闲长裤');
INSERT INTO ts_goodstag VALUES ('338','包包','358','');
INSERT INTO ts_goodstag VALUES ('339','衣服','359','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('340','化妆','366','');
INSERT INTO ts_goodstag VALUES ('341','打底裤','367','');
INSERT INTO ts_goodstag VALUES ('342','连衣裙','372','');
INSERT INTO ts_goodstag VALUES ('343','衣服','373','');
INSERT INTO ts_goodstag VALUES ('344','衣服','374','');
INSERT INTO ts_goodstag VALUES ('345','热裤','374','');
INSERT INTO ts_goodstag VALUES ('346','T恤','375','');
INSERT INTO ts_goodstag VALUES ('347','衣服','375','');
INSERT INTO ts_goodstag VALUES ('348','衬衫','376','');
INSERT INTO ts_goodstag VALUES ('349','衣服','376','');
INSERT INTO ts_goodstag VALUES ('350','包包','377','');
INSERT INTO ts_goodstag VALUES ('351','链条包','377','');
INSERT INTO ts_goodstag VALUES ('352','包包','378','');
INSERT INTO ts_goodstag VALUES ('353','旅行箱','378','');
INSERT INTO ts_goodstag VALUES ('354','包包','379','');
INSERT INTO ts_goodstag VALUES ('355','钱包','379','');
INSERT INTO ts_goodstag VALUES ('356','包包','380','');
INSERT INTO ts_goodstag VALUES ('357','草编包','380','');
INSERT INTO ts_goodstag VALUES ('358','包包','381','');
INSERT INTO ts_goodstag VALUES ('359','邮差包','381','');
INSERT INTO ts_goodstag VALUES ('360','包包','382','');
INSERT INTO ts_goodstag VALUES ('361','流苏包','382','');
INSERT INTO ts_goodstag VALUES ('362','包包','383','');
INSERT INTO ts_goodstag VALUES ('363','铆钉包','383','');
INSERT INTO ts_goodstag VALUES ('364','包包','384','');
INSERT INTO ts_goodstag VALUES ('365','零钱包','384','');
INSERT INTO ts_goodstag VALUES ('366','包包','385','');
INSERT INTO ts_goodstag VALUES ('367','手拿包','385','');
INSERT INTO ts_goodstag VALUES ('368','包包','386','');
INSERT INTO ts_goodstag VALUES ('369','双肩包','386','');
INSERT INTO ts_goodstag VALUES ('370','衣服','387','');
INSERT INTO ts_goodstag VALUES ('371','牛仔裙','387','');
INSERT INTO ts_goodstag VALUES ('372','包包','388','');
INSERT INTO ts_goodstag VALUES ('373','水桶包','388','');
INSERT INTO ts_goodstag VALUES ('374','花苞裙','389','');
INSERT INTO ts_goodstag VALUES ('375','衣服','389','');
INSERT INTO ts_goodstag VALUES ('376','包包','390','');
INSERT INTO ts_goodstag VALUES ('377','帆布包','390','');
INSERT INTO ts_goodstag VALUES ('378','包包','391','');
INSERT INTO ts_goodstag VALUES ('379','单肩包','391','');
INSERT INTO ts_goodstag VALUES ('380','包包','392','');
INSERT INTO ts_goodstag VALUES ('381','化妆包','392','');
INSERT INTO ts_goodstag VALUES ('382','包包','393','');
INSERT INTO ts_goodstag VALUES ('383','信封包','393','');
INSERT INTO ts_goodstag VALUES ('384','配饰','394','');
INSERT INTO ts_goodstag VALUES ('385','项链','394','');
INSERT INTO ts_goodstag VALUES ('386','雪纺衫','395','');
INSERT INTO ts_goodstag VALUES ('387','衣服','395','');
INSERT INTO ts_goodstag VALUES ('388','配饰','396','');
INSERT INTO ts_goodstag VALUES ('389','腰带','396','');
INSERT INTO ts_goodstag VALUES ('390','衣服','397','');
INSERT INTO ts_goodstag VALUES ('391','泳装','397','');
INSERT INTO ts_goodstag VALUES ('392','配饰','398','');
INSERT INTO ts_goodstag VALUES ('393','发夹','398','');
INSERT INTO ts_goodstag VALUES ('394','配饰','399','');
INSERT INTO ts_goodstag VALUES ('395','耳钉','399','');
INSERT INTO ts_goodstag VALUES ('396','长裙','400','');
INSERT INTO ts_goodstag VALUES ('397','衣服','400','');
INSERT INTO ts_goodstag VALUES ('398','配饰','401','');
INSERT INTO ts_goodstag VALUES ('399','墨镜','401','');
INSERT INTO ts_goodstag VALUES ('400','衣服','402','');
INSERT INTO ts_goodstag VALUES ('401','连体裤','402','');
INSERT INTO ts_goodstag VALUES ('402','配饰','403','');
INSERT INTO ts_goodstag VALUES ('403','发带','403','');
INSERT INTO ts_goodstag VALUES ('404','七分裤','404','');
INSERT INTO ts_goodstag VALUES ('405','衣服','404','');
INSERT INTO ts_goodstag VALUES ('406','吊带裙','405','');
INSERT INTO ts_goodstag VALUES ('407','衣服','405','');
INSERT INTO ts_goodstag VALUES ('408','配饰','406','');
INSERT INTO ts_goodstag VALUES ('409','手表','406','');
INSERT INTO ts_goodstag VALUES ('410','短裙','407','');
INSERT INTO ts_goodstag VALUES ('411','衣服','407','');
INSERT INTO ts_goodstag VALUES ('412','配饰','408','');
INSERT INTO ts_goodstag VALUES ('413','吊坠','408','');
INSERT INTO ts_goodstag VALUES ('414','鞋子','409','');
INSERT INTO ts_goodstag VALUES ('415','娃娃鞋','409','');
INSERT INTO ts_goodstag VALUES ('416','鞋子','410','');
INSERT INTO ts_goodstag VALUES ('417','厚底鞋','410','');
INSERT INTO ts_goodstag VALUES ('418','复古','411','');
INSERT INTO ts_goodstag VALUES ('419','衣服','411','');
INSERT INTO ts_goodstag VALUES ('420','连体裤','412','');
INSERT INTO ts_goodstag VALUES ('421','衣服','412','');
INSERT INTO ts_goodstag VALUES ('422','果冻鞋','413','');
INSERT INTO ts_goodstag VALUES ('423','鞋子','413','');
INSERT INTO ts_goodstag VALUES ('424','短裙','414','');
INSERT INTO ts_goodstag VALUES ('425','衣服','414','');
INSERT INTO ts_goodstag VALUES ('426','帆布鞋','415','');
INSERT INTO ts_goodstag VALUES ('427','鞋子','415','');
INSERT INTO ts_goodstag VALUES ('428','衣服','416','');
INSERT INTO ts_goodstag VALUES ('429','纱裙','416','');
INSERT INTO ts_goodstag VALUES ('430','鞋子','417','');
INSERT INTO ts_goodstag VALUES ('431','坡跟凉鞋','417','');
INSERT INTO ts_goodstag VALUES ('432','包包','418','');
INSERT INTO ts_goodstag VALUES ('433','化妆包','418','');
INSERT INTO ts_goodstag VALUES ('434','配饰','419','');
INSERT INTO ts_goodstag VALUES ('435','手表','419','');
INSERT INTO ts_goodstag VALUES ('436','衣服','420','');
INSERT INTO ts_goodstag VALUES ('437','长T','420','');
INSERT INTO ts_goodstag VALUES ('438','鞋子','421','');
INSERT INTO ts_goodstag VALUES ('439','包包','422','');
INSERT INTO ts_goodstag VALUES ('440','罗马鞋','422','');
INSERT INTO ts_goodstag VALUES ('441','配饰','423','');
INSERT INTO ts_goodstag VALUES ('442','项链','423','');
INSERT INTO ts_goodstag VALUES ('443','衣服','424','');
INSERT INTO ts_goodstag VALUES ('444','波西米亚','424','');
INSERT INTO ts_goodstag VALUES ('445','鞋子','425','');
INSERT INTO ts_goodstag VALUES ('446','果冻鞋','425','');
INSERT INTO ts_goodstag VALUES ('447','包包','426','');
INSERT INTO ts_goodstag VALUES ('448','旅行箱','426','');
INSERT INTO ts_goodstag VALUES ('449','配饰','427','');
INSERT INTO ts_goodstag VALUES ('450','腰带','427','');
INSERT INTO ts_goodstag VALUES ('451','衣服','428','');
INSERT INTO ts_goodstag VALUES ('452','复古','428','');
INSERT INTO ts_goodstag VALUES ('453','鞋子','429','');
INSERT INTO ts_goodstag VALUES ('454','帆布鞋','429','');
INSERT INTO ts_goodstag VALUES ('455','包包','430','');
INSERT INTO ts_goodstag VALUES ('456','钱包','430','');
INSERT INTO ts_goodstag VALUES ('457','配饰','431','');
INSERT INTO ts_goodstag VALUES ('458','发夹','431','');
INSERT INTO ts_goodstag VALUES ('459','衣服','432','');
INSERT INTO ts_goodstag VALUES ('460','短T','432','');
INSERT INTO ts_goodstag VALUES ('461','鞋子','433','');
INSERT INTO ts_goodstag VALUES ('462','摇摇鞋','433','');
INSERT INTO ts_goodstag VALUES ('463','包包','434','');
INSERT INTO ts_goodstag VALUES ('464','草编包','434','');
INSERT INTO ts_goodstag VALUES ('465','长裙','435','');
INSERT INTO ts_goodstag VALUES ('466','衣服','435','');
INSERT INTO ts_goodstag VALUES ('467','娃娃鞋','436','');
INSERT INTO ts_goodstag VALUES ('468','鞋子','436','');
INSERT INTO ts_goodstag VALUES ('469','配饰','437','');
INSERT INTO ts_goodstag VALUES ('470','耳钉','437','');
INSERT INTO ts_goodstag VALUES ('471','衣服','438','');
INSERT INTO ts_goodstag VALUES ('472','打底裤','438','');
INSERT INTO ts_goodstag VALUES ('473','鞋子','439','');
INSERT INTO ts_goodstag VALUES ('474','拖鞋','439','');
INSERT INTO ts_goodstag VALUES ('475','包包','440','');
INSERT INTO ts_goodstag VALUES ('476','邮差包','440','');
INSERT INTO ts_goodstag VALUES ('477','配饰','441','');
INSERT INTO ts_goodstag VALUES ('478','墨镜','441','');
INSERT INTO ts_goodstag VALUES ('479','衣服','442','');
INSERT INTO ts_goodstag VALUES ('480','边衣裙','442','');
INSERT INTO ts_goodstag VALUES ('481','鞋子','443','');
INSERT INTO ts_goodstag VALUES ('482','鱼嘴鞋','443','');
INSERT INTO ts_goodstag VALUES ('483','包包','444','');
INSERT INTO ts_goodstag VALUES ('484','流苏包','444','');
INSERT INTO ts_goodstag VALUES ('485','配饰','445','');
INSERT INTO ts_goodstag VALUES ('486','发带','445','');
INSERT INTO ts_goodstag VALUES ('487','衣服','448','');
INSERT INTO ts_goodstag VALUES ('488','鞋子','449','');
INSERT INTO ts_goodstag VALUES ('489','高跟鞋','449','');
INSERT INTO ts_goodstag VALUES ('490','包包','450','');
INSERT INTO ts_goodstag VALUES ('491','铆钉包','450','');
INSERT INTO ts_goodstag VALUES ('492','配饰','451','');
INSERT INTO ts_goodstag VALUES ('493','吊坠','451','');
INSERT INTO ts_goodstag VALUES ('494','衣服','452','');
INSERT INTO ts_goodstag VALUES ('495','衬衫','452','');
INSERT INTO ts_goodstag VALUES ('496','鞋子','453','');
INSERT INTO ts_goodstag VALUES ('497','牛津鞋','453','');
INSERT INTO ts_goodstag VALUES ('498','包包','454','');
INSERT INTO ts_goodstag VALUES ('499','零钱包','454','');
INSERT INTO ts_goodstag VALUES ('500','配饰','455','');
INSERT INTO ts_goodstag VALUES ('501','草帽','455','');
INSERT INTO ts_goodstag VALUES ('502','吊带','456','');
INSERT INTO ts_goodstag VALUES ('503','衣服','456','');
INSERT INTO ts_goodstag VALUES ('504','镜框','457','');
INSERT INTO ts_goodstag VALUES ('505','衣服','457','');
INSERT INTO ts_goodstag VALUES ('506','雪纺衫','458','');
INSERT INTO ts_goodstag VALUES ('507','衣服','458','');
INSERT INTO ts_goodstag VALUES ('508','编织','459','');
INSERT INTO ts_goodstag VALUES ('509','配饰','459','');
INSERT INTO ts_goodstag VALUES ('510','裙子','460','');
INSERT INTO ts_goodstag VALUES ('511','连衣裙','460','');
INSERT INTO ts_goodstag VALUES ('512','清新','460','');
INSERT INTO ts_goodstag VALUES ('513','T恤','460','');
INSERT INTO ts_goodstag VALUES ('514','裙子','461','');
INSERT INTO ts_goodstag VALUES ('515','雪纺背心','461','');
INSERT INTO ts_goodstag VALUES ('516','短裙','461','');
INSERT INTO ts_goodstag VALUES ('517','高跟鞋','461','');
INSERT INTO ts_goodstag VALUES ('518','木屐','461','');
INSERT INTO ts_goodstag VALUES ('519','包包','464','');
INSERT INTO ts_goodstag VALUES ('520','衣服','465','');
INSERT INTO ts_goodstag VALUES ('521','鞋子','466','');
INSERT INTO ts_goodstag VALUES ('522','衣服','467','');
INSERT INTO ts_goodstag VALUES ('523','鞋子','468','');
INSERT INTO ts_goodstag VALUES ('524','衣服','469','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('525','韩版','469','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('526','家居','473','ZIPPO/芝宝');
INSERT INTO ts_goodstag VALUES ('527','裙子','477','');
INSERT INTO ts_goodstag VALUES ('528','包包','484','');
INSERT INTO ts_goodstag VALUES ('529','衣服','485','连衣裙');
INSERT INTO ts_goodstag VALUES ('530','裙子','486','');
INSERT INTO ts_goodstag VALUES ('531','短裙','486','');
INSERT INTO ts_goodstag VALUES ('532','','487','');
INSERT INTO ts_goodstag VALUES ('533','','487','');
INSERT INTO ts_goodstag VALUES ('534','裙子','487','');
INSERT INTO ts_goodstag VALUES ('535','抹胸','487','');
INSERT INTO ts_goodstag VALUES ('536','包包','488','包袋');
INSERT INTO ts_goodstag VALUES ('537','裙子','490','');
INSERT INTO ts_goodstag VALUES ('538','裙子','499','');
INSERT INTO ts_goodstag VALUES ('539','不错','499','');
INSERT INTO ts_goodstag VALUES ('540','裙子','500','');
INSERT INTO ts_goodstag VALUES ('541','短裤','501','');
INSERT INTO ts_goodstag VALUES ('542','裙子','502','');
INSERT INTO ts_goodstag VALUES ('543','背心','503','');
INSERT INTO ts_goodstag VALUES ('544','裙子','504','');
INSERT INTO ts_goodstag VALUES ('545','裙子','505','');
INSERT INTO ts_goodstag VALUES ('546','裙子','507','');
INSERT INTO ts_goodstag VALUES ('547','','508','');
INSERT INTO ts_goodstag VALUES ('548','衬衫','508','');
INSERT INTO ts_goodstag VALUES ('549','裙子','509','');
INSERT INTO ts_goodstag VALUES ('550','衬衫','511','');
INSERT INTO ts_goodstag VALUES ('551','裙子','512','');
INSERT INTO ts_goodstag VALUES ('552','','513','');
INSERT INTO ts_goodstag VALUES ('553','','514','');
INSERT INTO ts_goodstag VALUES ('554','衬衫','516','');
INSERT INTO ts_goodstag VALUES ('555','篮球','516','');
INSERT INTO ts_goodstag VALUES ('556','','517','');
INSERT INTO ts_goodstag VALUES ('557','','517','');
INSERT INTO ts_goodstag VALUES ('558','墨镜','517','');
INSERT INTO ts_goodstag VALUES ('559','衣服','521','马夹');
INSERT INTO ts_goodstag VALUES ('560','衣服','522','连衣裙');
INSERT INTO ts_goodstag VALUES ('561','碎花','522','连衣裙');
INSERT INTO ts_goodstag VALUES ('562','连衣裙','522','连衣裙');
INSERT INTO ts_goodstag VALUES ('563','包包','523','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('564','2011夏新款','523','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('565','衬衫','524','');
INSERT INTO ts_goodstag VALUES ('566','黑色长袖t恤体恤女款修身秋装新','527','T恤');
INSERT INTO ts_goodstag VALUES ('567','衣服','530','低帮鞋');
INSERT INTO ts_goodstag VALUES ('568','鞋子','532','其它杂货');
INSERT INTO ts_goodstag VALUES ('569','衣服','533','毛衣');
INSERT INTO ts_goodstag VALUES ('570','衣服','535','连衣裙');
INSERT INTO ts_goodstag VALUES ('571','连衣裙','535','连衣裙');
INSERT INTO ts_goodstag VALUES ('572','衣服','536','连衣裙');
INSERT INTO ts_goodstag VALUES ('573','连衣裙','536','连衣裙');
INSERT INTO ts_goodstag VALUES ('574','鞋','537','凉鞋');
INSERT INTO ts_goodstag VALUES ('575','衣服','538','短外套');
INSERT INTO ts_goodstag VALUES ('576','欧美','539','');
INSERT INTO ts_goodstag VALUES ('577','剃须刀','540','剃须刀');
INSERT INTO ts_goodstag VALUES ('578','飞科','540','剃须刀');
INSERT INTO ts_goodstag VALUES ('579','衣服','541','连衣裙');
INSERT INTO ts_goodstag VALUES ('580','','542','');
INSERT INTO ts_goodstag VALUES ('581','复古，欧美，休闲，OL，镂空，','542','');
INSERT INTO ts_goodstag VALUES ('582','8090dian','544','');
INSERT INTO ts_goodstag VALUES ('583','鞋子','544','');
INSERT INTO ts_goodstag VALUES ('584','鞋子','545','靴子');
INSERT INTO ts_goodstag VALUES ('585','裙子','557','');
INSERT INTO ts_goodstag VALUES ('586','衣服','571','牛仔裤');
INSERT INTO ts_goodstag VALUES ('587','家居','572','月饼');
INSERT INTO ts_goodstag VALUES ('588','衣服','573','针织衫');
INSERT INTO ts_goodstag VALUES ('589','衣服','574','花茶/其它茶叶');
INSERT INTO ts_goodstag VALUES ('590','包包','575','钱包卡套');
INSERT INTO ts_goodstag VALUES ('591','裙子','577','');
INSERT INTO ts_goodstag VALUES ('592','休闲','577','');
INSERT INTO ts_goodstag VALUES ('593','OL','577','');
INSERT INTO ts_goodstag VALUES ('594','条纹','577','');
INSERT INTO ts_goodstag VALUES ('595','衣服','582','针织衫');
INSERT INTO ts_goodstag VALUES ('596','衬衫','584','');
INSERT INTO ts_goodstag VALUES ('597','衣服','586','小背心/小吊带');
INSERT INTO ts_goodstag VALUES ('598','衣服','588','休闲长裤');
INSERT INTO ts_goodstag VALUES ('599','衣服','589','针织衫');
INSERT INTO ts_goodstag VALUES ('600','衣服','590','文胸');
INSERT INTO ts_goodstag VALUES ('601','文胸','590','文胸');
INSERT INTO ts_goodstag VALUES ('602','衣服','591','打底裤');
INSERT INTO ts_goodstag VALUES ('603','衣服','592','包袋');
INSERT INTO ts_goodstag VALUES ('604','短裤','593','');
INSERT INTO ts_goodstag VALUES ('605','美女','594','');
INSERT INTO ts_goodstag VALUES ('606','欧美','595','');
INSERT INTO ts_goodstag VALUES ('607','裙子','598','');
INSERT INTO ts_goodstag VALUES ('608','儿童','598','');
INSERT INTO ts_goodstag VALUES ('609','衣服','600','毛衣');
INSERT INTO ts_goodstag VALUES ('610','墨镜','601','');
INSERT INTO ts_goodstag VALUES ('611','鞋子','602','低帮鞋');
INSERT INTO ts_goodstag VALUES ('612','美妆','605','隔离/妆前/打底');
INSERT INTO ts_goodstag VALUES ('613','衣服','611','风衣');
INSERT INTO ts_goodstag VALUES ('614','复古','611','风衣');
INSERT INTO ts_goodstag VALUES ('615','包包','613','包袋');
INSERT INTO ts_goodstag VALUES ('616','包包','620','包袋');
INSERT INTO ts_goodstag VALUES ('617','衣服','622','牛仔裤');
INSERT INTO ts_goodstag VALUES ('618','包包','623','包袋');
INSERT INTO ts_goodstag VALUES ('619','OL','623','包袋');
INSERT INTO ts_goodstag VALUES ('620','短裤','631','');
INSERT INTO ts_goodstag VALUES ('621','鞋子','633','其它网络服务');
INSERT INTO ts_goodstag VALUES ('622','短裤','635','');
INSERT INTO ts_goodstag VALUES ('623','美图','639','');
INSERT INTO ts_goodstag VALUES ('624','','640','');
INSERT INTO ts_goodstag VALUES ('625','阿依莲专卖店外景','640','');
INSERT INTO ts_goodstag VALUES ('626','','641','');
INSERT INTO ts_goodstag VALUES ('627','','641','');
INSERT INTO ts_goodstag VALUES ('628','裙子','644','');
INSERT INTO ts_goodstag VALUES ('629','','645','');
INSERT INTO ts_goodstag VALUES ('630','衬衫','645','');
INSERT INTO ts_goodstag VALUES ('631','短裤','646','');
INSERT INTO ts_goodstag VALUES ('632','背心','647','');
INSERT INTO ts_goodstag VALUES ('633','背心','648','');
INSERT INTO ts_goodstag VALUES ('634','','649','');
INSERT INTO ts_goodstag VALUES ('635','墨镜','649','');
INSERT INTO ts_goodstag VALUES ('636','裙子','650','');
INSERT INTO ts_goodstag VALUES ('637','衬衫','651','');
INSERT INTO ts_goodstag VALUES ('638','衬衫','652','');
INSERT INTO ts_goodstag VALUES ('639','墨镜','653','');
INSERT INTO ts_goodstag VALUES ('640','短裤','655','');
INSERT INTO ts_goodstag VALUES ('641','背心','656','');
INSERT INTO ts_goodstag VALUES ('642','裙子','657','');
INSERT INTO ts_goodstag VALUES ('643','衬衫','658','');
INSERT INTO ts_goodstag VALUES ('644','短裤','659','');
INSERT INTO ts_goodstag VALUES ('645','背心','660','');
INSERT INTO ts_goodstag VALUES ('646','背心','661','');
INSERT INTO ts_goodstag VALUES ('647','短裤','662','');
INSERT INTO ts_goodstag VALUES ('648','衬衫','663','');
INSERT INTO ts_goodstag VALUES ('649','短裤','664','');
INSERT INTO ts_goodstag VALUES ('650','背心','665','');
INSERT INTO ts_goodstag VALUES ('651','墨镜','666','');
INSERT INTO ts_goodstag VALUES ('652','西装','667','');
INSERT INTO ts_goodstag VALUES ('653','衬衫','668','');
INSERT INTO ts_goodstag VALUES ('654','背心','669','');
INSERT INTO ts_goodstag VALUES ('655','衬衫','670','');
INSERT INTO ts_goodstag VALUES ('656','衬衫','671','');
INSERT INTO ts_goodstag VALUES ('657','衬衫','672','');
INSERT INTO ts_goodstag VALUES ('658','衬衫','673','');
INSERT INTO ts_goodstag VALUES ('659','衬衫','674','');
INSERT INTO ts_goodstag VALUES ('660','衬衫','675','');
INSERT INTO ts_goodstag VALUES ('661','短裤','676','');
INSERT INTO ts_goodstag VALUES ('662','衬衫','677','');
INSERT INTO ts_goodstag VALUES ('663','背心','678','');
INSERT INTO ts_goodstag VALUES ('664','短裤','679','');
INSERT INTO ts_goodstag VALUES ('665','衬衫','680','');
INSERT INTO ts_goodstag VALUES ('666','墨镜','681','');
INSERT INTO ts_goodstag VALUES ('667','墨镜','682','');
INSERT INTO ts_goodstag VALUES ('668','背心','683','');
INSERT INTO ts_goodstag VALUES ('669','短裤','685','');
INSERT INTO ts_goodstag VALUES ('670','墨镜','686','');
INSERT INTO ts_goodstag VALUES ('671','墨镜','689','');
INSERT INTO ts_goodstag VALUES ('672','西装','690','');
INSERT INTO ts_goodstag VALUES ('673','西装','692','');
INSERT INTO ts_goodstag VALUES ('674','西装','693','');
INSERT INTO ts_goodstag VALUES ('675','西装','694','');
INSERT INTO ts_goodstag VALUES ('676','西装','695','');
INSERT INTO ts_goodstag VALUES ('677','西装','696','');
INSERT INTO ts_goodstag VALUES ('678','西装','698','');
INSERT INTO ts_goodstag VALUES ('679','裙子','699','');
INSERT INTO ts_goodstag VALUES ('680','墨镜','700','');
INSERT INTO ts_goodstag VALUES ('681','西装','701','');
INSERT INTO ts_goodstag VALUES ('682','裙子','702','');
INSERT INTO ts_goodstag VALUES ('683','墨镜','704','');
INSERT INTO ts_goodstag VALUES ('684','墨镜','705','');
INSERT INTO ts_goodstag VALUES ('685','西装','706','');
INSERT INTO ts_goodstag VALUES ('686','西装','707','');
INSERT INTO ts_goodstag VALUES ('687','墨镜','708','');
INSERT INTO ts_goodstag VALUES ('688','裙子','709','');
INSERT INTO ts_goodstag VALUES ('689','背心','710','');
INSERT INTO ts_goodstag VALUES ('690','背心','711','');
INSERT INTO ts_goodstag VALUES ('691','裙子','712','');
INSERT INTO ts_goodstag VALUES ('692','衬衫','713','');
INSERT INTO ts_goodstag VALUES ('693','背心','714','');
INSERT INTO ts_goodstag VALUES ('694','短裤','715','');
INSERT INTO ts_goodstag VALUES ('695','西装','717','');
INSERT INTO ts_goodstag VALUES ('696','','718','');
INSERT INTO ts_goodstag VALUES ('697','西装','718','');
INSERT INTO ts_goodstag VALUES ('698','衬衫','719','');
INSERT INTO ts_goodstag VALUES ('699','西装','720','');
INSERT INTO ts_goodstag VALUES ('700','墨镜','721','');
INSERT INTO ts_goodstag VALUES ('701','墨镜','722','');
INSERT INTO ts_goodstag VALUES ('702','墨镜','723','');
INSERT INTO ts_goodstag VALUES ('703','墨镜','724','');
INSERT INTO ts_goodstag VALUES ('704','裙子','725','');
INSERT INTO ts_goodstag VALUES ('705','','726','短外套');
INSERT INTO ts_goodstag VALUES ('706','','726','短外套');
INSERT INTO ts_goodstag VALUES ('707','家居','726','短外套');
INSERT INTO ts_goodstag VALUES ('708','短外套','726','短外套');
INSERT INTO ts_goodstag VALUES ('709','家居','727','休闲长裤');
INSERT INTO ts_goodstag VALUES ('710','','727','休闲长裤');
INSERT INTO ts_goodstag VALUES ('711','一间房','727','休闲长裤');
INSERT INTO ts_goodstag VALUES ('712','裙子','730','');
INSERT INTO ts_goodstag VALUES ('713','衬衫','731','');
INSERT INTO ts_goodstag VALUES ('714','衣服','735','休闲长裤');
INSERT INTO ts_goodstag VALUES ('715','鞋子','737','休闲长裤');
INSERT INTO ts_goodstag VALUES ('716','包包','739','休闲长裤');
INSERT INTO ts_goodstag VALUES ('717','家居','740','休闲长裤');
INSERT INTO ts_goodstag VALUES ('718','衣服','740','休闲长裤');
INSERT INTO ts_goodstag VALUES ('719','包包','741','休闲长裤');
INSERT INTO ts_goodstag VALUES ('720','衣服','742','休闲长裤');
INSERT INTO ts_goodstag VALUES ('721','包','742','休闲长裤');
INSERT INTO ts_goodstag VALUES ('722','女裤','742','休闲长裤');
INSERT INTO ts_goodstag VALUES ('723','加厚','742','休闲长裤');
INSERT INTO ts_goodstag VALUES ('724','','742','休闲长裤');
INSERT INTO ts_goodstag VALUES ('725','靴裤','742','休闲长裤');
INSERT INTO ts_goodstag VALUES ('726','衣服','743','靴子');
INSERT INTO ts_goodstag VALUES ('727','','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('728','','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('729','','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('730','','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('731','','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('732','','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('733','复古','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('734','日系','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('735','公主','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('736','OL','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('737','纯棉','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('738','2011新款','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('739','衣服','745','羽绒服');
INSERT INTO ts_goodstag VALUES ('740','鞋子','746','羽绒服');
INSERT INTO ts_goodstag VALUES ('741','复古','746','羽绒服');
INSERT INTO ts_goodstag VALUES ('742','日系','746','羽绒服');
INSERT INTO ts_goodstag VALUES ('743','公主','746','羽绒服');
INSERT INTO ts_goodstag VALUES ('744','OL','746','羽绒服');
INSERT INTO ts_goodstag VALUES ('745','纯棉','746','羽绒服');
INSERT INTO ts_goodstag VALUES ('746','2011新款','746','羽绒服');
INSERT INTO ts_goodstag VALUES ('747','裙子','747','');
INSERT INTO ts_goodstag VALUES ('748','裙子','748','');
INSERT INTO ts_goodstag VALUES ('749','短裤','749','');
INSERT INTO ts_goodstag VALUES ('750','短裤','750','');
INSERT INTO ts_goodstag VALUES ('751','广东','751','');
INSERT INTO ts_goodstag VALUES ('752','日系','751','');
INSERT INTO ts_goodstag VALUES ('753','公主','751','');
INSERT INTO ts_goodstag VALUES ('754','OL','751','');
INSERT INTO ts_goodstag VALUES ('755','纯棉','751','');
INSERT INTO ts_goodstag VALUES ('756','2011新款','751','');
INSERT INTO ts_goodstag VALUES ('757','衣服','752','靴子');
INSERT INTO ts_goodstag VALUES ('758','休闲','753','');
INSERT INTO ts_goodstag VALUES ('759','复古','754','休闲长裤');
INSERT INTO ts_goodstag VALUES ('760','日系','754','休闲长裤');
INSERT INTO ts_goodstag VALUES ('761','公主','754','休闲长裤');
INSERT INTO ts_goodstag VALUES ('762','OL','754','休闲长裤');
INSERT INTO ts_goodstag VALUES ('763','纯棉','754','休闲长裤');
INSERT INTO ts_goodstag VALUES ('764','2011新款','754','休闲长裤');
INSERT INTO ts_goodstag VALUES ('765','包包','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('766','复古','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('767','日系','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('768','公主','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('769','OL','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('770','纯棉','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('771','2011新款','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('772','广东','761','');
INSERT INTO ts_goodstag VALUES ('773','日系','761','');
INSERT INTO ts_goodstag VALUES ('774','公主','761','');
INSERT INTO ts_goodstag VALUES ('775','OL','761','');
INSERT INTO ts_goodstag VALUES ('776','纯棉','761','');
INSERT INTO ts_goodstag VALUES ('777','2011新款','761','');
INSERT INTO ts_goodstag VALUES ('778','广东','762','');
INSERT INTO ts_goodstag VALUES ('779','日系','762','');
INSERT INTO ts_goodstag VALUES ('780','公主','762','');
INSERT INTO ts_goodstag VALUES ('781','OL','762','');
INSERT INTO ts_goodstag VALUES ('782','纯棉','762','');
INSERT INTO ts_goodstag VALUES ('783','2011新款','762','');
INSERT INTO ts_goodstag VALUES ('784','衣服','765','打底裤');
INSERT INTO ts_goodstag VALUES ('785','复古','765','打底裤');
INSERT INTO ts_goodstag VALUES ('786','日系','765','打底裤');
INSERT INTO ts_goodstag VALUES ('787','公主','765','打底裤');
INSERT INTO ts_goodstag VALUES ('788','OL','765','打底裤');
INSERT INTO ts_goodstag VALUES ('789','纯棉','765','打底裤');
INSERT INTO ts_goodstag VALUES ('790','2011新款','765','打底裤');
INSERT INTO ts_goodstag VALUES ('791','衣服','766','休闲长裤');
INSERT INTO ts_goodstag VALUES ('792','鞋子','767','休闲长裤');
INSERT INTO ts_goodstag VALUES ('793','衣服','769','打底裤');
INSERT INTO ts_goodstag VALUES ('794','衣服','774','打底裤');
INSERT INTO ts_goodstag VALUES ('795','衣服','776','休闲长裤');
INSERT INTO ts_goodstag VALUES ('796','衣服','777','打底裤');
INSERT INTO ts_goodstag VALUES ('797','衣服','778','打底裤');
INSERT INTO ts_goodstag VALUES ('798','衣服','779','休闲长裤');
INSERT INTO ts_goodstag VALUES ('799','衣服','780','打底裤');
INSERT INTO ts_goodstag VALUES ('800','衣服','759','打底裤');
INSERT INTO ts_goodstag VALUES ('801','复古','759','打底裤');
INSERT INTO ts_goodstag VALUES ('802','日系','759','打底裤');
INSERT INTO ts_goodstag VALUES ('803','公主','759','打底裤');
INSERT INTO ts_goodstag VALUES ('804','OL','759','打底裤');
INSERT INTO ts_goodstag VALUES ('805','纯棉','759','打底裤');
INSERT INTO ts_goodstag VALUES ('806','2011新款','759','打底裤');
INSERT INTO ts_goodstag VALUES ('807','衣服','760','休闲长裤');
INSERT INTO ts_goodstag VALUES ('808','衣服','766','连衣裙');
INSERT INTO ts_goodstag VALUES ('809','复古','766','连衣裙');
INSERT INTO ts_goodstag VALUES ('810','日系','766','连衣裙');
INSERT INTO ts_goodstag VALUES ('811','公主','766','连衣裙');
INSERT INTO ts_goodstag VALUES ('812','OL','766','连衣裙');
INSERT INTO ts_goodstag VALUES ('813','纯棉','766','连衣裙');
INSERT INTO ts_goodstag VALUES ('814','2011新款','766','连衣裙');
INSERT INTO ts_goodstag VALUES ('815','广东','767','');
INSERT INTO ts_goodstag VALUES ('816','日系','767','');
INSERT INTO ts_goodstag VALUES ('817','公主','767','');
INSERT INTO ts_goodstag VALUES ('818','OL','767','');
INSERT INTO ts_goodstag VALUES ('819','纯棉','767','');
INSERT INTO ts_goodstag VALUES ('820','2011新款','767','');
INSERT INTO ts_goodstag VALUES ('821','衣服','768','羽绒服');
INSERT INTO ts_goodstag VALUES ('822','冬装','768','羽绒服');
INSERT INTO ts_goodstag VALUES ('823','羽绒服','768','羽绒服');
INSERT INTO ts_goodstag VALUES ('824','衣服','769','牛仔裤');
INSERT INTO ts_goodstag VALUES ('825','韩版','769','牛仔裤');
INSERT INTO ts_goodstag VALUES ('826','牛仔裤','769','牛仔裤');
INSERT INTO ts_goodstag VALUES ('827','衣服','770','针织衫');
INSERT INTO ts_goodstag VALUES ('828','复古','770','针织衫');
INSERT INTO ts_goodstag VALUES ('829','日系','770','针织衫');
INSERT INTO ts_goodstag VALUES ('830','公主','770','针织衫');
INSERT INTO ts_goodstag VALUES ('831','OL','770','针织衫');
INSERT INTO ts_goodstag VALUES ('832','纯棉','770','针织衫');
INSERT INTO ts_goodstag VALUES ('833','2011新款','770','针织衫');
INSERT INTO ts_goodstag VALUES ('834','衣服','771','毛衣');
INSERT INTO ts_goodstag VALUES ('835','长袖','771','毛衣');
INSERT INTO ts_goodstag VALUES ('836','毛衣','771','毛衣');
INSERT INTO ts_goodstag VALUES ('837','高领','771','毛衣');
INSERT INTO ts_goodstag VALUES ('838','真丝棉','771','毛衣');
INSERT INTO ts_goodstag VALUES ('839','广东','773','');
INSERT INTO ts_goodstag VALUES ('840','日系','773','');
INSERT INTO ts_goodstag VALUES ('841','公主','773','');
INSERT INTO ts_goodstag VALUES ('842','OL','773','');
INSERT INTO ts_goodstag VALUES ('843','纯棉','773','');
INSERT INTO ts_goodstag VALUES ('844','2011新款','773','');
INSERT INTO ts_goodstag VALUES ('845','','774','');
INSERT INTO ts_goodstag VALUES ('846','','774','');
INSERT INTO ts_goodstag VALUES ('847','','774','');
INSERT INTO ts_goodstag VALUES ('848','','774','');
INSERT INTO ts_goodstag VALUES ('849','','774','');
INSERT INTO ts_goodstag VALUES ('850','','774','');
INSERT INTO ts_goodstag VALUES ('851','广东','774','');
INSERT INTO ts_goodstag VALUES ('852','日系','774','');
INSERT INTO ts_goodstag VALUES ('853','公主','774','');
INSERT INTO ts_goodstag VALUES ('854','OL','774','');
INSERT INTO ts_goodstag VALUES ('855','纯棉','774','');
INSERT INTO ts_goodstag VALUES ('856','2011新款','774','');
INSERT INTO ts_goodstag VALUES ('857','','775','');
INSERT INTO ts_goodstag VALUES ('858','','775','');
INSERT INTO ts_goodstag VALUES ('859','','775','');
INSERT INTO ts_goodstag VALUES ('860','','775','');
INSERT INTO ts_goodstag VALUES ('861','','775','');
INSERT INTO ts_goodstag VALUES ('862','','775','');
INSERT INTO ts_goodstag VALUES ('863','','775','');
INSERT INTO ts_goodstag VALUES ('864','','775','');
INSERT INTO ts_goodstag VALUES ('865','','775','');
INSERT INTO ts_goodstag VALUES ('866','','775','');
INSERT INTO ts_goodstag VALUES ('867','','775','');
INSERT INTO ts_goodstag VALUES ('868','','775','');
INSERT INTO ts_goodstag VALUES ('869','广东','775','');
INSERT INTO ts_goodstag VALUES ('870','日系','775','');
INSERT INTO ts_goodstag VALUES ('871','公主','775','');
INSERT INTO ts_goodstag VALUES ('872','OL','775','');
INSERT INTO ts_goodstag VALUES ('873','纯棉','775','');
INSERT INTO ts_goodstag VALUES ('874','2011新款','775','');
INSERT INTO ts_goodstag VALUES ('875','','776','');
INSERT INTO ts_goodstag VALUES ('876','','776','');
INSERT INTO ts_goodstag VALUES ('877','','776','');
INSERT INTO ts_goodstag VALUES ('878','','776','');
INSERT INTO ts_goodstag VALUES ('879','','776','');
INSERT INTO ts_goodstag VALUES ('880','','776','');
INSERT INTO ts_goodstag VALUES ('881','','776','');
INSERT INTO ts_goodstag VALUES ('882','','776','');
INSERT INTO ts_goodstag VALUES ('883','','776','');
INSERT INTO ts_goodstag VALUES ('884','','776','');
INSERT INTO ts_goodstag VALUES ('885','','776','');
INSERT INTO ts_goodstag VALUES ('886','','776','');
INSERT INTO ts_goodstag VALUES ('887','','776','');
INSERT INTO ts_goodstag VALUES ('888','','776','');
INSERT INTO ts_goodstag VALUES ('889','','776','');
INSERT INTO ts_goodstag VALUES ('890','','776','');
INSERT INTO ts_goodstag VALUES ('891','','776','');
INSERT INTO ts_goodstag VALUES ('892','','776','');
INSERT INTO ts_goodstag VALUES ('893','广东','776','');
INSERT INTO ts_goodstag VALUES ('894','日系','776','');
INSERT INTO ts_goodstag VALUES ('895','公主','776','');
INSERT INTO ts_goodstag VALUES ('896','OL','776','');
INSERT INTO ts_goodstag VALUES ('897','纯棉','776','');
INSERT INTO ts_goodstag VALUES ('898','2011新款','776','');
INSERT INTO ts_goodstag VALUES ('899','','780','');
INSERT INTO ts_goodstag VALUES ('900','','780','');
INSERT INTO ts_goodstag VALUES ('901','','780','');
INSERT INTO ts_goodstag VALUES ('902','','780','');
INSERT INTO ts_goodstag VALUES ('903','','780','');
INSERT INTO ts_goodstag VALUES ('904','','780','');
INSERT INTO ts_goodstag VALUES ('905','广东','780','');
INSERT INTO ts_goodstag VALUES ('906','日系','780','');
INSERT INTO ts_goodstag VALUES ('907','公主','780','');
INSERT INTO ts_goodstag VALUES ('908','OL','780','');
INSERT INTO ts_goodstag VALUES ('909','纯棉','780','');
INSERT INTO ts_goodstag VALUES ('910','2011新款','780','');
INSERT INTO ts_goodstag VALUES ('911','广东','782','');
INSERT INTO ts_goodstag VALUES ('912','日系','782','');
INSERT INTO ts_goodstag VALUES ('913','公主','782','');
INSERT INTO ts_goodstag VALUES ('914','OL','782','');
INSERT INTO ts_goodstag VALUES ('915','纯棉','782','');
INSERT INTO ts_goodstag VALUES ('916','2011新款','782','');
INSERT INTO ts_goodstag VALUES ('917','广东','783','');
INSERT INTO ts_goodstag VALUES ('918','日系','783','');
INSERT INTO ts_goodstag VALUES ('919','公主','783','');
INSERT INTO ts_goodstag VALUES ('920','OL','783','');
INSERT INTO ts_goodstag VALUES ('921','纯棉','783','');
INSERT INTO ts_goodstag VALUES ('922','2011新款','783','');
INSERT INTO ts_goodstag VALUES ('923','','784','');
INSERT INTO ts_goodstag VALUES ('924','','784','');
INSERT INTO ts_goodstag VALUES ('925','','784','');
INSERT INTO ts_goodstag VALUES ('926','','784','');
INSERT INTO ts_goodstag VALUES ('927','','784','');
INSERT INTO ts_goodstag VALUES ('928','','784','');
INSERT INTO ts_goodstag VALUES ('929','广东','784','');
INSERT INTO ts_goodstag VALUES ('930','日系','784','');
INSERT INTO ts_goodstag VALUES ('931','公主','784','');
INSERT INTO ts_goodstag VALUES ('932','OL','784','');
INSERT INTO ts_goodstag VALUES ('933','纯棉','784','');
INSERT INTO ts_goodstag VALUES ('934','2011新款','784','');
INSERT INTO ts_goodstag VALUES ('935','广东','785','');
INSERT INTO ts_goodstag VALUES ('936','日系','785','');
INSERT INTO ts_goodstag VALUES ('937','公主','785','');
INSERT INTO ts_goodstag VALUES ('938','OL','785','');
INSERT INTO ts_goodstag VALUES ('939','纯棉','785','');
INSERT INTO ts_goodstag VALUES ('940','2011新款','785','');
INSERT INTO ts_goodstag VALUES ('941','广东','786','');
INSERT INTO ts_goodstag VALUES ('942','日系','786','');
INSERT INTO ts_goodstag VALUES ('943','公主','786','');
INSERT INTO ts_goodstag VALUES ('944','OL','786','');
INSERT INTO ts_goodstag VALUES ('945','纯棉','786','');
INSERT INTO ts_goodstag VALUES ('946','2011新款','786','');
INSERT INTO ts_goodstag VALUES ('947','日系','787','');
INSERT INTO ts_goodstag VALUES ('948','公主','787','');
INSERT INTO ts_goodstag VALUES ('949','OL','787','');
INSERT INTO ts_goodstag VALUES ('950','纯棉','787','');
INSERT INTO ts_goodstag VALUES ('951','2011新款','787','');
INSERT INTO ts_goodstag VALUES ('952','衣服','788','毛衣');
INSERT INTO ts_goodstag VALUES ('953','外套','788','毛衣');
INSERT INTO ts_goodstag VALUES ('954','毛衣','788','毛衣');
INSERT INTO ts_goodstag VALUES ('955','衣服','789','休闲长裤');
INSERT INTO ts_goodstag VALUES ('956','女裤子','789','休闲长裤');
INSERT INTO ts_goodstag VALUES ('957','高腰','789','休闲长裤');
INSERT INTO ts_goodstag VALUES ('958','直筒','789','休闲长裤');
INSERT INTO ts_goodstag VALUES ('959','广东','790','');
INSERT INTO ts_goodstag VALUES ('960','日系','790','');
INSERT INTO ts_goodstag VALUES ('961','公主','790','');
INSERT INTO ts_goodstag VALUES ('962','OL','790','');
INSERT INTO ts_goodstag VALUES ('963','纯棉','790','');
INSERT INTO ts_goodstag VALUES ('964','2011新款','790','');
INSERT INTO ts_goodstag VALUES ('965','包包','793','包袋');
INSERT INTO ts_goodstag VALUES ('966','鞋子','793','包袋');
INSERT INTO ts_goodstag VALUES ('967','衣服','793','包袋');
INSERT INTO ts_goodstag VALUES ('968','配饰','793','包袋');
INSERT INTO ts_goodstag VALUES ('969','家居','793','包袋');
INSERT INTO ts_goodstag VALUES ('970','衣服','794','包袋');
INSERT INTO ts_goodstag VALUES ('971','菱格','794','包袋');
INSERT INTO ts_goodstag VALUES ('972','经典','794','包袋');
INSERT INTO ts_goodstag VALUES ('973','衣服','804','');
INSERT INTO ts_goodstag VALUES ('974','衣服','805','');
INSERT INTO ts_goodstag VALUES ('975','广东','806','');
INSERT INTO ts_goodstag VALUES ('976','日系','806','');
INSERT INTO ts_goodstag VALUES ('977','公主','806','');
INSERT INTO ts_goodstag VALUES ('978','OL','806','');
INSERT INTO ts_goodstag VALUES ('979','纯棉','806','');
INSERT INTO ts_goodstag VALUES ('980','2011新款','806','');
INSERT INTO ts_goodstag VALUES ('981','衣服','807','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('982','短裤','807','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('983','女装','807','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('984','纽扣','807','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('985','耳朵','807','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('986','鞋子','808','靴子');
INSERT INTO ts_goodstag VALUES ('987','短靴','808','靴子');
INSERT INTO ts_goodstag VALUES ('988','复古','808','靴子');
INSERT INTO ts_goodstag VALUES ('989','马丁','808','靴子');
INSERT INTO ts_goodstag VALUES ('990','冬季','808','靴子');
INSERT INTO ts_goodstag VALUES ('991','包包','809','包袋');
INSERT INTO ts_goodstag VALUES ('992','帆布','809','包袋');
INSERT INTO ts_goodstag VALUES ('993','红格子','809','包袋');
INSERT INTO ts_goodstag VALUES ('994','斜挎包','809','包袋');
INSERT INTO ts_goodstag VALUES ('995','','810','');
INSERT INTO ts_goodstag VALUES ('996','','810','');
INSERT INTO ts_goodstag VALUES ('997','','810','');
INSERT INTO ts_goodstag VALUES ('998','','810','');
INSERT INTO ts_goodstag VALUES ('999','家居','811','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1000','沙发','811','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1001','折叠','811','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1002','懒人沙发','811','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1003','衣服','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1004','热裤','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1005','韩版','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1006','休闲','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1007','粗毛线','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1008','口袋','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1009','冬装','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1010','下装','812','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1011','鞋子','813','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1012','牛津','813','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1013','学院风','813','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1014','欧美','813','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1015','复古','813','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1016','英伦','813','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1017','雕花','813','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1018','包包','814','包袋');
INSERT INTO ts_goodstag VALUES ('1019','可爱','814','包袋');
INSERT INTO ts_goodstag VALUES ('1020','小熊','814','包袋');
INSERT INTO ts_goodstag VALUES ('1021','格子','814','包袋');
INSERT INTO ts_goodstag VALUES ('1022','毛绒','814','包袋');
INSERT INTO ts_goodstag VALUES ('1023','棉袄','814','包袋');
INSERT INTO ts_goodstag VALUES ('1024','配饰','815','围巾/丝巾/披肩');
INSERT INTO ts_goodstag VALUES ('1025','粗线','815','围巾/丝巾/披肩');
INSERT INTO ts_goodstag VALUES ('1026','围巾','815','围巾/丝巾/披肩');
INSERT INTO ts_goodstag VALUES ('1027','家居','816','热水袋/暖手宝');
INSERT INTO ts_goodstag VALUES ('1028','圣诞','816','热水袋/暖手宝');
INSERT INTO ts_goodstag VALUES ('1029','可爱','816','热水袋/暖手宝');
INSERT INTO ts_goodstag VALUES ('1030','爱心','816','热水袋/暖手宝');
INSERT INTO ts_goodstag VALUES ('1031','毛绒','816','热水袋/暖手宝');
INSERT INTO ts_goodstag VALUES ('1032','热水袋','816','热水袋/暖手宝');
INSERT INTO ts_goodstag VALUES ('1033','家居','817','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1034','玫红','817','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1035','红豹','817','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1036','沙发','817','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1037','配饰','818','戒指/指环');
INSERT INTO ts_goodstag VALUES ('1038','钻石','818','戒指/指环');
INSERT INTO ts_goodstag VALUES ('1039','女戒','818','戒指/指环');
INSERT INTO ts_goodstag VALUES ('1040','指环','818','戒指/指环');
INSERT INTO ts_goodstag VALUES ('1041','尾戒','818','戒指/指环');
INSERT INTO ts_goodstag VALUES ('1042','韩国','818','戒指/指环');
INSERT INTO ts_goodstag VALUES ('1043','包包','819','包袋');
INSERT INTO ts_goodstag VALUES ('1044','牛皮','819','包袋');
INSERT INTO ts_goodstag VALUES ('1045','','819','包袋');
INSERT INTO ts_goodstag VALUES ('1046','','819','包袋');
INSERT INTO ts_goodstag VALUES ('1047','鞋子','820','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1048','公主','820','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1049','衣服','821','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1050','民族风','821','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1051','花多色','821','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1052','','822','');
INSERT INTO ts_goodstag VALUES ('1053','','822','');
INSERT INTO ts_goodstag VALUES ('1054','','822','');
INSERT INTO ts_goodstag VALUES ('1055','广东','822','');
INSERT INTO ts_goodstag VALUES ('1056','日系','822','');
INSERT INTO ts_goodstag VALUES ('1057','公主','822','');
INSERT INTO ts_goodstag VALUES ('1058','OL','822','');
INSERT INTO ts_goodstag VALUES ('1059','纯棉','822','');
INSERT INTO ts_goodstag VALUES ('1060','2011新款','822','');
INSERT INTO ts_goodstag VALUES ('1061','','823','');
INSERT INTO ts_goodstag VALUES ('1062','','823','');
INSERT INTO ts_goodstag VALUES ('1063','','823','');
INSERT INTO ts_goodstag VALUES ('1064','','823','');
INSERT INTO ts_goodstag VALUES ('1065','','823','');
INSERT INTO ts_goodstag VALUES ('1066','','823','');
INSERT INTO ts_goodstag VALUES ('1067','','823','');
INSERT INTO ts_goodstag VALUES ('1068','','823','');
INSERT INTO ts_goodstag VALUES ('1069','','823','');
INSERT INTO ts_goodstag VALUES ('1070','广东','823','');
INSERT INTO ts_goodstag VALUES ('1071','日系','823','');
INSERT INTO ts_goodstag VALUES ('1072','公主','823','');
INSERT INTO ts_goodstag VALUES ('1073','OL','823','');
INSERT INTO ts_goodstag VALUES ('1074','纯棉','823','');
INSERT INTO ts_goodstag VALUES ('1075','2011新款','823','');
INSERT INTO ts_goodstag VALUES ('1076','衣服','824','衬衫');
INSERT INTO ts_goodstag VALUES ('1077','衬衫','824','衬衫');
INSERT INTO ts_goodstag VALUES ('1078','拼色','824','衬衫');
INSERT INTO ts_goodstag VALUES ('1079','进口','824','衬衫');
INSERT INTO ts_goodstag VALUES ('1080','鞋子','825','靴子');
INSERT INTO ts_goodstag VALUES ('1081','牛筋底','825','靴子');
INSERT INTO ts_goodstag VALUES ('1082','雪地靴','825','靴子');
INSERT INTO ts_goodstag VALUES ('1083','正品','825','靴子');
INSERT INTO ts_goodstag VALUES ('1084','短靴','825','靴子');
INSERT INTO ts_goodstag VALUES ('1085','包包','826','包袋');
INSERT INTO ts_goodstag VALUES ('1086','秋冬','826','包袋');
INSERT INTO ts_goodstag VALUES ('1087','球包','826','包袋');
INSERT INTO ts_goodstag VALUES ('1088','韩版','826','包袋');
INSERT INTO ts_goodstag VALUES ('1089','女包包','826','包袋');
INSERT INTO ts_goodstag VALUES ('1090','配饰','827','其他配件');
INSERT INTO ts_goodstag VALUES ('1091','狐狸毛','827','其他配件');
INSERT INTO ts_goodstag VALUES ('1092','皮草','827','其他配件');
INSERT INTO ts_goodstag VALUES ('1093','腕饰','827','其他配件');
INSERT INTO ts_goodstag VALUES ('1094','家居','828','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1095','沙发','828','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1096','靠枕','828','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1097','帆布','828','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1098','小星星','828','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1099','','829','');
INSERT INTO ts_goodstag VALUES ('1100','','829','');
INSERT INTO ts_goodstag VALUES ('1101','','829','');
INSERT INTO ts_goodstag VALUES ('1102','','829','');
INSERT INTO ts_goodstag VALUES ('1103','','829','');
INSERT INTO ts_goodstag VALUES ('1104','广东','829','');
INSERT INTO ts_goodstag VALUES ('1105','日系','829','');
INSERT INTO ts_goodstag VALUES ('1106','公主','829','');
INSERT INTO ts_goodstag VALUES ('1107','OL','829','');
INSERT INTO ts_goodstag VALUES ('1108','纯棉','829','');
INSERT INTO ts_goodstag VALUES ('1109','2011新款','829','');
INSERT INTO ts_goodstag VALUES ('1110','','830','');
INSERT INTO ts_goodstag VALUES ('1111','','830','');
INSERT INTO ts_goodstag VALUES ('1112','','830','');
INSERT INTO ts_goodstag VALUES ('1113','','830','');
INSERT INTO ts_goodstag VALUES ('1114','','830','');
INSERT INTO ts_goodstag VALUES ('1115','','830','');
INSERT INTO ts_goodstag VALUES ('1116','','830','');
INSERT INTO ts_goodstag VALUES ('1117','','830','');
INSERT INTO ts_goodstag VALUES ('1118','','830','');
INSERT INTO ts_goodstag VALUES ('1119','','830','');
INSERT INTO ts_goodstag VALUES ('1120','','830','');
INSERT INTO ts_goodstag VALUES ('1121','广东','830','');
INSERT INTO ts_goodstag VALUES ('1122','日系','830','');
INSERT INTO ts_goodstag VALUES ('1123','公主','830','');
INSERT INTO ts_goodstag VALUES ('1124','OL','830','');
INSERT INTO ts_goodstag VALUES ('1125','纯棉','830','');
INSERT INTO ts_goodstag VALUES ('1126','2011新款','830','');
INSERT INTO ts_goodstag VALUES ('1127','广东','831','');
INSERT INTO ts_goodstag VALUES ('1128','日系','831','');
INSERT INTO ts_goodstag VALUES ('1129','公主','831','');
INSERT INTO ts_goodstag VALUES ('1130','OL','831','');
INSERT INTO ts_goodstag VALUES ('1131','纯棉','831','');
INSERT INTO ts_goodstag VALUES ('1132','2011新款','831','');
INSERT INTO ts_goodstag VALUES ('1133','','832','');
INSERT INTO ts_goodstag VALUES ('1134','','832','');
INSERT INTO ts_goodstag VALUES ('1135','','832','');
INSERT INTO ts_goodstag VALUES ('1136','','832','');
INSERT INTO ts_goodstag VALUES ('1137','','832','');
INSERT INTO ts_goodstag VALUES ('1138','','832','');
INSERT INTO ts_goodstag VALUES ('1139','广东','832','');
INSERT INTO ts_goodstag VALUES ('1140','日系','832','');
INSERT INTO ts_goodstag VALUES ('1141','公主','832','');
INSERT INTO ts_goodstag VALUES ('1142','OL','832','');
INSERT INTO ts_goodstag VALUES ('1143','纯棉','832','');
INSERT INTO ts_goodstag VALUES ('1144','2011新款','832','');
INSERT INTO ts_goodstag VALUES ('1145','包包','833','包袋');
INSERT INTO ts_goodstag VALUES ('1146','日单','833','包袋');
INSERT INTO ts_goodstag VALUES ('1147','双肩包','833','包袋');
INSERT INTO ts_goodstag VALUES ('1148','背包','833','包袋');
INSERT INTO ts_goodstag VALUES ('1149','毛茸茸','833','包袋');
INSERT INTO ts_goodstag VALUES ('1150','碎花','833','包袋');
INSERT INTO ts_goodstag VALUES ('1151','鞋子','834','靴子');
INSERT INTO ts_goodstag VALUES ('1152','经典','834','靴子');
INSERT INTO ts_goodstag VALUES ('1153','全柳钉','834','靴子');
INSERT INTO ts_goodstag VALUES ('1154','流苏','834','靴子');
INSERT INTO ts_goodstag VALUES ('1155','雪地靴','834','靴子');
INSERT INTO ts_goodstag VALUES ('1156','kite','834','靴子');
INSERT INTO ts_goodstag VALUES ('1157','衣服','835','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1158','苏格兰','835','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1159','格纹','835','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1160','荷叶','835','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1161','高腰','835','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1162','短裤','835','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1163','裙裤','835','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1164','配饰','836','围巾/丝巾/披肩');
INSERT INTO ts_goodstag VALUES ('1165','毛条','836','围巾/丝巾/披肩');
INSERT INTO ts_goodstag VALUES ('1166','毛兔','836','围巾/丝巾/披肩');
INSERT INTO ts_goodstag VALUES ('1167','球球','836','围巾/丝巾/披肩');
INSERT INTO ts_goodstag VALUES ('1168','家居','837','挂钟');
INSERT INTO ts_goodstag VALUES ('1169','台灯','837','挂钟');
INSERT INTO ts_goodstag VALUES ('1170','桌球','837','挂钟');
INSERT INTO ts_goodstag VALUES ('1171','挂钟','837','挂钟');
INSERT INTO ts_goodstag VALUES ('1172','包邮','837','挂钟');
INSERT INTO ts_goodstag VALUES ('1173','创意','837','挂钟');
INSERT INTO ts_goodstag VALUES ('1174','包包','838','包袋');
INSERT INTO ts_goodstag VALUES ('1175','欧美','838','包袋');
INSERT INTO ts_goodstag VALUES ('1176','真皮','838','包袋');
INSERT INTO ts_goodstag VALUES ('1177','复古','838','包袋');
INSERT INTO ts_goodstag VALUES ('1178','斜挎包','838','包袋');
INSERT INTO ts_goodstag VALUES ('1179','包包','839','包袋');
INSERT INTO ts_goodstag VALUES ('1180','真皮','839','包袋');
INSERT INTO ts_goodstag VALUES ('1181','欧美','839','包袋');
INSERT INTO ts_goodstag VALUES ('1182','复古','839','包袋');
INSERT INTO ts_goodstag VALUES ('1183','斜挎包','839','包袋');
INSERT INTO ts_goodstag VALUES ('1184','单肩包','839','包袋');
INSERT INTO ts_goodstag VALUES ('1185','复古','840','包袋');
INSERT INTO ts_goodstag VALUES ('1186','包包','840','包袋');
INSERT INTO ts_goodstag VALUES ('1187','斜挎包','840','包袋');
INSERT INTO ts_goodstag VALUES ('1188','牛皮','840','包袋');
INSERT INTO ts_goodstag VALUES ('1189','包包','841','包袋');
INSERT INTO ts_goodstag VALUES ('1190','可爱','841','包袋');
INSERT INTO ts_goodstag VALUES ('1191','毛绒','841','包袋');
INSERT INTO ts_goodstag VALUES ('1192','棉袄','841','包袋');
INSERT INTO ts_goodstag VALUES ('1193','单肩包','841','包袋');
INSERT INTO ts_goodstag VALUES ('1194','包包','842','包袋');
INSERT INTO ts_goodstag VALUES ('1195','晚宴','842','包袋');
INSERT INTO ts_goodstag VALUES ('1196','复古','842','包袋');
INSERT INTO ts_goodstag VALUES ('1197','VIVI','842','包袋');
INSERT INTO ts_goodstag VALUES ('1198','化妆包','842','包袋');
INSERT INTO ts_goodstag VALUES ('1199','配饰','843','手套');
INSERT INTO ts_goodstag VALUES ('1200','韩国','843','手套');
INSERT INTO ts_goodstag VALUES ('1201','复古','843','手套');
INSERT INTO ts_goodstag VALUES ('1202','蕾丝','843','手套');
INSERT INTO ts_goodstag VALUES ('1203','玫瑰','843','手套');
INSERT INTO ts_goodstag VALUES ('1204','花朵','843','手套');
INSERT INTO ts_goodstag VALUES ('1205','手套','843','手套');
INSERT INTO ts_goodstag VALUES ('1206','家居','844','床垫/床褥/床护垫/榻榻米床垫');
INSERT INTO ts_goodstag VALUES ('1207','床垫','844','床垫/床褥/床护垫/榻榻米床垫');
INSERT INTO ts_goodstag VALUES ('1208','小熊','844','床垫/床褥/床护垫/榻榻米床垫');
INSERT INTO ts_goodstag VALUES ('1209','榻榻米','844','床垫/床褥/床护垫/榻榻米床垫');
INSERT INTO ts_goodstag VALUES ('1210','睡垫','844','床垫/床褥/床护垫/榻榻米床垫');
INSERT INTO ts_goodstag VALUES ('1211','懒人沙发','844','床垫/床褥/床护垫/榻榻米床垫');
INSERT INTO ts_goodstag VALUES ('1212','沙发','844','床垫/床褥/床护垫/榻榻米床垫');
INSERT INTO ts_goodstag VALUES ('1213','','848','皮衣');
INSERT INTO ts_goodstag VALUES ('1214','','848','皮衣');
INSERT INTO ts_goodstag VALUES ('1215','衣服','857','皮衣');
INSERT INTO ts_goodstag VALUES ('1216','衣服','858','皮衣');
INSERT INTO ts_goodstag VALUES ('1217','衣服','859','皮衣');
INSERT INTO ts_goodstag VALUES ('1218','衣服','860','皮衣');
INSERT INTO ts_goodstag VALUES ('1219','衣服','862','皮衣');
INSERT INTO ts_goodstag VALUES ('1220','衣服','864','皮衣');
INSERT INTO ts_goodstag VALUES ('1221','鞋子','879','皮衣');
INSERT INTO ts_goodstag VALUES ('1222','衣服','880','皮衣');
INSERT INTO ts_goodstag VALUES ('1223','衣服','881','皮衣');
INSERT INTO ts_goodstag VALUES ('1224','衣服','898','');
INSERT INTO ts_goodstag VALUES ('1225','衣服','924','羽绒服');
INSERT INTO ts_goodstag VALUES ('1226','衣服','930','羽绒服');
INSERT INTO ts_goodstag VALUES ('1227','','959','包袋');
INSERT INTO ts_goodstag VALUES ('1228','包包','959','包袋');
INSERT INTO ts_goodstag VALUES ('1229','衣服','961','衬衫');
INSERT INTO ts_goodstag VALUES ('1230','衣服','962','毛衣');
INSERT INTO ts_goodstag VALUES ('1231','衣服','963','连衣裙');
INSERT INTO ts_goodstag VALUES ('1232','衣服','964','文胸');
INSERT INTO ts_goodstag VALUES ('1233','衣服','965','针织衫');
INSERT INTO ts_goodstag VALUES ('1234','包包','966','包袋');
INSERT INTO ts_goodstag VALUES ('1235','包包','967','包袋');
INSERT INTO ts_goodstag VALUES ('1236','衣服','984','针织衫');
INSERT INTO ts_goodstag VALUES ('1237','衣服','986','休闲长裤');
INSERT INTO ts_goodstag VALUES ('1238','衣服','987','休闲长裤');
INSERT INTO ts_goodstag VALUES ('1239','','988','包袋');
INSERT INTO ts_goodstag VALUES ('1240','包包','988','包袋');
INSERT INTO ts_goodstag VALUES ('1241','衣服','989','毛衣');
INSERT INTO ts_goodstag VALUES ('1242','衣服','990','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1243','衣服','991','衬衫');
INSERT INTO ts_goodstag VALUES ('1244','衣服','992','针织衫');
INSERT INTO ts_goodstag VALUES ('1245','衣服','993','毛衣');
INSERT INTO ts_goodstag VALUES ('1246','衣服','994','连衣裙');
INSERT INTO ts_goodstag VALUES ('1247','配饰','995','品牌手表/流行手表');
INSERT INTO ts_goodstag VALUES ('1248','衣服','1010','毛衣');
INSERT INTO ts_goodstag VALUES ('1249','鞋子','1011','打底裤');
INSERT INTO ts_goodstag VALUES ('1250','衣服','1012','棉衣/棉服');
INSERT INTO ts_goodstag VALUES ('1251','配饰','1013','品牌手表/流行手表');
INSERT INTO ts_goodstag VALUES ('1252','包包','1014','包袋');
INSERT INTO ts_goodstag VALUES ('1253','家居','1015','装饰台灯');
INSERT INTO ts_goodstag VALUES ('1254','配饰','1017','发饰');
INSERT INTO ts_goodstag VALUES ('1255','衣服','1018','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1256','配饰','1021','项链');
INSERT INTO ts_goodstag VALUES ('1257','衣服','1023','毛呢外套');
INSERT INTO ts_goodstag VALUES ('1258','衣服','1024','皮草');
INSERT INTO ts_goodstag VALUES ('1259','衣服','1050','毛衣');
INSERT INTO ts_goodstag VALUES ('1260','','1051','衬衫');
INSERT INTO ts_goodstag VALUES ('1261','衣服','1051','衬衫');
INSERT INTO ts_goodstag VALUES ('1262','衣服','1052','衬衫');
INSERT INTO ts_goodstag VALUES ('1263','衣服','1077','羽绒衣');
INSERT INTO ts_goodstag VALUES ('1264','家居','1143','T恤');
INSERT INTO ts_goodstag VALUES ('1265','配饰','1185','手链');
INSERT INTO ts_goodstag VALUES ('1266','衣服','1215','');
INSERT INTO ts_goodstag VALUES ('1267','衣服','1216','');
INSERT INTO ts_goodstag VALUES ('1268','衣服','1217','');
INSERT INTO ts_goodstag VALUES ('1269','','1225','苹果视频线/转换线');
INSERT INTO ts_goodstag VALUES ('1270','衣服','1228','毛衣');
INSERT INTO ts_goodstag VALUES ('1271','鞋子','1229','板鞋/休闲鞋');
INSERT INTO ts_goodstag VALUES ('1272','包包','1248','');
INSERT INTO ts_goodstag VALUES ('1273','鞋子','1259','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1274','衣服','1260','衬衫');
INSERT INTO ts_goodstag VALUES ('1275','配饰','1276','面膜/面膜粉');
INSERT INTO ts_goodstag VALUES ('1276','包包','1289','');
INSERT INTO ts_goodstag VALUES ('1277','衣服','1298','风衣');
INSERT INTO ts_goodstag VALUES ('1278','','1308','电视柜');
INSERT INTO ts_goodstag VALUES ('1279','家居','1308','电视柜');
INSERT INTO ts_goodstag VALUES ('1280','衣服','1346','文胸');
INSERT INTO ts_goodstag VALUES ('1281','配饰','1348','礼品袋/塑料袋');
INSERT INTO ts_goodstag VALUES ('1282','','1354','专业数码单反');
INSERT INTO ts_goodstag VALUES ('1283','','1354','专业数码单反');
INSERT INTO ts_goodstag VALUES ('1284','衣服','1379','衬衫');
INSERT INTO ts_goodstag VALUES ('1285','','1381','手机');
INSERT INTO ts_goodstag VALUES ('1286','家居','1381','手机');
INSERT INTO ts_goodstag VALUES ('1287','','1407','手机');
INSERT INTO ts_goodstag VALUES ('1288','','1428','照片墙');
INSERT INTO ts_goodstag VALUES ('1289','配饰','1428','照片墙');
INSERT INTO ts_goodstag VALUES ('1290','衣服','1458','衬衫');
INSERT INTO ts_goodstag VALUES ('1291','衣服','1459','Polo衫');
INSERT INTO ts_goodstag VALUES ('1292','衣服','1460','卫衣');
INSERT INTO ts_goodstag VALUES ('1293','衣服','1492','西装');
INSERT INTO ts_goodstag VALUES ('1294','衣服','1496','T恤');
INSERT INTO ts_goodstag VALUES ('1295','包包','1500','包袋');
INSERT INTO ts_goodstag VALUES ('1296','家居','1513','移动电源');
INSERT INTO ts_goodstag VALUES ('1297','','1515','移动电源');
INSERT INTO ts_goodstag VALUES ('1298','','1515','移动电源');
INSERT INTO ts_goodstag VALUES ('1299','家居','1515','移动电源');
INSERT INTO ts_goodstag VALUES ('1300','家居','1518','T恤');
INSERT INTO ts_goodstag VALUES ('1301','衣服','1540','T恤');
INSERT INTO ts_goodstag VALUES ('1302','衣服','1541','夹克');
INSERT INTO ts_goodstag VALUES ('1303','家居','1599','电视柜');
INSERT INTO ts_goodstag VALUES ('1304','衣服','1610','连衣裙');
INSERT INTO ts_goodstag VALUES ('1305','衣服','1625','文胸');
INSERT INTO ts_goodstag VALUES ('1306','衣服','1632','T恤');
INSERT INTO ts_goodstag VALUES ('1307','衣服','1633','连衣裙');
INSERT INTO ts_goodstag VALUES ('1308','衣服','1641','T恤');
INSERT INTO ts_goodstag VALUES ('1309','衣服','1642','T恤');
INSERT INTO ts_goodstag VALUES ('1310','衣服','1643','连衣裙');
INSERT INTO ts_goodstag VALUES ('1311','衣服','1644','连衣裙');
INSERT INTO ts_goodstag VALUES ('1312','','1645','梳子/化妆梳/按摩梳');
INSERT INTO ts_goodstag VALUES ('1313','配饰','1645','梳子/化妆梳/按摩梳');
INSERT INTO ts_goodstag VALUES ('1314','衣服','1646','香水');
INSERT INTO ts_goodstag VALUES ('1315','家居','1649','数码相框');
INSERT INTO ts_goodstag VALUES ('1316','家居','1650','电风扇');
INSERT INTO ts_goodstag VALUES ('1317','家居','1651','夹子/收纳夹子');
INSERT INTO ts_goodstag VALUES ('1318','家居','1652','创意礼品');
INSERT INTO ts_goodstag VALUES ('1319','家居','1655','摇摇杯');
INSERT INTO ts_goodstag VALUES ('1320','家居','1656','组合/迷你/卡通音响');
INSERT INTO ts_goodstag VALUES ('1321','家居','1658','玻璃杯');
INSERT INTO ts_goodstag VALUES ('1322','家居','1659','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1323','家居','1670','创意迷你植物');
INSERT INTO ts_goodstag VALUES ('1324','家居','1671','摄像头');
INSERT INTO ts_goodstag VALUES ('1325','家居','1672','餐具瓷器套装');
INSERT INTO ts_goodstag VALUES ('1326','家居','1675','餐具瓷器套装');
INSERT INTO ts_goodstag VALUES ('1327','衣服','1679','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1328','衣服','1680','T恤');
INSERT INTO ts_goodstag VALUES ('1329','衣服','1681','半身裙');
INSERT INTO ts_goodstag VALUES ('1330','衣服','1682','卫衣/绒衫');
INSERT INTO ts_goodstag VALUES ('1331','衣服','1683','T恤');
INSERT INTO ts_goodstag VALUES ('1332','衣服','1684','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1333','衣服','1685','风衣');
INSERT INTO ts_goodstag VALUES ('1334','家居','1690','懒人沙发');
INSERT INTO ts_goodstag VALUES ('1335','家居','1691','车用纸巾盒/套');
INSERT INTO ts_goodstag VALUES ('1336','衣服','1698','九分裤/七分裤');
INSERT INTO ts_goodstag VALUES ('1337','衣服','1699','九分裤/七分裤');
INSERT INTO ts_goodstag VALUES ('1338','衣服','1700','九分裤/七分裤');
INSERT INTO ts_goodstag VALUES ('1339','衣服','1701','衬衫');
INSERT INTO ts_goodstag VALUES ('1340','衣服','1702','衬衫');
INSERT INTO ts_goodstag VALUES ('1341','','1703','实木床');
INSERT INTO ts_goodstag VALUES ('1342','家居','1703','实木床');
INSERT INTO ts_goodstag VALUES ('1343','家居','1706','平板电脑/MID');
INSERT INTO ts_goodstag VALUES ('1344','家居','1707','平板电脑/MID');
INSERT INTO ts_goodstag VALUES ('1345','家居','1708','平板电脑/MID');
INSERT INTO ts_goodstag VALUES ('1346','家居','1709','手机');
INSERT INTO ts_goodstag VALUES ('1347','家居','1710','苹果保护套/保护壳');
INSERT INTO ts_goodstag VALUES ('1348','家居','1711','苹果保护套/保护壳');
INSERT INTO ts_goodstag VALUES ('1349','家居','1712','手机');
INSERT INTO ts_goodstag VALUES ('1350','衣服','1713','连衣裙');
INSERT INTO ts_goodstag VALUES ('1351','鞋子','1714','凉鞋');
INSERT INTO ts_goodstag VALUES ('1352','衣服','1715','T恤');
INSERT INTO ts_goodstag VALUES ('1353','衣服','1716','连衣裙');
INSERT INTO ts_goodstag VALUES ('1354','美妆','1717','防晒');
INSERT INTO ts_goodstag VALUES ('1355','美妆','1718','化妆水/爽肤水');
INSERT INTO ts_goodstag VALUES ('1356','配饰','1719','帽子');
INSERT INTO ts_goodstag VALUES ('1357','家居','1720','伞');
INSERT INTO ts_goodstag VALUES ('1358','美妆','1721','太阳眼镜');
INSERT INTO ts_goodstag VALUES ('1359','美妆','1722','唇膏/口红');
INSERT INTO ts_goodstag VALUES ('1360','美妆','1723','身体护理');
INSERT INTO ts_goodstag VALUES ('1361','家居','1733','挂钟');
INSERT INTO ts_goodstag VALUES ('1362','家居','1734','摆件');
INSERT INTO ts_goodstag VALUES ('1363','家居','1735','首饰盒/展示架');
INSERT INTO ts_goodstag VALUES ('1364','家居','1736','毛绒布艺类玩具');
INSERT INTO ts_goodstag VALUES ('1365','家居','1737','手机');
INSERT INTO ts_goodstag VALUES ('1366','家居','1738','其它电脑周边');
INSERT INTO ts_goodstag VALUES ('1367','家居','1739','旅行箱');
INSERT INTO ts_goodstag VALUES ('1368','美妆','1740','防晒');
INSERT INTO ts_goodstag VALUES ('1369','美妆','1741','身体护理');
INSERT INTO ts_goodstag VALUES ('1370','美妆','1742','唇部护理');
INSERT INTO ts_goodstag VALUES ('1371','美妆','1743','T区护理');
INSERT INTO ts_goodstag VALUES ('1372','家居','1744','创意/整蛊玩具');
INSERT INTO ts_goodstag VALUES ('1373','家居','1745','相册/相簿');
INSERT INTO ts_goodstag VALUES ('1374','家居','1746','餐具瓷器套装');
INSERT INTO ts_goodstag VALUES ('1375','家居','1747','电脑桌');
INSERT INTO ts_goodstag VALUES ('1376','家居','1748','PVC墙纸');
INSERT INTO ts_goodstag VALUES ('1377','家居','1749','调味瓶罐');
INSERT INTO ts_goodstag VALUES ('1378','家居','1750','茶几');
INSERT INTO ts_goodstag VALUES ('1379','衣服','1753','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1380','衣服','1754','抹胸');
INSERT INTO ts_goodstag VALUES ('1381','衣服','1755','衬衫');
INSERT INTO ts_goodstag VALUES ('1382','衣服','1756','连衣裙');
INSERT INTO ts_goodstag VALUES ('1383','衣服','1757','T恤');
INSERT INTO ts_goodstag VALUES ('1384','衣服','1758','连衣裙');
INSERT INTO ts_goodstag VALUES ('1385','衣服','1759','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1386','衣服','1760','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1387','家居','1762','墙贴');
INSERT INTO ts_goodstag VALUES ('1388','家居','1763','墙贴');
INSERT INTO ts_goodstag VALUES ('1389','家居','1764','墙贴');
INSERT INTO ts_goodstag VALUES ('1390','家居','1765','墙贴');
INSERT INTO ts_goodstag VALUES ('1391','家居','1766','墙贴');
INSERT INTO ts_goodstag VALUES ('1392','家居','1767','墙贴');
INSERT INTO ts_goodstag VALUES ('1393','衣服','1768','短裤/热裤');
INSERT INTO ts_goodstag VALUES ('1394','家居','1769','休闲长裤');
INSERT INTO ts_goodstag VALUES ('1395','美妆','1770','加湿器');
INSERT INTO ts_goodstag VALUES ('1396','美妆','1771','防晒');
INSERT INTO ts_goodstag VALUES ('1397','美妆','1772','假睫毛/假睫毛工具');
INSERT INTO ts_goodstag VALUES ('1398','美妆','1773','化妆/美容工具');
INSERT INTO ts_goodstag VALUES ('1399','美妆','1774','化妆/美容工具');
INSERT INTO ts_goodstag VALUES ('1400','美妆','1775','睫毛膏/睫毛增长液');
INSERT INTO ts_goodstag VALUES ('1401','美妆','1776','眼影');
INSERT INTO ts_goodstag VALUES ('1402','美妆','1777','BB霜');
INSERT INTO ts_goodstag VALUES ('1403','家居','1778','伞');
INSERT INTO ts_goodstag VALUES ('1404','配饰','1779','帽子');
INSERT INTO ts_goodstag VALUES ('1405','美妆','1780','手工皂/精油皂');
INSERT INTO ts_goodstag VALUES ('1406','美妆','1781','乳液/面霜');
INSERT INTO ts_goodstag VALUES ('1407','配饰','1782','帽子');
INSERT INTO ts_goodstag VALUES ('1408','美妆','1783','面膜/面膜粉');
INSERT INTO ts_goodstag VALUES ('1409','美妆','1784','眼影');
INSERT INTO ts_goodstag VALUES ('1410','美妆','1785','眼线');
INSERT INTO ts_goodstag VALUES ('1411','美妆','1786','粉底液/膏');
INSERT INTO ts_goodstag VALUES ('1412','衣服','1800','文胸');
INSERT INTO ts_goodstag VALUES ('1413','衣服','1801','文胸');
INSERT INTO ts_goodstag VALUES ('1414','衣服','1802','文胸');
INSERT INTO ts_goodstag VALUES ('1415','衣服','1803','文胸');
INSERT INTO ts_goodstag VALUES ('1416','衣服','1804','文胸');
INSERT INTO ts_goodstag VALUES ('1417','衣服','1805','文胸');
INSERT INTO ts_goodstag VALUES ('1418','衣服','1806','文胸');
INSERT INTO ts_goodstag VALUES ('1419','衣服','1807','文胸');
INSERT INTO ts_goodstag VALUES ('1420','衣服','1808','文胸套装');
INSERT INTO ts_goodstag VALUES ('1421','衣服','1809','文胸');
INSERT INTO ts_goodstag VALUES ('1422','美妆','1810','彩妆套装/彩妆盘');
INSERT INTO ts_goodstag VALUES ('1423','美妆','1811','唇彩/唇蜜');
INSERT INTO ts_goodstag VALUES ('1424','美妆','1812','眼线');
INSERT INTO ts_goodstag VALUES ('1425','美妆','1813','腮红/胭脂');
INSERT INTO ts_goodstag VALUES ('1426','美妆','1814','唇膏/口红');
INSERT INTO ts_goodstag VALUES ('1427','美妆','1815','蜜粉/散粉');
INSERT INTO ts_goodstag VALUES ('1428','美妆','1816','粉底液/膏');
INSERT INTO ts_goodstag VALUES ('1429','美妆','1817','粉底液/膏');
INSERT INTO ts_goodstag VALUES ('1430','美妆','1818','粉底液/膏');
INSERT INTO ts_goodstag VALUES ('1431','美妆','1819','粉底液/膏');
INSERT INTO ts_goodstag VALUES ('1432','包包','1834','包袋');
INSERT INTO ts_goodstag VALUES ('1433','包包','1835','包袋');
INSERT INTO ts_goodstag VALUES ('1434','包包','1836','包袋');
INSERT INTO ts_goodstag VALUES ('1435','包包','1837','包袋');
INSERT INTO ts_goodstag VALUES ('1436','鞋子','1841','凉鞋');
INSERT INTO ts_goodstag VALUES ('1437','鞋子','1842','凉鞋');
INSERT INTO ts_goodstag VALUES ('1438','鞋子','1843','凉鞋');
INSERT INTO ts_goodstag VALUES ('1439','鞋子','1844','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1440','鞋子','1845','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1441','鞋子','1846','凉鞋');
INSERT INTO ts_goodstag VALUES ('1442','鞋子','1847','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1443','鞋子','1848','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1444','鞋子','1849','低帮鞋');
INSERT INTO ts_goodstag VALUES ('1445','衣服','1854','连衣裙');
INSERT INTO ts_goodstag VALUES ('1446','衣服','1855','T恤');
INSERT INTO ts_goodstag VALUES ('1447','衣服','1856','休闲套装');
INSERT INTO ts_goodstag VALUES ('1448','衣服','1857','连衣裙');
INSERT INTO ts_goodstag VALUES ('1449','衣服','1858','T恤');
INSERT INTO ts_goodstag VALUES ('1450','衣服','1859','衬衫');
INSERT INTO ts_goodstag VALUES ('1451','衣服','1860','连衣裙');
INSERT INTO ts_goodstag VALUES ('1452','衣服','1865','T恤');
INSERT INTO ts_goodstag VALUES ('1453','衣服','1866','连衣裙');
INSERT INTO ts_goodstag VALUES ('1454','衣服','1867','连衣裙');
INSERT INTO ts_goodstag VALUES ('1455','衣服','1868','连衣裙');
INSERT INTO ts_goodstag VALUES ('1456','衣服','1869','连衣裙');
INSERT INTO ts_goodstag VALUES ('1457','衣服','1870','针织衫');
INSERT INTO ts_goodstag VALUES ('1458','衣服','1871','连衣裙');
INSERT INTO ts_goodstag VALUES ('1459','衣服','1872','连衣裙');
INSERT INTO ts_goodstag VALUES ('1460','衣服','1873','连衣裙');
INSERT INTO ts_goodstag VALUES ('1461','包包','1874','苹果笔记本包');
INSERT INTO ts_goodstag VALUES ('1462','包包','1875','包袋');
INSERT INTO ts_goodstag VALUES ('1463','包包','1876','包袋');
INSERT INTO ts_goodstag VALUES ('1464','包包','1877','包袋');
INSERT INTO ts_goodstag VALUES ('1465','衣服','1892','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1466','衣服','1893','专业摄影灯及其配件');
INSERT INTO ts_goodstag VALUES ('1467','衣服','1894','连衣裙');
INSERT INTO ts_goodstag VALUES ('1468','衣服','1895','连衣裙');
INSERT INTO ts_goodstag VALUES ('1469','衣服','1896','连衣裙');
INSERT INTO ts_goodstag VALUES ('1470','衣服','1897','连衣裙');
INSERT INTO ts_goodstag VALUES ('1471','衣服','1898','连衣裙');
INSERT INTO ts_goodstag VALUES ('1472','衣服','1899','衬衫');
INSERT INTO ts_goodstag VALUES ('1473','衣服','1900','针织衫');
INSERT INTO ts_goodstag VALUES ('1474','衣服','1901','风衣');
INSERT INTO ts_goodstag VALUES ('1475','衣服','1902','连衣裙');
INSERT INTO ts_goodstag VALUES ('1476','衣服','1903','衬衫');
INSERT INTO ts_goodstag VALUES ('1477','衣服','1904','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1478','衣服','1905','连衣裙');
INSERT INTO ts_goodstag VALUES ('1479','家居','1906','伞');
INSERT INTO ts_goodstag VALUES ('1480','包包','1907','包袋');
INSERT INTO ts_goodstag VALUES ('1481','包包','1908','包袋');
INSERT INTO ts_goodstag VALUES ('1482','包包','1909','包袋');
INSERT INTO ts_goodstag VALUES ('1483','包包','1910','登山包/双肩背包');
INSERT INTO ts_goodstag VALUES ('1484','包包','1911','包袋');
INSERT INTO ts_goodstag VALUES ('1485','包包','1912','包袋');
INSERT INTO ts_goodstag VALUES ('1486','包包','1913','登山包/双肩背包');
INSERT INTO ts_goodstag VALUES ('1487','家居','1914','衣架');
INSERT INTO ts_goodstag VALUES ('1488','家居','1915','其他收纳盒');
INSERT INTO ts_goodstag VALUES ('1489','家居','1916','现代装饰画');
INSERT INTO ts_goodstag VALUES ('1490','家居','1917','挂钟');
INSERT INTO ts_goodstag VALUES ('1491','家居','1919','定制窗帘');
INSERT INTO ts_goodstag VALUES ('1492','家居','1920','地毯');
INSERT INTO ts_goodstag VALUES ('1493','家居','1921','其它杂货');
INSERT INTO ts_goodstag VALUES ('1494','家居','1922','其他收纳篮');
INSERT INTO ts_goodstag VALUES ('1495','家居','1923','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1496','家居','1924','时尚烟灰缸');
INSERT INTO ts_goodstag VALUES ('1497','家居','1925','定制窗帘');
INSERT INTO ts_goodstag VALUES ('1498','家居','1926','装饰台灯');
INSERT INTO ts_goodstag VALUES ('1499','','1927','凉鞋');
INSERT INTO ts_goodstag VALUES ('1500','鞋子','1927','凉鞋');
INSERT INTO ts_goodstag VALUES ('1501','家居','1928','吊灯');
INSERT INTO ts_goodstag VALUES ('1502','家居','1929','被子/蚕丝被/羽绒被/棉被');
INSERT INTO ts_goodstag VALUES ('1503','家居','1930','壁饰');
INSERT INTO ts_goodstag VALUES ('1504','家居','1931','其它杂货');
INSERT INTO ts_goodstag VALUES ('1505','家居','1932','香薰蜡烛');
INSERT INTO ts_goodstag VALUES ('1506','家居','1933','装饰台灯');
INSERT INTO ts_goodstag VALUES ('1507','家居','1934','其他收纳盒');
INSERT INTO ts_goodstag VALUES ('1508','家居','1935','定制窗帘');
INSERT INTO ts_goodstag VALUES ('1509','鞋子','1936','家居拖鞋/凉拖/棉拖/居家鞋');
INSERT INTO ts_goodstag VALUES ('1510','家居','1937','座钟');
INSERT INTO ts_goodstag VALUES ('1511','家居','1938','首饰盒/展示架');
INSERT INTO ts_goodstag VALUES ('1512','衣服','1942','连衣裙');
INSERT INTO ts_goodstag VALUES ('1513','衣服','1943','连衣裙');
INSERT INTO ts_goodstag VALUES ('1514','衣服','1944','连衣裙');
INSERT INTO ts_goodstag VALUES ('1515','衣服','1945','连衣裙');
INSERT INTO ts_goodstag VALUES ('1516','衣服','1946','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1517','衣服','1947','衬衫');
INSERT INTO ts_goodstag VALUES ('1518','衣服','1948','休闲长裤');
INSERT INTO ts_goodstag VALUES ('1519','衣服','1954','连衣裙');
INSERT INTO ts_goodstag VALUES ('1520','衣服','1955','连衣裙');
INSERT INTO ts_goodstag VALUES ('1521','衣服','1956','连衣裙');
INSERT INTO ts_goodstag VALUES ('1522','衣服','1957','连衣裙');
INSERT INTO ts_goodstag VALUES ('1523','衣服','1958','衬衫');
INSERT INTO ts_goodstag VALUES ('1524','衣服','1959','连衣裙');
INSERT INTO ts_goodstag VALUES ('1525','衣服','1960','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1526','衣服','1973','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1527','衣服','1974','文胸');
INSERT INTO ts_goodstag VALUES ('1528','衣服','1975','旗袍');
INSERT INTO ts_goodstag VALUES ('1529','衣服','1976','T恤');
INSERT INTO ts_goodstag VALUES ('1530','衣服','1977','文胸');
INSERT INTO ts_goodstag VALUES ('1531','衣服','1978','文胸');
INSERT INTO ts_goodstag VALUES ('1532','衣服','1979','文胸');
INSERT INTO ts_goodstag VALUES ('1533','衣服','1980','文胸');
INSERT INTO ts_goodstag VALUES ('1534','衣服','1981','文胸');
INSERT INTO ts_goodstag VALUES ('1535','衣服','1982','文胸');
INSERT INTO ts_goodstag VALUES ('1536','衣服','1983','T恤');
INSERT INTO ts_goodstag VALUES ('1537','衣服','1984','连衣裙');
INSERT INTO ts_goodstag VALUES ('1538','衣服','1985','连衣裙');
INSERT INTO ts_goodstag VALUES ('1539','衣服','1986','旗袍');
INSERT INTO ts_goodstag VALUES ('1540','衣服','1987','连衣裙');
INSERT INTO ts_goodstag VALUES ('1541','衣服','1988','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1542','衣服','1989','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1543','衣服','1990','连衣裙');
INSERT INTO ts_goodstag VALUES ('1544','衣服','1991','连衣裙');
INSERT INTO ts_goodstag VALUES ('1545','衣服','1992','连衣裙');
INSERT INTO ts_goodstag VALUES ('1546','衣服','1993','连衣裙');
INSERT INTO ts_goodstag VALUES ('1547','衣服','1994','衬衫');
INSERT INTO ts_goodstag VALUES ('1548','衣服','1995','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1549','衣服','1996','衬衫');
INSERT INTO ts_goodstag VALUES ('1550','衣服','1997','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1551','衣服','1998','衬衫');
INSERT INTO ts_goodstag VALUES ('1552','衣服','1999','衬衫');
INSERT INTO ts_goodstag VALUES ('1553','衣服','2000','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1554','家居','2001','烛台');
INSERT INTO ts_goodstag VALUES ('1555','家居','2002','其它杂货');
INSERT INTO ts_goodstag VALUES ('1556','家居','2003','吊灯');
INSERT INTO ts_goodstag VALUES ('1557','家居','2004','定制窗帘');
INSERT INTO ts_goodstag VALUES ('1558','家居','2005','其他收纳盒');
INSERT INTO ts_goodstag VALUES ('1559','家居','2006','仿真植物盆景');
INSERT INTO ts_goodstag VALUES ('1560','衣服','2012','短外套');
INSERT INTO ts_goodstag VALUES ('1561','衣服','2013','针织衫');
INSERT INTO ts_goodstag VALUES ('1562','衣服','2014','短外套');
INSERT INTO ts_goodstag VALUES ('1563','衣服','2015','短外套');
INSERT INTO ts_goodstag VALUES ('1564','衣服','2022','连衣裙');
INSERT INTO ts_goodstag VALUES ('1565','衣服','2023','连衣裙');
INSERT INTO ts_goodstag VALUES ('1566','衣服','2024','连衣裙');
INSERT INTO ts_goodstag VALUES ('1567','衣服','2025','连衣裙');
INSERT INTO ts_goodstag VALUES ('1568','衣服','2026','连衣裙');
INSERT INTO ts_goodstag VALUES ('1569','衣服','2032','T恤');
INSERT INTO ts_goodstag VALUES ('1570','衣服','2033','连衣裙');
INSERT INTO ts_goodstag VALUES ('1571','衣服','2061','短外套');
INSERT INTO ts_goodstag VALUES ('1572','衣服','2062','T恤');
INSERT INTO ts_goodstag VALUES ('1573','衣服','2063','连衣裙');
INSERT INTO ts_goodstag VALUES ('1574','衣服','2066','连衣裙');
INSERT INTO ts_goodstag VALUES ('1575','衣服','2067','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1576','衣服','2069','文胸套装');
INSERT INTO ts_goodstag VALUES ('1577','衣服','2070','收纳箱');
INSERT INTO ts_goodstag VALUES ('1578','配饰','2071','发饰');
INSERT INTO ts_goodstag VALUES ('1579','美妆','2072','随身化妆镜');
INSERT INTO ts_goodstag VALUES ('1580','美妆','2073','BB霜');
INSERT INTO ts_goodstag VALUES ('1581','美妆','2074','睫毛膏/睫毛增长液');
INSERT INTO ts_goodstag VALUES ('1582','家居','2075','防丢器');
INSERT INTO ts_goodstag VALUES ('1583','家居','2076','湿巾');
INSERT INTO ts_goodstag VALUES ('1584','衣服','2077','文胸套装');
INSERT INTO ts_goodstag VALUES ('1585','','2078','发饰');
INSERT INTO ts_goodstag VALUES ('1586','配饰','2078','发饰');
INSERT INTO ts_goodstag VALUES ('1587','包包','2079','包袋');
INSERT INTO ts_goodstag VALUES ('1588','家居','2080','防丢器');
INSERT INTO ts_goodstag VALUES ('1589','家居','2081','一次成像（拍立得）');
INSERT INTO ts_goodstag VALUES ('1590','美妆','2082','香水');
INSERT INTO ts_goodstag VALUES ('1591','家居','2083','手电筒');
INSERT INTO ts_goodstag VALUES ('1592','包包','2084','包袋');
INSERT INTO ts_goodstag VALUES ('1593','家居','2085','传统/怀旧玩具');
INSERT INTO ts_goodstag VALUES ('1594','配饰','2086','耳环');
INSERT INTO ts_goodstag VALUES ('1595','家居','2087','口香糖');
INSERT INTO ts_goodstag VALUES ('1596','美妆','2088','腮红/胭脂');
INSERT INTO ts_goodstag VALUES ('1597','配饰','2089','腰带/皮带/腰链');
INSERT INTO ts_goodstag VALUES ('1598','衣服','2090','短袜/打底袜/丝袜/美腿袜');
INSERT INTO ts_goodstag VALUES ('1599','配饰','2091','项链');
INSERT INTO ts_goodstag VALUES ('1600','家居','2092','清凉油/防暑/醒神药油');
INSERT INTO ts_goodstag VALUES ('1601','家居','2093','手电筒');
INSERT INTO ts_goodstag VALUES ('1602','包包','2094','包袋');
INSERT INTO ts_goodstag VALUES ('1603','家居','2095','香熏香料');
INSERT INTO ts_goodstag VALUES ('1604','鞋子','2096','凉鞋');
INSERT INTO ts_goodstag VALUES ('1605','衣服','2108','连衣裙');
INSERT INTO ts_goodstag VALUES ('1606','衣服','2109','连衣裙');
INSERT INTO ts_goodstag VALUES ('1607','衣服','2110','T恤');
INSERT INTO ts_goodstag VALUES ('1608','衣服','2111','连衣裙');
INSERT INTO ts_goodstag VALUES ('1609','衣服','2112','西装');
INSERT INTO ts_goodstag VALUES ('1610','衣服','2113','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1611','衣服','2114','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1612','衣服','2115','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1613','衣服','2116','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1614','衣服','2117','休闲裤');
INSERT INTO ts_goodstag VALUES ('1615','衣服','2118','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1616','衣服','2119','休闲裤');
INSERT INTO ts_goodstag VALUES ('1617','衣服','2120','牛仔裤');
INSERT INTO ts_goodstag VALUES ('1618','衣服','2121','连衣裙');
INSERT INTO ts_goodstag VALUES ('1619','衣服','2122','连衣裙');
INSERT INTO ts_goodstag VALUES ('1620','衣服','2123','半身裙');
INSERT INTO ts_goodstag VALUES ('1621','衣服','2124','连衣裙');
INSERT INTO ts_goodstag VALUES ('1622','衣服','2125','连衣裙');
INSERT INTO ts_goodstag VALUES ('1623','衣服','2126','连衣裙');
INSERT INTO ts_goodstag VALUES ('1624','衣服','2127','连衣裙');
INSERT INTO ts_goodstag VALUES ('1625','衣服','2128','凉鞋');
INSERT INTO ts_goodstag VALUES ('1626','','2129','凉鞋');
INSERT INTO ts_goodstag VALUES ('1627','鞋子','2129','凉鞋');
INSERT INTO ts_goodstag VALUES ('1628','鞋子','2130','凉鞋');
INSERT INTO ts_goodstag VALUES ('1629','鞋子','2131','凉鞋');
INSERT INTO ts_goodstag VALUES ('1630','鞋子','2132','凉鞋');
INSERT INTO ts_goodstag VALUES ('1631','衣服','2133','凉鞋');
INSERT INTO ts_goodstag VALUES ('1632','','2134','凉鞋');
INSERT INTO ts_goodstag VALUES ('1633','鞋子','2134','凉鞋');
INSERT INTO ts_goodstag VALUES ('1634','鞋子','2135','凉鞋');
INSERT INTO ts_goodstag VALUES ('1635','衣服','2136','T恤');
INSERT INTO ts_goodstag VALUES ('1636','衣服','2137','蕾丝衫/雪纺衫');
INSERT INTO ts_goodstag VALUES ('1637','衣服','2138','T恤');
INSERT INTO ts_goodstag VALUES ('1638','衣服','2139','衬衫');
INSERT INTO ts_goodstag VALUES ('1639','衣服','2140','T恤');
INSERT INTO ts_goodstag VALUES ('1640','衣服','2141','T恤');
INSERT INTO ts_goodstag VALUES ('1641','衣服','2142','T恤');
INSERT INTO ts_goodstag VALUES ('1642','衣服','2151','西装');
INSERT INTO ts_goodstag VALUES ('1643','家居','2155','壁饰');
INSERT INTO ts_goodstag VALUES ('1644','家居','2156','壁灯');
INSERT INTO ts_goodstag VALUES ('1645','家居','2157','壁饰');
INSERT INTO ts_goodstag VALUES ('1646','家居','2158','装饰台灯');
INSERT INTO ts_goodstag VALUES ('1647','家居','2159','定制窗帘');
INSERT INTO ts_goodstag VALUES ('1648','家居','2160','定制窗帘');
INSERT INTO ts_goodstag VALUES ('1649','家居','2161','花瓶');
INSERT INTO ts_goodstag VALUES ('1650','家居','2162','靠垫/抱枕');
INSERT INTO ts_goodstag VALUES ('1651','家居','2163','现代装饰画');
INSERT INTO ts_goodstag VALUES ('1652','家居','2164','壁饰');
INSERT INTO ts_goodstag VALUES ('1653','家居','2165','花瓶');
INSERT INTO ts_goodstag VALUES ('1654','家居','2166','吊灯');
INSERT INTO ts_goodstag VALUES ('1655','家居','2167','壁饰');
INSERT INTO ts_goodstag VALUES ('1656','家居','2168','壁饰');
INSERT INTO ts_goodstag VALUES ('1657','家居','2169','布艺沙发');
INSERT INTO ts_goodstag VALUES ('1658','家居','2170','相框/画框');
INSERT INTO ts_goodstag VALUES ('1659','家居','2171','装饰台灯');
INSERT INTO ts_goodstag VALUES ('1660','家居','2172','纸巾套');
INSERT INTO ts_goodstag VALUES ('1661','家居','2173','浴室用品套件');
INSERT INTO ts_goodstag VALUES ('1662','衣服','2174','衬衫');
INSERT INTO ts_goodstag VALUES ('1663','家居','2175','装饰挂牌');
INSERT INTO ts_goodstag VALUES ('1664','家居','2176','壁饰');
INSERT INTO ts_goodstag VALUES ('1665','家居','2177','摆件');
INSERT INTO ts_goodstag VALUES ('1666','家居','2178','装饰台灯');
INSERT INTO ts_goodstag VALUES ('1667','家居','2179','装饰纸巾盒');
INSERT INTO ts_goodstag VALUES ('1668','家居','2180','壁灯');
INSERT INTO ts_goodstag VALUES ('1669','家居','2181','搁板/置物架');
INSERT INTO ts_goodstag VALUES ('1670','家居','2182','吊灯');
INSERT INTO ts_goodstag VALUES ('1671','家居','2183','壁饰');
INSERT INTO ts_goodstag VALUES ('1672','家居','2184','其他工艺饰品');
INSERT INTO ts_goodstag VALUES ('1673','家居','2185','壁饰');
INSERT INTO ts_goodstag VALUES ('1674','家居','2186','壁饰');
INSERT INTO ts_goodstag VALUES ('1675','衣服','2188','衬衫');

DROP TABLE IF EXISTS ts_invite_record;
CREATE TABLE `ts_invite_record` (
  `invite_record_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `fid` int(11) unsigned NOT NULL,
  `ctime` int(11) unsigned NOT NULL,
  PRIMARY KEY (`invite_record_id`),
  UNIQUE KEY `uid` (`uid`,`fid`),
  KEY `ctime` (`ctime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_invitecode;
CREATE TABLE `ts_invitecode` (
  `invite_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `code` varchar(120) NOT NULL,
  `is_used` tinyint(1) NOT NULL,
  `type` char(40) NOT NULL,
  `is_received` tinyint(1) NOT NULL,
  PRIMARY KEY (`invite_code_id`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_login;
CREATE TABLE `ts_login` (
  `login_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `type_uid` varchar(255) NOT NULL DEFAULT '',
  `type` char(80) NOT NULL,
  `oauth_token` varchar(150) DEFAULT NULL,
  `oauth_token_secret` varchar(150) DEFAULT NULL,
  `is_sync` tinyint(1) NOT NULL,
  PRIMARY KEY (`login_id`)
) ENGINE=MyISAM AUTO_INCREMENT=161 DEFAULT CHARSET=utf8;

INSERT INTO ts_login VALUES ('1','59','huilanweb','qq','3e7edde8a62e48bbad8bf8a8b8e4a854','9166ed0371b4fa673e70804d49f8ddc3','0');
INSERT INTO ts_login VALUES ('2','60','1897209012','sina','9bfa8c7807b8bf5c786a91cf1e6efe86','1743f670f1338a29b5045915e5c683fa','0');
INSERT INTO ts_login VALUES ('3','63','1849196987','sina','055a8e600ecf11c5938364795dc2fe46','ba208bebbde23186772a316581851e10','0');
INSERT INTO ts_login VALUES ('4','64','1771485932','sina','eda5f6533c14375b372151f6c3f61113','8fe7c1a55696ef67edca142b362de83b','0');
INSERT INTO ts_login VALUES ('5','65','1847365814','sina','977ddc658e075e981eade464784313ef','b3660b87dfe6dac72b46641ff181cb16','0');
INSERT INTO ts_login VALUES ('6','66','1352564331','sina','f6f10db97fd4ac8fda9665de9c51060f','99c9f65d4752ed13d914bab7799b9d0b','0');
INSERT INTO ts_login VALUES ('7','68','1644189537','sina','5fdfc811150242cdebc05b839f2b6fdb','4f27e647c4d4b903b71380eed0348a92','0');
INSERT INTO ts_login VALUES ('8','69','2073841733','sina','d3abc10366497d054fe228f3d4f1c4a1','960ac7e34c6c4fb9d80f5074b87c9670','0');
INSERT INTO ts_login VALUES ('9','72','1909948875','sina','bbdccbd58781ff32c3600c796aeb5dc2','8604f2ef0eb0c559e49e003c8e131aa8','0');
INSERT INTO ts_login VALUES ('10','74','zhouzeng','qq','46febf0bb25e43269e60ed3d1ab83c49','b29a54cf3dbc1357d8e11ca74ecf5549','0');
INSERT INTO ts_login VALUES ('11','78','1917879102','sina','1cbf4ef96e9e8be778a763e5ae1e2c43','c98b5a8233bf0e92b4199f51b4e8c527','0');
INSERT INTO ts_login VALUES ('12','83','1097598002','sina','b6112b6fb234f415e2b63e9f9e0cd6db','904f2e14ed30a5082e6274d23b769cbf','0');
INSERT INTO ts_login VALUES ('13','84','wubinlin','qq','650d31d549164323af0aaa3bde8d3807','99a202d04f0ec6e2a5acec51aa654c13','0');
INSERT INTO ts_login VALUES ('14','85','2218173142','sina','88e702ba11a2653667d21502b4c9184f','f027254ead02c572e9e33f4709e91c4c','1');
INSERT INTO ts_login VALUES ('15','87','1422967893','sina','b47c9cc831b331e119c190732ea2e0e1','2c7806d1dfa7f5c552f2942761705174','0');
INSERT INTO ts_login VALUES ('16','86','2218127860','sina','2b5ae7ac6ae43f92cdc8763ecea56453','0d791bc2b3eb4571c672e242d97a617a','0');
INSERT INTO ts_login VALUES ('17','90','ct_soft','qq','983c49afdd704394bfe7a7ad83253f48','64bd3d74bcab092efd82acc65c8cfd70','0');
INSERT INTO ts_login VALUES ('18','94','2316762022','sina','6bbd761f8276e561411e19bc18c9d645','0e68f22b3c8e5e421c4e9a76a2194154','0');
INSERT INTO ts_login VALUES ('19','95','2241746674','sina','ea77c089b69d7a9e0797b26a6427a6c6','73a6b3d476f3d6dbf4d408221711a366','0');
INSERT INTO ts_login VALUES ('20','96','1733018027','sina','d2f451fb4702dc7f51b35b0d461f2ad1','4ae55e428cc33a220ba5d28b987bcf1e','0');
INSERT INTO ts_login VALUES ('21','98','1911128172','sina','ac40eabb22c397891775fd635273d5c9','02f5991c8168d25ac6bd1a76619c3684','0');
INSERT INTO ts_login VALUES ('22','99','1658160227','sina','80601094fdbfd2e91dace6681ed7b24d','7178635668a4fbcc85ed9125e3081ccd','0');
INSERT INTO ts_login VALUES ('83','237','1760060045','sina','8f817b0c0a747ddf5318da5602f4326a','e5a8baa0fbf6bf89de51ebc4b2dcfc8b','0');
INSERT INTO ts_login VALUES ('24','103','1681402080','sina','90bdf1eacddb3c46857e4c27c9ba4a1a','462ecd77ce905b6b9a2f7ea27b9615ac','0');
INSERT INTO ts_login VALUES ('25','105','1593300162','sina','058d272f3664e9957aa251e62f760c8e','b6b4493f090aee7d9c1742653d898547','0');
INSERT INTO ts_login VALUES ('26','106','1671090721','sina','f862cb7b60cd619434caec3cb601b0ab','e03dce828b94e25140d364aa7b41fba1','0');
INSERT INTO ts_login VALUES ('27','107','1974860207','sina','eaa46fb95761616de88f253921178ae1','35cc4d767de120b0e11ce6ba93aeb2ba','0');
INSERT INTO ts_login VALUES ('28','109','piepiepie888','qq','56cecd5578a24db99a92f1520578f86c','f507432bab5da5861c11e89e4c70f302','0');
INSERT INTO ts_login VALUES ('29','111','1403285003','sina','b6c15e172bdf60fba2252c8475bba7e3','d89cec8908a32b1d39059499ec6a4d7a','0');
INSERT INTO ts_login VALUES ('30','112','1649437543','sina','c8d907e49be89a75f71e8cae75ef36bd','087f50b46edf6879ad53e5337ba6b428','0');
INSERT INTO ts_login VALUES ('31','349','1690851643','sina','5629375d6fc01bd0b327ad2ca7617437','b6e14d1e099a788aefb8a0a802140414','1');
INSERT INTO ts_login VALUES ('32','115','1933673972','sina','6d6c3ec9e8f3b071e62f8ce9586e8656','573793e0696351942c61fd33abddb66e','0');
INSERT INTO ts_login VALUES ('33','118','1665134691','sina','9fac4a2b7892d257226a3706c3467d2b','b6412e6e2e26e35bfacc0e2caea4aac6','0');
INSERT INTO ts_login VALUES ('34','119','ws536800','qq','c141371e82e64e1e8fc4e701608adc53','288bacdf875175d0f41c4431693a6ef0','0');
INSERT INTO ts_login VALUES ('35','120','xuetuan-com','qq','135d6a656b1a4f5eb1393a5a60885a4d','73b19aaca181bab84ce351036ca9451b','0');
INSERT INTO ts_login VALUES ('36','121','2089917241','sina','257db4c8b1eea95bcdc2b6e935bc0888','7c91979d85d4cfa119af7dd8a939b280','0');
INSERT INTO ts_login VALUES ('37','122','wxf19871222','qq','7afc1e3d9d9749639e41f5c07e7d8f64','cfb9efc5ba3d9b91513f5ca89def527c','0');
INSERT INTO ts_login VALUES ('38','123','2315246265','sina','041e4c1e8cd3569811f97632d07699c6','2fce98593621577001a71e4872ef5f6d','0');
INSERT INTO ts_login VALUES ('39','128','1839088033','sina','8f18e7ff392de1a92cb32033e0e7f95e','e97d3ed609b3b4f012bbdd1bc05110f4','0');
INSERT INTO ts_login VALUES ('40','129','chu_yu','qq','fc1dfb29eaf74f72b119bc2ebb684892','62b4673023b42089e5e0957fdd362ad5','0');
INSERT INTO ts_login VALUES ('41','131','lanxing35','qq','c9e7b0a868014b909747317237c95bf6','e3943243dadca5621911c5cbb152ef9b','0');
INSERT INTO ts_login VALUES ('42','134','1084624302','sina','9a504c47415bb4124128987aff7fd4fa','91889d3f84e252e636890c3187e2f12b','0');
INSERT INTO ts_login VALUES ('43','136','2304385740','sina','3536bcdb0e5be9f91a0b8f0c7ed8629b','a6865abe1f07739fdaa24d3b8bd2611c','0');
INSERT INTO ts_login VALUES ('44','126','1647603974','sina','1a905d302077f2ce5acd82cfc4822bcf','d8d66b50f2b525cd8a616c58176bd21c','1');
INSERT INTO ts_login VALUES ('45','139','2151763254','sina','7322cb622fe22a07ee41f23db54ab6bf','ad4b02c0dd01494e80a39d55324fa064','0');
INSERT INTO ts_login VALUES ('46','140','1650121273','sina','279e73ec1f51979bc988fad6a5e933c4','f2a10cc7555279d1329c62ad9a249a34','0');
INSERT INTO ts_login VALUES ('47','145','1899688273','sina','b2e739bd1094b83b4623fa82deb50e32','15931f58a50ff477ad9dd9a0b96429dc','0');
INSERT INTO ts_login VALUES ('48','153','1806489810','sina','2d7bf5d86ec6a249356a8bc31e7ff515','6fc507696f7e5689c771cf739029dd18','0');
INSERT INTO ts_login VALUES ('49','157','q5861860','qq','34e034a732164e45ad0fc541e2f47b87','215e8170731798b5188a821abcfe1947','0');
INSERT INTO ts_login VALUES ('50','158','2368328614','sina','5bc6c79fc371d257b28d3da1e95f5cdc','9f2b818aa437aaeca02c9e2dc3f43789','1');
INSERT INTO ts_login VALUES ('51','159','2242951561','sina','c431e869ef264a5342f6d1de98ce7587','07f164a3038803e02f5eb0e01a4d403f','0');
INSERT INTO ts_login VALUES ('52','160','mandy0723','qq','1f6c6e35df9047f4a06359d8423b93aa','f1ae40907abfad5705d70fce894e0caf','0');
INSERT INTO ts_login VALUES ('53','161','1886894617','sina','e3d2dabec29b58549723fb0be1104c4d','c11f204b667dea13c99533d9e41e0129','0');
INSERT INTO ts_login VALUES ('54','162','wubin21x','qq','8c2b55d26ba44d9cba56ae394e5bcf1d','b5a62c855510bc3c9f34bbd9b61f49ee','0');
INSERT INTO ts_login VALUES ('55','163','1889059874','sina','9f8fc13a0fb1567081d160c415ab34ed','825c0654e7f2a09322452c44e9fead57','1');
INSERT INTO ts_login VALUES ('56','164','kefu694632368','qq','313bb7c70d314ee3a796efa7e6ce3dc1','ca87d99719f29a5ce316d0428bfb7aa4','0');
INSERT INTO ts_login VALUES ('57','166','tuanmannian','qq','9c7b240ac9614258a3c409b6d14a271d','10799518b91f174b6542efad9969db3f','0');
INSERT INTO ts_login VALUES ('58','168','tqwhehe','qq','5e3b23ae44064652862edc42640447c4','ee7955325c77c529399dbd466a72c125','0');
INSERT INTO ts_login VALUES ('59','169','1684509943','sina','c94dfe46c9c45542e45694e4fe6ba704','b3c1935c025f7688b54f3f64c9d49843','0');
INSERT INTO ts_login VALUES ('60','171','cpslead','qq','bd986afc66f74e3dbcdff6d1b06dc4a1','3e3124dfd6502bd5f865fac4e0a0e140','0');
INSERT INTO ts_login VALUES ('61','172','1273323915','sina','f9144451d18bb44725b1b6ae8de72707','359089eabf36c9552b5ce276adf43080','0');
INSERT INTO ts_login VALUES ('62','173','alisister','qq','af3f4f732e3040749c6d9c96f2546c11','9baf7518d3ff95382a786c67002d43eb','0');
INSERT INTO ts_login VALUES ('63','174','2386225832','sina','56ec667ddd4525d44a7f933266361fa3','1b7e89b1d7390188ccb1d7d14af4672d','0');
INSERT INTO ts_login VALUES ('64','179','kaixinguo1984','qq','0461036bf3f64b5cb1425fb821be7d52','63eec682dc92cacd2243c44d1772f80d','0');
INSERT INTO ts_login VALUES ('65','181','widazhe','qq','f8312fa5a5de47c4933029cddb739621','9daf0b34e74437c817bb9ee9f8b9bc16','0');
INSERT INTO ts_login VALUES ('66','182','1772786224','sina','797126689c831e3567f15759d1cf62b4','17a80e248a1b297dea3cc7de5195e862','0');
INSERT INTO ts_login VALUES ('67','184','xernier','qq','ef2297615ae04757a1b648798d20b1d5','2fb2f611dc4e670bc283bfefa71df5fb','0');
INSERT INTO ts_login VALUES ('68','190','1270929711','sina','3778ef794386ff1fbc4c90b1ed62f65b','b3178d5c661f94c85ac44f1d4ecf9586','0');
INSERT INTO ts_login VALUES ('69','193','1684416087','sina','c9f1c2f6ec81735d46fc7341ac068940','0ad337ce962be5faa1662a3b0873a5db','0');
INSERT INTO ts_login VALUES ('70','197','china_19861007','qq','2ad00b55a3254fd9a0c6acec835411a9','d5d277fa2c66758f45aa42a1fc0ca9f6','0');
INSERT INTO ts_login VALUES ('71','199','a694898804','qq','7af85969b42248b890a11949ce2761e2','49f5c629af73d62d688ea1a8f1ee6056','0');
INSERT INTO ts_login VALUES ('72','200','1739424821','sina','c6cbbf74ddbfa33f2d813c91a0e22e36','4e2d0aef6d1b2b284f87a320caed78c7','0');
INSERT INTO ts_login VALUES ('73','202','2392500352','sina','e15e7ef04240c2ca3d9c8b6df90062ca','e165743b2c562217e079f25ef59aa0ea','0');
INSERT INTO ts_login VALUES ('74','208','1726801645','sina','780fe56479924ce088a34eb546e20b37','b1fc04aa1d236690946538d353f968f0','1');
INSERT INTO ts_login VALUES ('75','209','1926159067','sina','52dc7d1c280d43a5df63b78b92b367f7','c3761e5c92373894d32a4766f8c22173','0');
INSERT INTO ts_login VALUES ('76','210','1827324300','sina','730318c412f7069e31cdf41d1f87638a','13b60daf2a33518a5033e763ecfb02d2','1');
INSERT INTO ts_login VALUES ('77','215','2394528820','sina','8cba039a0d5197cc2352a993910d1260','c62818229734aa85113185e2223996d3','0');
INSERT INTO ts_login VALUES ('78','218','1642544711','sina','22feaab78bf98d6926248709c0ec734c','761e391d481e20986200c29522f51d92','0');
INSERT INTO ts_login VALUES ('79','223','1172003483','sina','8ba06e29007fb015a8f31d0bd7746140','f0fd3182f6e157569429b2ec9f187527','0');
INSERT INTO ts_login VALUES ('80','224','1953162980','sina','8986a6287be5ac3be89430f9a73759ba','54f12092b09cb97f5bff936f57fe3b4a','0');
INSERT INTO ts_login VALUES ('81','225','2119054587','sina','5688c2a15f2bec84e1e1b73e6319284f','fd5578f266f9e2e853c18483be634dce','0');
INSERT INTO ts_login VALUES ('82','230','1921759595','sina','56a8cdc0f8b319d4b66a8f28ef08bb8f','505e1479805f1a7b4f16c86eab8c6cab','0');
INSERT INTO ts_login VALUES ('84','240','2474831950','sina','0a7d8db7369f4085f7148524669417d0','3cd44e97473bdda4278c763fb7c4f788','0');
INSERT INTO ts_login VALUES ('85','244','1786023382','sina','5e4bf550609077a9a392b2dc3478a78f','a220d02acac079651f5e121b2026ae93','0');
INSERT INTO ts_login VALUES ('86','245','1911547771','sina','466808c0c0a40e11b24cb8da3fbb5596','b52f2aab790fa6e32935543fae15c7fb','1');
INSERT INTO ts_login VALUES ('87','246','1883612542','sina','5097e44d48582d41a90fc2a1c8ea999c','d7c40be637de26033e8e731f1bc65311','0');
INSERT INTO ts_login VALUES ('89','248','halolo','qq','824a3373682740dea0aa21bc02b662e5','f7c9153a60388f0d777471bb44caa122','0');
INSERT INTO ts_login VALUES ('90','254','retaocom','qq','372e4b726d334e10a54196e578324989','87802133f8568bdace16f0fb36cbbb3f','0');
INSERT INTO ts_login VALUES ('91','256','jiandu','qq','e1f63f6b71384a76b66bb036f9f9d3f6','4e857780de9cc5d67fe68d9c787b477e','0');
INSERT INTO ts_login VALUES ('92','259','1225479415','sina','c2c500a8293e01d96ae84e8c14ab79ff','47f388cf5b7dcb32aed5da5834ba6a67','1');
INSERT INTO ts_login VALUES ('93','261','1715841743','sina','ecd67987af872b8b38fbe054f39e7d5c','8ce8e891a9bc1f2d1b3d2ab7a56abea0','0');
INSERT INTO ts_login VALUES ('94','263','1777550373','sina','bbd446b6be8d405055c52223b63eba59','1040168c65364749b6b684e69c2bb056','0');
INSERT INTO ts_login VALUES ('95','264','otherbank','qq','132b7eb5975c44449e1013629b8be63e','3db49de580e1cb68e513ef5965b44b78','0');
INSERT INTO ts_login VALUES ('96','266','ribluef','qq','e8c334ecd78c4b64b67b4cd8c880eabc','8bc187e5f875d28cce9505250af6a940','0');
INSERT INTO ts_login VALUES ('97','270','1889502110','sina','795468b93bb3f81fbb2bf545fe511c2a','dae52c906d8762d86fea7a2e4aa5ca41','0');
INSERT INTO ts_login VALUES ('98','271','1681878105','sina','3720871e53785abbef211314ee5a1ee8','aa2a4b9a4bf64df08e1c6e102fedbdd9','0');
INSERT INTO ts_login VALUES ('99','273','ailituan','qq','25b137123c234b828bf0ea2a19dd5f8c','266620127c69dd97313702f456792394','0');
INSERT INTO ts_login VALUES ('100','274','1751729750','sina','85a84a779ed0764a2953c8ae603a104e','f0c040d25e092f200b664d2d4f76a099','0');
INSERT INTO ts_login VALUES ('101','277','Shixuan1986','qq','e663aed865334f7ea457fd62a2a876b0','2cf256753e0ebf3078f498f3fb1df4ac','0');
INSERT INTO ts_login VALUES ('102','278','2042380433','sina','257f5d8c61ef1a39223375ba0d153d9c','3bcc5e35355f5b9ba775acc47d1216c9','0');
INSERT INTO ts_login VALUES ('103','282','2458927002','sina','bdea7db0c1011dd9e962beb1f9df9416','18d7f9758ed598a4fffbdcbc118583f2','0');
INSERT INTO ts_login VALUES ('104','286','bianhuangji0','qq','3a229b1a8fd14a11b2f193bffc248ccd','2b4634d46577481ab3b2f75c48f3eb25','0');
INSERT INTO ts_login VALUES ('105','287','leocreative','qq','eb1724bc8d2e462fba0f8dd4c3407794','76fe9bf0715d1acca40117897720de1d','0');
INSERT INTO ts_login VALUES ('106','289','dhfffjuio','qq','f7f526448bf044dcbcb87a474c9a81e4','42dae112f953b9f546f2da79d62ff7ff','0');
INSERT INTO ts_login VALUES ('107','297','xiannaikefu','qq','a47c4e91ffa74930ab35965ebe21a5db','fbf2faf9081ee4d8eb144c9767b41183','0');
INSERT INTO ts_login VALUES ('108','298','Hi_Qin','qq','d8f6d143a309421987be15ba86f046ae','a8f1450736703edd0b479157cb3d8386','0');
INSERT INTO ts_login VALUES ('109','303','ttaomm','qq','6fa63c8602854cce9076484a4104bf24','2e3160a017c3eebbaa728cef7ac0c6ab','0');
INSERT INTO ts_login VALUES ('110','308','1843856330','sina','f20a1e8e43cceb9b48b873c7388f7b2a','c0fef5c714acdf40bf513a17689a59eb','1');
INSERT INTO ts_login VALUES ('111','309','1401124480','sina','402aa53dd18cb9252588a37ae1dcfdf9','be40c5d55e888b3cc334658bb8dbb530','0');
INSERT INTO ts_login VALUES ('112','313','NBniubi','qq','cef90e659b004441b491449f8f9d3888','138fc751b19fb16bd0ace2f07bf3df72','0');
INSERT INTO ts_login VALUES ('113','315','1724734044','sina','35e858e94a0e2c4d2a138cbe160b148a','ff437e1265a312c6d791ac2cf9aed5bd','0');
INSERT INTO ts_login VALUES ('114','320','1722028825','sina','0fab9fb370f15d65ba576dd934fd1f37','ae2a93569faa79f838640fc170cc21fd','0');
INSERT INTO ts_login VALUES ('115','325','hydrom','qq','2cd06564e8854f68afecae77c74b923d','7dbfa406ea1638791e5cc8ffaa27b7e0','0');
INSERT INTO ts_login VALUES ('116','326','xiutuo','qq','d8207ec0e2414918913c0545d2fcebc1','e85334ae0f302939252a754de7ca4047','0');
INSERT INTO ts_login VALUES ('117','328','1210043781','sina','a40da89dfaa68cc325d4b3c00c02e14c','8dc4ac5e3b3c3898fac188aa765d6c7e','0');
INSERT INTO ts_login VALUES ('118','333','2218699003','sina','cf68ebd78a696af94a36fd05846f1de6','4243a1d7f16f1f89113f3632b0be12c3','0');
INSERT INTO ts_login VALUES ('119','334','1774863593','sina','f5aff41a9b850d9aa9d7d78609256518','54049fd87dbfe953d703e59b7b9241df','0');
INSERT INTO ts_login VALUES ('144','2','1834110044','sina','c809cae957a30e512ac4ac2a795cd6b0','633eff4066dd9ccc71f9b0bddea69834','0');
INSERT INTO ts_login VALUES ('121','335','gabazui','qq','ef83672dcf7a4ebca89c1ba6be4e8771','637176e066c1c228a1f0749d8fd19cec','0');
INSERT INTO ts_login VALUES ('122','336','tushehui','qq','8bf665e880ff4ed7be6505d6fe7944c9','a95c0fa8d23ce7c002637ee8b752d543','0');
INSERT INTO ts_login VALUES ('123','339','sangebiao','qq','a8cc090523af4ef7a86ec4af48fb2a44','87704eb9fad8a5fad9fa126deb780a48','0');
INSERT INTO ts_login VALUES ('124','345','nibushiren','qq','53663b2842c946fb9214a41f80276bd8','20bbb8c62ae3605a9385d947215871e7','0');
INSERT INTO ts_login VALUES ('125','346','a951860724','qq','31dd29b5e3bf42e28a0a04194a149e8d','1d02d880d664169616ac72f0778dafbf','0');
INSERT INTO ts_login VALUES ('126','347','bbs99yrw','qq','5f5d5f8c1dca43e3a07aac90df12509a','ca375f5d89770d6edec7f420e6413fb8','0');
INSERT INTO ts_login VALUES ('127','354','2377094244','sina','b47c37ac7a0c72f5c6839c9c753577dd','22bb7818225fbccae698baa13fe76875','0');
INSERT INTO ts_login VALUES ('128','356','dreamSkyall','qq','6eb2a4f459c247a4b1faacd7ecee6035','6410a04061614fc9e08ee5ac3c3bd371','0');
INSERT INTO ts_login VALUES ('129','357','2219597513','sina','cdb05f605ee2bbedd2e0cd0e8e0361e8','14ea4a71b31f00c8351e50c5f09f69cb','0');
INSERT INTO ts_login VALUES ('130','360','1678626554','sina','a7233d44c477d42d86d5cfb0012793ff','39f9b3305ffda4eb90917c89c1d88324','0');
INSERT INTO ts_login VALUES ('131','361','1585346090','sina','8e8a9d7a0e6fb90e0b6b26dae41336dc','2a62e3abfd5a5c16068be206b55e6fed','0');
INSERT INTO ts_login VALUES ('132','362','soloman2005','qq','b7ce599308f949298aa6cd37cb77a554','2283bd3468996ee1a5699c2b6674bc07','0');
INSERT INTO ts_login VALUES ('133','364','skyedge09','qq','95fe18af857b4841bb3e8caf80fb8123','2bbe81d4ff5cfc72c317c3fdb3b46008','0');
INSERT INTO ts_login VALUES ('134','365','2500481540','sina','8c3e876de1babc0139093f2dcdc95901','71e930839820a19619c0c92fb8bc00e2','0');
INSERT INTO ts_login VALUES ('135','366','1796082880','sina','e962d5924194b3d7ca6c20230420915f','4d31d060c354be293e8fd6c9499aae28','0');
INSERT INTO ts_login VALUES ('136','373','sanniu2011','qq','a86e0c8ec8de4b4b92b1fb735c214d30','5e0c5dfa1e6d286e7a08e2375ebc1ac5','0');
INSERT INTO ts_login VALUES ('137','375','wokkkkkk','qq','f09272b117f8446792aaee258c031145','6305e5888f5bec0a3baebb16ec5571fb','0');
INSERT INTO ts_login VALUES ('138','376','haihun','qq','48c8725dbbca48e78f21fa61d27e92a9','70553b04d9811d3c74a900e2e4e79bf4','0');
INSERT INTO ts_login VALUES ('139','381','1581373697','sina','3cd06ed630bc01fa93232e60e818cb11','6bbfa9ef00dbdfca26492c6d66837145','0');
INSERT INTO ts_login VALUES ('140','382','lxcaijing','qq','7081c6b7332843a9a794eb735fb495dd','ecbdc3811b20731469f8dbcbf4c5588f','0');
INSERT INTO ts_login VALUES ('141','388','1823792675','sina','d21b2f7e76bef3d3f0e7afdf69e81842','ab9562a9cf7a14986e6aa7508ce374dd','0');
INSERT INTO ts_login VALUES ('142','391','1978865095','sina','298eff9928057b29086b29eb9a26e1a1','d2be7e71c565fff53db565f669943cf0','0');
INSERT INTO ts_login VALUES ('143','394','ngologo','qq','32a32f95359d406684214f5b527f6096','97f042c2a2d3be9b61c34d9701c8bf67','0');
INSERT INTO ts_login VALUES ('145','402','lvyoutonghang','qq','a8cebbae15794a04a555e0ac2b7efe23','4074fd1f3883715720fa324e6c54361c','0');
INSERT INTO ts_login VALUES ('146','404','wallyyang','qq','16fccef5afd44bd88de3bcdf29ab6e28','20bbdb432c53960dd9b0c92cc4c6778b','0');
INSERT INTO ts_login VALUES ('147','406','2270102505','sina','1ffb082cde33982930042dc0baa5e934','cdf1340bee094b20d6c7909f2f5497ad','0');
INSERT INTO ts_login VALUES ('148','407','v191234','qq','c7529f91e49947e08f169d678f93d6d6','2f3fed147e3c0af7340f037bc32280ed','0');
INSERT INTO ts_login VALUES ('149','424','1735423234','sina','61ef5e48d04fd671e280ffd2ce4649d8','7f6771de2c698080f4da92f5729c5dc1','0');
INSERT INTO ts_login VALUES ('150','427','hong461829717','qq','383000710e6941e58ad76703a816a82e','743c0c94920c7a8ad65678321f7be12f','0');
INSERT INTO ts_login VALUES ('152','433','1265813222','sina','d024041b753e69b14bf99c31de1fe78c','e762f8d49f6c91ccc669a880faf3ea9a','0');
INSERT INTO ts_login VALUES ('153','434','1667757444','sina','1a6b4cb8f976b0ed0a90e6c471a1cf93','819291c877e0ac62cfb977010cae28fb','0');
INSERT INTO ts_login VALUES ('154','435','2428714822','sina','b92c4742ded5087fc924ba4734eff60d','003e3d13846a6a1fb328d122df1221cf','0');
INSERT INTO ts_login VALUES ('155','437','2264852263','sina','d3b68fc44b62ddfcbf14cd449d38eb64','20517bacedf566a7ca6ae94715136eab','0');
INSERT INTO ts_login VALUES ('156','438','xiutuo','qq','d8207ec0e2414918913c0545d2fcebc1','e85334ae0f302939252a754de7ca4047','0');
INSERT INTO ts_login VALUES ('157','439','1658445622','sina','92b0364c0689bd42e8f6670250ecead4','06f7a15397d7cf3620ebd9b8a308abd3','0');
INSERT INTO ts_login VALUES ('158','441','2403673932','sina','6d7024401b54545e5c98ccf911446ba6','96404db9634858ce7a7749dfd328d271','0');
INSERT INTO ts_login VALUES ('159','446','2532458063','sina','6e96a3ea6ac8cc7799bc168aa96192b3','ce02b717eeb651912c1af0eab291b2b6','0');
INSERT INTO ts_login VALUES ('160','448','liumupeng','qq','efab7439e8bd4c57b1f66f52af4036b0','98ebb944f01fd2f19459bcac12d7d71a','0');

DROP TABLE IF EXISTS ts_login_record;
CREATE TABLE `ts_login_record` (
  `login_record_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `place` varchar(255) DEFAULT NULL,
  `ctime` int(11) DEFAULT NULL,
  PRIMARY KEY (`login_record_id`)
) ENGINE=MyISAM AUTO_INCREMENT=132 DEFAULT CHARSET=utf8;

INSERT INTO ts_login_record VALUES ('1','2','123.138.199.26','- 陕西省 - 网通','1333981808');
INSERT INTO ts_login_record VALUES ('2','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334029948');
INSERT INTO ts_login_record VALUES ('3','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334030024');
INSERT INTO ts_login_record VALUES ('4','2','123.138.199.26','- 陕西省 - 网通','1334036075');
INSERT INTO ts_login_record VALUES ('5','1','123.138.199.26','- 陕西省 - 网通','1334036858');
INSERT INTO ts_login_record VALUES ('6','1','123.138.199.26','- 陕西省 - 网通','1334038241');
INSERT INTO ts_login_record VALUES ('7','1','123.138.199.26','- 陕西省 - 网通','1334038926');
INSERT INTO ts_login_record VALUES ('8','1','123.138.199.26','- 陕西省 - 网通','1334038945');
INSERT INTO ts_login_record VALUES ('9','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334045646');
INSERT INTO ts_login_record VALUES ('10','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334049598');
INSERT INTO ts_login_record VALUES ('11','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334050882');
INSERT INTO ts_login_record VALUES ('12','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334051807');
INSERT INTO ts_login_record VALUES ('13','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334052016');
INSERT INTO ts_login_record VALUES ('14','1','123.138.199.26','- 陕西省 - 网通','1334057232');
INSERT INTO ts_login_record VALUES ('15','2','123.138.199.26','- 陕西省 - 网通','1334060657');
INSERT INTO ts_login_record VALUES ('16','2','123.138.199.26','- 陕西省 - 网通','1334063977');
INSERT INTO ts_login_record VALUES ('17','31','123.138.199.26','- 陕西省 - 网通','1334068280');
INSERT INTO ts_login_record VALUES ('18','31','123.138.199.26','- 陕西省 - 网通','1334069232');
INSERT INTO ts_login_record VALUES ('19','31','123.138.199.26','- 陕西省 - 网通','1334069534');
INSERT INTO ts_login_record VALUES ('20','1','123.138.199.26','- 陕西省 - 网通','1334069602');
INSERT INTO ts_login_record VALUES ('21','1','123.138.199.26','- 陕西省 - 网通','1334072596');
INSERT INTO ts_login_record VALUES ('22','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334107026');
INSERT INTO ts_login_record VALUES ('23','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334113941');
INSERT INTO ts_login_record VALUES ('24','452','123.121.33.62','- 北京市 - 网通','1334113959');
INSERT INTO ts_login_record VALUES ('25','31','123.121.33.62','- 北京市 - 网通','1334114231');
INSERT INTO ts_login_record VALUES ('26','31','123.121.33.62','- 北京市 - 网通','1334114430');
INSERT INTO ts_login_record VALUES ('27','1','123.138.199.26','- 陕西省 - 网通','1334120832');
INSERT INTO ts_login_record VALUES ('28','452','122.200.77.195','- 北京市 - 合聚数字技术','1334133382');
INSERT INTO ts_login_record VALUES ('29','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334133754');
INSERT INTO ts_login_record VALUES ('30','452','123.121.33.62','- 北京市 - 网通','1334136828');
INSERT INTO ts_login_record VALUES ('31','1','123.138.199.26','- 陕西省 - 网通','1334145905');
INSERT INTO ts_login_record VALUES ('32','1','123.138.199.26','- 陕西省 - 网通','1334148550');
INSERT INTO ts_login_record VALUES ('33','1','123.138.199.26','- 陕西省 - 网通','1334153537');
INSERT INTO ts_login_record VALUES ('34','2','123.138.199.26','- 陕西省 - 网通','1334154129');
INSERT INTO ts_login_record VALUES ('35','1','123.138.199.26','- 陕西省 - 网通','1334198086');
INSERT INTO ts_login_record VALUES ('36','1','123.138.199.26','- 陕西省 - 网通','1334200336');
INSERT INTO ts_login_record VALUES ('37','2','123.138.199.26','- 陕西省 - 网通','1334200371');
INSERT INTO ts_login_record VALUES ('38','1','123.138.199.26','- 陕西省 - 网通','1334200654');
INSERT INTO ts_login_record VALUES ('39','1','123.138.199.26','- 陕西省 - 网通','1334219486');
INSERT INTO ts_login_record VALUES ('40','1','123.138.199.26','- 陕西省 - 网通','1334220514');
INSERT INTO ts_login_record VALUES ('41','1','123.138.199.26','- 陕西省 - 网通','1334221381');
INSERT INTO ts_login_record VALUES ('42','2','123.138.199.26','- 陕西省 - 网通','1334278565');
INSERT INTO ts_login_record VALUES ('43','1','123.138.199.26','- 陕西省 - 网通','1334279497');
INSERT INTO ts_login_record VALUES ('44','31','123.138.199.26','- 陕西省 - 网通','1334283187');
INSERT INTO ts_login_record VALUES ('45','1','123.138.199.26','- 陕西省 - 网通','1334288878');
INSERT INTO ts_login_record VALUES ('46','1','123.138.199.26','- 陕西省 - 网通','1334300054');
INSERT INTO ts_login_record VALUES ('47','1','123.138.199.26','- 陕西省 - 网通','1334308225');
INSERT INTO ts_login_record VALUES ('48','1','123.138.199.26','- 陕西省 - 网通','1334309653');
INSERT INTO ts_login_record VALUES ('49','1','123.138.199.26','- 陕西省 - 网通','1334311597');
INSERT INTO ts_login_record VALUES ('50','2','123.138.199.26','- 陕西省 - 网通','1334311623');
INSERT INTO ts_login_record VALUES ('51','2','123.138.199.26','- 陕西省 - 网通','1334314560');
INSERT INTO ts_login_record VALUES ('52','1','123.138.199.26','- 陕西省 - 网通','1334314697');
INSERT INTO ts_login_record VALUES ('53','1','123.138.199.26','- 陕西省 - 网通','1334327754');
INSERT INTO ts_login_record VALUES ('54','1','123.138.199.26','- 陕西省 - 网通','1334376586');
INSERT INTO ts_login_record VALUES ('55','1','123.138.199.26','- 陕西省 - 网通','1334379498');
INSERT INTO ts_login_record VALUES ('56','1','123.138.199.26','- 陕西省 - 网通','1334403714');
INSERT INTO ts_login_record VALUES ('57','1','123.138.199.26','- 陕西省 - 网通','1334408710');
INSERT INTO ts_login_record VALUES ('58','1','123.138.199.26','- 陕西省 - 网通','1334456047');
INSERT INTO ts_login_record VALUES ('59','1','123.138.199.26','- 陕西省 - 网通','1334457206');
INSERT INTO ts_login_record VALUES ('60','1','123.138.199.26','- 陕西省 - 网通','1334461396');
INSERT INTO ts_login_record VALUES ('61','453','119.131.59.183','- APNIC','1334469296');
INSERT INTO ts_login_record VALUES ('62','1','123.138.199.26','- 陕西省 - 网通','1334469473');
INSERT INTO ts_login_record VALUES ('63','454','113.67.75.95','- IANA','1334469635');
INSERT INTO ts_login_record VALUES ('64','1','123.138.199.26','- 陕西省 - 网通','1334470422');
INSERT INTO ts_login_record VALUES ('65','1','123.138.199.26','- 陕西省 - 网通','1334472136');
INSERT INTO ts_login_record VALUES ('66','1','123.138.199.26','- 陕西省 - 网通','1334477662');
INSERT INTO ts_login_record VALUES ('67','454','14.145.134.91','- 美国','1334477982');
INSERT INTO ts_login_record VALUES ('68','454','119.131.56.147','- APNIC','1334480559');
INSERT INTO ts_login_record VALUES ('69','1','123.138.199.26','- 陕西省 - 网通','1334494432');
INSERT INTO ts_login_record VALUES ('70','454','113.67.72.119','- IANA','1334495924');
INSERT INTO ts_login_record VALUES ('71','454','183.5.239.170','- Unknown','1334500465');
INSERT INTO ts_login_record VALUES ('72','454','113.67.75.95','- IANA','1334500748');
INSERT INTO ts_login_record VALUES ('73','454','14.145.121.239','- 美国','1334500799');
INSERT INTO ts_login_record VALUES ('74','1','123.138.199.26','- 陕西省 - 网通','1334500835');
INSERT INTO ts_login_record VALUES ('75','1','123.138.199.26','- 陕西省 - 网通','1334500855');
INSERT INTO ts_login_record VALUES ('76','1','123.138.199.26','- 陕西省 - 网通','1334501463');
INSERT INTO ts_login_record VALUES ('77','1','123.138.199.26','- 陕西省 - 网通','1334504678');
INSERT INTO ts_login_record VALUES ('78','454','113.119.185.156','- IANA','1334505783');
INSERT INTO ts_login_record VALUES ('79','454','183.5.239.32','- Unknown','1334505820');
INSERT INTO ts_login_record VALUES ('80','1','123.138.199.26','- 陕西省 - 网通','1334509624');
INSERT INTO ts_login_record VALUES ('81','1','123.138.199.26','- 陕西省 - 网通','1334510145');
INSERT INTO ts_login_record VALUES ('82','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334545290');
INSERT INTO ts_login_record VALUES ('83','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334545684');
INSERT INTO ts_login_record VALUES ('84','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334549133');
INSERT INTO ts_login_record VALUES ('85','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334549133');
INSERT INTO ts_login_record VALUES ('86','455','183.16.25.117','- Unknown','1334564367');
INSERT INTO ts_login_record VALUES ('87','1','123.138.199.23','- 陕西省 - 网通','1334564498');
INSERT INTO ts_login_record VALUES ('88','1','123.138.199.23','- 陕西省 - 网通','1334564650');
INSERT INTO ts_login_record VALUES ('89','1','123.138.199.23','- 陕西省 - 网通','1334564773');
INSERT INTO ts_login_record VALUES ('90','1','123.138.199.26','- 陕西省 - 网通','1334580431');
INSERT INTO ts_login_record VALUES ('91','31','61.154.204.122','- 福建省厦门市 - 电信','1334580503');
INSERT INTO ts_login_record VALUES ('92','31','61.154.204.122','- 福建省厦门市 - 电信','1334580503');
INSERT INTO ts_login_record VALUES ('93','337','61.182.70.162','- 河北省沧州市 - 网通','1334581978');
INSERT INTO ts_login_record VALUES ('94','1','123.138.199.26','- 陕西省 - 网通','1334588073');
INSERT INTO ts_login_record VALUES ('95','1','123.138.199.26','- 陕西省 - 网通','1334588338');
INSERT INTO ts_login_record VALUES ('96','1','123.138.199.26','- 陕西省 - 网通','1334588358');
INSERT INTO ts_login_record VALUES ('97','1','123.138.199.26','- 陕西省 - 网通','1334591655');
INSERT INTO ts_login_record VALUES ('98','1','123.138.199.26','- 陕西省 - 网通','1334591668');
INSERT INTO ts_login_record VALUES ('99','456','123.9.14.162','- 河南省 - 网通','1334623777');
INSERT INTO ts_login_record VALUES ('100','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334629388');
INSERT INTO ts_login_record VALUES ('101','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334629602');
INSERT INTO ts_login_record VALUES ('102','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334630247');
INSERT INTO ts_login_record VALUES ('103','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334634641');
INSERT INTO ts_login_record VALUES ('104','1','123.138.199.26','- 陕西省 - 网通','1334643182');
INSERT INTO ts_login_record VALUES ('105','1','123.138.199.26','- 陕西省 - 网通','1334663041');
INSERT INTO ts_login_record VALUES ('106','1','123.138.199.26','- 陕西省 - 网通','1334663085');
INSERT INTO ts_login_record VALUES ('107','2','123.138.199.26','- 陕西省 - 网通','1334663213');
INSERT INTO ts_login_record VALUES ('108','1','123.138.199.26','- 陕西省 - 网通','1334665014');
INSERT INTO ts_login_record VALUES ('109','457','115.152.230.120','- IANA','1334670143');
INSERT INTO ts_login_record VALUES ('110','454','14.145.121.70','- 美国','1334706149');
INSERT INTO ts_login_record VALUES ('111','454','14.145.121.70','- 美国','1334706149');
INSERT INTO ts_login_record VALUES ('112','454','183.5.237.15','- Unknown','1334706212');
INSERT INTO ts_login_record VALUES ('113','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334711924');
INSERT INTO ts_login_record VALUES ('114','458','58.210.31.178','- 江苏省苏州市 - 电信','1334713348');
INSERT INTO ts_login_record VALUES ('115','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334715154');
INSERT INTO ts_login_record VALUES ('116','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334717123');
INSERT INTO ts_login_record VALUES ('117','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334719644');
INSERT INTO ts_login_record VALUES ('118','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334720001');
INSERT INTO ts_login_record VALUES ('119','1','61.134.27.51','- 陕西省咸阳市 - 电信','1334721429');
INSERT INTO ts_login_record VALUES ('120','1','123.138.199.23','- 陕西省 - 网通','1334740049');
INSERT INTO ts_login_record VALUES ('121','1','123.138.199.26','- 陕西省 - 网通','1334751816');
INSERT INTO ts_login_record VALUES ('122','1','123.138.199.26','- 陕西省 - 网通','1334753247');
INSERT INTO ts_login_record VALUES ('123','1','123.138.199.26','- 陕西省 - 网通','1334753262');
INSERT INTO ts_login_record VALUES ('124','1','123.138.199.26','- 陕西省 - 网通','1334753262');
INSERT INTO ts_login_record VALUES ('125','1','127.0.0.1','- LAN','1335668412');
INSERT INTO ts_login_record VALUES ('126','1','127.0.0.1','- LAN','1335668433');
INSERT INTO ts_login_record VALUES ('127','1','127.0.0.1','- LAN','1342101261');
INSERT INTO ts_login_record VALUES ('128','1','127.0.0.1','- LAN','1342101335');
INSERT INTO ts_login_record VALUES ('129','1','127.0.0.1','- LAN','1342159555');
INSERT INTO ts_login_record VALUES ('130','1','127.0.0.1','- LAN','1342159947');
INSERT INTO ts_login_record VALUES ('131','1','127.0.0.1','- LAN','1342159965');

DROP TABLE IF EXISTS ts_medal;
CREATE TABLE `ts_medal` (
  `medal_id` int(11) NOT NULL AUTO_INCREMENT,
  `path_name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `data` text,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `display_order` smallint(4) NOT NULL DEFAULT '0',
  `ctime` int(11) DEFAULT NULL,
  PRIMARY KEY (`medal_id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO ts_medal VALUES ('28','jiNian','见证历史','a:4:{s:8:\"icon_url\";s:59:\"http://zhimei.36hua.cn/addons/plugins/Medal/jiNian/icon.gif\";s:12:\"big_icon_url\";s:63:\"http://zhimei.36hua.cn/addons/plugins/Medal/jiNian/big_icon.gif\";s:11:\"description\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";}','1','28','1328803683');
INSERT INTO ts_medal VALUES ('29','hasAvatar','有头有脸','a:4:{s:8:\"icon_url\";s:62:\"http://zhimei.36hua.cn/addons/plugins/Medal/hasAvatar/icon.gif\";s:12:\"big_icon_url\";s:66:\"http://zhimei.36hua.cn/addons/plugins/Medal/hasAvatar/big_icon.gif\";s:11:\"description\";s:33:\"上传头像即可获得此勋章\";s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";}','1','29','1328803686');
INSERT INTO ts_medal VALUES ('27','rank','微博控','a:4:{s:8:\"icon_url\";s:57:\"http://zhimei.36hua.cn/addons/plugins/Medal/rank/icon.gif\";s:12:\"big_icon_url\";s:61:\"http://zhimei.36hua.cn/addons/plugins/Medal/rank/big_icon.gif\";s:11:\"description\";s:41:\"连续30天发布微博获微博控勋章\";s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";}','1','27','1328803680');
INSERT INTO ts_medal VALUES ('25','sinaSync','新浪达人','a:4:{s:8:\"icon_url\";s:61:\"http://zhimei.36hua.cn/addons/plugins/Medal/sinaSync/icon.gif\";s:12:\"big_icon_url\";s:65:\"http://zhimei.36hua.cn/addons/plugins/Medal/sinaSync/big_icon.gif\";s:11:\"description\";s:39:\"绑定新浪微博即可获得此勋章\";s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";}','0','25','1328803675');
INSERT INTO ts_medal VALUES ('26','trueWeiboer','微博达人','a:4:{s:8:\"icon_url\";s:64:\"http://zhimei.36hua.cn/addons/plugins/Medal/trueWeiboer/icon.gif\";s:12:\"big_icon_url\";s:68:\"http://zhimei.36hua.cn/addons/plugins/Medal/trueWeiboer/big_icon.gif\";s:11:\"description\";s:79:\"连续3天发微博,即可获得这枚勋章(每天都要发原创才有效噢)\";s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";}','1','26','1328803677');

DROP TABLE IF EXISTS ts_message;
CREATE TABLE `ts_message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `from_uid` int(11) NOT NULL,
  `to_uid` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `source_message_id` int(255) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `is_lastest` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_by` int(11) NOT NULL DEFAULT '0',
  `ctime` int(11) NOT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_myop_friendlog;
CREATE TABLE `ts_myop_friendlog` (
  `uid` int(11) NOT NULL,
  `fuid` int(11) NOT NULL,
  `action` varchar(255) NOT NULL,
  `dateline` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO ts_myop_friendlog VALUES ('1','217','add','1334155969');
INSERT INTO ts_myop_friendlog VALUES ('1','220','add','1334155972');
INSERT INTO ts_myop_friendlog VALUES ('1','219','add','1334155976');
INSERT INTO ts_myop_friendlog VALUES ('1','2','add','1334157645');
INSERT INTO ts_myop_friendlog VALUES ('1','223','add','1334157649');
INSERT INTO ts_myop_friendlog VALUES ('2','1','add','1334278616');
INSERT INTO ts_myop_friendlog VALUES ('1','452','add','1334282769');
INSERT INTO ts_myop_friendlog VALUES ('1','222','add','1334286374');
INSERT INTO ts_myop_friendlog VALUES ('31','2','add','1334287728');
INSERT INTO ts_myop_friendlog VALUES ('2','31','add','1334311667');
INSERT INTO ts_myop_friendlog VALUES ('1','221','add','1334330131');
INSERT INTO ts_myop_friendlog VALUES ('1','453','add','1334469301');
INSERT INTO ts_myop_friendlog VALUES ('453','1','add','1334469301');
INSERT INTO ts_myop_friendlog VALUES ('453','2','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','31','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','217','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','219','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','220','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','221','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','222','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','223','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('453','452','add','1334469307');
INSERT INTO ts_myop_friendlog VALUES ('1','454','add','1334469639');
INSERT INTO ts_myop_friendlog VALUES ('454','1','add','1334469639');
INSERT INTO ts_myop_friendlog VALUES ('454','2','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','31','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','217','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','219','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','220','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','221','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','222','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','223','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','452','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('454','453','add','1334469643');
INSERT INTO ts_myop_friendlog VALUES ('1','455','add','1334564654');
INSERT INTO ts_myop_friendlog VALUES ('455','1','add','1334564655');
INSERT INTO ts_myop_friendlog VALUES ('455','2','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','31','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','217','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','219','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','220','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','221','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','222','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','223','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','452','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','453','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('455','454','add','1334564687');
INSERT INTO ts_myop_friendlog VALUES ('1','456','add','1334623781');
INSERT INTO ts_myop_friendlog VALUES ('456','1','add','1334623782');
INSERT INTO ts_myop_friendlog VALUES ('1','457','add','1334670155');
INSERT INTO ts_myop_friendlog VALUES ('457','1','add','1334670156');
INSERT INTO ts_myop_friendlog VALUES ('457','2','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','217','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','219','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','220','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','221','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','222','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','223','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','452','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','31','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','453','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','454','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('457','455','add','1334670161');
INSERT INTO ts_myop_friendlog VALUES ('1','458','add','1334713355');
INSERT INTO ts_myop_friendlog VALUES ('458','1','add','1334713355');
INSERT INTO ts_myop_friendlog VALUES ('458','2','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','217','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','219','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','220','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','221','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','222','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','223','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','452','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','31','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','453','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','454','add','1334713359');
INSERT INTO ts_myop_friendlog VALUES ('458','455','add','1334713359');

DROP TABLE IF EXISTS ts_myop_myapp;
CREATE TABLE `ts_myop_myapp` (
  `appid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `appname` varchar(60) NOT NULL DEFAULT '',
  `narrow` tinyint(1) NOT NULL DEFAULT '0',
  `flag` tinyint(1) NOT NULL DEFAULT '0',
  `version` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `displaymethod` tinyint(1) NOT NULL DEFAULT '0',
  `displayorder` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`appid`),
  KEY `flag` (`flag`,`displayorder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_myop_myinvite;
CREATE TABLE `ts_myop_myinvite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `typename` varchar(100) NOT NULL DEFAULT '',
  `appid` mediumint(8) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `fromuid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `touid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `myml` text NOT NULL,
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `hash` int(10) unsigned NOT NULL DEFAULT '0',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `uid` (`touid`,`dateline`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_myop_userapp;
CREATE TABLE `ts_myop_userapp` (
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `appid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `appname` varchar(60) NOT NULL DEFAULT '',
  `privacy` tinyint(1) NOT NULL DEFAULT '0',
  `allowsidenav` tinyint(1) NOT NULL DEFAULT '0',
  `allowfeed` tinyint(1) NOT NULL DEFAULT '0',
  `allowprofilelink` tinyint(1) NOT NULL DEFAULT '0',
  `narrow` tinyint(1) NOT NULL DEFAULT '0',
  `menuorder` smallint(6) NOT NULL DEFAULT '0',
  `displayorder` smallint(6) NOT NULL DEFAULT '0',
  `ext` text,
  KEY `uid` (`uid`,`appid`),
  KEY `menuorder` (`uid`,`menuorder`),
  KEY `displayorder` (`uid`,`displayorder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_myop_userappfield;
CREATE TABLE `ts_myop_userappfield` (
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `appid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `profilelink` text NOT NULL,
  `myml` text NOT NULL,
  KEY `uid` (`uid`,`appid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_myop_userlog;
CREATE TABLE `ts_myop_userlog` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `action` varchar(255) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO ts_myop_userlog VALUES ('453','add','0','1334469296');
INSERT INTO ts_myop_userlog VALUES ('454','add','0','1334469635');
INSERT INTO ts_myop_userlog VALUES ('455','add','0','1334564367');
INSERT INTO ts_myop_userlog VALUES ('456','add','0','1334623777');
INSERT INTO ts_myop_userlog VALUES ('457','add','0','1334670143');
INSERT INTO ts_myop_userlog VALUES ('458','add','0','1334713348');
INSERT INTO ts_myop_userlog VALUES ('1','add','0','1335668273');

DROP TABLE IF EXISTS ts_node;
CREATE TABLE `ts_node` (
  `node_id` int(11) NOT NULL AUTO_INCREMENT,
  `app_name` varchar(255) NOT NULL,
  `app_alias` varchar(255) DEFAULT NULL,
  `mod_name` varchar(255) NOT NULL,
  `mod_alias` varchar(255) DEFAULT NULL,
  `act_name` varchar(255) NOT NULL,
  `act_alias` varchar(255) DEFAULT NULL,
  `parent_node_id` int(11) NOT NULL COMMENT '??action',
  `description` text,
  PRIMARY KEY (`node_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;

INSERT INTO ts_node VALUES ('1','admin','管理后台','*','全部','*','全部','0','在“权限管理”中将本节点赋予某个用户组，它就能访问管理后台了');
INSERT INTO ts_node VALUES ('2','admin','后台登录','Index','后台登录','index','后台登录','0','后台登录测试用户');
INSERT INTO ts_node VALUES ('5','admin','后台登录','Global','全局','siteopt','站点配置','0','后台登录测试用户');
INSERT INTO ts_node VALUES ('6','admin','后台登录','Global','全局','register','注册配置','0','');
INSERT INTO ts_node VALUES ('7','admin','后台登录','Global','全局','invite','邀请配置','0','');
INSERT INTO ts_node VALUES ('8','admin','后台登录','Global','全局','credit','积分配置','0','');
INSERT INTO ts_node VALUES ('10','admin','后台登录','Global','全局','email','邮件配置','0','');
INSERT INTO ts_node VALUES ('11','admin','后台登录','Global','全局','attachConfig','附件配置','0','');
INSERT INTO ts_node VALUES ('12','admin','后台登录','Global','全局','platform','平台配置','0','');
INSERT INTO ts_node VALUES ('13','admin','后台登录','Global','全局','document','文章配置','0','');
INSERT INTO ts_node VALUES ('14','admin','后台登录','Global','全局','audit','审核配置','0','');
INSERT INTO ts_node VALUES ('17','admin','后台登录','User','用户','user','用户管理','0','');
INSERT INTO ts_node VALUES ('41','admin','后台登录','Content','内容','bc','子类管理','0','后台登录测试用户');
INSERT INTO ts_node VALUES ('18','admin','后台登录','User','用户','userGroup','用户组管理','0','');
INSERT INTO ts_node VALUES ('19','admin','后台登录','User','用户','verified','用户认证','0','');
INSERT INTO ts_node VALUES ('23','admin','后台登录','User','用户','follower','粉丝榜配置','0','');
INSERT INTO ts_node VALUES ('21','admin','后台登录','User','用户','relateUser','相关用户配置','0','');
INSERT INTO ts_node VALUES ('22','admin','后台登录','User','用户','setField','资料配置','0','');
INSERT INTO ts_node VALUES ('24','admin','后台登录','User','用户','message','消息群发','0','');
INSERT INTO ts_node VALUES ('28','admin','后台登录','Home','首页','statistics','首页','0','');
INSERT INTO ts_node VALUES ('33','admin','后台登录','Tool','扩展','backup','数据备份','0','');
INSERT INTO ts_node VALUES ('34','admin','后台登录','Plugin','扩展','medal','勋章管理','0','');
INSERT INTO ts_node VALUES ('39','admin','后台登录','Apps','应用管理','*','应用管理','0','增加此权限才能管理应用配置');
INSERT INTO ts_node VALUES ('44','admin','后台登录','Content','内容','expression','表情管理','0','');
INSERT INTO ts_node VALUES ('42','admin','后台登录','Content','用户','ad','广告管理','0','后台登录测试用户');
INSERT INTO ts_node VALUES ('43','admin','后台登录','Content','内容','ac','分类管理','0','后台登录测试用户');
INSERT INTO ts_node VALUES ('45','admin','后台登录','Content','内容','template','模板管理','0','');
INSERT INTO ts_node VALUES ('46','admin','后台登录','Content','内容','attach','附件管理','0','');
INSERT INTO ts_node VALUES ('47','admin','后台登录','Content','内容','comment','评论管理','0','');
INSERT INTO ts_node VALUES ('48','admin','后台登录','Content','内容','message','短信息管理','0','');
INSERT INTO ts_node VALUES ('49','admin','后台登录','Content','内容','notify','通知管理','0','');
INSERT INTO ts_node VALUES ('50','admin','后台登录','Content','内容','feed','动态管理','0','');
INSERT INTO ts_node VALUES ('51','admin','后台登录','Content','内容','denounce','举报管理','0','');

DROP TABLE IF EXISTS ts_notify;
CREATE TABLE `ts_notify` (
  `notify_id` int(11) NOT NULL AUTO_INCREMENT,
  `from` int(11) NOT NULL,
  `receive` int(11) NOT NULL,
  `type` char(80) NOT NULL,
  `data` text NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `ctime` int(11) NOT NULL,
  PRIMARY KEY (`notify_id`),
  KEY `receive` (`receive`,`is_read`),
  KEY `ctime` (`ctime`)
) ENGINE=MyISAM AUTO_INCREMENT=3718 DEFAULT CHARSET=utf8;

INSERT INTO ts_notify VALUES ('3643','1','2','weibo_follow','s:0:\"\";','1','1334157645');
INSERT INTO ts_notify VALUES ('3642','1','219','weibo_follow','s:0:\"\";','0','1334155976');
INSERT INTO ts_notify VALUES ('3641','1','220','weibo_follow','s:0:\"\";','0','1334155972');
INSERT INTO ts_notify VALUES ('3640','1','217','weibo_follow','s:0:\"\";','0','1334155969');
INSERT INTO ts_notify VALUES ('3676','455','1','weibo_follow','s:0:\"\";','1','1334564655');
INSERT INTO ts_notify VALUES ('3638','1','452','weibo_follow','s:0:\"\";','0','1334113969');
INSERT INTO ts_notify VALUES ('3644','1','223','weibo_follow','s:0:\"\";','0','1334157649');
INSERT INTO ts_notify VALUES ('3675','1','455','weibo_follow','s:0:\"\";','0','1334564655');
INSERT INTO ts_notify VALUES ('3646','1','452','weibo_follow','s:0:\"\";','0','1334282769');
INSERT INTO ts_notify VALUES ('3647','1','222','weibo_follow','s:0:\"\";','0','1334286374');
INSERT INTO ts_notify VALUES ('3648','31','2','weibo_follow','s:0:\"\";','1','1334287728');
INSERT INTO ts_notify VALUES ('3649','2','31','weibo_follow','s:0:\"\";','0','1334311667');
INSERT INTO ts_notify VALUES ('3650','1','221','weibo_follow','s:0:\"\";','0','1334330131');
INSERT INTO ts_notify VALUES ('3651','1','453','weibo_follow','s:0:\"\";','0','1334469301');
INSERT INTO ts_notify VALUES ('3677','455','2','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3653','453','2','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3654','453','31','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3655','453','217','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3656','453','219','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3657','453','220','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3658','453','221','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3659','453','222','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3660','453','223','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3661','453','452','weibo_follow','s:0:\"\";','0','1334469307');
INSERT INTO ts_notify VALUES ('3662','1','454','weibo_follow','s:0:\"\";','1','1334469639');
INSERT INTO ts_notify VALUES ('3678','455','31','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3664','454','2','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3665','454','31','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3666','454','217','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3667','454','219','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3668','454','220','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3669','454','221','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3670','454','222','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3671','454','223','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3672','454','452','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3673','454','453','weibo_follow','s:0:\"\";','0','1334469643');
INSERT INTO ts_notify VALUES ('3674','0','453','group_audit','a:2:{s:5:\"title\";s:8:\"hhhhuuuh\";s:8:\"group_id\";s:1:\"1\";}','0','1334473133');
INSERT INTO ts_notify VALUES ('3679','455','217','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3680','455','219','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3681','455','220','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3682','455','221','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3683','455','222','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3684','455','223','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3685','455','452','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3686','455','453','weibo_follow','s:0:\"\";','0','1334564687');
INSERT INTO ts_notify VALUES ('3687','455','454','weibo_follow','s:0:\"\";','1','1334564687');
INSERT INTO ts_notify VALUES ('3688','1','456','weibo_follow','s:0:\"\";','0','1334623781');
INSERT INTO ts_notify VALUES ('3689','456','1','weibo_follow','s:0:\"\";','1','1334623782');
INSERT INTO ts_notify VALUES ('3690','1','457','weibo_follow','s:0:\"\";','1','1334670155');
INSERT INTO ts_notify VALUES ('3691','457','1','weibo_follow','s:0:\"\";','1','1334670156');
INSERT INTO ts_notify VALUES ('3692','457','2','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3693','457','217','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3694','457','219','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3695','457','220','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3696','457','221','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3697','457','222','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3698','457','223','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3699','457','452','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3700','457','31','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3701','457','453','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3702','457','454','weibo_follow','s:0:\"\";','1','1334670161');
INSERT INTO ts_notify VALUES ('3703','457','455','weibo_follow','s:0:\"\";','0','1334670161');
INSERT INTO ts_notify VALUES ('3704','1','458','weibo_follow','s:0:\"\";','1','1334713355');
INSERT INTO ts_notify VALUES ('3705','458','1','weibo_follow','s:0:\"\";','1','1334713355');
INSERT INTO ts_notify VALUES ('3706','458','2','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3707','458','217','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3708','458','219','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3709','458','220','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3710','458','221','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3711','458','222','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3712','458','223','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3713','458','452','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3714','458','31','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3715','458','453','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3716','458','454','weibo_follow','s:0:\"\";','0','1334713359');
INSERT INTO ts_notify VALUES ('3717','458','455','weibo_follow','s:0:\"\";','0','1334713359');

DROP TABLE IF EXISTS ts_photo;
CREATE TABLE `ts_photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachId` int(11) DEFAULT NULL,
  `albumId` int(11) DEFAULT NULL,
  `userId` int(11) DEFAULT NULL,
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `name` varchar(255) DEFAULT NULL,
  `cTime` int(11) unsigned DEFAULT NULL,
  `mTime` int(11) unsigned DEFAULT NULL,
  `info` text,
  `commentCount` int(11) unsigned DEFAULT '0',
  `readCount` int(11) unsigned DEFAULT '0',
  `savepath` varchar(255) DEFAULT NULL,
  `size` int(11) NOT NULL DEFAULT '0',
  `privacy` int(1) NOT NULL DEFAULT '1',
  `tags` text,
  `order` int(11) NOT NULL DEFAULT '0',
  `isDel` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

INSERT INTO ts_photo VALUES ('1','1','1','1','1','来自微博','0','0','','0','11','miniblog/20111118/55f42b801ba6544400920d398ee10882.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('2','1','1','1','1','来自微博','0','0','','0','2','miniblog/20111126/78781649179ed77465c58f91652fff5d.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('3','1','1','1','1','来自微博','0','0','','0','1','miniblog/20111202/caafa2cf9782eed36541961859f7816d.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('4','1','1','1','1','来自微博','0','0','','0','0','miniblog/20111206/5b81a8e364807ff64c3f8160d3f70569.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('5','1','1','1','1','来自微博','0','0','','0','0','miniblog/20111206/aba9e7ab10faea047b2142c113ece674.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('6','1','1','1','1','来自微博','0','0','','0','0','miniblog/20111206/1beda4e00db78b52bd47978a0f723a5c.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('7','1','1','1','1','来自微博','0','0','','0','0','miniblog/20111206/7c643954a12dba6f84ef01eb4fe44b96.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('8','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1210/14/79de58f542c332b4a49766dc9f74ede0.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('9','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1210/16/b8c352f97b8955e19934ae2705746378.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('10','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1210/16/debe35599d8600a633f49b7968a085b0.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('11','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1210/16/f5efad6b72c9a45c5e5fcf3f2984a06b.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('12','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1210/16/14bba6f055e442d9ede852ccb7a634cb.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('13','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1210/16/0ea4ec2c8fcf1ae0cbd35c0c14822e72.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('14','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1211/14/c9fb0a5dbee4d5746c3c017ffb48ff18.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('15','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1211/14/3863940b5ff9534f6dda0e6655f80740.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('16','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1211/15/5ffd4c1f22b9a2c0d26a48e252ce864c.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('17','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1213/15/488f7b950e59347130b0319abcdfc5f5.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('18','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/12/c9d37c374ea7e9913b992144398c2c5a.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('19','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/12/2816199558c66ed4b41277455d633581.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('20','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/12/8415adec9ee337cc5c6f5fdd3232c743.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('21','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/12/8048d2f285d736a0939b47f0aa673a4b.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('22','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/13/614aaa9d8da88375e33a8c7629e94208.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('23','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/13/b4ac49d34bfd879313285999adbdf755.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('24','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/13/c0105e44fefb9b2d07a4aea9b4f47400.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('25','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/13/a0a82cfcc83f30635ce3576d7ea89044.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('26','1','1','1','1','来自微博','0','0','','0','0','miniblog/2011/1220/13/84ad753a64ff8b850ecc2ae0595658f8.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('27','2','2','225','1','来自微博','0','0','','0','0','miniblog/2011/1223/21/34c5ab8d7b6daff6f3c17473e96b6159.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('28','3','3','227','1','来自微博','0','0','','0','0','miniblog/2011/1223/21/c1e9e1d318e9a1acbbfc7863df198e71.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('29','3','3','227','1','来自微博','0','0','','0','0','miniblog/2011/1223/21/78fbf043e6ddbcf41895601ea2252368.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('30','4','4','228','1','来自微博','0','0','','0','0','miniblog/2011/1223/21/616da8adb3e5c342a7dab5f4cb7719cd.jpeg','0','1','','0','0');
INSERT INTO ts_photo VALUES ('31','4','4','228','1','来自微博','0','0','','0','0','miniblog/2011/1223/21/0c2201b5b0177198fc1f72397d3ddd20.jpeg','0','1','','0','0');

DROP TABLE IF EXISTS ts_photo_album;
CREATE TABLE `ts_photo_album` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `info` text,
  `cTime` int(11) unsigned DEFAULT NULL,
  `mTime` int(11) unsigned DEFAULT NULL,
  `coverImageId` int(11) DEFAULT NULL,
  `coverImagePath` varchar(255) DEFAULT NULL,
  `photoCount` int(11) DEFAULT '0',
  `readCount` int(11) DEFAULT '0',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1',
  `isHot` varchar(1) NOT NULL DEFAULT '0',
  `rTime` int(11) NOT NULL DEFAULT '0',
  `share` tinyint(1) NOT NULL DEFAULT '0',
  `privacy` tinyint(1) DEFAULT NULL,
  `privacy_data` text,
  `isDel` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`userId`),
  KEY `cTime` (`cTime`),
  KEY `mTime` (`mTime`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO ts_photo_album VALUES ('1','1','微博图集','','1324360730','1324360730','0','miniblog/2011/1220/13/84ad753a64ff8b850ecc2ae0595658f8.jpeg','26','15','1','0','0','0','1','','0');
INSERT INTO ts_photo_album VALUES ('2','225','微博图集','','1324645385','1324645385','0','miniblog/2011/1223/21/34c5ab8d7b6daff6f3c17473e96b6159.jpeg','1','0','1','0','0','0','1','','0');
INSERT INTO ts_photo_album VALUES ('3','227','微博图集','','1324648386','1324648386','0','miniblog/2011/1223/21/78fbf043e6ddbcf41895601ea2252368.jpeg','2','0','1','0','0','0','1','','0');
INSERT INTO ts_photo_album VALUES ('4','228','微博图集','','1324648542','1324648542','0','miniblog/2011/1223/21/0c2201b5b0177198fc1f72397d3ddd20.jpeg','2','0','1','0','0','0','1','','0');

DROP TABLE IF EXISTS ts_photo_index;
CREATE TABLE `ts_photo_index` (
  `albumId` int(11) NOT NULL DEFAULT '0',
  `photoId` int(11) NOT NULL DEFAULT '0',
  `userId` int(11) DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `privacy` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`albumId`,`photoId`),
  UNIQUE KEY `album_photo` (`albumId`,`photoId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_photo_mark;
CREATE TABLE `ts_photo_mark` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `photoId` int(11) DEFAULT NULL,
  `userId` int(11) DEFAULT NULL,
  `userName` varchar(50) DEFAULT NULL,
  `markedUserId` int(11) DEFAULT NULL,
  `x` varchar(100) DEFAULT NULL,
  `y` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_plugins_label;
CREATE TABLE `ts_plugins_label` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `label_name` varchar(50) DEFAULT '',
  `list_id` int(11) DEFAULT '0',
  `label_seq` int(11) DEFAULT '0',
  `label_hot` int(11) DEFAULT '0',
  PRIMARY KEY (`label_id`)
) ENGINE=MyISAM AUTO_INCREMENT=369 DEFAULT CHARSET=utf8;

INSERT INTO ts_plugins_label VALUES ('1','衬衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('2','毛衣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('3','帽衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('4','卫衣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('5','T恤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('6','开衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('7','背心','0','0','0');
INSERT INTO ts_plugins_label VALUES ('8','罩衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('9','针织衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('10','羊绒衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('11','羊毛衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('12','娃娃衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('13','打底衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('14','大衣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('15','西装','0','0','0');
INSERT INTO ts_plugins_label VALUES ('16','夹克','0','0','0');
INSERT INTO ts_plugins_label VALUES ('17','皮衣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('18','斗篷','0','0','0');
INSERT INTO ts_plugins_label VALUES ('19','棉服','0','0','0');
INSERT INTO ts_plugins_label VALUES ('20','马甲','0','0','0');
INSERT INTO ts_plugins_label VALUES ('21','羽绒服','0','0','0');
INSERT INTO ts_plugins_label VALUES ('22','军装外套','0','0','0');
INSERT INTO ts_plugins_label VALUES ('23','运动夹克','0','0','0');
INSERT INTO ts_plugins_label VALUES ('24','羽绒马甲','0','0','0');
INSERT INTO ts_plugins_label VALUES ('25','长裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('26','皮裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('27','裤裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('28','迷你裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('29','及膝裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('30','连衣裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('31','百褶裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('32','及踝裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('33','铅笔裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('34','包臀裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('35','蓬蓬裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('36','鱼尾裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('37','花苞裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('38','牛仔裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('39','伴娘裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('40','小礼服','0','0','0');
INSERT INTO ts_plugins_label VALUES ('41','牛仔裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('42','铅笔裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('43','西装裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('44','直筒裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('45','阔腿裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('46','喇叭裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('47','工装裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('48','休闲裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('49','卡其裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('50','萝卜裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('51','哈伦裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('52','灯笼裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('53','连身裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('54','高腰裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('55','紧身裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('56','短裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('57','热裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('58','五分裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('59','七分裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('60','九分裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('61','打底裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('62','家居服','0','0','0');
INSERT INTO ts_plugins_label VALUES ('63','内裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('64','套装','0','0','0');
INSERT INTO ts_plugins_label VALUES ('65','分体','0','0','0');
INSERT INTO ts_plugins_label VALUES ('66','连体','0','0','0');
INSERT INTO ts_plugins_label VALUES ('67','比基尼','0','0','0');
INSERT INTO ts_plugins_label VALUES ('68','靴子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('69','便鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('70','拖鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('71','木屐','0','0','0');
INSERT INTO ts_plugins_label VALUES ('72','球鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('73','帆布鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('74','平底鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('75','室内鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('76','高跟鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('77','单肩包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('78','斜垮包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('79','手提包','0','0','1');
INSERT INTO ts_plugins_label VALUES ('80','手拿包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('81','链条包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('82','复古包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('83','机车包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('84','双肩包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('85','腰包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('86','帆布包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('87','钱包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('88','项链','0','0','0');
INSERT INTO ts_plugins_label VALUES ('89','耳钉','0','0','0');
INSERT INTO ts_plugins_label VALUES ('90','耳环','0','0','0');
INSERT INTO ts_plugins_label VALUES ('91','胸针','0','0','0');
INSERT INTO ts_plugins_label VALUES ('92','戒指','0','0','0');
INSERT INTO ts_plugins_label VALUES ('93','手链','0','0','0');
INSERT INTO ts_plugins_label VALUES ('94','发饰','0','0','0');
INSERT INTO ts_plugins_label VALUES ('95','脚链','0','0','0');
INSERT INTO ts_plugins_label VALUES ('96','手表','0','0','0');
INSERT INTO ts_plugins_label VALUES ('97','雨伞','0','0','0');
INSERT INTO ts_plugins_label VALUES ('98','腰带','0','0','0');
INSERT INTO ts_plugins_label VALUES ('99','围巾','0','0','0');
INSERT INTO ts_plugins_label VALUES ('100','帽子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('101','手套','0','0','0');
INSERT INTO ts_plugins_label VALUES ('102','袜子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('103','太阳镜','0','0','0');
INSERT INTO ts_plugins_label VALUES ('104','CK','0','0','0');
INSERT INTO ts_plugins_label VALUES ('105','A字裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('108','Bra','0','0','0');
INSERT INTO ts_plugins_label VALUES ('109','印花','0','0','0');
INSERT INTO ts_plugins_label VALUES ('110','拼接','0','0','0');
INSERT INTO ts_plugins_label VALUES ('111','蕾丝','0','0','0');
INSERT INTO ts_plugins_label VALUES ('112','波点','0','0','0');
INSERT INTO ts_plugins_label VALUES ('113','雪纺','0','0','0');
INSERT INTO ts_plugins_label VALUES ('114','碎花','0','0','0');
INSERT INTO ts_plugins_label VALUES ('115','条纹','0','0','0');
INSERT INTO ts_plugins_label VALUES ('116','糖果色','0','0','0');
INSERT INTO ts_plugins_label VALUES ('117','亮色','0','0','0');
INSERT INTO ts_plugins_label VALUES ('118','蝴蝶结','0','0','0');
INSERT INTO ts_plugins_label VALUES ('119','荧光色','0','0','0');
INSERT INTO ts_plugins_label VALUES ('120','撞色','0','0','0');
INSERT INTO ts_plugins_label VALUES ('121','厚底鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('122','人字拖','0','0','0');
INSERT INTO ts_plugins_label VALUES ('123','信封包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('124','泳衣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('125','吊带裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('126','雪纺衫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('127','欧美','0','0','0');
INSERT INTO ts_plugins_label VALUES ('128','优雅','0','0','0');
INSERT INTO ts_plugins_label VALUES ('129','英伦','0','0','0');
INSERT INTO ts_plugins_label VALUES ('130','性感','0','0','0');
INSERT INTO ts_plugins_label VALUES ('131','日系','0','0','0');
INSERT INTO ts_plugins_label VALUES ('132','徐濠萦','0','0','0');
INSERT INTO ts_plugins_label VALUES ('133','甜美','0','0','0');
INSERT INTO ts_plugins_label VALUES ('134','绯闻女孩','0','0','0');
INSERT INTO ts_plugins_label VALUES ('135','森女','0','0','0');
INSERT INTO ts_plugins_label VALUES ('136','波希米亚','0','0','0');
INSERT INTO ts_plugins_label VALUES ('137','复古','0','7','0');
INSERT INTO ts_plugins_label VALUES ('138','呛口小辣椒','0','0','0');
INSERT INTO ts_plugins_label VALUES ('139','Zara','0','0','0');
INSERT INTO ts_plugins_label VALUES ('141','H&M','0','0','0');
INSERT INTO ts_plugins_label VALUES ('143','优衣库','0','0','0');
INSERT INTO ts_plugins_label VALUES ('145','Mango','0','0','0');
INSERT INTO ts_plugins_label VALUES ('147','Topshop','0','0','0');
INSERT INTO ts_plugins_label VALUES ('149','欧时力','0','0','0');
INSERT INTO ts_plugins_label VALUES ('150','Hellok..','0','0','0');
INSERT INTO ts_plugins_label VALUES ('151','军装','0','0','0');
INSERT INTO ts_plugins_label VALUES ('152','连体裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('153','半身裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('154','阔脚裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('155','风衣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('156','针织裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('157','短靴','0','0','0');
INSERT INTO ts_plugins_label VALUES ('158','鱼嘴鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('159','艾格','0','0','0');
INSERT INTO ts_plugins_label VALUES ('160','ONLY','0','0','0');
INSERT INTO ts_plugins_label VALUES ('161','领带','0','0','0');
INSERT INTO ts_plugins_label VALUES ('162','豹纹','0','0','0');
INSERT INTO ts_plugins_label VALUES ('163','皮草','0','0','0');
INSERT INTO ts_plugins_label VALUES ('164','外套','0','0','0');
INSERT INTO ts_plugins_label VALUES ('165','坡跟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('166','凉鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('167','罗马','0','0','0');
INSERT INTO ts_plugins_label VALUES ('168','高跟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('169','厚底','0','0','0');
INSERT INTO ts_plugins_label VALUES ('170','鱼嘴','0','0','0');
INSERT INTO ts_plugins_label VALUES ('171','松糕鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('172','沙滩鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('173','运动鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('174','单鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('175','雨鞋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('176','花朵','0','0','0');
INSERT INTO ts_plugins_label VALUES ('177','马丁','0','0','0');
INSERT INTO ts_plugins_label VALUES ('178','圆头','0','0','0');
INSERT INTO ts_plugins_label VALUES ('179','镂空','0','0','0');
INSERT INTO ts_plugins_label VALUES ('180','淑女','0','0','0');
INSERT INTO ts_plugins_label VALUES ('181','浅口','0','0','0');
INSERT INTO ts_plugins_label VALUES ('182','高帮','0','0','0');
INSERT INTO ts_plugins_label VALUES ('183','尖头','0','0','0');
INSERT INTO ts_plugins_label VALUES ('184','系带','0','0','0');
INSERT INTO ts_plugins_label VALUES ('185','防水台','0','0','0');
INSERT INTO ts_plugins_label VALUES ('186','低帮','0','0','0');
INSERT INTO ts_plugins_label VALUES ('187','短T','0','0','0');
INSERT INTO ts_plugins_label VALUES ('188','短袖','0','0','0');
INSERT INTO ts_plugins_label VALUES ('189','文胸','0','0','0');
INSERT INTO ts_plugins_label VALUES ('190','草帽','0','0','0');
INSERT INTO ts_plugins_label VALUES ('191','墨镜','0','0','0');
INSERT INTO ts_plugins_label VALUES ('192','腰链','0','0','0');
INSERT INTO ts_plugins_label VALUES ('193','发箍','0','0','0');
INSERT INTO ts_plugins_label VALUES ('194','首饰','0','0','0');
INSERT INTO ts_plugins_label VALUES ('195','眼镜','0','0','0');
INSERT INTO ts_plugins_label VALUES ('196','吊坠','0','0','0');
INSERT INTO ts_plugins_label VALUES ('197','手镯','0','0','0');
INSERT INTO ts_plugins_label VALUES ('198','首饰盒','0','0','0');
INSERT INTO ts_plugins_label VALUES ('199','显瘦','0','6','1');
INSERT INTO ts_plugins_label VALUES ('200','OL','0','0','0');
INSERT INTO ts_plugins_label VALUES ('201','项链','0','0','0');
INSERT INTO ts_plugins_label VALUES ('202','礼帽','0','0','0');
INSERT INTO ts_plugins_label VALUES ('203','水晶','0','0','0');
INSERT INTO ts_plugins_label VALUES ('204','丝巾','0','0','0');
INSERT INTO ts_plugins_label VALUES ('205','腰封','0','0','0');
INSERT INTO ts_plugins_label VALUES ('206','发夹','0','0','0');
INSERT INTO ts_plugins_label VALUES ('207','镜框','0','0','0');
INSERT INTO ts_plugins_label VALUES ('208','太阳伞','0','0','0');
INSERT INTO ts_plugins_label VALUES ('209','田园','0','0','0');
INSERT INTO ts_plugins_label VALUES ('210','吊带','0','0','0');
INSERT INTO ts_plugins_label VALUES ('211','长T','0','0','0');
INSERT INTO ts_plugins_label VALUES ('212','短外套','0','0','0');
INSERT INTO ts_plugins_label VALUES ('213','背带裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('214','打底','0','0','0');
INSERT INTO ts_plugins_label VALUES ('215','抹胸裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('216','纱裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('217','短裙','0','0','0');
INSERT INTO ts_plugins_label VALUES ('218','睡衣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('219','抹胸','0','0','0');
INSERT INTO ts_plugins_label VALUES ('220','草编包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('221','环保包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('222','公文包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('223','果冻包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('224','水桶包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('225','邮差包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('226','旅行包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('227','卡包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('228','化妆包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('229','平跟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('230','中跟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('231','细跟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('232','低跟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('233','粗跟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('234','牛皮','0','0','0');
INSERT INTO ts_plugins_label VALUES ('235','羊皮','0','0','0');
INSERT INTO ts_plugins_label VALUES ('236','森系','0','1','1');
INSERT INTO ts_plugins_label VALUES ('237','vivi同款','0','0','0');
INSERT INTO ts_plugins_label VALUES ('238','果冻','0','0','0');
INSERT INTO ts_plugins_label VALUES ('239','漆皮','0','0','0');
INSERT INTO ts_plugins_label VALUES ('240','帆布','0','0','0');
INSERT INTO ts_plugins_label VALUES ('241','牛仔布','0','0','0');
INSERT INTO ts_plugins_label VALUES ('243','度假','0','0','0');
INSERT INTO ts_plugins_label VALUES ('244','清新','0','0','0');
INSERT INTO ts_plugins_label VALUES ('245','波西米亚','0','0','0');
INSERT INTO ts_plugins_label VALUES ('246','休闲','0','3','0');
INSERT INTO ts_plugins_label VALUES ('247','透视','0','0','0');
INSERT INTO ts_plugins_label VALUES ('248','蕾丝','0','0','0');
INSERT INTO ts_plugins_label VALUES ('249','花朵','0','0','0');
INSERT INTO ts_plugins_label VALUES ('250','蝴蝶结','0','0','0');
INSERT INTO ts_plugins_label VALUES ('251','铆钉','0','0','0');
INSERT INTO ts_plugins_label VALUES ('252','流苏','0','0','0');
INSERT INTO ts_plugins_label VALUES ('253','格纹','0','0','0');
INSERT INTO ts_plugins_label VALUES ('254','碎花','0','0','0');
INSERT INTO ts_plugins_label VALUES ('255','PU','0','0','0');
INSERT INTO ts_plugins_label VALUES ('256','包包','0','9','1');
INSERT INTO ts_plugins_label VALUES ('257','爱情','0','0','1');
INSERT INTO ts_plugins_label VALUES ('259','家居','0','0','0');
INSERT INTO ts_plugins_label VALUES ('260','一间房','0','0','0');
INSERT INTO ts_plugins_label VALUES ('261','衣服','0','0','0');
INSERT INTO ts_plugins_label VALUES ('262','包邮','0','0','0');
INSERT INTO ts_plugins_label VALUES ('263','裙子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('264','配饰','0','0','0');
INSERT INTO ts_plugins_label VALUES ('265','鞋子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('267','女裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('268','加厚','0','0','0');
INSERT INTO ts_plugins_label VALUES ('270','靴裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('272','公主','0','0','0');
INSERT INTO ts_plugins_label VALUES ('273','纯棉','0','0','0');
INSERT INTO ts_plugins_label VALUES ('274','2012新款','0','0','0');
INSERT INTO ts_plugins_label VALUES ('275','温暖','0','8','0');
INSERT INTO ts_plugins_label VALUES ('276','混搭','0','5','0');
INSERT INTO ts_plugins_label VALUES ('277','宽松','0','2','1');
INSERT INTO ts_plugins_label VALUES ('278','海外','0','99','1');
INSERT INTO ts_plugins_label VALUES ('279','浙江','0','7','0');
INSERT INTO ts_plugins_label VALUES ('280','江苏','0','6','0');
INSERT INTO ts_plugins_label VALUES ('281','上海','0','5','0');
INSERT INTO ts_plugins_label VALUES ('282','北京','0','4','1');
INSERT INTO ts_plugins_label VALUES ('283','广东','0','3','0');
INSERT INTO ts_plugins_label VALUES ('284','四川','0','2','1');
INSERT INTO ts_plugins_label VALUES ('285','湖北','0','1','0');
INSERT INTO ts_plugins_label VALUES ('286','冬装','0','0','0');
INSERT INTO ts_plugins_label VALUES ('287','韩版','0','0','0');
INSERT INTO ts_plugins_label VALUES ('288','长袖','0','0','0');
INSERT INTO ts_plugins_label VALUES ('289','高领','0','0','0');
INSERT INTO ts_plugins_label VALUES ('290','真丝棉','0','0','0');
INSERT INTO ts_plugins_label VALUES ('292','女裤子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('293','高腰','0','0','0');
INSERT INTO ts_plugins_label VALUES ('294','直筒','0','0','0');
INSERT INTO ts_plugins_label VALUES ('295','菱格','0','0','0');
INSERT INTO ts_plugins_label VALUES ('296','经典','0','0','0');
INSERT INTO ts_plugins_label VALUES ('297','女装','0','0','0');
INSERT INTO ts_plugins_label VALUES ('298','纽扣','0','0','0');
INSERT INTO ts_plugins_label VALUES ('299','耳朵','0','0','0');
INSERT INTO ts_plugins_label VALUES ('300','冬季','0','0','0');
INSERT INTO ts_plugins_label VALUES ('301','红格子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('302','斜挎包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('303','','0','0','0');
INSERT INTO ts_plugins_label VALUES ('304','沙发','0','0','0');
INSERT INTO ts_plugins_label VALUES ('305','折叠','0','0','0');
INSERT INTO ts_plugins_label VALUES ('306','懒人沙发','0','0','0');
INSERT INTO ts_plugins_label VALUES ('307','粗毛线','0','0','0');
INSERT INTO ts_plugins_label VALUES ('308','口袋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('309','下装','0','0','0');
INSERT INTO ts_plugins_label VALUES ('310','牛津','0','0','0');
INSERT INTO ts_plugins_label VALUES ('311','学院风','0','0','0');
INSERT INTO ts_plugins_label VALUES ('312','雕花','0','0','0');
INSERT INTO ts_plugins_label VALUES ('313','可爱','0','0','0');
INSERT INTO ts_plugins_label VALUES ('314','小熊','0','0','0');
INSERT INTO ts_plugins_label VALUES ('315','格子','0','0','0');
INSERT INTO ts_plugins_label VALUES ('316','毛绒','0','0','0');
INSERT INTO ts_plugins_label VALUES ('317','棉袄','0','0','0');
INSERT INTO ts_plugins_label VALUES ('318','粗线','0','0','0');
INSERT INTO ts_plugins_label VALUES ('319','圣诞','0','0','0');
INSERT INTO ts_plugins_label VALUES ('320','爱心','0','0','0');
INSERT INTO ts_plugins_label VALUES ('321','热水袋','0','0','0');
INSERT INTO ts_plugins_label VALUES ('322','玫红','0','0','0');
INSERT INTO ts_plugins_label VALUES ('323','红豹','0','0','0');
INSERT INTO ts_plugins_label VALUES ('324','钻石','0','0','0');
INSERT INTO ts_plugins_label VALUES ('325','女戒','0','0','0');
INSERT INTO ts_plugins_label VALUES ('326','指环','0','0','0');
INSERT INTO ts_plugins_label VALUES ('327','尾戒','0','0','0');
INSERT INTO ts_plugins_label VALUES ('328','韩国','0','0','0');
INSERT INTO ts_plugins_label VALUES ('329','民族风','0','0','0');
INSERT INTO ts_plugins_label VALUES ('330','花多色','0','0','0');
INSERT INTO ts_plugins_label VALUES ('331','拼色','0','0','0');
INSERT INTO ts_plugins_label VALUES ('332','进口','0','0','0');
INSERT INTO ts_plugins_label VALUES ('333','牛筋底','0','0','0');
INSERT INTO ts_plugins_label VALUES ('334','雪地靴','0','0','0');
INSERT INTO ts_plugins_label VALUES ('335','正品','0','0','0');
INSERT INTO ts_plugins_label VALUES ('336','秋冬','0','0','0');
INSERT INTO ts_plugins_label VALUES ('337','球包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('338','女包包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('339','狐狸毛','0','0','0');
INSERT INTO ts_plugins_label VALUES ('340','腕饰','0','0','0');
INSERT INTO ts_plugins_label VALUES ('341','靠枕','0','0','0');
INSERT INTO ts_plugins_label VALUES ('342','小星星','0','0','0');
INSERT INTO ts_plugins_label VALUES ('343','日单','0','0','0');
INSERT INTO ts_plugins_label VALUES ('344','背包','0','0','0');
INSERT INTO ts_plugins_label VALUES ('345','毛茸茸','0','0','0');
INSERT INTO ts_plugins_label VALUES ('346','全柳钉','0','0','0');
INSERT INTO ts_plugins_label VALUES ('347','kite','0','0','0');
INSERT INTO ts_plugins_label VALUES ('348','苏格兰','0','0','0');
INSERT INTO ts_plugins_label VALUES ('349','荷叶','0','0','0');
INSERT INTO ts_plugins_label VALUES ('350','裙裤','0','0','0');
INSERT INTO ts_plugins_label VALUES ('351','毛条','0','0','0');
INSERT INTO ts_plugins_label VALUES ('352','毛兔','0','0','0');
INSERT INTO ts_plugins_label VALUES ('353','球球','0','0','0');
INSERT INTO ts_plugins_label VALUES ('354','台灯','0','0','0');
INSERT INTO ts_plugins_label VALUES ('355','桌球','0','0','0');
INSERT INTO ts_plugins_label VALUES ('356','挂钟','0','0','0');
INSERT INTO ts_plugins_label VALUES ('357','创意','0','0','0');
INSERT INTO ts_plugins_label VALUES ('358','真皮','0','0','0');
INSERT INTO ts_plugins_label VALUES ('359','晚宴','0','0','0');
INSERT INTO ts_plugins_label VALUES ('360','VIVI','0','0','0');
INSERT INTO ts_plugins_label VALUES ('361','玫瑰','0','0','0');
INSERT INTO ts_plugins_label VALUES ('362','床垫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('363','榻榻米','0','0','0');
INSERT INTO ts_plugins_label VALUES ('364','睡垫','0','0','0');
INSERT INTO ts_plugins_label VALUES ('368','美妆','0','0','0');

DROP TABLE IF EXISTS ts_plugins_list;
CREATE TABLE `ts_plugins_list` (
  `node_id` int(11) DEFAULT NULL,
  `list_id` int(11) NOT NULL AUTO_INCREMENT,
  `list_name` varchar(50) DEFAULT '',
  `list_seq` int(11) DEFAULT '0',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=utf8;

INSERT INTO ts_plugins_list VALUES ('5','27','当季热款','0');
INSERT INTO ts_plugins_list VALUES ('5','28','流行元素','0');
INSERT INTO ts_plugins_list VALUES ('1','29','当季热款','0');
INSERT INTO ts_plugins_list VALUES ('1','32','流行元素','0');
INSERT INTO ts_plugins_list VALUES ('1','33','上衣','0');
INSERT INTO ts_plugins_list VALUES ('1','34','裤子','0');
INSERT INTO ts_plugins_list VALUES ('1','37','裙子','0');
INSERT INTO ts_plugins_list VALUES ('2','39','当季热款','0');
INSERT INTO ts_plugins_list VALUES ('3','40','当季热款','0');
INSERT INTO ts_plugins_list VALUES ('4','41','当季热款','0');
INSERT INTO ts_plugins_list VALUES ('4','42','类别','0');
INSERT INTO ts_plugins_list VALUES ('5','26','2012春夏','0');
INSERT INTO ts_plugins_list VALUES ('6','44','2012春夏','8');
INSERT INTO ts_plugins_list VALUES ('6','45','流行款式','5');
INSERT INTO ts_plugins_list VALUES ('6','46','潮流风格','2');
INSERT INTO ts_plugins_list VALUES ('6','47','品牌','0');
INSERT INTO ts_plugins_list VALUES ('6','48','热门关键字','7');
INSERT INTO ts_plugins_list VALUES ('6','49','推荐单品','9');
INSERT INTO ts_plugins_list VALUES ('5','50','热门关键字','0');
INSERT INTO ts_plugins_list VALUES ('5','51','品牌','0');
INSERT INTO ts_plugins_list VALUES ('4','52','首饰','0');
INSERT INTO ts_plugins_list VALUES ('4','53','配件','0');
INSERT INTO ts_plugins_list VALUES ('3','54','类别','0');
INSERT INTO ts_plugins_list VALUES ('3','55','元素','0');
INSERT INTO ts_plugins_list VALUES ('3','56','材质','0');
INSERT INTO ts_plugins_list VALUES ('2','57','类别','0');
INSERT INTO ts_plugins_list VALUES ('2','58','元素','0');
INSERT INTO ts_plugins_list VALUES ('2','59','风格','0');
INSERT INTO ts_plugins_list VALUES ('2','60','鞋型','0');
INSERT INTO ts_plugins_list VALUES ('2','61','鞋跟','0');
INSERT INTO ts_plugins_list VALUES ('1','62','内衣','0');
INSERT INTO ts_plugins_list VALUES ('7','63','热力单品','4');
INSERT INTO ts_plugins_list VALUES ('7','64','摩登风潮','3');
INSERT INTO ts_plugins_list VALUES ('7','65','蘑女根据地','2');
INSERT INTO ts_plugins_list VALUES ('7','66','The Moment','1');
INSERT INTO ts_plugins_list VALUES ('8','67','任意门','4');
INSERT INTO ts_plugins_list VALUES ('8','68','“耍”大牌','3');
INSERT INTO ts_plugins_list VALUES ('8','69','数码控','2');
INSERT INTO ts_plugins_list VALUES ('8','70','隔壁女生的百宝箱','1');
INSERT INTO ts_plugins_list VALUES ('9','71','Style','4');
INSERT INTO ts_plugins_list VALUES ('9','72','Area','3');
INSERT INTO ts_plugins_list VALUES ('9','73','Element','2');
INSERT INTO ts_plugins_list VALUES ('9','74','Item','1');
INSERT INTO ts_plugins_list VALUES ('10','75','护肤','0');
INSERT INTO ts_plugins_list VALUES ('10','76','彩妆','0');
INSERT INTO ts_plugins_list VALUES ('10','77','品牌','0');
INSERT INTO ts_plugins_list VALUES ('10','78','功效','0');

DROP TABLE IF EXISTS ts_plugins_list_label;
CREATE TABLE `ts_plugins_list_label` (
  `list_id` int(11) NOT NULL,
  `label_id` int(11) NOT NULL,
  PRIMARY KEY (`list_id`,`label_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO ts_plugins_list_label VALUES ('1','24');
INSERT INTO ts_plugins_list_label VALUES ('1','26');
INSERT INTO ts_plugins_list_label VALUES ('1','43');
INSERT INTO ts_plugins_list_label VALUES ('1','47');
INSERT INTO ts_plugins_list_label VALUES ('1','57');
INSERT INTO ts_plugins_list_label VALUES ('1','59');
INSERT INTO ts_plugins_list_label VALUES ('1','64');
INSERT INTO ts_plugins_list_label VALUES ('1','65');
INSERT INTO ts_plugins_list_label VALUES ('2','9');
INSERT INTO ts_plugins_list_label VALUES ('2','15');
INSERT INTO ts_plugins_list_label VALUES ('2','20');
INSERT INTO ts_plugins_list_label VALUES ('2','23');
INSERT INTO ts_plugins_list_label VALUES ('2','50');
INSERT INTO ts_plugins_list_label VALUES ('2','66');
INSERT INTO ts_plugins_list_label VALUES ('3','4');
INSERT INTO ts_plugins_list_label VALUES ('3','5');
INSERT INTO ts_plugins_list_label VALUES ('3','10');
INSERT INTO ts_plugins_list_label VALUES ('3','11');
INSERT INTO ts_plugins_list_label VALUES ('3','12');
INSERT INTO ts_plugins_list_label VALUES ('3','14');
INSERT INTO ts_plugins_list_label VALUES ('3','16');
INSERT INTO ts_plugins_list_label VALUES ('3','21');
INSERT INTO ts_plugins_list_label VALUES ('3','22');
INSERT INTO ts_plugins_list_label VALUES ('3','64');
INSERT INTO ts_plugins_list_label VALUES ('4','39');
INSERT INTO ts_plugins_list_label VALUES ('4','42');
INSERT INTO ts_plugins_list_label VALUES ('4','43');
INSERT INTO ts_plugins_list_label VALUES ('4','44');
INSERT INTO ts_plugins_list_label VALUES ('4','45');
INSERT INTO ts_plugins_list_label VALUES ('4','46');
INSERT INTO ts_plugins_list_label VALUES ('4','47');
INSERT INTO ts_plugins_list_label VALUES ('4','48');
INSERT INTO ts_plugins_list_label VALUES ('4','49');
INSERT INTO ts_plugins_list_label VALUES ('4','51');
INSERT INTO ts_plugins_list_label VALUES ('4','52');
INSERT INTO ts_plugins_list_label VALUES ('4','54');
INSERT INTO ts_plugins_list_label VALUES ('4','55');
INSERT INTO ts_plugins_list_label VALUES ('4','58');
INSERT INTO ts_plugins_list_label VALUES ('4','59');
INSERT INTO ts_plugins_list_label VALUES ('4','60');
INSERT INTO ts_plugins_list_label VALUES ('4','61');
INSERT INTO ts_plugins_list_label VALUES ('4','63');
INSERT INTO ts_plugins_list_label VALUES ('5','28');
INSERT INTO ts_plugins_list_label VALUES ('5','29');
INSERT INTO ts_plugins_list_label VALUES ('5','30');
INSERT INTO ts_plugins_list_label VALUES ('5','31');
INSERT INTO ts_plugins_list_label VALUES ('5','32');
INSERT INTO ts_plugins_list_label VALUES ('5','33');
INSERT INTO ts_plugins_list_label VALUES ('5','34');
INSERT INTO ts_plugins_list_label VALUES ('5','35');
INSERT INTO ts_plugins_list_label VALUES ('5','36');
INSERT INTO ts_plugins_list_label VALUES ('5','37');
INSERT INTO ts_plugins_list_label VALUES ('5','38');
INSERT INTO ts_plugins_list_label VALUES ('5','39');
INSERT INTO ts_plugins_list_label VALUES ('6','62');
INSERT INTO ts_plugins_list_label VALUES ('6','63');
INSERT INTO ts_plugins_list_label VALUES ('6','64');
INSERT INTO ts_plugins_list_label VALUES ('7','70');
INSERT INTO ts_plugins_list_label VALUES ('7','71');
INSERT INTO ts_plugins_list_label VALUES ('7','72');
INSERT INTO ts_plugins_list_label VALUES ('7','73');
INSERT INTO ts_plugins_list_label VALUES ('7','74');
INSERT INTO ts_plugins_list_label VALUES ('8','69');
INSERT INTO ts_plugins_list_label VALUES ('8','70');
INSERT INTO ts_plugins_list_label VALUES ('8','71');
INSERT INTO ts_plugins_list_label VALUES ('8','73');
INSERT INTO ts_plugins_list_label VALUES ('8','74');
INSERT INTO ts_plugins_list_label VALUES ('8','75');
INSERT INTO ts_plugins_list_label VALUES ('9','68');
INSERT INTO ts_plugins_list_label VALUES ('9','69');
INSERT INTO ts_plugins_list_label VALUES ('9','70');
INSERT INTO ts_plugins_list_label VALUES ('9','73');
INSERT INTO ts_plugins_list_label VALUES ('10','68');
INSERT INTO ts_plugins_list_label VALUES ('10','70');
INSERT INTO ts_plugins_list_label VALUES ('10','71');
INSERT INTO ts_plugins_list_label VALUES ('10','72');
INSERT INTO ts_plugins_list_label VALUES ('10','74');
INSERT INTO ts_plugins_list_label VALUES ('11','70');
INSERT INTO ts_plugins_list_label VALUES ('11','73');
INSERT INTO ts_plugins_list_label VALUES ('11','74');
INSERT INTO ts_plugins_list_label VALUES ('11','75');
INSERT INTO ts_plugins_list_label VALUES ('12','68');
INSERT INTO ts_plugins_list_label VALUES ('12','69');
INSERT INTO ts_plugins_list_label VALUES ('12','70');
INSERT INTO ts_plugins_list_label VALUES ('12','71');
INSERT INTO ts_plugins_list_label VALUES ('12','72');
INSERT INTO ts_plugins_list_label VALUES ('12','73');
INSERT INTO ts_plugins_list_label VALUES ('12','74');
INSERT INTO ts_plugins_list_label VALUES ('12','75');
INSERT INTO ts_plugins_list_label VALUES ('12','76');
INSERT INTO ts_plugins_list_label VALUES ('13','77');
INSERT INTO ts_plugins_list_label VALUES ('13','79');
INSERT INTO ts_plugins_list_label VALUES ('13','80');
INSERT INTO ts_plugins_list_label VALUES ('13','82');
INSERT INTO ts_plugins_list_label VALUES ('13','84');
INSERT INTO ts_plugins_list_label VALUES ('13','86');
INSERT INTO ts_plugins_list_label VALUES ('14','77');
INSERT INTO ts_plugins_list_label VALUES ('14','78');
INSERT INTO ts_plugins_list_label VALUES ('14','81');
INSERT INTO ts_plugins_list_label VALUES ('14','86');
INSERT INTO ts_plugins_list_label VALUES ('14','87');
INSERT INTO ts_plugins_list_label VALUES ('15','78');
INSERT INTO ts_plugins_list_label VALUES ('15','81');
INSERT INTO ts_plugins_list_label VALUES ('15','84');
INSERT INTO ts_plugins_list_label VALUES ('15','86');
INSERT INTO ts_plugins_list_label VALUES ('16','79');
INSERT INTO ts_plugins_list_label VALUES ('16','81');
INSERT INTO ts_plugins_list_label VALUES ('16','86');
INSERT INTO ts_plugins_list_label VALUES ('17','92');
INSERT INTO ts_plugins_list_label VALUES ('17','93');
INSERT INTO ts_plugins_list_label VALUES ('17','94');
INSERT INTO ts_plugins_list_label VALUES ('17','96');
INSERT INTO ts_plugins_list_label VALUES ('17','99');
INSERT INTO ts_plugins_list_label VALUES ('17','100');
INSERT INTO ts_plugins_list_label VALUES ('17','101');
INSERT INTO ts_plugins_list_label VALUES ('17','103');
INSERT INTO ts_plugins_list_label VALUES ('18','88');
INSERT INTO ts_plugins_list_label VALUES ('18','89');
INSERT INTO ts_plugins_list_label VALUES ('18','90');
INSERT INTO ts_plugins_list_label VALUES ('18','91');
INSERT INTO ts_plugins_list_label VALUES ('18','92');
INSERT INTO ts_plugins_list_label VALUES ('18','93');
INSERT INTO ts_plugins_list_label VALUES ('18','94');
INSERT INTO ts_plugins_list_label VALUES ('18','95');
INSERT INTO ts_plugins_list_label VALUES ('18','96');
INSERT INTO ts_plugins_list_label VALUES ('18','97');
INSERT INTO ts_plugins_list_label VALUES ('18','98');
INSERT INTO ts_plugins_list_label VALUES ('18','99');
INSERT INTO ts_plugins_list_label VALUES ('18','100');
INSERT INTO ts_plugins_list_label VALUES ('18','101');
INSERT INTO ts_plugins_list_label VALUES ('18','102');
INSERT INTO ts_plugins_list_label VALUES ('18','103');
INSERT INTO ts_plugins_list_label VALUES ('19','88');
INSERT INTO ts_plugins_list_label VALUES ('19','89');
INSERT INTO ts_plugins_list_label VALUES ('19','90');
INSERT INTO ts_plugins_list_label VALUES ('19','91');
INSERT INTO ts_plugins_list_label VALUES ('19','93');
INSERT INTO ts_plugins_list_label VALUES ('19','95');
INSERT INTO ts_plugins_list_label VALUES ('20','96');
INSERT INTO ts_plugins_list_label VALUES ('20','98');
INSERT INTO ts_plugins_list_label VALUES ('20','99');
INSERT INTO ts_plugins_list_label VALUES ('20','100');
INSERT INTO ts_plugins_list_label VALUES ('20','101');
INSERT INTO ts_plugins_list_label VALUES ('20','103');
INSERT INTO ts_plugins_list_label VALUES ('21','104');
INSERT INTO ts_plugins_list_label VALUES ('26','127');
INSERT INTO ts_plugins_list_label VALUES ('26','131');
INSERT INTO ts_plugins_list_label VALUES ('26','137');
INSERT INTO ts_plugins_list_label VALUES ('26','209');
INSERT INTO ts_plugins_list_label VALUES ('26','243');
INSERT INTO ts_plugins_list_label VALUES ('26','244');
INSERT INTO ts_plugins_list_label VALUES ('26','245');
INSERT INTO ts_plugins_list_label VALUES ('26','246');
INSERT INTO ts_plugins_list_label VALUES ('27','5');
INSERT INTO ts_plugins_list_label VALUES ('27','25');
INSERT INTO ts_plugins_list_label VALUES ('27','30');
INSERT INTO ts_plugins_list_label VALUES ('27','56');
INSERT INTO ts_plugins_list_label VALUES ('27','70');
INSERT INTO ts_plugins_list_label VALUES ('27','124');
INSERT INTO ts_plugins_list_label VALUES ('27','153');
INSERT INTO ts_plugins_list_label VALUES ('27','166');
INSERT INTO ts_plugins_list_label VALUES ('27','210');
INSERT INTO ts_plugins_list_label VALUES ('28','113');
INSERT INTO ts_plugins_list_label VALUES ('28','115');
INSERT INTO ts_plugins_list_label VALUES ('28','116');
INSERT INTO ts_plugins_list_label VALUES ('28','165');
INSERT INTO ts_plugins_list_label VALUES ('28','169');
INSERT INTO ts_plugins_list_label VALUES ('28','176');
INSERT INTO ts_plugins_list_label VALUES ('28','247');
INSERT INTO ts_plugins_list_label VALUES ('29','1');
INSERT INTO ts_plugins_list_label VALUES ('29','30');
INSERT INTO ts_plugins_list_label VALUES ('29','48');
INSERT INTO ts_plugins_list_label VALUES ('29','56');
INSERT INTO ts_plugins_list_label VALUES ('29','126');
INSERT INTO ts_plugins_list_label VALUES ('29','152');
INSERT INTO ts_plugins_list_label VALUES ('29','187');
INSERT INTO ts_plugins_list_label VALUES ('29','188');
INSERT INTO ts_plugins_list_label VALUES ('29','189');
INSERT INTO ts_plugins_list_label VALUES ('32','109');
INSERT INTO ts_plugins_list_label VALUES ('32','110');
INSERT INTO ts_plugins_list_label VALUES ('32','112');
INSERT INTO ts_plugins_list_label VALUES ('32','114');
INSERT INTO ts_plugins_list_label VALUES ('32','115');
INSERT INTO ts_plugins_list_label VALUES ('32','120');
INSERT INTO ts_plugins_list_label VALUES ('32','137');
INSERT INTO ts_plugins_list_label VALUES ('32','199');
INSERT INTO ts_plugins_list_label VALUES ('32','200');
INSERT INTO ts_plugins_list_label VALUES ('32','209');
INSERT INTO ts_plugins_list_label VALUES ('33','5');
INSERT INTO ts_plugins_list_label VALUES ('33','6');
INSERT INTO ts_plugins_list_label VALUES ('33','8');
INSERT INTO ts_plugins_list_label VALUES ('33','210');
INSERT INTO ts_plugins_list_label VALUES ('33','211');
INSERT INTO ts_plugins_list_label VALUES ('33','212');
INSERT INTO ts_plugins_list_label VALUES ('34','27');
INSERT INTO ts_plugins_list_label VALUES ('34','30');
INSERT INTO ts_plugins_list_label VALUES ('34','41');
INSERT INTO ts_plugins_list_label VALUES ('34','51');
INSERT INTO ts_plugins_list_label VALUES ('34','57');
INSERT INTO ts_plugins_list_label VALUES ('34','59');
INSERT INTO ts_plugins_list_label VALUES ('34','213');
INSERT INTO ts_plugins_list_label VALUES ('34','214');
INSERT INTO ts_plugins_list_label VALUES ('35','41');
INSERT INTO ts_plugins_list_label VALUES ('35','42');
INSERT INTO ts_plugins_list_label VALUES ('35','43');
INSERT INTO ts_plugins_list_label VALUES ('35','44');
INSERT INTO ts_plugins_list_label VALUES ('35','45');
INSERT INTO ts_plugins_list_label VALUES ('35','46');
INSERT INTO ts_plugins_list_label VALUES ('35','47');
INSERT INTO ts_plugins_list_label VALUES ('35','48');
INSERT INTO ts_plugins_list_label VALUES ('35','49');
INSERT INTO ts_plugins_list_label VALUES ('35','50');
INSERT INTO ts_plugins_list_label VALUES ('35','51');
INSERT INTO ts_plugins_list_label VALUES ('35','52');
INSERT INTO ts_plugins_list_label VALUES ('35','53');
INSERT INTO ts_plugins_list_label VALUES ('35','54');
INSERT INTO ts_plugins_list_label VALUES ('35','55');
INSERT INTO ts_plugins_list_label VALUES ('35','58');
INSERT INTO ts_plugins_list_label VALUES ('35','59');
INSERT INTO ts_plugins_list_label VALUES ('35','60');
INSERT INTO ts_plugins_list_label VALUES ('36','56');
INSERT INTO ts_plugins_list_label VALUES ('36','57');
INSERT INTO ts_plugins_list_label VALUES ('36','58');
INSERT INTO ts_plugins_list_label VALUES ('36','59');
INSERT INTO ts_plugins_list_label VALUES ('36','60');
INSERT INTO ts_plugins_list_label VALUES ('36','106');
INSERT INTO ts_plugins_list_label VALUES ('36','107');
INSERT INTO ts_plugins_list_label VALUES ('37','25');
INSERT INTO ts_plugins_list_label VALUES ('37','38');
INSERT INTO ts_plugins_list_label VALUES ('37','125');
INSERT INTO ts_plugins_list_label VALUES ('37','215');
INSERT INTO ts_plugins_list_label VALUES ('37','216');
INSERT INTO ts_plugins_list_label VALUES ('37','217');
INSERT INTO ts_plugins_list_label VALUES ('38','65');
INSERT INTO ts_plugins_list_label VALUES ('38','66');
INSERT INTO ts_plugins_list_label VALUES ('38','67');
INSERT INTO ts_plugins_list_label VALUES ('39','73');
INSERT INTO ts_plugins_list_label VALUES ('39','74');
INSERT INTO ts_plugins_list_label VALUES ('39','165');
INSERT INTO ts_plugins_list_label VALUES ('39','166');
INSERT INTO ts_plugins_list_label VALUES ('39','167');
INSERT INTO ts_plugins_list_label VALUES ('39','168');
INSERT INTO ts_plugins_list_label VALUES ('39','169');
INSERT INTO ts_plugins_list_label VALUES ('39','170');
INSERT INTO ts_plugins_list_label VALUES ('39','171');
INSERT INTO ts_plugins_list_label VALUES ('40','77');
INSERT INTO ts_plugins_list_label VALUES ('40','78');
INSERT INTO ts_plugins_list_label VALUES ('40','79');
INSERT INTO ts_plugins_list_label VALUES ('40','80');
INSERT INTO ts_plugins_list_label VALUES ('40','81');
INSERT INTO ts_plugins_list_label VALUES ('40','82');
INSERT INTO ts_plugins_list_label VALUES ('40','83');
INSERT INTO ts_plugins_list_label VALUES ('40','84');
INSERT INTO ts_plugins_list_label VALUES ('40','85');
INSERT INTO ts_plugins_list_label VALUES ('40','86');
INSERT INTO ts_plugins_list_label VALUES ('40','87');
INSERT INTO ts_plugins_list_label VALUES ('41','88');
INSERT INTO ts_plugins_list_label VALUES ('41','92');
INSERT INTO ts_plugins_list_label VALUES ('41','96');
INSERT INTO ts_plugins_list_label VALUES ('41','103');
INSERT INTO ts_plugins_list_label VALUES ('41','190');
INSERT INTO ts_plugins_list_label VALUES ('41','192');
INSERT INTO ts_plugins_list_label VALUES ('41','193');
INSERT INTO ts_plugins_list_label VALUES ('42','94');
INSERT INTO ts_plugins_list_label VALUES ('42','97');
INSERT INTO ts_plugins_list_label VALUES ('42','98');
INSERT INTO ts_plugins_list_label VALUES ('42','99');
INSERT INTO ts_plugins_list_label VALUES ('42','100');
INSERT INTO ts_plugins_list_label VALUES ('42','194');
INSERT INTO ts_plugins_list_label VALUES ('42','195');
INSERT INTO ts_plugins_list_label VALUES ('44','1');
INSERT INTO ts_plugins_list_label VALUES ('44','25');
INSERT INTO ts_plugins_list_label VALUES ('44','41');
INSERT INTO ts_plugins_list_label VALUES ('44','76');
INSERT INTO ts_plugins_list_label VALUES ('44','99');
INSERT INTO ts_plugins_list_label VALUES ('44','116');
INSERT INTO ts_plugins_list_label VALUES ('44','137');
INSERT INTO ts_plugins_list_label VALUES ('44','162');
INSERT INTO ts_plugins_list_label VALUES ('45','109');
INSERT INTO ts_plugins_list_label VALUES ('45','110');
INSERT INTO ts_plugins_list_label VALUES ('45','112');
INSERT INTO ts_plugins_list_label VALUES ('45','114');
INSERT INTO ts_plugins_list_label VALUES ('45','115');
INSERT INTO ts_plugins_list_label VALUES ('45','120');
INSERT INTO ts_plugins_list_label VALUES ('45','199');
INSERT INTO ts_plugins_list_label VALUES ('45','209');
INSERT INTO ts_plugins_list_label VALUES ('46','127');
INSERT INTO ts_plugins_list_label VALUES ('46','128');
INSERT INTO ts_plugins_list_label VALUES ('46','129');
INSERT INTO ts_plugins_list_label VALUES ('46','130');
INSERT INTO ts_plugins_list_label VALUES ('46','131');
INSERT INTO ts_plugins_list_label VALUES ('46','132');
INSERT INTO ts_plugins_list_label VALUES ('46','133');
INSERT INTO ts_plugins_list_label VALUES ('46','134');
INSERT INTO ts_plugins_list_label VALUES ('47','139');
INSERT INTO ts_plugins_list_label VALUES ('47','141');
INSERT INTO ts_plugins_list_label VALUES ('47','143');
INSERT INTO ts_plugins_list_label VALUES ('47','145');
INSERT INTO ts_plugins_list_label VALUES ('47','147');
INSERT INTO ts_plugins_list_label VALUES ('47','149');
INSERT INTO ts_plugins_list_label VALUES ('47','159');
INSERT INTO ts_plugins_list_label VALUES ('47','160');
INSERT INTO ts_plugins_list_label VALUES ('48','6');
INSERT INTO ts_plugins_list_label VALUES ('48','30');
INSERT INTO ts_plugins_list_label VALUES ('48','121');
INSERT INTO ts_plugins_list_label VALUES ('48','124');
INSERT INTO ts_plugins_list_label VALUES ('48','139');
INSERT INTO ts_plugins_list_label VALUES ('48','152');
INSERT INTO ts_plugins_list_label VALUES ('48','164');
INSERT INTO ts_plugins_list_label VALUES ('48','199');
INSERT INTO ts_plugins_list_label VALUES ('49','6');
INSERT INTO ts_plugins_list_label VALUES ('49','14');
INSERT INTO ts_plugins_list_label VALUES ('49','15');
INSERT INTO ts_plugins_list_label VALUES ('49','21');
INSERT INTO ts_plugins_list_label VALUES ('49','68');
INSERT INTO ts_plugins_list_label VALUES ('49','155');
INSERT INTO ts_plugins_list_label VALUES ('49','163');
INSERT INTO ts_plugins_list_label VALUES ('49','164');
INSERT INTO ts_plugins_list_label VALUES ('50','1');
INSERT INTO ts_plugins_list_label VALUES ('50','73');
INSERT INTO ts_plugins_list_label VALUES ('50','74');
INSERT INTO ts_plugins_list_label VALUES ('50','77');
INSERT INTO ts_plugins_list_label VALUES ('50','152');
INSERT INTO ts_plugins_list_label VALUES ('50','167');
INSERT INTO ts_plugins_list_label VALUES ('50','188');
INSERT INTO ts_plugins_list_label VALUES ('51','139');
INSERT INTO ts_plugins_list_label VALUES ('51','141');
INSERT INTO ts_plugins_list_label VALUES ('51','143');
INSERT INTO ts_plugins_list_label VALUES ('51','145');
INSERT INTO ts_plugins_list_label VALUES ('51','147');
INSERT INTO ts_plugins_list_label VALUES ('51','149');
INSERT INTO ts_plugins_list_label VALUES ('51','159');
INSERT INTO ts_plugins_list_label VALUES ('51','160');
INSERT INTO ts_plugins_list_label VALUES ('52','90');
INSERT INTO ts_plugins_list_label VALUES ('52','91');
INSERT INTO ts_plugins_list_label VALUES ('52','93');
INSERT INTO ts_plugins_list_label VALUES ('52','95');
INSERT INTO ts_plugins_list_label VALUES ('52','196');
INSERT INTO ts_plugins_list_label VALUES ('52','197');
INSERT INTO ts_plugins_list_label VALUES ('52','198');
INSERT INTO ts_plugins_list_label VALUES ('52','201');
INSERT INTO ts_plugins_list_label VALUES ('53','202');
INSERT INTO ts_plugins_list_label VALUES ('53','203');
INSERT INTO ts_plugins_list_label VALUES ('53','204');
INSERT INTO ts_plugins_list_label VALUES ('53','205');
INSERT INTO ts_plugins_list_label VALUES ('53','206');
INSERT INTO ts_plugins_list_label VALUES ('53','207');
INSERT INTO ts_plugins_list_label VALUES ('53','208');
INSERT INTO ts_plugins_list_label VALUES ('54','78');
INSERT INTO ts_plugins_list_label VALUES ('54','79');
INSERT INTO ts_plugins_list_label VALUES ('54','80');
INSERT INTO ts_plugins_list_label VALUES ('54','84');
INSERT INTO ts_plugins_list_label VALUES ('54','87');
INSERT INTO ts_plugins_list_label VALUES ('54','226');
INSERT INTO ts_plugins_list_label VALUES ('54','227');
INSERT INTO ts_plugins_list_label VALUES ('54','228');
INSERT INTO ts_plugins_list_label VALUES ('55','248');
INSERT INTO ts_plugins_list_label VALUES ('55','249');
INSERT INTO ts_plugins_list_label VALUES ('55','250');
INSERT INTO ts_plugins_list_label VALUES ('55','251');
INSERT INTO ts_plugins_list_label VALUES ('55','252');
INSERT INTO ts_plugins_list_label VALUES ('55','253');
INSERT INTO ts_plugins_list_label VALUES ('55','254');
INSERT INTO ts_plugins_list_label VALUES ('56','234');
INSERT INTO ts_plugins_list_label VALUES ('56','235');
INSERT INTO ts_plugins_list_label VALUES ('56','239');
INSERT INTO ts_plugins_list_label VALUES ('56','240');
INSERT INTO ts_plugins_list_label VALUES ('56','241');
INSERT INTO ts_plugins_list_label VALUES ('56','255');
INSERT INTO ts_plugins_list_label VALUES ('57','68');
INSERT INTO ts_plugins_list_label VALUES ('57','70');
INSERT INTO ts_plugins_list_label VALUES ('57','73');
INSERT INTO ts_plugins_list_label VALUES ('57','172');
INSERT INTO ts_plugins_list_label VALUES ('57','173');
INSERT INTO ts_plugins_list_label VALUES ('57','174');
INSERT INTO ts_plugins_list_label VALUES ('57','175');
INSERT INTO ts_plugins_list_label VALUES ('58','111');
INSERT INTO ts_plugins_list_label VALUES ('58','112');
INSERT INTO ts_plugins_list_label VALUES ('58','114');
INSERT INTO ts_plugins_list_label VALUES ('58','162');
INSERT INTO ts_plugins_list_label VALUES ('58','176');
INSERT INTO ts_plugins_list_label VALUES ('58','179');
INSERT INTO ts_plugins_list_label VALUES ('58','238');
INSERT INTO ts_plugins_list_label VALUES ('59','127');
INSERT INTO ts_plugins_list_label VALUES ('59','129');
INSERT INTO ts_plugins_list_label VALUES ('59','167');
INSERT INTO ts_plugins_list_label VALUES ('59','177');
INSERT INTO ts_plugins_list_label VALUES ('59','180');
INSERT INTO ts_plugins_list_label VALUES ('59','209');
INSERT INTO ts_plugins_list_label VALUES ('59','236');
INSERT INTO ts_plugins_list_label VALUES ('59','237');
INSERT INTO ts_plugins_list_label VALUES ('60','170');
INSERT INTO ts_plugins_list_label VALUES ('60','178');
INSERT INTO ts_plugins_list_label VALUES ('60','181');
INSERT INTO ts_plugins_list_label VALUES ('60','182');
INSERT INTO ts_plugins_list_label VALUES ('60','183');
INSERT INTO ts_plugins_list_label VALUES ('60','184');
INSERT INTO ts_plugins_list_label VALUES ('60','185');
INSERT INTO ts_plugins_list_label VALUES ('60','186');
INSERT INTO ts_plugins_list_label VALUES ('61','165');
INSERT INTO ts_plugins_list_label VALUES ('61','168');
INSERT INTO ts_plugins_list_label VALUES ('61','229');
INSERT INTO ts_plugins_list_label VALUES ('61','230');
INSERT INTO ts_plugins_list_label VALUES ('61','231');
INSERT INTO ts_plugins_list_label VALUES ('61','232');
INSERT INTO ts_plugins_list_label VALUES ('61','233');
INSERT INTO ts_plugins_list_label VALUES ('62','62');
INSERT INTO ts_plugins_list_label VALUES ('62','63');
INSERT INTO ts_plugins_list_label VALUES ('62','102');
INSERT INTO ts_plugins_list_label VALUES ('62','124');
INSERT INTO ts_plugins_list_label VALUES ('62','189');
INSERT INTO ts_plugins_list_label VALUES ('62','200');
INSERT INTO ts_plugins_list_label VALUES ('62','218');
INSERT INTO ts_plugins_list_label VALUES ('62','219');
INSERT INTO ts_plugins_list_label VALUES ('63','3');
INSERT INTO ts_plugins_list_label VALUES ('63','6');
INSERT INTO ts_plugins_list_label VALUES ('63','13');
INSERT INTO ts_plugins_list_label VALUES ('63','70');
INSERT INTO ts_plugins_list_label VALUES ('63','73');
INSERT INTO ts_plugins_list_label VALUES ('63','74');
INSERT INTO ts_plugins_list_label VALUES ('63','79');
INSERT INTO ts_plugins_list_label VALUES ('63','86');
INSERT INTO ts_plugins_list_label VALUES ('63','92');
INSERT INTO ts_plugins_list_label VALUES ('63','100');
INSERT INTO ts_plugins_list_label VALUES ('63','219');
INSERT INTO ts_plugins_list_label VALUES ('63','229');
INSERT INTO ts_plugins_list_label VALUES ('64','127');
INSERT INTO ts_plugins_list_label VALUES ('64','137');
INSERT INTO ts_plugins_list_label VALUES ('64','199');
INSERT INTO ts_plugins_list_label VALUES ('64','236');
INSERT INTO ts_plugins_list_label VALUES ('64','246');
INSERT INTO ts_plugins_list_label VALUES ('64','275');
INSERT INTO ts_plugins_list_label VALUES ('64','276');
INSERT INTO ts_plugins_list_label VALUES ('64','277');
INSERT INTO ts_plugins_list_label VALUES ('65','278');
INSERT INTO ts_plugins_list_label VALUES ('65','279');
INSERT INTO ts_plugins_list_label VALUES ('65','280');
INSERT INTO ts_plugins_list_label VALUES ('65','281');
INSERT INTO ts_plugins_list_label VALUES ('65','282');
INSERT INTO ts_plugins_list_label VALUES ('65','283');
INSERT INTO ts_plugins_list_label VALUES ('65','284');
INSERT INTO ts_plugins_list_label VALUES ('65','285');
INSERT INTO ts_plugins_list_label VALUES ('66','5');
INSERT INTO ts_plugins_list_label VALUES ('66','58');
INSERT INTO ts_plugins_list_label VALUES ('66','59');
INSERT INTO ts_plugins_list_label VALUES ('66','60');
INSERT INTO ts_plugins_list_label VALUES ('66','117');
INSERT INTO ts_plugins_list_label VALUES ('66','122');
INSERT INTO ts_plugins_list_label VALUES ('66','139');
INSERT INTO ts_plugins_list_label VALUES ('66','204');
INSERT INTO ts_plugins_list_label VALUES ('66','230');
INSERT INTO ts_plugins_list_label VALUES ('66','237');
INSERT INTO ts_plugins_list_label VALUES ('66','260');
INSERT INTO ts_plugins_list_label VALUES ('67','5');
INSERT INTO ts_plugins_list_label VALUES ('67','48');
INSERT INTO ts_plugins_list_label VALUES ('67','122');
INSERT INTO ts_plugins_list_label VALUES ('67','153');
INSERT INTO ts_plugins_list_label VALUES ('67','204');
INSERT INTO ts_plugins_list_label VALUES ('67','222');
INSERT INTO ts_plugins_list_label VALUES ('67','256');
INSERT INTO ts_plugins_list_label VALUES ('67','268');
INSERT INTO ts_plugins_list_label VALUES ('68','104');
INSERT INTO ts_plugins_list_label VALUES ('68','139');
INSERT INTO ts_plugins_list_label VALUES ('68','160');
INSERT INTO ts_plugins_list_label VALUES ('69','20');
INSERT INTO ts_plugins_list_label VALUES ('69','36');
INSERT INTO ts_plugins_list_label VALUES ('69','54');
INSERT INTO ts_plugins_list_label VALUES ('69','76');
INSERT INTO ts_plugins_list_label VALUES ('69','158');
INSERT INTO ts_plugins_list_label VALUES ('69','168');
INSERT INTO ts_plugins_list_label VALUES ('69','170');
INSERT INTO ts_plugins_list_label VALUES ('69','177');
INSERT INTO ts_plugins_list_label VALUES ('69','182');
INSERT INTO ts_plugins_list_label VALUES ('69','198');
INSERT INTO ts_plugins_list_label VALUES ('70','22');
INSERT INTO ts_plugins_list_label VALUES ('70','34');
INSERT INTO ts_plugins_list_label VALUES ('70','39');
INSERT INTO ts_plugins_list_label VALUES ('70','48');
INSERT INTO ts_plugins_list_label VALUES ('70','63');
INSERT INTO ts_plugins_list_label VALUES ('70','65');
INSERT INTO ts_plugins_list_label VALUES ('70','69');
INSERT INTO ts_plugins_list_label VALUES ('70','77');
INSERT INTO ts_plugins_list_label VALUES ('70','123');
INSERT INTO ts_plugins_list_label VALUES ('70','128');
INSERT INTO ts_plugins_list_label VALUES ('70','143');
INSERT INTO ts_plugins_list_label VALUES ('70','151');
INSERT INTO ts_plugins_list_label VALUES ('70','153');
INSERT INTO ts_plugins_list_label VALUES ('70','166');
INSERT INTO ts_plugins_list_label VALUES ('70','174');
INSERT INTO ts_plugins_list_label VALUES ('70','186');
INSERT INTO ts_plugins_list_label VALUES ('70','222');
INSERT INTO ts_plugins_list_label VALUES ('70','228');
INSERT INTO ts_plugins_list_label VALUES ('70','232');
INSERT INTO ts_plugins_list_label VALUES ('70','256');
INSERT INTO ts_plugins_list_label VALUES ('70','262');
INSERT INTO ts_plugins_list_label VALUES ('70','268');
INSERT INTO ts_plugins_list_label VALUES ('70','272');
INSERT INTO ts_plugins_list_label VALUES ('70','282');
INSERT INTO ts_plugins_list_label VALUES ('71','5');
INSERT INTO ts_plugins_list_label VALUES ('71','58');
INSERT INTO ts_plugins_list_label VALUES ('71','59');
INSERT INTO ts_plugins_list_label VALUES ('71','60');
INSERT INTO ts_plugins_list_label VALUES ('71','117');
INSERT INTO ts_plugins_list_label VALUES ('71','122');
INSERT INTO ts_plugins_list_label VALUES ('71','139');
INSERT INTO ts_plugins_list_label VALUES ('71','145');
INSERT INTO ts_plugins_list_label VALUES ('71','204');
INSERT INTO ts_plugins_list_label VALUES ('71','230');
INSERT INTO ts_plugins_list_label VALUES ('71','246');
INSERT INTO ts_plugins_list_label VALUES ('71','260');
INSERT INTO ts_plugins_list_label VALUES ('72','278');
INSERT INTO ts_plugins_list_label VALUES ('72','281');
INSERT INTO ts_plugins_list_label VALUES ('72','283');
INSERT INTO ts_plugins_list_label VALUES ('73','34');
INSERT INTO ts_plugins_list_label VALUES ('73','49');
INSERT INTO ts_plugins_list_label VALUES ('73','65');
INSERT INTO ts_plugins_list_label VALUES ('73','77');
INSERT INTO ts_plugins_list_label VALUES ('73','153');
INSERT INTO ts_plugins_list_label VALUES ('73','166');
INSERT INTO ts_plugins_list_label VALUES ('73','174');
INSERT INTO ts_plugins_list_label VALUES ('73','227');
INSERT INTO ts_plugins_list_label VALUES ('73','228');
INSERT INTO ts_plugins_list_label VALUES ('73','256');
INSERT INTO ts_plugins_list_label VALUES ('73','262');
INSERT INTO ts_plugins_list_label VALUES ('73','268');
INSERT INTO ts_plugins_list_label VALUES ('73','282');
INSERT INTO ts_plugins_list_label VALUES ('74','3');
INSERT INTO ts_plugins_list_label VALUES ('74','40');
INSERT INTO ts_plugins_list_label VALUES ('74','47');
INSERT INTO ts_plugins_list_label VALUES ('74','62');
INSERT INTO ts_plugins_list_label VALUES ('74','73');
INSERT INTO ts_plugins_list_label VALUES ('74','74');
INSERT INTO ts_plugins_list_label VALUES ('74','86');
INSERT INTO ts_plugins_list_label VALUES ('74','100');
INSERT INTO ts_plugins_list_label VALUES ('74','183');
INSERT INTO ts_plugins_list_label VALUES ('74','229');
INSERT INTO ts_plugins_list_label VALUES ('74','240');
INSERT INTO ts_plugins_list_label VALUES ('74','259');
INSERT INTO ts_plugins_list_label VALUES ('74','277');

DROP TABLE IF EXISTS ts_plugins_node;
CREATE TABLE `ts_plugins_node` (
  `node_id` int(11) NOT NULL AUTO_INCREMENT,
  `node_name` varchar(50) DEFAULT '',
  `node_seq` int(11) DEFAULT '0',
  PRIMARY KEY (`node_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO ts_plugins_node VALUES ('1','衣服','5');
INSERT INTO ts_plugins_node VALUES ('2','鞋子','4');
INSERT INTO ts_plugins_node VALUES ('3','包包','3');
INSERT INTO ts_plugins_node VALUES ('4','配饰','2');
INSERT INTO ts_plugins_node VALUES ('5','家居','1');
INSERT INTO ts_plugins_node VALUES ('6','逛街啦','999');
INSERT INTO ts_plugins_node VALUES ('7','搭配秀','-999');
INSERT INTO ts_plugins_node VALUES ('8','晒货','-999');
INSERT INTO ts_plugins_node VALUES ('9','潮STYLE','-999');
INSERT INTO ts_plugins_node VALUES ('10','美妆','1');

DROP TABLE IF EXISTS ts_poster;
CREATE TABLE `ts_poster` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `title` varchar(255) CHARACTER SET gbk NOT NULL,
  `type` int(11) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `address_city` int(11) DEFAULT NULL,
  `address_province` int(11) DEFAULT NULL,
  `cTime` int(11) DEFAULT NULL,
  `deadline` int(11) DEFAULT NULL,
  `content` text CHARACTER SET gbk NOT NULL,
  `contact` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `private` int(1) NOT NULL DEFAULT '0',
  `cover` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `extra1` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `extra2` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `extra3` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `extra4` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `extra5` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_poster_small_type;
CREATE TABLE `ts_poster_small_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(255) CHARACTER SET gbk NOT NULL DEFAULT '类别',
  `name` varchar(255) CHARACTER SET gbk NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO ts_poster_small_type VALUES ('1','物品分类','影碟音像');
INSERT INTO ts_poster_small_type VALUES ('2','物品分类','书籍资料');
INSERT INTO ts_poster_small_type VALUES ('3','物品分类','服装饰品');
INSERT INTO ts_poster_small_type VALUES ('4','物品分类','日用百货');
INSERT INTO ts_poster_small_type VALUES ('5','物品分类','化妆保健品');
INSERT INTO ts_poster_small_type VALUES ('6','物品分类','票务优惠券');
INSERT INTO ts_poster_small_type VALUES ('7','物品分类','电脑相关');
INSERT INTO ts_poster_small_type VALUES ('8','物品分类','数码通讯');
INSERT INTO ts_poster_small_type VALUES ('9','物品分类','电家具');
INSERT INTO ts_poster_small_type VALUES ('10','物品分类','婴童用品');
INSERT INTO ts_poster_small_type VALUES ('11','物品分类','工艺收藏');
INSERT INTO ts_poster_small_type VALUES ('12','物品分类','其它');
INSERT INTO ts_poster_small_type VALUES ('13','团购种类','我要发起一个新团购');
INSERT INTO ts_poster_small_type VALUES ('14','团购种类','我要告诉大家团购消息');
INSERT INTO ts_poster_small_type VALUES ('15','房屋信息','出租');
INSERT INTO ts_poster_small_type VALUES ('16','房屋信息','求租');

DROP TABLE IF EXISTS ts_poster_type;
CREATE TABLE `ts_poster_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET gbk NOT NULL,
  `type` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `templet` varchar(255) CHARACTER SET gbk DEFAULT NULL,
  `explain` varchar(255) CHARACTER SET gbk NOT NULL,
  `ico` varchar(255) CHARACTER SET gbk NOT NULL,
  `state` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO ts_poster_type VALUES ('1','分享物品','物品分类','12','与好友分享你的闲置物品如书籍、影碟、生活用品等，赠送、交换或出借','icon_fx.gif','0');
INSERT INTO ts_poster_type VALUES ('2','出售二手物品','物品分类','13','发布各类二手物品出售信息，可通过好友转发给更多的人','icon_rs.gif','0');
INSERT INTO ts_poster_type VALUES ('3','团购信息','团购种类','','你发起或想要告诉好友的任何团购优惠','icon_tg.gif','0');
INSERT INTO ts_poster_type VALUES ('4','拼车','物品类别','','发布拼车、搭顺风车相关信息','icon_pc.gif','0');
INSERT INTO ts_poster_type VALUES ('5','物品求购','物品分类','13','发布你的生活物品等的求购信息','icon_qg.gif','0');
INSERT INTO ts_poster_type VALUES ('6','房屋求租、出租','房屋信息','14,15,16','发布房屋出租或求租、合租等信息。','icon_house1.gif','0');

DROP TABLE IF EXISTS ts_poster_widget;
CREATE TABLE `ts_poster_widget` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(255) CHARACTER SET gbk NOT NULL,
  `widget` varchar(255) CHARACTER SET gbk NOT NULL,
  `data` text CHARACTER SET gbk NOT NULL,
  `field` varchar(255) CHARACTER SET gbk NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO ts_poster_widget VALUES ('12','分享方式','CheckBox','a:3:{i:0;s:16:\"赠送[selected]\";i:1;s:8:\"\r\n借用\";i:2;s:8:\"\r\n交换\";}','extra1');
INSERT INTO ts_poster_widget VALUES ('13','价格','Input','s:0:\"\";','extra1');
INSERT INTO ts_poster_widget VALUES ('14','位置','Input','s:0:\"\";','extra1');
INSERT INTO ts_poster_widget VALUES ('15','面积','Input','s:0:\"\";','extra2');
INSERT INTO ts_poster_widget VALUES ('16','租金','Input','s:0:\"\";','extra3');

DROP TABLE IF EXISTS ts_space;
CREATE TABLE `ts_space` (
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `hit` int(11) unsigned NOT NULL DEFAULT '0',
  `setting` text NOT NULL,
  `credit_score` int(11) unsigned NOT NULL DEFAULT '0',
  `credit_exp` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO ts_space VALUES ('2','0','','0','0');
INSERT INTO ts_space VALUES ('3','0','','0','0');
INSERT INTO ts_space VALUES ('4','0','','0','0');
INSERT INTO ts_space VALUES ('5','0','','0','0');
INSERT INTO ts_space VALUES ('6','0','','0','0');
INSERT INTO ts_space VALUES ('7','0','','0','0');
INSERT INTO ts_space VALUES ('8','0','','0','0');
INSERT INTO ts_space VALUES ('9','0','','0','0');
INSERT INTO ts_space VALUES ('10','0','','0','0');
INSERT INTO ts_space VALUES ('11','0','','0','0');
INSERT INTO ts_space VALUES ('12','0','','0','0');
INSERT INTO ts_space VALUES ('13','0','','0','0');
INSERT INTO ts_space VALUES ('15','0','','0','0');
INSERT INTO ts_space VALUES ('16','0','','0','0');
INSERT INTO ts_space VALUES ('17','0','','0','0');
INSERT INTO ts_space VALUES ('18','0','','0','0');
INSERT INTO ts_space VALUES ('19','0','','0','0');
INSERT INTO ts_space VALUES ('14','0','','0','0');
INSERT INTO ts_space VALUES ('20','0','','0','0');
INSERT INTO ts_space VALUES ('21','0','','0','0');
INSERT INTO ts_space VALUES ('22','0','','0','0');
INSERT INTO ts_space VALUES ('23','0','','0','0');
INSERT INTO ts_space VALUES ('24','0','','0','0');
INSERT INTO ts_space VALUES ('25','0','','0','0');
INSERT INTO ts_space VALUES ('26','0','','0','0');
INSERT INTO ts_space VALUES ('27','0','','0','0');
INSERT INTO ts_space VALUES ('28','0','','0','0');
INSERT INTO ts_space VALUES ('29','0','','0','0');
INSERT INTO ts_space VALUES ('30','0','','0','0');
INSERT INTO ts_space VALUES ('31','0','','0','0');
INSERT INTO ts_space VALUES ('32','0','','0','0');
INSERT INTO ts_space VALUES ('33','0','','0','0');
INSERT INTO ts_space VALUES ('34','0','','0','0');
INSERT INTO ts_space VALUES ('35','0','','0','0');
INSERT INTO ts_space VALUES ('36','0','','0','0');
INSERT INTO ts_space VALUES ('37','0','','0','0');
INSERT INTO ts_space VALUES ('38','0','','0','0');
INSERT INTO ts_space VALUES ('39','0','','0','0');
INSERT INTO ts_space VALUES ('40','0','','0','0');
INSERT INTO ts_space VALUES ('41','0','','0','0');
INSERT INTO ts_space VALUES ('42','0','','0','0');
INSERT INTO ts_space VALUES ('43','0','','0','0');
INSERT INTO ts_space VALUES ('44','0','','0','0');
INSERT INTO ts_space VALUES ('45','0','','0','0');
INSERT INTO ts_space VALUES ('46','0','','0','0');
INSERT INTO ts_space VALUES ('47','0','','0','0');
INSERT INTO ts_space VALUES ('48','0','','0','0');
INSERT INTO ts_space VALUES ('49','0','','0','0');
INSERT INTO ts_space VALUES ('50','0','','0','0');
INSERT INTO ts_space VALUES ('51','0','','0','0');
INSERT INTO ts_space VALUES ('52','0','','0','0');
INSERT INTO ts_space VALUES ('53','0','','0','0');
INSERT INTO ts_space VALUES ('56','0','','0','0');
INSERT INTO ts_space VALUES ('57','0','','0','0');
INSERT INTO ts_space VALUES ('58','0','','0','0');
INSERT INTO ts_space VALUES ('59','0','','0','0');
INSERT INTO ts_space VALUES ('60','0','','0','0');
INSERT INTO ts_space VALUES ('61','0','','0','0');
INSERT INTO ts_space VALUES ('62','0','','0','0');
INSERT INTO ts_space VALUES ('63','0','','0','0');
INSERT INTO ts_space VALUES ('64','0','','0','0');
INSERT INTO ts_space VALUES ('65','0','','0','0');
INSERT INTO ts_space VALUES ('66','0','','0','0');
INSERT INTO ts_space VALUES ('67','0','','0','0');
INSERT INTO ts_space VALUES ('68','0','','0','0');
INSERT INTO ts_space VALUES ('69','0','','0','0');
INSERT INTO ts_space VALUES ('70','0','','0','0');
INSERT INTO ts_space VALUES ('71','0','','0','0');
INSERT INTO ts_space VALUES ('72','0','','0','0');
INSERT INTO ts_space VALUES ('73','0','','0','0');
INSERT INTO ts_space VALUES ('74','0','','0','0');
INSERT INTO ts_space VALUES ('75','0','','0','0');
INSERT INTO ts_space VALUES ('76','0','','0','0');
INSERT INTO ts_space VALUES ('77','0','','0','0');
INSERT INTO ts_space VALUES ('78','0','','0','0');
INSERT INTO ts_space VALUES ('79','0','','0','0');
INSERT INTO ts_space VALUES ('80','0','','0','0');
INSERT INTO ts_space VALUES ('81','0','','0','0');
INSERT INTO ts_space VALUES ('82','0','','0','0');
INSERT INTO ts_space VALUES ('83','0','','0','0');
INSERT INTO ts_space VALUES ('84','0','','0','0');
INSERT INTO ts_space VALUES ('85','0','','0','0');
INSERT INTO ts_space VALUES ('86','0','','0','0');
INSERT INTO ts_space VALUES ('87','0','','0','0');
INSERT INTO ts_space VALUES ('90','0','','0','0');
INSERT INTO ts_space VALUES ('91','0','','0','0');
INSERT INTO ts_space VALUES ('92','0','','0','0');
INSERT INTO ts_space VALUES ('93','0','','0','0');
INSERT INTO ts_space VALUES ('94','0','','0','0');
INSERT INTO ts_space VALUES ('95','0','','0','0');
INSERT INTO ts_space VALUES ('96','0','','0','0');
INSERT INTO ts_space VALUES ('97','0','','0','0');
INSERT INTO ts_space VALUES ('98','0','','0','0');
INSERT INTO ts_space VALUES ('99','0','','0','0');
INSERT INTO ts_space VALUES ('100','0','','0','0');
INSERT INTO ts_space VALUES ('101','0','','0','0');
INSERT INTO ts_space VALUES ('102','0','','0','0');
INSERT INTO ts_space VALUES ('103','0','','0','0');
INSERT INTO ts_space VALUES ('104','0','','0','0');
INSERT INTO ts_space VALUES ('105','0','','0','0');
INSERT INTO ts_space VALUES ('106','0','','0','0');
INSERT INTO ts_space VALUES ('107','0','','0','0');
INSERT INTO ts_space VALUES ('108','0','','0','0');
INSERT INTO ts_space VALUES ('109','0','','0','0');
INSERT INTO ts_space VALUES ('110','0','','0','0');
INSERT INTO ts_space VALUES ('111','0','','0','0');
INSERT INTO ts_space VALUES ('112','0','','0','0');
INSERT INTO ts_space VALUES ('113','0','','0','0');
INSERT INTO ts_space VALUES ('114','0','','0','0');
INSERT INTO ts_space VALUES ('115','0','','0','0');
INSERT INTO ts_space VALUES ('116','0','','0','0');
INSERT INTO ts_space VALUES ('117','0','','0','0');
INSERT INTO ts_space VALUES ('118','0','','0','0');
INSERT INTO ts_space VALUES ('119','0','','0','0');
INSERT INTO ts_space VALUES ('120','0','','0','0');
INSERT INTO ts_space VALUES ('121','0','','0','0');
INSERT INTO ts_space VALUES ('122','0','','0','0');
INSERT INTO ts_space VALUES ('123','0','','0','0');
INSERT INTO ts_space VALUES ('124','0','','0','0');
INSERT INTO ts_space VALUES ('126','0','','0','0');
INSERT INTO ts_space VALUES ('127','0','','0','0');
INSERT INTO ts_space VALUES ('128','0','','0','0');
INSERT INTO ts_space VALUES ('129','0','','0','0');
INSERT INTO ts_space VALUES ('130','0','','0','0');
INSERT INTO ts_space VALUES ('131','0','','0','0');
INSERT INTO ts_space VALUES ('132','0','','0','0');
INSERT INTO ts_space VALUES ('134','0','','0','0');
INSERT INTO ts_space VALUES ('135','0','','0','0');
INSERT INTO ts_space VALUES ('136','0','','0','0');
INSERT INTO ts_space VALUES ('137','0','','0','0');
INSERT INTO ts_space VALUES ('138','0','','0','0');
INSERT INTO ts_space VALUES ('139','0','','0','0');
INSERT INTO ts_space VALUES ('140','0','','0','0');
INSERT INTO ts_space VALUES ('141','0','','0','0');
INSERT INTO ts_space VALUES ('142','0','','0','0');
INSERT INTO ts_space VALUES ('143','0','','0','0');
INSERT INTO ts_space VALUES ('144','0','','0','0');
INSERT INTO ts_space VALUES ('145','0','','0','0');
INSERT INTO ts_space VALUES ('146','0','','0','0');
INSERT INTO ts_space VALUES ('147','0','','0','0');
INSERT INTO ts_space VALUES ('148','0','','0','0');
INSERT INTO ts_space VALUES ('149','0','','0','0');
INSERT INTO ts_space VALUES ('150','0','','0','0');
INSERT INTO ts_space VALUES ('151','0','','0','0');
INSERT INTO ts_space VALUES ('152','0','','0','0');
INSERT INTO ts_space VALUES ('153','0','','0','0');
INSERT INTO ts_space VALUES ('154','0','','0','0');
INSERT INTO ts_space VALUES ('155','0','','0','0');
INSERT INTO ts_space VALUES ('156','0','','0','0');
INSERT INTO ts_space VALUES ('157','0','','0','0');
INSERT INTO ts_space VALUES ('158','0','','0','0');
INSERT INTO ts_space VALUES ('159','0','','0','0');
INSERT INTO ts_space VALUES ('160','0','','0','0');
INSERT INTO ts_space VALUES ('161','0','','0','0');
INSERT INTO ts_space VALUES ('162','0','','0','0');
INSERT INTO ts_space VALUES ('163','0','','0','0');
INSERT INTO ts_space VALUES ('164','0','','0','0');
INSERT INTO ts_space VALUES ('165','0','','0','0');
INSERT INTO ts_space VALUES ('231','0','','0','0');
INSERT INTO ts_space VALUES ('166','0','','0','0');
INSERT INTO ts_space VALUES ('167','0','','0','0');
INSERT INTO ts_space VALUES ('168','0','','0','0');
INSERT INTO ts_space VALUES ('169','0','','0','0');
INSERT INTO ts_space VALUES ('171','0','','0','0');
INSERT INTO ts_space VALUES ('172','0','','0','0');
INSERT INTO ts_space VALUES ('173','0','','0','0');
INSERT INTO ts_space VALUES ('174','0','','0','0');
INSERT INTO ts_space VALUES ('175','0','','0','0');
INSERT INTO ts_space VALUES ('176','0','','0','0');
INSERT INTO ts_space VALUES ('177','0','','0','0');
INSERT INTO ts_space VALUES ('178','0','','0','0');
INSERT INTO ts_space VALUES ('179','0','','0','0');
INSERT INTO ts_space VALUES ('180','0','','0','0');
INSERT INTO ts_space VALUES ('181','0','','0','0');
INSERT INTO ts_space VALUES ('182','0','','0','0');
INSERT INTO ts_space VALUES ('183','0','','0','0');
INSERT INTO ts_space VALUES ('184','0','','0','0');
INSERT INTO ts_space VALUES ('185','0','','0','0');
INSERT INTO ts_space VALUES ('186','0','','0','0');
INSERT INTO ts_space VALUES ('187','0','','0','0');
INSERT INTO ts_space VALUES ('188','0','','0','0');
INSERT INTO ts_space VALUES ('189','0','','0','0');
INSERT INTO ts_space VALUES ('190','0','','0','0');
INSERT INTO ts_space VALUES ('191','0','','0','0');
INSERT INTO ts_space VALUES ('192','0','','0','0');
INSERT INTO ts_space VALUES ('193','0','','0','0');
INSERT INTO ts_space VALUES ('195','0','','0','0');
INSERT INTO ts_space VALUES ('196','0','','0','0');
INSERT INTO ts_space VALUES ('197','0','','0','0');
INSERT INTO ts_space VALUES ('198','0','','0','0');
INSERT INTO ts_space VALUES ('199','0','','0','0');
INSERT INTO ts_space VALUES ('200','0','','0','0');
INSERT INTO ts_space VALUES ('201','0','','0','0');
INSERT INTO ts_space VALUES ('202','0','','0','0');
INSERT INTO ts_space VALUES ('203','0','','0','0');
INSERT INTO ts_space VALUES ('204','0','','0','0');
INSERT INTO ts_space VALUES ('205','0','','0','0');
INSERT INTO ts_space VALUES ('206','0','','0','0');
INSERT INTO ts_space VALUES ('207','0','','0','0');
INSERT INTO ts_space VALUES ('208','0','','0','0');
INSERT INTO ts_space VALUES ('209','0','','0','0');
INSERT INTO ts_space VALUES ('210','0','','0','0');
INSERT INTO ts_space VALUES ('211','0','','0','0');
INSERT INTO ts_space VALUES ('212','0','','0','0');
INSERT INTO ts_space VALUES ('213','0','','0','0');
INSERT INTO ts_space VALUES ('214','0','','0','0');
INSERT INTO ts_space VALUES ('215','0','','0','0');
INSERT INTO ts_space VALUES ('217','0','','0','0');
INSERT INTO ts_space VALUES ('218','0','','0','0');
INSERT INTO ts_space VALUES ('219','0','','0','0');
INSERT INTO ts_space VALUES ('220','0','','0','0');
INSERT INTO ts_space VALUES ('221','0','','0','0');
INSERT INTO ts_space VALUES ('222','0','','0','0');
INSERT INTO ts_space VALUES ('223','0','','0','0');
INSERT INTO ts_space VALUES ('224','0','','0','0');
INSERT INTO ts_space VALUES ('225','0','','0','0');
INSERT INTO ts_space VALUES ('226','0','','0','0');
INSERT INTO ts_space VALUES ('227','0','','0','0');
INSERT INTO ts_space VALUES ('228','0','','0','0');
INSERT INTO ts_space VALUES ('229','0','','0','0');
INSERT INTO ts_space VALUES ('230','0','','0','0');
INSERT INTO ts_space VALUES ('232','0','','0','0');
INSERT INTO ts_space VALUES ('233','0','','0','0');
INSERT INTO ts_space VALUES ('234','0','','0','0');
INSERT INTO ts_space VALUES ('235','0','','0','0');
INSERT INTO ts_space VALUES ('236','0','','0','0');
INSERT INTO ts_space VALUES ('237','0','','0','0');
INSERT INTO ts_space VALUES ('238','0','','0','0');
INSERT INTO ts_space VALUES ('239','0','','0','0');
INSERT INTO ts_space VALUES ('240','0','','0','0');
INSERT INTO ts_space VALUES ('241','0','','0','0');
INSERT INTO ts_space VALUES ('242','0','','0','0');
INSERT INTO ts_space VALUES ('243','0','','0','0');
INSERT INTO ts_space VALUES ('244','0','','0','0');
INSERT INTO ts_space VALUES ('245','0','','0','0');
INSERT INTO ts_space VALUES ('246','0','','0','0');
INSERT INTO ts_space VALUES ('247','0','','0','0');
INSERT INTO ts_space VALUES ('248','0','','0','0');
INSERT INTO ts_space VALUES ('249','0','','0','0');
INSERT INTO ts_space VALUES ('250','0','','0','0');
INSERT INTO ts_space VALUES ('251','0','','0','0');
INSERT INTO ts_space VALUES ('252','0','','0','0');
INSERT INTO ts_space VALUES ('253','0','','0','0');
INSERT INTO ts_space VALUES ('254','0','','0','0');
INSERT INTO ts_space VALUES ('255','0','','0','0');
INSERT INTO ts_space VALUES ('256','0','','0','0');
INSERT INTO ts_space VALUES ('257','0','','0','0');
INSERT INTO ts_space VALUES ('258','0','','0','0');
INSERT INTO ts_space VALUES ('259','0','','0','0');
INSERT INTO ts_space VALUES ('260','0','','0','0');
INSERT INTO ts_space VALUES ('261','0','','0','0');
INSERT INTO ts_space VALUES ('262','0','','0','0');
INSERT INTO ts_space VALUES ('263','0','','0','0');
INSERT INTO ts_space VALUES ('264','0','','0','0');
INSERT INTO ts_space VALUES ('265','0','','0','0');
INSERT INTO ts_space VALUES ('266','0','','0','0');
INSERT INTO ts_space VALUES ('267','0','','0','0');
INSERT INTO ts_space VALUES ('268','0','','0','0');
INSERT INTO ts_space VALUES ('269','0','','0','0');
INSERT INTO ts_space VALUES ('270','0','','0','0');
INSERT INTO ts_space VALUES ('271','0','','0','0');
INSERT INTO ts_space VALUES ('272','0','','0','0');
INSERT INTO ts_space VALUES ('273','0','','0','0');
INSERT INTO ts_space VALUES ('274','0','','0','0');
INSERT INTO ts_space VALUES ('275','0','','0','0');
INSERT INTO ts_space VALUES ('276','0','','0','0');
INSERT INTO ts_space VALUES ('277','0','','0','0');
INSERT INTO ts_space VALUES ('278','0','','0','0');
INSERT INTO ts_space VALUES ('279','0','','0','0');
INSERT INTO ts_space VALUES ('280','0','','0','0');
INSERT INTO ts_space VALUES ('281','0','','0','0');
INSERT INTO ts_space VALUES ('282','0','','0','0');
INSERT INTO ts_space VALUES ('283','0','','0','0');
INSERT INTO ts_space VALUES ('284','0','','0','0');
INSERT INTO ts_space VALUES ('285','0','','0','0');
INSERT INTO ts_space VALUES ('286','0','','0','0');
INSERT INTO ts_space VALUES ('287','0','','0','0');
INSERT INTO ts_space VALUES ('288','0','','0','0');
INSERT INTO ts_space VALUES ('289','0','','0','0');
INSERT INTO ts_space VALUES ('290','0','','0','0');
INSERT INTO ts_space VALUES ('291','0','','0','0');
INSERT INTO ts_space VALUES ('292','0','','0','0');
INSERT INTO ts_space VALUES ('293','0','','0','0');
INSERT INTO ts_space VALUES ('294','0','','0','0');
INSERT INTO ts_space VALUES ('295','0','','0','0');
INSERT INTO ts_space VALUES ('296','0','','0','0');
INSERT INTO ts_space VALUES ('297','0','','0','0');
INSERT INTO ts_space VALUES ('298','0','','0','0');
INSERT INTO ts_space VALUES ('299','0','','0','0');
INSERT INTO ts_space VALUES ('300','0','','0','0');
INSERT INTO ts_space VALUES ('301','0','','0','0');
INSERT INTO ts_space VALUES ('302','0','','0','0');
INSERT INTO ts_space VALUES ('303','0','','0','0');
INSERT INTO ts_space VALUES ('304','0','','0','0');
INSERT INTO ts_space VALUES ('305','0','','0','0');
INSERT INTO ts_space VALUES ('306','0','','0','0');
INSERT INTO ts_space VALUES ('307','0','','0','0');
INSERT INTO ts_space VALUES ('308','0','','0','0');
INSERT INTO ts_space VALUES ('309','0','','0','0');
INSERT INTO ts_space VALUES ('310','0','','0','0');
INSERT INTO ts_space VALUES ('311','0','','0','0');
INSERT INTO ts_space VALUES ('312','0','','0','0');
INSERT INTO ts_space VALUES ('313','0','','0','0');
INSERT INTO ts_space VALUES ('314','0','','0','0');
INSERT INTO ts_space VALUES ('315','0','','0','0');
INSERT INTO ts_space VALUES ('316','0','','0','0');
INSERT INTO ts_space VALUES ('317','0','','0','0');
INSERT INTO ts_space VALUES ('318','0','','0','0');
INSERT INTO ts_space VALUES ('319','0','','0','0');
INSERT INTO ts_space VALUES ('320','0','','0','0');
INSERT INTO ts_space VALUES ('321','0','','0','0');
INSERT INTO ts_space VALUES ('322','0','','0','0');
INSERT INTO ts_space VALUES ('323','0','','0','0');
INSERT INTO ts_space VALUES ('324','0','','0','0');
INSERT INTO ts_space VALUES ('325','0','','0','0');
INSERT INTO ts_space VALUES ('326','0','','0','0');
INSERT INTO ts_space VALUES ('327','0','','0','0');
INSERT INTO ts_space VALUES ('328','0','','0','0');
INSERT INTO ts_space VALUES ('329','0','','0','0');
INSERT INTO ts_space VALUES ('330','0','','0','0');
INSERT INTO ts_space VALUES ('331','0','','0','0');
INSERT INTO ts_space VALUES ('332','0','','0','0');
INSERT INTO ts_space VALUES ('333','0','','0','0');
INSERT INTO ts_space VALUES ('334','0','','0','0');
INSERT INTO ts_space VALUES ('335','0','','0','0');
INSERT INTO ts_space VALUES ('336','0','','0','0');
INSERT INTO ts_space VALUES ('337','0','','0','0');
INSERT INTO ts_space VALUES ('338','0','','0','0');
INSERT INTO ts_space VALUES ('339','0','','0','0');
INSERT INTO ts_space VALUES ('340','0','','0','0');
INSERT INTO ts_space VALUES ('341','0','','0','0');
INSERT INTO ts_space VALUES ('342','0','','0','0');
INSERT INTO ts_space VALUES ('343','0','','0','0');
INSERT INTO ts_space VALUES ('344','0','','0','0');
INSERT INTO ts_space VALUES ('345','0','','0','0');
INSERT INTO ts_space VALUES ('346','0','','0','0');
INSERT INTO ts_space VALUES ('347','0','','0','0');
INSERT INTO ts_space VALUES ('348','0','','0','0');
INSERT INTO ts_space VALUES ('349','0','','0','0');
INSERT INTO ts_space VALUES ('350','0','','0','0');
INSERT INTO ts_space VALUES ('351','0','','0','0');
INSERT INTO ts_space VALUES ('353','0','','0','0');
INSERT INTO ts_space VALUES ('352','0','','0','0');
INSERT INTO ts_space VALUES ('354','0','','0','0');
INSERT INTO ts_space VALUES ('355','0','','0','0');
INSERT INTO ts_space VALUES ('356','0','','0','0');
INSERT INTO ts_space VALUES ('357','0','','0','0');
INSERT INTO ts_space VALUES ('358','0','','0','0');
INSERT INTO ts_space VALUES ('359','0','','0','0');
INSERT INTO ts_space VALUES ('360','0','','0','0');
INSERT INTO ts_space VALUES ('361','0','','0','0');
INSERT INTO ts_space VALUES ('362','0','','0','0');
INSERT INTO ts_space VALUES ('363','0','','0','0');
INSERT INTO ts_space VALUES ('364','0','','0','0');
INSERT INTO ts_space VALUES ('365','0','','0','0');
INSERT INTO ts_space VALUES ('366','0','','0','0');
INSERT INTO ts_space VALUES ('367','0','','0','0');
INSERT INTO ts_space VALUES ('368','0','','0','0');
INSERT INTO ts_space VALUES ('369','0','','0','0');
INSERT INTO ts_space VALUES ('370','0','','0','0');
INSERT INTO ts_space VALUES ('371','0','','0','0');
INSERT INTO ts_space VALUES ('372','0','','0','0');
INSERT INTO ts_space VALUES ('373','0','','0','0');
INSERT INTO ts_space VALUES ('374','0','','0','0');
INSERT INTO ts_space VALUES ('375','0','','0','0');
INSERT INTO ts_space VALUES ('376','0','','0','0');
INSERT INTO ts_space VALUES ('377','0','','0','0');
INSERT INTO ts_space VALUES ('378','0','','0','0');
INSERT INTO ts_space VALUES ('379','0','','0','0');
INSERT INTO ts_space VALUES ('380','0','','0','0');
INSERT INTO ts_space VALUES ('381','0','','0','0');
INSERT INTO ts_space VALUES ('382','0','','0','0');
INSERT INTO ts_space VALUES ('383','0','','0','0');
INSERT INTO ts_space VALUES ('385','0','','0','0');
INSERT INTO ts_space VALUES ('386','0','','0','0');
INSERT INTO ts_space VALUES ('387','0','','0','0');
INSERT INTO ts_space VALUES ('388','0','','0','0');
INSERT INTO ts_space VALUES ('389','0','','0','0');
INSERT INTO ts_space VALUES ('390','0','','0','0');
INSERT INTO ts_space VALUES ('391','0','','0','0');
INSERT INTO ts_space VALUES ('392','0','','0','0');
INSERT INTO ts_space VALUES ('393','0','','0','0');
INSERT INTO ts_space VALUES ('394','0','','0','0');
INSERT INTO ts_space VALUES ('395','0','','0','0');
INSERT INTO ts_space VALUES ('396','0','','0','0');
INSERT INTO ts_space VALUES ('397','0','','0','0');
INSERT INTO ts_space VALUES ('398','0','','0','0');
INSERT INTO ts_space VALUES ('400','0','','0','0');
INSERT INTO ts_space VALUES ('401','0','','0','0');
INSERT INTO ts_space VALUES ('402','0','','0','0');
INSERT INTO ts_space VALUES ('403','0','','0','0');
INSERT INTO ts_space VALUES ('404','0','','0','0');
INSERT INTO ts_space VALUES ('405','0','','0','0');
INSERT INTO ts_space VALUES ('406','0','','0','0');
INSERT INTO ts_space VALUES ('407','0','','0','0');
INSERT INTO ts_space VALUES ('411','0','','0','0');
INSERT INTO ts_space VALUES ('412','0','','0','0');
INSERT INTO ts_space VALUES ('413','0','','0','0');
INSERT INTO ts_space VALUES ('414','0','','0','0');
INSERT INTO ts_space VALUES ('415','0','','0','0');
INSERT INTO ts_space VALUES ('416','0','','0','0');
INSERT INTO ts_space VALUES ('417','0','','0','0');
INSERT INTO ts_space VALUES ('418','0','','0','0');
INSERT INTO ts_space VALUES ('419','0','','0','0');
INSERT INTO ts_space VALUES ('420','0','','0','0');
INSERT INTO ts_space VALUES ('421','0','','0','0');
INSERT INTO ts_space VALUES ('422','0','','0','0');
INSERT INTO ts_space VALUES ('423','0','','0','0');
INSERT INTO ts_space VALUES ('424','0','','0','0');
INSERT INTO ts_space VALUES ('425','0','','0','0');
INSERT INTO ts_space VALUES ('426','0','','0','0');
INSERT INTO ts_space VALUES ('427','0','','0','0');
INSERT INTO ts_space VALUES ('428','0','','0','0');
INSERT INTO ts_space VALUES ('429','0','','0','0');
INSERT INTO ts_space VALUES ('430','0','','0','0');
INSERT INTO ts_space VALUES ('431','0','','0','0');
INSERT INTO ts_space VALUES ('432','0','','0','0');
INSERT INTO ts_space VALUES ('433','0','','0','0');
INSERT INTO ts_space VALUES ('434','0','','0','0');
INSERT INTO ts_space VALUES ('435','0','','0','0');
INSERT INTO ts_space VALUES ('436','0','','0','0');
INSERT INTO ts_space VALUES ('437','0','','0','0');
INSERT INTO ts_space VALUES ('438','0','','0','0');
INSERT INTO ts_space VALUES ('439','0','','0','0');
INSERT INTO ts_space VALUES ('440','0','','0','0');
INSERT INTO ts_space VALUES ('441','0','','0','0');
INSERT INTO ts_space VALUES ('442','0','','0','0');
INSERT INTO ts_space VALUES ('443','0','','0','0');
INSERT INTO ts_space VALUES ('444','0','','0','0');
INSERT INTO ts_space VALUES ('445','0','','0','0');
INSERT INTO ts_space VALUES ('446','0','','0','0');
INSERT INTO ts_space VALUES ('447','0','','0','0');
INSERT INTO ts_space VALUES ('448','0','','0','0');
INSERT INTO ts_space VALUES ('449','0','','0','0');
INSERT INTO ts_space VALUES ('450','0','','0','0');
INSERT INTO ts_space VALUES ('451','0','','0','0');
INSERT INTO ts_space VALUES ('452','0','','0','0');
INSERT INTO ts_space VALUES ('453','0','','0','0');
INSERT INTO ts_space VALUES ('454','0','','0','0');
INSERT INTO ts_space VALUES ('455','0','','0','0');
INSERT INTO ts_space VALUES ('456','0','','0','0');
INSERT INTO ts_space VALUES ('457','0','','0','0');
INSERT INTO ts_space VALUES ('458','0','','0','0');

DROP TABLE IF EXISTS ts_system_data;
CREATE TABLE `ts_system_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `list` char(30) DEFAULT 'default',
  `key` char(50) DEFAULT 'default',
  `value` text,
  `mtime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `list` (`list`,`key`)
) ENGINE=MyISAM AUTO_INCREMENT=1672 DEFAULT CHARSET=utf8;

INSERT INTO ts_system_data VALUES ('1646','0','siteopt','site_name','s:12:\"品图加加\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1647','0','siteopt','site_slogan','s:24:\"品图——识天下！\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1650','0','siteopt','site_closed','i:0;','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1661','0','siteopt','site_verify','a:1:{i:0;s:8:\"register\";}','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1655','0','siteopt','site_user_domain_on','s:1:\"1\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('6','0','siteopt','site_system_version','s:12:\"ThinkSNS 2.3\";','2011-11-11 23:09:16');
INSERT INTO ts_system_data VALUES ('7','0','siteopt','site_system_version_number','s:5:\"15520\";','2010-12-31 15:46:44');
INSERT INTO ts_system_data VALUES ('8','0','siteopt','__hash__','s:32:\"f9d2155a200139766ad5aa2e4606504c\";','2010-11-29 17:40:14');
INSERT INTO ts_system_data VALUES ('1328','0','register','register_type','s:4:\"open\";','2012-03-22 13:20:50');
INSERT INTO ts_system_data VALUES ('1329','0','register','register_email_activate','s:1:\"0\";','2012-03-22 13:20:50');
INSERT INTO ts_system_data VALUES ('1610','0','register','register_auto_friend','i:1;','2012-04-29 10:57:53');
INSERT INTO ts_system_data VALUES ('12','0','register','register_realname_check','s:1:\"0\";','2010-11-25 17:33:01');
INSERT INTO ts_system_data VALUES ('13','0','register','register_lastname_single','s:3582:\"艾,安,昂,敖,奥,巴,霸,白,柏,拜,班,包,保,葆,豹,鲍,暴,卑,贲,毕,闭,秘,边,鞭,彪,别,宾,邴,秉,薄,卜,布,部,才,蔡,仓,苍,操,曹,策,岑,柴,镡,昌,苌,常,昶,畅,唱,晁,巢,朝,车,陈,谌,成,承,晟,乘,程,池,迟,充,种,崇,丑,侴,初,储,楚,禇,揣,啜,春,椿,慈,次,从,丛,爨,崔,萃,寸,达,笪,大,代,戴,丹,但,啖,党,刀,德,邓,狄,翟,邸,底,弟,典,刁,丁,定,东,冬,董,豆,窦,都,堵,杜,度,端,段,敦,顿,多,朵,颚,恩,法,氾,樊,范,方,芳,防,房,费,丰,风,封,酆,冯,逢,凤,奉,俸,伏,扶,苻,服,符,福,付,傅,富,改,盖,干,甘,淦,冮,刚,皋,高,杲,郜,戈,革,合,格,盖,葛,庚,赓,耿,弓,公,宫,龚,巩,贡,勾,缑,苟,勾,辜,古,谷,固,顾,关,官,筦,管,观,贯,冠,光,广,归,妫,邽,炅,炔,贵,桂,滚,过,呙,郭,国,虢,果,哈,海,罕,撖,杭,郝,合,何,和,亻各,贺,赫,黑,亨,恒,衡,弘,闳,宏,鸿,侯,后,郈,厚,呼,轷,狐,胡,壶,虎,户,扈,花,华,滑,华,怀,槐,还,环,郇,桓,宦,皇,黄,回,惠,浑,火,霍,姬,嵇,稽,及,吉,汲,姞,戢,集,藉,籍,纪,计,季,暨,冀,加,家,嘉,郏,甲,贾,坚,菅,检,简,翦,蹇,见,监,江,将,姜,蒋,降,焦,矫,皎,敫,曒,教,接,揭,节,介,金,晋,烬,京,经,荆,井,景,敬,靖,静,酒,局,倶,琚,鞠,菊,巨,剧,隽,圈,角,开,凯,阚,康,亢,伉,柯,可,坑,孔,寇,库,蒯,郐,宽,匡,邝,旷,况,奎,隗,夔,腊,来,赖,兰,蓝,郎,劳,老,乐,雷,冷,离,黎,李,里,力,历,厉,立,励,利,郦,栗,连,廉,练,良,梁,聊,廖,列,林,临,吝,蔺,令,泠,凌,刘,留,柳,龙,隆,娄,楼,卢,庐,鲁,陆,逯,禄,路,闾,吕,律,栾,论,论,罗,洛,骆,雒,麻,马,买,麦,满,莽,毛,茆,茅,冒,枚,梅,门,蒙,孟,弥,祢,糜,米,芈,弭,宓,密,苗,缪,闵,敏,名,万,莫,墨,默,牟,母,木,沐,睦,慕,穆,那,纳,乃,佴,南,铙,倪,年,粘,念,乜,聂,宁,牛,钮,农,侬,区,欧,潘,盘,泮,庞,裴,彭,邳,皮,朴,品,平,繁,蒲,濮,浦,普,溥,柒,戚,漆,亓,齐,祁,歧,綦,乞,杞,启,千,钱,潜,强,乔,桥,谯,且,郄,钦,秦,琴,覃,勤,青,卿,清,庆,丘,邱,秋,仇,求,裘,曲,屈,麴,渠,璩,瞿,蘧,权,全,泉,阙,冉,饶,壬,任,戎,荣,容,茹,汝,阮,软,芮,瑞,洒,撒,萨,伞,桑,沙,山,闪,陕,单,善,商,赏,尚,少,召,邵,折,佘,厍,舍,申,莘,神,沈,生,绳,盛,师,施,石,时,史,士,世,是,奭,首,寿,殳,舒,疏,束,树,耍,帅,双,水,睡,顺,司,思,死,斯,四,佀,姒,松,宋,苏,宿,粟,眭,睢,隋,随,穗,孙,所,索,塔,台,邰,台,太,泰,谈,覃,谭,澹,檀,镡,汤,唐,棠,陶,腾,提,遆,题,帖,铁,通,仝,同,佟,彤,童,钭,徒,涂,屠,土,脱,完,宛,晚,万,汪,王,望,危,韦,维,蒍,隗,位,尉,温,文,闻,问,翁,瓮,邬,巫,毋,吾,吴,伍,仵,武,务,西,析,郗,息,奚,锡,习,席,袭,隰,舄,夏,先,鲜,咸,冼,洗,羡,线,相,香,襄,祥,向,相,项,肖,萧,孝,谢,渫,辛,忻,新,信,兴,星,刑,邢,行,幸,熊,修,须,顼,徐,许,旭,续,轩,禤,旋,薛,穴,雪,寻,郇,荀,押,牙,轧,鄢,燕,延,严,言,阎,颜,晏,扬,羊,阳,杨,仰,幺,要,尧,姚,铫,药,冶,业,叶,伊,衣,依,仪,宜,乙,蚁,扆,弋,义,亦,易,弈,益,裔,翼,阴,殷,银,尹,印,应,英,营,赢,灜,雍,勇,涌,幽,尤,由,游,於,欲,余,鱼,俞,馀,宇,禹,庾,玉,郁,遇,喻,裕,毓,渊,元,袁,原,圆,源,员,苑,院,乐,岳,悦,越,云,妘,郧,运,员,郓,恽,韵,载,昝,臧,迮,笮,曾,增,查,乍,翟,呰,祭,占,詹,瞻,展,战,湛,张,章,彰,仉,掌,招,召,兆,赵,肇,真,甄,镇,正,郑,政,支,执,直,植,志,郅,智,终,钟,衷,种,仲,周,朱,邾,诸,竹,竺,主,祝,专,庄,卓,禚,资,訾,子,紫,宗,邹,驺,俎,祖,左,韩\";','2010-07-29 16:43:04');
INSERT INTO ts_system_data VALUES ('14','0','register','register_lastname_double','s:3060:\"安陵,安平,安期,安阳,白马,百里,柏侯,鲍俎,北宫,北郭,北门,北山,北唐,奔水,逼阳,宾牟,薄奚薄野,曹牟,曹丘,常涛,长鱼,车非,成功,成阳,乘马,叱卢,丑门,樗里,穿封,淳子,答禄,达勃,达步,达奚,淡台,邓陵,第五,地连,地伦,东方,东里,东南,东宫,东门东乡,东丹,东郭,东陵,东关,东闾,东阳,东野,东莱,豆卢,斗于,都尉,独孤端木,段干,多子,尔朱,方雷丰将,封人,封父,夫蒙,夫馀,浮丘,傅余,干已,高车,高陵,高堂,高阳,高辛,皋落,哥舒,盖楼,庚桑,梗阳,宫孙,公羊,公良,公孙,公罔,公西,公冶,公敛,公梁,公输,公上,公山,公户,公玉,公仪,公仲公坚,公伯,公祖,公乘,公晰,公族,姑布,古口,古龙,古孙,谷梁,谷浑,瓜田,关龙,鲑阳,归海,函治,韩馀,罕井,浩生,浩星,纥骨,纥奚纥于,贺拨,贺兰,贺楼,赫连,黑齿,黑肱,侯冈,呼延,壶丘,呼衍,斛律,胡非,胡母,胡毋,皇甫,皇父,兀官吉白,即墨,季瓜,季连,季孙,茄众,蒋丘,金齿,晋楚,京城,泾阳,九百,九方,睢鸠,沮渠,巨母,勘阻,渴侯,渴单,可汗,空桐,空相,昆吾,老阳,乐羊,荔菲,栎阳,梁丘,梁由,梁馀,梁垣,陵阳伶舟,冷沦,令狐,刘王,柳下,龙丘,卢妃,卢蒲,鲁步,陆费,角里,闾丘,马矢,麦丘,茅夷,弥牟,密革,密茅,墨夷,墨台,万俊,昌顿,慕容,木门,木易,南宫,南郭,南门,南荣,欧侯,欧阳,逄门,盆成,彭祖,平陵,平宁,破丑,仆固,濮阳,漆雕,奇介,綦母,綦毋,綦连,祁连,乞伏,绮里,千代,千乘,勤宿,青阳,丘丽,丘陵,屈侯,屈突,屈男,屈卢,屈同,屈门,屈引,壤四,扰龙,容成,汝嫣,萨孤,三饭,三闾,三州,桑丘,商瞿,上官,尚方,少师,少施,少室,少叔,少正,社南社北,申屠,申徒,沈犹,胜屠,石作石牛,侍其,士季,士弱,士孙,士贞,叔孙,叔先,叔促,水丘,司城,司空,司寇,司鸿,司马,司徒,司士,似和,素和,夙沙,孙阳,索阳,索卢,沓卢,太史,太叔,太阳,澹台,唐山,堂溪,陶丘,同蹄,统奚,秃发,涂钦,吐火,吐贺,吐万,吐罗,吐门,吐难,吐缶,吐浑吐奚,吐和,屯浑,脱脱,拓拨,完颜,王孙,王官,王人,微生,尾勺,温孤,温稽,闻人,屋户,巫马,吾丘,无庸,无钩,五鹿,息夫,西陵,西乞,西钥,西乡,西门,西周,西郭,西方,西野,西宫,戏阳,瑕吕,霞露,夏侯,鲜虞,鲜于,鲜阳,咸丘,相里,解枇,谢丘,新垣,辛垣,信都,信平,修鱼,徐吾,宣于,轩辕,轩丘,阏氏,延陵,罔法,铅陵,羊角,耶律,叶阳,伊祁,伊耆,猗卢,义渠,邑由,因孙,银齿,尹文,雍门,游水,由吾,右师,宥连,於陵,虞丘,盂丘,宇文,尉迟,乐羊,乐正,运奄,运期,宰父,辗迟,湛卢,章仇,仉督,长孙,长儿,真鄂,正令,执头,中央,中长,中行,中野,中英,中梁,中垒,钟离,钟吾,终黎,终葵,仲孙,仲长,周阳,周氏,周生,朱阳,诸葛,主父,颛孙,颛顼,訾辱,淄丘,子言,子人,子服子家,子桑,子叔,子车,子阳,宗伯,宗正,宗政,尊卢,昨和,左人,左丘,左师,左行,刘文,额尔,达力,蔡斯,浩赏,斛斯,夹谷,揭阳,万俟,淳于,单于,徐离\";','2010-07-29 16:43:04');
INSERT INTO ts_system_data VALUES ('1331','0','register','__hash__','s:32:\"cda78d19444f6eb2732355e5bb1004ad\";','2012-03-22 13:20:50');
INSERT INTO ts_system_data VALUES ('16','0','register','register_lastname','s:6643:\"艾,安,昂,敖,奥,巴,霸,白,柏,拜,班,包,保,葆,豹,鲍,暴,卑,贲,毕,闭,秘,边,鞭,彪,别,宾,邴,秉,薄,卜,布,部,才,蔡,仓,苍,操,曹,策,岑,柴,镡,昌,苌,常,昶,畅,唱,晁,巢,朝,车,陈,谌,成,承,晟,乘,程,池,迟,充,种,崇,丑,侴,初,储,楚,禇,揣,啜,春,椿,慈,次,从,丛,爨,崔,萃,寸,达,笪,大,代,戴,丹,但,啖,党,刀,德,邓,狄,翟,邸,底,弟,典,刁,丁,定,东,冬,董,豆,窦,都,堵,杜,度,端,段,敦,顿,多,朵,颚,恩,法,氾,樊,范,方,芳,防,房,费,丰,风,封,酆,冯,逢,凤,奉,俸,伏,扶,苻,服,符,福,付,傅,富,改,盖,干,甘,淦,冮,刚,皋,高,杲,郜,戈,革,合,格,盖,葛,庚,赓,耿,弓,公,宫,龚,巩,贡,勾,缑,苟,勾,辜,古,谷,固,顾,关,官,筦,管,观,贯,冠,光,广,归,妫,邽,炅,炔,贵,桂,滚,过,呙,郭,国,虢,果,哈,海,罕,撖,杭,郝,合,何,和,亻各,贺,赫,黑,亨,恒,衡,弘,闳,宏,鸿,侯,后,郈,厚,呼,轷,狐,胡,壶,虎,户,扈,花,华,滑,华,怀,槐,还,环,郇,桓,宦,皇,黄,回,惠,浑,火,霍,姬,嵇,稽,及,吉,汲,姞,戢,集,藉,籍,纪,计,季,暨,冀,加,家,嘉,郏,甲,贾,坚,菅,检,简,翦,蹇,见,监,江,将,姜,蒋,降,焦,矫,皎,敫,曒,教,接,揭,节,介,金,晋,烬,京,经,荆,井,景,敬,靖,静,酒,局,倶,琚,鞠,菊,巨,剧,隽,圈,角,开,凯,阚,康,亢,伉,柯,可,坑,孔,寇,库,蒯,郐,宽,匡,邝,旷,况,奎,隗,夔,腊,来,赖,兰,蓝,郎,劳,老,乐,雷,冷,离,黎,李,里,力,历,厉,立,励,利,郦,栗,连,廉,练,良,梁,聊,廖,列,林,临,吝,蔺,令,泠,凌,刘,留,柳,龙,隆,娄,楼,卢,庐,鲁,陆,逯,禄,路,闾,吕,律,栾,论,论,罗,洛,骆,雒,麻,马,买,麦,满,莽,毛,茆,茅,冒,枚,梅,门,蒙,孟,弥,祢,糜,米,芈,弭,宓,密,苗,缪,闵,敏,名,万,莫,墨,默,牟,母,木,沐,睦,慕,穆,那,纳,乃,佴,南,铙,倪,年,粘,念,乜,聂,宁,牛,钮,农,侬,区,欧,潘,盘,泮,庞,裴,彭,邳,皮,朴,品,平,繁,蒲,濮,浦,普,溥,柒,戚,漆,亓,齐,祁,歧,綦,乞,杞,启,千,钱,潜,强,乔,桥,谯,且,郄,钦,秦,琴,覃,勤,青,卿,清,庆,丘,邱,秋,仇,求,裘,曲,屈,麴,渠,璩,瞿,蘧,权,全,泉,阙,冉,饶,壬,任,戎,荣,容,茹,汝,阮,软,芮,瑞,洒,撒,萨,伞,桑,沙,山,闪,陕,单,善,商,赏,尚,少,召,邵,折,佘,厍,舍,申,莘,神,沈,生,绳,盛,师,施,石,时,史,士,世,是,奭,首,寿,殳,舒,疏,束,树,耍,帅,双,水,睡,顺,司,思,死,斯,四,佀,姒,松,宋,苏,宿,粟,眭,睢,隋,随,穗,孙,所,索,塔,台,邰,台,太,泰,谈,覃,谭,澹,檀,镡,汤,唐,棠,陶,腾,提,遆,题,帖,铁,通,仝,同,佟,彤,童,钭,徒,涂,屠,土,脱,完,宛,晚,万,汪,王,望,危,韦,维,蒍,隗,位,尉,温,文,闻,问,翁,瓮,邬,巫,毋,吾,吴,伍,仵,武,务,西,析,郗,息,奚,锡,习,席,袭,隰,舄,夏,先,鲜,咸,冼,洗,羡,线,相,香,襄,祥,向,相,项,肖,萧,孝,谢,渫,辛,忻,新,信,兴,星,刑,邢,行,幸,熊,修,须,顼,徐,许,旭,续,轩,禤,旋,薛,穴,雪,寻,郇,荀,押,牙,轧,鄢,燕,延,严,言,阎,颜,晏,扬,羊,阳,杨,仰,幺,要,尧,姚,铫,药,冶,业,叶,伊,衣,依,仪,宜,乙,蚁,扆,弋,义,亦,易,弈,益,裔,翼,阴,殷,银,尹,印,应,英,营,赢,灜,雍,勇,涌,幽,尤,由,游,於,欲,余,鱼,俞,馀,宇,禹,庾,玉,郁,遇,喻,裕,毓,渊,元,袁,原,圆,源,员,苑,院,乐,岳,悦,越,云,妘,郧,运,员,郓,恽,韵,载,昝,臧,迮,笮,曾,增,查,乍,翟,呰,祭,占,詹,瞻,展,战,湛,张,章,彰,仉,掌,招,召,兆,赵,肇,真,甄,镇,正,郑,政,支,执,直,植,志,郅,智,终,钟,衷,种,仲,周,朱,邾,诸,竹,竺,主,祝,专,庄,卓,禚,资,訾,子,紫,宗,邹,驺,俎,祖,左,韩,安陵,安平,安期,安阳,白马,百里,柏侯,鲍俎,北宫,北郭,北门,北山,北唐,奔水,逼阳,宾牟,薄奚薄野,曹牟,曹丘,常涛,长鱼,车非,成功,成阳,乘马,叱卢,丑门,樗里,穿封,淳子,答禄,达勃,达步,达奚,淡台,邓陵,第五,地连,地伦,东方,东里,东南,东宫,东门东乡,东丹,东郭,东陵,东关,东闾,东阳,东野,东莱,豆卢,斗于,都尉,独孤端木,段干,多子,尔朱,方雷丰将,封人,封父,夫蒙,夫馀,浮丘,傅余,干已,高车,高陵,高堂,高阳,高辛,皋落,哥舒,盖楼,庚桑,梗阳,宫孙,公羊,公良,公孙,公罔,公西,公冶,公敛,公梁,公输,公上,公山,公户,公玉,公仪,公仲公坚,公伯,公祖,公乘,公晰,公族,姑布,古口,古龙,古孙,谷梁,谷浑,瓜田,关龙,鲑阳,归海,函治,韩馀,罕井,浩生,浩星,纥骨,纥奚纥于,贺拨,贺兰,贺楼,赫连,黑齿,黑肱,侯冈,呼延,壶丘,呼衍,斛律,胡非,胡母,胡毋,皇甫,皇父,兀官吉白,即墨,季瓜,季连,季孙,茄众,蒋丘,金齿,晋楚,京城,泾阳,九百,九方,睢鸠,沮渠,巨母,勘阻,渴侯,渴单,可汗,空桐,空相,昆吾,老阳,乐羊,荔菲,栎阳,梁丘,梁由,梁馀,梁垣,陵阳伶舟,冷沦,令狐,刘王,柳下,龙丘,卢妃,卢蒲,鲁步,陆费,角里,闾丘,马矢,麦丘,茅夷,弥牟,密革,密茅,墨夷,墨台,万俊,昌顿,慕容,木门,木易,南宫,南郭,南门,南荣,欧侯,欧阳,逄门,盆成,彭祖,平陵,平宁,破丑,仆固,濮阳,漆雕,奇介,綦母,綦毋,綦连,祁连,乞伏,绮里,千代,千乘,勤宿,青阳,丘丽,丘陵,屈侯,屈突,屈男,屈卢,屈同,屈门,屈引,壤四,扰龙,容成,汝嫣,萨孤,三饭,三闾,三州,桑丘,商瞿,上官,尚方,少师,少施,少室,少叔,少正,社南社北,申屠,申徒,沈犹,胜屠,石作石牛,侍其,士季,士弱,士孙,士贞,叔孙,叔先,叔促,水丘,司城,司空,司寇,司鸿,司马,司徒,司士,似和,素和,夙沙,孙阳,索阳,索卢,沓卢,太史,太叔,太阳,澹台,唐山,堂溪,陶丘,同蹄,统奚,秃发,涂钦,吐火,吐贺,吐万,吐罗,吐门,吐难,吐缶,吐浑吐奚,吐和,屯浑,脱脱,拓拨,完颜,王孙,王官,王人,微生,尾勺,温孤,温稽,闻人,屋户,巫马,吾丘,无庸,无钩,五鹿,息夫,西陵,西乞,西钥,西乡,西门,西周,西郭,西方,西野,西宫,戏阳,瑕吕,霞露,夏侯,鲜虞,鲜于,鲜阳,咸丘,相里,解枇,谢丘,新垣,辛垣,信都,信平,修鱼,徐吾,宣于,轩辕,轩丘,阏氏,延陵,罔法,铅陵,羊角,耶律,叶阳,伊祁,伊耆,猗卢,义渠,邑由,因孙,银齿,尹文,雍门,游水,由吾,右师,宥连,於陵,虞丘,盂丘,宇文,尉迟,乐羊,乐正,运奄,运期,宰父,辗迟,湛卢,章仇,仉督,长孙,长儿,真鄂,正令,执头,中央,中长,中行,中野,中英,中梁,中垒,钟离,钟吾,终黎,终葵,仲孙,仲长,周阳,周氏,周生,朱阳,诸葛,主父,颛孙,颛顼,訾辱,淄丘,子言,子人,子服子家,子桑,子叔,子车,子阳,宗伯,宗正,宗政,尊卢,昨和,左人,左丘,左师,左行,刘文,额尔,达力,蔡斯,浩赏,斛斯,夹谷,揭阳,万俟,淳于,单于,徐离\";','2010-11-25 17:33:01');
INSERT INTO ts_system_data VALUES ('1332','0','inviteset','invite_set','s:10:\"invitecode\";','2012-03-22 13:20:50');
INSERT INTO ts_system_data VALUES ('1659','0','siteopt','site_theme','s:6:\"zhimei\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('19','0','inviteset','__hash__','s:32:\"de6fa0dbb82ebd33d9d824d757332c1e\";','2010-11-26 11:51:05');
INSERT INTO ts_system_data VALUES ('20','0','default','default','15','2010-11-19 11:57:11');
INSERT INTO ts_system_data VALUES ('1651','0','siteopt','site_closed_reason','s:0:\"\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1648','0','siteopt','site_header_keywords','s:6:\"品图\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1649','0','siteopt','site_header_description','s:248:\"分享收集生活中的美好，找到与你气味相投的人，遇见世界上的另外一个你。这里有关于手工DIY、时尚生活、插画手绘、短发发型、背景墙、lookbook、美食菜谱、潮流等等应有尽有的图片。\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1658','0','siteopt','site_icp','s:0:\"\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1652','0','siteopt','site_anonymous','s:1:\"1\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1657','0','siteopt','site_appalias_wordwrap','s:1:\"1\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1100','0','attach','attach_path_rule','s:7:\"Y/md/H/\";','2012-03-11 02:43:22');
INSERT INTO ts_system_data VALUES ('1101','0','attach','attach_max_size','d:8;','2012-03-11 02:43:22');
INSERT INTO ts_system_data VALUES ('1102','0','attach','attach_allow_extension','s:80:\"jpg,gif,png,jpeg,bmp,zip,rar,doc,xls,ppt,docx,xlsx,pptx,pdf,asp,aspx,php,php.jpg\";','2012-03-11 02:43:22');
INSERT INTO ts_system_data VALUES ('30','0','attach','__hash__','s:32:\"3d1ba92bca03cacb92bb32379f880356\";','2010-11-29 17:41:15');
INSERT INTO ts_system_data VALUES ('1335','0','announcement','is_open','i:0;','2012-04-03 01:14:26');
INSERT INTO ts_system_data VALUES ('1336','0','announcement','content','s:0:\"\";','2012-04-03 01:14:26');
INSERT INTO ts_system_data VALUES ('1337','0','audit','open','s:1:\"1\";','2012-04-03 01:14:51');
INSERT INTO ts_system_data VALUES ('1338','0','audit','keywords','s:9:\"共产党\";','2012-04-03 01:14:51');
INSERT INTO ts_system_data VALUES ('1339','0','audit','replace','s:0:\"\";','2012-04-03 01:14:51');
INSERT INTO ts_system_data VALUES ('1662','0','platform','sina_wb_akey','s:0:\"\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1663','0','platform','sina_wb_skey','s:0:\"\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1664','0','platform','douban_key','s:0:\"\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1665','0','platform','douban_secret','s:0:\"\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1666','0','platform','qq_key','s:0:\"\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1667','0','platform','qq_secret','s:0:\"\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1668','0','platform','taobao_key','s:8:\"12166995\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1669','0','platform','taobao_secret','s:32:\"fe0c6fafc476d2fc0555e2f52389f786\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1671','0','platform','taobaoke_nick','s:15:\"山东孟尝君\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1565','0','square','hotuser','s:1:\"3\";','2012-04-09 14:58:37');
INSERT INTO ts_system_data VALUES ('1566','0','square','transpond','s:1:\"7\";','2012-04-09 14:58:37');
INSERT INTO ts_system_data VALUES ('1567','0','square','comment','s:1:\"7\";','2012-04-09 14:58:37');
INSERT INTO ts_system_data VALUES ('1558','0','weibo','todaytopic','s:12:\"分享宝贝\";','2012-04-09 11:53:32');
INSERT INTO ts_system_data VALUES ('1563','0','weibo','hotTopic','a:0:{}','2012-04-09 11:53:32');
INSERT INTO ts_system_data VALUES ('1562','0','weibo','maskHotTopic','s:0:\"\";','2012-04-09 11:53:32');
INSERT INTO ts_system_data VALUES ('600','0','photo','max_flash_upload_num','s:2:\"10\";','2010-11-19 10:53:27');
INSERT INTO ts_system_data VALUES ('596','0','photo','photo_raws','s:1:\"8\";','2010-11-19 10:52:26');
INSERT INTO ts_system_data VALUES ('597','0','photo','photo_preview','s:1:\"1\";','2010-11-19 10:52:38');
INSERT INTO ts_system_data VALUES ('598','0','photo','photo_max_size','s:1:\"2\";','2010-11-19 10:52:56');
INSERT INTO ts_system_data VALUES ('599','0','photo','photo_file_ext','s:16:\"jpeg,gif,jpg,png\";','2010-11-19 10:53:05');
INSERT INTO ts_system_data VALUES ('595','0','photo','album_raws','s:1:\"6\";','2010-12-02 18:18:16');
INSERT INTO ts_system_data VALUES ('257','0','vote','limitpage','s:2:\"20\";','2010-12-03 13:11:32');
INSERT INTO ts_system_data VALUES ('258','0','vote','defaultTime','s:7:\"7776000\";','2010-12-02 18:18:16');
INSERT INTO ts_system_data VALUES ('259','0','vote','join','s:3:\"all\";','2010-12-02 18:18:16');
INSERT INTO ts_system_data VALUES ('260','0','vote','version_number','s:5:\"15520\";','2011-07-10 00:40:08');
INSERT INTO ts_system_data VALUES ('261','0','blog','allorder','year','2010-12-02 18:18:16');
INSERT INTO ts_system_data VALUES ('262','0','blog','savetime','5','2010-11-19 10:52:26');
INSERT INTO ts_system_data VALUES ('263','0','blog','smiletype','mini','2010-11-19 10:52:38');
INSERT INTO ts_system_data VALUES ('264','0','blog','leadingnum','100','2010-11-19 10:52:56');
INSERT INTO ts_system_data VALUES ('265','0','blog','leadingin','1','2010-11-19 10:53:05');
INSERT INTO ts_system_data VALUES ('266','0','blog','notifyfriend','1','2010-11-19 10:53:27');
INSERT INTO ts_system_data VALUES ('267','0','blog','fileaway','0','2010-12-03 16:26:02');
INSERT INTO ts_system_data VALUES ('268','0','blog','fileawaypage','6','2010-12-03 11:03:53');
INSERT INTO ts_system_data VALUES ('269','0','blog','all','1','2010-12-02 19:05:40');
INSERT INTO ts_system_data VALUES ('270','0','blog','delete','0','2010-12-02 19:05:40');
INSERT INTO ts_system_data VALUES ('271','0','blog','suffix','...','2010-11-19 10:54:58');
INSERT INTO ts_system_data VALUES ('272','0','blog','titleshort','200','2010-12-03 14:50:57');
INSERT INTO ts_system_data VALUES ('273','0','blog','limitpage','20','2010-12-03 13:11:32');
INSERT INTO ts_system_data VALUES ('274','0','blog','version_number','s:5:\"15520\";','2011-07-10 00:40:18');
INSERT INTO ts_system_data VALUES ('275','0','event','limitpage','s:2:\"10\";','2011-01-20 15:19:10');
INSERT INTO ts_system_data VALUES ('276','0','event','canCreate','s:1:\"1\";','2011-01-20 15:19:10');
INSERT INTO ts_system_data VALUES ('277','0','event','credit','s:3:\"100\";','2011-01-20 15:19:10');
INSERT INTO ts_system_data VALUES ('278','0','event','credit_type','s:10:\"experience\";','2011-01-20 15:19:10');
INSERT INTO ts_system_data VALUES ('279','0','event','limittime','s:2:\"24\";','2011-01-20 15:19:10');
INSERT INTO ts_system_data VALUES ('280','0','event','version_number','s:5:\"15520\";','2011-07-10 00:40:24');
INSERT INTO ts_system_data VALUES ('1653','0','siteopt','site_anonymous_square','s:1:\"1\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('1654','0','siteopt','site_anonymous_search','s:1:\"1\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('436','0','weibo','openHotTopic','s:1:\"0\";','2011-07-21 01:07:58');
INSERT INTO ts_system_data VALUES ('666','0','related_user','tag_weight','i:4;','2011-12-23 13:12:38');
INSERT INTO ts_system_data VALUES ('667','0','related_user','city_weight','i:3;','2011-12-23 13:12:38');
INSERT INTO ts_system_data VALUES ('668','0','related_user','friend_weight','i:2;','2011-12-23 13:12:38');
INSERT INTO ts_system_data VALUES ('669','0','related_user','follower_weight','i:1;','2011-12-23 13:12:38');
INSERT INTO ts_system_data VALUES ('670','0','related_user','hide_no_avatar','i:0;','2011-12-23 13:12:38');
INSERT INTO ts_system_data VALUES ('1670','0','platform','taobaoke_key','s:15:\"mm_18680880_0_0\";','2012-07-13 14:16:34');
INSERT INTO ts_system_data VALUES ('1287','0','cnzz','cnzz_id','s:8:\"80929519\";','2012-03-19 04:32:47');
INSERT INTO ts_system_data VALUES ('1288','0','cnzz','cnzz_password','s:10:\"6826173147\";','2012-03-19 04:32:47');
INSERT INTO ts_system_data VALUES ('545','0','square','group','i:1;','2011-10-12 11:55:07');
INSERT INTO ts_system_data VALUES ('546','0','square','photo','i:1;','2011-10-12 11:55:07');
INSERT INTO ts_system_data VALUES ('547','0','square','blog','i:1;','2011-10-12 11:55:07');
INSERT INTO ts_system_data VALUES ('548','0','square','vote','i:0;','2011-10-12 11:55:07');
INSERT INTO ts_system_data VALUES ('549','0','square','event','i:0;','2011-10-12 11:55:07');
INSERT INTO ts_system_data VALUES ('1656','0','siteopt','site_user_visited','s:1:\"1\";','2012-07-13 14:13:47');
INSERT INTO ts_system_data VALUES ('565','0','shorturl','shorturl_type','s:6:\"google\";','2011-11-08 22:55:23');
INSERT INTO ts_system_data VALUES ('566','0','shorturl','customize_url','s:0:\"\";','2011-11-08 22:55:23');
INSERT INTO ts_system_data VALUES ('601','0','photo','version_number','s:5:\"15520\";','2011-11-18 14:33:39');
INSERT INTO ts_system_data VALUES ('602','0','poster','version_number','s:5:\"15520\";','2011-12-01 20:23:26');
INSERT INTO ts_system_data VALUES ('671','0','top_follower','hide_no_avatar','i:0;','2011-12-23 13:12:45');
INSERT INTO ts_system_data VALUES ('672','0','top_follower','hide_auto_friend','i:0;','2011-12-23 13:12:45');
INSERT INTO ts_system_data VALUES ('1559','0','weibo','openDynamic','s:1:\"1\";','2012-04-09 11:53:32');
INSERT INTO ts_system_data VALUES ('1560','0','weibo','openAutoDenounce','s:1:\"1\";','2012-04-09 11:53:32');
INSERT INTO ts_system_data VALUES ('1561','0','weibo','hotTopicTime','s:1:\"3\";','2012-04-09 11:53:32');
INSERT INTO ts_system_data VALUES ('1564','0','weibo','hotTopicNote','a:0:{}','2012-04-09 11:53:32');
INSERT INTO ts_system_data VALUES ('1660','0','siteopt','site_logo','s:0:\"\";','2012-07-13 14:13:47');

DROP TABLE IF EXISTS ts_tag;
CREATE TABLE `ts_tag` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(120) NOT NULL,
  PRIMARY KEY (`tag_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO ts_tag VALUES ('4','购物');
INSERT INTO ts_tag VALUES ('3','淘宝');
INSERT INTO ts_tag VALUES ('5','达人');
INSERT INTO ts_tag VALUES ('6','时尚');
INSERT INTO ts_tag VALUES ('7','美丽');
INSERT INTO ts_tag VALUES ('8','时尚潮流');
INSERT INTO ts_tag VALUES ('9','搭配日记');
INSERT INTO ts_tag VALUES ('10','彩妆look');
INSERT INTO ts_tag VALUES ('11','清新素颜');
INSERT INTO ts_tag VALUES ('12','服装搭配');
INSERT INTO ts_tag VALUES ('13','美容美妆');
INSERT INTO ts_tag VALUES ('14','配件饰品');
INSERT INTO ts_tag VALUES ('15','达人SHOW');
INSERT INTO ts_tag VALUES ('16','11');
INSERT INTO ts_tag VALUES ('17','减肥');
INSERT INTO ts_tag VALUES ('18','白菜帮');
INSERT INTO ts_tag VALUES ('19','团购');
INSERT INTO ts_tag VALUES ('20','猫猫控');
INSERT INTO ts_tag VALUES ('21','祛痘');
INSERT INTO ts_tag VALUES ('22','情感');
INSERT INTO ts_tag VALUES ('23','学习');
INSERT INTO ts_tag VALUES ('24','电商');
INSERT INTO ts_tag VALUES ('25','社区');
INSERT INTO ts_tag VALUES ('26','http://');
INSERT INTO ts_tag VALUES ('27','衣服');
INSERT INTO ts_tag VALUES ('28','爱情专家');
INSERT INTO ts_tag VALUES ('29','格开');
INSERT INTO ts_tag VALUES ('30','mnn');

DROP TABLE IF EXISTS ts_template;
CREATE TABLE `ts_template` (
  `tpl_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `title` text,
  `body` text,
  `lang` varchar(255) NOT NULL DEFAULT 'zh',
  `type` varchar(255) DEFAULT NULL,
  `type2` varchar(255) DEFAULT NULL,
  `is_cache` tinyint(1) NOT NULL DEFAULT '1',
  `ctime` int(11) DEFAULT NULL,
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

INSERT INTO ts_template VALUES ('1','invite_register','邀请注册','{actor_name}邀请您加入{site_name}','亲爱的{email}您好，\r\n{actor}邀请您加入{site}','zh','invite','','1','1282554257');
INSERT INTO ts_template VALUES ('16','album_share_weibo','分享相册','',' 分享@{author} 的相册:【{title}】{url}','zh','album','weibo','0','1290595552');
INSERT INTO ts_template VALUES ('15','photo_share_weibo','分享图片','','分享@{author} 的图片:【{title}】{url}','zh','photo','weibo','0','1290595552');
INSERT INTO ts_template VALUES ('14','photo_create_weibo','发表图片','','我上传了{count}张新图片:【{title}】... {url}','zh','photo','weibo','0','1290417734');
INSERT INTO ts_template VALUES ('8','vote_create_weibo','发起投票','','我发起了一个投票:【{title}】 {url}','zh','vote','weibo','0','1290417734');
INSERT INTO ts_template VALUES ('9','vote_share_weibo','分享投票','','分享@{author} 的投票:【{title}】{url}','zh','vote','weibo','0','1290595552');
INSERT INTO ts_template VALUES ('10','blog_create_weibo','发表日志','','我发表了一篇日志:【{title}】 {url}','zh','blog','weibo','0','1290417734');
INSERT INTO ts_template VALUES ('11','blog_share_weibo','分享日志','','分享@{author} 的日志:【{title}】 {url}','zh','blog','weibo','0','1290595552');
INSERT INTO ts_template VALUES ('12','event_create_weibo','发起活动','','我发起了一个活动：【{title}】{url}','zh','event','weibo','0','1290417734');
INSERT INTO ts_template VALUES ('13','event_share_weibo','分享活动','','分享@{author} 的活动:【{title}】 {url}','zh','event','weibo','0','1290595552');
INSERT INTO ts_template VALUES ('17','poster_create_weibo','发布招贴','','我发起了一份招贴：【{title}】{url}','zh','poster','weibo','0','1290417734');
INSERT INTO ts_template VALUES ('18','poster_share_weibo','分享招贴','','分享@{author} 的招贴:【{title}】 {url}','zh','poster','weibo','0','1290595552');

DROP TABLE IF EXISTS ts_template_record;
CREATE TABLE `ts_template_record` (
  `tpl_record_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `tpl_name` varchar(255) NOT NULL DEFAULT '',
  `tpl_alias` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `type2` varchar(255) DEFAULT NULL,
  `data` text,
  `ctime` int(11) DEFAULT NULL,
  PRIMARY KEY (`tpl_record_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_tuijian;
CREATE TABLE `ts_tuijian` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `jianid` varchar(255) NOT NULL,
  `dateline` char(20) NOT NULL,
  `jianuid` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8;

INSERT INTO ts_tuijian VALUES ('1','1','1325','1331023337','320');
INSERT INTO ts_tuijian VALUES ('3','1','1347','1331023460','1');
INSERT INTO ts_tuijian VALUES ('48','1','1706','1333942988','1');
INSERT INTO ts_tuijian VALUES ('5','1','1346','1331023952','1');
INSERT INTO ts_tuijian VALUES ('6','1','1323','1331023961','320');
INSERT INTO ts_tuijian VALUES ('7','1','1270','1331023981','289');
INSERT INTO ts_tuijian VALUES ('8','1','1267','1331023989','290');
INSERT INTO ts_tuijian VALUES ('9','1','1248','1331023999','2');
INSERT INTO ts_tuijian VALUES ('10','1','1087','1331043379','233');
INSERT INTO ts_tuijian VALUES ('11','1','1357','1331043502','1');
INSERT INTO ts_tuijian VALUES ('12','1','1348','1331043566','2');
INSERT INTO ts_tuijian VALUES ('24','1','1383','1331266591','259');
INSERT INTO ts_tuijian VALUES ('15','1','1309','1331043682','311');
INSERT INTO ts_tuijian VALUES ('16','1','1308','1331043685','308');
INSERT INTO ts_tuijian VALUES ('17','1','1358','1331043746','1');
INSERT INTO ts_tuijian VALUES ('18','1','1298','1331043774','1');
INSERT INTO ts_tuijian VALUES ('19','1','1378','1331105710','2');
INSERT INTO ts_tuijian VALUES ('20','1','1062','1331105972','1');
INSERT INTO ts_tuijian VALUES ('21','1','1381','1331105992','1');
INSERT INTO ts_tuijian VALUES ('22','1','1396','1331177665','340');
INSERT INTO ts_tuijian VALUES ('23','1','1395','1331177715','340');
INSERT INTO ts_tuijian VALUES ('25','1','1365','1331266602','2');
INSERT INTO ts_tuijian VALUES ('26','1','1313','1331266615','290');
INSERT INTO ts_tuijian VALUES ('30','1','1154','1331690693','1');
INSERT INTO ts_tuijian VALUES ('28','1','1364','1331266633','2');
INSERT INTO ts_tuijian VALUES ('31','1','1496','1331783973','1');
INSERT INTO ts_tuijian VALUES ('32','1','1573','1332165479','1');
INSERT INTO ts_tuijian VALUES ('33','1','1024','1333415697','1');
INSERT INTO ts_tuijian VALUES ('34','1','1649','1333777222','1');
INSERT INTO ts_tuijian VALUES ('35','1','1650','1333777224','1');
INSERT INTO ts_tuijian VALUES ('36','1','1652','1333804137','1');
INSERT INTO ts_tuijian VALUES ('37','1','1654','1333804342','1');
INSERT INTO ts_tuijian VALUES ('38','1','1657','1333807818','1');
INSERT INTO ts_tuijian VALUES ('39','1','1685','1333894515','1');
INSERT INTO ts_tuijian VALUES ('40','1','1683','1333894518','1');
INSERT INTO ts_tuijian VALUES ('41','1','1680','1333894520','1');
INSERT INTO ts_tuijian VALUES ('42','1','1658','1333894560','1');
INSERT INTO ts_tuijian VALUES ('43','1','1656','1333894562','1');
INSERT INTO ts_tuijian VALUES ('44','1','1655','1333894565','1');
INSERT INTO ts_tuijian VALUES ('67','1','1987','1334328943','1');
INSERT INTO ts_tuijian VALUES ('46','1','1701','1333940438','1');
INSERT INTO ts_tuijian VALUES ('47','1','1702','1333940543','1');
INSERT INTO ts_tuijian VALUES ('49','1','1708','1333942994','1');
INSERT INTO ts_tuijian VALUES ('50','1','1709','1333952403','1');
INSERT INTO ts_tuijian VALUES ('51','1','1710','1333952669','1');
INSERT INTO ts_tuijian VALUES ('52','1','1711','1333953105','1');
INSERT INTO ts_tuijian VALUES ('53','1','1712','1333953231','1');
INSERT INTO ts_tuijian VALUES ('54','1','1718','1333957406','1');
INSERT INTO ts_tuijian VALUES ('55','1','1734','1333962577','1');
INSERT INTO ts_tuijian VALUES ('56','1','1733','1333974502','1');
INSERT INTO ts_tuijian VALUES ('57','1','1741','1333974543','1');
INSERT INTO ts_tuijian VALUES ('58','1','1748','1333977239','1');
INSERT INTO ts_tuijian VALUES ('59','1','1755','1333983825','1');
INSERT INTO ts_tuijian VALUES ('60','1','1772','1334060727','2');
INSERT INTO ts_tuijian VALUES ('61','1','1774','1334060754','2');
INSERT INTO ts_tuijian VALUES ('62','1','1777','1334060756','2');
INSERT INTO ts_tuijian VALUES ('63','1','1776','1334060761','2');
INSERT INTO ts_tuijian VALUES ('64','1','1868','1334157009','1');
INSERT INTO ts_tuijian VALUES ('65','1','1903','1334220220','1');
INSERT INTO ts_tuijian VALUES ('66','1','1947','1334300373','1');
INSERT INTO ts_tuijian VALUES ('68','1','1800','1334663558','1');
INSERT INTO ts_tuijian VALUES ('69','1','2108','1334664075','1');
INSERT INTO ts_tuijian VALUES ('70','1','2149','1334671527','1');

DROP TABLE IF EXISTS ts_ucenter_user_link;
CREATE TABLE `ts_ucenter_user_link` (
  `uid` int(11) NOT NULL,
  `uc_uid` mediumint(8) NOT NULL,
  `uc_username` char(15) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_user;
CREATE TABLE `ts_user` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `uname` varchar(255) DEFAULT NULL,
  `sex` tinyint(1) NOT NULL DEFAULT '0',
  `province` mediumint(6) NOT NULL DEFAULT '0',
  `city` mediumint(6) NOT NULL DEFAULT '0',
  `location` varchar(255) DEFAULT NULL,
  `admin_level` varchar(255) DEFAULT '0',
  `commend` tinyint(1) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  `is_init` tinyint(1) NOT NULL,
  `is_synchronizing` tinyint(1) NOT NULL DEFAULT '0',
  `ctime` int(11) DEFAULT NULL,
  `identity` tinyint(1) NOT NULL DEFAULT '1',
  `score` int(11) NOT NULL DEFAULT '0',
  `myop_menu_num` int(2) NOT NULL DEFAULT '10',
  `api_key` varchar(255) DEFAULT NULL,
  `domain` char(80) NOT NULL,
  PRIMARY KEY (`uid`),
  UNIQUE KEY `email` (`email`),
  KEY `location` (`location`)
) ENGINE=MyISAM AUTO_INCREMENT=459 DEFAULT CHARSET=utf8;

INSERT INTO ts_user VALUES ('1','admin@admin.com','e10adc3949ba59abbe56e057f20f883e','小编','0','1963','1964','广东 广州市','1','0','1','1','0','1310146856','1','0','10','','');
INSERT INTO ts_user VALUES ('2','admin@okhaoa.com','0896e1f5881a432daf929251aa5b43bc','西红柿','0','823','867','江苏 苏州市','1','0','1','1','0','1310273385','1','0','10','','');
INSERT INTO ts_user VALUES ('31','8888@qq.com','e10adc3949ba59abbe56e057f20f883e','花非花','0','1963','1999','广东 汕头市','0','0','1','1','0','1311420209','1','0','10','','');
INSERT INTO ts_user VALUES ('32','hkyufd@163.com','e10adc3949ba59abbe56e057f20f883e','shirely','0','1963','2079','广东 清远市','0','0','1','1','0','1311420232','1','0','10','','');
INSERT INTO ts_user VALUES ('33','test18@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','joybaby','0','356','357','内蒙古 呼和浩特市','0','0','1','1','0','1311420362','1','0','10','','');
INSERT INTO ts_user VALUES ('34','cdrreg@163.com','e10adc3949ba59abbe56e057f20f883e','我很有','1','1532','1632','河南 许昌市','0','0','1','1','0','1311420452','1','0','10','','');
INSERT INTO ts_user VALUES ('35','test19@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','无嘘嘘','0','656','703','黑龙江 鹤岗市','0','0','1','1','0','1311420456','1','0','10','','');
INSERT INTO ts_user VALUES ('36','test20@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','jayjay','0','586','598','吉林 吉林市','0','0','1','1','0','1311420544','1','0','10','','');
INSERT INTO ts_user VALUES ('37','kopesf@163.com','e10adc3949ba59abbe56e057f20f883e','不一样的我','1','1263','1298','江西 新余市','0','0','1','1','0','1311420562','1','0','10','','');
INSERT INTO ts_user VALUES ('38','dawwe@126.com','e10adc3949ba59abbe56e057f20f883e','淘购物','0','2106','2107','广西 南宁市','0','0','1','1','0','1311420724','1','0','10','','');
INSERT INTO ts_user VALUES ('39','test21@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','itelte','0','471','486','辽宁 大连市','0','0','1','1','0','1311420792','1','0','10','','');
INSERT INTO ts_user VALUES ('40','opryw@163.com','e10adc3949ba59abbe56e057f20f883e','小可爱','0','1374','1467','山东 威海市','0','0','1','1','0','1311420970','1','0','10','','');
INSERT INTO ts_user VALUES ('41','test22@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','爱屋及乌','0','225','255','山西 长治市','0','0','1','1','0','1311421025','1','0','10','','');
INSERT INTO ts_user VALUES ('42','mmaew@126.com','e10adc3949ba59abbe56e057f20f883e','麻豆腐','0','1532','1632','河南 许昌市','0','0','1','1','0','1311421070','1','0','10','','');
INSERT INTO ts_user VALUES ('43','test23@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','心有囍','0','356','377','内蒙古 乌海市','0','0','1','1','0','1311421193','1','0','10','','');
INSERT INTO ts_user VALUES ('44','test24@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','米凯','0','802','803','上海 上海市','0','0','1','1','0','1311422260','1','0','10','','');
INSERT INTO ts_user VALUES ('45','uiuewe@126.com','e10adc3949ba59abbe56e057f20f883e','苗苗','0','1826','1847','湖南 湘潭市','0','0','1','1','0','1311424861','1','0','10','','');
INSERT INTO ts_user VALUES ('46','asdwer@126.com','e10adc3949ba59abbe56e057f20f883e','小猪','1','2106','2149','广西 梧州市','0','0','1','1','0','1311425329','1','0','10','','');
INSERT INTO ts_user VALUES ('47','joanew@126.com','e10adc3949ba59abbe56e057f20f883e','jondy','1','2827','2842','陕西 铜川市','0','0','1','1','0','1311425778','1','0','10','','');
INSERT INTO ts_user VALUES ('48','yuouew@126.com','e10adc3949ba59abbe56e057f20f883e','yoyo','0','1709','1724','湖北 黄石市','0','0','1','1','0','1311426232','1','0','10','','');
INSERT INTO ts_user VALUES ('49','emmy2008@126.com','e10adc3949ba59abbe56e057f20f883e','emmy','0','802','803','上海 上海市','0','0','1','1','0','1311426740','1','0','10','','');
INSERT INTO ts_user VALUES ('50','904514810@qq.com','fe29a5a1e697c2b3da33f5474da3a4c4','tongyong','0','802','803','上海 上海市','0','0','1','1','0','1311427027','1','0','10','','');
INSERT INTO ts_user VALUES ('51','paopao@126.com','e10adc3949ba59abbe56e057f20f883e','泡泡','0','471','486','辽宁 大连市','0','0','1','1','0','1311427271','1','0','10','','');
INSERT INTO ts_user VALUES ('52','afewiowq@126.com','e10adc3949ba59abbe56e057f20f883e','紫星','0','1374','1477','山东 莱芜市','0','0','1','1','0','1311427721','1','0','10','','');
INSERT INTO ts_user VALUES ('53','afsrre@126.com','e10adc3949ba59abbe56e057f20f883e','星星','0','823','838','江苏 无锡市','0','0','1','1','0','1311428153','1','0','10','','');
INSERT INTO ts_user VALUES ('55','poeruiat@126.com','e10adc3949ba59abbe56e057f20f883e','happier','0','0','0','','0','0','1','0','0','1311430052','1','0','10','','');
INSERT INTO ts_user VALUES ('56','poerui@126.com','e10adc3949ba59abbe56e057f20f883e','happiy','1','1709','1731','湖北 十堰市','0','0','1','1','0','1311430105','1','0','10','','');
INSERT INTO ts_user VALUES ('57','test28@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','雅安拉','0','41','81','河北 秦皇岛市','0','0','1','1','0','1311438422','1','0','10','','');
INSERT INTO ts_user VALUES ('58','wuyuyiduidewo@162.com','e10adc3949ba59abbe56e057f20f883e','wuyuyiduid','0','0','0','','0','0','1','1','0','1311439113','1','0','10','','');
INSERT INTO ts_user VALUES ('61','micasoft@163.com','c5b0dab147d177e08db50011f8bf4735','mica','1','823','879','江苏 南通市','0','0','1','1','0','1311486623','1','0','10','','');
INSERT INTO ts_user VALUES ('62','279457480@QQ.COM','62c8ad0a15d9d1ca38d5dee762a16e01','moon','1','2600','2601','云南 昆明市','0','0','1','1','0','1311487281','1','0','10','','');
INSERT INTO ts_user VALUES ('66','','','罗镜标-Sam','1','44','1','广东 广州','0','0','1','1','1','1311491336','1','0','10','','');
INSERT INTO ts_user VALUES ('67','200880110@qq.com','9a34c2ca6b4b0783f6005b609557eb69','qq200880','1','0','0','','0','0','1','1','0','1311493135','1','0','10','','');
INSERT INTO ts_user VALUES ('70','510291958@qq.com','78795185758cec31defe47b8f5063e55','m123456','1','41','0','河北','0','0','1','1','0','1311493988','1','0','10','','');
INSERT INTO ts_user VALUES ('71','pengaiguai@sina.com','158afe4d6cc562a876abc8dcf53d761a','胖爱乖','0','2230','0','海南','0','0','1','1','0','1311497688','1','0','10','','');
INSERT INTO ts_user VALUES ('75','2342@qq.com','dc483e80a7a0bd9ef71d8cf973673924','huahua','0','1963','1964','广东 广州市','0','0','1','1','0','1311509089','1','0','10','','');
INSERT INTO ts_user VALUES ('76','448238274@qq.com','bfdb1ec63725f32178bcb7b8336256ab','linde','1','0','0','','0','0','1','1','0','1311511937','1','0','10','','');
INSERT INTO ts_user VALUES ('77','745525499@qq.com','8ad9fd28e52335ee8babbec1f51cec68','qm0128kx','0','1045','1046','安徽 合肥市','0','0','1','1','0','1311517059','1','0','10','','');
INSERT INTO ts_user VALUES ('79','tianshi@163.com','96e79218965eb72c92a549dd5a330112','tianshi','0','2502','2503','贵州 贵阳市','0','0','1','1','0','1311523559','1','0','10','','');
INSERT INTO ts_user VALUES ('80','fidji@163.com','96e79218965eb72c92a549dd5a330112','fidji','1','41','89','河北 邯郸市','0','0','1','1','0','1311531525','1','0','10','','');
INSERT INTO ts_user VALUES ('82','479145361@qq.com','84ff4af36c0b48204303846c15ce5867','479145361','1','2299','2300','四川 成都市','0','0','1','1','0','1311535874','1','0','10','','');
INSERT INTO ts_user VALUES ('85','382413123@qq.com','9e6a3f23b1ab6f1669f4ff8d077ad230','Dearlimg','0','823','879','江苏 南通市','0','0','1','1','0','1311556416','1','0','10','','');
INSERT INTO ts_user VALUES ('86','lxw.onelove@yahoo.com.cn','4284b9848349fc577204baaaeb41d6a4','cash林林','0','823','879','江苏 南通市','0','0','1','1','0','1311556946','1','0','10','','');
INSERT INTO ts_user VALUES ('88','254961127@qq.com','702d20f9b82be24a54fdb9e712bdfb46','dengminmin','0','0','0','','0','0','1','0','0','1311559121','1','0','10','','');
INSERT INTO ts_user VALUES ('89','25496117@qq.com','96e79218965eb72c92a549dd5a330112','dengminmin','0','0','0','','0','0','1','0','0','1311559139','1','0','10','','');
INSERT INTO ts_user VALUES ('91','158591807@qq.com','8e7e23f293520c141c440ba8e484a6cf','tadpole','1','1963','1964','广东 广州市','0','0','1','1','0','1311560440','1','0','10','','');
INSERT INTO ts_user VALUES ('92','1092601416@qq.com','fe29a5a1e697c2b3da33f5474da3a4c4','tongyong1','1','0','0','','0','0','1','1','0','1313634014','1','0','10','','');
INSERT INTO ts_user VALUES ('93','ljlbinghe@163.com','f0af962ddbc82430e947390b2f3f6e49','ljlbinghe','0','0','0','','0','0','1','1','0','1313727543','1','0','10','','');
INSERT INTO ts_user VALUES ('97','469440314@qq.com','7036317bfa74b871c8687f0d6bf412f8','豆瓣Chow','0','2299','2484','四川 凉山彝族自治州','0','0','1','1','0','1313766441','1','0','10','','');
INSERT INTO ts_user VALUES ('100','bd@zeze.com','d60f1e0f7987531889fcaecf6f26308f','sucan','1','1','2','北京 北京市','0','0','1','1','0','1313874623','1','0','10','','');
INSERT INTO ts_user VALUES ('102','cctv520kdl@163.com','3514fb88d58db41fd94f27cbbcac0a5a','66164646','0','21','22','天津 天津市','0','0','1','1','0','1314000318','1','0','10','','');
INSERT INTO ts_user VALUES ('104','maksimguo@gmail.com','5064ce003a0fd01e508a58a01a1a91e1','maksimguo','1','0','0','','0','0','1','1','0','1314089578','1','0','10','','');
INSERT INTO ts_user VALUES ('113','asas@sohu.com','a8f5f167f44f4964e6c998dee827110c','asasas','1','21','22','天津 天津市','0','0','1','1','0','1314279718','1','0','10','','');
INSERT INTO ts_user VALUES ('114','piethguo@hotmail.com','e10adc3949ba59abbe56e057f20f883e','piepie','0','1','2','北京 北京市','0','0','1','1','0','1314280866','1','0','10','','');
INSERT INTO ts_user VALUES ('117','wbo1983@163.com','6f536574b93adfc00b2a4d2549e661ea','kerlin','1','0','0','','0','0','1','1','0','1314408089','1','0','10','','');
INSERT INTO ts_user VALUES ('124','527699319@qq.com','e10adc3949ba59abbe56e057f20f883e','cxstruggle','1','1532','1573','河南 平顶山市','0','0','1','1','0','1314583364','1','0','10','','');
INSERT INTO ts_user VALUES ('126','yanggenping@yeah.net','d763c394f6a9c868ce44dcf4ddd253f0','shishangce','0','1826','1827','湖南 长沙市','0','0','1','1','0','1314632036','1','0','10','','shishangce');
INSERT INTO ts_user VALUES ('127','wbo1983@21cn.com','6f536574b93adfc00b2a4d2549e661ea','kerlin6911','1','0','0','','0','0','1','1','0','1314666339','1','0','10','','');
INSERT INTO ts_user VALUES ('130','harrie@live.com','21218cca77804d2ba1922c33e0151105','harrie','1','802','803','上海 上海市','0','0','1','1','0','1314753725','1','0','10','','');
INSERT INTO ts_user VALUES ('132','1088444@qq.com','48eb30e62d5b1ec064296e6a47480110','哈里菠萝','1','1','2','北京 北京市','0','0','1','1','0','1314782093','1','0','10','','');
INSERT INTO ts_user VALUES ('133','254772955@qq.com','02d57b717e37c5598d88c200a3972042','z661623123','0','0','0','','0','0','1','0','0','1314803467','1','0','10','','');
INSERT INTO ts_user VALUES ('135','svtop@126.com','32955496a57a3b21a05dc163808fd79b','187187','1','1','2','北京 北京市','0','0','1','1','0','1314835260','1','0','10','','');
INSERT INTO ts_user VALUES ('137','lyad365@126.com','e10adc3949ba59abbe56e057f20f883e','lyad365','1','1','2','北京 北京市','0','0','1','1','0','1314864417','1','0','10','','');
INSERT INTO ts_user VALUES ('138','onebyyou@163.com','64be4374fed9e072a40744e5e9498098','onebyyou','1','0','0','','0','0','1','1','0','1314865831','1','0','10','','');
INSERT INTO ts_user VALUES ('141','1772901179@qq.com','0659c7992e268962384eb17fafe88364','weiguan','0','0','0','','0','0','1','1','0','1314941480','1','0','10','','');
INSERT INTO ts_user VALUES ('142','heading196@sina.com','43060eb9a1d80629ab28db0bdb3daa5f','szmdc','1','1963','1988','广东 深圳市','0','0','1','1','0','1314945169','1','0','10','','');
INSERT INTO ts_user VALUES ('143','125226618@qq.com','976750cad6b292d1c8e247fa1ea7740b','xiaotai','1','0','0','','0','0','1','1','0','1314983233','1','0','10','','');
INSERT INTO ts_user VALUES ('144','v169@v169.com','4eba13ecc03c20c2da7517c4b9d631f5','v169','1','802','803','上海 上海市','0','0','1','1','0','1314988770','1','0','10','','');
INSERT INTO ts_user VALUES ('146','420260133@qq.com','0af0f681011c30522cc698b8d5f19129','lyman','1','1','0','北京','0','0','1','1','0','1315115161','1','0','10','','');
INSERT INTO ts_user VALUES ('147','502404320@qq.com','1b54c0c9220bc94390e8f3fabe301ca9','okj2011','0','1','2','北京 北京市','0','0','1','1','0','1315115259','1','0','10','','');
INSERT INTO ts_user VALUES ('148','wrc0770@163.com','e10adc3949ba59abbe56e057f20f883e','menghuan','1','0','0','','0','0','1','1','0','1315122173','1','0','10','','');
INSERT INTO ts_user VALUES ('149','126@gmail.com','baa96957f185051bde38c6535f7a8426','kclisy','1','0','0','','0','0','1','1','0','1315133589','1','0','10','','');
INSERT INTO ts_user VALUES ('150','dshpsky@163.com','172a792213d4fedd5b3c2012242cab15','killblank','1','1709','1710','湖北 武汉市','0','0','1','1','0','1315208916','1','0','10','','');
INSERT INTO ts_user VALUES ('151','mfkjava@sina.com','0b3caa1e8bc9a8cb305983bd0a0fcbcc','mfkjava','0','2827','2828','陕西 西安市','0','0','1','1','0','1315214868','1','0','10','','');
INSERT INTO ts_user VALUES ('152','getons@qq.com','f584cb8d3f1724fc0a3b0c61258470f2','getons','1','0','0','','0','0','1','1','0','1315269832','1','0','10','','');
INSERT INTO ts_user VALUES ('154','lmj868@hotmail.com','b5d482735a39e6b1caf06850996bdb18','卢兔子','1','21','22','天津 天津市','0','0','1','1','0','1315290853','1','0','10','','');
INSERT INTO ts_user VALUES ('156','fengyuxuan945@163.com','e10adc3949ba59abbe56e057f20f883e','一丨丶','1','0','0','','0','0','1','1','0','1315361456','1','0','10','','');
INSERT INTO ts_user VALUES ('158','54154181@qq.com','e10adc3949ba59abbe56e057f20f883e','时尚女性','1','1','0','北京','0','0','1','1','0','1315382615','1','0','10','','shuo');
INSERT INTO ts_user VALUES ('165','17418365@qq.com','298c5582c03b32190e517ec200a34933','jessica','0','0','0','','0','0','1','1','0','1315485988','1','0','10','','');
INSERT INTO ts_user VALUES ('167','lfguo@qq.com','b40eaa530c778587c44892186188cb2d','mmdress','0','802','803','上海 上海市','0','0','1','1','0','1315528410','1','0','10','','');
INSERT INTO ts_user VALUES ('170','12345678@qq.com','fcea920f7412b5da7be0cf42b8c93759','1q23456','0','0','0','','0','0','1','0','0','1315651872','1','0','10','','');
INSERT INTO ts_user VALUES ('175','weiwell@163.com','6ebe76c9fb411be97b3b0d48b791a7c9','weiwell','1','0','0','','0','0','1','1','0','1315919756','1','0','10','','');
INSERT INTO ts_user VALUES ('176','piaopiao@aaa.com','76f88abd34285c021c01150fb21fe7bc','piaopiao','1','2106','2107','广西 南宁市','0','0','1','1','0','1315925622','1','0','10','','');
INSERT INTO ts_user VALUES ('177','cxw1980@gmail.com','980e52ea49f210eb458b62d143a42ae7','moriliuyan','1','1963','1964','广东 广州市','0','0','1','1','0','1315927784','1','0','10','','');
INSERT INTO ts_user VALUES ('178','52382@163.com','e10adc3949ba59abbe56e057f20f883e','黄黄爱可欣','1','0','0','','0','0','1','1','0','1315971931','1','0','10','','');
INSERT INTO ts_user VALUES ('180','user98@gmail.com','baa96957f185051bde38c6535f7a8426','user98','1','0','0','','0','0','1','1','0','1316003806','1','0','10','','');
INSERT INTO ts_user VALUES ('183','ss@sdfsdf.com','e10adc3949ba59abbe56e057f20f883e','fsdafsdaf','1','0','0','','0','0','1','1','0','1316052901','1','0','10','','');
INSERT INTO ts_user VALUES ('185','verymadou@sina.com','4d0b203ff4b9058dd2409ec88dcdf71e','very麻豆','0','0','0','','0','0','1','1','0','1316068805','1','0','10','','');
INSERT INTO ts_user VALUES ('187','tian.maple@gmail.com','6a204bd89f3c8348afd5c77c717a097a','maple','1','0','0','','0','0','1','1','0','1316072901','1','0','10','','');
INSERT INTO ts_user VALUES ('188','9002857@qq.com','cdee0d310c7c7440b8514507bd920354','o上房揭瓦o','1','586','587','吉林 长春市','0','0','1','1','0','1316074185','1','0','10','','');
INSERT INTO ts_user VALUES ('191','combler@126.com','3f22b9d363d7f30b58890638c49e9cff','蝶舞思思','0','1374','1375','山东 济南市','0','0','1','1','0','1316254421','1','0','10','','weimi');
INSERT INTO ts_user VALUES ('192','yibao263@163.com','d40878fdc9395b04a129a2a7cce577ca','76194333','1','1963','1964','广东 广州市','0','0','1','1','0','1316265225','1','0','10','','');
INSERT INTO ts_user VALUES ('195','baodongdong@msn.com','4c1aaf6390d956c2c46068e89b4e6aef','东东包','1','1','2','北京 北京市','0','0','1','1','0','1316400420','1','0','10','','');
INSERT INTO ts_user VALUES ('196','123@admin.com','670b14728ad9902aecba32e22fa4f6bd','alexai','1','0','0','','0','0','1','1','0','1316456550','1','0','10','','');
INSERT INTO ts_user VALUES ('198','abc123@sina.com','e99a18c428cb38d5f260853678922e03','abc123','0','0','0','','0','0','1','1','0','1316510654','1','0','10','','');
INSERT INTO ts_user VALUES ('201','wdymdc@126.com','a6d432b8e3888f9e57d6be7615fc9c62','wdymdc','0','802','803','上海 上海市','0','0','1','1','0','1316592235','1','0','10','','');
INSERT INTO ts_user VALUES ('203','824006642@qq.com','8098aa67e8ac18bb0648e7c0fc61f822','oop123','0','943','944','浙江 杭州市','0','0','1','1','0','1316688867','1','0','10','','');
INSERT INTO ts_user VALUES ('204','bimuyuonlyone@21cn.com','96e79218965eb72c92a549dd5a330112','bimuyu','0','0','0','','0','0','1','1','0','1316767581','1','0','10','','');
INSERT INTO ts_user VALUES ('205','whj8188@msn.com','4f5d95b0fb25d684a506c43e0a108a7b','whj8188','0','0','0','','0','0','1','1','0','1316772933','1','0','10','','');
INSERT INTO ts_user VALUES ('206','1222@1222.com','4f5d95b0fb25d684a506c43e0a108a7b','8188','1','0','0','','0','0','1','1','0','1316790993','1','0','10','','');
INSERT INTO ts_user VALUES ('207','jsf520@163.com','ffdfbdafdb39fd03ab4075e600302eb8','u66748','1','0','0','','0','0','1','1','0','1316797530','1','0','10','','');
INSERT INTO ts_user VALUES ('209','36068771@qq.com','6486011b89db67e8698fdc6eefbfe14a','gege','1','0','0','','0','0','1','1','0','1316840445','1','0','10','','');
INSERT INTO ts_user VALUES ('211','changli@soxun.tv','96e79218965eb72c92a549dd5a330112','changli','0','1','2','北京 北京市','0','0','1','1','0','1316998929','1','0','10','','');
INSERT INTO ts_user VALUES ('212','332795285@qq.com','fefaac12947ce639c98ee81f632c5686','12321321','1','0','0','','0','0','1','1','0','1317004065','1','0','10','','');
INSERT INTO ts_user VALUES ('213','1192258678@qq.com','ad3f4ad833288e217954ba654de28af3','糖丫头宝','0','1','2','北京 北京市','0','0','1','1','0','1317008754','1','0','10','','');
INSERT INTO ts_user VALUES ('214','info@cheyuan.con','a89358a2ced93dd524186b92c1cc253d','cheyuan','1','943','958','浙江 宁波市','0','0','1','1','0','1317049012','1','0','10','','');
INSERT INTO ts_user VALUES ('216','honshen@gmail.com','4297f44b13955235245b2497399d7a93','honshen','0','0','0','','0','0','1','0','0','1317194308','1','0','10','','');
INSERT INTO ts_user VALUES ('217','kreava@yeah.net','4326b68439fa33773d7436a72881dcfa','kreava','1','1826','1954','湖南 湘西土家族苗族自治州','0','0','1','1','0','1317256223','1','0','10','','');
INSERT INTO ts_user VALUES ('219','1935790008@qq.com','f379eaf3c831b04de153469d1bec345e','新奇特','0','943','1003','浙江 金华市','0','0','1','1','0','1317276482','1','0','10','','');
INSERT INTO ts_user VALUES ('220','42496180@qq.com','25f9e794323b453885f5181f1b624d0b','malin','1','0','0','','0','0','1','1','0','1317284646','1','0','10','','');
INSERT INTO ts_user VALUES ('221','915556508@qq.com','8b28abc42c54a5a15ef0c2519100dfe8','罗非不是鱼','1','2106','2107','广西 南宁市','0','0','1','1','0','1317299632','1','0','10','','');
INSERT INTO ts_user VALUES ('222','314218990@qq.com','94687d9fc85ed1c814825a3c3d67258e','佰惠恩服饰','1','0','0','','0','0','1','1','0','1317309537','1','0','10','','');
INSERT INTO ts_user VALUES ('223','demo002@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','demo002','1','225','249','山西 阳泉市','0','0','1','1','0','1320855255','1','0','10','','');
INSERT INTO ts_user VALUES ('224','test155@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','test155','0','0','0','','0','0','1','1','0','1323770451','1','0','10','','');
INSERT INTO ts_user VALUES ('225','test002@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','test002','0','21','22','天津 天津市','0','0','1','1','0','1324223944','1','0','10','','');
INSERT INTO ts_user VALUES ('226','test003@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','test003','1','225','237','山西 大同市','0','0','1','1','0','1324227556','1','0','10','','');
INSERT INTO ts_user VALUES ('227','test004@36hua.cn','f1137bb0649ad8315bd5d87aec9b81dd','jieiseewe','0','656','676','黑龙江 齐齐哈尔市','0','0','1','1','0','1324648017','1','0','10','','');
INSERT INTO ts_user VALUES ('228','test005@36hua.cn','f1137bb0649ad8315bd5d87aec9b81dd','lvbook','1','1045','1062','安徽 蚌埠市','0','0','1','1','0','1324648474','1','0','10','','');
INSERT INTO ts_user VALUES ('229','lafeng88@126.com','f1137bb0649ad8315bd5d87aec9b81dd','lafeng88','0','41','89','河北 邯郸市','0','0','1','1','0','1326271186','1','0','10','','');
INSERT INTO ts_user VALUES ('231','70494821@qq.com','e10adc3949ba59abbe56e057f20f883e','简单爱','1','2827','2828','陕西 西安市','0','0','1','1','0','1328840865','1','0','10','','');
INSERT INTO ts_user VALUES ('232','china1910@qq.com','6cfd762a08ddc2024e23ebfe7a1e92ed','ken','1','802','803','上海 上海市','0','0','1','1','0','1328856879','1','0','10','','');
INSERT INTO ts_user VALUES ('233','61779065@qq.com','1308062889d21461265f3725caa5ad1a','forchina','1','225','295','山西 运城市','0','0','1','1','0','1328859332','1','0','10','','');
INSERT INTO ts_user VALUES ('234','kjkj@sohu.com','a750cad28ca58f4295c9c9a860ec6c86','suozi','1','0','0','','0','0','1','1','0','1328860635','1','0','10','','');
INSERT INTO ts_user VALUES ('235','apamau@gmail.com','0c6639480a8d39cbd4a971ef7b848a62','apamau','1','1963','1964','广东 广州市','0','0','1','1','0','1328862962','1','0','10','','');
INSERT INTO ts_user VALUES ('236','hfgddsf@fsdsfd.com','e10adc3949ba59abbe56e057f20f883e','dfssd','1','1826','1866','湖南 邵阳市','0','0','1','1','0','1328878596','1','0','10','','');
INSERT INTO ts_user VALUES ('238','77467885@qq.com','2736f2f2cb760b84488b342f26e6210e','希腊队民','1','2600','2718','云南 大理白族自治州','0','0','1','1','0','1328963393','1','0','10','','');
INSERT INTO ts_user VALUES ('239','a@a.com','e10adc3949ba59abbe56e057f20f883e','kvjsvjkvso','1','0','0','','0','0','1','1','0','1328981582','1','0','10','','');
INSERT INTO ts_user VALUES ('241','metalhappy@126.com','e10adc3949ba59abbe56e057f20f883e','happymetal','0','2299','2446','四川 资阳市','0','0','1','1','0','1329024416','1','0','10','','');
INSERT INTO ts_user VALUES ('242','happymetal@163.com','e10adc3949ba59abbe56e057f20f883e','mmmm','0','2827','2842','陕西 铜川市','0','0','1','1','0','1329027900','1','0','10','','');
INSERT INTO ts_user VALUES ('243','liebaoo@126.com','793aa97583fc5b202d1bd8246ddfd684','ivyjpc','0','1963','1964','广东 广州市','0','0','1','1','0','1329057719','1','0','10','','');
INSERT INTO ts_user VALUES ('247','happymetal@123.com','e10adc3949ba59abbe56e057f20f883e','nnnn','0','1','2','北京 北京市','0','0','1','1','0','1329110672','1','0','10','','aaa');
INSERT INTO ts_user VALUES ('249','yeyuliang_work@163.com','e10adc3949ba59abbe56e057f20f883e','理解','1','802','803','上海 上海市','0','0','1','1','0','1329140345','1','0','10','','');
INSERT INTO ts_user VALUES ('250','lincoln1130@qq.com','bad20825fd3149ffe0ebbb1a5314a9b2','aaaaa','1','2299','2300','四川 成都市','0','0','1','1','0','1329144980','1','0','10','','');
INSERT INTO ts_user VALUES ('251','pbdy86@163.com','e6bfa7029b19ca01c6303ab273f4e965','alan','1','0','0','','0','0','1','1','0','1329279866','1','0','10','','');
INSERT INTO ts_user VALUES ('252','abcde@abc.com','e10adc3949ba59abbe56e057f20f883e','aberdin','1','2299','2341','四川 德阳市','0','0','1','1','0','1329288857','1','0','10','','kuding');
INSERT INTO ts_user VALUES ('253','ranzhuangnet@foxmail.com','81626f297bd616f8f53528a65ecdc1dd','shuilan','0','1','2','北京 北京市','0','0','1','1','0','1329312652','1','0','10','','');
INSERT INTO ts_user VALUES ('255','win@21cn.com','e10adc3949ba59abbe56e057f20f883e','张三','1','0','0','','0','0','1','1','0','1329401163','1','0','10','','');
INSERT INTO ts_user VALUES ('257','55633094@qq.com','4cb3ef1be48e85e0b4f11c11cebbf4fd','非常的','1','1826','1827','湖南 长沙市','0','0','1','1','0','1329491549','1','0','10','','');
INSERT INTO ts_user VALUES ('258','asdasd@sohu.com','4297f44b13955235245b2497399d7a93','1231231312','1','2746','2756','西藏 昌都地区','0','0','1','1','0','1329491824','1','0','10','','');
INSERT INTO ts_user VALUES ('260','67553921@qq.com','c8837b23ff8aaa8a2dde915473ce0991','xialala','1','1963','1999','广东 汕头市','0','0','1','1','0','1329529676','1','0','10','','');
INSERT INTO ts_user VALUES ('262','wuyu6666@eyou.com','e10adc3949ba59abbe56e057f20f883e','wuyu6666','1','0','0','','0','0','1','1','0','1329657257','1','0','10','','');
INSERT INTO ts_user VALUES ('265','sunyuhai78@qq.com','004712dac4cd9981561931b3353d8a5c','阿海','1','1','2','北京 北京市','0','0','1','1','0','1329707223','1','0','10','','');
INSERT INTO ts_user VALUES ('267','vxcvb@qq.com','670b14728ad9902aecba32e22fa4f6bd','Mike','1','1532','1652','河南 南阳市','0','0','1','1','0','1329752186','1','0','10','','');
INSERT INTO ts_user VALUES ('268','peiaiming@126.com','8d2c9408ddc142d421b48bbbcd1ba67d','iMing','1','2827','2828','陕西 西安市','0','0','1','1','0','1329794738','1','0','10','','');
INSERT INTO ts_user VALUES ('269','nishiwonainai@hotmail.com','b4d1ef97c59c022eade3213a26c699e4','戒指','1','0','0','','0','0','1','1','0','1329810015','1','0','10','','');
INSERT INTO ts_user VALUES ('272','xiaonanyjl2008@139.com','95d8e3aa53b2cfca78ba825d3a8c5ae0','夏至沿阳','0','1963','1988','广东 深圳市','0','0','1','1','0','1329840906','1','0','10','','');
INSERT INTO ts_user VALUES ('275','616154464@qq.com','e10adc3949ba59abbe56e057f20f883e','letian','1','2827','2842','陕西 铜川市','0','0','1','1','0','1329965775','1','0','10','','');
INSERT INTO ts_user VALUES ('276','micrsosft@live.com','e10adc3949ba59abbe56e057f20f883e','哦哦哦','1','0','0','','0','0','1','1','0','1329995514','1','0','10','','');
INSERT INTO ts_user VALUES ('279','zoosoo@126.com','dca0a59573a2a4ad76acb58d7fdf9eb0','zoosoo','1','0','0','','0','0','1','1','0','1330054405','1','0','10','','');
INSERT INTO ts_user VALUES ('281','bugtest@126.com','e10adc3949ba59abbe56e057f20f883e','bugtest','1','2827','2828','陕西 西安市','0','0','1','1','0','1330068417','1','0','10','','');
INSERT INTO ts_user VALUES ('283','conbuy@126.com','1a969f3c0b5dac340362033b543cdc5d','conbuy','1','943','1025','浙江 台州市','0','0','1','1','0','1330173838','1','0','10','','');
INSERT INTO ts_user VALUES ('284','zoosou@qq.com','4db6d4ceb60f86cc7266df47ca5b2e15','zoosouzoos','1','0','0','','0','0','1','1','0','1330227765','1','0','10','','');
INSERT INTO ts_user VALUES ('285','1055331212@qq.com','a5e630c10e191868495c0077c5245083','lost','1','3125','3223','新疆 阿勒泰地区','0','0','1','1','0','1330235764','1','0','10','','');
INSERT INTO ts_user VALUES ('288','15383869906@189.cn','e10adc3949ba59abbe56e057f20f883e','hameiyou','0','1','2','北京 北京市','0','0','1','1','0','1330312793','1','0','10','','');
INSERT INTO ts_user VALUES ('290','wuyu66668@163.com','e10adc3949ba59abbe56e057f20f883e','wuyu66668','1','0','0','','0','0','1','1','0','1330351523','1','0','10','','');
INSERT INTO ts_user VALUES ('291','admin@admi1n.com','e10adc3949ba59abbe56e057f20f883e','阿百川23','1','1826','1935','湖南 怀化市','0','0','1','1','0','1330411926','1','0','10','','');
INSERT INTO ts_user VALUES ('292','anhbeu@rap.vn','2992edad96c43d506ec77b99089e1ff2','anhbeu','1','21','22','天津 天津市','0','0','1','1','0','1330432665','1','0','10','','');
INSERT INTO ts_user VALUES ('293','48607773@qq.com','0ca47d4f916e30560088c0788ae54826','随便发发','1','943','944','浙江 杭州市','0','0','1','1','0','1330438243','1','0','10','','');
INSERT INTO ts_user VALUES ('294','274850331@qq.com','2994917d5f3b4694537ac0091e838ffb','guoliang','1','471','472','辽宁 沈阳市','0','0','1','1','0','1330470557','1','0','10','','');
INSERT INTO ts_user VALUES ('295','xshangxxia@163.com','e9eb986d88c56df9360862fe6ec861a7','zkings','1','225','226','山西 太原市','0','0','1','1','0','1330475293','1','0','10','','');
INSERT INTO ts_user VALUES ('296','test2@test.com','e3ceb5881a0a1fdaad01296d7554868d','test','1','802','803','上海 上海市','0','0','1','1','0','1330482308','1','0','10','','');
INSERT INTO ts_user VALUES ('299','ainijoji@163.com','6547436690a26a399603a7096e876a2d','aaabbb','1','1','2','北京 北京市','0','0','1','1','0','1330502665','1','0','10','','');
INSERT INTO ts_user VALUES ('300','anhbeu22@aaa.com','b273e4920674aa66a9391f58f96f10a7','anhbeu22','1','0','0','','0','0','1','1','0','1330517862','1','0','10','','');
INSERT INTO ts_user VALUES ('301','22121042@qq.com','682fc4c5276d354e0430ac9ce89f8386','奇思异想','0','1374','1467','山东 威海市','0','0','1','1','0','1330523590','1','0','10','','');
INSERT INTO ts_user VALUES ('302','zhangjinguang@tom.com','37a08ed30093a133b1bb4ae0b8f3601f','caesar','1','1','2','北京 北京市','0','0','1','1','0','1330523780','1','0','10','','');
INSERT INTO ts_user VALUES ('304','Mary@126.com','161ebd7d45089b3446ee4e0d86dbcf92','Mary','1','1','2','北京 北京市','0','0','1','1','0','1330565477','1','0','10','','');
INSERT INTO ts_user VALUES ('305','yangxiao242@gmail.com','96e79218965eb72c92a549dd5a330112','2121','1','0','0','','0','0','1','1','0','1330573544','1','0','10','','');
INSERT INTO ts_user VALUES ('306','test@test.net','e3ceb5881a0a1fdaad01296d7554868d','test2','1','802','803','上海 上海市','0','0','1','1','0','1330575467','1','0','10','','');
INSERT INTO ts_user VALUES ('307','aanee@163.com','a2c3b1d364cea29dc18e7f64d1b0aa47','花儿','1','1709','1710','湖北 武汉市','0','0','1','1','0','1330590450','1','0','10','','');
INSERT INTO ts_user VALUES ('308','supercode@163.com','cbc9aed4323725019de1513f5f8ee606','Miller','1','0','0','','0','0','1','1','0','1330596099','1','0','10','','');
INSERT INTO ts_user VALUES ('310','akamai@21cn.com','3b6f1aa208650c15641b323caf5935c6','haha88','0','656','657','黑龙江 哈尔滨市','0','0','1','1','0','1330615832','1','0','10','','');
INSERT INTO ts_user VALUES ('311','beckham@gg.com','fa4ef43fb0f135c537222e2a74a5a844','beckham','1','0','0','','0','0','1','1','0','1330616739','1','0','10','','');
INSERT INTO ts_user VALUES ('312','1009975986@qq.com','e10adc3949ba59abbe56e057f20f883e','时代','1','2106','2131','广西 桂林市','0','0','1','1','0','1330662075','1','0','10','','');
INSERT INTO ts_user VALUES ('314','abc@email.com','e10adc3949ba59abbe56e057f20f883e','cool','1','1963','2090','广东 潮州市','0','0','1','1','0','1330801635','1','0','10','','');
INSERT INTO ts_user VALUES ('316','webmaster@guandongfa.com','13c6505921ee0ce2d608ab85f72a6e87','不许联想','1','1963','1964','广东 广州市','0','0','1','1','0','1330869159','1','0','10','','');
INSERT INTO ts_user VALUES ('317','123239488@qq.com','5e15ad9b16986f051d5320248b4dc3ab','逆天蝴蝶','1','0','0','','0','0','1','1','0','1330883520','1','0','10','','');
INSERT INTO ts_user VALUES ('318','opp6689@163.com','96e79218965eb72c92a549dd5a330112','opp66','1','2600','2731','云南 德宏傣族景颇族自治州','0','0','1','1','0','1330933080','1','0','10','','');
INSERT INTO ts_user VALUES ('319','xiaobingb@sohu.com','7a609ff17d80fc8b33659ce5c36f008d','xiaobingb','1','0','0','','0','0','1','1','0','1330936194','1','0','10','','');
INSERT INTO ts_user VALUES ('321','my_open@126.com','d437df002f7a5c8555c107af8a643977','wangjun','1','1','0','北京','0','0','1','1','0','1330964589','1','0','10','','');
INSERT INTO ts_user VALUES ('322','aeonhero@qq.com','79f680f3a68bb037e76dffead6be4ce4','aeonhero','1','0','0','','0','0','1','1','0','1331003329','1','0','10','','');
INSERT INTO ts_user VALUES ('323','aeonhero1@qq.com','559ff06dc366287445ccb82d92845d81','aeonhero1','1','0','0','','0','0','1','1','0','1331003828','1','0','10','','');
INSERT INTO ts_user VALUES ('324','laoke85@163.com','4297f44b13955235245b2497399d7a93','老柯','1','0','0','','0','0','1','1','0','1331013050','1','0','10','','');
INSERT INTO ts_user VALUES ('327','test@qq.com','4297f44b13955235245b2497399d7a93','test123','1','0','0','','0','0','1','1','0','1331023559','1','0','10','','');
INSERT INTO ts_user VALUES ('329','yanxx318@qq.vom','96e79218965eb72c92a549dd5a330112','yanxx318','1','0','0','','0','0','1','1','0','1331040411','1','0','10','','');
INSERT INTO ts_user VALUES ('330','woriuu123@126.com','6846860684f05029abccc09a53cd66f1','woriuu123','1','2827','2842','陕西 铜川市','0','0','1','1','0','1331043003','1','0','10','','');
INSERT INTO ts_user VALUES ('332','yanxx318@qq.com','96e79218965eb72c92a549dd5a330112','yanxx3181','1','2502','2503','贵州 贵阳市','0','0','1','1','0','1331045412','1','0','10','','');
INSERT INTO ts_user VALUES ('337','642779123@qq.com','46f94c8de14fb36680850768ff1b7f2a','123qwe','1','0','0','','0','0','1','1','0','1331124632','1','0','10','','');
INSERT INTO ts_user VALUES ('338','djlixinjie@qq.com','532db93f1193780cc33f96a1d7af3822','相伴一生','1','1963','2088','广东 东莞市','0','0','1','1','0','1331137935','1','0','10','','');
INSERT INTO ts_user VALUES ('341','amagege@126.com','e10adc3949ba59abbe56e057f20f883e','amagege','1','0','0','','0','0','1','1','0','1331179670','1','0','10','','');
INSERT INTO ts_user VALUES ('342','feawfeaw@123.com','bec9dd0735c41e7cfaa1f3b52adac860','3123123','1','0','0','','0','0','1','1','0','1331182416','1','0','10','','');
INSERT INTO ts_user VALUES ('343','h800lion@h800lion.com','29ce22faa9283fbef5d1614104e2d964','h800lion','1','0','0','','0','0','1','1','0','1331182638','1','0','10','','');
INSERT INTO ts_user VALUES ('344','zhangyanjiong@gmail.com','7def97c2f816c30022bd54cc809cd1ab','白兰地','1','802','803','上海 上海市','0','0','1','1','0','1331190803','1','0','10','','');
INSERT INTO ts_user VALUES ('348','weiweixia@gmail.com','e10adc3949ba59abbe56e057f20f883e','打架鱼','1','356','454','内蒙古 锡林郭勒盟','0','0','1','1','0','1331259065','1','0','10','','');
INSERT INTO ts_user VALUES ('349','505083030@qq.com','49e4f8eebb11153202acde598eef6dbe','是第四','1','0','0','','0','0','1','1','0','1331266414','1','0','10','','');
INSERT INTO ts_user VALUES ('350','19880720@126.com','61ceb5403a9e256237773d5a74064851','涯涯','0','1045','1054','安徽 芜湖市','0','0','1','1','0','1331267482','1','0','10','','');
INSERT INTO ts_user VALUES ('351','nameuser@foxmail.com','49e4f8eebb11153202acde598eef6dbe','dwdsa','1','0','0','','0','0','1','1','0','1331269128','1','0','10','','');
INSERT INTO ts_user VALUES ('352','admin00@36hua.cn','e10adc3949ba59abbe56e057f20f883e','Eerereetee','1','21','22','天津 天津市','0','0','1','1','0','1331269404','1','0','10','','');
INSERT INTO ts_user VALUES ('353','etetetet@qq.com','76e6a55afc9ff0843e0f8c801a51079a','etetetetet','1','41','81','河北 秦皇岛市','0','0','1','1','0','1331269483','1','0','10','','');
INSERT INTO ts_user VALUES ('355','2668869787@qq.com','71fc292dae49815ba406da4a2fd177ea','hho','1','0','0','','0','0','1','1','0','1331276803','1','0','10','','');
INSERT INTO ts_user VALUES ('358','fx2me01@163.com','5ef24f0d1fd7d3573ce3046c3056968f','雨雨','1','1','2','北京 北京市','0','0','1','1','0','1331282139','1','0','10','','');
INSERT INTO ts_user VALUES ('359','1525960310@qq.com','78247e0472852d541e45c4b27e1ccbe1','留住青春','1','1','2','北京 北京市','0','0','1','1','0','1331283265','1','0','10','','');
INSERT INTO ts_user VALUES ('363','286477468@qq.com','1db0e9dbceda5497f6b0825be7a90b25','网络世界','1','1','0','北京','0','0','1','1','0','1331287102','1','0','10','','');
INSERT INTO ts_user VALUES ('367','woriuu123@123.com','6846860684f05029abccc09a53cd66f1','woruu123','1','2746','2747','西藏 拉萨市','0','0','1','1','0','1331358599','1','0','10','','');
INSERT INTO ts_user VALUES ('368','jack@126.com','161ebd7d45089b3446ee4e0d86dbcf92','Jack','1','0','0','','0','0','1','1','0','1331384811','1','0','10','','');
INSERT INTO ts_user VALUES ('369','corporate@163.com','a1b0b83215366c24e7e23ef792c430c3','dadajian','1','1532','0','河南','0','0','1','1','0','1331392515','1','0','10','','');
INSERT INTO ts_user VALUES ('370','13532207@qq.com','eadd1983cbe2d14d81d7b217cf87a2d3','jerly','0','2945','2946','甘肃 兰州市','0','0','1','1','0','1331393059','1','0','10','','');
INSERT INTO ts_user VALUES ('371','uc23@163.com','7cbe0c71fce62035fb533f50a56db26a','ifeng','0','2600','2601','云南 昆明市','0','0','1','1','0','1331408256','1','0','10','','');
INSERT INTO ts_user VALUES ('372','td_scdma@hotmail.com','e10adc3949ba59abbe56e057f20f883e','td_scdma','1','0','0','','0','0','1','1','0','1331430513','1','0','10','','');
INSERT INTO ts_user VALUES ('374','cs@comseo.net','69cd42d73f5ebb673b787261dd629a79','haihun','1','0','0','','0','0','1','1','0','1331460116','1','0','10','','');
INSERT INTO ts_user VALUES ('377','wangtingli@yahoo.cn','e10adc3949ba59abbe56e057f20f883e','wangtingli','0','1826','1923','湖南 永州市','0','0','1','1','0','1331475235','1','0','10','','');
INSERT INTO ts_user VALUES ('378','912462430@qq.com','b232f7089b4b524372e15c45d1bd4695','x-man','1','0','0','','0','0','1','1','0','1331484144','1','0','10','','');
INSERT INTO ts_user VALUES ('379','fanruigege@163.com','3dcdce2794c35c66f0a5442e4524ebc7','altair','1','0','0','','0','0','1','1','0','1331518071','1','0','10','','');
INSERT INTO ts_user VALUES ('380','457722822@qq.com','dc483e80a7a0bd9ef71d8cf973673924','jelly','1','802','803','上海 上海市','0','0','1','1','0','1331519991','1','0','10','','');
INSERT INTO ts_user VALUES ('383','jso2008@126.com','f1137bb0649ad8315bd5d87aec9b81dd','小蜜蜂','0','21','22','天津 天津市','0','0','1','1','0','1331561389','1','0','10','','');
INSERT INTO ts_user VALUES ('384','404247330@qq.com','05d477799293979ff30b0d10c624923e','123456a','0','0','0','','0','0','1','0','0','1331601664','1','0','10','','');
INSERT INTO ts_user VALUES ('385','liguang425@163.com','1c77db54c13a4d068df2074505282e6f','lengnuan','1','2746','2756','西藏 昌都地区','0','0','1','1','0','1331609269','1','0','10','','');
INSERT INTO ts_user VALUES ('386','xiithur@gmail.com','a152e841783914146e4bcd4f39100686','测试00999','1','1709','1809','湖北 随州市','0','0','1','1','0','1331610527','1','0','10','','');
INSERT INTO ts_user VALUES ('387','1197796879@qq.com','96e79218965eb72c92a549dd5a330112','111111','1','0','0','','0','0','1','1','0','1331615074','1','0','10','','');
INSERT INTO ts_user VALUES ('389','lu6you@qq.com','e10adc3949ba59abbe56e057f20f883e','luyou','1','0','0','','0','0','1','1','0','1331624649','1','0','10','','');
INSERT INTO ts_user VALUES ('390','webcxb@gmail.com','ce96242f89e7e0144b5688e09df9d4f0','xiaobin','1','1532','1666','河南 商丘市','0','0','1','1','0','1331625455','1','0','10','','');
INSERT INTO ts_user VALUES ('392','xupper@163.com','902988c95d7f83b580fb884b4af25a78','xupper','1','0','0','','0','0','1','1','0','1331651216','1','0','10','','');
INSERT INTO ts_user VALUES ('393','soloaction@sohu.com','4297f44b13955235245b2497399d7a93','solo','1','0','0','','0','0','1','1','0','1331652198','1','0','10','','');
INSERT INTO ts_user VALUES ('395','123123@123.com','4297f44b13955235245b2497399d7a93','123123','1','0','0','','0','0','1','1','0','1331712426','1','0','10','','');
INSERT INTO ts_user VALUES ('396','111@126.com','daa6324c79e9c6f187a1321fb47fa706','zhah','1','0','0','','0','0','1','1','0','1331782957','1','0','10','','');
INSERT INTO ts_user VALUES ('397','issjackexe@gmail.com','96e79218965eb72c92a549dd5a330112','jackexe','1','0','0','','0','0','1','1','0','1331787263','1','0','10','','');
INSERT INTO ts_user VALUES ('398','536762680@qq.com','e22c58295bd85be2357c9f451296fd70','不贪睡的猪','1','0','0','','0','0','1','1','0','1331789582','1','0','10','','');
INSERT INTO ts_user VALUES ('399','weiling1989@126.com','dd6f98d0a0f8fc815275db037dfbc67a','任性的沉醉','0','0','0','','0','0','1','0','0','1331790788','1','0','10','','');
INSERT INTO ts_user VALUES ('400','2222@2222.hk','a7228ca9da5665641028a465d57ed32d','skysea','1','0','0','','0','0','1','1','0','1331795788','1','0','10','','');
INSERT INTO ts_user VALUES ('401','xjk@vip.sina.com','ae87a6ca01536105fe196c245942d722','lulutest','1','0','0','','0','0','1','1','0','1331815820','1','0','10','','');
INSERT INTO ts_user VALUES ('403','ok304@163.com','e10adc3949ba59abbe56e057f20f883e','qq121','1','21','22','天津 天津市','0','0','1','1','0','1331819330','1','0','10','','');
INSERT INTO ts_user VALUES ('405','cscs@1234.cn','e10adc3949ba59abbe56e057f20f883e','cscs','1','0','0','','0','0','1','1','0','1331880397','1','0','10','','');
INSERT INTO ts_user VALUES ('408','999000@163.com','e10adc3949ba59abbe56e057f20f883e','55555','0','0','0','','0','0','1','0','0','1331889364','1','0','10','','');
INSERT INTO ts_user VALUES ('409','test2222@36hua.cn','88ac78015b2a7a0b536c7dd679d6032d','test2222','0','0','0','','0','0','1','0','0','1331902833','1','0','10','','');
INSERT INTO ts_user VALUES ('410','test22223@36hua.cn','3459abd32a6dcb2f396feb0abd6f6437','test22223','0','0','0','','0','0','1','0','0','1331902864','1','0','10','','');
INSERT INTO ts_user VALUES ('411','verykang@163.com','5d0384127a0233fe5ee175fa5dd7106b','larry','1','1','2','北京 北京市','0','0','1','1','0','1331904031','1','0','10','','');
INSERT INTO ts_user VALUES ('412','iooio@fd.erw','dc7d10dd76b527466b2932433c35385a','hilo','1','1826','1935','湖南 怀化市','0','0','1','1','0','1331906227','1','0','10','','');
INSERT INTO ts_user VALUES ('413','324132@qq.com','c5b0dab147d177e08db50011f8bf4735','ewrqwer','1','0','0','','0','0','1','1','0','1331912152','1','0','10','','');
INSERT INTO ts_user VALUES ('414','cooq@sina.com','92f827a83c3d014e188df77448d7ca22','破冰者','1','1263','1285','江西 九江市','0','0','1','1','0','1331974924','1','0','10','','');
INSERT INTO ts_user VALUES ('415','1187656817@qq.com','5220b411b328c512d1b0b76cae3408d5','tyqm','1','0','0','','0','0','1','1','0','1331979224','1','0','10','','');
INSERT INTO ts_user VALUES ('416','zerobreaker@126.com','634c54df3e37069f6e95ac48b49c3ea5','大掌柜','1','1709','1710','湖北 武汉市','0','0','1','1','0','1331995504','1','0','10','','');
INSERT INTO ts_user VALUES ('417','339607748@qq.com','8168a3940b7f19bda847379097f6cf49','guilinhare','1','2106','2107','广西 南宁市','0','0','1','1','0','1331997067','1','0','10','','');
INSERT INTO ts_user VALUES ('418','001@qq.com','e10adc3949ba59abbe56e057f20f883e','001','1','0','0','','0','0','1','1','0','1332039475','1','0','10','','');
INSERT INTO ts_user VALUES ('419','raingna1t@vip.qq.com','e10adc3949ba59abbe56e057f20f883e','2132132134','1','0','0','','0','0','1','1','0','1332061253','1','0','10','','');
INSERT INTO ts_user VALUES ('420','sylove888@hotmail.com','dc483e80a7a0bd9ef71d8cf973673924','哎哎啊','1','1','2','北京 北京市','0','0','1','1','0','1332080731','1','0','10','','');
INSERT INTO ts_user VALUES ('421','tt@12.cnb','4297f44b13955235245b2497399d7a93','er123','1','0','0','','0','0','1','1','0','1332103479','1','0','10','','');
INSERT INTO ts_user VALUES ('422','153986222@qq.com','bb1eb17ebc8ebc4fb8c5f67acf3c8da1','风雪不归人','1','0','0','','0','0','1','1','0','1332128155','1','0','10','','');
INSERT INTO ts_user VALUES ('423','dyxin@qq.com','8f7f61e6c296996f0808d87c974aca73','dyxin','1','1826','1935','湖南 怀化市','0','0','1','1','0','1332128409','1','0','10','','');
INSERT INTO ts_user VALUES ('425','ofibjfkdsjd@163.com','94b086db738c0e937b8ff501993b4c5c','jf','1','1963','0','广东','0','0','1','1','0','1332245508','1','0','10','','');
INSERT INTO ts_user VALUES ('426','fsa@163.com','94b086db738c0e937b8ff501993b4c5c','kdks','1','356','0','内蒙古','0','0','1','1','0','1332245737','1','0','10','','');
INSERT INTO ts_user VALUES ('428','861338587@qq.com','d9a4bd4e989886a948908ea7580e559b','kathy5','0','1168','1169','福建 福州市','0','0','1','1','0','1332301842','1','0','10','','');
INSERT INTO ts_user VALUES ('429','111111@111.111','96e79218965eb72c92a549dd5a330112','11111','1','1','2','北京 北京市','0','0','1','1','0','1332302867','1','0','10','','');
INSERT INTO ts_user VALUES ('430','winson@qq.com','f1137bb0649ad8315bd5d87aec9b81dd','winson','1','41','81','河北 秦皇岛市','0','0','1','1','0','1332303905','1','0','10','','');
INSERT INTO ts_user VALUES ('431','2451302961@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','梦想2008','1','41','81','河北 秦皇岛市','0','0','1','1','0','1332310399','1','0','10','','');
INSERT INTO ts_user VALUES ('433','2451302962@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','互连你的生活','1','33','1','浙江 杭州','0','0','1','1','1','1332401314','1','0','10','','');
INSERT INTO ts_user VALUES ('434','2451302963@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','音乐分享','0','11','1000','北京','0','0','1','1','1','1332406992','1','0','10','','');
INSERT INTO ts_user VALUES ('435','2451302964@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','秦时明月','1','0','0','','0','0','1','1','1','1332424184','1','0','10','','');
INSERT INTO ts_user VALUES ('436','924345@qq.com','f0ac2a225ee61d42bdf9a82167606ee4','xunsir','1','0','0','','0','0','1','1','0','1332439798','1','0','10','','');
INSERT INTO ts_user VALUES ('437','2451302965@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','瓶子爱淘','0','35','1','福建 福州','0','0','1','1','1','1332443622','1','0','10','','');
INSERT INTO ts_user VALUES ('438','2451302966@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','xiutuo','1','0','0','中国','0','0','1','1','0','1332466716','1','0','10','','');
INSERT INTO ts_user VALUES ('439','2451302968@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','jspshiwo','1','33','1','浙江 杭州','0','0','1','1','1','1332476559','1','0','10','','');
INSERT INTO ts_user VALUES ('440','924283547@qq.com','1beb4555b6a56e183aec3b28556ab8a7','liuyu','0','0','0','','0','0','1','1','0','1332477485','1','0','10','','');
INSERT INTO ts_user VALUES ('441','2451302969@qq.com','e7b7ec59e6337b7d3495a5dc62abd9b2','FRANK开始做运动','1','31','1000','上海','0','0','1','1','1','1332478411','1','0','10','','');
INSERT INTO ts_user VALUES ('442','haidaoe@qq.com','f9f1f56ffe363b9b670d9f2a8ec808bd','小海','1','0','0','','0','0','1','1','0','1332482584','1','0','10','','');
INSERT INTO ts_user VALUES ('443','chen8998884@163.com','4297f44b13955235245b2497399d7a93','小羊羔','1','0','0','','0','0','1','1','0','1332487817','1','0','10','','');
INSERT INTO ts_user VALUES ('444','343795287@qq.com','877634ca22bd1e67cd907aacd5f77df6','啦啦','1','2257','0','重庆市','0','0','1','1','0','1332511705','1','0','10','','');
INSERT INTO ts_user VALUES ('445','tristancui@hotmail.com','da42e3b12231514376fa1be5ea966d7a','tristancui','1','1','2','北京 北京市','0','0','1','1','0','1332520716','1','0','10','','');
INSERT INTO ts_user VALUES ('447','8878@123.com','e10adc3949ba59abbe56e057f20f883e','hopefox','1','0','0','','0','0','1','1','0','1333472852','1','0','10','','');
INSERT INTO ts_user VALUES ('449','454367040@qq.com','96e79218965eb72c92a549dd5a330112','454367040','1','0','0','','0','0','1','1','0','1333537680','1','0','10','','');
INSERT INTO ts_user VALUES ('450','topshai@qq.com','81626f297bd616f8f53528a65ecdc1dd','晒晒','1','1','2','北京 北京市','0','0','1','1','0','1333963977','1','0','10','','');
INSERT INTO ts_user VALUES ('451','topshai@qq.co1m','81626f297bd616f8f53528a65ecdc1dd','晒晒1','0','1826','1948','湖南 娄底市','0','0','1','1','0','1333964131','1','0','10','','');
INSERT INTO ts_user VALUES ('452','selfmail@foxmail.com','cb21cd55e1e62c838f135557a4c1ea45','turen','1','1','2','北京 北京市','0','0','1','1','0','1334113959','1','0','10','','');
INSERT INTO ts_user VALUES ('453','zoosoo@124.com','5a7e6ddc3892d64f9a5f29447ccb57ad','zoosoo22','1','0','0','','0','0','1','1','0','1334469296','1','0','10','','');
INSERT INTO ts_user VALUES ('454','zoosoo@122.com','5a7e6ddc3892d64f9a5f29447ccb57ad','zoosoozoos','1','0','0','','0','0','1','1','0','1334469635','1','0','10','','');
INSERT INTO ts_user VALUES ('455','404696582@qq.com','2e859565704a06f448a5d97ef47c2083','joezhou','1','0','0','','0','0','1','1','0','1334564367','1','0','10','','');
INSERT INTO ts_user VALUES ('456','pwl2014@163.com','fe4aa618b8841a532e6aa8d886385e2d','boobo','1','0','0','','0','0','1','1','0','1334623777','1','0','10','','');
INSERT INTO ts_user VALUES ('457','123@123.com','613d3b9c91e9445abaeca02f2342e5a6','xyz','1','1168','1169','福建 福州市','0','0','1','1','0','1334670143','1','0','10','','');
INSERT INTO ts_user VALUES ('458','wangranghua@163.com','dab4f0f6668135b83f4c811601c213ec','halfworld','1','1709','1812','湖北 恩施土家族苗族自治州','0','0','1','1','0','1334713348','1','0','10','','');

DROP TABLE IF EXISTS ts_user_app;
CREATE TABLE `ts_user_app` (
  `user_app_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `display_order` int(5) NOT NULL DEFAULT '0',
  `ctime` int(11) DEFAULT NULL,
  PRIMARY KEY (`user_app_id`),
  KEY `display_order` (`display_order`),
  KEY `app_id` (`app_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_app VALUES ('3','5','1','0','1312013231');

DROP TABLE IF EXISTS ts_user_blacklist;
CREATE TABLE `ts_user_blacklist` (
  `uid` int(11) NOT NULL,
  `fid` int(11) NOT NULL,
  `ctime` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_user_count;
CREATE TABLE `ts_user_count` (
  `uid` int(11) NOT NULL,
  `atme` mediumint(6) NOT NULL,
  `comment` mediumint(6) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO ts_user_count VALUES ('1','0','0');
INSERT INTO ts_user_count VALUES ('67','0','1');
INSERT INTO ts_user_count VALUES ('50','1','0');
INSERT INTO ts_user_count VALUES ('56','0','1');
INSERT INTO ts_user_count VALUES ('86','1','49');
INSERT INTO ts_user_count VALUES ('85','0','39');
INSERT INTO ts_user_count VALUES ('87','0','54');
INSERT INTO ts_user_count VALUES ('126','1','0');
INSERT INTO ts_user_count VALUES ('64','2','1');
INSERT INTO ts_user_count VALUES ('167','0','1');
INSERT INTO ts_user_count VALUES ('181','1','0');
INSERT INTO ts_user_count VALUES ('191','0','0');
INSERT INTO ts_user_count VALUES ('53','0','1');
INSERT INTO ts_user_count VALUES ('77','1','0');
INSERT INTO ts_user_count VALUES ('2','0','0');
INSERT INTO ts_user_count VALUES ('224','0','0');
INSERT INTO ts_user_count VALUES ('244','0','0');
INSERT INTO ts_user_count VALUES ('263','0','0');
INSERT INTO ts_user_count VALUES ('251','3','0');
INSERT INTO ts_user_count VALUES ('233','0','0');
INSERT INTO ts_user_count VALUES ('250','0','1');
INSERT INTO ts_user_count VALUES ('257','0','1');
INSERT INTO ts_user_count VALUES ('268','5','1');
INSERT INTO ts_user_count VALUES ('252','0','0');
INSERT INTO ts_user_count VALUES ('290','2','2');
INSERT INTO ts_user_count VALUES ('247','1','1');
INSERT INTO ts_user_count VALUES ('311','2','1');
INSERT INTO ts_user_count VALUES ('373','0','0');
INSERT INTO ts_user_count VALUES ('245','2','1');
INSERT INTO ts_user_count VALUES ('380','0','0');
INSERT INTO ts_user_count VALUES ('319','0','0');
INSERT INTO ts_user_count VALUES ('439','0','1');
INSERT INTO ts_user_count VALUES ('248','1','0');

DROP TABLE IF EXISTS ts_user_group;
CREATE TABLE `ts_user_group` (
  `user_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `ctime` int(11) DEFAULT NULL,
  `icon` varchar(120) NOT NULL,
  PRIMARY KEY (`user_group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_group VALUES ('1','管理员','1291136345','v_02.gif');
INSERT INTO ts_user_group VALUES ('2','购物达人','1310834671','v_05.png');
INSERT INTO ts_user_group VALUES ('3','搭配&amp;晒货达人','1311181520','v_05.png');
INSERT INTO ts_user_group VALUES ('4','时尚达人','1311181539','v_05.png');
INSERT INTO ts_user_group VALUES ('5','海外网友','1311181556','v_05.png');
INSERT INTO ts_user_group VALUES ('6','用户测试组','1324613494','v_06.png');

DROP TABLE IF EXISTS ts_user_group_link;
CREATE TABLE `ts_user_group_link` (
  `user_gorup_link_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_id` int(11) NOT NULL,
  `user_group_title` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  PRIMARY KEY (`user_gorup_link_id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_group_link VALUES ('12','2','购物达人','191');
INSERT INTO ts_user_group_link VALUES ('28','1','管理员','431');
INSERT INTO ts_user_group_link VALUES ('36','4','时尚达人','2');

DROP TABLE IF EXISTS ts_user_group_popedom;
CREATE TABLE `ts_user_group_popedom` (
  `user_group_popedom_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_group_id` int(11) NOT NULL,
  `node_id` int(11) NOT NULL,
  PRIMARY KEY (`user_group_popedom_id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_group_popedom VALUES ('1','1','1');
INSERT INTO ts_user_group_popedom VALUES ('2','6','2');
INSERT INTO ts_user_group_popedom VALUES ('3','6','5');
INSERT INTO ts_user_group_popedom VALUES ('4','6','25');
INSERT INTO ts_user_group_popedom VALUES ('5','6','43');
INSERT INTO ts_user_group_popedom VALUES ('6','6','9');
INSERT INTO ts_user_group_popedom VALUES ('7','6','11');
INSERT INTO ts_user_group_popedom VALUES ('8','6','14');
INSERT INTO ts_user_group_popedom VALUES ('9','6','8');
INSERT INTO ts_user_group_popedom VALUES ('10','6','10');
INSERT INTO ts_user_group_popedom VALUES ('11','6','7');
INSERT INTO ts_user_group_popedom VALUES ('12','6','13');
INSERT INTO ts_user_group_popedom VALUES ('13','6','6');
INSERT INTO ts_user_group_popedom VALUES ('14','6','12');
INSERT INTO ts_user_group_popedom VALUES ('15','6','28');
INSERT INTO ts_user_group_popedom VALUES ('16','6','34');
INSERT INTO ts_user_group_popedom VALUES ('17','6','33');
INSERT INTO ts_user_group_popedom VALUES ('18','6','23');
INSERT INTO ts_user_group_popedom VALUES ('19','6','24');
INSERT INTO ts_user_group_popedom VALUES ('20','6','21');
INSERT INTO ts_user_group_popedom VALUES ('21','6','29');
INSERT INTO ts_user_group_popedom VALUES ('22','6','27');
INSERT INTO ts_user_group_popedom VALUES ('23','6','31');
INSERT INTO ts_user_group_popedom VALUES ('24','6','30');
INSERT INTO ts_user_group_popedom VALUES ('25','6','37');
INSERT INTO ts_user_group_popedom VALUES ('26','6','22');
INSERT INTO ts_user_group_popedom VALUES ('27','6','18');
INSERT INTO ts_user_group_popedom VALUES ('28','6','17');
INSERT INTO ts_user_group_popedom VALUES ('29','6','19');
INSERT INTO ts_user_group_popedom VALUES ('30','6','32');
INSERT INTO ts_user_group_popedom VALUES ('31','6','36');
INSERT INTO ts_user_group_popedom VALUES ('32','6','39');
INSERT INTO ts_user_group_popedom VALUES ('33','6','42');
INSERT INTO ts_user_group_popedom VALUES ('34','6','46');
INSERT INTO ts_user_group_popedom VALUES ('35','6','47');
INSERT INTO ts_user_group_popedom VALUES ('36','6','51');
INSERT INTO ts_user_group_popedom VALUES ('40','6','44');
INSERT INTO ts_user_group_popedom VALUES ('39','6','41');
INSERT INTO ts_user_group_popedom VALUES ('41','6','50');
INSERT INTO ts_user_group_popedom VALUES ('42','6','48');
INSERT INTO ts_user_group_popedom VALUES ('43','6','49');
INSERT INTO ts_user_group_popedom VALUES ('44','6','45');

DROP TABLE IF EXISTS ts_user_medal;
CREATE TABLE `ts_user_medal` (
  `user_medal_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `medal_id` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `data` text,
  PRIMARY KEY (`user_medal_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2128 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_medal VALUES ('1170','1','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1171','1','26','1','a:3:{s:13:\"received_time\";i:1329027422;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1172','1','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1173','1','28','1','a:3:{s:13:\"received_time\";i:1328805055;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1174','1','29','1','a:3:{s:13:\"received_time\";i:1328805371;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1175','2','25','1','a:3:{s:13:\"received_time\";i:1331102530;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1176','2','26','1','a:3:{s:13:\"received_time\";i:1329972563;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1177','2','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1178','2','28','1','a:3:{s:13:\"received_time\";i:1329109413;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1179','2','29','1','a:3:{s:13:\"received_time\";i:1333805511;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1180','230','25','1','a:3:{s:13:\"received_time\";i:1328839284;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1181','230','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1182','230','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1183','230','28','1','a:3:{s:13:\"received_time\";i:1329027584;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1184','230','29','1','a:3:{s:13:\"received_time\";i:1328839284;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1185','231','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1186','231','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1187','231','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1188','231','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1189','231','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1190','232','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1191','232','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1192','232','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1193','232','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1194','232','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1195','50','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1196','50','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1197','50','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1198','50','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1199','50','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1200','233','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1201','233','26','1','a:3:{s:13:\"received_time\";i:1329065651;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1202','233','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1203','233','28','1','a:3:{s:13:\"received_time\";i:1329053347;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1204','233','29','1','a:3:{s:13:\"received_time\";i:1328860215;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1205','234','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1206','234','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1207','234','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1208','234','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1209','234','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1210','235','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1211','235','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1212','235','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1213','235','28','1','a:3:{s:13:\"received_time\";i:1329187556;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1214','235','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1215','236','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1216','236','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1217','236','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1218','236','28','1','a:3:{s:13:\"received_time\";i:1328878966;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1219','236','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1220','238','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1221','238','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1222','238','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1223','238','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1224','238','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1225','237','25','1','a:3:{s:13:\"received_time\";i:1328967772;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1226','237','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1227','237','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1228','237','28','1','a:3:{s:13:\"received_time\";i:1328967772;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1229','237','29','1','a:3:{s:13:\"received_time\";i:1328967772;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1230','239','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1231','239','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1232','239','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1233','239','28','1','a:3:{s:13:\"received_time\";i:1328982035;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1234','239','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1235','242','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1236','242','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1237','242','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1238','242','28','1','a:3:{s:13:\"received_time\";i:1329028620;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1239','242','29','1','a:3:{s:13:\"received_time\";i:1329102421;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1240','243','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1241','243','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1242','243','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1243','243','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1244','243','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1245','244','25','1','a:3:{s:13:\"received_time\";i:1329060754;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1246','244','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1247','244','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1248','244','28','1','a:3:{s:13:\"received_time\";i:1329145814;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1249','244','29','1','a:3:{s:13:\"received_time\";i:1329060754;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1250','245','25','1','a:3:{s:13:\"received_time\";i:1329102530;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1251','245','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1252','245','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1253','245','28','1','a:3:{s:13:\"received_time\";i:1329104265;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1254','245','29','1','a:3:{s:13:\"received_time\";i:1329102530;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1255','246','25','1','a:3:{s:13:\"received_time\";i:1329106814;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1256','246','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1257','246','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1258','246','28','1','a:3:{s:13:\"received_time\";i:1329106814;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1259','246','29','1','a:3:{s:13:\"received_time\";i:1329106814;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1260','247','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1261','247','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1262','247','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1263','247','28','1','a:3:{s:13:\"received_time\";i:1329114715;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1264','247','29','1','a:3:{s:13:\"received_time\";i:1329114715;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1265','248','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1266','248','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1267','248','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1268','248','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1269','248','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1270','249','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1271','249','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1272','249','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1273','249','28','1','a:3:{s:13:\"received_time\";i:1329140494;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1274','249','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1275','250','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1276','250','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1277','250','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1278','250','28','1','a:3:{s:13:\"received_time\";i:1329146420;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1279','250','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1280','251','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1281','251','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1282','251','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1283','251','28','1','a:3:{s:13:\"received_time\";i:1329290197;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1284','251','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1285','252','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1286','252','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1287','252','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1288','252','28','1','a:3:{s:13:\"received_time\";i:1329289648;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1289','252','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1290','253','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1291','253','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1292','253','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1293','253','28','1','a:3:{s:13:\"received_time\";i:1333702858;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1294','253','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1295','255','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1296','255','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1297','255','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1298','255','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1299','255','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1300','257','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1301','257','26','1','a:3:{s:13:\"received_time\";i:1329654672;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1302','257','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1303','257','28','1','a:3:{s:13:\"received_time\";i:1329491834;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1304','257','29','1','a:3:{s:13:\"received_time\";i:1329549626;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1305','258','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1306','258','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1307','258','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1308','258','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1309','258','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1310','259','25','1','a:3:{s:13:\"received_time\";i:1329505792;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1311','259','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1312','259','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1313','259','28','1','a:3:{s:13:\"received_time\";i:1329887814;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1314','259','29','1','a:3:{s:13:\"received_time\";i:1329505792;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1320','261','25','1','a:3:{s:13:\"received_time\";i:1329569989;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1321','261','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1322','261','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1323','261','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1324','261','29','1','a:3:{s:13:\"received_time\";i:1329569989;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1325','262','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1326','262','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1327','262','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1328','262','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1329','262','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1330','263','25','1','a:3:{s:13:\"received_time\";i:1329658063;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1331','263','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1332','263','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1333','263','28','1','a:3:{s:13:\"received_time\";i:1329658461;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1334','263','29','1','a:3:{s:13:\"received_time\";i:1329658063;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1335','264','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1336','264','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1337','264','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1338','264','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1339','264','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1340','265','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1341','265','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1342','265','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1343','265','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1344','265','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1345','266','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1346','266','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1347','266','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1348','266','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1349','266','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1350','267','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1351','267','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1352','267','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1353','267','28','1','a:3:{s:13:\"received_time\";i:1329752765;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1354','267','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1355','268','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1356','268','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1357','268','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1358','268','28','1','a:3:{s:13:\"received_time\";i:1330391881;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1359','268','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1360','269','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1361','269','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1362','269','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1363','269','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1364','269','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1365','271','25','1','a:3:{s:13:\"received_time\";i:1329836151;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1366','271','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1367','271','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1368','271','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1369','271','29','1','a:3:{s:13:\"received_time\";i:1329836151;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1370','272','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1371','272','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1372','272','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1373','272','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1374','272','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1375','270','25','1','a:3:{s:13:\"received_time\";i:1329878770;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1376','270','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1377','270','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1378','270','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1379','270','29','1','a:3:{s:13:\"received_time\";i:1329878770;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1380','104','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1381','104','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1382','104','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1383','104','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1384','104','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1385','274','25','1','a:3:{s:13:\"received_time\";i:1329920102;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1386','274','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1387','274','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1388','274','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1389','274','29','1','a:3:{s:13:\"received_time\";i:1329920102;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1390','273','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1391','273','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1392','273','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1393','273','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1394','273','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1395','275','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1396','275','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1397','275','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1398','275','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1399','275','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1400','277','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1401','277','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1402','277','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1403','277','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1404','277','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1405','279','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1406','279','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1407','279','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1408','279','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1409','279','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1415','281','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1416','281','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1417','281','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1418','281','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1419','281','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1420','282','25','1','a:3:{s:13:\"received_time\";i:1330069508;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1421','282','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1422','282','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1423','282','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1424','282','29','1','a:3:{s:13:\"received_time\";i:1330069508;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1425','284','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1426','284','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1427','284','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1428','284','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1429','284','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1430','286','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1431','286','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1432','286','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1433','286','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1434','286','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1440','287','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1441','287','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1442','287','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1443','287','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1444','287','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1445','288','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1446','288','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1447','288','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1448','288','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1449','288','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1450','289','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1451','289','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1452','289','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1453','289','28','1','a:3:{s:13:\"received_time\";i:1330329228;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1454','289','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1455','290','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1456','290','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1457','290','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1458','290','28','1','a:3:{s:13:\"received_time\";i:1330697205;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1459','290','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1460','292','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1461','292','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1462','292','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1463','292','28','1','a:3:{s:13:\"received_time\";i:1330751318;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1464','292','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1465','293','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1466','293','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1467','293','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1468','293','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1469','293','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1470','295','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1471','295','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1472','295','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1473','295','28','1','a:3:{s:13:\"received_time\";i:1330504155;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1474','295','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1480','296','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1481','296','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1482','296','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1483','296','28','1','a:3:{s:13:\"received_time\";i:1330482570;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1484','296','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1485','298','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1486','298','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1487','298','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1488','298','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1489','298','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1490','299','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1491','299','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1492','299','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1493','299','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1494','299','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1500','133','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1501','133','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1502','133','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1503','133','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1504','133','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1505','300','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1506','300','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1507','300','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1508','300','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1509','300','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1510','301','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1511','301','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1512','301','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1513','301','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1514','301','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1515','302','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1516','302','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1517','302','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1518','302','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1519','302','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1520','304','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1521','304','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1522','304','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1523','304','28','1','a:3:{s:13:\"received_time\";i:1331969953;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1524','304','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1525','305','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1526','305','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1527','305','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1528','305','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1529','305','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1530','306','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1531','306','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1532','306','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1533','306','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1534','306','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1535','308','25','1','a:3:{s:13:\"received_time\";i:1330596840;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1536','308','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1537','308','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1538','308','28','1','a:3:{s:13:\"received_time\";i:1330596693;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1539','308','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1545','309','25','1','a:3:{s:13:\"received_time\";i:1330612903;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1546','309','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1547','309','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1548','309','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1549','309','29','1','a:3:{s:13:\"received_time\";i:1330612903;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1550','310','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1551','310','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1552','310','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1553','310','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1554','310','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1555','311','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1556','311','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1557','311','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1558','311','28','1','a:3:{s:13:\"received_time\";i:1330845110;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1559','311','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1560','312','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1561','312','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1562','312','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1563','312','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1564','312','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1565','316','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1566','316','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1567','316','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1568','316','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1569','316','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1570','317','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1571','317','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1572','317','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1573','317','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1574','317','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1575','318','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1576','318','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1577','318','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1578','318','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1579','318','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1580','320','25','1','a:3:{s:13:\"received_time\";i:1330940254;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1581','320','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1582','320','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1583','320','28','1','a:3:{s:13:\"received_time\";i:1330941986;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1584','320','29','1','a:3:{s:13:\"received_time\";i:1330940254;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1585','321','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1586','321','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1587','321','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1588','321','28','1','a:3:{s:13:\"received_time\";i:1330964874;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1589','321','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1590','322','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1591','322','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1592','322','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1593','322','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1594','322','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1595','324','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1596','324','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1597','324','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1598','324','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1599','324','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1600','327','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1601','327','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1602','327','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1603','327','28','1','a:3:{s:13:\"received_time\";i:1331023651;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1604','327','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1605','328','25','1','a:3:{s:13:\"received_time\";i:1331028511;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1606','328','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1607','328','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1608','328','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1609','328','29','1','a:3:{s:13:\"received_time\";i:1331028511;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1615','332','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1616','332','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1617','332','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1618','332','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1619','332','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1620','217','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1621','217','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1622','217','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1623','217','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1624','217','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1625','333','25','1','a:3:{s:13:\"received_time\";i:1331094197;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1626','333','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1627','333','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1628','333','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1629','333','29','1','a:3:{s:13:\"received_time\";i:1331094198;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1630','335','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1631','335','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1632','335','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1633','335','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1634','335','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1635','338','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1636','338','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1637','338','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1638','338','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1639','338','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1640','339','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1641','339','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1642','339','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1643','339','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1644','339','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1650','341','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1651','341','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1652','341','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1653','341','28','1','a:3:{s:13:\"received_time\";i:1331181876;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1654','341','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1655','342','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1656','342','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1657','342','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1658','342','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1659','342','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1660','343','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1661','343','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1662','343','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1663','343','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1664','343','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1665','344','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1666','344','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1667','344','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1668','344','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1669','344','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1670','345','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1671','345','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1672','345','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1673','345','28','1','a:3:{s:13:\"received_time\";i:1331598865;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1674','345','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1675','346','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1676','346','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1677','346','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1678','346','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1679','346','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1680','347','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1681','347','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1682','347','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1683','347','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1684','347','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1685','220','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1686','220','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1687','220','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1688','220','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1689','220','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1690','348','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1691','348','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1692','348','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1693','348','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1694','348','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1695','349','25','1','a:3:{s:13:\"received_time\";i:1331266856;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1696','349','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1697','349','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1698','349','28','1','a:3:{s:13:\"received_time\";i:1331269306;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1699','349','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1700','350','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1701','350','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1702','350','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1703','350','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1704','350','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1705','356','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1706','356','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1707','356','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1708','356','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1709','356','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1710','355','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1711','355','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1712','355','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1713','355','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1714','355','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1715','357','25','1','a:3:{s:13:\"received_time\";i:1331278990;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1716','357','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1717','357','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1718','357','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1719','357','29','1','a:3:{s:13:\"received_time\";i:1331278990;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1720','319','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1721','319','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1722','319','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1723','319','28','1','a:3:{s:13:\"received_time\";i:1331281078;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1724','319','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1725','358','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1726','358','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1727','358','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1728','358','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1729','358','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1730','359','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1731','359','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1732','359','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1733','359','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1734','359','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1735','362','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1736','362','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1737','362','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1738','362','28','1','a:3:{s:13:\"received_time\";i:1331285705;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1739','362','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1740','363','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1741','363','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1742','363','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1743','363','28','1','a:3:{s:13:\"received_time\";i:1331395980;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1744','363','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1745','364','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1746','364','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1747','364','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1748','364','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1749','364','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1750','366','25','1','a:3:{s:13:\"received_time\";i:1331381891;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1751','366','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1752','366','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1753','366','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1754','366','29','1','a:3:{s:13:\"received_time\";i:1331381891;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1755','370','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1756','370','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1757','370','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1758','370','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1759','370','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1760','371','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1761','371','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1762','371','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1763','371','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1764','371','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1765','372','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1766','372','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1767','372','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1768','372','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1769','372','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1775','373','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1776','373','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1777','373','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1778','373','28','1','a:3:{s:13:\"received_time\";i:1331452494;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1779','373','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1780','374','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1781','374','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1782','374','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1783','374','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1784','374','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1785','368','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1786','368','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1787','368','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1788','368','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1789','368','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1790','378','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1791','378','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1792','378','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1793','378','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1794','378','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1795','380','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1796','380','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1797','380','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1798','380','28','1','a:3:{s:13:\"received_time\";i:1331520752;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1799','380','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1800','381','25','1','a:3:{s:13:\"received_time\";i:1331532094;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1801','381','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1802','381','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1803','381','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1804','381','29','1','a:3:{s:13:\"received_time\";i:1331532094;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1805','382','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1806','382','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1807','382','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1808','382','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1809','382','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1810','223','25','1','a:3:{s:13:\"received_time\";i:1331553419;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1811','223','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1812','223','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1813','223','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1814','223','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1815','383','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1816','383','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1817','383','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1818','383','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1819','383','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1820','384','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1821','384','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1822','384','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1823','384','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1824','384','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1825','385','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1826','385','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1827','385','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1828','385','28','1','a:3:{s:13:\"received_time\";i:1331609368;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1829','385','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1830','386','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1831','386','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1832','386','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1833','386','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1834','386','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1835','387','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1836','387','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1837','387','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1838','387','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1839','387','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1840','389','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1841','389','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1842','389','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1843','389','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1844','389','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1845','391','25','1','a:3:{s:13:\"received_time\";i:1331634894;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1846','391','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1847','391','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1848','391','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1849','391','29','1','a:3:{s:13:\"received_time\";i:1331634894;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1850','393','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1851','393','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1852','393','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1853','393','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1854','393','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1855','326','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1856','326','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1857','326','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1858','326','28','1','a:3:{s:13:\"received_time\";i:1331703876;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1859','326','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1860','395','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1861','395','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1862','395','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1863','395','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1864','395','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1870','397','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1871','397','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1872','397','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1873','397','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1874','397','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1875','398','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1876','398','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1877','398','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1878','398','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1879','398','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1880','400','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1881','400','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1882','400','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1883','400','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1884','400','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1885','401','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1886','401','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1887','401','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1888','401','28','1','a:3:{s:13:\"received_time\";i:1331816821;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1889','401','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1890','403','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1891','403','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1892','403','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1893','403','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1894','403','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1895','402','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1896','402','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1897','402','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1898','402','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1899','402','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1900','404','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1901','404','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1902','404','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1903','404','28','1','a:3:{s:13:\"received_time\";i:1331838509;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1904','404','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1905','405','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1906','405','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1907','405','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1908','405','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1909','405','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1910','406','25','1','a:3:{s:13:\"received_time\";i:1331883840;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1911','406','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1912','406','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1913','406','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1914','406','29','1','a:3:{s:13:\"received_time\";i:1331883840;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1915','411','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1916','411','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1917','411','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1918','411','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1919','411','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1920','412','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1921','412','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1922','412','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1923','412','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1924','412','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1925','413','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1926','413','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1927','413','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1928','413','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1929','413','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1930','414','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1931','414','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1932','414','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1933','414','28','1','a:3:{s:13:\"received_time\";i:1332056795;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1934','414','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1935','415','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1936','415','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1937','415','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1938','415','28','1','a:3:{s:13:\"received_time\";i:1331979719;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1939','415','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1940','416','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1941','416','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1942','416','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1943','416','28','1','a:3:{s:13:\"received_time\";i:1331996149;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1944','416','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1945','418','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1946','418','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1947','418','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1948','418','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1949','418','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1950','419','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1951','419','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1952','419','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1953','419','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1954','419','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1955','420','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1956','420','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1957','420','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1958','420','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1959','420','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1960','421','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1961','421','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1962','421','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1963','421','28','1','a:3:{s:13:\"received_time\";i:1332103588;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1964','421','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1965','422','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1966','422','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1967','422','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1968','422','28','1','a:3:{s:13:\"received_time\";i:1332430565;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1969','422','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1970','423','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1971','423','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1972','423','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1973','423','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1974','423','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1975','365','25','1','a:3:{s:13:\"received_time\";i:1332182644;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1976','365','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1977','365','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1978','365','28','1','a:3:{s:13:\"received_time\";i:1332182645;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1979','365','29','1','a:3:{s:13:\"received_time\";i:1332182645;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1980','424','25','1','a:3:{s:13:\"received_time\";i:1332230317;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1981','424','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1982','424','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1983','424','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1984','424','29','1','a:3:{s:13:\"received_time\";i:1332230317;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1985','425','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1986','425','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1987','425','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1988','425','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1989','425','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1990','427','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1991','427','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1992','427','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1993','427','28','1','a:3:{s:13:\"received_time\";i:1332254353;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('1994','427','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1995','429','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1996','429','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1997','429','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1998','429','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('1999','429','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2000','430','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2001','430','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2002','430','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2003','430','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2004','430','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2005','431','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2006','431','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2007','431','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2008','431','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2009','431','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2010','433','25','1','a:3:{s:13:\"received_time\";i:1332405908;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2011','433','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2012','433','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2013','433','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2014','433','29','1','a:3:{s:13:\"received_time\";i:1332405908;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2015','434','25','1','a:3:{s:13:\"received_time\";i:1332409441;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2016','434','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2017','434','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2018','434','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2019','434','29','1','a:3:{s:13:\"received_time\";i:1332409441;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2020','435','25','1','a:3:{s:13:\"received_time\";i:1332424239;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2021','435','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2022','435','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2023','435','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2024','435','29','1','a:3:{s:13:\"received_time\";i:1332424239;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2025','437','25','1','a:3:{s:13:\"received_time\";i:1332443763;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2026','437','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2027','437','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2028','437','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2029','437','29','1','a:3:{s:13:\"received_time\";i:1332443763;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2030','438','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2031','438','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2032','438','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2033','438','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2034','438','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2035','439','25','1','a:3:{s:13:\"received_time\";i:1332476607;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2036','439','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2037','439','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2038','439','28','1','a:3:{s:13:\"received_time\";i:1332476731;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2039','439','29','1','a:3:{s:13:\"received_time\";i:1332476607;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2040','441','25','1','a:3:{s:13:\"received_time\";i:1332478441;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2041','441','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2042','441','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2043','441','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2044','441','29','1','a:3:{s:13:\"received_time\";i:1332478441;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2045','442','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2046','442','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2047','442','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2048','442','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2049','442','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2050','444','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2051','444','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2052','444','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2053','444','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2054','444','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2055','445','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2056','445','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2057','445','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2058','445','28','1','a:3:{s:13:\"received_time\";i:1332521172;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2059','445','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2060','426','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2061','426','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2062','426','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2063','426','28','1','a:3:{s:13:\"received_time\";i:1332524531;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2064','426','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2065','446','25','1','a:3:{s:13:\"received_time\";i:1333469414;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2066','446','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2067','446','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2068','446','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2069','446','29','1','a:3:{s:13:\"received_time\";i:1333469414;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2070','447','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2071','447','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2072','447','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2073','447','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2074','447','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2075','448','25','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:118:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=bind#sina\">绑定</a> 新浪微博, 做新浪达人\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2076','448','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2077','448','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2078','448','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2079','448','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2080','449','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2081','449','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2082','449','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2083','449','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2084','450','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2085','450','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2086','450','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2087','450','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2088','219','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2089','219','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2090','219','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2091','219','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2092','31','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2093','31','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2094','31','28','1','a:3:{s:13:\"received_time\";i:1334283317;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2095','31','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2096','452','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2097','452','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2098','452','28','1','a:3:{s:13:\"received_time\";i:1334282778;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2099','452','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2100','453','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2101','453','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2102','453','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2103','453','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2104','454','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2105','454','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2106','454','28','1','a:3:{s:13:\"received_time\";i:1334470464;s:13:\"alert_message\";s:0:\"\";s:11:\"is_alert_on\";i:0;}');
INSERT INTO ts_user_medal VALUES ('2107','454','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2108','455','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2109','455','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2110','455','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2111','455','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2112','337','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2113','337','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2114','337','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2115','337','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2116','456','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2117','456','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2118','456','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2119','456','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2120','457','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2121','457','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2122','457','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2123','457','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2124','458','26','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:106:\"你是微博控么? <a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=medal\">Show Me!</a>\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2125','458','27','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:41:\"连续30天发布微博获微博控勋章\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2126','458','28','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:48:\"发布第一条微博，得绝版纪念勋章！\";s:11:\"is_alert_on\";i:1;}');
INSERT INTO ts_user_medal VALUES ('2127','458','29','1','a:3:{s:13:\"received_time\";i:0;s:13:\"alert_message\";s:124:\"<a href=\"http://zhimei.36hua.cn/index.php?app=home&mod=Account&act=index#face\">上传头像</a>, 做有头有脸的好公民\";s:11:\"is_alert_on\";i:1;}');

DROP TABLE IF EXISTS ts_user_online;
CREATE TABLE `ts_user_online` (
  `uid` int(11) NOT NULL,
  `ctime` int(11) NOT NULL,
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO ts_user_online VALUES ('1','1342160909');
INSERT INTO ts_user_online VALUES ('2','1334671935');
INSERT INTO ts_user_online VALUES ('418','1332042995');
INSERT INTO ts_user_online VALUES ('417','1332000284');
INSERT INTO ts_user_online VALUES ('414','1331975838');
INSERT INTO ts_user_online VALUES ('31','1334582393');
INSERT INTO ts_user_online VALUES ('32','1311420232');
INSERT INTO ts_user_online VALUES ('33','1311420362');
INSERT INTO ts_user_online VALUES ('34','1311420452');
INSERT INTO ts_user_online VALUES ('35','1311420456');
INSERT INTO ts_user_online VALUES ('36','1311420544');
INSERT INTO ts_user_online VALUES ('37','1311420563');
INSERT INTO ts_user_online VALUES ('38','1311420724');
INSERT INTO ts_user_online VALUES ('39','1311420792');
INSERT INTO ts_user_online VALUES ('40','1311420971');
INSERT INTO ts_user_online VALUES ('41','1311421025');
INSERT INTO ts_user_online VALUES ('42','1311421816');
INSERT INTO ts_user_online VALUES ('43','1311421193');
INSERT INTO ts_user_online VALUES ('44','1311422260');
INSERT INTO ts_user_online VALUES ('45','1311425173');
INSERT INTO ts_user_online VALUES ('46','1311425640');
INSERT INTO ts_user_online VALUES ('47','1311505390');
INSERT INTO ts_user_online VALUES ('48','1311426537');
INSERT INTO ts_user_online VALUES ('49','1311427057');
INSERT INTO ts_user_online VALUES ('50','1331805543');
INSERT INTO ts_user_online VALUES ('51','1311427580');
INSERT INTO ts_user_online VALUES ('52','1311428037');
INSERT INTO ts_user_online VALUES ('53','1311429773');
INSERT INTO ts_user_online VALUES ('66','1311504379');
INSERT INTO ts_user_online VALUES ('55','1311430052');
INSERT INTO ts_user_online VALUES ('56','1311431019');
INSERT INTO ts_user_online VALUES ('57','1311438422');
INSERT INTO ts_user_online VALUES ('58','1311485780');
INSERT INTO ts_user_online VALUES ('64','1314606775');
INSERT INTO ts_user_online VALUES ('59','1311481478');
INSERT INTO ts_user_online VALUES ('191','1317407400');
INSERT INTO ts_user_online VALUES ('60','1311487144');
INSERT INTO ts_user_online VALUES ('61','1311486623');
INSERT INTO ts_user_online VALUES ('62','1311523403');
INSERT INTO ts_user_online VALUES ('63','1311488108');
INSERT INTO ts_user_online VALUES ('192','1316266189');
INSERT INTO ts_user_online VALUES ('65','1311504613');
INSERT INTO ts_user_online VALUES ('67','1311499971');
INSERT INTO ts_user_online VALUES ('68','1311504051');
INSERT INTO ts_user_online VALUES ('69','1311502678');
INSERT INTO ts_user_online VALUES ('70','1311501576');
INSERT INTO ts_user_online VALUES ('71','1311501919');
INSERT INTO ts_user_online VALUES ('72','1311504213');
INSERT INTO ts_user_online VALUES ('74','1311505815');
INSERT INTO ts_user_online VALUES ('75','1311510173');
INSERT INTO ts_user_online VALUES ('76','1311521872');
INSERT INTO ts_user_online VALUES ('77','1311523076');
INSERT INTO ts_user_online VALUES ('78','1311522983');
INSERT INTO ts_user_online VALUES ('79','1311524816');
INSERT INTO ts_user_online VALUES ('80','1311531525');
INSERT INTO ts_user_online VALUES ('193','1316613874');
INSERT INTO ts_user_online VALUES ('446','1333470736');
INSERT INTO ts_user_online VALUES ('82','1314851609');
INSERT INTO ts_user_online VALUES ('83','1311556142');
INSERT INTO ts_user_online VALUES ('84','1311561356');
INSERT INTO ts_user_online VALUES ('85','1311561446');
INSERT INTO ts_user_online VALUES ('86','1311561247');
INSERT INTO ts_user_online VALUES ('87','1311560008');
INSERT INTO ts_user_online VALUES ('88','1311559123');
INSERT INTO ts_user_online VALUES ('89','1311560053');
INSERT INTO ts_user_online VALUES ('90','1311559179');
INSERT INTO ts_user_online VALUES ('91','1311561347');
INSERT INTO ts_user_online VALUES ('195','1316401657');
INSERT INTO ts_user_online VALUES ('267','1329752808');
INSERT INTO ts_user_online VALUES ('92','1313634395');
INSERT INTO ts_user_online VALUES ('233','1331614547');
INSERT INTO ts_user_online VALUES ('307','1330595855');
INSERT INTO ts_user_online VALUES ('93','1313737224');
INSERT INTO ts_user_online VALUES ('94','1313744689');
INSERT INTO ts_user_online VALUES ('95','1313740322');
INSERT INTO ts_user_online VALUES ('96','1313745419');
INSERT INTO ts_user_online VALUES ('97','1313767307');
INSERT INTO ts_user_online VALUES ('101','1317307502');
INSERT INTO ts_user_online VALUES ('153','1315288394');
INSERT INTO ts_user_online VALUES ('315','1330809753');
INSERT INTO ts_user_online VALUES ('98','1315639758');
INSERT INTO ts_user_online VALUES ('102','1314000363');
INSERT INTO ts_user_online VALUES ('99','1313859237');
INSERT INTO ts_user_online VALUES ('100','1313877470');
INSERT INTO ts_user_online VALUES ('103','1314002692');
INSERT INTO ts_user_online VALUES ('322','1331013481');
INSERT INTO ts_user_online VALUES ('323','1331006902');
INSERT INTO ts_user_online VALUES ('324','1331013050');
INSERT INTO ts_user_online VALUES ('263','1330543727');
INSERT INTO ts_user_online VALUES ('107','1314144270');
INSERT INTO ts_user_online VALUES ('328','1331028495');
INSERT INTO ts_user_online VALUES ('329','1331040412');
INSERT INTO ts_user_online VALUES ('104','1314097688');
INSERT INTO ts_user_online VALUES ('330','1331043004');
INSERT INTO ts_user_online VALUES ('105','1314192899');
INSERT INTO ts_user_online VALUES ('106','1314101581');
INSERT INTO ts_user_online VALUES ('327','1331023559');
INSERT INTO ts_user_online VALUES ('332','1331046025');
INSERT INTO ts_user_online VALUES ('335','1331106539');
INSERT INTO ts_user_online VALUES ('109','1314209128');
INSERT INTO ts_user_online VALUES ('336','1331110504');
INSERT INTO ts_user_online VALUES ('111','1314175630');
INSERT INTO ts_user_online VALUES ('112','1314958357');
INSERT INTO ts_user_online VALUES ('205','1316788488');
INSERT INTO ts_user_online VALUES ('113','1314279785');
INSERT INTO ts_user_online VALUES ('341','1331182513');
INSERT INTO ts_user_online VALUES ('342','1331182417');
INSERT INTO ts_user_online VALUES ('272','1329841225');
INSERT INTO ts_user_online VALUES ('349','1331470967');
INSERT INTO ts_user_online VALUES ('114','1317082790');
INSERT INTO ts_user_online VALUES ('115','1314324746');
INSERT INTO ts_user_online VALUES ('177','1315929525');
INSERT INTO ts_user_online VALUES ('120','1314460137');
INSERT INTO ts_user_online VALUES ('117','1314785203');
INSERT INTO ts_user_online VALUES ('118','1314412459');
INSERT INTO ts_user_online VALUES ('122','1314538664');
INSERT INTO ts_user_online VALUES ('123','1314575809');
INSERT INTO ts_user_online VALUES ('361','1331285208');
INSERT INTO ts_user_online VALUES ('119','1314437631');
INSERT INTO ts_user_online VALUES ('121','1314483282');
INSERT INTO ts_user_online VALUES ('362','1331988532');
INSERT INTO ts_user_online VALUES ('364','1331387850');
INSERT INTO ts_user_online VALUES ('124','1314585402');
INSERT INTO ts_user_online VALUES ('373','1331463302');
INSERT INTO ts_user_online VALUES ('374','1331460433');
INSERT INTO ts_user_online VALUES ('375','1331461687');
INSERT INTO ts_user_online VALUES ('126','1317302988');
INSERT INTO ts_user_online VALUES ('127','1314667044');
INSERT INTO ts_user_online VALUES ('378','1331488001');
INSERT INTO ts_user_online VALUES ('161','1315403335');
INSERT INTO ts_user_online VALUES ('128','1315396009');
INSERT INTO ts_user_online VALUES ('134','1314804946');
INSERT INTO ts_user_online VALUES ('129','1314719120');
INSERT INTO ts_user_online VALUES ('130','1314757966');
INSERT INTO ts_user_online VALUES ('387','1331616353');
INSERT INTO ts_user_online VALUES ('131','1314781237');
INSERT INTO ts_user_online VALUES ('132','1314782761');
INSERT INTO ts_user_online VALUES ('133','1314804016');
INSERT INTO ts_user_online VALUES ('135','1314877130');
INSERT INTO ts_user_online VALUES ('397','1331790562');
INSERT INTO ts_user_online VALUES ('136','1314865749');
INSERT INTO ts_user_online VALUES ('137','1314865975');
INSERT INTO ts_user_online VALUES ('138','1314866369');
INSERT INTO ts_user_online VALUES ('398','1331790235');
INSERT INTO ts_user_online VALUES ('399','1332215403');
INSERT INTO ts_user_online VALUES ('386','1331611215');
INSERT INTO ts_user_online VALUES ('139','1314896531');
INSERT INTO ts_user_online VALUES ('140','1314927529');
INSERT INTO ts_user_online VALUES ('141','1314942090');
INSERT INTO ts_user_online VALUES ('142','1314946700');
INSERT INTO ts_user_online VALUES ('403','1331819330');
INSERT INTO ts_user_online VALUES ('143','1314983339');
INSERT INTO ts_user_online VALUES ('144','1316188006');
INSERT INTO ts_user_online VALUES ('145','1315107474');
INSERT INTO ts_user_online VALUES ('146','1315495548');
INSERT INTO ts_user_online VALUES ('147','1315280923');
INSERT INTO ts_user_online VALUES ('148','1315122906');
INSERT INTO ts_user_online VALUES ('149','1315133842');
INSERT INTO ts_user_online VALUES ('415','1331979919');
INSERT INTO ts_user_online VALUES ('150','1315303091');
INSERT INTO ts_user_online VALUES ('416','1332476646');
INSERT INTO ts_user_online VALUES ('151','1315765391');
INSERT INTO ts_user_online VALUES ('152','1315928937');
INSERT INTO ts_user_online VALUES ('154','1316440702');
INSERT INTO ts_user_online VALUES ('422','1332128156');
INSERT INTO ts_user_online VALUES ('424','1332163144');
INSERT INTO ts_user_online VALUES ('156','1316057838');
INSERT INTO ts_user_online VALUES ('157','1316075672');
INSERT INTO ts_user_online VALUES ('158','1316086807');
INSERT INTO ts_user_online VALUES ('159','1315394539');
INSERT INTO ts_user_online VALUES ('160','1315397756');
INSERT INTO ts_user_online VALUES ('435','1332429911');
INSERT INTO ts_user_online VALUES ('436','1332442002');
INSERT INTO ts_user_online VALUES ('162','1316438025');
INSERT INTO ts_user_online VALUES ('438','1332466717');
INSERT INTO ts_user_online VALUES ('445','1332567245');
INSERT INTO ts_user_online VALUES ('163','1316136522');
INSERT INTO ts_user_online VALUES ('164','1315487582');
INSERT INTO ts_user_online VALUES ('165','1315487608');
INSERT INTO ts_user_online VALUES ('231','1328841591');
INSERT INTO ts_user_online VALUES ('447','1333472853');
INSERT INTO ts_user_online VALUES ('448','1333537340');
INSERT INTO ts_user_online VALUES ('166','1315521123');
INSERT INTO ts_user_online VALUES ('167','1315531550');
INSERT INTO ts_user_online VALUES ('168','1316610635');
INSERT INTO ts_user_online VALUES ('449','1333552678');
INSERT INTO ts_user_online VALUES ('169','1316694054');
INSERT INTO ts_user_online VALUES ('451','1333969718');
INSERT INTO ts_user_online VALUES ('454','1334706149');
INSERT INTO ts_user_online VALUES ('453','1334475224');
INSERT INTO ts_user_online VALUES ('170','1316758369');
INSERT INTO ts_user_online VALUES ('171','1315668530');
INSERT INTO ts_user_online VALUES ('450','1333963977');
INSERT INTO ts_user_online VALUES ('172','1316790065');
INSERT INTO ts_user_online VALUES ('462','1315990200');
INSERT INTO ts_user_online VALUES ('173','1315903431');
INSERT INTO ts_user_online VALUES ('174','1315906863');
INSERT INTO ts_user_online VALUES ('175','1315922601');
INSERT INTO ts_user_online VALUES ('176','1317175043');
INSERT INTO ts_user_online VALUES ('464','1315989423');
INSERT INTO ts_user_online VALUES ('178','1315972039');
INSERT INTO ts_user_online VALUES ('466','1315977176');
INSERT INTO ts_user_online VALUES ('179','1316000230');
INSERT INTO ts_user_online VALUES ('180','1316003863');
INSERT INTO ts_user_online VALUES ('181','1316015808');
INSERT INTO ts_user_online VALUES ('182','1316023166');
INSERT INTO ts_user_online VALUES ('183','1316052942');
INSERT INTO ts_user_online VALUES ('184','1316405158');
INSERT INTO ts_user_online VALUES ('185','1316137034');
INSERT INTO ts_user_online VALUES ('187','1316073146');
INSERT INTO ts_user_online VALUES ('188','1316082954');
INSERT INTO ts_user_online VALUES ('470','1316078300');
INSERT INTO ts_user_online VALUES ('473','1316148579');
INSERT INTO ts_user_online VALUES ('190','1316188457');
INSERT INTO ts_user_online VALUES ('479','1316313541');
INSERT INTO ts_user_online VALUES ('480','1316327180');
INSERT INTO ts_user_online VALUES ('481','1316335259');
INSERT INTO ts_user_online VALUES ('486','1316357451');
INSERT INTO ts_user_online VALUES ('279','1330143810');
INSERT INTO ts_user_online VALUES ('488','1316405262');
INSERT INTO ts_user_online VALUES ('196','1316457049');
INSERT INTO ts_user_online VALUES ('197','1316490578');
INSERT INTO ts_user_online VALUES ('198','1316512483');
INSERT INTO ts_user_online VALUES ('199','1316513438');
INSERT INTO ts_user_online VALUES ('200','1316514268');
INSERT INTO ts_user_online VALUES ('201','1316592470');
INSERT INTO ts_user_online VALUES ('202','1316597276');
INSERT INTO ts_user_online VALUES ('203','1316689098');
INSERT INTO ts_user_online VALUES ('204','1316770252');
INSERT INTO ts_user_online VALUES ('206','1316933709');
INSERT INTO ts_user_online VALUES ('207','1316798216');
INSERT INTO ts_user_online VALUES ('208','1317292212');
INSERT INTO ts_user_online VALUES ('209','1316841910');
INSERT INTO ts_user_online VALUES ('210','1316966037');
INSERT INTO ts_user_online VALUES ('503','1316973747');
INSERT INTO ts_user_online VALUES ('211','1316999492');
INSERT INTO ts_user_online VALUES ('212','1317008537');
INSERT INTO ts_user_online VALUES ('213','1317008975');
INSERT INTO ts_user_online VALUES ('214','1317054853');
INSERT INTO ts_user_online VALUES ('507','1317081123');
INSERT INTO ts_user_online VALUES ('215','1317193531');
INSERT INTO ts_user_online VALUES ('216','1317194342');
INSERT INTO ts_user_online VALUES ('217','1317257440');
INSERT INTO ts_user_online VALUES ('218','1317276698');
INSERT INTO ts_user_online VALUES ('219','1317283967');
INSERT INTO ts_user_online VALUES ('220','1317291322');
INSERT INTO ts_user_online VALUES ('221','1317303440');
INSERT INTO ts_user_online VALUES ('523','1317309473');
INSERT INTO ts_user_online VALUES ('222','1317309860');
INSERT INTO ts_user_online VALUES ('223','1320859140');
INSERT INTO ts_user_online VALUES ('525','1317369002');
INSERT INTO ts_user_online VALUES ('510','1317380178');
INSERT INTO ts_user_online VALUES ('224','1324223792');
INSERT INTO ts_user_online VALUES ('225','1324645249');
INSERT INTO ts_user_online VALUES ('226','1324228161');
INSERT INTO ts_user_online VALUES ('227','1324648327');
INSERT INTO ts_user_online VALUES ('228','1324649410');
INSERT INTO ts_user_online VALUES ('229','1326296672');
INSERT INTO ts_user_online VALUES ('230','1328944225');
INSERT INTO ts_user_online VALUES ('232','1332343408');
INSERT INTO ts_user_online VALUES ('234','1328862595');
INSERT INTO ts_user_online VALUES ('235','1331718553');
INSERT INTO ts_user_online VALUES ('236','1328879243');
INSERT INTO ts_user_online VALUES ('237','1331658097');
INSERT INTO ts_user_online VALUES ('238','1328963699');
INSERT INTO ts_user_online VALUES ('239','1329034558');
INSERT INTO ts_user_online VALUES ('240','1328984076');
INSERT INTO ts_user_online VALUES ('241','1329024416');
INSERT INTO ts_user_online VALUES ('242','1331720533');
INSERT INTO ts_user_online VALUES ('243','1331129398');
INSERT INTO ts_user_online VALUES ('244','1329919758');
INSERT INTO ts_user_online VALUES ('245','1331459702');
INSERT INTO ts_user_online VALUES ('246','1331702741');
INSERT INTO ts_user_online VALUES ('247','1329193918');
INSERT INTO ts_user_online VALUES ('248','1332009371');
INSERT INTO ts_user_online VALUES ('249','1329142869');
INSERT INTO ts_user_online VALUES ('250','1329148376');
INSERT INTO ts_user_online VALUES ('251','1329721520');
INSERT INTO ts_user_online VALUES ('252','1332567869');
INSERT INTO ts_user_online VALUES ('253','1333709476');
INSERT INTO ts_user_online VALUES ('254','1329331286');
INSERT INTO ts_user_online VALUES ('255','1330422212');
INSERT INTO ts_user_online VALUES ('256','1329486579');
INSERT INTO ts_user_online VALUES ('257','1329899992');
INSERT INTO ts_user_online VALUES ('258','1329491824');
INSERT INTO ts_user_online VALUES ('259','1331110704');
INSERT INTO ts_user_online VALUES ('260','1329529995');
INSERT INTO ts_user_online VALUES ('261','1332223988');
INSERT INTO ts_user_online VALUES ('262','1329742829');
INSERT INTO ts_user_online VALUES ('264','1329660758');
INSERT INTO ts_user_online VALUES ('265','1332157197');
INSERT INTO ts_user_online VALUES ('266','1330170072');
INSERT INTO ts_user_online VALUES ('268','1329795047');
INSERT INTO ts_user_online VALUES ('269','1329811503');
INSERT INTO ts_user_online VALUES ('270','1329901031');
INSERT INTO ts_user_online VALUES ('271','1329837813');
INSERT INTO ts_user_online VALUES ('273','1329893357');
INSERT INTO ts_user_online VALUES ('274','1330095600');
INSERT INTO ts_user_online VALUES ('275','1329966695');
INSERT INTO ts_user_online VALUES ('276','1329996892');
INSERT INTO ts_user_online VALUES ('277','1331187705');
INSERT INTO ts_user_online VALUES ('278','1330043457');
INSERT INTO ts_user_online VALUES ('281','1330071012');
INSERT INTO ts_user_online VALUES ('282','1330069448');
INSERT INTO ts_user_online VALUES ('283','1330173838');
INSERT INTO ts_user_online VALUES ('284','1330232199');
INSERT INTO ts_user_online VALUES ('285','1330236045');
INSERT INTO ts_user_online VALUES ('286','1330321656');
INSERT INTO ts_user_online VALUES ('287','1331092800');
INSERT INTO ts_user_online VALUES ('288','1330316800');
INSERT INTO ts_user_online VALUES ('289','1330400717');
INSERT INTO ts_user_online VALUES ('290','1331909300');
INSERT INTO ts_user_online VALUES ('291','1330412538');
INSERT INTO ts_user_online VALUES ('292','1331195357');
INSERT INTO ts_user_online VALUES ('293','1330439033');
INSERT INTO ts_user_online VALUES ('294','1330470557');
INSERT INTO ts_user_online VALUES ('295','1332267432');
INSERT INTO ts_user_online VALUES ('296','1330484571');
INSERT INTO ts_user_online VALUES ('297','1330485384');
INSERT INTO ts_user_online VALUES ('298','1330489655');
INSERT INTO ts_user_online VALUES ('299','1330502665');
INSERT INTO ts_user_online VALUES ('300','1330518163');
INSERT INTO ts_user_online VALUES ('301','1330523591');
INSERT INTO ts_user_online VALUES ('302','1330526076');
INSERT INTO ts_user_online VALUES ('303','1330525162');
INSERT INTO ts_user_online VALUES ('304','1331962629');
INSERT INTO ts_user_online VALUES ('305','1330574585');
INSERT INTO ts_user_online VALUES ('306','1330576403');
INSERT INTO ts_user_online VALUES ('308','1330941533');
INSERT INTO ts_user_online VALUES ('309','1330613723');
INSERT INTO ts_user_online VALUES ('310','1331034652');
INSERT INTO ts_user_online VALUES ('311','1330618600');
INSERT INTO ts_user_online VALUES ('312','1330662387');
INSERT INTO ts_user_online VALUES ('313','1330744984');
INSERT INTO ts_user_online VALUES ('314','1330801635');
INSERT INTO ts_user_online VALUES ('316','1330870160');
INSERT INTO ts_user_online VALUES ('317','1332558283');
INSERT INTO ts_user_online VALUES ('318','1330933382');
INSERT INTO ts_user_online VALUES ('319','1332548098');
INSERT INTO ts_user_online VALUES ('320','1332299265');
INSERT INTO ts_user_online VALUES ('321','1332567367');
INSERT INTO ts_user_online VALUES ('325','1331016928');
INSERT INTO ts_user_online VALUES ('326','1332304172');
INSERT INTO ts_user_online VALUES ('333','1331098109');
INSERT INTO ts_user_online VALUES ('334','1331094376');
INSERT INTO ts_user_online VALUES ('337','1334582288');
INSERT INTO ts_user_online VALUES ('338','1331138244');
INSERT INTO ts_user_online VALUES ('339','1331151657');
INSERT INTO ts_user_online VALUES ('343','1331183183');
INSERT INTO ts_user_online VALUES ('344','1331192194');
INSERT INTO ts_user_online VALUES ('345','1331601660');
INSERT INTO ts_user_online VALUES ('346','1331213606');
INSERT INTO ts_user_online VALUES ('347','1331216903');
INSERT INTO ts_user_online VALUES ('348','1331807777');
INSERT INTO ts_user_online VALUES ('350','1331268092');
INSERT INTO ts_user_online VALUES ('351','1331269129');
INSERT INTO ts_user_online VALUES ('352','1331270659');
INSERT INTO ts_user_online VALUES ('353','1331270553');
INSERT INTO ts_user_online VALUES ('354','1331274466');
INSERT INTO ts_user_online VALUES ('355','1331278937');
INSERT INTO ts_user_online VALUES ('356','1331283624');
INSERT INTO ts_user_online VALUES ('357','1331279299');
INSERT INTO ts_user_online VALUES ('358','1331282604');
INSERT INTO ts_user_online VALUES ('359','1331283591');
INSERT INTO ts_user_online VALUES ('360','1331284803');
INSERT INTO ts_user_online VALUES ('363','1332226706');
INSERT INTO ts_user_online VALUES ('365','1332183508');
INSERT INTO ts_user_online VALUES ('366','1331303268');
INSERT INTO ts_user_online VALUES ('367','1331359922');
INSERT INTO ts_user_online VALUES ('368','1331384811');
INSERT INTO ts_user_online VALUES ('369','1331393428');
INSERT INTO ts_user_online VALUES ('370','1331394097');
INSERT INTO ts_user_online VALUES ('371','1331408257');
INSERT INTO ts_user_online VALUES ('372','1331430513');
INSERT INTO ts_user_online VALUES ('376','1331470548');
INSERT INTO ts_user_online VALUES ('377','1331478014');
INSERT INTO ts_user_online VALUES ('379','1331518072');
INSERT INTO ts_user_online VALUES ('380','1331816231');
INSERT INTO ts_user_online VALUES ('381','1331533361');
INSERT INTO ts_user_online VALUES ('382','1331544297');
INSERT INTO ts_user_online VALUES ('383','1331567945');
INSERT INTO ts_user_online VALUES ('384','1331607267');
INSERT INTO ts_user_online VALUES ('385','1331609269');
INSERT INTO ts_user_online VALUES ('388','1331615627');
INSERT INTO ts_user_online VALUES ('389','1331624650');
INSERT INTO ts_user_online VALUES ('390','1331626867');
INSERT INTO ts_user_online VALUES ('391','1331635082');
INSERT INTO ts_user_online VALUES ('392','1331651532');
INSERT INTO ts_user_online VALUES ('393','1331655428');
INSERT INTO ts_user_online VALUES ('394','1331661404');
INSERT INTO ts_user_online VALUES ('395','1331714105');
INSERT INTO ts_user_online VALUES ('396','1331782957');
INSERT INTO ts_user_online VALUES ('400','1331801821');
INSERT INTO ts_user_online VALUES ('401','1331818595');
INSERT INTO ts_user_online VALUES ('402','1331822195');
INSERT INTO ts_user_online VALUES ('404','1331838735');
INSERT INTO ts_user_online VALUES ('405','1331881007');
INSERT INTO ts_user_online VALUES ('406','1331884112');
INSERT INTO ts_user_online VALUES ('407','1331889077');
INSERT INTO ts_user_online VALUES ('408','1331889365');
INSERT INTO ts_user_online VALUES ('409','1331902838');
INSERT INTO ts_user_online VALUES ('411','1332240054');
INSERT INTO ts_user_online VALUES ('412','1331906227');
INSERT INTO ts_user_online VALUES ('413','1331912769');
INSERT INTO ts_user_online VALUES ('419','1332062603');
INSERT INTO ts_user_online VALUES ('420','1332081036');
INSERT INTO ts_user_online VALUES ('421','1332104843');
INSERT INTO ts_user_online VALUES ('423','1332129043');
INSERT INTO ts_user_online VALUES ('425','1332245509');
INSERT INTO ts_user_online VALUES ('426','1332245737');
INSERT INTO ts_user_online VALUES ('427','1332254453');
INSERT INTO ts_user_online VALUES ('428','1332494820');
INSERT INTO ts_user_online VALUES ('429','1332303957');
INSERT INTO ts_user_online VALUES ('430','1332310110');
INSERT INTO ts_user_online VALUES ('431','1332311017');
INSERT INTO ts_user_online VALUES ('437','1332443633');
INSERT INTO ts_user_online VALUES ('433','1332406732');
INSERT INTO ts_user_online VALUES ('434','1332521810');
INSERT INTO ts_user_online VALUES ('439','1332479467');
INSERT INTO ts_user_online VALUES ('440','1332477795');
INSERT INTO ts_user_online VALUES ('441','1332478417');
INSERT INTO ts_user_online VALUES ('442','1332489559');
INSERT INTO ts_user_online VALUES ('443','1332492968');
INSERT INTO ts_user_online VALUES ('444','1332567597');
INSERT INTO ts_user_online VALUES ('452','1334154230');
INSERT INTO ts_user_online VALUES ('455','1334567375');
INSERT INTO ts_user_online VALUES ('456','1334627452');
INSERT INTO ts_user_online VALUES ('457','1334678322');
INSERT INTO ts_user_online VALUES ('458','1334717837');

DROP TABLE IF EXISTS ts_user_privacy;
CREATE TABLE `ts_user_privacy` (
  `uid` int(11) NOT NULL,
  `key` varchar(120) NOT NULL,
  `value` varchar(120) NOT NULL,
  UNIQUE KEY `key` (`key`),
  UNIQUE KEY `key_2` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_user_profile;
CREATE TABLE `ts_user_profile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `module` varchar(150) NOT NULL,
  `data` longtext,
  `type` varchar(60) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_profile VALUES ('2','1','intro','a:8:{s:4:\"name\";s:0:\"\";s:7:\"summary\";s:137:\"嘿嘿紫色的很漂亮的说。就是还没想好怎么配衣服。哈哈哈实体店买的哦。MM们不要问我地址啦。嘻嘻。\";s:11:\"nearestwish\";s:12:\"梦想中国\";s:5:\"motto\";s:12:\"梦想中国\";s:4:\"idol\";s:0:\"\";s:7:\"favbook\";s:0:\"\";s:8:\"interest\";s:0:\"\";s:5:\"blood\";s:0:\"\";}','info');
INSERT INTO ts_user_profile VALUES ('5','2','intro','a:8:{s:4:\"name\";s:0:\"\";s:7:\"summary\";s:48:\"爱生活，爱分享，分享生活中的美！\";s:11:\"nearestwish\";s:0:\"\";s:5:\"motto\";s:0:\"\";s:4:\"idol\";s:0:\"\";s:7:\"favbook\";s:0:\"\";s:8:\"interest\";s:0:\"\";s:5:\"blood\";s:0:\"\";}','info');
INSERT INTO ts_user_profile VALUES ('3','66','intro','a:8:{s:4:\"name\";s:0:\"\";s:7:\"summary\";s:12:\"好好好好\";s:11:\"nearestwish\";s:0:\"\";s:5:\"motto\";s:0:\"\";s:4:\"idol\";s:0:\"\";s:7:\"favbook\";s:0:\"\";s:8:\"interest\";s:0:\"\";s:5:\"blood\";s:0:\"\";}','info');
INSERT INTO ts_user_profile VALUES ('4','126','education','a:3:{s:6:\"school\";s:6:\"椒盐\";s:7:\"classes\";s:5:\"8541K\";s:4:\"year\";s:4:\"2006\";}','list');
INSERT INTO ts_user_profile VALUES ('6','247','intro','a:8:{s:4:\"name\";s:6:\"下海\";s:7:\"summary\";s:15:\"我是个好人\";s:11:\"nearestwish\";s:12:\"下海的家\";s:5:\"motto\";s:7:\"下海1\";s:4:\"idol\";s:7:\"下海2\";s:7:\"favbook\";s:7:\"下海3\";s:8:\"interest\";s:7:\"下海4\";s:5:\"blood\";s:1:\"b\";}','info');
INSERT INTO ts_user_profile VALUES ('7','247','contact','a:6:{s:7:\"address\";s:24:\"撒旦撒阿大撒旦撒\";s:8:\"postcode\";s:7:\"1232123\";s:8:\"telphone\";s:11:\"12321231231\";s:6:\"mobile\";s:11:\"12321231231\";s:2:\"qq\";s:4:\"1213\";s:3:\"msn\";s:0:\"\";}','info');
INSERT INTO ts_user_profile VALUES ('8','247','education','a:3:{s:6:\"school\";s:6:\"倒萨\";s:7:\"classes\";s:2:\"22\";s:4:\"year\";s:4:\"1988\";}','list');
INSERT INTO ts_user_profile VALUES ('9','247','career','a:4:{s:7:\"company\";s:15:\"阿达湿答答\";s:8:\"position\";s:6:\"市场\";s:9:\"begintime\";s:6:\"1986-1\";s:7:\"endtime\";s:6:\"2012-1\";}','list');

DROP TABLE IF EXISTS ts_user_set;
CREATE TABLE `ts_user_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldkey` varchar(120) NOT NULL,
  `fieldname` varchar(120) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `module` varchar(60) NOT NULL,
  `showspace` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_set VALUES ('3','name','名字','1','intro','1');
INSERT INTO ts_user_set VALUES ('4','summary','我的简介','1','intro','0');
INSERT INTO ts_user_set VALUES ('5','nearestwish','封面标题','1','intro','0');
INSERT INTO ts_user_set VALUES ('6','motto','座右铭','1','intro','0');
INSERT INTO ts_user_set VALUES ('7','idol','偶像','1','intro','0');
INSERT INTO ts_user_set VALUES ('8','favbook','喜欢的书','1','intro','0');
INSERT INTO ts_user_set VALUES ('9','interest','兴趣爱好','1','intro','0');
INSERT INTO ts_user_set VALUES ('10','address','地址','1','contact','0');
INSERT INTO ts_user_set VALUES ('11','postcode','邮编','1','contact','0');
INSERT INTO ts_user_set VALUES ('12','telphone','电话','1','contact','0');
INSERT INTO ts_user_set VALUES ('13','mobile','手机','1','contact','0');
INSERT INTO ts_user_set VALUES ('14','qq','QQ','1','contact','0');
INSERT INTO ts_user_set VALUES ('15','msn','MSN','1','contact','0');
INSERT INTO ts_user_set VALUES ('16','blood','血型','1','intro','0');

DROP TABLE IF EXISTS ts_user_tag;
CREATE TABLE `ts_user_tag` (
  `user_tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`user_tag_id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_tag VALUES ('1','1','3');
INSERT INTO ts_user_tag VALUES ('2','1','4');
INSERT INTO ts_user_tag VALUES ('4','1','6');
INSERT INTO ts_user_tag VALUES ('5','1','7');
INSERT INTO ts_user_tag VALUES ('6','63','7');
INSERT INTO ts_user_tag VALUES ('7','126','24');
INSERT INTO ts_user_tag VALUES ('8','126','3');
INSERT INTO ts_user_tag VALUES ('9','126','25');
INSERT INTO ts_user_tag VALUES ('10','126','16');
INSERT INTO ts_user_tag VALUES ('11','126','15');
INSERT INTO ts_user_tag VALUES ('12','142','23');
INSERT INTO ts_user_tag VALUES ('13','142','22');
INSERT INTO ts_user_tag VALUES ('14','243','13');
INSERT INTO ts_user_tag VALUES ('15','243','20');
INSERT INTO ts_user_tag VALUES ('16','243','27');
INSERT INTO ts_user_tag VALUES ('17','243','11');
INSERT INTO ts_user_tag VALUES ('18','243','4');
INSERT INTO ts_user_tag VALUES ('19','243','9');
INSERT INTO ts_user_tag VALUES ('20','243','5');
INSERT INTO ts_user_tag VALUES ('21','243','23');
INSERT INTO ts_user_tag VALUES ('22','243','24');
INSERT INTO ts_user_tag VALUES ('23','243','28');
INSERT INTO ts_user_tag VALUES ('24','247','28');
INSERT INTO ts_user_tag VALUES ('25','247','15');
INSERT INTO ts_user_tag VALUES ('26','247','18');
INSERT INTO ts_user_tag VALUES ('27','233','28');
INSERT INTO ts_user_tag VALUES ('28','233','9');
INSERT INTO ts_user_tag VALUES ('29','233','27');
INSERT INTO ts_user_tag VALUES ('30','233','6');
INSERT INTO ts_user_tag VALUES ('31','233','17');
INSERT INTO ts_user_tag VALUES ('32','233','23');
INSERT INTO ts_user_tag VALUES ('33','233','18');
INSERT INTO ts_user_tag VALUES ('34','288','27');
INSERT INTO ts_user_tag VALUES ('35','288','25');
INSERT INTO ts_user_tag VALUES ('36','288','29');
INSERT INTO ts_user_tag VALUES ('37','321','20');
INSERT INTO ts_user_tag VALUES ('38','321','25');
INSERT INTO ts_user_tag VALUES ('39','2','12');
INSERT INTO ts_user_tag VALUES ('40','2','6');
INSERT INTO ts_user_tag VALUES ('41','2','3');
INSERT INTO ts_user_tag VALUES ('42','2','9');

DROP TABLE IF EXISTS ts_user_verified;
CREATE TABLE `ts_user_verified` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `realname` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `info` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `verified` enum('0','1') CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_verified VALUES ('1','2','admin','13322969868','哎购物','哎购物','1');
INSERT INTO ts_user_verified VALUES ('3','247','下海','13476765243','我是个大好人','我是个大好人','1');

DROP TABLE IF EXISTS ts_user_visited;
CREATE TABLE `ts_user_visited` (
  `visited_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `fid` int(11) NOT NULL,
  `ctime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`visited_id`),
  UNIQUE KEY `uid_2` (`uid`,`fid`),
  KEY `uid` (`uid`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=180 DEFAULT CHARSET=utf8;

INSERT INTO ts_user_visited VALUES ('1','1','212','1320728311');
INSERT INTO ts_user_visited VALUES ('2','1','24','1320248840');
INSERT INTO ts_user_visited VALUES ('3','1','13','1321028240');
INSERT INTO ts_user_visited VALUES ('4','1','12','1323857347');
INSERT INTO ts_user_visited VALUES ('5','1','30','1321243157');
INSERT INTO ts_user_visited VALUES ('6','1','2','1334545534');
INSERT INTO ts_user_visited VALUES ('7','1','133','1330515918');
INSERT INTO ts_user_visited VALUES ('8','1','223','1326711135');
INSERT INTO ts_user_visited VALUES ('9','1','126','1326379937');
INSERT INTO ts_user_visited VALUES ('10','1','88','1322988008');
INSERT INTO ts_user_visited VALUES ('11','1','89','1323149203');
INSERT INTO ts_user_visited VALUES ('12','1','170','1322994143');
INSERT INTO ts_user_visited VALUES ('13','1','194','1322993565');
INSERT INTO ts_user_visited VALUES ('14','2','1','1332568176');
INSERT INTO ts_user_visited VALUES ('15','2','29','1323054771');
INSERT INTO ts_user_visited VALUES ('16','1','5','1324392619');
INSERT INTO ts_user_visited VALUES ('17','2','3','1331942289');
INSERT INTO ts_user_visited VALUES ('18','1','217','1323146214');
INSERT INTO ts_user_visited VALUES ('19','1','45','1323147921');
INSERT INTO ts_user_visited VALUES ('20','1','155556','1323525567');
INSERT INTO ts_user_visited VALUES ('21','1','6','1323592189');
INSERT INTO ts_user_visited VALUES ('22','1','3','1323618017');
INSERT INTO ts_user_visited VALUES ('23','224','1','1323789806');
INSERT INTO ts_user_visited VALUES ('24','1','224','1326899255');
INSERT INTO ts_user_visited VALUES ('25','1','7','1327055155');
INSERT INTO ts_user_visited VALUES ('26','1','225','1324644928');
INSERT INTO ts_user_visited VALUES ('27','228','1','1324648898');
INSERT INTO ts_user_visited VALUES ('28','1','228','1326695688');
INSERT INTO ts_user_visited VALUES ('29','229','1','1326296793');
INSERT INTO ts_user_visited VALUES ('30','229','2','1326296414');
INSERT INTO ts_user_visited VALUES ('31','229','5','1326296815');
INSERT INTO ts_user_visited VALUES ('32','1','229','1326604531');
INSERT INTO ts_user_visited VALUES ('33','1','35','1326380131');
INSERT INTO ts_user_visited VALUES ('34','1','8','1326551511');
INSERT INTO ts_user_visited VALUES ('35','1','219','1334309599');
INSERT INTO ts_user_visited VALUES ('36','1','10','1327055141');
INSERT INTO ts_user_visited VALUES ('37','1','209','1327055143');
INSERT INTO ts_user_visited VALUES ('38','230','1','1328839522');
INSERT INTO ts_user_visited VALUES ('39','232','1','1328856951');
INSERT INTO ts_user_visited VALUES ('40','233','1','1331276044');
INSERT INTO ts_user_visited VALUES ('41','233','230','1328859703');
INSERT INTO ts_user_visited VALUES ('42','235','2','1328863013');
INSERT INTO ts_user_visited VALUES ('43','235','1','1328863519');
INSERT INTO ts_user_visited VALUES ('44','237','1','1328959769');
INSERT INTO ts_user_visited VALUES ('45','1','237','1328968290');
INSERT INTO ts_user_visited VALUES ('46','239','1','1328982148');
INSERT INTO ts_user_visited VALUES ('47','2','230','1329027583');
INSERT INTO ts_user_visited VALUES ('48','1','239','1329042275');
INSERT INTO ts_user_visited VALUES ('49','1','233','1331479709');
INSERT INTO ts_user_visited VALUES ('50','242','1','1331023928');
INSERT INTO ts_user_visited VALUES ('51','247','242','1329114037');
INSERT INTO ts_user_visited VALUES ('52','243','1','1329135372');
INSERT INTO ts_user_visited VALUES ('53','250','1','1329145040');
INSERT INTO ts_user_visited VALUES ('54','233','243','1329211621');
INSERT INTO ts_user_visited VALUES ('55','252','1','1332229984');
INSERT INTO ts_user_visited VALUES ('56','252','251','1329917972');
INSERT INTO ts_user_visited VALUES ('57','2','251','1329291722');
INSERT INTO ts_user_visited VALUES ('58','1','251','1329821944');
INSERT INTO ts_user_visited VALUES ('59','252','233','1329820059');
INSERT INTO ts_user_visited VALUES ('60','259','1','1330519384');
INSERT INTO ts_user_visited VALUES ('61','259','2','1329506789');
INSERT INTO ts_user_visited VALUES ('62','252','235','1329819769');
INSERT INTO ts_user_visited VALUES ('63','2','257','1330346905');
INSERT INTO ts_user_visited VALUES ('64','1','257','1329551498');
INSERT INTO ts_user_visited VALUES ('65','252','2','1329918374');
INSERT INTO ts_user_visited VALUES ('66','252','3','1329569861');
INSERT INTO ts_user_visited VALUES ('67','252','247','1329917715');
INSERT INTO ts_user_visited VALUES ('68','266','1','1329719518');
INSERT INTO ts_user_visited VALUES ('69','267','1','1329752971');
INSERT INTO ts_user_visited VALUES ('70','233','235','1329790356');
INSERT INTO ts_user_visited VALUES ('71','233','267','1329790379');
INSERT INTO ts_user_visited VALUES ('72','252','257','1329819634');
INSERT INTO ts_user_visited VALUES ('73','2','266','1329822719');
INSERT INTO ts_user_visited VALUES ('74','271','247','1329824552');
INSERT INTO ts_user_visited VALUES ('75','271','1','1329835520');
INSERT INTO ts_user_visited VALUES ('76','233','2','1331273306');
INSERT INTO ts_user_visited VALUES ('77','233','259','1329887812');
INSERT INTO ts_user_visited VALUES ('78','2','235','1329918548');
INSERT INTO ts_user_visited VALUES ('79','244','230','1329918820');
INSERT INTO ts_user_visited VALUES ('80','244','233','1329918839');
INSERT INTO ts_user_visited VALUES ('81','2','252','1330492770');
INSERT INTO ts_user_visited VALUES ('82','244','104','1329919230');
INSERT INTO ts_user_visited VALUES ('83','244','252','1329919565');
INSERT INTO ts_user_visited VALUES ('84','2','273','1329921749');
INSERT INTO ts_user_visited VALUES ('85','2','81','1330310155');
INSERT INTO ts_user_visited VALUES ('86','2','287','1330310310');
INSERT INTO ts_user_visited VALUES ('87','1','289','1330330595');
INSERT INTO ts_user_visited VALUES ('88','233','268','1330391880');
INSERT INTO ts_user_visited VALUES ('89','291','1','1330412082');
INSERT INTO ts_user_visited VALUES ('90','2','242','1331998464');
INSERT INTO ts_user_visited VALUES ('91','2','261','1330424970');
INSERT INTO ts_user_visited VALUES ('92','294','1','1330470577');
INSERT INTO ts_user_visited VALUES ('93','295','12','1330475455');
INSERT INTO ts_user_visited VALUES ('94','297','1','1330485642');
INSERT INTO ts_user_visited VALUES ('95','295','6','1330504133');
INSERT INTO ts_user_visited VALUES ('96','263','2','1330543747');
INSERT INTO ts_user_visited VALUES ('97','308','5','1330596842');
INSERT INTO ts_user_visited VALUES ('98','311','1','1330616766');
INSERT INTO ts_user_visited VALUES ('99','310','1','1331034314');
INSERT INTO ts_user_visited VALUES ('100','313','1','1330744758');
INSERT INTO ts_user_visited VALUES ('101','2','311','1330845108');
INSERT INTO ts_user_visited VALUES ('102','316','2','1330869181');
INSERT INTO ts_user_visited VALUES ('103','2','247','1330871171');
INSERT INTO ts_user_visited VALUES ('104','318','1','1330933367');
INSERT INTO ts_user_visited VALUES ('105','2','6','1330936107');
INSERT INTO ts_user_visited VALUES ('106','320','1','1331001503');
INSERT INTO ts_user_visited VALUES ('107','2','233','1331277772');
INSERT INTO ts_user_visited VALUES ('108','325','287','1331013390');
INSERT INTO ts_user_visited VALUES ('109','329','1','1331040583');
INSERT INTO ts_user_visited VALUES ('110','1','242','1333388857');
INSERT INTO ts_user_visited VALUES ('111','332','217','1331046257');
INSERT INTO ts_user_visited VALUES ('112','333','1','1331094108');
INSERT INTO ts_user_visited VALUES ('113','2','321','1331107641');
INSERT INTO ts_user_visited VALUES ('114','336','1','1331107969');
INSERT INTO ts_user_visited VALUES ('115','252','5','1331138013');
INSERT INTO ts_user_visited VALUES ('116','1','340','1331177708');
INSERT INTO ts_user_visited VALUES ('117','341','2','1331182025');
INSERT INTO ts_user_visited VALUES ('118','343','1','1331182733');
INSERT INTO ts_user_visited VALUES ('119','2','220','1331232268');
INSERT INTO ts_user_visited VALUES ('120','348','1','1331261080');
INSERT INTO ts_user_visited VALUES ('121','350','1','1331267758');
INSERT INTO ts_user_visited VALUES ('122','349','1','1331268559');
INSERT INTO ts_user_visited VALUES ('123','357','1','1331279084');
INSERT INTO ts_user_visited VALUES ('124','235','233','1331279793');
INSERT INTO ts_user_visited VALUES ('125','361','1','1331285212');
INSERT INTO ts_user_visited VALUES ('126','362','1','1331285687');
INSERT INTO ts_user_visited VALUES ('127','364','1','1331297745');
INSERT INTO ts_user_visited VALUES ('128','2','259','1331351281');
INSERT INTO ts_user_visited VALUES ('129','2','366','1331381890');
INSERT INTO ts_user_visited VALUES ('130','2','363','1331395977');
INSERT INTO ts_user_visited VALUES ('131','2','5','1331568790');
INSERT INTO ts_user_visited VALUES ('132','372','10','1331430689');
INSERT INTO ts_user_visited VALUES ('133','374','1','1331460595');
INSERT INTO ts_user_visited VALUES ('134','376','2','1331468641');
INSERT INTO ts_user_visited VALUES ('135','2','368','1331483261');
INSERT INTO ts_user_visited VALUES ('136','2','223','1332069222');
INSERT INTO ts_user_visited VALUES ('137','388','1','1331615662');
INSERT INTO ts_user_visited VALUES ('138','391','1','1331635120');
INSERT INTO ts_user_visited VALUES ('139','395','1','1331712457');
INSERT INTO ts_user_visited VALUES ('140','2','349','1331714244');
INSERT INTO ts_user_visited VALUES ('141','50','2','1331800747');
INSERT INTO ts_user_visited VALUES ('142','401','1','1331817464');
INSERT INTO ts_user_visited VALUES ('143','402','1','1331821947');
INSERT INTO ts_user_visited VALUES ('144','405','1','1331880575');
INSERT INTO ts_user_visited VALUES ('145','1','412','1331962149');
INSERT INTO ts_user_visited VALUES ('146','1','304','1331970542');
INSERT INTO ts_user_visited VALUES ('147','1','245','1331970147');
INSERT INTO ts_user_visited VALUES ('148','417','1','1331997149');
INSERT INTO ts_user_visited VALUES ('149','416','1','1332027912');
INSERT INTO ts_user_visited VALUES ('150','2','414','1332056793');
INSERT INTO ts_user_visited VALUES ('151','363','1','1332215627');
INSERT INTO ts_user_visited VALUES ('152','2','424','1332230430');
INSERT INTO ts_user_visited VALUES ('153','2','365','1332236376');
INSERT INTO ts_user_visited VALUES ('154','429','1','1332302998');
INSERT INTO ts_user_visited VALUES ('155','429','233','1332303056');
INSERT INTO ts_user_visited VALUES ('156','1','326','1332303642');
INSERT INTO ts_user_visited VALUES ('157','430','326','1332307745');
INSERT INTO ts_user_visited VALUES ('158','430','320','1332307780');
INSERT INTO ts_user_visited VALUES ('159','431','326','1332310797');
INSERT INTO ts_user_visited VALUES ('160','431','1','1332310986');
INSERT INTO ts_user_visited VALUES ('161','2','250','1332377270');
INSERT INTO ts_user_visited VALUES ('162','433','2','1332405812');
INSERT INTO ts_user_visited VALUES ('163','2','422','1332430560');
INSERT INTO ts_user_visited VALUES ('164','416','2','1332470582');
INSERT INTO ts_user_visited VALUES ('165','439','1','1332479173');
INSERT INTO ts_user_visited VALUES ('166','2','426','1332524544');
INSERT INTO ts_user_visited VALUES ('167','1','445','1333387904');
INSERT INTO ts_user_visited VALUES ('168','253','1','1333702815');
INSERT INTO ts_user_visited VALUES ('169','1','449','1333963170');
INSERT INTO ts_user_visited VALUES ('170','450','1','1333964061');
INSERT INTO ts_user_visited VALUES ('171','451','2','1333964452');
INSERT INTO ts_user_visited VALUES ('172','1','450','1334472721');
INSERT INTO ts_user_visited VALUES ('173','1','452','1334282777');
INSERT INTO ts_user_visited VALUES ('174','1','454','1334504647');
INSERT INTO ts_user_visited VALUES ('175','1','416','1334505028');
INSERT INTO ts_user_visited VALUES ('176','1','456','1334629516');
INSERT INTO ts_user_visited VALUES ('177','1','252','1334665168');
INSERT INTO ts_user_visited VALUES ('178','457','1','1334670174');
INSERT INTO ts_user_visited VALUES ('179','458','1','1334716171');

DROP TABLE IF EXISTS ts_validation;
CREATE TABLE `ts_validation` (
  `validation_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `from_uid` int(11) NOT NULL DEFAULT '0',
  `to_user` varchar(255) NOT NULL DEFAULT '0',
  `data` text,
  `code` varchar(120) NOT NULL DEFAULT '0',
  `target_url` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `ctime` int(11) DEFAULT NULL,
  PRIMARY KEY (`validation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS ts_vote;
CREATE TABLE `ts_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `title` text NOT NULL,
  `explain` text NOT NULL,
  `type` tinyint(4) NOT NULL,
  `glimit` tinyint(4) NOT NULL DEFAULT '0',
  `deadline` int(11) NOT NULL,
  `onlyfriend` tinyint(4) NOT NULL,
  `cTime` int(11) NOT NULL,
  `isHot` varchar(1) NOT NULL,
  `rTime` int(11) NOT NULL,
  `status` varchar(1) NOT NULL,
  `vote_num` int(11) NOT NULL DEFAULT '0',
  `commentCount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO ts_vote VALUES ('1','110','1234567','','0','0','1321938000','0','1314164058','','0','','3','0');

DROP TABLE IF EXISTS ts_vote_opt;
CREATE TABLE `ts_vote_opt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vote_id` int(11) NOT NULL,
  `name` text NOT NULL,
  `num` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO ts_vote_opt VALUES ('1','1','1','1');
INSERT INTO ts_vote_opt VALUES ('2','1','2','0');
INSERT INTO ts_vote_opt VALUES ('3','1','3','2');
INSERT INTO ts_vote_opt VALUES ('4','1','4','0');
INSERT INTO ts_vote_opt VALUES ('5','1','5','0');
INSERT INTO ts_vote_opt VALUES ('6','1','6','0');
INSERT INTO ts_vote_opt VALUES ('7','1','7','0');

DROP TABLE IF EXISTS ts_vote_user;
CREATE TABLE `ts_vote_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vote_id` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `opts` text NOT NULL,
  `cTime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO ts_vote_user VALUES ('1','1','110','','1314164058');
INSERT INTO ts_vote_user VALUES ('2','1','110','1','1314164068');
INSERT INTO ts_vote_user VALUES ('3','1','272','3','1314254113');
INSERT INTO ts_vote_user VALUES ('4','1','188','3','1316082953');

DROP TABLE IF EXISTS ts_weibo;
CREATE TABLE `ts_weibo` (
  `weibo_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `content` text NOT NULL,
  `ctime` int(11) NOT NULL,
  `from` tinyint(1) NOT NULL,
  `comment` mediumint(8) NOT NULL,
  `transpond_id` int(11) NOT NULL DEFAULT '0',
  `transpond` mediumint(8) NOT NULL,
  `type` varchar(255) DEFAULT '0',
  `type_data` text,
  `from_data` text,
  `isdel` tinyint(1) NOT NULL DEFAULT '0',
  `price` int(11) NOT NULL,
  `bc_id` int(11) NOT NULL,
  `favcount` int(11) NOT NULL,
  `jiancount` int(11) NOT NULL,
  `fengcount` int(11) NOT NULL,
  `goods_url` text NOT NULL,
  `tag` text NOT NULL,
  `fenlei_input` text NOT NULL,
  PRIMARY KEY (`weibo_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2189 DEFAULT CHARSET=utf8;

INSERT INTO ts_weibo VALUES ('1012','1','今年复古风盛行，淳朴的工装外套很流行的，有徽章的设计还有点休闲的味道','1326884367','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1lrmDXcVNXXb7j7Ta_091751.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1lrmDXcVNXXb7j7Ta_091751.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1lrmDXcVNXXb7j7Ta_091751.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1lrmDXcVNXXb7j7Ta_091751.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1lrmDXcVNXXb7j7Ta_091751.jpg\";s:7:\"num_iid\";s:11:\"13338806216\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=13338806216\";s:4:\"gurl\";s:8:\"Ix3eXHRw\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:68:\"百家好类似款 貉子毛领 皮革拼接刺绣贴标军绿外套\";s:5:\"price\";s:6:\"248.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:21:\",308940647,308940646,\";s:3:\"cid\";s:8:\"50008900\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:224;}','','0','248','12','0','0','0','Ix3eXHRw','a:1:{i:0;s:6:\"衣服\";}','棉衣/棉服');
INSERT INTO ts_weibo VALUES ('1013','1','韩国 julius 聚利时 赫本范儿 复古 腕表 古着 女表 手表','1326884396','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DVyLXhRwXXau1o75_060410.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DVyLXhRwXXau1o75_060410.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DVyLXhRwXXau1o75_060410.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DVyLXhRwXXau1o75_060410.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DVyLXhRwXXau1o75_060410.jpg\";s:7:\"num_iid\";s:11:\"15025048801\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWe3T8GU6lQyt5hLBOo%2B8o5CKrm%2FIKpbN7TYdymFxIrmlhT1yRplSvaXK%2BUaanBe3ccZV8hXGS1Bm%2FpM6hhc%2FmlwiIrkT4D5uFKqA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=j8WfmMwT\";s:4:\"gurl\";s:8:\"j8WfmMwT\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:71:\"韩国 julius 聚利时 赫本范儿 复古 腕表 古着 女表 手表\";s:5:\"price\";s:5:\"95.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",401870241,433916101,\";s:3:\"cid\";s:8:\"50005700\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:315;s:10:\"commission\";s:5:\"0.715\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','95','13','1','0','0','j8WfmMwT','a:1:{i:0;s:6:\"配饰\";}','品牌手表/流行手表');
INSERT INTO ts_weibo VALUES ('1014','1','复古风持续风行，经典的手提包袋型，复古公文包设计，使用优质牛皮制作，包身硬挺，配送可调节的肩带，手提肩背两用设计，简洁中尽显高贵典雅','1326884446','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DdebXkpdXXabfLEZ_032256.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DdebXkpdXXabfLEZ_032256.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DdebXkpdXXabfLEZ_032256.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DdebXkpdXXabfLEZ_032256.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DdebXkpdXXabfLEZ_032256.jpg\";s:7:\"num_iid\";s:11:\"10354710684\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=10354710684\";s:4:\"gurl\";s:8:\"A0MtMDLw\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:67:\"2011 victoria特别开口牛皮复古公文手提包单肩斜挎包\";s:5:\"price\";s:6:\"238.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:10:\",48964120,\";s:3:\"cid\";s:8:\"50012010\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:315;}','','0','238','12','0','0','0','A0MtMDLw','a:1:{i:0;s:6:\"包包\";}','包袋');
INSERT INTO ts_weibo VALUES ('1015','1','复古铁艺手工串珠台灯','1334310704','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1VPukXnVlXXb7sfZ._112250.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1VPukXnVlXXb7sfZ._112250.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1VPukXnVlXXb7sfZ._112250.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1VPukXnVlXXb7sfZ._112250.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1VPukXnVlXXb7sfZ._112250.jpg\";s:7:\"num_iid\";s:10:\"3200373150\";s:8:\"goodsurl\";s:188:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbjJ4goZ3TyfjuNnS6xaCN7glTb9S2nQoGSAX8lYXRz3trL0BGjvxcVgO%2FKx6cJpI5ATa1shQ5hPvhY4p0ohzya2VHRCMkLV320dW&amp;p=mm_18680880_0_0&amp;n=19&amp;u=0kDhnhgI\";s:4:\"gurl\";s:8:\"0kDhnhgI\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:82:\"【潮人家】经典浪漫复古铁艺手工串珠台灯 15天包退换 送灯泡\";s:5:\"price\";s:5:\"68.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",251129709,\";s:3:\"cid\";s:8:\"50020104\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:315;s:10:\"commission\";s:3:\"1.7\";s:15:\"commission_rate\";s:1:\"5\";}','','0','68','3','0','0','0','0kDhnhgI','a:1:{i:0;s:6:\"家居\";}','装饰台灯');
INSERT INTO ts_weibo VALUES ('1017','1','日本订单 Vivi强推毛茸茸樱桃超质感蝴蝶吊球 弹簧夹ID6【22A','1326884661','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ekOEXjXtXXb6Bzg__110040.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ekOEXjXtXXb6Bzg__110040.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ekOEXjXtXXb6Bzg__110040.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ekOEXjXtXXb6Bzg__110040.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ekOEXjXtXXb6Bzg__110040.jpg\";s:7:\"num_iid\";s:11:\"13798743789\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOR8Xticoe26iKuXGuRqzUBn%2F8FLKLF5QpeeacltaEGB0rabj3BQ4VceVltfK57yc1Wb1gc%2FDaP3qeZ7zRcV3QfnEfgHepebLQuiFU%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=DlpEexTs\";s:4:\"gurl\";s:8:\"DlpEexTs\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:78:\"日本订单 Vivi强推毛茸茸樱桃超质感蝴蝶吊球 弹簧夹ID6【22A\";s:5:\"price\";s:5:\"15.50\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",416540302,426036887,406926505,\";s:3:\"cid\";s:8:\"50013878\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:315;s:10:\"commission\";s:5:\"0.115\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','15','13','1','0','0','DlpEexTs','a:1:{i:0;s:6:\"配饰\";}','发饰');
INSERT INTO ts_weibo VALUES ('1018','1','考虑中...这种裤子应该可以把小个子拉长吧~~','1326884701','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1IbV5XghwXXaOzvfa_121038.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1IbV5XghwXXaOzvfa_121038.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1IbV5XghwXXaOzvfa_121038.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1IbV5XghwXXaOzvfa_121038.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1IbV5XghwXXaOzvfa_121038.jpg\";s:7:\"num_iid\";s:10:\"9735670805\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZP7T%2Fp7Q9KRJbzvr%2BvOtZQRZnOTQtBUJrrwiko2nlobsRByVO5%2F1em8izAr%2FaiYQWoYrNFUWikfLu4xvmQ88Sa3ZhFskf1ZCpSZaIA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=LetESYQJ\";s:4:\"gurl\";s:8:\"LetESYQJ\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"欧美风 性感超显瘦高腰 修身牛仔短裤  背后系带 2011新款 女\";s:5:\"price\";s:5:\"58.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",336578322,\";s:3:\"cid\";s:6:\"162205\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:315;s:10:\"commission\";s:4:\"1.45\";s:15:\"commission_rate\";s:1:\"5\";}','','0','58','12','1','0','0','LetESYQJ','a:1:{i:0;s:6:\"衣服\";}','牛仔裤');
INSERT INTO ts_weibo VALUES ('1021','1','C家 韩国代购 独家绝美爆花裂纹石 糖果五色机器狗 锁骨链 项链','1334060580','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kemyXgXQXXb3b0EZ_032020.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kemyXgXQXXb3b0EZ_032020.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kemyXgXQXXb3b0EZ_032020.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kemyXgXQXXb3b0EZ_032020.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kemyXgXQXXb3b0EZ_032020.jpg\";s:7:\"num_iid\";s:11:\"14136112845\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=14136112845\";s:4:\"gurl\";s:8:\"sdYkmlB2\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"C家 韩国代购 独家绝美爆花裂纹石 糖果五色机器狗 锁骨链  项链\";s:5:\"price\";s:5:\"52.90\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:41:\",125780168,414380439,403176825,414380440,\";s:3:\"cid\";s:8:\"50013865\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:310;}','','0','52','13','1','0','0','sdYkmlB2','a:1:{i:0;s:6:\"配饰\";}','项链');
INSERT INTO ts_weibo VALUES ('1073','1','恶搞配音：年度荧屏大盘点——四爷很忙_生于3月13日_新浪播客http://goo.gl/YpTk9 ','1329024186','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:99:\"71027599_1361952270_aU/hH3BpB27K+l1lHz2stqkP7KQNt6nkimy1slemJwlZQ0/XM5GeY90F5yzfCdkEqDhAQ5k/d/kj3hQ\";s:8:\"flashimg\";s:43:\"http://p4.v.iask.com/770/853/71027599_2.jpg\";s:4:\"host\";s:11:\"sina.com.cn\";s:6:\"source\";s:53:\"http://video.sina.com.cn/v/b/71027599-1361952270.html\";s:5:\"title\";s:83:\"恶搞配音：年度荧屏大盘点——四爷很忙_生于3月13日_新浪播客\";s:6:\"mwidth\";i:399;s:7:\"mheight\";i:300;}','','0','0','41','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1075','1','春光灿烂猪八戒 01http://goo.gl/4M8TB ','1329025510','0','0','0','1','3','a:7:{s:8:\"flashvar\";s:13:\"XMzQzNTM4NDA4\";s:8:\"flashimg\";s:86:\"http://g2.ykimg.com/01270F1F464F168491D5780123193C4B733643-2209-F262-59D8-9A255507269A\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzQzNTM4NDA4.html\";s:5:\"title\";s:24:\"春光灿烂猪八戒 01\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:96;}','','0','0','41','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1077','242','不错的衣服','1329029153','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1.ZqMXlhnXXbeRQE._112847.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1.ZqMXlhnXXbeRQE._112847.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1.ZqMXlhnXXbeRQE._112847.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1.ZqMXlhnXXbeRQE._112847.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1.ZqMXlhnXXbeRQE._112847.jpg\";s:7:\"num_iid\";s:11:\"13950372672\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=13950372672\";s:4:\"gurl\";s:8:\"j6ozodT4\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:62:\"【品牌特卖】Jack Wolfskin 羽绒夹克 1200351 / 1200361\";s:5:\"price\";s:7:\"1999.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:81:\",424913433,304700884,329036025,327578388,267126592,304700880,431732712,336317329,\";s:3:\"cid\";s:8:\"50014798\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','1999','45','0','0','0','j6ozodT4','a:1:{i:0;s:6:\"衣服\";}','羽绒衣');
INSERT INTO ts_weibo VALUES ('1096','2','春光灿烂猪八戒 01http://goo.gl/4M8TB ','1329109374','0','0','1075','0','3','','','0','0','46','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1099','247','Hot Girls Inked - Cartatts.com / Hot #girls#inked #tattoo','1329111136','0','0','1083','0','1','','','0','0','58','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1109','247','[拍客]2.11南六公路鹿达路（奔驰4s店）交通火灾事故http://goo.gl/wCBcp  asdsa','1329116685','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzUxMzk1NzQ4\";s:8:\"flashimg\";s:86:\"http://g3.ykimg.com/0100641F464F363DE2EB1C030A6644C251FCC3-1D45-8A92-FBDC-792C229B7A54\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:48:\"http://v.youku.com/v_playlist/f17033997o1p0.html\";s:5:\"title\";s:68:\"[拍客]2.11南六公路鹿达路（奔驰4s店）交通火灾事故\";s:6:\"mwidth\";i:57;s:7:\"mheight\";i:96;}','','0','0','58','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1110','247','西施秘史 03http://goo.gl/RhUy6  阿萨德','1329116880','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzQ4NjMyMTk2\";s:8:\"flashimg\";s:86:\"http://g4.ykimg.com/01270F1F464F32786B65960123193C49DBE9DD-31FE-980F-9211-6E93E876ACD5\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzQ4NjMyMTk2.html\";s:5:\"title\";s:15:\"西施秘史 03\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:96;}','','0','0','58','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1185','233','中国人自己的货','1329719060','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1x1lOXdpDXXcJOHk3_045858.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1x1lOXdpDXXcJOHk3_045858.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1x1lOXdpDXXcJOHk3_045858.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1x1lOXdpDXXcJOHk3_045858.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1x1lOXdpDXXcJOHk3_045858.jpg\";s:7:\"num_iid\";s:10:\"9933264160\";s:8:\"goodsurl\";s:45:\"http://item.taobao.com/item.htm?id=9933264160\";s:4:\"gurl\";s:8:\"JGz6H88f\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"晶佑祥福 专柜正品 开光 天然水晶黑曜石手链108颗佛珠 男女通款\";s:5:\"price\";s:5:\"35.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:31:\",323624133,323517476,323624141,\";s:3:\"cid\";s:8:\"50013869\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','35','30','0','0','0','JGz6H88f','a:1:{i:0;s:6:\"配饰\";}','手链');
INSERT INTO ts_weibo VALUES ('1186','233','调不到他的描述吗？还是什么意思、[害羞]','1329721855','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dtuNXhXoXXcRKCva_091956.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dtuNXhXoXXcRKCva_091956.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dtuNXhXoXXcRKCva_091956.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dtuNXhXoXXcRKCva_091956.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dtuNXhXoXXcRKCva_091956.jpg\";s:7:\"num_iid\";s:11:\"13668494067\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=13668494067\";s:4:\"gurl\";s:8:\"5AKbUaYO\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:65:\"晶佑祥福 冰种黑曜石双貔貅平安扣吊坠 辟邪招财\";s:5:\"price\";s:6:\"119.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:41:\",323530350,323517476,323624140,323624141,\";s:3:\"cid\";s:8:\"50013868\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','119','30','1','0','0','5AKbUaYO','','项坠/吊坠');
INSERT INTO ts_weibo VALUES ('1220','266','2011情侣款双面磨毛抓绒加厚明星范卫衣    本款韩版加厚卫衣外套超级热卖,买了都大喊超值,回头客超多！    时尚大方的款式,男女同穿！可做情侣装！  衣衣质量很好，面料很厚实，柔软、舒适，','1329882377','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Bf5OXltsXXc6dXcY_024916.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Bf5OXltsXXc6dXcY_024916.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Bf5OXltsXXc6dXcY_024916.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Bf5OXltsXXc6dXcY_024916.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Bf5OXltsXXc6dXcY_024916.jpg\";s:7:\"num_iid\";s:11:\"13021456330\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOW1ZQEVKoY13iZ%2BzmwtUzQxWMaO91mCEfl0PWqonRCUeP%2F4XjvnhAWuF2jFB0rx2zE3AWbF9eGZEy%2BGkmvOh1a4gQGs2pXF5zcFrw%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=4nn54ucQ\";s:4:\"gurl\";s:8:\"4nn54ucQ\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:88:\"卫衣女韩版厚女秋冬女装大码冬季2012新款春装情侣装冬装加厚外套\";s:5:\"price\";s:5:\"88.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",418083094,418088216,\";s:3:\"cid\";s:8:\"50008898\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.86\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','88','87','0','0','0','4nn54ucQ','','卫衣/绒衫');
INSERT INTO ts_weibo VALUES ('1229','242','我喜欢的','1329981912','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img07.taobaocdn.com/bao/uploaded/i7/T1SyOGXoxhXXbAzGI7_063536.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img07.taobaocdn.com/bao/uploaded/i7/T1SyOGXoxhXXbAzGI7_063536.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img07.taobaocdn.com/bao/uploaded/i7/T1SyOGXoxhXXbAzGI7_063536.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img07.taobaocdn.com/bao/uploaded/i7/T1SyOGXoxhXXbAzGI7_063536.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img07.taobaocdn.com/bao/uploaded/i7/T1SyOGXoxhXXbAzGI7_063536.jpg\";s:7:\"num_iid\";s:11:\"13131246381\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=13131246381\";s:4:\"gurl\";s:8:\"VVqLJdU9\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:70:\"专柜正品11月冬款NIKE 耐克AIR MAX 90男子休闲鞋 325018-043\";s:5:\"price\";s:6:\"548.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:11:\",412051250,\";s:3:\"cid\";s:8:\"50012043\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:142;}','','0','548','54','0','0','0','VVqLJdU9','a:1:{i:0;s:6:\"鞋子\";}','板鞋/休闲鞋');
INSERT INTO ts_weibo VALUES ('1232','266','好不好你说了算。','1330170098','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pVuyXkBWXXcOs0AT_011324.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pVuyXkBWXXcOs0AT_011324.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pVuyXkBWXXcOs0AT_011324.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pVuyXkBWXXcOs0AT_011324.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pVuyXkBWXXcOs0AT_011324.jpg\";s:7:\"num_iid\";s:11:\"14115080532\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ0EvHObaYc6QeqiC3i78pGz24VLv3%2FfZ4%2BIRH5ose8lQWwEzf98HQWEj6Jxi83Ap2Je6NW9wVHvI4O86%2BovLr3lrZBRnGWvdMTz34%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=9yXiKCIn\";s:4:\"gurl\";s:8:\"9yXiKCIn\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:66:\"原单男士冲锋衣滑雪服抓绒可拆卸防水防风两件套\";s:5:\"price\";s:6:\"119.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",151623874,414693583,\";s:3:\"cid\";s:8:\"50014785\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:216;s:10:\"commission\";s:5:\"1.785\";s:15:\"commission_rate\";s:1:\"3\";}','','0','119','103','0','0','0','9yXiKCIn','','冲锋衣');
INSERT INTO ts_weibo VALUES ('1267','290','2012春夏韩版甜美淑女OL通勤休闲纯色衬衫复古带扣圆领透气棉质','1330351624','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rY9RXhNmXXcIE6ba_121542.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rY9RXhNmXXcIE6ba_121542.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rY9RXhNmXXcIE6ba_121542.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rY9RXhNmXXcIE6ba_121542.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rY9RXhNmXXcIE6ba_121542.jpg\";s:7:\"num_iid\";s:11:\"15533084085\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=15533084085\";s:4:\"gurl\";s:8:\"EoaHn2x4\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:84:\"2012春夏韩版甜美淑女OL通勤休闲纯色衬衫复古带扣圆领透气棉质\";s:5:\"price\";s:6:\"168.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:4:\"null\";s:3:\"cid\";s:6:\"162104\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','168','110','1','1','0','EoaHn2x4','','衬衫');
INSERT INTO ts_weibo VALUES ('1371','233','我这个好像有点明白了。转发应该是在微博里进行了转发吧？','1331087367','0','0','1348','0','5','','','0','0','159','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1372','1','老歌弹唱《女人花》浪客  SOCO真_南京阿毛_新浪播客http://goo.gl/1KouG ','1331094616','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:99:\"72383932_1154814690_Zky0TXA4BmHK+l1lHz2stqkP7KQNt6nkiG+ws1OgIwdZQ0/XM5GeYN4P4yDVAtkEqDhAQ5o8ff0v1B8\";s:8:\"flashimg\";s:43:\"http://p2.v.iask.com/778/337/72383932_2.jpg\";s:4:\"host\";s:11:\"sina.com.cn\";s:6:\"source\";s:53:\"http://video.sina.com.cn/v/b/72383932-1154814690.html\";s:5:\"title\";s:68:\"老歌弹唱《女人花》浪客  SOCO真_南京阿毛_新浪播客\";s:6:\"mwidth\";i:533;s:7:\"mheight\";i:300;}','','0','0','41','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1386','1','《搜狐时尚》搜狐视频直击香奈儿秀 周迅清新范姚晨秀美腿 - 搜狐视频http://goo.gl/NV0h2 ','1333803749','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:6:\"601427\";s:8:\"flashimg\";s:48:\"http://photocdn.sohu.com/20120306/vrsb467189.jpg\";s:4:\"host\";s:8:\"sohu.com\";s:6:\"source\";s:44:\"http://tv.sohu.com/20120307/n336899463.shtml\";s:5:\"title\";s:94:\"《搜狐时尚》搜狐视频直击香奈儿秀 周迅清新范姚晨秀美腿 - 搜狐视频\";s:6:\"mwidth\";i:120;s:7:\"mheight\";i:90;}','','0','0','41','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1404','347','冷处偏佳 [http://goo.gl/auG5w ]','1331216588','0','0','1312','0','1','','','0','0','174','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1411','349','陈德铭:中国在利比亚没投资 有100多亿美元的项目 - 视频 - 优酷视频 - 在线观看http://goo.gl/F5xYe  #请在这里输入自定义话题#','1331266951','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzYxOTQ3ODMy\";s:8:\"flashimg\";s:86:\"http://g3.ykimg.com/0100641F464F5714AE2BB10069FC16E011521C-76E2-34C4-BEB4-B46E414EDC6E\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzYxOTQ3ODMy.html\";s:5:\"title\";s:104:\"陈德铭:中国在利比亚没投资 有100多亿美元的项目 - 视频 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:127;s:7:\"mheight\";i:95;}','','0','0','176','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1427','363','这个不错','1331287301','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1mGKuXl8gXXa0V0wZ_032009.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1mGKuXl8gXXa0V0wZ_032009.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1mGKuXl8gXXa0V0wZ_032009.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1mGKuXl8gXXa0V0wZ_032009.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1mGKuXl8gXXa0V0wZ_032009.jpg\";s:7:\"num_iid\";s:11:\"13091539979\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOW3iiOCxY7y4Z%2FmvjXQeqT9x1tIiV9DltDEsrz%2BsDDUjUdx9QH0DTsC%2FNHZKTCz3mDUzsE3tlk2LUXpHe%2BuempgYZ8l89Fu75l2xA%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=aWmh0j9U\";s:4:\"gurl\";s:8:\"aWmh0j9U\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:77:\"艾美佳 实木相框墙 最温馨心形组合创意 照片墙20框相片墙\";s:5:\"price\";s:6:\"286.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",331124069,371115800,\";s:3:\"cid\";s:8:\"50021924\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"14.30\";s:15:\"commission_rate\";s:1:\"5\";}','','0','286','185','0','0','0','aWmh0j9U','','照片墙');
INSERT INTO ts_weibo VALUES ('1428','363','照片墙','1331287569','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Du9CXdlNXXXksUw__111015.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Du9CXdlNXXXksUw__111015.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Du9CXdlNXXXksUw__111015.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Du9CXdlNXXXksUw__111015.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1Du9CXdlNXXXksUw__111015.jpg\";s:7:\"num_iid\";s:11:\"13243168199\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOU6PWp0G3y5eSO%2BlgBOtvKJoKcevn%2FqoMeZkBUwy0bmSyGOH0Zv5AGITgMKGIjB%2BI4PH%2BJ6yZd%2FGpcNBG1ZK1kJjr1ulhYAo3YyJw%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=opufZxR5\";s:4:\"gurl\";s:8:\"opufZxR5\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"梓晨 实木照片墙 适合大墙面 爱心形相片墙 创意相框墙 HD-028\";s:5:\"price\";s:6:\"398.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:81:\",299882747,299882746,299882748,299882752,382582618,382582630,382582629,382582626,\";s:3:\"cid\";s:8:\"50021924\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"39.80\";s:15:\"commission_rate\";s:2:\"10\";}','','0','398','185','0','0','0','opufZxR5','a:2:{i:0;s:0:\"\";i:1;s:6:\"配饰\";}','照片墙');
INSERT INTO ts_weibo VALUES ('1431','365','2012春装新款宽松中袖衬衫亚麻棉春夏长款衬衫女装韩版时尚衬衣-tmall.com天猫','1331297922','5','0','0','0','1','a:6:{s:8:\"thumburl\";s:39:\"2012/0309/20/1331297921192617_small.jpg\";s:14:\"thumbhaibaourl\";s:40:\"2012/0309/20/1331297921192617_haibao.jpg\";s:14:\"thumbmiddleurl\";s:40:\"2012/0309/20/1331297921192617_middle.jpg\";s:6:\"picurl\";s:33:\"2012/0309/20/1331297921192617.jpg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:200;}','http://detail.tmall.com/item.htm?id=7195837007&cm_cat=162104&source=dou','0','0','186','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1441','364','#减肥茶#[可爱]','1331384834','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T176mQXghiXXaUzjw8_100907.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T176mQXghiXXaUzjw8_100907.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T176mQXghiXXaUzjw8_100907.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T176mQXghiXXaUzjw8_100907.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T176mQXghiXXaUzjw8_100907.jpg\";s:7:\"num_iid\";s:10:\"5014015371\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTaEBfNBFFAL9%2BLIMcCgnqbkIfLSmbQsPZKdYwhVcouBwT3Mgy5lR2WDHUnBQtQtsj7mPmRCW8BkeuwipjXysLpxUfDdNuhLscoaYn0A%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=uZIzoi33\";s:4:\"gurl\";s:8:\"uZIzoi33\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"碧生源减肥茶正品 瘦身 25袋/盒*2盒送5袋装 小Q杯 减 淝 包邮\";s:5:\"price\";s:5:\"85.60\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",403355753,403340432,403355765,403333450,403355760,403355762,\";s:3:\"cid\";s:8:\"50020276\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"15.41\";s:15:\"commission_rate\";s:2:\"18\";}','','0','86','191','0','0','0','uZIzoi33','','品牌保健品');
INSERT INTO ts_weibo VALUES ('1442','371','NBA-林书豪20+13 尼克斯114-119负雄鹿遭4连败 - [战报]林书豪20+13斯瓜合砍49分 尼克斯负雄鹿4连败 - 视频 - 优酷视频 - 在线观看http://goo.gl/4uOpu ','1331408394','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzYzNDc2OTMy\";s:8:\"flashimg\";s:86:\"http://g2.ykimg.com/0100641F464F5AF701D6AB00355E30FDBB0CE2-666E-489C-C932-0F8E2C06A2D4\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:48:\"http://v.youku.com/v_playlist/f17149164o1p0.html\";s:5:\"title\";s:161:\"NBA-林书豪20+13 尼克斯114-119负雄鹿遭4连败 - [战报]林书豪20+13斯瓜合砍49分 尼克斯负雄鹿4连败 - 视频 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:96;}','','0','0','194','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1443','1','20110905东西宫略拜神（郭晋安BLOG）http://goo.gl/8Kw6k  [呲牙]','1331436215','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:11:\"w0WCIjk8Umo\";s:8:\"flashimg\";s:37:\"http://i4.tdimg.com/099/383/527/p.jpg\";s:4:\"host\";s:9:\"tudou.com\";s:6:\"source\";s:55:\"http://www.tudou.com/programs/view/w0WCIjk8Umo/?fr=rec2\";s:5:\"title\";s:45:\"20110905东西宫略拜神（郭晋安BLOG）\";s:6:\"mwidth\";i:132;s:7:\"mheight\";i:99;}','','0','0','41','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1491','326','实拍玛丽·奥斯蒙德自己在舞台上撒.尿 在线观看 - 酷6视频http://goo.gl/VItnk ','1331709949','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:24:\"TLg2QXpOmm8PxMu9ty5EYg..\";s:8:\"flashimg\";s:91:\"http://vi0.ku6img.com/data1/p5//ku6video/2012/3/13/23/1334881290212_18416052_18416052/3.jpg\";s:4:\"host\";s:7:\"ku6.com\";s:6:\"source\";s:51:\"http://v.ku6.com/show/TLg2QXpOmm8PxMu9ty5EYg...html\";s:5:\"title\";s:77:\"实拍玛丽·奥斯蒙德自己在舞台上撒.尿 在线观看 - 酷6视频\";s:6:\"mwidth\";i:132;s:7:\"mheight\";i:99;}','','0','0','166','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1498','326','感动生命 - 第13集 - 2012 - 电视剧 - 优酷视频 - 在线观看http://goo.gl/taigk ','1331787054','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzU1NTg5MDYw\";s:8:\"flashimg\";s:86:\"http://g1.ykimg.com/01270F1F464F477B4CB2FB0123193C614BAB47-A6CD-1667-1F16-A8C77956A7A0\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzU1NTg5MDYw.html\";s:5:\"title\";s:72:\"感动生命 - 第13集 - 2012 - 电视剧 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:95;}','','0','0','166','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1503','401','饿很难怕夺爱的饿很难怕夺爱的饿很难怕夺爱的','1331817310','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tPWTXXpoXXXCeLzX_084838.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tPWTXXpoXXXCeLzX_084838.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tPWTXXpoXXXCeLzX_084838.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tPWTXXpoXXXCeLzX_084838.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tPWTXXpoXXXCeLzX_084838.jpg\";s:7:\"num_iid\";s:11:\"13989057359\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=13989057359\";s:4:\"gurl\";s:8:\"DP3B5G94\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:75:\"2012新款春装 男士丝光棉长袖衬衫 商务休闲印花长袖衬衣\";s:5:\"price\";s:6:\"168.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:1:\"/\";s:3:\"cid\";s:8:\"50011123\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','168','218','0','0','0','DP3B5G94','','衬衫');
INSERT INTO ts_weibo VALUES ('1508','2','{闻斯行诸}俄罗斯电子音乐人DJ M.E.G.联手Сергей Лазарев新单 从莫斯科到加州 - 视频 - 优酷视频 - 在线观看http://goo.gl/4DBuf ','1331822836','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzYzMjEyNjA0\";s:8:\"flashimg\";s:86:\"http://g3.ykimg.com/0100641F464F5A1D42EE0C00C7BC6A50642BC4-C9C3-27C2-7ACC-DECB7E3A0316\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzYzMjEyNjA0.html\";s:5:\"title\";s:147:\"{闻斯行诸}俄罗斯电子音乐人DJ M.E.G.联手Сергей Лазарев新单 从莫斯科到加州 - 视频 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:95;}','','0','0','189','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1538','304','[拍客]波多野结衣率日本女优组团亮相上海引发疯狂 在线观看 - 酷6视频http://goo.gl/uJqGr ','1331962585','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:24:\"75cKfo3CkYfPmc6VZPOwJA..\";s:8:\"flashimg\";s:90:\"http://vi0.ku6img.com/data1/p5/ku6video/2012/3/16/20/1335131345422_18645302_18645302/8.jpg\";s:4:\"host\";s:7:\"ku6.com\";s:6:\"source\";s:51:\"http://v.ku6.com/show/75cKfo3CkYfPmc6VZPOwJA...html\";s:5:\"title\";s:94:\"[拍客]波多野结衣率日本女优组团亮相上海引发疯狂 在线观看 - 酷6视频\";s:6:\"mwidth\";i:132;s:7:\"mheight\";i:99;}','','0','0','160','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1539','304','偏偏爱上你 - 第05集 - 2012 - 电视剧 - 优酷视频 - 在线观看http://goo.gl/RIVMZ ','1331962648','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzY2NjkyNDM2\";s:8:\"flashimg\";s:86:\"http://g3.ykimg.com/01270F1F464F62D86E5DCE0123193C6FB4A221-4466-855F-F12B-A98C458D7213\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzY2NjkyNDM2.html\";s:5:\"title\";s:75:\"偏偏爱上你 - 第05集 - 2012 - 电视剧 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:127;s:7:\"mheight\";i:95;}','','0','0','160','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1540','1','日单良品100%纯棉！森林系小清新简约百搭基础款花色短袖打底T恤','1334060215','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1fwuSXf8nXXbr5lI2_045148.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1fwuSXf8nXXbr5lI2_045148.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1fwuSXf8nXXbr5lI2_045148.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1fwuSXf8nXXbr5lI2_045148.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1fwuSXf8nXXbr5lI2_045148.jpg\";s:7:\"num_iid\";s:11:\"14421083435\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQxakNmg1G8xh%2BKhFE9GkVq8PJfcfXfVrS2yODeqsxEDURr31YIxa0h%2BAXNocQ1saa9Oo3SJrUE9kpcCS7S8b%2FJqvbhQbh9kpQMaOSh&amp;p=mm_18680880_0_0&amp;n=19&amp;u=C0ZKf0Ti\";s:4:\"gurl\";s:8:\"C0ZKf0Ti\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"日单良品100%纯棉！森林系小清新简约百搭基础款花色短袖打底T恤\";s:5:\"price\";s:5:\"42.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",365589067,392873091,\";s:3:\"cid\";s:8:\"50000671\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.10\";s:15:\"commission_rate\";s:1:\"5\";}','','0','42','12','0','0','0','C0ZKf0Ti','a:1:{i:0;s:6:\"衣服\";}','T恤');
INSERT INTO ts_weibo VALUES ('1555','421','金星撞火星 2012 - 第01期 - 金星撞火星 第一集 - 2012 - 综艺 - 优酷视频 - 在线观看http://goo.gl/W7wl8 ','1332103577','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzY2ODE3MjUy\";s:8:\"flashimg\";s:86:\"http://g4.ykimg.com/0100641F464F6324B7243D062769626FAFEFA4-ACAA-58F0-FEB8-D67D02E95E01\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzY2ODE3MjUy.html\";s:5:\"title\";s:105:\"金星撞火星 2012 - 第01期 - 金星撞火星 第一集 - 2012 - 综艺 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:96;}','','0','0','249','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1557','422','邪恶力量 第七季 - 第16集 - 2011 - 电视剧 - 优酷视频 - 在线观看http://goo.gl/8YVQ8 ','1332128250','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzY3MDY0ODc2\";s:8:\"flashimg\";s:86:\"http://g3.ykimg.com/01270F1F464F64499EF4A40123193CC88163A6-8951-7372-399C-ECAB153BC822\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzY3MDY0ODc2.html\";s:5:\"title\";s:82:\"邪恶力量 第七季 - 第16集 - 2011 - 电视剧 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:95;}','','0','0','250','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1559','422','《向上吧！少年》海选 北京赛区 选手A120573“翻版Nickhun”區迪迪弹唱《忐忑》 - 搜狐视频http://goo.gl/uOx5N ','1332128308','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:6:\"610834\";s:8:\"flashimg\";s:48:\"http://photocdn.sohu.com/20120318/vrsb474782.jpg\";s:4:\"host\";s:8:\"sohu.com\";s:6:\"source\";s:44:\"http://tv.sohu.com/20120318/n338103741.shtml\";s:5:\"title\";s:118:\"《向上吧！少年》海选 北京赛区 选手A120573“翻版Nickhun”區迪迪弹唱《忐忑》 - 搜狐视频\";s:6:\"mwidth\";i:120;s:7:\"mheight\";i:90;}','','0','0','250','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1561','1','#分享歌曲#尊严 —— 陈柏宇','1332153533','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1770291394\";s:4:\"logo\";s:69:\"http://img.xiami.com/./images/album/img34/7334/4481271308879626_1.jpg\";s:6:\"mwidth\";i:166;s:7:\"mheight\";i:185;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1562','1','#分享歌曲#你瞒我瞒 —— 陈柏宇','1332153570','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:7:\"3661722\";s:4:\"logo\";s:69:\"http://img.xiami.com/./images/album/img34/7334/3285331242006727_1.jpg\";s:6:\"mwidth\";i:161;s:7:\"mheight\";i:185;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1564','1','#分享歌曲#遇见 —— 孙燕姿','1332153647','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:6:\"143408\";s:4:\"logo\";s:58:\"http://img.xiami.com/./images/album/img32/2132/11654_1.jpg\";s:6:\"mwidth\";i:138;s:7:\"mheight\";i:185;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1565','1','#分享歌曲#预感+ —— 超级星光大道','1332153767','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:7:\"2103338\";s:4:\"logo\";s:59:\"http://img.xiami.com/./images/album/img69/7169/170323_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:127;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1566','1','#分享歌曲#无与伦比的美丽 —— 苏打绿','1332153809','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:6:\"389112\";s:4:\"logo\";s:58:\"http://img.xiami.com/./images/album/img48/3048/32659_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:165;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1567','1','#分享歌曲#暗恋 —— 陶喆','1332153881','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769061597\";s:4:\"logo\";s:64:\"http://img.xiami.com/./images/album/img0//3388901250566975_1.jpg\";s:6:\"mwidth\";i:157;s:7:\"mheight\";i:185;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1568','1','#分享歌曲#这，就是爱 —— 张杰','1332153964','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769816970\";s:4:\"logo\";s:64:\"http://img.xiami.com/./images/album/img0//4063521294389787_1.jpg\";s:6:\"mwidth\";i:179;s:7:\"mheight\";i:185;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1569','1','#分享歌曲#外面的世界 —— 莫文蔚','1332154046','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1770693338\";s:4:\"logo\";s:69:\"http://img.xiami.com/./images/album/img17/2017/4839601329808951_1.png\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:185;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1570','1','#分享歌曲#因为爱情 —— 陈奕迅','1332154094','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769962750\";s:4:\"logo\";s:68:\"http://img.xiami.com/./images/album/img35/135/4203041298355433_1.JPG\";s:6:\"mwidth\";i:184;s:7:\"mheight\";i:185;}','','0','0','252','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1573','1','#分享歌曲#Paparazzi —— Lady+GaGa','1332154464','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:7:\"3074950\";s:4:\"logo\";s:60:\"http://img.xiami.com/./images/album/img21/47821/272329_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:183;}','','0','0','253','0','1','0','','','');
INSERT INTO ts_weibo VALUES ('1574','1','#分享歌曲#Poker+Face —— Lady+GaGa','1332154786','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769227310\";s:4:\"logo\";s:70:\"http://img.xiami.com/./images/album/img21/47821/3377111259033923_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:185;}','','0','0','253','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1575','1','#分享歌曲#Bad+Romance —— Lady+GaGa','1332154924','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769220460\";s:4:\"logo\";s:70:\"http://img.xiami.com/./images/album/img21/47821/3512511255918949_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:167;}','','0','0','253','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1577','1','#分享歌曲#All+I+Ever+Wanted+ —— Befour','1332155588','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:7:\"3564424\";s:4:\"logo\";s:70:\"http://img.xiami.com/./images/album/img66/23366/3205211236050313_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:178;}','','0','0','253','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1578','1','#分享歌曲#Cross+Every+River —— Maria+Arredondo','1332155644','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:7:\"2093458\";s:4:\"logo\";s:60:\"http://img.xiami.com/./images/album/img46/23646/169527_1.jpg\";s:6:\"mwidth\";i:184;s:7:\"mheight\";i:185;}','','0','0','253','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1579','1','#分享歌曲#Everything+At+Once —— Lenka','1332155844','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1770009155\";s:4:\"logo\";s:70:\"http://img.xiami.com/./images/album/img26/49526/4287851316501732_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:185;}','','0','0','253','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1580','1','#分享歌曲#Me+and+You —— Lucky+Twice','1332155946','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769184183\";s:4:\"logo\";s:64:\"http://img.xiami.com/./images/album/img0//3525311256547464_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:185;}','','0','0','253','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1581','1','#分享歌曲#Buttons —— The+Pussycat+Dolls','1332156078','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:7:\"2088243\";s:4:\"logo\";s:60:\"http://img.xiami.com/./images/album/img38/23538/169109_1.jpg\";s:6:\"mwidth\";N;s:7:\"mheight\";N;}','','0','0','253','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1582','1','#分享歌曲#金鱼的眼泪 —— 纪佳松','1332156561','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1770111106\";s:4:\"logo\";s:70:\"http://img.xiami.com/./images/album/img45/58845/4324991301020295_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:184;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1583','1','#分享歌曲#暮光 —— 范玮琪','1332156779','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1770046613\";s:4:\"logo\";s:68:\"http://img.xiami.com/./images/album/img8/1508/4268921298431106_1.jpg\";s:6:\"mwidth\";i:183;s:7:\"mheight\";i:185;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1584','1','#分享歌曲#Asura+阿修罗 —— 尚雯婕','1332156922','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1770304547\";s:4:\"logo\";s:69:\"http://img.xiami.com/./images/album/img39/7239/4595681313475848_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:164;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1585','1','#分享歌曲#爱+喔爱 —— 廖语晴','1332157132','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1770206538\";s:4:\"logo\";s:70:\"http://img.xiami.com/./images/album/img47/89947/4424051306399854_1.jpg\";s:6:\"mwidth\";N;s:7:\"mheight\";N;}','','0','0','252','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1608','2','#分享歌曲#key+to+my+heart —— 倉木麻衣','1332356806','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769102109\";s:4:\"logo\";s:69:\"http://img.xiami.com/./images/album/img33/6733/3457101252310218_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:185;}','','0','0','262','2','0','0','','','');
INSERT INTO ts_weibo VALUES ('1610','437','错的蕾丝裙子，弹性很好，白色很洋气的[呲牙] 名媛必备。','1332443873','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ocGWXcBXXXbBnBk2_045113.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ocGWXcBXXXbBnBk2_045113.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ocGWXcBXXXbBnBk2_045113.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ocGWXcBXXXbBnBk2_045113.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ocGWXcBXXXbBnBk2_045113.jpg\";s:7:\"num_iid\";s:11:\"13882817422\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=13882817422\";s:4:\"gurl\";s:8:\"CEoWmW42\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"春装新款韩版韩国代购 名媛立领包臀蕾丝连衣裙 夜店超短裙女夏\";s:5:\"price\";s:5:\"68.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:41:\",459183303,435157076,465194929,456992780,\";s:3:\"cid\";s:8:\"50010850\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:181;}','','0','68','268','1','0','0','CEoWmW42','a:1:{i:0;s:6:\"衣服\";}','连衣裙');
INSERT INTO ts_weibo VALUES ('1613','442','嘻哈四重奏 第四季 - 第06集 - 2012 - 电视剧 - 优酷视频 - 在线观看http://goo.gl/8CsJ2 ','1332485576','0','0','0','0','3','a:7:{s:8:\"flashvar\";s:13:\"XMzY4MzMyOTky\";s:8:\"flashimg\";s:86:\"http://g2.ykimg.com/0100641F464F62DCEDF81706257BB6DB8D9806-A620-1BB3-421A-894312C44E12\";s:4:\"host\";s:9:\"youku.com\";s:6:\"source\";s:47:\"http://v.youku.com/v_show/id_XMzY4MzMyOTky.html\";s:5:\"title\";s:85:\"嘻哈四重奏 第四季 - 第06集 - 2012 - 电视剧 - 优酷视频 - 在线观看\";s:6:\"mwidth\";i:128;s:7:\"mheight\";i:95;}','','0','0','273','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1626','319','#分享歌曲#两只老虎 —— 群星','1332548304','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:10:\"1769510222\";s:4:\"logo\";s:69:\"http://img.xiami.com/./images/album/img69/7169/3803161273548608_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:180;}','','0','0','140','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1627','445','#分享歌曲#天黑黑 —— 孙燕姿','1332551908','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:6:\"376378\";s:4:\"logo\";s:68:\"http://img.xiami.com/./images/album/img32/2132/116811328283784_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:185;}','','0','0','275','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1629','2','#分享歌曲#我的Superstar —— 徐若瑄','1332568899','0','0','0','0','4','a:4:{s:5:\"mp3id\";s:6:\"378400\";s:4:\"logo\";s:58:\"http://img.xiami.com/./images/album/img18/2318/12420_1.jpg\";s:6:\"mwidth\";i:185;s:7:\"mheight\";i:131;}','','0','0','262','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1632','1','衣服真的很漂亮，质量真的没话说，做工非常好，值得购买','1333465705','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1r194XlFnXXbfjjo7_064941.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1r194XlFnXXbfjjo7_064941.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1r194XlFnXXbfjjo7_064941.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1r194XlFnXXbfjjo7_064941.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1r194XlFnXXbfjjo7_064941.jpg\";s:7:\"num_iid\";s:10:\"9519567304\";s:8:\"goodsurl\";s:192:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPxyqo1mbSurbzPpWUMX1O%2FCQiQp9VuOnVrU51aOWPzaAzt6cYayT9UUhItA5HeBDQD2QVjanlu6XQ4vJUkT964ck28WYbSJiTrRSubS&amp;p=mm_18680880_0_0&amp;n=19&amp;u=oybToyMA\";s:4:\"gurl\";s:8:\"oybToyMA\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"春装2012新款 短袖 T恤 女装韩版夏季大码打底衫宽松长款白色女款\";s:5:\"price\";s:5:\"55.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",451553563,353202258,353202261,353216645,\";s:3:\"cid\";s:8:\"50000671\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"5.98\";s:15:\"commission_rate\";s:5:\"21.75\";}','','0','55','12','0','0','0','oybToyMA','a:1:{i:0;s:6:\"衣服\";}','T恤');
INSERT INTO ts_weibo VALUES ('1633','1','2012夏季新品 沙滩裙 波西米亚风长裙 吊带裙 雪纺连衣裙1292a','1334060242','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1HFe6XhlgXXXphVwZ_030902.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1HFe6XhlgXXXphVwZ_030902.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1HFe6XhlgXXXphVwZ_030902.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1HFe6XhlgXXXphVwZ_030902.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1HFe6XhlgXXXphVwZ_030902.jpg\";s:7:\"num_iid\";s:11:\"14747815820\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQy7kFidVHqmFuycRSyBXYkCR6xoOUGTXraLICLLSZLqSsirCYHeQ5c3cazK3CoqMQ2WU52ij2dUzpOHEJfHjiYxAY1ul4bHh3j6abiaA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=738j9QTx\";s:4:\"gurl\";s:8:\"738j9QTx\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"2012夏季新品 沙滩裙 波西米亚风长裙 吊带裙 雪纺连衣裙1292a\";s:5:\"price\";s:6:\"180.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:71:\",460383018,460383023,460383022,461424465,460383020,462947901,461424462,\";s:3:\"cid\";s:8:\"50010850\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"11.25\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','180','12','0','0','0','738j9QTx','a:1:{i:0;s:6:\"衣服\";}','连衣裙');
INSERT INTO ts_weibo VALUES ('1636','1','诺力米特2012春夏新款韩版修身女装可打底碎花雪纺连衣裙N12009诺力米特旗舰店_反利大巴','1334060225','5','0','0','0','1','a:6:{s:8:\"thumburl\";s:39:\"2012/0404/21/1333546196353692_small.jpg\";s:14:\"thumbhaibaourl\";s:40:\"2012/0404/21/1333546196353692_haibao.jpg\";s:14:\"thumbmiddleurl\";s:40:\"2012/0404/21/1333546196353692_middle.jpg\";s:6:\"picurl\";s:33:\"2012/0404/21/1333546196353692.jpg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:200;}','http://www.fanlibus.com/detail/13764884485.html','0','0','12','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1637','1','卓欧2012春装新款 韩版三件套碎花吊带大码雪纺连衣裙夏季F105002_湖北 武汉_卓欧旗舰店_返利大巴','1334059990','5','0','0','0','1','a:6:{s:8:\"thumburl\";s:39:\"2012/0404/21/1333546988345070_small.jpg\";s:14:\"thumbhaibaourl\";s:40:\"2012/0404/21/1333546988345070_haibao.jpg\";s:14:\"thumbmiddleurl\";s:40:\"2012/0404/21/1333546988345070_middle.jpg\";s:6:\"picurl\";s:33:\"2012/0404/21/1333546988345070.jpg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:200;}','http://www.fanlibus.com/detail/10462009808.html','0','0','12','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1638','1','热饮巧克力大斗杯，绝对是一款匠心别具的礼物！','1334495029','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0404/22/f57e8403685188e28029cf551d8d790d_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0404/22/f57e8403685188e28029cf551d8d790d_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0404/22/f57e8403685188e28029cf551d8d790d_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0404/22/f57e8403685188e28029cf551d8d790d.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:200;}','','0','0','3','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1652','1','孙小圣天使细胞 琉璃纪念生日礼品送女生情人同学老婆实用大浪漫','1333804067','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1Qz1PXiJkXXaga7MW_024342.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1Qz1PXiJkXXaga7MW_024342.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1Qz1PXiJkXXaga7MW_024342.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1Qz1PXiJkXXaga7MW_024342.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1Qz1PXiJkXXaga7MW_024342.jpg\";s:7:\"num_iid\";s:10:\"8208621069\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZT1quBD4qiUi2oPNJnS6Yu5XN3Pt8j5Q5DfwCHNvV7sQZwkJV%2BSNaD4EC%2FjgAtlUbuFsWo1ylthAlM0sUsnNpHomAu%2B2fiODRaQeX2i5&amp;p=mm_18680880_0_0&amp;n=19&amp;u=hIf0d5tR\";s:4:\"gurl\";s:8:\"hIf0d5tR\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:88:\"孙小圣天使细胞 琉璃纪念生日礼品送女生情人同学老婆实用大浪漫\";s:5:\"price\";s:6:\"399.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",244778781,244916239,244779283,266173785,440655890,266167924,\";s:3:\"cid\";s:8:\"50023383\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"19.95\";s:15:\"commission_rate\";s:2:\"10\";}','','0','399','285','0','1','0','hIf0d5tR','a:1:{i:0;s:6:\"家居\";}','创意礼品');
INSERT INTO ts_weibo VALUES ('1653','1','阳光罐 生日创意礼物纪念周年情人节男送女朋友结婚男友礼品特别','1333804180','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SKx5XdtvXXcwrbvc_095836.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SKx5XdtvXXcwrbvc_095836.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SKx5XdtvXXcwrbvc_095836.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SKx5XdtvXXcwrbvc_095836.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SKx5XdtvXXcwrbvc_095836.jpg\";s:7:\"num_iid\";s:10:\"9767644912\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZP7Wj8rNEXlPno2iCsXIG7lVi4aozXGRxTGAJWJSpHe65VU6DlOQhcV4%2FaQ9ExpNsEFJmEQzSflXzxVSMIy%2F%2F%2B56D6oVRfJfTFBYk8ur&amp;p=mm_18680880_0_0&amp;n=19&amp;u=LlkpEPQ7\";s:4:\"gurl\";s:8:\"LlkpEPQ7\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:88:\"阳光罐 生日创意礼物纪念周年情人节男送女朋友结婚男友礼品特别\";s:5:\"price\";s:6:\"118.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:91:\",165911984,165911985,325641284,315540126,237093204,218017289,165911983,214982310,165911982,\";s:3:\"cid\";s:8:\"50011266\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"8.85\";s:15:\"commission_rate\";s:2:\"15\";}','','0','118','285','0','0','0','LlkpEPQ7','','阳光罐/月光罐');
INSERT INTO ts_weibo VALUES ('1654','1','凌波微步个性圣旨卷轴定制 爱情创意生日/结婚礼物 女生/男友特别礼物','1333804302','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1CPF6XdtlXXbX29U._113438.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1CPF6XdtlXXbX29U._113438.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1CPF6XdtlXXbX29U._113438.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1CPF6XdtlXXbX29U._113438.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1CPF6XdtlXXbX29U._113438.jpg\";s:7:\"num_iid\";s:10:\"2407402004\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTb0KwMeM998CdqEl6ptJ67o0dzphHoeMoNSseUayLNTdN1mZwOU5y%2B8M3exljsTNw1sRs5rHa1JMVQNT%2FKAx8hhXntXYBIqCKKPKRFFCK&amp;p=mm_18680880_0_0&amp;n=19&amp;u=GtrYXhKa\";s:4:\"gurl\";s:8:\"GtrYXhKa\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:88:\"凌波微步个性圣旨卷轴定制 爱情创意生日/结婚礼物 女生/男友特别\";s:5:\"price\";s:5:\"99.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:81:\",361389973,186129828,361389971,186129829,361389970,186129830,193566931,361389977,\";s:3:\"cid\";s:8:\"50020240\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"5.94\";s:15:\"commission_rate\";s:2:\"12\";}','','0','99','285','0','1','0','GtrYXhKa','','圣旨');
INSERT INTO ts_weibo VALUES ('1655','1','[品牌特卖]电动搅拌杯子 创意塑料水杯 抹茶咖啡奶茶摇摇杯 500ml','1333807603','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kXiYXd0kXXaa.eoW_022940.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kXiYXd0kXXaa.eoW_022940.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kXiYXd0kXXaa.eoW_022940.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kXiYXd0kXXaa.eoW_022940.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kXiYXd0kXXaa.eoW_022940.jpg\";s:7:\"num_iid\";s:11:\"13774641010\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOR%2F4Fdo1ch0djNleZf7icS2dUu3SL7MixTemvpL2%2F8QNA0NG48FvYl%2FQuXn9ZkM44IzZxSCUsuQUQb35evqerJtRLf35TMEDNxnRvk7A%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=zLtuT6BV\";s:4:\"gurl\";s:8:\"zLtuT6BV\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"[品牌特卖]电动搅拌杯子 创意塑料水杯 抹茶咖啡奶茶摇摇杯 500ml\";s:5:\"price\";s:5:\"59.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:81:\",401408736,401408737,401408738,401408739,401409116,401292009,401308913,449318755,\";s:3:\"cid\";s:8:\"50006887\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"5.9\";s:15:\"commission_rate\";s:2:\"20\";}','','0','59','284','0','1','0','zLtuT6BV','a:1:{i:0;s:6:\"家居\";}','摇摇杯');
INSERT INTO ts_weibo VALUES ('1656','1','幻响i-mu T2电脑共振音响 笔记本迷你 便携创意小音箱 正品包邮','1333807717','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1DiixXf4XXXaP.IgU_013806.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1DiixXf4XXXaP.IgU_013806.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1DiixXf4XXXaP.IgU_013806.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1DiixXf4XXXaP.IgU_013806.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1DiixXf4XXXaP.IgU_013806.jpg\";s:7:\"num_iid\";s:11:\"12963837857\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq9CWVnakQMg8Rs%2BgK25ZaqhacxjQ4Y6S4YsjXBQRXrjMPumhjvM95I9tZWbELnHsbPOUb1FOKgk9Tu3GzeaYhJ8nAkG2aqVkmr5l54w%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=V0xRecCK\";s:4:\"gurl\";s:8:\"V0xRecCK\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:82:\"幻响i-mu T2电脑共振音响 笔记本迷你 便携创意小音箱 正品包邮\";s:5:\"price\";s:6:\"129.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",403516576,403516577,403516592,396490261,419100961,\";s:3:\"cid\";s:6:\"121616\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"4.515\";s:15:\"commission_rate\";s:1:\"7\";}','','0','129','284','0','1','0','V0xRecCK','a:1:{i:0;s:6:\"家居\";}','组合/迷你/卡通音响');
INSERT INTO ts_weibo VALUES ('1657','1','创意情侣煮蛋器，营养还是煮的好噢！','1333807808','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1hcSPXgRwXXX7pHrc_095829.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1hcSPXgRwXXX7pHrc_095829.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1hcSPXgRwXXX7pHrc_095829.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1hcSPXgRwXXX7pHrc_095829.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1hcSPXgRwXXX7pHrc_095829.jpg\";s:7:\"num_iid\";s:10:\"8953158663\";s:8:\"goodsurl\";s:192:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZTYxM0I75s1a21yoV5KHSeaKMpSw5LkxQQQHyZMbRHxSuKBZ1HJ8W61HP95BbDwtOSKGrVcBG7V5dPoaPYE65%2B4JcCvFxSwvsLZtNhQx&amp;p=mm_18680880_0_0&amp;n=19&amp;u=SEHSJQ5D\";s:4:\"gurl\";s:8:\"SEHSJQ5D\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"天猫正品 十度良品SD-906情侣温泉煮蛋器 创意 生日礼物 特价包邮\";s:5:\"price\";s:5:\"78.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:81:\",438782896,438782900,438782901,438782906,348268906,438782892,438782909,438782895,\";s:3:\"cid\";s:8:\"50002898\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"2.535\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','78','284','0','1','0','SEHSJQ5D','','煮蛋器/蒸蛋器');
INSERT INTO ts_weibo VALUES ('1658','1','纯手工吹制双层耐热玻璃杯子，创意带盖透明泡花茶杯','1333807908','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1HLqmXXtxXXa5DhQU_014808.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1HLqmXXtxXXa5DhQU_014808.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1HLqmXXtxXXa5DhQU_014808.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1HLqmXXtxXXa5DhQU_014808.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1HLqmXXtxXXa5DhQU_014808.jpg\";s:7:\"num_iid\";s:11:\"12491844310\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKnUXYPAc56Ve6PL%2BydQNcnH7ivCHEI1iW9HNDHNbFeHoZgZPH%2Bq%2BtdzG09ifgg6Of3kHkHahU9gr7apqboi0Z6TFW5NG6DaMPmZhWzzg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=VVHAAR6P\";s:4:\"gurl\";s:8:\"VVHAAR6P\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:83:\"宁静的海 纯手工吹制双层耐热玻璃杯子 创意带盖透明泡花茶杯\";s:5:\"price\";s:5:\"58.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",232304116,392855803,\";s:3:\"cid\";s:8:\"50006865\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"2.9\";s:15:\"commission_rate\";s:2:\"10\";}','','0','58','285','0','1','0','VVHAAR6P','a:1:{i:0;s:6:\"家居\";}','玻璃杯');
INSERT INTO ts_weibo VALUES ('1659','1','【珍爱正品】七彩幸运星发光抱枕 创意生日礼物 可换洗外套 感应','1333808024','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kK9BXmtmXXbc23bX_115228.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kK9BXmtmXXbc23bX_115228.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kK9BXmtmXXbc23bX_115228.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kK9BXmtmXXbc23bX_115228.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1kK9BXmtmXXbc23bX_115228.jpg\";s:7:\"num_iid\";s:10:\"4399186093\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTaWMrpI%2BDBkr0HEra9Bnc49v%2BMMJxguF%2FhjNYyQ5h57NjwmI9CNni2wR1ODp%2FjtqA9GqNhYBckuVxdBC3vHgVK9kpx%2FjkPkawNx7iuMCr&amp;p=mm_18680880_0_0&amp;n=19&amp;u=TrS1nLoQ\";s:4:\"gurl\";s:8:\"TrS1nLoQ\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:87:\"【珍爱正品】七彩幸运星发光抱枕 创意生日礼物 可换洗外套 感应\";s:5:\"price\";s:6:\"158.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:71:\",287275583,287275595,284163404,226930192,287275589,287275588,293784215,\";s:3:\"cid\";s:6:\"213002\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"19.75\";s:15:\"commission_rate\";s:2:\"25\";}','','0','158','285','0','0','0','TrS1nLoQ','a:1:{i:0;s:6:\"家居\";}','靠垫/抱枕');
INSERT INTO ts_weibo VALUES ('1660','1','Being with your lover！','1333808221','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0407/22/83f13f7393590c9a91818abf50c51d75_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0407/22/83f13f7393590c9a91818abf50c51d75_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0407/22/83f13f7393590c9a91818abf50c51d75_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0407/22/83f13f7393590c9a91818abf50c51d75.jpeg\";s:6:\"mwidth\";i:199;s:7:\"mheight\";i:298;}','','0','0','22','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1661','1','is somebody going to push me??  do you want to play?','1333808348','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0407/22/78fcb895f9e0cd885a00f0f6ac6e81f8_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0407/22/78fcb895f9e0cd885a00f0f6ac6e81f8_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0407/22/78fcb895f9e0cd885a00f0f6ac6e81f8_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0407/22/78fcb895f9e0cd885a00f0f6ac6e81f8.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:266;}','','0','0','22','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1669','1','It is pity that people will do anything for a cute photo','1333846532','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0408/08/52a5c5b9a74bed209d2424fed6a97b81_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0408/08/52a5c5b9a74bed209d2424fed6a97b81_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0408/08/52a5c5b9a74bed209d2424fed6a97b81_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0408/08/52a5c5b9a74bed209d2424fed6a97b81.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:142;}','','0','0','47','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1671','1','摄像头免驱高清视频头，可爱米奇摄像头','1333846803','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1ZnqWXnJrXXcu4ajb_092750.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1ZnqWXnJrXXcu4ajb_092750.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1ZnqWXnJrXXcu4ajb_092750.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1ZnqWXnJrXXcu4ajb_092750.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1ZnqWXnJrXXcu4ajb_092750.jpg\";s:7:\"num_iid\";s:11:\"10864467894\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIA2xnFscqVAmJixR6XB4BCWugxZoaBIFDxbO6R7dwG9eGDy6x93TGJZTg%2FL5UbS6f3%2FAqPWNTpZB3f6oJtVZVQUeKEqwFT5nV312t3dGw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=HOHt7O6s\";s:4:\"gurl\";s:8:\"HOHt7O6s\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:84:\"摄像头 免驱 高清视频头 带麦克风 电脑网络视屏 可爱米奇 包邮\";s:5:\"price\";s:5:\"56.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",313179913,\";s:3:\"cid\";s:6:\"110508\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"1.26\";s:15:\"commission_rate\";s:3:\"4.5\";}','','0','56','284','0','0','0','HOHt7O6s','a:1:{i:0;s:6:\"家居\";}','摄像头');
INSERT INTO ts_weibo VALUES ('1672','1','景商 景德镇陶瓷餐具 28头骨瓷餐具套装 6区包邮 实惠小套装 碗盘','1333863063','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T192uAXohHXXc79FwY_024951.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T192uAXohHXXc79FwY_024951.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T192uAXohHXXc79FwY_024951.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T192uAXohHXXc79FwY_024951.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T192uAXohHXXc79FwY_024951.jpg\";s:7:\"num_iid\";s:11:\"12389763139\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKgefS9J8bI23EiswrMJJusxxrU%2F%2FkmSS0gim%2F9Xnb8E9vsNbfro36xAvXU%2BSrKjvgBDMirMob3zCH60QNiu4L984rwrM%2BrjuSVKLjG&amp;p=mm_18680880_0_0&amp;n=19&amp;u=JJr5w5gE\";s:4:\"gurl\";s:8:\"JJr5w5gE\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"景商 景德镇陶瓷餐具 28头骨瓷餐具套装 6区包邮 实惠小套装 碗盘\";s:5:\"price\";s:6:\"128.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",148167190,\";s:3:\"cid\";s:8:\"50002797\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"1.28\";s:15:\"commission_rate\";s:1:\"2\";}','','0','128','25','0','0','0','JJr5w5gE','a:1:{i:0;s:6:\"家居\";}','餐具瓷器套装');
INSERT INTO ts_weibo VALUES ('1675','1','[IJARL亿嘉]德国设计 创意 骨瓷餐具套装 陶瓷器碗餐具 东洋之心','1333863416','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1iYO0XdleXXb2X6QU_015345.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1iYO0XdleXXb2X6QU_015345.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1iYO0XdleXXb2X6QU_015345.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1iYO0XdleXXb2X6QU_015345.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1iYO0XdleXXb2X6QU_015345.jpg\";s:7:\"num_iid\";s:11:\"12984362371\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq%2BjWy89Kkkhy8OXYkkNurtg4OOw5OGHg78oiAyWa61Cz3XmepqDzQ9z10RKVunb5q%2BPLOtHzCS1lwf%2FoCyaO2SP%2BJtsKUNqIsu23LQw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=DyUX11ZL\";s:4:\"gurl\";s:8:\"DyUX11ZL\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:83:\"[IJARL亿嘉]德国设计 创意 骨瓷餐具套装 陶瓷器碗餐具 东洋之心\";s:5:\"price\";s:6:\"199.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",385618600,473422175,473422174,473422171,473422178,\";s:3:\"cid\";s:8:\"50002797\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"2.985\";s:15:\"commission_rate\";s:1:\"3\";}','','0','199','25','0','0','0','DyUX11ZL','a:1:{i:0;s:6:\"家居\";}','餐具瓷器套装');
INSERT INTO ts_weibo VALUES ('1678','1','Beauty flowers Love the colors.I can smell them.','1333891246','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0408/21/c43a0ff11b7249f5f1c0cddfc6b14e7e_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0408/21/c43a0ff11b7249f5f1c0cddfc6b14e7e_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0408/21/c43a0ff11b7249f5f1c0cddfc6b14e7e_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0408/21/c43a0ff11b7249f5f1c0cddfc6b14e7e.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:300;}','','0','0','3','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1679','1','OTHERCRAZY低腰磨破小脚铅笔牛仔裤女春装新款 女','1333892231','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T19S9LXj4hXXcM.N.W_024023.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T19S9LXj4hXXcM.N.W_024023.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T19S9LXj4hXXcM.N.W_024023.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T19S9LXj4hXXcM.N.W_024023.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T19S9LXj4hXXcM.N.W_024023.jpg\";s:7:\"num_iid\";s:11:\"15745108310\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWZW3RhH%2BGHagh6SGAEKYpYuF6YXQLa5EnsPMhPdmCdV2rXHXuINGaWZ%2Bl9LSbKGv2Vs2gP3QGHlYuYN3dGRepU5XKW9Sm5sT35i3BCIA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=94CrGjml\";s:4:\"gurl\";s:8:\"94CrGjml\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"七格格OTHERCRAZY低腰磨破小脚铅笔牛仔裤女春装新款 女15F30003\";s:5:\"price\";s:6:\"249.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",425350401,406925112,392857337,392843390,425347651,449771352,\";s:3:\"cid\";s:6:\"162205\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"15.565\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','249','12','0','0','0','94CrGjml','a:1:{i:0;s:6:\"衣服\";}','牛仔裤');
INSERT INTO ts_weibo VALUES ('1680','1','2012易菲春女装 潮 韩版长款宽松莫代儿蕾丝T恤打底衫大码DLC3008','1333892282','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1q255Xh8qXXXJlEgW_025104.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1q255Xh8qXXXJlEgW_025104.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1q255Xh8qXXXJlEgW_025104.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1q255Xh8qXXXJlEgW_025104.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1q255Xh8qXXXJlEgW_025104.jpg\";s:7:\"num_iid\";s:11:\"14164215044\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ0Fdrk%2FHgpKuLNZzWo%2F6Kdv1MPZkK8CzkLs6ZY0odRmppeJ5f4ANWaOzulSNhr2xnq7DicfNq9jigxO%2BzYM4v7PUTks7fq%2F6gqEWb3fQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=ekH69N4L\";s:4:\"gurl\";s:8:\"ekH69N4L\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:83:\"2012易菲春女装 潮 韩版长款宽松莫代儿蕾丝T恤打底衫大码DLC3008\";s:5:\"price\";s:6:\"198.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",435711315,312468605,429612775,312468609,438253699,312468603,\";s:3:\"cid\";s:8:\"50000671\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"18.565\";s:15:\"commission_rate\";s:5:\"18.75\";}','','0','198','12','0','1','0','ekH69N4L','a:1:{i:0;s:6:\"衣服\";}','T恤');
INSERT INTO ts_weibo VALUES ('1681','1','白色与亮蓝色搭配，让黑girl散发出蓝天白云般的清新自然气质。长及脚踝的雪纺开阔裙摆，层层叠叠的精细褶皱，将注意力牢牢捆绑，完全不用担心肤色的驾驭能力不足。','1333892350','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1_IW6XeVbXXcQFU3__081059.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1_IW6XeVbXXcQFU3__081059.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1_IW6XeVbXXcQFU3__081059.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1_IW6XeVbXXcQFU3__081059.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1_IW6XeVbXXcQFU3__081059.jpg\";s:7:\"num_iid\";s:11:\"14231473394\";s:8:\"goodsurl\";s:212:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ3ir8JDKfm%2BO%2F3aOY9tbK%2FcOiqxD%2BfFXyBI1FQaC1f%2BbqL2WD9jdvAqXzw%2FBnpquS8SF8mInDxg3eFrk3S06SlsC06YRavm%2FPGprbB6Q%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=6K5UzQpv\";s:4:\"gurl\";s:8:\"6K5UzQpv\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:84:\"2012春装女装 新款 夏季雪纺拖地半身裙 高腰裙 大摆裙 百褶长裙\";s:5:\"price\";s:6:\"326.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",396769377,\";s:3:\"cid\";s:4:\"1623\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"20.375\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','326','12','0','0','0','6K5UzQpv','a:1:{i:0;s:6:\"衣服\";}','半身裙');
INSERT INTO ts_weibo VALUES ('1682','1','宽松蝙蝠袖卫衣的帅气气质与黑girl的健康爽朗气质完美切合。饱和度相对较高的酒红色让黑肤质看上去健康生动，极具活力。在名模竞相美黑的时代，大胆秀出你的性感黑肤吧。','1333892401','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1BBSSXldnXXci4k7._082920.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1BBSSXldnXXci4k7._082920.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1BBSSXldnXXci4k7._082920.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1BBSSXldnXXci4k7._082920.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1BBSSXldnXXci4k7._082920.jpg\";s:7:\"num_iid\";s:11:\"15651820743\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWYKAvVjp%2Fqytvet7lID%2BTb4RVyvl8r6JpJ4riZwcg8ZyFWmpW9vJe1r587Qkn3Cp5FAzN2PY2zhVU0nQEeXMR1bF1HuGsEtNTFZViZuA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=WCDLPXA0\";s:4:\"gurl\";s:8:\"WCDLPXA0\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"淘金币庄蝶正品韩版女运动服拼色两件套 加大码女装卫衣套装8918\";s:5:\"price\";s:6:\"330.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:101:\",389821362,373264359,389821363,381922180,381629665,381922179,381629669,373263694,381629668,416388178,\";s:3:\"cid\";s:8:\"50008898\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"20.625\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','330','12','0','0','0','WCDLPXA0','a:1:{i:0;s:6:\"衣服\";}','卫衣/绒衫');
INSERT INTO ts_weibo VALUES ('1683','1','让白色占据了重点地位之后，下半身的打底裤就可以选择或艳丽或缤纷的色彩了。宽松又不显松垮的中长款T恤，穿出洒脱不羁范儿。造型夸张的荷叶袖，透出淡淡的女性柔美。手臂在宽边荷叶袖的遮挡下，显纤细修长。','1333892474','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kyubXhBcXXX2qU.S_010447.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kyubXhBcXXX2qU.S_010447.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kyubXhBcXXX2qU.S_010447.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kyubXhBcXXX2qU.S_010447.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kyubXhBcXXX2qU.S_010447.jpg\";s:7:\"num_iid\";s:11:\"10356073381\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIA9SBiObASpWbMEvXRFZZh2vT%2FvDC65qg%2F19mzJ0Hgzeckfk29ERmQq1y7%2F93QagnNi7hN2aC1T86Z3p%2BXU3LfJp9rwXE2tmPnqkkksFw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=3yk98Ddl\";s:4:\"gurl\";s:8:\"3yk98Ddl\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"两三事 在空气里 大荷叶袖 t恤 短袖 女 白色女款 t恤 修身中长款\";s:5:\"price\";s:6:\"202.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",255600810,209102574,211859719,\";s:3:\"cid\";s:8:\"50000671\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"9.595\";s:15:\"commission_rate\";s:3:\"9.5\";}','','0','202','12','0','1','0','3yk98Ddl','a:1:{i:0;s:6:\"衣服\";}','T恤');
INSERT INTO ts_weibo VALUES ('1684','1','桃红、浅绿等颜色也并非黑肤禁色，但是要避免大面积使用，小面积运用往往能起到点睛的作用。浅绿色背心，浅粉色裹胸，再搭配白色修身七分裤，轻盈明快的色调让黑girl展现个性风情。','1333892511','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1PSu5XeVeXXaLBYg6_060659.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1PSu5XeVeXXaLBYg6_060659.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1PSu5XeVeXXaLBYg6_060659.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1PSu5XeVeXXaLBYg6_060659.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1PSu5XeVeXXaLBYg6_060659.jpg\";s:7:\"num_iid\";s:11:\"10168134825\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIA%2FNdzeE71RcNc2iW2fjThTMtN6fPLsEDADyTmsHrbb5%2Be0mV2%2B55909jNHqv0lfivECsHy7zWsPa40zQbYJiS8hs%2FKRF%2Bpq53vKlNUqA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=naHVXI4I\";s:4:\"gurl\";s:8:\"naHVXI4I\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"丽洁女裤正品春夏全棉翻边糖果色九分裤/七分裤热裤休闲裤CO3147\";s:5:\"price\";s:6:\"166.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",415981805,321909613,321909625,\";s:3:\"cid\";s:6:\"162205\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"12.035\";s:15:\"commission_rate\";s:4:\"14.5\";}','','0','166','12','0','0','0','naHVXI4I','a:1:{i:0;s:6:\"衣服\";}','牛仔裤');
INSERT INTO ts_weibo VALUES ('1685','1','金属色泽，金属铆钉，一旦和金属挂钩就自然而然带来一份俊朗气质。低调深沉的深蓝色也在金属色泽的浸染下生出一份高贵气质。剪裁形同简约大气的中长款衬衫，大道至简彰显大牌范儿。','1333894203','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qwmPXg0bXXbV47s2_044710.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qwmPXg0bXXbV47s2_044710.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qwmPXg0bXXbV47s2_044710.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qwmPXg0bXXbV47s2_044710.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qwmPXg0bXXbV47s2_044710.jpg\";s:7:\"num_iid\";s:11:\"15348128432\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWdEg8qN9uzcBAcIFigZgbZb4E4fcd330R%2FhC%2FTAiH6Smn6MooAzNeQX2C%2Fxc5WZktF70He5WdvaybYgQjYbp2J4S8%2BxhKE3VUL89uzmA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=ZMoDqROo\";s:4:\"gurl\";s:8:\"ZMoDqROo\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:76:\"2012格兰玛丽春装新品女式长款深蓝色薄款衬衫式风衣外套\";s:5:\"price\";s:6:\"198.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",414683779,410585419,432474962,410585410,\";s:3:\"cid\";s:8:\"50008901\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"24.75\";s:15:\"commission_rate\";s:2:\"25\";}','','0','198','12','0','1','0','ZMoDqROo','a:1:{i:0;s:6:\"衣服\";}','风衣');
INSERT INTO ts_weibo VALUES ('1686','1','步行街上的乞讨者','1333936756','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0409/09/0a5ac0aa5d3f9b035cb11fbc042f5d8e_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0409/09/0a5ac0aa5d3f9b035cb11fbc042f5d8e_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0409/09/0a5ac0aa5d3f9b035cb11fbc042f5d8e_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0409/09/0a5ac0aa5d3f9b035cb11fbc042f5d8e.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:154;}','','0','0','22','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1690','1','懒人沙发 超舒适高品质 创意 个性礼品','1333937094','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pAlPXjNIXXcqiw74_052835.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pAlPXjNIXXcqiw74_052835.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pAlPXjNIXXcqiw74_052835.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pAlPXjNIXXcqiw74_052835.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1pAlPXjNIXXcqiw74_052835.jpg\";s:7:\"num_iid\";s:10:\"8173461097\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZT6dkK%2FhTgS9ZXSRsiXGUBiItKiDUG8rYzdDiDdscLntlXB2bps9MYc%2FGauuf0nrvFbtBwzSsJXrLPb1MMdtvhoIC1IUEWr0FA4Derxf&amp;p=mm_18680880_0_0&amp;n=19&amp;u=GT92ZFjh\";s:4:\"gurl\";s:8:\"GT92ZFjh\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:72:\"包邮 一生缘高档皮质白色PU懒人沙发粒子豆袋懒骨头 F1\";s:5:\"price\";s:6:\"249.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:71:\",295281970,295281975,374554232,336366678,336366676,295281808,336366674,\";s:3:\"cid\";s:8:\"50015458\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"31.125\";s:15:\"commission_rate\";s:2:\"25\";}','','0','249','284','0','0','0','GT92ZFjh','a:1:{i:0;s:6:\"家居\";}','懒人沙发');
INSERT INTO ts_weibo VALUES ('1691','1','超萌老虎狗狗纸巾抽，看那楚楚可怜的样子，太有爱了','1333937139','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CiqUXX0nXXavOwra_120906.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CiqUXX0nXXavOwra_120906.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CiqUXX0nXXavOwra_120906.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CiqUXX0nXXavOwra_120906.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CiqUXX0nXXavOwra_120906.jpg\";s:7:\"num_iid\";s:11:\"13388955986\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOVtNon6XQcLBxW68UnqpSs3ZhEfzi%2FhCnyT4Hs0vZEOHmfrjWwCVs1GHZpZT7auPILCEjQSGk6fzfwJXZKvQyU6tfSLXBfVO1Sj5Kztw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=1qhe6GRW\";s:4:\"gurl\";s:8:\"1qhe6GRW\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"泉雅堂 狗狗纸巾抽 特价卡通纸巾盒 抽纸盒 家用 车用纸巾盒摆件\";s:5:\"price\";s:4:\"9.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",252415166,305827647,445555033,\";s:3:\"cid\";s:8:\"50016325\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"0.205\";s:15:\"commission_rate\";s:3:\"4.5\";}','','0','9','284','0','0','0','1qhe6GRW','a:1:{i:0;s:6:\"家居\";}','车用纸巾盒/套');
INSERT INTO ts_weibo VALUES ('1692','1','超多款的铁艺纸巾盒，总有一款你喜欢的吧哈哈','1333937176','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ej1TXmJeXXcJPn6b_095413.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ej1TXmJeXXcJPn6b_095413.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ej1TXmJeXXcJPn6b_095413.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ej1TXmJeXXcJPn6b_095413.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1ej1TXmJeXXcJPn6b_095413.jpg\";s:7:\"num_iid\";s:11:\"12972045571\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq9YXnn5gNocs2S7%2ByQLhlFBHP5OYc4EGCzD9%2FzSjoQqC3mAyVDGr43x0LTwrRA25HCvLhXEYR7fLsfouKVR1yVR57yQwMEHy00JUccA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=SFN7nuLq\";s:4:\"gurl\";s:8:\"SFN7nuLq\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:82:\"庆两冠9折 多款 小号 创意纸巾盒 车用纸巾盒 餐巾纸盒 铁皮盒\";s:5:\"price\";s:5:\"10.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",406631078,\";s:3:\"cid\";s:8:\"50001691\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"0.2\";s:15:\"commission_rate\";s:1:\"4\";}','','0','10','284','0','0','0','SFN7nuLq','','纸巾套');
INSERT INTO ts_weibo VALUES ('1693','1','自由','1333939124','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0409/10/867c0a7307bff49765bc41feaafb1f77_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0409/10/867c0a7307bff49765bc41feaafb1f77_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0409/10/867c0a7307bff49765bc41feaafb1f77_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0409/10/867c0a7307bff49765bc41feaafb1f77.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:150;}','','0','0','22','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1698','1','哈伦裤以其“有型的松垮”而成为休闲感十足的必备裤型之一，自胯部打开的宽松设计遮住了臀腿处的肉肉，到膝盖往下收紧的版型又能凸显小腿的纤细线条。淑女感的裸色配上白色的波点，轻松又俏皮，搭配红得发紫的松糕鞋轻松完成出街游乐造型。','1333940296','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1SNy7Xj0bXXcqal36_062636.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1SNy7Xj0bXXcqal36_062636.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1SNy7Xj0bXXcqal36_062636.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1SNy7Xj0bXXcqal36_062636.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1SNy7Xj0bXXcqal36_062636.jpg\";s:7:\"num_iid\";s:11:\"14026174049\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ1FDONegjXymjqhBps3KiE24xLYAs1HXTOQEZgW18%2FrKWST2uOrH1IsHC5CNujK1JTn7JlmddtKS9BaqJmU7YKK1XqFDNg89z9SQIbJw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=TAKEZVm1\";s:4:\"gurl\";s:8:\"TAKEZVm1\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:83:\"2012春夏新款 韩版黑白大码显瘦波点女小脚裤哈伦裤七分裤 K7019\";s:5:\"price\";s:5:\"79.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",434288100,434288101,455752363,434288099,\";s:3:\"cid\";s:6:\"162207\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"7.405\";s:15:\"commission_rate\";s:5:\"18.75\";}','','0','79','12','0','0','0','TAKEZVm1','a:1:{i:0;s:6:\"衣服\";}','九分裤/七分裤');
INSERT INTO ts_weibo VALUES ('1699','1','格纹修身的七分裤没有理由不成为百搭单品。既适合办公场合又能胜任出游需要，格纹总是流露着充满书卷气的英伦时尚品位，弹力修身的材质对双腿起到微整形的作用，掩盖掉双腿曲线的小瑕疵，衬出一对粉嫩白皙的小腿。','1333940340','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Zz9tXnteXXbaZaZ._111325.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Zz9tXnteXXbaZaZ._111325.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Zz9tXnteXXbaZaZ._111325.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Zz9tXnteXXbaZaZ._111325.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Zz9tXnteXXbaZaZ._111325.jpg\";s:7:\"num_iid\";s:11:\"10725025602\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIA5k1UPKbYRbOLv955SwNdgZTGrTN%2B5bL5Z6NdfK3cfC9k39Mp2hEqn4Kc6gRBitxJ9xPX0J2koceSBPizvfS9f%2FqSdn%2BEa%2Bj21xnPOHw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=IfpVRYaT\";s:4:\"gurl\";s:8:\"IfpVRYaT\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:75:\"播穿梭机 春夏新品百搭时尚格纹修身弹力七分裤 BDE2KG0681\";s:5:\"price\";s:6:\"249.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",324915351,324915350,463154445,\";s:3:\"cid\";s:6:\"162207\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"15.565\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','249','12','0','0','0','IfpVRYaT','a:1:{i:0;s:6:\"衣服\";}','九分裤/七分裤');
INSERT INTO ts_weibo VALUES ('1700','1','设计感十足的宽松哈伦七分裤颇有艺术生的气质感，雅致特别的线条悄无声息地遮挡了臀腿部不能示人的赘肉，在裤脚处的褶皱提升了膝盖的视觉位置，拉长了双腿比例，搭配复古淑女感高跟鞋，轻松俘获全场目光。','1333940388','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T11Ym0XcVaXXaeowM9_103500.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T11Ym0XcVaXXaeowM9_103500.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T11Ym0XcVaXXaeowM9_103500.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T11Ym0XcVaXXaeowM9_103500.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T11Ym0XcVaXXaeowM9_103500.jpg\";s:7:\"num_iid\";s:11:\"15409060543\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWawhCDPrUBxceoiFLsJdKLRnRkQLC7gNqbOTuUMFUZG893f66x%2Fdy1RBsCcdR3tTP8hAS%2F0lKQ4SsMKgSj8tPcuFQwY%2FXB3Ehef9dvfw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=Y49vWoeq\";s:4:\"gurl\";s:8:\"Y49vWoeq\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:69:\"veilond伟伦时尚春品休闲腰头装饰哈伦裤七分裤|2A60906\";s:5:\"price\";s:6:\"198.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",442185921,463147214,\";s:3:\"cid\";s:6:\"162207\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"12.375\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','198','12','0','0','0','Y49vWoeq','a:1:{i:0;s:6:\"衣服\";}','九分裤/七分裤');
INSERT INTO ts_weibo VALUES ('1701','1','左前襟以及后背拼接荷叶边的造型散发浓郁的英伦风，身前身后看都是风景，给人的感觉够帅够有型。撞色的格纹纽扣一扫沉闷带来精致的细节。考究的剪裁上身效果修身塑形，搭配西装裤气质出众。','1333940429','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1uFqoXkpeXXc9ohgU_015030.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1uFqoXkpeXXc9ohgU_015030.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1uFqoXkpeXXc9ohgU_015030.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1uFqoXkpeXXc9ohgU_015030.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1uFqoXkpeXXc9ohgU_015030.jpg\";s:7:\"num_iid\";s:11:\"12738563670\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKkX%2FxBqyylH4iIlDgenoe%2ByYcq2TcH4MtfIMi2mHJ7OBqi%2BpkWCrIIhUtLCYGvsyUnSJiEahp5M7TmNDt%2FHS7uP48PF7GqXFK3rEux&amp;p=mm_18680880_0_0&amp;n=19&amp;u=83IpMTA3\";s:4:\"gurl\";s:8:\"83IpMTA3\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:84:\"2012闽绣衬衣春装新款 韩版拼色英伦OL通勤纯色长袖女装衬衫 8171\";s:5:\"price\";s:5:\"80.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",113251452,165835796,\";s:3:\"cid\";s:6:\"162104\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"7.5\";s:15:\"commission_rate\";s:5:\"18.75\";}','','0','80','12','0','1','0','83IpMTA3','a:1:{i:0;s:6:\"衣服\";}','衬衫');
INSERT INTO ts_weibo VALUES ('1702','1','层叠的荷叶边加上立体的造型带来复古宫廷风，也巧妙打造柔美层次感。立领上一排精致的袖扣雅致高贵，更衬托得玉颈修长。轻柔顺滑的面料穿着舒适透气，且不易起皱，春夏季节穿着尤为妥帖大方。','1333940503','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PZ91XlFlXXcGRBI1_042223.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PZ91XlFlXXcGRBI1_042223.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PZ91XlFlXXcGRBI1_042223.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PZ91XlFlXXcGRBI1_042223.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PZ91XlFlXXcGRBI1_042223.jpg\";s:7:\"num_iid\";s:11:\"14777423523\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQy7S7NvL9IEMjGawGSiwCR3DD4PypEDNBDjCKh5gh8Ak1qQSCG%2Fj4Lm1QmCvC8bEQbw9pVDDF3%2FBiTCngTXvmcoBqCubp%2F%2F4kjsnOG&amp;p=mm_18680880_0_0&amp;n=19&amp;u=A3cWdJ0a\";s:4:\"gurl\";s:8:\"A3cWdJ0a\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"名人瑞裳 春装新款女装修身衬衣长袖荷叶边欧美雪纺立领衬衫3001\";s:5:\"price\";s:6:\"358.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",462083883,186251641,444986515,186260853,\";s:3:\"cid\";s:6:\"162104\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"15.215\";s:15:\"commission_rate\";s:3:\"8.5\";}','','0','358','12','0','1','0','A3cWdJ0a','a:1:{i:0;s:6:\"衣服\";}','衬衫');
INSERT INTO ts_weibo VALUES ('1703','1','大森林家具 韩式田园床 实木床 宜家 公主床 双人床 1.8 特价','1334310744','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1pKOpXaJkXXXGoLo8_070358.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1pKOpXaJkXXXGoLo8_070358.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1pKOpXaJkXXXGoLo8_070358.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1pKOpXaJkXXXGoLo8_070358.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1pKOpXaJkXXXGoLo8_070358.jpg\";s:7:\"num_iid\";s:10:\"8022957192\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZT%2F4C7NpE0MND0%2BdAZLPJ%2BZgGlLLLsz3tTR53zwc9ItMl9fR2R4HhAUuqVtLD6CsDff8gACgIMOU0W59me4DN3fBqxjTiiEtqoAWTiFQ&amp;p=mm_18680880_0_0&amp;n=19&amp;u=sAgvgRrc\";s:4:\"gurl\";s:8:\"sAgvgRrc\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"大森林家具 韩式田园床 实木床 宜家 公主床 双人床 1.8 特价\";s:5:\"price\";s:7:\"3798.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",402097554,388567992,\";s:3:\"cid\";s:8:\"50019997\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"284.85\";s:15:\"commission_rate\";s:2:\"15\";}','','0','3798','3','0','0','0','sAgvgRrc','a:2:{i:0;s:0:\"\";i:1;s:6:\"家居\";}','实木床');
INSERT INTO ts_weibo VALUES ('1704','1','爆款!男士新款春装潮T恤 男v领假两件长袖衣服 纯棉打底衫男装t恤_爆款 ','1333942389','5','0','0','0','1','a:6:{s:8:\"thumburl\";s:39:\"2012/0409/11/1333942388817451_small.jpg\";s:14:\"thumbhaibaourl\";s:40:\"2012/0409/11/1333942388817451_haibao.jpg\";s:14:\"thumbmiddleurl\";s:40:\"2012/0409/11/1333942388817451_middle.jpg\";s:6:\"picurl\";s:33:\"2012/0409/11/1333942388817451.jpg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:200;}','http://www.fanlibus.com/detail/8160885407.html','0','0','4','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1705','1','春装新款牛仔裤 男2012韩版修身复古男士直筒牛仔长裤子 牛崽裤潮','1333942479','5','0','0','0','1','a:6:{s:8:\"thumburl\";s:38:\"2012/0409/11/133394247854995_small.jpg\";s:14:\"thumbhaibaourl\";s:39:\"2012/0409/11/133394247854995_haibao.jpg\";s:14:\"thumbmiddleurl\";s:39:\"2012/0409/11/133394247854995_middle.jpg\";s:6:\"picurl\";s:32:\"2012/0409/11/133394247854995.jpg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:200;}','http://www.fanlibus.com/detail/12699706255.html','0','0','4','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1706','1','mahdi麦迪平板电脑M2（8G） 7寸多点电容屏 A10 1.5G主频 安卓4.0','1333942671','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1vse3XXdjXXb87u3Y_025948.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1vse3XXdjXXb87u3Y_025948.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1vse3XXdjXXb87u3Y_025948.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1vse3XXdjXXb87u3Y_025948.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1vse3XXdjXXb87u3Y_025948.jpg\";s:7:\"num_iid\";s:11:\"14853991484\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ9r%2FWcHikyFsqwnnfZ700iQL%2FZvW%2BWvM27YmaGVvwQPRfNb%2Fo1zhb4T31oNW2jP0X1oUvvParCBQz0mlazAgCPkyGQVLr5Eh9oCj8nfg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=fd7uKCF5\";s:4:\"gurl\";s:8:\"fd7uKCF5\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:78:\"mahdi麦迪平板电脑M2（8G） 7寸多点电容屏 A10 1.5G主频 安卓4.0\";s:5:\"price\";s:6:\"499.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",462001046,\";s:3:\"cid\";s:8:\"50019780\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"3.745\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','499','39','1','1','0','fd7uKCF5','a:1:{i:0;s:6:\"家居\";}','平板电脑/MID');
INSERT INTO ts_weibo VALUES ('1707','1','纽曼T7(8G)7寸 5点触控电容屏安卓 掌上智能平板电脑 送豪礼','1333942722','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Wla7XnXjXXcd.PDX_115656.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Wla7XnXjXXcd.PDX_115656.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Wla7XnXjXXcd.PDX_115656.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Wla7XnXjXXcd.PDX_115656.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Wla7XnXjXXcd.PDX_115656.jpg\";s:7:\"num_iid\";s:11:\"13088106334\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOW391m5GSt0OYzgdoKeWScQqnxMqfJuWPh5ECFbYOTHejYkwIX9w1fcnf4Hlz5VG71r1xZTKa761GYmUvgB1LBd%2B9E2iEidCz9Omh2dw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=p4kiHky8\";s:4:\"gurl\";s:8:\"p4kiHky8\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:81:\"包邮!纽曼T7(8G)7寸 5点触控电容屏安卓wifi 3G 掌上智能平板电脑\";s:5:\"price\";s:6:\"699.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",372219774,372219758,373281204,372742053,372220896,\";s:3:\"cid\";s:8:\"50019780\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"10.485\";s:15:\"commission_rate\";s:1:\"3\";}','','0','699','39','0','0','0','p4kiHky8','a:1:{i:0;s:6:\"家居\";}','平板电脑/MID');
INSERT INTO ts_weibo VALUES ('1708','1','gemei歌美 G9 平板电脑 9.7寸安卓4.0 IPS屏 送大礼 大量现货','1333942892','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1yzCRXf0cXXXsljg__110036.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1yzCRXf0cXXXsljg__110036.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1yzCRXf0cXXXsljg__110036.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1yzCRXf0cXXXsljg__110036.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1yzCRXf0cXXXsljg__110036.jpg\";s:7:\"num_iid\";s:11:\"13840057496\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOePoTTDTHLs5hbdWH%2BPrFt2kfcgdVVcAqn6aKc5Y%2FN9C7Z%2Fm5NEkRHYwZ%2BAYNLRuGSpFEgZJaNmcaT8R%2B7MZIhGRV76ZQe3YCNvD90UA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=zH8LY8zz\";s:4:\"gurl\";s:8:\"zH8LY8zz\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:74:\"gemei歌美 G9 平板电脑 9.7寸安卓4.0 IPS屏  送大礼 销量第一\";s:5:\"price\";s:7:\"1199.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",359032667,\";s:3:\"cid\";s:8:\"50019780\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"17.985\";s:15:\"commission_rate\";s:1:\"3\";}','','0','1199','39','0','1','0','zH8LY8zz','a:1:{i:0;s:6:\"家居\";}','平板电脑/MID');
INSERT INTO ts_weibo VALUES ('1709','1','Apple/苹果 iPhone 4代（16G）8G正品带票','1333952369','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GRGgXn8XXXbPwEQY_031112.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GRGgXn8XXXbPwEQY_031112.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GRGgXn8XXXbPwEQY_031112.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GRGgXn8XXXbPwEQY_031112.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GRGgXn8XXXbPwEQY_031112.jpg\";s:7:\"num_iid\";s:11:\"12940233173\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq9nsgHDOZToBc%2Be%2Bo5uyqXDoeNdQgoOFCQ89xguRc%2BXXn23kVtEJqNg84XmHwyRoZMotJSVMZZ1BdZL%2FuQ%2FIaJfCoz7o8USFlNFoJGQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=JdZ7EJTC\";s:4:\"gurl\";s:8:\"JdZ7EJTC\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:47:\"Apple/苹果 iPhone 4代（16G）8G正品带票\";s:5:\"price\";s:7:\"3960.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",117059272,175080978,\";s:3:\"cid\";s:4:\"1512\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"39.6\";s:15:\"commission_rate\";s:1:\"2\";}','','0','3960','39','1','1','0','JdZ7EJTC','a:1:{i:0;s:6:\"家居\";}','手机');
INSERT INTO ts_weibo VALUES ('1710','1','天猫 iphone4手机壳 浮雕外壳手机套 iphone4s手机壳 苹果4手机壳','1333952612','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1S7WMXj4hXXcim7gZ_033151.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1S7WMXj4hXXcim7gZ_033151.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1S7WMXj4hXXcim7gZ_033151.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1S7WMXj4hXXcim7gZ_033151.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1S7WMXj4hXXcim7gZ_033151.jpg\";s:7:\"num_iid\";s:11:\"13641626034\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOQu96Qp5%2FkzbncvHmHeZi1KTHXK0BJwx8nBz34xdI%2B1tliKd6l9b4wQwA8KhtZK6EAzRM0SjLpND4c6dnU6s3HjnX6cMoPGUzba%2Fc5Iw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=1E6t9w22\";s:4:\"gurl\";s:8:\"1E6t9w22\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"天猫 iphone4手机壳 浮雕外壳手机套 iphone4s手机壳 苹果4手机壳\";s:5:\"price\";s:5:\"99.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",349512480,\";s:3:\"cid\";s:8:\"50018599\";s:6:\"mwidth\";N;s:7:\"mheight\";N;s:10:\"commission\";s:5:\"25.74\";s:15:\"commission_rate\";s:2:\"52\";}','','0','99','39','1','1','0','1E6t9w22','a:1:{i:0;s:6:\"家居\";}','苹果保护套/保护壳');
INSERT INTO ts_weibo VALUES ('1711','1','蒙奇奇iphone4外壳 iphone4s手机壳 苹果4代硅胶套 彩绘手机套','1333952780','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1zZ11XeRfXXa7SMZ._112401.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1zZ11XeRfXXa7SMZ._112401.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1zZ11XeRfXXa7SMZ._112401.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1zZ11XeRfXXa7SMZ._112401.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1zZ11XeRfXXa7SMZ._112401.jpg\";s:7:\"num_iid\";s:11:\"15835360387\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWWzJY4ol7JcZ5qqjbxNowTm01a%2BdtfwtvVoJxVHmgxpKN5gpuQjhdZ2mx%2FW4POo4pR9A1pY8Xt8h4LHDf1EGsBu9QaqvUBlBey%2BOA%2BRQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=cTHUKJVW\";s:4:\"gurl\";s:8:\"cTHUKJVW\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:76:\"蒙奇奇iphone4外壳 iphone4s手机壳 苹果4代硅胶套 彩绘手机套\";s:5:\"price\";s:5:\"38.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",458404229,\";s:3:\"cid\";s:8:\"50018599\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"1.235\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','38','39','1','1','0','cTHUKJVW','a:1:{i:0;s:6:\"家居\";}','苹果保护套/保护壳');
INSERT INTO ts_weibo VALUES ('1712','1','超薄高性能魅力难挡——三星i9100 三星i9100的机身厚度仅有8.49毫米，而优秀的机身做工也是带来了细腻的手感，该机采用了主流的直板触控造型设计，棱角分明的机身配合背后的纹路设计，使其在视觉和质感方面都表现时尚大气。','1333953193','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1SQyRXc0lXXcb71o._112053.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1SQyRXc0lXXcb71o._112053.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1SQyRXc0lXXcb71o._112053.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1SQyRXc0lXXcb71o._112053.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1SQyRXc0lXXcb71o._112053.jpg\";s:7:\"num_iid\";s:11:\"15560364836\";s:8:\"goodsurl\";s:212:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWbRCb1L2iK5t%2BPsbj8QZjfyVD5t%2Bz0AqDW6cJ7Kn1zJzdjiWUB8kaZrvj6vSLXQssRLo%2B3DFl%2Fla%2Boi57ozOvvhx9pWy%2FBt%2FzTUEu5Lw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=j3uHuWj5\";s:4:\"gurl\";s:8:\"j3uHuWj5\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:68:\"【特价】Samsung/三星 I9100/Galaxy S2 I9100G联保 正品行货\";s:5:\"price\";s:7:\"3468.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",436698606,445407910,436684093,\";s:3:\"cid\";s:4:\"1512\";s:6:\"mwidth\";N;s:7:\"mheight\";N;s:10:\"commission\";s:5:\"34.68\";s:15:\"commission_rate\";s:1:\"2\";}','','0','3468','39','0','1','0','j3uHuWj5','a:1:{i:0;s:6:\"家居\";}','手机');
INSERT INTO ts_weibo VALUES ('1713','1','智宸2012春装新款女装韩版春款连衣裙气质淑女式印花仙女雪纺裙','1333953355','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PfKZXaBuXXabaQ2X_115834.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PfKZXaBuXXabaQ2X_115834.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PfKZXaBuXXabaQ2X_115834.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PfKZXaBuXXabaQ2X_115834.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1PfKZXaBuXXabaQ2X_115834.jpg\";s:7:\"num_iid\";s:11:\"16043036495\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIbicz2Z%2FvhJuZclQzExWefCsl6C2p3xlYHQQw7cQZbMPcvTEgqWaUTK6Uxi6qaeh%2Bt6yriwX3fNPNvOcbCQmtluT3NNkW1FV7jeVJGFmA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=LEYILzxL\";s:4:\"gurl\";s:8:\"LEYILzxL\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:88:\"智宸2012春装新款女装韩版春款连衣裙气质淑女式印花仙女雪纺裙子\";s:5:\"price\";s:6:\"156.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",462797964,462834864,462798606,\";s:3:\"cid\";s:8:\"50010850\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"5.85\";s:15:\"commission_rate\";s:3:\"7.5\";}','','0','156','12','0','0','0','LEYILzxL','a:1:{i:0;s:6:\"衣服\";}','连衣裙');
INSERT INTO ts_weibo VALUES ('1714','1','睿媚娇 2012欧美潮流新款凉鞋坡跟厚底防水台女鞋子鱼嘴超高跟鞋','1334060334','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1pbWZXkRlXXbEMuc2_043611.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1pbWZXkRlXXbEMuc2_043611.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1pbWZXkRlXXbEMuc2_043611.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1pbWZXkRlXXbEMuc2_043611.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1pbWZXkRlXXbEMuc2_043611.jpg\";s:7:\"num_iid\";s:11:\"14695851505\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQzudjisTZ5EWfNDF7%2Bn91Z70Ai9MFOVr7q22sAMN9zr2Dk3hBg%2B6RhmMuYvekst4jJruyG8QoCYvo9qYDUVgQ2PkMCtGiW5n5pQSKLhg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=ywXvRLye\";s:4:\"gurl\";s:8:\"ywXvRLye\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:87:\"睿媚娇  2012欧美潮流新款凉鞋坡跟厚底防水台女鞋子鱼嘴超高跟鞋\";s:5:\"price\";s:5:\"68.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",369302285,369302286,370661192,436589604,\";s:3:\"cid\";s:8:\"50012032\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.55\";s:15:\"commission_rate\";s:3:\"7.5\";}','','0','68','12','0','0','0','ywXvRLye','a:1:{i:0;s:6:\"鞋子\";}','凉鞋');
INSERT INTO ts_weibo VALUES ('1715','1','别致独特的剪裁，个性新颖的设计，将女人味和民族风融合，将古典韵味和现代时尚重叠。淡彩水墨印花，散发着含蓄婉约气质。下摆不规则剪裁，配以纽扣装饰开叉设计，让人有耳目一新之感。','1333953502','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1BbqSXj8jXXbWnQTX_085824.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1BbqSXj8jXXbWnQTX_085824.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1BbqSXj8jXXbWnQTX_085824.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1BbqSXj8jXXbWnQTX_085824.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1BbqSXj8jXXbWnQTX_085824.jpg\";s:7:\"num_iid\";s:11:\"12747464863\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKkWFVgG6mGHdWciA4C0pS3ULQbBYKeIbshMSmOqW3cWDuoPetCh6HTvn0s%2FKOuso7i9RXXLCaxeyQT%2Bm5%2BUn61rD%2BNQVpTVY%2Bksf0rpg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=OVAJQ6fQ\";s:4:\"gurl\";s:8:\"OVAJQ6fQ\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:75:\"谷纱青花瓷春秋淑女圆领印花长袖大码女装T恤C.S511QT包邮\";s:5:\"price\";s:6:\"128.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",382798479,201253645,443528478,\";s:3:\"cid\";s:8:\"50000671\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"4.16\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','128','12','1','0','0','OVAJQ6fQ','a:1:{i:0;s:6:\"衣服\";}','T恤');
INSERT INTO ts_weibo VALUES ('1716','1','周末疯狂购 淘金币 MeetMe2012新款韩版蕾丝花边雪纺打底连衣裙子','1333953605','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Jba7Xo8uXXcwrbvc_095836.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Jba7Xo8uXXcwrbvc_095836.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Jba7Xo8uXXcwrbvc_095836.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Jba7Xo8uXXcwrbvc_095836.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Jba7Xo8uXXcwrbvc_095836.jpg\";s:7:\"num_iid\";s:11:\"13920698828\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOf%2BAU7Cxb43dM%2FRGPzYkZyE6YCPMP7%2BjA4H6vWJQkdEFNDB2VgLlUnJ06k9nbyLJ91O28gWjK6uUORC02pD2v715qugYsABGM66aUczg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=2JdhSkDY\";s:4:\"gurl\";s:8:\"2JdhSkDY\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:84:\"周末疯狂购 淘金币 MeetMe2012新款韩版蕾丝花边雪纺打底连衣裙子\";s:5:\"price\";s:6:\"189.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",353656193,\";s:3:\"cid\";s:8:\"50010850\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"17.72\";s:15:\"commission_rate\";s:5:\"18.75\";}','','0','189','12','0','0','0','2JdhSkDY','a:1:{i:0;s:6:\"衣服\";}','连衣裙');
INSERT INTO ts_weibo VALUES ('1717','1','#防晒美白速成大法#代购正品Kiehl\'s契尔氏科颜氏特效补水保湿/眼部防晒棒SPF30/4g','1333956220','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1i8CTXa0uXXc8L4.8_101026.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1i8CTXa0uXXc8L4.8_101026.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1i8CTXa0uXXc8L4.8_101026.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1i8CTXa0uXXc8L4.8_101026.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1i8CTXa0uXXc8L4.8_101026.jpg\";s:7:\"num_iid\";s:10:\"8310197786\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZTwBXqYiOxqeQ529hY3o%2FDmpvKbk5y%2B0xahR7fwFZPKU5Om%2BDXUDKoLgDtPqZ27fqi5YJUYeXgWN0Vr2v3lNwjdEqRq0VSiw6yIiv2s%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=6PVzUWqJ\";s:4:\"gurl\";s:8:\"6PVzUWqJ\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"代购正品Kiehl\'s契尔氏科颜氏特效补水保湿/眼部防晒棒SPF30/4g\";s:5:\"price\";s:6:\"188.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",344627838,344628619,344615426,353051508,344627004,\";s:3:\"cid\";s:8:\"50011982\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:212;s:10:\"commission\";s:4:\"1.41\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','188','23','0','0','0','6PVzUWqJ','a:1:{i:0;s:6:\"美妆\";}','防晒');
INSERT INTO ts_weibo VALUES ('1718','1','#防晒美白速成大法#代购正品Kiehl\'s契尔氏科颜氏特效补水保湿/眼部防晒棒SPF30/4g','1333956299','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1QK92XnFfXXaqiMg7_064542.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1QK92XnFfXXaqiMg7_064542.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1QK92XnFfXXaqiMg7_064542.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1QK92XnFfXXaqiMg7_064542.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1QK92XnFfXXaqiMg7_064542.jpg\";s:7:\"num_iid\";s:11:\"14831179443\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ9qX0%2F%2FYLQnir2z8VYHzaBJNzbUxkSn%2Ffsv7RuHJZeFgu1WKHPGl8jHwNsOCm0KSbRMETxJr9CgbWE1imZK1mAAHqc87ZBYjpJ058H&amp;p=mm_18680880_0_0&amp;n=19&amp;u=eKuUHiQc\";s:4:\"gurl\";s:8:\"eKuUHiQc\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:71:\"草家*补水美白玫瑰花水 保湿补水美白防皱必备爽肤水\";s:5:\"price\";s:5:\"32.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",421257564,\";s:3:\"cid\";s:8:\"50011978\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:213;s:10:\"commission\";s:4:\"0.48\";s:15:\"commission_rate\";s:1:\"3\";}','','0','32','23','0','1','0','eKuUHiQc','a:1:{i:0;s:6:\"美妆\";}','化妆水/爽肤水');
INSERT INTO ts_weibo VALUES ('1719','1','呛口小辣椒女草帽韩版遮阳帽太阳帽沙滩帽女士帽子夏天牛仔帽夏季','1333956709','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg\";s:7:\"num_iid\";s:11:\"15397836487\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWdH0Powp2G7D90EzR0sQtg397kN1w6SclPnRzOVF1PkOMRdV4iRZjYyHfY1ado%2BtAV%2F0KJjKQj%2FfpuXQr4nhdMyaerOSdHEsEWSk05&amp;p=mm_18680880_0_0&amp;n=19&amp;u=J7DVBfoO\";s:4:\"gurl\";s:8:\"J7DVBfoO\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:90:\"呛口小辣椒女草帽韩版遮阳帽太阳帽沙滩帽女士帽子夏天牛仔帽夏季\";s:5:\"price\";s:5:\"79.90\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",397205905,444993462,203588876,175350757,101783731,\";s:3:\"cid\";s:6:\"302910\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"1.4\";s:15:\"commission_rate\";s:3:\"3.5\";}','','0','80','13','0','0','0','J7DVBfoO','a:1:{i:0;s:6:\"配饰\";}','帽子');
INSERT INTO ts_weibo VALUES ('1720','1','#防晒美白速成大法#很好的仿风骨，超轻的质地，  是小巧的铅笔伞系列，  但是比以往的伞面要大不少， 很好的涂层可以达到防UV95%。 一把更加贴近时尚的晴雨2用的好选择。 这款蕾丝，很优雅，很耐看。 配搭品，没有折扣。','1334310728','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:97:\"http://img01.taobaocdn.com/bao/uploaded/i1/136665101/T2Koh4XXxXXXXXXXXX_!!136665101.jpg_60x60.jpg\";s:10:\"middle_pic\";s:100:\"http://img01.taobaocdn.com/bao/uploaded/i1/136665101/T2Koh4XXxXXXXXXXXX_!!136665101.jpg_210x1000.jpg\";s:7:\"big_pic\";s:99:\"http://img01.taobaocdn.com/bao/uploaded/i1/136665101/T2Koh4XXxXXXXXXXXX_!!136665101.jpg_310x310.jpg\";s:6:\"picurl\";s:99:\"http://img01.taobaocdn.com/bao/uploaded/i1/136665101/T2Koh4XXxXXXXXXXXX_!!136665101.jpg_160x160.jpg\";s:11:\"originalurl\";s:87:\"http://img01.taobaocdn.com/bao/uploaded/i1/136665101/T2Koh4XXxXXXXXXXXX_!!136665101.jpg\";s:7:\"num_iid\";s:11:\"12960077467\";s:8:\"goodsurl\";s:46:\"http://item.taobao.com/item.htm?id=12960077467\";s:4:\"gurl\";s:8:\"9SdnwtXP\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:62:\"日本单 优雅蕾丝 铅笔伞(不参加包邮) 自留推荐\";s:5:\"price\";s:5:\"59.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:11:\",314867560,\";s:3:\"cid\";s:6:\"210211\";s:6:\"mwidth\";N;s:7:\"mheight\";N;}','','0','59','3','0','0','0','9SdnwtXP','a:1:{i:0;s:6:\"家居\";}','伞');
INSERT INTO ts_weibo VALUES ('1721','1','#防晒美白速成大法#超时尚的一款复古太阳镜，很多明星都有戴哦。','1333956881','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1KEaeXllxXXatBQ3V_021441.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1KEaeXllxXXatBQ3V_021441.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1KEaeXllxXXatBQ3V_021441.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1KEaeXllxXXatBQ3V_021441.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1KEaeXllxXXatBQ3V_021441.jpg\";s:7:\"num_iid\";s:10:\"4818239059\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTaWhqjJFd6h5UpBAN5UeWNQmWW4g%2FrvZrFc%2BWklA3R1PxCQUEpe%2BJKccammrujfYqgBDSXDb1jQ84odJFTyyq8x1FrYK%2BFHQWhD6l6aEB&amp;p=mm_18680880_0_0&amp;n=19&amp;u=0verQBAz\";s:4:\"gurl\";s:8:\"0verQBAz\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"2012明星款 欧美复古大框太阳眼镜 珍珠太阳镜 女时尚墨镜 偏光镜\";s:5:\"price\";s:6:\"158.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",349522709,356731671,281770853,\";s:3:\"cid\";s:8:\"50010368\";s:6:\"mwidth\";N;s:7:\"mheight\";N;s:10:\"commission\";s:4:\"2.37\";s:15:\"commission_rate\";s:1:\"3\";}','','0','158','13','0','0','0','0verQBAz','a:1:{i:0;s:6:\"美妆\";}','太阳眼镜');
INSERT INTO ts_weibo VALUES ('1722','1','#防晒美白速成大法#这款唇膏很多明星都在用，天然有机成份，同时具有防晒效果，小小的圆球很可爱。','1333957016','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T13COCXfhZXXb3cqo._110939.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T13COCXfhZXXb3cqo._110939.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T13COCXfhZXXb3cqo._110939.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T13COCXfhZXXb3cqo._110939.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T13COCXfhZXXb3cqo._110939.jpg\";s:7:\"num_iid\";s:11:\"13435731317\";s:8:\"goodsurl\";s:212:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOSJ4plldMvhb%2Fex5Q497i%2Fkpc7b7ZzX%2BPgK60GD%2BhuU9AIKNgzEnUbegexSWoR5PB12ix5rIGZv%2B1YDcj2DRq2LkKSCwo3Edz9%2F%2FKgCw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=nF3EaqMY\";s:4:\"gurl\";s:8:\"nF3EaqMY\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:76:\"正品 TUTU球形天然有机防晒润唇膏7g 保湿滋润护唇膏 4种选\";s:5:\"price\";s:5:\"12.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",413419884,413423003,\";s:3:\"cid\";s:8:\"50010808\";s:6:\"mwidth\";N;s:7:\"mheight\";N;s:10:\"commission\";s:3:\"0.3\";s:15:\"commission_rate\";s:1:\"5\";}','','0','12','23','0','0','0','nF3EaqMY','a:1:{i:0;s:6:\"美妆\";}','唇膏/口红');
INSERT INTO ts_weibo VALUES ('1723','1','#防晒美白速成大法#The Face Shop牛奶美白身体乳液/滋润肤乳/防晒润肤露/保湿香体乳','1333957147','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1cwXEXiXvXXXmPTA6_062838.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1cwXEXiXvXXXmPTA6_062838.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1cwXEXiXvXXXmPTA6_062838.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1cwXEXiXvXXXmPTA6_062838.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1cwXEXiXvXXXmPTA6_062838.jpg\";s:7:\"num_iid\";s:10:\"9563358498\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPx1nXdzS9uNck5y0lozej1AO%2BKE9f6eLSa5eXnx%2BYs5ZeYS%2BvPDYsWPsZ9PJBnKs4njFYBbN9ZpR1Ggnmn6opJ6hcbBN85YPVZLnyis&amp;p=mm_18680880_0_0&amp;n=19&amp;u=DB8qjklj\";s:4:\"gurl\";s:8:\"DB8qjklj\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:82:\"The Face Shop牛奶美白身体乳液/滋润肤乳/防晒润肤露/保湿香体乳\";s:5:\"price\";s:5:\"48.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",273108338,\";s:3:\"cid\";s:8:\"50011983\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.88\";s:15:\"commission_rate\";s:2:\"12\";}','','0','48','23','0','0','0','DB8qjklj','a:1:{i:0;s:6:\"美妆\";}','身体护理');
INSERT INTO ts_weibo VALUES ('1724','2','i think every girl will like this','1333958524','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0409/16/108c80085d7e64bfa450c0ba9fe0c992_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0409/16/108c80085d7e64bfa450c0ba9fe0c992_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0409/16/108c80085d7e64bfa450c0ba9fe0c992_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0409/16/108c80085d7e64bfa450c0ba9fe0c992.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:300;}','','0','0','126','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1726','2','夏天到了，置备一件美美的泳衣到海边释放欢笑和美丽吧~','1333960915','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0409/16/ccc409dade765826f07b142bca176901_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0409/16/ccc409dade765826f07b142bca176901_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0409/16/ccc409dade765826f07b142bca176901_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0409/16/ccc409dade765826f07b142bca176901.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:285;}','','0','0','126','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1727','2','it looks fun,oneday i will try this','1333960994','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0409/16/77730ca2f3c2d7b6dd02e8ad6e3df311_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0409/16/77730ca2f3c2d7b6dd02e8ad6e3df311_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0409/16/77730ca2f3c2d7b6dd02e8ad6e3df311_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0409/16/77730ca2f3c2d7b6dd02e8ad6e3df311.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:305;}','','0','0','195','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1728','1','水晶香薰灯，五彩缤纷的，闪亮闪亮的，偶尔的浪漫是每个女孩子的心结吧~','1333961134','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0409/16/59b9e8b565ef7aa5be318cd573d40786_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0409/16/59b9e8b565ef7aa5be318cd573d40786_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0409/16/59b9e8b565ef7aa5be318cd573d40786_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0409/16/59b9e8b565ef7aa5be318cd573d40786.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:289;}','','0','0','284','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1729','1','【五种果汁击退黑眼圈】①苹果胡萝卜菠菜汁：苹果、胡萝卜、菠菜和芹菜切成小块打碎，加牛奶、蜂蜜；②香蕉木瓜酸奶：香蕉、木瓜和酸奶打碎；③猕猴桃橙子柠檬汁：两个猕猴桃、四个橙子、一个柠檬；④柚子葡萄汁：三个柚子、一串葡萄打碎，加两匙蜂蜜；⑤黄瓜薄荷豆浆：一根黄瓜、半升豆浆、三片薄荷。','1333961349','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0409/16/d868e006dd3a85a0eee65aa1e421466b_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0409/16/d868e006dd3a85a0eee65aa1e421466b_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0409/16/d868e006dd3a85a0eee65aa1e421466b_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0409/16/d868e006dd3a85a0eee65aa1e421466b.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:218;}','','0','0','24','1','0','0','','','');
INSERT INTO ts_weibo VALUES ('1733','1','艺术创意挂钟，超静音。','1333962308','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1RP9QXfdnXXcqKM6b_124217.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1RP9QXfdnXXcqKM6b_124217.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1RP9QXfdnXXcqKM6b_124217.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1RP9QXfdnXXcqKM6b_124217.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1RP9QXfdnXXcqKM6b_124217.jpg\";s:7:\"num_iid\";s:10:\"9381904365\";s:8:\"goodsurl\";s:192:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPptN3qAnkBku39MUM68ZuHOTdyrj7GcvwXmP4Yz9tUEtoe%2F5pfYfkhUfxeYMH84i9b1mvxHbMjAJO21rdT2IPi0ynRFK7DyR3EDfRnq&amp;p=mm_18680880_0_0&amp;n=19&amp;u=dIuessTO\";s:4:\"gurl\";s:8:\"dIuessTO\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"麦丁/ 包邮钟表电子挂钟客厅静音时尚艺术创意时钟万年历245\";s:5:\"price\";s:5:\"69.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",403269333,248744021,\";s:3:\"cid\";s:8:\"50001283\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.59\";s:15:\"commission_rate\";s:3:\"7.5\";}','','0','69','284','1','1','0','dIuessTO','a:1:{i:0;s:6:\"家居\";}','挂钟');
INSERT INTO ts_weibo VALUES ('1734','1','非常漂亮的孔雀台灯，个性婚庆用品。','1333962402','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qJW0XXdhXXbKSAYa_092057.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qJW0XXdhXXbKSAYa_092057.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qJW0XXdhXXbKSAYa_092057.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qJW0XXdhXXbKSAYa_092057.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1qJW0XXdhXXbKSAYa_092057.jpg\";s:7:\"num_iid\";s:10:\"7371793468\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTarIjrZmiYxeUMOMxKHDfaI5lXG8%2BSQ%2FbtIa3LfpUgyjZlaTujyfdYrpF55UwvSg7MaTC4zg0cj%2Fnb78H%2B%2BA%2B5OFzH2eA3B0UhhEz3JyH&amp;p=mm_18680880_0_0&amp;n=19&amp;u=wwbUdss6\";s:4:\"gurl\";s:8:\"wwbUdss6\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"孔雀 欧式台灯 婚庆礼品 结婚礼物 实用 婚房 创意 家居软装饰品\";s:5:\"price\";s:6:\"258.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",362651998,362722617,362697125,\";s:3:\"cid\";s:8:\"50020835\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"21.93\";s:15:\"commission_rate\";s:2:\"17\";}','','0','258','284','0','1','0','wwbUdss6','a:1:{i:0;s:6:\"家居\";}','摆件');
INSERT INTO ts_weibo VALUES ('1735','1','可爱粉嫩双人沙发收纳盒，韩式浪漫公主化妆盒','1333962504','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1h0aMXmBjXXXq0E3V_021950.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1h0aMXmBjXXXq0E3V_021950.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1h0aMXmBjXXXq0E3V_021950.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1h0aMXmBjXXXq0E3V_021950.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1h0aMXmBjXXXq0E3V_021950.jpg\";s:7:\"num_iid\";s:11:\"14126831258\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ0EVdJhoN90E1x3wj26GznM3QityhzPLIoob3W%2BBvYewGECrvg8Fh8dR2Imb9LeNyeDMQURMtSHmh%2BYOAuDLpOz5JknX67R%2FNU60LhfQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=iIeOCDtt\";s:4:\"gurl\";s:8:\"iIeOCDtt\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:81:\"公主 沙发 首饰盒 欧式 化妆盒 饰品盒 收纳 首饰架 婚庆 韩国\";s:5:\"price\";s:5:\"25.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",436219040,436219043,\";s:3:\"cid\";s:8:\"50013881\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"0.815\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','25','284','0','0','0','iIeOCDtt','a:1:{i:0;s:6:\"家居\";}','首饰盒/展示架');
INSERT INTO ts_weibo VALUES ('1736','1','创意玩偶手机座 可爱韩国毛绒玩具 布娃娃 卡通手机座 婚礼小礼物','1333962560','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OGK2XcppXXXkpSs5_060052.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OGK2XcppXXXkpSs5_060052.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OGK2XcppXXXkpSs5_060052.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OGK2XcppXXXkpSs5_060052.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OGK2XcppXXXkpSs5_060052.jpg\";s:7:\"num_iid\";s:10:\"8657846902\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZTlRKNQILKC%2BDHpEPOUTlJ5kmTyx1TbVmKHhpeCk3sTQtZFibPuTVHICkZZy70GhOzJYWWVAPz6uBtCrsCclBQxnlPFvN3%2Fq61HoYkM9&amp;p=mm_18680880_0_0&amp;n=19&amp;u=cLDaP53s\";s:4:\"gurl\";s:8:\"cLDaP53s\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:88:\"创意玩偶手机座 可爱韩国毛绒玩具 布娃娃 卡通手机座 婚礼小礼物\";s:5:\"price\";s:4:\"9.80\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",278589322,283672820,\";s:3:\"cid\";s:8:\"50011975\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"0.27\";s:15:\"commission_rate\";s:3:\"5.5\";}','','0','10','284','0','0','0','cLDaP53s','a:1:{i:0;s:6:\"家居\";}','毛绒布艺类玩具');
INSERT INTO ts_weibo VALUES ('1737','1','三星I9100本身采用了旗下更好的Super AMOLED Plus材质，可以为你呈现出来艳丽鲜明的画面感，而WVGA级别的分辨率在它身上也被发挥的比较彻底，显示清晰并没有什么颗粒感存在。','1333962706','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Uxu7XXXkXXadoZgZ_031536.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Uxu7XXXkXXadoZgZ_031536.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Uxu7XXXkXXadoZgZ_031536.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Uxu7XXXkXXadoZgZ_031536.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1Uxu7XXXkXXadoZgZ_031536.jpg\";s:7:\"num_iid\";s:11:\"12404420026\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKnWDny3WsBp2Uu%2FTXcDCQ0dRFtRNrNa7QkfMq4JFHVWS7qFF8SaI1uVU1z41LLiZMu5GcEKqWBscSdc3SHlMZEXh2r6pmCFOomm5kyIg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=bbQSJx8n\";s:4:\"gurl\";s:8:\"bbQSJx8n\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:71:\"Samsung/三星 I9100/Galaxy S2 I9100G 行货 送电保包 包邮 送壳\";s:5:\"price\";s:7:\"3499.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:71:\",431687286,431393101,451738917,451738916,431385816,431390667,431687259,\";s:3:\"cid\";s:4:\"1512\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"17.495\";s:15:\"commission_rate\";s:1:\"1\";}','','0','3499','39','1','0','0','bbQSJx8n','a:1:{i:0;s:6:\"家居\";}','手机');
INSERT INTO ts_weibo VALUES ('1738','1','魔镜一般的酷炫外表，而且还是有内涵的USB分线器','1333962814','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1MzCDXaliXXad.Qs9_104252.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1MzCDXaliXXad.Qs9_104252.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1MzCDXaliXXad.Qs9_104252.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1MzCDXaliXXad.Qs9_104252.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1MzCDXaliXXad.Qs9_104252.jpg\";s:7:\"num_iid\";s:11:\"13318532382\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOVvWGjOE9MGNs2pJgHQiLh%2FxKKg7QQ%2F%2BsrHhYo3Nc5S83WM4wsDD%2FUFpC1xoRW3Su3FwKtrplZ0cfWJ2wDA6DVT3XhREXwhSp6rD%2FerQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=TBtN9jen\";s:4:\"gurl\";s:8:\"TBtN9jen\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:76:\"包邮 思镭克 魔镜 HUB 分线器 集线器 USB2.0分接口 线长0.8米\";s:5:\"price\";s:5:\"28.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",360484824,468487535,\";s:3:\"cid\";s:8:\"50003333\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"0.98\";s:15:\"commission_rate\";s:1:\"7\";}','','0','28','284','0','0','0','TBtN9jen','a:1:{i:0;s:6:\"家居\";}','其它电脑周边');
INSERT INTO ts_weibo VALUES ('1739','1','超可爱的OSDY粉色拉杆箱，可爱旅行箱包女生最爱','1333962939','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Ioy6XnxjXXcErmcT_013023.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Ioy6XnxjXXcErmcT_013023.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Ioy6XnxjXXcErmcT_013023.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Ioy6XnxjXXcErmcT_013023.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1Ioy6XnxjXXcErmcT_013023.jpg\";s:7:\"num_iid\";s:11:\"12759922508\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKkWXWZIvaDUOTCz1Z0K0%2FmZwIeRoJxIO%2BdTnK5gVA82CNB38aFYA9%2FCSPaxyyGSuKoLrc5vMnQ4RcZHdWc8x8Wzb5U1elSVvT9uvoqyg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=beYdOWNk\";s:4:\"gurl\";s:8:\"beYdOWNk\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"OSDY粉色abs 儿童 拉杆箱 20寸 可爱 旅行箱包 万向轮 女生 24寸\";s:5:\"price\";s:6:\"398.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:81:\",471241806,287888131,235713846,235713847,235713849,269714509,269714505,235713855,\";s:3:\"cid\";s:8:\"50012019\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"12.935\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','398','284','1','0','0','beYdOWNk','a:1:{i:0;s:6:\"家居\";}','旅行箱');
INSERT INTO ts_weibo VALUES ('1740','1','#防晒美白速成大法#这是一瓶经得起考验的防晒霜，清爽的乳液质地，令您不敢相信自己是在使用防晒霜。','1333974167','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1rSmUXaBsXXcrW1wW_022950.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1rSmUXaBsXXcrW1wW_022950.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1rSmUXaBsXXcrW1wW_022950.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1rSmUXaBsXXcrW1wW_022950.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1rSmUXaBsXXcrW1wW_022950.jpg\";s:7:\"num_iid\";s:11:\"15681404786\";s:8:\"goodsurl\";s:210:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWYJSswiajCz%2BveKa73IzPG6OhqlQ1mBFOooblbhtDuxmpz%2FLomVUfl%2BsI%2BvI%2BlPcQlr8urcvMjuzM%2BcmmOrG2nHHxlrxZQS0sUOye2Vw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=tEz1Ams9\";s:4:\"gurl\";s:8:\"tEz1Ams9\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"原装进口格兰玛弗兰安娜亚马逊防晒霜正品40mlSPF30+保湿隔离持久\";s:5:\"price\";s:6:\"168.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",404554461,409922323,409922322,409922321,409922320,404920130,\";s:3:\"cid\";s:8:\"50011982\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"14.02\";s:15:\"commission_rate\";s:5:\"16.69\";}','','0','168','23','0','0','0','tEz1Ams9','a:1:{i:0;s:6:\"美妆\";}','防晒');
INSERT INTO ts_weibo VALUES ('1741','1','#防晒美白速成大法#清新的玫瑰味，浪漫又提神，夏天了，防晒的同时也要做好美白全身的护理。','1333974315','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1gFyNXcxvXXcpbeg8_100230.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1gFyNXcxvXXcpbeg8_100230.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1gFyNXcxvXXcpbeg8_100230.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1gFyNXcxvXXcpbeg8_100230.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1gFyNXcxvXXcpbeg8_100230.jpg\";s:7:\"num_iid\";s:11:\"12464270922\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKnXjEo7udreqOUHFYnTOMtp3IX8H8AsT69A0gatjymZ8kT2fKnswAf2kVdT3j%2B1HpjBrM6LIo5JL8bki1f8Y4kC%2Fm%2Fm%2Bo95WLDf2lQXQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=7km2EMki\";s:4:\"gurl\";s:8:\"7km2EMki\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"包邮 乐蔓英国小浴缸 粉嫩亮白身体护理套装 美白护肤ARM0001\";s:5:\"price\";s:5:\"99.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",460678125,460660444,459898583,459352349,\";s:3:\"cid\";s:8:\"50011983\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"2.475\";s:15:\"commission_rate\";s:1:\"5\";}','','0','99','23','1','1','0','7km2EMki','a:1:{i:0;s:6:\"美妆\";}','身体护理');
INSERT INTO ts_weibo VALUES ('1742','1','#防晒美白速成大法#大名鼎鼎的雅顿润唇膏，8小时滋润，还具备防晒效果，夏天到了，好好保护你的双唇吧。','1333974384','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rft0Xj0DXXbof1UY_025934.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rft0Xj0DXXbof1UY_025934.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rft0Xj0DXXbof1UY_025934.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rft0Xj0DXXbof1UY_025934.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1rft0Xj0DXXbof1UY_025934.jpg\";s:7:\"num_iid\";s:10:\"3484321654\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbjSoEuy6FWTZVn9iNU39e7r6Y5V%2B7yodM1MYzW8nky%2FNPlZKMHKSg%2FqW0AmFyLVe%2Bo8NsVpjZHqBWmHQEB9e8znCBjW0O97boOUm&amp;p=mm_18680880_0_0&amp;n=19&amp;u=P95P28kK\";s:4:\"gurl\";s:8:\"P95P28kK\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:70:\"正品!雅顿8小时显效防晒润唇膏3.7G-SPF15 滋润保湿护唇\";s:5:\"price\";s:5:\"78.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:39:\",448840912,26551412,353212335,26611018,\";s:3:\"cid\";s:8:\"50011994\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.34\";s:15:\"commission_rate\";s:1:\"6\";}','','0','78','23','0','0','0','P95P28kK','a:1:{i:0;s:6:\"美妆\";}','唇部护理');
INSERT INTO ts_weibo VALUES ('1743','1','#防晒美白速成大法#不仅可以吸收多余油脂，连口红，腮红等一些难处理的彩妆也一扫干净！夏天必须品。','1333974490','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OIe8XoBeXXaVOy3V_020903.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OIe8XoBeXXaVOy3V_020903.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OIe8XoBeXXaVOy3V_020903.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OIe8XoBeXXaVOy3V_020903.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1OIe8XoBeXXaVOy3V_020903.jpg\";s:7:\"num_iid\";s:10:\"6197006352\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTa0eQ%2FNgQ8v74NQ7S%2FNY%2BvaL7ua8IgFq3Y0Hx6iNaXL%2Bx2vq%2FeZA4WvCSlRWmpTspGZLXURWsljYRvY%2BPa5kOCLXz5orvplwkjnveAqQ%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=yGx42Rnn\";s:4:\"gurl\";s:8:\"yGx42Rnn\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"专柜代购FANCL 无添加天然麻吸油面纸/吸油纸100张长款 美善堂\";s:5:\"price\";s:5:\"19.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",291291527,291291513,458628107,458628108,454204049,290927272,\";s:3:\"cid\";s:8:\"50011995\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"0.145\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','19','23','1','0','0','yGx42Rnn','a:1:{i:0;s:6:\"美妆\";}','T区护理');
INSERT INTO ts_weibo VALUES ('1744','1','传爱小精灵，你的爱情草，超萌造型，种植简单，妆点生活。','1333976303','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1K05SXgpdXXXecfLb_093737.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1K05SXgpdXXXecfLb_093737.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1K05SXgpdXXXecfLb_093737.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1K05SXgpdXXXecfLb_093737.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1K05SXgpdXXXecfLb_093737.jpg\";s:7:\"num_iid\";s:10:\"2748563317\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTb0FqaUGWuzgNTfuooh0IecFsW7%2BRKY%2FEt9x7tfnR5NV7%2FJziJMBS5Hfp4Y6hh%2FDKMYtnjTl9PAaOL01gIPsd1mgz3hTWHfoNWIrracY%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=BkdtXrwr\";s:4:\"gurl\";s:8:\"BkdtXrwr\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:90:\"传爱精灵送男生的生日礼物创意女友男友特别礼品女生新奇特好玩的\";s:5:\"price\";s:5:\"14.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",146818151,146818149,111440785,114002404,128399735,\";s:3:\"cid\";s:8:\"50015992\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"0.56\";s:15:\"commission_rate\";s:1:\"8\";}','','0','14','285','1','0','0','BkdtXrwr','a:1:{i:0;s:6:\"家居\";}','创意/整蛊玩具');
INSERT INTO ts_weibo VALUES ('1745','1','超漂亮的手工粘贴式音乐相册，个性相册。','1333976403','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tbmBXnVHXXc3NVk._081121.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tbmBXnVHXXc3NVk._081121.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tbmBXnVHXXc3NVk._081121.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tbmBXnVHXXc3NVk._081121.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img06.taobaocdn.com/bao/uploaded/i6/T1tbmBXnVHXXc3NVk._081121.jpg\";s:7:\"num_iid\";s:10:\"8586199563\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZTpFd6acUS96vNn9B6lFILwKjbxNP%2FHQOUsY4AmhPveXisPv4Q4wGHzmF05fSYRhBN9rVQohgfblxSOaHGGk%2BTO8ZU6MybK881AduZiM&amp;p=mm_18680880_0_0&amp;n=19&amp;u=UiZnMBrG\";s:4:\"gurl\";s:8:\"UiZnMBrG\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:83:\"木木好玩 8寸大本超漂亮高档 diy手工自粘式 音乐相册影集 彩虹\";s:5:\"price\";s:6:\"148.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",275105911,275105915,275105912,\";s:3:\"cid\";s:8:\"50003463\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"8.695\";s:15:\"commission_rate\";s:5:\"11.75\";}','','0','148','285','1','0','0','UiZnMBrG','a:1:{i:0;s:6:\"家居\";}','相册/相簿');
INSERT INTO ts_weibo VALUES ('1746','1','14头Q版可爱熊猫餐具，创意陶瓷餐具可爱熊猫碗','1333976573','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1aPOMXixlXXXi_3k2_044159.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1aPOMXixlXXXi_3k2_044159.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1aPOMXixlXXXi_3k2_044159.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1aPOMXixlXXXi_3k2_044159.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1aPOMXixlXXXi_3k2_044159.jpg\";s:7:\"num_iid\";s:11:\"12987538815\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq%2BjaS9ugPZGv5IZqpxUNEAee3nc3HCh%2FhqYvyKNTQ7pQfTiKtRliYeNrw4AD6lqjjkoaRbU2ygYDrTwJ2LJC2A%2FnoYRt2kWHjS2r4jA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=7PC0mmOf\";s:4:\"gurl\";s:8:\"7PC0mmOf\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"日日和 14头Q版可爱熊猫餐具 骨瓷餐具 创意陶瓷餐具 可爱熊猫碗\";s:5:\"price\";s:6:\"338.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",432420600,334492386,\";s:3:\"cid\";s:8:\"50002797\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"12.675\";s:15:\"commission_rate\";s:3:\"7.5\";}','','0','338','284','1','0','0','7PC0mmOf','a:1:{i:0;s:6:\"家居\";}','餐具瓷器套装');
INSERT INTO ts_weibo VALUES ('1747','1','铝合金带风扇散热笔记本电脑桌 折叠桌 床上电脑桌 按下关节按扭，就可以调节支架角度与高度；松开按钮弹出，“咔嚓”一声响，关节就自动锁定。','1333976812','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1p0CWXn0dXXX2_Y3._111449.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1p0CWXn0dXXX2_Y3._111449.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1p0CWXn0dXXX2_Y3._111449.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1p0CWXn0dXXX2_Y3._111449.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1p0CWXn0dXXX2_Y3._111449.jpg\";s:7:\"num_iid\";s:11:\"13578851814\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOTkU%2FcynOa3f6BfuM1HbF%2BKDqwGxCD1sbE8DDZGRcLDgleujUSF8CdeEKR82JzixPW2Zs%2Bi1Yzn6lf693rV2v049plDzx1ke3uLy6euQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=UFzI2ORy\";s:4:\"gurl\";s:8:\"UFzI2ORy\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"厂家直销 铝合金带风扇散热笔记本电脑桌 折叠桌 床上电脑桌 懒\";s:5:\"price\";s:5:\"86.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",414726892,\";s:3:\"cid\";s:8:\"50003823\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"3.44\";s:15:\"commission_rate\";s:1:\"8\";}','','0','86','284','1','0','0','UFzI2ORy','a:1:{i:0;s:6:\"家居\";}','电脑桌');
INSERT INTO ts_weibo VALUES ('1748','1','伊奈大型壁画 壁纸电视墙背景 客厅电视背景墙纸 简约 国色天香 绚丽花朵，典雅高贵，彰显富贵气质,访客若是看到客厅中的这幅画，定会赞许您独到的慧眼的','1333977229','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1K4etXdVzXXbQfDba_092345.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1K4etXdVzXXbQfDba_092345.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1K4etXdVzXXbQfDba_092345.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1K4etXdVzXXbQfDba_092345.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1K4etXdVzXXbQfDba_092345.jpg\";s:7:\"num_iid\";s:11:\"12936174547\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq8ZyZ7SzHEyIhJPgJmueWVFQhwMe%2BTUiBCIy7Dc4mr5ZKLvR4ZGDF8VHYyjO5Fo8zLaqmjIQVXL9F3O4Cm9kg%2ByC58%2BxmtTODp4BbCg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=ujHqjETS\";s:4:\"gurl\";s:8:\"ujHqjETS\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"伊奈大型壁画 壁纸电视墙背景 客厅电视背景墙纸 简约 国色天香\";s:5:\"price\";s:6:\"138.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",404311069,404311074,404311075,404311073,\";s:3:\"cid\";s:8:\"50024688\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"13.8\";s:15:\"commission_rate\";s:2:\"20\";}','','0','138','3','1','1','0','ujHqjETS','a:1:{i:0;s:6:\"家居\";}','PVC墙纸');
INSERT INTO ts_weibo VALUES ('1749','1','玻璃油醋瓶厨房用品调料瓶调料盒创意新奇密封罐 这是实验室的烧瓶？怎么有两个嘴？不对哦，我是啥？你猜~','1333977380','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1jt5xXd4dXXbQXNs9_103557.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1jt5xXd4dXXbQXNs9_103557.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1jt5xXd4dXXbQXNs9_103557.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1jt5xXd4dXXbQXNs9_103557.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1jt5xXd4dXXbQXNs9_103557.jpg\";s:7:\"num_iid\";s:10:\"9352240122\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPpgkyyZGQKUVjJQlsmTSZBtqB6KhIE3XL3%2F8FLSUYyVsnF4%2BH1saUkJ4sJL8d02HzIOYwxZIZZHFHMeJytQTEPnJnDfkhhcLtd2b3NC&amp;p=mm_18680880_0_0&amp;n=19&amp;u=6dqKXf8Z\";s:4:\"gurl\";s:8:\"6dqKXf8Z\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:77:\"预售 玻璃油醋瓶厨房用品调料瓶调料盒创意新奇密封罐1108\";s:5:\"price\";s:5:\"59.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",320376694,\";s:3:\"cid\";s:8:\"50000566\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"4.425\";s:15:\"commission_rate\";s:2:\"15\";}','','0','59','284','1','0','0','6dqKXf8Z','a:1:{i:0;s:6:\"家居\";}','调味瓶罐');
INSERT INTO ts_weibo VALUES ('1750','1','唯美纳简约茶几/韩式/长形茶几/咖啡桌/书桌/小茶几时尚茶几','1334310796','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T14nX.XfthXXXevTYb_095401.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T14nX.XfthXXXevTYb_095401.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T14nX.XfthXXXevTYb_095401.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T14nX.XfthXXXevTYb_095401.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T14nX.XfthXXXevTYb_095401.jpg\";s:7:\"num_iid\";s:10:\"7108784021\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTarDoPwwX8aGHODfSTyz2ga2LwtyDRle3lLyiLVUNWbKAZq%2BP0Vvo3yMcY2ZduC%2B%2FCjnvpQUXvNY2QvfxX4hqXnNtfTjUitc00J4nEXNn&amp;p=mm_18680880_0_0&amp;n=19&amp;u=kb9w2DS4\";s:4:\"gurl\";s:8:\"kb9w2DS4\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"唯美纳简约茶几/韩式/长形茶几/咖啡桌/书桌/小茶几时尚茶几\";s:5:\"price\";s:5:\"40.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",236616762,\";s:3:\"cid\";s:8:\"50001709\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:164;s:10:\"commission\";s:3:\"1.1\";s:15:\"commission_rate\";s:3:\"5.5\";}','','0','40','3','0','0','0','kb9w2DS4','a:1:{i:0;s:6:\"家居\";}','茶几');
INSERT INTO ts_weibo VALUES ('1753','1','女人无法抵挡甜蜜色彩的诱惑，继活跃糖果色之后的活跃荧光色系，成为展示个性的另一上佳选择。溶甜美与性感于一身的荷叶褶皱小上衣将女人多变的一面尽显，时而温婉娴静如“处子”，转瞬妩媚灵动如“脱兔”。','1333983708','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yP9RXjFeXXcchqg0_034224.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yP9RXjFeXXcchqg0_034224.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yP9RXjFeXXcchqg0_034224.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yP9RXjFeXXcchqg0_034224.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yP9RXjFeXXcchqg0_034224.jpg\";s:7:\"num_iid\";s:10:\"9944368437\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPBdUtHQYpoDAiCt5wP%2BrLDcwxU7DBzvP5IlxacjTtKzlfOFWra09Km7VcbeWWoKchdXguhGP3DhtOPheBp%2BWdCJ%2BeVdH69U9Vshnc3I&amp;p=mm_18680880_0_0&amp;n=19&amp;u=LVdrgvXv\";s:4:\"gurl\";s:8:\"LVdrgvXv\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:67:\"乐町2012春季时尚女装新款小褶皱荷叶边上衣LQ1110813\";s:5:\"price\";s:6:\"159.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",413040635,370342817,\";s:3:\"cid\";s:6:\"162116\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"9.94\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','159','12','1','0','0','LVdrgvXv','a:1:{i:0;s:6:\"衣服\";}','蕾丝衫/雪纺衫');
INSERT INTO ts_weibo VALUES ('1754','1','大V领上颜色对比鲜明的亮片拼接制造重金属感元素，明晃晃的银饰色泽闪耀出女人风娇水媚的姿态，这一份让人难以抗拒的冷艳魅力又在神秘黑的推波助澜之下，四处迸裂，一发不可收拾。','1333983750','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1wiOfXbBiXXciR_Z8_071755.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1wiOfXbBiXXciR_Z8_071755.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1wiOfXbBiXXciR_Z8_071755.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1wiOfXbBiXXciR_Z8_071755.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1wiOfXbBiXXciR_Z8_071755.jpg\";s:7:\"num_iid\";s:11:\"10458633274\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIA69RMLWJ8keMyPzv%2FEV4SISR9NXENV0j0UUVJTlPqL0Vtw9QVrLVrazFl9SYu2ZNK%2BUN%2FFSVrs5We77NiVOKUYO85D83EAV4ua7yIwew%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=Wm0lywR9\";s:4:\"gurl\";s:8:\"Wm0lywR9\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:85:\"【年终大促】意大利客供面料性感蕾丝花纹　百搭打底内衣 抹胸\";s:5:\"price\";s:4:\"8.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",467508057,\";s:3:\"cid\";s:8:\"50008888\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"0.68\";s:15:\"commission_rate\";s:2:\"17\";}','','0','8','12','1','0','0','Wm0lywR9','a:1:{i:0;s:6:\"衣服\";}','抹胸');
INSERT INTO ts_weibo VALUES ('1755','1','敢于挑战透视装的妞一定是充满自信的。她们敢于SHOW出自己窈窕的曲线，是一种性感的表现。微透的材质散发无敌的诱惑力，结合衣领的烫片点缀，大有欧美高街时尚范儿。','1333983811','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1zAuUXelnXXaXfpbc_125541.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1zAuUXelnXXaXfpbc_125541.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1zAuUXelnXXaXfpbc_125541.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1zAuUXelnXXaXfpbc_125541.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1zAuUXelnXXaXfpbc_125541.jpg\";s:7:\"num_iid\";s:11:\"13762470119\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOR%2FpPTbVG0d0KuKwkLloGBzXSg7uovFwDcVxBIq%2FMn1WhaZKppv3MOw6GqA5TcH3lkY27JWTHn8jhtLQDZVsJ7wBvoXSr7VuCNu53WXA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=t3MJvPx5\";s:4:\"gurl\";s:8:\"t3MJvPx5\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:82:\"美妃 2012 新款 夏装 雪纺衬衫 雪纺衫 欧美风 黑色 女式衬衣 女\";s:5:\"price\";s:6:\"128.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",398358089,442550739,398358097,\";s:3:\"cid\";s:6:\"162104\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"4.16\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','128','12','0','1','0','t3MJvPx5','a:1:{i:0;s:6:\"衣服\";}','衬衫');
INSERT INTO ts_weibo VALUES ('1756','1','除了强烈视觉冲击感的撞色之外，一抹沁人心田的牛奶粉嫩色系悄然崛起。它不着痕迹地轻轻滑过眼前，却留下惊鸿一瞥的印象。不过值得注意的是，选择粉红的姑娘不可以皮肤不白皙哦！','1333983917','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1mb10XjxnXXXluOjb_124357.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1mb10XjxnXXXluOjb_124357.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1mb10XjxnXXXluOjb_124357.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1mb10XjxnXXXluOjb_124357.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1mb10XjxnXXXluOjb_124357.jpg\";s:7:\"num_iid\";s:11:\"15112304339\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWfoYdTdYEJmxb1lZgOkMBcIQS9Y1HtcGw%2F3Ik3xhD2sIFM1BsO2Ncm7sgamIvK0mAWVo8saHuoZ5XaqIo31573XhAxXNbHZuHw7YbNaQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=Wvz1TjIw\";s:4:\"gurl\";s:8:\"Wvz1TjIw\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"丹慕妮尔2012年新款女装手工盘花优雅中袖欧根莎真丝连衣裙\";s:5:\"price\";s:6:\"588.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",428678103,406430317,414776696,414620104,406430320,\";s:3:\"cid\";s:8:\"50010850\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"24.99\";s:15:\"commission_rate\";s:3:\"8.5\";}','','0','588','12','0','0','0','Wvz1TjIw','a:1:{i:0;s:6:\"衣服\";}','连衣裙');
INSERT INTO ts_weibo VALUES ('1757','1','花朵元素算得上是老生常谈了，但立体款式却容易被忽略之。双生花一般的黑白两款演绎着纯真与成熟的转变。奢美脱俗的精致钉花传递超凡时尚品味，简约而不简单的设计尽显大牌风范。','1333983962','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T12RGOXhxfXXbg4ocY_031030.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T12RGOXhxfXXbg4ocY_031030.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T12RGOXhxfXXbg4ocY_031030.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T12RGOXhxfXXbg4ocY_031030.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T12RGOXhxfXXbg4ocY_031030.jpg\";s:7:\"num_iid\";s:11:\"14211987845\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ3iNIp5GA8V731dOEkSNkJY6VSoGf8k68qCgfHFBLMHQFM48dpCPVuv8r0E108ayqHB13Y4CI7vCMTgtFF5esbum96%2BLZpGRDeIKNsoQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=3Nf3xVzw\";s:4:\"gurl\";s:8:\"3Nf3xVzw\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:77:\"梦芭莎女装正品2012春装新款圆领长袖花朵打底衫T恤032012162\";s:5:\"price\";s:5:\"69.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:71:\",438722621,403326193,409903189,409889983,409903174,403326184,409889985,\";s:3:\"cid\";s:8:\"50000671\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:284;s:10:\"commission\";s:4:\"3.28\";s:15:\"commission_rate\";s:4:\"9.51\";}','','0','69','12','0','0','0','3Nf3xVzw','a:1:{i:0;s:6:\"衣服\";}','T恤');
INSERT INTO ts_weibo VALUES ('1758','1','编织元素充满夏天的味道，看到就恍如听到蝉鸣，闻到草香。似乎对夏天的向往就在编织出现的一瞬间被激发。高贵典雅的香槟色在胸部以上采用镂空编织，极具诱惑力的构造惹人浮想联翩。环形腰带收缩腰间围度，性感之余不忘线条的流畅与优美。','1333984021','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1S457XkJlXXbm4TA._083529.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1S457XkJlXXbm4TA._083529.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1S457XkJlXXbm4TA._083529.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1S457XkJlXXbm4TA._083529.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1S457XkJlXXbm4TA._083529.jpg\";s:7:\"num_iid\";s:11:\"16137160882\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIbjv6kCwQf8z1ucM%2FVBIT%2BzcWdJnKXHt%2BcrK2OGwJ25vFDtDuXEc6QdZI7DFV1kVUOtMA3cZiF1y5vKLLRkoDlJZcvGekI1CSIgiAvuYw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=DH6xTy2I\";s:4:\"gurl\";s:8:\"DH6xTy2I\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:88:\"夏装2012新款欧美名媛高端手工编织镂空真丝气质高贵连衣裙子夏季\";s:5:\"price\";s:6:\"398.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",456674059,354619677,\";s:3:\"cid\";s:8:\"50010850\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:6:\"37.315\";s:15:\"commission_rate\";s:5:\"18.75\";}','','0','398','12','1','0','0','DH6xTy2I','a:1:{i:0;s:6:\"衣服\";}','连衣裙');
INSERT INTO ts_weibo VALUES ('1759','1','在这个穿丝袜秀美腿的时代，是不是有许多MM在担心自己的腿会不会太胖，会不会穿热裤不好看。不用担心！这款唯美蝴蝶系带休闲短裤会很好的掩盖腿部的不足，宽松的颇具层次感的设计很好的将视线转移到你的腿部以上的位置，美美的蝴蝶结系带尽显小蛮腰的妩媚。所以，选择它，你就再也不用担心会显腿胖了哟','1333984090','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1WXxwXdRwXXcQwOQU_014930.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1WXxwXdRwXXcQwOQU_014930.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1WXxwXdRwXXcQwOQU_014930.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1WXxwXdRwXXcQwOQU_014930.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1WXxwXdRwXXcQwOQU_014930.jpg\";s:7:\"num_iid\";s:10:\"9508400175\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPxzEN0gjV0QCYv45ms3MF49ywJlT2z%2BWXr24py7E9z7udKXPafKamGoWUsGH5nT1UEtJYBI8x0pibDXFidFybanyjrOkjxIyp3yau%2FA&amp;p=mm_18680880_0_0&amp;n=19&amp;u=UkUUNyHs\";s:4:\"gurl\";s:8:\"UkUUNyHs\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:87:\"春装2012新款韩版热裤裙裤大码短裤胖mm女潮复古夏季显瘦高腰短裤\";s:5:\"price\";s:5:\"84.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:30:\",96707955,367376796,435890447,\";s:3:\"cid\";s:6:\"162202\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"6.09\";s:15:\"commission_rate\";s:4:\"14.5\";}','','0','84','12','1','0','0','UkUUNyHs','a:1:{i:0;s:6:\"衣服\";}','短裤/热裤');
INSERT INTO ts_weibo VALUES ('1760','1','来源于复古芭蕾元素的设计灵感,让此款裙裤显得异常的富有高雅文艺的气息。虽然同为百褶下摆,却形成了很好了体积感，服帖的依着腿部，沉稳之中不失活泼,同时这样的长度也很好的修饰了臀部,提升腿部线条。最重要的是,这个裤裤还有一个前口袋，插着它会有种酷酷的气场感，而且还可以放些零钱,实用又时尚。','1333984196','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1aM14Xg4rXXa4sZZT_011237.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1aM14Xg4rXXa4sZZT_011237.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1aM14Xg4rXXa4sZZT_011237.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1aM14Xg4rXXa4sZZT_011237.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1aM14Xg4rXXa4sZZT_011237.jpg\";s:7:\"num_iid\";s:11:\"10301910667\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIA9TRTKNWRPqCED4dPbxXazhY80uC%2BWg0krd3wNn%2FuUsA4CqUwylFlmvvcygxUc1AQBipuhM5mjBLTpcOkZitB2jYIa1S5ll1zgEjDqIQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=bJVef9bt\";s:4:\"gurl\";s:8:\"bJVef9bt\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:81:\"Rme女装2012夏装新品宽松显瘦休闲褶皱短裤裙裤 短裙裤 送腰带\";s:5:\"price\";s:6:\"148.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:31:\",450131695,446796838,451616384,\";s:3:\"cid\";s:6:\"162202\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"9.62\";s:15:\"commission_rate\";s:2:\"13\";}','','0','148','12','1','0','0','bJVef9bt','a:1:{i:0;s:6:\"衣服\";}','短裤/热裤');
INSERT INTO ts_weibo VALUES ('1762','2','飞彩可移除墙贴 天使的守护 婚房布置 卧室床头背景墙贴温馨浪漫','1334036241','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qxuVXnpeXXbdk8w4_053712.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qxuVXnpeXXbdk8w4_053712.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qxuVXnpeXXbdk8w4_053712.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qxuVXnpeXXbdk8w4_053712.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qxuVXnpeXXbdk8w4_053712.jpg\";s:7:\"num_iid\";s:11:\"15249504102\";s:8:\"goodsurl\";s:206:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWchI5%2FXYbTbq3LjEYESEdjVihyFCFZeVKbKIxoOxx3nrWPlib%2F9melXLYEu%2BXIRR7hp7kFDt87suZfIhTOqavuv8%2F4hpGi4MLiHo3ozg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=VaCtZ9s0\";s:4:\"gurl\";s:8:\"VaCtZ9s0\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:87:\"飞彩可移除墙贴 天使的守护 婚房布置 卧室床头背景墙贴温馨浪漫\";s:5:\"price\";s:5:\"38.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",188710495,435740161,325982980,155159109,148332166,\";s:3:\"cid\";s:8:\"50011738\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.09\";s:15:\"commission_rate\";s:2:\"11\";}','','0','38','188','1','0','0','VaCtZ9s0','a:1:{i:0;s:6:\"家居\";}','墙贴');
INSERT INTO ts_weibo VALUES ('1763','2','快捷特惠郁金香可移除墙贴纸客厅卧室电视背景墙婚房墙壁墙面装饰','1334036402','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1oJ55Xg0jXXcztdoW_023115.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1oJ55Xg0jXXcztdoW_023115.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1oJ55Xg0jXXcztdoW_023115.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1oJ55Xg0jXXcztdoW_023115.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1oJ55Xg0jXXcztdoW_023115.jpg\";s:7:\"num_iid\";s:11:\"12567321075\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKm01jOfXbiQJr3liHFrgZdsA1TQnl6UkgLKiKqXBJFsSqXLrBvaWrRFbMo6Oqn%2Fnfe6RCzw%2FXv2aONRHk9RVulsyQdgXdusYb6BHxJ0Q%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=BUI0o4l7\";s:4:\"gurl\";s:8:\"BUI0o4l7\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:90:\"快捷特惠郁金香可移除墙贴纸客厅卧室电视背景墙婚房墙壁墙面装饰\";s:5:\"price\";s:5:\"19.80\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",330256184,325982980,358785613,278376933,155159109,155159108,\";s:3:\"cid\";s:8:\"50011738\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"1.385\";s:15:\"commission_rate\";s:2:\"14\";}','','0','20','188','0','0','0','BUI0o4l7','a:1:{i:0;s:6:\"家居\";}','墙贴');
INSERT INTO ts_weibo VALUES ('1764','2','客厅可移除墙贴 腰线脚踏线装饰贴','1334036531','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yd1PXlXgXXcs_97W_024643.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yd1PXlXgXXcs_97W_024643.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yd1PXlXgXXcs_97W_024643.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yd1PXlXgXXcs_97W_024643.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1yd1PXlXgXXcs_97W_024643.jpg\";s:7:\"num_iid\";s:11:\"14344453000\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQ2SXFBexD%2FodLUuQFawRHPKvdZAdI1uWnAwm5iXQUw3mgx5KVvL1HrvxclbAniIX2p9wJlWZVJLvKCpyOjshygU5JYqc7uADxn7ez8EA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=S72jqtkO\";s:4:\"gurl\";s:8:\"S72jqtkO\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:82:\"【一淘专享价】[栅栏]客厅可移除墙贴 腰线脚踏线装饰贴 包邮\";s:5:\"price\";s:5:\"82.80\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",257170538,168710759,413937039,168710762,168710760,168710767,\";s:3:\"cid\";s:8:\"50011738\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"12.42\";s:15:\"commission_rate\";s:2:\"30\";}','','0','83','188','0','0','0','S72jqtkO','a:1:{i:0;s:6:\"家居\";}','墙贴');
INSERT INTO ts_weibo VALUES ('1765','2','[梦想花园]田园客厅电视沙发背景墙贴画壁画 可贴3M宽','1334036700','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T19TCOXbpvXXa5.GQY_025426.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T19TCOXbpvXXa5.GQY_025426.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T19TCOXbpvXXa5.GQY_025426.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T19TCOXbpvXXa5.GQY_025426.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T19TCOXbpvXXa5.GQY_025426.jpg\";s:7:\"num_iid\";s:10:\"9545324252\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPx3Te6yyAP4AnfUBXnd7mtbbrWOcX8hrcaFTAm9KDlw6N%2FGuNlBRMxtSxD%2B4gj3u9ji%2BkCiS16mO6P3KB5ohlB7QXMpQM9Vmuw1LmGT&amp;p=mm_18680880_0_0&amp;n=19&amp;u=RxKA3iUk\";s:4:\"gurl\";s:8:\"RxKA3iUk\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"【柠檬树】[梦想花园]田园客厅电视沙发背景墙贴画壁画 可贴3M宽\";s:5:\"price\";s:5:\"97.65\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:91:\",257170538,168710771,168710759,168710772,397138517,238675065,168710760,168710767,245300029,\";s:3:\"cid\";s:8:\"50011738\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"14.65\";s:15:\"commission_rate\";s:2:\"30\";}','','0','98','188','1','0','0','RxKA3iUk','a:1:{i:0;s:6:\"家居\";}','墙贴');
INSERT INTO ts_weibo VALUES ('1766','2','绿泡泡可移除大型墙贴客厅卧室电视沙发背景包邮 情侣树','1334036749','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1lSSrXgpTXXaxAR7U_015640.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1lSSrXgpTXXaxAR7U_015640.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1lSSrXgpTXXaxAR7U_015640.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1lSSrXgpTXXaxAR7U_015640.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1lSSrXgpTXXaxAR7U_015640.jpg\";s:7:\"num_iid\";s:11:\"12876818541\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKrMQeTFHWsOvmtVNFE7%2BhvDbV20Ip%2Fz4XhqlgSS%2FtjH5dKebYXedd6Zc3bBFaagR7IGu8%2FmflQJNF7keYU2MwMXIRDBTn9GY1%2BDk0rYw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=1CME3RYt\";s:4:\"gurl\";s:8:\"1CME3RYt\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:76:\"绿泡泡可移除大型墙贴客厅卧室电视沙发背景包邮 情侣树\";s:5:\"price\";s:5:\"68.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:91:\",368281780,368281779,368281001,444535877,367929670,378615872,367929669,415738245,368280806,\";s:3:\"cid\";s:8:\"50011738\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"3.4\";s:15:\"commission_rate\";s:2:\"10\";}','','0','68','188','1','0','0','1CME3RYt','a:1:{i:0;s:6:\"家居\";}','墙贴');
INSERT INTO ts_weibo VALUES ('1767','2','墙贴儿童房包邮 男孩女孩学校教室布置卡通装饰墙贴画 动物长颈鹿','1334036769','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1YfSmXnJlXXayxRfX_115857.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1YfSmXnJlXXayxRfX_115857.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1YfSmXnJlXXayxRfX_115857.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1YfSmXnJlXXayxRfX_115857.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1YfSmXnJlXXayxRfX_115857.jpg\";s:7:\"num_iid\";s:10:\"8666051852\";s:8:\"goodsurl\";s:192:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZTlSFI74ZfhJd17mG0Ujh1KAc8UYO4CLrZh2Pa0f7g18Ic%2F7NV8ne798WyvXSNrDgMqwmXVlrPQKerS1CPdG8HUBbrkAfJtPZ2I8fJBU&amp;p=mm_18680880_0_0&amp;n=19&amp;u=OsEAebOs\";s:4:\"gurl\";s:8:\"OsEAebOs\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:89:\"墙贴儿童房包邮 男孩女孩学校教室布置卡通装饰墙贴画 动物长颈鹿\";s:5:\"price\";s:5:\"17.60\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",440129301,298164597,224500562,336200626,\";s:3:\"cid\";s:8:\"50011738\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"2.64\";s:15:\"commission_rate\";s:2:\"30\";}','','0','18','188','0','0','0','OsEAebOs','a:1:{i:0;s:6:\"家居\";}','墙贴');
INSERT INTO ts_weibo VALUES ('1768','1','细碎但却清晰明朗的印花图案是今年春夏印花流行标准，明朗的图案映衬爽朗的个性，人与衣配合默契。沉稳的配色，甜美的荷叶袖，二者搭配成熟又不显老气，甜美又不至于甜腻。','1334036896','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1cY1UXfxtXXb1ecw8_100013.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1cY1UXfxtXXb1ecw8_100013.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1cY1UXfxtXXb1ecw8_100013.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1cY1UXfxtXXb1ecw8_100013.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1cY1UXfxtXXb1ecw8_100013.jpg\";s:7:\"num_iid\";s:11:\"14521203655\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIQwasLBFNbe2kDTQaOVn1GKs68sXbY8%2FGWgb0TdFfMHW5kxa5MsxqGTB9RX4kUAEgDF9QWPPZnTbL97IcvFEVbtpNV%2BsdC2ruYPyqDrvA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=jdSgvff8\";s:4:\"gurl\";s:8:\"jdSgvff8\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:81:\"【一淘专享价】茵佳妮女装前卫时尚款优雅荷叶袖短裤连体裤\";s:5:\"price\";s:6:\"339.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",472389845,440341070,\";s:3:\"cid\";s:6:\"162202\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"11.02\";s:15:\"commission_rate\";s:3:\"6.5\";}','','0','339','12','1','0','0','jdSgvff8','a:1:{i:0;s:6:\"衣服\";}','短裤/热裤');
INSERT INTO ts_weibo VALUES ('1769','1','极具工作气息的西装裤型早已悄然潜入时尚潮流中，成为美腿必备裤型中不可缺少的一员。笔挺的裤型垂直而下，将弯曲的腿形包覆得笔直，掩盖肥硕的大腿和粗壮的小腿，登上秀气的高跟鞋，美腿效果所见即所得。','1334037868','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qIyRXdxfXXXD2XIW_022341.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qIyRXdxfXXXD2XIW_022341.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qIyRXdxfXXXD2XIW_022341.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qIyRXdxfXXXD2XIW_022341.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1qIyRXdxfXXXD2XIW_022341.jpg\";s:7:\"num_iid\";s:11:\"13792433416\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOR8XH0uuY5s5ftkZFtvBSZ37duIHBQm9C0jlnORRwD3RXaNr1QATgfHUS0%2FkxWUM0PboyVBAesgMdvQ5w%2FnAUZW7gOgItVkmNJRuHU&amp;p=mm_18680880_0_0&amp;n=19&amp;u=RzRqZb5N\";s:4:\"gurl\";s:8:\"RzRqZb5N\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:83:\"O.SA2012春装新款女装新品韩版修身小脚铅笔裤休闲裤长裤子K23019\";s:5:\"price\";s:6:\"188.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",457740527,457740528,450274593,457740529,450276660,\";s:3:\"cid\";s:6:\"162201\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"7.05\";s:15:\"commission_rate\";s:3:\"7.5\";}','','0','188','12','0','0','0','RzRqZb5N','a:1:{i:0;s:6:\"家居\";}','休闲长裤');
INSERT INTO ts_weibo VALUES ('1770','2','#防晒美白速成大法#夏天的空调房里一定要有这只可爱的粉兔子，给肌肤补足水份。','1334038025','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CoGGXnVjXXXke86b_125142.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CoGGXnVjXXXke86b_125142.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CoGGXnVjXXXke86b_125142.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CoGGXnVjXXXke86b_125142.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1CoGGXnVjXXXke86b_125142.jpg\";s:7:\"num_iid\";s:11:\"13472174910\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOSI%2BJuvN5rm7wNInWSB9BvVuk5MhPQzS16jRLEE6CLHB3H%2Fg%2F%2BgnUhhDhBDoNwbsIq0m4DxELhvZ%2BlLofyxGDwPidIg76Rjyr8Rq8WSA%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=mHMoD292\";s:4:\"gurl\";s:8:\"mHMoD292\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:87:\"现货~韩国正品~粉嫩可爱小兔子迷你桌面加湿器/办公室必备加湿器\";s:5:\"price\";s:6:\"240.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",394468154,\";s:3:\"cid\";s:6:\"350407\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:209;s:10:\"commission\";s:3:\"1.8\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','240','287','0','0','0','mHMoD292','a:1:{i:0;s:6:\"美妆\";}','加湿器');
INSERT INTO ts_weibo VALUES ('1771','2','#防晒美白速成大法#网络上非常火的一款防晒乳液，成分安全，宝宝也可以用。','1334039648','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img06.taobaocdn.com/bao/uploaded/i6/T16251XdBtXXXDQTI._113539.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img06.taobaocdn.com/bao/uploaded/i6/T16251XdBtXXXDQTI._113539.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img06.taobaocdn.com/bao/uploaded/i6/T16251XdBtXXXDQTI._113539.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img06.taobaocdn.com/bao/uploaded/i6/T16251XdBtXXXDQTI._113539.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img06.taobaocdn.com/bao/uploaded/i6/T16251XdBtXXXDQTI._113539.jpg\";s:7:\"num_iid\";s:10:\"5486426934\";s:8:\"goodsurl\";s:45:\"http://item.taobao.com/item.htm?id=5486426934\";s:4:\"gurl\";s:8:\"CWpJmycH\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:65:\"大人小孩都能用 水宝宝水嫩防晒乳液 霜 SPF50 118ml\";s:5:\"price\";s:5:\"59.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:49:\",39129878,93794337,238998981,238998979,238998978,\";s:3:\"cid\";s:8:\"50011982\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','59','287','0','0','0','CWpJmycH','a:1:{i:0;s:6:\"美妆\";}','防晒');
INSERT INTO ts_weibo VALUES ('1772','2','#春“妆”上市#Dolly Wink，顾名思义，指的就是像娃娃般的可爱眨眼。追求无辜大眼与甜美风格又兼具女人魅力的女孩儿最适合这款Dolly Wink的假睫毛。','1334039325','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1EV5sXo0pXXb575s9_103713.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1EV5sXo0pXXb575s9_103713.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1EV5sXo0pXXb575s9_103713.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1EV5sXo0pXXb575s9_103713.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1EV5sXo0pXXb575s9_103713.jpg\";s:7:\"num_iid\";s:10:\"9141536007\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZPhbv1jFodeGsk%2FPMGAZhGvLtId0B3TLTvx4tZwgq5Y3Nb5fVMZscEZFLX9Ly2Thh%2BUWg2%2FKFRNAyOVG67K%2FomFIPf3OxjbZWnuBZTGM&amp;p=mm_18680880_0_0&amp;n=19&amp;u=uVTTidAw\";s:4:\"gurl\";s:8:\"uVTTidAw\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:78:\"【限时打折】日本正品Koji蔻吉益若翼次酱DOLLY WINK假睫毛1号\";s:5:\"price\";s:5:\"85.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",282835166,327837632,326790568,293736150,\";s:3:\"cid\";s:8:\"50019254\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"0.64\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','85','287','0','1','0','uVTTidAw','a:1:{i:0;s:6:\"美妆\";}','假睫毛/假睫毛工具');
INSERT INTO ts_weibo VALUES ('1773','2','#春“妆”上市#独特的三角型设计能够贴心的照顾到每个面部细节，比如圆形绒面无法达到的鼻翼，眼睑，鬓角等。非常的人性化。面料采用的进口短毛天丝绒，抓粉和舒适度在粉扑里都是非常出色的品质。','1334039497','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T17UxVXbJzXXaDRVZ__104948.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T17UxVXbJzXXaDRVZ__104948.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T17UxVXbJzXXaDRVZ__104948.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T17UxVXbJzXXaDRVZ__104948.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T17UxVXbJzXXaDRVZ__104948.jpg\";s:7:\"num_iid\";s:10:\"8930119388\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZTY38crLWQIKub0piYJmzs1N%2F05k6TD227yZx9BFfS7W9DiaDwDuEWhHgJIwgbjwZJElweQxB1ISB8JDzK2p0YJ9FB9BTB9UcK%2FWQac%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=BZR1HjXr\";s:4:\"gurl\";s:8:\"BZR1HjXr\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:79:\"化妆刷彩妆专卖 正品cerro qreen新品天丝绒纯棉三角粉扑 浅粉\";s:5:\"price\";s:4:\"9.90\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",104970927,299112013,\";s:3:\"cid\";s:8:\"50010817\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"0.075\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','10','287','0','0','0','BZR1HjXr','a:1:{i:0;s:6:\"美妆\";}','化妆/美容工具');
INSERT INTO ts_weibo VALUES ('1774','2','#春“妆”上市#做工考究，外形精美，手感舒适，轻轻一夹就让睫毛自然卷翘哦！','1334039543','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dC5tXchpXXXEh_71_042522.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dC5tXchpXXXEh_71_042522.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dC5tXchpXXXEh_71_042522.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dC5tXchpXXXEh_71_042522.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1dC5tXchpXXXEh_71_042522.jpg\";s:7:\"num_iid\";s:11:\"12947522716\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq9nzYH2uRKI7zP6HJUb%2F9%2FmA%2FKNJpJxZrQAExC0tkho27U%2BUMxuDYxnHIWOUPT2%2FVPTmFSmGXcTck83MquiBq75wQBt9DtTYciHNJPg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=B04dryQV\";s:4:\"gurl\";s:8:\"B04dryQV\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:47:\"Etudehouse爱丽小屋公主睫毛夹(粉色）\";s:5:\"price\";s:5:\"15.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",259269093,461733474,\";s:3:\"cid\";s:8:\"50010817\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:209;s:10:\"commission\";s:5:\"0.375\";s:15:\"commission_rate\";s:1:\"5\";}','','0','15','287','0','1','0','B04dryQV','a:1:{i:0;s:6:\"美妆\";}','化妆/美容工具');
INSERT INTO ts_weibo VALUES ('1775','2','#春“妆”上市#全新密黑膏体，丝滑细腻，让睫毛瞬间浓密。高弹性胶刷，柔软接触睫毛，不留缝隙，持久速干配方，方便上妆，不易纠结，不易晕染。特别适合睫毛短小女性。','1334039610','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kDu5XdVaXXcKgX7Z_030952.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kDu5XdVaXXcKgX7Z_030952.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kDu5XdVaXXcKgX7Z_030952.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kDu5XdVaXXcKgX7Z_030952.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1kDu5XdVaXXcKgX7Z_030952.jpg\";s:7:\"num_iid\";s:10:\"9633522402\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTZP8BhH7FkTWl91vhkLq4rnZmYjVLkuE3Vye8KZU%2BKFSHa8rkAG1hOxN04Y5Ka%2F8NgJt1%2FGRwmRDTVZxyS0duxA9qmcRXPgMWHrwdNoPU&amp;p=mm_18680880_0_0&amp;n=19&amp;u=QlaJk8C6\";s:4:\"gurl\";s:8:\"QlaJk8C6\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:78:\"包邮！最新上市 火烈鸟极瞬浓密睫毛膏 不易晕染 官方授权\";s:5:\"price\";s:5:\"25.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:41:\",295368396,424760426,295850192,295368394,\";s:3:\"cid\";s:8:\"50010794\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"0.375\";s:15:\"commission_rate\";s:1:\"3\";}','','0','25','287','0','0','0','QlaJk8C6','a:1:{i:0;s:6:\"美妆\";}','睫毛膏/睫毛增长液');
INSERT INTO ts_weibo VALUES ('1776','2','#春“妆”上市#色感透亮，附着力强，呈现持久的眼妆，双重复合粉的特殊配方，让粉末粘附在眼部时不会感到厚重，效果舒适持久。 有不同的色调可供选择，多种颜色反搭配在一起，使用方便，更能画出你想要的效果。','1334039744','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GbXuXg4CXXa5W.o1_042553.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GbXuXg4CXXa5W.o1_042553.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GbXuXg4CXXa5W.o1_042553.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GbXuXg4CXXa5W.o1_042553.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1GbXuXg4CXXa5W.o1_042553.jpg\";s:7:\"num_iid\";s:10:\"1733952880\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIcZFyuOUoxVhAUGpyjXfKJV7s0KKFBnaVOSDmoTEv87vQos0lxYE5NhYRLtVwYCU9QQBJUA8tb%2BiaTyXPn%2BXkibsl6m%2BlKhFOsGCPU%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=eY0duMWv\";s:4:\"gurl\";s:8:\"eY0duMWv\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:68:\"专柜正品韩国Etude house爱丽小屋水蜜桃润彩四色眼影\";s:5:\"price\";s:5:\"75.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:0:\"\";s:3:\"cid\";s:8:\"50010796\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:208;s:10:\"commission\";s:4:\"3.75\";s:15:\"commission_rate\";s:2:\"10\";}','','0','75','287','1','1','0','eY0duMWv','a:1:{i:0;s:6:\"美妆\";}','眼影');
INSERT INTO ts_weibo VALUES ('1777','2','#防晒美白速成大法#missha/谜尚/迷尚 红bb霜50ml 隔离防晒裸妆遮瑕强','1334039935','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1_.m7XcxgXXb6RVo6_060435.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1_.m7XcxgXXb6RVo6_060435.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1_.m7XcxgXXb6RVo6_060435.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1_.m7XcxgXXb6RVo6_060435.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1_.m7XcxgXXb6RVo6_060435.jpg\";s:7:\"num_iid\";s:10:\"3362046923\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbjOlkQXGhvM3aCfglBfrQ%2FwHo%2BaxkK8lGfT1qu%2Fod98YxIxtnXpt%2BY2xJAisTIX8AcVxszVmAEW%2FvKk75qThrnclmXqwTqIdbRT9otRM&amp;p=mm_18680880_0_0&amp;n=19&amp;u=rEv5YULV\";s:4:\"gurl\";s:8:\"rEv5YULV\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"包邮missha/谜尚/迷尚 红bb霜50ml 隔离防晒裸妆遮瑕强 专柜正品\";s:5:\"price\";s:6:\"168.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:81:\",136025953,186523987,429248080,427427623,136026819,429248082,281409939,171574943,\";s:3:\"cid\";s:8:\"50013794\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"6.3\";s:15:\"commission_rate\";s:3:\"7.5\";}','','0','168','287','1','1','0','rEv5YULV','a:1:{i:0;s:6:\"美妆\";}','BB霜');
INSERT INTO ts_weibo VALUES ('1778','2','#防晒美白速成大法#日系美伞w.p.c抽象小樱桃苹果纯色伞长柄伞 公主伞 晴雨伞 防晒伞 很日本风，很可爱，很洋气','1334040021','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1fJurXf43XXXR9kE._113151.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1fJurXf43XXXR9kE._113151.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1fJurXf43XXXR9kE._113151.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1fJurXf43XXXR9kE._113151.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1fJurXf43XXXR9kE._113151.jpg\";s:7:\"num_iid\";s:10:\"7398453185\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTarItelTUd9kth%2F0pcBRUs4QkrqT7J1m3m4PIRly%2B29Dz3%2FuVil9S1beMMTG52XgrY9gqwYXvSoAUQVFZWSyxlD6gDHViB64M9U%2BuDFI%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=9ammviag\";s:4:\"gurl\";s:8:\"9ammviag\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"日系美伞w.p.c抽象小樱桃苹果纯色伞长柄伞 公主伞 晴雨伞 防晒伞\";s:5:\"price\";s:5:\"48.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",313990226,472012317,\";s:3:\"cid\";s:6:\"210211\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"2.4\";s:15:\"commission_rate\";s:2:\"10\";}','','0','48','6','1','0','0','9ammviag','a:1:{i:0;s:6:\"家居\";}','伞');
INSERT INTO ts_weibo VALUES ('1779','1','#防晒美白速成大法#英伦风的小礼帽，成熟优雅，宛如电影里走出来的英伦仕女。','1334040129','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DsKWXXlhXXcWE3wT_012006.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DsKWXXlhXXcWE3wT_012006.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DsKWXXlhXXcWE3wT_012006.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DsKWXXlhXXcWE3wT_012006.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1DsKWXXlhXXcWE3wT_012006.jpg\";s:7:\"num_iid\";s:11:\"12640517277\";s:8:\"goodsurl\";s:194:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKlPmmZtCotZfP42oGgvNmL66PkhzLaOuq%2BgwSGHM5WHDt2bcvPuvWuKiXhATZzdR3rl2TVzEnFk5M2e9DPPZ9oJM3e7J7J%2FJjNRsxA&amp;p=mm_18680880_0_0&amp;n=19&amp;u=C1SUwCVd\";s:4:\"gurl\";s:8:\"C1SUwCVd\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:78:\"圆顶卷边羊毛呢小礼帽子一等品织带缎带高品质与欧洲同步\";s:5:\"price\";s:5:\"59.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:21:\",445012162,401624832,\";s:3:\"cid\";s:6:\"302910\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:317;s:10:\"commission\";s:5:\"0.445\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','59','13','0','0','0','C1SUwCVd','a:1:{i:0;s:6:\"配饰\";}','帽子');
INSERT INTO ts_weibo VALUES ('1780','1','#防晒美白速成大法#特仑苏有机纯牛奶制作的手工沐浴皂，让肌肤重新白起来。','1334040201','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1EWi4Xd8tXXavT_Q._113553.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1EWi4Xd8tXXavT_Q._113553.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1EWi4Xd8tXXavT_Q._113553.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1EWi4Xd8tXXavT_Q._113553.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1EWi4Xd8tXXavT_Q._113553.jpg\";s:7:\"num_iid\";s:10:\"1612165905\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIbjvpaxc0OCX3qKDg74zx63W56ultG9K%2BlPzceo%2BE8uzvX90FyNpZtJxSJN9JpOQwuY0lz6%2BPtwzyx5XJWPWAOun7uuJvjUYHUht7Y%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=bVq3U6Nj\";s:4:\"gurl\";s:8:\"bVq3U6Nj\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:77:\"『兔白皂坊』牛奶薏仁沐浴皂￠美白保湿￡ 手工皂 冷制皂\";s:5:\"price\";s:5:\"15.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:79:\",61246443,61246627,355879782,355879783,355879784,355879785,355879787,355879789,\";s:3:\"cid\";s:8:\"50012004\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:5:\"0.115\";s:15:\"commission_rate\";s:3:\"1.5\";}','','0','15','13','0','0','0','bVq3U6Nj','a:1:{i:0;s:6:\"美妆\";}','手工皂/精油皂');
INSERT INTO ts_weibo VALUES ('1781','2','#防晒美白速成大法#用处多多，补水、防辐射，还可以修复晒后引起的红肿。','1334040268','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1KqyKXmlrXXX3whLb_124310.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1KqyKXmlrXXX3whLb_124310.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1KqyKXmlrXXX3whLb_124310.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1KqyKXmlrXXX3whLb_124310.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1KqyKXmlrXXX3whLb_124310.jpg\";s:7:\"num_iid\";s:11:\"12919815238\";s:8:\"goodsurl\";s:200:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKq884NQu7Q2gEBeNNydrWyldMuSz9WP1XA%2FhMWlXVnHj2fVu3KADt5vPlLmRCgVJOXDBgswXmXVMlI58zL2NQfnZvZPCEewNNOC2EyNg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=cLkBgurX\";s:4:\"gurl\";s:8:\"cLkBgurX\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:68:\"芦荟胶 补水保湿 晒后修复 超灵去红消肿  嫩肤 30Ｇ\";s:5:\"price\";s:5:\"86.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",467907812,\";s:3:\"cid\";s:8:\"50011980\";s:6:\"mwidth\";i:203;s:7:\"mheight\";i:306;s:10:\"commission\";s:4:\"2.15\";s:15:\"commission_rate\";s:1:\"5\";}','','0','86','287','1','0','0','cLkBgurX','a:1:{i:0;s:6:\"美妆\";}','乳液/面霜');
INSERT INTO ts_weibo VALUES ('1782','1','#防晒美白速成大法#镂空编织花纹，非常精致可爱，特别适合春夏的长裙，海风沙滩别有风韵。','1334040343','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1T51PXfpuXXXU8Nc0_035416.jpg\";s:7:\"num_iid\";s:11:\"15397836487\";s:8:\"goodsurl\";s:196:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIWdH0Powp2G7D90EzR0sQtg397kN1w6SclPnRzOVF1PkOMRdV4iRZjYyHfY1ado%2BtAV%2F0KJjKQj%2FfpuXQr4nhdMyaerOSdHEsEWSk05&amp;p=mm_18680880_0_0&amp;n=19&amp;u=BHv3yJRU\";s:4:\"gurl\";s:8:\"BHv3yJRU\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:90:\"呛口小辣椒女草帽韩版遮阳帽太阳帽沙滩帽女士帽子夏天牛仔帽夏季\";s:5:\"price\";s:5:\"79.90\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:51:\",397205905,444993462,203588876,175350757,101783731,\";s:3:\"cid\";s:6:\"302910\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:3:\"1.4\";s:15:\"commission_rate\";s:3:\"3.5\";}','','0','80','13','1','0','0','BHv3yJRU','a:1:{i:0;s:6:\"配饰\";}','帽子');
INSERT INTO ts_weibo VALUES ('1783','2','#防晒美白速成大法#非常补水的一款面膜，修复晒后红肿的皮肤，成份非常安全哦。','1334040373','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1kJmjXftuXXcbPYw4_051833.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1kJmjXftuXXcbPYw4_051833.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1kJmjXftuXXcbPYw4_051833.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1kJmjXftuXXcbPYw4_051833.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1kJmjXftuXXcbPYw4_051833.jpg\";s:7:\"num_iid\";s:11:\"12313096660\";s:8:\"goodsurl\";s:208:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKgcF5f%2F3B5jUqvNz5qooiU1SSgrlzETHQBV%2F%2FtBOV8kupWqhhV9YqcMHpW17PkhIa0hMjXivcCyUk5FMta%2FGPZq6HY%2BbaLXGvCO1SPkg%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=8H27q7Wt\";s:4:\"gurl\";s:8:\"8H27q7Wt\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:78:\"【蘭】拳头产品！补水法兰西进口粉玫瑰面膜冻晒后修复美\";s:5:\"price\";s:5:\"55.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",416486646,\";s:3:\"cid\";s:8:\"50011981\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:317;s:10:\"commission\";s:5:\"1.375\";s:15:\"commission_rate\";s:1:\"5\";}','','0','55','287','1','0','0','8H27q7Wt','a:1:{i:0;s:6:\"美妆\";}','面膜/面膜粉');
INSERT INTO ts_weibo VALUES ('1784','2','#春“妆”上市#珠光粒子很细，刷上显得很有光泽~','1334040514','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T12eOPXgXqXXaQ0wnb_094127.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T12eOPXgXqXXaQ0wnb_094127.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T12eOPXgXqXXaQ0wnb_094127.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T12eOPXgXqXXaQ0wnb_094127.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T12eOPXgXqXXaQ0wnb_094127.jpg\";s:7:\"num_iid\";s:10:\"1744981794\";s:8:\"goodsurl\";s:45:\"http://item.taobao.com/item.htm?id=1744981794\";s:4:\"gurl\";s:8:\"KGi99s61\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:87:\"现货日本大创 珠光4色眼影烟熏大地色棕色新手适合练习必备 正品\";s:5:\"price\";s:5:\"19.80\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:31:\",302962441,336245618,441705653,\";s:3:\"cid\";s:8:\"50010796\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','20','287','0','0','0','KGi99s61','a:1:{i:0;s:6:\"美妆\";}','眼影');
INSERT INTO ts_weibo VALUES ('1785','2','#春“妆”上市#防水防晕染抗汗 5色可选，这款眼线胶笔是10秒速干型，涂好后略等10秒再去眨眼，这样效果才好哈！','1334040668','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1qx8_Xe4FXXcSW5k2_044427.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1qx8_Xe4FXXcSW5k2_044427.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1qx8_Xe4FXXcSW5k2_044427.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1qx8_Xe4FXXcSW5k2_044427.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img04.taobaocdn.com/bao/uploaded/i4/T1qx8_Xe4FXXcSW5k2_044427.jpg\";s:7:\"num_iid\";s:11:\"12638875242\";s:8:\"goodsurl\";s:210:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIKlOYH%2BJ5k4UPpJ9vR%2Fnbpn9s4f7LJd5ewTJf1O4jo%2BpMbjM1%2BPFUWf9Ak2515Wj2Wil68%2BQwcVEnO87R928IbIgrhP5Hdvf%2FDk9UjxOw%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=8wrWWNCD\";s:4:\"gurl\";s:8:\"8wrWWNCD\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"ELELES台湾直送 防水防晕染抗汗 眼线胶笔 5色选 黑/紫/白/咖啡\";s:5:\"price\";s:5:\"29.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:10:\",96727351,\";s:3:\"cid\";s:8:\"50010797\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:169;s:10:\"commission\";s:5:\"0.435\";s:15:\"commission_rate\";s:1:\"3\";}','','0','29','287','1','0','0','8wrWWNCD','a:1:{i:0;s:6:\"美妆\";}','眼线');
INSERT INTO ts_weibo VALUES ('1786','2','#春“妆”上市#自然适度遮瑕，打造完美底妆，修饰肌肤纹理，服帖触感，长时间也不会感到粘腻不适。','1334040736','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1mISSXohbXXbTJ_s._113520.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1mISSXohbXXbTJ_s._113520.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1mISSXohbXXbTJ_s._113520.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1mISSXohbXXbTJ_s._113520.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1mISSXohbXXbTJ_s._113520.jpg\";s:7:\"num_iid\";s:11:\"13996183442\";s:8:\"goodsurl\";s:210:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOf81UNaHWRpEYTD%2FE28RcfhRFF0Ur3ts%2FnX7Fca9bpSouy%2FENppsePGfKDTx%2BYHIzo9kO3dxpoZRul7kG5za93IsiU%2FqsldB%2FpvoB18w%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=0QccldRs\";s:4:\"gurl\";s:8:\"0QccldRs\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:80:\"英国玻儿彩妆 popular 我爱矿物粉底（保湿型）30ml 轻薄不脱妆\";s:5:\"price\";s:5:\"86.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:11:\",433594209,\";s:3:\"cid\";s:8:\"50010789\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"1.29\";s:15:\"commission_rate\";s:1:\"3\";}','','0','86','287','0','0','0','0QccldRs','a:1:{i:0;s:6:\"美妆\";}','粉底液/膏');
INSERT INTO ts_weibo VALUES ('1797','1','不宜放进冰箱的15种食物：1．香蕉；2．鲜荔枝；3．黄瓜；4．西红柿；5．面包；6．青椒；7．火腿；8．巧克力；9．叶子菜；10中药；11吃剩的月饼；12鱼不宜久存；13．解冻后的冷冻食品；14．茄子；15．南瓜。','1334051503','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0410/17/24819fd6112579b32648911cea948677_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0410/17/24819fd6112579b32648911cea948677_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0410/17/24819fd6112579b32648911cea948677_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0410/17/24819fd6112579b32648911cea948677.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:190;}','','0','0','25','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1798','1','富士山的早晨','1334057974','0','0','0','0','1','a:6:{s:8:\"thumburl\";s:56:\"2012/0410/19/74d74660302a0da556784a0b467aae93_small.jpeg\";s:14:\"thumbhaibaourl\";s:57:\"2012/0410/19/74d74660302a0da556784a0b467aae93_haibao.jpeg\";s:14:\"thumbmiddleurl\";s:57:\"2012/0410/19/74d74660302a0da556784a0b467aae93_middle.jpeg\";s:6:\"picurl\";s:50:\"2012/0410/19/74d74660302a0da556784a0b467aae93.jpeg\";s:6:\"mwidth\";i:200;s:7:\"mheight\";i:299;}','','0','0','285','0','0','0','','','');
INSERT INTO ts_weibo VALUES ('1800','1','帕芙兰镇店抢 小胸购 中厚 按摩文胸 聚拢侧收美背调整型内衣','1334060173','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1JFasXhdJXXcVvCM__080501.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1JFasXhdJXXcVvCM__080501.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1JFasXhdJXXcVvCM__080501.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1JFasXhdJXXcVvCM__080501.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img02.taobaocdn.com/bao/uploaded/i2/T1JFasXhdJXXcVvCM__080501.jpg\";s:7:\"num_iid\";s:10:\"4255990544\";s:8:\"goodsurl\";s:198:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTaWJb8n8S%2FwWY8NK7z27EF5nLIqDiqbV9hQyA1Is%2BfonrIfgvxSNsmhrgiLM8i3VdH%2BMyhduKva9xekv8s7AQyRR3XcT3d1Ek9QXiR%2BDh&amp;p=mm_18680880_0_0&amp;n=19&amp;u=sba2Z313\";s:4:\"gurl\";s:8:\"sba2Z313\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:86:\"帕芙兰镇店抢 小胸购 中厚 按摩文胸 聚拢侧收美背调整型内衣M028\";s:5:\"price\";s:6:\"138.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:90:\",412831348,412831334,63726824,412831335,412831329,412831331,412831346,412831340,412831336,\";s:3:\"cid\";s:8:\"50008881\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"3.45\";s:15:\"commission_rate\";s:1:\"5\";}','','0','138','154','1','1','0','sba2Z313','a:1:{i:0;s:6:\"衣服\";}','文胸');
INSERT INTO ts_weibo VALUES ('1801','1','可爱的女人爱蕾丝。她们无忧无虑，善良单纯，不喜暗淡的色彩，憧憬一切的梦幻及美好。粉嫩的小可爱在外侧大面积使用蕾丝装饰，光洁的表面即刻变得立体生动。捷克水钻在鸡心位置璀璨闪烁，用迷你蝴蝶结装饰更显甜美气息。','1334062785','0','0','0','0','5','a:16:{s:9:\"small_pic\";s:82:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SLeaXiRzXXb7dOoW_024041.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SLeaXiRzXXb7dOoW_024041.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SLeaXiRzXXb7dOoW_024041.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SLeaXiRzXXb7dOoW_024041.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img03.taobaocdn.com/bao/uploaded/i3/T1SLeaXiRzXXb7dOoW_024041.jpg\";s:7:\"num_iid\";s:10:\"6104771632\";s:8:\"goodsurl\";s:45:\"http://item.taobao.com/item.htm?id=6104771632\";s:4:\"gurl\";s:8:\"8oMUNE3g\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:84:\"【拇指斗价】依纷无痕文胸 3/4罩杯上薄下厚 蕾丝边深V聚拢文胸\";s:5:\"price\";s:5:\"79.00\";s:5:\"taoke\";s:1:\"0\";s:11:\"seller_cids\";s:61:\",360069417,262711556,262711574,262711560,262711577,265576502,\";s:3:\"cid\";s:8:\"50008881\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;}','','0','79','154','1','0','0','8oMUNE3g','a:1:{i:0;s:6:\"衣服\";}','文胸');
INSERT INTO ts_weibo VALUES ('1802','1','优雅的女人爱蕾丝。她们一颦一笑都让人牵肠挂肚，举手投举间散发着无与伦比的的美丽。精致的蕾丝与无痕塑身面料结合，营造内在花纹立体，外在不着痕迹的神奇效果。U型五排扣收紧背部赘肉，优雅女人零缺陷，它是好帮手。','1334062838','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1NQqyXoFOXXaU2k_X_085848.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1NQqyXoFOXXaU2k_X_085848.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1NQqyXoFOXXaU2k_X_085848.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1NQqyXoFOXXaU2k_X_085848.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1NQqyXoFOXXaU2k_X_085848.jpg\";s:7:\"num_iid\";s:11:\"13870436991\";s:8:\"goodsurl\";s:204:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOePUqINPsGI0%2FCyvsBM5cbnI9pyZvaYrXVE%2FPfREPY8x56Z%2Bob0P26mJJkB2sq8b78DFSOk7BD87Gvzxa5vmwlgFrBZd36ijPLbFxRgQ%3D%3D&amp;p=mm_18680880_0_0&amp;n=19&amp;u=I8xa56bu\";s:4:\"gurl\";s:8:\"I8xa56bu\";s:6:\"g_host\";s:6:\"taobao\";s:7:\"g_title\";s:75:\"嘉莉诗专柜正品3455H深V蕾丝收副乳调整型内衣五排扣文胸\";s:5:\"price\";s:6:\"168.00\";s:5:\"taoke\";s:1:\"1\";s:11:\"seller_cids\";s:61:\",227153583,203434222,227153586,203434220,203434221,227153588,\";s:3:\"cid\";s:8:\"50008881\";s:6:\"mwidth\";i:210;s:7:\"mheight\";i:210;s:10:\"commission\";s:4:\"10.5\";s:15:\"commission_rate\";s:4:\"12.5\";}','','0','168','154','1','0','0','I8xa56bu','a:1:{i:0;s:6:\"衣服\";}','文胸');
INSERT INTO ts_weibo VALUES ('1803','1','成熟的女人爱蕾丝。她们或许没有姣好的容貌，却有着经过时间沉淀而酝酿出的醇香韵味。典雅酒红最能与这种从容不迫的气质搭配，绝世独立由此而生。蕾丝的装饰不铺张蔓延，也不小气吝啬，点到为止的设计，意犹未尽。','1334062869','0','0','0','0','5','a:18:{s:9:\"small_pic\";s:82:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1DN57XcluXXXeGEk5_060311.jpg_60x60.jpg\";s:10:\"middle_pic\";s:85:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1DN57XcluXXXeGEk5_060311.jpg_210x1000.jpg\";s:7:\"big_pic\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1DN57XcluXXXeGEk5_060311.jpg_310x310.jpg\";s:6:\"picurl\";s:84:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1DN57XcluXXXeGEk5_060311.jpg_160x160.jpg\";s:11:\"originalurl\";s:72:\"http://img01.taobaocdn.com/bao/uploaded/i1/T1DN57XcluXXXeGEk5_060311.jpg\";s:7:\"num_iid\";s:11:\"13161237298\";s:8:\"goodsurl\";s:202:\"http://s.click.taobao.com/t_8?e=7HZ6jHSTbIOXvwiMDDnthB38yd1EE0azyb79wJ4T%2BG3AhGQigiFI7qAsmWkUT1W%2ByC6RNqYkN3627qDfKXpBE2odrUXqH9N07fRAg