<?php 
/**
*
* example目录下为简单的支付样例，仅能用于搭建快速体验微信支付使用
* 样例的作用仅限于指导如何使用sdk，在安全上面仅做了简单处理， 复制使用样例代码时请慎重
* 请勿直接直接使用样例对外提供服务
* 
**/
require_once "../lib/WxPay.Api.php";
require_once "WxPay.JsApiPay.php";
require_once "WxPay.Config.php";
require_once 'log.php';

//初始化日志
$logHandler= new CLogFileHandler("../logs/".date('Y-m-d').'.log');
$log = Log::Init($logHandler, 15);

//打印输出数组信息
function printf_info($data)
{
    foreach($data as $key=>$value){
        echo "<font color='#00ff55;'>$key</font> :  ".htmlspecialchars($value, ENT_QUOTES)." <br/>";
    }
}


 $order_num=$_GET['order_num'];$order_money=$_GET['order_money']*100;$open_id=$_GET['openid'];
//①、获取用户openid
try{

	$tools = new JsApiPay();
	$openId = $open_id;

	//②、统一下单
	$input = new WxPayUnifiedOrder();
    $input->SetBody($order_num);
    $input->SetAttach("test");
	$input->SetOut_trade_no($order_num);
	$input->SetTotal_fee($order_money);
	$input->SetTime_start(date("YmdHis"));
	$input->SetTime_expire(date("YmdHis", time() + 600));
	$input->SetGoods_tag("test");
	$input->SetNotify_url("http://www.wevalueweb.com/pay/weixin/example/notify.php");
	$input->SetTrade_type("JSAPI");
	$input->SetOpenid($openId);
	$config = new WxPayConfig();
	$order = WxPayApi::unifiedOrder($config, $input);
    //	printf_info($order);
	$jsApiParameters = $tools->GetJsApiParameters($order);

} catch(Exception $e) {
	Log::ERROR(json_encode($e));
}
//③、在支持成功回调通知中处理成功之后的事宜，见 notify.php
/**
 * 注意：
 * 1、当你的回调地址不可访问的时候，回调通知会失败，可以通过查询订单来确认支付是否成功
 * 2、jsapi支付时需要填入用户openid，WxPay.JsApiPay.php中有获取openid流程 （文档可以参考微信公众平台“网页授权接口”，
 * 参考http://mp.weixin.qq.com/wiki/17/c0f37d5704f0b64713d5d2c37b468d75.html）
 */
?>

<html>
<head>
    <meta http-equiv="content-type" content="text/html;charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/> 
    	<script src="../../../js/jquery-1.8.3.min.js"></script>
    <title>微信支付</title>

    <script type="text/javascript">
        //调用微信JS api 支付
        function jsApiCall()
        {
            WeixinJSBridge.invoke(
                'getBrandWCPayRequest',
                <?php echo $jsApiParameters; ?>,
                function(res){
                    WeixinJSBridge.log(res.err_msg);
                    //alert(res.err_code+res.err_desc+res.err_msg);
                }
            );
        }

        function callpay()
        {
            if (typeof WeixinJSBridge == "undefined"){
                if( document.addEventListener ){
                    document.addEventListener('WeixinJSBridgeReady', jsApiCall, false);
                }else if (document.attachEvent){
                    document.attachEvent('WeixinJSBridgeReady', jsApiCall); 
                    document.attachEvent('onWeixinJSBridgeReady', jsApiCall);
                }
            }else{
                jsApiCall();
            }
        }
    </script>

</head>
<body>
    <br/>

	<div align="center">
	
	</div>
</body>

<body style="border: 0px;padding: 0px;margin: 0px;">

    <p style="margin-top: 5px;text-align: center;font-size:25px;">	
    <button style="width:210px; height:50px; border-radius: 15px;background-color:#FE6714; border:0px #FE6714 solid; cursor: pointer;  color:white;  font-size:16px;" type="button" onclick="callpay()" >立即支付</button>
    </p>
	<div style="width: 100%;text-align: center;">
       <p> <font color="#9ACD32"><b>该笔订单支付金额为<span style="color: red;font-size:30px"><?php echo urlencode($_GET['order_money']);?></b>元</font></p><br/><br/>
  <div style="width: 100%;height: 277px;margin: auto;">
    
        <p style="margin-top: 5px;text-align: center;font-size:25px;">	
    <a href="../../../index.php">返回首页</a>
    </p>
   </div>          
     </div> 

<input type="hidden" name="out_trade_no" id="out_trade_no" value="<?php echo urlencode($order_num);?>" />
<script>
    $(function(){
       setInterval(function(){check()}, 2000);  //5秒查询一次支付是否成功
    })
    function check(){
        var url = "http://wevalueweb.com/pay/weixin/example/orderquery2.php";　　//新建
        var out_trade_no = $("#out_trade_no").val();
        var param = {'out_trade_no':out_trade_no};
        $.post(url, param, function(data){
           data = data.split("{");
            data_one=data[1];
            data_two='{'+data_one;
            data_three = JSON.parse(data_two); 
            if(data_three['trade_state'] == "SUCCESS"){
              //  alert("订单支付成功,即将跳转...");
                window.location.href = "../../../index.php?c=main&a=weixin_pay_return&order_num="+out_trade_no;
                return false;  
            }else{
              //  console.log(data_three);
            }
        });
    }
</script>

</body>
</html>